/* valacodenode.c generated by valac, the Vala compiler
 * generated from valacodenode.vala, do not modify */

/* valacodenode.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_attribute_cache_unref0(var) ((var == NULL) ? NULL : (var = (vala_attribute_cache_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ValaParamSpecCodeNode ValaParamSpecCodeNode;
typedef struct _ValaParamSpecAttributeCache ValaParamSpecAttributeCache;

struct _ValaCodeNodePrivate {
	ValaCodeNode* _parent_node;
	ValaSourceReference* _source_reference;
	gboolean _unreachable;
	gboolean _checked;
	gboolean _error;
	ValaAttributeCache** attributes_cache;
	gint attributes_cache_length1;
	gint _attributes_cache_size_;
};

struct _ValaParamSpecCodeNode {
	GParamSpec parent_instance;
};

struct _ValaParamSpecAttributeCache {
	GParamSpec parent_instance;
};

static gint ValaCodeNode_private_offset;
static gpointer vala_code_node_parent_class = NULL;
static gint vala_code_node_last_temp_nr;
static gint vala_code_node_last_temp_nr = 0;
static gint vala_code_node_next_attribute_cache_index;
static gint vala_code_node_next_attribute_cache_index = 0;
static gpointer vala_attribute_cache_parent_class = NULL;

static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_code_node_real_accept (ValaCodeNode* self,
                                 ValaCodeVisitor* visitor);
static void vala_code_node_real_accept_children (ValaCodeNode* self,
                                          ValaCodeVisitor* visitor);
static gboolean vala_code_node_real_check (ValaCodeNode* self,
                                    ValaCodeContext* context);
static void vala_code_node_real_emit (ValaCodeNode* self,
                               ValaCodeGenerator* codegen);
static void vala_code_node_real_replace_type (ValaCodeNode* self,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static void vala_code_node_real_replace_expression (ValaCodeNode* self,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node);
static ValaAttribute* vala_code_node_get_or_create_attribute (ValaCodeNode* self,
                                                       const gchar* name);
static gchar* vala_code_node_real_to_string (ValaCodeNode* self);
static void vala_code_node_real_get_defined_variables (ValaCodeNode* self,
                                                ValaCollection* collection);
static void vala_code_node_real_get_used_variables (ValaCodeNode* self,
                                             ValaCollection* collection);
static void vala_code_node_real_get_error_types (ValaCodeNode* self,
                                          ValaCollection* collection,
                                          ValaSourceReference* source_reference);
static void vala_code_node_finalize (ValaCodeNode * obj);
static GType vala_code_node_get_type_once (void);
static void vala_attribute_cache_finalize (ValaAttributeCache * obj);
static GType vala_attribute_cache_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
vala_code_node_get_instance_private (ValaCodeNode* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCodeNode_private_offset);
}

ValaCodeNode*
vala_code_node_get_parent_node (ValaCodeNode* self)
{
	ValaCodeNode* result;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_node;
	result = _tmp0_;
	return result;
}

void
vala_code_node_set_parent_node (ValaCodeNode* self,
                                ValaCodeNode* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_parent_node = value;
}

ValaSourceReference*
vala_code_node_get_source_reference (ValaCodeNode* self)
{
	ValaSourceReference* result;
	ValaSourceReference* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_reference;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}

void
vala_code_node_set_source_reference (ValaCodeNode* self,
                                     ValaSourceReference* value)
{
	ValaSourceReference* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_reference_ref0 (value);
	_vala_source_reference_unref0 (self->priv->_source_reference);
	self->priv->_source_reference = _tmp0_;
}

gboolean
vala_code_node_get_unreachable (ValaCodeNode* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_unreachable;
	return result;
}

void
vala_code_node_set_unreachable (ValaCodeNode* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_unreachable = value;
}

static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}

static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}

const gchar*
vala_code_node_get_type_name (ValaCodeNode* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_type_name (G_TYPE_FROM_INSTANCE (self));
	result = _tmp0_;
	return result;
}

gboolean
vala_code_node_get_checked (ValaCodeNode* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_checked;
	return result;
}

void
vala_code_node_set_checked (ValaCodeNode* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_checked = value;
}

gboolean
vala_code_node_get_error (ValaCodeNode* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error;
	return result;
}

void
vala_code_node_set_error (ValaCodeNode* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_error = value;
}

gboolean
vala_code_node_get_tree_can_fail (ValaCodeNode* self)
{
	gboolean result;
	ValaArrayList* error_types = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	error_types = _tmp1_;
	vala_code_node_get_error_types (self, (ValaCollection*) error_types, NULL);
	_tmp2_ = vala_collection_get_size ((ValaCollection*) error_types);
	_tmp3_ = _tmp2_;
	result = _tmp3_ > 0;
	_vala_iterable_unref0 (error_types);
	return result;
}

/**
 * Visits this code node with the specified CodeVisitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void
vala_code_node_real_accept (ValaCodeNode* self,
                            ValaCodeVisitor* visitor)
{
	g_return_if_fail (visitor != NULL);
}

void
vala_code_node_accept (ValaCodeNode* self,
                       ValaCodeVisitor* visitor)
{
	ValaCodeNodeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->accept) {
		_klass_->accept (self, visitor);
	}
}

/**
 * Visits all children of this code node with the specified CodeVisitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void
vala_code_node_real_accept_children (ValaCodeNode* self,
                                     ValaCodeVisitor* visitor)
{
	g_return_if_fail (visitor != NULL);
}

void
vala_code_node_accept_children (ValaCodeNode* self,
                                ValaCodeVisitor* visitor)
{
	ValaCodeNodeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->accept_children) {
		_klass_->accept_children (self, visitor);
	}
}

static gboolean
vala_code_node_real_check (ValaCodeNode* self,
                           ValaCodeContext* context)
{
	gboolean result;
	g_return_val_if_fail (context != NULL, FALSE);
	result = TRUE;
	return result;
}

gboolean
vala_code_node_check (ValaCodeNode* self,
                      ValaCodeContext* context)
{
	ValaCodeNodeClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->check) {
		return _klass_->check (self, context);
	}
	return FALSE;
}

static void
vala_code_node_real_emit (ValaCodeNode* self,
                          ValaCodeGenerator* codegen)
{
	g_return_if_fail (codegen != NULL);
}

void
vala_code_node_emit (ValaCodeNode* self,
                     ValaCodeGenerator* codegen)
{
	ValaCodeNodeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->emit) {
		_klass_->emit (self, codegen);
	}
}

static void
vala_code_node_real_replace_type (ValaCodeNode* self,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
}

void
vala_code_node_replace_type (ValaCodeNode* self,
                             ValaDataType* old_type,
                             ValaDataType* new_type)
{
	ValaCodeNodeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->replace_type) {
		_klass_->replace_type (self, old_type, new_type);
	}
}

static void
vala_code_node_real_replace_expression (ValaCodeNode* self,
                                        ValaExpression* old_node,
                                        ValaExpression* new_node)
{
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
}

void
vala_code_node_replace_expression (ValaCodeNode* self,
                                   ValaExpression* old_node,
                                   ValaExpression* new_node)
{
	ValaCodeNodeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->replace_expression) {
		_klass_->replace_expression (self, old_node, new_node);
	}
}

/**
 * Returns the specified attribute.
 *
 * @param name attribute name
 * @return     attribute
 */
ValaAttribute*
vala_code_node_get_attribute (ValaCodeNode* self,
                              const gchar* name)
{
	GList* _tmp0_;
	ValaAttribute* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->attributes;
	{
		GList* a_collection = NULL;
		GList* a_it = NULL;
		a_collection = _tmp0_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a = NULL;
			a = (ValaAttribute*) a_it->data;
			{
				ValaAttribute* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp1_ = a;
				_tmp2_ = vala_attribute_get_name (_tmp1_);
				_tmp3_ = _tmp2_;
				if (g_strcmp0 (_tmp3_, name) == 0) {
					ValaAttribute* _tmp4_;
					_tmp4_ = a;
					result = _tmp4_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

/**
 * Add attribute and append key/value pairs to an existing one.
 *
 * @param a  an attribute to add
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_code_node_add_attribute (ValaCodeNode* self,
                              ValaAttribute* a)
{
	ValaAttribute* old_a = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaAttribute* _tmp2_;
	ValaAttribute* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_get_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_get_attribute (self, _tmp1_);
	old_a = _tmp2_;
	_tmp3_ = old_a;
	if (_tmp3_ == NULL) {
		ValaAttribute* _tmp4_;
		_tmp4_ = _vala_code_node_ref0 (a);
		self->attributes = g_list_append (self->attributes, _tmp4_);
	} else {
		ValaMapIterator* it = NULL;
		ValaMap* _tmp5_;
		ValaMap* _tmp6_;
		ValaMapIterator* _tmp7_;
		_tmp5_ = vala_attribute_get_args (a);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_map_map_iterator (_tmp6_);
		it = _tmp7_;
		while (TRUE) {
			ValaMapIterator* _tmp8_;
			ValaAttribute* _tmp9_;
			ValaMap* _tmp10_;
			ValaMap* _tmp11_;
			ValaMapIterator* _tmp12_;
			gpointer _tmp13_;
			gchar* _tmp14_;
			ValaMapIterator* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			_tmp8_ = it;
			if (!vala_map_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = old_a;
			_tmp10_ = vala_attribute_get_args (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = it;
			_tmp13_ = vala_map_iterator_get_key (_tmp12_);
			_tmp14_ = (gchar*) _tmp13_;
			_tmp15_ = it;
			_tmp16_ = vala_map_iterator_get_value (_tmp15_);
			_tmp17_ = (gchar*) _tmp16_;
			vala_map_set (_tmp11_, _tmp14_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp14_);
		}
		_vala_map_iterator_unref0 (it);
	}
}

static ValaAttribute*
vala_code_node_get_or_create_attribute (ValaCodeNode* self,
                                        const gchar* name)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp7_;
	ValaAttribute* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute (self, name);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		ValaAttribute* new_a = NULL;
		ValaSourceReference* _tmp2_;
		ValaAttribute* _tmp3_;
		ValaAttribute* _tmp4_;
		ValaAttribute* _tmp5_;
		ValaAttribute* _tmp6_;
		_tmp2_ = self->priv->_source_reference;
		_tmp3_ = vala_attribute_new (name, _tmp2_);
		new_a = _tmp3_;
		_tmp4_ = new_a;
		_tmp5_ = _vala_code_node_ref0 (_tmp4_);
		self->attributes = g_list_append (self->attributes, _tmp5_);
		_tmp6_ = new_a;
		a = _tmp6_;
		_vala_code_node_unref0 (new_a);
	}
	_tmp7_ = a;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_ATTRIBUTE, ValaAttribute);
	return result;
}

/**
 * Returns true if the specified attribute is set.
 *
 * @param  attribute attribute name
 * @return           true if the node has the given attribute
 */
gboolean
vala_code_node_has_attribute (ValaCodeNode* self,
                              const gchar* attribute)
{
	ValaAttribute* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Returns true if the specified attribute argument is set.
 *
 * @param  attribute attribute name
 * @param  argument  argument name
 * @return           true if the attribute has the given argument
 */
gboolean
vala_code_node_has_attribute_argument (ValaCodeNode* self,
                                       const gchar* attribute,
                                       const gchar* argument)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (argument != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = a;
	result = vala_attribute_has_argument (_tmp2_, argument);
	return result;
}

/**
 * Sets the specified named attribute to this code node.
 *
 * @param name  attribute name
 * @param value true to add the attribute, false to remove it
 */
static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
vala_code_node_set_attribute (ValaCodeNode* self,
                              const gchar* name,
                              gboolean value,
                              ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = vala_code_node_get_attribute (self, name);
	a = _tmp0_;
	if (value) {
		ValaAttribute* _tmp2_;
		_tmp2_ = a;
		_tmp1_ = _tmp2_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaAttribute* _tmp3_;
		_tmp3_ = vala_attribute_new (name, source_reference);
		self->attributes = g_list_append (self->attributes, _tmp3_);
	} else {
		gboolean _tmp4_ = FALSE;
		if (!value) {
			ValaAttribute* _tmp5_;
			_tmp5_ = a;
			_tmp4_ = _tmp5_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaAttribute* _tmp6_;
			_tmp6_ = a;
			self->attributes = vala_g_list_remove_full (self->attributes, _tmp6_, _vala_code_node_unref0_);
		}
	}
}

/**
 * Remove the specified named attribute argument
 *
 * @param attribute attribute name
 * @param argument  argument name
 */
void
vala_code_node_remove_attribute_argument (ValaCodeNode* self,
                                          const gchar* attribute,
                                          const gchar* argument)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ != NULL) {
		ValaAttribute* _tmp2_;
		ValaMap* _tmp3_;
		ValaMap* _tmp4_;
		ValaAttribute* _tmp5_;
		ValaMap* _tmp6_;
		ValaMap* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp2_ = a;
		_tmp3_ = vala_attribute_get_args (_tmp2_);
		_tmp4_ = _tmp3_;
		vala_map_remove (_tmp4_, argument);
		_tmp5_ = a;
		_tmp6_ = vala_attribute_get_args (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_map_get_size (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == 0) {
			ValaAttribute* _tmp10_;
			_tmp10_ = a;
			self->attributes = vala_g_list_remove_full (self->attributes, _tmp10_, _vala_code_node_unref0_);
		}
	}
}

/**
 * Returns the string value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @return          string value
 */
gchar*
vala_code_node_get_attribute_string (ValaCodeNode* self,
                                     const gchar* attribute,
                                     const gchar* argument,
                                     const gchar* default_value)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute != NULL, NULL);
	g_return_val_if_fail (argument != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (default_value);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = a;
	_tmp4_ = vala_attribute_get_string (_tmp3_, argument, default_value);
	result = _tmp4_;
	return result;
}

/**
 * Returns the integer value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @return          integer value
 */
gint
vala_code_node_get_attribute_integer (ValaCodeNode* self,
                                      const gchar* attribute,
                                      const gchar* argument,
                                      gint default_value)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (attribute != NULL, 0);
	g_return_val_if_fail (argument != NULL, 0);
	_tmp0_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		result = default_value;
		return result;
	}
	_tmp2_ = a;
	result = vala_attribute_get_integer (_tmp2_, argument, default_value);
	return result;
}

/**
 * Returns the double value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @return          double value
 */
gdouble
vala_code_node_get_attribute_double (ValaCodeNode* self,
                                     const gchar* attribute,
                                     const gchar* argument,
                                     gdouble default_value)
{
	GList* _tmp0_;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	ValaAttribute* _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (attribute != NULL, 0.0);
	g_return_val_if_fail (argument != NULL, 0.0);
	_tmp0_ = self->attributes;
	if (_tmp0_ == NULL) {
		result = default_value;
		return result;
	}
	_tmp1_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp1_;
	_tmp2_ = a;
	if (_tmp2_ == NULL) {
		result = default_value;
		return result;
	}
	_tmp3_ = a;
	result = vala_attribute_get_double (_tmp3_, argument, default_value);
	return result;
}

/**
 * Returns the bool value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @return          bool value
 */
gboolean
vala_code_node_get_attribute_bool (ValaCodeNode* self,
                                   const gchar* attribute,
                                   const gchar* argument,
                                   gboolean default_value)
{
	GList* _tmp0_;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	ValaAttribute* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (argument != NULL, FALSE);
	_tmp0_ = self->attributes;
	if (_tmp0_ == NULL) {
		result = default_value;
		return result;
	}
	_tmp1_ = vala_code_node_get_attribute (self, attribute);
	a = _tmp1_;
	_tmp2_ = a;
	if (_tmp2_ == NULL) {
		result = default_value;
		return result;
	}
	_tmp3_ = a;
	result = vala_attribute_get_bool (_tmp3_, argument, default_value);
	return result;
}

/**
 * Sets the string value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @param value     string value
 */
void
vala_code_node_set_attribute_string (ValaCodeNode* self,
                                     const gchar* attribute,
                                     const gchar* argument,
                                     const gchar* value,
                                     ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	if (value == NULL) {
		vala_code_node_remove_attribute_argument (self, attribute, argument);
		return;
	}
	_tmp0_ = vala_code_node_get_or_create_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = a;
	_tmp2_ = g_strdup_printf ("\"%s\"", value);
	_tmp3_ = _tmp2_;
	vala_attribute_add_argument (_tmp1_, argument, _tmp3_);
	_g_free0 (_tmp3_);
}

/**
 * Sets the integer value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @param value     integer value
 */
void
vala_code_node_set_attribute_integer (ValaCodeNode* self,
                                      const gchar* attribute,
                                      const gchar* argument,
                                      gint value,
                                      ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = vala_code_node_get_or_create_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = g_strdup_printf ("%i", value);
	_tmp2_ = _tmp1_;
	vala_attribute_add_argument (a, argument, _tmp2_);
	_g_free0 (_tmp2_);
}

/**
 * Sets the integer value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @param value     double value
 */
void
vala_code_node_set_attribute_double (ValaCodeNode* self,
                                     const gchar* attribute,
                                     const gchar* argument,
                                     gdouble value,
                                     ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = vala_code_node_get_or_create_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp3_ = g_ascii_formatd (_tmp2_, (gint) G_ASCII_DTOSTR_BUF_SIZE, "%g", value);
	vala_attribute_add_argument (a, argument, _tmp3_);
	_tmp2_ = (g_free (_tmp2_), NULL);
}

/**
 * Sets the boolean value of the specified attribute argument.
 *
 * @param attribute attribute name
 * @param argument  argument name
 * @param value     bool value
 */
static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
vala_code_node_set_attribute_bool (ValaCodeNode* self,
                                   const gchar* attribute,
                                   const gchar* argument,
                                   gboolean value,
                                   ValaSourceReference* source_reference)
{
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attribute != NULL);
	g_return_if_fail (argument != NULL);
	_tmp0_ = vala_code_node_get_or_create_attribute (self, attribute);
	a = _tmp0_;
	_tmp1_ = bool_to_string (value);
	_tmp2_ = _tmp1_;
	vala_attribute_add_argument (a, argument, _tmp2_);
	_g_free0 (_tmp2_);
}

/**
 * Copy the string value of the specified attribute argument if available.
 *
 * @param source    codenode to copy from
 * @param attribute attribute name
 * @param argument  argument name
 * @return          true if successful
 */
gboolean
vala_code_node_copy_attribute_string (ValaCodeNode* self,
                                      ValaCodeNode* source,
                                      const gchar* attribute,
                                      const gchar* argument)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (argument != NULL, FALSE);
	if (vala_code_node_has_attribute_argument (source, attribute, argument)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = vala_code_node_get_attribute_string (source, attribute, argument, NULL);
		_tmp1_ = _tmp0_;
		vala_code_node_set_attribute_string (self, attribute, argument, _tmp1_, NULL);
		_g_free0 (_tmp1_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
 * Copy the integer value of the specified attribute argument if available.
 *
 * @param source    codenode to copy from
 * @param attribute attribute name
 * @param argument  argument name
 * @return          true if successful
 */
gboolean
vala_code_node_copy_attribute_integer (ValaCodeNode* self,
                                       ValaCodeNode* source,
                                       const gchar* attribute,
                                       const gchar* argument)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (argument != NULL, FALSE);
	if (vala_code_node_has_attribute_argument (source, attribute, argument)) {
		vala_code_node_set_attribute_integer (self, attribute, argument, vala_code_node_get_attribute_integer (source, attribute, argument, 0), NULL);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
 * Copy the double value of the specified attribute argument if available.
 *
 * @param source    codenode to copy from
 * @param attribute attribute name
 * @param argument  argument name
 * @return          true if successful
 */
gboolean
vala_code_node_copy_attribute_double (ValaCodeNode* self,
                                      ValaCodeNode* source,
                                      const gchar* attribute,
                                      const gchar* argument)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (argument != NULL, FALSE);
	if (vala_code_node_has_attribute_argument (source, attribute, argument)) {
		vala_code_node_set_attribute_double (self, attribute, argument, vala_code_node_get_attribute_double (source, attribute, argument, (gdouble) 0), NULL);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
 * Copy the boolean value of the specified attribute argument if available.
 *
 * @param source    codenode to copy from
 * @param attribute attribute name
 * @param argument  argument name
 * @return          true if successful
 */
gboolean
vala_code_node_copy_attribute_bool (ValaCodeNode* self,
                                    ValaCodeNode* source,
                                    const gchar* attribute,
                                    const gchar* argument)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	g_return_val_if_fail (argument != NULL, FALSE);
	if (vala_code_node_has_attribute_argument (source, attribute, argument)) {
		vala_code_node_set_attribute_bool (self, attribute, argument, vala_code_node_get_attribute_bool (source, attribute, argument, FALSE), NULL);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
 * Returns the attribute cache at the specified index.
 *
 * @param index attribute cache index
 * @return      attribute cache
 */
ValaAttributeCache*
vala_code_node_get_attribute_cache (ValaCodeNode* self,
                                    gint index)
{
	ValaAttributeCache** _tmp0_;
	gint _tmp0__length1;
	ValaAttributeCache** _tmp1_;
	gint _tmp1__length1;
	ValaAttributeCache* _tmp2_;
	ValaAttributeCache* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->attributes_cache;
	_tmp0__length1 = self->priv->attributes_cache_length1;
	if (index >= _tmp0__length1) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->attributes_cache;
	_tmp1__length1 = self->priv->attributes_cache_length1;
	_tmp2_ = _tmp1_[index];
	result = _tmp2_;
	return result;
}

/**
 * Sets the specified attribute cache to this code node.
 *
 * @param index attribute cache index
 * @param cache attribute cache
 */
static gpointer
_vala_attribute_cache_ref0 (gpointer self)
{
	return self ? vala_attribute_cache_ref (self) : NULL;
}

void
vala_code_node_set_attribute_cache (ValaCodeNode* self,
                                    gint index,
                                    ValaAttributeCache* cache)
{
	ValaAttributeCache** _tmp0_;
	gint _tmp0__length1;
	ValaAttributeCache** _tmp2_;
	gint _tmp2__length1;
	ValaAttributeCache* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cache != NULL);
	_tmp0_ = self->priv->attributes_cache;
	_tmp0__length1 = self->priv->attributes_cache_length1;
	if (index >= _tmp0__length1) {
		gint _tmp1_;
		_tmp1_ = (index * 2) + 1;
		self->priv->attributes_cache = g_renew (ValaAttributeCache*, self->priv->attributes_cache, (index * 2) + 1);
		(_tmp1_ > self->priv->attributes_cache_length1) ? memset (self->priv->attributes_cache + self->priv->attributes_cache_length1, 0, sizeof (ValaAttributeCache*) * (_tmp1_ - self->priv->attributes_cache_length1)) : NULL;
		self->priv->attributes_cache_length1 = _tmp1_;
		self->priv->_attributes_cache_size_ = _tmp1_;
	}
	_tmp2_ = self->priv->attributes_cache;
	_tmp2__length1 = self->priv->attributes_cache_length1;
	_tmp3_ = _vala_attribute_cache_ref0 (cache);
	_vala_attribute_cache_unref0 (_tmp2_[index]);
	_tmp2_[index] = _tmp3_;
}

/**
 * Returns a string that represents this code node.
 *
 * @return a string representation
 */
static gchar*
vala_code_node_real_to_string (ValaCodeNode* self)
{
	GString* str = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaSourceReference* _tmp5_;
	GString* _tmp11_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = str;
	g_string_append (_tmp1_, "/* ");
	_tmp2_ = str;
	_tmp3_ = vala_code_node_get_type_name (self);
	_tmp4_ = _tmp3_;
	g_string_append (_tmp2_, _tmp4_);
	_tmp5_ = self->priv->_source_reference;
	if (_tmp5_ != NULL) {
		GString* _tmp6_;
		GString* _tmp7_;
		ValaSourceReference* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = str;
		_tmp7_ = g_string_append (_tmp6_, "@");
		_tmp8_ = self->priv->_source_reference;
		_tmp9_ = vala_source_reference_to_string (_tmp8_);
		_tmp10_ = _tmp9_;
		g_string_append (_tmp7_, _tmp10_);
		_g_free0 (_tmp10_);
	}
	_tmp11_ = str;
	_tmp12_ = g_string_append (_tmp11_, " */");
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_string_free0 (str);
	return result;
}

gchar*
vala_code_node_to_string (ValaCodeNode* self)
{
	ValaCodeNodeClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

static void
vala_code_node_real_get_defined_variables (ValaCodeNode* self,
                                           ValaCollection* collection)
{
	g_return_if_fail (collection != NULL);
}

void
vala_code_node_get_defined_variables (ValaCodeNode* self,
                                      ValaCollection* collection)
{
	ValaCodeNodeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->get_defined_variables) {
		_klass_->get_defined_variables (self, collection);
	}
}

static void
vala_code_node_real_get_used_variables (ValaCodeNode* self,
                                        ValaCollection* collection)
{
	g_return_if_fail (collection != NULL);
}

void
vala_code_node_get_used_variables (ValaCodeNode* self,
                                   ValaCollection* collection)
{
	ValaCodeNodeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->get_used_variables) {
		_klass_->get_used_variables (self, collection);
	}
}

static void
vala_code_node_real_get_error_types (ValaCodeNode* self,
                                     ValaCollection* collection,
                                     ValaSourceReference* source_reference)
{
	g_return_if_fail (collection != NULL);
}

void
vala_code_node_get_error_types (ValaCodeNode* self,
                                ValaCollection* collection,
                                ValaSourceReference* source_reference)
{
	ValaCodeNodeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VALA_CODE_NODE_GET_CLASS (self);
	if (_klass_->get_error_types) {
		_klass_->get_error_types (self, collection, source_reference);
	}
}

gchar*
vala_code_node_get_temp_name (void)
{
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	vala_code_node_last_temp_nr = vala_code_node_last_temp_nr + 1;
	_tmp0_ = vala_code_node_last_temp_nr;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (".", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
 * Returns a new cache index for accessing the attributes cache of code nodes
 *
 * @return a new cache index
 */
gint
vala_code_node_get_attribute_cache_index (void)
{
	gint _tmp0_;
	gint result;
	_tmp0_ = vala_code_node_next_attribute_cache_index;
	vala_code_node_next_attribute_cache_index = _tmp0_ + 1;
	result = _tmp0_;
	return result;
}

ValaCodeNode*
vala_code_node_construct (GType object_type)
{
	ValaCodeNode* self = NULL;
	self = (ValaCodeNode*) g_type_create_instance (object_type);
	return self;
}

static void
vala_value_code_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_code_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_code_node_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_code_node_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_code_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_code_node_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCodeNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_code_node_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	ValaCodeNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_code_node (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ValaParamSpecCodeNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_code_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_code_node (GValue* value,
                          gpointer v_object)
{
	ValaCodeNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_node_unref (old);
	}
}

void
vala_value_take_code_node (GValue* value,
                           gpointer v_object)
{
	ValaCodeNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_node_unref (old);
	}
}

static void
vala_code_node_class_init (ValaCodeNodeClass * klass,
                           gpointer klass_data)
{
	vala_code_node_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_code_node_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCodeNode_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_code_node_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_code_node_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_code_node_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_code_node_real_emit;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_code_node_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_code_node_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_code_node_real_to_string;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_code_node_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_code_node_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_code_node_real_get_error_types;
}

static void
vala_code_node_instance_init (ValaCodeNode * self,
                              gpointer klass)
{
	self->priv = vala_code_node_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_code_node_finalize (ValaCodeNode * obj)
{
	ValaCodeNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CODE_NODE, ValaCodeNode);
	g_signal_handlers_destroy (self);
	_vala_source_reference_unref0 (self->priv->_source_reference);
	(self->attributes == NULL) ? NULL : (self->attributes = (_g_list_free__vala_code_node_unref0_ (self->attributes), NULL));
	self->priv->attributes_cache = (_vala_array_free (self->priv->attributes_cache, self->priv->attributes_cache_length1, (GDestroyNotify) vala_attribute_cache_unref), NULL);
}

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
static GType
vala_code_node_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_code_node_init, vala_value_code_node_free_value, vala_value_code_node_copy_value, vala_value_code_node_peek_pointer, "p", vala_value_code_node_collect_value, "p", vala_value_code_node_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaCodeNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeNode), 0, (GInstanceInitFunc) vala_code_node_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_code_node_type_id;
	vala_code_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeNode", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	ValaCodeNode_private_offset = g_type_add_instance_private (vala_code_node_type_id, sizeof (ValaCodeNodePrivate));
	return vala_code_node_type_id;
}

GType
vala_code_node_get_type (void)
{
	static volatile gsize vala_code_node_type_id__once = 0;
	if (g_once_init_enter (&vala_code_node_type_id__once)) {
		GType vala_code_node_type_id;
		vala_code_node_type_id = vala_code_node_get_type_once ();
		g_once_init_leave (&vala_code_node_type_id__once, vala_code_node_type_id);
	}
	return vala_code_node_type_id__once;
}

gpointer
vala_code_node_ref (gpointer instance)
{
	ValaCodeNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_code_node_unref (gpointer instance)
{
	ValaCodeNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

ValaAttributeCache*
vala_attribute_cache_construct (GType object_type)
{
	ValaAttributeCache* self = NULL;
	self = (ValaAttributeCache*) g_type_create_instance (object_type);
	return self;
}

ValaAttributeCache*
vala_attribute_cache_new (void)
{
	return vala_attribute_cache_construct (VALA_TYPE_ATTRIBUTE_CACHE);
}

static void
vala_value_attribute_cache_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_attribute_cache_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_attribute_cache_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_attribute_cache_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_attribute_cache_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_attribute_cache_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_attribute_cache_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaAttributeCache * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_attribute_cache_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_attribute_cache_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ValaAttributeCache ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_attribute_cache_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_attribute_cache (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ValaParamSpecAttributeCache* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_ATTRIBUTE_CACHE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_attribute_cache (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_ATTRIBUTE_CACHE), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_attribute_cache (GValue* value,
                                gpointer v_object)
{
	ValaAttributeCache * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_ATTRIBUTE_CACHE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_ATTRIBUTE_CACHE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_attribute_cache_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_attribute_cache_unref (old);
	}
}

void
vala_value_take_attribute_cache (GValue* value,
                                 gpointer v_object)
{
	ValaAttributeCache * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_ATTRIBUTE_CACHE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_ATTRIBUTE_CACHE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_attribute_cache_unref (old);
	}
}

static void
vala_attribute_cache_class_init (ValaAttributeCacheClass * klass,
                                 gpointer klass_data)
{
	vala_attribute_cache_parent_class = g_type_class_peek_parent (klass);
	((ValaAttributeCacheClass *) klass)->finalize = vala_attribute_cache_finalize;
}

static void
vala_attribute_cache_instance_init (ValaAttributeCache * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
vala_attribute_cache_finalize (ValaAttributeCache * obj)
{
	ValaAttributeCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ATTRIBUTE_CACHE, ValaAttributeCache);
	g_signal_handlers_destroy (self);
}

static GType
vala_attribute_cache_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_attribute_cache_init, vala_value_attribute_cache_free_value, vala_value_attribute_cache_copy_value, vala_value_attribute_cache_peek_pointer, "p", vala_value_attribute_cache_collect_value, "p", vala_value_attribute_cache_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaAttributeCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_attribute_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAttributeCache), 0, (GInstanceInitFunc) vala_attribute_cache_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_attribute_cache_type_id;
	vala_attribute_cache_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaAttributeCache", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_attribute_cache_type_id;
}

GType
vala_attribute_cache_get_type (void)
{
	static volatile gsize vala_attribute_cache_type_id__once = 0;
	if (g_once_init_enter (&vala_attribute_cache_type_id__once)) {
		GType vala_attribute_cache_type_id;
		vala_attribute_cache_type_id = vala_attribute_cache_get_type_once ();
		g_once_init_leave (&vala_attribute_cache_type_id__once, vala_attribute_cache_type_id);
	}
	return vala_attribute_cache_type_id__once;
}

gpointer
vala_attribute_cache_ref (gpointer instance)
{
	ValaAttributeCache * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_attribute_cache_unref (gpointer instance)
{
	ValaAttributeCache * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_ATTRIBUTE_CACHE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

