// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::StyleProvider;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSettings")]
    pub struct Settings(Object<ffi::GtkSettings>) @implements StyleProvider;

    match fn {
        type_ => || ffi::gtk_settings_get_type(),
    }
}

impl Settings {
    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Settings`] objects.
    ///
    /// This method returns an instance of [`SettingsBuilder`](crate::builders::SettingsBuilder) which can be used to create [`Settings`] objects.
    pub fn builder() -> SettingsBuilder {
        SettingsBuilder::default()
    }

    #[doc(alias = "gtk_settings_reset_property")]
    pub fn reset_property(&self, name: &str) {
        unsafe {
            ffi::gtk_settings_reset_property(self.to_glib_none().0, name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk-alternative-button-order")]
    pub fn is_gtk_alternative_button_order(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-alternative-button-order")
    }

    #[doc(alias = "gtk-alternative-button-order")]
    pub fn set_gtk_alternative_button_order(&self, gtk_alternative_button_order: bool) {
        glib::ObjectExt::set_property(
            self,
            "gtk-alternative-button-order",
            &gtk_alternative_button_order,
        )
    }

    #[doc(alias = "gtk-alternative-sort-arrows")]
    pub fn is_gtk_alternative_sort_arrows(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-alternative-sort-arrows")
    }

    #[doc(alias = "gtk-alternative-sort-arrows")]
    pub fn set_gtk_alternative_sort_arrows(&self, gtk_alternative_sort_arrows: bool) {
        glib::ObjectExt::set_property(
            self,
            "gtk-alternative-sort-arrows",
            &gtk_alternative_sort_arrows,
        )
    }

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    pub fn is_gtk_application_prefer_dark_theme(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-application-prefer-dark-theme")
    }

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    pub fn set_gtk_application_prefer_dark_theme(&self, gtk_application_prefer_dark_theme: bool) {
        glib::ObjectExt::set_property(
            self,
            "gtk-application-prefer-dark-theme",
            &gtk_application_prefer_dark_theme,
        )
    }

    #[doc(alias = "gtk-cursor-aspect-ratio")]
    pub fn gtk_cursor_aspect_ratio(&self) -> f64 {
        glib::ObjectExt::property(self, "gtk-cursor-aspect-ratio")
    }

    #[doc(alias = "gtk-cursor-aspect-ratio")]
    pub fn set_gtk_cursor_aspect_ratio(&self, gtk_cursor_aspect_ratio: f64) {
        glib::ObjectExt::set_property(self, "gtk-cursor-aspect-ratio", &gtk_cursor_aspect_ratio)
    }

    #[doc(alias = "gtk-cursor-blink")]
    pub fn is_gtk_cursor_blink(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-cursor-blink")
    }

    #[doc(alias = "gtk-cursor-blink")]
    pub fn set_gtk_cursor_blink(&self, gtk_cursor_blink: bool) {
        glib::ObjectExt::set_property(self, "gtk-cursor-blink", &gtk_cursor_blink)
    }

    #[doc(alias = "gtk-cursor-blink-time")]
    pub fn gtk_cursor_blink_time(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-cursor-blink-time")
    }

    #[doc(alias = "gtk-cursor-blink-time")]
    pub fn set_gtk_cursor_blink_time(&self, gtk_cursor_blink_time: i32) {
        glib::ObjectExt::set_property(self, "gtk-cursor-blink-time", &gtk_cursor_blink_time)
    }

    #[doc(alias = "gtk-cursor-blink-timeout")]
    pub fn gtk_cursor_blink_timeout(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-cursor-blink-timeout")
    }

    #[doc(alias = "gtk-cursor-blink-timeout")]
    pub fn set_gtk_cursor_blink_timeout(&self, gtk_cursor_blink_timeout: i32) {
        glib::ObjectExt::set_property(self, "gtk-cursor-blink-timeout", &gtk_cursor_blink_timeout)
    }

    #[doc(alias = "gtk-cursor-theme-name")]
    pub fn gtk_cursor_theme_name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-cursor-theme-name")
    }

    #[doc(alias = "gtk-cursor-theme-name")]
    pub fn set_gtk_cursor_theme_name(&self, gtk_cursor_theme_name: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-cursor-theme-name", &gtk_cursor_theme_name)
    }

    #[doc(alias = "gtk-cursor-theme-size")]
    pub fn gtk_cursor_theme_size(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-cursor-theme-size")
    }

    #[doc(alias = "gtk-cursor-theme-size")]
    pub fn set_gtk_cursor_theme_size(&self, gtk_cursor_theme_size: i32) {
        glib::ObjectExt::set_property(self, "gtk-cursor-theme-size", &gtk_cursor_theme_size)
    }

    #[doc(alias = "gtk-decoration-layout")]
    pub fn gtk_decoration_layout(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-decoration-layout")
    }

    #[doc(alias = "gtk-decoration-layout")]
    pub fn set_gtk_decoration_layout(&self, gtk_decoration_layout: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-decoration-layout", &gtk_decoration_layout)
    }

    #[doc(alias = "gtk-dialogs-use-header")]
    pub fn is_gtk_dialogs_use_header(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-dialogs-use-header")
    }

    #[doc(alias = "gtk-dialogs-use-header")]
    pub fn set_gtk_dialogs_use_header(&self, gtk_dialogs_use_header: bool) {
        glib::ObjectExt::set_property(self, "gtk-dialogs-use-header", &gtk_dialogs_use_header)
    }

    #[doc(alias = "gtk-dnd-drag-threshold")]
    pub fn gtk_dnd_drag_threshold(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-dnd-drag-threshold")
    }

    #[doc(alias = "gtk-dnd-drag-threshold")]
    pub fn set_gtk_dnd_drag_threshold(&self, gtk_dnd_drag_threshold: i32) {
        glib::ObjectExt::set_property(self, "gtk-dnd-drag-threshold", &gtk_dnd_drag_threshold)
    }

    #[doc(alias = "gtk-double-click-distance")]
    pub fn gtk_double_click_distance(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-double-click-distance")
    }

    #[doc(alias = "gtk-double-click-distance")]
    pub fn set_gtk_double_click_distance(&self, gtk_double_click_distance: i32) {
        glib::ObjectExt::set_property(
            self,
            "gtk-double-click-distance",
            &gtk_double_click_distance,
        )
    }

    #[doc(alias = "gtk-double-click-time")]
    pub fn gtk_double_click_time(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-double-click-time")
    }

    #[doc(alias = "gtk-double-click-time")]
    pub fn set_gtk_double_click_time(&self, gtk_double_click_time: i32) {
        glib::ObjectExt::set_property(self, "gtk-double-click-time", &gtk_double_click_time)
    }

    #[doc(alias = "gtk-enable-accels")]
    pub fn is_gtk_enable_accels(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-enable-accels")
    }

    #[doc(alias = "gtk-enable-accels")]
    pub fn set_gtk_enable_accels(&self, gtk_enable_accels: bool) {
        glib::ObjectExt::set_property(self, "gtk-enable-accels", &gtk_enable_accels)
    }

    #[doc(alias = "gtk-enable-animations")]
    pub fn is_gtk_enable_animations(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-enable-animations")
    }

    #[doc(alias = "gtk-enable-animations")]
    pub fn set_gtk_enable_animations(&self, gtk_enable_animations: bool) {
        glib::ObjectExt::set_property(self, "gtk-enable-animations", &gtk_enable_animations)
    }

    #[doc(alias = "gtk-enable-event-sounds")]
    pub fn is_gtk_enable_event_sounds(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-enable-event-sounds")
    }

    #[doc(alias = "gtk-enable-event-sounds")]
    pub fn set_gtk_enable_event_sounds(&self, gtk_enable_event_sounds: bool) {
        glib::ObjectExt::set_property(self, "gtk-enable-event-sounds", &gtk_enable_event_sounds)
    }

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    pub fn is_gtk_enable_input_feedback_sounds(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-enable-input-feedback-sounds")
    }

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    pub fn set_gtk_enable_input_feedback_sounds(&self, gtk_enable_input_feedback_sounds: bool) {
        glib::ObjectExt::set_property(
            self,
            "gtk-enable-input-feedback-sounds",
            &gtk_enable_input_feedback_sounds,
        )
    }

    #[doc(alias = "gtk-enable-primary-paste")]
    pub fn is_gtk_enable_primary_paste(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-enable-primary-paste")
    }

    #[doc(alias = "gtk-enable-primary-paste")]
    pub fn set_gtk_enable_primary_paste(&self, gtk_enable_primary_paste: bool) {
        glib::ObjectExt::set_property(self, "gtk-enable-primary-paste", &gtk_enable_primary_paste)
    }

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    pub fn gtk_entry_password_hint_timeout(&self) -> u32 {
        glib::ObjectExt::property(self, "gtk-entry-password-hint-timeout")
    }

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    pub fn set_gtk_entry_password_hint_timeout(&self, gtk_entry_password_hint_timeout: u32) {
        glib::ObjectExt::set_property(
            self,
            "gtk-entry-password-hint-timeout",
            &gtk_entry_password_hint_timeout,
        )
    }

    #[doc(alias = "gtk-entry-select-on-focus")]
    pub fn is_gtk_entry_select_on_focus(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-entry-select-on-focus")
    }

    #[doc(alias = "gtk-entry-select-on-focus")]
    pub fn set_gtk_entry_select_on_focus(&self, gtk_entry_select_on_focus: bool) {
        glib::ObjectExt::set_property(
            self,
            "gtk-entry-select-on-focus",
            &gtk_entry_select_on_focus,
        )
    }

    #[doc(alias = "gtk-error-bell")]
    pub fn is_gtk_error_bell(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-error-bell")
    }

    #[doc(alias = "gtk-error-bell")]
    pub fn set_gtk_error_bell(&self, gtk_error_bell: bool) {
        glib::ObjectExt::set_property(self, "gtk-error-bell", &gtk_error_bell)
    }

    #[doc(alias = "gtk-font-name")]
    pub fn gtk_font_name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-font-name")
    }

    #[doc(alias = "gtk-font-name")]
    pub fn set_gtk_font_name(&self, gtk_font_name: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-font-name", &gtk_font_name)
    }

    #[doc(alias = "gtk-fontconfig-timestamp")]
    pub fn gtk_fontconfig_timestamp(&self) -> u32 {
        glib::ObjectExt::property(self, "gtk-fontconfig-timestamp")
    }

    #[doc(alias = "gtk-fontconfig-timestamp")]
    pub fn set_gtk_fontconfig_timestamp(&self, gtk_fontconfig_timestamp: u32) {
        glib::ObjectExt::set_property(self, "gtk-fontconfig-timestamp", &gtk_fontconfig_timestamp)
    }

    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gtk-hint-font-metrics")]
    pub fn is_gtk_hint_font_metrics(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-hint-font-metrics")
    }

    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gtk-hint-font-metrics")]
    pub fn set_gtk_hint_font_metrics(&self, gtk_hint_font_metrics: bool) {
        glib::ObjectExt::set_property(self, "gtk-hint-font-metrics", &gtk_hint_font_metrics)
    }

    #[doc(alias = "gtk-icon-theme-name")]
    pub fn gtk_icon_theme_name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-icon-theme-name")
    }

    #[doc(alias = "gtk-icon-theme-name")]
    pub fn set_gtk_icon_theme_name(&self, gtk_icon_theme_name: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-icon-theme-name", &gtk_icon_theme_name)
    }

    #[doc(alias = "gtk-im-module")]
    pub fn gtk_im_module(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-im-module")
    }

    #[doc(alias = "gtk-im-module")]
    pub fn set_gtk_im_module(&self, gtk_im_module: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-im-module", &gtk_im_module)
    }

    #[doc(alias = "gtk-keynav-use-caret")]
    pub fn is_gtk_keynav_use_caret(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-keynav-use-caret")
    }

    #[doc(alias = "gtk-keynav-use-caret")]
    pub fn set_gtk_keynav_use_caret(&self, gtk_keynav_use_caret: bool) {
        glib::ObjectExt::set_property(self, "gtk-keynav-use-caret", &gtk_keynav_use_caret)
    }

    #[doc(alias = "gtk-label-select-on-focus")]
    pub fn is_gtk_label_select_on_focus(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-label-select-on-focus")
    }

    #[doc(alias = "gtk-label-select-on-focus")]
    pub fn set_gtk_label_select_on_focus(&self, gtk_label_select_on_focus: bool) {
        glib::ObjectExt::set_property(
            self,
            "gtk-label-select-on-focus",
            &gtk_label_select_on_focus,
        )
    }

    #[doc(alias = "gtk-long-press-time")]
    pub fn gtk_long_press_time(&self) -> u32 {
        glib::ObjectExt::property(self, "gtk-long-press-time")
    }

    #[doc(alias = "gtk-long-press-time")]
    pub fn set_gtk_long_press_time(&self, gtk_long_press_time: u32) {
        glib::ObjectExt::set_property(self, "gtk-long-press-time", &gtk_long_press_time)
    }

    #[doc(alias = "gtk-overlay-scrolling")]
    pub fn is_gtk_overlay_scrolling(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-overlay-scrolling")
    }

    #[doc(alias = "gtk-overlay-scrolling")]
    pub fn set_gtk_overlay_scrolling(&self, gtk_overlay_scrolling: bool) {
        glib::ObjectExt::set_property(self, "gtk-overlay-scrolling", &gtk_overlay_scrolling)
    }

    #[doc(alias = "gtk-primary-button-warps-slider")]
    pub fn is_gtk_primary_button_warps_slider(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-primary-button-warps-slider")
    }

    #[doc(alias = "gtk-primary-button-warps-slider")]
    pub fn set_gtk_primary_button_warps_slider(&self, gtk_primary_button_warps_slider: bool) {
        glib::ObjectExt::set_property(
            self,
            "gtk-primary-button-warps-slider",
            &gtk_primary_button_warps_slider,
        )
    }

    #[doc(alias = "gtk-print-backends")]
    pub fn gtk_print_backends(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-print-backends")
    }

    #[doc(alias = "gtk-print-backends")]
    pub fn set_gtk_print_backends(&self, gtk_print_backends: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-print-backends", &gtk_print_backends)
    }

    #[doc(alias = "gtk-print-preview-command")]
    pub fn gtk_print_preview_command(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-print-preview-command")
    }

    #[doc(alias = "gtk-print-preview-command")]
    pub fn set_gtk_print_preview_command(&self, gtk_print_preview_command: Option<&str>) {
        glib::ObjectExt::set_property(
            self,
            "gtk-print-preview-command",
            &gtk_print_preview_command,
        )
    }

    #[doc(alias = "gtk-recent-files-enabled")]
    pub fn is_gtk_recent_files_enabled(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-recent-files-enabled")
    }

    #[doc(alias = "gtk-recent-files-enabled")]
    pub fn set_gtk_recent_files_enabled(&self, gtk_recent_files_enabled: bool) {
        glib::ObjectExt::set_property(self, "gtk-recent-files-enabled", &gtk_recent_files_enabled)
    }

    #[doc(alias = "gtk-recent-files-max-age")]
    pub fn gtk_recent_files_max_age(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-recent-files-max-age")
    }

    #[doc(alias = "gtk-recent-files-max-age")]
    pub fn set_gtk_recent_files_max_age(&self, gtk_recent_files_max_age: i32) {
        glib::ObjectExt::set_property(self, "gtk-recent-files-max-age", &gtk_recent_files_max_age)
    }

    #[doc(alias = "gtk-shell-shows-app-menu")]
    pub fn is_gtk_shell_shows_app_menu(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-shell-shows-app-menu")
    }

    #[doc(alias = "gtk-shell-shows-app-menu")]
    pub fn set_gtk_shell_shows_app_menu(&self, gtk_shell_shows_app_menu: bool) {
        glib::ObjectExt::set_property(self, "gtk-shell-shows-app-menu", &gtk_shell_shows_app_menu)
    }

    #[doc(alias = "gtk-shell-shows-desktop")]
    pub fn is_gtk_shell_shows_desktop(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-shell-shows-desktop")
    }

    #[doc(alias = "gtk-shell-shows-desktop")]
    pub fn set_gtk_shell_shows_desktop(&self, gtk_shell_shows_desktop: bool) {
        glib::ObjectExt::set_property(self, "gtk-shell-shows-desktop", &gtk_shell_shows_desktop)
    }

    #[doc(alias = "gtk-shell-shows-menubar")]
    pub fn is_gtk_shell_shows_menubar(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-shell-shows-menubar")
    }

    #[doc(alias = "gtk-shell-shows-menubar")]
    pub fn set_gtk_shell_shows_menubar(&self, gtk_shell_shows_menubar: bool) {
        glib::ObjectExt::set_property(self, "gtk-shell-shows-menubar", &gtk_shell_shows_menubar)
    }

    #[doc(alias = "gtk-sound-theme-name")]
    pub fn gtk_sound_theme_name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-sound-theme-name")
    }

    #[doc(alias = "gtk-sound-theme-name")]
    pub fn set_gtk_sound_theme_name(&self, gtk_sound_theme_name: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-sound-theme-name", &gtk_sound_theme_name)
    }

    #[doc(alias = "gtk-split-cursor")]
    pub fn is_gtk_split_cursor(&self) -> bool {
        glib::ObjectExt::property(self, "gtk-split-cursor")
    }

    #[doc(alias = "gtk-split-cursor")]
    pub fn set_gtk_split_cursor(&self, gtk_split_cursor: bool) {
        glib::ObjectExt::set_property(self, "gtk-split-cursor", &gtk_split_cursor)
    }

    #[doc(alias = "gtk-theme-name")]
    pub fn gtk_theme_name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-theme-name")
    }

    #[doc(alias = "gtk-theme-name")]
    pub fn set_gtk_theme_name(&self, gtk_theme_name: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-theme-name", &gtk_theme_name)
    }

    #[doc(alias = "gtk-titlebar-double-click")]
    pub fn gtk_titlebar_double_click(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-titlebar-double-click")
    }

    #[doc(alias = "gtk-titlebar-double-click")]
    pub fn set_gtk_titlebar_double_click(&self, gtk_titlebar_double_click: Option<&str>) {
        glib::ObjectExt::set_property(
            self,
            "gtk-titlebar-double-click",
            &gtk_titlebar_double_click,
        )
    }

    #[doc(alias = "gtk-titlebar-middle-click")]
    pub fn gtk_titlebar_middle_click(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-titlebar-middle-click")
    }

    #[doc(alias = "gtk-titlebar-middle-click")]
    pub fn set_gtk_titlebar_middle_click(&self, gtk_titlebar_middle_click: Option<&str>) {
        glib::ObjectExt::set_property(
            self,
            "gtk-titlebar-middle-click",
            &gtk_titlebar_middle_click,
        )
    }

    #[doc(alias = "gtk-titlebar-right-click")]
    pub fn gtk_titlebar_right_click(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-titlebar-right-click")
    }

    #[doc(alias = "gtk-titlebar-right-click")]
    pub fn set_gtk_titlebar_right_click(&self, gtk_titlebar_right_click: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-titlebar-right-click", &gtk_titlebar_right_click)
    }

    #[doc(alias = "gtk-xft-antialias")]
    pub fn gtk_xft_antialias(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-xft-antialias")
    }

    #[doc(alias = "gtk-xft-antialias")]
    pub fn set_gtk_xft_antialias(&self, gtk_xft_antialias: i32) {
        glib::ObjectExt::set_property(self, "gtk-xft-antialias", &gtk_xft_antialias)
    }

    #[doc(alias = "gtk-xft-dpi")]
    pub fn gtk_xft_dpi(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-xft-dpi")
    }

    #[doc(alias = "gtk-xft-dpi")]
    pub fn set_gtk_xft_dpi(&self, gtk_xft_dpi: i32) {
        glib::ObjectExt::set_property(self, "gtk-xft-dpi", &gtk_xft_dpi)
    }

    #[doc(alias = "gtk-xft-hinting")]
    pub fn gtk_xft_hinting(&self) -> i32 {
        glib::ObjectExt::property(self, "gtk-xft-hinting")
    }

    #[doc(alias = "gtk-xft-hinting")]
    pub fn set_gtk_xft_hinting(&self, gtk_xft_hinting: i32) {
        glib::ObjectExt::set_property(self, "gtk-xft-hinting", &gtk_xft_hinting)
    }

    #[doc(alias = "gtk-xft-hintstyle")]
    pub fn gtk_xft_hintstyle(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-xft-hintstyle")
    }

    #[doc(alias = "gtk-xft-hintstyle")]
    pub fn set_gtk_xft_hintstyle(&self, gtk_xft_hintstyle: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-xft-hintstyle", &gtk_xft_hintstyle)
    }

    #[doc(alias = "gtk-xft-rgba")]
    pub fn gtk_xft_rgba(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "gtk-xft-rgba")
    }

    #[doc(alias = "gtk-xft-rgba")]
    pub fn set_gtk_xft_rgba(&self, gtk_xft_rgba: Option<&str>) {
        glib::ObjectExt::set_property(self, "gtk-xft-rgba", &gtk_xft_rgba)
    }

    #[doc(alias = "gtk_settings_get_default")]
    #[doc(alias = "get_default")]
    pub fn default() -> Option<Settings> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_settings_get_default()) }
    }

    #[doc(alias = "gtk_settings_get_for_display")]
    #[doc(alias = "get_for_display")]
    pub fn for_display(display: &impl IsA<gdk::Display>) -> Settings {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gtk_settings_get_for_display(
                display.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk-alternative-button-order")]
    pub fn connect_gtk_alternative_button_order_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_alternative_button_order_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-alternative-button-order\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_alternative_button_order_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-alternative-sort-arrows")]
    pub fn connect_gtk_alternative_sort_arrows_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_alternative_sort_arrows_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-alternative-sort-arrows\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_alternative_sort_arrows_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-application-prefer-dark-theme")]
    pub fn connect_gtk_application_prefer_dark_theme_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_application_prefer_dark_theme_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-application-prefer-dark-theme\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_application_prefer_dark_theme_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-aspect-ratio")]
    pub fn connect_gtk_cursor_aspect_ratio_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_aspect_ratio_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-aspect-ratio\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_aspect_ratio_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-blink")]
    pub fn connect_gtk_cursor_blink_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-blink\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-blink-time")]
    pub fn connect_gtk_cursor_blink_time_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_time_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-blink-time\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_time_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-blink-timeout")]
    pub fn connect_gtk_cursor_blink_timeout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_blink_timeout_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-blink-timeout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_blink_timeout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-theme-name")]
    pub fn connect_gtk_cursor_theme_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_theme_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_theme_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-cursor-theme-size")]
    pub fn connect_gtk_cursor_theme_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_cursor_theme_size_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-cursor-theme-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_cursor_theme_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-decoration-layout")]
    pub fn connect_gtk_decoration_layout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_decoration_layout_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-decoration-layout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_decoration_layout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-dialogs-use-header")]
    pub fn connect_gtk_dialogs_use_header_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_dialogs_use_header_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-dialogs-use-header\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_dialogs_use_header_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-dnd-drag-threshold")]
    pub fn connect_gtk_dnd_drag_threshold_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_dnd_drag_threshold_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-dnd-drag-threshold\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_dnd_drag_threshold_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-double-click-distance")]
    pub fn connect_gtk_double_click_distance_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_double_click_distance_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-double-click-distance\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_double_click_distance_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-double-click-time")]
    pub fn connect_gtk_double_click_time_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_double_click_time_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-double-click-time\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_double_click_time_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-accels")]
    pub fn connect_gtk_enable_accels_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_accels_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-accels\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_accels_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-animations")]
    pub fn connect_gtk_enable_animations_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_animations_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-animations\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_animations_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-event-sounds")]
    pub fn connect_gtk_enable_event_sounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_event_sounds_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-event-sounds\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_event_sounds_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-input-feedback-sounds")]
    pub fn connect_gtk_enable_input_feedback_sounds_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_input_feedback_sounds_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-input-feedback-sounds\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_input_feedback_sounds_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-enable-primary-paste")]
    pub fn connect_gtk_enable_primary_paste_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_enable_primary_paste_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-enable-primary-paste\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_enable_primary_paste_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-entry-password-hint-timeout")]
    pub fn connect_gtk_entry_password_hint_timeout_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_entry_password_hint_timeout_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-entry-password-hint-timeout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_entry_password_hint_timeout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-entry-select-on-focus")]
    pub fn connect_gtk_entry_select_on_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_entry_select_on_focus_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-entry-select-on-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_entry_select_on_focus_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-error-bell")]
    pub fn connect_gtk_error_bell_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_error_bell_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-error-bell\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_error_bell_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-font-name")]
    pub fn connect_gtk_font_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_font_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-font-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_font_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-fontconfig-timestamp")]
    pub fn connect_gtk_fontconfig_timestamp_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_fontconfig_timestamp_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-fontconfig-timestamp\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_fontconfig_timestamp_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "gtk-hint-font-metrics")]
    pub fn connect_gtk_hint_font_metrics_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_hint_font_metrics_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-hint-font-metrics\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_hint_font_metrics_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-icon-theme-name")]
    pub fn connect_gtk_icon_theme_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_icon_theme_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-icon-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_icon_theme_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-im-module")]
    pub fn connect_gtk_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_im_module_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-im-module\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_im_module_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-keynav-use-caret")]
    pub fn connect_gtk_keynav_use_caret_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_keynav_use_caret_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-keynav-use-caret\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_keynav_use_caret_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-label-select-on-focus")]
    pub fn connect_gtk_label_select_on_focus_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_label_select_on_focus_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-label-select-on-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_label_select_on_focus_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-long-press-time")]
    pub fn connect_gtk_long_press_time_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_long_press_time_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-long-press-time\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_long_press_time_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-overlay-scrolling")]
    pub fn connect_gtk_overlay_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_overlay_scrolling_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-overlay-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_overlay_scrolling_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-primary-button-warps-slider")]
    pub fn connect_gtk_primary_button_warps_slider_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_primary_button_warps_slider_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-primary-button-warps-slider\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_primary_button_warps_slider_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-print-backends")]
    pub fn connect_gtk_print_backends_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_print_backends_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-print-backends\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_print_backends_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-print-preview-command")]
    pub fn connect_gtk_print_preview_command_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_print_preview_command_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-print-preview-command\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_print_preview_command_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-recent-files-enabled")]
    pub fn connect_gtk_recent_files_enabled_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_recent_files_enabled_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-recent-files-enabled\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_recent_files_enabled_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-recent-files-max-age")]
    pub fn connect_gtk_recent_files_max_age_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_recent_files_max_age_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-recent-files-max-age\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_recent_files_max_age_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-shell-shows-app-menu")]
    pub fn connect_gtk_shell_shows_app_menu_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_app_menu_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-shell-shows-app-menu\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_app_menu_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-shell-shows-desktop")]
    pub fn connect_gtk_shell_shows_desktop_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_desktop_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-shell-shows-desktop\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_desktop_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-shell-shows-menubar")]
    pub fn connect_gtk_shell_shows_menubar_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_shell_shows_menubar_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-shell-shows-menubar\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_shell_shows_menubar_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-sound-theme-name")]
    pub fn connect_gtk_sound_theme_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_sound_theme_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-sound-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_sound_theme_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-split-cursor")]
    pub fn connect_gtk_split_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_split_cursor_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-split-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_split_cursor_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-theme-name")]
    pub fn connect_gtk_theme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_theme_name_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-theme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_theme_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-titlebar-double-click")]
    pub fn connect_gtk_titlebar_double_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_double_click_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-titlebar-double-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_titlebar_double_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-titlebar-middle-click")]
    pub fn connect_gtk_titlebar_middle_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_middle_click_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-titlebar-middle-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_titlebar_middle_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-titlebar-right-click")]
    pub fn connect_gtk_titlebar_right_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_titlebar_right_click_trampoline<
            F: Fn(&Settings) + 'static,
        >(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-titlebar-right-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_titlebar_right_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-antialias")]
    pub fn connect_gtk_xft_antialias_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_antialias_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-antialias\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_antialias_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-dpi")]
    pub fn connect_gtk_xft_dpi_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_dpi_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-dpi\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_dpi_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-hinting")]
    pub fn connect_gtk_xft_hinting_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_hinting_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-hinting\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_hinting_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-hintstyle")]
    pub fn connect_gtk_xft_hintstyle_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_hintstyle_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-hintstyle\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_hintstyle_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gtk-xft-rgba")]
    pub fn connect_gtk_xft_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gtk_xft_rgba_trampoline<F: Fn(&Settings) + 'static>(
            this: *mut ffi::GtkSettings,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gtk-xft-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gtk_xft_rgba_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Settings`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SettingsBuilder {
    gtk_alternative_button_order: Option<bool>,
    gtk_alternative_sort_arrows: Option<bool>,
    gtk_application_prefer_dark_theme: Option<bool>,
    gtk_cursor_aspect_ratio: Option<f64>,
    gtk_cursor_blink: Option<bool>,
    gtk_cursor_blink_time: Option<i32>,
    gtk_cursor_blink_timeout: Option<i32>,
    gtk_cursor_theme_name: Option<String>,
    gtk_cursor_theme_size: Option<i32>,
    gtk_decoration_layout: Option<String>,
    gtk_dialogs_use_header: Option<bool>,
    gtk_dnd_drag_threshold: Option<i32>,
    gtk_double_click_distance: Option<i32>,
    gtk_double_click_time: Option<i32>,
    gtk_enable_accels: Option<bool>,
    gtk_enable_animations: Option<bool>,
    gtk_enable_event_sounds: Option<bool>,
    gtk_enable_input_feedback_sounds: Option<bool>,
    gtk_enable_primary_paste: Option<bool>,
    gtk_entry_password_hint_timeout: Option<u32>,
    gtk_entry_select_on_focus: Option<bool>,
    gtk_error_bell: Option<bool>,
    gtk_font_name: Option<String>,
    gtk_fontconfig_timestamp: Option<u32>,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    gtk_hint_font_metrics: Option<bool>,
    gtk_icon_theme_name: Option<String>,
    gtk_im_module: Option<String>,
    gtk_keynav_use_caret: Option<bool>,
    gtk_label_select_on_focus: Option<bool>,
    gtk_long_press_time: Option<u32>,
    gtk_overlay_scrolling: Option<bool>,
    gtk_primary_button_warps_slider: Option<bool>,
    gtk_print_backends: Option<String>,
    gtk_print_preview_command: Option<String>,
    gtk_recent_files_enabled: Option<bool>,
    gtk_recent_files_max_age: Option<i32>,
    gtk_shell_shows_app_menu: Option<bool>,
    gtk_shell_shows_desktop: Option<bool>,
    gtk_shell_shows_menubar: Option<bool>,
    gtk_sound_theme_name: Option<String>,
    gtk_split_cursor: Option<bool>,
    gtk_theme_name: Option<String>,
    gtk_titlebar_double_click: Option<String>,
    gtk_titlebar_middle_click: Option<String>,
    gtk_titlebar_right_click: Option<String>,
    gtk_xft_antialias: Option<i32>,
    gtk_xft_dpi: Option<i32>,
    gtk_xft_hinting: Option<i32>,
    gtk_xft_hintstyle: Option<String>,
    gtk_xft_rgba: Option<String>,
}

impl SettingsBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`SettingsBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Settings`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Settings {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref gtk_alternative_button_order) = self.gtk_alternative_button_order {
            properties.push(("gtk-alternative-button-order", gtk_alternative_button_order));
        }
        if let Some(ref gtk_alternative_sort_arrows) = self.gtk_alternative_sort_arrows {
            properties.push(("gtk-alternative-sort-arrows", gtk_alternative_sort_arrows));
        }
        if let Some(ref gtk_application_prefer_dark_theme) = self.gtk_application_prefer_dark_theme
        {
            properties.push((
                "gtk-application-prefer-dark-theme",
                gtk_application_prefer_dark_theme,
            ));
        }
        if let Some(ref gtk_cursor_aspect_ratio) = self.gtk_cursor_aspect_ratio {
            properties.push(("gtk-cursor-aspect-ratio", gtk_cursor_aspect_ratio));
        }
        if let Some(ref gtk_cursor_blink) = self.gtk_cursor_blink {
            properties.push(("gtk-cursor-blink", gtk_cursor_blink));
        }
        if let Some(ref gtk_cursor_blink_time) = self.gtk_cursor_blink_time {
            properties.push(("gtk-cursor-blink-time", gtk_cursor_blink_time));
        }
        if let Some(ref gtk_cursor_blink_timeout) = self.gtk_cursor_blink_timeout {
            properties.push(("gtk-cursor-blink-timeout", gtk_cursor_blink_timeout));
        }
        if let Some(ref gtk_cursor_theme_name) = self.gtk_cursor_theme_name {
            properties.push(("gtk-cursor-theme-name", gtk_cursor_theme_name));
        }
        if let Some(ref gtk_cursor_theme_size) = self.gtk_cursor_theme_size {
            properties.push(("gtk-cursor-theme-size", gtk_cursor_theme_size));
        }
        if let Some(ref gtk_decoration_layout) = self.gtk_decoration_layout {
            properties.push(("gtk-decoration-layout", gtk_decoration_layout));
        }
        if let Some(ref gtk_dialogs_use_header) = self.gtk_dialogs_use_header {
            properties.push(("gtk-dialogs-use-header", gtk_dialogs_use_header));
        }
        if let Some(ref gtk_dnd_drag_threshold) = self.gtk_dnd_drag_threshold {
            properties.push(("gtk-dnd-drag-threshold", gtk_dnd_drag_threshold));
        }
        if let Some(ref gtk_double_click_distance) = self.gtk_double_click_distance {
            properties.push(("gtk-double-click-distance", gtk_double_click_distance));
        }
        if let Some(ref gtk_double_click_time) = self.gtk_double_click_time {
            properties.push(("gtk-double-click-time", gtk_double_click_time));
        }
        if let Some(ref gtk_enable_accels) = self.gtk_enable_accels {
            properties.push(("gtk-enable-accels", gtk_enable_accels));
        }
        if let Some(ref gtk_enable_animations) = self.gtk_enable_animations {
            properties.push(("gtk-enable-animations", gtk_enable_animations));
        }
        if let Some(ref gtk_enable_event_sounds) = self.gtk_enable_event_sounds {
            properties.push(("gtk-enable-event-sounds", gtk_enable_event_sounds));
        }
        if let Some(ref gtk_enable_input_feedback_sounds) = self.gtk_enable_input_feedback_sounds {
            properties.push((
                "gtk-enable-input-feedback-sounds",
                gtk_enable_input_feedback_sounds,
            ));
        }
        if let Some(ref gtk_enable_primary_paste) = self.gtk_enable_primary_paste {
            properties.push(("gtk-enable-primary-paste", gtk_enable_primary_paste));
        }
        if let Some(ref gtk_entry_password_hint_timeout) = self.gtk_entry_password_hint_timeout {
            properties.push((
                "gtk-entry-password-hint-timeout",
                gtk_entry_password_hint_timeout,
            ));
        }
        if let Some(ref gtk_entry_select_on_focus) = self.gtk_entry_select_on_focus {
            properties.push(("gtk-entry-select-on-focus", gtk_entry_select_on_focus));
        }
        if let Some(ref gtk_error_bell) = self.gtk_error_bell {
            properties.push(("gtk-error-bell", gtk_error_bell));
        }
        if let Some(ref gtk_font_name) = self.gtk_font_name {
            properties.push(("gtk-font-name", gtk_font_name));
        }
        if let Some(ref gtk_fontconfig_timestamp) = self.gtk_fontconfig_timestamp {
            properties.push(("gtk-fontconfig-timestamp", gtk_fontconfig_timestamp));
        }
        #[cfg(any(feature = "v4_6", feature = "dox"))]
        if let Some(ref gtk_hint_font_metrics) = self.gtk_hint_font_metrics {
            properties.push(("gtk-hint-font-metrics", gtk_hint_font_metrics));
        }
        if let Some(ref gtk_icon_theme_name) = self.gtk_icon_theme_name {
            properties.push(("gtk-icon-theme-name", gtk_icon_theme_name));
        }
        if let Some(ref gtk_im_module) = self.gtk_im_module {
            properties.push(("gtk-im-module", gtk_im_module));
        }
        if let Some(ref gtk_keynav_use_caret) = self.gtk_keynav_use_caret {
            properties.push(("gtk-keynav-use-caret", gtk_keynav_use_caret));
        }
        if let Some(ref gtk_label_select_on_focus) = self.gtk_label_select_on_focus {
            properties.push(("gtk-label-select-on-focus", gtk_label_select_on_focus));
        }
        if let Some(ref gtk_long_press_time) = self.gtk_long_press_time {
            properties.push(("gtk-long-press-time", gtk_long_press_time));
        }
        if let Some(ref gtk_overlay_scrolling) = self.gtk_overlay_scrolling {
            properties.push(("gtk-overlay-scrolling", gtk_overlay_scrolling));
        }
        if let Some(ref gtk_primary_button_warps_slider) = self.gtk_primary_button_warps_slider {
            properties.push((
                "gtk-primary-button-warps-slider",
                gtk_primary_button_warps_slider,
            ));
        }
        if let Some(ref gtk_print_backends) = self.gtk_print_backends {
            properties.push(("gtk-print-backends", gtk_print_backends));
        }
        if let Some(ref gtk_print_preview_command) = self.gtk_print_preview_command {
            properties.push(("gtk-print-preview-command", gtk_print_preview_command));
        }
        if let Some(ref gtk_recent_files_enabled) = self.gtk_recent_files_enabled {
            properties.push(("gtk-recent-files-enabled", gtk_recent_files_enabled));
        }
        if let Some(ref gtk_recent_files_max_age) = self.gtk_recent_files_max_age {
            properties.push(("gtk-recent-files-max-age", gtk_recent_files_max_age));
        }
        if let Some(ref gtk_shell_shows_app_menu) = self.gtk_shell_shows_app_menu {
            properties.push(("gtk-shell-shows-app-menu", gtk_shell_shows_app_menu));
        }
        if let Some(ref gtk_shell_shows_desktop) = self.gtk_shell_shows_desktop {
            properties.push(("gtk-shell-shows-desktop", gtk_shell_shows_desktop));
        }
        if let Some(ref gtk_shell_shows_menubar) = self.gtk_shell_shows_menubar {
            properties.push(("gtk-shell-shows-menubar", gtk_shell_shows_menubar));
        }
        if let Some(ref gtk_sound_theme_name) = self.gtk_sound_theme_name {
            properties.push(("gtk-sound-theme-name", gtk_sound_theme_name));
        }
        if let Some(ref gtk_split_cursor) = self.gtk_split_cursor {
            properties.push(("gtk-split-cursor", gtk_split_cursor));
        }
        if let Some(ref gtk_theme_name) = self.gtk_theme_name {
            properties.push(("gtk-theme-name", gtk_theme_name));
        }
        if let Some(ref gtk_titlebar_double_click) = self.gtk_titlebar_double_click {
            properties.push(("gtk-titlebar-double-click", gtk_titlebar_double_click));
        }
        if let Some(ref gtk_titlebar_middle_click) = self.gtk_titlebar_middle_click {
            properties.push(("gtk-titlebar-middle-click", gtk_titlebar_middle_click));
        }
        if let Some(ref gtk_titlebar_right_click) = self.gtk_titlebar_right_click {
            properties.push(("gtk-titlebar-right-click", gtk_titlebar_right_click));
        }
        if let Some(ref gtk_xft_antialias) = self.gtk_xft_antialias {
            properties.push(("gtk-xft-antialias", gtk_xft_antialias));
        }
        if let Some(ref gtk_xft_dpi) = self.gtk_xft_dpi {
            properties.push(("gtk-xft-dpi", gtk_xft_dpi));
        }
        if let Some(ref gtk_xft_hinting) = self.gtk_xft_hinting {
            properties.push(("gtk-xft-hinting", gtk_xft_hinting));
        }
        if let Some(ref gtk_xft_hintstyle) = self.gtk_xft_hintstyle {
            properties.push(("gtk-xft-hintstyle", gtk_xft_hintstyle));
        }
        if let Some(ref gtk_xft_rgba) = self.gtk_xft_rgba {
            properties.push(("gtk-xft-rgba", gtk_xft_rgba));
        }
        glib::Object::new::<Settings>(&properties)
            .expect("Failed to create an instance of Settings")
    }

    pub fn gtk_alternative_button_order(mut self, gtk_alternative_button_order: bool) -> Self {
        self.gtk_alternative_button_order = Some(gtk_alternative_button_order);
        self
    }

    pub fn gtk_alternative_sort_arrows(mut self, gtk_alternative_sort_arrows: bool) -> Self {
        self.gtk_alternative_sort_arrows = Some(gtk_alternative_sort_arrows);
        self
    }

    pub fn gtk_application_prefer_dark_theme(
        mut self,
        gtk_application_prefer_dark_theme: bool,
    ) -> Self {
        self.gtk_application_prefer_dark_theme = Some(gtk_application_prefer_dark_theme);
        self
    }

    pub fn gtk_cursor_aspect_ratio(mut self, gtk_cursor_aspect_ratio: f64) -> Self {
        self.gtk_cursor_aspect_ratio = Some(gtk_cursor_aspect_ratio);
        self
    }

    pub fn gtk_cursor_blink(mut self, gtk_cursor_blink: bool) -> Self {
        self.gtk_cursor_blink = Some(gtk_cursor_blink);
        self
    }

    pub fn gtk_cursor_blink_time(mut self, gtk_cursor_blink_time: i32) -> Self {
        self.gtk_cursor_blink_time = Some(gtk_cursor_blink_time);
        self
    }

    pub fn gtk_cursor_blink_timeout(mut self, gtk_cursor_blink_timeout: i32) -> Self {
        self.gtk_cursor_blink_timeout = Some(gtk_cursor_blink_timeout);
        self
    }

    pub fn gtk_cursor_theme_name(mut self, gtk_cursor_theme_name: &str) -> Self {
        self.gtk_cursor_theme_name = Some(gtk_cursor_theme_name.to_string());
        self
    }

    pub fn gtk_cursor_theme_size(mut self, gtk_cursor_theme_size: i32) -> Self {
        self.gtk_cursor_theme_size = Some(gtk_cursor_theme_size);
        self
    }

    pub fn gtk_decoration_layout(mut self, gtk_decoration_layout: &str) -> Self {
        self.gtk_decoration_layout = Some(gtk_decoration_layout.to_string());
        self
    }

    pub fn gtk_dialogs_use_header(mut self, gtk_dialogs_use_header: bool) -> Self {
        self.gtk_dialogs_use_header = Some(gtk_dialogs_use_header);
        self
    }

    pub fn gtk_dnd_drag_threshold(mut self, gtk_dnd_drag_threshold: i32) -> Self {
        self.gtk_dnd_drag_threshold = Some(gtk_dnd_drag_threshold);
        self
    }

    pub fn gtk_double_click_distance(mut self, gtk_double_click_distance: i32) -> Self {
        self.gtk_double_click_distance = Some(gtk_double_click_distance);
        self
    }

    pub fn gtk_double_click_time(mut self, gtk_double_click_time: i32) -> Self {
        self.gtk_double_click_time = Some(gtk_double_click_time);
        self
    }

    pub fn gtk_enable_accels(mut self, gtk_enable_accels: bool) -> Self {
        self.gtk_enable_accels = Some(gtk_enable_accels);
        self
    }

    pub fn gtk_enable_animations(mut self, gtk_enable_animations: bool) -> Self {
        self.gtk_enable_animations = Some(gtk_enable_animations);
        self
    }

    pub fn gtk_enable_event_sounds(mut self, gtk_enable_event_sounds: bool) -> Self {
        self.gtk_enable_event_sounds = Some(gtk_enable_event_sounds);
        self
    }

    pub fn gtk_enable_input_feedback_sounds(
        mut self,
        gtk_enable_input_feedback_sounds: bool,
    ) -> Self {
        self.gtk_enable_input_feedback_sounds = Some(gtk_enable_input_feedback_sounds);
        self
    }

    pub fn gtk_enable_primary_paste(mut self, gtk_enable_primary_paste: bool) -> Self {
        self.gtk_enable_primary_paste = Some(gtk_enable_primary_paste);
        self
    }

    pub fn gtk_entry_password_hint_timeout(mut self, gtk_entry_password_hint_timeout: u32) -> Self {
        self.gtk_entry_password_hint_timeout = Some(gtk_entry_password_hint_timeout);
        self
    }

    pub fn gtk_entry_select_on_focus(mut self, gtk_entry_select_on_focus: bool) -> Self {
        self.gtk_entry_select_on_focus = Some(gtk_entry_select_on_focus);
        self
    }

    pub fn gtk_error_bell(mut self, gtk_error_bell: bool) -> Self {
        self.gtk_error_bell = Some(gtk_error_bell);
        self
    }

    pub fn gtk_font_name(mut self, gtk_font_name: &str) -> Self {
        self.gtk_font_name = Some(gtk_font_name.to_string());
        self
    }

    pub fn gtk_fontconfig_timestamp(mut self, gtk_fontconfig_timestamp: u32) -> Self {
        self.gtk_fontconfig_timestamp = Some(gtk_fontconfig_timestamp);
        self
    }

    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    pub fn gtk_hint_font_metrics(mut self, gtk_hint_font_metrics: bool) -> Self {
        self.gtk_hint_font_metrics = Some(gtk_hint_font_metrics);
        self
    }

    pub fn gtk_icon_theme_name(mut self, gtk_icon_theme_name: &str) -> Self {
        self.gtk_icon_theme_name = Some(gtk_icon_theme_name.to_string());
        self
    }

    pub fn gtk_im_module(mut self, gtk_im_module: &str) -> Self {
        self.gtk_im_module = Some(gtk_im_module.to_string());
        self
    }

    pub fn gtk_keynav_use_caret(mut self, gtk_keynav_use_caret: bool) -> Self {
        self.gtk_keynav_use_caret = Some(gtk_keynav_use_caret);
        self
    }

    pub fn gtk_label_select_on_focus(mut self, gtk_label_select_on_focus: bool) -> Self {
        self.gtk_label_select_on_focus = Some(gtk_label_select_on_focus);
        self
    }

    pub fn gtk_long_press_time(mut self, gtk_long_press_time: u32) -> Self {
        self.gtk_long_press_time = Some(gtk_long_press_time);
        self
    }

    pub fn gtk_overlay_scrolling(mut self, gtk_overlay_scrolling: bool) -> Self {
        self.gtk_overlay_scrolling = Some(gtk_overlay_scrolling);
        self
    }

    pub fn gtk_primary_button_warps_slider(
        mut self,
        gtk_primary_button_warps_slider: bool,
    ) -> Self {
        self.gtk_primary_button_warps_slider = Some(gtk_primary_button_warps_slider);
        self
    }

    pub fn gtk_print_backends(mut self, gtk_print_backends: &str) -> Self {
        self.gtk_print_backends = Some(gtk_print_backends.to_string());
        self
    }

    pub fn gtk_print_preview_command(mut self, gtk_print_preview_command: &str) -> Self {
        self.gtk_print_preview_command = Some(gtk_print_preview_command.to_string());
        self
    }

    pub fn gtk_recent_files_enabled(mut self, gtk_recent_files_enabled: bool) -> Self {
        self.gtk_recent_files_enabled = Some(gtk_recent_files_enabled);
        self
    }

    pub fn gtk_recent_files_max_age(mut self, gtk_recent_files_max_age: i32) -> Self {
        self.gtk_recent_files_max_age = Some(gtk_recent_files_max_age);
        self
    }

    pub fn gtk_shell_shows_app_menu(mut self, gtk_shell_shows_app_menu: bool) -> Self {
        self.gtk_shell_shows_app_menu = Some(gtk_shell_shows_app_menu);
        self
    }

    pub fn gtk_shell_shows_desktop(mut self, gtk_shell_shows_desktop: bool) -> Self {
        self.gtk_shell_shows_desktop = Some(gtk_shell_shows_desktop);
        self
    }

    pub fn gtk_shell_shows_menubar(mut self, gtk_shell_shows_menubar: bool) -> Self {
        self.gtk_shell_shows_menubar = Some(gtk_shell_shows_menubar);
        self
    }

    pub fn gtk_sound_theme_name(mut self, gtk_sound_theme_name: &str) -> Self {
        self.gtk_sound_theme_name = Some(gtk_sound_theme_name.to_string());
        self
    }

    pub fn gtk_split_cursor(mut self, gtk_split_cursor: bool) -> Self {
        self.gtk_split_cursor = Some(gtk_split_cursor);
        self
    }

    pub fn gtk_theme_name(mut self, gtk_theme_name: &str) -> Self {
        self.gtk_theme_name = Some(gtk_theme_name.to_string());
        self
    }

    pub fn gtk_titlebar_double_click(mut self, gtk_titlebar_double_click: &str) -> Self {
        self.gtk_titlebar_double_click = Some(gtk_titlebar_double_click.to_string());
        self
    }

    pub fn gtk_titlebar_middle_click(mut self, gtk_titlebar_middle_click: &str) -> Self {
        self.gtk_titlebar_middle_click = Some(gtk_titlebar_middle_click.to_string());
        self
    }

    pub fn gtk_titlebar_right_click(mut self, gtk_titlebar_right_click: &str) -> Self {
        self.gtk_titlebar_right_click = Some(gtk_titlebar_right_click.to_string());
        self
    }

    pub fn gtk_xft_antialias(mut self, gtk_xft_antialias: i32) -> Self {
        self.gtk_xft_antialias = Some(gtk_xft_antialias);
        self
    }

    pub fn gtk_xft_dpi(mut self, gtk_xft_dpi: i32) -> Self {
        self.gtk_xft_dpi = Some(gtk_xft_dpi);
        self
    }

    pub fn gtk_xft_hinting(mut self, gtk_xft_hinting: i32) -> Self {
        self.gtk_xft_hinting = Some(gtk_xft_hinting);
        self
    }

    pub fn gtk_xft_hintstyle(mut self, gtk_xft_hintstyle: &str) -> Self {
        self.gtk_xft_hintstyle = Some(gtk_xft_hintstyle.to_string());
        self
    }

    pub fn gtk_xft_rgba(mut self, gtk_xft_rgba: &str) -> Self {
        self.gtk_xft_rgba = Some(gtk_xft_rgba.to_string());
        self
    }
}

impl fmt::Display for Settings {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Settings")
    }
}
