/*
 * Copyright (C) 2020 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

using Folks;

public class Contacts.AddressbookDialog : Gtk.Dialog {

  private AccountsList accounts_list;

  public AddressbookDialog (Store contacts_store, Gtk.Window? window) {
    Object(
      modal: true,
      transient_for: window,
      title: _("Change Address Book"),
      use_header_bar: 1
    );

    add_buttons (_("Change"), Gtk.ResponseType.OK,
                 _("Cancel"), Gtk.ResponseType.CANCEL);

    var ok_button = get_widget_for_response (Gtk.ResponseType.OK);
    ok_button.sensitive = false;
    ok_button.get_style_context ().add_class ("suggested-action");

    var scrolled_window = new Gtk.ScrolledWindow ();
    scrolled_window.hexpand = true;
    scrolled_window.vexpand = true;
    scrolled_window.height_request = 300;
    scrolled_window.hscrollbar_policy = Gtk.PolicyType.NEVER;
    scrolled_window.propagate_natural_height = true;
    ((Gtk.Box) this.get_content_area ()).append (scrolled_window);

    var clamp = new Adw.Clamp ();
    clamp.margin_top = 32;
    clamp.margin_bottom = 32;
    clamp.margin_start = 12;
    clamp.margin_end = 12;
    clamp.maximum_size = 400;
    scrolled_window.set_child (clamp);

    var box = new Gtk.Box (Gtk.Orientation.VERTICAL, 12);
    box.valign = Gtk.Align.START;
    clamp.set_child (box);

    var explanation_label = new Gtk.Label (_("New contacts will be added to the selected address book.\nYou are able to view and edit contacts from other address books."));
    explanation_label.xalign = 0;
    explanation_label.wrap = true;
    box.append (explanation_label);

    this.accounts_list = new AccountsList (contacts_store);
    this.accounts_list.notify["selected-store"].connect ((obj, pspec) => {
      ok_button.sensitive = (this.accounts_list.selected_store != null);
    });

    box.append (this.accounts_list);
  }

  public override void response (int response) {
    if (response != Gtk.ResponseType.OK)
      return;

    unowned var e_store = (Edsf.PersonaStore) this.accounts_list.selected_store;
    if (e_store != null)
      Utils.set_primary_store (e_store);
  }
}
