// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Animation;
use crate::AnimationTarget;
use crate::SpringParams;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "AdwSpringAnimation")]
    pub struct SpringAnimation(Object<ffi::AdwSpringAnimation, ffi::AdwSpringAnimationClass>) @extends Animation;

    match fn {
        type_ => || ffi::adw_spring_animation_get_type(),
    }
}

impl SpringAnimation {
    #[doc(alias = "adw_spring_animation_new")]
    pub fn new(
        widget: &impl IsA<gtk::Widget>,
        from: f64,
        to: f64,
        spring_params: &SpringParams,
        target: &impl IsA<AnimationTarget>,
    ) -> SpringAnimation {
        skip_assert_initialized!();
        unsafe {
            Animation::from_glib_none(ffi::adw_spring_animation_new(
                widget.as_ref().to_glib_none().0,
                from,
                to,
                spring_params.to_glib_full(),
                target.as_ref().to_glib_full(),
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SpringAnimation`] objects.
    ///
    /// This method returns an instance of [`SpringAnimationBuilder`](crate::builders::SpringAnimationBuilder) which can be used to create [`SpringAnimation`] objects.
    pub fn builder() -> SpringAnimationBuilder {
        SpringAnimationBuilder::default()
    }

    #[doc(alias = "adw_spring_animation_get_clamp")]
    #[doc(alias = "get_clamp")]
    pub fn is_clamp(&self) -> bool {
        unsafe { from_glib(ffi::adw_spring_animation_get_clamp(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_spring_animation_get_epsilon")]
    #[doc(alias = "get_epsilon")]
    pub fn epsilon(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_epsilon(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_estimated_duration")]
    #[doc(alias = "get_estimated_duration")]
    pub fn estimated_duration(&self) -> u32 {
        unsafe { ffi::adw_spring_animation_get_estimated_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_initial_velocity")]
    #[doc(alias = "get_initial_velocity")]
    pub fn initial_velocity(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_initial_velocity(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_spring_params")]
    #[doc(alias = "get_spring_params")]
    pub fn spring_params(&self) -> SpringParams {
        unsafe {
            from_glib_none(ffi::adw_spring_animation_get_spring_params(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_spring_animation_get_value_from")]
    #[doc(alias = "get_value_from")]
    pub fn value_from(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_value_from(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_value_to")]
    #[doc(alias = "get_value_to")]
    pub fn value_to(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_value_to(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_get_velocity")]
    #[doc(alias = "get_velocity")]
    pub fn velocity(&self) -> f64 {
        unsafe { ffi::adw_spring_animation_get_velocity(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_spring_animation_set_clamp")]
    pub fn set_clamp(&self, clamp: bool) {
        unsafe {
            ffi::adw_spring_animation_set_clamp(self.to_glib_none().0, clamp.into_glib());
        }
    }

    #[doc(alias = "adw_spring_animation_set_epsilon")]
    pub fn set_epsilon(&self, epsilon: f64) {
        unsafe {
            ffi::adw_spring_animation_set_epsilon(self.to_glib_none().0, epsilon);
        }
    }

    #[doc(alias = "adw_spring_animation_set_initial_velocity")]
    pub fn set_initial_velocity(&self, velocity: f64) {
        unsafe {
            ffi::adw_spring_animation_set_initial_velocity(self.to_glib_none().0, velocity);
        }
    }

    #[doc(alias = "adw_spring_animation_set_spring_params")]
    pub fn set_spring_params(&self, spring_params: &SpringParams) {
        unsafe {
            ffi::adw_spring_animation_set_spring_params(
                self.to_glib_none().0,
                spring_params.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_spring_animation_set_value_from")]
    pub fn set_value_from(&self, value: f64) {
        unsafe {
            ffi::adw_spring_animation_set_value_from(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "adw_spring_animation_set_value_to")]
    pub fn set_value_to(&self, value: f64) {
        unsafe {
            ffi::adw_spring_animation_set_value_to(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "clamp")]
    pub fn connect_clamp_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_clamp_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::clamp\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_clamp_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "epsilon")]
    pub fn connect_epsilon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_epsilon_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::epsilon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_epsilon_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "estimated-duration")]
    pub fn connect_estimated_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_estimated_duration_trampoline<
            F: Fn(&SpringAnimation) + 'static,
        >(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::estimated-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_estimated_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "initial-velocity")]
    pub fn connect_initial_velocity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_initial_velocity_trampoline<
            F: Fn(&SpringAnimation) + 'static,
        >(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::initial-velocity\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_initial_velocity_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "spring-params")]
    pub fn connect_spring_params_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spring_params_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::spring-params\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_spring_params_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value-from")]
    pub fn connect_value_from_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_from_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::value-from\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_value_from_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "value-to")]
    pub fn connect_value_to_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_value_to_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::value-to\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_value_to_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "velocity")]
    pub fn connect_velocity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_velocity_trampoline<F: Fn(&SpringAnimation) + 'static>(
            this: *mut ffi::AdwSpringAnimation,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::velocity\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_velocity_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for SpringAnimation {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct SpringAnimation object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SpringAnimation`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SpringAnimationBuilder {
    clamp: Option<bool>,
    epsilon: Option<f64>,
    initial_velocity: Option<f64>,
    spring_params: Option<SpringParams>,
    value_from: Option<f64>,
    value_to: Option<f64>,
    target: Option<AnimationTarget>,
    widget: Option<gtk::Widget>,
}

impl SpringAnimationBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`SpringAnimationBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SpringAnimation`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SpringAnimation {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref clamp) = self.clamp {
            properties.push(("clamp", clamp));
        }
        if let Some(ref epsilon) = self.epsilon {
            properties.push(("epsilon", epsilon));
        }
        if let Some(ref initial_velocity) = self.initial_velocity {
            properties.push(("initial-velocity", initial_velocity));
        }
        if let Some(ref spring_params) = self.spring_params {
            properties.push(("spring-params", spring_params));
        }
        if let Some(ref value_from) = self.value_from {
            properties.push(("value-from", value_from));
        }
        if let Some(ref value_to) = self.value_to {
            properties.push(("value-to", value_to));
        }
        if let Some(ref target) = self.target {
            properties.push(("target", target));
        }
        if let Some(ref widget) = self.widget {
            properties.push(("widget", widget));
        }
        glib::Object::new::<SpringAnimation>(&properties)
            .expect("Failed to create an instance of SpringAnimation")
    }

    pub fn clamp(mut self, clamp: bool) -> Self {
        self.clamp = Some(clamp);
        self
    }

    pub fn epsilon(mut self, epsilon: f64) -> Self {
        self.epsilon = Some(epsilon);
        self
    }

    pub fn initial_velocity(mut self, initial_velocity: f64) -> Self {
        self.initial_velocity = Some(initial_velocity);
        self
    }

    pub fn spring_params(mut self, spring_params: &SpringParams) -> Self {
        self.spring_params = Some(spring_params.clone());
        self
    }

    pub fn value_from(mut self, value_from: f64) -> Self {
        self.value_from = Some(value_from);
        self
    }

    pub fn value_to(mut self, value_to: f64) -> Self {
        self.value_to = Some(value_to);
        self
    }

    pub fn target(mut self, target: &impl IsA<AnimationTarget>) -> Self {
        self.target = Some(target.clone().upcast());
        self
    }

    pub fn widget(mut self, widget: &impl IsA<gtk::Widget>) -> Self {
        self.widget = Some(widget.clone().upcast());
        self
    }
}

impl fmt::Display for SpringAnimation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SpringAnimation")
    }
}
