/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);
static GType vala_field_get_type_once (void);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	gboolean _tmp45_ = FALSE;
	ValaAttribute* _tmp46_;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	gboolean _tmp57_;
	gboolean _tmp58_;
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp85_;
	ValaDataType* _tmp86_;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp89_ = FALSE;
	ValaArrayType* _tmp90_;
	gboolean _tmp102_ = FALSE;
	gboolean _tmp103_ = FALSE;
	ValaArrayType* _tmp104_;
	ValaExpression* _tmp113_;
	ValaExpression* _tmp114_;
	gboolean _tmp235_ = FALSE;
	ValaMemberBinding _tmp236_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp241_;
	ValaSymbol* _tmp242_;
	gboolean _tmp251_ = FALSE;
	gboolean _tmp252_ = FALSE;
	gboolean _tmp253_;
	gboolean _tmp254_;
	ValaSemanticAnalyzer* _tmp267_;
	ValaSemanticAnalyzer* _tmp268_;
	ValaSourceFile* _tmp269_;
	ValaSemanticAnalyzer* _tmp270_;
	ValaSemanticAnalyzer* _tmp271_;
	ValaSymbol* _tmp272_;
	gboolean _tmp273_;
	gboolean _tmp274_;
	gboolean result;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_type_symbol (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_type_symbol (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_type_symbol (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		vala_report_error (_tmp38_, "`%s' not supported as field type", _tmp44_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp46_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkChild");
	if (_tmp46_ != NULL) {
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_data_type_get_value_owned (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp45_ = _tmp50_;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		ValaSourceReference* _tmp51_;
		ValaSourceReference* _tmp52_;
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp52_ = _tmp51_;
		vala_report_warning (_tmp52_, "[GtkChild] fields must be declared as `unowned'");
		_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		vala_data_type_set_value_owned (_tmp54_, FALSE);
	}
	_tmp55_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp56_ = _tmp55_;
	vala_code_node_check ((ValaCodeNode*) _tmp56_, context);
	_tmp57_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp58_ = _tmp57_;
	if (!_tmp58_) {
		ValaSemanticAnalyzer* _tmp59_;
		ValaSemanticAnalyzer* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaTypeSymbol* _tmp65_;
		ValaTypeSymbol* _tmp66_;
		_tmp59_ = vala_code_context_get_analyzer (context);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp62_ = _tmp61_;
		vala_semantic_analyzer_check_type (_tmp60_, _tmp62_);
		_tmp63_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_data_type_get_type_symbol (_tmp64_);
		_tmp66_ = _tmp65_;
		if (_tmp66_ != NULL) {
			ValaDataType* _tmp67_;
			ValaDataType* _tmp68_;
			ValaTypeSymbol* _tmp69_;
			ValaTypeSymbol* _tmp70_;
			ValaVersionAttribute* _tmp71_;
			ValaVersionAttribute* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			_tmp67_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_data_type_get_type_symbol (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_symbol_get_version ((ValaSymbol*) _tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp74_ = _tmp73_;
			vala_version_attribute_check (_tmp72_, context, _tmp74_);
		}
	}
	_tmp75_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp76_ = _tmp75_;
	if (!vala_data_type_is_accessible (_tmp76_, (ValaSymbol*) self)) {
		ValaSourceReference* _tmp77_;
		ValaSourceReference* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_code_node_to_string ((ValaCodeNode*) _tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp84_ = _tmp83_;
		vala_report_error (_tmp78_, "field type `%s' is less accessible than field `%s'", _tmp82_, _tmp84_);
		_g_free0 (_tmp84_);
		_g_free0 (_tmp82_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp85_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp86_ = _tmp85_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp86_) ? ((ValaArrayType*) _tmp86_) : NULL;
	_tmp90_ = variable_array_type;
	if (_tmp90_ != NULL) {
		ValaArrayType* _tmp91_;
		gboolean _tmp92_;
		gboolean _tmp93_;
		_tmp91_ = variable_array_type;
		_tmp92_ = vala_array_type_get_inline_allocated (_tmp91_);
		_tmp93_ = _tmp92_;
		_tmp89_ = _tmp93_;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		ValaExpression* _tmp94_;
		ValaExpression* _tmp95_;
		_tmp94_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp95_ = _tmp94_;
		_tmp88_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp95_);
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		ValaInitializerList* _tmp98_;
		ValaInitializerList* _tmp99_;
		_tmp96_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp99_ = _tmp98_;
		_tmp87_ = _tmp99_ == NULL;
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		ValaSourceReference* _tmp100_;
		ValaSourceReference* _tmp101_;
		_tmp100_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp101_ = _tmp100_;
		vala_report_warning (_tmp101_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp104_ = variable_array_type;
	if (_tmp104_ != NULL) {
		ValaArrayType* _tmp105_;
		gboolean _tmp106_;
		gboolean _tmp107_;
		_tmp105_ = variable_array_type;
		_tmp106_ = vala_array_type_get_inline_allocated (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp103_ = _tmp107_;
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		ValaArrayType* _tmp108_;
		gboolean _tmp109_;
		gboolean _tmp110_;
		_tmp108_ = variable_array_type;
		_tmp109_ = vala_array_type_get_fixed_length (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp102_ = !_tmp110_;
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		ValaSourceReference* _tmp111_;
		ValaSourceReference* _tmp112_;
		_tmp111_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp112_ = _tmp111_;
		vala_report_error (_tmp112_, "Inline allocated array as field requires to have fixed length");
	}
	_tmp113_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp114_ = _tmp113_;
	if (_tmp114_ != NULL) {
		ValaExpression* _tmp115_;
		ValaExpression* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaDataType* _tmp129_;
		ValaDataType* _tmp130_;
		ValaExpression* _tmp133_;
		ValaExpression* _tmp134_;
		ValaDataType* _tmp135_;
		ValaDataType* _tmp136_;
		ValaDataType* _tmp137_;
		ValaDataType* _tmp138_;
		gboolean _tmp151_ = FALSE;
		gboolean _tmp152_ = FALSE;
		gboolean _tmp153_ = FALSE;
		ValaArrayType* _tmp154_;
		gboolean _tmp168_ = FALSE;
		gboolean _tmp169_ = FALSE;
		ValaArrayType* _tmp170_;
		ValaExpression* _tmp180_;
		ValaExpression* _tmp181_;
		ValaDataType* _tmp182_;
		ValaDataType* _tmp183_;
		gboolean _tmp193_ = FALSE;
		ValaSymbol* _tmp194_;
		ValaSymbol* _tmp195_;
		gboolean _tmp200_ = FALSE;
		gboolean _tmp201_ = FALSE;
		ValaSymbol* _tmp202_;
		ValaSymbol* _tmp203_;
		gboolean _tmp217_ = FALSE;
		gboolean _tmp218_ = FALSE;
		gboolean _tmp219_ = FALSE;
		ValaMemberBinding _tmp220_;
		gboolean _tmp231_;
		gboolean _tmp232_;
		_tmp115_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type (_tmp116_, _tmp118_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp119_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp120_ = _tmp119_;
		if (VALA_IS_INITIALIZER_LIST (_tmp120_)) {
			ValaExpression* _tmp121_;
			ValaExpression* _tmp122_;
			gint _tmp123_;
			gint _tmp124_;
			_tmp121_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp124_ = _tmp123_;
			initializer_size = _tmp124_;
			is_initializer_list = TRUE;
		}
		_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp126_ = _tmp125_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp126_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp127_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_expression_get_value_type (_tmp128_);
		_tmp130_ = _tmp129_;
		if (_tmp130_ == NULL) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp132_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp133_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp134_ = _tmp133_;
		_tmp135_ = vala_expression_get_value_type (_tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp138_ = _tmp137_;
		if (!vala_data_type_compatible (_tmp136_, _tmp138_)) {
			ValaSourceReference* _tmp139_;
			ValaSourceReference* _tmp140_;
			ValaExpression* _tmp141_;
			ValaExpression* _tmp142_;
			ValaDataType* _tmp143_;
			ValaDataType* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			gchar* _tmp149_;
			gchar* _tmp150_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_expression_get_value_type (_tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_code_node_to_string ((ValaCodeNode*) _tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_code_node_to_string ((ValaCodeNode*) _tmp148_);
			_tmp150_ = _tmp149_;
			vala_report_error (_tmp140_, "Cannot convert from `%s' to `%s'", _tmp146_, _tmp150_);
			_g_free0 (_tmp150_);
			_g_free0 (_tmp146_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp154_ = variable_array_type;
		if (_tmp154_ != NULL) {
			ValaArrayType* _tmp155_;
			gboolean _tmp156_;
			gboolean _tmp157_;
			_tmp155_ = variable_array_type;
			_tmp156_ = vala_array_type_get_inline_allocated (_tmp155_);
			_tmp157_ = _tmp156_;
			_tmp153_ = _tmp157_;
		} else {
			_tmp153_ = FALSE;
		}
		if (_tmp153_) {
			ValaArrayType* _tmp158_;
			gboolean _tmp159_;
			gboolean _tmp160_;
			_tmp158_ = variable_array_type;
			_tmp159_ = vala_array_type_get_fixed_length (_tmp158_);
			_tmp160_ = _tmp159_;
			_tmp152_ = !_tmp160_;
		} else {
			_tmp152_ = FALSE;
		}
		if (_tmp152_) {
			_tmp151_ = is_initializer_list;
		} else {
			_tmp151_ = FALSE;
		}
		if (_tmp151_) {
			ValaArrayType* _tmp161_;
			gchar* _tmp162_;
			gchar* _tmp163_;
			ValaIntegerLiteral* _tmp164_;
			ValaIntegerLiteral* _tmp165_;
			ValaArrayType* _tmp166_;
			ValaArrayType* _tmp167_;
			_tmp161_ = variable_array_type;
			_tmp162_ = g_strdup_printf ("%i", initializer_size);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_integer_literal_new (_tmp163_, NULL);
			_tmp165_ = _tmp164_;
			vala_array_type_set_length (_tmp161_, (ValaExpression*) _tmp165_);
			_vala_code_node_unref0 (_tmp165_);
			_g_free0 (_tmp163_);
			_tmp166_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp166_, TRUE);
			_tmp167_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp167_, FALSE);
		}
		_tmp170_ = variable_array_type;
		if (_tmp170_ != NULL) {
			ValaArrayType* _tmp171_;
			gboolean _tmp172_;
			gboolean _tmp173_;
			_tmp171_ = variable_array_type;
			_tmp172_ = vala_array_type_get_inline_allocated (_tmp171_);
			_tmp173_ = _tmp172_;
			_tmp169_ = _tmp173_;
		} else {
			_tmp169_ = FALSE;
		}
		if (_tmp169_) {
			ValaExpression* _tmp174_;
			ValaExpression* _tmp175_;
			ValaDataType* _tmp176_;
			ValaDataType* _tmp177_;
			_tmp174_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp175_ = _tmp174_;
			_tmp176_ = vala_expression_get_value_type (_tmp175_);
			_tmp177_ = _tmp176_;
			_tmp168_ = !VALA_IS_ARRAY_TYPE (_tmp177_);
		} else {
			_tmp168_ = FALSE;
		}
		if (_tmp168_) {
			ValaSourceReference* _tmp178_;
			ValaSourceReference* _tmp179_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp179_ = _tmp178_;
			vala_report_error (_tmp179_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp180_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_expression_get_value_type (_tmp181_);
		_tmp183_ = _tmp182_;
		if (vala_data_type_is_disposable (_tmp183_)) {
			gboolean _tmp184_ = FALSE;
			ValaDataType* _tmp185_;
			ValaDataType* _tmp186_;
			_tmp185_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp186_ = _tmp185_;
			if (!VALA_IS_POINTER_TYPE (_tmp186_)) {
				ValaDataType* _tmp187_;
				ValaDataType* _tmp188_;
				gboolean _tmp189_;
				gboolean _tmp190_;
				_tmp187_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp188_ = _tmp187_;
				_tmp189_ = vala_data_type_get_value_owned (_tmp188_);
				_tmp190_ = _tmp189_;
				_tmp184_ = !_tmp190_;
			} else {
				_tmp184_ = FALSE;
			}
			if (_tmp184_) {
				ValaSourceReference* _tmp191_;
				ValaSourceReference* _tmp192_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp192_ = _tmp191_;
				vala_report_error (_tmp192_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp194_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp195_ = _tmp194_;
		if (VALA_IS_NAMESPACE (_tmp195_)) {
			ValaExpression* _tmp196_;
			ValaExpression* _tmp197_;
			_tmp196_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp197_ = _tmp196_;
			_tmp193_ = !vala_expression_is_constant (_tmp197_);
		} else {
			_tmp193_ = FALSE;
		}
		if (_tmp193_) {
			ValaSourceReference* _tmp198_;
			ValaSourceReference* _tmp199_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp199_ = _tmp198_;
			vala_report_error (_tmp199_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp202_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp203_ = _tmp202_;
		if (VALA_IS_NAMESPACE (_tmp203_)) {
			ValaExpression* _tmp204_;
			ValaExpression* _tmp205_;
			_tmp204_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp205_ = _tmp204_;
			_tmp201_ = vala_expression_is_constant (_tmp205_);
		} else {
			_tmp201_ = FALSE;
		}
		if (_tmp201_) {
			ValaExpression* _tmp206_;
			ValaExpression* _tmp207_;
			_tmp206_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp207_ = _tmp206_;
			_tmp200_ = vala_expression_is_non_null (_tmp207_);
		} else {
			_tmp200_ = FALSE;
		}
		if (_tmp200_) {
			gboolean _tmp208_ = FALSE;
			ValaDataType* _tmp209_;
			ValaDataType* _tmp210_;
			_tmp209_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp210_ = _tmp209_;
			if (vala_data_type_is_disposable (_tmp210_)) {
				ValaDataType* _tmp211_;
				ValaDataType* _tmp212_;
				gboolean _tmp213_;
				gboolean _tmp214_;
				_tmp211_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_data_type_get_value_owned (_tmp212_);
				_tmp214_ = _tmp213_;
				_tmp208_ = _tmp214_;
			} else {
				_tmp208_ = FALSE;
			}
			if (_tmp208_) {
				ValaSourceReference* _tmp215_;
				ValaSourceReference* _tmp216_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp216_ = _tmp215_;
				vala_report_error (_tmp216_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp220_ = self->priv->_binding;
		if (_tmp220_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp221_;
			ValaSymbol* _tmp222_;
			_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp222_ = _tmp221_;
			_tmp219_ = VALA_IS_CLASS (_tmp222_);
		} else {
			_tmp219_ = FALSE;
		}
		if (_tmp219_) {
			ValaSymbol* _tmp223_;
			ValaSymbol* _tmp224_;
			gboolean _tmp225_;
			gboolean _tmp226_;
			_tmp223_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp224_ = _tmp223_;
			_tmp225_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp224_, VALA_TYPE_CLASS, ValaClass));
			_tmp226_ = _tmp225_;
			_tmp218_ = _tmp226_;
		} else {
			_tmp218_ = FALSE;
		}
		if (_tmp218_) {
			ValaExpression* _tmp227_;
			ValaExpression* _tmp228_;
			_tmp227_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp228_ = _tmp227_;
			_tmp217_ = !vala_expression_is_constant (_tmp228_);
		} else {
			_tmp217_ = FALSE;
		}
		if (_tmp217_) {
			ValaSourceReference* _tmp229_;
			ValaSourceReference* _tmp230_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp229_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp230_ = _tmp229_;
			vala_report_error (_tmp230_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp231_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp232_ = _tmp231_;
		if (_tmp232_) {
			ValaSourceReference* _tmp233_;
			ValaSourceReference* _tmp234_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp233_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp234_ = _tmp233_;
			vala_report_error (_tmp234_, "External fields cannot use initializers");
		}
	}
	_tmp236_ = self->priv->_binding;
	if (_tmp236_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp237_;
		ValaSymbol* _tmp238_;
		_tmp237_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp238_ = _tmp237_;
		_tmp235_ = VALA_IS_INTERFACE (_tmp238_);
	} else {
		_tmp235_ = FALSE;
	}
	if (_tmp235_) {
		ValaSourceReference* _tmp239_;
		ValaSourceReference* _tmp240_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp239_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp240_ = _tmp239_;
		vala_report_error (_tmp240_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp241_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp242_ = _tmp241_;
	if (VALA_IS_CLASS (_tmp242_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp243_;
		ValaSymbol* _tmp244_;
		ValaClass* _tmp245_;
		gboolean _tmp246_ = FALSE;
		ValaClass* _tmp247_;
		gboolean _tmp248_;
		gboolean _tmp249_;
		_tmp243_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp244_ = _tmp243_;
		_tmp245_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp244_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp245_;
		_tmp247_ = cl;
		_tmp248_ = vala_class_get_is_compact (_tmp247_);
		_tmp249_ = _tmp248_;
		if (_tmp249_) {
			ValaClass* _tmp250_;
			_tmp250_ = cl;
			_tmp246_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp250_);
		} else {
			_tmp246_ = FALSE;
		}
		if (_tmp246_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp253_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp254_ = _tmp253_;
	if (!_tmp254_) {
		gboolean _tmp255_;
		gboolean _tmp256_;
		_tmp255_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp256_ = _tmp255_;
		_tmp252_ = !_tmp256_;
	} else {
		_tmp252_ = FALSE;
	}
	if (_tmp252_) {
		ValaSymbol* _tmp257_;
		ValaSymbol* _tmp258_;
		_tmp257_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp258_ = _tmp257_;
		_tmp251_ = _tmp258_ != NULL;
		_vala_code_node_unref0 (_tmp258_);
	} else {
		_tmp251_ = FALSE;
	}
	if (_tmp251_) {
		ValaSourceReference* _tmp259_;
		ValaSourceReference* _tmp260_;
		gchar* _tmp261_;
		gchar* _tmp262_;
		ValaSymbol* _tmp263_;
		ValaSymbol* _tmp264_;
		gchar* _tmp265_;
		gchar* _tmp266_;
		_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp262_ = _tmp261_;
		_tmp263_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp264_ = _tmp263_;
		_tmp265_ = vala_symbol_get_full_name (_tmp264_);
		_tmp266_ = _tmp265_;
		vala_report_warning (_tmp260_, "%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp262_, _tmp266_);
		_g_free0 (_tmp266_);
		_vala_code_node_unref0 (_tmp264_);
		_g_free0 (_tmp262_);
	}
	_tmp267_ = vala_code_context_get_analyzer (context);
	_tmp268_ = _tmp267_;
	_tmp269_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp268_, _tmp269_);
	_tmp270_ = vala_code_context_get_analyzer (context);
	_tmp271_ = _tmp270_;
	_tmp272_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp271_, _tmp272_);
	_tmp273_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp274_ = _tmp273_;
	result = !_tmp274_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
static GType
vala_field_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
	static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_field_type_id;
	vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
	g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
	return vala_field_type_id;
}

GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__once = 0;
	if (g_once_init_enter (&vala_field_type_id__once)) {
		GType vala_field_type_id;
		vala_field_type_id = vala_field_get_type_once ();
		g_once_init_leave (&vala_field_type_id__once, vala_field_type_id);
	}
	return vala_field_type_id__once;
}

