/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala.h>
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <gidlmodule.h>
#include <gidlparser.h>
#include <gidlnode.h>
#include <float.h>
#include <math.h>
#include <gmetadata.h>
#include <errno.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	ValaMap* codenode_attributes_map;
	ValaMap* codenode_attributes_patterns;
	ValaSet* current_type_symbol_set;
	ValaMap* cname_type_map;
};

static gint ValaGIdlParser_private_offset;
static gpointer vala_gidl_parser_parent_class = NULL;
static GRegex* vala_gidl_parser_type_from_string_regex;
static GRegex* vala_gidl_parser_type_from_string_regex = NULL;

VALA_EXTERN GType vala_gidl_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaGIdlParser, vala_code_visitor_unref)
VALA_EXTERN void vala_gidl_parser_parse (ValaGIdlParser* self,
                             ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base,
                                            ValaNamespace* ns);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base,
                                        ValaClass* cl);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self,
                                  ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base,
                                         ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base,
                                            ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base,
                                       ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base,
                                               ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base,
                                           ValaDelegate* d);
static gchar* vala_gidl_parser_get_cname (ValaGIdlParser* self,
                                   ValaSymbol* sym,
                                   ValaSymbol* container);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base,
                                              ValaSourceFile* source_file);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self,
                                  ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self,
                                              GIdlModule* module);
static void _g_idl_module_free0_ (gpointer var);
static inline void _g_list_free__g_idl_module_free0_ (GList* self);
static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self,
                                       const gchar* type_name,
                                       ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self,
                                         const gchar* codenode,
                                         gint* result_length1);
static gchar* vala_gidl_parser_eval (ValaGIdlParser* self,
                              const gchar* s);
VALA_EXTERN gchar* vala_gidl_parser_get_cprefix (ValaGIdlParser* self,
                                     ValaSymbol* sym);
static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self,
                                        const gchar* const_name,
                                        ValaSymbol* container);
static gchar* vala_gidl_parser_get_lower_case_cprefix (ValaGIdlParser* self,
                                                ValaSymbol* sym);
static gchar* vala_gidl_parser_get_cheader_filename (ValaGIdlParser* self,
                                              ValaSymbol* sym);
static gchar* vala_gidl_parser_get_finish_cname (ValaGIdlParser* self,
                                          ValaMethod* m);
static gchar* vala_gidl_parser_get_lower_case_cname (ValaGIdlParser* self,
                                              ValaSymbol* sym);
static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self,
                                                  GIdlNode* node,
                                                  gint* result_length1);
static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self,
                                               ValaSymbol* container,
                                               ValaSymbol* sym);
static void vala_gidl_parser_parse_node (ValaGIdlParser* self,
                                  GIdlNode* node,
                                  GIdlModule* module,
                                  ValaSymbol* container);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self,
                                               GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self,
                                    GIdlNodeStruct* st_node,
                                    ValaSymbol* container,
                                    GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self,
                                   GIdlNodeUnion* un_node,
                                   ValaSymbol* container,
                                   GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self,
                                   GIdlNodeBoxed* boxed_node,
                                   ValaSymbol* container,
                                   GIdlModule* module);
static void vala_gidl_parser_parse_enum (ValaGIdlParser* self,
                                  GIdlNodeEnum* en_node,
                                  ValaSymbol* container,
                                  GIdlModule* module,
                                  gboolean is_flags);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self,
                                    GIdlNodeInterface* node,
                                    ValaSymbol* container,
                                    GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self,
                                       GIdlNodeInterface* node,
                                       ValaSymbol* container,
                                       GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self,
                                               GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self,
                                             GIdlNodeFunction* f,
                                             gboolean is_interface);
static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self,
                                                      const gchar* name);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self,
                                            GIdlNodeParam* param,
                                            ValaParameterDirection* direction);
static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self,
                                                       const gchar* type_string,
                                                       gboolean owned_by_default,
                                                       ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self,
                                                            ValaDataType* parent_type,
                                                            const gchar* type_arguments,
                                                            ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self,
                                              GIdlNodeParam* param);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self,
                                           GIdlNodeType* type_node,
                                           ValaParameterDirection* direction);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self,
                                             const gchar* cname);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self,
                                                  const gchar* n);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self,
                                         GIdlNodeField* field_node);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self,
                                            GIdlNodeVFunc* v,
                                            GIdlNodeFunction* func,
                                            gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self,
                                               GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self,
                                           GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self,
                                            ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self,
                                          const gchar* type_name);
static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self,
                                                                 const gchar* symbol_string,
                                                                 ValaSourceReference* source_reference);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self,
                                            const gchar* name,
                                            const gchar* symbol,
                                            GIdlNodeParam* res,
                                            GList* parameters,
                                            gboolean is_constructor,
                                            gboolean is_interface);
static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self,
                                       const gchar* name);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
VALA_EXTERN ValaGIdlParser* vala_gidl_parser_new (void);
VALA_EXTERN ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor * obj);
static GType vala_gidl_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
vala_gidl_parser_get_instance_private (ValaGIdlParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGIdlParser_private_offset);
}

/**
 * Parse all source files in the specified code context and build a
 * code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

void
vala_gidl_parser_parse (ValaGIdlParser* self,
                        ValaCodeContext* context)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	ValaCodeContext* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = (ValaMap*) _tmp3_;
	_tmp4_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp4_;
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = NULL;
}

static void
vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base,
                                       ValaNamespace* ns)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
}

static void
vala_gidl_parser_real_visit_class (ValaCodeVisitor* base,
                                   ValaClass* cl)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) cl);
}

static void
vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base,
                                    ValaStruct* st)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) st);
}

static void
vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base,
                                       ValaInterface* iface)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) iface);
}

static void
vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base,
                                  ValaEnum* en)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) en);
}

static void
vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base,
                                          ValaErrorDomain* ed)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) ed);
}

static void
vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base,
                                      ValaDelegate* d)
{
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) d);
}

static void
vala_gidl_parser_visit_type (ValaGIdlParser* self,
                             ValaTypeSymbol* t)
{
	ValaMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->cname_type_map;
	_tmp1_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) t, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = !vala_map_contains (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaMap* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->cname_type_map;
		_tmp5_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) t, NULL);
		_tmp6_ = _tmp5_;
		vala_map_set (_tmp4_, _tmp6_, t);
		_g_free0 (_tmp6_);
	}
}

static void
vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base,
                                         ValaSourceFile* source_file)
{
	ValaGIdlParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gi")) {
		vala_gidl_parser_parse_file (self, source_file);
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_g_idl_module_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_idl_module_free (var), NULL));
}

static inline void
_g_list_free__g_idl_module_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_idl_module_free0_);
}

static void
vala_gidl_parser_parse_file (ValaGIdlParser* self,
                             ValaSourceFile* source_file)
{
	gchar* metadata_filename = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValaSourceFile* _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GEqualFunc _tmp15_;
	ValaHashMap* _tmp16_;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	ValaHashMap* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_source_file_get_filename (source_file);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (".gi");
	_tmp7_ = _tmp6_;
	_tmp8_ = string_substring (_tmp1_, (glong) 0, (glong) (_tmp5_ - _tmp7_));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%s.metadata", _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	metadata_filename = _tmp11_;
	_tmp12_ = _vala_source_file_ref0 (source_file);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp12_;
	_tmp13_ = g_str_hash;
	_tmp14_ = g_str_equal;
	_tmp15_ = g_direct_equal;
	_tmp16_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp13_, _tmp14_, _tmp15_);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	self->priv->codenode_attributes_map = (ValaMap*) _tmp16_;
	_tmp17_ = g_direct_hash;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp17_, (GEqualFunc) g_pattern_spec_equal, _tmp18_);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	self->priv->codenode_attributes_patterns = (ValaMap*) _tmp19_;
	_tmp20_ = metadata_filename;
	if (g_file_test (_tmp20_, G_FILE_TEST_EXISTS)) {
		{
			gchar* metadata = NULL;
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gchar** _tmp25_;
			_tmp21_ = metadata_filename;
			g_file_get_contents (_tmp21_, &_tmp22_, NULL, &_inner_error0_);
			_g_free0 (metadata);
			metadata = _tmp22_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (metadata);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (metadata_filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp23_ = metadata;
			_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "\n", 0);
			{
				gchar** line_collection = NULL;
				gint line_collection_length1 = 0;
				gint _line_collection_size_ = 0;
				gint line_it = 0;
				line_collection = _tmp25_;
				line_collection_length1 = _vala_array_length (_tmp24_);
				for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
					const gchar* line = NULL;
					line = line_collection[line_it];
					{
						const gchar* _tmp26_;
						gchar** tokens = NULL;
						const gchar* _tmp27_;
						gchar** _tmp28_;
						gchar** _tmp29_;
						gint tokens_length1;
						gint _tokens_size_;
						gchar** _tmp30_;
						gint _tmp30__length1;
						const gchar* _tmp31_;
						gchar** _tmp32_;
						gint _tmp32__length1;
						const gchar* _tmp33_;
						ValaMap* _tmp41_;
						gchar** _tmp42_;
						gint _tmp42__length1;
						const gchar* _tmp43_;
						gchar** _tmp44_;
						gint _tmp44__length1;
						const gchar* _tmp45_;
						_tmp26_ = line;
						if (g_str_has_prefix (_tmp26_, "#")) {
							continue;
						}
						_tmp27_ = line;
						_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, " ", 2);
						tokens = _tmp29_;
						tokens_length1 = _vala_array_length (_tmp28_);
						_tokens_size_ = tokens_length1;
						_tmp30_ = tokens;
						_tmp30__length1 = tokens_length1;
						_tmp31_ = _tmp30_[0];
						if (NULL == _tmp31_) {
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							continue;
						}
						_tmp32_ = tokens;
						_tmp32__length1 = tokens_length1;
						_tmp33_ = _tmp32_[0];
						if (-1 != string_index_of_char (_tmp33_, (gunichar) '*', 0)) {
							GPatternSpec* pattern = NULL;
							gchar** _tmp34_;
							gint _tmp34__length1;
							const gchar* _tmp35_;
							GPatternSpec* _tmp36_;
							ValaMap* _tmp37_;
							GPatternSpec* _tmp38_;
							gchar** _tmp39_;
							gint _tmp39__length1;
							const gchar* _tmp40_;
							_tmp34_ = tokens;
							_tmp34__length1 = tokens_length1;
							_tmp35_ = _tmp34_[0];
							_tmp36_ = g_pattern_spec_new (_tmp35_);
							pattern = _tmp36_;
							_tmp37_ = self->priv->codenode_attributes_patterns;
							_tmp38_ = pattern;
							_tmp39_ = tokens;
							_tmp39__length1 = tokens_length1;
							_tmp40_ = _tmp39_[0];
							vala_map_set (_tmp37_, _tmp38_, _tmp40_);
						}
						_tmp41_ = self->priv->codenode_attributes_map;
						_tmp42_ = tokens;
						_tmp42__length1 = tokens_length1;
						_tmp43_ = _tmp42_[0];
						_tmp44_ = tokens;
						_tmp44__length1 = tokens_length1;
						_tmp45_ = _tmp44_[1];
						vala_map_set (_tmp41_, _tmp43_, _tmp45_);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (metadata);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp46_;
			const gchar* _tmp47_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp46_ = e;
			_tmp47_ = _tmp46_->message;
			vala_report_error (NULL, "Unable to read metadata file: %s", _tmp47_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GList* modules = NULL;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		GList* _tmp50_;
		ValaSourceLocation _tmp51_ = {0};
		ValaSourceLocation _tmp52_ = {0};
		ValaSourceReference* _tmp53_;
		_tmp48_ = vala_source_file_get_filename (source_file);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_idl_parse_file (_tmp49_, &_inner_error0_);
		modules = _tmp50_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch1_g_markup_error;
			}
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		vala_source_location_init (&_tmp51_, NULL, 0, 0);
		vala_source_location_init (&_tmp52_, NULL, 0, 0);
		_tmp53_ = vala_source_reference_new (source_file, &_tmp51_, &_tmp52_);
		_vala_source_reference_unref0 (self->priv->current_source_reference);
		self->priv->current_source_reference = _tmp53_;
		{
			GList* module_collection = NULL;
			GList* module_it = NULL;
			module_collection = modules;
			for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
				GIdlModule* module = NULL;
				module = (GIdlModule*) module_it->data;
				{
					ValaNamespace* ns = NULL;
					GIdlModule* _tmp54_;
					ValaNamespace* _tmp55_;
					ValaNamespace* _tmp56_;
					_tmp54_ = module;
					_tmp55_ = vala_gidl_parser_parse_module (self, _tmp54_);
					ns = _tmp55_;
					_tmp56_ = ns;
					if (_tmp56_ != NULL) {
						ValaCodeContext* _tmp57_;
						ValaNamespace* _tmp58_;
						ValaNamespace* _tmp59_;
						ValaNamespace* _tmp60_;
						_tmp57_ = self->priv->context;
						_tmp58_ = vala_code_context_get_root (_tmp57_);
						_tmp59_ = _tmp58_;
						_tmp60_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp59_, _tmp60_);
					}
					_vala_code_node_unref0 (ns);
				}
			}
		}
		(modules == NULL) ? NULL : (modules = (_g_list_free__g_idl_module_free0_ (modules), NULL));
	}
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp61_;
		const gchar* _tmp62_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp61_ = e;
		_tmp62_ = _tmp61_->message;
		vala_report_error (NULL, "Unable to parse GIDL file: %s", _tmp62_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (metadata_filename);
}

static gchar*
vala_gidl_parser_fix_type_name (ValaGIdlParser* self,
                                const gchar* type_name,
                                ValaSymbol* container)
{
	gchar** attributes = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp26_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp1_ = vala_gidl_parser_get_attributes (self, type_name, &_tmp0_);
	attributes = _tmp1_;
	attributes_length1 = _tmp0_;
	_attributes_size_ = attributes_length1;
	_tmp2_ = attributes;
	_tmp2__length1 = attributes_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = attributes;
		_tmp3__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp3_;
			attr_collection_length1 = _tmp3__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp4_;
				gchar* attr = NULL;
				_tmp4_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp4_;
				{
					gchar** nv = NULL;
					const gchar* _tmp5_;
					gchar** _tmp6_;
					gchar** _tmp7_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					_tmp5_ = attr;
					_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "=", 2);
					nv = _tmp7_;
					nv_length1 = _vala_array_length (_tmp6_);
					_nv_size_ = nv_length1;
					_tmp8_ = nv;
					_tmp8__length1 = nv_length1;
					_tmp9_ = _tmp8_[0];
					if (g_strcmp0 (_tmp9_, "name") == 0) {
						gchar** _tmp10_;
						gint _tmp10__length1;
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp10_ = nv;
						_tmp10__length1 = nv_length1;
						_tmp11_ = _tmp10_[1];
						_tmp12_ = vala_gidl_parser_eval (self, _tmp11_);
						result = _tmp12_;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp13_ = vala_symbol_get_name (container);
	_tmp14_ = _tmp13_;
	if (g_str_has_prefix (type_name, _tmp14_)) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = vala_symbol_get_name (container);
		_tmp16_ = _tmp15_;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_substring (type_name, (glong) _tmp18_, (glong) -1);
		result = _tmp19_;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gchar* cprefix = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = vala_gidl_parser_get_cprefix (self, container);
		cprefix = _tmp20_;
		_tmp21_ = cprefix;
		if (g_str_has_prefix (type_name, _tmp21_)) {
			const gchar* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gchar* _tmp25_;
			_tmp22_ = cprefix;
			_tmp23_ = strlen (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = string_substring (type_name, (glong) _tmp24_, (glong) -1);
			result = _tmp25_;
			_g_free0 (cprefix);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_free0 (cprefix);
	}
	_tmp26_ = g_strdup (type_name);
	result = _tmp26_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar*
vala_gidl_parser_fix_const_name (ValaGIdlParser* self,
                                 const gchar* const_name,
                                 ValaSymbol* container)
{
	gchar* pref = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = vala_gidl_parser_get_lower_case_cprefix (self, container);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	pref = _tmp3_;
	_tmp4_ = pref;
	if (g_str_has_prefix (const_name, _tmp4_)) {
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = pref;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (const_name, (glong) _tmp7_, (glong) -1);
		result = _tmp8_;
		_g_free0 (pref);
		return result;
	}
	_tmp9_ = g_strdup (const_name);
	result = _tmp9_;
	_g_free0 (pref);
	return result;
}

static gchar*
vala_gidl_parser_get_cheader_filename (ValaGIdlParser* self,
                                       ValaSymbol* sym)
{
	gchar* cheader_filename = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp0_;
	_tmp1_ = cheader_filename;
	if (_tmp1_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp2_ = vala_symbol_get_parent_symbol (sym);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = vala_symbol_get_parent_symbol (sym);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_gidl_parser_get_cheader_filename (self, _tmp5_);
		result = _tmp6_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != NULL) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaSourceFile* _tmp11_;
			ValaSourceFile* _tmp12_;
			gchar* _tmp13_;
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_source_reference_get_file (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_source_file_get_cinclude_filename (_tmp12_);
			result = _tmp13_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp14_ = g_strdup ("");
	result = _tmp14_;
	_g_free0 (cheader_filename);
	return result;
}

static gchar*
vala_gidl_parser_get_cname (ValaGIdlParser* self,
                            ValaSymbol* sym,
                            ValaSymbol* container)
{
	gchar* cname = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (container == NULL) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		container = _tmp1_;
	}
	_tmp2_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cname", NULL);
	cname = _tmp2_;
	_tmp3_ = cname;
	if (_tmp3_ != NULL) {
		result = cname;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
		gchar* name = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = vala_symbol_get_name (sym);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		name = _tmp6_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CREATION_METHOD)) {
			gboolean _tmp7_ = FALSE;
			const gchar* _tmp8_;
			_tmp8_ = name;
			if (_tmp8_ == NULL) {
				_tmp7_ = TRUE;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = name;
				_tmp7_ = g_strcmp0 (_tmp9_, ".new") == 0;
			}
			if (_tmp7_) {
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("new");
				_g_free0 (name);
				name = _tmp10_;
			} else {
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = name;
				_tmp12_ = g_strdup_printf ("new_%s", _tmp11_);
				_g_free0 (name);
				name = _tmp12_;
			}
		}
		if (container != NULL) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = vala_gidl_parser_get_lower_case_cprefix (self, container);
			_tmp14_ = _tmp13_;
			_tmp15_ = name;
			_tmp16_ = g_strdup_printf ("%s%s", _tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			_g_free0 (name);
			_g_free0 (cname);
			return result;
		} else {
			result = name;
			_g_free0 (cname);
			return result;
		}
		_g_free0 (name);
	} else {
		if (container != NULL) {
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = vala_gidl_parser_get_cprefix (self, container);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_symbol_get_name (sym);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf ("%s%s", _tmp19_, _tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp19_);
			result = _tmp23_;
			_g_free0 (cname);
			return result;
		} else {
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp24_ = vala_symbol_get_name (sym);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup (_tmp25_);
			result = _tmp26_;
			_g_free0 (cname);
			return result;
		}
	}
}

static gchar*
vala_gidl_parser_get_finish_cname (ValaGIdlParser* self,
                                   ValaMethod* m)
{
	gchar* finish_cname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) m, "CCode", "finish_name", NULL);
	finish_cname = _tmp0_;
	_tmp1_ = finish_cname;
	if (_tmp1_ != NULL) {
		result = finish_cname;
		return result;
	}
	_tmp2_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) m, NULL);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (g_str_has_suffix (_tmp3_, "_async")) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = _result_;
		_tmp5_ = _result_;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = strlen ("_async");
		_tmp9_ = _tmp8_;
		_tmp10_ = string_substring (_tmp4_, (glong) 0, (glong) (_tmp7_ - _tmp9_));
		_g_free0 (_result_);
		_result_ = _tmp10_;
	}
	_tmp11_ = _result_;
	_tmp12_ = g_strconcat (_tmp11_, "_finish", NULL);
	result = _tmp12_;
	_g_free0 (_result_);
	_g_free0 (finish_cname);
	return result;
}

static gchar*
vala_gidl_parser_get_lower_case_cname (ValaGIdlParser* self,
                                       ValaSymbol* sym)
{
	gchar* lower_case_csuffix = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	ValaSymbol* _tmp27_;
	ValaSymbol* _tmp28_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_symbol_get_name (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_camel_case_to_lower_case (_tmp1_);
	lower_case_csuffix = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		const gchar* _tmp3_;
		const gchar* _tmp17_;
		_tmp3_ = lower_case_csuffix;
		if (g_str_has_prefix (_tmp3_, "type_")) {
			const gchar* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp4_ = lower_case_csuffix;
			_tmp5_ = strlen ("type_");
			_tmp6_ = _tmp5_;
			_tmp7_ = string_substring (_tmp4_, (glong) _tmp6_, (glong) -1);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat ("type", _tmp8_, NULL);
			_g_free0 (lower_case_csuffix);
			lower_case_csuffix = _tmp9_;
			_g_free0 (_tmp8_);
		} else {
			const gchar* _tmp10_;
			_tmp10_ = lower_case_csuffix;
			if (g_str_has_prefix (_tmp10_, "is_")) {
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp11_ = lower_case_csuffix;
				_tmp12_ = strlen ("is_");
				_tmp13_ = _tmp12_;
				_tmp14_ = string_substring (_tmp11_, (glong) _tmp13_, (glong) -1);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat ("is", _tmp15_, NULL);
				_g_free0 (lower_case_csuffix);
				lower_case_csuffix = _tmp16_;
				_g_free0 (_tmp15_);
			}
		}
		_tmp17_ = lower_case_csuffix;
		if (g_str_has_suffix (_tmp17_, "_class")) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp18_ = lower_case_csuffix;
			_tmp19_ = lower_case_csuffix;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = strlen ("_class");
			_tmp23_ = _tmp22_;
			_tmp24_ = string_substring (_tmp18_, (glong) 0, (glong) (_tmp21_ - _tmp23_));
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp25_, "class", NULL);
			_g_free0 (lower_case_csuffix);
			lower_case_csuffix = _tmp26_;
			_g_free0 (_tmp25_);
		}
	}
	_tmp27_ = vala_symbol_get_parent_symbol (sym);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp29_ = vala_symbol_get_parent_symbol (sym);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = lower_case_csuffix;
		_tmp34_ = g_strdup_printf ("%s%s", _tmp32_, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp32_);
		result = _tmp35_;
		_g_free0 (lower_case_csuffix);
		return result;
	} else {
		result = lower_case_csuffix;
		return result;
	}
}

static gchar*
vala_gidl_parser_get_lower_case_cprefix (ValaGIdlParser* self,
                                         ValaSymbol* sym)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* cprefix = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_symbol_get_name (sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "lower_case_cprefix", NULL);
	_g_free0 (cprefix);
	cprefix = _tmp3_;
	_tmp5_ = cprefix;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp7_;
		_tmp7_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cprefix", NULL);
		_g_free0 (cprefix);
		cprefix = _tmp7_;
	}
	_tmp8_ = cprefix;
	if (_tmp8_ != NULL) {
		result = cprefix;
		return result;
	}
	_tmp9_ = vala_gidl_parser_get_lower_case_cname (self, sym);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, "_", NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	result = _tmp12_;
	_g_free0 (cprefix);
	return result;
}

gchar*
vala_gidl_parser_get_cprefix (ValaGIdlParser* self,
                              ValaSymbol* sym)
{
	gchar* _tmp31_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		gchar* _tmp0_;
		_tmp0_ = vala_gidl_parser_get_cname (self, sym, NULL);
		result = _tmp0_;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN);
		}
		if (_tmp1_) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp2_ = vala_gidl_parser_get_lower_case_cname (self, sym);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_ascii_strup (_tmp3_, (gssize) -1);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("%s_", _tmp5_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			_g_free0 (_tmp3_);
			result = _tmp7_;
			return result;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = vala_symbol_get_name (sym);
				_tmp9_ = _tmp8_;
				if (_tmp9_ != NULL) {
					gchar* cprefix = NULL;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					ValaSymbol* _tmp12_;
					ValaSymbol* _tmp13_;
					_tmp10_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cprefix", NULL);
					cprefix = _tmp10_;
					_tmp11_ = cprefix;
					if (_tmp11_ != NULL) {
						result = cprefix;
						return result;
					}
					_tmp12_ = vala_symbol_get_parent_symbol (sym);
					_tmp13_ = _tmp12_;
					if (_tmp13_ != NULL) {
						ValaSymbol* _tmp14_;
						ValaSymbol* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp14_ = vala_symbol_get_parent_symbol (sym);
						_tmp15_ = _tmp14_;
						_tmp16_ = vala_gidl_parser_get_cprefix (self, _tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = vala_symbol_get_name (sym);
						_tmp19_ = _tmp18_;
						_tmp20_ = g_strdup_printf ("%s%s", _tmp17_, _tmp19_);
						_tmp21_ = _tmp20_;
						_g_free0 (_tmp17_);
						result = _tmp21_;
						_g_free0 (cprefix);
						return result;
					} else {
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp22_ = vala_symbol_get_name (sym);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_strdup (_tmp23_);
						result = _tmp24_;
						_g_free0 (cprefix);
						return result;
					}
					_g_free0 (cprefix);
				} else {
					gchar* _tmp25_;
					_tmp25_ = g_strdup ("");
					result = _tmp25_;
					return result;
				}
			} else {
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp26_ = vala_symbol_get_name (sym);
				_tmp27_ = _tmp26_;
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp28_ = vala_symbol_get_name (sym);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strdup (_tmp29_);
					result = _tmp30_;
					return result;
				}
			}
		}
	}
	_tmp31_ = g_strdup ("");
	result = _tmp31_;
	return result;
}

static gchar**
vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self,
                                          GIdlNode* node,
                                          gint* result_length1)
{
	gchar* name = NULL;
	const gchar* _tmp19_;
	gint _tmp20_ = 0;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (node->type == G_IDL_NODE_FUNCTION) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = ((GIdlNodeFunction*) node)->symbol;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (name);
		name = _tmp1_;
	} else {
		if (node->type == G_IDL_NODE_SIGNAL) {
			ValaTypeSymbol* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = self->priv->current_data_type;
			_tmp3_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp2_, NULL);
			_tmp4_ = _tmp3_;
			_tmp5_ = node->name;
			_tmp6_ = g_strdup_printf ("%s::%s", _tmp4_, _tmp5_);
			_g_free0 (name);
			name = _tmp6_;
			_g_free0 (_tmp4_);
		} else {
			if (node->type == G_IDL_NODE_PROPERTY) {
				ValaTypeSymbol* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp7_ = self->priv->current_data_type;
				_tmp8_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = node->name;
				_tmp11_ = g_strdup_printf ("%s:%s", _tmp9_, _tmp10_);
				_g_free0 (name);
				name = _tmp11_;
				_g_free0 (_tmp9_);
			} else {
				if (node->type == G_IDL_NODE_FIELD) {
					ValaTypeSymbol* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = self->priv->current_data_type;
					_tmp13_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp12_, NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = node->name;
					_tmp16_ = g_strdup_printf ("%s.%s", _tmp14_, _tmp15_);
					_g_free0 (name);
					name = _tmp16_;
					_g_free0 (_tmp14_);
				} else {
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp17_ = node->name;
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (name);
					name = _tmp18_;
				}
			}
		}
	}
	_tmp19_ = name;
	_tmp21_ = vala_gidl_parser_get_attributes (self, _tmp19_, &_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp22__length1 = _tmp20_;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	_g_free0 (name);
	return result;
}

static void
vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self,
                                          ValaSymbol* container,
                                          ValaSymbol* sym)
{
	gboolean _tmp44_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		cl = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_CLASS, ValaClass);
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
			ValaClass* _tmp0_;
			_tmp0_ = cl;
			vala_symbol_add_class ((ValaSymbol*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
				ValaClass* _tmp1_;
				_tmp1_ = cl;
				vala_symbol_add_constant ((ValaSymbol*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
					ValaClass* _tmp2_;
					_tmp2_ = cl;
					vala_symbol_add_enum ((ValaSymbol*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
						ValaClass* _tmp3_;
						_tmp3_ = cl;
						vala_symbol_add_field ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
							ValaClass* _tmp4_;
							_tmp4_ = cl;
							vala_symbol_add_method ((ValaSymbol*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
								ValaClass* _tmp5_;
								_tmp5_ = cl;
								vala_symbol_add_property ((ValaSymbol*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
									ValaClass* _tmp6_;
									_tmp6_ = cl;
									vala_symbol_add_signal ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
										ValaClass* _tmp7_;
										_tmp7_ = cl;
										vala_symbol_add_struct ((ValaSymbol*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			en = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ENUM, ValaEnum);
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM_VALUE)) {
				ValaEnum* _tmp8_;
				_tmp8_ = en;
				vala_enum_add_value (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
					ValaEnum* _tmp9_;
					_tmp9_ = en;
					vala_symbol_add_constant ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
						ValaEnum* _tmp10_;
						_tmp10_ = en;
						vala_symbol_add_method ((ValaSymbol*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_INTERFACE)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_INTERFACE, ValaInterface);
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
					ValaInterface* _tmp11_;
					_tmp11_ = iface;
					vala_symbol_add_class ((ValaSymbol*) _tmp11_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
						ValaInterface* _tmp12_;
						_tmp12_ = iface;
						vala_symbol_add_constant ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
							ValaInterface* _tmp13_;
							_tmp13_ = iface;
							vala_symbol_add_enum ((ValaSymbol*) _tmp13_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								ValaInterface* _tmp14_;
								_tmp14_ = iface;
								vala_symbol_add_field ((ValaSymbol*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaInterface* _tmp15_;
									_tmp15_ = iface;
									vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										ValaInterface* _tmp16_;
										_tmp16_ = iface;
										vala_symbol_add_property ((ValaSymbol*) _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_SIGNAL)) {
											ValaInterface* _tmp17_;
											_tmp17_ = iface;
											vala_symbol_add_signal ((ValaSymbol*) _tmp17_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
												ValaInterface* _tmp18_;
												_tmp18_ = iface;
												vala_symbol_add_struct ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_NAMESPACE)) {
					ValaNamespace* ns = NULL;
					ns = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_NAMESPACE, ValaNamespace);
					if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
						ValaNamespace* _tmp19_;
						_tmp19_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp19_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
							ValaNamespace* _tmp20_;
							_tmp20_ = ns;
							vala_symbol_add_class ((ValaSymbol*) _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
								ValaNamespace* _tmp21_;
								_tmp21_ = ns;
								vala_symbol_add_constant ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE)) {
									ValaNamespace* _tmp22_;
									_tmp22_ = ns;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp22_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM)) {
										ValaNamespace* _tmp23_;
										_tmp23_ = ns;
										vala_symbol_add_enum ((ValaSymbol*) _tmp23_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ERROR_DOMAIN)) {
											ValaNamespace* _tmp24_;
											_tmp24_ = ns;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
												ValaField* field = NULL;
												ValaField* _tmp25_;
												ValaMemberBinding _tmp26_;
												ValaMemberBinding _tmp27_;
												ValaNamespace* _tmp29_;
												ValaField* _tmp30_;
												field = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField);
												_tmp25_ = field;
												_tmp26_ = vala_field_get_binding (_tmp25_);
												_tmp27_ = _tmp26_;
												if (_tmp27_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp28_;
													_tmp28_ = field;
													vala_field_set_binding (_tmp28_, VALA_MEMBER_BINDING_STATIC);
												}
												_tmp29_ = ns;
												_tmp30_ = field;
												vala_symbol_add_field ((ValaSymbol*) _tmp29_, _tmp30_);
											} else {
												if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_INTERFACE)) {
													ValaNamespace* _tmp31_;
													_tmp31_ = ns;
													vala_symbol_add_interface ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
														ValaMethod* method = NULL;
														ValaMethod* _tmp32_;
														ValaMemberBinding _tmp33_;
														ValaMemberBinding _tmp34_;
														ValaNamespace* _tmp36_;
														ValaMethod* _tmp37_;
														method = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod);
														_tmp32_ = method;
														_tmp33_ = vala_method_get_binding (_tmp32_);
														_tmp34_ = _tmp33_;
														if (_tmp34_ == VALA_MEMBER_BINDING_INSTANCE) {
															ValaMethod* _tmp35_;
															_tmp35_ = method;
															vala_method_set_binding (_tmp35_, VALA_MEMBER_BINDING_STATIC);
														}
														_tmp36_ = ns;
														_tmp37_ = method;
														vala_symbol_add_method ((ValaSymbol*) _tmp36_, _tmp37_);
													} else {
														if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
															ValaNamespace* _tmp38_;
															_tmp38_ = ns;
															vala_symbol_add_namespace ((ValaSymbol*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
														} else {
															if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
																ValaNamespace* _tmp39_;
																_tmp39_ = ns;
																vala_symbol_add_struct ((ValaSymbol*) _tmp39_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_STRUCT)) {
						ValaStruct* st = NULL;
						st = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_STRUCT, ValaStruct);
						if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CONSTANT)) {
							ValaStruct* _tmp40_;
							_tmp40_ = st;
							vala_symbol_add_constant ((ValaSymbol*) _tmp40_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
								ValaStruct* _tmp41_;
								_tmp41_ = st;
								vala_symbol_add_field ((ValaSymbol*) _tmp41_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
									ValaStruct* _tmp42_;
									_tmp42_ = st;
									vala_symbol_add_method ((ValaSymbol*) _tmp42_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
										ValaStruct* _tmp43_;
										_tmp43_ = st;
										vala_symbol_add_property ((ValaSymbol*) _tmp43_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE)) {
		_tmp44_ = G_TYPE_CHECK_INSTANCE_TYPE (container, VALA_TYPE_NAMESPACE);
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp45_ = vala_gidl_parser_get_cheader_filename (self, sym);
		_tmp46_ = _tmp45_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "cheader_filename", _tmp46_, NULL);
		_g_free0 (_tmp46_);
	}
}

static void
vala_gidl_parser_parse_node (ValaGIdlParser* self,
                             GIdlNode* node,
                             GIdlModule* module,
                             ValaSymbol* container)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (module != NULL);
	g_return_if_fail (container != NULL);
	if (node->type == G_IDL_NODE_CALLBACK) {
		ValaDelegate* cb = NULL;
		ValaDelegate* _tmp0_;
		ValaDelegate* _tmp1_;
		ValaDelegate* _tmp2_;
		ValaDelegate* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		ValaDelegate* _tmp8_;
		ValaSourceFile* _tmp9_;
		ValaDelegate* _tmp10_;
		_tmp0_ = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) node);
		cb = _tmp0_;
		_tmp1_ = cb;
		if (_tmp1_ == NULL) {
			_vala_code_node_unref0 (cb);
			return;
		}
		_tmp2_ = cb;
		_tmp3_ = cb;
		_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_gidl_parser_fix_type_name (self, _tmp5_, container);
		_tmp7_ = _tmp6_;
		vala_symbol_set_name ((ValaSymbol*) _tmp2_, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = cb;
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp8_);
		_tmp9_ = self->priv->current_source_file;
		_tmp10_ = cb;
		vala_source_file_add_node (_tmp9_, (ValaCodeNode*) _tmp10_);
		_vala_code_node_unref0 (cb);
	} else {
		if (node->type == G_IDL_NODE_STRUCT) {
			vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) node, container, module);
		} else {
			if (node->type == G_IDL_NODE_UNION) {
				vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) node, container, module);
			} else {
				if (node->type == G_IDL_NODE_BOXED) {
					vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) node, container, module);
				} else {
					if (node->type == G_IDL_NODE_ENUM) {
						vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, FALSE);
					} else {
						if (node->type == G_IDL_NODE_FLAGS) {
							vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, TRUE);
						} else {
							if (node->type == G_IDL_NODE_OBJECT) {
								vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) node, container, module);
							} else {
								if (node->type == G_IDL_NODE_INTERFACE) {
									vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) node, container, module);
								} else {
									if (node->type == G_IDL_NODE_CONSTANT) {
										ValaConstant* c = NULL;
										ValaConstant* _tmp11_;
										ValaConstant* _tmp12_;
										_tmp11_ = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) node);
										c = _tmp11_;
										_tmp12_ = c;
										if (_tmp12_ != NULL) {
											ValaConstant* _tmp13_;
											ValaConstant* _tmp14_;
											const gchar* _tmp15_;
											const gchar* _tmp16_;
											gchar* _tmp17_;
											gchar* _tmp18_;
											ValaConstant* _tmp19_;
											ValaSourceFile* _tmp20_;
											ValaConstant* _tmp21_;
											_tmp13_ = c;
											_tmp14_ = c;
											_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
											_tmp16_ = _tmp15_;
											_tmp17_ = vala_gidl_parser_fix_const_name (self, _tmp16_, container);
											_tmp18_ = _tmp17_;
											vala_symbol_set_name ((ValaSymbol*) _tmp13_, _tmp18_);
											_g_free0 (_tmp18_);
											_tmp19_ = c;
											vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp19_);
											_tmp20_ = self->priv->current_source_file;
											_tmp21_ = c;
											vala_source_file_add_node (_tmp20_, (ValaCodeNode*) _tmp21_);
										}
										_vala_code_node_unref0 (c);
									} else {
										if (node->type == G_IDL_NODE_FUNCTION) {
											ValaMethod* m = NULL;
											ValaMethod* _tmp22_;
											ValaMethod* _tmp23_;
											_tmp22_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) node, FALSE);
											m = _tmp22_;
											_tmp23_ = m;
											if (_tmp23_ != NULL) {
												ValaMethod* _tmp24_;
												ValaMethod* _tmp26_;
												ValaSourceFile* _tmp27_;
												ValaMethod* _tmp28_;
												_tmp24_ = m;
												if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_CREATION_METHOD)) {
													ValaMethod* _tmp25_;
													_tmp25_ = m;
													vala_method_set_binding (_tmp25_, VALA_MEMBER_BINDING_STATIC);
												}
												_tmp26_ = m;
												vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp26_);
												_tmp27_ = self->priv->current_source_file;
												_tmp28_ = m;
												vala_source_file_add_node (_tmp27_, (ValaCodeNode*) _tmp28_);
											}
											_vala_code_node_unref0 (m);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static ValaSymbol*
vala_gidl_parser_get_container_from_name (ValaGIdlParser* self,
                                          const gchar* name)
{
	gchar** path = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint path_length1;
	gint _path_size_;
	ValaSymbol* cp = NULL;
	ValaNamespace* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaCodeContext* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaSymbol* cc = NULL;
	gchar** _tmp14_;
	gint _tmp14__length1;
	ValaSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (name, ".", 0);
	path = _tmp1_;
	path_length1 = _vala_array_length (_tmp0_);
	_path_size_ = path_length1;
	_tmp2_ = self->priv->current_namespace;
	_tmp3_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp2_);
	cp = _tmp3_;
	_tmp4_ = cp;
	_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->context;
	_tmp8_ = vala_code_context_get_root (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp6_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_SYMBOL, ValaSymbol)) {
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		_tmp10_ = cp;
		_tmp11_ = vala_symbol_get_parent_symbol (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (_tmp12_);
		_vala_code_node_unref0 (cp);
		cp = _tmp13_;
	}
	cc = NULL;
	_tmp14_ = path;
	_tmp14__length1 = path_length1;
	{
		gchar** tok_collection = NULL;
		gint tok_collection_length1 = 0;
		gint _tok_collection_size_ = 0;
		gint tok_it = 0;
		tok_collection = _tmp14_;
		tok_collection_length1 = _tmp14__length1;
		for (tok_it = 0; tok_it < tok_collection_length1; tok_it = tok_it + 1) {
			const gchar* tok = NULL;
			tok = tok_collection[tok_it];
			{
				ValaSymbol* _tmp15_;
				ValaScope* _tmp16_;
				ValaScope* _tmp17_;
				const gchar* _tmp18_;
				ValaSymbol* _tmp19_;
				ValaSymbol* _tmp20_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				_tmp15_ = cp;
				_tmp16_ = vala_symbol_get_scope (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = tok;
				_tmp19_ = vala_scope_lookup (_tmp17_, _tmp18_);
				_vala_code_node_unref0 (cc);
				cc = _tmp19_;
				_tmp20_ = cc;
				if (_tmp20_ == NULL) {
					const gchar* _tmp21_;
					ValaSourceReference* _tmp22_;
					ValaNamespace* _tmp23_;
					ValaSymbol* _tmp24_;
					ValaSymbol* _tmp25_;
					_tmp21_ = tok;
					_tmp22_ = self->priv->current_source_reference;
					_tmp23_ = vala_namespace_new (_tmp21_, _tmp22_);
					_vala_code_node_unref0 (cc);
					cc = (ValaSymbol*) _tmp23_;
					_tmp24_ = cp;
					_tmp25_ = cc;
					vala_gidl_parser_add_symbol_to_container (self, _tmp24_, _tmp25_);
				}
				_tmp26_ = cc;
				_tmp27_ = _vala_code_node_ref0 (_tmp26_);
				_vala_code_node_unref0 (cp);
				cp = _tmp27_;
			}
		}
	}
	result = cc;
	_vala_code_node_unref0 (cp);
	path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}

static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}

static ValaNamespace*
vala_gidl_parser_parse_module (ValaGIdlParser* self,
                               GIdlModule* module)
{
	ValaSymbol* sym = NULL;
	ValaCodeContext* _tmp0_;
	ValaNamespace* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	const gchar* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaNamespace* ns = NULL;
	ValaSymbol* _tmp7_;
	ValaNamespace* _tmp19_;
	ValaNamespace* _tmp20_;
	gchar** attributes = NULL;
	ValaNamespace* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_ = 0;
	gchar** _tmp25_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	ValaArrayList* deferred = NULL;
	GEqualFunc _tmp107_;
	ValaArrayList* _tmp108_;
	GList* _tmp109_;
	ValaSymbol* _tmp158_;
	ValaNamespace* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = module->name;
	_tmp6_ = vala_scope_lookup (_tmp4_, _tmp5_);
	sym = _tmp6_;
	_tmp7_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp8_;
		ValaNamespace* _tmp9_;
		ValaNamespace* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp8_ = sym;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp9_;
		_tmp10_ = ns;
		_tmp11_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_) {
			ValaNamespace* _tmp13_;
			ValaNamespace* _tmp14_;
			ValaSourceReference* _tmp15_;
			_tmp13_ = ns;
			(((ValaCodeNode*) _tmp13_)->attributes == NULL) ? NULL : (((ValaCodeNode*) _tmp13_)->attributes = (_g_list_free__vala_code_node_unref0_ (((ValaCodeNode*) _tmp13_)->attributes), NULL));
			((ValaCodeNode*) _tmp13_)->attributes = NULL;
			_tmp14_ = ns;
			_tmp15_ = self->priv->current_source_reference;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp14_, _tmp15_);
		}
	} else {
		const gchar* _tmp16_;
		ValaSourceReference* _tmp17_;
		ValaNamespace* _tmp18_;
		_tmp16_ = module->name;
		_tmp17_ = self->priv->current_source_reference;
		_tmp18_ = vala_namespace_new (_tmp16_, _tmp17_);
		_vala_code_node_unref0 (ns);
		ns = _tmp18_;
	}
	_tmp19_ = ns;
	_tmp20_ = _vala_code_node_ref0 (_tmp19_);
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp20_;
	_tmp21_ = ns;
	_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp25_ = vala_gidl_parser_get_attributes (self, _tmp23_, &_tmp24_);
	attributes = _tmp25_;
	attributes_length1 = _tmp24_;
	_attributes_size_ = attributes_length1;
	_tmp26_ = attributes;
	_tmp26__length1 = attributes_length1;
	if (_tmp26_ != NULL) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp27_ = attributes;
		_tmp27__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp27_;
			attr_collection_length1 = _tmp27__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp28_;
				gchar* attr = NULL;
				_tmp28_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp28_;
				{
					gchar** nv = NULL;
					const gchar* _tmp29_;
					gchar** _tmp30_;
					gchar** _tmp31_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp32_;
					gint _tmp32__length1;
					const gchar* _tmp33_;
					_tmp29_ = attr;
					_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, "=", 2);
					nv = _tmp31_;
					nv_length1 = _vala_array_length (_tmp30_);
					_nv_size_ = nv_length1;
					_tmp32_ = nv;
					_tmp32__length1 = nv_length1;
					_tmp33_ = _tmp32_[0];
					if (g_strcmp0 (_tmp33_, "cheader_filename") == 0) {
						ValaNamespace* _tmp34_;
						gchar** _tmp35_;
						gint _tmp35__length1;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp34_ = ns;
						_tmp35_ = nv;
						_tmp35__length1 = nv_length1;
						_tmp36_ = _tmp35_[1];
						_tmp37_ = vala_gidl_parser_eval (self, _tmp36_);
						_tmp38_ = _tmp37_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp34_, "CCode", "cheader_filename", _tmp38_, NULL);
						_g_free0 (_tmp38_);
					} else {
						gchar** _tmp39_;
						gint _tmp39__length1;
						const gchar* _tmp40_;
						_tmp39_ = nv;
						_tmp39__length1 = nv_length1;
						_tmp40_ = _tmp39_[0];
						if (g_strcmp0 (_tmp40_, "cprefix") == 0) {
							ValaNamespace* _tmp41_;
							gchar** _tmp42_;
							gint _tmp42__length1;
							const gchar* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							_tmp41_ = ns;
							_tmp42_ = nv;
							_tmp42__length1 = nv_length1;
							_tmp43_ = _tmp42_[1];
							_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
							_tmp45_ = _tmp44_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp41_, "CCode", "cprefix", _tmp45_, NULL);
							_g_free0 (_tmp45_);
						} else {
							gchar** _tmp46_;
							gint _tmp46__length1;
							const gchar* _tmp47_;
							_tmp46_ = nv;
							_tmp46__length1 = nv_length1;
							_tmp47_ = _tmp46_[0];
							if (g_strcmp0 (_tmp47_, "lower_case_cprefix") == 0) {
								ValaNamespace* _tmp48_;
								gchar** _tmp49_;
								gint _tmp49__length1;
								const gchar* _tmp50_;
								gchar* _tmp51_;
								gchar* _tmp52_;
								_tmp48_ = ns;
								_tmp49_ = nv;
								_tmp49__length1 = nv_length1;
								_tmp50_ = _tmp49_[1];
								_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
								_tmp52_ = _tmp51_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp48_, "CCode", "lower_case_cprefix", _tmp52_, NULL);
								_g_free0 (_tmp52_);
							} else {
								gchar** _tmp53_;
								gint _tmp53__length1;
								const gchar* _tmp54_;
								_tmp53_ = nv;
								_tmp53__length1 = nv_length1;
								_tmp54_ = _tmp53_[0];
								if (g_strcmp0 (_tmp54_, "gir_namespace") == 0) {
									ValaNamespace* _tmp55_;
									ValaSourceReference* _tmp56_;
									ValaSourceReference* _tmp57_;
									ValaSourceFile* _tmp58_;
									ValaSourceFile* _tmp59_;
									gchar** _tmp60_;
									gint _tmp60__length1;
									const gchar* _tmp61_;
									gchar* _tmp62_;
									gchar* _tmp63_;
									ValaNamespace* _tmp64_;
									gchar** _tmp65_;
									gint _tmp65__length1;
									const gchar* _tmp66_;
									gchar* _tmp67_;
									gchar* _tmp68_;
									_tmp55_ = ns;
									_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
									_tmp57_ = _tmp56_;
									_tmp58_ = vala_source_reference_get_file (_tmp57_);
									_tmp59_ = _tmp58_;
									_tmp60_ = nv;
									_tmp60__length1 = nv_length1;
									_tmp61_ = _tmp60_[1];
									_tmp62_ = vala_gidl_parser_eval (self, _tmp61_);
									_tmp63_ = _tmp62_;
									vala_source_file_set_gir_namespace (_tmp59_, _tmp63_);
									_g_free0 (_tmp63_);
									_tmp64_ = ns;
									_tmp65_ = nv;
									_tmp65__length1 = nv_length1;
									_tmp66_ = _tmp65_[1];
									_tmp67_ = vala_gidl_parser_eval (self, _tmp66_);
									_tmp68_ = _tmp67_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp64_, "CCode", "gir_namespace", _tmp68_, NULL);
									_g_free0 (_tmp68_);
								} else {
									gchar** _tmp69_;
									gint _tmp69__length1;
									const gchar* _tmp70_;
									_tmp69_ = nv;
									_tmp69__length1 = nv_length1;
									_tmp70_ = _tmp69_[0];
									if (g_strcmp0 (_tmp70_, "gir_version") == 0) {
										ValaNamespace* _tmp71_;
										ValaSourceReference* _tmp72_;
										ValaSourceReference* _tmp73_;
										ValaSourceFile* _tmp74_;
										ValaSourceFile* _tmp75_;
										gchar** _tmp76_;
										gint _tmp76__length1;
										const gchar* _tmp77_;
										gchar* _tmp78_;
										gchar* _tmp79_;
										ValaNamespace* _tmp80_;
										gchar** _tmp81_;
										gint _tmp81__length1;
										const gchar* _tmp82_;
										gchar* _tmp83_;
										gchar* _tmp84_;
										_tmp71_ = ns;
										_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
										_tmp73_ = _tmp72_;
										_tmp74_ = vala_source_reference_get_file (_tmp73_);
										_tmp75_ = _tmp74_;
										_tmp76_ = nv;
										_tmp76__length1 = nv_length1;
										_tmp77_ = _tmp76_[1];
										_tmp78_ = vala_gidl_parser_eval (self, _tmp77_);
										_tmp79_ = _tmp78_;
										vala_source_file_set_gir_version (_tmp75_, _tmp79_);
										_g_free0 (_tmp79_);
										_tmp80_ = ns;
										_tmp81_ = nv;
										_tmp81__length1 = nv_length1;
										_tmp82_ = _tmp81_[1];
										_tmp83_ = vala_gidl_parser_eval (self, _tmp82_);
										_tmp84_ = _tmp83_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp80_, "CCode", "gir_version", _tmp84_, NULL);
										_g_free0 (_tmp84_);
									} else {
										gchar** _tmp85_;
										gint _tmp85__length1;
										const gchar* _tmp86_;
										_tmp85_ = nv;
										_tmp85__length1 = nv_length1;
										_tmp86_ = _tmp85_[0];
										if (g_strcmp0 (_tmp86_, "deprecated") == 0) {
											gchar** _tmp87_;
											gint _tmp87__length1;
											const gchar* _tmp88_;
											gchar* _tmp89_;
											gchar* _tmp90_;
											gboolean _tmp91_;
											_tmp87_ = nv;
											_tmp87__length1 = nv_length1;
											_tmp88_ = _tmp87_[1];
											_tmp89_ = vala_gidl_parser_eval (self, _tmp88_);
											_tmp90_ = _tmp89_;
											_tmp91_ = g_strcmp0 (_tmp90_, "1") == 0;
											_g_free0 (_tmp90_);
											if (_tmp91_) {
												ValaNamespace* _tmp92_;
												_tmp92_ = ns;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp92_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp93_;
											gint _tmp93__length1;
											const gchar* _tmp94_;
											_tmp93_ = nv;
											_tmp93__length1 = nv_length1;
											_tmp94_ = _tmp93_[0];
											if (g_strcmp0 (_tmp94_, "replacement") == 0) {
												ValaNamespace* _tmp95_;
												gchar** _tmp96_;
												gint _tmp96__length1;
												const gchar* _tmp97_;
												gchar* _tmp98_;
												gchar* _tmp99_;
												_tmp95_ = ns;
												_tmp96_ = nv;
												_tmp96__length1 = nv_length1;
												_tmp97_ = _tmp96_[1];
												_tmp98_ = vala_gidl_parser_eval (self, _tmp97_);
												_tmp99_ = _tmp98_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "Version", "replacement", _tmp99_, NULL);
												_g_free0 (_tmp99_);
											} else {
												gchar** _tmp100_;
												gint _tmp100__length1;
												const gchar* _tmp101_;
												_tmp100_ = nv;
												_tmp100__length1 = nv_length1;
												_tmp101_ = _tmp100_[0];
												if (g_strcmp0 (_tmp101_, "deprecated_since") == 0) {
													ValaNamespace* _tmp102_;
													gchar** _tmp103_;
													gint _tmp103__length1;
													const gchar* _tmp104_;
													gchar* _tmp105_;
													gchar* _tmp106_;
													_tmp102_ = ns;
													_tmp103_ = nv;
													_tmp103__length1 = nv_length1;
													_tmp104_ = _tmp103_[1];
													_tmp105_ = vala_gidl_parser_eval (self, _tmp104_);
													_tmp106_ = _tmp105_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "Version", "deprecated_since", _tmp106_, NULL);
													_g_free0 (_tmp106_);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp107_ = g_direct_equal;
	_tmp108_ = vala_array_list_new (G_TYPE_POINTER, NULL, NULL, _tmp107_);
	deferred = _tmp108_;
	_tmp109_ = module->entries;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp109_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node = NULL;
			node = (GIdlNode*) node_it->data;
			{
				gboolean is_deferred = FALSE;
				gchar** child_attributes = NULL;
				GIdlNode* _tmp110_;
				gint _tmp111_ = 0;
				gchar** _tmp112_;
				gint child_attributes_length1;
				gint _child_attributes_size_;
				gchar** _tmp113_;
				gint _tmp113__length1;
				is_deferred = FALSE;
				_tmp110_ = node;
				_tmp112_ = vala_gidl_parser_get_attributes_for_node (self, _tmp110_, &_tmp111_);
				child_attributes = _tmp112_;
				child_attributes_length1 = _tmp111_;
				_child_attributes_size_ = child_attributes_length1;
				_tmp113_ = child_attributes;
				_tmp113__length1 = child_attributes_length1;
				if (_tmp113_ != NULL) {
					gchar** _tmp114_;
					gint _tmp114__length1;
					_tmp114_ = child_attributes;
					_tmp114__length1 = child_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp114_;
						attr_collection_length1 = _tmp114__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							const gchar* attr = NULL;
							attr = attr_collection[attr_it];
							{
								gchar** nv = NULL;
								const gchar* _tmp115_;
								gchar** _tmp116_;
								gchar** _tmp117_;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp118_;
								gint _tmp118__length1;
								const gchar* _tmp119_;
								_tmp115_ = attr;
								_tmp117_ = _tmp116_ = g_strsplit (_tmp115_, "=", 2);
								nv = _tmp117_;
								nv_length1 = _vala_array_length (_tmp116_);
								_nv_size_ = nv_length1;
								_tmp118_ = nv;
								_tmp118__length1 = nv_length1;
								_tmp119_ = _tmp118_[0];
								if (g_strcmp0 (_tmp119_, "parent") == 0) {
									ValaArrayList* _tmp120_;
									GIdlNode* _tmp121_;
									_tmp120_ = deferred;
									_tmp121_ = node;
									vala_collection_add ((ValaCollection*) _tmp120_, _tmp121_);
									is_deferred = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
				if (!is_deferred) {
					GIdlNode* _tmp122_;
					ValaNamespace* _tmp123_;
					_tmp122_ = node;
					_tmp123_ = ns;
					vala_gidl_parser_parse_node (self, _tmp122_, module, (ValaSymbol*) _tmp123_);
				}
				child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp124_;
		gint _node_size = 0;
		ValaArrayList* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _node_index = 0;
		_tmp124_ = deferred;
		_node_list = _tmp124_;
		_tmp125_ = _node_list;
		_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
		_tmp127_ = _tmp126_;
		_node_size = _tmp127_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp128_;
			gint _tmp129_;
			GIdlNode* node = NULL;
			ValaArrayList* _tmp130_;
			gpointer _tmp131_;
			ValaSymbol* container = NULL;
			ValaNamespace* _tmp132_;
			ValaSymbol* _tmp133_;
			gchar** child_attributes = NULL;
			GIdlNode* _tmp134_;
			gint _tmp135_ = 0;
			gchar** _tmp136_;
			gint child_attributes_length1;
			gint _child_attributes_size_;
			gchar** _tmp137_;
			gint _tmp137__length1;
			ValaSymbol* _tmp149_;
			GIdlNode* _tmp154_;
			ValaSymbol* _tmp155_;
			ValaNamespace* _tmp156_;
			ValaNamespace* _tmp157_;
			_node_index = _node_index + 1;
			_tmp128_ = _node_index;
			_tmp129_ = _node_size;
			if (!(_tmp128_ < _tmp129_)) {
				break;
			}
			_tmp130_ = _node_list;
			_tmp131_ = vala_list_get ((ValaList*) _tmp130_, _node_index);
			node = (GIdlNode*) _tmp131_;
			_tmp132_ = ns;
			_tmp133_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp132_);
			container = _tmp133_;
			_tmp134_ = node;
			_tmp136_ = vala_gidl_parser_get_attributes_for_node (self, _tmp134_, &_tmp135_);
			child_attributes = _tmp136_;
			child_attributes_length1 = _tmp135_;
			_child_attributes_size_ = child_attributes_length1;
			_tmp137_ = child_attributes;
			_tmp137__length1 = child_attributes_length1;
			if (_tmp137_ != NULL) {
				gchar** _tmp138_;
				gint _tmp138__length1;
				_tmp138_ = child_attributes;
				_tmp138__length1 = child_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp138_;
					attr_collection_length1 = _tmp138__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						const gchar* attr = NULL;
						attr = attr_collection[attr_it];
						{
							gchar** nv = NULL;
							const gchar* _tmp139_;
							gchar** _tmp140_;
							gchar** _tmp141_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp142_;
							gint _tmp142__length1;
							const gchar* _tmp143_;
							_tmp139_ = attr;
							_tmp141_ = _tmp140_ = g_strsplit (_tmp139_, "=", 2);
							nv = _tmp141_;
							nv_length1 = _vala_array_length (_tmp140_);
							_nv_size_ = nv_length1;
							_tmp142_ = nv;
							_tmp142__length1 = nv_length1;
							_tmp143_ = _tmp142_[0];
							if (g_strcmp0 (_tmp143_, "parent") == 0) {
								gchar** _tmp144_;
								gint _tmp144__length1;
								const gchar* _tmp145_;
								gchar* _tmp146_;
								gchar* _tmp147_;
								ValaSymbol* _tmp148_;
								_tmp144_ = nv;
								_tmp144__length1 = nv_length1;
								_tmp145_ = _tmp144_[1];
								_tmp146_ = vala_gidl_parser_eval (self, _tmp145_);
								_tmp147_ = _tmp146_;
								_tmp148_ = vala_gidl_parser_get_container_from_name (self, _tmp147_);
								_vala_code_node_unref0 (container);
								container = _tmp148_;
								_g_free0 (_tmp147_);
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			_tmp149_ = container;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp149_, VALA_TYPE_NAMESPACE)) {
				ValaSymbol* _tmp150_;
				ValaNamespace* _tmp151_;
				_tmp150_ = container;
				_tmp151_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, VALA_TYPE_NAMESPACE, ValaNamespace));
				_vala_code_node_unref0 (self->priv->current_namespace);
				self->priv->current_namespace = _tmp151_;
			} else {
				ValaSymbol* _tmp152_;
				ValaTypeSymbol* _tmp153_;
				_tmp152_ = container;
				_tmp153_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (self->priv->current_data_type);
				self->priv->current_data_type = _tmp153_;
			}
			_tmp154_ = node;
			_tmp155_ = container;
			vala_gidl_parser_parse_node (self, _tmp154_, module, _tmp155_);
			_tmp156_ = ns;
			_tmp157_ = _vala_code_node_ref0 (_tmp156_);
			_vala_code_node_unref0 (self->priv->current_namespace);
			self->priv->current_namespace = _tmp157_;
			_vala_code_node_unref0 (self->priv->current_data_type);
			self->priv->current_data_type = NULL;
			child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (container);
		}
	}
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = NULL;
	_tmp158_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp158_, VALA_TYPE_NAMESPACE)) {
		result = NULL;
		_vala_iterable_unref0 (deferred);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (ns);
		_vala_code_node_unref0 (sym);
		return result;
	}
	result = ns;
	_vala_iterable_unref0 (deferred);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (sym);
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static ValaDelegate*
vala_gidl_parser_parse_delegate (ValaGIdlParser* self,
                                 GIdlNodeFunction* f_node)
{
	GIdlNode* node = NULL;
	ValaDataType* return_type = NULL;
	GIdlNodeParam* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDelegate* cb = NULL;
	GIdlNode* _tmp2_;
	const gchar* _tmp3_;
	ValaDataType* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaDelegate* _tmp7_;
	ValaDelegate* _tmp8_;
	gboolean check_has_target = FALSE;
	gboolean suppress_throws = FALSE;
	gchar* error_types = NULL;
	gchar** attributes = NULL;
	GIdlNode* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	guint remaining_params = 0U;
	GList* _tmp159_;
	GList* _tmp160_;
	gboolean _tmp332_ = FALSE;
	ValaDelegate* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	node = (GIdlNode*) f_node;
	_tmp0_ = f_node->result;
	_tmp1_ = vala_gidl_parser_parse_param (self, _tmp0_, NULL);
	return_type = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = return_type;
	_tmp5_ = self->priv->current_source_reference;
	_tmp6_ = vala_delegate_new (_tmp3_, _tmp4_, _tmp5_, NULL);
	cb = _tmp6_;
	_tmp7_ = cb;
	vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp8_ = cb;
	vala_delegate_set_has_target (_tmp8_, FALSE);
	check_has_target = TRUE;
	suppress_throws = FALSE;
	error_types = NULL;
	_tmp9_ = node;
	_tmp10_ = _tmp9_->name;
	_tmp12_ = vala_gidl_parser_get_attributes (self, _tmp10_, &_tmp11_);
	attributes = _tmp12_;
	attributes_length1 = _tmp11_;
	_attributes_size_ = attributes_length1;
	_tmp13_ = attributes;
	_tmp13__length1 = attributes_length1;
	if (_tmp13_ != NULL) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = attributes;
		_tmp14__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp14_;
			attr_collection_length1 = _tmp14__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr = NULL;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** nv = NULL;
					const gchar* _tmp16_;
					gchar** _tmp17_;
					gchar** _tmp18_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					_tmp16_ = attr;
					_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "=", 2);
					nv = _tmp18_;
					nv_length1 = _vala_array_length (_tmp17_);
					_nv_size_ = nv_length1;
					_tmp19_ = nv;
					_tmp19__length1 = nv_length1;
					_tmp20_ = _tmp19_[0];
					if (g_strcmp0 (_tmp20_, "hidden") == 0) {
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gboolean _tmp25_;
						_tmp21_ = nv;
						_tmp21__length1 = nv_length1;
						_tmp22_ = _tmp21_[1];
						_tmp23_ = vala_gidl_parser_eval (self, _tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0;
						_g_free0 (_tmp24_);
						if (_tmp25_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (error_types);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (return_type);
							return result;
						}
					} else {
						gchar** _tmp26_;
						gint _tmp26__length1;
						const gchar* _tmp27_;
						_tmp26_ = nv;
						_tmp26__length1 = nv_length1;
						_tmp27_ = _tmp26_[0];
						if (g_strcmp0 (_tmp27_, "cheader_filename") == 0) {
							ValaDelegate* _tmp28_;
							gchar** _tmp29_;
							gint _tmp29__length1;
							const gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							_tmp28_ = cb;
							_tmp29_ = nv;
							_tmp29__length1 = nv_length1;
							_tmp30_ = _tmp29_[1];
							_tmp31_ = vala_gidl_parser_eval (self, _tmp30_);
							_tmp32_ = _tmp31_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp28_, "CCode", "cheader_filename", _tmp32_, NULL);
							_g_free0 (_tmp32_);
						} else {
							gchar** _tmp33_;
							gint _tmp33__length1;
							const gchar* _tmp34_;
							_tmp33_ = nv;
							_tmp33__length1 = nv_length1;
							_tmp34_ = _tmp33_[0];
							if (g_strcmp0 (_tmp34_, "has_target") == 0) {
								gchar** _tmp35_;
								gint _tmp35__length1;
								const gchar* _tmp36_;
								gchar* _tmp37_;
								gchar* _tmp38_;
								gboolean _tmp39_;
								_tmp35_ = nv;
								_tmp35__length1 = nv_length1;
								_tmp36_ = _tmp35_[1];
								_tmp37_ = vala_gidl_parser_eval (self, _tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = g_strcmp0 (_tmp38_, "0") == 0;
								_g_free0 (_tmp38_);
								if (_tmp39_) {
									check_has_target = FALSE;
								} else {
									gchar** _tmp40_;
									gint _tmp40__length1;
									const gchar* _tmp41_;
									gchar* _tmp42_;
									gchar* _tmp43_;
									gboolean _tmp44_;
									_tmp40_ = nv;
									_tmp40__length1 = nv_length1;
									_tmp41_ = _tmp40_[1];
									_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
									_tmp43_ = _tmp42_;
									_tmp44_ = g_strcmp0 (_tmp43_, "1") == 0;
									_g_free0 (_tmp43_);
									if (_tmp44_) {
										ValaDelegate* _tmp45_;
										_tmp45_ = cb;
										vala_delegate_set_has_target (_tmp45_, TRUE);
									}
								}
							} else {
								gchar** _tmp46_;
								gint _tmp46__length1;
								const gchar* _tmp47_;
								_tmp46_ = nv;
								_tmp46__length1 = nv_length1;
								_tmp47_ = _tmp46_[0];
								if (g_strcmp0 (_tmp47_, "transfer_ownership") == 0) {
									gchar** _tmp48_;
									gint _tmp48__length1;
									const gchar* _tmp49_;
									gchar* _tmp50_;
									gchar* _tmp51_;
									gboolean _tmp52_;
									_tmp48_ = nv;
									_tmp48__length1 = nv_length1;
									_tmp49_ = _tmp48_[1];
									_tmp50_ = vala_gidl_parser_eval (self, _tmp49_);
									_tmp51_ = _tmp50_;
									_tmp52_ = g_strcmp0 (_tmp51_, "1") == 0;
									_g_free0 (_tmp51_);
									if (_tmp52_) {
										ValaDataType* _tmp53_;
										_tmp53_ = return_type;
										vala_data_type_set_value_owned (_tmp53_, TRUE);
									}
								} else {
									gchar** _tmp54_;
									gint _tmp54__length1;
									const gchar* _tmp55_;
									_tmp54_ = nv;
									_tmp54__length1 = nv_length1;
									_tmp55_ = _tmp54_[0];
									if (g_strcmp0 (_tmp55_, "is_array") == 0) {
										gchar** _tmp56_;
										gint _tmp56__length1;
										const gchar* _tmp57_;
										gchar* _tmp58_;
										gchar* _tmp59_;
										gboolean _tmp60_;
										_tmp56_ = nv;
										_tmp56__length1 = nv_length1;
										_tmp57_ = _tmp56_[1];
										_tmp58_ = vala_gidl_parser_eval (self, _tmp57_);
										_tmp59_ = _tmp58_;
										_tmp60_ = g_strcmp0 (_tmp59_, "1") == 0;
										_g_free0 (_tmp59_);
										if (_tmp60_) {
											ValaDataType* _tmp61_;
											ValaDataType* _tmp62_;
											ValaDataType* _tmp63_;
											ValaSourceReference* _tmp64_;
											ValaSourceReference* _tmp65_;
											ValaArrayType* _tmp66_;
											ValaDelegate* _tmp67_;
											ValaDataType* _tmp68_;
											_tmp61_ = return_type;
											vala_data_type_set_value_owned (_tmp61_, TRUE);
											_tmp62_ = return_type;
											_tmp63_ = return_type;
											_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
											_tmp65_ = _tmp64_;
											_tmp66_ = vala_array_type_new (_tmp62_, 1, _tmp65_);
											_vala_code_node_unref0 (return_type);
											return_type = (ValaDataType*) _tmp66_;
											_tmp67_ = cb;
											_tmp68_ = return_type;
											vala_callable_set_return_type ((ValaCallable*) _tmp67_, _tmp68_);
										}
									} else {
										gchar** _tmp69_;
										gint _tmp69__length1;
										const gchar* _tmp70_;
										_tmp69_ = nv;
										_tmp69__length1 = nv_length1;
										_tmp70_ = _tmp69_[0];
										if (g_strcmp0 (_tmp70_, "throws") == 0) {
											gchar** _tmp71_;
											gint _tmp71__length1;
											const gchar* _tmp72_;
											gchar* _tmp73_;
											gchar* _tmp74_;
											gboolean _tmp75_;
											_tmp71_ = nv;
											_tmp71__length1 = nv_length1;
											_tmp72_ = _tmp71_[1];
											_tmp73_ = vala_gidl_parser_eval (self, _tmp72_);
											_tmp74_ = _tmp73_;
											_tmp75_ = g_strcmp0 (_tmp74_, "0") == 0;
											_g_free0 (_tmp74_);
											if (_tmp75_) {
												suppress_throws = TRUE;
											}
										} else {
											gchar** _tmp76_;
											gint _tmp76__length1;
											const gchar* _tmp77_;
											_tmp76_ = nv;
											_tmp76__length1 = nv_length1;
											_tmp77_ = _tmp76_[0];
											if (g_strcmp0 (_tmp77_, "error_types") == 0) {
												gchar** _tmp78_;
												gint _tmp78__length1;
												const gchar* _tmp79_;
												gchar* _tmp80_;
												_tmp78_ = nv;
												_tmp78__length1 = nv_length1;
												_tmp79_ = _tmp78_[1];
												_tmp80_ = vala_gidl_parser_eval (self, _tmp79_);
												_g_free0 (error_types);
												error_types = _tmp80_;
											} else {
												gchar** _tmp81_;
												gint _tmp81__length1;
												const gchar* _tmp82_;
												_tmp81_ = nv;
												_tmp81__length1 = nv_length1;
												_tmp82_ = _tmp81_[0];
												if (g_strcmp0 (_tmp82_, "array_length_type") == 0) {
													ValaDelegate* _tmp83_;
													gchar** _tmp84_;
													gint _tmp84__length1;
													const gchar* _tmp85_;
													gchar* _tmp86_;
													gchar* _tmp87_;
													_tmp83_ = cb;
													_tmp84_ = nv;
													_tmp84__length1 = nv_length1;
													_tmp85_ = _tmp84_[1];
													_tmp86_ = vala_gidl_parser_eval (self, _tmp85_);
													_tmp87_ = _tmp86_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp83_, "CCode", "array_length_type", _tmp87_, NULL);
													_g_free0 (_tmp87_);
												} else {
													gchar** _tmp88_;
													gint _tmp88__length1;
													const gchar* _tmp89_;
													_tmp88_ = nv;
													_tmp88__length1 = nv_length1;
													_tmp89_ = _tmp88_[0];
													if (g_strcmp0 (_tmp89_, "type_name") == 0) {
														ValaDelegate* _tmp90_;
														gchar** _tmp91_;
														gint _tmp91__length1;
														const gchar* _tmp92_;
														gchar* _tmp93_;
														gchar* _tmp94_;
														ValaDataType* _tmp95_;
														gboolean _tmp96_;
														gboolean _tmp97_;
														ValaDataType* _tmp98_;
														ValaDataType* _tmp99_;
														_tmp90_ = cb;
														_tmp91_ = nv;
														_tmp91__length1 = nv_length1;
														_tmp92_ = _tmp91_[1];
														_tmp93_ = vala_gidl_parser_eval (self, _tmp92_);
														_tmp94_ = _tmp93_;
														_tmp95_ = return_type;
														_tmp96_ = vala_data_type_get_value_owned (_tmp95_);
														_tmp97_ = _tmp96_;
														_tmp98_ = vala_gidl_parser_parse_type_from_string (self, _tmp94_, _tmp97_, NULL);
														_vala_code_node_unref0 (return_type);
														return_type = _tmp98_;
														_tmp99_ = return_type;
														vala_callable_set_return_type ((ValaCallable*) _tmp90_, _tmp99_);
														_g_free0 (_tmp94_);
													} else {
														gchar** _tmp100_;
														gint _tmp100__length1;
														const gchar* _tmp101_;
														_tmp100_ = nv;
														_tmp100__length1 = nv_length1;
														_tmp101_ = _tmp100_[0];
														if (g_strcmp0 (_tmp101_, "deprecated") == 0) {
															gchar** _tmp102_;
															gint _tmp102__length1;
															const gchar* _tmp103_;
															gchar* _tmp104_;
															gchar* _tmp105_;
															gboolean _tmp106_;
															_tmp102_ = nv;
															_tmp102__length1 = nv_length1;
															_tmp103_ = _tmp102_[1];
															_tmp104_ = vala_gidl_parser_eval (self, _tmp103_);
															_tmp105_ = _tmp104_;
															_tmp106_ = g_strcmp0 (_tmp105_, "1") == 0;
															_g_free0 (_tmp105_);
															if (_tmp106_) {
																ValaDelegate* _tmp107_;
																_tmp107_ = cb;
																vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp107_, "Version", "deprecated", TRUE, NULL);
															}
														} else {
															gchar** _tmp108_;
															gint _tmp108__length1;
															const gchar* _tmp109_;
															_tmp108_ = nv;
															_tmp108__length1 = nv_length1;
															_tmp109_ = _tmp108_[0];
															if (g_strcmp0 (_tmp109_, "replacement") == 0) {
																ValaDelegate* _tmp110_;
																gchar** _tmp111_;
																gint _tmp111__length1;
																const gchar* _tmp112_;
																gchar* _tmp113_;
																gchar* _tmp114_;
																_tmp110_ = cb;
																_tmp111_ = nv;
																_tmp111__length1 = nv_length1;
																_tmp112_ = _tmp111_[1];
																_tmp113_ = vala_gidl_parser_eval (self, _tmp112_);
																_tmp114_ = _tmp113_;
																vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp110_, "Version", "replacement", _tmp114_, NULL);
																_g_free0 (_tmp114_);
															} else {
																gchar** _tmp115_;
																gint _tmp115__length1;
																const gchar* _tmp116_;
																_tmp115_ = nv;
																_tmp115__length1 = nv_length1;
																_tmp116_ = _tmp115_[0];
																if (g_strcmp0 (_tmp116_, "deprecated_since") == 0) {
																	ValaDelegate* _tmp117_;
																	gchar** _tmp118_;
																	gint _tmp118__length1;
																	const gchar* _tmp119_;
																	gchar* _tmp120_;
																	gchar* _tmp121_;
																	_tmp117_ = cb;
																	_tmp118_ = nv;
																	_tmp118__length1 = nv_length1;
																	_tmp119_ = _tmp118_[1];
																	_tmp120_ = vala_gidl_parser_eval (self, _tmp119_);
																	_tmp121_ = _tmp120_;
																	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp117_, "Version", "deprecated_since", _tmp121_, NULL);
																	_g_free0 (_tmp121_);
																} else {
																	gchar** _tmp122_;
																	gint _tmp122__length1;
																	const gchar* _tmp123_;
																	_tmp122_ = nv;
																	_tmp122__length1 = nv_length1;
																	_tmp123_ = _tmp122_[0];
																	if (g_strcmp0 (_tmp123_, "type_arguments") == 0) {
																		ValaDataType* _tmp124_;
																		gchar** _tmp125_;
																		gint _tmp125__length1;
																		const gchar* _tmp126_;
																		gchar* _tmp127_;
																		gchar* _tmp128_;
																		_tmp124_ = return_type;
																		_tmp125_ = nv;
																		_tmp125__length1 = nv_length1;
																		_tmp126_ = _tmp125_[1];
																		_tmp127_ = vala_gidl_parser_eval (self, _tmp126_);
																		_tmp128_ = _tmp127_;
																		vala_gidl_parser_parse_type_arguments_from_string (self, _tmp124_, _tmp128_, NULL);
																		_g_free0 (_tmp128_);
																	} else {
																		gchar** _tmp129_;
																		gint _tmp129__length1;
																		const gchar* _tmp130_;
																		_tmp129_ = nv;
																		_tmp129__length1 = nv_length1;
																		_tmp130_ = _tmp129_[0];
																		if (g_strcmp0 (_tmp130_, "instance_pos") == 0) {
																			ValaDelegate* _tmp131_;
																			gchar** _tmp132_;
																			gint _tmp132__length1;
																			const gchar* _tmp133_;
																			gchar* _tmp134_;
																			gchar* _tmp135_;
																			_tmp131_ = cb;
																			_tmp132_ = nv;
																			_tmp132__length1 = nv_length1;
																			_tmp133_ = _tmp132_[1];
																			_tmp134_ = vala_gidl_parser_eval (self, _tmp133_);
																			_tmp135_ = _tmp134_;
																			vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp131_, "CCode", "instance_pos", double_parse (_tmp135_), NULL);
																			_g_free0 (_tmp135_);
																		} else {
																			gchar** _tmp136_;
																			gint _tmp136__length1;
																			const gchar* _tmp137_;
																			_tmp136_ = nv;
																			_tmp136__length1 = nv_length1;
																			_tmp137_ = _tmp136_[0];
																			if (g_strcmp0 (_tmp137_, "type_parameters") == 0) {
																				gchar** _tmp138_;
																				gint _tmp138__length1;
																				const gchar* _tmp139_;
																				gchar* _tmp140_;
																				gchar* _tmp141_;
																				gchar** _tmp142_;
																				gchar** _tmp143_;
																				gchar** _tmp144_;
																				gint _tmp144__length1;
																				_tmp138_ = nv;
																				_tmp138__length1 = nv_length1;
																				_tmp139_ = _tmp138_[1];
																				_tmp140_ = vala_gidl_parser_eval (self, _tmp139_);
																				_tmp141_ = _tmp140_;
																				_tmp143_ = _tmp142_ = g_strsplit (_tmp141_, ",", 0);
																				_tmp144_ = _tmp143_;
																				_tmp144__length1 = _vala_array_length (_tmp142_);
																				_g_free0 (_tmp141_);
																				{
																					gchar** type_param_name_collection = NULL;
																					gint type_param_name_collection_length1 = 0;
																					gint _type_param_name_collection_size_ = 0;
																					gint type_param_name_it = 0;
																					type_param_name_collection = _tmp144_;
																					type_param_name_collection_length1 = _tmp144__length1;
																					for (type_param_name_it = 0; type_param_name_it < type_param_name_collection_length1; type_param_name_it = type_param_name_it + 1) {
																						gchar* _tmp145_;
																						gchar* type_param_name = NULL;
																						_tmp145_ = g_strdup (type_param_name_collection[type_param_name_it]);
																						type_param_name = _tmp145_;
																						{
																							ValaDelegate* _tmp146_;
																							const gchar* _tmp147_;
																							ValaSourceReference* _tmp148_;
																							ValaTypeParameter* _tmp149_;
																							ValaTypeParameter* _tmp150_;
																							_tmp146_ = cb;
																							_tmp147_ = type_param_name;
																							_tmp148_ = self->priv->current_source_reference;
																							_tmp149_ = vala_typeparameter_new (_tmp147_, _tmp148_);
																							_tmp150_ = _tmp149_;
																							vala_delegate_add_type_parameter (_tmp146_, _tmp150_);
																							_vala_code_node_unref0 (_tmp150_);
																							_g_free0 (type_param_name);
																						}
																					}
																					type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																				}
																			} else {
																				gchar** _tmp151_;
																				gint _tmp151__length1;
																				const gchar* _tmp152_;
																				_tmp151_ = nv;
																				_tmp151__length1 = nv_length1;
																				_tmp152_ = _tmp151_[0];
																				if (g_strcmp0 (_tmp152_, "experimental") == 0) {
																					gchar** _tmp153_;
																					gint _tmp153__length1;
																					const gchar* _tmp154_;
																					gchar* _tmp155_;
																					gchar* _tmp156_;
																					gboolean _tmp157_;
																					_tmp153_ = nv;
																					_tmp153__length1 = nv_length1;
																					_tmp154_ = _tmp153_[1];
																					_tmp155_ = vala_gidl_parser_eval (self, _tmp154_);
																					_tmp156_ = _tmp155_;
																					_tmp157_ = g_strcmp0 (_tmp156_, "1") == 0;
																					_g_free0 (_tmp156_);
																					if (_tmp157_) {
																						ValaDelegate* _tmp158_;
																						_tmp158_ = cb;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp158_, "Version", "experimental", TRUE, NULL);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp159_ = f_node->parameters;
	remaining_params = g_list_length (_tmp159_);
	_tmp160_ = f_node->parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp160_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp161_;
				gboolean _tmp162_ = FALSE;
				gboolean _tmp163_ = FALSE;
				guint _tmp331_;
				_tmp161_ = param;
				param_node = (GIdlNode*) _tmp161_;
				if (check_has_target) {
					_tmp163_ = remaining_params == ((guint) 1);
				} else {
					_tmp163_ = FALSE;
				}
				if (_tmp163_) {
					gboolean _tmp164_ = FALSE;
					GIdlNode* _tmp165_;
					const gchar* _tmp166_;
					_tmp165_ = param_node;
					_tmp166_ = _tmp165_->name;
					if (g_strcmp0 (_tmp166_, "user_data") == 0) {
						_tmp164_ = TRUE;
					} else {
						GIdlNode* _tmp167_;
						const gchar* _tmp168_;
						_tmp167_ = param_node;
						_tmp168_ = _tmp167_->name;
						_tmp164_ = g_strcmp0 (_tmp168_, "data") == 0;
					}
					_tmp162_ = _tmp164_;
				} else {
					_tmp162_ = FALSE;
				}
				if (_tmp162_) {
					ValaDelegate* _tmp169_;
					_tmp169_ = cb;
					vala_delegate_set_has_target (_tmp169_, TRUE);
				} else {
					gboolean _tmp170_ = FALSE;
					gchar* param_name = NULL;
					GIdlNode* _tmp179_;
					const gchar* _tmp180_;
					gchar* _tmp181_;
					const gchar* _tmp182_;
					ValaParameterDirection direction = 0;
					ValaDataType* param_type = NULL;
					GIdlNodeParam* _tmp186_;
					ValaParameterDirection _tmp187_ = 0;
					ValaDataType* _tmp188_;
					ValaParameter* p = NULL;
					const gchar* _tmp189_;
					ValaDataType* _tmp190_;
					ValaSourceReference* _tmp191_;
					ValaParameter* _tmp192_;
					ValaParameter* _tmp193_;
					gboolean hide_param = FALSE;
					gboolean show_param = FALSE;
					gboolean array_requested = FALSE;
					gboolean out_requested = FALSE;
					GIdlNode* _tmp194_;
					const gchar* _tmp195_;
					GIdlNode* _tmp196_;
					const gchar* _tmp197_;
					gchar* _tmp198_;
					gchar* _tmp199_;
					gint _tmp200_ = 0;
					gchar** _tmp201_;
					gchar** _tmp202_;
					gint _tmp202__length1;
					gboolean _tmp328_ = FALSE;
					if (suppress_throws == FALSE) {
						GIdlNodeParam* _tmp171_;
						_tmp171_ = param;
						_tmp170_ = vala_gidl_parser_param_is_exception (self, _tmp171_);
					} else {
						_tmp170_ = FALSE;
					}
					if (_tmp170_) {
						const gchar* _tmp172_;
						guint _tmp178_;
						_tmp172_ = error_types;
						if (_tmp172_ == NULL) {
							ValaDelegate* _tmp173_;
							GIdlNodeParam* _tmp174_;
							GIdlNodeType* _tmp175_;
							ValaDataType* _tmp176_;
							ValaDataType* _tmp177_;
							_tmp173_ = cb;
							_tmp174_ = param;
							_tmp175_ = _tmp174_->type;
							_tmp176_ = vala_gidl_parser_parse_type (self, _tmp175_, NULL);
							_tmp177_ = _tmp176_;
							vala_delegate_add_error_type (_tmp173_, _tmp177_);
							_vala_code_node_unref0 (_tmp177_);
						}
						_tmp178_ = remaining_params;
						remaining_params = _tmp178_ - 1;
						continue;
					}
					_tmp179_ = param_node;
					_tmp180_ = _tmp179_->name;
					_tmp181_ = g_strdup (_tmp180_);
					param_name = _tmp181_;
					_tmp182_ = param_name;
					if (g_strcmp0 (_tmp182_, "string") == 0) {
						gchar* _tmp183_;
						_tmp183_ = g_strdup ("str");
						_g_free0 (param_name);
						param_name = _tmp183_;
					} else {
						const gchar* _tmp184_;
						_tmp184_ = param_name;
						if (g_strcmp0 (_tmp184_, "self") == 0) {
							gchar* _tmp185_;
							_tmp185_ = g_strdup ("_self");
							_g_free0 (param_name);
							param_name = _tmp185_;
						}
					}
					_tmp186_ = param;
					_tmp188_ = vala_gidl_parser_parse_param (self, _tmp186_, &_tmp187_);
					direction = _tmp187_;
					param_type = _tmp188_;
					_tmp189_ = param_name;
					_tmp190_ = param_type;
					_tmp191_ = self->priv->current_source_reference;
					_tmp192_ = vala_parameter_new (_tmp189_, _tmp190_, _tmp191_);
					p = _tmp192_;
					_tmp193_ = p;
					vala_parameter_set_direction (_tmp193_, direction);
					hide_param = FALSE;
					show_param = FALSE;
					array_requested = FALSE;
					out_requested = FALSE;
					_tmp194_ = node;
					_tmp195_ = _tmp194_->name;
					_tmp196_ = param_node;
					_tmp197_ = _tmp196_->name;
					_tmp198_ = g_strdup_printf ("%s.%s", _tmp195_, _tmp197_);
					_tmp199_ = _tmp198_;
					_tmp201_ = vala_gidl_parser_get_attributes (self, _tmp199_, &_tmp200_);
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					attributes = _tmp201_;
					attributes_length1 = _tmp200_;
					_attributes_size_ = attributes_length1;
					_g_free0 (_tmp199_);
					_tmp202_ = attributes;
					_tmp202__length1 = attributes_length1;
					if (_tmp202_ != NULL) {
						gchar** _tmp203_;
						gint _tmp203__length1;
						_tmp203_ = attributes;
						_tmp203__length1 = attributes_length1;
						{
							gchar** attr_collection = NULL;
							gint attr_collection_length1 = 0;
							gint _attr_collection_size_ = 0;
							gint attr_it = 0;
							attr_collection = _tmp203_;
							attr_collection_length1 = _tmp203__length1;
							for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
								gchar* _tmp204_;
								gchar* attr = NULL;
								_tmp204_ = g_strdup (attr_collection[attr_it]);
								attr = _tmp204_;
								{
									gchar** nv = NULL;
									const gchar* _tmp205_;
									gchar** _tmp206_;
									gchar** _tmp207_;
									gint nv_length1;
									gint _nv_size_;
									gchar** _tmp208_;
									gint _tmp208__length1;
									const gchar* _tmp209_;
									_tmp205_ = attr;
									_tmp207_ = _tmp206_ = g_strsplit (_tmp205_, "=", 2);
									nv = _tmp207_;
									nv_length1 = _vala_array_length (_tmp206_);
									_nv_size_ = nv_length1;
									_tmp208_ = nv;
									_tmp208__length1 = nv_length1;
									_tmp209_ = _tmp208_[0];
									if (g_strcmp0 (_tmp209_, "hidden") == 0) {
										gchar** _tmp210_;
										gint _tmp210__length1;
										const gchar* _tmp211_;
										gchar* _tmp212_;
										gchar* _tmp213_;
										gboolean _tmp214_;
										_tmp210_ = nv;
										_tmp210__length1 = nv_length1;
										_tmp211_ = _tmp210_[1];
										_tmp212_ = vala_gidl_parser_eval (self, _tmp211_);
										_tmp213_ = _tmp212_;
										_tmp214_ = g_strcmp0 (_tmp213_, "1") == 0;
										_g_free0 (_tmp213_);
										if (_tmp214_) {
											hide_param = TRUE;
										} else {
											gchar** _tmp215_;
											gint _tmp215__length1;
											const gchar* _tmp216_;
											gchar* _tmp217_;
											gchar* _tmp218_;
											gboolean _tmp219_;
											_tmp215_ = nv;
											_tmp215__length1 = nv_length1;
											_tmp216_ = _tmp215_[1];
											_tmp217_ = vala_gidl_parser_eval (self, _tmp216_);
											_tmp218_ = _tmp217_;
											_tmp219_ = g_strcmp0 (_tmp218_, "0") == 0;
											_g_free0 (_tmp218_);
											if (_tmp219_) {
												show_param = TRUE;
											}
										}
									} else {
										gchar** _tmp220_;
										gint _tmp220__length1;
										const gchar* _tmp221_;
										_tmp220_ = nv;
										_tmp220__length1 = nv_length1;
										_tmp221_ = _tmp220_[0];
										if (g_strcmp0 (_tmp221_, "is_array") == 0) {
											gchar** _tmp222_;
											gint _tmp222__length1;
											const gchar* _tmp223_;
											gchar* _tmp224_;
											gchar* _tmp225_;
											gboolean _tmp226_;
											_tmp222_ = nv;
											_tmp222__length1 = nv_length1;
											_tmp223_ = _tmp222_[1];
											_tmp224_ = vala_gidl_parser_eval (self, _tmp223_);
											_tmp225_ = _tmp224_;
											_tmp226_ = g_strcmp0 (_tmp225_, "1") == 0;
											_g_free0 (_tmp225_);
											if (_tmp226_) {
												ValaDataType* _tmp227_;
												ValaDataType* _tmp228_;
												ValaDataType* _tmp229_;
												ValaSourceReference* _tmp230_;
												ValaSourceReference* _tmp231_;
												ValaArrayType* _tmp232_;
												ValaParameter* _tmp233_;
												ValaDataType* _tmp234_;
												_tmp227_ = param_type;
												vala_data_type_set_value_owned (_tmp227_, TRUE);
												_tmp228_ = param_type;
												_tmp229_ = param_type;
												_tmp230_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp229_);
												_tmp231_ = _tmp230_;
												_tmp232_ = vala_array_type_new (_tmp228_, 1, _tmp231_);
												_vala_code_node_unref0 (param_type);
												param_type = (ValaDataType*) _tmp232_;
												_tmp233_ = p;
												_tmp234_ = param_type;
												vala_variable_set_variable_type ((ValaVariable*) _tmp233_, _tmp234_);
												if (!out_requested) {
													ValaParameter* _tmp235_;
													_tmp235_ = p;
													vala_parameter_set_direction (_tmp235_, VALA_PARAMETER_DIRECTION_IN);
												}
												array_requested = TRUE;
											}
										} else {
											gchar** _tmp236_;
											gint _tmp236__length1;
											const gchar* _tmp237_;
											_tmp236_ = nv;
											_tmp236__length1 = nv_length1;
											_tmp237_ = _tmp236_[0];
											if (g_strcmp0 (_tmp237_, "is_out") == 0) {
												gchar** _tmp238_;
												gint _tmp238__length1;
												const gchar* _tmp239_;
												gchar* _tmp240_;
												gchar* _tmp241_;
												gboolean _tmp242_;
												_tmp238_ = nv;
												_tmp238__length1 = nv_length1;
												_tmp239_ = _tmp238_[1];
												_tmp240_ = vala_gidl_parser_eval (self, _tmp239_);
												_tmp241_ = _tmp240_;
												_tmp242_ = g_strcmp0 (_tmp241_, "1") == 0;
												_g_free0 (_tmp241_);
												if (_tmp242_) {
													ValaParameter* _tmp243_;
													gboolean _tmp244_ = FALSE;
													_tmp243_ = p;
													vala_parameter_set_direction (_tmp243_, VALA_PARAMETER_DIRECTION_OUT);
													out_requested = TRUE;
													if (!array_requested) {
														ValaDataType* _tmp245_;
														_tmp245_ = param_type;
														_tmp244_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp245_, VALA_TYPE_ARRAY_TYPE);
													} else {
														_tmp244_ = FALSE;
													}
													if (_tmp244_) {
														ValaArrayType* array_type = NULL;
														ValaDataType* _tmp246_;
														ValaArrayType* _tmp247_;
														ValaArrayType* _tmp248_;
														ValaDataType* _tmp249_;
														ValaDataType* _tmp250_;
														ValaDataType* _tmp251_;
														ValaParameter* _tmp252_;
														ValaDataType* _tmp253_;
														_tmp246_ = param_type;
														_tmp247_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp246_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
														array_type = _tmp247_;
														_tmp248_ = array_type;
														_tmp249_ = vala_array_type_get_element_type (_tmp248_);
														_tmp250_ = _tmp249_;
														_tmp251_ = _vala_code_node_ref0 (_tmp250_);
														_vala_code_node_unref0 (param_type);
														param_type = _tmp251_;
														_tmp252_ = p;
														_tmp253_ = param_type;
														vala_variable_set_variable_type ((ValaVariable*) _tmp252_, _tmp253_);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												gchar** _tmp254_;
												gint _tmp254__length1;
												const gchar* _tmp255_;
												_tmp254_ = nv;
												_tmp254__length1 = nv_length1;
												_tmp255_ = _tmp254_[0];
												if (g_strcmp0 (_tmp255_, "is_ref") == 0) {
													gchar** _tmp256_;
													gint _tmp256__length1;
													const gchar* _tmp257_;
													gchar* _tmp258_;
													gchar* _tmp259_;
													gboolean _tmp260_;
													_tmp256_ = nv;
													_tmp256__length1 = nv_length1;
													_tmp257_ = _tmp256_[1];
													_tmp258_ = vala_gidl_parser_eval (self, _tmp257_);
													_tmp259_ = _tmp258_;
													_tmp260_ = g_strcmp0 (_tmp259_, "1") == 0;
													_g_free0 (_tmp259_);
													if (_tmp260_) {
														ValaParameter* _tmp261_;
														gboolean _tmp262_ = FALSE;
														_tmp261_ = p;
														vala_parameter_set_direction (_tmp261_, VALA_PARAMETER_DIRECTION_REF);
														if (!array_requested) {
															ValaDataType* _tmp263_;
															_tmp263_ = param_type;
															_tmp262_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp263_, VALA_TYPE_ARRAY_TYPE);
														} else {
															_tmp262_ = FALSE;
														}
														if (_tmp262_) {
															ValaArrayType* array_type = NULL;
															ValaDataType* _tmp264_;
															ValaArrayType* _tmp265_;
															ValaArrayType* _tmp266_;
															ValaDataType* _tmp267_;
															ValaDataType* _tmp268_;
															ValaDataType* _tmp269_;
															ValaParameter* _tmp270_;
															ValaDataType* _tmp271_;
															_tmp264_ = param_type;
															_tmp265_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
															array_type = _tmp265_;
															_tmp266_ = array_type;
															_tmp267_ = vala_array_type_get_element_type (_tmp266_);
															_tmp268_ = _tmp267_;
															_tmp269_ = _vala_code_node_ref0 (_tmp268_);
															_vala_code_node_unref0 (param_type);
															param_type = _tmp269_;
															_tmp270_ = p;
															_tmp271_ = param_type;
															vala_variable_set_variable_type ((ValaVariable*) _tmp270_, _tmp271_);
															_vala_code_node_unref0 (array_type);
														}
													}
												} else {
													gchar** _tmp272_;
													gint _tmp272__length1;
													const gchar* _tmp273_;
													_tmp272_ = nv;
													_tmp272__length1 = nv_length1;
													_tmp273_ = _tmp272_[0];
													if (g_strcmp0 (_tmp273_, "takes_ownership") == 0) {
														gchar** _tmp274_;
														gint _tmp274__length1;
														const gchar* _tmp275_;
														gchar* _tmp276_;
														gchar* _tmp277_;
														gboolean _tmp278_;
														_tmp274_ = nv;
														_tmp274__length1 = nv_length1;
														_tmp275_ = _tmp274_[1];
														_tmp276_ = vala_gidl_parser_eval (self, _tmp275_);
														_tmp277_ = _tmp276_;
														_tmp278_ = g_strcmp0 (_tmp277_, "1") == 0;
														_g_free0 (_tmp277_);
														if (_tmp278_) {
															ValaDataType* _tmp279_;
															_tmp279_ = param_type;
															vala_data_type_set_value_owned (_tmp279_, TRUE);
														}
													} else {
														gchar** _tmp280_;
														gint _tmp280__length1;
														const gchar* _tmp281_;
														_tmp280_ = nv;
														_tmp280__length1 = nv_length1;
														_tmp281_ = _tmp280_[0];
														if (g_strcmp0 (_tmp281_, "nullable") == 0) {
															gchar** _tmp282_;
															gint _tmp282__length1;
															const gchar* _tmp283_;
															gchar* _tmp284_;
															gchar* _tmp285_;
															gboolean _tmp286_;
															_tmp282_ = nv;
															_tmp282__length1 = nv_length1;
															_tmp283_ = _tmp282_[1];
															_tmp284_ = vala_gidl_parser_eval (self, _tmp283_);
															_tmp285_ = _tmp284_;
															_tmp286_ = g_strcmp0 (_tmp285_, "1") == 0;
															_g_free0 (_tmp285_);
															if (_tmp286_) {
																ValaDataType* _tmp287_;
																_tmp287_ = param_type;
																vala_data_type_set_nullable (_tmp287_, TRUE);
															}
														} else {
															gchar** _tmp288_;
															gint _tmp288__length1;
															const gchar* _tmp289_;
															_tmp288_ = nv;
															_tmp288__length1 = nv_length1;
															_tmp289_ = _tmp288_[0];
															if (g_strcmp0 (_tmp289_, "type_arguments") == 0) {
																ValaDataType* _tmp290_;
																gchar** _tmp291_;
																gint _tmp291__length1;
																const gchar* _tmp292_;
																gchar* _tmp293_;
																gchar* _tmp294_;
																_tmp290_ = param_type;
																_tmp291_ = nv;
																_tmp291__length1 = nv_length1;
																_tmp292_ = _tmp291_[1];
																_tmp293_ = vala_gidl_parser_eval (self, _tmp292_);
																_tmp294_ = _tmp293_;
																vala_gidl_parser_parse_type_arguments_from_string (self, _tmp290_, _tmp294_, NULL);
																_g_free0 (_tmp294_);
															} else {
																gchar** _tmp295_;
																gint _tmp295__length1;
																const gchar* _tmp296_;
																_tmp295_ = nv;
																_tmp295__length1 = nv_length1;
																_tmp296_ = _tmp295_[0];
																if (g_strcmp0 (_tmp296_, "no_array_length") == 0) {
																	gchar** _tmp297_;
																	gint _tmp297__length1;
																	const gchar* _tmp298_;
																	gchar* _tmp299_;
																	gchar* _tmp300_;
																	gboolean _tmp301_;
																	_tmp297_ = nv;
																	_tmp297__length1 = nv_length1;
																	_tmp298_ = _tmp297_[1];
																	_tmp299_ = vala_gidl_parser_eval (self, _tmp298_);
																	_tmp300_ = _tmp299_;
																	_tmp301_ = g_strcmp0 (_tmp300_, "1") == 0;
																	_g_free0 (_tmp300_);
																	if (_tmp301_) {
																		ValaParameter* _tmp302_;
																		_tmp302_ = p;
																		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp302_, "CCode", "array_length", FALSE, NULL);
																	}
																} else {
																	gchar** _tmp303_;
																	gint _tmp303__length1;
																	const gchar* _tmp304_;
																	_tmp303_ = nv;
																	_tmp303__length1 = nv_length1;
																	_tmp304_ = _tmp303_[0];
																	if (g_strcmp0 (_tmp304_, "array_length_type") == 0) {
																		ValaParameter* _tmp305_;
																		gchar** _tmp306_;
																		gint _tmp306__length1;
																		const gchar* _tmp307_;
																		gchar* _tmp308_;
																		gchar* _tmp309_;
																		_tmp305_ = p;
																		_tmp306_ = nv;
																		_tmp306__length1 = nv_length1;
																		_tmp307_ = _tmp306_[1];
																		_tmp308_ = vala_gidl_parser_eval (self, _tmp307_);
																		_tmp309_ = _tmp308_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp305_, "CCode", "array_length_type", _tmp309_, NULL);
																		_g_free0 (_tmp309_);
																	} else {
																		gchar** _tmp310_;
																		gint _tmp310__length1;
																		const gchar* _tmp311_;
																		_tmp310_ = nv;
																		_tmp310__length1 = nv_length1;
																		_tmp311_ = _tmp310_[0];
																		if (g_strcmp0 (_tmp311_, "array_null_terminated") == 0) {
																			gchar** _tmp312_;
																			gint _tmp312__length1;
																			const gchar* _tmp313_;
																			gchar* _tmp314_;
																			gchar* _tmp315_;
																			gboolean _tmp316_;
																			_tmp312_ = nv;
																			_tmp312__length1 = nv_length1;
																			_tmp313_ = _tmp312_[1];
																			_tmp314_ = vala_gidl_parser_eval (self, _tmp313_);
																			_tmp315_ = _tmp314_;
																			_tmp316_ = g_strcmp0 (_tmp315_, "1") == 0;
																			_g_free0 (_tmp315_);
																			if (_tmp316_) {
																				ValaParameter* _tmp317_;
																				ValaParameter* _tmp318_;
																				_tmp317_ = p;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp317_, "CCode", "array_length", FALSE, NULL);
																				_tmp318_ = p;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp318_, "CCode", "array_null_terminated", TRUE, NULL);
																			}
																		} else {
																			gchar** _tmp319_;
																			gint _tmp319__length1;
																			const gchar* _tmp320_;
																			_tmp319_ = nv;
																			_tmp319__length1 = nv_length1;
																			_tmp320_ = _tmp319_[0];
																			if (g_strcmp0 (_tmp320_, "type_name") == 0) {
																				ValaParameter* _tmp321_;
																				gchar** _tmp322_;
																				gint _tmp322__length1;
																				const gchar* _tmp323_;
																				gchar* _tmp324_;
																				gchar* _tmp325_;
																				ValaDataType* _tmp326_;
																				ValaDataType* _tmp327_;
																				_tmp321_ = p;
																				_tmp322_ = nv;
																				_tmp322__length1 = nv_length1;
																				_tmp323_ = _tmp322_[1];
																				_tmp324_ = vala_gidl_parser_eval (self, _tmp323_);
																				_tmp325_ = _tmp324_;
																				_tmp326_ = vala_gidl_parser_parse_type_from_string (self, _tmp325_, FALSE, NULL);
																				_vala_code_node_unref0 (param_type);
																				param_type = _tmp326_;
																				_tmp327_ = param_type;
																				vala_variable_set_variable_type ((ValaVariable*) _tmp321_, _tmp327_);
																				_g_free0 (_tmp325_);
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
								}
							}
						}
					}
					if (show_param) {
						_tmp328_ = TRUE;
					} else {
						_tmp328_ = !hide_param;
					}
					if (_tmp328_) {
						ValaDelegate* _tmp329_;
						ValaParameter* _tmp330_;
						_tmp329_ = cb;
						_tmp330_ = p;
						vala_callable_add_parameter ((ValaCallable*) _tmp329_, _tmp330_);
					}
					_vala_code_node_unref0 (p);
					_vala_code_node_unref0 (param_type);
					_g_free0 (param_name);
				}
				_tmp331_ = remaining_params;
				remaining_params = _tmp331_ - 1;
			}
		}
	}
	if (suppress_throws == FALSE) {
		const gchar* _tmp333_;
		_tmp333_ = error_types;
		_tmp332_ = _tmp333_ != NULL;
	} else {
		_tmp332_ = FALSE;
	}
	if (_tmp332_) {
		gchar** type_args = NULL;
		const gchar* _tmp334_;
		gchar* _tmp335_;
		gchar* _tmp336_;
		gchar** _tmp337_;
		gchar** _tmp338_;
		gchar** _tmp339_;
		gint _tmp339__length1;
		gint type_args_length1;
		gint _type_args_size_;
		gchar** _tmp340_;
		gint _tmp340__length1;
		_tmp334_ = error_types;
		_tmp335_ = vala_gidl_parser_eval (self, _tmp334_);
		_tmp336_ = _tmp335_;
		_tmp338_ = _tmp337_ = g_strsplit (_tmp336_, ",", 0);
		_tmp339_ = _tmp338_;
		_tmp339__length1 = _vala_array_length (_tmp337_);
		_g_free0 (_tmp336_);
		type_args = _tmp339_;
		type_args_length1 = _tmp339__length1;
		_type_args_size_ = type_args_length1;
		_tmp340_ = type_args;
		_tmp340__length1 = type_args_length1;
		{
			gchar** type_arg_collection = NULL;
			gint type_arg_collection_length1 = 0;
			gint _type_arg_collection_size_ = 0;
			gint type_arg_it = 0;
			type_arg_collection = _tmp340_;
			type_arg_collection_length1 = _tmp340__length1;
			for (type_arg_it = 0; type_arg_it < type_arg_collection_length1; type_arg_it = type_arg_it + 1) {
				const gchar* type_arg = NULL;
				type_arg = type_arg_collection[type_arg_it];
				{
					ValaDelegate* _tmp341_;
					const gchar* _tmp342_;
					ValaDataType* _tmp343_;
					ValaDataType* _tmp344_;
					_tmp341_ = cb;
					_tmp342_ = type_arg;
					_tmp343_ = vala_gidl_parser_parse_type_from_string (self, _tmp342_, TRUE, NULL);
					_tmp344_ = _tmp343_;
					vala_delegate_add_error_type (_tmp341_, _tmp344_);
					_vala_code_node_unref0 (_tmp344_);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	result = cb;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}

static gboolean
vala_gidl_parser_is_reference_type (ValaGIdlParser* self,
                                    const gchar* cname)
{
	gchar** st_attributes = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint st_attributes_length1;
	gint _st_attributes_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	_tmp1_ = vala_gidl_parser_get_attributes (self, cname, &_tmp0_);
	st_attributes = _tmp1_;
	st_attributes_length1 = _tmp0_;
	_st_attributes_size_ = st_attributes_length1;
	_tmp2_ = st_attributes;
	_tmp2__length1 = st_attributes_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = st_attributes;
		_tmp3__length1 = st_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp3_;
			attr_collection_length1 = _tmp3__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp4_;
				gchar* attr = NULL;
				_tmp4_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp4_;
				{
					gchar** nv = NULL;
					const gchar* _tmp5_;
					gchar** _tmp6_;
					gchar** _tmp7_;
					gint nv_length1;
					gint _nv_size_;
					gboolean _tmp8_ = FALSE;
					gchar** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					_tmp5_ = attr;
					_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "=", 2);
					nv = _tmp7_;
					nv_length1 = _vala_array_length (_tmp6_);
					_nv_size_ = nv_length1;
					_tmp9_ = nv;
					_tmp9__length1 = nv_length1;
					_tmp10_ = _tmp9_[0];
					if (g_strcmp0 (_tmp10_, "is_value_type") == 0) {
						gchar** _tmp11_;
						gint _tmp11__length1;
						const gchar* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp11_ = nv;
						_tmp11__length1 = nv_length1;
						_tmp12_ = _tmp11_[1];
						_tmp13_ = vala_gidl_parser_eval (self, _tmp12_);
						_tmp14_ = _tmp13_;
						_tmp8_ = g_strcmp0 (_tmp14_, "1") == 0;
						_g_free0 (_tmp14_);
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						result = FALSE;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
vala_gidl_parser_parse_struct (ValaGIdlParser* self,
                               GIdlNodeStruct* st_node,
                               ValaSymbol* container,
                               GIdlModule* module)
{
	GIdlNode* node = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) st_node;
	if (st_node->deprecated) {
		return;
	}
	_tmp0_ = node;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
	name = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	if (!vala_gidl_parser_is_reference_type (self, _tmp4_)) {
		ValaStruct* st = NULL;
		ValaScope* _tmp5_;
		ValaScope* _tmp6_;
		const gchar* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaStruct* _tmp10_;
		ValaStruct* _tmp135_;
		ValaTypeSymbol* _tmp136_;
		GList* _tmp137_;
		_tmp5_ = vala_symbol_get_scope (container);
		_tmp6_ = _tmp5_;
		_tmp7_ = name;
		_tmp8_ = vala_scope_lookup (_tmp6_, _tmp7_);
		_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp8_) : NULL;
		if (_tmp9_ == NULL) {
			_vala_code_node_unref0 (_tmp8_);
		}
		st = _tmp9_;
		_tmp10_ = st;
		if (_tmp10_ == NULL) {
			const gchar* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaStruct* _tmp13_;
			ValaStruct* _tmp14_;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp15_;
			const gchar* _tmp16_;
			gint _tmp17_ = 0;
			gchar** _tmp18_;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			ValaStruct* _tmp132_;
			ValaSourceFile* _tmp133_;
			ValaStruct* _tmp134_;
			_tmp11_ = name;
			_tmp12_ = self->priv->current_source_reference;
			_tmp13_ = vala_struct_new (_tmp11_, _tmp12_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp13_;
			_tmp14_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp15_ = node;
			_tmp16_ = _tmp15_->name;
			_tmp18_ = vala_gidl_parser_get_attributes (self, _tmp16_, &_tmp17_);
			st_attributes = _tmp18_;
			st_attributes_length1 = _tmp17_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp19_ = st_attributes;
			_tmp19__length1 = st_attributes_length1;
			if (_tmp19_ != NULL) {
				gchar** _tmp20_;
				gint _tmp20__length1;
				_tmp20_ = st_attributes;
				_tmp20__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp20_;
					attr_collection_length1 = _tmp20__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp21_;
						gchar* attr = NULL;
						_tmp21_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp21_;
						{
							gchar** nv = NULL;
							const gchar* _tmp22_;
							gchar** _tmp23_;
							gchar** _tmp24_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp25_;
							gint _tmp25__length1;
							const gchar* _tmp26_;
							_tmp22_ = attr;
							_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "=", 2);
							nv = _tmp24_;
							nv_length1 = _vala_array_length (_tmp23_);
							_nv_size_ = nv_length1;
							_tmp25_ = nv;
							_tmp25__length1 = nv_length1;
							_tmp26_ = _tmp25_[0];
							if (g_strcmp0 (_tmp26_, "cheader_filename") == 0) {
								ValaStruct* _tmp27_;
								gchar** _tmp28_;
								gint _tmp28__length1;
								const gchar* _tmp29_;
								gchar* _tmp30_;
								gchar* _tmp31_;
								_tmp27_ = st;
								_tmp28_ = nv;
								_tmp28__length1 = nv_length1;
								_tmp29_ = _tmp28_[1];
								_tmp30_ = vala_gidl_parser_eval (self, _tmp29_);
								_tmp31_ = _tmp30_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp27_, "CCode", "cheader_filename", _tmp31_, NULL);
								_g_free0 (_tmp31_);
							} else {
								gchar** _tmp32_;
								gint _tmp32__length1;
								const gchar* _tmp33_;
								_tmp32_ = nv;
								_tmp32__length1 = nv_length1;
								_tmp33_ = _tmp32_[0];
								if (g_strcmp0 (_tmp33_, "hidden") == 0) {
									gchar** _tmp34_;
									gint _tmp34__length1;
									const gchar* _tmp35_;
									gchar* _tmp36_;
									gchar* _tmp37_;
									gboolean _tmp38_;
									_tmp34_ = nv;
									_tmp34__length1 = nv_length1;
									_tmp35_ = _tmp34_[1];
									_tmp36_ = vala_gidl_parser_eval (self, _tmp35_);
									_tmp37_ = _tmp36_;
									_tmp38_ = g_strcmp0 (_tmp37_, "1") == 0;
									_g_free0 (_tmp37_);
									if (_tmp38_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									gchar** _tmp39_;
									gint _tmp39__length1;
									const gchar* _tmp40_;
									_tmp39_ = nv;
									_tmp39__length1 = nv_length1;
									_tmp40_ = _tmp39_[0];
									if (g_strcmp0 (_tmp40_, "base_type") == 0) {
										ValaStruct* _tmp41_;
										gchar** _tmp42_;
										gint _tmp42__length1;
										const gchar* _tmp43_;
										gchar* _tmp44_;
										gchar* _tmp45_;
										ValaDataType* _tmp46_;
										ValaDataType* _tmp47_;
										_tmp41_ = st;
										_tmp42_ = nv;
										_tmp42__length1 = nv_length1;
										_tmp43_ = _tmp42_[1];
										_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
										_tmp45_ = _tmp44_;
										_tmp46_ = vala_gidl_parser_parse_type_string (self, _tmp45_);
										_tmp47_ = _tmp46_;
										vala_struct_set_base_type (_tmp41_, _tmp47_);
										_vala_code_node_unref0 (_tmp47_);
										_g_free0 (_tmp45_);
									} else {
										gchar** _tmp48_;
										gint _tmp48__length1;
										const gchar* _tmp49_;
										_tmp48_ = nv;
										_tmp48__length1 = nv_length1;
										_tmp49_ = _tmp48_[0];
										if (g_strcmp0 (_tmp49_, "rank") == 0) {
											ValaStruct* _tmp50_;
											gchar** _tmp51_;
											gint _tmp51__length1;
											const gchar* _tmp52_;
											gchar* _tmp53_;
											gchar* _tmp54_;
											_tmp50_ = st;
											_tmp51_ = nv;
											_tmp51__length1 = nv_length1;
											_tmp52_ = _tmp51_[1];
											_tmp53_ = vala_gidl_parser_eval (self, _tmp52_);
											_tmp54_ = _tmp53_;
											vala_struct_set_rank (_tmp50_, atoi (_tmp54_));
											_g_free0 (_tmp54_);
										} else {
											gchar** _tmp55_;
											gint _tmp55__length1;
											const gchar* _tmp56_;
											_tmp55_ = nv;
											_tmp55__length1 = nv_length1;
											_tmp56_ = _tmp55_[0];
											if (g_strcmp0 (_tmp56_, "simple_type") == 0) {
												gchar** _tmp57_;
												gint _tmp57__length1;
												const gchar* _tmp58_;
												gchar* _tmp59_;
												gchar* _tmp60_;
												gboolean _tmp61_;
												_tmp57_ = nv;
												_tmp57__length1 = nv_length1;
												_tmp58_ = _tmp57_[1];
												_tmp59_ = vala_gidl_parser_eval (self, _tmp58_);
												_tmp60_ = _tmp59_;
												_tmp61_ = g_strcmp0 (_tmp60_, "1") == 0;
												_g_free0 (_tmp60_);
												if (_tmp61_) {
													ValaStruct* _tmp62_;
													_tmp62_ = st;
													vala_struct_set_simple_type (_tmp62_, TRUE);
												}
											} else {
												gchar** _tmp63_;
												gint _tmp63__length1;
												const gchar* _tmp64_;
												_tmp63_ = nv;
												_tmp63__length1 = nv_length1;
												_tmp64_ = _tmp63_[0];
												if (g_strcmp0 (_tmp64_, "immutable") == 0) {
													gchar** _tmp65_;
													gint _tmp65__length1;
													const gchar* _tmp66_;
													gchar* _tmp67_;
													gchar* _tmp68_;
													gboolean _tmp69_;
													_tmp65_ = nv;
													_tmp65__length1 = nv_length1;
													_tmp66_ = _tmp65_[1];
													_tmp67_ = vala_gidl_parser_eval (self, _tmp66_);
													_tmp68_ = _tmp67_;
													_tmp69_ = g_strcmp0 (_tmp68_, "1") == 0;
													_g_free0 (_tmp68_);
													if (_tmp69_) {
														ValaStruct* _tmp70_;
														_tmp70_ = st;
														vala_code_node_set_attribute ((ValaCodeNode*) _tmp70_, "Immutable", TRUE, NULL);
													}
												} else {
													gchar** _tmp71_;
													gint _tmp71__length1;
													const gchar* _tmp72_;
													_tmp71_ = nv;
													_tmp71__length1 = nv_length1;
													_tmp72_ = _tmp71_[0];
													if (g_strcmp0 (_tmp72_, "has_type_id") == 0) {
														gchar** _tmp73_;
														gint _tmp73__length1;
														const gchar* _tmp74_;
														gchar* _tmp75_;
														gchar* _tmp76_;
														gboolean _tmp77_;
														_tmp73_ = nv;
														_tmp73__length1 = nv_length1;
														_tmp74_ = _tmp73_[1];
														_tmp75_ = vala_gidl_parser_eval (self, _tmp74_);
														_tmp76_ = _tmp75_;
														_tmp77_ = g_strcmp0 (_tmp76_, "0") == 0;
														_g_free0 (_tmp76_);
														if (_tmp77_) {
															ValaStruct* _tmp78_;
															_tmp78_ = st;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp78_, "CCode", "has_type_id", FALSE, NULL);
														}
													} else {
														gchar** _tmp79_;
														gint _tmp79__length1;
														const gchar* _tmp80_;
														_tmp79_ = nv;
														_tmp79__length1 = nv_length1;
														_tmp80_ = _tmp79_[0];
														if (g_strcmp0 (_tmp80_, "type_id") == 0) {
															ValaStruct* _tmp81_;
															gchar** _tmp82_;
															gint _tmp82__length1;
															const gchar* _tmp83_;
															gchar* _tmp84_;
															gchar* _tmp85_;
															_tmp81_ = st;
															_tmp82_ = nv;
															_tmp82__length1 = nv_length1;
															_tmp83_ = _tmp82_[1];
															_tmp84_ = vala_gidl_parser_eval (self, _tmp83_);
															_tmp85_ = _tmp84_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp81_, "CCode", "type_id", _tmp85_, NULL);
															_g_free0 (_tmp85_);
														} else {
															gchar** _tmp86_;
															gint _tmp86__length1;
															const gchar* _tmp87_;
															_tmp86_ = nv;
															_tmp86__length1 = nv_length1;
															_tmp87_ = _tmp86_[0];
															if (g_strcmp0 (_tmp87_, "has_copy_function") == 0) {
																gchar** _tmp88_;
																gint _tmp88__length1;
																const gchar* _tmp89_;
																gchar* _tmp90_;
																gchar* _tmp91_;
																gboolean _tmp92_;
																_tmp88_ = nv;
																_tmp88__length1 = nv_length1;
																_tmp89_ = _tmp88_[1];
																_tmp90_ = vala_gidl_parser_eval (self, _tmp89_);
																_tmp91_ = _tmp90_;
																_tmp92_ = g_strcmp0 (_tmp91_, "0") == 0;
																_g_free0 (_tmp91_);
																if (_tmp92_) {
																	ValaStruct* _tmp93_;
																	_tmp93_ = st;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp93_, "CCode", "has_copy_function", FALSE, NULL);
																}
															} else {
																gchar** _tmp94_;
																gint _tmp94__length1;
																const gchar* _tmp95_;
																_tmp94_ = nv;
																_tmp94__length1 = nv_length1;
																_tmp95_ = _tmp94_[0];
																if (g_strcmp0 (_tmp95_, "deprecated") == 0) {
																	gchar** _tmp96_;
																	gint _tmp96__length1;
																	const gchar* _tmp97_;
																	gchar* _tmp98_;
																	gchar* _tmp99_;
																	gboolean _tmp100_;
																	_tmp96_ = nv;
																	_tmp96__length1 = nv_length1;
																	_tmp97_ = _tmp96_[1];
																	_tmp98_ = vala_gidl_parser_eval (self, _tmp97_);
																	_tmp99_ = _tmp98_;
																	_tmp100_ = g_strcmp0 (_tmp99_, "1") == 0;
																	_g_free0 (_tmp99_);
																	if (_tmp100_) {
																		ValaStruct* _tmp101_;
																		_tmp101_ = st;
																		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp101_, "Version", "deprecated", TRUE, NULL);
																	}
																} else {
																	gchar** _tmp102_;
																	gint _tmp102__length1;
																	const gchar* _tmp103_;
																	_tmp102_ = nv;
																	_tmp102__length1 = nv_length1;
																	_tmp103_ = _tmp102_[0];
																	if (g_strcmp0 (_tmp103_, "replacement") == 0) {
																		ValaStruct* _tmp104_;
																		gchar** _tmp105_;
																		gint _tmp105__length1;
																		const gchar* _tmp106_;
																		gchar* _tmp107_;
																		gchar* _tmp108_;
																		_tmp104_ = st;
																		_tmp105_ = nv;
																		_tmp105__length1 = nv_length1;
																		_tmp106_ = _tmp105_[1];
																		_tmp107_ = vala_gidl_parser_eval (self, _tmp106_);
																		_tmp108_ = _tmp107_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp104_, "Version", "replacement", _tmp108_, NULL);
																		_g_free0 (_tmp108_);
																	} else {
																		gchar** _tmp109_;
																		gint _tmp109__length1;
																		const gchar* _tmp110_;
																		_tmp109_ = nv;
																		_tmp109__length1 = nv_length1;
																		_tmp110_ = _tmp109_[0];
																		if (g_strcmp0 (_tmp110_, "deprecated_since") == 0) {
																			ValaStruct* _tmp111_;
																			gchar** _tmp112_;
																			gint _tmp112__length1;
																			const gchar* _tmp113_;
																			gchar* _tmp114_;
																			gchar* _tmp115_;
																			_tmp111_ = st;
																			_tmp112_ = nv;
																			_tmp112__length1 = nv_length1;
																			_tmp113_ = _tmp112_[1];
																			_tmp114_ = vala_gidl_parser_eval (self, _tmp113_);
																			_tmp115_ = _tmp114_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp111_, "Version", "deprecated_since", _tmp115_, NULL);
																			_g_free0 (_tmp115_);
																		} else {
																			gchar** _tmp116_;
																			gint _tmp116__length1;
																			const gchar* _tmp117_;
																			_tmp116_ = nv;
																			_tmp116__length1 = nv_length1;
																			_tmp117_ = _tmp116_[0];
																			if (g_strcmp0 (_tmp117_, "has_destroy_function") == 0) {
																				gchar** _tmp118_;
																				gint _tmp118__length1;
																				const gchar* _tmp119_;
																				gchar* _tmp120_;
																				gchar* _tmp121_;
																				gboolean _tmp122_;
																				_tmp118_ = nv;
																				_tmp118__length1 = nv_length1;
																				_tmp119_ = _tmp118_[1];
																				_tmp120_ = vala_gidl_parser_eval (self, _tmp119_);
																				_tmp121_ = _tmp120_;
																				_tmp122_ = g_strcmp0 (_tmp121_, "0") == 0;
																				_g_free0 (_tmp121_);
																				if (_tmp122_) {
																					ValaStruct* _tmp123_;
																					_tmp123_ = st;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp123_, "CCode", "has_destroy_function", FALSE, NULL);
																				}
																			} else {
																				gchar** _tmp124_;
																				gint _tmp124__length1;
																				const gchar* _tmp125_;
																				_tmp124_ = nv;
																				_tmp124__length1 = nv_length1;
																				_tmp125_ = _tmp124_[0];
																				if (g_strcmp0 (_tmp125_, "experimental") == 0) {
																					gchar** _tmp126_;
																					gint _tmp126__length1;
																					const gchar* _tmp127_;
																					gchar* _tmp128_;
																					gchar* _tmp129_;
																					gboolean _tmp130_;
																					_tmp126_ = nv;
																					_tmp126__length1 = nv_length1;
																					_tmp127_ = _tmp126_[1];
																					_tmp128_ = vala_gidl_parser_eval (self, _tmp127_);
																					_tmp129_ = _tmp128_;
																					_tmp130_ = g_strcmp0 (_tmp129_, "1") == 0;
																					_g_free0 (_tmp129_);
																					if (_tmp130_) {
																						ValaStruct* _tmp131_;
																						_tmp131_ = st;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp131_, "Version", "experimental", TRUE, NULL);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp132_ = st;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp132_);
			_tmp133_ = self->priv->current_source_file;
			_tmp134_ = st;
			vala_source_file_add_node (_tmp133_, (ValaCodeNode*) _tmp134_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp135_ = st;
		_tmp136_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp135_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp136_;
		_tmp137_ = st_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp137_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp138_;
					_tmp138_ = member;
					if (_tmp138_->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp139_;
						ValaMethod* _tmp140_;
						ValaMethod* _tmp141_;
						_tmp139_ = member;
						_tmp140_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp139_, FALSE);
						m = _tmp140_;
						_tmp141_ = m;
						if (_tmp141_ != NULL) {
							ValaStruct* _tmp142_;
							ValaMethod* _tmp143_;
							_tmp142_ = st;
							_tmp143_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp142_, _tmp143_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp144_;
						_tmp144_ = member;
						if (_tmp144_->type == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp145_;
							ValaField* _tmp146_;
							ValaField* _tmp147_;
							_tmp145_ = member;
							_tmp146_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp145_);
							f = _tmp146_;
							_tmp147_ = f;
							if (_tmp147_ != NULL) {
								ValaStruct* _tmp148_;
								ValaField* _tmp149_;
								_tmp148_ = st;
								_tmp149_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp148_, _tmp149_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		ValaClass* cl = NULL;
		ValaScope* _tmp150_;
		ValaScope* _tmp151_;
		const gchar* _tmp152_;
		ValaSymbol* _tmp153_;
		ValaClass* _tmp154_;
		ValaClass* _tmp155_;
		ValaClass* _tmp310_;
		ValaTypeSymbol* _tmp311_;
		GList* _tmp312_;
		const gchar* _tmp361_;
		const gchar* _tmp368_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp150_ = vala_symbol_get_scope (container);
		_tmp151_ = _tmp150_;
		_tmp152_ = name;
		_tmp153_ = vala_scope_lookup (_tmp151_, _tmp152_);
		_tmp154_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp153_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp153_) : NULL;
		if (_tmp154_ == NULL) {
			_vala_code_node_unref0 (_tmp153_);
		}
		cl = _tmp154_;
		_tmp155_ = cl;
		if (_tmp155_ == NULL) {
			gchar* base_class = NULL;
			gboolean is_fundamental = FALSE;
			const gchar* _tmp156_;
			ValaSourceReference* _tmp157_;
			ValaClass* _tmp158_;
			ValaClass* _tmp159_;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp160_;
			const gchar* _tmp161_;
			gint _tmp162_ = 0;
			gchar** _tmp163_;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp164_;
			gint _tmp164__length1;
			ValaClass* _tmp299_;
			ValaSourceFile* _tmp300_;
			ValaClass* _tmp301_;
			const gchar* _tmp302_;
			gboolean _tmp307_ = FALSE;
			const gchar* _tmp308_;
			base_class = NULL;
			is_fundamental = FALSE;
			_tmp156_ = name;
			_tmp157_ = self->priv->current_source_reference;
			_tmp158_ = vala_class_new (_tmp156_, _tmp157_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp158_;
			_tmp159_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp159_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp160_ = node;
			_tmp161_ = _tmp160_->name;
			_tmp163_ = vala_gidl_parser_get_attributes (self, _tmp161_, &_tmp162_);
			cl_attributes = _tmp163_;
			cl_attributes_length1 = _tmp162_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp164_ = cl_attributes;
			_tmp164__length1 = cl_attributes_length1;
			if (_tmp164_ != NULL) {
				gchar** _tmp165_;
				gint _tmp165__length1;
				_tmp165_ = cl_attributes;
				_tmp165__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp165_;
					attr_collection_length1 = _tmp165__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp166_;
						gchar* attr = NULL;
						_tmp166_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp166_;
						{
							gchar** nv = NULL;
							const gchar* _tmp167_;
							gchar** _tmp168_;
							gchar** _tmp169_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp170_;
							gint _tmp170__length1;
							const gchar* _tmp171_;
							_tmp167_ = attr;
							_tmp169_ = _tmp168_ = g_strsplit (_tmp167_, "=", 2);
							nv = _tmp169_;
							nv_length1 = _vala_array_length (_tmp168_);
							_nv_size_ = nv_length1;
							_tmp170_ = nv;
							_tmp170__length1 = nv_length1;
							_tmp171_ = _tmp170_[0];
							if (g_strcmp0 (_tmp171_, "cheader_filename") == 0) {
								ValaClass* _tmp172_;
								gchar** _tmp173_;
								gint _tmp173__length1;
								const gchar* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								_tmp172_ = cl;
								_tmp173_ = nv;
								_tmp173__length1 = nv_length1;
								_tmp174_ = _tmp173_[1];
								_tmp175_ = vala_gidl_parser_eval (self, _tmp174_);
								_tmp176_ = _tmp175_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp172_, "CCode", "cheader_filename", _tmp176_, NULL);
								_g_free0 (_tmp176_);
							} else {
								gchar** _tmp177_;
								gint _tmp177__length1;
								const gchar* _tmp178_;
								_tmp177_ = nv;
								_tmp177__length1 = nv_length1;
								_tmp178_ = _tmp177_[0];
								if (g_strcmp0 (_tmp178_, "base_class") == 0) {
									gchar** _tmp179_;
									gint _tmp179__length1;
									const gchar* _tmp180_;
									gchar* _tmp181_;
									_tmp179_ = nv;
									_tmp179__length1 = nv_length1;
									_tmp180_ = _tmp179_[1];
									_tmp181_ = vala_gidl_parser_eval (self, _tmp180_);
									_g_free0 (base_class);
									base_class = _tmp181_;
								} else {
									gchar** _tmp182_;
									gint _tmp182__length1;
									const gchar* _tmp183_;
									_tmp182_ = nv;
									_tmp182__length1 = nv_length1;
									_tmp183_ = _tmp182_[0];
									if (g_strcmp0 (_tmp183_, "hidden") == 0) {
										gchar** _tmp184_;
										gint _tmp184__length1;
										const gchar* _tmp185_;
										gchar* _tmp186_;
										gchar* _tmp187_;
										gboolean _tmp188_;
										_tmp184_ = nv;
										_tmp184__length1 = nv_length1;
										_tmp185_ = _tmp184_[1];
										_tmp186_ = vala_gidl_parser_eval (self, _tmp185_);
										_tmp187_ = _tmp186_;
										_tmp188_ = g_strcmp0 (_tmp187_, "1") == 0;
										_g_free0 (_tmp187_);
										if (_tmp188_) {
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											_vala_code_node_unref0 (cl);
											_g_free0 (free_function);
											_g_free0 (copy_function);
											_g_free0 (unref_function);
											_g_free0 (ref_function);
											_g_free0 (name);
											return;
										}
									} else {
										gchar** _tmp189_;
										gint _tmp189__length1;
										const gchar* _tmp190_;
										_tmp189_ = nv;
										_tmp189__length1 = nv_length1;
										_tmp190_ = _tmp189_[0];
										if (g_strcmp0 (_tmp190_, "is_immutable") == 0) {
											gchar** _tmp191_;
											gint _tmp191__length1;
											const gchar* _tmp192_;
											gchar* _tmp193_;
											gchar* _tmp194_;
											gboolean _tmp195_;
											_tmp191_ = nv;
											_tmp191__length1 = nv_length1;
											_tmp192_ = _tmp191_[1];
											_tmp193_ = vala_gidl_parser_eval (self, _tmp192_);
											_tmp194_ = _tmp193_;
											_tmp195_ = g_strcmp0 (_tmp194_, "1") == 0;
											_g_free0 (_tmp194_);
											if (_tmp195_) {
												ValaClass* _tmp196_;
												_tmp196_ = cl;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp196_, "Immutable", TRUE, NULL);
											}
										} else {
											gchar** _tmp197_;
											gint _tmp197__length1;
											const gchar* _tmp198_;
											_tmp197_ = nv;
											_tmp197__length1 = nv_length1;
											_tmp198_ = _tmp197_[0];
											if (g_strcmp0 (_tmp198_, "const_cname") == 0) {
												ValaClass* _tmp199_;
												gchar** _tmp200_;
												gint _tmp200__length1;
												const gchar* _tmp201_;
												gchar* _tmp202_;
												gchar* _tmp203_;
												_tmp199_ = cl;
												_tmp200_ = nv;
												_tmp200__length1 = nv_length1;
												_tmp201_ = _tmp200_[1];
												_tmp202_ = vala_gidl_parser_eval (self, _tmp201_);
												_tmp203_ = _tmp202_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp199_, "CCode", "const_cname", _tmp203_, NULL);
												_g_free0 (_tmp203_);
											} else {
												gchar** _tmp204_;
												gint _tmp204__length1;
												const gchar* _tmp205_;
												_tmp204_ = nv;
												_tmp204__length1 = nv_length1;
												_tmp205_ = _tmp204_[0];
												if (g_strcmp0 (_tmp205_, "is_fundamental") == 0) {
													gchar** _tmp206_;
													gint _tmp206__length1;
													const gchar* _tmp207_;
													gchar* _tmp208_;
													gchar* _tmp209_;
													gboolean _tmp210_;
													_tmp206_ = nv;
													_tmp206__length1 = nv_length1;
													_tmp207_ = _tmp206_[1];
													_tmp208_ = vala_gidl_parser_eval (self, _tmp207_);
													_tmp209_ = _tmp208_;
													_tmp210_ = g_strcmp0 (_tmp209_, "1") == 0;
													_g_free0 (_tmp209_);
													if (_tmp210_) {
														is_fundamental = TRUE;
													}
												} else {
													gboolean _tmp211_ = FALSE;
													gchar** _tmp212_;
													gint _tmp212__length1;
													const gchar* _tmp213_;
													_tmp212_ = nv;
													_tmp212__length1 = nv_length1;
													_tmp213_ = _tmp212_[0];
													if (g_strcmp0 (_tmp213_, "abstract") == 0) {
														const gchar* _tmp214_;
														_tmp214_ = base_class;
														_tmp211_ = _tmp214_ != NULL;
													} else {
														_tmp211_ = FALSE;
													}
													if (_tmp211_) {
														gchar** _tmp215_;
														gint _tmp215__length1;
														const gchar* _tmp216_;
														gchar* _tmp217_;
														gchar* _tmp218_;
														gboolean _tmp219_;
														_tmp215_ = nv;
														_tmp215__length1 = nv_length1;
														_tmp216_ = _tmp215_[1];
														_tmp217_ = vala_gidl_parser_eval (self, _tmp216_);
														_tmp218_ = _tmp217_;
														_tmp219_ = g_strcmp0 (_tmp218_, "1") == 0;
														_g_free0 (_tmp218_);
														if (_tmp219_) {
															ValaClass* _tmp220_;
															_tmp220_ = cl;
															vala_class_set_is_abstract (_tmp220_, TRUE);
														}
													} else {
														gchar** _tmp221_;
														gint _tmp221__length1;
														const gchar* _tmp222_;
														_tmp221_ = nv;
														_tmp221__length1 = nv_length1;
														_tmp222_ = _tmp221_[0];
														if (g_strcmp0 (_tmp222_, "free_function") == 0) {
															gchar** _tmp223_;
															gint _tmp223__length1;
															const gchar* _tmp224_;
															gchar* _tmp225_;
															_tmp223_ = nv;
															_tmp223__length1 = nv_length1;
															_tmp224_ = _tmp223_[1];
															_tmp225_ = vala_gidl_parser_eval (self, _tmp224_);
															_g_free0 (free_function);
															free_function = _tmp225_;
														} else {
															gchar** _tmp226_;
															gint _tmp226__length1;
															const gchar* _tmp227_;
															_tmp226_ = nv;
															_tmp226__length1 = nv_length1;
															_tmp227_ = _tmp226_[0];
															if (g_strcmp0 (_tmp227_, "ref_function") == 0) {
																gchar** _tmp228_;
																gint _tmp228__length1;
																const gchar* _tmp229_;
																gchar* _tmp230_;
																_tmp228_ = nv;
																_tmp228__length1 = nv_length1;
																_tmp229_ = _tmp228_[1];
																_tmp230_ = vala_gidl_parser_eval (self, _tmp229_);
																_g_free0 (ref_function);
																ref_function = _tmp230_;
															} else {
																gchar** _tmp231_;
																gint _tmp231__length1;
																const gchar* _tmp232_;
																_tmp231_ = nv;
																_tmp231__length1 = nv_length1;
																_tmp232_ = _tmp231_[0];
																if (g_strcmp0 (_tmp232_, "unref_function") == 0) {
																	gchar** _tmp233_;
																	gint _tmp233__length1;
																	const gchar* _tmp234_;
																	gchar* _tmp235_;
																	_tmp233_ = nv;
																	_tmp233__length1 = nv_length1;
																	_tmp234_ = _tmp233_[1];
																	_tmp235_ = vala_gidl_parser_eval (self, _tmp234_);
																	_g_free0 (unref_function);
																	unref_function = _tmp235_;
																} else {
																	gchar** _tmp236_;
																	gint _tmp236__length1;
																	const gchar* _tmp237_;
																	_tmp236_ = nv;
																	_tmp236__length1 = nv_length1;
																	_tmp237_ = _tmp236_[0];
																	if (g_strcmp0 (_tmp237_, "copy_function") == 0) {
																		gchar** _tmp238_;
																		gint _tmp238__length1;
																		const gchar* _tmp239_;
																		gchar* _tmp240_;
																		_tmp238_ = nv;
																		_tmp238__length1 = nv_length1;
																		_tmp239_ = _tmp238_[1];
																		_tmp240_ = vala_gidl_parser_eval (self, _tmp239_);
																		_g_free0 (copy_function);
																		copy_function = _tmp240_;
																	} else {
																		gchar** _tmp241_;
																		gint _tmp241__length1;
																		const gchar* _tmp242_;
																		_tmp241_ = nv;
																		_tmp241__length1 = nv_length1;
																		_tmp242_ = _tmp241_[0];
																		if (g_strcmp0 (_tmp242_, "ref_function_void") == 0) {
																			gchar** _tmp243_;
																			gint _tmp243__length1;
																			const gchar* _tmp244_;
																			gchar* _tmp245_;
																			gchar* _tmp246_;
																			gboolean _tmp247_;
																			_tmp243_ = nv;
																			_tmp243__length1 = nv_length1;
																			_tmp244_ = _tmp243_[1];
																			_tmp245_ = vala_gidl_parser_eval (self, _tmp244_);
																			_tmp246_ = _tmp245_;
																			_tmp247_ = g_strcmp0 (_tmp246_, "1") == 0;
																			_g_free0 (_tmp246_);
																			if (_tmp247_) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			gchar** _tmp248_;
																			gint _tmp248__length1;
																			const gchar* _tmp249_;
																			_tmp248_ = nv;
																			_tmp248__length1 = nv_length1;
																			_tmp249_ = _tmp248_[0];
																			if (g_strcmp0 (_tmp249_, "deprecated") == 0) {
																				gchar** _tmp250_;
																				gint _tmp250__length1;
																				const gchar* _tmp251_;
																				gchar* _tmp252_;
																				gchar* _tmp253_;
																				gboolean _tmp254_;
																				_tmp250_ = nv;
																				_tmp250__length1 = nv_length1;
																				_tmp251_ = _tmp250_[1];
																				_tmp252_ = vala_gidl_parser_eval (self, _tmp251_);
																				_tmp253_ = _tmp252_;
																				_tmp254_ = g_strcmp0 (_tmp253_, "1") == 0;
																				_g_free0 (_tmp253_);
																				if (_tmp254_) {
																					ValaClass* _tmp255_;
																					_tmp255_ = cl;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp255_, "Version", "deprecated", TRUE, NULL);
																				}
																			} else {
																				gchar** _tmp256_;
																				gint _tmp256__length1;
																				const gchar* _tmp257_;
																				_tmp256_ = nv;
																				_tmp256__length1 = nv_length1;
																				_tmp257_ = _tmp256_[0];
																				if (g_strcmp0 (_tmp257_, "replacement") == 0) {
																					ValaClass* _tmp258_;
																					gchar** _tmp259_;
																					gint _tmp259__length1;
																					const gchar* _tmp260_;
																					gchar* _tmp261_;
																					gchar* _tmp262_;
																					_tmp258_ = cl;
																					_tmp259_ = nv;
																					_tmp259__length1 = nv_length1;
																					_tmp260_ = _tmp259_[1];
																					_tmp261_ = vala_gidl_parser_eval (self, _tmp260_);
																					_tmp262_ = _tmp261_;
																					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp258_, "Version", "replacement", _tmp262_, NULL);
																					_g_free0 (_tmp262_);
																				} else {
																					gchar** _tmp263_;
																					gint _tmp263__length1;
																					const gchar* _tmp264_;
																					_tmp263_ = nv;
																					_tmp263__length1 = nv_length1;
																					_tmp264_ = _tmp263_[0];
																					if (g_strcmp0 (_tmp264_, "deprecated_since") == 0) {
																						ValaClass* _tmp265_;
																						gchar** _tmp266_;
																						gint _tmp266__length1;
																						const gchar* _tmp267_;
																						gchar* _tmp268_;
																						gchar* _tmp269_;
																						_tmp265_ = cl;
																						_tmp266_ = nv;
																						_tmp266__length1 = nv_length1;
																						_tmp267_ = _tmp266_[1];
																						_tmp268_ = vala_gidl_parser_eval (self, _tmp267_);
																						_tmp269_ = _tmp268_;
																						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp265_, "Version", "deprecated_since", _tmp269_, NULL);
																						_g_free0 (_tmp269_);
																					} else {
																						gchar** _tmp270_;
																						gint _tmp270__length1;
																						const gchar* _tmp271_;
																						_tmp270_ = nv;
																						_tmp270__length1 = nv_length1;
																						_tmp271_ = _tmp270_[0];
																						if (g_strcmp0 (_tmp271_, "type_parameters") == 0) {
																							gchar** _tmp272_;
																							gint _tmp272__length1;
																							const gchar* _tmp273_;
																							gchar* _tmp274_;
																							gchar* _tmp275_;
																							gchar** _tmp276_;
																							gchar** _tmp277_;
																							gchar** _tmp278_;
																							gint _tmp278__length1;
																							_tmp272_ = nv;
																							_tmp272__length1 = nv_length1;
																							_tmp273_ = _tmp272_[1];
																							_tmp274_ = vala_gidl_parser_eval (self, _tmp273_);
																							_tmp275_ = _tmp274_;
																							_tmp277_ = _tmp276_ = g_strsplit (_tmp275_, ",", 0);
																							_tmp278_ = _tmp277_;
																							_tmp278__length1 = _vala_array_length (_tmp276_);
																							_g_free0 (_tmp275_);
																							{
																								gchar** type_param_name_collection = NULL;
																								gint type_param_name_collection_length1 = 0;
																								gint _type_param_name_collection_size_ = 0;
																								gint type_param_name_it = 0;
																								type_param_name_collection = _tmp278_;
																								type_param_name_collection_length1 = _tmp278__length1;
																								for (type_param_name_it = 0; type_param_name_it < type_param_name_collection_length1; type_param_name_it = type_param_name_it + 1) {
																									const gchar* type_param_name = NULL;
																									type_param_name = type_param_name_collection[type_param_name_it];
																									{
																										ValaClass* _tmp279_;
																										const gchar* _tmp280_;
																										ValaSourceReference* _tmp281_;
																										ValaTypeParameter* _tmp282_;
																										ValaTypeParameter* _tmp283_;
																										_tmp279_ = cl;
																										_tmp280_ = type_param_name;
																										_tmp281_ = self->priv->current_source_reference;
																										_tmp282_ = vala_typeparameter_new (_tmp280_, _tmp281_);
																										_tmp283_ = _tmp282_;
																										vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) _tmp279_, _tmp283_);
																										_vala_code_node_unref0 (_tmp283_);
																									}
																								}
																								type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						} else {
																							gchar** _tmp284_;
																							gint _tmp284__length1;
																							const gchar* _tmp285_;
																							_tmp284_ = nv;
																							_tmp284__length1 = nv_length1;
																							_tmp285_ = _tmp284_[0];
																							if (g_strcmp0 (_tmp285_, "experimental") == 0) {
																								gchar** _tmp286_;
																								gint _tmp286__length1;
																								const gchar* _tmp287_;
																								gchar* _tmp288_;
																								gchar* _tmp289_;
																								gboolean _tmp290_;
																								_tmp286_ = nv;
																								_tmp286__length1 = nv_length1;
																								_tmp287_ = _tmp286_[1];
																								_tmp288_ = vala_gidl_parser_eval (self, _tmp287_);
																								_tmp289_ = _tmp288_;
																								_tmp290_ = g_strcmp0 (_tmp289_, "1") == 0;
																								_g_free0 (_tmp289_);
																								if (_tmp290_) {
																									ValaClass* _tmp291_;
																									_tmp291_ = cl;
																									vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp291_, "Version", "experimental", TRUE, NULL);
																								}
																							} else {
																								gchar** _tmp292_;
																								gint _tmp292__length1;
																								const gchar* _tmp293_;
																								_tmp292_ = nv;
																								_tmp292__length1 = nv_length1;
																								_tmp293_ = _tmp292_[0];
																								if (g_strcmp0 (_tmp293_, "delegate_target_cname") == 0) {
																									ValaClass* _tmp294_;
																									gchar** _tmp295_;
																									gint _tmp295__length1;
																									const gchar* _tmp296_;
																									gchar* _tmp297_;
																									gchar* _tmp298_;
																									_tmp294_ = cl;
																									_tmp295_ = nv;
																									_tmp295__length1 = nv_length1;
																									_tmp296_ = _tmp295_[1];
																									_tmp297_ = vala_gidl_parser_eval (self, _tmp296_);
																									_tmp298_ = _tmp297_;
																									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp294_, "CCode", "delegate_target_cname", _tmp298_, NULL);
																									_g_free0 (_tmp298_);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp299_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp299_);
			_tmp300_ = self->priv->current_source_file;
			_tmp301_ = cl;
			vala_source_file_add_node (_tmp300_, (ValaCodeNode*) _tmp301_);
			_tmp302_ = base_class;
			if (_tmp302_ != NULL) {
				ValaDataType* parent = NULL;
				const gchar* _tmp303_;
				ValaDataType* _tmp304_;
				ValaClass* _tmp305_;
				ValaDataType* _tmp306_;
				_tmp303_ = base_class;
				_tmp304_ = vala_gidl_parser_parse_type_string (self, _tmp303_);
				parent = _tmp304_;
				_tmp305_ = cl;
				_tmp306_ = parent;
				vala_class_add_base_type (_tmp305_, _tmp306_);
				_vala_code_node_unref0 (parent);
			}
			_tmp308_ = base_class;
			if (_tmp308_ == NULL) {
				_tmp307_ = !is_fundamental;
			} else {
				_tmp307_ = FALSE;
			}
			if (_tmp307_) {
				ValaClass* _tmp309_;
				_tmp309_ = cl;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp309_, "Compact", TRUE, NULL);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp310_ = cl;
		_tmp311_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp310_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp311_;
		_tmp312_ = st_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp312_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp313_;
					_tmp313_ = member;
					if (_tmp313_->type == G_IDL_NODE_FUNCTION) {
						gboolean _tmp314_ = FALSE;
						const gchar* _tmp315_;
						_tmp315_ = ref_function;
						if (_tmp315_ == NULL) {
							GIdlNode* _tmp316_;
							const gchar* _tmp317_;
							_tmp316_ = member;
							_tmp317_ = _tmp316_->name;
							_tmp314_ = g_strcmp0 (_tmp317_, "ref") == 0;
						} else {
							_tmp314_ = FALSE;
						}
						if (_tmp314_) {
							GIdlNode* _tmp318_;
							const gchar* _tmp319_;
							gchar* _tmp320_;
							GIdlNode* _tmp321_;
							GIdlNodeParam* _tmp322_;
							GIdlNodeType* _tmp323_;
							ValaDataType* _tmp324_;
							ValaDataType* _tmp325_;
							_tmp318_ = member;
							_tmp319_ = ((GIdlNodeFunction*) _tmp318_)->symbol;
							_tmp320_ = g_strdup (_tmp319_);
							_g_free0 (ref_function);
							ref_function = _tmp320_;
							_tmp321_ = member;
							_tmp322_ = ((GIdlNodeFunction*) _tmp321_)->result;
							_tmp323_ = _tmp322_->type;
							_tmp324_ = vala_gidl_parser_parse_type (self, _tmp323_, NULL);
							_tmp325_ = _tmp324_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp325_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp325_);
						} else {
							gboolean _tmp326_ = FALSE;
							const gchar* _tmp327_;
							_tmp327_ = unref_function;
							if (_tmp327_ == NULL) {
								GIdlNode* _tmp328_;
								const gchar* _tmp329_;
								_tmp328_ = member;
								_tmp329_ = _tmp328_->name;
								_tmp326_ = g_strcmp0 (_tmp329_, "unref") == 0;
							} else {
								_tmp326_ = FALSE;
							}
							if (_tmp326_) {
								GIdlNode* _tmp330_;
								const gchar* _tmp331_;
								gchar* _tmp332_;
								_tmp330_ = member;
								_tmp331_ = ((GIdlNodeFunction*) _tmp330_)->symbol;
								_tmp332_ = g_strdup (_tmp331_);
								_g_free0 (unref_function);
								unref_function = _tmp332_;
							} else {
								gboolean _tmp333_ = FALSE;
								const gchar* _tmp334_;
								_tmp334_ = free_function;
								if (_tmp334_ == NULL) {
									gboolean _tmp335_ = FALSE;
									GIdlNode* _tmp336_;
									const gchar* _tmp337_;
									_tmp336_ = member;
									_tmp337_ = _tmp336_->name;
									if (g_strcmp0 (_tmp337_, "free") == 0) {
										_tmp335_ = TRUE;
									} else {
										GIdlNode* _tmp338_;
										const gchar* _tmp339_;
										_tmp338_ = member;
										_tmp339_ = _tmp338_->name;
										_tmp335_ = g_strcmp0 (_tmp339_, "destroy") == 0;
									}
									_tmp333_ = _tmp335_;
								} else {
									_tmp333_ = FALSE;
								}
								if (_tmp333_) {
									GIdlNode* _tmp340_;
									const gchar* _tmp341_;
									gchar* _tmp342_;
									_tmp340_ = member;
									_tmp341_ = ((GIdlNodeFunction*) _tmp340_)->symbol;
									_tmp342_ = g_strdup (_tmp341_);
									_g_free0 (free_function);
									free_function = _tmp342_;
								} else {
									gboolean _tmp343_ = FALSE;
									const gchar* _tmp344_;
									ValaMethod* m = NULL;
									GIdlNode* _tmp350_;
									ValaMethod* _tmp351_;
									ValaMethod* _tmp352_;
									_tmp344_ = copy_function;
									if (_tmp344_ == NULL) {
										GIdlNode* _tmp345_;
										const gchar* _tmp346_;
										_tmp345_ = member;
										_tmp346_ = _tmp345_->name;
										_tmp343_ = g_strcmp0 (_tmp346_, "copy") == 0;
									} else {
										_tmp343_ = FALSE;
									}
									if (_tmp343_) {
										GIdlNode* _tmp347_;
										const gchar* _tmp348_;
										gchar* _tmp349_;
										_tmp347_ = member;
										_tmp348_ = ((GIdlNodeFunction*) _tmp347_)->symbol;
										_tmp349_ = g_strdup (_tmp348_);
										_g_free0 (copy_function);
										copy_function = _tmp349_;
									}
									_tmp350_ = member;
									_tmp351_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp350_, FALSE);
									m = _tmp351_;
									_tmp352_ = m;
									if (_tmp352_ != NULL) {
										ValaClass* _tmp353_;
										ValaMethod* _tmp354_;
										_tmp353_ = cl;
										_tmp354_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp353_, _tmp354_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp355_;
						_tmp355_ = member;
						if (_tmp355_->type == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp356_;
							ValaField* _tmp357_;
							ValaField* _tmp358_;
							_tmp356_ = member;
							_tmp357_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp356_);
							f = _tmp357_;
							_tmp358_ = f;
							if (_tmp358_ != NULL) {
								ValaClass* _tmp359_;
								ValaField* _tmp360_;
								_tmp359_ = cl;
								_tmp360_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp359_, _tmp360_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp361_ = ref_function;
		if (_tmp361_ != NULL) {
			ValaClass* _tmp362_;
			const gchar* _tmp363_;
			_tmp362_ = cl;
			_tmp363_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp362_, "CCode", "ref_function", _tmp363_, NULL);
			if (ref_function_void) {
				ValaClass* _tmp364_;
				_tmp364_ = cl;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp364_, "CCode", "ref_function_void", ref_function_void, NULL);
			}
		} else {
			const gchar* _tmp365_;
			_tmp365_ = copy_function;
			if (_tmp365_ != NULL) {
				ValaClass* _tmp366_;
				const gchar* _tmp367_;
				_tmp366_ = cl;
				_tmp367_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp366_, "CCode", "copy_function", _tmp367_, NULL);
			}
		}
		_tmp368_ = unref_function;
		if (_tmp368_ != NULL) {
			ValaClass* _tmp369_;
			const gchar* _tmp370_;
			_tmp369_ = cl;
			_tmp370_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp369_, "CCode", "unref_function", _tmp370_, NULL);
		} else {
			gboolean _tmp371_ = FALSE;
			const gchar* _tmp372_;
			_tmp372_ = free_function;
			if (_tmp372_ != NULL) {
				const gchar* _tmp373_;
				ValaClass* _tmp374_;
				gchar* _tmp375_;
				gchar* _tmp376_;
				gchar* _tmp377_;
				gchar* _tmp378_;
				_tmp373_ = free_function;
				_tmp374_ = cl;
				_tmp375_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp374_);
				_tmp376_ = _tmp375_;
				_tmp377_ = g_strdup_printf ("%sfree", _tmp376_);
				_tmp378_ = _tmp377_;
				_tmp371_ = g_strcmp0 (_tmp373_, _tmp378_) != 0;
				_g_free0 (_tmp378_);
				_g_free0 (_tmp376_);
			} else {
				_tmp371_ = FALSE;
			}
			if (_tmp371_) {
				ValaClass* _tmp379_;
				const gchar* _tmp380_;
				_tmp379_ = cl;
				_tmp380_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp379_, "CCode", "free_function", _tmp380_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	_g_free0 (name);
}

static void
vala_gidl_parser_parse_union (ValaGIdlParser* self,
                              GIdlNodeUnion* un_node,
                              ValaSymbol* container,
                              GIdlModule* module)
{
	GIdlNode* node = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) un_node;
	if (un_node->deprecated) {
		return;
	}
	_tmp0_ = node;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
	name = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	if (!vala_gidl_parser_is_reference_type (self, _tmp4_)) {
		ValaStruct* st = NULL;
		ValaScope* _tmp5_;
		ValaScope* _tmp6_;
		const gchar* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaStruct* _tmp10_;
		ValaStruct* _tmp72_;
		ValaTypeSymbol* _tmp73_;
		GList* _tmp74_;
		_tmp5_ = vala_symbol_get_scope (container);
		_tmp6_ = _tmp5_;
		_tmp7_ = name;
		_tmp8_ = vala_scope_lookup (_tmp6_, _tmp7_);
		_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp8_) : NULL;
		if (_tmp9_ == NULL) {
			_vala_code_node_unref0 (_tmp8_);
		}
		st = _tmp9_;
		_tmp10_ = st;
		if (_tmp10_ == NULL) {
			const gchar* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaStruct* _tmp13_;
			ValaStruct* _tmp14_;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp15_;
			const gchar* _tmp16_;
			gint _tmp17_ = 0;
			gchar** _tmp18_;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			ValaStruct* _tmp69_;
			ValaSourceFile* _tmp70_;
			ValaStruct* _tmp71_;
			_tmp11_ = name;
			_tmp12_ = self->priv->current_source_reference;
			_tmp13_ = vala_struct_new (_tmp11_, _tmp12_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp13_;
			_tmp14_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp15_ = node;
			_tmp16_ = _tmp15_->name;
			_tmp18_ = vala_gidl_parser_get_attributes (self, _tmp16_, &_tmp17_);
			st_attributes = _tmp18_;
			st_attributes_length1 = _tmp17_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp19_ = st_attributes;
			_tmp19__length1 = st_attributes_length1;
			if (_tmp19_ != NULL) {
				gchar** _tmp20_;
				gint _tmp20__length1;
				_tmp20_ = st_attributes;
				_tmp20__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp20_;
					attr_collection_length1 = _tmp20__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp21_;
						gchar* attr = NULL;
						_tmp21_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp21_;
						{
							gchar** nv = NULL;
							const gchar* _tmp22_;
							gchar** _tmp23_;
							gchar** _tmp24_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp25_;
							gint _tmp25__length1;
							const gchar* _tmp26_;
							_tmp22_ = attr;
							_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "=", 2);
							nv = _tmp24_;
							nv_length1 = _vala_array_length (_tmp23_);
							_nv_size_ = nv_length1;
							_tmp25_ = nv;
							_tmp25__length1 = nv_length1;
							_tmp26_ = _tmp25_[0];
							if (g_strcmp0 (_tmp26_, "cheader_filename") == 0) {
								ValaStruct* _tmp27_;
								gchar** _tmp28_;
								gint _tmp28__length1;
								const gchar* _tmp29_;
								gchar* _tmp30_;
								gchar* _tmp31_;
								_tmp27_ = st;
								_tmp28_ = nv;
								_tmp28__length1 = nv_length1;
								_tmp29_ = _tmp28_[1];
								_tmp30_ = vala_gidl_parser_eval (self, _tmp29_);
								_tmp31_ = _tmp30_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp27_, "CCode", "cheader_filename", _tmp31_, NULL);
								_g_free0 (_tmp31_);
							} else {
								gchar** _tmp32_;
								gint _tmp32__length1;
								const gchar* _tmp33_;
								_tmp32_ = nv;
								_tmp32__length1 = nv_length1;
								_tmp33_ = _tmp32_[0];
								if (g_strcmp0 (_tmp33_, "deprecated") == 0) {
									gchar** _tmp34_;
									gint _tmp34__length1;
									const gchar* _tmp35_;
									gchar* _tmp36_;
									gchar* _tmp37_;
									gboolean _tmp38_;
									_tmp34_ = nv;
									_tmp34__length1 = nv_length1;
									_tmp35_ = _tmp34_[1];
									_tmp36_ = vala_gidl_parser_eval (self, _tmp35_);
									_tmp37_ = _tmp36_;
									_tmp38_ = g_strcmp0 (_tmp37_, "1") == 0;
									_g_free0 (_tmp37_);
									if (_tmp38_) {
										ValaStruct* _tmp39_;
										_tmp39_ = st;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp39_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp40_;
									gint _tmp40__length1;
									const gchar* _tmp41_;
									_tmp40_ = nv;
									_tmp40__length1 = nv_length1;
									_tmp41_ = _tmp40_[0];
									if (g_strcmp0 (_tmp41_, "replacement") == 0) {
										ValaStruct* _tmp42_;
										gchar** _tmp43_;
										gint _tmp43__length1;
										const gchar* _tmp44_;
										gchar* _tmp45_;
										gchar* _tmp46_;
										_tmp42_ = st;
										_tmp43_ = nv;
										_tmp43__length1 = nv_length1;
										_tmp44_ = _tmp43_[1];
										_tmp45_ = vala_gidl_parser_eval (self, _tmp44_);
										_tmp46_ = _tmp45_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp42_, "Version", "replacement", _tmp46_, NULL);
										_g_free0 (_tmp46_);
									} else {
										gchar** _tmp47_;
										gint _tmp47__length1;
										const gchar* _tmp48_;
										_tmp47_ = nv;
										_tmp47__length1 = nv_length1;
										_tmp48_ = _tmp47_[0];
										if (g_strcmp0 (_tmp48_, "deprecated_since") == 0) {
											ValaStruct* _tmp49_;
											gchar** _tmp50_;
											gint _tmp50__length1;
											const gchar* _tmp51_;
											gchar* _tmp52_;
											gchar* _tmp53_;
											_tmp49_ = st;
											_tmp50_ = nv;
											_tmp50__length1 = nv_length1;
											_tmp51_ = _tmp50_[1];
											_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
											_tmp53_ = _tmp52_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp49_, "Version", "deprecated_since", _tmp53_, NULL);
											_g_free0 (_tmp53_);
										} else {
											gchar** _tmp54_;
											gint _tmp54__length1;
											const gchar* _tmp55_;
											_tmp54_ = nv;
											_tmp54__length1 = nv_length1;
											_tmp55_ = _tmp54_[0];
											if (g_strcmp0 (_tmp55_, "hidden") == 0) {
												gchar** _tmp56_;
												gint _tmp56__length1;
												const gchar* _tmp57_;
												gchar* _tmp58_;
												gchar* _tmp59_;
												gboolean _tmp60_;
												_tmp56_ = nv;
												_tmp56__length1 = nv_length1;
												_tmp57_ = _tmp56_[1];
												_tmp58_ = vala_gidl_parser_eval (self, _tmp57_);
												_tmp59_ = _tmp58_;
												_tmp60_ = g_strcmp0 (_tmp59_, "1") == 0;
												_g_free0 (_tmp59_);
												if (_tmp60_) {
													nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (attr);
													st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
													_vala_code_node_unref0 (st);
													_g_free0 (name);
													return;
												}
											} else {
												gchar** _tmp61_;
												gint _tmp61__length1;
												const gchar* _tmp62_;
												_tmp61_ = nv;
												_tmp61__length1 = nv_length1;
												_tmp62_ = _tmp61_[0];
												if (g_strcmp0 (_tmp62_, "experimental") == 0) {
													gchar** _tmp63_;
													gint _tmp63__length1;
													const gchar* _tmp64_;
													gchar* _tmp65_;
													gchar* _tmp66_;
													gboolean _tmp67_;
													_tmp63_ = nv;
													_tmp63__length1 = nv_length1;
													_tmp64_ = _tmp63_[1];
													_tmp65_ = vala_gidl_parser_eval (self, _tmp64_);
													_tmp66_ = _tmp65_;
													_tmp67_ = g_strcmp0 (_tmp66_, "1") == 0;
													_g_free0 (_tmp66_);
													if (_tmp67_) {
														ValaStruct* _tmp68_;
														_tmp68_ = st;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp68_, "Version", "experimental", TRUE, NULL);
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp69_ = st;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp69_);
			_tmp70_ = self->priv->current_source_file;
			_tmp71_ = st;
			vala_source_file_add_node (_tmp70_, (ValaCodeNode*) _tmp71_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp72_ = st;
		_tmp73_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp72_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp73_;
		_tmp74_ = un_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp74_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp75_;
					_tmp75_ = member;
					if (_tmp75_->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp76_;
						ValaMethod* _tmp77_;
						ValaMethod* _tmp78_;
						_tmp76_ = member;
						_tmp77_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp76_, FALSE);
						m = _tmp77_;
						_tmp78_ = m;
						if (_tmp78_ != NULL) {
							ValaStruct* _tmp79_;
							ValaMethod* _tmp80_;
							_tmp79_ = st;
							_tmp80_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp79_, _tmp80_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp81_;
						_tmp81_ = member;
						if (_tmp81_->type == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp82_;
							ValaField* _tmp83_;
							ValaField* _tmp84_;
							_tmp82_ = member;
							_tmp83_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp82_);
							f = _tmp83_;
							_tmp84_ = f;
							if (_tmp84_ != NULL) {
								ValaStruct* _tmp85_;
								ValaField* _tmp86_;
								_tmp85_ = st;
								_tmp86_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp85_, _tmp86_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		ValaClass* cl = NULL;
		ValaScope* _tmp87_;
		ValaScope* _tmp88_;
		const gchar* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaClass* _tmp91_;
		ValaClass* _tmp92_;
		ValaClass* _tmp125_;
		ValaTypeSymbol* _tmp126_;
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		GList* _tmp127_;
		const gchar* _tmp168_;
		const gchar* _tmp175_;
		_tmp87_ = vala_symbol_get_scope (container);
		_tmp88_ = _tmp87_;
		_tmp89_ = name;
		_tmp90_ = vala_scope_lookup (_tmp88_, _tmp89_);
		_tmp91_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp90_) : NULL;
		if (_tmp91_ == NULL) {
			_vala_code_node_unref0 (_tmp90_);
		}
		cl = _tmp91_;
		_tmp92_ = cl;
		if (_tmp92_ == NULL) {
			const gchar* _tmp93_;
			ValaSourceReference* _tmp94_;
			ValaClass* _tmp95_;
			ValaClass* _tmp96_;
			ValaClass* _tmp97_;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp98_;
			const gchar* _tmp99_;
			gint _tmp100_ = 0;
			gchar** _tmp101_;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp102_;
			gint _tmp102__length1;
			ValaClass* _tmp122_;
			ValaSourceFile* _tmp123_;
			ValaClass* _tmp124_;
			_tmp93_ = name;
			_tmp94_ = self->priv->current_source_reference;
			_tmp95_ = vala_class_new (_tmp93_, _tmp94_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp95_;
			_tmp96_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp96_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp97_ = cl;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp97_, "Compact", TRUE, NULL);
			_tmp98_ = node;
			_tmp99_ = _tmp98_->name;
			_tmp101_ = vala_gidl_parser_get_attributes (self, _tmp99_, &_tmp100_);
			cl_attributes = _tmp101_;
			cl_attributes_length1 = _tmp100_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp102_ = cl_attributes;
			_tmp102__length1 = cl_attributes_length1;
			if (_tmp102_ != NULL) {
				gchar** _tmp103_;
				gint _tmp103__length1;
				_tmp103_ = cl_attributes;
				_tmp103__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp103_;
					attr_collection_length1 = _tmp103__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp104_;
						gchar* attr = NULL;
						_tmp104_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp104_;
						{
							gchar** nv = NULL;
							const gchar* _tmp105_;
							gchar** _tmp106_;
							gchar** _tmp107_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp108_;
							gint _tmp108__length1;
							const gchar* _tmp109_;
							_tmp105_ = attr;
							_tmp107_ = _tmp106_ = g_strsplit (_tmp105_, "=", 2);
							nv = _tmp107_;
							nv_length1 = _vala_array_length (_tmp106_);
							_nv_size_ = nv_length1;
							_tmp108_ = nv;
							_tmp108__length1 = nv_length1;
							_tmp109_ = _tmp108_[0];
							if (g_strcmp0 (_tmp109_, "cheader_filename") == 0) {
								ValaClass* _tmp110_;
								gchar** _tmp111_;
								gint _tmp111__length1;
								const gchar* _tmp112_;
								gchar* _tmp113_;
								gchar* _tmp114_;
								_tmp110_ = cl;
								_tmp111_ = nv;
								_tmp111__length1 = nv_length1;
								_tmp112_ = _tmp111_[1];
								_tmp113_ = vala_gidl_parser_eval (self, _tmp112_);
								_tmp114_ = _tmp113_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp110_, "CCode", "cheader_filename", _tmp114_, NULL);
								_g_free0 (_tmp114_);
							} else {
								gchar** _tmp115_;
								gint _tmp115__length1;
								const gchar* _tmp116_;
								_tmp115_ = nv;
								_tmp115__length1 = nv_length1;
								_tmp116_ = _tmp115_[0];
								if (g_strcmp0 (_tmp116_, "hidden") == 0) {
									gchar** _tmp117_;
									gint _tmp117__length1;
									const gchar* _tmp118_;
									gchar* _tmp119_;
									gchar* _tmp120_;
									gboolean _tmp121_;
									_tmp117_ = nv;
									_tmp117__length1 = nv_length1;
									_tmp118_ = _tmp117_[1];
									_tmp119_ = vala_gidl_parser_eval (self, _tmp118_);
									_tmp120_ = _tmp119_;
									_tmp121_ = g_strcmp0 (_tmp120_, "1") == 0;
									_g_free0 (_tmp120_);
									if (_tmp121_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp122_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp122_);
			_tmp123_ = self->priv->current_source_file;
			_tmp124_ = cl;
			vala_source_file_add_node (_tmp123_, (ValaCodeNode*) _tmp124_);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp125_ = cl;
		_tmp126_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp125_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp126_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp127_ = un_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp127_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp128_;
					_tmp128_ = member;
					if (_tmp128_->type == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp129_;
						const gchar* _tmp130_;
						_tmp129_ = member;
						_tmp130_ = _tmp129_->name;
						if (g_strcmp0 (_tmp130_, "ref") == 0) {
							GIdlNode* _tmp131_;
							const gchar* _tmp132_;
							gchar* _tmp133_;
							GIdlNode* _tmp134_;
							GIdlNodeParam* _tmp135_;
							GIdlNodeType* _tmp136_;
							ValaDataType* _tmp137_;
							ValaDataType* _tmp138_;
							_tmp131_ = member;
							_tmp132_ = ((GIdlNodeFunction*) _tmp131_)->symbol;
							_tmp133_ = g_strdup (_tmp132_);
							_g_free0 (ref_function);
							ref_function = _tmp133_;
							_tmp134_ = member;
							_tmp135_ = ((GIdlNodeFunction*) _tmp134_)->result;
							_tmp136_ = _tmp135_->type;
							_tmp137_ = vala_gidl_parser_parse_type (self, _tmp136_, NULL);
							_tmp138_ = _tmp137_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp138_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp138_);
						} else {
							GIdlNode* _tmp139_;
							const gchar* _tmp140_;
							_tmp139_ = member;
							_tmp140_ = _tmp139_->name;
							if (g_strcmp0 (_tmp140_, "unref") == 0) {
								GIdlNode* _tmp141_;
								const gchar* _tmp142_;
								gchar* _tmp143_;
								_tmp141_ = member;
								_tmp142_ = ((GIdlNodeFunction*) _tmp141_)->symbol;
								_tmp143_ = g_strdup (_tmp142_);
								_g_free0 (unref_function);
								unref_function = _tmp143_;
							} else {
								gboolean _tmp144_ = FALSE;
								GIdlNode* _tmp145_;
								const gchar* _tmp146_;
								_tmp145_ = member;
								_tmp146_ = _tmp145_->name;
								if (g_strcmp0 (_tmp146_, "free") == 0) {
									_tmp144_ = TRUE;
								} else {
									GIdlNode* _tmp147_;
									const gchar* _tmp148_;
									_tmp147_ = member;
									_tmp148_ = _tmp147_->name;
									_tmp144_ = g_strcmp0 (_tmp148_, "destroy") == 0;
								}
								if (_tmp144_) {
									GIdlNode* _tmp149_;
									const gchar* _tmp150_;
									gchar* _tmp151_;
									_tmp149_ = member;
									_tmp150_ = ((GIdlNodeFunction*) _tmp149_)->symbol;
									_tmp151_ = g_strdup (_tmp150_);
									_g_free0 (free_function);
									free_function = _tmp151_;
								} else {
									GIdlNode* _tmp152_;
									const gchar* _tmp153_;
									ValaMethod* m = NULL;
									GIdlNode* _tmp157_;
									ValaMethod* _tmp158_;
									ValaMethod* _tmp159_;
									_tmp152_ = member;
									_tmp153_ = _tmp152_->name;
									if (g_strcmp0 (_tmp153_, "copy") == 0) {
										GIdlNode* _tmp154_;
										const gchar* _tmp155_;
										gchar* _tmp156_;
										_tmp154_ = member;
										_tmp155_ = ((GIdlNodeFunction*) _tmp154_)->symbol;
										_tmp156_ = g_strdup (_tmp155_);
										_g_free0 (copy_function);
										copy_function = _tmp156_;
									}
									_tmp157_ = member;
									_tmp158_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp157_, FALSE);
									m = _tmp158_;
									_tmp159_ = m;
									if (_tmp159_ != NULL) {
										ValaClass* _tmp160_;
										ValaMethod* _tmp161_;
										_tmp160_ = cl;
										_tmp161_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp160_, _tmp161_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp162_;
						_tmp162_ = member;
						if (_tmp162_->type == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp163_;
							ValaField* _tmp164_;
							ValaField* _tmp165_;
							_tmp163_ = member;
							_tmp164_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp163_);
							f = _tmp164_;
							_tmp165_ = f;
							if (_tmp165_ != NULL) {
								ValaClass* _tmp166_;
								ValaField* _tmp167_;
								_tmp166_ = cl;
								_tmp167_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp166_, _tmp167_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp168_ = ref_function;
		if (_tmp168_ != NULL) {
			ValaClass* _tmp169_;
			const gchar* _tmp170_;
			_tmp169_ = cl;
			_tmp170_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp169_, "CCode", "ref_function", _tmp170_, NULL);
			if (ref_function_void) {
				ValaClass* _tmp171_;
				_tmp171_ = cl;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp171_, "CCode", "ref_function_void", ref_function_void, NULL);
			}
		} else {
			const gchar* _tmp172_;
			_tmp172_ = copy_function;
			if (_tmp172_ != NULL) {
				ValaClass* _tmp173_;
				const gchar* _tmp174_;
				_tmp173_ = cl;
				_tmp174_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp173_, "CCode", "copy_function", _tmp174_, NULL);
			}
		}
		_tmp175_ = unref_function;
		if (_tmp175_ != NULL) {
			ValaClass* _tmp176_;
			const gchar* _tmp177_;
			_tmp176_ = cl;
			_tmp177_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp176_, "CCode", "unref_function", _tmp177_, NULL);
		} else {
			gboolean _tmp178_ = FALSE;
			const gchar* _tmp179_;
			_tmp179_ = free_function;
			if (_tmp179_ != NULL) {
				const gchar* _tmp180_;
				ValaClass* _tmp181_;
				gchar* _tmp182_;
				gchar* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				_tmp180_ = free_function;
				_tmp181_ = cl;
				_tmp182_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = g_strdup_printf ("%sfree", _tmp183_);
				_tmp185_ = _tmp184_;
				_tmp178_ = g_strcmp0 (_tmp180_, _tmp185_) != 0;
				_g_free0 (_tmp185_);
				_g_free0 (_tmp183_);
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaClass* _tmp186_;
				const gchar* _tmp187_;
				_tmp186_ = cl;
				_tmp187_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp186_, "CCode", "free_function", _tmp187_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}

static void
vala_gidl_parser_parse_boxed (ValaGIdlParser* self,
                              GIdlNodeBoxed* boxed_node,
                              ValaSymbol* container,
                              GIdlModule* module)
{
	GIdlNode* node = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** node_attributes = NULL;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint node_attributes_length1;
	gint _node_attributes_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GIdlNode* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) boxed_node;
	_tmp0_ = node;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
	name = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp6_ = vala_gidl_parser_get_attributes (self, _tmp4_, &_tmp5_);
	node_attributes = _tmp6_;
	node_attributes_length1 = _tmp5_;
	_node_attributes_size_ = node_attributes_length1;
	_tmp7_ = node_attributes;
	_tmp7__length1 = node_attributes_length1;
	if (_tmp7_ != NULL) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp8_ = node_attributes;
		_tmp8__length1 = node_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp8_;
			attr_collection_length1 = _tmp8__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp9_;
				gchar* attr = NULL;
				_tmp9_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp9_;
				{
					gchar** nv = NULL;
					const gchar* _tmp10_;
					gchar** _tmp11_;
					gchar** _tmp12_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					_tmp10_ = attr;
					_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "=", 2);
					nv = _tmp12_;
					nv_length1 = _vala_array_length (_tmp11_);
					_nv_size_ = nv_length1;
					_tmp13_ = nv;
					_tmp13__length1 = nv_length1;
					_tmp14_ = _tmp13_[0];
					if (g_strcmp0 (_tmp14_, "hidden") == 0) {
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						return;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp15_ = node;
	_tmp16_ = _tmp15_->name;
	if (!vala_gidl_parser_is_reference_type (self, _tmp16_)) {
		ValaStruct* st = NULL;
		ValaScope* _tmp17_;
		ValaScope* _tmp18_;
		const gchar* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaStruct* _tmp21_;
		ValaStruct* _tmp22_;
		ValaStruct* _tmp101_;
		ValaTypeSymbol* _tmp102_;
		GList* _tmp103_;
		_tmp17_ = vala_symbol_get_scope (container);
		_tmp18_ = _tmp17_;
		_tmp19_ = name;
		_tmp20_ = vala_scope_lookup (_tmp18_, _tmp19_);
		_tmp21_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp20_) : NULL;
		if (_tmp21_ == NULL) {
			_vala_code_node_unref0 (_tmp20_);
		}
		st = _tmp21_;
		_tmp22_ = st;
		if (_tmp22_ == NULL) {
			const gchar* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaStruct* _tmp25_;
			ValaStruct* _tmp26_;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp27_;
			const gchar* _tmp28_;
			gint _tmp29_ = 0;
			gchar** _tmp30_;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			ValaStruct* _tmp98_;
			ValaSourceFile* _tmp99_;
			ValaStruct* _tmp100_;
			_tmp23_ = name;
			_tmp24_ = self->priv->current_source_reference;
			_tmp25_ = vala_struct_new (_tmp23_, _tmp24_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp25_;
			_tmp26_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp26_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp27_ = node;
			_tmp28_ = _tmp27_->name;
			_tmp30_ = vala_gidl_parser_get_attributes (self, _tmp28_, &_tmp29_);
			st_attributes = _tmp30_;
			st_attributes_length1 = _tmp29_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp31_ = st_attributes;
			_tmp31__length1 = st_attributes_length1;
			if (_tmp31_ != NULL) {
				gchar** _tmp32_;
				gint _tmp32__length1;
				_tmp32_ = st_attributes;
				_tmp32__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp32_;
					attr_collection_length1 = _tmp32__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp33_;
						gchar* attr = NULL;
						_tmp33_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp33_;
						{
							gchar** nv = NULL;
							const gchar* _tmp34_;
							gchar** _tmp35_;
							gchar** _tmp36_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp37_;
							gint _tmp37__length1;
							const gchar* _tmp38_;
							_tmp34_ = attr;
							_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, "=", 2);
							nv = _tmp36_;
							nv_length1 = _vala_array_length (_tmp35_);
							_nv_size_ = nv_length1;
							_tmp37_ = nv;
							_tmp37__length1 = nv_length1;
							_tmp38_ = _tmp37_[0];
							if (g_strcmp0 (_tmp38_, "cheader_filename") == 0) {
								ValaStruct* _tmp39_;
								gchar** _tmp40_;
								gint _tmp40__length1;
								const gchar* _tmp41_;
								gchar* _tmp42_;
								gchar* _tmp43_;
								_tmp39_ = st;
								_tmp40_ = nv;
								_tmp40__length1 = nv_length1;
								_tmp41_ = _tmp40_[1];
								_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
								_tmp43_ = _tmp42_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp39_, "CCode", "cheader_filename", _tmp43_, NULL);
								_g_free0 (_tmp43_);
							} else {
								gchar** _tmp44_;
								gint _tmp44__length1;
								const gchar* _tmp45_;
								_tmp44_ = nv;
								_tmp44__length1 = nv_length1;
								_tmp45_ = _tmp44_[0];
								if (g_strcmp0 (_tmp45_, "deprecated") == 0) {
									gchar** _tmp46_;
									gint _tmp46__length1;
									const gchar* _tmp47_;
									gchar* _tmp48_;
									gchar* _tmp49_;
									gboolean _tmp50_;
									_tmp46_ = nv;
									_tmp46__length1 = nv_length1;
									_tmp47_ = _tmp46_[1];
									_tmp48_ = vala_gidl_parser_eval (self, _tmp47_);
									_tmp49_ = _tmp48_;
									_tmp50_ = g_strcmp0 (_tmp49_, "1") == 0;
									_g_free0 (_tmp49_);
									if (_tmp50_) {
										ValaStruct* _tmp51_;
										_tmp51_ = st;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp51_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp52_;
									gint _tmp52__length1;
									const gchar* _tmp53_;
									_tmp52_ = nv;
									_tmp52__length1 = nv_length1;
									_tmp53_ = _tmp52_[0];
									if (g_strcmp0 (_tmp53_, "replacement") == 0) {
										ValaStruct* _tmp54_;
										gchar** _tmp55_;
										gint _tmp55__length1;
										const gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										_tmp54_ = st;
										_tmp55_ = nv;
										_tmp55__length1 = nv_length1;
										_tmp56_ = _tmp55_[1];
										_tmp57_ = vala_gidl_parser_eval (self, _tmp56_);
										_tmp58_ = _tmp57_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp54_, "Version", "replacement", _tmp58_, NULL);
										_g_free0 (_tmp58_);
									} else {
										gchar** _tmp59_;
										gint _tmp59__length1;
										const gchar* _tmp60_;
										_tmp59_ = nv;
										_tmp59__length1 = nv_length1;
										_tmp60_ = _tmp59_[0];
										if (g_strcmp0 (_tmp60_, "deprecated_since") == 0) {
											ValaStruct* _tmp61_;
											gchar** _tmp62_;
											gint _tmp62__length1;
											const gchar* _tmp63_;
											gchar* _tmp64_;
											gchar* _tmp65_;
											_tmp61_ = st;
											_tmp62_ = nv;
											_tmp62__length1 = nv_length1;
											_tmp63_ = _tmp62_[1];
											_tmp64_ = vala_gidl_parser_eval (self, _tmp63_);
											_tmp65_ = _tmp64_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp61_, "Version", "deprecated_since", _tmp65_, NULL);
											_g_free0 (_tmp65_);
										} else {
											gchar** _tmp66_;
											gint _tmp66__length1;
											const gchar* _tmp67_;
											_tmp66_ = nv;
											_tmp66__length1 = nv_length1;
											_tmp67_ = _tmp66_[0];
											if (g_strcmp0 (_tmp67_, "immutable") == 0) {
												gchar** _tmp68_;
												gint _tmp68__length1;
												const gchar* _tmp69_;
												gchar* _tmp70_;
												gchar* _tmp71_;
												gboolean _tmp72_;
												_tmp68_ = nv;
												_tmp68__length1 = nv_length1;
												_tmp69_ = _tmp68_[1];
												_tmp70_ = vala_gidl_parser_eval (self, _tmp69_);
												_tmp71_ = _tmp70_;
												_tmp72_ = g_strcmp0 (_tmp71_, "1") == 0;
												_g_free0 (_tmp71_);
												if (_tmp72_) {
													ValaStruct* _tmp73_;
													_tmp73_ = st;
													vala_code_node_set_attribute ((ValaCodeNode*) _tmp73_, "Immutable", TRUE, NULL);
												}
											} else {
												gchar** _tmp74_;
												gint _tmp74__length1;
												const gchar* _tmp75_;
												_tmp74_ = nv;
												_tmp74__length1 = nv_length1;
												_tmp75_ = _tmp74_[0];
												if (g_strcmp0 (_tmp75_, "has_copy_function") == 0) {
													gchar** _tmp76_;
													gint _tmp76__length1;
													const gchar* _tmp77_;
													gchar* _tmp78_;
													gchar* _tmp79_;
													gboolean _tmp80_;
													_tmp76_ = nv;
													_tmp76__length1 = nv_length1;
													_tmp77_ = _tmp76_[1];
													_tmp78_ = vala_gidl_parser_eval (self, _tmp77_);
													_tmp79_ = _tmp78_;
													_tmp80_ = g_strcmp0 (_tmp79_, "0") == 0;
													_g_free0 (_tmp79_);
													if (_tmp80_) {
														ValaStruct* _tmp81_;
														_tmp81_ = st;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp81_, "CCode", "has_copy_function", FALSE, NULL);
													}
												} else {
													gchar** _tmp82_;
													gint _tmp82__length1;
													const gchar* _tmp83_;
													_tmp82_ = nv;
													_tmp82__length1 = nv_length1;
													_tmp83_ = _tmp82_[0];
													if (g_strcmp0 (_tmp83_, "has_destroy_function") == 0) {
														gchar** _tmp84_;
														gint _tmp84__length1;
														const gchar* _tmp85_;
														gchar* _tmp86_;
														gchar* _tmp87_;
														gboolean _tmp88_;
														_tmp84_ = nv;
														_tmp84__length1 = nv_length1;
														_tmp85_ = _tmp84_[1];
														_tmp86_ = vala_gidl_parser_eval (self, _tmp85_);
														_tmp87_ = _tmp86_;
														_tmp88_ = g_strcmp0 (_tmp87_, "0") == 0;
														_g_free0 (_tmp87_);
														if (_tmp88_) {
															ValaStruct* _tmp89_;
															_tmp89_ = st;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp89_, "CCode", "has_destroy_function", FALSE, NULL);
														}
													} else {
														gchar** _tmp90_;
														gint _tmp90__length1;
														const gchar* _tmp91_;
														_tmp90_ = nv;
														_tmp90__length1 = nv_length1;
														_tmp91_ = _tmp90_[0];
														if (g_strcmp0 (_tmp91_, "experimental") == 0) {
															gchar** _tmp92_;
															gint _tmp92__length1;
															const gchar* _tmp93_;
															gchar* _tmp94_;
															gchar* _tmp95_;
															gboolean _tmp96_;
															_tmp92_ = nv;
															_tmp92__length1 = nv_length1;
															_tmp93_ = _tmp92_[1];
															_tmp94_ = vala_gidl_parser_eval (self, _tmp93_);
															_tmp95_ = _tmp94_;
															_tmp96_ = g_strcmp0 (_tmp95_, "1") == 0;
															_g_free0 (_tmp95_);
															if (_tmp96_) {
																ValaStruct* _tmp97_;
																_tmp97_ = st;
																vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp97_, "Version", "experimental", TRUE, NULL);
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp98_ = st;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp98_);
			_tmp99_ = self->priv->current_source_file;
			_tmp100_ = st;
			vala_source_file_add_node (_tmp99_, (ValaCodeNode*) _tmp100_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp101_ = st;
		_tmp102_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp101_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp102_;
		_tmp103_ = boxed_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp103_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp104_;
					_tmp104_ = member;
					if (_tmp104_->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp105_;
						ValaMethod* _tmp106_;
						ValaMethod* _tmp107_;
						_tmp105_ = member;
						_tmp106_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp105_, FALSE);
						m = _tmp106_;
						_tmp107_ = m;
						if (_tmp107_ != NULL) {
							ValaStruct* _tmp108_;
							ValaMethod* _tmp109_;
							_tmp108_ = st;
							_tmp109_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp108_, _tmp109_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp110_;
						_tmp110_ = member;
						if (_tmp110_->type == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp111_;
							ValaField* _tmp112_;
							ValaField* _tmp113_;
							_tmp111_ = member;
							_tmp112_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp111_);
							f = _tmp112_;
							_tmp113_ = f;
							if (_tmp113_ != NULL) {
								ValaStruct* _tmp114_;
								ValaField* _tmp115_;
								_tmp114_ = st;
								_tmp115_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp114_, _tmp115_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		ValaClass* cl = NULL;
		ValaScope* _tmp116_;
		ValaScope* _tmp117_;
		const gchar* _tmp118_;
		ValaSymbol* _tmp119_;
		ValaClass* _tmp120_;
		ValaClass* _tmp121_;
		ValaClass* _tmp234_;
		ValaTypeSymbol* _tmp235_;
		GList* _tmp236_;
		const gchar* _tmp277_;
		const gchar* _tmp284_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp116_ = vala_symbol_get_scope (container);
		_tmp117_ = _tmp116_;
		_tmp118_ = name;
		_tmp119_ = vala_scope_lookup (_tmp117_, _tmp118_);
		_tmp120_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp119_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp119_) : NULL;
		if (_tmp120_ == NULL) {
			_vala_code_node_unref0 (_tmp119_);
		}
		cl = _tmp120_;
		_tmp121_ = cl;
		if (_tmp121_ == NULL) {
			gchar* base_class = NULL;
			const gchar* _tmp122_;
			ValaSourceReference* _tmp123_;
			ValaClass* _tmp124_;
			ValaClass* _tmp125_;
			ValaClass* _tmp126_;
			const gchar* _tmp127_;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp132_;
			const gchar* _tmp133_;
			gint _tmp134_ = 0;
			gchar** _tmp135_;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp136_;
			gint _tmp136__length1;
			ValaClass* _tmp226_;
			ValaSourceFile* _tmp227_;
			ValaClass* _tmp228_;
			const gchar* _tmp229_;
			base_class = NULL;
			_tmp122_ = name;
			_tmp123_ = self->priv->current_source_reference;
			_tmp124_ = vala_class_new (_tmp122_, _tmp123_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp124_;
			_tmp125_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp125_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp126_ = cl;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp126_, "Compact", TRUE, NULL);
			_tmp127_ = boxed_node->gtype_init;
			if (_tmp127_ != NULL) {
				ValaClass* _tmp128_;
				const gchar* _tmp129_;
				gchar* _tmp130_;
				gchar* _tmp131_;
				_tmp128_ = cl;
				_tmp129_ = boxed_node->gtype_init;
				_tmp130_ = g_strdup_printf ("%s ()", _tmp129_);
				_tmp131_ = _tmp130_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp128_, "CCode", "type_id", _tmp131_, NULL);
				_g_free0 (_tmp131_);
			}
			_tmp132_ = node;
			_tmp133_ = _tmp132_->name;
			_tmp135_ = vala_gidl_parser_get_attributes (self, _tmp133_, &_tmp134_);
			cl_attributes = _tmp135_;
			cl_attributes_length1 = _tmp134_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp136_ = cl_attributes;
			_tmp136__length1 = cl_attributes_length1;
			if (_tmp136_ != NULL) {
				gchar** _tmp137_;
				gint _tmp137__length1;
				_tmp137_ = cl_attributes;
				_tmp137__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp137_;
					attr_collection_length1 = _tmp137__length1;
					for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
						gchar* _tmp138_;
						gchar* attr = NULL;
						_tmp138_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp138_;
						{
							gchar** nv = NULL;
							const gchar* _tmp139_;
							gchar** _tmp140_;
							gchar** _tmp141_;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp142_;
							gint _tmp142__length1;
							const gchar* _tmp143_;
							_tmp139_ = attr;
							_tmp141_ = _tmp140_ = g_strsplit (_tmp139_, "=", 2);
							nv = _tmp141_;
							nv_length1 = _vala_array_length (_tmp140_);
							_nv_size_ = nv_length1;
							_tmp142_ = nv;
							_tmp142__length1 = nv_length1;
							_tmp143_ = _tmp142_[0];
							if (g_strcmp0 (_tmp143_, "cheader_filename") == 0) {
								ValaClass* _tmp144_;
								gchar** _tmp145_;
								gint _tmp145__length1;
								const gchar* _tmp146_;
								gchar* _tmp147_;
								gchar* _tmp148_;
								_tmp144_ = cl;
								_tmp145_ = nv;
								_tmp145__length1 = nv_length1;
								_tmp146_ = _tmp145_[1];
								_tmp147_ = vala_gidl_parser_eval (self, _tmp146_);
								_tmp148_ = _tmp147_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp144_, "CCode", "cheader_filename", _tmp148_, NULL);
								_g_free0 (_tmp148_);
							} else {
								gchar** _tmp149_;
								gint _tmp149__length1;
								const gchar* _tmp150_;
								_tmp149_ = nv;
								_tmp149__length1 = nv_length1;
								_tmp150_ = _tmp149_[0];
								if (g_strcmp0 (_tmp150_, "base_class") == 0) {
									gchar** _tmp151_;
									gint _tmp151__length1;
									const gchar* _tmp152_;
									gchar* _tmp153_;
									_tmp151_ = nv;
									_tmp151__length1 = nv_length1;
									_tmp152_ = _tmp151_[1];
									_tmp153_ = vala_gidl_parser_eval (self, _tmp152_);
									_g_free0 (base_class);
									base_class = _tmp153_;
								} else {
									gchar** _tmp154_;
									gint _tmp154__length1;
									const gchar* _tmp155_;
									_tmp154_ = nv;
									_tmp154__length1 = nv_length1;
									_tmp155_ = _tmp154_[0];
									if (g_strcmp0 (_tmp155_, "is_immutable") == 0) {
										gchar** _tmp156_;
										gint _tmp156__length1;
										const gchar* _tmp157_;
										gchar* _tmp158_;
										gchar* _tmp159_;
										gboolean _tmp160_;
										_tmp156_ = nv;
										_tmp156__length1 = nv_length1;
										_tmp157_ = _tmp156_[1];
										_tmp158_ = vala_gidl_parser_eval (self, _tmp157_);
										_tmp159_ = _tmp158_;
										_tmp160_ = g_strcmp0 (_tmp159_, "1") == 0;
										_g_free0 (_tmp159_);
										if (_tmp160_) {
											ValaClass* _tmp161_;
											_tmp161_ = cl;
											vala_code_node_set_attribute ((ValaCodeNode*) _tmp161_, "Immutable", TRUE, NULL);
										}
									} else {
										gchar** _tmp162_;
										gint _tmp162__length1;
										const gchar* _tmp163_;
										_tmp162_ = nv;
										_tmp162__length1 = nv_length1;
										_tmp163_ = _tmp162_[0];
										if (g_strcmp0 (_tmp163_, "deprecated") == 0) {
											gchar** _tmp164_;
											gint _tmp164__length1;
											const gchar* _tmp165_;
											gchar* _tmp166_;
											gchar* _tmp167_;
											gboolean _tmp168_;
											_tmp164_ = nv;
											_tmp164__length1 = nv_length1;
											_tmp165_ = _tmp164_[1];
											_tmp166_ = vala_gidl_parser_eval (self, _tmp165_);
											_tmp167_ = _tmp166_;
											_tmp168_ = g_strcmp0 (_tmp167_, "1") == 0;
											_g_free0 (_tmp167_);
											if (_tmp168_) {
												ValaClass* _tmp169_;
												_tmp169_ = cl;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp169_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp170_;
											gint _tmp170__length1;
											const gchar* _tmp171_;
											_tmp170_ = nv;
											_tmp170__length1 = nv_length1;
											_tmp171_ = _tmp170_[0];
											if (g_strcmp0 (_tmp171_, "replacement") == 0) {
												ValaClass* _tmp172_;
												gchar** _tmp173_;
												gint _tmp173__length1;
												const gchar* _tmp174_;
												gchar* _tmp175_;
												gchar* _tmp176_;
												_tmp172_ = cl;
												_tmp173_ = nv;
												_tmp173__length1 = nv_length1;
												_tmp174_ = _tmp173_[1];
												_tmp175_ = vala_gidl_parser_eval (self, _tmp174_);
												_tmp176_ = _tmp175_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp172_, "Version", "replacement", _tmp176_, NULL);
												_g_free0 (_tmp176_);
											} else {
												gchar** _tmp177_;
												gint _tmp177__length1;
												const gchar* _tmp178_;
												_tmp177_ = nv;
												_tmp177__length1 = nv_length1;
												_tmp178_ = _tmp177_[0];
												if (g_strcmp0 (_tmp178_, "deprecated_since") == 0) {
													ValaClass* _tmp179_;
													gchar** _tmp180_;
													gint _tmp180__length1;
													const gchar* _tmp181_;
													gchar* _tmp182_;
													gchar* _tmp183_;
													_tmp179_ = cl;
													_tmp180_ = nv;
													_tmp180__length1 = nv_length1;
													_tmp181_ = _tmp180_[1];
													_tmp182_ = vala_gidl_parser_eval (self, _tmp181_);
													_tmp183_ = _tmp182_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp179_, "Version", "deprecated_since", _tmp183_, NULL);
													_g_free0 (_tmp183_);
												} else {
													gchar** _tmp184_;
													gint _tmp184__length1;
													const gchar* _tmp185_;
													_tmp184_ = nv;
													_tmp184__length1 = nv_length1;
													_tmp185_ = _tmp184_[0];
													if (g_strcmp0 (_tmp185_, "const_cname") == 0) {
														ValaClass* _tmp186_;
														gchar** _tmp187_;
														gint _tmp187__length1;
														const gchar* _tmp188_;
														gchar* _tmp189_;
														gchar* _tmp190_;
														_tmp186_ = cl;
														_tmp187_ = nv;
														_tmp187__length1 = nv_length1;
														_tmp188_ = _tmp187_[1];
														_tmp189_ = vala_gidl_parser_eval (self, _tmp188_);
														_tmp190_ = _tmp189_;
														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp186_, "CCode", "const_cname", _tmp190_, NULL);
														_g_free0 (_tmp190_);
													} else {
														gchar** _tmp191_;
														gint _tmp191__length1;
														const gchar* _tmp192_;
														_tmp191_ = nv;
														_tmp191__length1 = nv_length1;
														_tmp192_ = _tmp191_[0];
														if (g_strcmp0 (_tmp192_, "free_function") == 0) {
															gchar** _tmp193_;
															gint _tmp193__length1;
															const gchar* _tmp194_;
															gchar* _tmp195_;
															_tmp193_ = nv;
															_tmp193__length1 = nv_length1;
															_tmp194_ = _tmp193_[1];
															_tmp195_ = vala_gidl_parser_eval (self, _tmp194_);
															_g_free0 (free_function);
															free_function = _tmp195_;
														} else {
															gchar** _tmp196_;
															gint _tmp196__length1;
															const gchar* _tmp197_;
															_tmp196_ = nv;
															_tmp196__length1 = nv_length1;
															_tmp197_ = _tmp196_[0];
															if (g_strcmp0 (_tmp197_, "ref_function") == 0) {
																gchar** _tmp198_;
																gint _tmp198__length1;
																const gchar* _tmp199_;
																gchar* _tmp200_;
																_tmp198_ = nv;
																_tmp198__length1 = nv_length1;
																_tmp199_ = _tmp198_[1];
																_tmp200_ = vala_gidl_parser_eval (self, _tmp199_);
																_g_free0 (ref_function);
																ref_function = _tmp200_;
															} else {
																gchar** _tmp201_;
																gint _tmp201__length1;
																const gchar* _tmp202_;
																_tmp201_ = nv;
																_tmp201__length1 = nv_length1;
																_tmp202_ = _tmp201_[0];
																if (g_strcmp0 (_tmp202_, "unref_function") == 0) {
																	gchar** _tmp203_;
																	gint _tmp203__length1;
																	const gchar* _tmp204_;
																	gchar* _tmp205_;
																	_tmp203_ = nv;
																	_tmp203__length1 = nv_length1;
																	_tmp204_ = _tmp203_[1];
																	_tmp205_ = vala_gidl_parser_eval (self, _tmp204_);
																	_g_free0 (unref_function);
																	unref_function = _tmp205_;
																} else {
																	gchar** _tmp206_;
																	gint _tmp206__length1;
																	const gchar* _tmp207_;
																	_tmp206_ = nv;
																	_tmp206__length1 = nv_length1;
																	_tmp207_ = _tmp206_[0];
																	if (g_strcmp0 (_tmp207_, "copy_function") == 0) {
																		gchar** _tmp208_;
																		gint _tmp208__length1;
																		const gchar* _tmp209_;
																		gchar* _tmp210_;
																		_tmp208_ = nv;
																		_tmp208__length1 = nv_length1;
																		_tmp209_ = _tmp208_[1];
																		_tmp210_ = vala_gidl_parser_eval (self, _tmp209_);
																		_g_free0 (copy_function);
																		copy_function = _tmp210_;
																	} else {
																		gchar** _tmp211_;
																		gint _tmp211__length1;
																		const gchar* _tmp212_;
																		_tmp211_ = nv;
																		_tmp211__length1 = nv_length1;
																		_tmp212_ = _tmp211_[0];
																		if (g_strcmp0 (_tmp212_, "ref_function_void") == 0) {
																			gchar** _tmp213_;
																			gint _tmp213__length1;
																			const gchar* _tmp214_;
																			gchar* _tmp215_;
																			gchar* _tmp216_;
																			gboolean _tmp217_;
																			_tmp213_ = nv;
																			_tmp213__length1 = nv_length1;
																			_tmp214_ = _tmp213_[1];
																			_tmp215_ = vala_gidl_parser_eval (self, _tmp214_);
																			_tmp216_ = _tmp215_;
																			_tmp217_ = g_strcmp0 (_tmp216_, "1") == 0;
																			_g_free0 (_tmp216_);
																			if (_tmp217_) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			gchar** _tmp218_;
																			gint _tmp218__length1;
																			const gchar* _tmp219_;
																			_tmp218_ = nv;
																			_tmp218__length1 = nv_length1;
																			_tmp219_ = _tmp218_[0];
																			if (g_strcmp0 (_tmp219_, "experimental") == 0) {
																				gchar** _tmp220_;
																				gint _tmp220__length1;
																				const gchar* _tmp221_;
																				gchar* _tmp222_;
																				gchar* _tmp223_;
																				gboolean _tmp224_;
																				_tmp220_ = nv;
																				_tmp220__length1 = nv_length1;
																				_tmp221_ = _tmp220_[1];
																				_tmp222_ = vala_gidl_parser_eval (self, _tmp221_);
																				_tmp223_ = _tmp222_;
																				_tmp224_ = g_strcmp0 (_tmp223_, "1") == 0;
																				_g_free0 (_tmp223_);
																				if (_tmp224_) {
																					ValaClass* _tmp225_;
																					_tmp225_ = cl;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp225_, "Version", "experimental", TRUE, NULL);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp226_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp226_);
			_tmp227_ = self->priv->current_source_file;
			_tmp228_ = cl;
			vala_source_file_add_node (_tmp227_, (ValaCodeNode*) _tmp228_);
			_tmp229_ = base_class;
			if (_tmp229_ != NULL) {
				ValaDataType* parent = NULL;
				const gchar* _tmp230_;
				ValaDataType* _tmp231_;
				ValaClass* _tmp232_;
				ValaDataType* _tmp233_;
				_tmp230_ = base_class;
				_tmp231_ = vala_gidl_parser_parse_type_string (self, _tmp230_);
				parent = _tmp231_;
				_tmp232_ = cl;
				_tmp233_ = parent;
				vala_class_add_base_type (_tmp232_, _tmp233_);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp234_ = cl;
		_tmp235_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp234_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp235_;
		_tmp236_ = boxed_node->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp236_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp237_;
					_tmp237_ = member;
					if (_tmp237_->type == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp238_;
						const gchar* _tmp239_;
						_tmp238_ = member;
						_tmp239_ = _tmp238_->name;
						if (g_strcmp0 (_tmp239_, "ref") == 0) {
							GIdlNode* _tmp240_;
							const gchar* _tmp241_;
							gchar* _tmp242_;
							GIdlNode* _tmp243_;
							GIdlNodeParam* _tmp244_;
							GIdlNodeType* _tmp245_;
							ValaDataType* _tmp246_;
							ValaDataType* _tmp247_;
							_tmp240_ = member;
							_tmp241_ = ((GIdlNodeFunction*) _tmp240_)->symbol;
							_tmp242_ = g_strdup (_tmp241_);
							_g_free0 (ref_function);
							ref_function = _tmp242_;
							_tmp243_ = member;
							_tmp244_ = ((GIdlNodeFunction*) _tmp243_)->result;
							_tmp245_ = _tmp244_->type;
							_tmp246_ = vala_gidl_parser_parse_type (self, _tmp245_, NULL);
							_tmp247_ = _tmp246_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp247_);
						} else {
							GIdlNode* _tmp248_;
							const gchar* _tmp249_;
							_tmp248_ = member;
							_tmp249_ = _tmp248_->name;
							if (g_strcmp0 (_tmp249_, "unref") == 0) {
								GIdlNode* _tmp250_;
								const gchar* _tmp251_;
								gchar* _tmp252_;
								_tmp250_ = member;
								_tmp251_ = ((GIdlNodeFunction*) _tmp250_)->symbol;
								_tmp252_ = g_strdup (_tmp251_);
								_g_free0 (unref_function);
								unref_function = _tmp252_;
							} else {
								gboolean _tmp253_ = FALSE;
								GIdlNode* _tmp254_;
								const gchar* _tmp255_;
								_tmp254_ = member;
								_tmp255_ = _tmp254_->name;
								if (g_strcmp0 (_tmp255_, "free") == 0) {
									_tmp253_ = TRUE;
								} else {
									GIdlNode* _tmp256_;
									const gchar* _tmp257_;
									_tmp256_ = member;
									_tmp257_ = _tmp256_->name;
									_tmp253_ = g_strcmp0 (_tmp257_, "destroy") == 0;
								}
								if (_tmp253_) {
									GIdlNode* _tmp258_;
									const gchar* _tmp259_;
									gchar* _tmp260_;
									_tmp258_ = member;
									_tmp259_ = ((GIdlNodeFunction*) _tmp258_)->symbol;
									_tmp260_ = g_strdup (_tmp259_);
									_g_free0 (free_function);
									free_function = _tmp260_;
								} else {
									GIdlNode* _tmp261_;
									const gchar* _tmp262_;
									ValaMethod* m = NULL;
									GIdlNode* _tmp266_;
									ValaMethod* _tmp267_;
									ValaMethod* _tmp268_;
									_tmp261_ = member;
									_tmp262_ = _tmp261_->name;
									if (g_strcmp0 (_tmp262_, "copy") == 0) {
										GIdlNode* _tmp263_;
										const gchar* _tmp264_;
										gchar* _tmp265_;
										_tmp263_ = member;
										_tmp264_ = ((GIdlNodeFunction*) _tmp263_)->symbol;
										_tmp265_ = g_strdup (_tmp264_);
										_g_free0 (copy_function);
										copy_function = _tmp265_;
									}
									_tmp266_ = member;
									_tmp267_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp266_, FALSE);
									m = _tmp267_;
									_tmp268_ = m;
									if (_tmp268_ != NULL) {
										ValaClass* _tmp269_;
										ValaMethod* _tmp270_;
										_tmp269_ = cl;
										_tmp270_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp269_, _tmp270_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp271_;
						_tmp271_ = member;
						if (_tmp271_->type == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp272_;
							ValaField* _tmp273_;
							ValaField* _tmp274_;
							_tmp272_ = member;
							_tmp273_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp272_);
							f = _tmp273_;
							_tmp274_ = f;
							if (_tmp274_ != NULL) {
								ValaClass* _tmp275_;
								ValaField* _tmp276_;
								_tmp275_ = cl;
								_tmp276_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp275_, _tmp276_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp277_ = ref_function;
		if (_tmp277_ != NULL) {
			ValaClass* _tmp278_;
			const gchar* _tmp279_;
			_tmp278_ = cl;
			_tmp279_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp278_, "CCode", "ref_function", _tmp279_, NULL);
			if (ref_function_void) {
				ValaClass* _tmp280_;
				_tmp280_ = cl;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp280_, "CCode", "ref_function_void", ref_function_void, NULL);
			}
		} else {
			const gchar* _tmp281_;
			_tmp281_ = copy_function;
			if (_tmp281_ != NULL) {
				ValaClass* _tmp282_;
				const gchar* _tmp283_;
				_tmp282_ = cl;
				_tmp283_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp282_, "CCode", "copy_function", _tmp283_, NULL);
			}
		}
		_tmp284_ = unref_function;
		if (_tmp284_ != NULL) {
			ValaClass* _tmp285_;
			const gchar* _tmp286_;
			_tmp285_ = cl;
			_tmp286_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp285_, "CCode", "unref_function", _tmp286_, NULL);
		} else {
			gboolean _tmp287_ = FALSE;
			const gchar* _tmp288_;
			_tmp288_ = free_function;
			if (_tmp288_ != NULL) {
				const gchar* _tmp289_;
				ValaClass* _tmp290_;
				gchar* _tmp291_;
				gchar* _tmp292_;
				gchar* _tmp293_;
				gchar* _tmp294_;
				_tmp289_ = free_function;
				_tmp290_ = cl;
				_tmp291_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp290_);
				_tmp292_ = _tmp291_;
				_tmp293_ = g_strdup_printf ("%sfree", _tmp292_);
				_tmp294_ = _tmp293_;
				_tmp287_ = g_strcmp0 (_tmp289_, _tmp294_) != 0;
				_g_free0 (_tmp294_);
				_g_free0 (_tmp292_);
			} else {
				_tmp287_ = FALSE;
			}
			if (_tmp287_) {
				ValaClass* _tmp295_;
				const gchar* _tmp296_;
				_tmp295_ = cl;
				_tmp296_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp295_, "CCode", "free_function", _tmp296_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
vala_gidl_parser_parse_enum (ValaGIdlParser* self,
                             GIdlNodeEnum* en_node,
                             ValaSymbol* container,
                             GIdlModule* module,
                             gboolean is_flags)
{
	GIdlNode* node = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean existing = FALSE;
	ValaEnum* en = NULL;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	const gchar* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaEnum* _tmp7_;
	ValaEnum* _tmp8_;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	gchar* common_prefix = NULL;
	GList* _tmp28_;
	gboolean is_errordomain = FALSE;
	gchar* cheader_filename = NULL;
	gchar** en_attributes = NULL;
	GIdlNode* _tmp92_;
	const gchar* _tmp93_;
	gint _tmp94_ = 0;
	gchar** _tmp95_;
	gint en_attributes_length1;
	gint _en_attributes_size_;
	gchar** _tmp96_;
	gint _tmp96__length1;
	ValaEnum* _tmp190_;
	const gchar* _tmp191_;
	GList* _tmp192_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) en_node;
	_tmp0_ = node;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
	name = _tmp2_;
	existing = TRUE;
	_tmp3_ = vala_symbol_get_scope (container);
	_tmp4_ = _tmp3_;
	_tmp5_ = name;
	_tmp6_ = vala_scope_lookup (_tmp4_, _tmp5_);
	_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_ENUM) ? ((ValaEnum*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_vala_code_node_unref0 (_tmp6_);
	}
	en = _tmp7_;
	_tmp8_ = en;
	if (_tmp8_ == NULL) {
		const gchar* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaEnum* _tmp11_;
		ValaEnum* _tmp12_;
		_tmp9_ = name;
		_tmp10_ = self->priv->current_source_reference;
		_tmp11_ = vala_enum_new (_tmp9_, _tmp10_, NULL);
		_vala_code_node_unref0 (en);
		en = _tmp11_;
		_tmp12_ = en;
		vala_symbol_set_access ((ValaSymbol*) _tmp12_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		existing = FALSE;
	} else {
		ValaEnumValue* dummy = NULL;
		ValaEnum* _tmp13_;
		ValaScope* _tmp14_;
		ValaScope* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaEnumValue* _tmp17_;
		_tmp13_ = en;
		_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_scope_lookup (_tmp15_, "__DUMMY__");
		dummy = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_ENUM_VALUE, ValaEnumValue);
		_tmp17_ = dummy;
		if (_tmp17_ != NULL) {
			ValaEnum* _tmp18_;
			ValaList* _tmp19_;
			ValaEnumValue* _tmp20_;
			ValaEnum* _tmp21_;
			ValaScope* _tmp22_;
			ValaScope* _tmp23_;
			_tmp18_ = en;
			_tmp19_ = vala_enum_get_values (_tmp18_);
			_tmp20_ = dummy;
			vala_collection_remove ((ValaCollection*) _tmp19_, _tmp20_);
			_tmp21_ = en;
			_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp23_, "__DUMMY__");
		}
		_vala_code_node_unref0 (dummy);
	}
	_tmp25_ = en_node->gtype_name;
	if (_tmp25_ == NULL) {
		_tmp24_ = TRUE;
	} else {
		const gchar* _tmp26_;
		_tmp26_ = en_node->gtype_name;
		_tmp24_ = g_strcmp0 (_tmp26_, "") == 0;
	}
	if (_tmp24_) {
		ValaEnum* _tmp27_;
		_tmp27_ = en;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp27_, "CCode", "has_type_id", FALSE, NULL);
	}
	common_prefix = NULL;
	_tmp28_ = en_node->values;
	{
		GList* value_collection = NULL;
		GList* value_it = NULL;
		value_collection = _tmp28_;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value = NULL;
			value = (GIdlNode*) value_it->data;
			{
				gchar** val_attributes = NULL;
				GIdlNode* _tmp29_;
				const gchar* _tmp30_;
				gint _tmp31_ = 0;
				gchar** _tmp32_;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gboolean is_hidden = FALSE;
				gchar** _tmp33_;
				gint _tmp33__length1;
				const gchar* _tmp46_;
				_tmp29_ = value;
				_tmp30_ = _tmp29_->name;
				_tmp32_ = vala_gidl_parser_get_attributes (self, _tmp30_, &_tmp31_);
				val_attributes = _tmp32_;
				val_attributes_length1 = _tmp31_;
				_val_attributes_size_ = val_attributes_length1;
				is_hidden = FALSE;
				_tmp33_ = val_attributes;
				_tmp33__length1 = val_attributes_length1;
				if (_tmp33_ != NULL) {
					gchar** _tmp34_;
					gint _tmp34__length1;
					_tmp34_ = val_attributes;
					_tmp34__length1 = val_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp34_;
						attr_collection_length1 = _tmp34__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp35_;
							gchar* attr = NULL;
							_tmp35_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp35_;
							{
								gchar** nv = NULL;
								const gchar* _tmp36_;
								gchar** _tmp37_;
								gchar** _tmp38_;
								gint nv_length1;
								gint _nv_size_;
								gboolean _tmp39_ = FALSE;
								gchar** _tmp40_;
								gint _tmp40__length1;
								const gchar* _tmp41_;
								_tmp36_ = attr;
								_tmp38_ = _tmp37_ = g_strsplit (_tmp36_, "=", 2);
								nv = _tmp38_;
								nv_length1 = _vala_array_length (_tmp37_);
								_nv_size_ = nv_length1;
								_tmp40_ = nv;
								_tmp40__length1 = nv_length1;
								_tmp41_ = _tmp40_[0];
								if (g_strcmp0 (_tmp41_, "hidden") == 0) {
									gchar** _tmp42_;
									gint _tmp42__length1;
									const gchar* _tmp43_;
									gchar* _tmp44_;
									gchar* _tmp45_;
									_tmp42_ = nv;
									_tmp42__length1 = nv_length1;
									_tmp43_ = _tmp42_[1];
									_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
									_tmp45_ = _tmp44_;
									_tmp39_ = g_strcmp0 (_tmp45_, "1") == 0;
									_g_free0 (_tmp45_);
								} else {
									_tmp39_ = FALSE;
								}
								if (_tmp39_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (is_hidden) {
					val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				_tmp46_ = common_prefix;
				if (_tmp46_ == NULL) {
					GIdlNode* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					_tmp47_ = value;
					_tmp48_ = _tmp47_->name;
					_tmp49_ = g_strdup (_tmp48_);
					_g_free0 (common_prefix);
					common_prefix = _tmp49_;
					while (TRUE) {
						gboolean _tmp50_ = FALSE;
						const gchar* _tmp51_;
						gint _tmp52_;
						gint _tmp53_;
						const gchar* _tmp55_;
						const gchar* _tmp56_;
						gint _tmp57_;
						gint _tmp58_;
						gchar* _tmp59_;
						_tmp51_ = common_prefix;
						_tmp52_ = strlen (_tmp51_);
						_tmp53_ = _tmp52_;
						if (_tmp53_ > 0) {
							const gchar* _tmp54_;
							_tmp54_ = common_prefix;
							_tmp50_ = !g_str_has_suffix (_tmp54_, "_");
						} else {
							_tmp50_ = FALSE;
						}
						if (!_tmp50_) {
							break;
						}
						_tmp55_ = common_prefix;
						_tmp56_ = common_prefix;
						_tmp57_ = strlen (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = string_substring (_tmp55_, (glong) 0, (glong) (_tmp58_ - 1));
						_g_free0 (common_prefix);
						common_prefix = _tmp59_;
					}
				} else {
					while (TRUE) {
						GIdlNode* _tmp60_;
						const gchar* _tmp61_;
						const gchar* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
						gint _tmp65_;
						gint _tmp66_;
						gchar* _tmp67_;
						_tmp60_ = value;
						_tmp61_ = _tmp60_->name;
						_tmp62_ = common_prefix;
						if (!(!g_str_has_prefix (_tmp61_, _tmp62_))) {
							break;
						}
						_tmp63_ = common_prefix;
						_tmp64_ = common_prefix;
						_tmp65_ = strlen (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = string_substring (_tmp63_, (glong) 0, (glong) (_tmp66_ - 1));
						_g_free0 (common_prefix);
						common_prefix = _tmp67_;
					}
				}
				while (TRUE) {
					gboolean _tmp68_ = FALSE;
					const gchar* _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					const gchar* _tmp87_;
					const gchar* _tmp88_;
					gint _tmp89_;
					gint _tmp90_;
					gchar* _tmp91_;
					_tmp69_ = common_prefix;
					_tmp70_ = strlen (_tmp69_);
					_tmp71_ = _tmp70_;
					if (_tmp71_ > 0) {
						gboolean _tmp72_ = FALSE;
						const gchar* _tmp73_;
						_tmp73_ = common_prefix;
						if (!g_str_has_suffix (_tmp73_, "_")) {
							_tmp72_ = TRUE;
						} else {
							gboolean _tmp74_ = FALSE;
							GIdlNode* _tmp75_;
							const gchar* _tmp76_;
							const gchar* _tmp77_;
							gint _tmp78_;
							gint _tmp79_;
							_tmp75_ = value;
							_tmp76_ = _tmp75_->name;
							_tmp77_ = common_prefix;
							_tmp78_ = strlen (_tmp77_);
							_tmp79_ = _tmp78_;
							if (g_unichar_isdigit (string_get_char (_tmp76_, (glong) _tmp79_))) {
								GIdlNode* _tmp80_;
								const gchar* _tmp81_;
								gint _tmp82_;
								gint _tmp83_;
								const gchar* _tmp84_;
								gint _tmp85_;
								gint _tmp86_;
								_tmp80_ = value;
								_tmp81_ = _tmp80_->name;
								_tmp82_ = strlen (_tmp81_);
								_tmp83_ = _tmp82_;
								_tmp84_ = common_prefix;
								_tmp85_ = strlen (_tmp84_);
								_tmp86_ = _tmp85_;
								_tmp74_ = (_tmp83_ - _tmp86_) <= 1;
							} else {
								_tmp74_ = FALSE;
							}
							_tmp72_ = _tmp74_;
						}
						_tmp68_ = _tmp72_;
					} else {
						_tmp68_ = FALSE;
					}
					if (!_tmp68_) {
						break;
					}
					_tmp87_ = common_prefix;
					_tmp88_ = common_prefix;
					_tmp89_ = strlen (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = string_substring (_tmp87_, (glong) 0, (glong) (_tmp90_ - 1));
					_g_free0 (common_prefix);
					common_prefix = _tmp91_;
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	is_errordomain = FALSE;
	cheader_filename = NULL;
	_tmp92_ = node;
	_tmp93_ = _tmp92_->name;
	_tmp95_ = vala_gidl_parser_get_attributes (self, _tmp93_, &_tmp94_);
	en_attributes = _tmp95_;
	en_attributes_length1 = _tmp94_;
	_en_attributes_size_ = en_attributes_length1;
	_tmp96_ = en_attributes;
	_tmp96__length1 = en_attributes_length1;
	if (_tmp96_ != NULL) {
		gchar** _tmp97_;
		gint _tmp97__length1;
		_tmp97_ = en_attributes;
		_tmp97__length1 = en_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp97_;
			attr_collection_length1 = _tmp97__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp98_;
				gchar* attr = NULL;
				_tmp98_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp98_;
				{
					gchar** nv = NULL;
					const gchar* _tmp99_;
					gchar** _tmp100_;
					gchar** _tmp101_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp102_;
					gint _tmp102__length1;
					const gchar* _tmp103_;
					_tmp99_ = attr;
					_tmp101_ = _tmp100_ = g_strsplit (_tmp99_, "=", 2);
					nv = _tmp101_;
					nv_length1 = _vala_array_length (_tmp100_);
					_nv_size_ = nv_length1;
					_tmp102_ = nv;
					_tmp102__length1 = nv_length1;
					_tmp103_ = _tmp102_[0];
					if (g_strcmp0 (_tmp103_, "common_prefix") == 0) {
						gchar** _tmp104_;
						gint _tmp104__length1;
						const gchar* _tmp105_;
						gchar* _tmp106_;
						_tmp104_ = nv;
						_tmp104__length1 = nv_length1;
						_tmp105_ = _tmp104_[1];
						_tmp106_ = vala_gidl_parser_eval (self, _tmp105_);
						_g_free0 (common_prefix);
						common_prefix = _tmp106_;
					} else {
						gchar** _tmp107_;
						gint _tmp107__length1;
						const gchar* _tmp108_;
						_tmp107_ = nv;
						_tmp107__length1 = nv_length1;
						_tmp108_ = _tmp107_[0];
						if (g_strcmp0 (_tmp108_, "cheader_filename") == 0) {
							gchar** _tmp109_;
							gint _tmp109__length1;
							const gchar* _tmp110_;
							gchar* _tmp111_;
							ValaEnum* _tmp112_;
							const gchar* _tmp113_;
							_tmp109_ = nv;
							_tmp109__length1 = nv_length1;
							_tmp110_ = _tmp109_[1];
							_tmp111_ = vala_gidl_parser_eval (self, _tmp110_);
							_g_free0 (cheader_filename);
							cheader_filename = _tmp111_;
							_tmp112_ = en;
							_tmp113_ = cheader_filename;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp112_, "CCode", "cheader_filename", _tmp113_, NULL);
						} else {
							gchar** _tmp114_;
							gint _tmp114__length1;
							const gchar* _tmp115_;
							_tmp114_ = nv;
							_tmp114__length1 = nv_length1;
							_tmp115_ = _tmp114_[0];
							if (g_strcmp0 (_tmp115_, "hidden") == 0) {
								gchar** _tmp116_;
								gint _tmp116__length1;
								const gchar* _tmp117_;
								gchar* _tmp118_;
								gchar* _tmp119_;
								gboolean _tmp120_;
								_tmp116_ = nv;
								_tmp116__length1 = nv_length1;
								_tmp117_ = _tmp116_[1];
								_tmp118_ = vala_gidl_parser_eval (self, _tmp117_);
								_tmp119_ = _tmp118_;
								_tmp120_ = g_strcmp0 (_tmp119_, "1") == 0;
								_g_free0 (_tmp119_);
								if (_tmp120_) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (cheader_filename);
									_g_free0 (common_prefix);
									_vala_code_node_unref0 (en);
									_g_free0 (name);
									return;
								}
							} else {
								gchar** _tmp121_;
								gint _tmp121__length1;
								const gchar* _tmp122_;
								_tmp121_ = nv;
								_tmp121__length1 = nv_length1;
								_tmp122_ = _tmp121_[0];
								if (g_strcmp0 (_tmp122_, "deprecated") == 0) {
									gchar** _tmp123_;
									gint _tmp123__length1;
									const gchar* _tmp124_;
									gchar* _tmp125_;
									gchar* _tmp126_;
									gboolean _tmp127_;
									_tmp123_ = nv;
									_tmp123__length1 = nv_length1;
									_tmp124_ = _tmp123_[1];
									_tmp125_ = vala_gidl_parser_eval (self, _tmp124_);
									_tmp126_ = _tmp125_;
									_tmp127_ = g_strcmp0 (_tmp126_, "1") == 0;
									_g_free0 (_tmp126_);
									if (_tmp127_) {
										ValaEnum* _tmp128_;
										_tmp128_ = en;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp128_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp129_;
									gint _tmp129__length1;
									const gchar* _tmp130_;
									_tmp129_ = nv;
									_tmp129__length1 = nv_length1;
									_tmp130_ = _tmp129_[0];
									if (g_strcmp0 (_tmp130_, "default_value") == 0) {
										ValaEnum* _tmp131_;
										gchar** _tmp132_;
										gint _tmp132__length1;
										const gchar* _tmp133_;
										gchar* _tmp134_;
										gchar* _tmp135_;
										_tmp131_ = en;
										_tmp132_ = nv;
										_tmp132__length1 = nv_length1;
										_tmp133_ = _tmp132_[1];
										_tmp134_ = vala_gidl_parser_eval (self, _tmp133_);
										_tmp135_ = _tmp134_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp131_, "CCode", "default_value", _tmp135_, NULL);
										_g_free0 (_tmp135_);
									} else {
										gchar** _tmp136_;
										gint _tmp136__length1;
										const gchar* _tmp137_;
										_tmp136_ = nv;
										_tmp136__length1 = nv_length1;
										_tmp137_ = _tmp136_[0];
										if (g_strcmp0 (_tmp137_, "replacement") == 0) {
											ValaEnum* _tmp138_;
											gchar** _tmp139_;
											gint _tmp139__length1;
											const gchar* _tmp140_;
											gchar* _tmp141_;
											gchar* _tmp142_;
											_tmp138_ = en;
											_tmp139_ = nv;
											_tmp139__length1 = nv_length1;
											_tmp140_ = _tmp139_[1];
											_tmp141_ = vala_gidl_parser_eval (self, _tmp140_);
											_tmp142_ = _tmp141_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp138_, "Version", "replacement", _tmp142_, NULL);
											_g_free0 (_tmp142_);
										} else {
											gchar** _tmp143_;
											gint _tmp143__length1;
											const gchar* _tmp144_;
											_tmp143_ = nv;
											_tmp143__length1 = nv_length1;
											_tmp144_ = _tmp143_[0];
											if (g_strcmp0 (_tmp144_, "deprecated_since") == 0) {
												ValaEnum* _tmp145_;
												gchar** _tmp146_;
												gint _tmp146__length1;
												const gchar* _tmp147_;
												gchar* _tmp148_;
												gchar* _tmp149_;
												_tmp145_ = en;
												_tmp146_ = nv;
												_tmp146__length1 = nv_length1;
												_tmp147_ = _tmp146_[1];
												_tmp148_ = vala_gidl_parser_eval (self, _tmp147_);
												_tmp149_ = _tmp148_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp145_, "Version", "deprecated_since", _tmp149_, NULL);
												_g_free0 (_tmp149_);
											} else {
												gchar** _tmp150_;
												gint _tmp150__length1;
												const gchar* _tmp151_;
												_tmp150_ = nv;
												_tmp150__length1 = nv_length1;
												_tmp151_ = _tmp150_[0];
												if (g_strcmp0 (_tmp151_, "rename_to") == 0) {
													ValaEnum* _tmp152_;
													gchar** _tmp153_;
													gint _tmp153__length1;
													const gchar* _tmp154_;
													gchar* _tmp155_;
													gchar* _tmp156_;
													_tmp152_ = en;
													_tmp153_ = nv;
													_tmp153__length1 = nv_length1;
													_tmp154_ = _tmp153_[1];
													_tmp155_ = vala_gidl_parser_eval (self, _tmp154_);
													_tmp156_ = _tmp155_;
													vala_symbol_set_name ((ValaSymbol*) _tmp152_, _tmp156_);
													_g_free0 (_tmp156_);
												} else {
													gchar** _tmp157_;
													gint _tmp157__length1;
													const gchar* _tmp158_;
													_tmp157_ = nv;
													_tmp157__length1 = nv_length1;
													_tmp158_ = _tmp157_[0];
													if (g_strcmp0 (_tmp158_, "errordomain") == 0) {
														gchar** _tmp159_;
														gint _tmp159__length1;
														const gchar* _tmp160_;
														gchar* _tmp161_;
														gchar* _tmp162_;
														gboolean _tmp163_;
														_tmp159_ = nv;
														_tmp159__length1 = nv_length1;
														_tmp160_ = _tmp159_[1];
														_tmp161_ = vala_gidl_parser_eval (self, _tmp160_);
														_tmp162_ = _tmp161_;
														_tmp163_ = g_strcmp0 (_tmp162_, "1") == 0;
														_g_free0 (_tmp162_);
														if (_tmp163_) {
															is_errordomain = TRUE;
														}
													} else {
														gchar** _tmp164_;
														gint _tmp164__length1;
														const gchar* _tmp165_;
														_tmp164_ = nv;
														_tmp164__length1 = nv_length1;
														_tmp165_ = _tmp164_[0];
														if (g_strcmp0 (_tmp165_, "to_string") == 0) {
															ValaUnresolvedType* return_type = NULL;
															ValaUnresolvedType* _tmp166_;
															ValaUnresolvedType* _tmp167_;
															ValaUnresolvedSymbol* _tmp168_;
															ValaUnresolvedSymbol* _tmp169_;
															ValaUnresolvedType* _tmp170_;
															ValaMethod* m = NULL;
															ValaUnresolvedType* _tmp171_;
															ValaSourceReference* _tmp172_;
															ValaMethod* _tmp173_;
															ValaMethod* _tmp174_;
															ValaMethod* _tmp175_;
															gchar** _tmp176_;
															gint _tmp176__length1;
															const gchar* _tmp177_;
															gchar* _tmp178_;
															gchar* _tmp179_;
															ValaEnum* _tmp180_;
															ValaMethod* _tmp181_;
															_tmp166_ = vala_unresolved_type_new (NULL);
															return_type = _tmp166_;
															_tmp167_ = return_type;
															_tmp168_ = vala_unresolved_symbol_new (NULL, "string", NULL);
															_tmp169_ = _tmp168_;
															vala_unresolved_type_set_unresolved_symbol (_tmp167_, _tmp169_);
															_vala_code_node_unref0 (_tmp169_);
															_tmp170_ = return_type;
															vala_data_type_set_value_owned ((ValaDataType*) _tmp170_, FALSE);
															_tmp171_ = return_type;
															_tmp172_ = self->priv->current_source_reference;
															_tmp173_ = vala_method_new ("to_string", (ValaDataType*) _tmp171_, _tmp172_, NULL);
															m = _tmp173_;
															_tmp174_ = m;
															vala_symbol_set_access ((ValaSymbol*) _tmp174_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
															_tmp175_ = m;
															_tmp176_ = nv;
															_tmp176__length1 = nv_length1;
															_tmp177_ = _tmp176_[1];
															_tmp178_ = vala_gidl_parser_eval (self, _tmp177_);
															_tmp179_ = _tmp178_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp175_, "CCode", "cname", _tmp179_, NULL);
															_g_free0 (_tmp179_);
															_tmp180_ = en;
															_tmp181_ = m;
															vala_symbol_add_method ((ValaSymbol*) _tmp180_, _tmp181_);
															_vala_code_node_unref0 (m);
															_vala_code_node_unref0 (return_type);
														} else {
															gchar** _tmp182_;
															gint _tmp182__length1;
															const gchar* _tmp183_;
															_tmp182_ = nv;
															_tmp182__length1 = nv_length1;
															_tmp183_ = _tmp182_[0];
															if (g_strcmp0 (_tmp183_, "experimental") == 0) {
																gchar** _tmp184_;
																gint _tmp184__length1;
																const gchar* _tmp185_;
																gchar* _tmp186_;
																gchar* _tmp187_;
																gboolean _tmp188_;
																_tmp184_ = nv;
																_tmp184__length1 = nv_length1;
																_tmp185_ = _tmp184_[1];
																_tmp186_ = vala_gidl_parser_eval (self, _tmp185_);
																_tmp187_ = _tmp186_;
																_tmp188_ = g_strcmp0 (_tmp187_, "1") == 0;
																_g_free0 (_tmp187_);
																if (_tmp188_) {
																	ValaEnum* _tmp189_;
																	_tmp189_ = en;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp189_, "Version", "experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp190_ = en;
	_tmp191_ = common_prefix;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp190_, "CCode", "cprefix", _tmp191_, NULL);
	_tmp192_ = en_node->values;
	{
		GList* value2_collection = NULL;
		GList* value2_it = NULL;
		value2_collection = _tmp192_;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2 = NULL;
			value2 = (GIdlNode*) value2_it->data;
			{
				ValaEnumValue* ev = NULL;
				GIdlNode* _tmp193_;
				const gchar* _tmp194_;
				const gchar* _tmp195_;
				gint _tmp196_;
				gint _tmp197_;
				gchar* _tmp198_;
				gchar* _tmp199_;
				ValaEnumValue* _tmp200_;
				ValaEnumValue* _tmp201_;
				gchar** val_attributes = NULL;
				GIdlNode* _tmp202_;
				const gchar* _tmp203_;
				gint _tmp204_ = 0;
				gchar** _tmp205_;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gboolean is_hidden = FALSE;
				gchar** _tmp206_;
				gint _tmp206__length1;
				_tmp193_ = value2;
				_tmp194_ = _tmp193_->name;
				_tmp195_ = common_prefix;
				_tmp196_ = strlen (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = string_substring (_tmp194_, (glong) _tmp197_, (glong) -1);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_enum_value_new (_tmp199_, NULL, NULL, NULL);
				_tmp201_ = _tmp200_;
				_g_free0 (_tmp199_);
				ev = _tmp201_;
				_tmp202_ = value2;
				_tmp203_ = _tmp202_->name;
				_tmp205_ = vala_gidl_parser_get_attributes (self, _tmp203_, &_tmp204_);
				val_attributes = _tmp205_;
				val_attributes_length1 = _tmp204_;
				_val_attributes_size_ = val_attributes_length1;
				is_hidden = FALSE;
				_tmp206_ = val_attributes;
				_tmp206__length1 = val_attributes_length1;
				if (_tmp206_ != NULL) {
					gchar** _tmp207_;
					gint _tmp207__length1;
					_tmp207_ = val_attributes;
					_tmp207__length1 = val_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp207_;
						attr_collection_length1 = _tmp207__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp208_;
							gchar* attr = NULL;
							_tmp208_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp208_;
							{
								gchar** nv = NULL;
								const gchar* _tmp209_;
								gchar** _tmp210_;
								gchar** _tmp211_;
								gint nv_length1;
								gint _nv_size_;
								gboolean _tmp212_ = FALSE;
								gchar** _tmp213_;
								gint _tmp213__length1;
								const gchar* _tmp214_;
								_tmp209_ = attr;
								_tmp211_ = _tmp210_ = g_strsplit (_tmp209_, "=", 2);
								nv = _tmp211_;
								nv_length1 = _vala_array_length (_tmp210_);
								_nv_size_ = nv_length1;
								_tmp213_ = nv;
								_tmp213__length1 = nv_length1;
								_tmp214_ = _tmp213_[0];
								if (g_strcmp0 (_tmp214_, "hidden") == 0) {
									gchar** _tmp215_;
									gint _tmp215__length1;
									const gchar* _tmp216_;
									gchar* _tmp217_;
									gchar* _tmp218_;
									_tmp215_ = nv;
									_tmp215__length1 = nv_length1;
									_tmp216_ = _tmp215_[1];
									_tmp217_ = vala_gidl_parser_eval (self, _tmp216_);
									_tmp218_ = _tmp217_;
									_tmp212_ = g_strcmp0 (_tmp218_, "1") == 0;
									_g_free0 (_tmp218_);
								} else {
									_tmp212_ = FALSE;
								}
								if (_tmp212_) {
									is_hidden = TRUE;
								} else {
									gchar** _tmp219_;
									gint _tmp219__length1;
									const gchar* _tmp220_;
									_tmp219_ = nv;
									_tmp219__length1 = nv_length1;
									_tmp220_ = _tmp219_[0];
									if (g_strcmp0 (_tmp220_, "deprecated") == 0) {
										gchar** _tmp221_;
										gint _tmp221__length1;
										const gchar* _tmp222_;
										gchar* _tmp223_;
										gchar* _tmp224_;
										gboolean _tmp225_;
										_tmp221_ = nv;
										_tmp221__length1 = nv_length1;
										_tmp222_ = _tmp221_[1];
										_tmp223_ = vala_gidl_parser_eval (self, _tmp222_);
										_tmp224_ = _tmp223_;
										_tmp225_ = g_strcmp0 (_tmp224_, "1") == 0;
										_g_free0 (_tmp224_);
										if (_tmp225_) {
											ValaEnumValue* _tmp226_;
											_tmp226_ = ev;
											vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp226_, "Version", "deprecated", TRUE, NULL);
										}
									} else {
										gchar** _tmp227_;
										gint _tmp227__length1;
										const gchar* _tmp228_;
										_tmp227_ = nv;
										_tmp227__length1 = nv_length1;
										_tmp228_ = _tmp227_[0];
										if (g_strcmp0 (_tmp228_, "replacement") == 0) {
											ValaEnumValue* _tmp229_;
											gchar** _tmp230_;
											gint _tmp230__length1;
											const gchar* _tmp231_;
											gchar* _tmp232_;
											gchar* _tmp233_;
											_tmp229_ = ev;
											_tmp230_ = nv;
											_tmp230__length1 = nv_length1;
											_tmp231_ = _tmp230_[1];
											_tmp232_ = vala_gidl_parser_eval (self, _tmp231_);
											_tmp233_ = _tmp232_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp229_, "Version", "replacement", _tmp233_, NULL);
											_g_free0 (_tmp233_);
										} else {
											gchar** _tmp234_;
											gint _tmp234__length1;
											const gchar* _tmp235_;
											_tmp234_ = nv;
											_tmp234__length1 = nv_length1;
											_tmp235_ = _tmp234_[0];
											if (g_strcmp0 (_tmp235_, "deprecated_since") == 0) {
												ValaEnumValue* _tmp236_;
												gchar** _tmp237_;
												gint _tmp237__length1;
												const gchar* _tmp238_;
												gchar* _tmp239_;
												gchar* _tmp240_;
												_tmp236_ = ev;
												_tmp237_ = nv;
												_tmp237__length1 = nv_length1;
												_tmp238_ = _tmp237_[1];
												_tmp239_ = vala_gidl_parser_eval (self, _tmp238_);
												_tmp240_ = _tmp239_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp236_, "Version", "deprecated_since", _tmp240_, NULL);
												_g_free0 (_tmp240_);
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (!is_hidden) {
					ValaEnum* _tmp241_;
					ValaEnumValue* _tmp242_;
					_tmp241_ = en;
					_tmp242_ = ev;
					vala_enum_add_value (_tmp241_, _tmp242_);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
				_vala_code_node_unref0 (ev);
			}
		}
	}
	if (is_errordomain) {
		ValaErrorDomain* ed = NULL;
		ValaEnum* _tmp243_;
		const gchar* _tmp244_;
		const gchar* _tmp245_;
		ValaSourceReference* _tmp246_;
		ValaErrorDomain* _tmp247_;
		ValaErrorDomain* _tmp248_;
		ValaErrorDomain* _tmp249_;
		const gchar* _tmp250_;
		const gchar* _tmp251_;
		ValaSourceFile* _tmp269_;
		ValaErrorDomain* _tmp270_;
		_tmp243_ = en;
		_tmp244_ = vala_symbol_get_name ((ValaSymbol*) _tmp243_);
		_tmp245_ = _tmp244_;
		_tmp246_ = self->priv->current_source_reference;
		_tmp247_ = vala_error_domain_new (_tmp245_, _tmp246_, NULL);
		ed = _tmp247_;
		_tmp248_ = ed;
		vala_symbol_set_access ((ValaSymbol*) _tmp248_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp249_ = ed;
		_tmp250_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp249_, "CCode", "cprefix", _tmp250_, NULL);
		_tmp251_ = cheader_filename;
		if (_tmp251_ != NULL) {
			ValaErrorDomain* _tmp252_;
			const gchar* _tmp253_;
			_tmp252_ = ed;
			_tmp253_ = cheader_filename;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp252_, "CCode", "cheader_filename", _tmp253_, NULL);
		}
		{
			ValaList* _ev_list = NULL;
			ValaEnum* _tmp254_;
			ValaList* _tmp255_;
			gint _ev_size = 0;
			ValaList* _tmp256_;
			gint _tmp257_;
			gint _tmp258_;
			gint _ev_index = 0;
			_tmp254_ = en;
			_tmp255_ = vala_enum_get_values (_tmp254_);
			_ev_list = _tmp255_;
			_tmp256_ = _ev_list;
			_tmp257_ = vala_collection_get_size ((ValaCollection*) _tmp256_);
			_tmp258_ = _tmp257_;
			_ev_size = _tmp258_;
			_ev_index = -1;
			while (TRUE) {
				gint _tmp259_;
				gint _tmp260_;
				ValaEnumValue* ev = NULL;
				ValaList* _tmp261_;
				gpointer _tmp262_;
				ValaErrorDomain* _tmp263_;
				ValaEnumValue* _tmp264_;
				const gchar* _tmp265_;
				const gchar* _tmp266_;
				ValaErrorCode* _tmp267_;
				ValaErrorCode* _tmp268_;
				_ev_index = _ev_index + 1;
				_tmp259_ = _ev_index;
				_tmp260_ = _ev_size;
				if (!(_tmp259_ < _tmp260_)) {
					break;
				}
				_tmp261_ = _ev_list;
				_tmp262_ = vala_list_get (_tmp261_, _ev_index);
				ev = (ValaEnumValue*) _tmp262_;
				_tmp263_ = ed;
				_tmp264_ = ev;
				_tmp265_ = vala_symbol_get_name ((ValaSymbol*) _tmp264_);
				_tmp266_ = _tmp265_;
				_tmp267_ = vala_error_code_new (_tmp266_, NULL, NULL);
				_tmp268_ = _tmp267_;
				vala_error_domain_add_code (_tmp263_, _tmp268_);
				_vala_code_node_unref0 (_tmp268_);
				_vala_code_node_unref0 (ev);
			}
		}
		_tmp269_ = self->priv->current_source_file;
		_tmp270_ = ed;
		vala_source_file_add_node (_tmp269_, (ValaCodeNode*) _tmp270_);
		if (!existing) {
			ValaErrorDomain* _tmp271_;
			_tmp271_ = ed;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp271_);
		}
		_vala_code_node_unref0 (ed);
	} else {
		ValaEnum* _tmp272_;
		ValaSourceFile* _tmp273_;
		ValaEnum* _tmp274_;
		_tmp272_ = en;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp272_, "Flags", is_flags, NULL);
		_tmp273_ = self->priv->current_source_file;
		_tmp274_ = en;
		vala_source_file_add_node (_tmp273_, (ValaCodeNode*) _tmp274_);
		if (!existing) {
			ValaEnum* _tmp275_;
			_tmp275_ = en;
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp275_);
		}
	}
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cheader_filename);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (en);
	_g_free0 (name);
}

static void
vala_gidl_parser_parse_object (ValaGIdlParser* self,
                               GIdlNodeInterface* node,
                               ValaSymbol* container,
                               GIdlModule* module)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* base_class = NULL;
	ValaClass* cl = NULL;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaClass* _tmp6_;
	ValaClass* _tmp7_;
	const gchar* _tmp131_;
	GList* _tmp152_;
	ValaClass* _tmp174_;
	ValaTypeSymbol* _tmp175_;
	GHashFunc _tmp176_;
	GEqualFunc _tmp177_;
	ValaHashSet* _tmp178_;
	ValaHashMap* current_type_func_map = NULL;
	GHashFunc _tmp179_;
	GEqualFunc _tmp180_;
	GEqualFunc _tmp181_;
	ValaHashMap* _tmp182_;
	ValaHashMap* current_type_vfunc_map = NULL;
	GHashFunc _tmp183_;
	GEqualFunc _tmp184_;
	GEqualFunc _tmp185_;
	ValaHashMap* _tmp186_;
	GList* _tmp187_;
	GList* _tmp197_;
	GList* _tmp229_;
	ValaClass* _tmp287_;
	ValaClass* _tmp288_;
	ValaCreationMethod* _tmp289_;
	ValaCreationMethod* _tmp290_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = ((GIdlNode*) node)->name;
	_tmp1_ = vala_gidl_parser_fix_type_name (self, _tmp0_, container);
	name = _tmp1_;
	base_class = NULL;
	_tmp2_ = vala_symbol_get_scope (container);
	_tmp3_ = _tmp2_;
	_tmp4_ = name;
	_tmp5_ = vala_scope_lookup (_tmp3_, _tmp4_);
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_vala_code_node_unref0 (_tmp5_);
	}
	cl = _tmp6_;
	_tmp7_ = cl;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaClass* _tmp10_;
		ValaClass* _tmp11_;
		gchar** attributes = NULL;
		const gchar* _tmp12_;
		gint _tmp13_ = 0;
		gchar** _tmp14_;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		ValaClass* _tmp128_;
		ValaSourceFile* _tmp129_;
		ValaClass* _tmp130_;
		_tmp8_ = name;
		_tmp9_ = self->priv->current_source_reference;
		_tmp10_ = vala_class_new (_tmp8_, _tmp9_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp10_;
		_tmp11_ = cl;
		vala_symbol_set_access ((ValaSymbol*) _tmp11_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp12_ = node->gtype_name;
		_tmp14_ = vala_gidl_parser_get_attributes (self, _tmp12_, &_tmp13_);
		attributes = _tmp14_;
		attributes_length1 = _tmp13_;
		_attributes_size_ = attributes_length1;
		_tmp15_ = attributes;
		_tmp15__length1 = attributes_length1;
		if (_tmp15_ != NULL) {
			gchar** _tmp16_;
			gint _tmp16__length1;
			_tmp16_ = attributes;
			_tmp16__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp16_;
				attr_collection_length1 = _tmp16__length1;
				for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
					gchar* _tmp17_;
					gchar* attr = NULL;
					_tmp17_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp17_;
					{
						gchar** nv = NULL;
						const gchar* _tmp18_;
						gchar** _tmp19_;
						gchar** _tmp20_;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						_tmp18_ = attr;
						_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
						nv = _tmp20_;
						nv_length1 = _vala_array_length (_tmp19_);
						_nv_size_ = nv_length1;
						_tmp21_ = nv;
						_tmp21__length1 = nv_length1;
						_tmp22_ = _tmp21_[0];
						if (g_strcmp0 (_tmp22_, "cheader_filename") == 0) {
							ValaClass* _tmp23_;
							gchar** _tmp24_;
							gint _tmp24__length1;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp23_ = cl;
							_tmp24_ = nv;
							_tmp24__length1 = nv_length1;
							_tmp25_ = _tmp24_[1];
							_tmp26_ = vala_gidl_parser_eval (self, _tmp25_);
							_tmp27_ = _tmp26_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp23_, "CCode", "cheader_filename", _tmp27_, NULL);
							_g_free0 (_tmp27_);
						} else {
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[0];
							if (g_strcmp0 (_tmp29_, "base_class") == 0) {
								gchar** _tmp30_;
								gint _tmp30__length1;
								const gchar* _tmp31_;
								gchar* _tmp32_;
								_tmp30_ = nv;
								_tmp30__length1 = nv_length1;
								_tmp31_ = _tmp30_[1];
								_tmp32_ = vala_gidl_parser_eval (self, _tmp31_);
								_g_free0 (base_class);
								base_class = _tmp32_;
							} else {
								gchar** _tmp33_;
								gint _tmp33__length1;
								const gchar* _tmp34_;
								_tmp33_ = nv;
								_tmp33__length1 = nv_length1;
								_tmp34_ = _tmp33_[0];
								if (g_strcmp0 (_tmp34_, "hidden") == 0) {
									gchar** _tmp35_;
									gint _tmp35__length1;
									const gchar* _tmp36_;
									gchar* _tmp37_;
									gchar* _tmp38_;
									gboolean _tmp39_;
									_tmp35_ = nv;
									_tmp35__length1 = nv_length1;
									_tmp36_ = _tmp35_[1];
									_tmp37_ = vala_gidl_parser_eval (self, _tmp36_);
									_tmp38_ = _tmp37_;
									_tmp39_ = g_strcmp0 (_tmp38_, "1") == 0;
									_g_free0 (_tmp38_);
									if (_tmp39_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (base_class);
										_g_free0 (name);
										return;
									}
								} else {
									gchar** _tmp40_;
									gint _tmp40__length1;
									const gchar* _tmp41_;
									_tmp40_ = nv;
									_tmp40__length1 = nv_length1;
									_tmp41_ = _tmp40_[0];
									if (g_strcmp0 (_tmp41_, "type_check_function") == 0) {
										ValaClass* _tmp42_;
										gchar** _tmp43_;
										gint _tmp43__length1;
										const gchar* _tmp44_;
										gchar* _tmp45_;
										gchar* _tmp46_;
										_tmp42_ = cl;
										_tmp43_ = nv;
										_tmp43__length1 = nv_length1;
										_tmp44_ = _tmp43_[1];
										_tmp45_ = vala_gidl_parser_eval (self, _tmp44_);
										_tmp46_ = _tmp45_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp42_, "CCode", "type_check_function", _tmp46_, NULL);
										_g_free0 (_tmp46_);
									} else {
										gchar** _tmp47_;
										gint _tmp47__length1;
										const gchar* _tmp48_;
										_tmp47_ = nv;
										_tmp47__length1 = nv_length1;
										_tmp48_ = _tmp47_[0];
										if (g_strcmp0 (_tmp48_, "deprecated") == 0) {
											gchar** _tmp49_;
											gint _tmp49__length1;
											const gchar* _tmp50_;
											gchar* _tmp51_;
											gchar* _tmp52_;
											gboolean _tmp53_;
											_tmp49_ = nv;
											_tmp49__length1 = nv_length1;
											_tmp50_ = _tmp49_[1];
											_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
											_tmp52_ = _tmp51_;
											_tmp53_ = g_strcmp0 (_tmp52_, "1") == 0;
											_g_free0 (_tmp52_);
											if (_tmp53_) {
												ValaClass* _tmp54_;
												_tmp54_ = cl;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp54_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp55_;
											gint _tmp55__length1;
											const gchar* _tmp56_;
											_tmp55_ = nv;
											_tmp55__length1 = nv_length1;
											_tmp56_ = _tmp55_[0];
											if (g_strcmp0 (_tmp56_, "replacement") == 0) {
												ValaClass* _tmp57_;
												gchar** _tmp58_;
												gint _tmp58__length1;
												const gchar* _tmp59_;
												gchar* _tmp60_;
												gchar* _tmp61_;
												_tmp57_ = cl;
												_tmp58_ = nv;
												_tmp58__length1 = nv_length1;
												_tmp59_ = _tmp58_[1];
												_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
												_tmp61_ = _tmp60_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp57_, "Version", "replacement", _tmp61_, NULL);
												_g_free0 (_tmp61_);
											} else {
												gchar** _tmp62_;
												gint _tmp62__length1;
												const gchar* _tmp63_;
												_tmp62_ = nv;
												_tmp62__length1 = nv_length1;
												_tmp63_ = _tmp62_[0];
												if (g_strcmp0 (_tmp63_, "deprecated_since") == 0) {
													ValaClass* _tmp64_;
													gchar** _tmp65_;
													gint _tmp65__length1;
													const gchar* _tmp66_;
													gchar* _tmp67_;
													gchar* _tmp68_;
													_tmp64_ = cl;
													_tmp65_ = nv;
													_tmp65__length1 = nv_length1;
													_tmp66_ = _tmp65_[1];
													_tmp67_ = vala_gidl_parser_eval (self, _tmp66_);
													_tmp68_ = _tmp67_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp64_, "Version", "deprecated_since", _tmp68_, NULL);
													_g_free0 (_tmp68_);
												} else {
													gchar** _tmp69_;
													gint _tmp69__length1;
													const gchar* _tmp70_;
													_tmp69_ = nv;
													_tmp69__length1 = nv_length1;
													_tmp70_ = _tmp69_[0];
													if (g_strcmp0 (_tmp70_, "type_id") == 0) {
														ValaClass* _tmp71_;
														gchar** _tmp72_;
														gint _tmp72__length1;
														const gchar* _tmp73_;
														gchar* _tmp74_;
														gchar* _tmp75_;
														_tmp71_ = cl;
														_tmp72_ = nv;
														_tmp72__length1 = nv_length1;
														_tmp73_ = _tmp72_[1];
														_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
														_tmp75_ = _tmp74_;
														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp71_, "CCode", "type_id", _tmp75_, NULL);
														_g_free0 (_tmp75_);
													} else {
														gchar** _tmp76_;
														gint _tmp76__length1;
														const gchar* _tmp77_;
														_tmp76_ = nv;
														_tmp76__length1 = nv_length1;
														_tmp77_ = _tmp76_[0];
														if (g_strcmp0 (_tmp77_, "abstract") == 0) {
															gchar** _tmp78_;
															gint _tmp78__length1;
															const gchar* _tmp79_;
															gchar* _tmp80_;
															gchar* _tmp81_;
															gboolean _tmp82_;
															_tmp78_ = nv;
															_tmp78__length1 = nv_length1;
															_tmp79_ = _tmp78_[1];
															_tmp80_ = vala_gidl_parser_eval (self, _tmp79_);
															_tmp81_ = _tmp80_;
															_tmp82_ = g_strcmp0 (_tmp81_, "1") == 0;
															_g_free0 (_tmp81_);
															if (_tmp82_) {
																ValaClass* _tmp83_;
																_tmp83_ = cl;
																vala_class_set_is_abstract (_tmp83_, TRUE);
															}
														} else {
															gchar** _tmp84_;
															gint _tmp84__length1;
															const gchar* _tmp85_;
															_tmp84_ = nv;
															_tmp84__length1 = nv_length1;
															_tmp85_ = _tmp84_[0];
															if (g_strcmp0 (_tmp85_, "experimental") == 0) {
																gchar** _tmp86_;
																gint _tmp86__length1;
																const gchar* _tmp87_;
																gchar* _tmp88_;
																gchar* _tmp89_;
																gboolean _tmp90_;
																_tmp86_ = nv;
																_tmp86__length1 = nv_length1;
																_tmp87_ = _tmp86_[1];
																_tmp88_ = vala_gidl_parser_eval (self, _tmp87_);
																_tmp89_ = _tmp88_;
																_tmp90_ = g_strcmp0 (_tmp89_, "1") == 0;
																_g_free0 (_tmp89_);
																if (_tmp90_) {
																	ValaClass* _tmp91_;
																	_tmp91_ = cl;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp91_, "Version", "experimental", TRUE, NULL);
																}
															} else {
																gchar** _tmp92_;
																gint _tmp92__length1;
																const gchar* _tmp93_;
																_tmp92_ = nv;
																_tmp92__length1 = nv_length1;
																_tmp93_ = _tmp92_[0];
																if (g_strcmp0 (_tmp93_, "compact") == 0) {
																	gchar** _tmp94_;
																	gint _tmp94__length1;
																	const gchar* _tmp95_;
																	gchar* _tmp96_;
																	gchar* _tmp97_;
																	gboolean _tmp98_;
																	_tmp94_ = nv;
																	_tmp94__length1 = nv_length1;
																	_tmp95_ = _tmp94_[1];
																	_tmp96_ = vala_gidl_parser_eval (self, _tmp95_);
																	_tmp97_ = _tmp96_;
																	_tmp98_ = g_strcmp0 (_tmp97_, "1") == 0;
																	_g_free0 (_tmp97_);
																	if (_tmp98_) {
																		ValaClass* _tmp99_;
																		_tmp99_ = cl;
																		vala_code_node_set_attribute ((ValaCodeNode*) _tmp99_, "Compact", TRUE, NULL);
																	}
																} else {
																	gchar** _tmp100_;
																	gint _tmp100__length1;
																	const gchar* _tmp101_;
																	_tmp100_ = nv;
																	_tmp100__length1 = nv_length1;
																	_tmp101_ = _tmp100_[0];
																	if (g_strcmp0 (_tmp101_, "ref_function") == 0) {
																		ValaClass* _tmp102_;
																		gchar** _tmp103_;
																		gint _tmp103__length1;
																		const gchar* _tmp104_;
																		gchar* _tmp105_;
																		gchar* _tmp106_;
																		_tmp102_ = cl;
																		_tmp103_ = nv;
																		_tmp103__length1 = nv_length1;
																		_tmp104_ = _tmp103_[1];
																		_tmp105_ = vala_gidl_parser_eval (self, _tmp104_);
																		_tmp106_ = _tmp105_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "CCode", "ref_function", _tmp106_, NULL);
																		_g_free0 (_tmp106_);
																	} else {
																		gchar** _tmp107_;
																		gint _tmp107__length1;
																		const gchar* _tmp108_;
																		_tmp107_ = nv;
																		_tmp107__length1 = nv_length1;
																		_tmp108_ = _tmp107_[0];
																		if (g_strcmp0 (_tmp108_, "unref_function") == 0) {
																			ValaClass* _tmp109_;
																			gchar** _tmp110_;
																			gint _tmp110__length1;
																			const gchar* _tmp111_;
																			gchar* _tmp112_;
																			gchar* _tmp113_;
																			_tmp109_ = cl;
																			_tmp110_ = nv;
																			_tmp110__length1 = nv_length1;
																			_tmp111_ = _tmp110_[1];
																			_tmp112_ = vala_gidl_parser_eval (self, _tmp111_);
																			_tmp113_ = _tmp112_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp109_, "CCode", "unref_function", _tmp113_, NULL);
																			_g_free0 (_tmp113_);
																		} else {
																			gchar** _tmp114_;
																			gint _tmp114__length1;
																			const gchar* _tmp115_;
																			_tmp114_ = nv;
																			_tmp114__length1 = nv_length1;
																			_tmp115_ = _tmp114_[0];
																			if (g_strcmp0 (_tmp115_, "copy_function") == 0) {
																				ValaClass* _tmp116_;
																				gchar** _tmp117_;
																				gint _tmp117__length1;
																				const gchar* _tmp118_;
																				gchar* _tmp119_;
																				gchar* _tmp120_;
																				_tmp116_ = cl;
																				_tmp117_ = nv;
																				_tmp117__length1 = nv_length1;
																				_tmp118_ = _tmp117_[1];
																				_tmp119_ = vala_gidl_parser_eval (self, _tmp118_);
																				_tmp120_ = _tmp119_;
																				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp116_, "CCode", "copy_function", _tmp120_, NULL);
																				_g_free0 (_tmp120_);
																			} else {
																				gchar** _tmp121_;
																				gint _tmp121__length1;
																				const gchar* _tmp122_;
																				_tmp121_ = nv;
																				_tmp121__length1 = nv_length1;
																				_tmp122_ = _tmp121_[0];
																				if (g_strcmp0 (_tmp122_, "free_function") == 0) {
																					ValaClass* _tmp123_;
																					gchar** _tmp124_;
																					gint _tmp124__length1;
																					const gchar* _tmp125_;
																					gchar* _tmp126_;
																					gchar* _tmp127_;
																					_tmp123_ = cl;
																					_tmp124_ = nv;
																					_tmp124__length1 = nv_length1;
																					_tmp125_ = _tmp124_[1];
																					_tmp126_ = vala_gidl_parser_eval (self, _tmp125_);
																					_tmp127_ = _tmp126_;
																					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp123_, "CCode", "free_function", _tmp127_, NULL);
																					_g_free0 (_tmp127_);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp128_ = cl;
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp128_);
		_tmp129_ = self->priv->current_source_file;
		_tmp130_ = cl;
		vala_source_file_add_node (_tmp129_, (ValaCodeNode*) _tmp130_);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp131_ = base_class;
	if (_tmp131_ != NULL) {
		ValaDataType* parent = NULL;
		const gchar* _tmp132_;
		ValaDataType* _tmp133_;
		ValaClass* _tmp134_;
		ValaDataType* _tmp135_;
		_tmp132_ = base_class;
		_tmp133_ = vala_gidl_parser_parse_type_string (self, _tmp132_);
		parent = _tmp133_;
		_tmp134_ = cl;
		_tmp135_ = parent;
		vala_class_add_base_type (_tmp134_, _tmp135_);
		_vala_code_node_unref0 (parent);
	} else {
		const gchar* _tmp136_;
		_tmp136_ = node->parent;
		if (_tmp136_ != NULL) {
			ValaClass* _tmp137_;
			gboolean _tmp138_;
			gboolean _tmp139_;
			_tmp137_ = cl;
			_tmp138_ = vala_class_get_is_compact (_tmp137_);
			_tmp139_ = _tmp138_;
			if (!_tmp139_) {
				ValaDataType* parent = NULL;
				const gchar* _tmp140_;
				ValaDataType* _tmp141_;
				ValaClass* _tmp142_;
				ValaDataType* _tmp143_;
				_tmp140_ = node->parent;
				_tmp141_ = vala_gidl_parser_parse_type_string (self, _tmp140_);
				parent = _tmp141_;
				_tmp142_ = cl;
				_tmp143_ = parent;
				vala_class_add_base_type (_tmp142_, _tmp143_);
				_vala_code_node_unref0 (parent);
			}
		} else {
			ValaUnresolvedSymbol* gobject_symbol = NULL;
			ValaUnresolvedSymbol* _tmp144_;
			ValaUnresolvedSymbol* _tmp145_;
			ValaUnresolvedSymbol* _tmp146_;
			ValaUnresolvedSymbol* _tmp147_;
			ValaClass* _tmp148_;
			ValaUnresolvedSymbol* _tmp149_;
			ValaUnresolvedType* _tmp150_;
			ValaUnresolvedType* _tmp151_;
			_tmp144_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_unresolved_symbol_new (_tmp145_, "Object", NULL);
			_tmp147_ = _tmp146_;
			_vala_code_node_unref0 (_tmp145_);
			gobject_symbol = _tmp147_;
			_tmp148_ = cl;
			_tmp149_ = gobject_symbol;
			_tmp150_ = vala_unresolved_type_new_from_symbol (_tmp149_, NULL);
			_tmp151_ = _tmp150_;
			vala_class_add_base_type (_tmp148_, (ValaDataType*) _tmp151_);
			_vala_code_node_unref0 (_tmp151_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	_tmp152_ = node->interfaces;
	{
		GList* iface_name_collection = NULL;
		GList* iface_name_it = NULL;
		iface_name_collection = _tmp152_;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			gchar* _tmp153_;
			gchar* iface_name = NULL;
			_tmp153_ = g_strdup ((const gchar*) iface_name_it->data);
			iface_name = _tmp153_;
			{
				gboolean skip_iface = FALSE;
				gchar** attributes = NULL;
				const gchar* _tmp154_;
				gint _tmp155_ = 0;
				gchar** _tmp156_;
				gint attributes_length1;
				gint _attributes_size_;
				gchar** _tmp157_;
				gint _tmp157__length1;
				ValaDataType* iface = NULL;
				const gchar* _tmp170_;
				ValaDataType* _tmp171_;
				ValaClass* _tmp172_;
				ValaDataType* _tmp173_;
				skip_iface = FALSE;
				_tmp154_ = iface_name;
				_tmp156_ = vala_gidl_parser_get_attributes (self, _tmp154_, &_tmp155_);
				attributes = _tmp156_;
				attributes_length1 = _tmp155_;
				_attributes_size_ = attributes_length1;
				_tmp157_ = attributes;
				_tmp157__length1 = attributes_length1;
				if (_tmp157_ != NULL) {
					gchar** _tmp158_;
					gint _tmp158__length1;
					_tmp158_ = attributes;
					_tmp158__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp158_;
						attr_collection_length1 = _tmp158__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp159_;
							gchar* attr = NULL;
							_tmp159_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp159_;
							{
								gchar** nv = NULL;
								const gchar* _tmp160_;
								gchar** _tmp161_;
								gchar** _tmp162_;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp163_;
								gint _tmp163__length1;
								const gchar* _tmp164_;
								_tmp160_ = attr;
								_tmp162_ = _tmp161_ = g_strsplit (_tmp160_, "=", 2);
								nv = _tmp162_;
								nv_length1 = _vala_array_length (_tmp161_);
								_nv_size_ = nv_length1;
								_tmp163_ = nv;
								_tmp163__length1 = nv_length1;
								_tmp164_ = _tmp163_[0];
								if (g_strcmp0 (_tmp164_, "hidden") == 0) {
									gchar** _tmp165_;
									gint _tmp165__length1;
									const gchar* _tmp166_;
									gchar* _tmp167_;
									gchar* _tmp168_;
									gboolean _tmp169_;
									_tmp165_ = nv;
									_tmp165__length1 = nv_length1;
									_tmp166_ = _tmp165_[1];
									_tmp167_ = vala_gidl_parser_eval (self, _tmp166_);
									_tmp168_ = _tmp167_;
									_tmp169_ = g_strcmp0 (_tmp168_, "1") == 0;
									_g_free0 (_tmp168_);
									if (_tmp169_) {
										skip_iface = TRUE;
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (skip_iface) {
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (iface_name);
					continue;
				}
				_tmp170_ = iface_name;
				_tmp171_ = vala_gidl_parser_parse_type_string (self, _tmp170_);
				iface = _tmp171_;
				_tmp172_ = cl;
				_tmp173_ = iface;
				vala_class_add_base_type (_tmp172_, _tmp173_);
				_vala_code_node_unref0 (iface);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (iface_name);
			}
		}
	}
	_tmp174_ = cl;
	_tmp175_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp174_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp175_;
	_tmp176_ = g_str_hash;
	_tmp177_ = g_str_equal;
	_tmp178_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp176_, _tmp177_);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = (ValaSet*) _tmp178_;
	_tmp179_ = g_str_hash;
	_tmp180_ = g_str_equal;
	_tmp181_ = g_direct_equal;
	_tmp182_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_POINTER, NULL, NULL, _tmp179_, _tmp180_, _tmp181_);
	current_type_func_map = _tmp182_;
	_tmp183_ = g_str_hash;
	_tmp184_ = g_str_equal;
	_tmp185_ = g_direct_equal;
	_tmp186_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp183_, _tmp184_, _tmp185_);
	current_type_vfunc_map = _tmp186_;
	_tmp187_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp187_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp188_;
				GIdlNode* _tmp193_;
				_tmp188_ = member;
				if (_tmp188_->type == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp189_;
					GIdlNode* _tmp190_;
					const gchar* _tmp191_;
					GIdlNode* _tmp192_;
					_tmp189_ = current_type_func_map;
					_tmp190_ = member;
					_tmp191_ = _tmp190_->name;
					_tmp192_ = member;
					vala_map_set ((ValaMap*) _tmp189_, _tmp191_, (GIdlNodeFunction*) _tmp192_);
				}
				_tmp193_ = member;
				if (_tmp193_->type == G_IDL_NODE_VFUNC) {
					ValaHashMap* _tmp194_;
					GIdlNode* _tmp195_;
					const gchar* _tmp196_;
					_tmp194_ = current_type_vfunc_map;
					_tmp195_ = member;
					_tmp196_ = _tmp195_->name;
					vala_map_set ((ValaMap*) _tmp194_, _tmp196_, "1");
				}
			}
		}
	}
	_tmp197_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp197_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp198_;
				_tmp198_ = member;
				if (_tmp198_->type == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp199_;
					GIdlNode* _tmp200_;
					const gchar* _tmp201_;
					_tmp199_ = current_type_vfunc_map;
					_tmp200_ = member;
					_tmp201_ = _tmp200_->name;
					if (!vala_map_contains ((ValaMap*) _tmp199_, _tmp201_)) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp202_;
						ValaMethod* _tmp203_;
						ValaMethod* _tmp204_;
						_tmp202_ = member;
						_tmp203_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp202_, FALSE);
						m = _tmp203_;
						_tmp204_ = m;
						if (_tmp204_ != NULL) {
							ValaClass* _tmp205_;
							ValaMethod* _tmp206_;
							_tmp205_ = cl;
							_tmp206_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp205_, _tmp206_);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					GIdlNode* _tmp207_;
					_tmp207_ = member;
					if (_tmp207_->type == G_IDL_NODE_VFUNC) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp208_;
						ValaHashMap* _tmp209_;
						GIdlNode* _tmp210_;
						const gchar* _tmp211_;
						gpointer _tmp212_;
						ValaMethod* _tmp213_;
						ValaMethod* _tmp214_;
						_tmp208_ = member;
						_tmp209_ = current_type_func_map;
						_tmp210_ = member;
						_tmp211_ = _tmp210_->name;
						_tmp212_ = vala_map_get ((ValaMap*) _tmp209_, _tmp211_);
						_tmp213_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) _tmp208_, (GIdlNodeFunction*) _tmp212_, FALSE);
						m = _tmp213_;
						_tmp214_ = m;
						if (_tmp214_ != NULL) {
							ValaClass* _tmp215_;
							ValaMethod* _tmp216_;
							_tmp215_ = cl;
							_tmp216_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp215_, _tmp216_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp217_;
						_tmp217_ = member;
						if (_tmp217_->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop = NULL;
							GIdlNode* _tmp218_;
							ValaProperty* _tmp219_;
							ValaProperty* _tmp220_;
							_tmp218_ = member;
							_tmp219_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) _tmp218_);
							prop = _tmp219_;
							_tmp220_ = prop;
							if (_tmp220_ != NULL) {
								ValaClass* _tmp221_;
								ValaProperty* _tmp222_;
								_tmp221_ = cl;
								_tmp222_ = prop;
								vala_symbol_add_property ((ValaSymbol*) _tmp221_, _tmp222_);
							}
							_vala_code_node_unref0 (prop);
						} else {
							GIdlNode* _tmp223_;
							_tmp223_ = member;
							if (_tmp223_->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig = NULL;
								GIdlNode* _tmp224_;
								ValaSignal* _tmp225_;
								ValaSignal* _tmp226_;
								_tmp224_ = member;
								_tmp225_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) _tmp224_);
								sig = _tmp225_;
								_tmp226_ = sig;
								if (_tmp226_ != NULL) {
									ValaClass* _tmp227_;
									ValaSignal* _tmp228_;
									_tmp227_ = cl;
									_tmp228_ = sig;
									vala_symbol_add_signal ((ValaSymbol*) _tmp227_, _tmp228_);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	_tmp229_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp229_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp230_;
				_tmp230_ = member;
				if (_tmp230_->type == G_IDL_NODE_FIELD) {
					ValaSet* _tmp231_;
					GIdlNode* _tmp232_;
					const gchar* _tmp233_;
					_tmp231_ = self->priv->current_type_symbol_set;
					_tmp232_ = member;
					_tmp233_ = _tmp232_->name;
					if (!vala_collection_contains ((ValaCollection*) _tmp231_, _tmp233_)) {
						ValaField* f = NULL;
						GIdlNode* _tmp234_;
						ValaField* _tmp235_;
						ValaField* _tmp236_;
						_tmp234_ = member;
						_tmp235_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp234_);
						f = _tmp235_;
						_tmp236_ = f;
						if (_tmp236_ != NULL) {
							ValaClass* _tmp237_;
							ValaField* _tmp238_;
							_tmp237_ = cl;
							_tmp238_ = f;
							vala_symbol_add_field ((ValaSymbol*) _tmp237_, _tmp238_);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaClass* _tmp239_;
		ValaList* _tmp240_;
		gint _prop_size = 0;
		ValaList* _tmp241_;
		gint _tmp242_;
		gint _tmp243_;
		gint _prop_index = 0;
		_tmp239_ = cl;
		_tmp240_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp239_);
		_prop_list = _tmp240_;
		_tmp241_ = _prop_list;
		_tmp242_ = vala_collection_get_size ((ValaCollection*) _tmp241_);
		_tmp243_ = _tmp242_;
		_prop_size = _tmp243_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp244_;
			gint _tmp245_;
			ValaProperty* prop = NULL;
			ValaList* _tmp246_;
			gpointer _tmp247_;
			gchar* getter = NULL;
			ValaProperty* _tmp248_;
			const gchar* _tmp249_;
			const gchar* _tmp250_;
			gchar* _tmp251_;
			gboolean _tmp252_ = FALSE;
			ValaProperty* _tmp253_;
			ValaPropertyAccessor* _tmp254_;
			ValaPropertyAccessor* _tmp255_;
			gchar* setter = NULL;
			ValaProperty* _tmp259_;
			const gchar* _tmp260_;
			const gchar* _tmp261_;
			gchar* _tmp262_;
			gboolean _tmp263_ = FALSE;
			gboolean _tmp264_ = FALSE;
			ValaProperty* _tmp265_;
			ValaPropertyAccessor* _tmp266_;
			ValaPropertyAccessor* _tmp267_;
			gboolean _tmp276_ = FALSE;
			ValaProperty* _tmp277_;
			ValaAttribute* _tmp278_;
			_prop_index = _prop_index + 1;
			_tmp244_ = _prop_index;
			_tmp245_ = _prop_size;
			if (!(_tmp244_ < _tmp245_)) {
				break;
			}
			_tmp246_ = _prop_list;
			_tmp247_ = vala_list_get (_tmp246_, _prop_index);
			prop = (ValaProperty*) _tmp247_;
			_tmp248_ = prop;
			_tmp249_ = vala_symbol_get_name ((ValaSymbol*) _tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = g_strdup_printf ("get_%s", _tmp250_);
			getter = _tmp251_;
			_tmp253_ = prop;
			_tmp254_ = vala_property_get_get_accessor (_tmp253_);
			_tmp255_ = _tmp254_;
			if (_tmp255_ != NULL) {
				ValaSet* _tmp256_;
				const gchar* _tmp257_;
				_tmp256_ = self->priv->current_type_symbol_set;
				_tmp257_ = getter;
				_tmp252_ = !vala_collection_contains ((ValaCollection*) _tmp256_, _tmp257_);
			} else {
				_tmp252_ = FALSE;
			}
			if (_tmp252_) {
				ValaProperty* _tmp258_;
				_tmp258_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp258_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp259_ = prop;
			_tmp260_ = vala_symbol_get_name ((ValaSymbol*) _tmp259_);
			_tmp261_ = _tmp260_;
			_tmp262_ = g_strdup_printf ("set_%s", _tmp261_);
			setter = _tmp262_;
			_tmp265_ = prop;
			_tmp266_ = vala_property_get_set_accessor (_tmp265_);
			_tmp267_ = _tmp266_;
			if (_tmp267_ != NULL) {
				ValaProperty* _tmp268_;
				ValaPropertyAccessor* _tmp269_;
				ValaPropertyAccessor* _tmp270_;
				gboolean _tmp271_;
				gboolean _tmp272_;
				_tmp268_ = prop;
				_tmp269_ = vala_property_get_set_accessor (_tmp268_);
				_tmp270_ = _tmp269_;
				_tmp271_ = vala_property_accessor_get_writable (_tmp270_);
				_tmp272_ = _tmp271_;
				_tmp264_ = _tmp272_;
			} else {
				_tmp264_ = FALSE;
			}
			if (_tmp264_) {
				ValaSet* _tmp273_;
				const gchar* _tmp274_;
				_tmp273_ = self->priv->current_type_symbol_set;
				_tmp274_ = setter;
				_tmp263_ = !vala_collection_contains ((ValaCollection*) _tmp273_, _tmp274_);
			} else {
				_tmp263_ = FALSE;
			}
			if (_tmp263_) {
				ValaProperty* _tmp275_;
				_tmp275_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp275_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp277_ = prop;
			_tmp278_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp277_, "NoAccessorMethod");
			if (_tmp278_ != NULL) {
				ValaProperty* _tmp279_;
				ValaPropertyAccessor* _tmp280_;
				ValaPropertyAccessor* _tmp281_;
				_tmp279_ = prop;
				_tmp280_ = vala_property_get_get_accessor (_tmp279_);
				_tmp281_ = _tmp280_;
				_tmp276_ = _tmp281_ != NULL;
			} else {
				_tmp276_ = FALSE;
			}
			if (_tmp276_) {
				ValaProperty* _tmp282_;
				ValaPropertyAccessor* _tmp283_;
				ValaPropertyAccessor* _tmp284_;
				ValaDataType* _tmp285_;
				ValaDataType* _tmp286_;
				_tmp282_ = prop;
				_tmp283_ = vala_property_get_get_accessor (_tmp282_);
				_tmp284_ = _tmp283_;
				_tmp285_ = vala_property_accessor_get_value_type (_tmp284_);
				_tmp286_ = _tmp285_;
				vala_data_type_set_value_owned (_tmp286_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
	}
	_tmp287_ = cl;
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) _tmp287_);
	_tmp288_ = cl;
	_tmp289_ = vala_class_get_default_construction_method (_tmp288_);
	_tmp290_ = _tmp289_;
	if (_tmp290_ == NULL) {
		ValaCreationMethod* cm = NULL;
		ValaClass* _tmp291_;
		ValaSourceReference* _tmp292_;
		ValaSourceReference* _tmp293_;
		ValaCreationMethod* _tmp294_;
		ValaCreationMethod* _tmp295_;
		ValaCreationMethod* _tmp296_;
		ValaClass* _tmp297_;
		ValaCreationMethod* _tmp298_;
		_tmp291_ = cl;
		_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp291_);
		_tmp293_ = _tmp292_;
		_tmp294_ = vala_creation_method_new (NULL, NULL, _tmp293_, NULL);
		cm = _tmp294_;
		_tmp295_ = cm;
		vala_method_set_has_construct_function ((ValaMethod*) _tmp295_, FALSE);
		_tmp296_ = cm;
		vala_symbol_set_access ((ValaSymbol*) _tmp296_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		_tmp297_ = cl;
		_tmp298_ = cm;
		vala_symbol_add_method ((ValaSymbol*) _tmp297_, (ValaMethod*) _tmp298_);
		_vala_code_node_unref0 (cm);
	}
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = NULL;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = NULL;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (cl);
	_g_free0 (base_class);
	_g_free0 (name);
}

static void
vala_gidl_parser_parse_interface (ValaGIdlParser* self,
                                  GIdlNodeInterface* node,
                                  ValaSymbol* container,
                                  GIdlModule* module)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ValaInterface* iface = NULL;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaInterface* _tmp6_;
	ValaInterface* _tmp7_;
	ValaInterface* _tmp58_;
	ValaTypeSymbol* _tmp59_;
	GHashFunc _tmp60_;
	GEqualFunc _tmp61_;
	ValaHashSet* _tmp62_;
	ValaHashMap* current_type_func_map = NULL;
	GHashFunc _tmp63_;
	GEqualFunc _tmp64_;
	GEqualFunc _tmp65_;
	ValaHashMap* _tmp66_;
	ValaHashMap* current_type_vfunc_map = NULL;
	GHashFunc _tmp67_;
	GEqualFunc _tmp68_;
	GEqualFunc _tmp69_;
	ValaHashMap* _tmp70_;
	GList* _tmp71_;
	GList* _tmp81_;
	ValaInterface* _tmp162_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = node->gtype_name;
	_tmp1_ = vala_gidl_parser_fix_type_name (self, _tmp0_, container);
	name = _tmp1_;
	_tmp2_ = vala_symbol_get_scope (container);
	_tmp3_ = _tmp2_;
	_tmp4_ = name;
	_tmp5_ = vala_scope_lookup (_tmp3_, _tmp4_);
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_INTERFACE) ? ((ValaInterface*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_vala_code_node_unref0 (_tmp5_);
	}
	iface = _tmp6_;
	_tmp7_ = iface;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaInterface* _tmp10_;
		ValaInterface* _tmp11_;
		gchar** attributes = NULL;
		const gchar* _tmp12_;
		gint _tmp13_ = 0;
		gchar** _tmp14_;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		GList* _tmp49_;
		ValaInterface* _tmp55_;
		ValaSourceFile* _tmp56_;
		ValaInterface* _tmp57_;
		_tmp8_ = name;
		_tmp9_ = self->priv->current_source_reference;
		_tmp10_ = vala_interface_new (_tmp8_, _tmp9_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp10_;
		_tmp11_ = iface;
		vala_symbol_set_access ((ValaSymbol*) _tmp11_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp12_ = node->gtype_name;
		_tmp14_ = vala_gidl_parser_get_attributes (self, _tmp12_, &_tmp13_);
		attributes = _tmp14_;
		attributes_length1 = _tmp13_;
		_attributes_size_ = attributes_length1;
		_tmp15_ = attributes;
		_tmp15__length1 = attributes_length1;
		if (_tmp15_ != NULL) {
			gchar** _tmp16_;
			gint _tmp16__length1;
			_tmp16_ = attributes;
			_tmp16__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp16_;
				attr_collection_length1 = _tmp16__length1;
				for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
					gchar* _tmp17_;
					gchar* attr = NULL;
					_tmp17_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp17_;
					{
						gchar** nv = NULL;
						const gchar* _tmp18_;
						gchar** _tmp19_;
						gchar** _tmp20_;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						_tmp18_ = attr;
						_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
						nv = _tmp20_;
						nv_length1 = _vala_array_length (_tmp19_);
						_nv_size_ = nv_length1;
						_tmp21_ = nv;
						_tmp21__length1 = nv_length1;
						_tmp22_ = _tmp21_[0];
						if (g_strcmp0 (_tmp22_, "cheader_filename") == 0) {
							ValaInterface* _tmp23_;
							gchar** _tmp24_;
							gint _tmp24__length1;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp23_ = iface;
							_tmp24_ = nv;
							_tmp24__length1 = nv_length1;
							_tmp25_ = _tmp24_[1];
							_tmp26_ = vala_gidl_parser_eval (self, _tmp25_);
							_tmp27_ = _tmp26_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp23_, "CCode", "cheader_filename", _tmp27_, NULL);
							_g_free0 (_tmp27_);
						} else {
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[0];
							if (g_strcmp0 (_tmp29_, "hidden") == 0) {
								gchar** _tmp30_;
								gint _tmp30__length1;
								const gchar* _tmp31_;
								gchar* _tmp32_;
								gchar* _tmp33_;
								gboolean _tmp34_;
								_tmp30_ = nv;
								_tmp30__length1 = nv_length1;
								_tmp31_ = _tmp30_[1];
								_tmp32_ = vala_gidl_parser_eval (self, _tmp31_);
								_tmp33_ = _tmp32_;
								_tmp34_ = g_strcmp0 (_tmp33_, "1") == 0;
								_g_free0 (_tmp33_);
								if (_tmp34_) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (iface);
									_g_free0 (name);
									return;
								}
							} else {
								gchar** _tmp35_;
								gint _tmp35__length1;
								const gchar* _tmp36_;
								_tmp35_ = nv;
								_tmp35__length1 = nv_length1;
								_tmp36_ = _tmp35_[0];
								if (g_strcmp0 (_tmp36_, "type_cname") == 0) {
									ValaInterface* _tmp37_;
									gchar** _tmp38_;
									gint _tmp38__length1;
									const gchar* _tmp39_;
									gchar* _tmp40_;
									gchar* _tmp41_;
									_tmp37_ = iface;
									_tmp38_ = nv;
									_tmp38__length1 = nv_length1;
									_tmp39_ = _tmp38_[1];
									_tmp40_ = vala_gidl_parser_eval (self, _tmp39_);
									_tmp41_ = _tmp40_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp37_, "CCode", "type_cname", _tmp41_, NULL);
									_g_free0 (_tmp41_);
								} else {
									gchar** _tmp42_;
									gint _tmp42__length1;
									const gchar* _tmp43_;
									_tmp42_ = nv;
									_tmp42__length1 = nv_length1;
									_tmp43_ = _tmp42_[0];
									if (g_strcmp0 (_tmp43_, "lower_case_csuffix") == 0) {
										ValaInterface* _tmp44_;
										gchar** _tmp45_;
										gint _tmp45__length1;
										const gchar* _tmp46_;
										gchar* _tmp47_;
										gchar* _tmp48_;
										_tmp44_ = iface;
										_tmp45_ = nv;
										_tmp45__length1 = nv_length1;
										_tmp46_ = _tmp45_[1];
										_tmp47_ = vala_gidl_parser_eval (self, _tmp46_);
										_tmp48_ = _tmp47_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp44_, "CCode", "lower_case_csuffix", _tmp48_, NULL);
										_g_free0 (_tmp48_);
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp49_ = node->prerequisites;
		{
			GList* prereq_name_collection = NULL;
			GList* prereq_name_it = NULL;
			prereq_name_collection = _tmp49_;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				gchar* _tmp50_;
				gchar* prereq_name = NULL;
				_tmp50_ = g_strdup ((const gchar*) prereq_name_it->data);
				prereq_name = _tmp50_;
				{
					ValaDataType* prereq = NULL;
					const gchar* _tmp51_;
					ValaDataType* _tmp52_;
					ValaInterface* _tmp53_;
					ValaDataType* _tmp54_;
					_tmp51_ = prereq_name;
					_tmp52_ = vala_gidl_parser_parse_type_string (self, _tmp51_);
					prereq = _tmp52_;
					_tmp53_ = iface;
					_tmp54_ = prereq;
					vala_interface_add_prerequisite (_tmp53_, _tmp54_);
					_vala_code_node_unref0 (prereq);
					_g_free0 (prereq_name);
				}
			}
		}
		_tmp55_ = iface;
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) _tmp55_);
		_tmp56_ = self->priv->current_source_file;
		_tmp57_ = iface;
		vala_source_file_add_node (_tmp56_, (ValaCodeNode*) _tmp57_);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp58_ = iface;
	_tmp59_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp58_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp59_;
	_tmp60_ = g_str_hash;
	_tmp61_ = g_str_equal;
	_tmp62_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp60_, _tmp61_);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = (ValaSet*) _tmp62_;
	_tmp63_ = g_str_hash;
	_tmp64_ = g_str_equal;
	_tmp65_ = g_direct_equal;
	_tmp66_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_POINTER, NULL, NULL, _tmp63_, _tmp64_, _tmp65_);
	current_type_func_map = _tmp66_;
	_tmp67_ = g_str_hash;
	_tmp68_ = g_str_equal;
	_tmp69_ = g_direct_equal;
	_tmp70_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp67_, _tmp68_, _tmp69_);
	current_type_vfunc_map = _tmp70_;
	_tmp71_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp71_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp72_;
				GIdlNode* _tmp77_;
				_tmp72_ = member;
				if (_tmp72_->type == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp73_;
					GIdlNode* _tmp74_;
					const gchar* _tmp75_;
					GIdlNode* _tmp76_;
					_tmp73_ = current_type_func_map;
					_tmp74_ = member;
					_tmp75_ = _tmp74_->name;
					_tmp76_ = member;
					vala_map_set ((ValaMap*) _tmp73_, _tmp75_, (GIdlNodeFunction*) _tmp76_);
				}
				_tmp77_ = member;
				if (_tmp77_->type == G_IDL_NODE_VFUNC) {
					ValaHashMap* _tmp78_;
					GIdlNode* _tmp79_;
					const gchar* _tmp80_;
					_tmp78_ = current_type_vfunc_map;
					_tmp79_ = member;
					_tmp80_ = _tmp79_->name;
					vala_map_set ((ValaMap*) _tmp78_, _tmp80_, "1");
				}
			}
		}
	}
	_tmp81_ = node->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp81_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp82_;
				_tmp82_ = member;
				if (_tmp82_->type == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp83_;
					GIdlNode* _tmp84_;
					const gchar* _tmp85_;
					_tmp83_ = current_type_vfunc_map;
					_tmp84_ = member;
					_tmp85_ = _tmp84_->name;
					if (!vala_map_contains ((ValaMap*) _tmp83_, _tmp85_)) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp86_;
						ValaMethod* _tmp87_;
						ValaMethod* _tmp88_;
						_tmp86_ = member;
						_tmp87_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp86_, TRUE);
						m = _tmp87_;
						_tmp88_ = m;
						if (_tmp88_ != NULL) {
							ValaInterface* _tmp89_;
							ValaMethod* _tmp90_;
							_tmp89_ = iface;
							_tmp90_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp89_, _tmp90_);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					GIdlNode* _tmp91_;
					_tmp91_ = member;
					if (_tmp91_->type == G_IDL_NODE_VFUNC) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp92_;
						ValaHashMap* _tmp93_;
						GIdlNode* _tmp94_;
						const gchar* _tmp95_;
						gpointer _tmp96_;
						ValaMethod* _tmp97_;
						ValaMethod* _tmp98_;
						_tmp92_ = member;
						_tmp93_ = current_type_func_map;
						_tmp94_ = member;
						_tmp95_ = _tmp94_->name;
						_tmp96_ = vala_map_get ((ValaMap*) _tmp93_, _tmp95_);
						_tmp97_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) _tmp92_, (GIdlNodeFunction*) _tmp96_, TRUE);
						m = _tmp97_;
						_tmp98_ = m;
						if (_tmp98_ != NULL) {
							ValaInterface* _tmp99_;
							ValaMethod* _tmp100_;
							_tmp99_ = iface;
							_tmp100_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp99_, _tmp100_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp101_;
						_tmp101_ = member;
						if (_tmp101_->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop = NULL;
							GIdlNode* _tmp102_;
							ValaProperty* _tmp103_;
							ValaProperty* _tmp104_;
							_tmp102_ = member;
							_tmp103_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) _tmp102_);
							prop = _tmp103_;
							_tmp104_ = prop;
							if (_tmp104_ != NULL) {
								ValaInterface* _tmp105_;
								ValaProperty* _tmp106_;
								_tmp105_ = iface;
								_tmp106_ = prop;
								vala_symbol_add_property ((ValaSymbol*) _tmp105_, _tmp106_);
							}
							_vala_code_node_unref0 (prop);
						} else {
							GIdlNode* _tmp107_;
							_tmp107_ = member;
							if (_tmp107_->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig = NULL;
								GIdlNode* _tmp108_;
								ValaSignal* _tmp109_;
								ValaSignal* _tmp110_;
								_tmp108_ = member;
								_tmp109_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) _tmp108_);
								sig = _tmp109_;
								_tmp110_ = sig;
								if (_tmp110_ != NULL) {
									ValaInterface* _tmp111_;
									ValaSignal* _tmp112_;
									ValaSignal* _tmp113_;
									_tmp111_ = iface;
									_tmp112_ = sig;
									vala_symbol_add_signal ((ValaSymbol*) _tmp111_, _tmp112_);
									_tmp113_ = sig;
									vala_signal_set_is_virtual (_tmp113_, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaInterface* _tmp114_;
		ValaList* _tmp115_;
		gint _prop_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _prop_index = 0;
		_tmp114_ = iface;
		_tmp115_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp114_);
		_prop_list = _tmp115_;
		_tmp116_ = _prop_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_prop_size = _tmp118_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			ValaProperty* prop = NULL;
			ValaList* _tmp121_;
			gpointer _tmp122_;
			gchar* getter = NULL;
			ValaProperty* _tmp123_;
			const gchar* _tmp124_;
			const gchar* _tmp125_;
			gchar* _tmp126_;
			gboolean _tmp127_ = FALSE;
			ValaProperty* _tmp128_;
			ValaPropertyAccessor* _tmp129_;
			ValaPropertyAccessor* _tmp130_;
			gchar* setter = NULL;
			ValaProperty* _tmp134_;
			const gchar* _tmp135_;
			const gchar* _tmp136_;
			gchar* _tmp137_;
			gboolean _tmp138_ = FALSE;
			gboolean _tmp139_ = FALSE;
			ValaProperty* _tmp140_;
			ValaPropertyAccessor* _tmp141_;
			ValaPropertyAccessor* _tmp142_;
			gboolean _tmp151_ = FALSE;
			ValaProperty* _tmp152_;
			ValaAttribute* _tmp153_;
			_prop_index = _prop_index + 1;
			_tmp119_ = _prop_index;
			_tmp120_ = _prop_size;
			if (!(_tmp119_ < _tmp120_)) {
				break;
			}
			_tmp121_ = _prop_list;
			_tmp122_ = vala_list_get (_tmp121_, _prop_index);
			prop = (ValaProperty*) _tmp122_;
			_tmp123_ = prop;
			_tmp124_ = vala_symbol_get_name ((ValaSymbol*) _tmp123_);
			_tmp125_ = _tmp124_;
			_tmp126_ = g_strdup_printf ("get_%s", _tmp125_);
			getter = _tmp126_;
			_tmp128_ = prop;
			_tmp129_ = vala_property_get_get_accessor (_tmp128_);
			_tmp130_ = _tmp129_;
			if (_tmp130_ != NULL) {
				ValaSet* _tmp131_;
				const gchar* _tmp132_;
				_tmp131_ = self->priv->current_type_symbol_set;
				_tmp132_ = getter;
				_tmp127_ = !vala_collection_contains ((ValaCollection*) _tmp131_, _tmp132_);
			} else {
				_tmp127_ = FALSE;
			}
			if (_tmp127_) {
				ValaProperty* _tmp133_;
				_tmp133_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp133_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp134_ = prop;
			_tmp135_ = vala_symbol_get_name ((ValaSymbol*) _tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = g_strdup_printf ("set_%s", _tmp136_);
			setter = _tmp137_;
			_tmp140_ = prop;
			_tmp141_ = vala_property_get_set_accessor (_tmp140_);
			_tmp142_ = _tmp141_;
			if (_tmp142_ != NULL) {
				ValaProperty* _tmp143_;
				ValaPropertyAccessor* _tmp144_;
				ValaPropertyAccessor* _tmp145_;
				gboolean _tmp146_;
				gboolean _tmp147_;
				_tmp143_ = prop;
				_tmp144_ = vala_property_get_set_accessor (_tmp143_);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_property_accessor_get_writable (_tmp145_);
				_tmp147_ = _tmp146_;
				_tmp139_ = _tmp147_;
			} else {
				_tmp139_ = FALSE;
			}
			if (_tmp139_) {
				ValaSet* _tmp148_;
				const gchar* _tmp149_;
				_tmp148_ = self->priv->current_type_symbol_set;
				_tmp149_ = setter;
				_tmp138_ = !vala_collection_contains ((ValaCollection*) _tmp148_, _tmp149_);
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				ValaProperty* _tmp150_;
				_tmp150_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp150_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp152_ = prop;
			_tmp153_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp152_, "NoAccessorMethod");
			if (_tmp153_ != NULL) {
				ValaProperty* _tmp154_;
				ValaPropertyAccessor* _tmp155_;
				ValaPropertyAccessor* _tmp156_;
				_tmp154_ = prop;
				_tmp155_ = vala_property_get_get_accessor (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp151_ = _tmp156_ != NULL;
			} else {
				_tmp151_ = FALSE;
			}
			if (_tmp151_) {
				ValaProperty* _tmp157_;
				ValaPropertyAccessor* _tmp158_;
				ValaPropertyAccessor* _tmp159_;
				ValaDataType* _tmp160_;
				ValaDataType* _tmp161_;
				_tmp157_ = prop;
				_tmp158_ = vala_property_get_get_accessor (_tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_property_accessor_get_value_type (_tmp159_);
				_tmp161_ = _tmp160_;
				vala_data_type_set_value_owned (_tmp161_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
	}
	_tmp162_ = iface;
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) _tmp162_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = NULL;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (iface);
	_g_free0 (name);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_gidl_parser_handle_async_methods (ValaGIdlParser* self,
                                       ValaObjectTypeSymbol* type_symbol)
{
	ValaSet* finish_methods = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaList* methods = NULL;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_hash_set_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_);
	finish_methods = (ValaSet*) _tmp2_;
	_tmp3_ = vala_object_type_symbol_get_methods (type_symbol);
	_tmp4_ = _vala_iterable_ref0 (_tmp3_);
	methods = _tmp4_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp5_;
		gint _m_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _m_index = 0;
		_tmp5_ = methods;
		_m_list = _tmp5_;
		_tmp6_ = _m_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_m_size = _tmp8_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaMethod* m = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaMethod* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_m_index = _m_index + 1;
			_tmp9_ = _m_index;
			_tmp10_ = _m_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _m_list;
			_tmp12_ = vala_list_get (_tmp11_, _m_index);
			m = (ValaMethod*) _tmp12_;
			_tmp13_ = m;
			_tmp14_ = vala_method_get_coroutine (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_) {
				gchar* finish_method_base = NULL;
				ValaMethod* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				ValaMethod* finish_method = NULL;
				ValaScope* _tmp34_;
				ValaScope* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				ValaSymbol* _tmp39_;
				ValaMethod* _tmp40_;
				ValaMethod* _tmp41_;
				ValaMethod* _tmp42_;
				ValaMethod* _tmp60_;
				_tmp16_ = m;
				_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				if (g_str_has_suffix (_tmp18_, "_async")) {
					ValaMethod* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					ValaMethod* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					gchar* _tmp29_;
					_tmp19_ = m;
					_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = m;
					_tmp23_ = vala_symbol_get_name ((ValaSymbol*) _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = strlen (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = strlen ("_async");
					_tmp28_ = _tmp27_;
					_tmp29_ = string_substring (_tmp21_, (glong) 0, (glong) (_tmp26_ - _tmp28_));
					_g_free0 (finish_method_base);
					finish_method_base = _tmp29_;
				} else {
					ValaMethod* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp30_ = m;
					_tmp31_ = vala_symbol_get_name ((ValaSymbol*) _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strdup (_tmp32_);
					_g_free0 (finish_method_base);
					finish_method_base = _tmp33_;
				}
				_tmp34_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
				_tmp35_ = _tmp34_;
				_tmp36_ = finish_method_base;
				_tmp37_ = g_strconcat (_tmp36_, "_finish", NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_scope_lookup (_tmp35_, _tmp38_);
				_tmp40_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp39_) : NULL;
				if (_tmp40_ == NULL) {
					_vala_code_node_unref0 (_tmp39_);
				}
				_tmp41_ = _tmp40_;
				_g_free0 (_tmp38_);
				finish_method = _tmp41_;
				_tmp42_ = finish_method;
				if (_tmp42_ == NULL) {
					gchar* method_cname = NULL;
					ValaMethod* _tmp43_;
					gchar* _tmp44_;
					_tmp43_ = m;
					_tmp44_ = vala_gidl_parser_get_finish_cname (self, _tmp43_);
					method_cname = _tmp44_;
					{
						ValaList* _method_list = NULL;
						ValaList* _tmp45_;
						gint _method_size = 0;
						ValaList* _tmp46_;
						gint _tmp47_;
						gint _tmp48_;
						gint _method_index = 0;
						_tmp45_ = vala_object_type_symbol_get_methods (type_symbol);
						_method_list = _tmp45_;
						_tmp46_ = _method_list;
						_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
						_tmp48_ = _tmp47_;
						_method_size = _tmp48_;
						_method_index = -1;
						while (TRUE) {
							gint _tmp49_;
							gint _tmp50_;
							ValaMethod* method = NULL;
							ValaList* _tmp51_;
							gpointer _tmp52_;
							ValaMethod* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							const gchar* _tmp56_;
							gboolean _tmp57_;
							_method_index = _method_index + 1;
							_tmp49_ = _method_index;
							_tmp50_ = _method_size;
							if (!(_tmp49_ < _tmp50_)) {
								break;
							}
							_tmp51_ = _method_list;
							_tmp52_ = vala_list_get (_tmp51_, _method_index);
							method = (ValaMethod*) _tmp52_;
							_tmp53_ = method;
							_tmp54_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp53_, NULL);
							_tmp55_ = _tmp54_;
							_tmp56_ = method_cname;
							_tmp57_ = g_strcmp0 (_tmp55_, _tmp56_) == 0;
							_g_free0 (_tmp55_);
							if (_tmp57_) {
								ValaMethod* _tmp58_;
								ValaMethod* _tmp59_;
								_tmp58_ = method;
								_tmp59_ = _vala_code_node_ref0 (_tmp58_);
								_vala_code_node_unref0 (finish_method);
								finish_method = _tmp59_;
								_vala_code_node_unref0 (method);
								break;
							}
							_vala_code_node_unref0 (method);
						}
					}
					_g_free0 (method_cname);
				}
				_tmp60_ = finish_method;
				if (_tmp60_ != NULL) {
					ValaMethod* _tmp61_;
					ValaMethod* _tmp62_;
					ValaDataType* _tmp63_;
					ValaDataType* _tmp64_;
					ValaDataType* _tmp65_;
					ValaDataType* _tmp66_;
					ValaAttribute* a = NULL;
					ValaMethod* _tmp67_;
					ValaAttribute* _tmp68_;
					ValaAttribute* _tmp69_;
					gboolean _tmp70_ = FALSE;
					ValaAttribute* _tmp71_;
					gboolean _tmp75_ = FALSE;
					ValaAttribute* _tmp76_;
					ValaArrayList* error_types = NULL;
					GEqualFunc _tmp111_;
					ValaArrayList* _tmp112_;
					ValaMethod* _tmp113_;
					ValaArrayList* _tmp114_;
					ValaMethod* _tmp115_;
					ValaSourceReference* _tmp116_;
					ValaSourceReference* _tmp117_;
					ValaSet* _tmp128_;
					ValaMethod* _tmp129_;
					_tmp61_ = m;
					_tmp62_ = finish_method;
					_tmp63_ = vala_callable_get_return_type ((ValaCallable*) _tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = vala_data_type_copy (_tmp64_);
					_tmp66_ = _tmp65_;
					vala_callable_set_return_type ((ValaCallable*) _tmp61_, _tmp66_);
					_vala_code_node_unref0 (_tmp66_);
					_tmp67_ = finish_method;
					_tmp68_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp67_, "CCode");
					_tmp69_ = _vala_code_node_ref0 (_tmp68_);
					a = _tmp69_;
					_tmp71_ = a;
					if (_tmp71_ != NULL) {
						ValaAttribute* _tmp72_;
						_tmp72_ = a;
						_tmp70_ = vala_attribute_has_argument (_tmp72_, "array_length");
					} else {
						_tmp70_ = FALSE;
					}
					if (_tmp70_) {
						ValaMethod* _tmp73_;
						ValaAttribute* _tmp74_;
						_tmp73_ = m;
						_tmp74_ = a;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp73_, "CCode", "array_length", vala_attribute_get_bool (_tmp74_, "array_length", FALSE), NULL);
					}
					_tmp76_ = a;
					if (_tmp76_ != NULL) {
						ValaAttribute* _tmp77_;
						_tmp77_ = a;
						_tmp75_ = vala_attribute_has_argument (_tmp77_, "array_null_terminated");
					} else {
						_tmp75_ = FALSE;
					}
					if (_tmp75_) {
						ValaMethod* _tmp78_;
						ValaAttribute* _tmp79_;
						_tmp78_ = m;
						_tmp79_ = a;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp78_, "CCode", "array_null_terminated", vala_attribute_get_bool (_tmp79_, "array_null_terminated", FALSE), NULL);
					}
					{
						ValaList* _param_list = NULL;
						ValaMethod* _tmp80_;
						ValaList* _tmp81_;
						gint _param_size = 0;
						ValaList* _tmp82_;
						gint _tmp83_;
						gint _tmp84_;
						gint _param_index = 0;
						_tmp80_ = finish_method;
						_tmp81_ = vala_callable_get_parameters ((ValaCallable*) _tmp80_);
						_param_list = _tmp81_;
						_tmp82_ = _param_list;
						_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
						_tmp84_ = _tmp83_;
						_param_size = _tmp84_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp85_;
							gint _tmp86_;
							ValaParameter* param = NULL;
							ValaList* _tmp87_;
							gpointer _tmp88_;
							ValaParameter* _tmp89_;
							ValaParameterDirection _tmp90_;
							ValaParameterDirection _tmp91_;
							_param_index = _param_index + 1;
							_tmp85_ = _param_index;
							_tmp86_ = _param_size;
							if (!(_tmp85_ < _tmp86_)) {
								break;
							}
							_tmp87_ = _param_list;
							_tmp88_ = vala_list_get (_tmp87_, _param_index);
							param = (ValaParameter*) _tmp88_;
							_tmp89_ = param;
							_tmp90_ = vala_parameter_get_direction (_tmp89_);
							_tmp91_ = _tmp90_;
							if (_tmp91_ == VALA_PARAMETER_DIRECTION_OUT) {
								ValaParameter* async_param = NULL;
								ValaParameter* _tmp92_;
								ValaParameter* _tmp93_;
								ValaMethod* _tmp94_;
								ValaScope* _tmp95_;
								ValaScope* _tmp96_;
								ValaParameter* _tmp97_;
								const gchar* _tmp98_;
								const gchar* _tmp99_;
								ValaSymbol* _tmp100_;
								ValaSymbol* _tmp101_;
								gboolean _tmp102_;
								ValaMethod* _tmp109_;
								ValaParameter* _tmp110_;
								_tmp92_ = param;
								_tmp93_ = vala_parameter_copy (_tmp92_);
								async_param = _tmp93_;
								_tmp94_ = m;
								_tmp95_ = vala_symbol_get_scope ((ValaSymbol*) _tmp94_);
								_tmp96_ = _tmp95_;
								_tmp97_ = param;
								_tmp98_ = vala_symbol_get_name ((ValaSymbol*) _tmp97_);
								_tmp99_ = _tmp98_;
								_tmp100_ = vala_scope_lookup (_tmp96_, _tmp99_);
								_tmp101_ = _tmp100_;
								_tmp102_ = _tmp101_ != NULL;
								_vala_code_node_unref0 (_tmp101_);
								if (_tmp102_) {
									ValaParameter* _tmp103_;
									ValaParameter* _tmp104_;
									const gchar* _tmp105_;
									const gchar* _tmp106_;
									gchar* _tmp107_;
									gchar* _tmp108_;
									_tmp103_ = async_param;
									_tmp104_ = async_param;
									_tmp105_ = vala_symbol_get_name ((ValaSymbol*) _tmp104_);
									_tmp106_ = _tmp105_;
									_tmp107_ = g_strconcat (_tmp106_, "_out", NULL);
									_tmp108_ = _tmp107_;
									vala_symbol_set_name ((ValaSymbol*) _tmp104_, _tmp108_);
									_g_free0 (_tmp108_);
								}
								_tmp109_ = m;
								_tmp110_ = async_param;
								vala_callable_add_parameter ((ValaCallable*) _tmp109_, _tmp110_);
								_vala_code_node_unref0 (async_param);
							}
							_vala_code_node_unref0 (param);
						}
					}
					_tmp111_ = g_direct_equal;
					_tmp112_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp111_);
					error_types = _tmp112_;
					_tmp113_ = finish_method;
					_tmp114_ = error_types;
					_tmp115_ = m;
					_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp115_);
					_tmp117_ = _tmp116_;
					vala_code_node_get_error_types ((ValaCodeNode*) _tmp113_, (ValaCollection*) _tmp114_, _tmp117_);
					{
						ValaArrayList* _error_type_list = NULL;
						ValaArrayList* _tmp118_;
						gint _error_type_size = 0;
						ValaArrayList* _tmp119_;
						gint _tmp120_;
						gint _tmp121_;
						gint _error_type_index = 0;
						_tmp118_ = error_types;
						_error_type_list = _tmp118_;
						_tmp119_ = _error_type_list;
						_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
						_tmp121_ = _tmp120_;
						_error_type_size = _tmp121_;
						_error_type_index = -1;
						while (TRUE) {
							gint _tmp122_;
							gint _tmp123_;
							ValaDataType* error_type = NULL;
							ValaArrayList* _tmp124_;
							gpointer _tmp125_;
							ValaMethod* _tmp126_;
							ValaDataType* _tmp127_;
							_error_type_index = _error_type_index + 1;
							_tmp122_ = _error_type_index;
							_tmp123_ = _error_type_size;
							if (!(_tmp122_ < _tmp123_)) {
								break;
							}
							_tmp124_ = _error_type_list;
							_tmp125_ = vala_list_get ((ValaList*) _tmp124_, _error_type_index);
							error_type = (ValaDataType*) _tmp125_;
							_tmp126_ = m;
							_tmp127_ = error_type;
							vala_method_add_error_type (_tmp126_, _tmp127_);
							_vala_code_node_unref0 (error_type);
						}
					}
					_tmp128_ = finish_methods;
					_tmp129_ = finish_method;
					vala_collection_add ((ValaCollection*) _tmp128_, _tmp129_);
					_vala_iterable_unref0 (error_types);
					_vala_code_node_unref0 (a);
				}
				_vala_code_node_unref0 (finish_method);
				_g_free0 (finish_method_base);
			}
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaIterator* _m_it = NULL;
		ValaSet* _tmp130_;
		ValaIterator* _tmp131_;
		_tmp130_ = finish_methods;
		_tmp131_ = vala_iterable_iterator ((ValaIterable*) _tmp130_);
		_m_it = _tmp131_;
		while (TRUE) {
			ValaIterator* _tmp132_;
			ValaMethod* m = NULL;
			ValaIterator* _tmp133_;
			gpointer _tmp134_;
			ValaScope* _tmp135_;
			ValaScope* _tmp136_;
			ValaMethod* _tmp137_;
			const gchar* _tmp138_;
			const gchar* _tmp139_;
			ValaList* _tmp140_;
			ValaMethod* _tmp141_;
			_tmp132_ = _m_it;
			if (!vala_iterator_next (_tmp132_)) {
				break;
			}
			_tmp133_ = _m_it;
			_tmp134_ = vala_iterator_get (_tmp133_);
			m = (ValaMethod*) _tmp134_;
			_tmp135_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
			_tmp136_ = _tmp135_;
			_tmp137_ = m;
			_tmp138_ = vala_symbol_get_name ((ValaSymbol*) _tmp137_);
			_tmp139_ = _tmp138_;
			vala_scope_remove (_tmp136_, _tmp139_);
			_tmp140_ = methods;
			_tmp141_ = m;
			vala_collection_remove ((ValaCollection*) _tmp140_, _tmp141_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterator_unref0 (_m_it);
	}
	_vala_iterable_unref0 (methods);
	_vala_iterable_unref0 (finish_methods);
}

static ValaDataType*
vala_gidl_parser_parse_type (ValaGIdlParser* self,
                             GIdlNodeType* type_node,
                             ValaParameterDirection* direction)
{
	ValaParameterDirection _vala_direction = 0;
	ValaUnresolvedType* type = NULL;
	ValaUnresolvedType* _tmp0_;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	_vala_direction = VALA_PARAMETER_DIRECTION_IN;
	_tmp0_ = vala_unresolved_type_new (NULL);
	type = _tmp0_;
	if (type_node->tag == TYPE_TAG_VOID) {
		if (type_node->is_pointer) {
			ValaVoidType* _tmp1_;
			ValaVoidType* _tmp2_;
			ValaPointerType* _tmp3_;
			ValaDataType* _tmp4_;
			_tmp1_ = vala_void_type_new (NULL);
			_tmp2_ = _tmp1_;
			_tmp3_ = vala_pointer_type_new ((ValaDataType*) _tmp2_, NULL);
			_tmp4_ = (ValaDataType*) _tmp3_;
			_vala_code_node_unref0 (_tmp2_);
			result = _tmp4_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _vala_direction;
			}
			return result;
		} else {
			ValaVoidType* _tmp5_;
			_tmp5_ = vala_void_type_new (NULL);
			result = (ValaDataType*) _tmp5_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _vala_direction;
			}
			return result;
		}
	} else {
		if (type_node->tag == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedType* _tmp6_;
			ValaUnresolvedSymbol* _tmp7_;
			ValaUnresolvedSymbol* _tmp8_;
			_tmp6_ = type;
			_tmp7_ = vala_unresolved_symbol_new (NULL, "bool", NULL);
			_tmp8_ = _tmp7_;
			vala_unresolved_type_set_unresolved_symbol (_tmp6_, _tmp8_);
			_vala_code_node_unref0 (_tmp8_);
		} else {
			if (type_node->tag == TYPE_TAG_INT8) {
				ValaUnresolvedType* _tmp9_;
				ValaUnresolvedSymbol* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				_tmp9_ = type;
				_tmp10_ = vala_unresolved_symbol_new (NULL, "char", NULL);
				_tmp11_ = _tmp10_;
				vala_unresolved_type_set_unresolved_symbol (_tmp9_, _tmp11_);
				_vala_code_node_unref0 (_tmp11_);
			} else {
				if (type_node->tag == TYPE_TAG_UINT8) {
					ValaUnresolvedType* _tmp12_;
					ValaUnresolvedSymbol* _tmp13_;
					ValaUnresolvedSymbol* _tmp14_;
					_tmp12_ = type;
					_tmp13_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
					_tmp14_ = _tmp13_;
					vala_unresolved_type_set_unresolved_symbol (_tmp12_, _tmp14_);
					_vala_code_node_unref0 (_tmp14_);
				} else {
					if (type_node->tag == TYPE_TAG_INT16) {
						ValaUnresolvedType* _tmp15_;
						ValaUnresolvedSymbol* _tmp16_;
						ValaUnresolvedSymbol* _tmp17_;
						_tmp15_ = type;
						_tmp16_ = vala_unresolved_symbol_new (NULL, "int16", NULL);
						_tmp17_ = _tmp16_;
						vala_unresolved_type_set_unresolved_symbol (_tmp15_, _tmp17_);
						_vala_code_node_unref0 (_tmp17_);
					} else {
						if (type_node->tag == TYPE_TAG_UINT16) {
							ValaUnresolvedType* _tmp18_;
							ValaUnresolvedSymbol* _tmp19_;
							ValaUnresolvedSymbol* _tmp20_;
							_tmp18_ = type;
							_tmp19_ = vala_unresolved_symbol_new (NULL, "uint16", NULL);
							_tmp20_ = _tmp19_;
							vala_unresolved_type_set_unresolved_symbol (_tmp18_, _tmp20_);
							_vala_code_node_unref0 (_tmp20_);
						} else {
							if (type_node->tag == TYPE_TAG_INT32) {
								ValaUnresolvedType* _tmp21_;
								ValaUnresolvedSymbol* _tmp22_;
								ValaUnresolvedSymbol* _tmp23_;
								_tmp21_ = type;
								_tmp22_ = vala_unresolved_symbol_new (NULL, "int32", NULL);
								_tmp23_ = _tmp22_;
								vala_unresolved_type_set_unresolved_symbol (_tmp21_, _tmp23_);
								_vala_code_node_unref0 (_tmp23_);
							} else {
								if (type_node->tag == TYPE_TAG_UINT32) {
									ValaUnresolvedType* _tmp24_;
									ValaUnresolvedSymbol* _tmp25_;
									ValaUnresolvedSymbol* _tmp26_;
									_tmp24_ = type;
									_tmp25_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
									_tmp26_ = _tmp25_;
									vala_unresolved_type_set_unresolved_symbol (_tmp24_, _tmp26_);
									_vala_code_node_unref0 (_tmp26_);
								} else {
									if (type_node->tag == TYPE_TAG_INT64) {
										ValaUnresolvedType* _tmp27_;
										ValaUnresolvedSymbol* _tmp28_;
										ValaUnresolvedSymbol* _tmp29_;
										_tmp27_ = type;
										_tmp28_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
										_tmp29_ = _tmp28_;
										vala_unresolved_type_set_unresolved_symbol (_tmp27_, _tmp29_);
										_vala_code_node_unref0 (_tmp29_);
									} else {
										if (type_node->tag == TYPE_TAG_UINT64) {
											ValaUnresolvedType* _tmp30_;
											ValaUnresolvedSymbol* _tmp31_;
											ValaUnresolvedSymbol* _tmp32_;
											_tmp30_ = type;
											_tmp31_ = vala_unresolved_symbol_new (NULL, "uint64", NULL);
											_tmp32_ = _tmp31_;
											vala_unresolved_type_set_unresolved_symbol (_tmp30_, _tmp32_);
											_vala_code_node_unref0 (_tmp32_);
										} else {
											if (type_node->tag == TYPE_TAG_INT) {
												ValaUnresolvedType* _tmp33_;
												ValaUnresolvedSymbol* _tmp34_;
												ValaUnresolvedSymbol* _tmp35_;
												_tmp33_ = type;
												_tmp34_ = vala_unresolved_symbol_new (NULL, "int", NULL);
												_tmp35_ = _tmp34_;
												vala_unresolved_type_set_unresolved_symbol (_tmp33_, _tmp35_);
												_vala_code_node_unref0 (_tmp35_);
											} else {
												if (type_node->tag == TYPE_TAG_UINT) {
													ValaUnresolvedType* _tmp36_;
													ValaUnresolvedSymbol* _tmp37_;
													ValaUnresolvedSymbol* _tmp38_;
													_tmp36_ = type;
													_tmp37_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
													_tmp38_ = _tmp37_;
													vala_unresolved_type_set_unresolved_symbol (_tmp36_, _tmp38_);
													_vala_code_node_unref0 (_tmp38_);
												} else {
													if (type_node->tag == TYPE_TAG_LONG) {
														ValaUnresolvedType* _tmp39_;
														ValaUnresolvedSymbol* _tmp40_;
														ValaUnresolvedSymbol* _tmp41_;
														_tmp39_ = type;
														_tmp40_ = vala_unresolved_symbol_new (NULL, "long", NULL);
														_tmp41_ = _tmp40_;
														vala_unresolved_type_set_unresolved_symbol (_tmp39_, _tmp41_);
														_vala_code_node_unref0 (_tmp41_);
													} else {
														if (type_node->tag == TYPE_TAG_ULONG) {
															ValaUnresolvedType* _tmp42_;
															ValaUnresolvedSymbol* _tmp43_;
															ValaUnresolvedSymbol* _tmp44_;
															_tmp42_ = type;
															_tmp43_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
															_tmp44_ = _tmp43_;
															vala_unresolved_type_set_unresolved_symbol (_tmp42_, _tmp44_);
															_vala_code_node_unref0 (_tmp44_);
														} else {
															if (type_node->tag == TYPE_TAG_SSIZE) {
																ValaUnresolvedType* _tmp45_;
																ValaUnresolvedSymbol* _tmp46_;
																ValaUnresolvedSymbol* _tmp47_;
																_tmp45_ = type;
																_tmp46_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL);
																_tmp47_ = _tmp46_;
																vala_unresolved_type_set_unresolved_symbol (_tmp45_, _tmp47_);
																_vala_code_node_unref0 (_tmp47_);
															} else {
																if (type_node->tag == TYPE_TAG_SIZE) {
																	ValaUnresolvedType* _tmp48_;
																	ValaUnresolvedSymbol* _tmp49_;
																	ValaUnresolvedSymbol* _tmp50_;
																	_tmp48_ = type;
																	_tmp49_ = vala_unresolved_symbol_new (NULL, "size_t", NULL);
																	_tmp50_ = _tmp49_;
																	vala_unresolved_type_set_unresolved_symbol (_tmp48_, _tmp50_);
																	_vala_code_node_unref0 (_tmp50_);
																} else {
																	if (type_node->tag == TYPE_TAG_FLOAT) {
																		ValaUnresolvedType* _tmp51_;
																		ValaUnresolvedSymbol* _tmp52_;
																		ValaUnresolvedSymbol* _tmp53_;
																		_tmp51_ = type;
																		_tmp52_ = vala_unresolved_symbol_new (NULL, "float", NULL);
																		_tmp53_ = _tmp52_;
																		vala_unresolved_type_set_unresolved_symbol (_tmp51_, _tmp53_);
																		_vala_code_node_unref0 (_tmp53_);
																	} else {
																		if (type_node->tag == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedType* _tmp54_;
																			ValaUnresolvedSymbol* _tmp55_;
																			ValaUnresolvedSymbol* _tmp56_;
																			_tmp54_ = type;
																			_tmp55_ = vala_unresolved_symbol_new (NULL, "double", NULL);
																			_tmp56_ = _tmp55_;
																			vala_unresolved_type_set_unresolved_symbol (_tmp54_, _tmp56_);
																			_vala_code_node_unref0 (_tmp56_);
																		} else {
																			if (type_node->tag == TYPE_TAG_UTF8) {
																				ValaUnresolvedType* _tmp57_;
																				ValaUnresolvedSymbol* _tmp58_;
																				ValaUnresolvedSymbol* _tmp59_;
																				_tmp57_ = type;
																				_tmp58_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																				_tmp59_ = _tmp58_;
																				vala_unresolved_type_set_unresolved_symbol (_tmp57_, _tmp59_);
																				_vala_code_node_unref0 (_tmp59_);
																			} else {
																				if (type_node->tag == TYPE_TAG_FILENAME) {
																					ValaUnresolvedType* _tmp60_;
																					ValaUnresolvedSymbol* _tmp61_;
																					ValaUnresolvedSymbol* _tmp62_;
																					_tmp60_ = type;
																					_tmp61_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																					_tmp62_ = _tmp61_;
																					vala_unresolved_type_set_unresolved_symbol (_tmp60_, _tmp62_);
																					_vala_code_node_unref0 (_tmp62_);
																				} else {
																					if (type_node->tag == TYPE_TAG_ARRAY) {
																						ValaDataType* element_type = NULL;
																						GIdlNodeType* _tmp63_;
																						ValaDataType* _tmp64_;
																						ValaDataType* _tmp65_;
																						ValaUnresolvedType* _tmp66_;
																						ValaUnresolvedType* _tmp67_;
																						ValaDataType* _tmp68_;
																						ValaDataType* _tmp69_;
																						ValaDataType* _tmp70_;
																						ValaSourceReference* _tmp71_;
																						ValaSourceReference* _tmp72_;
																						ValaArrayType* _tmp73_;
																						_tmp63_ = type_node->parameter_type1;
																						_tmp64_ = vala_gidl_parser_parse_type (self, _tmp63_, NULL);
																						element_type = _tmp64_;
																						_tmp65_ = element_type;
																						_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp65_) : NULL);
																						_vala_code_node_unref0 (type);
																						type = _tmp66_;
																						_tmp67_ = type;
																						if (_tmp67_ == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							if (direction) {
																								*direction = _vala_direction;
																							}
																							return result;
																						}
																						_tmp68_ = element_type;
																						vala_data_type_set_value_owned (_tmp68_, TRUE);
																						_tmp69_ = element_type;
																						_tmp70_ = element_type;
																						_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
																						_tmp72_ = _tmp71_;
																						_tmp73_ = vala_array_type_new (_tmp69_, 1, _tmp72_);
																						result = (ValaDataType*) _tmp73_;
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						if (direction) {
																							*direction = _vala_direction;
																						}
																						return result;
																					} else {
																						if (type_node->tag == TYPE_TAG_LIST) {
																							ValaUnresolvedType* _tmp74_;
																							ValaUnresolvedSymbol* _tmp75_;
																							ValaUnresolvedSymbol* _tmp76_;
																							ValaUnresolvedSymbol* _tmp77_;
																							ValaUnresolvedSymbol* _tmp78_;
																							_tmp74_ = type;
																							_tmp75_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																							_tmp76_ = _tmp75_;
																							_tmp77_ = vala_unresolved_symbol_new (_tmp76_, "List", NULL);
																							_tmp78_ = _tmp77_;
																							vala_unresolved_type_set_unresolved_symbol (_tmp74_, _tmp78_);
																							_vala_code_node_unref0 (_tmp78_);
																							_vala_code_node_unref0 (_tmp76_);
																						} else {
																							if (type_node->tag == TYPE_TAG_SLIST) {
																								ValaUnresolvedType* _tmp79_;
																								ValaUnresolvedSymbol* _tmp80_;
																								ValaUnresolvedSymbol* _tmp81_;
																								ValaUnresolvedSymbol* _tmp82_;
																								ValaUnresolvedSymbol* _tmp83_;
																								_tmp79_ = type;
																								_tmp80_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																								_tmp81_ = _tmp80_;
																								_tmp82_ = vala_unresolved_symbol_new (_tmp81_, "SList", NULL);
																								_tmp83_ = _tmp82_;
																								vala_unresolved_type_set_unresolved_symbol (_tmp79_, _tmp83_);
																								_vala_code_node_unref0 (_tmp83_);
																								_vala_code_node_unref0 (_tmp81_);
																							} else {
																								if (type_node->tag == TYPE_TAG_HASH) {
																									ValaUnresolvedType* _tmp84_;
																									ValaUnresolvedSymbol* _tmp85_;
																									ValaUnresolvedSymbol* _tmp86_;
																									ValaUnresolvedSymbol* _tmp87_;
																									ValaUnresolvedSymbol* _tmp88_;
																									_tmp84_ = type;
																									_tmp85_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																									_tmp86_ = _tmp85_;
																									_tmp87_ = vala_unresolved_symbol_new (_tmp86_, "HashTable", NULL);
																									_tmp88_ = _tmp87_;
																									vala_unresolved_type_set_unresolved_symbol (_tmp84_, _tmp88_);
																									_vala_code_node_unref0 (_tmp88_);
																									_vala_code_node_unref0 (_tmp86_);
																								} else {
																									if (type_node->tag == TYPE_TAG_ERROR) {
																										ValaUnresolvedType* _tmp89_;
																										ValaUnresolvedSymbol* _tmp90_;
																										ValaUnresolvedSymbol* _tmp91_;
																										ValaUnresolvedSymbol* _tmp92_;
																										ValaUnresolvedSymbol* _tmp93_;
																										_tmp89_ = type;
																										_tmp90_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																										_tmp91_ = _tmp90_;
																										_tmp92_ = vala_unresolved_symbol_new (_tmp91_, "Error", NULL);
																										_tmp93_ = _tmp92_;
																										vala_unresolved_type_set_unresolved_symbol (_tmp89_, _tmp93_);
																										_vala_code_node_unref0 (_tmp93_);
																										_vala_code_node_unref0 (_tmp91_);
																									} else {
																										gboolean _tmp94_ = FALSE;
																										gboolean _tmp95_ = FALSE;
																										const gchar* _tmp96_;
																										_tmp96_ = type_node->unparsed;
																										if (g_str_has_prefix (_tmp96_, "cairo_device_t")) {
																											_tmp95_ = TRUE;
																										} else {
																											const gchar* _tmp97_;
																											_tmp97_ = type_node->unparsed;
																											_tmp95_ = g_str_has_prefix (_tmp97_, "cairo_pattern_t");
																										}
																										if (_tmp95_) {
																											_tmp94_ = TRUE;
																										} else {
																											const gchar* _tmp98_;
																											_tmp98_ = type_node->unparsed;
																											_tmp94_ = g_str_has_prefix (_tmp98_, "cairo_surface_t");
																										}
																										if (_tmp94_) {
																											const gchar* _tmp99_;
																											const gchar* _tmp117_;
																											_tmp99_ = type_node->unparsed;
																											if (g_str_has_prefix (_tmp99_, "cairo_device_t")) {
																												ValaUnresolvedType* _tmp100_;
																												ValaUnresolvedSymbol* _tmp101_;
																												ValaUnresolvedSymbol* _tmp102_;
																												ValaUnresolvedSymbol* _tmp103_;
																												ValaUnresolvedSymbol* _tmp104_;
																												_tmp100_ = type;
																												_tmp101_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																												_tmp102_ = _tmp101_;
																												_tmp103_ = vala_unresolved_symbol_new (_tmp102_, "Device", NULL);
																												_tmp104_ = _tmp103_;
																												vala_unresolved_type_set_unresolved_symbol (_tmp100_, _tmp104_);
																												_vala_code_node_unref0 (_tmp104_);
																												_vala_code_node_unref0 (_tmp102_);
																											} else {
																												const gchar* _tmp105_;
																												_tmp105_ = type_node->unparsed;
																												if (g_str_has_prefix (_tmp105_, "cairo_pattern_t")) {
																													ValaUnresolvedType* _tmp106_;
																													ValaUnresolvedSymbol* _tmp107_;
																													ValaUnresolvedSymbol* _tmp108_;
																													ValaUnresolvedSymbol* _tmp109_;
																													ValaUnresolvedSymbol* _tmp110_;
																													_tmp106_ = type;
																													_tmp107_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																													_tmp108_ = _tmp107_;
																													_tmp109_ = vala_unresolved_symbol_new (_tmp108_, "Pattern", NULL);
																													_tmp110_ = _tmp109_;
																													vala_unresolved_type_set_unresolved_symbol (_tmp106_, _tmp110_);
																													_vala_code_node_unref0 (_tmp110_);
																													_vala_code_node_unref0 (_tmp108_);
																												} else {
																													const gchar* _tmp111_;
																													_tmp111_ = type_node->unparsed;
																													if (g_str_has_prefix (_tmp111_, "cairo_surface_t")) {
																														ValaUnresolvedType* _tmp112_;
																														ValaUnresolvedSymbol* _tmp113_;
																														ValaUnresolvedSymbol* _tmp114_;
																														ValaUnresolvedSymbol* _tmp115_;
																														ValaUnresolvedSymbol* _tmp116_;
																														_tmp112_ = type;
																														_tmp113_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																														_tmp114_ = _tmp113_;
																														_tmp115_ = vala_unresolved_symbol_new (_tmp114_, "Surface", NULL);
																														_tmp116_ = _tmp115_;
																														vala_unresolved_type_set_unresolved_symbol (_tmp112_, _tmp116_);
																														_vala_code_node_unref0 (_tmp116_);
																														_vala_code_node_unref0 (_tmp114_);
																													}
																												}
																											}
																											_tmp117_ = type_node->unparsed;
																											if (g_str_has_suffix (_tmp117_, "**")) {
																												_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																											}
																										} else {
																											if (type_node->is_interface) {
																												gchar* n = NULL;
																												const gchar* _tmp118_;
																												gchar* _tmp119_;
																												const gchar* _tmp120_;
																												const gchar* _tmp121_;
																												gboolean _tmp126_ = FALSE;
																												_tmp118_ = type_node->interface;
																												_tmp119_ = g_strdup (_tmp118_);
																												n = _tmp119_;
																												_tmp120_ = n;
																												if (g_strcmp0 (_tmp120_, "") == 0) {
																													result = NULL;
																													_g_free0 (n);
																													_vala_code_node_unref0 (type);
																													if (direction) {
																														*direction = _vala_direction;
																													}
																													return result;
																												}
																												_tmp121_ = n;
																												if (g_str_has_prefix (_tmp121_, "const-")) {
																													const gchar* _tmp122_;
																													gint _tmp123_;
																													gint _tmp124_;
																													gchar* _tmp125_;
																													_tmp122_ = n;
																													_tmp123_ = strlen ("const-");
																													_tmp124_ = _tmp123_;
																													_tmp125_ = string_substring (_tmp122_, (glong) _tmp124_, (glong) -1);
																													_g_free0 (n);
																													n = _tmp125_;
																												}
																												if (type_node->is_pointer) {
																													gboolean _tmp127_ = FALSE;
																													const gchar* _tmp128_;
																													_tmp128_ = n;
																													if (g_strcmp0 (_tmp128_, "gchar") == 0) {
																														_tmp127_ = TRUE;
																													} else {
																														const gchar* _tmp129_;
																														_tmp129_ = n;
																														_tmp127_ = g_strcmp0 (_tmp129_, "char") == 0;
																													}
																													_tmp126_ = _tmp127_;
																												} else {
																													_tmp126_ = FALSE;
																												}
																												if (_tmp126_) {
																													ValaUnresolvedType* _tmp130_;
																													ValaUnresolvedSymbol* _tmp131_;
																													ValaUnresolvedSymbol* _tmp132_;
																													const gchar* _tmp133_;
																													_tmp130_ = type;
																													_tmp131_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																													_tmp132_ = _tmp131_;
																													vala_unresolved_type_set_unresolved_symbol (_tmp130_, _tmp132_);
																													_vala_code_node_unref0 (_tmp132_);
																													_tmp133_ = type_node->unparsed;
																													if (g_str_has_suffix (_tmp133_, "**")) {
																														_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																													}
																												} else {
																													const gchar* _tmp134_;
																													_tmp134_ = n;
																													if (g_strcmp0 (_tmp134_, "gunichar") == 0) {
																														ValaUnresolvedType* _tmp135_;
																														ValaUnresolvedSymbol* _tmp136_;
																														ValaUnresolvedSymbol* _tmp137_;
																														_tmp135_ = type;
																														_tmp136_ = vala_unresolved_symbol_new (NULL, "unichar", NULL);
																														_tmp137_ = _tmp136_;
																														vala_unresolved_type_set_unresolved_symbol (_tmp135_, _tmp137_);
																														_vala_code_node_unref0 (_tmp137_);
																													} else {
																														const gchar* _tmp138_;
																														_tmp138_ = n;
																														if (g_strcmp0 (_tmp138_, "gchar") == 0) {
																															ValaUnresolvedType* _tmp139_;
																															ValaUnresolvedSymbol* _tmp140_;
																															ValaUnresolvedSymbol* _tmp141_;
																															_tmp139_ = type;
																															_tmp140_ = vala_unresolved_symbol_new (NULL, "char", NULL);
																															_tmp141_ = _tmp140_;
																															vala_unresolved_type_set_unresolved_symbol (_tmp139_, _tmp141_);
																															_vala_code_node_unref0 (_tmp141_);
																														} else {
																															gboolean _tmp142_ = FALSE;
																															const gchar* _tmp143_;
																															_tmp143_ = n;
																															if (g_strcmp0 (_tmp143_, "guchar") == 0) {
																																_tmp142_ = TRUE;
																															} else {
																																const gchar* _tmp144_;
																																_tmp144_ = n;
																																_tmp142_ = g_strcmp0 (_tmp144_, "guint8") == 0;
																															}
																															if (_tmp142_) {
																																ValaUnresolvedType* _tmp145_;
																																ValaUnresolvedSymbol* _tmp146_;
																																ValaUnresolvedSymbol* _tmp147_;
																																_tmp145_ = type;
																																_tmp146_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
																																_tmp147_ = _tmp146_;
																																vala_unresolved_type_set_unresolved_symbol (_tmp145_, _tmp147_);
																																_vala_code_node_unref0 (_tmp147_);
																																if (type_node->is_pointer) {
																																	ValaUnresolvedType* _tmp148_;
																																	ValaUnresolvedType* _tmp149_;
																																	ValaUnresolvedType* _tmp150_;
																																	ValaSourceReference* _tmp151_;
																																	ValaSourceReference* _tmp152_;
																																	ValaArrayType* _tmp153_;
																																	_tmp148_ = type;
																																	vala_data_type_set_value_owned ((ValaDataType*) _tmp148_, TRUE);
																																	_tmp149_ = type;
																																	_tmp150_ = type;
																																	_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp150_);
																																	_tmp152_ = _tmp151_;
																																	_tmp153_ = vala_array_type_new ((ValaDataType*) _tmp149_, 1, _tmp152_);
																																	result = (ValaDataType*) _tmp153_;
																																	_g_free0 (n);
																																	_vala_code_node_unref0 (type);
																																	if (direction) {
																																		*direction = _vala_direction;
																																	}
																																	return result;
																																}
																															} else {
																																const gchar* _tmp154_;
																																_tmp154_ = n;
																																if (g_strcmp0 (_tmp154_, "gushort") == 0) {
																																	ValaUnresolvedType* _tmp155_;
																																	ValaUnresolvedSymbol* _tmp156_;
																																	ValaUnresolvedSymbol* _tmp157_;
																																	_tmp155_ = type;
																																	_tmp156_ = vala_unresolved_symbol_new (NULL, "ushort", NULL);
																																	_tmp157_ = _tmp156_;
																																	vala_unresolved_type_set_unresolved_symbol (_tmp155_, _tmp157_);
																																	_vala_code_node_unref0 (_tmp157_);
																																} else {
																																	const gchar* _tmp158_;
																																	_tmp158_ = n;
																																	if (g_strcmp0 (_tmp158_, "gshort") == 0) {
																																		ValaUnresolvedType* _tmp159_;
																																		ValaUnresolvedSymbol* _tmp160_;
																																		ValaUnresolvedSymbol* _tmp161_;
																																		_tmp159_ = type;
																																		_tmp160_ = vala_unresolved_symbol_new (NULL, "short", NULL);
																																		_tmp161_ = _tmp160_;
																																		vala_unresolved_type_set_unresolved_symbol (_tmp159_, _tmp161_);
																																		_vala_code_node_unref0 (_tmp161_);
																																	} else {
																																		gboolean _tmp162_ = FALSE;
																																		const gchar* _tmp163_;
																																		_tmp163_ = n;
																																		if (g_strcmp0 (_tmp163_, "gconstpointer") == 0) {
																																			_tmp162_ = TRUE;
																																		} else {
																																			const gchar* _tmp164_;
																																			_tmp164_ = n;
																																			_tmp162_ = g_strcmp0 (_tmp164_, "void") == 0;
																																		}
																																		if (_tmp162_) {
																																			ValaVoidType* _tmp165_;
																																			ValaVoidType* _tmp166_;
																																			ValaPointerType* _tmp167_;
																																			ValaDataType* _tmp168_;
																																			_tmp165_ = vala_void_type_new (NULL);
																																			_tmp166_ = _tmp165_;
																																			_tmp167_ = vala_pointer_type_new ((ValaDataType*) _tmp166_, NULL);
																																			_tmp168_ = (ValaDataType*) _tmp167_;
																																			_vala_code_node_unref0 (_tmp166_);
																																			result = _tmp168_;
																																			_g_free0 (n);
																																			_vala_code_node_unref0 (type);
																																			if (direction) {
																																				*direction = _vala_direction;
																																			}
																																			return result;
																																		} else {
																																			gboolean _tmp169_ = FALSE;
																																			const gchar* _tmp170_;
																																			_tmp170_ = n;
																																			if (g_strcmp0 (_tmp170_, "goffset") == 0) {
																																				_tmp169_ = TRUE;
																																			} else {
																																				const gchar* _tmp171_;
																																				_tmp171_ = n;
																																				_tmp169_ = g_strcmp0 (_tmp171_, "off_t") == 0;
																																			}
																																			if (_tmp169_) {
																																				ValaUnresolvedType* _tmp172_;
																																				ValaUnresolvedSymbol* _tmp173_;
																																				ValaUnresolvedSymbol* _tmp174_;
																																				_tmp172_ = type;
																																				_tmp173_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
																																				_tmp174_ = _tmp173_;
																																				vala_unresolved_type_set_unresolved_symbol (_tmp172_, _tmp174_);
																																				_vala_code_node_unref0 (_tmp174_);
																																			} else {
																																				const gchar* _tmp175_;
																																				_tmp175_ = n;
																																				if (g_strcmp0 (_tmp175_, "value_array") == 0) {
																																					ValaUnresolvedType* _tmp176_;
																																					ValaUnresolvedSymbol* _tmp177_;
																																					ValaUnresolvedSymbol* _tmp178_;
																																					ValaUnresolvedSymbol* _tmp179_;
																																					ValaUnresolvedSymbol* _tmp180_;
																																					_tmp176_ = type;
																																					_tmp177_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																					_tmp178_ = _tmp177_;
																																					_tmp179_ = vala_unresolved_symbol_new (_tmp178_, "ValueArray", NULL);
																																					_tmp180_ = _tmp179_;
																																					vala_unresolved_type_set_unresolved_symbol (_tmp176_, _tmp180_);
																																					_vala_code_node_unref0 (_tmp180_);
																																					_vala_code_node_unref0 (_tmp178_);
																																				} else {
																																					const gchar* _tmp181_;
																																					_tmp181_ = n;
																																					if (g_strcmp0 (_tmp181_, "time_t") == 0) {
																																						ValaUnresolvedType* _tmp182_;
																																						ValaUnresolvedSymbol* _tmp183_;
																																						ValaUnresolvedSymbol* _tmp184_;
																																						_tmp182_ = type;
																																						_tmp183_ = vala_unresolved_symbol_new (NULL, "time_t", NULL);
																																						_tmp184_ = _tmp183_;
																																						vala_unresolved_type_set_unresolved_symbol (_tmp182_, _tmp184_);
																																						_vala_code_node_unref0 (_tmp184_);
																																					} else {
																																						const gchar* _tmp185_;
																																						_tmp185_ = n;
																																						if (g_strcmp0 (_tmp185_, "socklen_t") == 0) {
																																							ValaUnresolvedType* _tmp186_;
																																							ValaUnresolvedSymbol* _tmp187_;
																																							ValaUnresolvedSymbol* _tmp188_;
																																							_tmp186_ = type;
																																							_tmp187_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
																																							_tmp188_ = _tmp187_;
																																							vala_unresolved_type_set_unresolved_symbol (_tmp186_, _tmp188_);
																																							_vala_code_node_unref0 (_tmp188_);
																																						} else {
																																							const gchar* _tmp189_;
																																							_tmp189_ = n;
																																							if (g_strcmp0 (_tmp189_, "mode_t") == 0) {
																																								ValaUnresolvedType* _tmp190_;
																																								ValaUnresolvedSymbol* _tmp191_;
																																								ValaUnresolvedSymbol* _tmp192_;
																																								_tmp190_ = type;
																																								_tmp191_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																								_tmp192_ = _tmp191_;
																																								vala_unresolved_type_set_unresolved_symbol (_tmp190_, _tmp192_);
																																								_vala_code_node_unref0 (_tmp192_);
																																							} else {
																																								gboolean _tmp193_ = FALSE;
																																								const gchar* _tmp194_;
																																								_tmp194_ = n;
																																								if (g_strcmp0 (_tmp194_, "gint") == 0) {
																																									_tmp193_ = TRUE;
																																								} else {
																																									const gchar* _tmp195_;
																																									_tmp195_ = n;
																																									_tmp193_ = g_strcmp0 (_tmp195_, "pid_t") == 0;
																																								}
																																								if (_tmp193_) {
																																									ValaUnresolvedType* _tmp196_;
																																									ValaUnresolvedSymbol* _tmp197_;
																																									ValaUnresolvedSymbol* _tmp198_;
																																									_tmp196_ = type;
																																									_tmp197_ = vala_unresolved_symbol_new (NULL, "int", NULL);
																																									_tmp198_ = _tmp197_;
																																									vala_unresolved_type_set_unresolved_symbol (_tmp196_, _tmp198_);
																																									_vala_code_node_unref0 (_tmp198_);
																																								} else {
																																									gboolean _tmp199_ = FALSE;
																																									const gchar* _tmp200_;
																																									_tmp200_ = n;
																																									if (g_strcmp0 (_tmp200_, "unsigned") == 0) {
																																										_tmp199_ = TRUE;
																																									} else {
																																										const gchar* _tmp201_;
																																										_tmp201_ = n;
																																										_tmp199_ = g_strcmp0 (_tmp201_, "unsigned-int") == 0;
																																									}
																																									if (_tmp199_) {
																																										ValaUnresolvedType* _tmp202_;
																																										ValaUnresolvedSymbol* _tmp203_;
																																										ValaUnresolvedSymbol* _tmp204_;
																																										_tmp202_ = type;
																																										_tmp203_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																										_tmp204_ = _tmp203_;
																																										vala_unresolved_type_set_unresolved_symbol (_tmp202_, _tmp204_);
																																										_vala_code_node_unref0 (_tmp204_);
																																									} else {
																																										const gchar* _tmp205_;
																																										_tmp205_ = n;
																																										if (g_strcmp0 (_tmp205_, "FILE") == 0) {
																																											ValaUnresolvedType* _tmp206_;
																																											ValaUnresolvedSymbol* _tmp207_;
																																											ValaUnresolvedSymbol* _tmp208_;
																																											ValaUnresolvedSymbol* _tmp209_;
																																											ValaUnresolvedSymbol* _tmp210_;
																																											_tmp206_ = type;
																																											_tmp207_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																											_tmp208_ = _tmp207_;
																																											_tmp209_ = vala_unresolved_symbol_new (_tmp208_, "FileStream", NULL);
																																											_tmp210_ = _tmp209_;
																																											vala_unresolved_type_set_unresolved_symbol (_tmp206_, _tmp210_);
																																											_vala_code_node_unref0 (_tmp210_);
																																											_vala_code_node_unref0 (_tmp208_);
																																										} else {
																																											const gchar* _tmp211_;
																																											_tmp211_ = n;
																																											if (g_strcmp0 (_tmp211_, "struct") == 0) {
																																												ValaVoidType* _tmp212_;
																																												ValaVoidType* _tmp213_;
																																												ValaPointerType* _tmp214_;
																																												ValaDataType* _tmp215_;
																																												_tmp212_ = vala_void_type_new (NULL);
																																												_tmp213_ = _tmp212_;
																																												_tmp214_ = vala_pointer_type_new ((ValaDataType*) _tmp213_, NULL);
																																												_tmp215_ = (ValaDataType*) _tmp214_;
																																												_vala_code_node_unref0 (_tmp213_);
																																												result = _tmp215_;
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												if (direction) {
																																													*direction = _vala_direction;
																																												}
																																												return result;
																																											} else {
																																												const gchar* _tmp216_;
																																												_tmp216_ = n;
																																												if (g_strcmp0 (_tmp216_, "iconv_t") == 0) {
																																													ValaVoidType* _tmp217_;
																																													ValaVoidType* _tmp218_;
																																													ValaPointerType* _tmp219_;
																																													ValaDataType* _tmp220_;
																																													_tmp217_ = vala_void_type_new (NULL);
																																													_tmp218_ = _tmp217_;
																																													_tmp219_ = vala_pointer_type_new ((ValaDataType*) _tmp218_, NULL);
																																													_tmp220_ = (ValaDataType*) _tmp219_;
																																													_vala_code_node_unref0 (_tmp218_);
																																													result = _tmp220_;
																																													_g_free0 (n);
																																													_vala_code_node_unref0 (type);
																																													if (direction) {
																																														*direction = _vala_direction;
																																													}
																																													return result;
																																												} else {
																																													const gchar* _tmp221_;
																																													_tmp221_ = n;
																																													if (g_strcmp0 (_tmp221_, "GType") == 0) {
																																														ValaUnresolvedType* _tmp222_;
																																														ValaUnresolvedSymbol* _tmp223_;
																																														ValaUnresolvedSymbol* _tmp224_;
																																														ValaUnresolvedSymbol* _tmp225_;
																																														ValaUnresolvedSymbol* _tmp226_;
																																														_tmp222_ = type;
																																														_tmp223_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																														_tmp224_ = _tmp223_;
																																														_tmp225_ = vala_unresolved_symbol_new (_tmp224_, "Type", NULL);
																																														_tmp226_ = _tmp225_;
																																														vala_unresolved_type_set_unresolved_symbol (_tmp222_, _tmp226_);
																																														_vala_code_node_unref0 (_tmp226_);
																																														_vala_code_node_unref0 (_tmp224_);
																																														if (type_node->is_pointer) {
																																															ValaUnresolvedType* _tmp227_;
																																															ValaUnresolvedType* _tmp228_;
																																															ValaUnresolvedType* _tmp229_;
																																															ValaSourceReference* _tmp230_;
																																															ValaSourceReference* _tmp231_;
																																															ValaArrayType* _tmp232_;
																																															_tmp227_ = type;
																																															vala_data_type_set_value_owned ((ValaDataType*) _tmp227_, TRUE);
																																															_tmp228_ = type;
																																															_tmp229_ = type;
																																															_tmp230_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp229_);
																																															_tmp231_ = _tmp230_;
																																															_tmp232_ = vala_array_type_new ((ValaDataType*) _tmp228_, 1, _tmp231_);
																																															result = (ValaDataType*) _tmp232_;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _vala_direction;
																																															}
																																															return result;
																																														}
																																													} else {
																																														const gchar* _tmp233_;
																																														_tmp233_ = n;
																																														if (g_strcmp0 (_tmp233_, "GStrv") == 0) {
																																															ValaUnresolvedType* _tmp234_;
																																															ValaUnresolvedSymbol* _tmp235_;
																																															ValaUnresolvedSymbol* _tmp236_;
																																															ValaUnresolvedType* _tmp237_;
																																															ValaUnresolvedType* _tmp238_;
																																															ValaUnresolvedType* _tmp239_;
																																															ValaSourceReference* _tmp240_;
																																															ValaSourceReference* _tmp241_;
																																															ValaArrayType* _tmp242_;
																																															_tmp234_ = type;
																																															_tmp235_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																																															_tmp236_ = _tmp235_;
																																															vala_unresolved_type_set_unresolved_symbol (_tmp234_, _tmp236_);
																																															_vala_code_node_unref0 (_tmp236_);
																																															_tmp237_ = type;
																																															vala_data_type_set_value_owned ((ValaDataType*) _tmp237_, TRUE);
																																															_tmp238_ = type;
																																															_tmp239_ = type;
																																															_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp239_);
																																															_tmp241_ = _tmp240_;
																																															_tmp242_ = vala_array_type_new ((ValaDataType*) _tmp238_, 1, _tmp241_);
																																															result = (ValaDataType*) _tmp242_;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _vala_direction;
																																															}
																																															return result;
																																														} else {
																																															ValaDataType* named_type = NULL;
																																															const gchar* _tmp243_;
																																															ValaDataType* _tmp244_;
																																															ValaDataType* _tmp245_;
																																															ValaUnresolvedType* _tmp246_;
																																															ValaUnresolvedType* _tmp247_;
																																															const gchar* _tmp248_;
																																															_tmp243_ = n;
																																															_tmp244_ = vala_gidl_parser_parse_type_string (self, _tmp243_);
																																															named_type = _tmp244_;
																																															_tmp245_ = named_type;
																																															_tmp246_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp245_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp245_) : NULL);
																																															_vala_code_node_unref0 (type);
																																															type = _tmp246_;
																																															_tmp247_ = type;
																																															if (_tmp247_ == NULL) {
																																																result = named_type;
																																																_g_free0 (n);
																																																_vala_code_node_unref0 (type);
																																																if (direction) {
																																																	*direction = _vala_direction;
																																																}
																																																return result;
																																															}
																																															_tmp248_ = n;
																																															if (vala_gidl_parser_is_simple_type (self, _tmp248_)) {
																																																if (type_node->is_pointer) {
																																																	_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																																																}
																																															} else {
																																																const gchar* _tmp249_;
																																																_tmp249_ = type_node->unparsed;
																																																if (g_str_has_suffix (_tmp249_, "**")) {
																																																	_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																																																}
																																															}
																																															_vala_code_node_unref0 (named_type);
																																														}
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																												_g_free0 (n);
																											} else {
																												g_print ("%d\n", (gint) type_node->tag);
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = (ValaDataType*) type;
	if (direction) {
		*direction = _vala_direction;
	}
	return result;
}

static gboolean
vala_gidl_parser_is_simple_type (ValaGIdlParser* self,
                                 const gchar* type_name)
{
	ValaStruct* st = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaStruct* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaStruct* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	_tmp0_ = self->priv->cname_type_map;
	_tmp1_ = vala_map_get (_tmp0_, type_name);
	_tmp2_ = (ValaTypeSymbol*) _tmp1_;
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_vala_code_node_unref0 (_tmp2_);
	}
	st = _tmp3_;
	_tmp5_ = st;
	if (_tmp5_ != NULL) {
		ValaStruct* _tmp6_;
		_tmp6_ = st;
		_tmp4_ = vala_struct_is_simple_type (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}

static ValaDataType*
vala_gidl_parser_parse_type_string (ValaGIdlParser* self,
                                    const gchar* n)
{
	ValaUnresolvedType* type = NULL;
	ValaUnresolvedType* _tmp4_;
	ValaTypeSymbol* dt = NULL;
	ValaMap* _tmp5_;
	gpointer _tmp6_;
	ValaTypeSymbol* _tmp7_;
	gchar** type_attributes = NULL;
	gint _tmp26_ = 0;
	gchar** _tmp27_;
	gint type_attributes_length1;
	gint _type_attributes_size_;
	gchar* ns_name = NULL;
	gchar** _tmp28_;
	gint _tmp28__length1;
	ValaUnresolvedType* _tmp70_;
	ValaUnresolvedSymbol* _tmp71_;
	ValaUnresolvedSymbol* _tmp72_;
	ValaNamespace* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	if (g_strcmp0 (n, "va_list") == 0) {
		ValaVoidType* _tmp0_;
		ValaVoidType* _tmp1_;
		ValaPointerType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp0_ = vala_void_type_new (NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_pointer_type_new ((ValaDataType*) _tmp1_, NULL);
		_tmp3_ = (ValaDataType*) _tmp2_;
		_vala_code_node_unref0 (_tmp1_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = vala_unresolved_type_new (NULL);
	type = _tmp4_;
	_tmp5_ = self->priv->cname_type_map;
	_tmp6_ = vala_map_get (_tmp5_, n);
	dt = (ValaTypeSymbol*) _tmp6_;
	_tmp7_ = dt;
	if (_tmp7_ != NULL) {
		ValaUnresolvedSymbol* parent_symbol = NULL;
		ValaTypeSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		ValaUnresolvedType* _tmp19_;
		ValaUnresolvedSymbol* _tmp20_;
		ValaTypeSymbol* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaUnresolvedSymbol* _tmp25_;
		parent_symbol = NULL;
		_tmp8_ = dt;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaTypeSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			ValaUnresolvedSymbol* _tmp18_;
			_tmp13_ = dt;
			_tmp14_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_symbol_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_unresolved_symbol_new (NULL, _tmp17_, NULL);
			_vala_code_node_unref0 (parent_symbol);
			parent_symbol = _tmp18_;
		}
		_tmp19_ = type;
		_tmp20_ = parent_symbol;
		_tmp21_ = dt;
		_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_unresolved_symbol_new (_tmp20_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		vala_unresolved_type_set_unresolved_symbol (_tmp19_, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp27_ = vala_gidl_parser_get_attributes (self, n, &_tmp26_);
	type_attributes = _tmp27_;
	type_attributes_length1 = _tmp26_;
	_type_attributes_size_ = type_attributes_length1;
	ns_name = NULL;
	_tmp28_ = type_attributes;
	_tmp28__length1 = type_attributes_length1;
	if (NULL != _tmp28_) {
		gchar** _tmp29_;
		gint _tmp29__length1;
		_tmp29_ = type_attributes;
		_tmp29__length1 = type_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp29_;
			attr_collection_length1 = _tmp29__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp30_;
				gchar* attr = NULL;
				_tmp30_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp30_;
				{
					gchar** nv = NULL;
					const gchar* _tmp31_;
					gchar** _tmp32_;
					gchar** _tmp33_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp34_;
					gint _tmp34__length1;
					const gchar* _tmp35_;
					_tmp31_ = attr;
					_tmp33_ = _tmp32_ = g_strsplit (_tmp31_, "=", 2);
					nv = _tmp33_;
					nv_length1 = _vala_array_length (_tmp32_);
					_nv_size_ = nv_length1;
					_tmp34_ = nv;
					_tmp34__length1 = nv_length1;
					_tmp35_ = _tmp34_[0];
					if (g_strcmp0 (_tmp35_, "cprefix") == 0) {
						ValaUnresolvedType* _tmp36_;
						gchar** _tmp37_;
						gint _tmp37__length1;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						ValaUnresolvedSymbol* _tmp45_;
						ValaUnresolvedSymbol* _tmp46_;
						_tmp36_ = type;
						_tmp37_ = nv;
						_tmp37__length1 = nv_length1;
						_tmp38_ = _tmp37_[1];
						_tmp39_ = vala_gidl_parser_eval (self, _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = strlen (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = string_substring (n, (glong) _tmp42_, (glong) -1);
						_tmp44_ = _tmp43_;
						_tmp45_ = vala_unresolved_symbol_new (NULL, _tmp44_, NULL);
						_tmp46_ = _tmp45_;
						vala_unresolved_type_set_unresolved_symbol (_tmp36_, _tmp46_);
						_vala_code_node_unref0 (_tmp46_);
						_g_free0 (_tmp44_);
						_g_free0 (_tmp40_);
					} else {
						gchar** _tmp47_;
						gint _tmp47__length1;
						const gchar* _tmp48_;
						_tmp47_ = nv;
						_tmp47__length1 = nv_length1;
						_tmp48_ = _tmp47_[0];
						if (g_strcmp0 (_tmp48_, "name") == 0) {
							ValaUnresolvedType* _tmp49_;
							gchar** _tmp50_;
							gint _tmp50__length1;
							const gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							ValaUnresolvedSymbol* _tmp54_;
							ValaUnresolvedSymbol* _tmp55_;
							_tmp49_ = type;
							_tmp50_ = nv;
							_tmp50__length1 = nv_length1;
							_tmp51_ = _tmp50_[1];
							_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = vala_unresolved_symbol_new (NULL, _tmp53_, NULL);
							_tmp55_ = _tmp54_;
							vala_unresolved_type_set_unresolved_symbol (_tmp49_, _tmp55_);
							_vala_code_node_unref0 (_tmp55_);
							_g_free0 (_tmp53_);
						} else {
							gchar** _tmp56_;
							gint _tmp56__length1;
							const gchar* _tmp57_;
							_tmp56_ = nv;
							_tmp56__length1 = nv_length1;
							_tmp57_ = _tmp56_[0];
							if (g_strcmp0 (_tmp57_, "namespace") == 0) {
								gchar** _tmp58_;
								gint _tmp58__length1;
								const gchar* _tmp59_;
								gchar* _tmp60_;
								_tmp58_ = nv;
								_tmp58__length1 = nv_length1;
								_tmp59_ = _tmp58_[1];
								_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
								_g_free0 (ns_name);
								ns_name = _tmp60_;
							} else {
								gchar** _tmp61_;
								gint _tmp61__length1;
								const gchar* _tmp62_;
								_tmp61_ = nv;
								_tmp61__length1 = nv_length1;
								_tmp62_ = _tmp61_[0];
								if (g_strcmp0 (_tmp62_, "rename_to") == 0) {
									ValaUnresolvedType* _tmp63_;
									gchar** _tmp64_;
									gint _tmp64__length1;
									const gchar* _tmp65_;
									gchar* _tmp66_;
									gchar* _tmp67_;
									ValaUnresolvedSymbol* _tmp68_;
									ValaUnresolvedSymbol* _tmp69_;
									_tmp63_ = type;
									_tmp64_ = nv;
									_tmp64__length1 = nv_length1;
									_tmp65_ = _tmp64_[1];
									_tmp66_ = vala_gidl_parser_eval (self, _tmp65_);
									_tmp67_ = _tmp66_;
									_tmp68_ = vala_unresolved_symbol_new (NULL, _tmp67_, NULL);
									_tmp69_ = _tmp68_;
									vala_unresolved_type_set_unresolved_symbol (_tmp63_, _tmp69_);
									_vala_code_node_unref0 (_tmp69_);
									_g_free0 (_tmp67_);
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp70_ = type;
	_tmp71_ = vala_unresolved_type_get_unresolved_symbol (_tmp70_);
	_tmp72_ = _tmp71_;
	if (_tmp72_ != NULL) {
		ValaUnresolvedType* _tmp73_;
		ValaUnresolvedSymbol* _tmp74_;
		ValaUnresolvedSymbol* _tmp75_;
		const gchar* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp82_;
		_tmp73_ = type;
		_tmp74_ = vala_unresolved_type_get_unresolved_symbol (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_symbol_get_name ((ValaSymbol*) _tmp75_);
		_tmp77_ = _tmp76_;
		if (g_strcmp0 (_tmp77_, "pointer") == 0) {
			ValaVoidType* _tmp78_;
			ValaVoidType* _tmp79_;
			ValaPointerType* _tmp80_;
			ValaDataType* _tmp81_;
			_tmp78_ = vala_void_type_new (NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_pointer_type_new ((ValaDataType*) _tmp79_, NULL);
			_tmp81_ = (ValaDataType*) _tmp80_;
			_vala_code_node_unref0 (_tmp79_);
			result = _tmp81_;
			_g_free0 (ns_name);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (dt);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp82_ = ns_name;
		if (_tmp82_ != NULL) {
			ValaUnresolvedType* _tmp83_;
			ValaUnresolvedSymbol* _tmp84_;
			ValaUnresolvedSymbol* _tmp85_;
			const gchar* _tmp86_;
			ValaUnresolvedSymbol* _tmp87_;
			ValaUnresolvedSymbol* _tmp88_;
			_tmp83_ = type;
			_tmp84_ = vala_unresolved_type_get_unresolved_symbol (_tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = ns_name;
			_tmp87_ = vala_unresolved_symbol_new (NULL, _tmp86_, NULL);
			_tmp88_ = _tmp87_;
			vala_unresolved_symbol_set_inner (_tmp85_, _tmp88_);
			_vala_code_node_unref0 (_tmp88_);
		}
		result = (ValaDataType*) type;
		_g_free0 (ns_name);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp89_ = self->priv->current_namespace;
	_tmp90_ = vala_symbol_get_name ((ValaSymbol*) _tmp89_);
	_tmp91_ = _tmp90_;
	if (g_str_has_prefix (n, _tmp91_)) {
		ValaUnresolvedType* _tmp92_;
		ValaNamespace* _tmp93_;
		const gchar* _tmp94_;
		const gchar* _tmp95_;
		ValaUnresolvedSymbol* _tmp96_;
		ValaUnresolvedSymbol* _tmp97_;
		ValaNamespace* _tmp98_;
		const gchar* _tmp99_;
		const gchar* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		ValaUnresolvedSymbol* _tmp105_;
		ValaUnresolvedSymbol* _tmp106_;
		_tmp92_ = type;
		_tmp93_ = self->priv->current_namespace;
		_tmp94_ = vala_symbol_get_name ((ValaSymbol*) _tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_unresolved_symbol_new (NULL, _tmp95_, NULL);
		_tmp97_ = _tmp96_;
		_tmp98_ = self->priv->current_namespace;
		_tmp99_ = vala_symbol_get_name ((ValaSymbol*) _tmp98_);
		_tmp100_ = _tmp99_;
		_tmp101_ = strlen (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = string_substring (n, (glong) _tmp102_, (glong) -1);
		_tmp104_ = _tmp103_;
		_tmp105_ = vala_unresolved_symbol_new (_tmp97_, _tmp104_, NULL);
		_tmp106_ = _tmp105_;
		vala_unresolved_type_set_unresolved_symbol (_tmp92_, _tmp106_);
		_vala_code_node_unref0 (_tmp106_);
		_g_free0 (_tmp104_);
		_vala_code_node_unref0 (_tmp97_);
	} else {
		gboolean _tmp107_ = FALSE;
		gboolean _tmp108_ = FALSE;
		ValaNamespace* _tmp109_;
		ValaSymbol* _tmp110_;
		ValaSymbol* _tmp111_;
		_tmp109_ = self->priv->current_namespace;
		_tmp110_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp109_);
		_tmp111_ = _tmp110_;
		if (_tmp111_ != NULL) {
			ValaNamespace* _tmp112_;
			ValaSymbol* _tmp113_;
			ValaSymbol* _tmp114_;
			const gchar* _tmp115_;
			const gchar* _tmp116_;
			_tmp112_ = self->priv->current_namespace;
			_tmp113_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_symbol_get_name (_tmp114_);
			_tmp116_ = _tmp115_;
			_tmp108_ = _tmp116_ != NULL;
		} else {
			_tmp108_ = FALSE;
		}
		if (_tmp108_) {
			ValaNamespace* _tmp117_;
			ValaSymbol* _tmp118_;
			ValaSymbol* _tmp119_;
			const gchar* _tmp120_;
			const gchar* _tmp121_;
			_tmp117_ = self->priv->current_namespace;
			_tmp118_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_symbol_get_name (_tmp119_);
			_tmp121_ = _tmp120_;
			_tmp107_ = g_str_has_prefix (n, _tmp121_);
		} else {
			_tmp107_ = FALSE;
		}
		if (_tmp107_) {
			ValaUnresolvedType* _tmp122_;
			ValaNamespace* _tmp123_;
			ValaSymbol* _tmp124_;
			ValaSymbol* _tmp125_;
			const gchar* _tmp126_;
			const gchar* _tmp127_;
			ValaUnresolvedSymbol* _tmp128_;
			ValaUnresolvedSymbol* _tmp129_;
			ValaNamespace* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			const gchar* _tmp133_;
			const gchar* _tmp134_;
			gint _tmp135_;
			gint _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			ValaUnresolvedSymbol* _tmp139_;
			ValaUnresolvedSymbol* _tmp140_;
			_tmp122_ = type;
			_tmp123_ = self->priv->current_namespace;
			_tmp124_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp123_);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_symbol_get_name (_tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_unresolved_symbol_new (NULL, _tmp127_, NULL);
			_tmp129_ = _tmp128_;
			_tmp130_ = self->priv->current_namespace;
			_tmp131_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_symbol_get_name (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = strlen (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = string_substring (n, (glong) _tmp136_, (glong) -1);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_unresolved_symbol_new (_tmp129_, _tmp138_, NULL);
			_tmp140_ = _tmp139_;
			vala_unresolved_type_set_unresolved_symbol (_tmp122_, _tmp140_);
			_vala_code_node_unref0 (_tmp140_);
			_g_free0 (_tmp138_);
			_vala_code_node_unref0 (_tmp129_);
		} else {
			if (g_str_has_prefix (n, "G")) {
				ValaUnresolvedType* _tmp141_;
				ValaUnresolvedSymbol* _tmp142_;
				ValaUnresolvedSymbol* _tmp143_;
				gchar* _tmp144_;
				gchar* _tmp145_;
				ValaUnresolvedSymbol* _tmp146_;
				ValaUnresolvedSymbol* _tmp147_;
				_tmp141_ = type;
				_tmp142_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
				_tmp143_ = _tmp142_;
				_tmp144_ = string_substring (n, (glong) 1, (glong) -1);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_unresolved_symbol_new (_tmp143_, _tmp145_, NULL);
				_tmp147_ = _tmp146_;
				vala_unresolved_type_set_unresolved_symbol (_tmp141_, _tmp147_);
				_vala_code_node_unref0 (_tmp147_);
				_g_free0 (_tmp145_);
				_vala_code_node_unref0 (_tmp143_);
			} else {
				gchar** name_parts = NULL;
				gchar** _tmp148_;
				gchar** _tmp149_;
				gint name_parts_length1;
				gint _name_parts_size_;
				gchar** _tmp150_;
				gint _tmp150__length1;
				const gchar* _tmp151_;
				_tmp149_ = _tmp148_ = g_strsplit (n, ".", 2);
				name_parts = _tmp149_;
				name_parts_length1 = _vala_array_length (_tmp148_);
				_name_parts_size_ = name_parts_length1;
				_tmp150_ = name_parts;
				_tmp150__length1 = name_parts_length1;
				_tmp151_ = _tmp150_[1];
				if (_tmp151_ == NULL) {
					ValaUnresolvedType* _tmp152_;
					gchar** _tmp153_;
					gint _tmp153__length1;
					const gchar* _tmp154_;
					ValaUnresolvedSymbol* _tmp155_;
					ValaUnresolvedSymbol* _tmp156_;
					_tmp152_ = type;
					_tmp153_ = name_parts;
					_tmp153__length1 = name_parts_length1;
					_tmp154_ = _tmp153_[0];
					_tmp155_ = vala_unresolved_symbol_new (NULL, _tmp154_, NULL);
					_tmp156_ = _tmp155_;
					vala_unresolved_type_set_unresolved_symbol (_tmp152_, _tmp156_);
					_vala_code_node_unref0 (_tmp156_);
				} else {
					ValaUnresolvedType* _tmp157_;
					gchar** _tmp158_;
					gint _tmp158__length1;
					const gchar* _tmp159_;
					ValaUnresolvedSymbol* _tmp160_;
					ValaUnresolvedSymbol* _tmp161_;
					gchar** _tmp162_;
					gint _tmp162__length1;
					const gchar* _tmp163_;
					ValaUnresolvedSymbol* _tmp164_;
					ValaUnresolvedSymbol* _tmp165_;
					_tmp157_ = type;
					_tmp158_ = name_parts;
					_tmp158__length1 = name_parts_length1;
					_tmp159_ = _tmp158_[0];
					_tmp160_ = vala_unresolved_symbol_new (NULL, _tmp159_, NULL);
					_tmp161_ = _tmp160_;
					_tmp162_ = name_parts;
					_tmp162__length1 = name_parts_length1;
					_tmp163_ = _tmp162_[1];
					_tmp164_ = vala_unresolved_symbol_new (_tmp161_, _tmp163_, NULL);
					_tmp165_ = _tmp164_;
					vala_unresolved_type_set_unresolved_symbol (_tmp157_, _tmp165_);
					_vala_code_node_unref0 (_tmp165_);
					_vala_code_node_unref0 (_tmp161_);
				}
				name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = (ValaDataType*) type;
	_g_free0 (ns_name);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (dt);
	return result;
}

static ValaDataType*
vala_gidl_parser_parse_param (ValaGIdlParser* self,
                              GIdlNodeParam* param,
                              ValaParameterDirection* direction)
{
	ValaParameterDirection _vala_direction = 0;
	ValaDataType* type = NULL;
	GIdlNodeType* _tmp0_;
	ValaParameterDirection _tmp1_ = 0;
	ValaDataType* _tmp2_;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp0_ = param->type;
	_tmp2_ = vala_gidl_parser_parse_type (self, _tmp0_, &_tmp1_);
	_vala_direction = _tmp1_;
	type = _tmp2_;
	result = type;
	if (direction) {
		*direction = _vala_direction;
	}
	return result;
}

static ValaUnresolvedSymbol*
vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self,
                                           const gchar* symbol_string,
                                           ValaSourceReference* source_reference)
{
	ValaUnresolvedSymbol* sym = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	ValaUnresolvedSymbol* _tmp5_;
	ValaUnresolvedSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_;
				const gchar* _tmp3_;
				ValaUnresolvedSymbol* _tmp4_;
				_tmp2_ = sym;
				_tmp3_ = s;
				_tmp4_ = vala_unresolved_symbol_new (_tmp2_, _tmp3_, source_reference);
				_vala_code_node_unref0 (sym);
				sym = _tmp4_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = sym;
	if (_tmp5_ == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self,
                                                   ValaDataType* parent_type,
                                                   const gchar* type_arguments,
                                                   ValaSourceReference* source_reference)
{
	gint type_arguments_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* current = NULL;
	GString* _tmp2_;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp19_;
	const gchar* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	_tmp1_ = _tmp0_;
	type_arguments_length = (gint) _tmp1_;
	_tmp2_ = g_string_sized_new ((gsize) type_arguments_length);
	current = _tmp2_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = c;
					c = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(c < type_arguments_length)) {
					break;
				}
				if (string_get (type_arguments, (glong) c) == '<') {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = string_get (type_arguments, (glong) c) == '[';
				}
				if (_tmp5_) {
					gint _tmp6_;
					GString* _tmp7_;
					_tmp6_ = depth;
					depth = _tmp6_ + 1;
					_tmp7_ = current;
					g_string_append_unichar (_tmp7_, (gunichar) string_get (type_arguments, (glong) c));
				} else {
					gboolean _tmp8_ = FALSE;
					if (string_get (type_arguments, (glong) c) == '>') {
						_tmp8_ = TRUE;
					} else {
						_tmp8_ = string_get (type_arguments, (glong) c) == ']';
					}
					if (_tmp8_) {
						gint _tmp9_;
						GString* _tmp10_;
						_tmp9_ = depth;
						depth = _tmp9_ - 1;
						_tmp10_ = current;
						g_string_append_unichar (_tmp10_, (gunichar) string_get (type_arguments, (glong) c));
					} else {
						if (string_get (type_arguments, (glong) c) == ',') {
							if (depth == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp11_;
								const gchar* _tmp12_;
								ValaDataType* _tmp13_;
								ValaDataType* _tmp14_;
								ValaDataType* _tmp15_;
								GString* _tmp16_;
								_tmp11_ = current;
								_tmp12_ = _tmp11_->str;
								_tmp13_ = vala_gidl_parser_parse_type_from_string (self, _tmp12_, TRUE, source_reference);
								dt = _tmp13_;
								_tmp14_ = dt;
								if (_tmp14_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp15_ = dt;
								vala_data_type_add_type_argument (parent_type, _tmp15_);
								_tmp16_ = current;
								g_string_truncate (_tmp16_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp17_;
								_tmp17_ = current;
								g_string_append_unichar (_tmp17_, (gunichar) string_get (type_arguments, (glong) c));
							}
						} else {
							GString* _tmp18_;
							_tmp18_ = current;
							g_string_append_unichar (_tmp18_, (gunichar) string_get (type_arguments, (glong) c));
						}
					}
				}
			}
		}
	}
	_tmp19_ = current;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = vala_gidl_parser_parse_type_from_string (self, _tmp20_, TRUE, source_reference);
	dt = _tmp21_;
	_tmp22_ = dt;
	if (_tmp22_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp23_ = dt;
	vala_data_type_add_type_argument (parent_type, _tmp23_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}

static ValaDataType*
vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self,
                                         const gchar* type_string,
                                         gboolean owned_by_default,
                                         ValaSourceReference* source_reference)
{
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gchar* type_name = NULL;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp14_;
	gchar* _tmp15_;
	gchar* array_data = NULL;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* array_dimension_data = NULL;
	GMatchInfo* _tmp18_;
	gchar* _tmp19_;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	gboolean nullable = FALSE;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	gboolean value_owned = FALSE;
	const gchar* _tmp41_;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp43_;
	ValaUnresolvedSymbol* _tmp44_;
	ValaUnresolvedSymbol* _tmp45_;
	ValaUnresolvedSymbol* _tmp46_;
	ValaUnresolvedType* _tmp47_;
	gboolean _tmp48_ = FALSE;
	const gchar* _tmp49_;
	const gchar* _tmp55_;
	gboolean _tmp63_ = FALSE;
	const gchar* _tmp64_;
	ValaDataType* _tmp74_;
	ValaDataType* _tmp75_;
	GError* _inner_error0_ = NULL;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gidl_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[(," \
"*)?\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gidl_parser_type_from_string_regex);
			vala_gidl_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagidlparser.vala:2143: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = vala_gidl_parser_type_from_string_regex;
	_tmp7_ = g_regex_match (_tmp5_, type_string, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp8_ = match;
	_tmp9_ = g_match_info_fetch (_tmp8_, 1);
	ownership_data = _tmp9_;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 2);
	type_name = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 3);
	type_arguments_data = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 4);
	pointers_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 5);
	array_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 6);
	array_dimension_data = _tmp19_;
	_tmp20_ = match;
	_tmp21_ = g_match_info_fetch (_tmp20_, 7);
	nullable_data = _tmp21_;
	_tmp23_ = nullable_data;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp24_ = nullable_data;
		_tmp25_ = strlen (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = _tmp26_ > 0;
	} else {
		_tmp22_ = FALSE;
	}
	nullable = _tmp22_;
	_tmp28_ = ownership_data;
	if (_tmp28_ == NULL) {
		const gchar* _tmp29_;
		_tmp29_ = type_name;
		_tmp27_ = g_strcmp0 (_tmp29_, "void") == 0;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		_tmp31_ = array_data;
		if (_tmp31_ == NULL) {
			_tmp30_ = !nullable;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValaVoidType* _tmp32_;
			const gchar* _tmp33_;
			_tmp32_ = vala_void_type_new (source_reference);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp32_;
			_tmp33_ = pointers_data;
			if (_tmp33_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp34_ = FALSE;
						_tmp34_ = TRUE;
						while (TRUE) {
							const gchar* _tmp36_;
							gint _tmp37_;
							gint _tmp38_;
							ValaDataType* _tmp39_;
							ValaPointerType* _tmp40_;
							if (!_tmp34_) {
								gint _tmp35_;
								_tmp35_ = i;
								i = _tmp35_ + 1;
							}
							_tmp34_ = FALSE;
							_tmp36_ = pointers_data;
							_tmp37_ = strlen (_tmp36_);
							_tmp38_ = _tmp37_;
							if (!(i < _tmp38_)) {
								break;
							}
							_tmp39_ = type;
							_tmp40_ = vala_pointer_type_new (_tmp39_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp40_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	_tmp41_ = ownership_data;
	if (g_strcmp0 (_tmp41_, "owned") == 0) {
		value_owned = TRUE;
	} else {
		const gchar* _tmp42_;
		_tmp42_ = ownership_data;
		if (g_strcmp0 (_tmp42_, "unowned") == 0) {
			value_owned = FALSE;
		}
	}
	_tmp43_ = type_name;
	_tmp44_ = vala_gidl_parser_parse_symbol_from_string (self, _tmp43_, source_reference);
	sym = _tmp44_;
	_tmp45_ = sym;
	if (_tmp45_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_dimension_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp46_ = sym;
	_tmp47_ = vala_unresolved_type_new_from_symbol (_tmp46_, source_reference);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp47_;
	_tmp49_ = type_arguments_data;
	if (_tmp49_ != NULL) {
		const gchar* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		_tmp50_ = type_arguments_data;
		_tmp51_ = strlen (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp48_ = _tmp52_ > 0;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		ValaDataType* _tmp53_;
		const gchar* _tmp54_;
		_tmp53_ = type;
		_tmp54_ = type_arguments_data;
		if (!vala_gidl_parser_parse_type_arguments_from_string (self, _tmp53_, _tmp54_, source_reference)) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp55_ = pointers_data;
	if (_tmp55_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp56_ = FALSE;
				_tmp56_ = TRUE;
				while (TRUE) {
					const gchar* _tmp58_;
					gint _tmp59_;
					gint _tmp60_;
					ValaDataType* _tmp61_;
					ValaPointerType* _tmp62_;
					if (!_tmp56_) {
						gint _tmp57_;
						_tmp57_ = i;
						i = _tmp57_ + 1;
					}
					_tmp56_ = FALSE;
					_tmp58_ = pointers_data;
					_tmp59_ = strlen (_tmp58_);
					_tmp60_ = _tmp59_;
					if (!(i < _tmp60_)) {
						break;
					}
					_tmp61_ = type;
					_tmp62_ = vala_pointer_type_new (_tmp61_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp62_;
				}
			}
		}
	}
	_tmp64_ = array_data;
	if (_tmp64_ != NULL) {
		const gchar* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		_tmp65_ = array_data;
		_tmp66_ = strlen (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp63_ = _tmp67_ > 0;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		const gchar* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		ValaArrayType* _tmp73_;
		_tmp68_ = type;
		vala_data_type_set_value_owned (_tmp68_, TRUE);
		_tmp69_ = type;
		_tmp70_ = array_dimension_data;
		_tmp71_ = strlen (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_array_type_new (_tmp69_, _tmp72_ + 1, source_reference);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp73_;
	}
	_tmp74_ = type;
	vala_data_type_set_nullable (_tmp74_, nullable);
	_tmp75_ = type;
	vala_data_type_set_value_owned (_tmp75_, value_owned);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_dimension_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar** unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar** unparsed)
{
	gdouble _vala__result_ = 0.0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = errno != ERANGE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static ValaMethod*
vala_gidl_parser_create_method (ValaGIdlParser* self,
                                const gchar* name,
                                const gchar* symbol,
                                GIdlNodeParam* res,
                                GList* parameters,
                                gboolean is_constructor,
                                gboolean is_interface)
{
	ValaDataType* return_type = NULL;
	ValaMethod* m = NULL;
	gboolean _tmp1_ = FALSE;
	ValaMethod* _tmp37_;
	ValaSet* _tmp38_;
	ValaTypeSymbol* _tmp40_;
	gboolean add_ellipsis = FALSE;
	gboolean suppress_throws = FALSE;
	gchar* error_types = NULL;
	ValaSymbol* container = NULL;
	gchar** attributes = NULL;
	gint _tmp62_ = 0;
	gchar** _tmp63_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	gboolean first = FALSE;
	ValaParameter* last_param = NULL;
	ValaDataType* last_param_type = NULL;
	gboolean _tmp746_ = FALSE;
	gboolean _tmp759_ = FALSE;
	gboolean _tmp762_ = FALSE;
	ValaParameter* _tmp763_;
	ValaSymbol* _tmp772_;
	ValaMethod* _tmp778_;
	ValaSymbol* _tmp779_;
	gchar* _tmp780_;
	gchar* _tmp781_;
	gboolean _tmp782_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	if (res != NULL) {
		ValaDataType* _tmp0_;
		_tmp0_ = vala_gidl_parser_parse_param (self, res, NULL);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp0_;
	}
	if (!is_interface) {
		gboolean _tmp2_ = FALSE;
		if (is_constructor) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_str_has_prefix (name, "new");
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp3_;
		ValaCreationMethod* _tmp4_;
		ValaMethod* _tmp5_;
		ValaMethod* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp21_ = FALSE;
		ValaTypeSymbol* _tmp22_;
		_tmp3_ = self->priv->current_source_reference;
		_tmp4_ = vala_creation_method_new (NULL, name, _tmp3_, NULL);
		_vala_code_node_unref0 (m);
		m = (ValaMethod*) _tmp4_;
		_tmp5_ = m;
		vala_method_set_has_construct_function (_tmp5_, FALSE);
		_tmp6_ = m;
		_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (g_strcmp0 (_tmp8_, "new") == 0) {
			ValaMethod* _tmp9_;
			_tmp9_ = m;
			vala_symbol_set_name ((ValaSymbol*) _tmp9_, NULL);
		} else {
			ValaMethod* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = m;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (g_str_has_prefix (_tmp12_, "new_")) {
				ValaMethod* _tmp13_;
				ValaMethod* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp13_ = m;
				_tmp14_ = m;
				_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = strlen ("new_");
				_tmp18_ = _tmp17_;
				_tmp19_ = string_substring (_tmp16_, (glong) _tmp18_, (glong) -1);
				_tmp20_ = _tmp19_;
				vala_symbol_set_name ((ValaSymbol*) _tmp13_, _tmp20_);
				_g_free0 (_tmp20_);
			}
		}
		_tmp22_ = self->priv->current_data_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_CLASS)) {
			_tmp21_ = res != NULL;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			ValaTypeSymbol* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			GIdlNodeType* _tmp28_;
			const gchar* _tmp29_;
			gboolean _tmp30_;
			_tmp23_ = self->priv->current_data_type;
			_tmp24_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("%s*", _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = res->type;
			_tmp29_ = _tmp28_->unparsed;
			_tmp30_ = g_strcmp0 (_tmp27_, _tmp29_) != 0;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			if (_tmp30_) {
				ValaMethod* _tmp31_;
				GIdlNodeType* _tmp32_;
				const gchar* _tmp33_;
				_tmp31_ = m;
				_tmp32_ = res->type;
				_tmp33_ = _tmp32_->unparsed;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp31_, "CCode", "type", _tmp33_, NULL);
			}
		}
	} else {
		ValaDataType* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaMethod* _tmp36_;
		_tmp34_ = return_type;
		_tmp35_ = self->priv->current_source_reference;
		_tmp36_ = vala_method_new (name, _tmp34_, _tmp35_, NULL);
		_vala_code_node_unref0 (m);
		m = _tmp36_;
	}
	_tmp37_ = m;
	vala_symbol_set_access ((ValaSymbol*) _tmp37_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp38_ = self->priv->current_type_symbol_set;
	if (_tmp38_ != NULL) {
		ValaSet* _tmp39_;
		_tmp39_ = self->priv->current_type_symbol_set;
		vala_collection_add ((ValaCollection*) _tmp39_, name);
	}
	_tmp40_ = self->priv->current_data_type;
	if (_tmp40_ != NULL) {
		gchar** sig_attributes = NULL;
		ValaTypeSymbol* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gint _tmp46_ = 0;
		gchar** _tmp47_;
		gchar** _tmp48_;
		gint _tmp48__length1;
		gint sig_attributes_length1;
		gint _sig_attributes_size_;
		gchar** _tmp49_;
		gint _tmp49__length1;
		_tmp41_ = self->priv->current_data_type;
		_tmp42_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf ("%s::%s", _tmp43_, name);
		_tmp45_ = _tmp44_;
		_tmp47_ = vala_gidl_parser_get_attributes (self, _tmp45_, &_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp48__length1 = _tmp46_;
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		sig_attributes = _tmp48_;
		sig_attributes_length1 = _tmp48__length1;
		_sig_attributes_size_ = sig_attributes_length1;
		_tmp49_ = sig_attributes;
		_tmp49__length1 = sig_attributes_length1;
		if (_tmp49_ != NULL) {
			gchar** _tmp50_;
			gint _tmp50__length1;
			_tmp50_ = sig_attributes;
			_tmp50__length1 = sig_attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp50_;
				attr_collection_length1 = _tmp50__length1;
				for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
					gchar* _tmp51_;
					gchar* attr = NULL;
					_tmp51_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp51_;
					{
						gchar** nv = NULL;
						const gchar* _tmp52_;
						gchar** _tmp53_;
						gchar** _tmp54_;
						gint nv_length1;
						gint _nv_size_;
						gboolean _tmp55_ = FALSE;
						gchar** _tmp56_;
						gint _tmp56__length1;
						const gchar* _tmp57_;
						_tmp52_ = attr;
						_tmp54_ = _tmp53_ = g_strsplit (_tmp52_, "=", 2);
						nv = _tmp54_;
						nv_length1 = _vala_array_length (_tmp53_);
						_nv_size_ = nv_length1;
						_tmp56_ = nv;
						_tmp56__length1 = nv_length1;
						_tmp57_ = _tmp56_[0];
						if (g_strcmp0 (_tmp57_, "has_emitter") == 0) {
							gchar** _tmp58_;
							gint _tmp58__length1;
							const gchar* _tmp59_;
							gchar* _tmp60_;
							gchar* _tmp61_;
							_tmp58_ = nv;
							_tmp58__length1 = nv_length1;
							_tmp59_ = _tmp58_[1];
							_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
							_tmp61_ = _tmp60_;
							_tmp55_ = g_strcmp0 (_tmp61_, "1") == 0;
							_g_free0 (_tmp61_);
						} else {
							_tmp55_ = FALSE;
						}
						if (_tmp55_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (return_type);
							return result;
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	error_types = NULL;
	container = NULL;
	_tmp63_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp62_);
	attributes = _tmp63_;
	attributes_length1 = _tmp62_;
	_attributes_size_ = attributes_length1;
	_tmp64_ = attributes;
	_tmp64__length1 = attributes_length1;
	if (_tmp64_ != NULL) {
		gchar** _tmp65_;
		gint _tmp65__length1;
		_tmp65_ = attributes;
		_tmp65__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp65_;
			attr_collection_length1 = _tmp65__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp66_;
				gchar* attr = NULL;
				_tmp66_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp66_;
				{
					gchar** nv = NULL;
					const gchar* _tmp67_;
					gchar** _tmp68_;
					gchar** _tmp69_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp70_;
					gint _tmp70__length1;
					const gchar* _tmp71_;
					_tmp67_ = attr;
					_tmp69_ = _tmp68_ = g_strsplit (_tmp67_, "=", 2);
					nv = _tmp69_;
					nv_length1 = _vala_array_length (_tmp68_);
					_nv_size_ = nv_length1;
					_tmp70_ = nv;
					_tmp70__length1 = nv_length1;
					_tmp71_ = _tmp70_[0];
					if (g_strcmp0 (_tmp71_, "name") == 0) {
						ValaMethod* _tmp72_;
						gchar** _tmp73_;
						gint _tmp73__length1;
						const gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						_tmp72_ = m;
						_tmp73_ = nv;
						_tmp73__length1 = nv_length1;
						_tmp74_ = _tmp73_[1];
						_tmp75_ = vala_gidl_parser_eval (self, _tmp74_);
						_tmp76_ = _tmp75_;
						vala_symbol_set_name ((ValaSymbol*) _tmp72_, _tmp76_);
						_g_free0 (_tmp76_);
					} else {
						gchar** _tmp77_;
						gint _tmp77__length1;
						const gchar* _tmp78_;
						_tmp77_ = nv;
						_tmp77__length1 = nv_length1;
						_tmp78_ = _tmp77_[0];
						if (g_strcmp0 (_tmp78_, "hidden") == 0) {
							gchar** _tmp79_;
							gint _tmp79__length1;
							const gchar* _tmp80_;
							gchar* _tmp81_;
							gchar* _tmp82_;
							gboolean _tmp83_;
							_tmp79_ = nv;
							_tmp79__length1 = nv_length1;
							_tmp80_ = _tmp79_[1];
							_tmp81_ = vala_gidl_parser_eval (self, _tmp80_);
							_tmp82_ = _tmp81_;
							_tmp83_ = g_strcmp0 (_tmp82_, "1") == 0;
							_g_free0 (_tmp82_);
							if (_tmp83_) {
								result = NULL;
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (container);
								_g_free0 (error_types);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (return_type);
								return result;
							}
						} else {
							gchar** _tmp84_;
							gint _tmp84__length1;
							const gchar* _tmp85_;
							_tmp84_ = nv;
							_tmp84__length1 = nv_length1;
							_tmp85_ = _tmp84_[0];
							if (g_strcmp0 (_tmp85_, "ellipsis") == 0) {
								gchar** _tmp86_;
								gint _tmp86__length1;
								const gchar* _tmp87_;
								gchar* _tmp88_;
								gchar* _tmp89_;
								gboolean _tmp90_;
								_tmp86_ = nv;
								_tmp86__length1 = nv_length1;
								_tmp87_ = _tmp86_[1];
								_tmp88_ = vala_gidl_parser_eval (self, _tmp87_);
								_tmp89_ = _tmp88_;
								_tmp90_ = g_strcmp0 (_tmp89_, "1") == 0;
								_g_free0 (_tmp89_);
								if (_tmp90_) {
									add_ellipsis = TRUE;
								}
							} else {
								gchar** _tmp91_;
								gint _tmp91__length1;
								const gchar* _tmp92_;
								_tmp91_ = nv;
								_tmp91__length1 = nv_length1;
								_tmp92_ = _tmp91_[0];
								if (g_strcmp0 (_tmp92_, "printf_format") == 0) {
									gchar** _tmp93_;
									gint _tmp93__length1;
									const gchar* _tmp94_;
									gchar* _tmp95_;
									gchar* _tmp96_;
									gboolean _tmp97_;
									_tmp93_ = nv;
									_tmp93__length1 = nv_length1;
									_tmp94_ = _tmp93_[1];
									_tmp95_ = vala_gidl_parser_eval (self, _tmp94_);
									_tmp96_ = _tmp95_;
									_tmp97_ = g_strcmp0 (_tmp96_, "1") == 0;
									_g_free0 (_tmp96_);
									if (_tmp97_) {
										ValaMethod* _tmp98_;
										_tmp98_ = m;
										vala_code_node_set_attribute ((ValaCodeNode*) _tmp98_, "PrintfFormat", TRUE, NULL);
									}
								} else {
									gchar** _tmp99_;
									gint _tmp99__length1;
									const gchar* _tmp100_;
									_tmp99_ = nv;
									_tmp99__length1 = nv_length1;
									_tmp100_ = _tmp99_[0];
									if (g_strcmp0 (_tmp100_, "transfer_ownership") == 0) {
										gchar** _tmp101_;
										gint _tmp101__length1;
										const gchar* _tmp102_;
										gchar* _tmp103_;
										gchar* _tmp104_;
										gboolean _tmp105_;
										_tmp101_ = nv;
										_tmp101__length1 = nv_length1;
										_tmp102_ = _tmp101_[1];
										_tmp103_ = vala_gidl_parser_eval (self, _tmp102_);
										_tmp104_ = _tmp103_;
										_tmp105_ = g_strcmp0 (_tmp104_, "1") == 0;
										_g_free0 (_tmp104_);
										if (_tmp105_) {
											ValaDataType* _tmp106_;
											_tmp106_ = return_type;
											vala_data_type_set_value_owned (_tmp106_, TRUE);
										}
									} else {
										gchar** _tmp107_;
										gint _tmp107__length1;
										const gchar* _tmp108_;
										_tmp107_ = nv;
										_tmp107__length1 = nv_length1;
										_tmp108_ = _tmp107_[0];
										if (g_strcmp0 (_tmp108_, "transfer_container") == 0) {
											gchar** _tmp109_;
											gint _tmp109__length1;
											const gchar* _tmp110_;
											gchar* _tmp111_;
											gchar* _tmp112_;
											gboolean _tmp113_;
											_tmp109_ = nv;
											_tmp109__length1 = nv_length1;
											_tmp110_ = _tmp109_[1];
											_tmp111_ = vala_gidl_parser_eval (self, _tmp110_);
											_tmp112_ = _tmp111_;
											_tmp113_ = g_strcmp0 (_tmp112_, "1") == 0;
											_g_free0 (_tmp112_);
											if (_tmp113_) {
												ValaDataType* _tmp114_;
												ValaDataType* _tmp115_;
												_tmp114_ = return_type;
												vala_data_type_set_value_owned (_tmp114_, TRUE);
												_tmp115_ = return_type;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, VALA_TYPE_ARRAY_TYPE)) {
													ValaDataType* _tmp116_;
													ValaDataType* _tmp117_;
													ValaDataType* _tmp118_;
													_tmp116_ = return_type;
													_tmp117_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
													_tmp118_ = _tmp117_;
													vala_data_type_set_value_owned (_tmp118_, FALSE);
												}
											}
										} else {
											gchar** _tmp119_;
											gint _tmp119__length1;
											const gchar* _tmp120_;
											_tmp119_ = nv;
											_tmp119__length1 = nv_length1;
											_tmp120_ = _tmp119_[0];
											if (g_strcmp0 (_tmp120_, "destroys_instance") == 0) {
												gchar** _tmp121_;
												gint _tmp121__length1;
												const gchar* _tmp122_;
												gchar* _tmp123_;
												gchar* _tmp124_;
												gboolean _tmp125_;
												_tmp121_ = nv;
												_tmp121__length1 = nv_length1;
												_tmp122_ = _tmp121_[1];
												_tmp123_ = vala_gidl_parser_eval (self, _tmp122_);
												_tmp124_ = _tmp123_;
												_tmp125_ = g_strcmp0 (_tmp124_, "1") == 0;
												_g_free0 (_tmp124_);
												if (_tmp125_) {
													ValaMethod* _tmp126_;
													ValaMethod* _tmp127_;
													ValaSourceReference* _tmp128_;
													ValaSourceReference* _tmp129_;
													_tmp126_ = m;
													_tmp127_ = m;
													_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp127_);
													_tmp129_ = _tmp128_;
													vala_code_node_set_attribute ((ValaCodeNode*) _tmp126_, "DestroysInstance", TRUE, _tmp129_);
												}
											} else {
												gchar** _tmp130_;
												gint _tmp130__length1;
												const gchar* _tmp131_;
												_tmp130_ = nv;
												_tmp130__length1 = nv_length1;
												_tmp131_ = _tmp130_[0];
												if (g_strcmp0 (_tmp131_, "returns_floating_reference") == 0) {
													gchar** _tmp132_;
													gint _tmp132__length1;
													const gchar* _tmp133_;
													gchar* _tmp134_;
													gchar* _tmp135_;
													gboolean _tmp136_;
													_tmp132_ = nv;
													_tmp132__length1 = nv_length1;
													_tmp133_ = _tmp132_[1];
													_tmp134_ = vala_gidl_parser_eval (self, _tmp133_);
													_tmp135_ = _tmp134_;
													_tmp136_ = g_strcmp0 (_tmp135_, "1") == 0;
													_g_free0 (_tmp135_);
													if (_tmp136_) {
														ValaMethod* _tmp137_;
														ValaMethod* _tmp138_;
														ValaDataType* _tmp139_;
														ValaDataType* _tmp140_;
														_tmp137_ = m;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp137_, "CCode", "returns_floating_reference", TRUE, NULL);
														_tmp138_ = m;
														_tmp139_ = vala_callable_get_return_type ((ValaCallable*) _tmp138_);
														_tmp140_ = _tmp139_;
														vala_data_type_set_value_owned (_tmp140_, TRUE);
													}
												} else {
													gchar** _tmp141_;
													gint _tmp141__length1;
													const gchar* _tmp142_;
													_tmp141_ = nv;
													_tmp141__length1 = nv_length1;
													_tmp142_ = _tmp141_[0];
													if (g_strcmp0 (_tmp142_, "nullable") == 0) {
														gboolean _tmp143_ = FALSE;
														gchar** _tmp144_;
														gint _tmp144__length1;
														const gchar* _tmp145_;
														gchar* _tmp146_;
														gchar* _tmp147_;
														gboolean _tmp148_;
														_tmp144_ = nv;
														_tmp144__length1 = nv_length1;
														_tmp145_ = _tmp144_[1];
														_tmp146_ = vala_gidl_parser_eval (self, _tmp145_);
														_tmp147_ = _tmp146_;
														_tmp148_ = g_strcmp0 (_tmp147_, "1") == 0;
														_g_free0 (_tmp147_);
														if (_tmp148_) {
															ValaDataType* _tmp149_;
															_tmp149_ = return_type;
															_tmp143_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp149_, VALA_TYPE_VOID_TYPE);
														} else {
															_tmp143_ = FALSE;
														}
														if (_tmp143_) {
															ValaDataType* _tmp150_;
															_tmp150_ = return_type;
															vala_data_type_set_nullable (_tmp150_, TRUE);
														}
													} else {
														gchar** _tmp151_;
														gint _tmp151__length1;
														const gchar* _tmp152_;
														_tmp151_ = nv;
														_tmp151__length1 = nv_length1;
														_tmp152_ = _tmp151_[0];
														if (g_strcmp0 (_tmp152_, "sentinel") == 0) {
															ValaMethod* _tmp153_;
															gchar** _tmp154_;
															gint _tmp154__length1;
															const gchar* _tmp155_;
															gchar* _tmp156_;
															gchar* _tmp157_;
															_tmp153_ = m;
															_tmp154_ = nv;
															_tmp154__length1 = nv_length1;
															_tmp155_ = _tmp154_[1];
															_tmp156_ = vala_gidl_parser_eval (self, _tmp155_);
															_tmp157_ = _tmp156_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp153_, "CCode", "sentinel", _tmp157_, NULL);
															_g_free0 (_tmp157_);
														} else {
															gchar** _tmp158_;
															gint _tmp158__length1;
															const gchar* _tmp159_;
															_tmp158_ = nv;
															_tmp158__length1 = nv_length1;
															_tmp159_ = _tmp158_[0];
															if (g_strcmp0 (_tmp159_, "is_array") == 0) {
																gchar** _tmp160_;
																gint _tmp160__length1;
																const gchar* _tmp161_;
																gchar* _tmp162_;
																gchar* _tmp163_;
																gboolean _tmp164_;
																_tmp160_ = nv;
																_tmp160__length1 = nv_length1;
																_tmp161_ = _tmp160_[1];
																_tmp162_ = vala_gidl_parser_eval (self, _tmp161_);
																_tmp163_ = _tmp162_;
																_tmp164_ = g_strcmp0 (_tmp163_, "1") == 0;
																_g_free0 (_tmp163_);
																if (_tmp164_) {
																	ValaDataType* _tmp165_;
																	ValaDataType* _tmp166_;
																	ValaDataType* _tmp167_;
																	ValaSourceReference* _tmp168_;
																	ValaSourceReference* _tmp169_;
																	ValaArrayType* _tmp170_;
																	ValaMethod* _tmp171_;
																	ValaDataType* _tmp172_;
																	_tmp165_ = return_type;
																	vala_data_type_set_value_owned (_tmp165_, TRUE);
																	_tmp166_ = return_type;
																	_tmp167_ = return_type;
																	_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp167_);
																	_tmp169_ = _tmp168_;
																	_tmp170_ = vala_array_type_new (_tmp166_, 1, _tmp169_);
																	_vala_code_node_unref0 (return_type);
																	return_type = (ValaDataType*) _tmp170_;
																	_tmp171_ = m;
																	_tmp172_ = return_type;
																	vala_callable_set_return_type ((ValaCallable*) _tmp171_, _tmp172_);
																}
															} else {
																gchar** _tmp173_;
																gint _tmp173__length1;
																const gchar* _tmp174_;
																_tmp173_ = nv;
																_tmp173__length1 = nv_length1;
																_tmp174_ = _tmp173_[0];
																if (g_strcmp0 (_tmp174_, "is_pointer") == 0) {
																	gchar** _tmp175_;
																	gint _tmp175__length1;
																	const gchar* _tmp176_;
																	gchar* _tmp177_;
																	gchar* _tmp178_;
																	gboolean _tmp179_;
																	_tmp175_ = nv;
																	_tmp175__length1 = nv_length1;
																	_tmp176_ = _tmp175_[1];
																	_tmp177_ = vala_gidl_parser_eval (self, _tmp176_);
																	_tmp178_ = _tmp177_;
																	_tmp179_ = g_strcmp0 (_tmp178_, "1") == 0;
																	_g_free0 (_tmp178_);
																	if (_tmp179_) {
																		ValaDataType* _tmp180_;
																		ValaDataType* _tmp181_;
																		ValaSourceReference* _tmp182_;
																		ValaSourceReference* _tmp183_;
																		ValaPointerType* _tmp184_;
																		ValaMethod* _tmp185_;
																		ValaDataType* _tmp186_;
																		_tmp180_ = return_type;
																		_tmp181_ = return_type;
																		_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp181_);
																		_tmp183_ = _tmp182_;
																		_tmp184_ = vala_pointer_type_new (_tmp180_, _tmp183_);
																		_vala_code_node_unref0 (return_type);
																		return_type = (ValaDataType*) _tmp184_;
																		_tmp185_ = m;
																		_tmp186_ = return_type;
																		vala_callable_set_return_type ((ValaCallable*) _tmp185_, _tmp186_);
																	}
																} else {
																	gchar** _tmp187_;
																	gint _tmp187__length1;
																	const gchar* _tmp188_;
																	_tmp187_ = nv;
																	_tmp187__length1 = nv_length1;
																	_tmp188_ = _tmp187_[0];
																	if (g_strcmp0 (_tmp188_, "throws") == 0) {
																		gchar** _tmp189_;
																		gint _tmp189__length1;
																		const gchar* _tmp190_;
																		gchar* _tmp191_;
																		gchar* _tmp192_;
																		gboolean _tmp193_;
																		_tmp189_ = nv;
																		_tmp189__length1 = nv_length1;
																		_tmp190_ = _tmp189_[1];
																		_tmp191_ = vala_gidl_parser_eval (self, _tmp190_);
																		_tmp192_ = _tmp191_;
																		_tmp193_ = g_strcmp0 (_tmp192_, "0") == 0;
																		_g_free0 (_tmp192_);
																		if (_tmp193_) {
																			suppress_throws = TRUE;
																		}
																	} else {
																		gchar** _tmp194_;
																		gint _tmp194__length1;
																		const gchar* _tmp195_;
																		_tmp194_ = nv;
																		_tmp194__length1 = nv_length1;
																		_tmp195_ = _tmp194_[0];
																		if (g_strcmp0 (_tmp195_, "error_types") == 0) {
																			gchar** _tmp196_;
																			gint _tmp196__length1;
																			const gchar* _tmp197_;
																			gchar* _tmp198_;
																			_tmp196_ = nv;
																			_tmp196__length1 = nv_length1;
																			_tmp197_ = _tmp196_[1];
																			_tmp198_ = vala_gidl_parser_eval (self, _tmp197_);
																			_g_free0 (error_types);
																			error_types = _tmp198_;
																		} else {
																			gchar** _tmp199_;
																			gint _tmp199__length1;
																			const gchar* _tmp200_;
																			_tmp199_ = nv;
																			_tmp199__length1 = nv_length1;
																			_tmp200_ = _tmp199_[0];
																			if (g_strcmp0 (_tmp200_, "no_array_length") == 0) {
																				gchar** _tmp201_;
																				gint _tmp201__length1;
																				const gchar* _tmp202_;
																				gchar* _tmp203_;
																				gchar* _tmp204_;
																				gboolean _tmp205_;
																				_tmp201_ = nv;
																				_tmp201__length1 = nv_length1;
																				_tmp202_ = _tmp201_[1];
																				_tmp203_ = vala_gidl_parser_eval (self, _tmp202_);
																				_tmp204_ = _tmp203_;
																				_tmp205_ = g_strcmp0 (_tmp204_, "1") == 0;
																				_g_free0 (_tmp204_);
																				if (_tmp205_) {
																					ValaMethod* _tmp206_;
																					_tmp206_ = m;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp206_, "CCode", "array_length", FALSE, NULL);
																				}
																			} else {
																				gchar** _tmp207_;
																				gint _tmp207__length1;
																				const gchar* _tmp208_;
																				_tmp207_ = nv;
																				_tmp207__length1 = nv_length1;
																				_tmp208_ = _tmp207_[0];
																				if (g_strcmp0 (_tmp208_, "array_null_terminated") == 0) {
																					gchar** _tmp209_;
																					gint _tmp209__length1;
																					const gchar* _tmp210_;
																					gchar* _tmp211_;
																					gchar* _tmp212_;
																					gboolean _tmp213_;
																					_tmp209_ = nv;
																					_tmp209__length1 = nv_length1;
																					_tmp210_ = _tmp209_[1];
																					_tmp211_ = vala_gidl_parser_eval (self, _tmp210_);
																					_tmp212_ = _tmp211_;
																					_tmp213_ = g_strcmp0 (_tmp212_, "1") == 0;
																					_g_free0 (_tmp212_);
																					if (_tmp213_) {
																						ValaMethod* _tmp214_;
																						ValaMethod* _tmp215_;
																						_tmp214_ = m;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp214_, "CCode", "array_length", FALSE, NULL);
																						_tmp215_ = m;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp215_, "CCode", "array_null_terminated", TRUE, NULL);
																					}
																				} else {
																					gchar** _tmp216_;
																					gint _tmp216__length1;
																					const gchar* _tmp217_;
																					_tmp216_ = nv;
																					_tmp216__length1 = nv_length1;
																					_tmp217_ = _tmp216_[0];
																					if (g_strcmp0 (_tmp217_, "array_length_type") == 0) {
																						ValaMethod* _tmp218_;
																						gchar** _tmp219_;
																						gint _tmp219__length1;
																						const gchar* _tmp220_;
																						gchar* _tmp221_;
																						gchar* _tmp222_;
																						_tmp218_ = m;
																						_tmp219_ = nv;
																						_tmp219__length1 = nv_length1;
																						_tmp220_ = _tmp219_[1];
																						_tmp221_ = vala_gidl_parser_eval (self, _tmp220_);
																						_tmp222_ = _tmp221_;
																						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp218_, "CCode", "array_length_type", _tmp222_, NULL);
																						_g_free0 (_tmp222_);
																					} else {
																						gchar** _tmp223_;
																						gint _tmp223__length1;
																						const gchar* _tmp224_;
																						_tmp223_ = nv;
																						_tmp223__length1 = nv_length1;
																						_tmp224_ = _tmp223_[0];
																						if (g_strcmp0 (_tmp224_, "type_name") == 0) {
																							ValaMethod* _tmp225_;
																							gchar** _tmp226_;
																							gint _tmp226__length1;
																							const gchar* _tmp227_;
																							gchar* _tmp228_;
																							gchar* _tmp229_;
																							ValaDataType* _tmp230_;
																							gboolean _tmp231_;
																							gboolean _tmp232_;
																							ValaDataType* _tmp233_;
																							ValaDataType* _tmp234_;
																							_tmp225_ = m;
																							_tmp226_ = nv;
																							_tmp226__length1 = nv_length1;
																							_tmp227_ = _tmp226_[1];
																							_tmp228_ = vala_gidl_parser_eval (self, _tmp227_);
																							_tmp229_ = _tmp228_;
																							_tmp230_ = return_type;
																							_tmp231_ = vala_data_type_get_value_owned (_tmp230_);
																							_tmp232_ = _tmp231_;
																							_tmp233_ = vala_gidl_parser_parse_type_from_string (self, _tmp229_, _tmp232_, NULL);
																							_vala_code_node_unref0 (return_type);
																							return_type = _tmp233_;
																							_tmp234_ = return_type;
																							vala_callable_set_return_type ((ValaCallable*) _tmp225_, _tmp234_);
																							_g_free0 (_tmp229_);
																						} else {
																							gchar** _tmp235_;
																							gint _tmp235__length1;
																							const gchar* _tmp236_;
																							_tmp235_ = nv;
																							_tmp235__length1 = nv_length1;
																							_tmp236_ = _tmp235_[0];
																							if (g_strcmp0 (_tmp236_, "ctype") == 0) {
																								ValaMethod* _tmp237_;
																								gchar** _tmp238_;
																								gint _tmp238__length1;
																								const gchar* _tmp239_;
																								gchar* _tmp240_;
																								gchar* _tmp241_;
																								_tmp237_ = m;
																								_tmp238_ = nv;
																								_tmp238__length1 = nv_length1;
																								_tmp239_ = _tmp238_[1];
																								_tmp240_ = vala_gidl_parser_eval (self, _tmp239_);
																								_tmp241_ = _tmp240_;
																								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp237_, "CCode", "type", _tmp241_, NULL);
																								_g_free0 (_tmp241_);
																							} else {
																								gchar** _tmp242_;
																								gint _tmp242__length1;
																								const gchar* _tmp243_;
																								_tmp242_ = nv;
																								_tmp242__length1 = nv_length1;
																								_tmp243_ = _tmp242_[0];
																								if (g_strcmp0 (_tmp243_, "type_arguments") == 0) {
																									ValaDataType* _tmp244_;
																									gchar** _tmp245_;
																									gint _tmp245__length1;
																									const gchar* _tmp246_;
																									gchar* _tmp247_;
																									gchar* _tmp248_;
																									_tmp244_ = return_type;
																									_tmp245_ = nv;
																									_tmp245__length1 = nv_length1;
																									_tmp246_ = _tmp245_[1];
																									_tmp247_ = vala_gidl_parser_eval (self, _tmp246_);
																									_tmp248_ = _tmp247_;
																									vala_gidl_parser_parse_type_arguments_from_string (self, _tmp244_, _tmp248_, NULL);
																									_g_free0 (_tmp248_);
																								} else {
																									gchar** _tmp249_;
																									gint _tmp249__length1;
																									const gchar* _tmp250_;
																									_tmp249_ = nv;
																									_tmp249__length1 = nv_length1;
																									_tmp250_ = _tmp249_[0];
																									if (g_strcmp0 (_tmp250_, "deprecated") == 0) {
																										gchar** _tmp251_;
																										gint _tmp251__length1;
																										const gchar* _tmp252_;
																										gchar* _tmp253_;
																										gchar* _tmp254_;
																										gboolean _tmp255_;
																										_tmp251_ = nv;
																										_tmp251__length1 = nv_length1;
																										_tmp252_ = _tmp251_[1];
																										_tmp253_ = vala_gidl_parser_eval (self, _tmp252_);
																										_tmp254_ = _tmp253_;
																										_tmp255_ = g_strcmp0 (_tmp254_, "1") == 0;
																										_g_free0 (_tmp254_);
																										if (_tmp255_) {
																											ValaMethod* _tmp256_;
																											_tmp256_ = m;
																											vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp256_, "Version", "deprecated", TRUE, NULL);
																										}
																									} else {
																										gchar** _tmp257_;
																										gint _tmp257__length1;
																										const gchar* _tmp258_;
																										_tmp257_ = nv;
																										_tmp257__length1 = nv_length1;
																										_tmp258_ = _tmp257_[0];
																										if (g_strcmp0 (_tmp258_, "replacement") == 0) {
																											ValaMethod* _tmp259_;
																											gchar** _tmp260_;
																											gint _tmp260__length1;
																											const gchar* _tmp261_;
																											gchar* _tmp262_;
																											gchar* _tmp263_;
																											_tmp259_ = m;
																											_tmp260_ = nv;
																											_tmp260__length1 = nv_length1;
																											_tmp261_ = _tmp260_[1];
																											_tmp262_ = vala_gidl_parser_eval (self, _tmp261_);
																											_tmp263_ = _tmp262_;
																											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp259_, "Version", "replacement", _tmp263_, NULL);
																											_g_free0 (_tmp263_);
																										} else {
																											gchar** _tmp264_;
																											gint _tmp264__length1;
																											const gchar* _tmp265_;
																											_tmp264_ = nv;
																											_tmp264__length1 = nv_length1;
																											_tmp265_ = _tmp264_[0];
																											if (g_strcmp0 (_tmp265_, "deprecated_since") == 0) {
																												ValaMethod* _tmp266_;
																												gchar** _tmp267_;
																												gint _tmp267__length1;
																												const gchar* _tmp268_;
																												gchar* _tmp269_;
																												gchar* _tmp270_;
																												_tmp266_ = m;
																												_tmp267_ = nv;
																												_tmp267__length1 = nv_length1;
																												_tmp268_ = _tmp267_[1];
																												_tmp269_ = vala_gidl_parser_eval (self, _tmp268_);
																												_tmp270_ = _tmp269_;
																												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp266_, "Version", "deprecated_since", _tmp270_, NULL);
																												_g_free0 (_tmp270_);
																											} else {
																												gchar** _tmp271_;
																												gint _tmp271__length1;
																												const gchar* _tmp272_;
																												_tmp271_ = nv;
																												_tmp271__length1 = nv_length1;
																												_tmp272_ = _tmp271_[0];
																												if (g_strcmp0 (_tmp272_, "cheader_filename") == 0) {
																													ValaMethod* _tmp273_;
																													gchar** _tmp274_;
																													gint _tmp274__length1;
																													const gchar* _tmp275_;
																													gchar* _tmp276_;
																													gchar* _tmp277_;
																													_tmp273_ = m;
																													_tmp274_ = nv;
																													_tmp274__length1 = nv_length1;
																													_tmp275_ = _tmp274_[1];
																													_tmp276_ = vala_gidl_parser_eval (self, _tmp275_);
																													_tmp277_ = _tmp276_;
																													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp273_, "CCode", "cheader_filename", _tmp277_, NULL);
																													_g_free0 (_tmp277_);
																												} else {
																													gchar** _tmp278_;
																													gint _tmp278__length1;
																													const gchar* _tmp279_;
																													_tmp278_ = nv;
																													_tmp278__length1 = nv_length1;
																													_tmp279_ = _tmp278_[0];
																													if (g_strcmp0 (_tmp279_, "abstract") == 0) {
																														gchar** _tmp280_;
																														gint _tmp280__length1;
																														const gchar* _tmp281_;
																														gchar* _tmp282_;
																														gchar* _tmp283_;
																														gboolean _tmp284_;
																														_tmp280_ = nv;
																														_tmp280__length1 = nv_length1;
																														_tmp281_ = _tmp280_[1];
																														_tmp282_ = vala_gidl_parser_eval (self, _tmp281_);
																														_tmp283_ = _tmp282_;
																														_tmp284_ = g_strcmp0 (_tmp283_, "1") == 0;
																														_g_free0 (_tmp283_);
																														if (_tmp284_) {
																															ValaMethod* _tmp285_;
																															_tmp285_ = m;
																															vala_method_set_is_abstract (_tmp285_, TRUE);
																														}
																													} else {
																														gchar** _tmp286_;
																														gint _tmp286__length1;
																														const gchar* _tmp287_;
																														_tmp286_ = nv;
																														_tmp286__length1 = nv_length1;
																														_tmp287_ = _tmp286_[0];
																														if (g_strcmp0 (_tmp287_, "virtual") == 0) {
																															gchar** _tmp288_;
																															gint _tmp288__length1;
																															const gchar* _tmp289_;
																															gchar* _tmp290_;
																															gchar* _tmp291_;
																															gboolean _tmp292_;
																															_tmp288_ = nv;
																															_tmp288__length1 = nv_length1;
																															_tmp289_ = _tmp288_[1];
																															_tmp290_ = vala_gidl_parser_eval (self, _tmp289_);
																															_tmp291_ = _tmp290_;
																															_tmp292_ = g_strcmp0 (_tmp291_, "1") == 0;
																															_g_free0 (_tmp291_);
																															if (_tmp292_) {
																																ValaMethod* _tmp293_;
																																_tmp293_ = m;
																																vala_method_set_is_virtual (_tmp293_, TRUE);
																															}
																														} else {
																															gchar** _tmp294_;
																															gint _tmp294__length1;
																															const gchar* _tmp295_;
																															_tmp294_ = nv;
																															_tmp294__length1 = nv_length1;
																															_tmp295_ = _tmp294_[0];
																															if (g_strcmp0 (_tmp295_, "vfunc_name") == 0) {
																																ValaMethod* _tmp296_;
																																gchar** _tmp297_;
																																gint _tmp297__length1;
																																const gchar* _tmp298_;
																																gchar* _tmp299_;
																																gchar* _tmp300_;
																																_tmp296_ = m;
																																_tmp297_ = nv;
																																_tmp297__length1 = nv_length1;
																																_tmp298_ = _tmp297_[1];
																																_tmp299_ = vala_gidl_parser_eval (self, _tmp298_);
																																_tmp300_ = _tmp299_;
																																vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp296_, "CCode", "vfunc_name", _tmp300_, NULL);
																																_g_free0 (_tmp300_);
																															} else {
																																gchar** _tmp301_;
																																gint _tmp301__length1;
																																const gchar* _tmp302_;
																																_tmp301_ = nv;
																																_tmp301__length1 = nv_length1;
																																_tmp302_ = _tmp301_[0];
																																if (g_strcmp0 (_tmp302_, "finish_vfunc_name") == 0) {
																																	ValaMethod* _tmp303_;
																																	gchar** _tmp304_;
																																	gint _tmp304__length1;
																																	const gchar* _tmp305_;
																																	gchar* _tmp306_;
																																	gchar* _tmp307_;
																																	_tmp303_ = m;
																																	_tmp304_ = nv;
																																	_tmp304__length1 = nv_length1;
																																	_tmp305_ = _tmp304_[1];
																																	_tmp306_ = vala_gidl_parser_eval (self, _tmp305_);
																																	_tmp307_ = _tmp306_;
																																	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp303_, "CCode", "finish_vfunc_name", _tmp307_, NULL);
																																	_g_free0 (_tmp307_);
																																} else {
																																	gchar** _tmp308_;
																																	gint _tmp308__length1;
																																	const gchar* _tmp309_;
																																	_tmp308_ = nv;
																																	_tmp308__length1 = nv_length1;
																																	_tmp309_ = _tmp308_[0];
																																	if (g_strcmp0 (_tmp309_, "finish_name") == 0) {
																																		ValaMethod* _tmp310_;
																																		gchar** _tmp311_;
																																		gint _tmp311__length1;
																																		const gchar* _tmp312_;
																																		gchar* _tmp313_;
																																		gchar* _tmp314_;
																																		_tmp310_ = m;
																																		_tmp311_ = nv;
																																		_tmp311__length1 = nv_length1;
																																		_tmp312_ = _tmp311_[1];
																																		_tmp313_ = vala_gidl_parser_eval (self, _tmp312_);
																																		_tmp314_ = _tmp313_;
																																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp310_, "CCode", "finish_name", _tmp314_, NULL);
																																		_g_free0 (_tmp314_);
																																	} else {
																																		gchar** _tmp315_;
																																		gint _tmp315__length1;
																																		const gchar* _tmp316_;
																																		_tmp315_ = nv;
																																		_tmp315__length1 = nv_length1;
																																		_tmp316_ = _tmp315_[0];
																																		if (g_strcmp0 (_tmp316_, "async") == 0) {
																																			gchar** _tmp317_;
																																			gint _tmp317__length1;
																																			const gchar* _tmp318_;
																																			gchar* _tmp319_;
																																			gchar* _tmp320_;
																																			gboolean _tmp321_;
																																			_tmp317_ = nv;
																																			_tmp317__length1 = nv_length1;
																																			_tmp318_ = _tmp317_[1];
																																			_tmp319_ = vala_gidl_parser_eval (self, _tmp318_);
																																			_tmp320_ = _tmp319_;
																																			_tmp321_ = g_strcmp0 (_tmp320_, "1") == 0;
																																			_g_free0 (_tmp320_);
																																			if (_tmp321_) {
																																				ValaMethod* _tmp322_;
																																				_tmp322_ = m;
																																				vala_method_set_coroutine (_tmp322_, TRUE);
																																			}
																																		} else {
																																			gchar** _tmp323_;
																																			gint _tmp323__length1;
																																			const gchar* _tmp324_;
																																			_tmp323_ = nv;
																																			_tmp323__length1 = nv_length1;
																																			_tmp324_ = _tmp323_[0];
																																			if (g_strcmp0 (_tmp324_, "parent") == 0) {
																																				gchar** _tmp325_;
																																				gint _tmp325__length1;
																																				const gchar* _tmp326_;
																																				gchar* _tmp327_;
																																				gchar* _tmp328_;
																																				ValaSymbol* _tmp329_;
																																				gchar* prefix = NULL;
																																				ValaSymbol* _tmp330_;
																																				gchar* _tmp331_;
																																				const gchar* _tmp332_;
																																				_tmp325_ = nv;
																																				_tmp325__length1 = nv_length1;
																																				_tmp326_ = _tmp325_[1];
																																				_tmp327_ = vala_gidl_parser_eval (self, _tmp326_);
																																				_tmp328_ = _tmp327_;
																																				_tmp329_ = vala_gidl_parser_get_container_from_name (self, _tmp328_);
																																				_vala_code_node_unref0 (container);
																																				container = _tmp329_;
																																				_g_free0 (_tmp328_);
																																				_tmp330_ = container;
																																				_tmp331_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp330_);
																																				prefix = _tmp331_;
																																				_tmp332_ = prefix;
																																				if (g_str_has_prefix (symbol, _tmp332_)) {
																																					ValaMethod* _tmp333_;
																																					const gchar* _tmp334_;
																																					gint _tmp335_;
																																					gint _tmp336_;
																																					gchar* _tmp337_;
																																					gchar* _tmp338_;
																																					_tmp333_ = m;
																																					_tmp334_ = prefix;
																																					_tmp335_ = strlen (_tmp334_);
																																					_tmp336_ = _tmp335_;
																																					_tmp337_ = string_substring (symbol, (glong) _tmp336_, (glong) -1);
																																					_tmp338_ = _tmp337_;
																																					vala_symbol_set_name ((ValaSymbol*) _tmp333_, _tmp338_);
																																					_g_free0 (_tmp338_);
																																				}
																																				_g_free0 (prefix);
																																			} else {
																																				gchar** _tmp339_;
																																				gint _tmp339__length1;
																																				const gchar* _tmp340_;
																																				_tmp339_ = nv;
																																				_tmp339__length1 = nv_length1;
																																				_tmp340_ = _tmp339_[0];
																																				if (g_strcmp0 (_tmp340_, "experimental") == 0) {
																																					gchar** _tmp341_;
																																					gint _tmp341__length1;
																																					const gchar* _tmp342_;
																																					gchar* _tmp343_;
																																					gchar* _tmp344_;
																																					gboolean _tmp345_;
																																					_tmp341_ = nv;
																																					_tmp341__length1 = nv_length1;
																																					_tmp342_ = _tmp341_[1];
																																					_tmp343_ = vala_gidl_parser_eval (self, _tmp342_);
																																					_tmp344_ = _tmp343_;
																																					_tmp345_ = g_strcmp0 (_tmp344_, "1") == 0;
																																					_g_free0 (_tmp344_);
																																					if (_tmp345_) {
																																						ValaMethod* _tmp346_;
																																						_tmp346_ = m;
																																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp346_, "Version", "experimental", TRUE, NULL);
																																					}
																																				} else {
																																					gchar** _tmp347_;
																																					gint _tmp347__length1;
																																					const gchar* _tmp348_;
																																					_tmp347_ = nv;
																																					_tmp347__length1 = nv_length1;
																																					_tmp348_ = _tmp347_[0];
																																					if (g_strcmp0 (_tmp348_, "simple_generics") == 0) {
																																						gchar** _tmp349_;
																																						gint _tmp349__length1;
																																						const gchar* _tmp350_;
																																						gchar* _tmp351_;
																																						gchar* _tmp352_;
																																						gboolean _tmp353_;
																																						_tmp349_ = nv;
																																						_tmp349__length1 = nv_length1;
																																						_tmp350_ = _tmp349_[1];
																																						_tmp351_ = vala_gidl_parser_eval (self, _tmp350_);
																																						_tmp352_ = _tmp351_;
																																						_tmp353_ = g_strcmp0 (_tmp352_, "1") == 0;
																																						_g_free0 (_tmp352_);
																																						if (_tmp353_) {
																																							ValaMethod* _tmp354_;
																																							_tmp354_ = m;
																																							vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp354_, "CCode", "simple_generics", TRUE, NULL);
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp355_;
				gboolean _tmp411_ = FALSE;
				GIdlNodeParam* _tmp412_;
				GIdlNodeType* _tmp413_;
				const gchar* _tmp414_;
				gboolean _tmp420_ = FALSE;
				gchar* param_name = NULL;
				GIdlNode* _tmp428_;
				const gchar* _tmp429_;
				gchar* _tmp430_;
				const gchar* _tmp431_;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type = NULL;
				GIdlNodeParam* _tmp435_;
				ValaParameterDirection _tmp436_ = 0;
				ValaDataType* _tmp437_;
				ValaParameter* p = NULL;
				const gchar* _tmp438_;
				ValaDataType* _tmp439_;
				ValaSourceReference* _tmp440_;
				ValaParameter* _tmp441_;
				ValaParameter* _tmp442_;
				gboolean hide_param = FALSE;
				gboolean show_param = FALSE;
				gboolean set_array_length_pos = FALSE;
				gdouble array_length_pos = 0.0;
				gboolean set_delegate_target_pos = FALSE;
				gdouble delegate_target_pos = 0.0;
				gboolean array_requested = FALSE;
				gboolean out_requested = FALSE;
				GIdlNode* _tmp443_;
				const gchar* _tmp444_;
				gchar* _tmp445_;
				gchar* _tmp446_;
				gint _tmp447_ = 0;
				gchar** _tmp448_;
				gchar** _tmp449_;
				gint _tmp449__length1;
				gboolean _tmp712_ = FALSE;
				ValaParameter* _tmp713_;
				gboolean _tmp737_ = FALSE;
				ValaParameter* _tmp742_;
				ValaParameter* _tmp743_;
				ValaDataType* _tmp744_;
				ValaDataType* _tmp745_;
				_tmp355_ = param;
				param_node = (GIdlNode*) _tmp355_;
				if (first) {
					gboolean _tmp356_ = FALSE;
					gboolean _tmp357_ = FALSE;
					gboolean _tmp358_ = FALSE;
					ValaMethod* _tmp359_;
					first = FALSE;
					_tmp359_ = m;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp359_, VALA_TYPE_CREATION_METHOD)) {
						ValaTypeSymbol* _tmp360_;
						_tmp360_ = self->priv->current_data_type;
						_tmp358_ = _tmp360_ != NULL;
					} else {
						_tmp358_ = FALSE;
					}
					if (_tmp358_) {
						GIdlNodeParam* _tmp361_;
						GIdlNodeType* _tmp362_;
						_tmp361_ = param;
						_tmp362_ = _tmp361_->type;
						_tmp357_ = _tmp362_->is_interface;
					} else {
						_tmp357_ = FALSE;
					}
					if (_tmp357_) {
						gboolean _tmp363_ = FALSE;
						GIdlNode* _tmp364_;
						const gchar* _tmp365_;
						_tmp364_ = param_node;
						_tmp365_ = _tmp364_->name;
						if (g_strcmp0 (_tmp365_, "self") == 0) {
							_tmp363_ = TRUE;
						} else {
							GIdlNodeParam* _tmp366_;
							GIdlNodeType* _tmp367_;
							const gchar* _tmp368_;
							ValaTypeSymbol* _tmp369_;
							gchar* _tmp370_;
							gchar* _tmp371_;
							_tmp366_ = param;
							_tmp367_ = _tmp366_->type;
							_tmp368_ = _tmp367_->interface;
							_tmp369_ = self->priv->current_data_type;
							_tmp370_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp369_, NULL);
							_tmp371_ = _tmp370_;
							_tmp363_ = g_str_has_suffix (_tmp368_, _tmp371_);
							_g_free0 (_tmp371_);
						}
						_tmp356_ = _tmp363_;
					} else {
						_tmp356_ = FALSE;
					}
					if (_tmp356_) {
						continue;
					} else {
						gboolean _tmp372_ = FALSE;
						gboolean _tmp373_ = FALSE;
						gboolean _tmp374_ = FALSE;
						ValaMethod* _tmp375_;
						_tmp375_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp375_, VALA_TYPE_CREATION_METHOD)) {
							ValaTypeSymbol* _tmp376_;
							_tmp376_ = self->priv->current_data_type;
							_tmp374_ = _tmp376_ != NULL;
						} else {
							_tmp374_ = FALSE;
						}
						if (_tmp374_) {
							GIdlNodeParam* _tmp377_;
							GIdlNodeType* _tmp378_;
							_tmp377_ = param;
							_tmp378_ = _tmp377_->type;
							_tmp373_ = _tmp378_->is_interface;
						} else {
							_tmp373_ = FALSE;
						}
						if (_tmp373_) {
							gboolean _tmp379_ = FALSE;
							GIdlNode* _tmp380_;
							const gchar* _tmp381_;
							_tmp380_ = param_node;
							_tmp381_ = _tmp380_->name;
							if (g_strcmp0 (_tmp381_, "klass") == 0) {
								_tmp379_ = TRUE;
							} else {
								GIdlNodeParam* _tmp382_;
								GIdlNodeType* _tmp383_;
								const gchar* _tmp384_;
								ValaTypeSymbol* _tmp385_;
								gchar* _tmp386_;
								gchar* _tmp387_;
								gchar* _tmp388_;
								gchar* _tmp389_;
								_tmp382_ = param;
								_tmp383_ = _tmp382_->type;
								_tmp384_ = _tmp383_->interface;
								_tmp385_ = self->priv->current_data_type;
								_tmp386_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp385_, NULL);
								_tmp387_ = _tmp386_;
								_tmp388_ = g_strdup_printf ("%sClass", _tmp387_);
								_tmp389_ = _tmp388_;
								_tmp379_ = g_str_has_suffix (_tmp384_, _tmp389_);
								_g_free0 (_tmp389_);
								_g_free0 (_tmp387_);
							}
							_tmp372_ = _tmp379_;
						} else {
							_tmp372_ = FALSE;
						}
						if (_tmp372_) {
							ValaMethod* _tmp390_;
							ValaMethod* _tmp391_;
							const gchar* _tmp392_;
							const gchar* _tmp393_;
							_tmp390_ = m;
							vala_method_set_binding (_tmp390_, VALA_MEMBER_BINDING_CLASS);
							_tmp391_ = m;
							_tmp392_ = vala_symbol_get_name ((ValaSymbol*) _tmp391_);
							_tmp393_ = _tmp392_;
							if (g_str_has_prefix (_tmp393_, "class_")) {
								ValaMethod* _tmp394_;
								ValaMethod* _tmp395_;
								const gchar* _tmp396_;
								const gchar* _tmp397_;
								gint _tmp398_;
								gint _tmp399_;
								ValaMethod* _tmp400_;
								const gchar* _tmp401_;
								const gchar* _tmp402_;
								gint _tmp403_;
								gint _tmp404_;
								gint _tmp405_;
								gint _tmp406_;
								gchar* _tmp407_;
								gchar* _tmp408_;
								_tmp394_ = m;
								_tmp395_ = m;
								_tmp396_ = vala_symbol_get_name ((ValaSymbol*) _tmp395_);
								_tmp397_ = _tmp396_;
								_tmp398_ = strlen ("class_");
								_tmp399_ = _tmp398_;
								_tmp400_ = m;
								_tmp401_ = vala_symbol_get_name ((ValaSymbol*) _tmp400_);
								_tmp402_ = _tmp401_;
								_tmp403_ = strlen (_tmp402_);
								_tmp404_ = _tmp403_;
								_tmp405_ = strlen ("class_");
								_tmp406_ = _tmp405_;
								_tmp407_ = string_substring (_tmp397_, (glong) _tmp399_, (glong) (_tmp404_ - _tmp406_));
								_tmp408_ = _tmp407_;
								vala_symbol_set_name ((ValaSymbol*) _tmp394_, _tmp408_);
								_g_free0 (_tmp408_);
							}
							continue;
						} else {
							ValaMethod* _tmp409_;
							_tmp409_ = m;
							if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp409_, VALA_TYPE_CREATION_METHOD)) {
								ValaMethod* _tmp410_;
								_tmp410_ = m;
								vala_method_set_binding (_tmp410_, VALA_MEMBER_BINDING_STATIC);
							}
						}
					}
				}
				_tmp412_ = param;
				_tmp413_ = _tmp412_->type;
				_tmp414_ = _tmp413_->interface;
				if (g_strcmp0 (_tmp414_, "GAsyncReadyCallback") == 0) {
					gboolean _tmp415_ = FALSE;
					if (g_str_has_suffix (symbol, "_async")) {
						_tmp415_ = TRUE;
					} else {
						ValaMethod* _tmp416_;
						gboolean _tmp417_;
						gboolean _tmp418_;
						_tmp416_ = m;
						_tmp417_ = vala_method_get_coroutine (_tmp416_);
						_tmp418_ = _tmp417_;
						_tmp415_ = _tmp418_;
					}
					_tmp411_ = _tmp415_;
				} else {
					_tmp411_ = FALSE;
				}
				if (_tmp411_) {
					ValaMethod* _tmp419_;
					_tmp419_ = m;
					vala_method_set_coroutine (_tmp419_, TRUE);
					continue;
				}
				if (suppress_throws == FALSE) {
					GIdlNodeParam* _tmp421_;
					_tmp421_ = param;
					_tmp420_ = vala_gidl_parser_param_is_exception (self, _tmp421_);
				} else {
					_tmp420_ = FALSE;
				}
				if (_tmp420_) {
					const gchar* _tmp422_;
					_tmp422_ = error_types;
					if (_tmp422_ == NULL) {
						ValaMethod* _tmp423_;
						GIdlNodeParam* _tmp424_;
						GIdlNodeType* _tmp425_;
						ValaDataType* _tmp426_;
						ValaDataType* _tmp427_;
						_tmp423_ = m;
						_tmp424_ = param;
						_tmp425_ = _tmp424_->type;
						_tmp426_ = vala_gidl_parser_parse_type (self, _tmp425_, NULL);
						_tmp427_ = _tmp426_;
						vala_method_add_error_type (_tmp423_, _tmp427_);
						_vala_code_node_unref0 (_tmp427_);
					}
					continue;
				}
				_tmp428_ = param_node;
				_tmp429_ = _tmp428_->name;
				_tmp430_ = g_strdup (_tmp429_);
				param_name = _tmp430_;
				_tmp431_ = param_name;
				if (g_strcmp0 (_tmp431_, "result") == 0) {
					gchar* _tmp432_;
					_tmp432_ = g_strdup ("_result");
					_g_free0 (param_name);
					param_name = _tmp432_;
				} else {
					const gchar* _tmp433_;
					_tmp433_ = param_name;
					if (g_strcmp0 (_tmp433_, "string") == 0) {
						gchar* _tmp434_;
						_tmp434_ = g_strdup ("str");
						_g_free0 (param_name);
						param_name = _tmp434_;
					}
				}
				_tmp435_ = param;
				_tmp437_ = vala_gidl_parser_parse_param (self, _tmp435_, &_tmp436_);
				direction = _tmp436_;
				param_type = _tmp437_;
				_tmp438_ = param_name;
				_tmp439_ = param_type;
				_tmp440_ = self->priv->current_source_reference;
				_tmp441_ = vala_parameter_new (_tmp438_, _tmp439_, _tmp440_);
				p = _tmp441_;
				_tmp442_ = p;
				vala_parameter_set_direction (_tmp442_, direction);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (gdouble) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (gdouble) 0;
				array_requested = FALSE;
				out_requested = FALSE;
				_tmp443_ = param_node;
				_tmp444_ = _tmp443_->name;
				_tmp445_ = g_strdup_printf ("%s.%s", symbol, _tmp444_);
				_tmp446_ = _tmp445_;
				_tmp448_ = vala_gidl_parser_get_attributes (self, _tmp446_, &_tmp447_);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes = _tmp448_;
				attributes_length1 = _tmp447_;
				_attributes_size_ = attributes_length1;
				_g_free0 (_tmp446_);
				_tmp449_ = attributes;
				_tmp449__length1 = attributes_length1;
				if (_tmp449_ != NULL) {
					gchar** _tmp450_;
					gint _tmp450__length1;
					_tmp450_ = attributes;
					_tmp450__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp450_;
						attr_collection_length1 = _tmp450__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp451_;
							gchar* attr = NULL;
							_tmp451_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp451_;
							{
								gchar** nv = NULL;
								const gchar* _tmp452_;
								gchar** _tmp453_;
								gchar** _tmp454_;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp455_;
								gint _tmp455__length1;
								const gchar* _tmp456_;
								_tmp452_ = attr;
								_tmp454_ = _tmp453_ = g_strsplit (_tmp452_, "=", 2);
								nv = _tmp454_;
								nv_length1 = _vala_array_length (_tmp453_);
								_nv_size_ = nv_length1;
								_tmp455_ = nv;
								_tmp455__length1 = nv_length1;
								_tmp456_ = _tmp455_[0];
								if (g_strcmp0 (_tmp456_, "is_array") == 0) {
									gchar** _tmp457_;
									gint _tmp457__length1;
									const gchar* _tmp458_;
									gchar* _tmp459_;
									gchar* _tmp460_;
									gboolean _tmp461_;
									_tmp457_ = nv;
									_tmp457__length1 = nv_length1;
									_tmp458_ = _tmp457_[1];
									_tmp459_ = vala_gidl_parser_eval (self, _tmp458_);
									_tmp460_ = _tmp459_;
									_tmp461_ = g_strcmp0 (_tmp460_, "1") == 0;
									_g_free0 (_tmp460_);
									if (_tmp461_) {
										ValaDataType* _tmp462_;
										ValaDataType* _tmp463_;
										ValaDataType* _tmp464_;
										ValaSourceReference* _tmp465_;
										ValaSourceReference* _tmp466_;
										ValaArrayType* _tmp467_;
										ValaParameter* _tmp468_;
										ValaDataType* _tmp469_;
										_tmp462_ = param_type;
										vala_data_type_set_value_owned (_tmp462_, TRUE);
										_tmp463_ = param_type;
										_tmp464_ = param_type;
										_tmp465_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp464_);
										_tmp466_ = _tmp465_;
										_tmp467_ = vala_array_type_new (_tmp463_, 1, _tmp466_);
										_vala_code_node_unref0 (param_type);
										param_type = (ValaDataType*) _tmp467_;
										_tmp468_ = p;
										_tmp469_ = param_type;
										vala_variable_set_variable_type ((ValaVariable*) _tmp468_, _tmp469_);
										if (!out_requested) {
											ValaParameter* _tmp470_;
											_tmp470_ = p;
											vala_parameter_set_direction (_tmp470_, VALA_PARAMETER_DIRECTION_IN);
										}
										array_requested = TRUE;
									}
								} else {
									gchar** _tmp471_;
									gint _tmp471__length1;
									const gchar* _tmp472_;
									_tmp471_ = nv;
									_tmp471__length1 = nv_length1;
									_tmp472_ = _tmp471_[0];
									if (g_strcmp0 (_tmp472_, "is_pointer") == 0) {
										gchar** _tmp473_;
										gint _tmp473__length1;
										const gchar* _tmp474_;
										gchar* _tmp475_;
										gchar* _tmp476_;
										gboolean _tmp477_;
										_tmp473_ = nv;
										_tmp473__length1 = nv_length1;
										_tmp474_ = _tmp473_[1];
										_tmp475_ = vala_gidl_parser_eval (self, _tmp474_);
										_tmp476_ = _tmp475_;
										_tmp477_ = g_strcmp0 (_tmp476_, "1") == 0;
										_g_free0 (_tmp476_);
										if (_tmp477_) {
											ValaDataType* _tmp478_;
											ValaDataType* _tmp479_;
											ValaSourceReference* _tmp480_;
											ValaSourceReference* _tmp481_;
											ValaPointerType* _tmp482_;
											ValaParameter* _tmp483_;
											ValaDataType* _tmp484_;
											_tmp478_ = param_type;
											_tmp479_ = return_type;
											_tmp480_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp479_);
											_tmp481_ = _tmp480_;
											_tmp482_ = vala_pointer_type_new (_tmp478_, _tmp481_);
											_vala_code_node_unref0 (param_type);
											param_type = (ValaDataType*) _tmp482_;
											_tmp483_ = p;
											_tmp484_ = param_type;
											vala_variable_set_variable_type ((ValaVariable*) _tmp483_, _tmp484_);
											if (!out_requested) {
												ValaParameter* _tmp485_;
												_tmp485_ = p;
												vala_parameter_set_direction (_tmp485_, VALA_PARAMETER_DIRECTION_IN);
											}
										}
									} else {
										gchar** _tmp486_;
										gint _tmp486__length1;
										const gchar* _tmp487_;
										_tmp486_ = nv;
										_tmp486__length1 = nv_length1;
										_tmp487_ = _tmp486_[0];
										if (g_strcmp0 (_tmp487_, "is_out") == 0) {
											gchar** _tmp488_;
											gint _tmp488__length1;
											const gchar* _tmp489_;
											gchar* _tmp490_;
											gchar* _tmp491_;
											gboolean _tmp492_;
											_tmp488_ = nv;
											_tmp488__length1 = nv_length1;
											_tmp489_ = _tmp488_[1];
											_tmp490_ = vala_gidl_parser_eval (self, _tmp489_);
											_tmp491_ = _tmp490_;
											_tmp492_ = g_strcmp0 (_tmp491_, "1") == 0;
											_g_free0 (_tmp491_);
											if (_tmp492_) {
												ValaParameter* _tmp493_;
												gboolean _tmp494_ = FALSE;
												_tmp493_ = p;
												vala_parameter_set_direction (_tmp493_, VALA_PARAMETER_DIRECTION_OUT);
												out_requested = TRUE;
												if (!array_requested) {
													ValaDataType* _tmp495_;
													_tmp495_ = param_type;
													_tmp494_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp495_, VALA_TYPE_ARRAY_TYPE);
												} else {
													_tmp494_ = FALSE;
												}
												if (_tmp494_) {
													ValaArrayType* array_type = NULL;
													ValaDataType* _tmp496_;
													ValaArrayType* _tmp497_;
													ValaArrayType* _tmp498_;
													ValaDataType* _tmp499_;
													ValaDataType* _tmp500_;
													ValaDataType* _tmp501_;
													ValaParameter* _tmp502_;
													ValaDataType* _tmp503_;
													_tmp496_ = param_type;
													_tmp497_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp496_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
													array_type = _tmp497_;
													_tmp498_ = array_type;
													_tmp499_ = vala_array_type_get_element_type (_tmp498_);
													_tmp500_ = _tmp499_;
													_tmp501_ = _vala_code_node_ref0 (_tmp500_);
													_vala_code_node_unref0 (param_type);
													param_type = _tmp501_;
													_tmp502_ = p;
													_tmp503_ = param_type;
													vala_variable_set_variable_type ((ValaVariable*) _tmp502_, _tmp503_);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											gchar** _tmp504_;
											gint _tmp504__length1;
											const gchar* _tmp505_;
											_tmp504_ = nv;
											_tmp504__length1 = nv_length1;
											_tmp505_ = _tmp504_[0];
											if (g_strcmp0 (_tmp505_, "is_ref") == 0) {
												gchar** _tmp506_;
												gint _tmp506__length1;
												const gchar* _tmp507_;
												gchar* _tmp508_;
												gchar* _tmp509_;
												gboolean _tmp510_;
												_tmp506_ = nv;
												_tmp506__length1 = nv_length1;
												_tmp507_ = _tmp506_[1];
												_tmp508_ = vala_gidl_parser_eval (self, _tmp507_);
												_tmp509_ = _tmp508_;
												_tmp510_ = g_strcmp0 (_tmp509_, "1") == 0;
												_g_free0 (_tmp509_);
												if (_tmp510_) {
													ValaParameter* _tmp511_;
													gboolean _tmp512_ = FALSE;
													_tmp511_ = p;
													vala_parameter_set_direction (_tmp511_, VALA_PARAMETER_DIRECTION_REF);
													if (!array_requested) {
														ValaDataType* _tmp513_;
														_tmp513_ = param_type;
														_tmp512_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp513_, VALA_TYPE_ARRAY_TYPE);
													} else {
														_tmp512_ = FALSE;
													}
													if (_tmp512_) {
														ValaArrayType* array_type = NULL;
														ValaDataType* _tmp514_;
														ValaArrayType* _tmp515_;
														ValaArrayType* _tmp516_;
														ValaDataType* _tmp517_;
														ValaDataType* _tmp518_;
														ValaDataType* _tmp519_;
														ValaParameter* _tmp520_;
														ValaDataType* _tmp521_;
														_tmp514_ = param_type;
														_tmp515_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp514_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
														array_type = _tmp515_;
														_tmp516_ = array_type;
														_tmp517_ = vala_array_type_get_element_type (_tmp516_);
														_tmp518_ = _tmp517_;
														_tmp519_ = _vala_code_node_ref0 (_tmp518_);
														_vala_code_node_unref0 (param_type);
														param_type = _tmp519_;
														_tmp520_ = p;
														_tmp521_ = param_type;
														vala_variable_set_variable_type ((ValaVariable*) _tmp520_, _tmp521_);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												gchar** _tmp522_;
												gint _tmp522__length1;
												const gchar* _tmp523_;
												_tmp522_ = nv;
												_tmp522__length1 = nv_length1;
												_tmp523_ = _tmp522_[0];
												if (g_strcmp0 (_tmp523_, "nullable") == 0) {
													gboolean _tmp524_ = FALSE;
													gchar** _tmp525_;
													gint _tmp525__length1;
													const gchar* _tmp526_;
													gchar* _tmp527_;
													gchar* _tmp528_;
													gboolean _tmp529_;
													_tmp525_ = nv;
													_tmp525__length1 = nv_length1;
													_tmp526_ = _tmp525_[1];
													_tmp527_ = vala_gidl_parser_eval (self, _tmp526_);
													_tmp528_ = _tmp527_;
													_tmp529_ = g_strcmp0 (_tmp528_, "1") == 0;
													_g_free0 (_tmp528_);
													if (_tmp529_) {
														ValaDataType* _tmp530_;
														_tmp530_ = param_type;
														_tmp524_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp530_, VALA_TYPE_VOID_TYPE);
													} else {
														_tmp524_ = FALSE;
													}
													if (_tmp524_) {
														ValaDataType* _tmp531_;
														_tmp531_ = param_type;
														vala_data_type_set_nullable (_tmp531_, TRUE);
													}
												} else {
													gchar** _tmp532_;
													gint _tmp532__length1;
													const gchar* _tmp533_;
													_tmp532_ = nv;
													_tmp532__length1 = nv_length1;
													_tmp533_ = _tmp532_[0];
													if (g_strcmp0 (_tmp533_, "transfer_ownership") == 0) {
														gchar** _tmp534_;
														gint _tmp534__length1;
														const gchar* _tmp535_;
														gchar* _tmp536_;
														gchar* _tmp537_;
														gboolean _tmp538_;
														_tmp534_ = nv;
														_tmp534__length1 = nv_length1;
														_tmp535_ = _tmp534_[1];
														_tmp536_ = vala_gidl_parser_eval (self, _tmp535_);
														_tmp537_ = _tmp536_;
														_tmp538_ = g_strcmp0 (_tmp537_, "1") == 0;
														_g_free0 (_tmp537_);
														if (_tmp538_) {
															ValaDataType* _tmp539_;
															_tmp539_ = param_type;
															vala_data_type_set_value_owned (_tmp539_, TRUE);
														}
													} else {
														gchar** _tmp540_;
														gint _tmp540__length1;
														const gchar* _tmp541_;
														_tmp540_ = nv;
														_tmp540__length1 = nv_length1;
														_tmp541_ = _tmp540_[0];
														if (g_strcmp0 (_tmp541_, "takes_ownership") == 0) {
															gchar** _tmp542_;
															gint _tmp542__length1;
															const gchar* _tmp543_;
															gchar* _tmp544_;
															gchar* _tmp545_;
															gboolean _tmp546_;
															_tmp542_ = nv;
															_tmp542__length1 = nv_length1;
															_tmp543_ = _tmp542_[1];
															_tmp544_ = vala_gidl_parser_eval (self, _tmp543_);
															_tmp545_ = _tmp544_;
															_tmp546_ = g_strcmp0 (_tmp545_, "1") == 0;
															_g_free0 (_tmp545_);
															if (_tmp546_) {
																ValaDataType* _tmp547_;
																_tmp547_ = param_type;
																vala_data_type_set_value_owned (_tmp547_, TRUE);
															}
														} else {
															gchar** _tmp548_;
															gint _tmp548__length1;
															const gchar* _tmp549_;
															_tmp548_ = nv;
															_tmp548__length1 = nv_length1;
															_tmp549_ = _tmp548_[0];
															if (g_strcmp0 (_tmp549_, "value_owned") == 0) {
																gchar** _tmp550_;
																gint _tmp550__length1;
																const gchar* _tmp551_;
																gchar* _tmp552_;
																gchar* _tmp553_;
																gboolean _tmp554_;
																_tmp550_ = nv;
																_tmp550__length1 = nv_length1;
																_tmp551_ = _tmp550_[1];
																_tmp552_ = vala_gidl_parser_eval (self, _tmp551_);
																_tmp553_ = _tmp552_;
																_tmp554_ = g_strcmp0 (_tmp553_, "0") == 0;
																_g_free0 (_tmp553_);
																if (_tmp554_) {
																	ValaDataType* _tmp555_;
																	_tmp555_ = param_type;
																	vala_data_type_set_value_owned (_tmp555_, FALSE);
																} else {
																	gchar** _tmp556_;
																	gint _tmp556__length1;
																	const gchar* _tmp557_;
																	gchar* _tmp558_;
																	gchar* _tmp559_;
																	gboolean _tmp560_;
																	_tmp556_ = nv;
																	_tmp556__length1 = nv_length1;
																	_tmp557_ = _tmp556_[1];
																	_tmp558_ = vala_gidl_parser_eval (self, _tmp557_);
																	_tmp559_ = _tmp558_;
																	_tmp560_ = g_strcmp0 (_tmp559_, "1") == 0;
																	_g_free0 (_tmp559_);
																	if (_tmp560_) {
																		ValaDataType* _tmp561_;
																		_tmp561_ = param_type;
																		vala_data_type_set_value_owned (_tmp561_, TRUE);
																	}
																}
															} else {
																gchar** _tmp562_;
																gint _tmp562__length1;
																const gchar* _tmp563_;
																_tmp562_ = nv;
																_tmp562__length1 = nv_length1;
																_tmp563_ = _tmp562_[0];
																if (g_strcmp0 (_tmp563_, "hidden") == 0) {
																	gchar** _tmp564_;
																	gint _tmp564__length1;
																	const gchar* _tmp565_;
																	gchar* _tmp566_;
																	gchar* _tmp567_;
																	gboolean _tmp568_;
																	_tmp564_ = nv;
																	_tmp564__length1 = nv_length1;
																	_tmp565_ = _tmp564_[1];
																	_tmp566_ = vala_gidl_parser_eval (self, _tmp565_);
																	_tmp567_ = _tmp566_;
																	_tmp568_ = g_strcmp0 (_tmp567_, "1") == 0;
																	_g_free0 (_tmp567_);
																	if (_tmp568_) {
																		hide_param = TRUE;
																	} else {
																		gchar** _tmp569_;
																		gint _tmp569__length1;
																		const gchar* _tmp570_;
																		gchar* _tmp571_;
																		gchar* _tmp572_;
																		gboolean _tmp573_;
																		_tmp569_ = nv;
																		_tmp569__length1 = nv_length1;
																		_tmp570_ = _tmp569_[1];
																		_tmp571_ = vala_gidl_parser_eval (self, _tmp570_);
																		_tmp572_ = _tmp571_;
																		_tmp573_ = g_strcmp0 (_tmp572_, "0") == 0;
																		_g_free0 (_tmp572_);
																		if (_tmp573_) {
																			show_param = TRUE;
																		}
																	}
																} else {
																	gchar** _tmp574_;
																	gint _tmp574__length1;
																	const gchar* _tmp575_;
																	_tmp574_ = nv;
																	_tmp574__length1 = nv_length1;
																	_tmp575_ = _tmp574_[0];
																	if (g_strcmp0 (_tmp575_, "no_array_length") == 0) {
																		gchar** _tmp576_;
																		gint _tmp576__length1;
																		const gchar* _tmp577_;
																		gchar* _tmp578_;
																		gchar* _tmp579_;
																		gboolean _tmp580_;
																		_tmp576_ = nv;
																		_tmp576__length1 = nv_length1;
																		_tmp577_ = _tmp576_[1];
																		_tmp578_ = vala_gidl_parser_eval (self, _tmp577_);
																		_tmp579_ = _tmp578_;
																		_tmp580_ = g_strcmp0 (_tmp579_, "1") == 0;
																		_g_free0 (_tmp579_);
																		if (_tmp580_) {
																			ValaParameter* _tmp581_;
																			_tmp581_ = p;
																			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp581_, "CCode", "array_length", FALSE, NULL);
																		}
																	} else {
																		gchar** _tmp582_;
																		gint _tmp582__length1;
																		const gchar* _tmp583_;
																		_tmp582_ = nv;
																		_tmp582__length1 = nv_length1;
																		_tmp583_ = _tmp582_[0];
																		if (g_strcmp0 (_tmp583_, "array_length_type") == 0) {
																			ValaParameter* _tmp584_;
																			gchar** _tmp585_;
																			gint _tmp585__length1;
																			const gchar* _tmp586_;
																			gchar* _tmp587_;
																			gchar* _tmp588_;
																			_tmp584_ = p;
																			_tmp585_ = nv;
																			_tmp585__length1 = nv_length1;
																			_tmp586_ = _tmp585_[1];
																			_tmp587_ = vala_gidl_parser_eval (self, _tmp586_);
																			_tmp588_ = _tmp587_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp584_, "CCode", "array_length_type", _tmp588_, NULL);
																			_g_free0 (_tmp588_);
																		} else {
																			gchar** _tmp589_;
																			gint _tmp589__length1;
																			const gchar* _tmp590_;
																			_tmp589_ = nv;
																			_tmp589__length1 = nv_length1;
																			_tmp590_ = _tmp589_[0];
																			if (g_strcmp0 (_tmp590_, "array_null_terminated") == 0) {
																				gchar** _tmp591_;
																				gint _tmp591__length1;
																				const gchar* _tmp592_;
																				gchar* _tmp593_;
																				gchar* _tmp594_;
																				gboolean _tmp595_;
																				_tmp591_ = nv;
																				_tmp591__length1 = nv_length1;
																				_tmp592_ = _tmp591_[1];
																				_tmp593_ = vala_gidl_parser_eval (self, _tmp592_);
																				_tmp594_ = _tmp593_;
																				_tmp595_ = g_strcmp0 (_tmp594_, "1") == 0;
																				_g_free0 (_tmp594_);
																				if (_tmp595_) {
																					ValaParameter* _tmp596_;
																					ValaParameter* _tmp597_;
																					_tmp596_ = p;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp596_, "CCode", "array_length", FALSE, NULL);
																					_tmp597_ = p;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp597_, "CCode", "array_null_terminated", TRUE, NULL);
																				}
																			} else {
																				gchar** _tmp598_;
																				gint _tmp598__length1;
																				const gchar* _tmp599_;
																				_tmp598_ = nv;
																				_tmp598__length1 = nv_length1;
																				_tmp599_ = _tmp598_[0];
																				if (g_strcmp0 (_tmp599_, "array_length_pos") == 0) {
																					gchar** _tmp600_;
																					gint _tmp600__length1;
																					const gchar* _tmp601_;
																					gchar* _tmp602_;
																					gchar* _tmp603_;
																					set_array_length_pos = TRUE;
																					_tmp600_ = nv;
																					_tmp600__length1 = nv_length1;
																					_tmp601_ = _tmp600_[1];
																					_tmp602_ = vala_gidl_parser_eval (self, _tmp601_);
																					_tmp603_ = _tmp602_;
																					array_length_pos = double_parse (_tmp603_);
																					_g_free0 (_tmp603_);
																				} else {
																					gchar** _tmp604_;
																					gint _tmp604__length1;
																					const gchar* _tmp605_;
																					_tmp604_ = nv;
																					_tmp604__length1 = nv_length1;
																					_tmp605_ = _tmp604_[0];
																					if (g_strcmp0 (_tmp605_, "delegate_target_pos") == 0) {
																						gchar** _tmp606_;
																						gint _tmp606__length1;
																						const gchar* _tmp607_;
																						gchar* _tmp608_;
																						gchar* _tmp609_;
																						set_delegate_target_pos = TRUE;
																						_tmp606_ = nv;
																						_tmp606__length1 = nv_length1;
																						_tmp607_ = _tmp606_[1];
																						_tmp608_ = vala_gidl_parser_eval (self, _tmp607_);
																						_tmp609_ = _tmp608_;
																						delegate_target_pos = double_parse (_tmp609_);
																						_g_free0 (_tmp609_);
																					} else {
																						gchar** _tmp610_;
																						gint _tmp610__length1;
																						const gchar* _tmp611_;
																						_tmp610_ = nv;
																						_tmp610__length1 = nv_length1;
																						_tmp611_ = _tmp610_[0];
																						if (g_strcmp0 (_tmp611_, "type_name") == 0) {
																							ValaParameter* _tmp612_;
																							gchar** _tmp613_;
																							gint _tmp613__length1;
																							const gchar* _tmp614_;
																							gchar* _tmp615_;
																							gchar* _tmp616_;
																							ValaDataType* _tmp617_;
																							ValaDataType* _tmp618_;
																							_tmp612_ = p;
																							_tmp613_ = nv;
																							_tmp613__length1 = nv_length1;
																							_tmp614_ = _tmp613_[1];
																							_tmp615_ = vala_gidl_parser_eval (self, _tmp614_);
																							_tmp616_ = _tmp615_;
																							_tmp617_ = vala_gidl_parser_parse_type_from_string (self, _tmp616_, FALSE, NULL);
																							_vala_code_node_unref0 (param_type);
																							param_type = _tmp617_;
																							_tmp618_ = param_type;
																							vala_variable_set_variable_type ((ValaVariable*) _tmp612_, _tmp618_);
																							_g_free0 (_tmp616_);
																						} else {
																							gchar** _tmp619_;
																							gint _tmp619__length1;
																							const gchar* _tmp620_;
																							_tmp619_ = nv;
																							_tmp619__length1 = nv_length1;
																							_tmp620_ = _tmp619_[0];
																							if (g_strcmp0 (_tmp620_, "ctype") == 0) {
																								ValaParameter* _tmp621_;
																								gchar** _tmp622_;
																								gint _tmp622__length1;
																								const gchar* _tmp623_;
																								gchar* _tmp624_;
																								gchar* _tmp625_;
																								_tmp621_ = p;
																								_tmp622_ = nv;
																								_tmp622__length1 = nv_length1;
																								_tmp623_ = _tmp622_[1];
																								_tmp624_ = vala_gidl_parser_eval (self, _tmp623_);
																								_tmp625_ = _tmp624_;
																								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp621_, "CCode", "type", _tmp625_, NULL);
																								_g_free0 (_tmp625_);
																							} else {
																								gchar** _tmp626_;
																								gint _tmp626__length1;
																								const gchar* _tmp627_;
																								_tmp626_ = nv;
																								_tmp626__length1 = nv_length1;
																								_tmp627_ = _tmp626_[0];
																								if (g_strcmp0 (_tmp627_, "scope") == 0) {
																									ValaParameter* _tmp628_;
																									gchar** _tmp629_;
																									gint _tmp629__length1;
																									const gchar* _tmp630_;
																									gchar* _tmp631_;
																									gchar* _tmp632_;
																									_tmp628_ = p;
																									_tmp629_ = nv;
																									_tmp629__length1 = nv_length1;
																									_tmp630_ = _tmp629_[1];
																									_tmp631_ = vala_gidl_parser_eval (self, _tmp630_);
																									_tmp632_ = _tmp631_;
																									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp628_, "CCode", "scope", _tmp632_, NULL);
																									_g_free0 (_tmp632_);
																								} else {
																									gchar** _tmp633_;
																									gint _tmp633__length1;
																									const gchar* _tmp634_;
																									_tmp633_ = nv;
																									_tmp633__length1 = nv_length1;
																									_tmp634_ = _tmp633_[0];
																									if (g_strcmp0 (_tmp634_, "type_arguments") == 0) {
																										ValaDataType* _tmp635_;
																										gchar** _tmp636_;
																										gint _tmp636__length1;
																										const gchar* _tmp637_;
																										gchar* _tmp638_;
																										gchar* _tmp639_;
																										_tmp635_ = param_type;
																										_tmp636_ = nv;
																										_tmp636__length1 = nv_length1;
																										_tmp637_ = _tmp636_[1];
																										_tmp638_ = vala_gidl_parser_eval (self, _tmp637_);
																										_tmp639_ = _tmp638_;
																										vala_gidl_parser_parse_type_arguments_from_string (self, _tmp635_, _tmp639_, NULL);
																										_g_free0 (_tmp639_);
																									} else {
																										gchar** _tmp640_;
																										gint _tmp640__length1;
																										const gchar* _tmp641_;
																										_tmp640_ = nv;
																										_tmp640__length1 = nv_length1;
																										_tmp641_ = _tmp640_[0];
																										if (g_strcmp0 (_tmp641_, "default_value") == 0) {
																											gchar* val = NULL;
																											gchar** _tmp642_;
																											gint _tmp642__length1;
																											const gchar* _tmp643_;
																											gchar* _tmp644_;
																											const gchar* _tmp645_;
																											_tmp642_ = nv;
																											_tmp642__length1 = nv_length1;
																											_tmp643_ = _tmp642_[1];
																											_tmp644_ = vala_gidl_parser_eval (self, _tmp643_);
																											val = _tmp644_;
																											_tmp645_ = val;
																											if (g_strcmp0 (_tmp645_, "null") == 0) {
																												ValaParameter* _tmp646_;
																												ValaDataType* _tmp647_;
																												ValaSourceReference* _tmp648_;
																												ValaSourceReference* _tmp649_;
																												ValaNullLiteral* _tmp650_;
																												ValaNullLiteral* _tmp651_;
																												_tmp646_ = p;
																												_tmp647_ = param_type;
																												_tmp648_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp647_);
																												_tmp649_ = _tmp648_;
																												_tmp650_ = vala_null_literal_new (_tmp649_);
																												_tmp651_ = _tmp650_;
																												vala_variable_set_initializer ((ValaVariable*) _tmp646_, (ValaExpression*) _tmp651_);
																												_vala_code_node_unref0 (_tmp651_);
																											} else {
																												const gchar* _tmp652_;
																												_tmp652_ = val;
																												if (g_strcmp0 (_tmp652_, "true") == 0) {
																													ValaParameter* _tmp653_;
																													ValaDataType* _tmp654_;
																													ValaSourceReference* _tmp655_;
																													ValaSourceReference* _tmp656_;
																													ValaBooleanLiteral* _tmp657_;
																													ValaBooleanLiteral* _tmp658_;
																													_tmp653_ = p;
																													_tmp654_ = param_type;
																													_tmp655_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp654_);
																													_tmp656_ = _tmp655_;
																													_tmp657_ = vala_boolean_literal_new (TRUE, _tmp656_);
																													_tmp658_ = _tmp657_;
																													vala_variable_set_initializer ((ValaVariable*) _tmp653_, (ValaExpression*) _tmp658_);
																													_vala_code_node_unref0 (_tmp658_);
																												} else {
																													const gchar* _tmp659_;
																													_tmp659_ = val;
																													if (g_strcmp0 (_tmp659_, "false") == 0) {
																														ValaParameter* _tmp660_;
																														ValaDataType* _tmp661_;
																														ValaSourceReference* _tmp662_;
																														ValaSourceReference* _tmp663_;
																														ValaBooleanLiteral* _tmp664_;
																														ValaBooleanLiteral* _tmp665_;
																														_tmp660_ = p;
																														_tmp661_ = param_type;
																														_tmp662_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp661_);
																														_tmp663_ = _tmp662_;
																														_tmp664_ = vala_boolean_literal_new (FALSE, _tmp663_);
																														_tmp665_ = _tmp664_;
																														vala_variable_set_initializer ((ValaVariable*) _tmp660_, (ValaExpression*) _tmp665_);
																														_vala_code_node_unref0 (_tmp665_);
																													} else {
																														const gchar* _tmp666_;
																														_tmp666_ = val;
																														if (g_strcmp0 (_tmp666_, "") == 0) {
																															ValaParameter* _tmp667_;
																															ValaDataType* _tmp668_;
																															ValaSourceReference* _tmp669_;
																															ValaSourceReference* _tmp670_;
																															ValaStringLiteral* _tmp671_;
																															ValaStringLiteral* _tmp672_;
																															_tmp667_ = p;
																															_tmp668_ = param_type;
																															_tmp669_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp668_);
																															_tmp670_ = _tmp669_;
																															_tmp671_ = vala_string_literal_new ("\"\"", _tmp670_);
																															_tmp672_ = _tmp671_;
																															vala_variable_set_initializer ((ValaVariable*) _tmp667_, (ValaExpression*) _tmp672_);
																															_vala_code_node_unref0 (_tmp672_);
																														} else {
																															const gchar* _tmp673_;
																															_tmp673_ = val;
																															if (int64_try_parse (_tmp673_, NULL, NULL, (guint) 0)) {
																																ValaParameter* _tmp674_;
																																const gchar* _tmp675_;
																																ValaDataType* _tmp676_;
																																ValaSourceReference* _tmp677_;
																																ValaSourceReference* _tmp678_;
																																ValaIntegerLiteral* _tmp679_;
																																ValaIntegerLiteral* _tmp680_;
																																_tmp674_ = p;
																																_tmp675_ = val;
																																_tmp676_ = param_type;
																																_tmp677_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp676_);
																																_tmp678_ = _tmp677_;
																																_tmp679_ = vala_integer_literal_new (_tmp675_, _tmp678_);
																																_tmp680_ = _tmp679_;
																																vala_variable_set_initializer ((ValaVariable*) _tmp674_, (ValaExpression*) _tmp680_);
																																_vala_code_node_unref0 (_tmp680_);
																															} else {
																																const gchar* _tmp681_;
																																_tmp681_ = val;
																																if (double_try_parse (_tmp681_, NULL, NULL)) {
																																	ValaParameter* _tmp682_;
																																	const gchar* _tmp683_;
																																	ValaDataType* _tmp684_;
																																	ValaSourceReference* _tmp685_;
																																	ValaSourceReference* _tmp686_;
																																	ValaRealLiteral* _tmp687_;
																																	ValaRealLiteral* _tmp688_;
																																	_tmp682_ = p;
																																	_tmp683_ = val;
																																	_tmp684_ = param_type;
																																	_tmp685_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp684_);
																																	_tmp686_ = _tmp685_;
																																	_tmp687_ = vala_real_literal_new (_tmp683_, _tmp686_);
																																	_tmp688_ = _tmp687_;
																																	vala_variable_set_initializer ((ValaVariable*) _tmp682_, (ValaExpression*) _tmp688_);
																																	_vala_code_node_unref0 (_tmp688_);
																																} else {
																																	gboolean _tmp689_ = FALSE;
																																	const gchar* _tmp690_;
																																	_tmp690_ = val;
																																	if (g_str_has_prefix (_tmp690_, "\"")) {
																																		const gchar* _tmp691_;
																																		_tmp691_ = val;
																																		_tmp689_ = g_str_has_suffix (_tmp691_, "\"");
																																	} else {
																																		_tmp689_ = FALSE;
																																	}
																																	if (_tmp689_) {
																																		ValaParameter* _tmp692_;
																																		const gchar* _tmp693_;
																																		ValaDataType* _tmp694_;
																																		ValaSourceReference* _tmp695_;
																																		ValaSourceReference* _tmp696_;
																																		ValaStringLiteral* _tmp697_;
																																		ValaStringLiteral* _tmp698_;
																																		_tmp692_ = p;
																																		_tmp693_ = val;
																																		_tmp694_ = param_type;
																																		_tmp695_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp694_);
																																		_tmp696_ = _tmp695_;
																																		_tmp697_ = vala_string_literal_new (_tmp693_, _tmp696_);
																																		_tmp698_ = _tmp697_;
																																		vala_variable_set_initializer ((ValaVariable*) _tmp692_, (ValaExpression*) _tmp698_);
																																		_vala_code_node_unref0 (_tmp698_);
																																	} else {
																																		const gchar* _tmp699_;
																																		gchar** _tmp700_;
																																		gchar** _tmp701_;
																																		_tmp699_ = val;
																																		_tmp701_ = _tmp700_ = g_strsplit (_tmp699_, ".", 0);
																																		{
																																			gchar** member_collection = NULL;
																																			gint member_collection_length1 = 0;
																																			gint _member_collection_size_ = 0;
																																			gint member_it = 0;
																																			member_collection = _tmp701_;
																																			member_collection_length1 = _vala_array_length (_tmp700_);
																																			for (member_it = 0; member_it < member_collection_length1; member_it = member_it + 1) {
																																				const gchar* member = NULL;
																																				member = member_collection[member_it];
																																				{
																																					ValaParameter* _tmp702_;
																																					ValaParameter* _tmp703_;
																																					ValaExpression* _tmp704_;
																																					ValaExpression* _tmp705_;
																																					const gchar* _tmp706_;
																																					ValaDataType* _tmp707_;
																																					ValaSourceReference* _tmp708_;
																																					ValaSourceReference* _tmp709_;
																																					ValaMemberAccess* _tmp710_;
																																					ValaMemberAccess* _tmp711_;
																																					_tmp702_ = p;
																																					_tmp703_ = p;
																																					_tmp704_ = vala_variable_get_initializer ((ValaVariable*) _tmp703_);
																																					_tmp705_ = _tmp704_;
																																					_tmp706_ = member;
																																					_tmp707_ = param_type;
																																					_tmp708_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp707_);
																																					_tmp709_ = _tmp708_;
																																					_tmp710_ = vala_member_access_new (_tmp705_, _tmp706_, _tmp709_);
																																					_tmp711_ = _tmp710_;
																																					vala_variable_set_initializer ((ValaVariable*) _tmp702_, (ValaExpression*) _tmp711_);
																																					_vala_code_node_unref0 (_tmp711_);
																																				}
																																			}
																																			member_collection = (_vala_array_free (member_collection, member_collection_length1, (GDestroyNotify) g_free), NULL);
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (val);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp713_ = last_param;
				if (_tmp713_ != NULL) {
					ValaParameter* _tmp714_;
					const gchar* _tmp715_;
					const gchar* _tmp716_;
					ValaParameter* _tmp717_;
					const gchar* _tmp718_;
					const gchar* _tmp719_;
					gchar* _tmp720_;
					gchar* _tmp721_;
					_tmp714_ = p;
					_tmp715_ = vala_symbol_get_name ((ValaSymbol*) _tmp714_);
					_tmp716_ = _tmp715_;
					_tmp717_ = last_param;
					_tmp718_ = vala_symbol_get_name ((ValaSymbol*) _tmp717_);
					_tmp719_ = _tmp718_;
					_tmp720_ = g_strconcat ("n_", _tmp719_, NULL);
					_tmp721_ = _tmp720_;
					_tmp712_ = g_strcmp0 (_tmp716_, _tmp721_) == 0;
					_g_free0 (_tmp721_);
				} else {
					_tmp712_ = FALSE;
				}
				if (_tmp712_) {
					ValaDataType* _tmp722_;
					_tmp722_ = last_param_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp722_, VALA_TYPE_ARRAY_TYPE)) {
						ValaDataType* _tmp723_;
						ValaDataType* _tmp724_;
						ValaDataType* _tmp725_;
						ValaSourceReference* _tmp726_;
						ValaSourceReference* _tmp727_;
						ValaArrayType* _tmp728_;
						ValaParameter* _tmp729_;
						ValaDataType* _tmp730_;
						ValaParameter* _tmp731_;
						_tmp723_ = last_param_type;
						vala_data_type_set_value_owned (_tmp723_, TRUE);
						_tmp724_ = last_param_type;
						_tmp725_ = last_param_type;
						_tmp726_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp725_);
						_tmp727_ = _tmp726_;
						_tmp728_ = vala_array_type_new (_tmp724_, 1, _tmp727_);
						_vala_code_node_unref0 (last_param_type);
						last_param_type = (ValaDataType*) _tmp728_;
						_tmp729_ = last_param;
						_tmp730_ = last_param_type;
						vala_variable_set_variable_type ((ValaVariable*) _tmp729_, _tmp730_);
						_tmp731_ = last_param;
						vala_parameter_set_direction (_tmp731_, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp732_ = FALSE;
					ValaParameter* _tmp733_;
					_tmp733_ = last_param;
					if (_tmp733_ != NULL) {
						ValaParameter* _tmp734_;
						const gchar* _tmp735_;
						const gchar* _tmp736_;
						_tmp734_ = p;
						_tmp735_ = vala_symbol_get_name ((ValaSymbol*) _tmp734_);
						_tmp736_ = _tmp735_;
						_tmp732_ = g_strcmp0 (_tmp736_, "user_data") == 0;
					} else {
						_tmp732_ = FALSE;
					}
					if (_tmp732_) {
						hide_param = TRUE;
					}
				}
				if (show_param) {
					_tmp737_ = TRUE;
				} else {
					_tmp737_ = !hide_param;
				}
				if (_tmp737_) {
					ValaMethod* _tmp738_;
					ValaParameter* _tmp739_;
					_tmp738_ = m;
					_tmp739_ = p;
					vala_callable_add_parameter ((ValaCallable*) _tmp738_, _tmp739_);
					if (set_array_length_pos) {
						ValaParameter* _tmp740_;
						_tmp740_ = p;
						vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp740_, "CCode", "array_length_pos", array_length_pos, NULL);
					}
					if (set_delegate_target_pos) {
						ValaParameter* _tmp741_;
						_tmp741_ = p;
						vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp741_, "CCode", "delegate_target_pos", delegate_target_pos, NULL);
					}
				}
				_tmp742_ = p;
				_tmp743_ = _vala_code_node_ref0 (_tmp742_);
				_vala_code_node_unref0 (last_param);
				last_param = _tmp743_;
				_tmp744_ = param_type;
				_tmp745_ = _vala_code_node_ref0 (_tmp744_);
				_vala_code_node_unref0 (last_param_type);
				last_param_type = _tmp745_;
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	if (suppress_throws == FALSE) {
		const gchar* _tmp747_;
		_tmp747_ = error_types;
		_tmp746_ = _tmp747_ != NULL;
	} else {
		_tmp746_ = FALSE;
	}
	if (_tmp746_) {
		gchar** type_args = NULL;
		const gchar* _tmp748_;
		gchar* _tmp749_;
		gchar* _tmp750_;
		gchar** _tmp751_;
		gchar** _tmp752_;
		gchar** _tmp753_;
		gint _tmp753__length1;
		gint type_args_length1;
		gint _type_args_size_;
		gchar** _tmp754_;
		gint _tmp754__length1;
		_tmp748_ = error_types;
		_tmp749_ = vala_gidl_parser_eval (self, _tmp748_);
		_tmp750_ = _tmp749_;
		_tmp752_ = _tmp751_ = g_strsplit (_tmp750_, ",", 0);
		_tmp753_ = _tmp752_;
		_tmp753__length1 = _vala_array_length (_tmp751_);
		_g_free0 (_tmp750_);
		type_args = _tmp753_;
		type_args_length1 = _tmp753__length1;
		_type_args_size_ = type_args_length1;
		_tmp754_ = type_args;
		_tmp754__length1 = type_args_length1;
		{
			gchar** type_arg_collection = NULL;
			gint type_arg_collection_length1 = 0;
			gint _type_arg_collection_size_ = 0;
			gint type_arg_it = 0;
			type_arg_collection = _tmp754_;
			type_arg_collection_length1 = _tmp754__length1;
			for (type_arg_it = 0; type_arg_it < type_arg_collection_length1; type_arg_it = type_arg_it + 1) {
				const gchar* type_arg = NULL;
				type_arg = type_arg_collection[type_arg_it];
				{
					ValaMethod* _tmp755_;
					const gchar* _tmp756_;
					ValaDataType* _tmp757_;
					ValaDataType* _tmp758_;
					_tmp755_ = m;
					_tmp756_ = type_arg;
					_tmp757_ = vala_gidl_parser_parse_type_from_string (self, _tmp756_, TRUE, NULL);
					_tmp758_ = _tmp757_;
					vala_method_add_error_type (_tmp755_, _tmp758_);
					_vala_code_node_unref0 (_tmp758_);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	if (first) {
		ValaMethod* _tmp760_;
		_tmp760_ = m;
		_tmp759_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp760_, VALA_TYPE_CREATION_METHOD);
	} else {
		_tmp759_ = FALSE;
	}
	if (_tmp759_) {
		ValaMethod* _tmp761_;
		_tmp761_ = m;
		vala_method_set_binding (_tmp761_, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp763_ = last_param;
	if (_tmp763_ != NULL) {
		ValaParameter* _tmp764_;
		const gchar* _tmp765_;
		const gchar* _tmp766_;
		_tmp764_ = last_param;
		_tmp765_ = vala_symbol_get_name ((ValaSymbol*) _tmp764_);
		_tmp766_ = _tmp765_;
		_tmp762_ = g_str_has_prefix (_tmp766_, "first_");
	} else {
		_tmp762_ = FALSE;
	}
	if (_tmp762_) {
		ValaParameter* _tmp767_;
		_tmp767_ = last_param;
		vala_parameter_set_ellipsis (_tmp767_, TRUE);
	} else {
		if (add_ellipsis) {
			ValaMethod* _tmp768_;
			ValaSourceReference* _tmp769_;
			ValaParameter* _tmp770_;
			ValaParameter* _tmp771_;
			_tmp768_ = m;
			_tmp769_ = self->priv->current_source_reference;
			_tmp770_ = vala_parameter_new_with_ellipsis (_tmp769_);
			_tmp771_ = _tmp770_;
			vala_callable_add_parameter ((ValaCallable*) _tmp768_, _tmp771_);
			_vala_code_node_unref0 (_tmp771_);
		}
	}
	_tmp772_ = container;
	if (_tmp772_ == NULL) {
		ValaTypeSymbol* _tmp773_;
		ValaSymbol* _tmp774_;
		ValaSymbol* _tmp775_;
		_tmp773_ = self->priv->current_data_type;
		_tmp774_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp773_);
		_vala_code_node_unref0 (container);
		container = _tmp774_;
		_tmp775_ = container;
		if (_tmp775_ == NULL) {
			ValaNamespace* _tmp776_;
			ValaSymbol* _tmp777_;
			_tmp776_ = self->priv->current_namespace;
			_tmp777_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp776_);
			_vala_code_node_unref0 (container);
			container = _tmp777_;
		}
	}
	_tmp778_ = m;
	_tmp779_ = container;
	_tmp780_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp778_, _tmp779_);
	_tmp781_ = _tmp780_;
	_tmp782_ = g_strcmp0 (symbol, _tmp781_) != 0;
	_g_free0 (_tmp781_);
	if (_tmp782_) {
		ValaMethod* _tmp783_;
		_tmp783_ = m;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp783_, "CCode", "cname", symbol, NULL);
	}
	result = m;
	_vala_code_node_unref0 (last_param_type);
	_vala_code_node_unref0 (last_param);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (container);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gboolean
vala_gidl_parser_param_is_exception (ValaGIdlParser* self,
                                     GIdlNodeParam* param)
{
	GIdlNodeType* _tmp0_;
	gchar* s = NULL;
	GIdlNodeType* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	_tmp0_ = param->type;
	if (!_tmp0_->is_error) {
		result = FALSE;
		return result;
	}
	_tmp1_ = param->type;
	_tmp2_ = _tmp1_->unparsed;
	_tmp3_ = string_chomp (_tmp2_);
	s = _tmp3_;
	_tmp4_ = s;
	if (g_str_has_suffix (_tmp4_, "**")) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}

static ValaMethod*
vala_gidl_parser_parse_function (ValaGIdlParser* self,
                                 GIdlNodeFunction* f,
                                 gboolean is_interface)
{
	GIdlNode* node = NULL;
	GIdlNode* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GIdlNodeParam* _tmp3_;
	GList* _tmp4_;
	ValaMethod* _tmp5_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	node = (GIdlNode*) f;
	if (f->deprecated) {
		result = NULL;
		return result;
	}
	_tmp0_ = node;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = f->symbol;
	_tmp3_ = f->result;
	_tmp4_ = f->parameters;
	_tmp5_ = vala_gidl_parser_create_method (self, _tmp1_, _tmp2_, _tmp3_, _tmp4_, f->is_constructor, is_interface);
	result = _tmp5_;
	return result;
}

static ValaMethod*
vala_gidl_parser_parse_virtual (ValaGIdlParser* self,
                                GIdlNodeVFunc* v,
                                GIdlNodeFunction* func,
                                gboolean is_interface)
{
	GIdlNode* node = NULL;
	gchar* symbol = NULL;
	ValaTypeSymbol* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GList* _tmp9_ = NULL;
	ValaMethod* m = NULL;
	GIdlNode* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GIdlNodeParam* _tmp15_;
	ValaMethod* _tmp16_;
	ValaMethod* _tmp17_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	node = (GIdlNode*) v;
	_tmp0_ = self->priv->current_data_type;
	_tmp1_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = g_strdup_printf ("%s%s", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp2_);
	symbol = _tmp6_;
	if (func != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = func->symbol;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (symbol);
		symbol = _tmp8_;
	}
	if (func != NULL) {
		GList* _tmp10_;
		_tmp10_ = func->parameters;
		_tmp9_ = _tmp10_;
	} else {
		GList* _tmp11_;
		_tmp11_ = v->parameters;
		_tmp9_ = _tmp11_;
	}
	_tmp12_ = node;
	_tmp13_ = _tmp12_->name;
	_tmp14_ = symbol;
	_tmp15_ = v->result;
	_tmp16_ = vala_gidl_parser_create_method (self, _tmp13_, _tmp14_, _tmp15_, _tmp9_, FALSE, is_interface);
	m = _tmp16_;
	_tmp17_ = m;
	if (_tmp17_ != NULL) {
		ValaMethod* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ValaMethod* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		ValaMethod* _tmp23_;
		gboolean _tmp24_ = FALSE;
		ValaMethod* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		ValaMethod* _tmp28_;
		gchar** attributes = NULL;
		const gchar* _tmp29_;
		gint _tmp30_ = 0;
		gchar** _tmp31_;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		_tmp18_ = m;
		vala_method_set_binding (_tmp18_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = m;
		_tmp21_ = vala_method_get_is_abstract (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = is_interface;
		}
		_tmp23_ = m;
		vala_method_set_is_virtual (_tmp23_, !_tmp19_);
		_tmp25_ = m;
		_tmp26_ = vala_method_get_is_abstract (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_) {
			_tmp24_ = TRUE;
		} else {
			_tmp24_ = is_interface;
		}
		_tmp28_ = m;
		vala_method_set_is_abstract (_tmp28_, _tmp24_);
		_tmp29_ = symbol;
		_tmp31_ = vala_gidl_parser_get_attributes (self, _tmp29_, &_tmp30_);
		attributes = _tmp31_;
		attributes_length1 = _tmp30_;
		_attributes_size_ = attributes_length1;
		_tmp32_ = attributes;
		_tmp32__length1 = attributes_length1;
		if (_tmp32_ != NULL) {
			gchar** _tmp33_;
			gint _tmp33__length1;
			_tmp33_ = attributes;
			_tmp33__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp33_;
				attr_collection_length1 = _tmp33__length1;
				for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
					gchar* _tmp34_;
					gchar* attr = NULL;
					_tmp34_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp34_;
					{
						gchar** nv = NULL;
						const gchar* _tmp35_;
						gchar** _tmp36_;
						gchar** _tmp37_;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp38_;
						gint _tmp38__length1;
						const gchar* _tmp39_;
						_tmp35_ = attr;
						_tmp37_ = _tmp36_ = g_strsplit (_tmp35_, "=", 2);
						nv = _tmp37_;
						nv_length1 = _vala_array_length (_tmp36_);
						_nv_size_ = nv_length1;
						_tmp38_ = nv;
						_tmp38__length1 = nv_length1;
						_tmp39_ = _tmp38_[0];
						if (g_strcmp0 (_tmp39_, "virtual") == 0) {
							gchar** _tmp40_;
							gint _tmp40__length1;
							const gchar* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							gboolean _tmp44_;
							_tmp40_ = nv;
							_tmp40__length1 = nv_length1;
							_tmp41_ = _tmp40_[1];
							_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = g_strcmp0 (_tmp43_, "0") == 0;
							_g_free0 (_tmp43_);
							if (_tmp44_) {
								ValaMethod* _tmp45_;
								ValaMethod* _tmp46_;
								_tmp45_ = m;
								vala_method_set_is_virtual (_tmp45_, FALSE);
								_tmp46_ = m;
								vala_method_set_is_abstract (_tmp46_, FALSE);
							} else {
								ValaMethod* _tmp47_;
								ValaMethod* _tmp48_;
								_tmp47_ = m;
								vala_method_set_is_virtual (_tmp47_, TRUE);
								_tmp48_ = m;
								vala_method_set_is_abstract (_tmp48_, FALSE);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		if (func == NULL) {
			ValaMethod* _tmp49_;
			_tmp49_ = m;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp49_, "NoWrapper", TRUE, NULL);
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}

static gchar*
vala_gidl_parser_fix_prop_name (ValaGIdlParser* self,
                                const gchar* name)
{
	GString* str = NULL;
	GString* _tmp0_;
	gchar* i = NULL;
	gchar* _tmp1_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = g_strdup (name);
	i = _tmp1_;
	while (TRUE) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gunichar c = 0U;
		const gchar* _tmp5_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = i;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!(_tmp4_ > 0)) {
			break;
		}
		_tmp5_ = i;
		c = string_get_char (_tmp5_, (glong) 0);
		if (c == ((gunichar) '-')) {
			GString* _tmp6_;
			_tmp6_ = str;
			g_string_append_c (_tmp6_, '_');
		} else {
			GString* _tmp7_;
			_tmp7_ = str;
			g_string_append_unichar (_tmp7_, c);
		}
		_tmp8_ = i;
		_tmp9_ = g_utf8_next_char (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (i);
		i = _tmp10_;
	}
	_tmp11_ = str;
	_tmp12_ = _tmp11_->str;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}

static ValaProperty*
vala_gidl_parser_parse_property (ValaGIdlParser* self,
                                 GIdlNodeProperty* prop_node)
{
	GIdlNode* node = NULL;
	gboolean _tmp0_ = FALSE;
	ValaProperty* prop = NULL;
	GIdlNode* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GIdlNodeType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaProperty* _tmp9_;
	ValaProperty* _tmp10_;
	ValaProperty* _tmp11_;
	ValaProperty* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GIdlNodeType* _tmp14_;
	ValaProperty* _tmp43_;
	ValaDataType* _tmp44_;
	ValaDataType* _tmp45_;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GIdlNode* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gint _tmp53_ = 0;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	ValaSet* _tmp159_;
	ValaProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	node = (GIdlNode*) prop_node;
	if (prop_node->deprecated) {
		result = NULL;
		return result;
	}
	if (!prop_node->readable) {
		_tmp0_ = !prop_node->writable;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		prop_node->readable = TRUE;
		prop_node->writable = TRUE;
	}
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = vala_gidl_parser_fix_prop_name (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = prop_node->type;
	_tmp6_ = vala_gidl_parser_parse_type (self, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->current_source_reference;
	_tmp9_ = vala_property_new (_tmp4_, _tmp7_, NULL, NULL, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_vala_code_node_unref0 (_tmp7_);
	_g_free0 (_tmp4_);
	prop = _tmp10_;
	_tmp11_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp11_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp12_ = prop;
	vala_property_set_interface_only (_tmp12_, TRUE);
	_tmp14_ = prop_node->type;
	if (_tmp14_->is_interface) {
		GIdlNodeType* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = prop_node->type;
		_tmp16_ = _tmp15_->interface;
		_tmp13_ = g_strcmp0 (_tmp16_, "GStrv") == 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaProperty* _tmp17_;
		ValaProperty* _tmp18_;
		_tmp17_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp17_, "CCode", "array_length", FALSE, NULL);
		_tmp18_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp18_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	if (prop_node->readable) {
		ValaProperty* _tmp19_;
		ValaProperty* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaPropertyAccessor* _tmp25_;
		ValaPropertyAccessor* _tmp26_;
		_tmp19_ = prop;
		_tmp20_ = prop;
		_tmp21_ = vala_property_get_property_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_data_type_copy (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp24_, NULL, NULL, NULL);
		_tmp26_ = _tmp25_;
		vala_property_set_get_accessor (_tmp19_, _tmp26_);
		_vala_code_node_unref0 (_tmp26_);
		_vala_code_node_unref0 (_tmp24_);
	}
	if (prop_node->writable) {
		if (prop_node->construct_only) {
			ValaProperty* _tmp27_;
			ValaProperty* _tmp28_;
			ValaDataType* _tmp29_;
			ValaDataType* _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			ValaPropertyAccessor* _tmp33_;
			ValaPropertyAccessor* _tmp34_;
			_tmp27_ = prop;
			_tmp28_ = prop;
			_tmp29_ = vala_property_get_property_type (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_data_type_copy (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_property_accessor_new (FALSE, FALSE, TRUE, _tmp32_, NULL, NULL, NULL);
			_tmp34_ = _tmp33_;
			vala_property_set_set_accessor (_tmp27_, _tmp34_);
			_vala_code_node_unref0 (_tmp34_);
			_vala_code_node_unref0 (_tmp32_);
		} else {
			ValaProperty* _tmp35_;
			ValaProperty* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaDataType* _tmp39_;
			ValaDataType* _tmp40_;
			ValaPropertyAccessor* _tmp41_;
			ValaPropertyAccessor* _tmp42_;
			_tmp35_ = prop;
			_tmp36_ = prop;
			_tmp37_ = vala_property_get_property_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_data_type_copy (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_property_accessor_new (FALSE, TRUE, prop_node->construct, _tmp40_, NULL, NULL, NULL);
			_tmp42_ = _tmp41_;
			vala_property_set_set_accessor (_tmp35_, _tmp42_);
			_vala_code_node_unref0 (_tmp42_);
			_vala_code_node_unref0 (_tmp40_);
		}
	}
	_tmp43_ = prop;
	_tmp44_ = vala_property_get_property_type (_tmp43_);
	_tmp45_ = _tmp44_;
	vala_data_type_set_value_owned (_tmp45_, TRUE);
	_tmp46_ = self->priv->current_data_type;
	_tmp47_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp46_, NULL);
	_tmp48_ = _tmp47_;
	_tmp49_ = node;
	_tmp50_ = _tmp49_->name;
	_tmp51_ = g_strdup_printf ("%s:%s", _tmp48_, _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp54_ = vala_gidl_parser_get_attributes (self, _tmp52_, &_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp55__length1 = _tmp53_;
	_g_free0 (_tmp52_);
	_g_free0 (_tmp48_);
	attributes = _tmp55_;
	attributes_length1 = _tmp55__length1;
	_attributes_size_ = attributes_length1;
	_tmp56_ = attributes;
	_tmp56__length1 = attributes_length1;
	if (_tmp56_ != NULL) {
		gchar** _tmp57_;
		gint _tmp57__length1;
		_tmp57_ = attributes;
		_tmp57__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp57_;
			attr_collection_length1 = _tmp57__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp58_;
				gchar* attr = NULL;
				_tmp58_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp58_;
				{
					gchar** nv = NULL;
					const gchar* _tmp59_;
					gchar** _tmp60_;
					gchar** _tmp61_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp62_;
					gint _tmp62__length1;
					const gchar* _tmp63_;
					_tmp59_ = attr;
					_tmp61_ = _tmp60_ = g_strsplit (_tmp59_, "=", 2);
					nv = _tmp61_;
					nv_length1 = _vala_array_length (_tmp60_);
					_nv_size_ = nv_length1;
					_tmp62_ = nv;
					_tmp62__length1 = nv_length1;
					_tmp63_ = _tmp62_[0];
					if (g_strcmp0 (_tmp63_, "hidden") == 0) {
						gchar** _tmp64_;
						gint _tmp64__length1;
						const gchar* _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						gboolean _tmp68_;
						_tmp64_ = nv;
						_tmp64__length1 = nv_length1;
						_tmp65_ = _tmp64_[1];
						_tmp66_ = vala_gidl_parser_eval (self, _tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = g_strcmp0 (_tmp67_, "1") == 0;
						_g_free0 (_tmp67_);
						if (_tmp68_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						gchar** _tmp69_;
						gint _tmp69__length1;
						const gchar* _tmp70_;
						_tmp69_ = nv;
						_tmp69__length1 = nv_length1;
						_tmp70_ = _tmp69_[0];
						if (g_strcmp0 (_tmp70_, "type_arguments") == 0) {
							ValaProperty* _tmp71_;
							ValaDataType* _tmp72_;
							ValaDataType* _tmp73_;
							gchar** _tmp74_;
							gint _tmp74__length1;
							const gchar* _tmp75_;
							gchar* _tmp76_;
							gchar* _tmp77_;
							_tmp71_ = prop;
							_tmp72_ = vala_property_get_property_type (_tmp71_);
							_tmp73_ = _tmp72_;
							_tmp74_ = nv;
							_tmp74__length1 = nv_length1;
							_tmp75_ = _tmp74_[1];
							_tmp76_ = vala_gidl_parser_eval (self, _tmp75_);
							_tmp77_ = _tmp76_;
							vala_gidl_parser_parse_type_arguments_from_string (self, _tmp73_, _tmp77_, NULL);
							_g_free0 (_tmp77_);
						} else {
							gchar** _tmp78_;
							gint _tmp78__length1;
							const gchar* _tmp79_;
							_tmp78_ = nv;
							_tmp78__length1 = nv_length1;
							_tmp79_ = _tmp78_[0];
							if (g_strcmp0 (_tmp79_, "deprecated") == 0) {
								gchar** _tmp80_;
								gint _tmp80__length1;
								const gchar* _tmp81_;
								gchar* _tmp82_;
								gchar* _tmp83_;
								gboolean _tmp84_;
								_tmp80_ = nv;
								_tmp80__length1 = nv_length1;
								_tmp81_ = _tmp80_[1];
								_tmp82_ = vala_gidl_parser_eval (self, _tmp81_);
								_tmp83_ = _tmp82_;
								_tmp84_ = g_strcmp0 (_tmp83_, "1") == 0;
								_g_free0 (_tmp83_);
								if (_tmp84_) {
									ValaProperty* _tmp85_;
									_tmp85_ = prop;
									vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp85_, "Version", "deprecated", TRUE, NULL);
								}
							} else {
								gchar** _tmp86_;
								gint _tmp86__length1;
								const gchar* _tmp87_;
								_tmp86_ = nv;
								_tmp86__length1 = nv_length1;
								_tmp87_ = _tmp86_[0];
								if (g_strcmp0 (_tmp87_, "replacement") == 0) {
									ValaProperty* _tmp88_;
									gchar** _tmp89_;
									gint _tmp89__length1;
									const gchar* _tmp90_;
									gchar* _tmp91_;
									gchar* _tmp92_;
									_tmp88_ = prop;
									_tmp89_ = nv;
									_tmp89__length1 = nv_length1;
									_tmp90_ = _tmp89_[1];
									_tmp91_ = vala_gidl_parser_eval (self, _tmp90_);
									_tmp92_ = _tmp91_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp88_, "Version", "replacement", _tmp92_, NULL);
									_g_free0 (_tmp92_);
								} else {
									gchar** _tmp93_;
									gint _tmp93__length1;
									const gchar* _tmp94_;
									_tmp93_ = nv;
									_tmp93__length1 = nv_length1;
									_tmp94_ = _tmp93_[0];
									if (g_strcmp0 (_tmp94_, "deprecated_since") == 0) {
										ValaProperty* _tmp95_;
										gchar** _tmp96_;
										gint _tmp96__length1;
										const gchar* _tmp97_;
										gchar* _tmp98_;
										gchar* _tmp99_;
										_tmp95_ = prop;
										_tmp96_ = nv;
										_tmp96__length1 = nv_length1;
										_tmp97_ = _tmp96_[1];
										_tmp98_ = vala_gidl_parser_eval (self, _tmp97_);
										_tmp99_ = _tmp98_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "Version", "deprecated_since", _tmp99_, NULL);
										_g_free0 (_tmp99_);
									} else {
										gchar** _tmp100_;
										gint _tmp100__length1;
										const gchar* _tmp101_;
										_tmp100_ = nv;
										_tmp100__length1 = nv_length1;
										_tmp101_ = _tmp100_[0];
										if (g_strcmp0 (_tmp101_, "accessor_method") == 0) {
											gchar** _tmp102_;
											gint _tmp102__length1;
											const gchar* _tmp103_;
											gchar* _tmp104_;
											gchar* _tmp105_;
											gboolean _tmp106_;
											_tmp102_ = nv;
											_tmp102__length1 = nv_length1;
											_tmp103_ = _tmp102_[1];
											_tmp104_ = vala_gidl_parser_eval (self, _tmp103_);
											_tmp105_ = _tmp104_;
											_tmp106_ = g_strcmp0 (_tmp105_, "0") == 0;
											_g_free0 (_tmp105_);
											if (_tmp106_) {
												ValaProperty* _tmp107_;
												_tmp107_ = prop;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp107_, "NoAccessorMethod", TRUE, NULL);
											}
										} else {
											gchar** _tmp108_;
											gint _tmp108__length1;
											const gchar* _tmp109_;
											_tmp108_ = nv;
											_tmp108__length1 = nv_length1;
											_tmp109_ = _tmp108_[0];
											if (g_strcmp0 (_tmp109_, "owned_get") == 0) {
												gchar** _tmp110_;
												gint _tmp110__length1;
												const gchar* _tmp111_;
												gchar* _tmp112_;
												gchar* _tmp113_;
												gboolean _tmp114_;
												_tmp110_ = nv;
												_tmp110__length1 = nv_length1;
												_tmp111_ = _tmp110_[1];
												_tmp112_ = vala_gidl_parser_eval (self, _tmp111_);
												_tmp113_ = _tmp112_;
												_tmp114_ = g_strcmp0 (_tmp113_, "1") == 0;
												_g_free0 (_tmp113_);
												if (_tmp114_) {
													ValaProperty* _tmp115_;
													ValaPropertyAccessor* _tmp116_;
													ValaPropertyAccessor* _tmp117_;
													ValaDataType* _tmp118_;
													ValaDataType* _tmp119_;
													_tmp115_ = prop;
													_tmp116_ = vala_property_get_get_accessor (_tmp115_);
													_tmp117_ = _tmp116_;
													_tmp118_ = vala_property_accessor_get_value_type (_tmp117_);
													_tmp119_ = _tmp118_;
													vala_data_type_set_value_owned (_tmp119_, TRUE);
												}
											} else {
												gchar** _tmp120_;
												gint _tmp120__length1;
												const gchar* _tmp121_;
												_tmp120_ = nv;
												_tmp120__length1 = nv_length1;
												_tmp121_ = _tmp120_[0];
												if (g_strcmp0 (_tmp121_, "type_name") == 0) {
													ValaProperty* _tmp122_;
													gchar** _tmp123_;
													gint _tmp123__length1;
													const gchar* _tmp124_;
													gchar* _tmp125_;
													gchar* _tmp126_;
													ValaDataType* _tmp127_;
													ValaDataType* _tmp128_;
													_tmp122_ = prop;
													_tmp123_ = nv;
													_tmp123__length1 = nv_length1;
													_tmp124_ = _tmp123_[1];
													_tmp125_ = vala_gidl_parser_eval (self, _tmp124_);
													_tmp126_ = _tmp125_;
													_tmp127_ = vala_gidl_parser_parse_type_from_string (self, _tmp126_, FALSE, NULL);
													_tmp128_ = _tmp127_;
													vala_property_set_property_type (_tmp122_, _tmp128_);
													_vala_code_node_unref0 (_tmp128_);
													_g_free0 (_tmp126_);
												} else {
													gchar** _tmp129_;
													gint _tmp129__length1;
													const gchar* _tmp130_;
													_tmp129_ = nv;
													_tmp129__length1 = nv_length1;
													_tmp130_ = _tmp129_[0];
													if (g_strcmp0 (_tmp130_, "experimental") == 0) {
														gchar** _tmp131_;
														gint _tmp131__length1;
														const gchar* _tmp132_;
														gchar* _tmp133_;
														gchar* _tmp134_;
														gboolean _tmp135_;
														_tmp131_ = nv;
														_tmp131__length1 = nv_length1;
														_tmp132_ = _tmp131_[1];
														_tmp133_ = vala_gidl_parser_eval (self, _tmp132_);
														_tmp134_ = _tmp133_;
														_tmp135_ = g_strcmp0 (_tmp134_, "1") == 0;
														_g_free0 (_tmp134_);
														if (_tmp135_) {
															ValaProperty* _tmp136_;
															_tmp136_ = prop;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp136_, "Version", "experimental", TRUE, NULL);
														}
													} else {
														gchar** _tmp137_;
														gint _tmp137__length1;
														const gchar* _tmp138_;
														_tmp137_ = nv;
														_tmp137__length1 = nv_length1;
														_tmp138_ = _tmp137_[0];
														if (g_strcmp0 (_tmp138_, "nullable") == 0) {
															gboolean _tmp139_ = FALSE;
															gchar** _tmp140_;
															gint _tmp140__length1;
															const gchar* _tmp141_;
															gchar* _tmp142_;
															gchar* _tmp143_;
															gboolean _tmp144_;
															_tmp140_ = nv;
															_tmp140__length1 = nv_length1;
															_tmp141_ = _tmp140_[1];
															_tmp142_ = vala_gidl_parser_eval (self, _tmp141_);
															_tmp143_ = _tmp142_;
															_tmp144_ = g_strcmp0 (_tmp143_, "1") == 0;
															_g_free0 (_tmp143_);
															if (_tmp144_) {
																ValaProperty* _tmp145_;
																ValaDataType* _tmp146_;
																ValaDataType* _tmp147_;
																_tmp145_ = prop;
																_tmp146_ = vala_property_get_property_type (_tmp145_);
																_tmp147_ = _tmp146_;
																_tmp139_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, VALA_TYPE_VOID_TYPE);
															} else {
																_tmp139_ = FALSE;
															}
															if (_tmp139_) {
																ValaProperty* _tmp148_;
																ValaDataType* _tmp149_;
																ValaDataType* _tmp150_;
																_tmp148_ = prop;
																_tmp149_ = vala_property_get_property_type (_tmp148_);
																_tmp150_ = _tmp149_;
																vala_data_type_set_nullable (_tmp150_, TRUE);
															}
														} else {
															gchar** _tmp151_;
															gint _tmp151__length1;
															const gchar* _tmp152_;
															_tmp151_ = nv;
															_tmp151__length1 = nv_length1;
															_tmp152_ = _tmp151_[0];
															if (g_strcmp0 (_tmp152_, "abstract") == 0) {
																gchar** _tmp153_;
																gint _tmp153__length1;
																const gchar* _tmp154_;
																gchar* _tmp155_;
																gchar* _tmp156_;
																gboolean _tmp157_;
																_tmp153_ = nv;
																_tmp153__length1 = nv_length1;
																_tmp154_ = _tmp153_[1];
																_tmp155_ = vala_gidl_parser_eval (self, _tmp154_);
																_tmp156_ = _tmp155_;
																_tmp157_ = g_strcmp0 (_tmp156_, "1") == 0;
																_g_free0 (_tmp156_);
																if (_tmp157_) {
																	ValaProperty* _tmp158_;
																	_tmp158_ = prop;
																	vala_property_set_is_abstract (_tmp158_, TRUE);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp159_ = self->priv->current_type_symbol_set;
	if (_tmp159_ != NULL) {
		ValaSet* _tmp160_;
		ValaProperty* _tmp161_;
		const gchar* _tmp162_;
		const gchar* _tmp163_;
		_tmp160_ = self->priv->current_type_symbol_set;
		_tmp161_ = prop;
		_tmp162_ = vala_symbol_get_name ((ValaSymbol*) _tmp161_);
		_tmp163_ = _tmp162_;
		vala_collection_add ((ValaCollection*) _tmp160_, _tmp163_);
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static ValaConstant*
vala_gidl_parser_parse_constant (ValaGIdlParser* self,
                                 GIdlNodeConstant* const_node)
{
	GIdlNode* node = NULL;
	ValaDataType* type = NULL;
	GIdlNodeType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaConstant* c = NULL;
	GIdlNode* _tmp3_;
	const gchar* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaConstant* _tmp7_;
	ValaConstant* _tmp8_;
	gchar** attributes = NULL;
	GIdlNode* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	ValaConstant* _tmp63_;
	ValaConstant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	node = (GIdlNode*) const_node;
	_tmp0_ = const_node->type;
	_tmp1_ = vala_gidl_parser_parse_type (self, _tmp0_, NULL);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = type;
	_tmp6_ = self->priv->current_source_reference;
	_tmp7_ = vala_constant_new (_tmp4_, _tmp5_, NULL, _tmp6_, NULL);
	c = _tmp7_;
	_tmp8_ = c;
	vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
	_tmp9_ = node;
	_tmp10_ = _tmp9_->name;
	_tmp12_ = vala_gidl_parser_get_attributes (self, _tmp10_, &_tmp11_);
	attributes = _tmp12_;
	attributes_length1 = _tmp11_;
	_attributes_size_ = attributes_length1;
	_tmp13_ = attributes;
	_tmp13__length1 = attributes_length1;
	if (_tmp13_ != NULL) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = attributes;
		_tmp14__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp14_;
			attr_collection_length1 = _tmp14__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr = NULL;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** nv = NULL;
					const gchar* _tmp16_;
					gchar** _tmp17_;
					gchar** _tmp18_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					_tmp16_ = attr;
					_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "=", 2);
					nv = _tmp18_;
					nv_length1 = _vala_array_length (_tmp17_);
					_nv_size_ = nv_length1;
					_tmp19_ = nv;
					_tmp19__length1 = nv_length1;
					_tmp20_ = _tmp19_[0];
					if (g_strcmp0 (_tmp20_, "cheader_filename") == 0) {
						ValaConstant* _tmp21_;
						gchar** _tmp22_;
						gint _tmp22__length1;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp21_ = c;
						_tmp22_ = nv;
						_tmp22__length1 = nv_length1;
						_tmp23_ = _tmp22_[1];
						_tmp24_ = vala_gidl_parser_eval (self, _tmp23_);
						_tmp25_ = _tmp24_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp21_, "CCode", "cheader_filename", _tmp25_, NULL);
						_g_free0 (_tmp25_);
					} else {
						gchar** _tmp26_;
						gint _tmp26__length1;
						const gchar* _tmp27_;
						_tmp26_ = nv;
						_tmp26__length1 = nv_length1;
						_tmp27_ = _tmp26_[0];
						if (g_strcmp0 (_tmp27_, "deprecated") == 0) {
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gboolean _tmp32_;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[1];
							_tmp30_ = vala_gidl_parser_eval (self, _tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = g_strcmp0 (_tmp31_, "1") == 0;
							_g_free0 (_tmp31_);
							if (_tmp32_) {
								ValaConstant* _tmp33_;
								_tmp33_ = c;
								vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp33_, "Version", "deprecated", TRUE, NULL);
							}
						} else {
							gchar** _tmp34_;
							gint _tmp34__length1;
							const gchar* _tmp35_;
							_tmp34_ = nv;
							_tmp34__length1 = nv_length1;
							_tmp35_ = _tmp34_[0];
							if (g_strcmp0 (_tmp35_, "replacement") == 0) {
								ValaConstant* _tmp36_;
								gchar** _tmp37_;
								gint _tmp37__length1;
								const gchar* _tmp38_;
								gchar* _tmp39_;
								gchar* _tmp40_;
								_tmp36_ = c;
								_tmp37_ = nv;
								_tmp37__length1 = nv_length1;
								_tmp38_ = _tmp37_[1];
								_tmp39_ = vala_gidl_parser_eval (self, _tmp38_);
								_tmp40_ = _tmp39_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp36_, "Version", "replacement", _tmp40_, NULL);
								_g_free0 (_tmp40_);
							} else {
								gchar** _tmp41_;
								gint _tmp41__length1;
								const gchar* _tmp42_;
								_tmp41_ = nv;
								_tmp41__length1 = nv_length1;
								_tmp42_ = _tmp41_[0];
								if (g_strcmp0 (_tmp42_, "deprecated_since") == 0) {
									ValaConstant* _tmp43_;
									gchar** _tmp44_;
									gint _tmp44__length1;
									const gchar* _tmp45_;
									gchar* _tmp46_;
									gchar* _tmp47_;
									_tmp43_ = c;
									_tmp44_ = nv;
									_tmp44__length1 = nv_length1;
									_tmp45_ = _tmp44_[1];
									_tmp46_ = vala_gidl_parser_eval (self, _tmp45_);
									_tmp47_ = _tmp46_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp43_, "Version", "deprecated_since", _tmp47_, NULL);
									_g_free0 (_tmp47_);
								} else {
									gchar** _tmp48_;
									gint _tmp48__length1;
									const gchar* _tmp49_;
									_tmp48_ = nv;
									_tmp48__length1 = nv_length1;
									_tmp49_ = _tmp48_[0];
									if (g_strcmp0 (_tmp49_, "hidden") == 0) {
										gchar** _tmp50_;
										gint _tmp50__length1;
										const gchar* _tmp51_;
										gchar* _tmp52_;
										gchar* _tmp53_;
										gboolean _tmp54_;
										_tmp50_ = nv;
										_tmp50__length1 = nv_length1;
										_tmp51_ = _tmp50_[1];
										_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
										_tmp53_ = _tmp52_;
										_tmp54_ = g_strcmp0 (_tmp53_, "1") == 0;
										_g_free0 (_tmp53_);
										if (_tmp54_) {
											result = NULL;
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
											_vala_code_node_unref0 (c);
											_vala_code_node_unref0 (type);
											return result;
										}
									} else {
										gchar** _tmp55_;
										gint _tmp55__length1;
										const gchar* _tmp56_;
										_tmp55_ = nv;
										_tmp55__length1 = nv_length1;
										_tmp56_ = _tmp55_[0];
										if (g_strcmp0 (_tmp56_, "experimental") == 0) {
											gchar** _tmp57_;
											gint _tmp57__length1;
											const gchar* _tmp58_;
											gchar* _tmp59_;
											gchar* _tmp60_;
											gboolean _tmp61_;
											_tmp57_ = nv;
											_tmp57__length1 = nv_length1;
											_tmp58_ = _tmp57_[1];
											_tmp59_ = vala_gidl_parser_eval (self, _tmp58_);
											_tmp60_ = _tmp59_;
											_tmp61_ = g_strcmp0 (_tmp60_, "1") == 0;
											_g_free0 (_tmp60_);
											if (_tmp61_) {
												ValaConstant* _tmp62_;
												_tmp62_ = c;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp62_, "Version", "experimental", TRUE, NULL);
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp63_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp63_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (type);
	return result;
}

static ValaField*
vala_gidl_parser_parse_field (ValaGIdlParser* self,
                              GIdlNodeField* field_node)
{
	GIdlNode* node = NULL;
	gboolean unhidden = FALSE;
	ValaDataType* type = NULL;
	GIdlNodeType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gchar* cheader_filename = NULL;
	gchar* ctype = NULL;
	gchar* array_length_cname = NULL;
	gchar* array_length_type = NULL;
	gboolean array_null_terminated = FALSE;
	gboolean deprecated = FALSE;
	gchar* deprecated_since = NULL;
	gchar* replacement = NULL;
	gboolean experimental = FALSE;
	gboolean no_delegate_target = FALSE;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GIdlNode* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_ = 0;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gboolean _tmp133_ = FALSE;
	GIdlNode* _tmp134_;
	const gchar* _tmp135_;
	ValaSet* _tmp136_;
	gchar* field_name = NULL;
	GIdlNode* _tmp140_;
	const gchar* _tmp141_;
	gchar* _tmp142_;
	const gchar* _tmp143_;
	ValaField* field = NULL;
	const gchar* _tmp145_;
	ValaDataType* _tmp146_;
	ValaSourceReference* _tmp147_;
	ValaField* _tmp148_;
	ValaField* _tmp149_;
	const gchar* _tmp150_;
	GIdlNode* _tmp151_;
	const gchar* _tmp152_;
	const gchar* _tmp164_;
	const gchar* _tmp167_;
	gboolean _tmp171_ = FALSE;
	const gchar* _tmp172_;
	ValaField* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	node = (GIdlNode*) field_node;
	unhidden = FALSE;
	_tmp0_ = field_node->type;
	_tmp1_ = vala_gidl_parser_parse_type (self, _tmp0_, NULL);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_length_cname = NULL;
	array_length_type = NULL;
	array_null_terminated = FALSE;
	deprecated = FALSE;
	deprecated_since = NULL;
	replacement = NULL;
	experimental = FALSE;
	no_delegate_target = FALSE;
	_tmp3_ = self->priv->current_data_type;
	_tmp4_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = node;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = g_strdup_printf ("%s.%s", _tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp11_ = vala_gidl_parser_get_attributes (self, _tmp9_, &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	attributes = _tmp12_;
	attributes_length1 = _tmp12__length1;
	_attributes_size_ = attributes_length1;
	_tmp13_ = attributes;
	_tmp13__length1 = attributes_length1;
	if (_tmp13_ != NULL) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = attributes;
		_tmp14__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp14_;
			attr_collection_length1 = _tmp14__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr = NULL;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** nv = NULL;
					const gchar* _tmp16_;
					gchar** _tmp17_;
					gchar** _tmp18_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					_tmp16_ = attr;
					_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "=", 2);
					nv = _tmp18_;
					nv_length1 = _vala_array_length (_tmp17_);
					_nv_size_ = nv_length1;
					_tmp19_ = nv;
					_tmp19__length1 = nv_length1;
					_tmp20_ = _tmp19_[0];
					if (g_strcmp0 (_tmp20_, "hidden") == 0) {
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gboolean _tmp25_;
						_tmp21_ = nv;
						_tmp21__length1 = nv_length1;
						_tmp22_ = _tmp21_[1];
						_tmp23_ = vala_gidl_parser_eval (self, _tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0;
						_g_free0 (_tmp24_);
						if (_tmp25_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (replacement);
							_g_free0 (deprecated_since);
							_g_free0 (array_length_type);
							_g_free0 (array_length_cname);
							_g_free0 (ctype);
							_g_free0 (cheader_filename);
							_vala_code_node_unref0 (type);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						gchar** _tmp26_;
						gint _tmp26__length1;
						const gchar* _tmp27_;
						_tmp26_ = nv;
						_tmp26__length1 = nv_length1;
						_tmp27_ = _tmp26_[0];
						if (g_strcmp0 (_tmp27_, "is_array") == 0) {
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gboolean _tmp32_;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[1];
							_tmp30_ = vala_gidl_parser_eval (self, _tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = g_strcmp0 (_tmp31_, "1") == 0;
							_g_free0 (_tmp31_);
							if (_tmp32_) {
								ValaDataType* _tmp33_;
								ValaDataType* _tmp34_;
								ValaDataType* _tmp35_;
								ValaSourceReference* _tmp36_;
								ValaSourceReference* _tmp37_;
								ValaArrayType* _tmp38_;
								_tmp33_ = type;
								vala_data_type_set_value_owned (_tmp33_, TRUE);
								_tmp34_ = type;
								_tmp35_ = type;
								_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = vala_array_type_new (_tmp34_, 1, _tmp37_);
								_vala_code_node_unref0 (type);
								type = (ValaDataType*) _tmp38_;
							}
						} else {
							gchar** _tmp39_;
							gint _tmp39__length1;
							const gchar* _tmp40_;
							_tmp39_ = nv;
							_tmp39__length1 = nv_length1;
							_tmp40_ = _tmp39_[0];
							if (g_strcmp0 (_tmp40_, "weak") == 0) {
								gchar** _tmp41_;
								gint _tmp41__length1;
								const gchar* _tmp42_;
								gchar* _tmp43_;
								gchar* _tmp44_;
								gboolean _tmp45_;
								_tmp41_ = nv;
								_tmp41__length1 = nv_length1;
								_tmp42_ = _tmp41_[1];
								_tmp43_ = vala_gidl_parser_eval (self, _tmp42_);
								_tmp44_ = _tmp43_;
								_tmp45_ = g_strcmp0 (_tmp44_, "0") == 0;
								_g_free0 (_tmp44_);
								if (_tmp45_) {
									ValaDataType* _tmp46_;
									_tmp46_ = type;
									vala_data_type_set_value_owned (_tmp46_, TRUE);
								}
							} else {
								gchar** _tmp47_;
								gint _tmp47__length1;
								const gchar* _tmp48_;
								_tmp47_ = nv;
								_tmp47__length1 = nv_length1;
								_tmp48_ = _tmp47_[0];
								if (g_strcmp0 (_tmp48_, "value_owned") == 0) {
									gchar** _tmp49_;
									gint _tmp49__length1;
									const gchar* _tmp50_;
									gchar* _tmp51_;
									gchar* _tmp52_;
									gboolean _tmp53_;
									_tmp49_ = nv;
									_tmp49__length1 = nv_length1;
									_tmp50_ = _tmp49_[1];
									_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
									_tmp52_ = _tmp51_;
									_tmp53_ = g_strcmp0 (_tmp52_, "0") == 0;
									_g_free0 (_tmp52_);
									if (_tmp53_) {
										ValaDataType* _tmp54_;
										_tmp54_ = type;
										vala_data_type_set_value_owned (_tmp54_, FALSE);
									} else {
										gchar** _tmp55_;
										gint _tmp55__length1;
										const gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										gboolean _tmp59_;
										_tmp55_ = nv;
										_tmp55__length1 = nv_length1;
										_tmp56_ = _tmp55_[1];
										_tmp57_ = vala_gidl_parser_eval (self, _tmp56_);
										_tmp58_ = _tmp57_;
										_tmp59_ = g_strcmp0 (_tmp58_, "1") == 0;
										_g_free0 (_tmp58_);
										if (_tmp59_) {
											ValaDataType* _tmp60_;
											_tmp60_ = type;
											vala_data_type_set_value_owned (_tmp60_, TRUE);
										}
									}
								} else {
									gchar** _tmp61_;
									gint _tmp61__length1;
									const gchar* _tmp62_;
									_tmp61_ = nv;
									_tmp61__length1 = nv_length1;
									_tmp62_ = _tmp61_[0];
									if (g_strcmp0 (_tmp62_, "type_name") == 0) {
										gchar** _tmp63_;
										gint _tmp63__length1;
										const gchar* _tmp64_;
										gchar* _tmp65_;
										gchar* _tmp66_;
										ValaDataType* _tmp67_;
										_tmp63_ = nv;
										_tmp63__length1 = nv_length1;
										_tmp64_ = _tmp63_[1];
										_tmp65_ = vala_gidl_parser_eval (self, _tmp64_);
										_tmp66_ = _tmp65_;
										_tmp67_ = vala_gidl_parser_parse_type_from_string (self, _tmp66_, TRUE, NULL);
										_vala_code_node_unref0 (type);
										type = _tmp67_;
										_g_free0 (_tmp66_);
									} else {
										gchar** _tmp68_;
										gint _tmp68__length1;
										const gchar* _tmp69_;
										_tmp68_ = nv;
										_tmp68__length1 = nv_length1;
										_tmp69_ = _tmp68_[0];
										if (g_strcmp0 (_tmp69_, "type_arguments") == 0) {
											ValaDataType* _tmp70_;
											gchar** _tmp71_;
											gint _tmp71__length1;
											const gchar* _tmp72_;
											gchar* _tmp73_;
											gchar* _tmp74_;
											_tmp70_ = type;
											_tmp71_ = nv;
											_tmp71__length1 = nv_length1;
											_tmp72_ = _tmp71_[1];
											_tmp73_ = vala_gidl_parser_eval (self, _tmp72_);
											_tmp74_ = _tmp73_;
											vala_gidl_parser_parse_type_arguments_from_string (self, _tmp70_, _tmp74_, NULL);
											_g_free0 (_tmp74_);
										} else {
											gchar** _tmp75_;
											gint _tmp75__length1;
											const gchar* _tmp76_;
											_tmp75_ = nv;
											_tmp75__length1 = nv_length1;
											_tmp76_ = _tmp75_[0];
											if (g_strcmp0 (_tmp76_, "deprecated") == 0) {
												gchar** _tmp77_;
												gint _tmp77__length1;
												const gchar* _tmp78_;
												gchar* _tmp79_;
												gchar* _tmp80_;
												gboolean _tmp81_;
												_tmp77_ = nv;
												_tmp77__length1 = nv_length1;
												_tmp78_ = _tmp77_[1];
												_tmp79_ = vala_gidl_parser_eval (self, _tmp78_);
												_tmp80_ = _tmp79_;
												_tmp81_ = g_strcmp0 (_tmp80_, "1") == 0;
												_g_free0 (_tmp80_);
												if (_tmp81_) {
													deprecated = TRUE;
												}
											} else {
												gchar** _tmp82_;
												gint _tmp82__length1;
												const gchar* _tmp83_;
												_tmp82_ = nv;
												_tmp82__length1 = nv_length1;
												_tmp83_ = _tmp82_[0];
												if (g_strcmp0 (_tmp83_, "replacement") == 0) {
													gchar** _tmp84_;
													gint _tmp84__length1;
													const gchar* _tmp85_;
													gchar* _tmp86_;
													_tmp84_ = nv;
													_tmp84__length1 = nv_length1;
													_tmp85_ = _tmp84_[1];
													_tmp86_ = vala_gidl_parser_eval (self, _tmp85_);
													_g_free0 (replacement);
													replacement = _tmp86_;
												} else {
													gchar** _tmp87_;
													gint _tmp87__length1;
													const gchar* _tmp88_;
													_tmp87_ = nv;
													_tmp87__length1 = nv_length1;
													_tmp88_ = _tmp87_[0];
													if (g_strcmp0 (_tmp88_, "deprecated_since") == 0) {
														gchar** _tmp89_;
														gint _tmp89__length1;
														const gchar* _tmp90_;
														gchar* _tmp91_;
														_tmp89_ = nv;
														_tmp89__length1 = nv_length1;
														_tmp90_ = _tmp89_[1];
														_tmp91_ = vala_gidl_parser_eval (self, _tmp90_);
														_g_free0 (deprecated_since);
														deprecated_since = _tmp91_;
													} else {
														gchar** _tmp92_;
														gint _tmp92__length1;
														const gchar* _tmp93_;
														_tmp92_ = nv;
														_tmp92__length1 = nv_length1;
														_tmp93_ = _tmp92_[0];
														if (g_strcmp0 (_tmp93_, "cheader_filename") == 0) {
															gchar** _tmp94_;
															gint _tmp94__length1;
															const gchar* _tmp95_;
															gchar* _tmp96_;
															_tmp94_ = nv;
															_tmp94__length1 = nv_length1;
															_tmp95_ = _tmp94_[1];
															_tmp96_ = vala_gidl_parser_eval (self, _tmp95_);
															_g_free0 (cheader_filename);
															cheader_filename = _tmp96_;
														} else {
															gchar** _tmp97_;
															gint _tmp97__length1;
															const gchar* _tmp98_;
															_tmp97_ = nv;
															_tmp97__length1 = nv_length1;
															_tmp98_ = _tmp97_[0];
															if (g_strcmp0 (_tmp98_, "ctype") == 0) {
																gchar** _tmp99_;
																gint _tmp99__length1;
																const gchar* _tmp100_;
																gchar* _tmp101_;
																_tmp99_ = nv;
																_tmp99__length1 = nv_length1;
																_tmp100_ = _tmp99_[1];
																_tmp101_ = vala_gidl_parser_eval (self, _tmp100_);
																_g_free0 (ctype);
																ctype = _tmp101_;
															} else {
																gchar** _tmp102_;
																gint _tmp102__length1;
																const gchar* _tmp103_;
																_tmp102_ = nv;
																_tmp102__length1 = nv_length1;
																_tmp103_ = _tmp102_[0];
																if (g_strcmp0 (_tmp103_, "array_null_terminated") == 0) {
																	gchar** _tmp104_;
																	gint _tmp104__length1;
																	const gchar* _tmp105_;
																	gchar* _tmp106_;
																	gchar* _tmp107_;
																	gboolean _tmp108_;
																	_tmp104_ = nv;
																	_tmp104__length1 = nv_length1;
																	_tmp105_ = _tmp104_[1];
																	_tmp106_ = vala_gidl_parser_eval (self, _tmp105_);
																	_tmp107_ = _tmp106_;
																	_tmp108_ = g_strcmp0 (_tmp107_, "1") == 0;
																	_g_free0 (_tmp107_);
																	if (_tmp108_) {
																		array_null_terminated = TRUE;
																	}
																} else {
																	gchar** _tmp109_;
																	gint _tmp109__length1;
																	const gchar* _tmp110_;
																	_tmp109_ = nv;
																	_tmp109__length1 = nv_length1;
																	_tmp110_ = _tmp109_[0];
																	if (g_strcmp0 (_tmp110_, "array_length_cname") == 0) {
																		gchar** _tmp111_;
																		gint _tmp111__length1;
																		const gchar* _tmp112_;
																		gchar* _tmp113_;
																		_tmp111_ = nv;
																		_tmp111__length1 = nv_length1;
																		_tmp112_ = _tmp111_[1];
																		_tmp113_ = vala_gidl_parser_eval (self, _tmp112_);
																		_g_free0 (array_length_cname);
																		array_length_cname = _tmp113_;
																	} else {
																		gchar** _tmp114_;
																		gint _tmp114__length1;
																		const gchar* _tmp115_;
																		_tmp114_ = nv;
																		_tmp114__length1 = nv_length1;
																		_tmp115_ = _tmp114_[0];
																		if (g_strcmp0 (_tmp115_, "array_length_type") == 0) {
																			gchar** _tmp116_;
																			gint _tmp116__length1;
																			const gchar* _tmp117_;
																			gchar* _tmp118_;
																			_tmp116_ = nv;
																			_tmp116__length1 = nv_length1;
																			_tmp117_ = _tmp116_[1];
																			_tmp118_ = vala_gidl_parser_eval (self, _tmp117_);
																			_g_free0 (array_length_type);
																			array_length_type = _tmp118_;
																		} else {
																			gchar** _tmp119_;
																			gint _tmp119__length1;
																			const gchar* _tmp120_;
																			_tmp119_ = nv;
																			_tmp119__length1 = nv_length1;
																			_tmp120_ = _tmp119_[0];
																			if (g_strcmp0 (_tmp120_, "no_delegate_target") == 0) {
																				gchar** _tmp121_;
																				gint _tmp121__length1;
																				const gchar* _tmp122_;
																				gchar* _tmp123_;
																				gchar* _tmp124_;
																				gboolean _tmp125_;
																				_tmp121_ = nv;
																				_tmp121__length1 = nv_length1;
																				_tmp122_ = _tmp121_[1];
																				_tmp123_ = vala_gidl_parser_eval (self, _tmp122_);
																				_tmp124_ = _tmp123_;
																				_tmp125_ = g_strcmp0 (_tmp124_, "1") == 0;
																				_g_free0 (_tmp124_);
																				if (_tmp125_) {
																					no_delegate_target = TRUE;
																				}
																			} else {
																				gchar** _tmp126_;
																				gint _tmp126__length1;
																				const gchar* _tmp127_;
																				_tmp126_ = nv;
																				_tmp126__length1 = nv_length1;
																				_tmp127_ = _tmp126_[0];
																				if (g_strcmp0 (_tmp127_, "experimental") == 0) {
																					gchar** _tmp128_;
																					gint _tmp128__length1;
																					const gchar* _tmp129_;
																					gchar* _tmp130_;
																					gchar* _tmp131_;
																					gboolean _tmp132_;
																					_tmp128_ = nv;
																					_tmp128__length1 = nv_length1;
																					_tmp129_ = _tmp128_[1];
																					_tmp130_ = vala_gidl_parser_eval (self, _tmp129_);
																					_tmp131_ = _tmp130_;
																					_tmp132_ = g_strcmp0 (_tmp131_, "1") == 0;
																					_g_free0 (_tmp131_);
																					if (_tmp132_) {
																						experimental = TRUE;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp134_ = node;
	_tmp135_ = _tmp134_->name;
	if (g_str_has_prefix (_tmp135_, "_")) {
		_tmp133_ = !unhidden;
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_free0 (array_length_type);
		_g_free0 (array_length_cname);
		_g_free0 (ctype);
		_g_free0 (cheader_filename);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp136_ = self->priv->current_type_symbol_set;
	if (_tmp136_ != NULL) {
		ValaSet* _tmp137_;
		GIdlNode* _tmp138_;
		const gchar* _tmp139_;
		_tmp137_ = self->priv->current_type_symbol_set;
		_tmp138_ = node;
		_tmp139_ = _tmp138_->name;
		vala_collection_add ((ValaCollection*) _tmp137_, _tmp139_);
	}
	_tmp140_ = node;
	_tmp141_ = _tmp140_->name;
	_tmp142_ = g_strdup (_tmp141_);
	field_name = _tmp142_;
	_tmp143_ = field_name;
	if (g_strcmp0 (_tmp143_, "string") == 0) {
		gchar* _tmp144_;
		_tmp144_ = g_strdup ("str");
		_g_free0 (field_name);
		field_name = _tmp144_;
	}
	_tmp145_ = field_name;
	_tmp146_ = type;
	_tmp147_ = self->priv->current_source_reference;
	_tmp148_ = vala_field_new (_tmp145_, _tmp146_, NULL, _tmp147_, NULL);
	field = _tmp148_;
	_tmp149_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp149_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp150_ = field_name;
	_tmp151_ = node;
	_tmp152_ = _tmp151_->name;
	if (g_strcmp0 (_tmp150_, _tmp152_) != 0) {
		ValaField* _tmp153_;
		GIdlNode* _tmp154_;
		const gchar* _tmp155_;
		_tmp153_ = field;
		_tmp154_ = node;
		_tmp155_ = _tmp154_->name;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp153_, "CCode", "cname", _tmp155_, NULL);
	}
	if (deprecated) {
		ValaField* _tmp156_;
		const gchar* _tmp157_;
		const gchar* _tmp160_;
		_tmp156_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp156_, "Version", "deprecated", TRUE, NULL);
		_tmp157_ = deprecated_since;
		if (_tmp157_ != NULL) {
			ValaField* _tmp158_;
			const gchar* _tmp159_;
			_tmp158_ = field;
			_tmp159_ = deprecated_since;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp158_, "Version", "deprecated_since", _tmp159_, NULL);
		}
		_tmp160_ = replacement;
		if (_tmp160_ != NULL) {
			ValaField* _tmp161_;
			const gchar* _tmp162_;
			_tmp161_ = field;
			_tmp162_ = replacement;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp161_, "Version", "replacement", _tmp162_, NULL);
		}
	}
	if (experimental) {
		ValaField* _tmp163_;
		_tmp163_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp163_, "Version", "experimental", TRUE, NULL);
	}
	_tmp164_ = ctype;
	if (_tmp164_ != NULL) {
		ValaField* _tmp165_;
		const gchar* _tmp166_;
		_tmp165_ = field;
		_tmp166_ = ctype;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp165_, "CCode", "type", _tmp166_, NULL);
	}
	_tmp167_ = cheader_filename;
	if (_tmp167_ != NULL) {
		ValaField* _tmp168_;
		const gchar* _tmp169_;
		_tmp168_ = field;
		_tmp169_ = cheader_filename;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp168_, "CCode", "cheader_filename", _tmp169_, NULL);
	}
	if (array_null_terminated) {
		ValaField* _tmp170_;
		_tmp170_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp170_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp172_ = array_length_cname;
	if (_tmp172_ != NULL) {
		_tmp171_ = TRUE;
	} else {
		const gchar* _tmp173_;
		_tmp173_ = array_length_type;
		_tmp171_ = _tmp173_ != NULL;
	}
	if (_tmp171_) {
		const gchar* _tmp174_;
		const gchar* _tmp177_;
		_tmp174_ = array_length_cname;
		if (_tmp174_ != NULL) {
			ValaField* _tmp175_;
			const gchar* _tmp176_;
			_tmp175_ = field;
			_tmp176_ = array_length_cname;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp175_, "CCode", "array_length_cname", _tmp176_, NULL);
		}
		_tmp177_ = array_length_type;
		if (_tmp177_ != NULL) {
			ValaField* _tmp178_;
			const gchar* _tmp179_;
			_tmp178_ = field;
			_tmp179_ = array_length_type;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp178_, "CCode", "array_length_type", _tmp179_, NULL);
		}
	} else {
		ValaField* _tmp180_;
		ValaDataType* _tmp181_;
		ValaDataType* _tmp182_;
		_tmp180_ = field;
		_tmp181_ = vala_variable_get_variable_type ((ValaVariable*) _tmp180_);
		_tmp182_ = _tmp181_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp182_, VALA_TYPE_ARRAY_TYPE)) {
			ValaField* _tmp183_;
			_tmp183_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp183_, "CCode", "array_length", FALSE, NULL);
		}
	}
	if (no_delegate_target) {
		ValaField* _tmp184_;
		_tmp184_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp184_, "CCode", "delegate_target", FALSE, NULL);
	}
	result = field;
	_g_free0 (field_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (replacement);
	_g_free0 (deprecated_since);
	_g_free0 (array_length_type);
	_g_free0 (array_length_cname);
	_g_free0 (ctype);
	_g_free0 (cheader_filename);
	_vala_code_node_unref0 (type);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static gchar**
vala_gidl_parser_get_attributes (ValaGIdlParser* self,
                                 const gchar* codenode,
                                 gint* result_length1)
{
	gchar* attributes = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp23_;
	GSList* attr_list = NULL;
	GString* attr = NULL;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GString* _tmp28_;
	gint attributes_len = 0;
	const gchar* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	const gchar* remaining = NULL;
	const gchar* _tmp32_;
	gboolean quoted = FALSE;
	gboolean escaped = FALSE;
	GString* _tmp46_;
	gchar** attrs = NULL;
	GSList* _tmp50_;
	gchar** _tmp51_;
	gint attrs_length1;
	gint _attrs_size_;
	GSList* attr_i = NULL;
	GSList* _tmp52_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	_tmp0_ = self->priv->codenode_attributes_map;
	_tmp1_ = vala_map_get (_tmp0_, codenode);
	attributes = (gchar*) _tmp1_;
	_tmp2_ = attributes;
	if (_tmp2_ == NULL) {
		gboolean dot_required = FALSE;
		gboolean colon_required = FALSE;
		ValaSet* pattern_specs = NULL;
		ValaMap* _tmp3_;
		ValaSet* _tmp4_;
		dot_required = -1 != string_index_of_char (codenode, (gunichar) '.', 0);
		colon_required = -1 != string_index_of_char (codenode, (gunichar) ':', 0);
		_tmp3_ = self->priv->codenode_attributes_patterns;
		_tmp4_ = vala_map_get_keys (_tmp3_);
		pattern_specs = _tmp4_;
		{
			ValaIterator* _pattern_it = NULL;
			ValaSet* _tmp5_;
			ValaIterator* _tmp6_;
			_tmp5_ = pattern_specs;
			_tmp6_ = vala_iterable_iterator ((ValaIterable*) _tmp5_);
			_pattern_it = _tmp6_;
			while (TRUE) {
				ValaIterator* _tmp7_;
				GPatternSpec* pattern = NULL;
				ValaIterator* _tmp8_;
				gpointer _tmp9_;
				gchar* pspec = NULL;
				ValaMap* _tmp10_;
				GPatternSpec* _tmp11_;
				gpointer _tmp12_;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				GPatternSpec* _tmp18_;
				_tmp7_ = _pattern_it;
				if (!vala_iterator_next (_tmp7_)) {
					break;
				}
				_tmp8_ = _pattern_it;
				_tmp9_ = vala_iterator_get (_tmp8_);
				pattern = _tmp9_;
				_tmp10_ = self->priv->codenode_attributes_patterns;
				_tmp11_ = pattern;
				_tmp12_ = vala_map_get (_tmp10_, _tmp11_);
				pspec = (gchar*) _tmp12_;
				if (dot_required) {
					const gchar* _tmp15_;
					_tmp15_ = pspec;
					_tmp14_ = -1 == string_index_of_char (_tmp15_, (gunichar) '.', 0);
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					_tmp13_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					if (colon_required) {
						const gchar* _tmp17_;
						_tmp17_ = pspec;
						_tmp16_ = -1 == string_index_of_char (_tmp17_, (gunichar) ':', 0);
					} else {
						_tmp16_ = FALSE;
					}
					_tmp13_ = _tmp16_;
				}
				if (_tmp13_) {
					_g_free0 (pspec);
					continue;
				}
				_tmp18_ = pattern;
				if (g_pattern_match_string (_tmp18_, codenode)) {
					const gchar* _tmp19_;
					gint _tmp20_ = 0;
					gchar** _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					_tmp19_ = pspec;
					_tmp21_ = vala_gidl_parser_get_attributes (self, _tmp19_, &_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp22__length1 = _tmp20_;
					if (result_length1) {
						*result_length1 = _tmp22__length1;
					}
					result = _tmp22_;
					_g_free0 (pspec);
					_vala_iterator_unref0 (_pattern_it);
					_vala_iterable_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_vala_iterator_unref0 (_pattern_it);
		}
		_vala_iterable_unref0 (pattern_specs);
	}
	_tmp23_ = attributes;
	if (_tmp23_ == NULL) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		_tmp24_ = NULL;
		_tmp24__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp24__length1;
		}
		result = _tmp24_;
		_g_free0 (attributes);
		return result;
	}
	attr_list = NULL;
	_tmp25_ = attributes;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_string_sized_new ((gsize) _tmp27_);
	attr = _tmp28_;
	_tmp29_ = attributes;
	_tmp30_ = strlen (_tmp29_);
	_tmp31_ = _tmp30_;
	attributes_len = _tmp31_;
	_tmp32_ = attributes;
	remaining = _tmp32_;
	quoted = FALSE;
	escaped = FALSE;
	{
		gint b = 0;
		b = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				gunichar c = 0U;
				const gchar* _tmp35_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = b;
					b = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				if (!(b < attributes_len)) {
					break;
				}
				_tmp35_ = remaining;
				c = string_get_char (_tmp35_, (glong) 0);
				if (escaped) {
					GString* _tmp36_;
					escaped = FALSE;
					_tmp36_ = attr;
					g_string_append_unichar (_tmp36_, c);
				} else {
					if (c == ((gunichar) '"')) {
						GString* _tmp37_;
						_tmp37_ = attr;
						g_string_append_unichar (_tmp37_, c);
						quoted = !quoted;
					} else {
						if (c == ((gunichar) '\\')) {
							escaped = TRUE;
						} else {
							gboolean _tmp38_ = FALSE;
							if (!quoted) {
								_tmp38_ = c == ((gunichar) ' ');
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								GString* _tmp39_;
								const gchar* _tmp40_;
								gchar* _tmp41_;
								GString* _tmp42_;
								_tmp39_ = attr;
								_tmp40_ = _tmp39_->str;
								_tmp41_ = g_strdup (_tmp40_);
								attr_list = g_slist_prepend (attr_list, _tmp41_);
								_tmp42_ = attr;
								g_string_truncate (_tmp42_, (gsize) 0);
							} else {
								GString* _tmp43_;
								_tmp43_ = attr;
								g_string_append_unichar (_tmp43_, c);
							}
						}
					}
				}
				_tmp44_ = remaining;
				_tmp45_ = remaining;
				remaining = (const gchar*) (((gchar*) _tmp44_) + string_index_of_nth_char (_tmp45_, (glong) 1));
			}
		}
	}
	_tmp46_ = attr;
	if (_tmp46_->len > ((gssize) 0)) {
		GString* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp47_ = attr;
		_tmp48_ = _tmp47_->str;
		_tmp49_ = g_strdup (_tmp48_);
		attr_list = g_slist_prepend (attr_list, _tmp49_);
	}
	_tmp50_ = attr_list;
	_tmp51_ = g_new0 (gchar*, g_slist_length (_tmp50_) + 1);
	attrs = _tmp51_;
	attrs_length1 = g_slist_length (_tmp50_);
	_attrs_size_ = attrs_length1;
	_tmp52_ = attr_list;
	attr_i = _tmp52_;
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = TRUE;
			while (TRUE) {
				gchar** _tmp57_;
				gint _tmp57__length1;
				gchar** _tmp58_;
				gint _tmp58__length1;
				gchar** _tmp59_;
				gint _tmp59__length1;
				GSList* _tmp60_;
				gconstpointer _tmp61_;
				gchar* _tmp62_;
				if (!_tmp53_) {
					gint _tmp54_;
					GSList* _tmp55_;
					GSList* _tmp56_;
					_tmp54_ = a;
					a = _tmp54_ + 1;
					_tmp55_ = attr_i;
					_tmp56_ = _tmp55_->next;
					attr_i = _tmp56_;
				}
				_tmp53_ = FALSE;
				_tmp57_ = attrs;
				_tmp57__length1 = attrs_length1;
				if (!(a < _tmp57__length1)) {
					break;
				}
				_tmp58_ = attrs;
				_tmp58__length1 = attrs_length1;
				_tmp59_ = attrs;
				_tmp59__length1 = attrs_length1;
				_tmp60_ = attr_i;
				_tmp61_ = _tmp60_->data;
				_tmp62_ = g_strdup ((const gchar*) _tmp61_);
				_g_free0 (_tmp58_[(_tmp59__length1 - 1) - a]);
				_tmp58_[(_tmp59__length1 - 1) - a] = _tmp62_;
			}
		}
	}
	_tmp63_ = attrs;
	_tmp63__length1 = attrs_length1;
	if (result_length1) {
		*result_length1 = _tmp63__length1;
	}
	result = _tmp63_;
	_g_string_free0 (attr);
	(attr_list == NULL) ? NULL : (attr_list = (_g_slist_free__g_free0_ (attr_list), NULL));
	_g_free0 (attributes);
	return result;
}

static gchar*
vala_gidl_parser_eval (ValaGIdlParser* self,
                       const gchar* s)
{
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gint _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp3_ = strlen (s);
	_tmp4_ = _tmp3_;
	if (_tmp4_ >= 2) {
		_tmp2_ = g_str_has_prefix (s, "\"");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_str_has_suffix (s, "\"");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = strlen (s);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_substring (s, (glong) 1, (glong) (_tmp6_ - 2));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (s);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static ValaSignal*
vala_gidl_parser_parse_signal (ValaGIdlParser* self,
                               GIdlNodeSignal* sig_node)
{
	GIdlNode* node = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSignal* sig = NULL;
	GIdlNode* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GIdlNodeParam* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSignal* _tmp10_;
	ValaSignal* _tmp11_;
	ValaSignal* _tmp12_;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ValaSignal* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint _tmp21_ = 0;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	ValaSignal* _tmp130_;
	gboolean first = FALSE;
	GList* _tmp131_;
	ValaSignal* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	node = (GIdlNode*) sig_node;
	if (sig_node->deprecated) {
		_tmp0_ = TRUE;
	} else {
		GIdlNodeParam* _tmp1_;
		_tmp1_ = sig_node->result;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = node;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = vala_gidl_parser_fix_prop_name (self, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = sig_node->result;
	_tmp7_ = vala_gidl_parser_parse_param (self, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->current_source_reference;
	_tmp10_ = vala_signal_new (_tmp5_, _tmp8_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_vala_code_node_unref0 (_tmp8_);
	_g_free0 (_tmp5_);
	sig = _tmp11_;
	_tmp12_ = sig;
	vala_symbol_set_access ((ValaSymbol*) _tmp12_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp13_ = self->priv->current_data_type;
	_tmp14_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = sig;
	_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%s::%s", _tmp15_, _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp22_ = vala_gidl_parser_get_attributes (self, _tmp20_, &_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp21_;
	_g_free0 (_tmp20_);
	_g_free0 (_tmp15_);
	attributes = _tmp23_;
	attributes_length1 = _tmp23__length1;
	_attributes_size_ = attributes_length1;
	_tmp24_ = attributes;
	_tmp24__length1 = attributes_length1;
	if (_tmp24_ != NULL) {
		gchar* ns_name = NULL;
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp121_;
		ns_name = NULL;
		_tmp25_ = attributes;
		_tmp25__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp25_;
			attr_collection_length1 = _tmp25__length1;
			for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
				gchar* _tmp26_;
				gchar* attr = NULL;
				_tmp26_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp26_;
				{
					gchar** nv = NULL;
					const gchar* _tmp27_;
					gchar** _tmp28_;
					gchar** _tmp29_;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp30_;
					gint _tmp30__length1;
					const gchar* _tmp31_;
					_tmp27_ = attr;
					_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "=", 2);
					nv = _tmp29_;
					nv_length1 = _vala_array_length (_tmp28_);
					_nv_size_ = nv_length1;
					_tmp30_ = nv;
					_tmp30__length1 = nv_length1;
					_tmp31_ = _tmp30_[0];
					if (g_strcmp0 (_tmp31_, "name") == 0) {
						ValaSignal* _tmp32_;
						ValaSignal* _tmp33_;
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						ValaSignal* _tmp38_;
						gchar** _tmp39_;
						gint _tmp39__length1;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp32_ = sig;
						_tmp33_ = sig;
						_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = string_replace (_tmp35_, "_", "-");
						_tmp37_ = _tmp36_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp32_, "CCode", "cname", _tmp37_, NULL);
						_g_free0 (_tmp37_);
						_tmp38_ = sig;
						_tmp39_ = nv;
						_tmp39__length1 = nv_length1;
						_tmp40_ = _tmp39_[1];
						_tmp41_ = vala_gidl_parser_eval (self, _tmp40_);
						_tmp42_ = _tmp41_;
						vala_symbol_set_name ((ValaSymbol*) _tmp38_, _tmp42_);
						_g_free0 (_tmp42_);
					} else {
						gboolean _tmp43_ = FALSE;
						gchar** _tmp44_;
						gint _tmp44__length1;
						const gchar* _tmp45_;
						_tmp44_ = nv;
						_tmp44__length1 = nv_length1;
						_tmp45_ = _tmp44_[0];
						if (g_strcmp0 (_tmp45_, "has_emitter") == 0) {
							gchar** _tmp46_;
							gint _tmp46__length1;
							const gchar* _tmp47_;
							gchar* _tmp48_;
							gchar* _tmp49_;
							_tmp46_ = nv;
							_tmp46__length1 = nv_length1;
							_tmp47_ = _tmp46_[1];
							_tmp48_ = vala_gidl_parser_eval (self, _tmp47_);
							_tmp49_ = _tmp48_;
							_tmp43_ = g_strcmp0 (_tmp49_, "1") == 0;
							_g_free0 (_tmp49_);
						} else {
							_tmp43_ = FALSE;
						}
						if (_tmp43_) {
							ValaSignal* _tmp50_;
							_tmp50_ = sig;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp50_, "HasEmitter", TRUE, NULL);
						} else {
							gchar** _tmp51_;
							gint _tmp51__length1;
							const gchar* _tmp52_;
							_tmp51_ = nv;
							_tmp51__length1 = nv_length1;
							_tmp52_ = _tmp51_[0];
							if (g_strcmp0 (_tmp52_, "hidden") == 0) {
								gchar** _tmp53_;
								gint _tmp53__length1;
								const gchar* _tmp54_;
								gchar* _tmp55_;
								gchar* _tmp56_;
								gboolean _tmp57_;
								_tmp53_ = nv;
								_tmp53__length1 = nv_length1;
								_tmp54_ = _tmp53_[1];
								_tmp55_ = vala_gidl_parser_eval (self, _tmp54_);
								_tmp56_ = _tmp55_;
								_tmp57_ = g_strcmp0 (_tmp56_, "1") == 0;
								_g_free0 (_tmp56_);
								if (_tmp57_) {
									result = NULL;
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									_g_free0 (ns_name);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									return result;
								}
							} else {
								gchar** _tmp58_;
								gint _tmp58__length1;
								const gchar* _tmp59_;
								_tmp58_ = nv;
								_tmp58__length1 = nv_length1;
								_tmp59_ = _tmp58_[0];
								if (g_strcmp0 (_tmp59_, "deprecated") == 0) {
									gchar** _tmp60_;
									gint _tmp60__length1;
									const gchar* _tmp61_;
									gchar* _tmp62_;
									gchar* _tmp63_;
									gboolean _tmp64_;
									_tmp60_ = nv;
									_tmp60__length1 = nv_length1;
									_tmp61_ = _tmp60_[1];
									_tmp62_ = vala_gidl_parser_eval (self, _tmp61_);
									_tmp63_ = _tmp62_;
									_tmp64_ = g_strcmp0 (_tmp63_, "1") == 0;
									_g_free0 (_tmp63_);
									if (_tmp64_) {
										ValaSignal* _tmp65_;
										_tmp65_ = sig;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp65_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp66_;
									gint _tmp66__length1;
									const gchar* _tmp67_;
									_tmp66_ = nv;
									_tmp66__length1 = nv_length1;
									_tmp67_ = _tmp66_[0];
									if (g_strcmp0 (_tmp67_, "replacement") == 0) {
										ValaSignal* _tmp68_;
										gchar** _tmp69_;
										gint _tmp69__length1;
										const gchar* _tmp70_;
										gchar* _tmp71_;
										gchar* _tmp72_;
										_tmp68_ = sig;
										_tmp69_ = nv;
										_tmp69__length1 = nv_length1;
										_tmp70_ = _tmp69_[1];
										_tmp71_ = vala_gidl_parser_eval (self, _tmp70_);
										_tmp72_ = _tmp71_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp68_, "Version", "replacement", _tmp72_, NULL);
										_g_free0 (_tmp72_);
									} else {
										gchar** _tmp73_;
										gint _tmp73__length1;
										const gchar* _tmp74_;
										_tmp73_ = nv;
										_tmp73__length1 = nv_length1;
										_tmp74_ = _tmp73_[0];
										if (g_strcmp0 (_tmp74_, "deprecated_since") == 0) {
											ValaSignal* _tmp75_;
											gchar** _tmp76_;
											gint _tmp76__length1;
											const gchar* _tmp77_;
											gchar* _tmp78_;
											gchar* _tmp79_;
											_tmp75_ = sig;
											_tmp76_ = nv;
											_tmp76__length1 = nv_length1;
											_tmp77_ = _tmp76_[1];
											_tmp78_ = vala_gidl_parser_eval (self, _tmp77_);
											_tmp79_ = _tmp78_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp75_, "Version", "deprecated_since", _tmp79_, NULL);
											_g_free0 (_tmp79_);
										} else {
											gchar** _tmp80_;
											gint _tmp80__length1;
											const gchar* _tmp81_;
											_tmp80_ = nv;
											_tmp80__length1 = nv_length1;
											_tmp81_ = _tmp80_[0];
											if (g_strcmp0 (_tmp81_, "transfer_ownership") == 0) {
												gchar** _tmp82_;
												gint _tmp82__length1;
												const gchar* _tmp83_;
												gchar* _tmp84_;
												gchar* _tmp85_;
												gboolean _tmp86_;
												_tmp82_ = nv;
												_tmp82__length1 = nv_length1;
												_tmp83_ = _tmp82_[1];
												_tmp84_ = vala_gidl_parser_eval (self, _tmp83_);
												_tmp85_ = _tmp84_;
												_tmp86_ = g_strcmp0 (_tmp85_, "1") == 0;
												_g_free0 (_tmp85_);
												if (_tmp86_) {
													ValaSignal* _tmp87_;
													ValaDataType* _tmp88_;
													ValaDataType* _tmp89_;
													_tmp87_ = sig;
													_tmp88_ = vala_callable_get_return_type ((ValaCallable*) _tmp87_);
													_tmp89_ = _tmp88_;
													vala_data_type_set_value_owned (_tmp89_, TRUE);
												}
											} else {
												gchar** _tmp90_;
												gint _tmp90__length1;
												const gchar* _tmp91_;
												_tmp90_ = nv;
												_tmp90__length1 = nv_length1;
												_tmp91_ = _tmp90_[0];
												if (g_strcmp0 (_tmp91_, "namespace_name") == 0) {
													gchar** _tmp92_;
													gint _tmp92__length1;
													const gchar* _tmp93_;
													gchar* _tmp94_;
													_tmp92_ = nv;
													_tmp92__length1 = nv_length1;
													_tmp93_ = _tmp92_[1];
													_tmp94_ = vala_gidl_parser_eval (self, _tmp93_);
													_g_free0 (ns_name);
													ns_name = _tmp94_;
												} else {
													gchar** _tmp95_;
													gint _tmp95__length1;
													const gchar* _tmp96_;
													_tmp95_ = nv;
													_tmp95__length1 = nv_length1;
													_tmp96_ = _tmp95_[0];
													if (g_strcmp0 (_tmp96_, "type_name") == 0) {
														ValaSignal* _tmp97_;
														gchar** _tmp98_;
														gint _tmp98__length1;
														const gchar* _tmp99_;
														gchar* _tmp100_;
														gchar* _tmp101_;
														ValaDataType* _tmp102_;
														ValaDataType* _tmp103_;
														_tmp97_ = sig;
														_tmp98_ = nv;
														_tmp98__length1 = nv_length1;
														_tmp99_ = _tmp98_[1];
														_tmp100_ = vala_gidl_parser_eval (self, _tmp99_);
														_tmp101_ = _tmp100_;
														_tmp102_ = vala_gidl_parser_parse_type_from_string (self, _tmp101_, FALSE, NULL);
														_tmp103_ = _tmp102_;
														vala_callable_set_return_type ((ValaCallable*) _tmp97_, _tmp103_);
														_vala_code_node_unref0 (_tmp103_);
														_g_free0 (_tmp101_);
													} else {
														gchar** _tmp104_;
														gint _tmp104__length1;
														const gchar* _tmp105_;
														_tmp104_ = nv;
														_tmp104__length1 = nv_length1;
														_tmp105_ = _tmp104_[0];
														if (g_strcmp0 (_tmp105_, "type_arguments") == 0) {
															ValaSignal* _tmp106_;
															ValaDataType* _tmp107_;
															ValaDataType* _tmp108_;
															gchar** _tmp109_;
															gint _tmp109__length1;
															const gchar* _tmp110_;
															gchar* _tmp111_;
															gchar* _tmp112_;
															_tmp106_ = sig;
															_tmp107_ = vala_callable_get_return_type ((ValaCallable*) _tmp106_);
															_tmp108_ = _tmp107_;
															_tmp109_ = nv;
															_tmp109__length1 = nv_length1;
															_tmp110_ = _tmp109_[1];
															_tmp111_ = vala_gidl_parser_eval (self, _tmp110_);
															_tmp112_ = _tmp111_;
															vala_gidl_parser_parse_type_arguments_from_string (self, _tmp108_, _tmp112_, NULL);
															_g_free0 (_tmp112_);
														} else {
															gchar** _tmp113_;
															gint _tmp113__length1;
															const gchar* _tmp114_;
															_tmp113_ = nv;
															_tmp113__length1 = nv_length1;
															_tmp114_ = _tmp113_[0];
															if (g_strcmp0 (_tmp114_, "experimental") == 0) {
																gchar** _tmp115_;
																gint _tmp115__length1;
																const gchar* _tmp116_;
																gchar* _tmp117_;
																gchar* _tmp118_;
																gboolean _tmp119_;
																_tmp115_ = nv;
																_tmp115__length1 = nv_length1;
																_tmp116_ = _tmp115_[1];
																_tmp117_ = vala_gidl_parser_eval (self, _tmp116_);
																_tmp118_ = _tmp117_;
																_tmp119_ = g_strcmp0 (_tmp118_, "1") == 0;
																_g_free0 (_tmp118_);
																if (_tmp119_) {
																	ValaSignal* _tmp120_;
																	_tmp120_ = sig;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp120_, "Version", "experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
		_tmp121_ = ns_name;
		if (_tmp121_ != NULL) {
			ValaSignal* _tmp122_;
			ValaDataType* _tmp123_;
			ValaDataType* _tmp124_;
			ValaUnresolvedSymbol* _tmp125_;
			ValaUnresolvedSymbol* _tmp126_;
			const gchar* _tmp127_;
			ValaUnresolvedSymbol* _tmp128_;
			ValaUnresolvedSymbol* _tmp129_;
			_tmp122_ = sig;
			_tmp123_ = vala_callable_get_return_type ((ValaCallable*) _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp126_ = _tmp125_;
			_tmp127_ = ns_name;
			_tmp128_ = vala_unresolved_symbol_new (NULL, _tmp127_, NULL);
			_tmp129_ = _tmp128_;
			vala_unresolved_symbol_set_inner (_tmp126_, _tmp129_);
			_vala_code_node_unref0 (_tmp129_);
		}
		_g_free0 (ns_name);
	}
	_tmp130_ = sig;
	vala_signal_set_is_virtual (_tmp130_, TRUE);
	first = TRUE;
	_tmp131_ = sig_node->parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp131_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp132_;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type = NULL;
				GIdlNodeParam* _tmp133_;
				ValaParameterDirection _tmp134_ = 0;
				ValaDataType* _tmp135_;
				ValaParameter* p = NULL;
				GIdlNode* _tmp136_;
				const gchar* _tmp137_;
				ValaDataType* _tmp138_;
				ValaSourceReference* _tmp139_;
				ValaParameter* _tmp140_;
				ValaParameter* _tmp141_;
				gboolean hide_param = FALSE;
				gboolean show_param = FALSE;
				ValaTypeSymbol* _tmp142_;
				gchar* _tmp143_;
				gchar* _tmp144_;
				ValaSignal* _tmp145_;
				const gchar* _tmp146_;
				const gchar* _tmp147_;
				GIdlNode* _tmp148_;
				const gchar* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				gint _tmp152_ = 0;
				gchar** _tmp153_;
				gchar** _tmp154_;
				gint _tmp154__length1;
				gboolean _tmp274_ = FALSE;
				if (first) {
					first = FALSE;
					continue;
				}
				_tmp132_ = param;
				param_node = (GIdlNode*) _tmp132_;
				_tmp133_ = param;
				_tmp135_ = vala_gidl_parser_parse_param (self, _tmp133_, &_tmp134_);
				direction = _tmp134_;
				param_type = _tmp135_;
				_tmp136_ = param_node;
				_tmp137_ = _tmp136_->name;
				_tmp138_ = param_type;
				_tmp139_ = self->priv->current_source_reference;
				_tmp140_ = vala_parameter_new (_tmp137_, _tmp138_, _tmp139_);
				p = _tmp140_;
				_tmp141_ = p;
				vala_parameter_set_direction (_tmp141_, direction);
				hide_param = FALSE;
				show_param = FALSE;
				_tmp142_ = self->priv->current_data_type;
				_tmp143_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp142_, NULL);
				_tmp144_ = _tmp143_;
				_tmp145_ = sig;
				_tmp146_ = vala_symbol_get_name ((ValaSymbol*) _tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = param_node;
				_tmp149_ = _tmp148_->name;
				_tmp150_ = g_strdup_printf ("%s::%s.%s", _tmp144_, _tmp147_, _tmp149_);
				_tmp151_ = _tmp150_;
				_tmp153_ = vala_gidl_parser_get_attributes (self, _tmp151_, &_tmp152_);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes = _tmp153_;
				attributes_length1 = _tmp152_;
				_attributes_size_ = attributes_length1;
				_g_free0 (_tmp151_);
				_g_free0 (_tmp144_);
				_tmp154_ = attributes;
				_tmp154__length1 = attributes_length1;
				if (_tmp154_ != NULL) {
					gchar* ns_name = NULL;
					gchar** _tmp155_;
					gint _tmp155__length1;
					const gchar* _tmp267_;
					ns_name = NULL;
					_tmp155_ = attributes;
					_tmp155__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp155_;
						attr_collection_length1 = _tmp155__length1;
						for (attr_it = 0; attr_it < attr_collection_length1; attr_it = attr_it + 1) {
							gchar* _tmp156_;
							gchar* attr = NULL;
							_tmp156_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp156_;
							{
								gchar** nv = NULL;
								const gchar* _tmp157_;
								gchar** _tmp158_;
								gchar** _tmp159_;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp160_;
								gint _tmp160__length1;
								const gchar* _tmp161_;
								_tmp157_ = attr;
								_tmp159_ = _tmp158_ = g_strsplit (_tmp157_, "=", 2);
								nv = _tmp159_;
								nv_length1 = _vala_array_length (_tmp158_);
								_nv_size_ = nv_length1;
								_tmp160_ = nv;
								_tmp160__length1 = nv_length1;
								_tmp161_ = _tmp160_[0];
								if (g_strcmp0 (_tmp161_, "hidden") == 0) {
									gchar** _tmp162_;
									gint _tmp162__length1;
									const gchar* _tmp163_;
									gchar* _tmp164_;
									gchar* _tmp165_;
									gboolean _tmp166_;
									_tmp162_ = nv;
									_tmp162__length1 = nv_length1;
									_tmp163_ = _tmp162_[1];
									_tmp164_ = vala_gidl_parser_eval (self, _tmp163_);
									_tmp165_ = _tmp164_;
									_tmp166_ = g_strcmp0 (_tmp165_, "1") == 0;
									_g_free0 (_tmp165_);
									if (_tmp166_) {
										hide_param = TRUE;
									} else {
										gchar** _tmp167_;
										gint _tmp167__length1;
										const gchar* _tmp168_;
										gchar* _tmp169_;
										gchar* _tmp170_;
										gboolean _tmp171_;
										_tmp167_ = nv;
										_tmp167__length1 = nv_length1;
										_tmp168_ = _tmp167_[1];
										_tmp169_ = vala_gidl_parser_eval (self, _tmp168_);
										_tmp170_ = _tmp169_;
										_tmp171_ = g_strcmp0 (_tmp170_, "0") == 0;
										_g_free0 (_tmp170_);
										if (_tmp171_) {
											show_param = TRUE;
										}
									}
								} else {
									gchar** _tmp172_;
									gint _tmp172__length1;
									const gchar* _tmp173_;
									_tmp172_ = nv;
									_tmp172__length1 = nv_length1;
									_tmp173_ = _tmp172_[0];
									if (g_strcmp0 (_tmp173_, "is_array") == 0) {
										gchar** _tmp174_;
										gint _tmp174__length1;
										const gchar* _tmp175_;
										gchar* _tmp176_;
										gchar* _tmp177_;
										gboolean _tmp178_;
										_tmp174_ = nv;
										_tmp174__length1 = nv_length1;
										_tmp175_ = _tmp174_[1];
										_tmp176_ = vala_gidl_parser_eval (self, _tmp175_);
										_tmp177_ = _tmp176_;
										_tmp178_ = g_strcmp0 (_tmp177_, "1") == 0;
										_g_free0 (_tmp177_);
										if (_tmp178_) {
											ValaDataType* _tmp179_;
											ValaDataType* _tmp180_;
											ValaDataType* _tmp181_;
											ValaSourceReference* _tmp182_;
											ValaSourceReference* _tmp183_;
											ValaArrayType* _tmp184_;
											ValaParameter* _tmp185_;
											ValaDataType* _tmp186_;
											ValaParameter* _tmp187_;
											_tmp179_ = param_type;
											vala_data_type_set_value_owned (_tmp179_, TRUE);
											_tmp180_ = param_type;
											_tmp181_ = param_type;
											_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp181_);
											_tmp183_ = _tmp182_;
											_tmp184_ = vala_array_type_new (_tmp180_, 1, _tmp183_);
											_vala_code_node_unref0 (param_type);
											param_type = (ValaDataType*) _tmp184_;
											_tmp185_ = p;
											_tmp186_ = param_type;
											vala_variable_set_variable_type ((ValaVariable*) _tmp185_, _tmp186_);
											_tmp187_ = p;
											vala_parameter_set_direction (_tmp187_, VALA_PARAMETER_DIRECTION_IN);
										}
									} else {
										gchar** _tmp188_;
										gint _tmp188__length1;
										const gchar* _tmp189_;
										_tmp188_ = nv;
										_tmp188__length1 = nv_length1;
										_tmp189_ = _tmp188_[0];
										if (g_strcmp0 (_tmp189_, "no_array_length") == 0) {
											gchar** _tmp190_;
											gint _tmp190__length1;
											const gchar* _tmp191_;
											gchar* _tmp192_;
											gchar* _tmp193_;
											gboolean _tmp194_;
											_tmp190_ = nv;
											_tmp190__length1 = nv_length1;
											_tmp191_ = _tmp190_[1];
											_tmp192_ = vala_gidl_parser_eval (self, _tmp191_);
											_tmp193_ = _tmp192_;
											_tmp194_ = g_strcmp0 (_tmp193_, "1") == 0;
											_g_free0 (_tmp193_);
											if (_tmp194_) {
												ValaParameter* _tmp195_;
												_tmp195_ = p;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp195_, "CCode", "array_length", FALSE, NULL);
											}
										} else {
											gchar** _tmp196_;
											gint _tmp196__length1;
											const gchar* _tmp197_;
											_tmp196_ = nv;
											_tmp196__length1 = nv_length1;
											_tmp197_ = _tmp196_[0];
											if (g_strcmp0 (_tmp197_, "array_length_type") == 0) {
												ValaParameter* _tmp198_;
												gchar** _tmp199_;
												gint _tmp199__length1;
												const gchar* _tmp200_;
												_tmp198_ = p;
												_tmp199_ = nv;
												_tmp199__length1 = nv_length1;
												_tmp200_ = _tmp199_[1];
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp198_, "CCode", "array_length_type", _tmp200_, NULL);
											} else {
												gchar** _tmp201_;
												gint _tmp201__length1;
												const gchar* _tmp202_;
												_tmp201_ = nv;
												_tmp201__length1 = nv_length1;
												_tmp202_ = _tmp201_[0];
												if (g_strcmp0 (_tmp202_, "array_null_terminated") == 0) {
													gchar** _tmp203_;
													gint _tmp203__length1;
													const gchar* _tmp204_;
													gchar* _tmp205_;
													gchar* _tmp206_;
													gboolean _tmp207_;
													_tmp203_ = nv;
													_tmp203__length1 = nv_length1;
													_tmp204_ = _tmp203_[1];
													_tmp205_ = vala_gidl_parser_eval (self, _tmp204_);
													_tmp206_ = _tmp205_;
													_tmp207_ = g_strcmp0 (_tmp206_, "1") == 0;
													_g_free0 (_tmp206_);
													if (_tmp207_) {
														ValaParameter* _tmp208_;
														ValaParameter* _tmp209_;
														_tmp208_ = p;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp208_, "CCode", "array_length", FALSE, NULL);
														_tmp209_ = p;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp209_, "CCode", "array_null_terminated", TRUE, NULL);
													}
												} else {
													gchar** _tmp210_;
													gint _tmp210__length1;
													const gchar* _tmp211_;
													_tmp210_ = nv;
													_tmp210__length1 = nv_length1;
													_tmp211_ = _tmp210_[0];
													if (g_strcmp0 (_tmp211_, "is_out") == 0) {
														gchar** _tmp212_;
														gint _tmp212__length1;
														const gchar* _tmp213_;
														gchar* _tmp214_;
														gchar* _tmp215_;
														gboolean _tmp216_;
														_tmp212_ = nv;
														_tmp212__length1 = nv_length1;
														_tmp213_ = _tmp212_[1];
														_tmp214_ = vala_gidl_parser_eval (self, _tmp213_);
														_tmp215_ = _tmp214_;
														_tmp216_ = g_strcmp0 (_tmp215_, "1") == 0;
														_g_free0 (_tmp215_);
														if (_tmp216_) {
															ValaParameter* _tmp217_;
															_tmp217_ = p;
															vala_parameter_set_direction (_tmp217_, VALA_PARAMETER_DIRECTION_OUT);
														}
													} else {
														gchar** _tmp218_;
														gint _tmp218__length1;
														const gchar* _tmp219_;
														_tmp218_ = nv;
														_tmp218__length1 = nv_length1;
														_tmp219_ = _tmp218_[0];
														if (g_strcmp0 (_tmp219_, "is_ref") == 0) {
															gchar** _tmp220_;
															gint _tmp220__length1;
															const gchar* _tmp221_;
															gchar* _tmp222_;
															gchar* _tmp223_;
															gboolean _tmp224_;
															_tmp220_ = nv;
															_tmp220__length1 = nv_length1;
															_tmp221_ = _tmp220_[1];
															_tmp222_ = vala_gidl_parser_eval (self, _tmp221_);
															_tmp223_ = _tmp222_;
															_tmp224_ = g_strcmp0 (_tmp223_, "1") == 0;
															_g_free0 (_tmp223_);
															if (_tmp224_) {
																ValaParameter* _tmp225_;
																_tmp225_ = p;
																vala_parameter_set_direction (_tmp225_, VALA_PARAMETER_DIRECTION_REF);
															}
														} else {
															gchar** _tmp226_;
															gint _tmp226__length1;
															const gchar* _tmp227_;
															_tmp226_ = nv;
															_tmp226__length1 = nv_length1;
															_tmp227_ = _tmp226_[0];
															if (g_strcmp0 (_tmp227_, "nullable") == 0) {
																gboolean _tmp228_ = FALSE;
																gchar** _tmp229_;
																gint _tmp229__length1;
																const gchar* _tmp230_;
																gchar* _tmp231_;
																gchar* _tmp232_;
																gboolean _tmp233_;
																_tmp229_ = nv;
																_tmp229__length1 = nv_length1;
																_tmp230_ = _tmp229_[1];
																_tmp231_ = vala_gidl_parser_eval (self, _tmp230_);
																_tmp232_ = _tmp231_;
																_tmp233_ = g_strcmp0 (_tmp232_, "1") == 0;
																_g_free0 (_tmp232_);
																if (_tmp233_) {
																	ValaDataType* _tmp234_;
																	_tmp234_ = param_type;
																	_tmp228_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp234_, VALA_TYPE_VOID_TYPE);
																} else {
																	_tmp228_ = FALSE;
																}
																if (_tmp228_) {
																	ValaDataType* _tmp235_;
																	_tmp235_ = param_type;
																	vala_data_type_set_nullable (_tmp235_, TRUE);
																}
															} else {
																gchar** _tmp236_;
																gint _tmp236__length1;
																const gchar* _tmp237_;
																_tmp236_ = nv;
																_tmp236__length1 = nv_length1;
																_tmp237_ = _tmp236_[0];
																if (g_strcmp0 (_tmp237_, "transfer_ownership") == 0) {
																	gchar** _tmp238_;
																	gint _tmp238__length1;
																	const gchar* _tmp239_;
																	gchar* _tmp240_;
																	gchar* _tmp241_;
																	gboolean _tmp242_;
																	_tmp238_ = nv;
																	_tmp238__length1 = nv_length1;
																	_tmp239_ = _tmp238_[1];
																	_tmp240_ = vala_gidl_parser_eval (self, _tmp239_);
																	_tmp241_ = _tmp240_;
																	_tmp242_ = g_strcmp0 (_tmp241_, "1") == 0;
																	_g_free0 (_tmp241_);
																	if (_tmp242_) {
																		ValaDataType* _tmp243_;
																		_tmp243_ = param_type;
																		vala_data_type_set_value_owned (_tmp243_, TRUE);
																	}
																} else {
																	gchar** _tmp244_;
																	gint _tmp244__length1;
																	const gchar* _tmp245_;
																	_tmp244_ = nv;
																	_tmp244__length1 = nv_length1;
																	_tmp245_ = _tmp244_[0];
																	if (g_strcmp0 (_tmp245_, "type_name") == 0) {
																		ValaParameter* _tmp246_;
																		gchar** _tmp247_;
																		gint _tmp247__length1;
																		const gchar* _tmp248_;
																		gchar* _tmp249_;
																		gchar* _tmp250_;
																		ValaDataType* _tmp251_;
																		ValaDataType* _tmp252_;
																		_tmp246_ = p;
																		_tmp247_ = nv;
																		_tmp247__length1 = nv_length1;
																		_tmp248_ = _tmp247_[1];
																		_tmp249_ = vala_gidl_parser_eval (self, _tmp248_);
																		_tmp250_ = _tmp249_;
																		_tmp251_ = vala_gidl_parser_parse_type_from_string (self, _tmp250_, FALSE, NULL);
																		_vala_code_node_unref0 (param_type);
																		param_type = _tmp251_;
																		_tmp252_ = param_type;
																		vala_variable_set_variable_type ((ValaVariable*) _tmp246_, _tmp252_);
																		_g_free0 (_tmp250_);
																	} else {
																		gchar** _tmp253_;
																		gint _tmp253__length1;
																		const gchar* _tmp254_;
																		_tmp253_ = nv;
																		_tmp253__length1 = nv_length1;
																		_tmp254_ = _tmp253_[0];
																		if (g_strcmp0 (_tmp254_, "type_arguments") == 0) {
																			ValaParameter* _tmp255_;
																			ValaDataType* _tmp256_;
																			ValaDataType* _tmp257_;
																			gchar** _tmp258_;
																			gint _tmp258__length1;
																			const gchar* _tmp259_;
																			gchar* _tmp260_;
																			gchar* _tmp261_;
																			_tmp255_ = p;
																			_tmp256_ = vala_variable_get_variable_type ((ValaVariable*) _tmp255_);
																			_tmp257_ = _tmp256_;
																			_tmp258_ = nv;
																			_tmp258__length1 = nv_length1;
																			_tmp259_ = _tmp258_[1];
																			_tmp260_ = vala_gidl_parser_eval (self, _tmp259_);
																			_tmp261_ = _tmp260_;
																			vala_gidl_parser_parse_type_arguments_from_string (self, _tmp257_, _tmp261_, NULL);
																			_g_free0 (_tmp261_);
																		} else {
																			gchar** _tmp262_;
																			gint _tmp262__length1;
																			const gchar* _tmp263_;
																			_tmp262_ = nv;
																			_tmp262__length1 = nv_length1;
																			_tmp263_ = _tmp262_[0];
																			if (g_strcmp0 (_tmp263_, "namespace_name") == 0) {
																				gchar** _tmp264_;
																				gint _tmp264__length1;
																				const gchar* _tmp265_;
																				gchar* _tmp266_;
																				_tmp264_ = nv;
																				_tmp264__length1 = nv_length1;
																				_tmp265_ = _tmp264_[1];
																				_tmp266_ = vala_gidl_parser_eval (self, _tmp265_);
																				_g_free0 (ns_name);
																				ns_name = _tmp266_;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
					_tmp267_ = ns_name;
					if (_tmp267_ != NULL) {
						ValaDataType* _tmp268_;
						ValaUnresolvedSymbol* _tmp269_;
						ValaUnresolvedSymbol* _tmp270_;
						const gchar* _tmp271_;
						ValaUnresolvedSymbol* _tmp272_;
						ValaUnresolvedSymbol* _tmp273_;
						_tmp268_ = param_type;
						_tmp269_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp268_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp270_ = _tmp269_;
						_tmp271_ = ns_name;
						_tmp272_ = vala_unresolved_symbol_new (NULL, _tmp271_, NULL);
						_tmp273_ = _tmp272_;
						vala_unresolved_symbol_set_inner (_tmp270_, _tmp273_);
						_vala_code_node_unref0 (_tmp273_);
					}
					_g_free0 (ns_name);
				}
				if (show_param) {
					_tmp274_ = TRUE;
				} else {
					_tmp274_ = !hide_param;
				}
				if (_tmp274_) {
					ValaSignal* _tmp275_;
					ValaParameter* _tmp276_;
					_tmp275_ = sig;
					_tmp276_ = p;
					vala_callable_add_parameter ((ValaCallable*) _tmp275_, _tmp276_);
				}
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

ValaGIdlParser*
vala_gidl_parser_construct (GType object_type)
{
	ValaGIdlParser* self = NULL;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}

ValaGIdlParser*
vala_gidl_parser_new (void)
{
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}

static void
vala_gidl_parser_class_init (ValaGIdlParserClass * klass,
                             gpointer klass_data)
{
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGIdlParser_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) vala_gidl_parser_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gidl_parser_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_gidl_parser_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_gidl_parser_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_gidl_parser_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gidl_parser_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) vala_gidl_parser_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gidl_parser_real_visit_source_file;
}

static void
vala_gidl_parser_instance_init (ValaGIdlParser * self,
                                gpointer klass)
{
	self->priv = vala_gidl_parser_get_instance_private (self);
}

static void
vala_gidl_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGIdlParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIDL_PARSER, ValaGIdlParser);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	_vala_map_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}

/**
 * Code visitor parsing all GIDL files.
 */
static GType
vala_gidl_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
	GType vala_gidl_parser_type_id;
	vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
	ValaGIdlParser_private_offset = g_type_add_instance_private (vala_gidl_parser_type_id, sizeof (ValaGIdlParserPrivate));
	return vala_gidl_parser_type_id;
}

GType
vala_gidl_parser_get_type (void)
{
	static volatile gsize vala_gidl_parser_type_id__once = 0;
	if (g_once_init_enter (&vala_gidl_parser_type_id__once)) {
		GType vala_gidl_parser_type_id;
		vala_gidl_parser_type_id = vala_gidl_parser_get_type_once ();
		g_once_init_leave (&vala_gidl_parser_type_id__once, vala_gidl_parser_type_id);
	}
	return vala_gidl_parser_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

