/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

static ValaExpression*
vala_method_call_real_get_call (ValaCallableExpression* base)
{
	ValaExpression* result;
	ValaMethodCall* self;
	ValaExpression* _tmp0_;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

static gboolean
vala_method_call_real_get_is_chainup (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_real_set_is_chainup (ValaCallableExpression* base,
                                      gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	_tmp0_ = _vala_code_node_ref0 (call);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp3_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		ValaExpression* _tmp2_;
		_tmp2_ = _vala_code_node_ref0 (new_node);
		_vala_code_node_unref0 (self->priv->_call);
		self->priv->_call = _tmp2_;
	}
	_tmp3_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp3_, old_node);
	if (index >= 0) {
		ValaList* _tmp4_;
		_tmp4_ = self->priv->argument_list;
		vala_list_set (_tmp4_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		gboolean _tmp22_ = FALSE;
		ValaDataType* _tmp23_;
		_tmp23_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp23_)) {
			ValaDataType* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaTypeSymbol* _tmp26_;
			_tmp24_ = mtype;
			_tmp25_ = vala_data_type_get_type_symbol (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp22_ = VALA_IS_CLASS (_tmp26_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp27_;
			ValaTypeSymbol* _tmp28_;
			ValaTypeSymbol* _tmp29_;
			ValaMethod* m = NULL;
			ValaClass* _tmp30_;
			ValaCreationMethod* _tmp31_;
			ValaCreationMethod* _tmp32_;
			ValaMethod* _tmp33_;
			_tmp27_ = mtype;
			_tmp28_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp29_ = _tmp28_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_CLASS, ValaClass);
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_default_construction_method (_tmp30_);
			_tmp32_ = _tmp31_;
			m = (ValaMethod*) _tmp32_;
			_tmp33_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
		} else {
			ValaDataType* _tmp34_;
			_tmp34_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp34_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp35_;
				ValaDelegate* _tmp36_;
				ValaDelegate* _tmp37_;
				ValaDelegate* _tmp38_;
				_tmp35_ = mtype;
				_tmp36_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp37_ = _tmp36_;
				d = _tmp37_;
				_tmp38_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp38_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp39_;
		gint _expr_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _expr_index = 0;
		_tmp39_ = self->priv->argument_list;
		_expr_list = _tmp39_;
		_tmp40_ = _expr_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_expr_size = _tmp42_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			ValaExpression* expr = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			ValaExpression* _tmp47_;
			_expr_index = _expr_index + 1;
			_tmp43_ = _expr_index;
			_tmp44_ = _expr_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _expr_list;
			_tmp46_ = vala_list_get (_tmp45_, _expr_index);
			expr = (ValaExpression*) _tmp46_;
			_tmp47_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp47_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp111_;
	ValaExpression* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean _tmp116_ = FALSE;
	ValaProfile _tmp117_;
	ValaProfile _tmp118_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp144_;
	gboolean _tmp145_;
	gboolean _tmp227_ = FALSE;
	ValaExpression* _tmp228_;
	ValaExpression* _tmp229_;
	gboolean _tmp304_ = FALSE;
	gboolean _tmp305_;
	gboolean _tmp306_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp321_;
	ValaDataType* _tmp322_;
	ValaDataType* _tmp323_;
	ValaList* params = NULL;
	ValaDataType* _tmp324_;
	ValaList* _tmp325_;
	ValaList* _tmp326_;
	ValaDataType* _tmp327_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp389_;
	ValaIterator* _tmp390_;
	gboolean _tmp440_ = FALSE;
	ValaDataType* _tmp441_;
	gboolean _tmp462_ = FALSE;
	ValaDataType* _tmp463_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp543_ = FALSE;
	gboolean _tmp544_;
	gboolean _tmp545_;
	ValaDataType* _tmp565_;
	ValaDataType* _tmp576_;
	ValaDataType* _tmp577_;
	ValaDataType* _tmp578_;
	ValaDataType* _tmp579_;
	ValaDataType* _tmp580_;
	ValaDataType* _tmp581_;
	ValaList* _tmp582_;
	ValaDataType* _tmp583_;
	ValaDataType* _tmp584_;
	gboolean _tmp585_;
	gboolean _tmp586_;
	ValaDataType* _tmp609_;
	ValaSemanticAnalyzer* _tmp852_;
	ValaSemanticAnalyzer* _tmp853_;
	ValaDataType* _tmp854_;
	ValaList* _tmp855_;
	ValaList* _tmp856_;
	gboolean _tmp883_ = FALSE;
	gboolean _tmp884_ = FALSE;
	ValaCreationMethod* _tmp885_;
	ValaDataType* _tmp913_;
	ValaDataType* _tmp914_;
	gboolean _tmp915_;
	gboolean _tmp916_;
	gboolean _tmp977_;
	gboolean _tmp978_;
	gboolean result;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp6_ = _tmp5_;
	if (VALA_IS_MEMBER_ACCESS (_tmp6_)) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_member_access_get_null_safe_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		result = !_tmp12_;
		return result;
	}
	_tmp13_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp14_ = _tmp13_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp14_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp15_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_value_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (VALA_IS_DELEGATE_TYPE (_tmp18_)) {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp19_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_expression_get_value_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp23_;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp25_ = _tmp24_;
		if (VALA_IS_MEMBER_ACCESS (_tmp25_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaMemberAccess* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			ValaMemberAccess* _tmp39_;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			gboolean _tmp95_ = FALSE;
			ValaMemberAccess* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			_tmp26_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp27_ = _tmp26_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp28_ = ma;
			_tmp29_ = vala_member_access_get_prototype_access (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaSymbol* _tmp35_;
				ValaSymbol* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_full_name (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp32_, "Access to instance member `%s' denied", _tmp38_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_type_arguments (_tmp39_);
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp41_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaMemberAccess* _tmp51_;
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				gboolean _tmp69_ = FALSE;
				ValaMethod* _tmp70_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_inner (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_expression_get_value_type (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _vala_code_node_ref0 (_tmp49_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp50_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_inner (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_expression_get_symbol_reference (_tmp53_);
				_tmp55_ = _tmp54_;
				if (VALA_IS_SIGNAL (_tmp55_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp56_;
					ValaExpression* _tmp57_;
					ValaExpression* _tmp58_;
					ValaMemberAccess* _tmp59_;
					_tmp56_ = ma;
					_tmp57_ = vala_member_access_get_inner (_tmp56_);
					_tmp58_ = _tmp57_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp58_) ? ((ValaMemberAccess*) _tmp58_) : NULL;
					_tmp59_ = sig;
					if (_tmp59_ != NULL) {
						ValaMemberAccess* _tmp60_;
						ValaExpression* _tmp61_;
						ValaExpression* _tmp62_;
						ValaDataType* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						_tmp60_ = sig;
						_tmp61_ = vala_member_access_get_inner (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_expression_get_value_type (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _vala_code_node_ref0 (_tmp64_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp65_;
					}
				}
				_tmp66_ = ma;
				_tmp67_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp66_);
				_tmp68_ = _tmp67_;
				m = VALA_IS_METHOD (_tmp68_) ? ((ValaMethod*) _tmp68_) : NULL;
				_tmp70_ = m;
				if (_tmp70_ != NULL) {
					ValaMethod* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					_tmp71_ = m;
					_tmp72_ = vala_method_get_coroutine (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp69_ = _tmp73_;
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					gboolean _tmp74_ = FALSE;
					ValaMemberAccess* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp75_ = ma;
					_tmp76_ = vala_member_access_get_member_name (_tmp75_);
					_tmp77_ = _tmp76_;
					if (g_strcmp0 (_tmp77_, "begin") == 0) {
						_tmp74_ = TRUE;
					} else {
						ValaMemberAccess* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						_tmp78_ = ma;
						_tmp79_ = vala_member_access_get_member_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp74_ = g_strcmp0 (_tmp80_, "end") == 0;
					}
					if (_tmp74_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp81_;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						gboolean _tmp84_ = FALSE;
						ValaMemberAccess* _tmp85_;
						_tmp81_ = ma;
						_tmp82_ = vala_member_access_get_inner (_tmp81_);
						_tmp83_ = _tmp82_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp83_) ? ((ValaMemberAccess*) _tmp83_) : NULL;
						_tmp85_ = method_access;
						if (_tmp85_ != NULL) {
							ValaMemberAccess* _tmp86_;
							ValaExpression* _tmp87_;
							ValaExpression* _tmp88_;
							_tmp86_ = method_access;
							_tmp87_ = vala_member_access_get_inner (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp84_ = _tmp88_ != NULL;
						} else {
							_tmp84_ = FALSE;
						}
						if (_tmp84_) {
							ValaMemberAccess* _tmp89_;
							ValaExpression* _tmp90_;
							ValaExpression* _tmp91_;
							ValaDataType* _tmp92_;
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							_tmp89_ = method_access;
							_tmp90_ = vala_member_access_get_inner (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = vala_expression_get_value_type (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = _vala_code_node_ref0 (_tmp93_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp94_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp96_ = ma;
			_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp98_ != NULL) {
				ValaMemberAccess* _tmp99_;
				ValaSymbol* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaAttribute* _tmp102_;
				_tmp99_ = ma;
				_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp101_, "Assert");
				_tmp95_ = _tmp102_ != NULL;
			} else {
				_tmp95_ = FALSE;
			}
			if (_tmp95_) {
				ValaList* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp103_ = self->priv->argument_list;
				_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
				_tmp105_ = _tmp104_;
				if (_tmp105_ == 1) {
					ValaList* _tmp106_;
					gpointer _tmp107_;
					ValaExpression* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp106_ = self->priv->argument_list;
					_tmp107_ = vala_list_get (_tmp106_, 0);
					_tmp108_ = (ValaExpression*) _tmp107_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp110_);
					_vala_code_node_unref0 (_tmp108_);
				}
			}
		}
	}
	_tmp111_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_expression_get_value_type (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = _vala_code_node_ref0 (_tmp114_);
	mtype = _tmp115_;
	_tmp117_ = vala_code_context_get_profile (context);
	_tmp118_ = _tmp117_;
	if (_tmp118_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaSymbol* _tmp121_;
		ValaSymbol* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSemanticAnalyzer* _tmp124_;
		ValaClass* _tmp125_;
		_tmp119_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_symbol_reference (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_code_context_get_analyzer (context);
		_tmp124_ = _tmp123_;
		_tmp125_ = _tmp124_->object_type;
		_tmp116_ = _tmp122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp116_ = FALSE;
	}
	gobject_chainup = _tmp116_;
	vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp128_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		gboolean _tmp138_ = FALSE;
		ValaMemberAccess* _tmp139_;
		_tmp126_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp127_ = _tmp126_;
		expr = _tmp127_;
		_tmp128_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaSymbol* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = VALA_IS_CREATION_METHOD (_tmp133_);
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			ValaMemberAccess* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			_tmp134_ = ma;
			_tmp135_ = vala_member_access_get_inner (_tmp134_);
			_tmp136_ = _tmp135_;
			expr = _tmp136_;
			_tmp137_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp137_) ? ((ValaMemberAccess*) _tmp137_) : NULL;
		}
		_tmp139_ = ma;
		if (_tmp139_ != NULL) {
			ValaMemberAccess* _tmp140_;
			const gchar* _tmp141_;
			const gchar* _tmp142_;
			_tmp140_ = ma;
			_tmp141_ = vala_member_access_get_member_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp138_ = g_strcmp0 (_tmp142_, "this") == 0;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, TRUE);
		} else {
			ValaExpression* _tmp143_;
			_tmp143_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp143_)) {
				vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp144_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
	_tmp145_ = _tmp144_;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp157_;
		ValaDataType* _tmp158_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		cm = VALA_IS_CREATION_METHOD (_tmp148_) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		_tmp149_ = cm;
		if (_tmp149_ == NULL) {
			ValaSourceReference* _tmp150_;
			ValaSourceReference* _tmp151_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp151_ = _tmp150_;
			vala_report_error (_tmp151_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp152_;
			gboolean _tmp153_;
			gboolean _tmp154_;
			_tmp152_ = cm;
			_tmp153_ = vala_creation_method_get_chain_up (_tmp152_);
			_tmp154_ = _tmp153_;
			if (_tmp154_) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				vala_report_error (_tmp156_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp157_ = cm;
		vala_creation_method_set_chain_up (_tmp157_, TRUE);
		_tmp158_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp158_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp159_;
			ValaTypeSymbol* _tmp160_;
			ValaTypeSymbol* _tmp161_;
			ValaClass* _tmp162_;
			ValaCreationMethod* _tmp163_;
			ValaCreationMethod* _tmp164_;
			ValaCreationMethod* _tmp165_;
			_tmp159_ = mtype;
			_tmp160_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp161_ = _tmp160_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_CLASS, ValaClass);
			_tmp162_ = cl;
			_tmp163_ = vala_class_get_default_construction_method (_tmp162_);
			_tmp164_ = _tmp163_;
			base_cm = _tmp164_;
			_tmp165_ = base_cm;
			if (_tmp165_ == NULL) {
				ValaSourceReference* _tmp166_;
				ValaSourceReference* _tmp167_;
				ValaClass* _tmp168_;
				gchar* _tmp169_;
				gchar* _tmp170_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = cl;
				_tmp169_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp168_);
				_tmp170_ = _tmp169_;
				vala_report_error (_tmp167_, "chain up to `%s' not supported", _tmp170_);
				_g_free0 (_tmp170_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp171_;
				gboolean _tmp172_;
				gboolean _tmp173_;
				_tmp171_ = base_cm;
				_tmp172_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp171_);
				_tmp173_ = _tmp172_;
				if (!_tmp173_) {
					ValaSourceReference* _tmp174_;
					ValaSourceReference* _tmp175_;
					ValaCreationMethod* _tmp176_;
					gchar* _tmp177_;
					gchar* _tmp178_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp175_ = _tmp174_;
					_tmp176_ = base_cm;
					_tmp177_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp176_);
					_tmp178_ = _tmp177_;
					vala_report_error (_tmp175_, "chain up to `%s' not supported", _tmp178_);
					_g_free0 (_tmp178_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp179_ = FALSE;
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			ValaSymbol* _tmp182_;
			ValaSymbol* _tmp183_;
			_tmp180_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
			_tmp183_ = _tmp182_;
			if (VALA_IS_CREATION_METHOD (_tmp183_)) {
				ValaExpression* _tmp184_;
				ValaExpression* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				ValaSymbol* _tmp188_;
				ValaSymbol* _tmp189_;
				_tmp184_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_expression_get_symbol_reference (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_symbol_get_parent_symbol (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp179_ = VALA_IS_CLASS (_tmp189_);
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				ValaExpression* _tmp190_;
				ValaExpression* _tmp191_;
				ValaSymbol* _tmp192_;
				ValaSymbol* _tmp193_;
				ValaCreationMethod* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				_tmp190_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_expression_get_symbol_reference (_tmp191_);
				_tmp193_ = _tmp192_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp193_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp194_ = base_cm;
				_tmp195_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp194_);
				_tmp196_ = _tmp195_;
				if (!_tmp196_) {
					ValaSourceReference* _tmp197_;
					ValaSourceReference* _tmp198_;
					ValaCreationMethod* _tmp199_;
					gchar* _tmp200_;
					gchar* _tmp201_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp198_ = _tmp197_;
					_tmp199_ = base_cm;
					_tmp200_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp199_);
					_tmp201_ = _tmp200_;
					vala_report_error (_tmp198_, "chain up to `%s' not supported", _tmp201_);
					_g_free0 (_tmp201_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					gboolean _tmp205_ = FALSE;
					ValaClass* _tmp206_;
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaSemanticAnalyzer* _tmp215_;
					ValaSemanticAnalyzer* _tmp216_;
					ValaClass* _tmp217_;
					ValaSourceReference* _tmp218_;
					ValaSourceReference* _tmp219_;
					ValaObjectType* _tmp220_;
					ValaObjectType* _tmp221_;
					ValaExpression* _tmp222_;
					ValaExpression* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					ValaDataType* _tmp226_;
					_tmp202_ = cm;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					cl = VALA_IS_CLASS (_tmp204_) ? ((ValaClass*) _tmp204_) : NULL;
					_tmp206_ = cl;
					if (_tmp206_ == NULL) {
						_tmp205_ = TRUE;
					} else {
						ValaClass* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaSemanticAnalyzer* _tmp209_;
						ValaClass* _tmp210_;
						_tmp207_ = cl;
						_tmp208_ = vala_code_context_get_analyzer (context);
						_tmp209_ = _tmp208_;
						_tmp210_ = _tmp209_->object_type;
						_tmp205_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp207_, (ValaTypeSymbol*) _tmp210_);
					}
					if (_tmp205_) {
						ValaSourceReference* _tmp211_;
						ValaSourceReference* _tmp212_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp212_ = _tmp211_;
						vala_report_error (_tmp212_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp213_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_code_context_get_analyzer (context);
					_tmp216_ = _tmp215_;
					_tmp217_ = _tmp216_->object_type;
					_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp217_, _tmp219_);
					_tmp221_ = _tmp220_;
					vala_expression_set_value_type (_tmp214_, (ValaDataType*) _tmp221_);
					_vala_code_node_unref0 (_tmp221_);
					_tmp222_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_expression_get_value_type (_tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = _vala_code_node_ref0 (_tmp225_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp226_;
				}
			}
		}
	}
	_tmp228_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp229_ = _tmp228_;
	if (VALA_IS_MEMBER_ACCESS (_tmp229_)) {
		gboolean _tmp230_ = FALSE;
		gboolean _tmp231_ = FALSE;
		ValaExpression* _tmp232_;
		ValaExpression* _tmp233_;
		ValaSymbol* _tmp234_;
		ValaSymbol* _tmp235_;
		_tmp232_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp233_ = _tmp232_;
		_tmp234_ = vala_expression_get_symbol_reference (_tmp233_);
		_tmp235_ = _tmp234_;
		if (VALA_IS_CREATION_METHOD (_tmp235_)) {
			ValaExpression* _tmp236_;
			ValaExpression* _tmp237_;
			ValaSymbol* _tmp238_;
			ValaSymbol* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			_tmp236_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp237_ = _tmp236_;
			_tmp238_ = vala_expression_get_symbol_reference (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_symbol_get_parent_symbol (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp231_ = VALA_IS_STRUCT (_tmp241_);
		} else {
			_tmp231_ = FALSE;
		}
		if (_tmp231_) {
			_tmp230_ = TRUE;
		} else {
			ValaExpression* _tmp242_;
			ValaExpression* _tmp243_;
			ValaSymbol* _tmp244_;
			ValaSymbol* _tmp245_;
			_tmp242_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp243_ = _tmp242_;
			_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
			_tmp245_ = _tmp244_;
			_tmp230_ = VALA_IS_STRUCT (_tmp245_);
		}
		_tmp227_ = _tmp230_;
	} else {
		_tmp227_ = FALSE;
	}
	if (_tmp227_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp246_;
		ValaExpression* _tmp247_;
		ValaSymbol* _tmp248_;
		ValaSymbol* _tmp249_;
		gboolean _tmp250_ = FALSE;
		gboolean _tmp251_ = FALSE;
		ValaStruct* _tmp252_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp263_;
		ValaExpression* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaSourceReference* _tmp266_;
		ValaObjectCreationExpression* _tmp267_;
		ValaObjectCreationExpression* _tmp268_;
		ValaObjectCreationExpression* _tmp269_;
		gboolean _tmp270_;
		gboolean _tmp271_;
		ValaObjectCreationExpression* _tmp282_;
		ValaDataType* _tmp283_;
		ValaDataType* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaList* _tmp287_;
		ValaCodeNode* _tmp288_;
		ValaCodeNode* _tmp289_;
		ValaObjectCreationExpression* _tmp290_;
		ValaObjectCreationExpression* _tmp291_;
		_tmp246_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp247_ = _tmp246_;
		_tmp248_ = vala_expression_get_symbol_reference (_tmp247_);
		_tmp249_ = _tmp248_;
		st = VALA_IS_STRUCT (_tmp249_) ? ((ValaStruct*) _tmp249_) : NULL;
		_tmp252_ = st;
		if (_tmp252_ != NULL) {
			ValaStruct* _tmp253_;
			ValaCreationMethod* _tmp254_;
			ValaCreationMethod* _tmp255_;
			_tmp253_ = st;
			_tmp254_ = vala_struct_get_default_construction_method (_tmp253_);
			_tmp255_ = _tmp254_;
			_tmp251_ = _tmp255_ == NULL;
		} else {
			_tmp251_ = FALSE;
		}
		if (_tmp251_) {
			gboolean _tmp256_ = FALSE;
			gboolean _tmp257_ = FALSE;
			ValaStruct* _tmp258_;
			_tmp258_ = st;
			if (vala_struct_is_boolean_type (_tmp258_)) {
				_tmp257_ = TRUE;
			} else {
				ValaStruct* _tmp259_;
				_tmp259_ = st;
				_tmp257_ = vala_struct_is_integer_type (_tmp259_);
			}
			if (_tmp257_) {
				_tmp256_ = TRUE;
			} else {
				ValaStruct* _tmp260_;
				_tmp260_ = st;
				_tmp256_ = vala_struct_is_floating_type (_tmp260_);
			}
			_tmp250_ = _tmp256_;
		} else {
			_tmp250_ = FALSE;
		}
		if (_tmp250_) {
			ValaSourceReference* _tmp261_;
			ValaSourceReference* _tmp262_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp262_ = _tmp261_;
			vala_report_error (_tmp262_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp263_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp264_ = _tmp263_;
		_tmp265_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp266_ = _tmp265_;
		_tmp267_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp266_);
		struct_creation_expression = _tmp267_;
		_tmp268_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp268_, TRUE);
		_tmp269_ = struct_creation_expression;
		_tmp270_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
		_tmp271_ = _tmp270_;
		vala_callable_expression_set_is_chainup ((ValaCallableExpression*) _tmp269_, _tmp271_);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp272_;
			gint _arg_size = 0;
			ValaList* _tmp273_;
			gint _tmp274_;
			gint _tmp275_;
			gint _arg_index = 0;
			_tmp272_ = self->priv->argument_list;
			_arg_list = _tmp272_;
			_tmp273_ = _arg_list;
			_tmp274_ = vala_collection_get_size ((ValaCollection*) _tmp273_);
			_tmp275_ = _tmp274_;
			_arg_size = _tmp275_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp276_;
				gint _tmp277_;
				ValaExpression* arg = NULL;
				ValaList* _tmp278_;
				gpointer _tmp279_;
				ValaObjectCreationExpression* _tmp280_;
				ValaExpression* _tmp281_;
				_arg_index = _arg_index + 1;
				_tmp276_ = _arg_index;
				_tmp277_ = _arg_size;
				if (!(_tmp276_ < _tmp277_)) {
					break;
				}
				_tmp278_ = _arg_list;
				_tmp279_ = vala_list_get (_tmp278_, _arg_index);
				arg = (ValaExpression*) _tmp279_;
				_tmp280_ = struct_creation_expression;
				_tmp281_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp280_, _tmp281_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp282_ = struct_creation_expression;
		_tmp283_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp284_ = _tmp283_;
		vala_expression_set_target_type ((ValaExpression*) _tmp282_, _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp287_, (ValaCodeNode*) self);
		_tmp288_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp289_ = _tmp288_;
		_tmp290_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp289_, (ValaExpression*) self, (ValaExpression*) _tmp290_);
		_tmp291_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp291_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp292_ = FALSE;
		gboolean _tmp293_ = FALSE;
		gboolean _tmp294_;
		gboolean _tmp295_;
		_tmp294_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
		_tmp295_ = _tmp294_;
		if (!_tmp295_) {
			ValaExpression* _tmp296_;
			ValaExpression* _tmp297_;
			_tmp296_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp297_ = _tmp296_;
			_tmp293_ = VALA_IS_MEMBER_ACCESS (_tmp297_);
		} else {
			_tmp293_ = FALSE;
		}
		if (_tmp293_) {
			ValaExpression* _tmp298_;
			ValaExpression* _tmp299_;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			_tmp298_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_expression_get_symbol_reference (_tmp299_);
			_tmp301_ = _tmp300_;
			_tmp292_ = VALA_IS_CREATION_METHOD (_tmp301_);
		} else {
			_tmp292_ = FALSE;
		}
		if (_tmp292_) {
			ValaSourceReference* _tmp302_;
			ValaSourceReference* _tmp303_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp302_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp303_ = _tmp302_;
			vala_report_error (_tmp303_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp305_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
	_tmp306_ = _tmp305_;
	if (!_tmp306_) {
		ValaDataType* _tmp307_;
		_tmp307_ = mtype;
		_tmp304_ = VALA_IS_OBJECT_TYPE (_tmp307_);
	} else {
		_tmp304_ = FALSE;
	}
	if (_tmp304_) {
		ValaSourceReference* _tmp308_;
		ValaSourceReference* _tmp309_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp309_ = _tmp308_;
		vala_report_error (_tmp309_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp310_ = FALSE;
		ValaDataType* _tmp311_;
		_tmp311_ = mtype;
		if (_tmp311_ != NULL) {
			ValaDataType* _tmp312_;
			_tmp312_ = mtype;
			_tmp310_ = vala_data_type_is_invokable (_tmp312_);
		} else {
			_tmp310_ = FALSE;
		}
		if (_tmp310_) {
		} else {
			ValaExpression* _tmp313_;
			ValaExpression* _tmp314_;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			_tmp313_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp314_ = _tmp313_;
			_tmp315_ = vala_expression_get_symbol_reference (_tmp314_);
			_tmp316_ = _tmp315_;
			if (VALA_IS_CLASS (_tmp316_)) {
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_report_error (_tmp318_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp319_;
				ValaSourceReference* _tmp320_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp319_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp320_ = _tmp319_;
				vala_report_error (_tmp320_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp321_ = mtype;
	_tmp322_ = vala_data_type_get_return_type (_tmp321_);
	_tmp323_ = _vala_code_node_ref0 (_tmp322_);
	ret_type = _tmp323_;
	_tmp324_ = mtype;
	_tmp325_ = vala_data_type_get_parameters (_tmp324_);
	_tmp326_ = _vala_iterable_ref0 (_tmp325_);
	params = _tmp326_;
	_tmp327_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp327_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp328_;
		ValaExpression* _tmp329_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp330_;
		ValaMethod* _tmp331_;
		ValaMethod* _tmp332_;
		ValaMethod* _tmp333_;
		gboolean _tmp334_;
		gboolean _tmp335_;
		gint n_type_params = 0;
		ValaMethod* _tmp367_;
		ValaList* _tmp368_;
		gint _tmp369_;
		gint _tmp370_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp371_;
		ValaList* _tmp372_;
		gint _tmp373_;
		gint _tmp374_;
		gboolean _tmp375_ = FALSE;
		_tmp328_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp329_ = _tmp328_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp329_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp330_ = mtype;
		_tmp331_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp332_ = _tmp331_;
		m = _tmp332_;
		_tmp333_ = m;
		_tmp334_ = vala_method_get_coroutine (_tmp333_);
		_tmp335_ = _tmp334_;
		if (_tmp335_) {
			gboolean _tmp336_;
			gboolean _tmp337_;
			_tmp336_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp337_ = _tmp336_;
			if (!_tmp337_) {
				ValaMemberAccess* _tmp338_;
				const gchar* _tmp339_;
				const gchar* _tmp340_;
				_tmp338_ = ma;
				_tmp339_ = vala_member_access_get_member_name (_tmp338_);
				_tmp340_ = _tmp339_;
				if (g_strcmp0 (_tmp340_, "end") != 0) {
					ValaMemberAccess* _tmp341_;
					const gchar* _tmp342_;
					const gchar* _tmp343_;
					ValaMethod* _tmp347_;
					ValaList* _tmp348_;
					ValaList* _tmp349_;
					ValaVoidType* _tmp350_;
					_tmp341_ = ma;
					_tmp342_ = vala_member_access_get_member_name (_tmp341_);
					_tmp343_ = _tmp342_;
					if (g_strcmp0 (_tmp343_, "begin") != 0) {
						ValaMemberAccess* _tmp344_;
						ValaSourceReference* _tmp345_;
						ValaSourceReference* _tmp346_;
						_tmp344_ = ma;
						_tmp345_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp344_);
						_tmp346_ = _tmp345_;
						vala_report_deprecated (_tmp346_, "implicit .begin is deprecated");
					}
					_tmp347_ = m;
					_tmp348_ = vala_method_get_async_begin_parameters (_tmp347_);
					_tmp349_ = _vala_iterable_ref0 (_tmp348_);
					_vala_iterable_unref0 (params);
					params = _tmp349_;
					_tmp350_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp350_;
				} else {
					ValaMethod* _tmp351_;
					ValaList* _tmp352_;
					ValaList* _tmp353_;
					_tmp351_ = m;
					_tmp352_ = vala_method_get_async_end_parameters (_tmp351_);
					_tmp353_ = _vala_iterable_ref0 (_tmp352_);
					_vala_iterable_unref0 (params);
					params = _tmp353_;
				}
			} else {
				gboolean _tmp354_ = FALSE;
				ValaMemberAccess* _tmp355_;
				const gchar* _tmp356_;
				const gchar* _tmp357_;
				_tmp355_ = ma;
				_tmp356_ = vala_member_access_get_member_name (_tmp355_);
				_tmp357_ = _tmp356_;
				if (g_strcmp0 (_tmp357_, "begin") == 0) {
					_tmp354_ = TRUE;
				} else {
					ValaMemberAccess* _tmp358_;
					const gchar* _tmp359_;
					const gchar* _tmp360_;
					_tmp358_ = ma;
					_tmp359_ = vala_member_access_get_member_name (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp354_ = g_strcmp0 (_tmp360_, "end") == 0;
				}
				if (_tmp354_) {
					ValaMemberAccess* _tmp361_;
					ValaSourceReference* _tmp362_;
					ValaSourceReference* _tmp363_;
					ValaMemberAccess* _tmp364_;
					const gchar* _tmp365_;
					const gchar* _tmp366_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp361_ = ma;
					_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp361_);
					_tmp363_ = _tmp362_;
					_tmp364_ = ma;
					_tmp365_ = vala_member_access_get_member_name (_tmp364_);
					_tmp366_ = _tmp365_;
					vala_report_error (_tmp363_, "use of `%s' not allowed in yield statement", _tmp366_);
				}
			}
		}
		_tmp367_ = m;
		_tmp368_ = vala_method_get_type_parameters (_tmp367_);
		_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
		_tmp370_ = _tmp369_;
		n_type_params = _tmp370_;
		_tmp371_ = ma;
		_tmp372_ = vala_member_access_get_type_arguments (_tmp371_);
		_tmp373_ = vala_collection_get_size ((ValaCollection*) _tmp372_);
		_tmp374_ = _tmp373_;
		n_type_args = _tmp374_;
		if (n_type_args > 0) {
			_tmp375_ = n_type_args < n_type_params;
		} else {
			_tmp375_ = FALSE;
		}
		if (_tmp375_) {
			ValaMemberAccess* _tmp376_;
			ValaSourceReference* _tmp377_;
			ValaSourceReference* _tmp378_;
			ValaMethod* _tmp379_;
			gchar* _tmp380_;
			gchar* _tmp381_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp376_ = ma;
			_tmp377_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp376_);
			_tmp378_ = _tmp377_;
			_tmp379_ = m;
			_tmp380_ = vala_code_node_to_string ((ValaCodeNode*) _tmp379_);
			_tmp381_ = _tmp380_;
			vala_report_error (_tmp378_, "too few type arguments for `%s'", _tmp381_);
			_g_free0 (_tmp381_);
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp382_ = FALSE;
			if (n_type_args > 0) {
				_tmp382_ = n_type_args > n_type_params;
			} else {
				_tmp382_ = FALSE;
			}
			if (_tmp382_) {
				ValaMemberAccess* _tmp383_;
				ValaSourceReference* _tmp384_;
				ValaSourceReference* _tmp385_;
				ValaMethod* _tmp386_;
				gchar* _tmp387_;
				gchar* _tmp388_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp383_ = ma;
				_tmp384_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp383_);
				_tmp385_ = _tmp384_;
				_tmp386_ = m;
				_tmp387_ = vala_code_node_to_string ((ValaCodeNode*) _tmp386_);
				_tmp388_ = _tmp387_;
				vala_report_error (_tmp385_, "too many type arguments for `%s'", _tmp388_);
				_g_free0 (_tmp388_);
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp389_ = self->priv->argument_list;
	_tmp390_ = vala_iterable_iterator ((ValaIterable*) _tmp389_);
	arg_it = _tmp390_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp391_;
		gint _param_size = 0;
		ValaList* _tmp392_;
		gint _tmp393_;
		gint _tmp394_;
		gint _param_index = 0;
		_tmp391_ = params;
		_param_list = _tmp391_;
		_tmp392_ = _param_list;
		_tmp393_ = vala_collection_get_size ((ValaCollection*) _tmp392_);
		_tmp394_ = _tmp393_;
		_param_size = _tmp394_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp395_;
			gint _tmp396_;
			ValaParameter* param = NULL;
			ValaList* _tmp397_;
			gpointer _tmp398_;
			ValaParameter* _tmp399_;
			ValaParameter* _tmp400_;
			gboolean _tmp401_;
			gboolean _tmp402_;
			ValaParameter* _tmp403_;
			gboolean _tmp404_;
			gboolean _tmp405_;
			ValaIterator* _tmp423_;
			_param_index = _param_index + 1;
			_tmp395_ = _param_index;
			_tmp396_ = _param_size;
			if (!(_tmp395_ < _tmp396_)) {
				break;
			}
			_tmp397_ = _param_list;
			_tmp398_ = vala_list_get (_tmp397_, _param_index);
			param = (ValaParameter*) _tmp398_;
			_tmp399_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp399_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp400_ = param;
			_tmp401_ = vala_parameter_get_ellipsis (_tmp400_);
			_tmp402_ = _tmp401_;
			if (_tmp402_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp403_ = param;
			_tmp404_ = vala_parameter_get_params_array (_tmp403_);
			_tmp405_ = _tmp404_;
			if (_tmp405_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp406_;
				ValaDataType* _tmp407_;
				ValaDataType* _tmp408_;
				ValaArrayType* _tmp409_;
				_tmp406_ = param;
				_tmp407_ = vala_variable_get_variable_type ((ValaVariable*) _tmp406_);
				_tmp408_ = _tmp407_;
				_tmp409_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp408_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp409_;
				while (TRUE) {
					ValaIterator* _tmp410_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp411_;
					gpointer _tmp412_;
					ValaExpression* _tmp413_;
					ValaArrayType* _tmp414_;
					ValaDataType* _tmp415_;
					ValaDataType* _tmp416_;
					ValaExpression* _tmp417_;
					ValaDataType* _tmp418_;
					ValaDataType* _tmp419_;
					ValaArrayType* _tmp420_;
					gboolean _tmp421_;
					gboolean _tmp422_;
					_tmp410_ = arg_it;
					if (!vala_iterator_next (_tmp410_)) {
						break;
					}
					_tmp411_ = arg_it;
					_tmp412_ = vala_iterator_get (_tmp411_);
					arg = (ValaExpression*) _tmp412_;
					_tmp413_ = arg;
					_tmp414_ = array_type;
					_tmp415_ = vala_array_type_get_element_type (_tmp414_);
					_tmp416_ = _tmp415_;
					vala_expression_set_target_type (_tmp413_, _tmp416_);
					_tmp417_ = arg;
					_tmp418_ = vala_expression_get_target_type (_tmp417_);
					_tmp419_ = _tmp418_;
					_tmp420_ = array_type;
					_tmp421_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp420_);
					_tmp422_ = _tmp421_;
					vala_data_type_set_value_owned (_tmp419_, _tmp422_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp423_ = arg_it;
			if (vala_iterator_next (_tmp423_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp424_;
				gpointer _tmp425_;
				ValaExpression* _tmp426_;
				ValaParameter* _tmp427_;
				ValaDataType* _tmp428_;
				ValaDataType* _tmp429_;
				ValaExpression* _tmp430_;
				ValaExpression* _tmp431_;
				ValaDataType* _tmp432_;
				ValaDataType* _tmp433_;
				ValaDataType* _tmp434_;
				ValaList* _tmp435_;
				ValaDataType* _tmp436_;
				ValaDataType* _tmp437_;
				ValaExpression* _tmp438_;
				ValaExpression* _tmp439_;
				_tmp424_ = arg_it;
				_tmp425_ = vala_iterator_get (_tmp424_);
				arg = (ValaExpression*) _tmp425_;
				_tmp426_ = arg;
				_tmp427_ = param;
				_tmp428_ = vala_variable_get_variable_type ((ValaVariable*) _tmp427_);
				_tmp429_ = _tmp428_;
				vala_expression_set_formal_target_type (_tmp426_, _tmp429_);
				_tmp430_ = arg;
				_tmp431_ = arg;
				_tmp432_ = vala_expression_get_formal_target_type (_tmp431_);
				_tmp433_ = _tmp432_;
				_tmp434_ = target_object_type;
				_tmp435_ = method_type_args;
				_tmp436_ = vala_data_type_get_actual_type (_tmp433_, _tmp434_, _tmp435_, (ValaCodeNode*) self);
				_tmp437_ = _tmp436_;
				vala_expression_set_target_type (_tmp430_, _tmp437_);
				_vala_code_node_unref0 (_tmp437_);
				_tmp438_ = arg;
				_tmp439_ = _vala_code_node_ref0 (_tmp438_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp439_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp441_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp441_)) {
		ValaDataType* _tmp442_;
		ValaMethod* _tmp443_;
		ValaMethod* _tmp444_;
		ValaAttribute* _tmp445_;
		_tmp442_ = mtype;
		_tmp443_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp442_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp444_ = _tmp443_;
		_tmp445_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp444_, "Print");
		_tmp440_ = _tmp445_ != NULL;
	} else {
		_tmp440_ = FALSE;
	}
	if (_tmp440_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp446_;
		ValaSourceReference* _tmp447_;
		ValaTemplate* _tmp448_;
		ValaList* _tmp460_;
		ValaTemplate* _tmp461_;
		_tmp446_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp447_ = _tmp446_;
		_tmp448_ = vala_template_new (_tmp447_);
		template = _tmp448_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp449_;
			gint _arg_size = 0;
			ValaList* _tmp450_;
			gint _tmp451_;
			gint _tmp452_;
			gint _arg_index = 0;
			_tmp449_ = self->priv->argument_list;
			_arg_list = _tmp449_;
			_tmp450_ = _arg_list;
			_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
			_tmp452_ = _tmp451_;
			_arg_size = _tmp452_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp453_;
				gint _tmp454_;
				ValaExpression* arg = NULL;
				ValaList* _tmp455_;
				gpointer _tmp456_;
				ValaExpression* _tmp457_;
				ValaTemplate* _tmp458_;
				ValaExpression* _tmp459_;
				_arg_index = _arg_index + 1;
				_tmp453_ = _arg_index;
				_tmp454_ = _arg_size;
				if (!(_tmp453_ < _tmp454_)) {
					break;
				}
				_tmp455_ = _arg_list;
				_tmp456_ = vala_list_get (_tmp455_, _arg_index);
				arg = (ValaExpression*) _tmp456_;
				_tmp457_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp457_, NULL);
				_tmp458_ = template;
				_tmp459_ = arg;
				vala_template_add_expression (_tmp458_, _tmp459_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp460_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp460_);
		_tmp461_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp461_);
		_vala_code_node_unref0 (template);
	}
	_tmp463_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp463_)) {
		ValaDataType* _tmp464_;
		ValaMethod* _tmp465_;
		ValaMethod* _tmp466_;
		gboolean _tmp467_;
		gboolean _tmp468_;
		_tmp464_ = mtype;
		_tmp465_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp464_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_method_get_printf_format (_tmp466_);
		_tmp468_ = _tmp467_;
		_tmp462_ = _tmp468_;
	} else {
		_tmp462_ = FALSE;
	}
	if (_tmp462_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp469_;
		ValaStringLiteral* _tmp518_;
		format_literal = NULL;
		_tmp469_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp469_)) {
		} else {
			ValaExpression* _tmp470_;
			_tmp470_ = last_arg;
			if (_tmp470_ != NULL) {
				ValaExpression* _tmp471_;
				ValaStringLiteral* _tmp472_;
				gboolean _tmp473_ = FALSE;
				ValaStringLiteral* _tmp474_;
				_tmp471_ = last_arg;
				_tmp472_ = vala_string_literal_get_format_literal (_tmp471_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp472_;
				_tmp474_ = format_literal;
				if (_tmp474_ == NULL) {
					ValaList* _tmp475_;
					gint _tmp476_;
					gint _tmp477_;
					ValaList* _tmp478_;
					gint _tmp479_;
					gint _tmp480_;
					_tmp475_ = self->priv->argument_list;
					_tmp476_ = vala_collection_get_size ((ValaCollection*) _tmp475_);
					_tmp477_ = _tmp476_;
					_tmp478_ = params;
					_tmp479_ = vala_collection_get_size ((ValaCollection*) _tmp478_);
					_tmp480_ = _tmp479_;
					_tmp473_ = _tmp477_ == (_tmp480_ - 1);
				} else {
					_tmp473_ = FALSE;
				}
				if (_tmp473_) {
					ValaStringLiteral* _tmp481_;
					ValaStringLiteral* _tmp482_;
					ValaSemanticAnalyzer* _tmp483_;
					ValaSemanticAnalyzer* _tmp484_;
					ValaDataType* _tmp485_;
					ValaDataType* _tmp486_;
					ValaDataType* _tmp487_;
					ValaList* _tmp488_;
					ValaList* _tmp489_;
					gint _tmp490_;
					gint _tmp491_;
					ValaStringLiteral* _tmp492_;
					ValaList* _tmp493_;
					ValaIterator* _tmp494_;
					_tmp481_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp481_;
					_tmp482_ = format_literal;
					_tmp483_ = vala_code_context_get_analyzer (context);
					_tmp484_ = _tmp483_;
					_tmp485_ = _tmp484_->string_type;
					_tmp486_ = vala_data_type_copy (_tmp485_);
					_tmp487_ = _tmp486_;
					vala_expression_set_target_type ((ValaExpression*) _tmp482_, _tmp487_);
					_vala_code_node_unref0 (_tmp487_);
					_tmp488_ = self->priv->argument_list;
					_tmp489_ = self->priv->argument_list;
					_tmp490_ = vala_collection_get_size ((ValaCollection*) _tmp489_);
					_tmp491_ = _tmp490_;
					_tmp492_ = format_literal;
					vala_list_insert (_tmp488_, _tmp491_ - 1, (ValaExpression*) _tmp492_);
					_tmp493_ = self->priv->argument_list;
					_tmp494_ = vala_iterable_iterator ((ValaIterable*) _tmp493_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp494_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp495_;
						gint _param_size = 0;
						ValaList* _tmp496_;
						gint _tmp497_;
						gint _tmp498_;
						gint _param_index = 0;
						_tmp495_ = params;
						_param_list = _tmp495_;
						_tmp496_ = _param_list;
						_tmp497_ = vala_collection_get_size ((ValaCollection*) _tmp496_);
						_tmp498_ = _tmp497_;
						_param_size = _tmp498_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp499_;
							gint _tmp500_;
							ValaParameter* param = NULL;
							ValaList* _tmp501_;
							gpointer _tmp502_;
							gboolean _tmp503_ = FALSE;
							ValaParameter* _tmp504_;
							gboolean _tmp505_;
							gboolean _tmp506_;
							ValaIterator* _tmp510_;
							_param_index = _param_index + 1;
							_tmp499_ = _param_index;
							_tmp500_ = _param_size;
							if (!(_tmp499_ < _tmp500_)) {
								break;
							}
							_tmp501_ = _param_list;
							_tmp502_ = vala_list_get (_tmp501_, _param_index);
							param = (ValaParameter*) _tmp502_;
							_tmp504_ = param;
							_tmp505_ = vala_parameter_get_ellipsis (_tmp504_);
							_tmp506_ = _tmp505_;
							if (_tmp506_) {
								_tmp503_ = TRUE;
							} else {
								ValaParameter* _tmp507_;
								gboolean _tmp508_;
								gboolean _tmp509_;
								_tmp507_ = param;
								_tmp508_ = vala_parameter_get_params_array (_tmp507_);
								_tmp509_ = _tmp508_;
								_tmp503_ = _tmp509_;
							}
							if (_tmp503_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp510_ = arg_it;
							vala_iterator_next (_tmp510_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp511_;
				ValaExpression* _tmp512_;
				ValaMemberAccess* _tmp513_;
				_tmp511_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp512_ = _tmp511_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp512_) ? ((ValaMemberAccess*) _tmp512_) : NULL;
				_tmp513_ = ma;
				if (_tmp513_ != NULL) {
					ValaMemberAccess* _tmp514_;
					ValaExpression* _tmp515_;
					ValaExpression* _tmp516_;
					ValaStringLiteral* _tmp517_;
					_tmp514_ = ma;
					_tmp515_ = vala_member_access_get_inner (_tmp514_);
					_tmp516_ = _tmp515_;
					_tmp517_ = vala_string_literal_get_format_literal (_tmp516_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp517_;
				}
			}
		}
		_tmp518_ = format_literal;
		if (_tmp518_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp519_;
			gchar* _tmp520_;
			ValaSemanticAnalyzer* _tmp521_;
			ValaSemanticAnalyzer* _tmp522_;
			const gchar* _tmp523_;
			ValaIterator* _tmp524_;
			ValaSourceReference* _tmp525_;
			ValaSourceReference* _tmp526_;
			_tmp519_ = format_literal;
			_tmp520_ = vala_string_literal_eval (_tmp519_);
			format = _tmp520_;
			_tmp521_ = vala_code_context_get_analyzer (context);
			_tmp522_ = _tmp521_;
			_tmp523_ = format;
			_tmp524_ = arg_it;
			_tmp525_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp526_ = _tmp525_;
			if (!vala_semantic_analyzer_check_print_format (_tmp522_, _tmp523_, _tmp524_, _tmp526_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp527_;
		gint _arg_size = 0;
		ValaList* _tmp528_;
		gint _tmp529_;
		gint _tmp530_;
		gint _arg_index = 0;
		_tmp527_ = self->priv->argument_list;
		_arg_list = _tmp527_;
		_tmp528_ = _arg_list;
		_tmp529_ = vala_collection_get_size ((ValaCollection*) _tmp528_);
		_tmp530_ = _tmp529_;
		_arg_size = _tmp530_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp531_;
			gint _tmp532_;
			ValaExpression* arg = NULL;
			ValaList* _tmp533_;
			gpointer _tmp534_;
			ValaExpression* _tmp535_;
			gboolean _tmp536_ = FALSE;
			ValaExpression* _tmp537_;
			_arg_index = _arg_index + 1;
			_tmp531_ = _arg_index;
			_tmp532_ = _arg_size;
			if (!(_tmp531_ < _tmp532_)) {
				break;
			}
			_tmp533_ = _arg_list;
			_tmp534_ = vala_list_get (_tmp533_, _arg_index);
			arg = (ValaExpression*) _tmp534_;
			_tmp535_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp535_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp537_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp537_)) {
				ValaExpression* _tmp538_;
				ValaMethod* _tmp539_;
				ValaMethod* _tmp540_;
				gboolean _tmp541_;
				gboolean _tmp542_;
				_tmp538_ = arg;
				_tmp539_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp538_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp540_ = _tmp539_;
				_tmp541_ = vala_method_get_closure (_tmp540_);
				_tmp542_ = _tmp541_;
				_tmp536_ = _tmp542_;
			} else {
				_tmp536_ = FALSE;
			}
			if (_tmp536_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp544_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp545_ = _tmp544_;
	if (!_tmp545_) {
		_tmp543_ = force_lambda_method_closure;
	} else {
		_tmp543_ = FALSE;
	}
	if (_tmp543_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp546_;
			gint _arg_size = 0;
			ValaList* _tmp547_;
			gint _tmp548_;
			gint _tmp549_;
			gint _arg_index = 0;
			_tmp546_ = self->priv->argument_list;
			_arg_list = _tmp546_;
			_tmp547_ = _arg_list;
			_tmp548_ = vala_collection_get_size ((ValaCollection*) _tmp547_);
			_tmp549_ = _tmp548_;
			_arg_size = _tmp549_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp550_;
				gint _tmp551_;
				ValaExpression* arg = NULL;
				ValaList* _tmp552_;
				gpointer _tmp553_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp554_;
				gboolean _tmp555_ = FALSE;
				ValaLambdaExpression* _tmp556_;
				_arg_index = _arg_index + 1;
				_tmp550_ = _arg_index;
				_tmp551_ = _arg_size;
				if (!(_tmp550_ < _tmp551_)) {
					break;
				}
				_tmp552_ = _arg_list;
				_tmp553_ = vala_list_get (_tmp552_, _arg_index);
				arg = (ValaExpression*) _tmp553_;
				_tmp554_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp554_) ? ((ValaLambdaExpression*) _tmp554_) : NULL;
				_tmp556_ = lambda;
				if (_tmp556_ != NULL) {
					ValaLambdaExpression* _tmp557_;
					ValaMethod* _tmp558_;
					ValaMethod* _tmp559_;
					ValaMemberBinding _tmp560_;
					ValaMemberBinding _tmp561_;
					_tmp557_ = lambda;
					_tmp558_ = vala_lambda_expression_get_method (_tmp557_);
					_tmp559_ = _tmp558_;
					_tmp560_ = vala_method_get_binding (_tmp559_);
					_tmp561_ = _tmp560_;
					_tmp555_ = _tmp561_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp555_ = FALSE;
				}
				if (_tmp555_) {
					ValaLambdaExpression* _tmp562_;
					ValaMethod* _tmp563_;
					ValaMethod* _tmp564_;
					_tmp562_ = lambda;
					_tmp563_ = vala_lambda_expression_get_method (_tmp562_);
					_tmp564_ = _tmp563_;
					vala_method_set_closure (_tmp564_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp565_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp565_)) {
		gboolean _tmp566_ = FALSE;
		gboolean _tmp567_ = FALSE;
		ValaCodeNode* _tmp568_;
		ValaCodeNode* _tmp569_;
		_tmp568_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp569_ = _tmp568_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp569_)) {
			ValaCodeNode* _tmp570_;
			ValaCodeNode* _tmp571_;
			_tmp570_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp571_ = _tmp570_;
			_tmp567_ = !VALA_IS_FOR_STATEMENT (_tmp571_);
		} else {
			_tmp567_ = FALSE;
		}
		if (_tmp567_) {
			ValaCodeNode* _tmp572_;
			ValaCodeNode* _tmp573_;
			_tmp572_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp573_ = _tmp572_;
			_tmp566_ = !VALA_IS_YIELD_STATEMENT (_tmp573_);
		} else {
			_tmp566_ = FALSE;
		}
		if (_tmp566_) {
			ValaSourceReference* _tmp574_;
			ValaSourceReference* _tmp575_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp574_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp575_ = _tmp574_;
			vala_report_error (_tmp575_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp576_ = ret_type;
	_tmp577_ = vala_data_type_copy (_tmp576_);
	_tmp578_ = _tmp577_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp578_);
	_vala_code_node_unref0 (_tmp578_);
	_tmp579_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp580_ = _tmp579_;
	_tmp581_ = target_object_type;
	_tmp582_ = method_type_args;
	_tmp583_ = vala_data_type_get_actual_type (_tmp580_, _tmp581_, _tmp582_, (ValaCodeNode*) self);
	_tmp584_ = _tmp583_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp584_);
	_vala_code_node_unref0 (_tmp584_);
	_tmp585_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp586_ = _tmp585_;
	if (_tmp586_) {
		gboolean _tmp587_ = FALSE;
		ValaDataType* _tmp588_;
		gboolean _tmp596_ = FALSE;
		ValaSemanticAnalyzer* _tmp597_;
		ValaSemanticAnalyzer* _tmp598_;
		ValaMethod* _tmp599_;
		ValaMethod* _tmp600_;
		_tmp588_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp588_)) {
			_tmp587_ = TRUE;
		} else {
			ValaDataType* _tmp589_;
			ValaMethod* _tmp590_;
			ValaMethod* _tmp591_;
			gboolean _tmp592_;
			gboolean _tmp593_;
			_tmp589_ = mtype;
			_tmp590_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp589_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp591_ = _tmp590_;
			_tmp592_ = vala_method_get_coroutine (_tmp591_);
			_tmp593_ = _tmp592_;
			_tmp587_ = !_tmp593_;
		}
		if (_tmp587_) {
			ValaSourceReference* _tmp594_;
			ValaSourceReference* _tmp595_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp594_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp595_ = _tmp594_;
			vala_report_error (_tmp595_, "yield expression requires async method");
		}
		_tmp597_ = vala_code_context_get_analyzer (context);
		_tmp598_ = _tmp597_;
		_tmp599_ = vala_semantic_analyzer_get_current_method (_tmp598_);
		_tmp600_ = _tmp599_;
		if (_tmp600_ == NULL) {
			_tmp596_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp601_;
			ValaSemanticAnalyzer* _tmp602_;
			ValaMethod* _tmp603_;
			ValaMethod* _tmp604_;
			gboolean _tmp605_;
			gboolean _tmp606_;
			_tmp601_ = vala_code_context_get_analyzer (context);
			_tmp602_ = _tmp601_;
			_tmp603_ = vala_semantic_analyzer_get_current_method (_tmp602_);
			_tmp604_ = _tmp603_;
			_tmp605_ = vala_method_get_coroutine (_tmp604_);
			_tmp606_ = _tmp605_;
			_tmp596_ = !_tmp606_;
		}
		if (_tmp596_) {
			ValaSourceReference* _tmp607_;
			ValaSourceReference* _tmp608_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp607_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp608_ = _tmp607_;
			vala_report_error (_tmp608_, "yield expression not available outside async method");
		}
	}
	_tmp609_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp609_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp610_;
		ValaMethod* _tmp611_;
		ValaMethod* _tmp612_;
		ValaMethod* _tmp613_;
		gboolean _tmp614_;
		gboolean _tmp615_;
		ValaMethod* _tmp618_;
		gboolean _tmp619_;
		gboolean _tmp620_;
		gboolean _tmp646_ = FALSE;
		gboolean _tmp647_ = FALSE;
		gboolean _tmp648_ = FALSE;
		gboolean _tmp649_;
		gboolean _tmp650_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp662_;
		ValaSymbol* _tmp663_;
		ValaSymbol* _tmp664_;
		gboolean _tmp665_ = FALSE;
		ValaSignal* _tmp666_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp679_;
		ValaSymbol* _tmp680_;
		ValaSymbol* _tmp681_;
		gboolean _tmp682_ = FALSE;
		ValaDynamicSignal* _tmp683_;
		gboolean _tmp728_ = FALSE;
		ValaMethod* _tmp729_;
		gboolean _tmp837_ = FALSE;
		ValaMethod* _tmp838_;
		_tmp610_ = mtype;
		_tmp611_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp610_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp612_ = _tmp611_;
		m = _tmp612_;
		_tmp613_ = m;
		_tmp614_ = vala_method_get_returns_floating_reference (_tmp613_);
		_tmp615_ = _tmp614_;
		if (_tmp615_) {
			ValaDataType* _tmp616_;
			ValaDataType* _tmp617_;
			_tmp616_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp617_ = _tmp616_;
			vala_data_type_set_floating_reference (_tmp617_, TRUE);
		}
		_tmp618_ = m;
		_tmp619_ = vala_method_get_returns_modified_pointer (_tmp618_);
		_tmp620_ = _tmp619_;
		if (_tmp620_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp621_;
			ValaExpression* _tmp622_;
			ValaExpression* _tmp623_;
			ValaExpression* _tmp624_;
			ValaExpression* _tmp625_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp626_;
			ValaSymbol* _tmp627_;
			ValaSymbol* _tmp628_;
			gboolean _tmp629_ = FALSE;
			ValaProperty* _tmp630_;
			_tmp621_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp622_ = _tmp621_;
			_tmp623_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp622_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp624_ = _tmp623_;
			inner = _tmp624_;
			_tmp625_ = inner;
			vala_expression_set_lvalue (_tmp625_, TRUE);
			_tmp626_ = inner;
			_tmp627_ = vala_expression_get_symbol_reference (_tmp626_);
			_tmp628_ = _tmp627_;
			prop = VALA_IS_PROPERTY (_tmp628_) ? ((ValaProperty*) _tmp628_) : NULL;
			_tmp630_ = prop;
			if (_tmp630_ != NULL) {
				gboolean _tmp631_ = FALSE;
				ValaProperty* _tmp632_;
				ValaPropertyAccessor* _tmp633_;
				ValaPropertyAccessor* _tmp634_;
				_tmp632_ = prop;
				_tmp633_ = vala_property_get_set_accessor (_tmp632_);
				_tmp634_ = _tmp633_;
				if (_tmp634_ == NULL) {
					_tmp631_ = TRUE;
				} else {
					ValaProperty* _tmp635_;
					ValaPropertyAccessor* _tmp636_;
					ValaPropertyAccessor* _tmp637_;
					gboolean _tmp638_;
					gboolean _tmp639_;
					_tmp635_ = prop;
					_tmp636_ = vala_property_get_set_accessor (_tmp635_);
					_tmp637_ = _tmp636_;
					_tmp638_ = vala_property_accessor_get_writable (_tmp637_);
					_tmp639_ = _tmp638_;
					_tmp631_ = !_tmp639_;
				}
				_tmp629_ = _tmp631_;
			} else {
				_tmp629_ = FALSE;
			}
			if (_tmp629_) {
				ValaExpression* _tmp640_;
				ValaSourceReference* _tmp641_;
				ValaSourceReference* _tmp642_;
				ValaProperty* _tmp643_;
				gchar* _tmp644_;
				gchar* _tmp645_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp640_ = inner;
				_tmp641_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp640_);
				_tmp642_ = _tmp641_;
				_tmp643_ = prop;
				_tmp644_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp643_);
				_tmp645_ = _tmp644_;
				vala_report_error (_tmp642_, "Property `%s' is read-only", _tmp645_);
				_g_free0 (_tmp645_);
			}
		}
		_tmp649_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp650_ = _tmp649_;
		if (_tmp650_) {
			ValaDataType* _tmp651_;
			ValaDataType* _tmp652_;
			gboolean _tmp653_;
			gboolean _tmp654_;
			_tmp651_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp652_ = _tmp651_;
			_tmp653_ = vala_data_type_get_nullable (_tmp652_);
			_tmp654_ = _tmp653_;
			_tmp648_ = !_tmp654_;
		} else {
			_tmp648_ = FALSE;
		}
		if (_tmp648_) {
			ValaDataType* _tmp655_;
			ValaDataType* _tmp656_;
			gboolean _tmp657_;
			gboolean _tmp658_;
			_tmp655_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp656_ = _tmp655_;
			_tmp657_ = vala_data_type_get_floating_reference (_tmp656_);
			_tmp658_ = _tmp657_;
			_tmp647_ = _tmp658_;
		} else {
			_tmp647_ = FALSE;
		}
		if (_tmp647_) {
			ValaDataType* _tmp659_;
			_tmp659_ = ret_type;
			_tmp646_ = VALA_IS_OBJECT_TYPE (_tmp659_);
		} else {
			_tmp646_ = FALSE;
		}
		if (_tmp646_) {
			ValaDataType* _tmp660_;
			ValaDataType* _tmp661_;
			_tmp660_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp661_ = _tmp660_;
			vala_data_type_set_nullable (_tmp661_, TRUE);
		}
		_tmp662_ = m;
		_tmp663_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp662_);
		_tmp664_ = _tmp663_;
		sig = VALA_IS_SIGNAL (_tmp664_) ? ((ValaSignal*) _tmp664_) : NULL;
		_tmp666_ = sig;
		if (_tmp666_ != NULL) {
			ValaMethod* _tmp667_;
			const gchar* _tmp668_;
			const gchar* _tmp669_;
			_tmp667_ = m;
			_tmp668_ = vala_symbol_get_name ((ValaSymbol*) _tmp667_);
			_tmp669_ = _tmp668_;
			_tmp665_ = g_strcmp0 (_tmp669_, "disconnect") == 0;
		} else {
			_tmp665_ = FALSE;
		}
		if (_tmp665_) {
			gboolean _tmp670_ = FALSE;
			ValaList* _tmp671_;
			gboolean _tmp672_;
			gboolean _tmp673_;
			_tmp671_ = self->priv->argument_list;
			_tmp672_ = vala_collection_get_is_empty ((ValaCollection*) _tmp671_);
			_tmp673_ = _tmp672_;
			if (!_tmp673_) {
				ValaList* _tmp674_;
				gpointer _tmp675_;
				ValaExpression* _tmp676_;
				_tmp674_ = self->priv->argument_list;
				_tmp675_ = vala_list_get (_tmp674_, 0);
				_tmp676_ = (ValaExpression*) _tmp675_;
				_tmp670_ = VALA_IS_LAMBDA_EXPRESSION (_tmp676_);
				_vala_code_node_unref0 (_tmp676_);
			} else {
				_tmp670_ = FALSE;
			}
			if (_tmp670_) {
				ValaSourceReference* _tmp677_;
				ValaSourceReference* _tmp678_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp677_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp678_ = _tmp677_;
				vala_report_error (_tmp678_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp679_ = m;
		_tmp680_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp679_);
		_tmp681_ = _tmp680_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp681_) ? ((ValaDynamicSignal*) _tmp681_) : NULL;
		_tmp683_ = dynamic_sig;
		if (_tmp683_ != NULL) {
			ValaDynamicSignal* _tmp684_;
			ValaExpression* _tmp685_;
			ValaExpression* _tmp686_;
			_tmp684_ = dynamic_sig;
			_tmp685_ = vala_dynamic_signal_get_handler (_tmp684_);
			_tmp686_ = _tmp685_;
			_tmp682_ = _tmp686_ != NULL;
		} else {
			_tmp682_ = FALSE;
		}
		if (_tmp682_) {
			ValaDynamicSignal* _tmp687_;
			ValaDynamicSignal* _tmp688_;
			ValaExpression* _tmp689_;
			ValaExpression* _tmp690_;
			ValaDataType* _tmp691_;
			ValaDataType* _tmp692_;
			ValaDataType* _tmp693_;
			ValaDataType* _tmp694_;
			ValaDataType* _tmp695_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp713_;
			ValaExpression* _tmp714_;
			ValaExpression* _tmp715_;
			ValaDynamicSignal* _tmp716_;
			ValaDynamicSignal* _tmp717_;
			ValaSymbol* _tmp718_;
			ValaSymbol* _tmp719_;
			ValaObjectType* _tmp720_;
			ValaObjectType* _tmp721_;
			ValaDelegate* _tmp722_;
			ValaDelegate* _tmp723_;
			ValaSourceReference* _tmp724_;
			ValaSourceReference* _tmp725_;
			ValaDelegateType* _tmp726_;
			ValaDelegateType* _tmp727_;
			_tmp687_ = dynamic_sig;
			_tmp688_ = dynamic_sig;
			_tmp689_ = vala_dynamic_signal_get_handler (_tmp688_);
			_tmp690_ = _tmp689_;
			_tmp691_ = vala_expression_get_value_type (_tmp690_);
			_tmp692_ = _tmp691_;
			_tmp693_ = vala_data_type_get_return_type (_tmp692_);
			_tmp694_ = vala_data_type_copy (_tmp693_);
			_tmp695_ = _tmp694_;
			vala_callable_set_return_type ((ValaCallable*) _tmp687_, _tmp695_);
			_vala_code_node_unref0 (_tmp695_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp696_;
				ValaExpression* _tmp697_;
				ValaExpression* _tmp698_;
				ValaDataType* _tmp699_;
				ValaDataType* _tmp700_;
				ValaList* _tmp701_;
				gint _param_size = 0;
				ValaList* _tmp702_;
				gint _tmp703_;
				gint _tmp704_;
				gint _param_index = 0;
				_tmp696_ = dynamic_sig;
				_tmp697_ = vala_dynamic_signal_get_handler (_tmp696_);
				_tmp698_ = _tmp697_;
				_tmp699_ = vala_expression_get_value_type (_tmp698_);
				_tmp700_ = _tmp699_;
				_tmp701_ = vala_data_type_get_parameters (_tmp700_);
				_param_list = _tmp701_;
				_tmp702_ = _param_list;
				_tmp703_ = vala_collection_get_size ((ValaCollection*) _tmp702_);
				_tmp704_ = _tmp703_;
				_param_size = _tmp704_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp705_;
					gint _tmp706_;
					ValaParameter* param = NULL;
					ValaList* _tmp707_;
					gpointer _tmp708_;
					_param_index = _param_index + 1;
					_tmp705_ = _param_index;
					_tmp706_ = _param_size;
					if (!(_tmp705_ < _tmp706_)) {
						break;
					}
					_tmp707_ = _param_list;
					_tmp708_ = vala_list_get (_tmp707_, _param_index);
					param = (ValaParameter*) _tmp708_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp709_;
						ValaParameter* _tmp710_;
						ValaParameter* _tmp711_;
						ValaParameter* _tmp712_;
						_tmp709_ = dynamic_sig;
						_tmp710_ = param;
						_tmp711_ = vala_parameter_copy (_tmp710_);
						_tmp712_ = _tmp711_;
						vala_callable_add_parameter ((ValaCallable*) _tmp709_, _tmp712_);
						_vala_code_node_unref0 (_tmp712_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp713_ = dynamic_sig;
			_tmp714_ = vala_dynamic_signal_get_handler (_tmp713_);
			_tmp715_ = _tmp714_;
			_tmp716_ = dynamic_sig;
			_tmp717_ = dynamic_sig;
			_tmp718_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp717_);
			_tmp719_ = _tmp718_;
			_tmp720_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp719_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), NULL);
			_tmp721_ = _tmp720_;
			_tmp722_ = vala_signal_get_delegate ((ValaSignal*) _tmp716_, (ValaDataType*) _tmp721_, (ValaCodeNode*) self);
			_tmp723_ = _tmp722_;
			_tmp724_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp725_ = _tmp724_;
			_tmp726_ = vala_delegate_type_new (_tmp723_, _tmp725_);
			_tmp727_ = _tmp726_;
			vala_expression_set_target_type (_tmp715_, (ValaDataType*) _tmp727_);
			_vala_code_node_unref0 (_tmp727_);
			_vala_code_node_unref0 (_tmp723_);
			_vala_code_node_unref0 (_tmp721_);
		}
		_tmp729_ = m;
		if (_tmp729_ != NULL) {
			ValaMethod* _tmp730_;
			_tmp730_ = m;
			_tmp728_ = vala_method_has_type_parameters (_tmp730_);
		} else {
			_tmp728_ = FALSE;
		}
		if (_tmp728_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp731_;
			ValaExpression* _tmp732_;
			ValaMemberAccess* _tmp733_;
			ValaList* _tmp734_;
			gint _tmp735_;
			gint _tmp736_;
			_tmp731_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp732_ = _tmp731_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp732_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp733_ = ma;
			_tmp734_ = vala_member_access_get_type_arguments (_tmp733_);
			_tmp735_ = vala_collection_get_size ((ValaCollection*) _tmp734_);
			_tmp736_ = _tmp735_;
			if (_tmp736_ == 0) {
				ValaList* _tmp803_;
				ValaIterator* _tmp804_;
				ValaDataType* _tmp831_;
				ValaDataType* _tmp832_;
				ValaDataType* _tmp833_;
				ValaList* _tmp834_;
				ValaDataType* _tmp835_;
				ValaDataType* _tmp836_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp737_;
					ValaList* _tmp738_;
					gint _type_param_size = 0;
					ValaList* _tmp739_;
					gint _tmp740_;
					gint _tmp741_;
					gint _type_param_index = 0;
					_tmp737_ = m;
					_tmp738_ = vala_method_get_type_parameters (_tmp737_);
					_type_param_list = _tmp738_;
					_tmp739_ = _type_param_list;
					_tmp740_ = vala_collection_get_size ((ValaCollection*) _tmp739_);
					_tmp741_ = _tmp740_;
					_type_param_size = _tmp741_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp742_;
						gint _tmp743_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp744_;
						gpointer _tmp745_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp746_;
						ValaIterator* _tmp747_;
						gboolean _tmp783_ = FALSE;
						ValaDataType* _tmp784_;
						ValaDataType* _tmp794_;
						ValaMemberAccess* _tmp801_;
						ValaDataType* _tmp802_;
						_type_param_index = _type_param_index + 1;
						_tmp742_ = _type_param_index;
						_tmp743_ = _type_param_size;
						if (!(_tmp742_ < _tmp743_)) {
							break;
						}
						_tmp744_ = _type_param_list;
						_tmp745_ = vala_list_get (_tmp744_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp745_;
						type_arg = NULL;
						_tmp746_ = self->priv->argument_list;
						_tmp747_ = vala_iterable_iterator ((ValaIterable*) _tmp746_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp747_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp748_;
							gint _param_size = 0;
							ValaList* _tmp749_;
							gint _tmp750_;
							gint _tmp751_;
							gint _param_index = 0;
							_tmp748_ = params;
							_param_list = _tmp748_;
							_tmp749_ = _param_list;
							_tmp750_ = vala_collection_get_size ((ValaCollection*) _tmp749_);
							_tmp751_ = _tmp750_;
							_param_size = _tmp751_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp752_;
								gint _tmp753_;
								ValaParameter* param = NULL;
								ValaList* _tmp754_;
								gpointer _tmp755_;
								gboolean _tmp756_ = FALSE;
								ValaParameter* _tmp757_;
								gboolean _tmp758_;
								gboolean _tmp759_;
								ValaIterator* _tmp763_;
								_param_index = _param_index + 1;
								_tmp752_ = _param_index;
								_tmp753_ = _param_size;
								if (!(_tmp752_ < _tmp753_)) {
									break;
								}
								_tmp754_ = _param_list;
								_tmp755_ = vala_list_get (_tmp754_, _param_index);
								param = (ValaParameter*) _tmp755_;
								_tmp757_ = param;
								_tmp758_ = vala_parameter_get_ellipsis (_tmp757_);
								_tmp759_ = _tmp758_;
								if (_tmp759_) {
									_tmp756_ = TRUE;
								} else {
									ValaParameter* _tmp760_;
									gboolean _tmp761_;
									gboolean _tmp762_;
									_tmp760_ = param;
									_tmp761_ = vala_parameter_get_params_array (_tmp760_);
									_tmp762_ = _tmp761_;
									_tmp756_ = _tmp762_;
								}
								if (_tmp756_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp763_ = arg_it;
								if (vala_iterator_next (_tmp763_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp764_;
									gpointer _tmp765_;
									ValaParameter* _tmp766_;
									ValaDataType* _tmp767_;
									ValaDataType* _tmp768_;
									ValaTypeParameter* _tmp769_;
									ValaExpression* _tmp770_;
									ValaDataType* _tmp771_;
									ValaDataType* _tmp772_;
									ValaDataType* _tmp773_;
									ValaDataType* _tmp774_;
									ValaExpression* _tmp775_;
									ValaExpression* _tmp776_;
									ValaDataType* _tmp777_;
									ValaDataType* _tmp778_;
									ValaDataType* _tmp779_;
									ValaList* _tmp780_;
									ValaDataType* _tmp781_;
									ValaDataType* _tmp782_;
									_tmp764_ = arg_it;
									_tmp765_ = vala_iterator_get (_tmp764_);
									arg = (ValaExpression*) _tmp765_;
									_tmp766_ = param;
									_tmp767_ = vala_variable_get_variable_type ((ValaVariable*) _tmp766_);
									_tmp768_ = _tmp767_;
									_tmp769_ = type_param;
									_tmp770_ = arg;
									_tmp771_ = vala_expression_get_value_type (_tmp770_);
									_tmp772_ = _tmp771_;
									_tmp773_ = vala_data_type_infer_type_argument (_tmp768_, _tmp769_, _tmp772_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp773_;
									_tmp774_ = type_arg;
									if (_tmp774_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp775_ = arg;
									_tmp776_ = arg;
									_tmp777_ = vala_expression_get_formal_target_type (_tmp776_);
									_tmp778_ = _tmp777_;
									_tmp779_ = target_object_type;
									_tmp780_ = method_type_args;
									_tmp781_ = vala_data_type_get_actual_type (_tmp778_, _tmp779_, _tmp780_, (ValaCodeNode*) self);
									_tmp782_ = _tmp781_;
									vala_expression_set_target_type (_tmp775_, _tmp782_);
									_vala_code_node_unref0 (_tmp782_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp784_ = type_arg;
						if (_tmp784_ == NULL) {
							ValaDataType* _tmp785_;
							ValaDataType* _tmp786_;
							_tmp785_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp786_ = _tmp785_;
							_tmp783_ = _tmp786_ != NULL;
						} else {
							_tmp783_ = FALSE;
						}
						if (_tmp783_) {
							ValaMethod* _tmp787_;
							ValaDataType* _tmp788_;
							ValaDataType* _tmp789_;
							ValaTypeParameter* _tmp790_;
							ValaDataType* _tmp791_;
							ValaDataType* _tmp792_;
							ValaDataType* _tmp793_;
							_tmp787_ = m;
							_tmp788_ = vala_callable_get_return_type ((ValaCallable*) _tmp787_);
							_tmp789_ = _tmp788_;
							_tmp790_ = type_param;
							_tmp791_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp792_ = _tmp791_;
							_tmp793_ = vala_data_type_infer_type_argument (_tmp789_, _tmp790_, _tmp792_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp793_;
						}
						_tmp794_ = type_arg;
						if (_tmp794_ == NULL) {
							ValaMemberAccess* _tmp795_;
							ValaSourceReference* _tmp796_;
							ValaSourceReference* _tmp797_;
							ValaTypeParameter* _tmp798_;
							gchar* _tmp799_;
							gchar* _tmp800_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp795_ = ma;
							_tmp796_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp795_);
							_tmp797_ = _tmp796_;
							_tmp798_ = type_param;
							_tmp799_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp798_);
							_tmp800_ = _tmp799_;
							vala_report_error (_tmp797_, "cannot infer generic type argument for type parameter `%s'", _tmp800_);
							_g_free0 (_tmp800_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp801_ = ma;
						_tmp802_ = type_arg;
						vala_member_access_add_type_argument (_tmp801_, _tmp802_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp803_ = self->priv->argument_list;
				_tmp804_ = vala_iterable_iterator ((ValaIterable*) _tmp803_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp804_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp805_;
					gint _param_size = 0;
					ValaList* _tmp806_;
					gint _tmp807_;
					gint _tmp808_;
					gint _param_index = 0;
					_tmp805_ = params;
					_param_list = _tmp805_;
					_tmp806_ = _param_list;
					_tmp807_ = vala_collection_get_size ((ValaCollection*) _tmp806_);
					_tmp808_ = _tmp807_;
					_param_size = _tmp808_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp809_;
						gint _tmp810_;
						ValaParameter* param = NULL;
						ValaList* _tmp811_;
						gpointer _tmp812_;
						gboolean _tmp813_ = FALSE;
						ValaParameter* _tmp814_;
						gboolean _tmp815_;
						gboolean _tmp816_;
						ValaIterator* _tmp820_;
						_param_index = _param_index + 1;
						_tmp809_ = _param_index;
						_tmp810_ = _param_size;
						if (!(_tmp809_ < _tmp810_)) {
							break;
						}
						_tmp811_ = _param_list;
						_tmp812_ = vala_list_get (_tmp811_, _param_index);
						param = (ValaParameter*) _tmp812_;
						_tmp814_ = param;
						_tmp815_ = vala_parameter_get_ellipsis (_tmp814_);
						_tmp816_ = _tmp815_;
						if (_tmp816_) {
							_tmp813_ = TRUE;
						} else {
							ValaParameter* _tmp817_;
							gboolean _tmp818_;
							gboolean _tmp819_;
							_tmp817_ = param;
							_tmp818_ = vala_parameter_get_params_array (_tmp817_);
							_tmp819_ = _tmp818_;
							_tmp813_ = _tmp819_;
						}
						if (_tmp813_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp820_ = arg_it;
						if (vala_iterator_next (_tmp820_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp821_;
							gpointer _tmp822_;
							ValaExpression* _tmp823_;
							ValaExpression* _tmp824_;
							ValaDataType* _tmp825_;
							ValaDataType* _tmp826_;
							ValaDataType* _tmp827_;
							ValaList* _tmp828_;
							ValaDataType* _tmp829_;
							ValaDataType* _tmp830_;
							_tmp821_ = arg_it;
							_tmp822_ = vala_iterator_get (_tmp821_);
							arg = (ValaExpression*) _tmp822_;
							_tmp823_ = arg;
							_tmp824_ = arg;
							_tmp825_ = vala_expression_get_formal_target_type (_tmp824_);
							_tmp826_ = _tmp825_;
							_tmp827_ = target_object_type;
							_tmp828_ = method_type_args;
							_tmp829_ = vala_data_type_get_actual_type (_tmp826_, _tmp827_, _tmp828_, (ValaCodeNode*) self);
							_tmp830_ = _tmp829_;
							vala_expression_set_target_type (_tmp823_, _tmp830_);
							_vala_code_node_unref0 (_tmp830_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp831_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp832_ = _tmp831_;
				_tmp833_ = target_object_type;
				_tmp834_ = method_type_args;
				_tmp835_ = vala_data_type_get_actual_type (_tmp832_, _tmp833_, _tmp834_, (ValaCodeNode*) self);
				_tmp836_ = _tmp835_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp836_);
				_vala_code_node_unref0 (_tmp836_);
			}
		}
		_tmp838_ = m;
		if (_tmp838_ != NULL) {
			ValaMethod* _tmp839_;
			gboolean _tmp840_;
			gboolean _tmp841_;
			_tmp839_ = m;
			_tmp840_ = vala_method_get_coroutine (_tmp839_);
			_tmp841_ = _tmp840_;
			_tmp837_ = _tmp841_;
		} else {
			_tmp837_ = FALSE;
		}
		if (_tmp837_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp842_;
			ValaExpression* _tmp843_;
			ValaMemberAccess* _tmp844_;
			const gchar* _tmp845_;
			const gchar* _tmp846_;
			_tmp842_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp843_ = _tmp842_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp843_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp844_ = ma;
			_tmp845_ = vala_member_access_get_member_name (_tmp844_);
			_tmp846_ = _tmp845_;
			if (g_strcmp0 (_tmp846_, "end") == 0) {
				ValaMethod* _tmp847_;
				ValaMethod* _tmp848_;
				ValaSourceReference* _tmp849_;
				ValaSourceReference* _tmp850_;
				ValaMethodType* _tmp851_;
				_tmp847_ = m;
				_tmp848_ = vala_method_get_end_method (_tmp847_);
				_tmp849_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp850_ = _tmp849_;
				_tmp851_ = vala_method_type_new (_tmp848_, _tmp850_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp851_;
			}
		}
	}
	_tmp852_ = vala_code_context_get_analyzer (context);
	_tmp853_ = _tmp852_;
	_tmp854_ = mtype;
	_tmp855_ = params;
	_tmp856_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp853_, (ValaExpression*) self, _tmp854_, _tmp855_, _tmp856_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp857_;
		gint _arg_size = 0;
		ValaList* _tmp858_;
		gint _tmp859_;
		gint _tmp860_;
		gint _arg_index = 0;
		_tmp857_ = self->priv->argument_list;
		_arg_list = _tmp857_;
		_tmp858_ = _arg_list;
		_tmp859_ = vala_collection_get_size ((ValaCollection*) _tmp858_);
		_tmp860_ = _tmp859_;
		_arg_size = _tmp860_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp861_;
			gint _tmp862_;
			ValaExpression* arg = NULL;
			ValaList* _tmp863_;
			gpointer _tmp864_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp865_;
			gboolean _tmp866_ = FALSE;
			ValaSizeofExpression* _tmp867_;
			_arg_index = _arg_index + 1;
			_tmp861_ = _arg_index;
			_tmp862_ = _arg_size;
			if (!(_tmp861_ < _tmp862_)) {
				break;
			}
			_tmp863_ = _arg_list;
			_tmp864_ = vala_list_get (_tmp863_, _arg_index);
			arg = (ValaExpression*) _tmp864_;
			_tmp865_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp865_) ? ((ValaSizeofExpression*) _tmp865_) : NULL;
			_tmp867_ = sizeof_expr;
			if (_tmp867_ != NULL) {
				ValaSizeofExpression* _tmp868_;
				ValaDataType* _tmp869_;
				ValaDataType* _tmp870_;
				_tmp868_ = sizeof_expr;
				_tmp869_ = vala_sizeof_expression_get_type_reference (_tmp868_);
				_tmp870_ = _tmp869_;
				_tmp866_ = VALA_IS_GENERIC_TYPE (_tmp870_);
			} else {
				_tmp866_ = FALSE;
			}
			if (_tmp866_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp871_;
				ValaDataType* _tmp872_;
				ValaDataType* _tmp873_;
				ValaDataType* _tmp874_;
				ValaList* _tmp875_;
				ValaDataType* _tmp876_;
				ValaExpression* _tmp877_;
				ValaDataType* _tmp878_;
				ValaSourceReference* _tmp879_;
				ValaSourceReference* _tmp880_;
				ValaSizeofExpression* _tmp881_;
				ValaSizeofExpression* _tmp882_;
				_tmp871_ = sizeof_expr;
				_tmp872_ = vala_sizeof_expression_get_type_reference (_tmp871_);
				_tmp873_ = _tmp872_;
				_tmp874_ = target_object_type;
				_tmp875_ = method_type_args;
				_tmp876_ = vala_data_type_get_actual_type (_tmp873_, _tmp874_, _tmp875_, (ValaCodeNode*) self);
				sizeof_type = _tmp876_;
				_tmp877_ = arg;
				_tmp878_ = sizeof_type;
				_tmp879_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp880_ = _tmp879_;
				_tmp881_ = vala_sizeof_expression_new (_tmp878_, _tmp880_);
				_tmp882_ = _tmp881_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp877_, (ValaExpression*) _tmp882_);
				_vala_code_node_unref0 (_tmp882_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp885_ = base_cm;
	if (_tmp885_ != NULL) {
		ValaCreationMethod* _tmp886_;
		_tmp886_ = base_cm;
		_tmp884_ = vala_method_is_variadic ((ValaMethod*) _tmp886_);
	} else {
		_tmp884_ = FALSE;
	}
	if (_tmp884_) {
		ValaList* _tmp887_;
		gint _tmp888_;
		gint _tmp889_;
		ValaCreationMethod* _tmp890_;
		ValaList* _tmp891_;
		gint _tmp892_;
		gint _tmp893_;
		_tmp887_ = self->priv->argument_list;
		_tmp888_ = vala_collection_get_size ((ValaCollection*) _tmp887_);
		_tmp889_ = _tmp888_;
		_tmp890_ = base_cm;
		_tmp891_ = vala_callable_get_parameters ((ValaCallable*) _tmp890_);
		_tmp892_ = vala_collection_get_size ((ValaCollection*) _tmp891_);
		_tmp893_ = _tmp892_;
		_tmp883_ = _tmp889_ == _tmp893_;
	} else {
		_tmp883_ = FALSE;
	}
	if (_tmp883_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp894_;
		ValaList* _tmp895_;
		gint _tmp896_;
		gint _tmp897_;
		gpointer _tmp898_;
		gboolean _tmp899_ = FALSE;
		ValaExpression* _tmp900_;
		ValaDataType* _tmp901_;
		ValaDataType* _tmp902_;
		_tmp894_ = self->priv->argument_list;
		_tmp895_ = self->priv->argument_list;
		_tmp896_ = vala_collection_get_size ((ValaCollection*) _tmp895_);
		_tmp897_ = _tmp896_;
		_tmp898_ = vala_list_get (_tmp894_, _tmp897_ - 1);
		this_last_arg = (ValaExpression*) _tmp898_;
		_tmp900_ = this_last_arg;
		_tmp901_ = vala_expression_get_value_type (_tmp900_);
		_tmp902_ = _tmp901_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp902_)) {
			ValaExpression* _tmp903_;
			ValaDataType* _tmp904_;
			ValaDataType* _tmp905_;
			ValaTypeSymbol* _tmp906_;
			ValaTypeSymbol* _tmp907_;
			ValaSemanticAnalyzer* _tmp908_;
			ValaSemanticAnalyzer* _tmp909_;
			ValaDataType* _tmp910_;
			ValaTypeSymbol* _tmp911_;
			ValaTypeSymbol* _tmp912_;
			_tmp903_ = this_last_arg;
			_tmp904_ = vala_expression_get_value_type (_tmp903_);
			_tmp905_ = _tmp904_;
			_tmp906_ = vala_data_type_get_type_symbol (_tmp905_);
			_tmp907_ = _tmp906_;
			_tmp908_ = vala_code_context_get_analyzer (context);
			_tmp909_ = _tmp908_;
			_tmp910_ = _tmp909_->va_list_type;
			_tmp911_ = vala_data_type_get_type_symbol (_tmp910_);
			_tmp912_ = _tmp911_;
			_tmp899_ = _tmp907_ == _tmp912_;
		} else {
			_tmp899_ = FALSE;
		}
		if (_tmp899_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp913_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp914_ = _tmp913_;
	vala_code_node_check ((ValaCodeNode*) _tmp914_, context);
	_tmp915_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp916_ = _tmp915_;
	if (_tmp916_) {
		gboolean _tmp917_ = FALSE;
		ValaCodeNode* _tmp918_;
		ValaCodeNode* _tmp919_;
		_tmp918_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp919_ = _tmp918_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp919_)) {
			_tmp917_ = TRUE;
		} else {
			ValaCodeNode* _tmp920_;
			ValaCodeNode* _tmp921_;
			_tmp920_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp921_ = _tmp920_;
			_tmp917_ = VALA_IS_EXPRESSION_STATEMENT (_tmp921_);
		}
		if (_tmp917_) {
		} else {
			ValaSemanticAnalyzer* _tmp922_;
			ValaSemanticAnalyzer* _tmp923_;
			ValaSymbol* _tmp924_;
			ValaSymbol* _tmp925_;
			_tmp922_ = vala_code_context_get_analyzer (context);
			_tmp923_ = _tmp922_;
			_tmp924_ = vala_semantic_analyzer_get_current_symbol (_tmp923_);
			_tmp925_ = _tmp924_;
			if (!VALA_IS_BLOCK (_tmp925_)) {
				ValaSourceReference* _tmp926_;
				ValaSourceReference* _tmp927_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp926_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp927_ = _tmp926_;
				vala_report_error (_tmp927_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp928_;
				ValaCodeNode* _tmp929_;
				ValaCodeNode* _tmp930_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp931_;
				ValaDataType* _tmp932_;
				ValaDataType* _tmp933_;
				ValaDataType* _tmp934_;
				gchar* _tmp935_;
				gchar* _tmp936_;
				ValaSourceReference* _tmp937_;
				ValaSourceReference* _tmp938_;
				ValaLocalVariable* _tmp939_;
				ValaLocalVariable* _tmp940_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp941_;
				ValaSourceReference* _tmp942_;
				ValaSourceReference* _tmp943_;
				ValaDeclarationStatement* _tmp944_;
				ValaDataType* _tmp945_;
				ValaDataType* _tmp946_;
				ValaSemanticAnalyzer* _tmp950_;
				ValaSemanticAnalyzer* _tmp951_;
				ValaBlock* _tmp952_;
				ValaDeclarationStatement* _tmp953_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp954_;
				ValaDataType* _tmp955_;
				ValaDataType* _tmp956_;
				ValaExpression* _tmp957_;
				ValaExpression* _tmp958_;
				ValaDataType* _tmp959_;
				ValaDataType* _tmp960_;
				ValaLocalVariable* _tmp961_;
				ValaDeclarationStatement* _tmp962_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp963_;
				ValaSemanticAnalyzer* _tmp964_;
				ValaSymbol* _tmp965_;
				ValaSymbol* _tmp966_;
				ValaBlock* _tmp967_;
				ValaBlock* _tmp968_;
				ValaLocalVariable* _tmp969_;
				ValaSemanticAnalyzer* _tmp970_;
				ValaSemanticAnalyzer* _tmp971_;
				ValaBlock* _tmp972_;
				ValaLocalVariable* _tmp973_;
				ValaCodeNode* _tmp974_;
				ValaExpression* _tmp975_;
				ValaExpression* _tmp976_;
				_tmp928_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp929_ = _tmp928_;
				_tmp930_ = _vala_code_node_ref0 (_tmp929_);
				old_parent_node = _tmp930_;
				_tmp931_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp932_ = _tmp931_;
				_tmp933_ = vala_data_type_copy (_tmp932_);
				_tmp934_ = _tmp933_;
				_tmp935_ = vala_code_node_get_temp_name ();
				_tmp936_ = _tmp935_;
				_tmp937_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_local_variable_new (_tmp934_, _tmp936_, NULL, _tmp938_);
				_tmp940_ = _tmp939_;
				_g_free0 (_tmp936_);
				_vala_code_node_unref0 (_tmp934_);
				local = _tmp940_;
				_tmp941_ = local;
				_tmp942_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp943_ = _tmp942_;
				_tmp944_ = vala_declaration_statement_new ((ValaSymbol*) _tmp941_, _tmp943_);
				decl = _tmp944_;
				_tmp945_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp946_ = _tmp945_;
				if (_tmp946_ == NULL) {
					ValaLocalVariable* _tmp947_;
					ValaDataType* _tmp948_;
					ValaDataType* _tmp949_;
					_tmp947_ = local;
					_tmp948_ = vala_variable_get_variable_type ((ValaVariable*) _tmp947_);
					_tmp949_ = _tmp948_;
					vala_data_type_set_floating_reference (_tmp949_, FALSE);
				}
				_tmp950_ = vala_code_context_get_analyzer (context);
				_tmp951_ = _tmp950_;
				_tmp952_ = _tmp951_->insert_block;
				_tmp953_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp952_, (ValaStatement*) _tmp953_);
				_tmp954_ = local;
				_tmp955_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp956_ = _tmp955_;
				_tmp957_ = vala_semantic_analyzer_create_temp_access (_tmp954_, _tmp956_);
				temp_access = _tmp957_;
				_tmp958_ = temp_access;
				_tmp959_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp960_ = _tmp959_;
				vala_expression_set_formal_target_type (_tmp958_, _tmp960_);
				_tmp961_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp961_, (ValaExpression*) self);
				_tmp962_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp962_, context);
				_tmp963_ = vala_code_context_get_analyzer (context);
				_tmp964_ = _tmp963_;
				_tmp965_ = vala_semantic_analyzer_get_current_symbol (_tmp964_);
				_tmp966_ = _tmp965_;
				_tmp967_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp966_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp967_;
				_tmp968_ = block;
				_tmp969_ = local;
				vala_block_remove_local_variable (_tmp968_, _tmp969_);
				_tmp970_ = vala_code_context_get_analyzer (context);
				_tmp971_ = _tmp970_;
				_tmp972_ = _tmp971_->insert_block;
				_tmp973_ = local;
				vala_block_add_local_variable (_tmp972_, _tmp973_);
				_tmp974_ = old_parent_node;
				_tmp975_ = temp_access;
				vala_code_node_replace_expression (_tmp974_, (ValaExpression*) self, _tmp975_);
				_tmp976_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp976_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp977_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp978_ = _tmp977_;
	result = !_tmp978_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_call = vala_method_call_real_get_call;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
	iface->get_is_chainup = vala_method_call_real_get_is_chainup;
	iface->set_is_chainup = vala_method_call_real_set_is_chainup;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__once = 0;
	if (g_once_init_enter (&vala_method_call_type_id__once)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__once, vala_method_call_type_id);
	}
	return vala_method_call_type_id__once;
}

