/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	gboolean _null_safe_access;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

gboolean
vala_member_access_get_null_safe_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_null_safe_access;
	return result;
}

void
vala_member_access_set_null_safe_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_null_safe_access = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaLocalVariable* l = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaConstant* _tmp6_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	l = VALA_IS_LOCAL_VARIABLE (_tmp3_) ? ((ValaLocalVariable*) _tmp3_) : NULL;
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	m = VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL;
	_tmp6_ = c;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		ValaConstant* _tmp8_;
		_tmp8_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp8_)) {
			_tmp7_ = TRUE;
		} else {
			ValaConstant* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp9_ = c;
			_tmp10_ = vala_constant_get_type_reference (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_data_type_get_nullable (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = !_tmp13_;
		}
		result = _tmp7_;
		return result;
	} else {
		ValaLocalVariable* _tmp14_;
		_tmp14_ = l;
		if (_tmp14_ != NULL) {
			ValaDataType* type = NULL;
			ValaLocalVariable* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp15_ = l;
			_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) _tmp15_);
			_tmp17_ = _tmp16_;
			type = _tmp17_;
			_tmp18_ = type;
			if (VALA_IS_ARRAY_TYPE (_tmp18_)) {
				ValaDataType* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = type;
				_tmp20_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp21_ = _tmp20_;
				result = _tmp21_;
				return result;
			} else {
				gboolean _tmp22_ = FALSE;
				ValaDataType* _tmp23_;
				_tmp23_ = type;
				if (vala_data_type_is_real_non_null_struct_type (_tmp23_)) {
					_tmp22_ = TRUE;
				} else {
					ValaDataType* _tmp24_;
					_tmp24_ = type;
					_tmp22_ = vala_data_type_is_non_null_simple_type (_tmp24_);
				}
				result = _tmp22_;
				return result;
			}
		} else {
			ValaMethod* _tmp25_;
			_tmp25_ = m;
			if (_tmp25_ != NULL) {
				gboolean _tmp26_ = FALSE;
				ValaMethod* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = m;
				_tmp28_ = vala_method_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp26_ = TRUE;
				} else {
					gboolean _tmp30_;
					_tmp30_ = self->priv->_prototype_access;
					_tmp26_ = _tmp30_;
				}
				result = _tmp26_;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp747_ = FALSE;
	gboolean _tmp748_ = FALSE;
	gboolean _tmp749_ = FALSE;
	ValaExpression* _tmp750_;
	ValaExpression* _tmp751_;
	ValaSymbol* _tmp778_;
	ValaSymbol* _tmp779_;
	ValaSymbol* _tmp848_;
	ValaSymbol* _tmp849_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp885_;
	ValaSymbol* _tmp886_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp887_;
	ValaSymbol* _tmp888_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1336_;
	ValaSymbol* _tmp1337_;
	ValaSymbol* _tmp1339_;
	ValaVersionAttribute* _tmp1340_;
	ValaVersionAttribute* _tmp1341_;
	ValaSourceReference* _tmp1342_;
	ValaSourceReference* _tmp1343_;
	gboolean _tmp1344_ = FALSE;
	gboolean _tmp1395_ = FALSE;
	gboolean _tmp1422_ = FALSE;
	gboolean _tmp1423_ = FALSE;
	ValaDataType* _tmp1716_;
	ValaDataType* _tmp1717_;
	ValaSymbol* _tmp1720_;
	ValaSymbol* _tmp1721_;
	gboolean _tmp1762_;
	gboolean _tmp1763_;
	gboolean _tmp1764_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_null_safe_access;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		result = !_tmp6_;
		return result;
	}
	_tmp7_ = vala_member_access_get_inner (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp9_ = vala_member_access_get_inner (self);
		_tmp10_ = _tmp9_;
		vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp11_;
		gint _type_arg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _type_arg_index = 0;
		_tmp11_ = self->priv->type_argument_list;
		_type_arg_list = _tmp11_;
		_tmp12_ = _type_arg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_type_arg_size = _tmp14_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_type_arg_index = _type_arg_index + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = vala_list_get (_tmp17_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	visited_types = _tmp21_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp22_ = self->priv->_qualified;
	if (_tmp22_) {
		ValaNamespace* _tmp23_;
		ValaNamespace* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaScope* _tmp26_;
		ValaScope* _tmp27_;
		const gchar* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		_tmp23_ = vala_code_context_get_root (context);
		_tmp24_ = _tmp23_;
		base_symbol = (ValaSymbol*) _tmp24_;
		_tmp25_ = base_symbol;
		_tmp26_ = vala_symbol_get_scope (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_member_name;
		_tmp29_ = vala_scope_lookup (_tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
	} else {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		_tmp31_ = vala_member_access_get_inner (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == NULL) {
			const gchar* _tmp33_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			gboolean _tmp182_ = FALSE;
			ValaSymbol* _tmp183_;
			ValaSymbol* _tmp184_;
			_tmp33_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp33_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp34_;
				ValaSemanticAnalyzer* _tmp35_;
				_tmp34_ = vala_code_context_get_analyzer (context);
				_tmp35_ = _tmp34_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp35_)) {
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			sym = _tmp45_;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp93_;
				const gchar* _tmp94_;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp135_ = FALSE;
				gboolean _tmp136_ = FALSE;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				_tmp47_ = sym;
				if (_tmp47_ != NULL) {
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					_tmp48_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp49_ = _tmp48_;
					_tmp46_ = _tmp49_ == NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (!_tmp46_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp50_;
					_tmp50_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp50_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp51_;
						ValaCreationMethod* _tmp52_;
						ValaParameter* _tmp53_;
						ValaParameter* _tmp54_;
						_tmp51_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp52_ = cm;
						_tmp53_ = vala_method_get_this_parameter ((ValaMethod*) _tmp52_);
						_tmp54_ = _tmp53_;
						this_parameter = _tmp54_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp55_;
						_tmp55_ = sym;
						if (VALA_IS_PROPERTY (_tmp55_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaProperty* _tmp63_;
							ValaMemberBinding _tmp64_;
							ValaMemberBinding _tmp65_;
							_tmp56_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							this_parameter = _tmp59_;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_instance_members = _tmp62_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp63_ = prop;
							_tmp64_ = vala_property_get_binding (_tmp63_);
							_tmp65_ = _tmp64_;
							may_access_klass_members = _tmp65_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp66_;
							_tmp66_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp66_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaParameter* _tmp69_;
								ValaParameter* _tmp70_;
								ValaConstructor* _tmp71_;
								ValaMemberBinding _tmp72_;
								ValaMemberBinding _tmp73_;
								_tmp67_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_this_parameter (_tmp68_);
								_tmp70_ = _tmp69_;
								this_parameter = _tmp70_;
								_tmp71_ = c;
								_tmp72_ = vala_constructor_get_binding (_tmp71_);
								_tmp73_ = _tmp72_;
								may_access_instance_members = _tmp73_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp74_;
								_tmp74_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp74_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaParameter* _tmp77_;
									ValaParameter* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaMemberBinding _tmp80_;
									ValaMemberBinding _tmp81_;
									_tmp75_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_this_parameter (_tmp76_);
									_tmp78_ = _tmp77_;
									this_parameter = _tmp78_;
									_tmp79_ = d;
									_tmp80_ = vala_destructor_get_binding (_tmp79_);
									_tmp81_ = _tmp80_;
									may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp82_;
									_tmp82_ = sym;
									if (VALA_IS_METHOD (_tmp82_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp83_;
										ValaMethod* _tmp84_;
										ValaParameter* _tmp85_;
										ValaParameter* _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMethod* _tmp90_;
										ValaMemberBinding _tmp91_;
										ValaMemberBinding _tmp92_;
										_tmp83_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_METHOD, ValaMethod);
										_tmp84_ = m;
										_tmp85_ = vala_method_get_this_parameter (_tmp84_);
										_tmp86_ = _tmp85_;
										this_parameter = _tmp86_;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_instance_members = _tmp89_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_binding (_tmp90_);
										_tmp92_ = _tmp91_;
										may_access_klass_members = _tmp92_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp93_ = sym;
				_tmp94_ = self->priv->_member_name;
				_tmp95_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp93_, _tmp94_);
				_tmp96_ = _tmp95_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp96_);
				_vala_code_node_unref0 (_tmp96_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp99_;
					ValaSymbol* _tmp100_;
					_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp100_ = _tmp99_;
					_tmp98_ = _tmp100_ == NULL;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSymbol* _tmp101_;
					_tmp101_ = sym;
					_tmp97_ = VALA_IS_WITH_STATEMENT (_tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp102_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp103_;
					ValaLocalVariable* _tmp104_;
					ValaLocalVariable* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					ValaDataType* _tmp109_;
					ValaArrayList* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					const gchar* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					ValaSymbol* _tmp121_;
					_tmp102_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp103_ = w;
					_tmp104_ = vala_with_statement_get_with_variable (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_variable_get_variable_type ((ValaVariable*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = _vala_code_node_ref0 (_tmp107_);
					variable_type = _tmp108_;
					_tmp109_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp109_)) {
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_tmp110_ = variable_type;
						_tmp111_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp112_ = _tmp111_;
						_tmp113_ = _vala_code_node_ref0 (_tmp112_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp113_;
					}
					_tmp114_ = visited_types;
					_tmp115_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp114_, _tmp115_);
					_tmp116_ = variable_type;
					_tmp117_ = self->priv->_member_name;
					_tmp118_ = vala_data_type_get_member (_tmp116_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp119_);
					_vala_code_node_unref0 (_tmp119_);
					_tmp120_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp121_ = _tmp120_;
					if (_tmp121_ != NULL) {
						ValaWithStatement* _tmp122_;
						ValaLocalVariable* _tmp123_;
						ValaLocalVariable* _tmp124_;
						const gchar* _tmp125_;
						const gchar* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaSourceReference* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaMemberAccess* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaExpression* _tmp133_;
						ValaExpression* _tmp134_;
						_tmp122_ = w;
						_tmp123_ = vala_with_statement_get_with_variable (_tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_member_access_new (NULL, _tmp126_, _tmp128_);
						_tmp130_ = _tmp129_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp133_ = vala_member_access_get_inner (self);
						_tmp134_ = _tmp133_;
						vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp138_ = _tmp137_;
				if (_tmp138_ == NULL) {
					ValaSymbol* _tmp139_;
					_tmp139_ = sym;
					_tmp136_ = VALA_IS_TYPESYMBOL (_tmp139_);
				} else {
					_tmp136_ = FALSE;
				}
				if (_tmp136_) {
					_tmp135_ = may_access_instance_members;
				} else {
					_tmp135_ = FALSE;
				}
				if (_tmp135_) {
					ValaParameter* _tmp140_;
					ValaDataType* _tmp141_;
					ValaDataType* _tmp142_;
					const gchar* _tmp143_;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					gboolean _tmp146_ = FALSE;
					ValaSymbol* _tmp147_;
					ValaSymbol* _tmp148_;
					_tmp140_ = this_parameter;
					_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = self->priv->_member_name;
					_tmp144_ = vala_data_type_get_member (_tmp142_, _tmp143_);
					_tmp145_ = _tmp144_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp145_);
					_vala_code_node_unref0 (_tmp145_);
					_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp148_ = _tmp147_;
					if (_tmp148_ != NULL) {
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp146_ = vala_member_access_is_instance_symbol (_tmp150_);
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						ValaSourceReference* _tmp151_;
						ValaSourceReference* _tmp152_;
						ValaMemberAccess* _tmp153_;
						ValaMemberAccess* _tmp154_;
						ValaExpression* _tmp155_;
						ValaExpression* _tmp156_;
						ValaParameter* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaDataType* _tmp160_;
						ValaDataType* _tmp161_;
						ValaExpression* _tmp162_;
						ValaExpression* _tmp163_;
						ValaDataType* _tmp164_;
						ValaDataType* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaParameter* _tmp168_;
						ValaExpression* _tmp169_;
						ValaExpression* _tmp170_;
						ValaDataType* _tmp171_;
						ValaDataType* _tmp172_;
						const gchar* _tmp173_;
						ValaSymbol* _tmp174_;
						ValaSymbol* _tmp175_;
						_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_member_access_new (NULL, "this", _tmp152_);
						_tmp154_ = _tmp153_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = vala_member_access_get_inner (self);
						_tmp156_ = _tmp155_;
						_tmp157_ = this_parameter;
						_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
						_tmp159_ = _tmp158_;
						_tmp160_ = vala_data_type_copy (_tmp159_);
						_tmp161_ = _tmp160_;
						vala_expression_set_value_type (_tmp156_, _tmp161_);
						_vala_code_node_unref0 (_tmp161_);
						_tmp162_ = vala_member_access_get_inner (self);
						_tmp163_ = _tmp162_;
						_tmp164_ = vala_expression_get_value_type (_tmp163_);
						_tmp165_ = _tmp164_;
						vala_data_type_set_value_owned (_tmp165_, FALSE);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp167_, (ValaSymbol*) _tmp168_);
						_tmp169_ = vala_member_access_get_inner (self);
						_tmp170_ = _tmp169_;
						_tmp171_ = vala_expression_get_value_type (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = self->priv->_member_name;
						_tmp174_ = vala_data_type_get_member (_tmp172_, _tmp173_);
						_tmp175_ = _tmp174_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp175_);
						_vala_code_node_unref0 (_tmp175_);
					}
				}
				_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == NULL) {
					ValaSymbol* _tmp178_;
					_tmp178_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp178_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp179_ = sym;
				_tmp180_ = vala_symbol_get_parent_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				sym = _tmp181_;
			}
			_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp184_ = _tmp183_;
			if (_tmp184_ == NULL) {
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp186_ = _tmp185_;
				_tmp182_ = _tmp186_ != NULL;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaList* _tmp189_;
					ValaList* _tmp190_;
					gint _ns_size = 0;
					ValaList* _tmp191_;
					gint _tmp192_;
					gint _tmp193_;
					gint _ns_index = 0;
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_source_reference_get_using_directives (_tmp188_);
					_tmp190_ = _tmp189_;
					_ns_list = _tmp190_;
					_tmp191_ = _ns_list;
					_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
					_tmp193_ = _tmp192_;
					_ns_size = _tmp193_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp194_;
						gint _tmp195_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp196_;
						gpointer _tmp197_;
						ValaUsingDirective* _tmp198_;
						gboolean _tmp199_;
						gboolean _tmp200_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaSymbol* _tmp203_;
						ValaScope* _tmp204_;
						ValaScope* _tmp205_;
						const gchar* _tmp206_;
						ValaSymbol* _tmp207_;
						ValaSymbol* _tmp208_;
						_ns_index = _ns_index + 1;
						_tmp194_ = _ns_index;
						_tmp195_ = _ns_size;
						if (!(_tmp194_ < _tmp195_)) {
							break;
						}
						_tmp196_ = _ns_list;
						_tmp197_ = vala_list_get (_tmp196_, _ns_index);
						ns = (ValaUsingDirective*) _tmp197_;
						_tmp198_ = ns;
						_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
						_tmp200_ = _tmp199_;
						if (_tmp200_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp201_ = ns;
						_tmp202_ = vala_using_directive_get_namespace_symbol (_tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_symbol_get_scope (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = self->priv->_member_name;
						_tmp207_ = vala_scope_lookup (_tmp205_, _tmp206_);
						local_sym = _tmp207_;
						_tmp208_ = local_sym;
						if (_tmp208_ != NULL) {
							gboolean _tmp209_ = FALSE;
							ValaSymbol* _tmp210_;
							ValaSymbol* _tmp211_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp225_;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp247_;
							ValaExpression* _tmp248_;
							ValaExpression* _tmp249_;
							ValaSymbol* _tmp250_;
							_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp211_ = _tmp210_;
							if (_tmp211_ != NULL) {
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								ValaSymbol* _tmp214_;
								_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = local_sym;
								_tmp209_ = _tmp213_ != _tmp214_;
							} else {
								_tmp209_ = FALSE;
							}
							if (_tmp209_) {
								ValaSourceReference* _tmp215_;
								ValaSourceReference* _tmp216_;
								const gchar* _tmp217_;
								ValaSymbol* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								ValaSymbol* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = self->priv->_member_name;
								_tmp218_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp219_ = _tmp218_;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								_tmp222_ = local_sym;
								_tmp223_ = vala_symbol_get_full_name (_tmp222_);
								_tmp224_ = _tmp223_;
								vala_report_error (_tmp216_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp217_, _tmp221_, _tmp224_);
								_g_free0 (_tmp224_);
								_g_free0 (_tmp221_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp225_ = local_sym;
							_tmp226_ = vala_symbol_get_parent_symbol (_tmp225_);
							_tmp227_ = _tmp226_;
							inner_sym = _tmp227_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp228_ = FALSE;
								ValaSymbol* _tmp229_;
								ValaMemberAccess* _tmp233_;
								ValaSymbol* _tmp234_;
								const gchar* _tmp235_;
								const gchar* _tmp236_;
								ValaSourceReference* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaMemberAccess* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaExpression* _tmp242_;
								ValaExpression* _tmp243_;
								ValaSymbol* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								_tmp229_ = inner_sym;
								if (_tmp229_ != NULL) {
									ValaSymbol* _tmp230_;
									const gchar* _tmp231_;
									const gchar* _tmp232_;
									_tmp230_ = inner_sym;
									_tmp231_ = vala_symbol_get_name (_tmp230_);
									_tmp232_ = _tmp231_;
									_tmp228_ = _tmp232_ != NULL;
								} else {
									_tmp228_ = FALSE;
								}
								if (!_tmp228_) {
									break;
								}
								_tmp233_ = inner_ma;
								_tmp234_ = inner_sym;
								_tmp235_ = vala_symbol_get_name (_tmp234_);
								_tmp236_ = _tmp235_;
								_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp238_ = _tmp237_;
								_tmp239_ = vala_member_access_new (NULL, _tmp236_, _tmp238_);
								_tmp240_ = _tmp239_;
								vala_member_access_set_inner (_tmp233_, (ValaExpression*) _tmp240_);
								_vala_code_node_unref0 (_tmp240_);
								_tmp241_ = inner_ma;
								_tmp242_ = vala_member_access_get_inner (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp243_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp244_ = inner_sym;
								_tmp245_ = vala_symbol_get_parent_symbol (_tmp244_);
								_tmp246_ = _tmp245_;
								inner_sym = _tmp246_;
							}
							_tmp247_ = inner_ma;
							vala_member_access_set_qualified (_tmp247_, TRUE);
							_tmp248_ = vala_member_access_get_inner (self);
							_tmp249_ = _tmp248_;
							vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
							_tmp250_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp253_;
			gboolean _tmp254_;
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaDataType* _tmp257_;
			ValaDataType* _tmp258_;
			gboolean _tmp289_ = FALSE;
			ValaExpression* _tmp290_;
			ValaExpression* _tmp291_;
			ValaDataType* _tmp292_;
			ValaDataType* _tmp293_;
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			gboolean _tmp313_ = FALSE;
			ValaExpression* _tmp314_;
			ValaExpression* _tmp315_;
			gboolean _tmp322_ = FALSE;
			ValaExpression* _tmp323_;
			ValaExpression* _tmp324_;
			gboolean _tmp345_ = FALSE;
			ValaExpression* _tmp346_;
			ValaExpression* _tmp347_;
			gboolean _tmp362_ = FALSE;
			ValaSymbol* _tmp363_;
			ValaSymbol* _tmp364_;
			gboolean _tmp398_ = FALSE;
			gboolean _tmp399_ = FALSE;
			ValaSymbol* _tmp400_;
			ValaSymbol* _tmp401_;
			ValaSymbol* _tmp713_;
			ValaSymbol* _tmp714_;
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_code_node_get_error ((ValaCodeNode*) _tmp252_);
			_tmp254_ = _tmp253_;
			if (_tmp254_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp255_ = vala_member_access_get_inner (self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_value_type (_tmp256_);
			_tmp258_ = _tmp257_;
			if (VALA_IS_POINTER_TYPE (_tmp258_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaDataType* _tmp261_;
				ValaDataType* _tmp262_;
				gboolean _tmp263_ = FALSE;
				ValaPointerType* _tmp264_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_value_type (_tmp260_);
				_tmp262_ = _tmp261_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp262_) ? ((ValaPointerType*) _tmp262_) : NULL;
				_tmp264_ = pointer_type;
				if (_tmp264_ != NULL) {
					ValaPointerType* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					_tmp265_ = pointer_type;
					_tmp266_ = vala_pointer_type_get_base_type (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp263_ = VALA_IS_VALUE_TYPE (_tmp267_);
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaExpression* _tmp268_;
					ValaExpression* _tmp269_;
					ValaDataType* _tmp270_;
					ValaDataType* _tmp271_;
					ValaExpression* _tmp281_;
					ValaExpression* _tmp282_;
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaPointerIndirection* _tmp285_;
					ValaPointerIndirection* _tmp286_;
					ValaExpression* _tmp287_;
					ValaExpression* _tmp288_;
					_tmp268_ = vala_member_access_get_inner (self);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_expression_get_formal_value_type (_tmp269_);
					_tmp271_ = _tmp270_;
					if (VALA_IS_GENERIC_TYPE (_tmp271_)) {
						ValaExpression* _tmp272_;
						ValaExpression* _tmp273_;
						ValaPointerType* _tmp274_;
						ValaDataType* _tmp275_;
						ValaDataType* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaCastExpression* _tmp279_;
						ValaCastExpression* _tmp280_;
						_tmp272_ = vala_member_access_get_inner (self);
						_tmp273_ = _tmp272_;
						_tmp274_ = pointer_type;
						_tmp275_ = vala_data_type_copy ((ValaDataType*) _tmp274_);
						_tmp276_ = _tmp275_;
						_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp278_ = _tmp277_;
						_tmp279_ = vala_cast_expression_new (_tmp273_, _tmp276_, _tmp278_);
						_tmp280_ = _tmp279_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp280_);
						_vala_code_node_unref0 (_tmp280_);
						_vala_code_node_unref0 (_tmp276_);
					}
					_tmp281_ = vala_member_access_get_inner (self);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_pointer_indirection_new (_tmp282_, _tmp284_);
					_tmp286_ = _tmp285_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp286_);
					_vala_code_node_unref0 (_tmp286_);
					_tmp287_ = vala_member_access_get_inner (self);
					_tmp288_ = _tmp287_;
					vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp290_ = vala_member_access_get_inner (self);
			_tmp291_ = _tmp290_;
			_tmp292_ = vala_expression_get_value_type (_tmp291_);
			_tmp293_ = _tmp292_;
			if (VALA_IS_SIGNAL_TYPE (_tmp293_)) {
				const gchar* _tmp294_;
				_tmp294_ = self->priv->_member_name;
				_tmp289_ = g_strcmp0 (_tmp294_, "emit") == 0;
			} else {
				_tmp289_ = FALSE;
			}
			if (_tmp289_) {
				ValaCodeNode* _tmp295_;
				ValaCodeNode* _tmp296_;
				ValaExpression* _tmp297_;
				ValaExpression* _tmp298_;
				_tmp295_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp296_ = _tmp295_;
				_tmp297_ = vala_member_access_get_inner (self);
				_tmp298_ = _tmp297_;
				vala_code_node_replace_expression (_tmp296_, (ValaExpression*) self, _tmp298_);
				result = TRUE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp299_ = vala_member_access_get_inner (self);
			_tmp300_ = _tmp299_;
			if (VALA_IS_MEMBER_ACCESS (_tmp300_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaMemberAccess* _tmp303_;
				gboolean _tmp304_;
				_tmp301_ = vala_member_access_get_inner (self);
				_tmp302_ = _tmp301_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp303_ = ma;
				_tmp304_ = _tmp303_->priv->_prototype_access;
				if (_tmp304_) {
					ValaSourceReference* _tmp305_;
					ValaSourceReference* _tmp306_;
					ValaExpression* _tmp307_;
					ValaExpression* _tmp308_;
					ValaSymbol* _tmp309_;
					ValaSymbol* _tmp310_;
					gchar* _tmp311_;
					gchar* _tmp312_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp305_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_member_access_get_inner (self);
					_tmp308_ = _tmp307_;
					_tmp309_ = vala_expression_get_symbol_reference (_tmp308_);
					_tmp310_ = _tmp309_;
					_tmp311_ = vala_symbol_get_full_name (_tmp310_);
					_tmp312_ = _tmp311_;
					vala_report_error (_tmp306_, "Access to instance member `%s' denied", _tmp312_);
					_g_free0 (_tmp312_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp314_ = vala_member_access_get_inner (self);
			_tmp315_ = _tmp314_;
			if (VALA_IS_CAST_EXPRESSION (_tmp315_)) {
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				gboolean _tmp318_;
				gboolean _tmp319_;
				_tmp316_ = vala_member_access_get_inner (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp317_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp319_ = _tmp318_;
				_tmp313_ = _tmp319_;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaSourceReference* _tmp320_;
				ValaSourceReference* _tmp321_;
				_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				vala_report_warning (_tmp321_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp323_ = vala_member_access_get_inner (self);
			_tmp324_ = _tmp323_;
			if (VALA_IS_MEMBER_ACCESS (_tmp324_)) {
				_tmp322_ = TRUE;
			} else {
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				_tmp325_ = vala_member_access_get_inner (self);
				_tmp326_ = _tmp325_;
				_tmp322_ = VALA_IS_BASE_ACCESS (_tmp326_);
			}
			if (_tmp322_) {
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaSymbol* _tmp329_;
				ValaSymbol* _tmp330_;
				gboolean _tmp331_ = FALSE;
				ValaSymbol* _tmp332_;
				ValaSymbol* _tmp333_;
				_tmp327_ = vala_member_access_get_inner (self);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_expression_get_symbol_reference (_tmp328_);
				_tmp330_ = _tmp329_;
				base_symbol = _tmp330_;
				_tmp332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp333_ = _tmp332_;
				if (_tmp333_ == NULL) {
					gboolean _tmp334_ = FALSE;
					ValaSymbol* _tmp335_;
					_tmp335_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp335_)) {
						_tmp334_ = TRUE;
					} else {
						ValaSymbol* _tmp336_;
						_tmp336_ = base_symbol;
						_tmp334_ = VALA_IS_TYPESYMBOL (_tmp336_);
					}
					_tmp331_ = _tmp334_;
				} else {
					_tmp331_ = FALSE;
				}
				if (_tmp331_) {
					ValaSymbol* _tmp337_;
					ValaScope* _tmp338_;
					ValaScope* _tmp339_;
					const gchar* _tmp340_;
					ValaSymbol* _tmp341_;
					ValaSymbol* _tmp342_;
					ValaExpression* _tmp343_;
					ValaExpression* _tmp344_;
					_tmp337_ = base_symbol;
					_tmp338_ = vala_symbol_get_scope (_tmp337_);
					_tmp339_ = _tmp338_;
					_tmp340_ = self->priv->_member_name;
					_tmp341_ = vala_scope_lookup (_tmp339_, _tmp340_);
					_tmp342_ = _tmp341_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp342_);
					_vala_code_node_unref0 (_tmp342_);
					_tmp343_ = vala_member_access_get_inner (self);
					_tmp344_ = _tmp343_;
					if (VALA_IS_BASE_ACCESS (_tmp344_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp346_ = vala_member_access_get_inner (self);
			_tmp347_ = _tmp346_;
			if (VALA_IS_MEMBER_ACCESS (_tmp347_)) {
				ValaExpression* _tmp348_;
				ValaExpression* _tmp349_;
				ValaSymbol* _tmp350_;
				ValaSymbol* _tmp351_;
				_tmp348_ = vala_member_access_get_inner (self);
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_expression_get_symbol_reference (_tmp349_);
				_tmp351_ = _tmp350_;
				_tmp345_ = VALA_IS_TYPEPARAMETER (_tmp351_);
			} else {
				_tmp345_ = FALSE;
			}
			if (_tmp345_) {
				ValaExpression* _tmp352_;
				ValaExpression* _tmp353_;
				ValaExpression* _tmp354_;
				ValaExpression* _tmp355_;
				ValaSymbol* _tmp356_;
				ValaSymbol* _tmp357_;
				ValaSourceReference* _tmp358_;
				ValaSourceReference* _tmp359_;
				ValaGenericType* _tmp360_;
				ValaGenericType* _tmp361_;
				_tmp352_ = vala_member_access_get_inner (self);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_member_access_get_inner (self);
				_tmp355_ = _tmp354_;
				_tmp356_ = vala_expression_get_symbol_reference (_tmp355_);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp359_ = _tmp358_;
				_tmp360_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter), _tmp359_);
				_tmp361_ = _tmp360_;
				vala_expression_set_value_type (_tmp353_, (ValaDataType*) _tmp361_);
				_vala_code_node_unref0 (_tmp361_);
			}
			_tmp363_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp364_ = _tmp363_;
			if (_tmp364_ == NULL) {
				ValaExpression* _tmp365_;
				ValaExpression* _tmp366_;
				ValaDataType* _tmp367_;
				ValaDataType* _tmp368_;
				_tmp365_ = vala_member_access_get_inner (self);
				_tmp366_ = _tmp365_;
				_tmp367_ = vala_expression_get_value_type (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp362_ = _tmp368_ != NULL;
			} else {
				_tmp362_ = FALSE;
			}
			if (_tmp362_) {
				gboolean _tmp369_;
				ValaSymbol* _tmp396_;
				ValaSymbol* _tmp397_;
				_tmp369_ = self->priv->_pointer_member_access;
				if (_tmp369_) {
					ValaExpression* _tmp370_;
					ValaExpression* _tmp371_;
					ValaDataType* _tmp372_;
					ValaDataType* _tmp373_;
					const gchar* _tmp374_;
					ValaSymbol* _tmp375_;
					ValaSymbol* _tmp376_;
					_tmp370_ = vala_member_access_get_inner (self);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_expression_get_value_type (_tmp371_);
					_tmp373_ = _tmp372_;
					_tmp374_ = self->priv->_member_name;
					_tmp375_ = vala_data_type_get_pointer_member (_tmp373_, _tmp374_);
					_tmp376_ = _tmp375_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp376_);
					_vala_code_node_unref0 (_tmp376_);
				} else {
					ValaExpression* _tmp377_;
					ValaExpression* _tmp378_;
					ValaDataType* _tmp379_;
					ValaDataType* _tmp380_;
					ValaTypeSymbol* _tmp381_;
					ValaTypeSymbol* _tmp382_;
					ValaExpression* _tmp389_;
					ValaExpression* _tmp390_;
					ValaDataType* _tmp391_;
					ValaDataType* _tmp392_;
					const gchar* _tmp393_;
					ValaSymbol* _tmp394_;
					ValaSymbol* _tmp395_;
					_tmp377_ = vala_member_access_get_inner (self);
					_tmp378_ = _tmp377_;
					_tmp379_ = vala_expression_get_value_type (_tmp378_);
					_tmp380_ = _tmp379_;
					_tmp381_ = vala_data_type_get_type_symbol (_tmp380_);
					_tmp382_ = _tmp381_;
					if (_tmp382_ != NULL) {
						ValaExpression* _tmp383_;
						ValaExpression* _tmp384_;
						ValaDataType* _tmp385_;
						ValaDataType* _tmp386_;
						ValaTypeSymbol* _tmp387_;
						ValaTypeSymbol* _tmp388_;
						_tmp383_ = vala_member_access_get_inner (self);
						_tmp384_ = _tmp383_;
						_tmp385_ = vala_expression_get_value_type (_tmp384_);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_data_type_get_type_symbol (_tmp386_);
						_tmp388_ = _tmp387_;
						base_symbol = (ValaSymbol*) _tmp388_;
					}
					_tmp389_ = vala_member_access_get_inner (self);
					_tmp390_ = _tmp389_;
					_tmp391_ = vala_expression_get_value_type (_tmp390_);
					_tmp392_ = _tmp391_;
					_tmp393_ = self->priv->_member_name;
					_tmp394_ = vala_data_type_get_member (_tmp392_, _tmp393_);
					_tmp395_ = _tmp394_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp395_);
					_vala_code_node_unref0 (_tmp395_);
				}
				_tmp396_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp397_ = _tmp396_;
				if (_tmp397_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp401_ = _tmp400_;
			if (_tmp401_ == NULL) {
				ValaExpression* _tmp402_;
				ValaExpression* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp405_;
				_tmp402_ = vala_member_access_get_inner (self);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_expression_get_value_type (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp399_ = _tmp405_ != NULL;
			} else {
				_tmp399_ = FALSE;
			}
			if (_tmp399_) {
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				gboolean _tmp410_;
				gboolean _tmp411_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_data_type_get_is_dynamic (_tmp409_);
				_tmp411_ = _tmp410_;
				_tmp398_ = _tmp411_;
			} else {
				_tmp398_ = FALSE;
			}
			if (_tmp398_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp412_;
				ValaExpression* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaObjectType* _tmp416_;
				ValaCodeNode* _tmp417_;
				ValaCodeNode* _tmp418_;
				ValaSymbol* _tmp648_;
				ValaSymbol* _tmp649_;
				ValaSymbol* _tmp711_;
				ValaSymbol* _tmp712_;
				_tmp412_ = vala_member_access_get_inner (self);
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_expression_get_value_type (_tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp415_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp416_;
				_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp418_ = _tmp417_;
				if (VALA_IS_METHOD_CALL (_tmp418_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp419_;
					ValaCodeNode* _tmp420_;
					ValaMethodCall* _tmp421_;
					ValaExpression* _tmp422_;
					ValaExpression* _tmp423_;
					_tmp419_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp420_ = _tmp419_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp421_ = invoc;
					_tmp422_ = vala_method_call_get_call (_tmp421_);
					_tmp423_ = _tmp422_;
					if (_tmp423_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp424_;
						ValaDataType* _tmp425_;
						ValaDataType* _tmp426_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp441_;
						ValaExpression* _tmp442_;
						ValaDataType* _tmp443_;
						ValaDataType* _tmp444_;
						const gchar* _tmp445_;
						ValaDataType* _tmp446_;
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						ValaDynamicMethod* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						ValaMethodCall* _tmp451_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp452_;
						ValaSourceReference* _tmp453_;
						ValaSourceReference* _tmp454_;
						ValaErrorType* _tmp455_;
						ValaErrorType* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaErrorType* _tmp458_;
						ValaDynamicMethod* _tmp459_;
						ValaDynamicMethod* _tmp460_;
						ValaParameter* _tmp461_;
						ValaParameter* _tmp462_;
						ValaDynamicMethod* _tmp463_;
						ValaObjectType* _tmp464_;
						ValaDataType* _tmp465_;
						ValaDataType* _tmp466_;
						ValaDynamicMethod* _tmp467_;
						ValaSourceReference* _tmp468_;
						ValaSourceReference* _tmp469_;
						ValaParameter* _tmp470_;
						ValaParameter* _tmp471_;
						ValaObjectType* _tmp472_;
						ValaTypeSymbol* _tmp473_;
						ValaTypeSymbol* _tmp474_;
						ValaScope* _tmp475_;
						ValaScope* _tmp476_;
						ValaDynamicMethod* _tmp477_;
						ValaDynamicMethod* _tmp478_;
						_tmp424_ = invoc;
						_tmp425_ = vala_expression_get_target_type ((ValaExpression*) _tmp424_);
						_tmp426_ = _tmp425_;
						if (_tmp426_ != NULL) {
							ValaMethodCall* _tmp427_;
							ValaDataType* _tmp428_;
							ValaDataType* _tmp429_;
							ValaDataType* _tmp430_;
							ValaDataType* _tmp431_;
							_tmp427_ = invoc;
							_tmp428_ = vala_expression_get_target_type ((ValaExpression*) _tmp427_);
							_tmp429_ = _tmp428_;
							_tmp430_ = vala_data_type_copy (_tmp429_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp430_;
							_tmp431_ = ret_type;
							vala_data_type_set_value_owned (_tmp431_, TRUE);
						} else {
							ValaMethodCall* _tmp432_;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							_tmp432_ = invoc;
							_tmp433_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp432_);
							_tmp434_ = _tmp433_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp434_)) {
								ValaVoidType* _tmp435_;
								_tmp435_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp435_;
							} else {
								ValaExpression* _tmp436_;
								ValaExpression* _tmp437_;
								ValaDataType* _tmp438_;
								ValaDataType* _tmp439_;
								ValaDataType* _tmp440_;
								_tmp436_ = vala_member_access_get_inner (self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_expression_get_value_type (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = vala_data_type_copy (_tmp439_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp440_;
							}
						}
						_tmp441_ = vala_member_access_get_inner (self);
						_tmp442_ = _tmp441_;
						_tmp443_ = vala_expression_get_value_type (_tmp442_);
						_tmp444_ = _tmp443_;
						_tmp445_ = self->priv->_member_name;
						_tmp446_ = ret_type;
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp448_ = _tmp447_;
						_tmp449_ = vala_dynamic_method_new (_tmp444_, _tmp445_, _tmp446_, _tmp448_, NULL);
						m = _tmp449_;
						_tmp450_ = m;
						_tmp451_ = invoc;
						vala_dynamic_method_set_invocation (_tmp450_, _tmp451_);
						_tmp452_ = m;
						_tmp453_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp452_);
						_tmp454_ = _tmp453_;
						_tmp455_ = vala_error_type_new (NULL, NULL, _tmp454_);
						err = _tmp455_;
						_tmp456_ = err;
						vala_error_type_set_dynamic_error (_tmp456_, TRUE);
						_tmp457_ = m;
						_tmp458_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp457_, (ValaDataType*) _tmp458_);
						_tmp459_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp459_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp460_ = m;
						_tmp461_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp462_ = _tmp461_;
						vala_callable_add_parameter ((ValaCallable*) _tmp460_, _tmp462_);
						_vala_code_node_unref0 (_tmp462_);
						_tmp463_ = m;
						_tmp464_ = dynamic_object_type;
						_tmp465_ = vala_data_type_copy ((ValaDataType*) _tmp464_);
						_tmp466_ = _tmp465_;
						_tmp467_ = m;
						_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp467_);
						_tmp469_ = _tmp468_;
						_tmp470_ = vala_parameter_new ("this", _tmp466_, _tmp469_);
						_tmp471_ = _tmp470_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp463_, _tmp471_);
						_vala_code_node_unref0 (_tmp471_);
						_vala_code_node_unref0 (_tmp466_);
						_tmp472_ = dynamic_object_type;
						_tmp473_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp472_);
						_tmp474_ = _tmp473_;
						_tmp475_ = vala_symbol_get_scope ((ValaSymbol*) _tmp474_);
						_tmp476_ = _tmp475_;
						_tmp477_ = m;
						vala_scope_add (_tmp476_, NULL, (ValaSymbol*) _tmp477_);
						_tmp478_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp478_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp479_;
					ValaCodeNode* _tmp480_;
					_tmp479_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp480_ = _tmp479_;
					if (VALA_IS_ASSIGNMENT (_tmp480_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp481_;
						ValaCodeNode* _tmp482_;
						ValaAssignment* _tmp483_;
						ValaExpression* _tmp484_;
						ValaExpression* _tmp485_;
						_tmp481_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp482_ = _tmp481_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp483_ = a;
						_tmp484_ = vala_assignment_get_left (_tmp483_);
						_tmp485_ = _tmp484_;
						if (_tmp485_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp486_;
							ValaExpression* _tmp487_;
							ValaDataType* _tmp488_;
							ValaDataType* _tmp489_;
							const gchar* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaDynamicProperty* _tmp493_;
							ValaDynamicProperty* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaDynamicProperty* _tmp496_;
							ValaSourceReference* _tmp497_;
							ValaSourceReference* _tmp498_;
							ValaPropertyAccessor* _tmp499_;
							ValaPropertyAccessor* _tmp500_;
							ValaDynamicProperty* _tmp501_;
							ValaExpression* _tmp502_;
							ValaExpression* _tmp503_;
							ValaDataType* _tmp504_;
							ValaDataType* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaTypeSymbol* _tmp507_;
							ValaScope* _tmp508_;
							ValaScope* _tmp509_;
							ValaObjectType* _tmp510_;
							ValaTypeSymbol* _tmp511_;
							ValaTypeSymbol* _tmp512_;
							ValaScope* _tmp513_;
							ValaScope* _tmp514_;
							ValaDynamicProperty* _tmp515_;
							ValaDynamicProperty* _tmp516_;
							ValaObjectType* _tmp517_;
							ValaTypeSymbol* _tmp518_;
							ValaTypeSymbol* _tmp519_;
							ValaSemanticAnalyzer* _tmp520_;
							ValaSemanticAnalyzer* _tmp521_;
							ValaClass* _tmp522_;
							_tmp486_ = vala_member_access_get_inner (self);
							_tmp487_ = _tmp486_;
							_tmp488_ = vala_expression_get_value_type (_tmp487_);
							_tmp489_ = _tmp488_;
							_tmp490_ = self->priv->_member_name;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_dynamic_property_new (_tmp489_, _tmp490_, _tmp492_, NULL);
							prop = _tmp493_;
							_tmp494_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp494_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp495_ = prop;
							_tmp496_ = prop;
							_tmp497_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp496_);
							_tmp498_ = _tmp497_;
							_tmp499_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp498_, NULL);
							_tmp500_ = _tmp499_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp495_, _tmp500_);
							_vala_code_node_unref0 (_tmp500_);
							_tmp501_ = prop;
							_tmp502_ = vala_member_access_get_inner (self);
							_tmp503_ = _tmp502_;
							_tmp504_ = vala_expression_get_value_type (_tmp503_);
							_tmp505_ = _tmp504_;
							_tmp506_ = vala_data_type_get_type_symbol (_tmp505_);
							_tmp507_ = _tmp506_;
							_tmp508_ = vala_symbol_get_scope ((ValaSymbol*) _tmp507_);
							_tmp509_ = _tmp508_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp501_, _tmp509_);
							_tmp510_ = dynamic_object_type;
							_tmp511_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp510_);
							_tmp512_ = _tmp511_;
							_tmp513_ = vala_symbol_get_scope ((ValaSymbol*) _tmp512_);
							_tmp514_ = _tmp513_;
							_tmp515_ = prop;
							vala_scope_add (_tmp514_, NULL, (ValaSymbol*) _tmp515_);
							_tmp516_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp516_);
							_tmp517_ = dynamic_object_type;
							_tmp518_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp517_);
							_tmp519_ = _tmp518_;
							_tmp520_ = vala_code_context_get_analyzer (context);
							_tmp521_ = _tmp520_;
							_tmp522_ = _tmp521_->object_type;
							if (!vala_typesymbol_is_subtype_of (_tmp519_, (ValaTypeSymbol*) _tmp522_)) {
								ValaSourceReference* _tmp523_;
								ValaSourceReference* _tmp524_;
								ValaObjectType* _tmp525_;
								ValaTypeSymbol* _tmp526_;
								ValaTypeSymbol* _tmp527_;
								gchar* _tmp528_;
								gchar* _tmp529_;
								_tmp523_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp524_ = _tmp523_;
								_tmp525_ = dynamic_object_type;
								_tmp526_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp525_);
								_tmp527_ = _tmp526_;
								_tmp528_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp527_);
								_tmp529_ = _tmp528_;
								vala_report_error (_tmp524_, "dynamic properties are not supported for `%s'", _tmp529_);
								_g_free0 (_tmp529_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							}
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp530_ = FALSE;
						gboolean _tmp531_ = FALSE;
						ValaCodeNode* _tmp532_;
						ValaCodeNode* _tmp533_;
						_tmp532_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp533_ = _tmp532_;
						if (VALA_IS_MEMBER_ACCESS (_tmp533_)) {
							ValaExpression* _tmp534_;
							ValaExpression* _tmp535_;
							_tmp534_ = vala_member_access_get_inner (self);
							_tmp535_ = _tmp534_;
							_tmp531_ = VALA_IS_MEMBER_ACCESS (_tmp535_);
						} else {
							_tmp531_ = FALSE;
						}
						if (_tmp531_) {
							ValaCodeNode* _tmp536_;
							ValaCodeNode* _tmp537_;
							ValaCodeNode* _tmp538_;
							ValaCodeNode* _tmp539_;
							_tmp536_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp537_ = _tmp536_;
							_tmp538_ = vala_code_node_get_parent_node (_tmp537_);
							_tmp539_ = _tmp538_;
							_tmp530_ = VALA_IS_METHOD_CALL (_tmp539_);
						} else {
							_tmp530_ = FALSE;
						}
						if (_tmp530_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp540_;
							ValaCodeNode* _tmp541_;
							gboolean _tmp542_ = FALSE;
							ValaMemberAccess* _tmp543_;
							const gchar* _tmp544_;
							_tmp540_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp541_ = _tmp540_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp541_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp543_ = ma;
							_tmp544_ = _tmp543_->priv->_member_name;
							if (g_strcmp0 (_tmp544_, "connect") == 0) {
								_tmp542_ = TRUE;
							} else {
								ValaMemberAccess* _tmp545_;
								const gchar* _tmp546_;
								_tmp545_ = ma;
								_tmp546_ = _tmp545_->priv->_member_name;
								_tmp542_ = g_strcmp0 (_tmp546_, "connect_after") == 0;
							}
							if (_tmp542_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp547_;
								ValaExpression* _tmp548_;
								ValaDataType* _tmp549_;
								ValaDataType* _tmp550_;
								const gchar* _tmp551_;
								ValaVoidType* _tmp552_;
								ValaVoidType* _tmp553_;
								ValaSourceReference* _tmp554_;
								ValaSourceReference* _tmp555_;
								ValaDynamicSignal* _tmp556_;
								ValaDynamicSignal* _tmp557_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp558_;
								ValaCodeNode* _tmp559_;
								ValaCodeNode* _tmp560_;
								ValaCodeNode* _tmp561_;
								ValaMethodCall* _tmp562_;
								ValaMethodCall* _tmp563_;
								ValaList* _tmp564_;
								gint _tmp565_;
								gint _tmp566_;
								ValaDynamicSignal* _tmp598_;
								ValaObjectType* _tmp599_;
								ValaTypeSymbol* _tmp600_;
								ValaTypeSymbol* _tmp601_;
								ValaScope* _tmp602_;
								ValaScope* _tmp603_;
								ValaDynamicSignal* _tmp604_;
								ValaDynamicSignal* _tmp605_;
								_tmp547_ = vala_member_access_get_inner (self);
								_tmp548_ = _tmp547_;
								_tmp549_ = vala_expression_get_value_type (_tmp548_);
								_tmp550_ = _tmp549_;
								_tmp551_ = self->priv->_member_name;
								_tmp552_ = vala_void_type_new (NULL);
								_tmp553_ = _tmp552_;
								_tmp554_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp555_ = _tmp554_;
								_tmp556_ = vala_dynamic_signal_new (_tmp550_, _tmp551_, (ValaDataType*) _tmp553_, _tmp555_, NULL);
								_tmp557_ = _tmp556_;
								_vala_code_node_unref0 (_tmp553_);
								s = _tmp557_;
								_tmp558_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp559_ = _tmp558_;
								_tmp560_ = vala_code_node_get_parent_node (_tmp559_);
								_tmp561_ = _tmp560_;
								_tmp562_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp561_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp562_;
								_tmp563_ = mcall;
								_tmp564_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp563_);
								_tmp565_ = vala_collection_get_size ((ValaCollection*) _tmp564_);
								_tmp566_ = _tmp565_;
								if (_tmp566_ > 0) {
									ValaDynamicSignal* _tmp567_;
									ValaMethodCall* _tmp568_;
									ValaList* _tmp569_;
									gpointer _tmp570_;
									ValaExpression* _tmp571_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp572_;
									ValaExpression* _tmp573_;
									ValaExpression* _tmp574_;
									gboolean _tmp575_ = FALSE;
									gboolean _tmp576_ = FALSE;
									ValaMemberAccess* _tmp577_;
									_tmp567_ = s;
									_tmp568_ = mcall;
									_tmp569_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp568_);
									_tmp570_ = vala_list_get (_tmp569_, 0);
									_tmp571_ = (ValaExpression*) _tmp570_;
									vala_dynamic_signal_set_handler (_tmp567_, _tmp571_);
									_vala_code_node_unref0 (_tmp571_);
									_tmp572_ = s;
									_tmp573_ = vala_dynamic_signal_get_handler (_tmp572_);
									_tmp574_ = _tmp573_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp574_) ? ((ValaMemberAccess*) _tmp574_) : NULL;
									_tmp577_ = arg;
									if (_tmp577_ == NULL) {
										_tmp576_ = TRUE;
									} else {
										ValaMemberAccess* _tmp578_;
										_tmp578_ = arg;
										_tmp576_ = !vala_code_node_check ((ValaCodeNode*) _tmp578_, context);
									}
									if (_tmp576_) {
										_tmp575_ = TRUE;
									} else {
										ValaMemberAccess* _tmp579_;
										ValaSymbol* _tmp580_;
										ValaSymbol* _tmp581_;
										_tmp579_ = arg;
										_tmp580_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp579_);
										_tmp581_ = _tmp580_;
										_tmp575_ = !VALA_IS_METHOD (_tmp581_);
									}
									if (_tmp575_) {
										ValaDynamicSignal* _tmp582_;
										ValaExpression* _tmp583_;
										ValaExpression* _tmp584_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp582_ = s;
										_tmp583_ = vala_dynamic_signal_get_handler (_tmp582_);
										_tmp584_ = _tmp583_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp584_)) {
											ValaDynamicSignal* _tmp585_;
											ValaExpression* _tmp586_;
											ValaExpression* _tmp587_;
											ValaSourceReference* _tmp588_;
											ValaSourceReference* _tmp589_;
											_tmp585_ = s;
											_tmp586_ = vala_dynamic_signal_get_handler (_tmp585_);
											_tmp587_ = _tmp586_;
											_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp587_);
											_tmp589_ = _tmp588_;
											vala_report_error (_tmp589_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp590_;
											ValaExpression* _tmp591_;
											ValaExpression* _tmp592_;
											ValaSourceReference* _tmp593_;
											ValaSourceReference* _tmp594_;
											ValaDynamicSignal* _tmp595_;
											gchar* _tmp596_;
											gchar* _tmp597_;
											_tmp590_ = s;
											_tmp591_ = vala_dynamic_signal_get_handler (_tmp590_);
											_tmp592_ = _tmp591_;
											_tmp593_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp592_);
											_tmp594_ = _tmp593_;
											_tmp595_ = s;
											_tmp596_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp595_);
											_tmp597_ = _tmp596_;
											vala_report_error (_tmp594_, "Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp597_);
											_g_free0 (_tmp597_);
										}
									}
								}
								_tmp598_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp598_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp599_ = dynamic_object_type;
								_tmp600_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp599_);
								_tmp601_ = _tmp600_;
								_tmp602_ = vala_symbol_get_scope ((ValaSymbol*) _tmp601_);
								_tmp603_ = _tmp602_;
								_tmp604_ = s;
								vala_scope_add (_tmp603_, NULL, (ValaSymbol*) _tmp604_);
								_tmp605_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp605_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp606_;
								const gchar* _tmp607_;
								_tmp606_ = ma;
								_tmp607_ = _tmp606_->priv->_member_name;
								if (g_strcmp0 (_tmp607_, "emit") == 0) {
									ValaMethodCall* mcall = NULL;
									ValaMemberAccess* _tmp608_;
									ValaCodeNode* _tmp609_;
									ValaCodeNode* _tmp610_;
									ValaDataType* _tmp611_ = NULL;
									ValaMethodCall* _tmp612_;
									ValaDataType* _tmp613_;
									ValaDataType* _tmp614_;
									ValaDataType* _tmp615_;
									ValaDataType* return_type = NULL;
									ValaDataType* _tmp617_;
									ValaDataType* _tmp618_;
									ValaDynamicSignal* s = NULL;
									ValaExpression* _tmp623_;
									ValaExpression* _tmp624_;
									ValaDataType* _tmp625_;
									ValaDataType* _tmp626_;
									const gchar* _tmp627_;
									ValaDataType* _tmp628_;
									ValaSourceReference* _tmp629_;
									ValaSourceReference* _tmp630_;
									ValaDynamicSignal* _tmp631_;
									ValaDynamicSignal* _tmp632_;
									ValaDynamicSignal* _tmp633_;
									ValaParameter* _tmp634_;
									ValaParameter* _tmp635_;
									ValaObjectType* _tmp636_;
									ValaTypeSymbol* _tmp637_;
									ValaTypeSymbol* _tmp638_;
									ValaScope* _tmp639_;
									ValaScope* _tmp640_;
									ValaDynamicSignal* _tmp641_;
									ValaDynamicSignal* _tmp642_;
									_tmp608_ = ma;
									_tmp609_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp608_);
									_tmp610_ = _tmp609_;
									mcall = G_TYPE_CHECK_INSTANCE_CAST (_tmp610_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
									_tmp612_ = mcall;
									_tmp613_ = vala_expression_get_target_type ((ValaExpression*) _tmp612_);
									_tmp614_ = _tmp613_;
									_tmp615_ = _vala_code_node_ref0 (_tmp614_);
									_tmp611_ = _tmp615_;
									if (_tmp611_ == NULL) {
										ValaVoidType* _tmp616_;
										_tmp616_ = vala_void_type_new (NULL);
										_vala_code_node_unref0 (_tmp611_);
										_tmp611_ = (ValaDataType*) _tmp616_;
									}
									_tmp617_ = _tmp611_;
									_tmp611_ = NULL;
									return_type = _tmp617_;
									_tmp618_ = return_type;
									if (VALA_IS_VAR_TYPE (_tmp618_)) {
										ValaMethodCall* _tmp619_;
										ValaSourceReference* _tmp620_;
										ValaSourceReference* _tmp621_;
										const gchar* _tmp622_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp619_ = mcall;
										_tmp620_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp619_);
										_tmp621_ = _tmp620_;
										_tmp622_ = self->priv->_member_name;
										vala_report_error (_tmp621_, "Cannot infer return type for dynamic signal `%s' from given context", _tmp622_);
									}
									_tmp623_ = vala_member_access_get_inner (self);
									_tmp624_ = _tmp623_;
									_tmp625_ = vala_expression_get_value_type (_tmp624_);
									_tmp626_ = _tmp625_;
									_tmp627_ = self->priv->_member_name;
									_tmp628_ = return_type;
									_tmp629_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp630_ = _tmp629_;
									_tmp631_ = vala_dynamic_signal_new (_tmp626_, _tmp627_, _tmp628_, _tmp630_, NULL);
									s = _tmp631_;
									_tmp632_ = s;
									vala_symbol_set_access ((ValaSymbol*) _tmp632_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
									_tmp633_ = s;
									_tmp634_ = vala_parameter_new_with_ellipsis (NULL);
									_tmp635_ = _tmp634_;
									vala_callable_add_parameter ((ValaCallable*) _tmp633_, _tmp635_);
									_vala_code_node_unref0 (_tmp635_);
									_tmp636_ = dynamic_object_type;
									_tmp637_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp636_);
									_tmp638_ = _tmp637_;
									_tmp639_ = vala_symbol_get_scope ((ValaSymbol*) _tmp638_);
									_tmp640_ = _tmp639_;
									_tmp641_ = s;
									vala_scope_add (_tmp640_, NULL, (ValaSymbol*) _tmp641_);
									_tmp642_ = s;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp642_);
									_vala_code_node_unref0 (s);
									_vala_code_node_unref0 (return_type);
									_vala_code_node_unref0 (_tmp611_);
								} else {
									ValaMemberAccess* _tmp643_;
									const gchar* _tmp644_;
									_tmp643_ = ma;
									_tmp644_ = _tmp643_->priv->_member_name;
									if (g_strcmp0 (_tmp644_, "disconnect") == 0) {
										ValaMemberAccess* _tmp645_;
										ValaSourceReference* _tmp646_;
										ValaSourceReference* _tmp647_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp645_ = ma;
										_tmp646_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp645_);
										_tmp647_ = _tmp646_;
										vala_report_error (_tmp647_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
									}
								}
							}
						}
					}
				}
				_tmp648_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp649_ = _tmp648_;
				if (_tmp649_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp650_;
					ValaExpression* _tmp651_;
					ValaDataType* _tmp652_;
					ValaDataType* _tmp653_;
					const gchar* _tmp654_;
					ValaSourceReference* _tmp655_;
					ValaSourceReference* _tmp656_;
					ValaDynamicProperty* _tmp657_;
					ValaDataType* _tmp658_;
					ValaDataType* _tmp659_;
					ValaDynamicProperty* _tmp670_;
					ValaDynamicProperty* _tmp671_;
					ValaDynamicProperty* _tmp672_;
					ValaDataType* _tmp673_;
					ValaDataType* _tmp674_;
					ValaDataType* _tmp675_;
					ValaDataType* _tmp676_;
					ValaDynamicProperty* _tmp677_;
					ValaSourceReference* _tmp678_;
					ValaSourceReference* _tmp679_;
					ValaPropertyAccessor* _tmp680_;
					ValaPropertyAccessor* _tmp681_;
					ValaDynamicProperty* _tmp682_;
					ValaExpression* _tmp683_;
					ValaExpression* _tmp684_;
					ValaDataType* _tmp685_;
					ValaDataType* _tmp686_;
					ValaTypeSymbol* _tmp687_;
					ValaTypeSymbol* _tmp688_;
					ValaScope* _tmp689_;
					ValaScope* _tmp690_;
					ValaObjectType* _tmp691_;
					ValaTypeSymbol* _tmp692_;
					ValaTypeSymbol* _tmp693_;
					ValaScope* _tmp694_;
					ValaScope* _tmp695_;
					ValaDynamicProperty* _tmp696_;
					ValaDynamicProperty* _tmp697_;
					ValaObjectType* _tmp698_;
					ValaTypeSymbol* _tmp699_;
					ValaTypeSymbol* _tmp700_;
					ValaSemanticAnalyzer* _tmp701_;
					ValaSemanticAnalyzer* _tmp702_;
					ValaClass* _tmp703_;
					_tmp650_ = vala_member_access_get_inner (self);
					_tmp651_ = _tmp650_;
					_tmp652_ = vala_expression_get_value_type (_tmp651_);
					_tmp653_ = _tmp652_;
					_tmp654_ = self->priv->_member_name;
					_tmp655_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp656_ = _tmp655_;
					_tmp657_ = vala_dynamic_property_new (_tmp653_, _tmp654_, _tmp656_, NULL);
					prop = _tmp657_;
					_tmp658_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp659_ = _tmp658_;
					if (_tmp659_ != NULL) {
						ValaDynamicProperty* _tmp660_;
						ValaDataType* _tmp661_;
						ValaDataType* _tmp662_;
						_tmp660_ = prop;
						_tmp661_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp662_ = _tmp661_;
						vala_property_set_property_type ((ValaProperty*) _tmp660_, _tmp662_);
					} else {
						ValaDynamicProperty* _tmp663_;
						ValaExpression* _tmp664_;
						ValaExpression* _tmp665_;
						ValaDataType* _tmp666_;
						ValaDataType* _tmp667_;
						ValaDataType* _tmp668_;
						ValaDataType* _tmp669_;
						_tmp663_ = prop;
						_tmp664_ = vala_member_access_get_inner (self);
						_tmp665_ = _tmp664_;
						_tmp666_ = vala_expression_get_value_type (_tmp665_);
						_tmp667_ = _tmp666_;
						_tmp668_ = vala_data_type_copy (_tmp667_);
						_tmp669_ = _tmp668_;
						vala_property_set_property_type ((ValaProperty*) _tmp663_, _tmp669_);
						_vala_code_node_unref0 (_tmp669_);
					}
					_tmp670_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp670_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp671_ = prop;
					_tmp672_ = prop;
					_tmp673_ = vala_property_get_property_type ((ValaProperty*) _tmp672_);
					_tmp674_ = _tmp673_;
					_tmp675_ = vala_data_type_copy (_tmp674_);
					_tmp676_ = _tmp675_;
					_tmp677_ = prop;
					_tmp678_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp677_);
					_tmp679_ = _tmp678_;
					_tmp680_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp676_, NULL, _tmp679_, NULL);
					_tmp681_ = _tmp680_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp671_, _tmp681_);
					_vala_code_node_unref0 (_tmp681_);
					_vala_code_node_unref0 (_tmp676_);
					_tmp682_ = prop;
					_tmp683_ = vala_member_access_get_inner (self);
					_tmp684_ = _tmp683_;
					_tmp685_ = vala_expression_get_value_type (_tmp684_);
					_tmp686_ = _tmp685_;
					_tmp687_ = vala_data_type_get_type_symbol (_tmp686_);
					_tmp688_ = _tmp687_;
					_tmp689_ = vala_symbol_get_scope ((ValaSymbol*) _tmp688_);
					_tmp690_ = _tmp689_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp682_, _tmp690_);
					_tmp691_ = dynamic_object_type;
					_tmp692_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp691_);
					_tmp693_ = _tmp692_;
					_tmp694_ = vala_symbol_get_scope ((ValaSymbol*) _tmp693_);
					_tmp695_ = _tmp694_;
					_tmp696_ = prop;
					vala_scope_add (_tmp695_, NULL, (ValaSymbol*) _tmp696_);
					_tmp697_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp697_);
					_tmp698_ = dynamic_object_type;
					_tmp699_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp698_);
					_tmp700_ = _tmp699_;
					_tmp701_ = vala_code_context_get_analyzer (context);
					_tmp702_ = _tmp701_;
					_tmp703_ = _tmp702_->object_type;
					if (!vala_typesymbol_is_subtype_of (_tmp700_, (ValaTypeSymbol*) _tmp703_)) {
						ValaSourceReference* _tmp704_;
						ValaSourceReference* _tmp705_;
						ValaObjectType* _tmp706_;
						ValaTypeSymbol* _tmp707_;
						ValaTypeSymbol* _tmp708_;
						gchar* _tmp709_;
						gchar* _tmp710_;
						_tmp704_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp705_ = _tmp704_;
						_tmp706_ = dynamic_object_type;
						_tmp707_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp706_);
						_tmp708_ = _tmp707_;
						_tmp709_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp708_);
						_tmp710_ = _tmp709_;
						vala_report_error (_tmp705_, "dynamic properties are not supported for %s", _tmp710_);
						_g_free0 (_tmp710_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_vala_code_node_unref0 (prop);
				}
				_tmp711_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp712_ = _tmp711_;
				if (_tmp712_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp713_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp714_ = _tmp713_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp714_)) {
				ValaExpression* _tmp715_;
				ValaExpression* _tmp716_;
				ValaSymbol* _tmp717_;
				ValaSymbol* _tmp718_;
				_tmp715_ = vala_member_access_get_inner (self);
				_tmp716_ = _tmp715_;
				_tmp717_ = vala_expression_get_symbol_reference (_tmp716_);
				_tmp718_ = _tmp717_;
				if (VALA_IS_VARIABLE (_tmp718_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp719_;
					ValaSemanticAnalyzer* _tmp720_;
					ValaExpression* _tmp721_;
					ValaExpression* _tmp722_;
					ValaSymbol* _tmp723_;
					ValaSymbol* _tmp724_;
					ValaDataType* _tmp725_;
					ValaArrayType* _tmp726_;
					gboolean _tmp727_ = FALSE;
					ValaArrayType* _tmp728_;
					_tmp719_ = vala_code_context_get_analyzer (context);
					_tmp720_ = _tmp719_;
					_tmp721_ = vala_member_access_get_inner (self);
					_tmp722_ = _tmp721_;
					_tmp723_ = vala_expression_get_symbol_reference (_tmp722_);
					_tmp724_ = _tmp723_;
					_tmp725_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp720_, _tmp724_, TRUE);
					_tmp726_ = VALA_IS_ARRAY_TYPE (_tmp725_) ? ((ValaArrayType*) _tmp725_) : NULL;
					if (_tmp726_ == NULL) {
						_vala_code_node_unref0 (_tmp725_);
					}
					inner_type = _tmp726_;
					_tmp728_ = inner_type;
					if (_tmp728_ != NULL) {
						ValaArrayType* _tmp729_;
						gboolean _tmp730_;
						gboolean _tmp731_;
						_tmp729_ = inner_type;
						_tmp730_ = vala_array_type_get_inline_allocated (_tmp729_);
						_tmp731_ = _tmp730_;
						_tmp727_ = _tmp731_;
					} else {
						_tmp727_ = FALSE;
					}
					if (_tmp727_) {
						ValaSourceReference* _tmp732_;
						ValaSourceReference* _tmp733_;
						_tmp732_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp733_ = _tmp732_;
						vala_report_error (_tmp733_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp734_ = FALSE;
						ValaArrayType* _tmp735_;
						_tmp735_ = inner_type;
						if (_tmp735_ != NULL) {
							ValaArrayType* _tmp736_;
							gboolean _tmp737_;
							gboolean _tmp738_;
							_tmp736_ = inner_type;
							_tmp737_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp736_);
							_tmp738_ = _tmp737_;
							_tmp734_ = !_tmp738_;
						} else {
							_tmp734_ = FALSE;
						}
						if (_tmp734_) {
							ValaSourceReference* _tmp739_;
							ValaSourceReference* _tmp740_;
							_tmp739_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp740_ = _tmp739_;
							vala_report_error (_tmp740_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp741_;
					ValaExpression* _tmp742_;
					ValaSymbol* _tmp743_;
					ValaSymbol* _tmp744_;
					_tmp741_ = vala_member_access_get_inner (self);
					_tmp742_ = _tmp741_;
					_tmp743_ = vala_expression_get_symbol_reference (_tmp742_);
					_tmp744_ = _tmp743_;
					if (VALA_IS_CONSTANT (_tmp744_)) {
						ValaSourceReference* _tmp745_;
						ValaSourceReference* _tmp746_;
						_tmp745_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp746_ = _tmp745_;
						vala_report_error (_tmp746_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp750_ = vala_member_access_get_inner (self);
	_tmp751_ = _tmp750_;
	if (_tmp751_ == NULL) {
		ValaSymbol* _tmp752_;
		ValaSymbol* _tmp753_;
		_tmp752_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp753_ = _tmp752_;
		_tmp749_ = _tmp753_ == NULL;
	} else {
		_tmp749_ = FALSE;
	}
	if (_tmp749_) {
		ValaDataType* _tmp754_;
		ValaDataType* _tmp755_;
		_tmp754_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp755_ = _tmp754_;
		_tmp748_ = _tmp755_ != NULL;
	} else {
		_tmp748_ = FALSE;
	}
	if (_tmp748_) {
		ValaDataType* _tmp756_;
		ValaDataType* _tmp757_;
		ValaTypeSymbol* _tmp758_;
		ValaTypeSymbol* _tmp759_;
		_tmp756_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp757_ = _tmp756_;
		_tmp758_ = vala_data_type_get_type_symbol (_tmp757_);
		_tmp759_ = _tmp758_;
		_tmp747_ = VALA_IS_ENUM (_tmp759_);
	} else {
		_tmp747_ = FALSE;
	}
	if (_tmp747_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp760_;
		ValaDataType* _tmp761_;
		ValaTypeSymbol* _tmp762_;
		ValaTypeSymbol* _tmp763_;
		_tmp760_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp761_ = _tmp760_;
		_tmp762_ = vala_data_type_get_type_symbol (_tmp761_);
		_tmp763_ = _tmp762_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp763_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp764_;
			ValaList* _tmp765_;
			gint _val_size = 0;
			ValaList* _tmp766_;
			gint _tmp767_;
			gint _tmp768_;
			gint _val_index = 0;
			_tmp764_ = enum_type;
			_tmp765_ = vala_enum_get_values (_tmp764_);
			_val_list = _tmp765_;
			_tmp766_ = _val_list;
			_tmp767_ = vala_collection_get_size ((ValaCollection*) _tmp766_);
			_tmp768_ = _tmp767_;
			_val_size = _tmp768_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp769_;
				gint _tmp770_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp771_;
				gpointer _tmp772_;
				const gchar* _tmp773_;
				ValaEnumValue* _tmp774_;
				const gchar* _tmp775_;
				const gchar* _tmp776_;
				_val_index = _val_index + 1;
				_tmp769_ = _val_index;
				_tmp770_ = _val_size;
				if (!(_tmp769_ < _tmp770_)) {
					break;
				}
				_tmp771_ = _val_list;
				_tmp772_ = vala_list_get (_tmp771_, _val_index);
				val = (ValaEnumValue*) _tmp772_;
				_tmp773_ = self->priv->_member_name;
				_tmp774_ = val;
				_tmp775_ = vala_symbol_get_name ((ValaSymbol*) _tmp774_);
				_tmp776_ = _tmp775_;
				if (g_strcmp0 (_tmp773_, _tmp776_) == 0) {
					ValaEnumValue* _tmp777_;
					_tmp777_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp777_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp778_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp779_ = _tmp778_;
	if (_tmp779_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp780_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp781_ = FALSE;
		ValaExpression* _tmp782_;
		ValaExpression* _tmp783_;
		gchar* base_type_package = NULL;
		gchar* _tmp803_;
		gboolean _tmp804_ = FALSE;
		ValaSymbol* _tmp805_;
		gchar* visited_types_string = NULL;
		gchar* _tmp820_;
		ValaSourceReference* _tmp836_;
		ValaSourceReference* _tmp837_;
		const gchar* _tmp838_;
		const gchar* _tmp839_;
		const gchar* _tmp840_;
		const gchar* _tmp841_;
		ValaInvalidType* _tmp842_;
		ValaInvalidType* _tmp843_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp780_ = g_strdup ("(null)");
		base_type_name = _tmp780_;
		base_type = NULL;
		_tmp782_ = vala_member_access_get_inner (self);
		_tmp783_ = _tmp782_;
		if (_tmp783_ != NULL) {
			ValaExpression* _tmp784_;
			ValaExpression* _tmp785_;
			ValaDataType* _tmp786_;
			ValaDataType* _tmp787_;
			_tmp784_ = vala_member_access_get_inner (self);
			_tmp785_ = _tmp784_;
			_tmp786_ = vala_expression_get_value_type (_tmp785_);
			_tmp787_ = _tmp786_;
			_tmp781_ = _tmp787_ != NULL;
		} else {
			_tmp781_ = FALSE;
		}
		if (_tmp781_) {
			ValaExpression* _tmp788_;
			ValaExpression* _tmp789_;
			ValaDataType* _tmp790_;
			ValaDataType* _tmp791_;
			gchar* _tmp792_;
			ValaExpression* _tmp793_;
			ValaExpression* _tmp794_;
			ValaDataType* _tmp795_;
			ValaDataType* _tmp796_;
			ValaTypeSymbol* _tmp797_;
			ValaTypeSymbol* _tmp798_;
			_tmp788_ = vala_member_access_get_inner (self);
			_tmp789_ = _tmp788_;
			_tmp790_ = vala_expression_get_value_type (_tmp789_);
			_tmp791_ = _tmp790_;
			_tmp792_ = vala_code_node_to_string ((ValaCodeNode*) _tmp791_);
			_g_free0 (base_type_name);
			base_type_name = _tmp792_;
			_tmp793_ = vala_member_access_get_inner (self);
			_tmp794_ = _tmp793_;
			_tmp795_ = vala_expression_get_value_type (_tmp794_);
			_tmp796_ = _tmp795_;
			_tmp797_ = vala_data_type_get_type_symbol (_tmp796_);
			_tmp798_ = _tmp797_;
			base_type = (ValaSymbol*) _tmp798_;
		} else {
			ValaSymbol* _tmp799_;
			_tmp799_ = base_symbol;
			if (_tmp799_ != NULL) {
				ValaSymbol* _tmp800_;
				gchar* _tmp801_;
				ValaSymbol* _tmp802_;
				_tmp800_ = base_symbol;
				_tmp801_ = vala_symbol_get_full_name (_tmp800_);
				_g_free0 (base_type_name);
				base_type_name = _tmp801_;
				_tmp802_ = base_symbol;
				base_type = _tmp802_;
			}
		}
		_tmp803_ = g_strdup ("");
		base_type_package = _tmp803_;
		_tmp805_ = base_type;
		if (_tmp805_ != NULL) {
			ValaSymbol* _tmp806_;
			gboolean _tmp807_;
			gboolean _tmp808_;
			_tmp806_ = base_type;
			_tmp807_ = vala_symbol_get_external_package (_tmp806_);
			_tmp808_ = _tmp807_;
			_tmp804_ = _tmp808_;
		} else {
			_tmp804_ = FALSE;
		}
		if (_tmp804_) {
			ValaSymbol* _tmp809_;
			ValaSourceReference* _tmp810_;
			ValaSourceReference* _tmp811_;
			ValaSourceFile* _tmp812_;
			ValaSourceFile* _tmp813_;
			const gchar* _tmp814_;
			const gchar* _tmp815_;
			gchar* _tmp816_;
			const gchar* _tmp817_;
			_tmp809_ = base_symbol;
			_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp809_);
			_tmp811_ = _tmp810_;
			_tmp812_ = vala_source_reference_get_file (_tmp811_);
			_tmp813_ = _tmp812_;
			_tmp814_ = vala_source_file_get_package_name (_tmp813_);
			_tmp815_ = _tmp814_;
			_tmp816_ = g_strdup (_tmp815_);
			_g_free0 (base_type_package);
			base_type_package = _tmp816_;
			_tmp817_ = base_type_package;
			if (_tmp817_ != NULL) {
				const gchar* _tmp818_;
				gchar* _tmp819_;
				_tmp818_ = base_type_package;
				_tmp819_ = g_strdup_printf (" (%s)", _tmp818_);
				_g_free0 (base_type_package);
				base_type_package = _tmp819_;
			}
		}
		_tmp820_ = g_strdup ("");
		visited_types_string = _tmp820_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp821_;
			gint _type_size = 0;
			ValaArrayList* _tmp822_;
			gint _tmp823_;
			gint _tmp824_;
			gint _type_index = 0;
			_tmp821_ = visited_types;
			_type_list = _tmp821_;
			_tmp822_ = _type_list;
			_tmp823_ = vala_collection_get_size ((ValaCollection*) _tmp822_);
			_tmp824_ = _tmp823_;
			_type_size = _tmp824_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp825_;
				gint _tmp826_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp827_;
				gpointer _tmp828_;
				const gchar* _tmp829_;
				ValaDataType* _tmp830_;
				gchar* _tmp831_;
				gchar* _tmp832_;
				gchar* _tmp833_;
				gchar* _tmp834_;
				gchar* _tmp835_;
				_type_index = _type_index + 1;
				_tmp825_ = _type_index;
				_tmp826_ = _type_size;
				if (!(_tmp825_ < _tmp826_)) {
					break;
				}
				_tmp827_ = _type_list;
				_tmp828_ = vala_list_get ((ValaList*) _tmp827_, _type_index);
				type = (ValaDataType*) _tmp828_;
				_tmp829_ = visited_types_string;
				_tmp830_ = type;
				_tmp831_ = vala_code_node_to_string ((ValaCodeNode*) _tmp830_);
				_tmp832_ = _tmp831_;
				_tmp833_ = g_strdup_printf (" or `%s'", _tmp832_);
				_tmp834_ = _tmp833_;
				_tmp835_ = g_strconcat (_tmp829_, _tmp834_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp835_;
				_g_free0 (_tmp834_);
				_g_free0 (_tmp832_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp836_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp837_ = _tmp836_;
		_tmp838_ = self->priv->_member_name;
		_tmp839_ = base_type_name;
		_tmp840_ = base_type_package;
		_tmp841_ = visited_types_string;
		vala_report_error (_tmp837_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp838_, _tmp839_, _tmp840_, _tmp841_);
		_tmp842_ = vala_invalid_type_new ();
		_tmp843_ = _tmp842_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp843_);
		_vala_code_node_unref0 (_tmp843_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp844_;
		ValaSymbol* _tmp845_;
		gboolean _tmp846_;
		gboolean _tmp847_;
		_tmp844_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp845_ = _tmp844_;
		_tmp846_ = vala_code_node_get_error ((ValaCodeNode*) _tmp845_);
		_tmp847_ = _tmp846_;
		if (_tmp847_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp848_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp849_ = _tmp848_;
	if (VALA_IS_SIGNAL (_tmp849_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp850_;
		ValaSymbol* _tmp851_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp858_;
		ValaCodeNode* _tmp859_;
		ValaCodeNode* _tmp860_;
		gboolean _tmp861_ = FALSE;
		gboolean _tmp862_ = FALSE;
		gboolean _tmp863_ = FALSE;
		ValaCodeNode* _tmp864_;
		_tmp850_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp851_ = _tmp850_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp851_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp852_;
			ValaCodeNode* _tmp853_;
			ValaCodeNode* _tmp854_;
			ValaCodeNode* _tmp855_;
			ValaCodeNode* _tmp856_;
			ValaCodeNode* _tmp857_;
			_tmp852_ = ma;
			_tmp853_ = vala_code_node_get_parent_node (_tmp852_);
			_tmp854_ = _tmp853_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp854_)) {
				break;
			}
			_tmp855_ = ma;
			_tmp856_ = vala_code_node_get_parent_node (_tmp855_);
			_tmp857_ = _tmp856_;
			ma = _tmp857_;
		}
		_tmp858_ = ma;
		_tmp859_ = vala_code_node_get_parent_node (_tmp858_);
		_tmp860_ = _tmp859_;
		parent = _tmp860_;
		_tmp864_ = parent;
		if (_tmp864_ != NULL) {
			ValaCodeNode* _tmp865_;
			_tmp865_ = parent;
			_tmp863_ = !VALA_IS_ELEMENT_ACCESS (_tmp865_);
		} else {
			_tmp863_ = FALSE;
		}
		if (_tmp863_) {
			ValaCodeNode* _tmp866_;
			ValaExpression* _tmp867_;
			ValaExpression* _tmp868_;
			_tmp866_ = ma;
			_tmp867_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp866_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp868_ = _tmp867_;
			_tmp862_ = !VALA_IS_BASE_ACCESS (_tmp868_);
		} else {
			_tmp862_ = FALSE;
		}
		if (_tmp862_) {
			gboolean _tmp869_ = FALSE;
			ValaCodeNode* _tmp870_;
			_tmp870_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp870_)) {
				_tmp869_ = TRUE;
			} else {
				ValaCodeNode* _tmp871_;
				ValaList* _tmp872_;
				_tmp871_ = parent;
				_tmp872_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp871_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp869_ = vala_collection_contains ((ValaCollection*) _tmp872_, (ValaExpression*) self);
			}
			_tmp861_ = _tmp869_;
		} else {
			_tmp861_ = FALSE;
		}
		if (_tmp861_) {
			ValaSignal* _tmp873_;
			ValaAttribute* _tmp874_;
			_tmp873_ = sig;
			_tmp874_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp873_, "HasEmitter");
			if (_tmp874_ != NULL) {
				ValaSignal* _tmp875_;
				ValaSignal* _tmp876_;
				ValaMethod* _tmp877_;
				ValaMethod* _tmp878_;
				_tmp875_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp875_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp876_ = sig;
				_tmp877_ = vala_signal_get_emitter (_tmp876_);
				_tmp878_ = _tmp877_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp878_);
			} else {
				ValaSourceReference* _tmp879_;
				ValaSourceReference* _tmp880_;
				ValaSymbol* _tmp881_;
				ValaSymbol* _tmp882_;
				gchar* _tmp883_;
				gchar* _tmp884_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp879_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp880_ = _tmp879_;
				_tmp881_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp882_ = _tmp881_;
				_tmp883_ = vala_symbol_get_full_name (_tmp882_);
				_tmp884_ = _tmp883_;
				vala_report_error (_tmp880_, "Signal `%s' requires emitter in this context", _tmp884_);
				_g_free0 (_tmp884_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp885_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp886_ = _tmp885_;
	member = _tmp886_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp887_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp887_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp888_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp888_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp889_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp890_;
		ValaSymbol* _tmp891_;
		ValaSymbol* _tmp892_;
		gboolean _tmp893_ = FALSE;
		ValaBlock* _tmp894_;
		_tmp889_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp889_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp890_ = local;
		_tmp891_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp890_);
		_tmp892_ = _tmp891_;
		block = VALA_IS_BLOCK (_tmp892_) ? ((ValaBlock*) _tmp892_) : NULL;
		_tmp894_ = block;
		if (_tmp894_ != NULL) {
			ValaBlock* _tmp895_;
			ValaSymbol* _tmp896_;
			ValaSemanticAnalyzer* _tmp897_;
			ValaSemanticAnalyzer* _tmp898_;
			ValaSymbol* _tmp899_;
			ValaSymbol* _tmp900_;
			_tmp895_ = block;
			_tmp896_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp895_);
			_tmp897_ = vala_code_context_get_analyzer (context);
			_tmp898_ = _tmp897_;
			_tmp899_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp898_);
			_tmp900_ = _tmp899_;
			_tmp893_ = _tmp896_ != _tmp900_;
		} else {
			_tmp893_ = FALSE;
		}
		if (_tmp893_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp901_;
			ValaSemanticAnalyzer* _tmp902_;
			ValaSymbol* _tmp903_;
			ValaSymbol* _tmp904_;
			ValaLocalVariable* _tmp915_;
			ValaBlock* _tmp916_;
			ValaLocalVariable* _tmp917_;
			ValaDataType* _tmp918_;
			ValaDataType* _tmp919_;
			ValaTypeSymbol* _tmp920_;
			ValaTypeSymbol* _tmp921_;
			ValaSemanticAnalyzer* _tmp922_;
			ValaSemanticAnalyzer* _tmp923_;
			ValaDataType* _tmp924_;
			ValaTypeSymbol* _tmp925_;
			ValaTypeSymbol* _tmp926_;
			_tmp901_ = vala_code_context_get_analyzer (context);
			_tmp902_ = _tmp901_;
			_tmp903_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp902_);
			_tmp904_ = _tmp903_;
			sym = _tmp904_;
			while (TRUE) {
				ValaSymbol* _tmp905_;
				ValaBlock* _tmp906_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp907_;
				ValaMethod* _tmp908_;
				ValaSymbol* _tmp912_;
				ValaSymbol* _tmp913_;
				ValaSymbol* _tmp914_;
				_tmp905_ = sym;
				_tmp906_ = block;
				if (!(_tmp905_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp906_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp907_ = sym;
				method = VALA_IS_METHOD (_tmp907_) ? ((ValaMethod*) _tmp907_) : NULL;
				_tmp908_ = method;
				if (_tmp908_ != NULL) {
					ValaMethod* _tmp909_;
					ValaMethod* _tmp910_;
					ValaLocalVariable* _tmp911_;
					_tmp909_ = method;
					vala_method_set_closure (_tmp909_, TRUE);
					_tmp910_ = method;
					_tmp911_ = local;
					vala_method_add_captured_variable (_tmp910_, _tmp911_);
				}
				_tmp912_ = sym;
				_tmp913_ = vala_symbol_get_parent_symbol (_tmp912_);
				_tmp914_ = _tmp913_;
				sym = _tmp914_;
			}
			_tmp915_ = local;
			vala_local_variable_set_captured (_tmp915_, TRUE);
			_tmp916_ = block;
			vala_block_set_captured (_tmp916_, TRUE);
			_tmp917_ = local;
			_tmp918_ = vala_variable_get_variable_type ((ValaVariable*) _tmp917_);
			_tmp919_ = _tmp918_;
			_tmp920_ = vala_data_type_get_type_symbol (_tmp919_);
			_tmp921_ = _tmp920_;
			_tmp922_ = vala_code_context_get_analyzer (context);
			_tmp923_ = _tmp922_;
			_tmp924_ = _tmp923_->va_list_type;
			_tmp925_ = vala_data_type_get_type_symbol (_tmp924_);
			_tmp926_ = _tmp925_;
			if (_tmp921_ == _tmp926_) {
				ValaSourceReference* _tmp927_;
				ValaSourceReference* _tmp928_;
				ValaLocalVariable* _tmp929_;
				gchar* _tmp930_;
				gchar* _tmp931_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp927_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp928_ = _tmp927_;
				_tmp929_ = local;
				_tmp930_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp929_);
				_tmp931_ = _tmp930_;
				vala_report_error (_tmp928_, "Capturing `va_list' variable `%s' is not allowed", _tmp931_);
				_g_free0 (_tmp931_);
			}
		}
	} else {
		ValaSymbol* _tmp932_;
		_tmp932_ = member;
		if (VALA_IS_PARAMETER (_tmp932_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp933_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp934_;
			ValaSymbol* _tmp935_;
			ValaSymbol* _tmp936_;
			gboolean _tmp937_ = FALSE;
			gboolean _tmp938_ = FALSE;
			ValaMethod* _tmp939_;
			_tmp933_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp933_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp934_ = param;
			_tmp935_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp934_);
			_tmp936_ = _tmp935_;
			m = VALA_IS_METHOD (_tmp936_) ? ((ValaMethod*) _tmp936_) : NULL;
			_tmp939_ = m;
			if (_tmp939_ != NULL) {
				ValaMethod* _tmp940_;
				ValaSemanticAnalyzer* _tmp941_;
				ValaSemanticAnalyzer* _tmp942_;
				ValaSymbol* _tmp943_;
				ValaSymbol* _tmp944_;
				_tmp940_ = m;
				_tmp941_ = vala_code_context_get_analyzer (context);
				_tmp942_ = _tmp941_;
				_tmp943_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp942_);
				_tmp944_ = _tmp943_;
				_tmp938_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp940_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp944_;
			} else {
				_tmp938_ = FALSE;
			}
			if (_tmp938_) {
				ValaParameter* _tmp945_;
				ValaMethod* _tmp946_;
				ValaParameter* _tmp947_;
				ValaParameter* _tmp948_;
				_tmp945_ = param;
				_tmp946_ = m;
				_tmp947_ = vala_method_get_this_parameter (_tmp946_);
				_tmp948_ = _tmp947_;
				_tmp937_ = _tmp945_ != _tmp948_;
			} else {
				_tmp937_ = FALSE;
			}
			if (_tmp937_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp949_;
				ValaSemanticAnalyzer* _tmp950_;
				ValaSymbol* _tmp951_;
				ValaSymbol* _tmp952_;
				ValaParameter* _tmp961_;
				ValaMethod* _tmp962_;
				ValaBlock* _tmp963_;
				ValaBlock* _tmp964_;
				ValaParameter* _tmp965_;
				ValaParameterDirection _tmp966_;
				ValaParameterDirection _tmp967_;
				ValaParameter* _tmp973_;
				ValaDataType* _tmp974_;
				ValaDataType* _tmp975_;
				ValaTypeSymbol* _tmp976_;
				ValaTypeSymbol* _tmp977_;
				ValaSemanticAnalyzer* _tmp978_;
				ValaSemanticAnalyzer* _tmp979_;
				ValaDataType* _tmp980_;
				ValaTypeSymbol* _tmp981_;
				ValaTypeSymbol* _tmp982_;
				_tmp949_ = vala_code_context_get_analyzer (context);
				_tmp950_ = _tmp949_;
				_tmp951_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp950_);
				_tmp952_ = _tmp951_;
				sym = _tmp952_;
				while (TRUE) {
					ValaSymbol* _tmp953_;
					ValaMethod* _tmp954_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp955_;
					ValaMethod* _tmp956_;
					ValaSymbol* _tmp958_;
					ValaSymbol* _tmp959_;
					ValaSymbol* _tmp960_;
					_tmp953_ = sym;
					_tmp954_ = m;
					if (!(_tmp953_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp954_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp955_ = sym;
					method = VALA_IS_METHOD (_tmp955_) ? ((ValaMethod*) _tmp955_) : NULL;
					_tmp956_ = method;
					if (_tmp956_ != NULL) {
						ValaMethod* _tmp957_;
						_tmp957_ = method;
						vala_method_set_closure (_tmp957_, TRUE);
					}
					_tmp958_ = sym;
					_tmp959_ = vala_symbol_get_parent_symbol (_tmp958_);
					_tmp960_ = _tmp959_;
					sym = _tmp960_;
				}
				_tmp961_ = param;
				vala_parameter_set_captured (_tmp961_, TRUE);
				_tmp962_ = m;
				_tmp963_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp962_);
				_tmp964_ = _tmp963_;
				vala_block_set_captured (_tmp964_, TRUE);
				_tmp965_ = param;
				_tmp966_ = vala_parameter_get_direction (_tmp965_);
				_tmp967_ = _tmp966_;
				if (_tmp967_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp968_;
					ValaSourceReference* _tmp969_;
					ValaParameter* _tmp970_;
					gchar* _tmp971_;
					gchar* _tmp972_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp968_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp969_ = _tmp968_;
					_tmp970_ = param;
					_tmp971_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp970_);
					_tmp972_ = _tmp971_;
					vala_report_error (_tmp969_, "Cannot capture reference or output parameter `%s'", _tmp972_);
					_g_free0 (_tmp972_);
				}
				_tmp973_ = param;
				_tmp974_ = vala_variable_get_variable_type ((ValaVariable*) _tmp973_);
				_tmp975_ = _tmp974_;
				_tmp976_ = vala_data_type_get_type_symbol (_tmp975_);
				_tmp977_ = _tmp976_;
				_tmp978_ = vala_code_context_get_analyzer (context);
				_tmp979_ = _tmp978_;
				_tmp980_ = _tmp979_->va_list_type;
				_tmp981_ = vala_data_type_get_type_symbol (_tmp980_);
				_tmp982_ = _tmp981_;
				if (_tmp977_ == _tmp982_) {
					ValaSourceReference* _tmp983_;
					ValaSourceReference* _tmp984_;
					ValaParameter* _tmp985_;
					gchar* _tmp986_;
					gchar* _tmp987_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp983_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp984_ = _tmp983_;
					_tmp985_ = param;
					_tmp986_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp985_);
					_tmp987_ = _tmp986_;
					vala_report_error (_tmp984_, "Capturing `va_list' parameter `%s' is not allowed", _tmp987_);
					_g_free0 (_tmp987_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp988_;
				ValaSymbol* _tmp989_;
				ValaSymbol* _tmp990_;
				ValaSymbol* _tmp991_;
				ValaSymbol* _tmp992_;
				gboolean _tmp993_ = FALSE;
				gboolean _tmp994_ = FALSE;
				ValaPropertyAccessor* _tmp995_;
				_tmp988_ = param;
				_tmp989_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp988_);
				_tmp990_ = _tmp989_;
				_tmp991_ = vala_symbol_get_parent_symbol (_tmp990_);
				_tmp992_ = _tmp991_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp992_) ? ((ValaPropertyAccessor*) _tmp992_) : NULL;
				_tmp995_ = acc;
				if (_tmp995_ != NULL) {
					ValaPropertyAccessor* _tmp996_;
					ValaSemanticAnalyzer* _tmp997_;
					ValaSemanticAnalyzer* _tmp998_;
					ValaSymbol* _tmp999_;
					ValaSymbol* _tmp1000_;
					_tmp996_ = acc;
					_tmp997_ = vala_code_context_get_analyzer (context);
					_tmp998_ = _tmp997_;
					_tmp999_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp998_);
					_tmp1000_ = _tmp999_;
					_tmp994_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp996_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp1000_;
				} else {
					_tmp994_ = FALSE;
				}
				if (_tmp994_) {
					ValaParameter* _tmp1001_;
					ValaPropertyAccessor* _tmp1002_;
					ValaProperty* _tmp1003_;
					ValaProperty* _tmp1004_;
					ValaParameter* _tmp1005_;
					ValaParameter* _tmp1006_;
					_tmp1001_ = param;
					_tmp1002_ = acc;
					_tmp1003_ = vala_property_accessor_get_prop (_tmp1002_);
					_tmp1004_ = _tmp1003_;
					_tmp1005_ = vala_property_get_this_parameter (_tmp1004_);
					_tmp1006_ = _tmp1005_;
					_tmp993_ = _tmp1001_ != _tmp1006_;
				} else {
					_tmp993_ = FALSE;
				}
				if (_tmp993_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp1007_;
					ValaSemanticAnalyzer* _tmp1008_;
					ValaSymbol* _tmp1009_;
					ValaSymbol* _tmp1010_;
					ValaParameter* _tmp1019_;
					ValaPropertyAccessor* _tmp1020_;
					ValaBlock* _tmp1021_;
					ValaBlock* _tmp1022_;
					_tmp1007_ = vala_code_context_get_analyzer (context);
					_tmp1008_ = _tmp1007_;
					_tmp1009_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1008_);
					_tmp1010_ = _tmp1009_;
					sym = _tmp1010_;
					while (TRUE) {
						ValaSymbol* _tmp1011_;
						ValaMethod* _tmp1012_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp1013_;
						ValaMethod* _tmp1014_;
						ValaSymbol* _tmp1016_;
						ValaSymbol* _tmp1017_;
						ValaSymbol* _tmp1018_;
						_tmp1011_ = sym;
						_tmp1012_ = m;
						if (!(_tmp1011_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1012_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp1013_ = sym;
						method = VALA_IS_METHOD (_tmp1013_) ? ((ValaMethod*) _tmp1013_) : NULL;
						_tmp1014_ = method;
						if (_tmp1014_ != NULL) {
							ValaMethod* _tmp1015_;
							_tmp1015_ = method;
							vala_method_set_closure (_tmp1015_, TRUE);
						}
						_tmp1016_ = sym;
						_tmp1017_ = vala_symbol_get_parent_symbol (_tmp1016_);
						_tmp1018_ = _tmp1017_;
						sym = _tmp1018_;
					}
					_tmp1019_ = param;
					vala_parameter_set_captured (_tmp1019_, TRUE);
					_tmp1020_ = acc;
					_tmp1021_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1020_);
					_tmp1022_ = _tmp1021_;
					vala_block_set_captured (_tmp1022_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp1023_;
			_tmp1023_ = member;
			if (VALA_IS_FIELD (_tmp1023_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp1024_;
				ValaField* _tmp1025_;
				ValaSymbolAccessibility _tmp1026_;
				ValaSymbolAccessibility _tmp1027_;
				ValaField* _tmp1028_;
				ValaMemberBinding _tmp1029_;
				ValaMemberBinding _tmp1030_;
				ValaField* _tmp1031_;
				ValaMemberBinding _tmp1032_;
				ValaMemberBinding _tmp1033_;
				ValaField* _tmp1034_;
				ValaDataType* _tmp1035_;
				ValaDataType* _tmp1036_;
				_tmp1024_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp1024_, VALA_TYPE_FIELD, ValaField);
				_tmp1025_ = f;
				_tmp1026_ = vala_symbol_get_access ((ValaSymbol*) _tmp1025_);
				_tmp1027_ = _tmp1026_;
				access = _tmp1027_;
				_tmp1028_ = f;
				_tmp1029_ = vala_field_get_binding (_tmp1028_);
				_tmp1030_ = _tmp1029_;
				instance = _tmp1030_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp1031_ = f;
				_tmp1032_ = vala_field_get_binding (_tmp1031_);
				_tmp1033_ = _tmp1032_;
				klass = _tmp1033_ == VALA_MEMBER_BINDING_CLASS;
				_tmp1034_ = f;
				_tmp1035_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1034_);
				_tmp1036_ = _tmp1035_;
				if (VALA_IS_GENERIC_TYPE (_tmp1036_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp1037_;
				_tmp1037_ = member;
				if (VALA_IS_CONSTANT (_tmp1037_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp1038_;
					ValaConstant* _tmp1039_;
					ValaSymbolAccessibility _tmp1040_;
					ValaSymbolAccessibility _tmp1041_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp1042_;
					ValaSymbol* _tmp1043_;
					ValaSymbol* _tmp1044_;
					gboolean _tmp1045_ = FALSE;
					ValaBlock* _tmp1046_;
					_tmp1038_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp1038_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp1039_ = c;
					_tmp1040_ = vala_symbol_get_access ((ValaSymbol*) _tmp1039_);
					_tmp1041_ = _tmp1040_;
					access = _tmp1041_;
					_tmp1042_ = c;
					_tmp1043_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1042_);
					_tmp1044_ = _tmp1043_;
					block = VALA_IS_BLOCK (_tmp1044_) ? ((ValaBlock*) _tmp1044_) : NULL;
					_tmp1046_ = block;
					if (_tmp1046_ != NULL) {
						ValaBlock* _tmp1047_;
						ValaSymbol* _tmp1048_;
						ValaSemanticAnalyzer* _tmp1049_;
						ValaSemanticAnalyzer* _tmp1050_;
						ValaSymbol* _tmp1051_;
						ValaSymbol* _tmp1052_;
						_tmp1047_ = block;
						_tmp1048_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp1047_);
						_tmp1049_ = vala_code_context_get_analyzer (context);
						_tmp1050_ = _tmp1049_;
						_tmp1051_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1050_);
						_tmp1052_ = _tmp1051_;
						_tmp1045_ = _tmp1048_ != _tmp1052_;
					} else {
						_tmp1045_ = FALSE;
					}
					if (_tmp1045_) {
						ValaSourceReference* _tmp1053_;
						ValaSourceReference* _tmp1054_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1053_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1054_ = _tmp1053_;
						vala_report_error (_tmp1054_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp1055_;
					_tmp1055_ = member;
					if (VALA_IS_METHOD (_tmp1055_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp1056_;
						ValaMethod* _tmp1057_;
						gboolean _tmp1058_;
						gboolean _tmp1059_;
						ValaMethod* _tmp1146_;
						ValaSymbolAccessibility _tmp1147_;
						ValaSymbolAccessibility _tmp1148_;
						ValaMethod* _tmp1149_;
						ValaMethod* _tmp1153_;
						ValaMemberBinding _tmp1154_;
						ValaMemberBinding _tmp1155_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1175_;
						ValaDataType* _tmp1176_;
						ValaDataType* _tmp1177_;
						gboolean _tmp1178_ = FALSE;
						ValaGenericType* _tmp1179_;
						_tmp1056_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp1056_, VALA_TYPE_METHOD, ValaMethod);
						_tmp1057_ = m;
						_tmp1058_ = vala_method_get_is_async_callback (_tmp1057_);
						_tmp1059_ = _tmp1058_;
						if (_tmp1059_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp1060_;
							ValaSemanticAnalyzer* _tmp1061_;
							ValaMethod* _tmp1062_;
							ValaMethod* _tmp1063_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp1064_;
							ValaMethod* _tmp1091_;
							ValaSemanticAnalyzer* _tmp1092_;
							ValaSemanticAnalyzer* _tmp1093_;
							ValaMethod* _tmp1094_;
							ValaMethod* _tmp1095_;
							ValaMethod* _tmp1111_;
							ValaMethod* _tmp1112_;
							ValaMethod* _tmp1113_;
							ValaSymbol* _tmp1114_;
							ValaSymbol* _tmp1115_;
							_tmp1060_ = vala_code_context_get_analyzer (context);
							_tmp1061_ = _tmp1060_;
							_tmp1062_ = vala_semantic_analyzer_get_current_async_method (_tmp1061_);
							_tmp1063_ = _tmp1062_;
							async_method = _tmp1063_;
							is_valid_access = FALSE;
							_tmp1064_ = async_method;
							if (_tmp1064_ != NULL) {
								ValaMethod* _tmp1065_;
								ValaMethod* _tmp1066_;
								ValaMethod* _tmp1067_;
								_tmp1065_ = m;
								_tmp1066_ = async_method;
								_tmp1067_ = vala_method_get_callback_method (_tmp1066_);
								if (_tmp1065_ == _tmp1067_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp1068_ = FALSE;
									ValaMethod* _tmp1069_;
									ValaMethod* _tmp1070_;
									ValaMethod* _tmp1071_;
									_tmp1069_ = async_method;
									_tmp1070_ = vala_method_get_base_method (_tmp1069_);
									_tmp1071_ = _tmp1070_;
									if (_tmp1071_ != NULL) {
										ValaMethod* _tmp1072_;
										ValaMethod* _tmp1073_;
										ValaMethod* _tmp1074_;
										ValaMethod* _tmp1075_;
										ValaMethod* _tmp1076_;
										_tmp1072_ = m;
										_tmp1073_ = async_method;
										_tmp1074_ = vala_method_get_base_method (_tmp1073_);
										_tmp1075_ = _tmp1074_;
										_tmp1076_ = vala_method_get_callback_method (_tmp1075_);
										_tmp1068_ = _tmp1072_ == _tmp1076_;
									} else {
										_tmp1068_ = FALSE;
									}
									if (_tmp1068_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1077_ = FALSE;
										ValaMethod* _tmp1078_;
										ValaMethod* _tmp1079_;
										ValaMethod* _tmp1080_;
										_tmp1078_ = async_method;
										_tmp1079_ = vala_method_get_base_interface_method (_tmp1078_);
										_tmp1080_ = _tmp1079_;
										if (_tmp1080_ != NULL) {
											ValaMethod* _tmp1081_;
											ValaMethod* _tmp1082_;
											ValaMethod* _tmp1083_;
											ValaMethod* _tmp1084_;
											ValaMethod* _tmp1085_;
											_tmp1081_ = m;
											_tmp1082_ = async_method;
											_tmp1083_ = vala_method_get_base_interface_method (_tmp1082_);
											_tmp1084_ = _tmp1083_;
											_tmp1085_ = vala_method_get_callback_method (_tmp1084_);
											_tmp1077_ = _tmp1081_ == _tmp1085_;
										} else {
											_tmp1077_ = FALSE;
										}
										if (_tmp1077_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1086_;
								ValaSourceReference* _tmp1087_;
								ValaMethod* _tmp1088_;
								gchar* _tmp1089_;
								gchar* _tmp1090_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1086_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1087_ = _tmp1086_;
								_tmp1088_ = m;
								_tmp1089_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1088_);
								_tmp1090_ = _tmp1089_;
								vala_report_error (_tmp1087_, "Access to async callback `%s' not allowed in this context", _tmp1090_);
								_g_free0 (_tmp1090_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1091_ = async_method;
							_tmp1092_ = vala_code_context_get_analyzer (context);
							_tmp1093_ = _tmp1092_;
							_tmp1094_ = vala_semantic_analyzer_get_current_method (_tmp1093_);
							_tmp1095_ = _tmp1094_;
							if (_tmp1091_ != _tmp1095_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1096_;
								ValaSemanticAnalyzer* _tmp1097_;
								ValaMethod* _tmp1098_;
								ValaMethod* _tmp1099_;
								ValaMethod* _tmp1108_;
								ValaBlock* _tmp1109_;
								ValaBlock* _tmp1110_;
								_tmp1096_ = vala_code_context_get_analyzer (context);
								_tmp1097_ = _tmp1096_;
								_tmp1098_ = vala_semantic_analyzer_get_current_method (_tmp1097_);
								_tmp1099_ = _tmp1098_;
								sym = (ValaSymbol*) _tmp1099_;
								while (TRUE) {
									ValaSymbol* _tmp1100_;
									ValaMethod* _tmp1101_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1102_;
									ValaMethod* _tmp1103_;
									ValaSymbol* _tmp1105_;
									ValaSymbol* _tmp1106_;
									ValaSymbol* _tmp1107_;
									_tmp1100_ = sym;
									_tmp1101_ = async_method;
									if (!(_tmp1100_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1101_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1102_ = sym;
									method = VALA_IS_METHOD (_tmp1102_) ? ((ValaMethod*) _tmp1102_) : NULL;
									_tmp1103_ = method;
									if (_tmp1103_ != NULL) {
										ValaMethod* _tmp1104_;
										_tmp1104_ = method;
										vala_method_set_closure (_tmp1104_, TRUE);
									}
									_tmp1105_ = sym;
									_tmp1106_ = vala_symbol_get_parent_symbol (_tmp1105_);
									_tmp1107_ = _tmp1106_;
									sym = _tmp1107_;
								}
								_tmp1108_ = async_method;
								_tmp1109_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1108_);
								_tmp1110_ = _tmp1109_;
								vala_block_set_captured (_tmp1110_, TRUE);
							}
							_tmp1111_ = async_method;
							_tmp1112_ = vala_method_get_callback_method (_tmp1111_);
							m = _tmp1112_;
							_tmp1113_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1113_);
							_tmp1114_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1115_ = _tmp1114_;
							member = _tmp1115_;
						} else {
							ValaMethod* _tmp1116_;
							ValaMethod* _tmp1117_;
							ValaMethod* _tmp1118_;
							_tmp1116_ = m;
							_tmp1117_ = vala_method_get_base_method (_tmp1116_);
							_tmp1118_ = _tmp1117_;
							if (_tmp1118_ != NULL) {
								ValaMethod* _tmp1119_;
								ValaMethod* _tmp1120_;
								ValaMethod* _tmp1121_;
								ValaMethod* _tmp1122_;
								ValaSignal* _tmp1123_;
								ValaSignal* _tmp1124_;
								ValaSymbol* _tmp1129_;
								ValaSymbol* _tmp1130_;
								_tmp1119_ = m;
								_tmp1120_ = vala_method_get_base_method (_tmp1119_);
								_tmp1121_ = _tmp1120_;
								m = _tmp1121_;
								_tmp1122_ = m;
								_tmp1123_ = vala_method_get_signal_reference (_tmp1122_);
								_tmp1124_ = _tmp1123_;
								if (_tmp1124_ != NULL) {
									ValaMethod* _tmp1125_;
									ValaSignal* _tmp1126_;
									ValaSignal* _tmp1127_;
									_tmp1125_ = m;
									_tmp1126_ = vala_method_get_signal_reference (_tmp1125_);
									_tmp1127_ = _tmp1126_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1127_);
								} else {
									ValaMethod* _tmp1128_;
									_tmp1128_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1128_);
								}
								_tmp1129_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1130_ = _tmp1129_;
								member = _tmp1130_;
							} else {
								ValaMethod* _tmp1131_;
								ValaMethod* _tmp1132_;
								ValaMethod* _tmp1133_;
								_tmp1131_ = m;
								_tmp1132_ = vala_method_get_base_interface_method (_tmp1131_);
								_tmp1133_ = _tmp1132_;
								if (_tmp1133_ != NULL) {
									ValaMethod* _tmp1134_;
									ValaMethod* _tmp1135_;
									ValaMethod* _tmp1136_;
									ValaMethod* _tmp1137_;
									ValaSignal* _tmp1138_;
									ValaSignal* _tmp1139_;
									ValaSymbol* _tmp1144_;
									ValaSymbol* _tmp1145_;
									_tmp1134_ = m;
									_tmp1135_ = vala_method_get_base_interface_method (_tmp1134_);
									_tmp1136_ = _tmp1135_;
									m = _tmp1136_;
									_tmp1137_ = m;
									_tmp1138_ = vala_method_get_signal_reference (_tmp1137_);
									_tmp1139_ = _tmp1138_;
									if (_tmp1139_ != NULL) {
										ValaMethod* _tmp1140_;
										ValaSignal* _tmp1141_;
										ValaSignal* _tmp1142_;
										_tmp1140_ = m;
										_tmp1141_ = vala_method_get_signal_reference (_tmp1140_);
										_tmp1142_ = _tmp1141_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1142_);
									} else {
										ValaMethod* _tmp1143_;
										_tmp1143_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1143_);
									}
									_tmp1144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1145_ = _tmp1144_;
									member = _tmp1145_;
								}
							}
						}
						_tmp1146_ = m;
						_tmp1147_ = vala_symbol_get_access ((ValaSymbol*) _tmp1146_);
						_tmp1148_ = _tmp1147_;
						access = _tmp1148_;
						_tmp1149_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1149_)) {
							ValaMethod* _tmp1150_;
							ValaMemberBinding _tmp1151_;
							ValaMemberBinding _tmp1152_;
							_tmp1150_ = m;
							_tmp1151_ = vala_method_get_binding (_tmp1150_);
							_tmp1152_ = _tmp1151_;
							instance = _tmp1152_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1153_ = m;
						_tmp1154_ = vala_method_get_binding (_tmp1153_);
						_tmp1155_ = _tmp1154_;
						klass = _tmp1155_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1156_;
							ValaList* _tmp1157_;
							gint _param_size = 0;
							ValaList* _tmp1158_;
							gint _tmp1159_;
							gint _tmp1160_;
							gint _param_index = 0;
							_tmp1156_ = m;
							_tmp1157_ = vala_callable_get_parameters ((ValaCallable*) _tmp1156_);
							_param_list = _tmp1157_;
							_tmp1158_ = _param_list;
							_tmp1159_ = vala_collection_get_size ((ValaCollection*) _tmp1158_);
							_tmp1160_ = _tmp1159_;
							_param_size = _tmp1160_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1161_;
								gint _tmp1162_;
								ValaParameter* param = NULL;
								ValaList* _tmp1163_;
								gpointer _tmp1164_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1165_;
								ValaDataType* _tmp1166_;
								ValaDataType* _tmp1167_;
								gboolean _tmp1168_ = FALSE;
								ValaGenericType* _tmp1169_;
								_param_index = _param_index + 1;
								_tmp1161_ = _param_index;
								_tmp1162_ = _param_size;
								if (!(_tmp1161_ < _tmp1162_)) {
									break;
								}
								_tmp1163_ = _param_list;
								_tmp1164_ = vala_list_get (_tmp1163_, _param_index);
								param = (ValaParameter*) _tmp1164_;
								_tmp1165_ = param;
								_tmp1166_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1165_);
								_tmp1167_ = _tmp1166_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1167_) ? ((ValaGenericType*) _tmp1167_) : NULL;
								_tmp1169_ = generic_type;
								if (_tmp1169_ != NULL) {
									ValaGenericType* _tmp1170_;
									ValaTypeParameter* _tmp1171_;
									ValaTypeParameter* _tmp1172_;
									ValaSymbol* _tmp1173_;
									ValaSymbol* _tmp1174_;
									_tmp1170_ = generic_type;
									_tmp1171_ = vala_generic_type_get_type_parameter (_tmp1170_);
									_tmp1172_ = _tmp1171_;
									_tmp1173_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1172_);
									_tmp1174_ = _tmp1173_;
									_tmp1168_ = VALA_IS_TYPESYMBOL (_tmp1174_);
								} else {
									_tmp1168_ = FALSE;
								}
								if (_tmp1168_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1175_ = m;
						_tmp1176_ = vala_callable_get_return_type ((ValaCallable*) _tmp1175_);
						_tmp1177_ = _tmp1176_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1177_) ? ((ValaGenericType*) _tmp1177_) : NULL;
						_tmp1179_ = generic_type;
						if (_tmp1179_ != NULL) {
							ValaGenericType* _tmp1180_;
							ValaTypeParameter* _tmp1181_;
							ValaTypeParameter* _tmp1182_;
							ValaSymbol* _tmp1183_;
							ValaSymbol* _tmp1184_;
							_tmp1180_ = generic_type;
							_tmp1181_ = vala_generic_type_get_type_parameter (_tmp1180_);
							_tmp1182_ = _tmp1181_;
							_tmp1183_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1182_);
							_tmp1184_ = _tmp1183_;
							_tmp1178_ = VALA_IS_TYPESYMBOL (_tmp1184_);
						} else {
							_tmp1178_ = FALSE;
						}
						if (_tmp1178_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1185_;
						_tmp1185_ = member;
						if (VALA_IS_PROPERTY (_tmp1185_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1186_;
							ValaProperty* _tmp1187_;
							ValaProperty* _tmp1188_;
							ValaProperty* _tmp1189_;
							ValaProperty* _tmp1190_;
							ValaProperty* _tmp1206_;
							ValaSymbolAccessibility _tmp1207_;
							ValaSymbolAccessibility _tmp1208_;
							gboolean _tmp1209_;
							gboolean _tmp1210_;
							ValaProperty* _tmp1309_;
							ValaMemberBinding _tmp1310_;
							ValaMemberBinding _tmp1311_;
							ValaProperty* _tmp1312_;
							ValaDataType* _tmp1313_;
							ValaDataType* _tmp1314_;
							_tmp1186_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1186_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1187_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1187_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1188_ = prop;
							_tmp1189_ = vala_property_get_base_property (_tmp1188_);
							_tmp1190_ = _tmp1189_;
							if (_tmp1190_ != NULL) {
								ValaProperty* _tmp1191_;
								ValaProperty* _tmp1192_;
								ValaProperty* _tmp1193_;
								ValaProperty* _tmp1194_;
								ValaSymbol* _tmp1195_;
								ValaSymbol* _tmp1196_;
								_tmp1191_ = prop;
								_tmp1192_ = vala_property_get_base_property (_tmp1191_);
								_tmp1193_ = _tmp1192_;
								prop = _tmp1193_;
								_tmp1194_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1194_);
								_tmp1195_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1196_ = _tmp1195_;
								member = _tmp1196_;
							} else {
								ValaProperty* _tmp1197_;
								ValaProperty* _tmp1198_;
								ValaProperty* _tmp1199_;
								_tmp1197_ = prop;
								_tmp1198_ = vala_property_get_base_interface_property (_tmp1197_);
								_tmp1199_ = _tmp1198_;
								if (_tmp1199_ != NULL) {
									ValaProperty* _tmp1200_;
									ValaProperty* _tmp1201_;
									ValaProperty* _tmp1202_;
									ValaProperty* _tmp1203_;
									ValaSymbol* _tmp1204_;
									ValaSymbol* _tmp1205_;
									_tmp1200_ = prop;
									_tmp1201_ = vala_property_get_base_interface_property (_tmp1200_);
									_tmp1202_ = _tmp1201_;
									prop = _tmp1202_;
									_tmp1203_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1203_);
									_tmp1204_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1205_ = _tmp1204_;
									member = _tmp1205_;
								}
							}
							_tmp1206_ = prop;
							_tmp1207_ = vala_symbol_get_access ((ValaSymbol*) _tmp1206_);
							_tmp1208_ = _tmp1207_;
							access = _tmp1208_;
							_tmp1209_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1210_ = _tmp1209_;
							if (_tmp1210_) {
								ValaProperty* _tmp1211_;
								ValaPropertyAccessor* _tmp1212_;
								ValaPropertyAccessor* _tmp1213_;
								ValaProperty* _tmp1257_;
								ValaSymbolAccessibility _tmp1258_;
								ValaSymbolAccessibility _tmp1259_;
								_tmp1211_ = prop;
								_tmp1212_ = vala_property_get_set_accessor (_tmp1211_);
								_tmp1213_ = _tmp1212_;
								if (_tmp1213_ == NULL) {
									ValaSourceReference* _tmp1214_;
									ValaSourceReference* _tmp1215_;
									ValaProperty* _tmp1216_;
									gchar* _tmp1217_;
									gchar* _tmp1218_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1215_ = _tmp1214_;
									_tmp1216_ = prop;
									_tmp1217_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1216_);
									_tmp1218_ = _tmp1217_;
									vala_report_error (_tmp1215_, "Property `%s' is read-only", _tmp1218_);
									_g_free0 (_tmp1218_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1219_ = FALSE;
									ValaProperty* _tmp1220_;
									ValaPropertyAccessor* _tmp1221_;
									ValaPropertyAccessor* _tmp1222_;
									gboolean _tmp1223_;
									gboolean _tmp1224_;
									_tmp1220_ = prop;
									_tmp1221_ = vala_property_get_set_accessor (_tmp1220_);
									_tmp1222_ = _tmp1221_;
									_tmp1223_ = vala_property_accessor_get_writable (_tmp1222_);
									_tmp1224_ = _tmp1223_;
									if (!_tmp1224_) {
										ValaProperty* _tmp1225_;
										ValaPropertyAccessor* _tmp1226_;
										ValaPropertyAccessor* _tmp1227_;
										gboolean _tmp1228_;
										gboolean _tmp1229_;
										_tmp1225_ = prop;
										_tmp1226_ = vala_property_get_set_accessor (_tmp1225_);
										_tmp1227_ = _tmp1226_;
										_tmp1228_ = vala_property_accessor_get_construction (_tmp1227_);
										_tmp1229_ = _tmp1228_;
										_tmp1219_ = _tmp1229_;
									} else {
										_tmp1219_ = FALSE;
									}
									if (_tmp1219_) {
										ValaSemanticAnalyzer* _tmp1230_;
										ValaSemanticAnalyzer* _tmp1231_;
										ValaMethod* _tmp1232_;
										_tmp1230_ = vala_code_context_get_analyzer (context);
										_tmp1231_ = _tmp1230_;
										_tmp1232_ = vala_semantic_analyzer_find_current_method (_tmp1231_);
										if (VALA_IS_CREATION_METHOD (_tmp1232_)) {
											ValaSourceReference* _tmp1233_;
											ValaSourceReference* _tmp1234_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1233_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1234_ = _tmp1233_;
											vala_report_error (_tmp1234_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1235_;
											ValaSemanticAnalyzer* _tmp1236_;
											_tmp1235_ = vala_code_context_get_analyzer (context);
											_tmp1236_ = _tmp1235_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1236_)) {
												ValaSemanticAnalyzer* _tmp1237_;
												ValaSemanticAnalyzer* _tmp1238_;
												ValaTypeSymbol* _tmp1239_;
												ValaTypeSymbol* _tmp1240_;
												ValaProperty* _tmp1241_;
												ValaSymbol* _tmp1242_;
												ValaSymbol* _tmp1243_;
												_tmp1237_ = vala_code_context_get_analyzer (context);
												_tmp1238_ = _tmp1237_;
												_tmp1239_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1238_);
												_tmp1240_ = _tmp1239_;
												_tmp1241_ = prop;
												_tmp1242_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1241_);
												_tmp1243_ = _tmp1242_;
												if (!vala_typesymbol_is_subtype_of (_tmp1240_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1243_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1244_;
													ValaSourceReference* _tmp1245_;
													ValaProperty* _tmp1246_;
													gchar* _tmp1247_;
													gchar* _tmp1248_;
													ValaSemanticAnalyzer* _tmp1249_;
													ValaSemanticAnalyzer* _tmp1250_;
													ValaTypeSymbol* _tmp1251_;
													ValaTypeSymbol* _tmp1252_;
													gchar* _tmp1253_;
													gchar* _tmp1254_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1244_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1245_ = _tmp1244_;
													_tmp1246_ = prop;
													_tmp1247_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1246_);
													_tmp1248_ = _tmp1247_;
													_tmp1249_ = vala_code_context_get_analyzer (context);
													_tmp1250_ = _tmp1249_;
													_tmp1251_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1250_);
													_tmp1252_ = _tmp1251_;
													_tmp1253_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1252_);
													_tmp1254_ = _tmp1253_;
													vala_report_error (_tmp1245_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1248_, _tmp1254_);
													_g_free0 (_tmp1254_);
													_g_free0 (_tmp1248_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1255_;
												ValaSourceReference* _tmp1256_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1256_ = _tmp1255_;
												vala_report_error (_tmp1256_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1257_ = prop;
								_tmp1258_ = vala_symbol_get_access ((ValaSymbol*) _tmp1257_);
								_tmp1259_ = _tmp1258_;
								if (_tmp1259_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1260_;
									ValaPropertyAccessor* _tmp1261_;
									ValaPropertyAccessor* _tmp1262_;
									ValaSymbolAccessibility _tmp1263_;
									ValaSymbolAccessibility _tmp1264_;
									_tmp1260_ = prop;
									_tmp1261_ = vala_property_get_set_accessor (_tmp1260_);
									_tmp1262_ = _tmp1261_;
									_tmp1263_ = vala_symbol_get_access ((ValaSymbol*) _tmp1262_);
									_tmp1264_ = _tmp1263_;
									access = _tmp1264_;
								} else {
									gboolean _tmp1265_ = FALSE;
									ValaProperty* _tmp1266_;
									ValaSymbolAccessibility _tmp1267_;
									ValaSymbolAccessibility _tmp1268_;
									_tmp1266_ = prop;
									_tmp1267_ = vala_symbol_get_access ((ValaSymbol*) _tmp1266_);
									_tmp1268_ = _tmp1267_;
									if (_tmp1268_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1269_;
										ValaPropertyAccessor* _tmp1270_;
										ValaPropertyAccessor* _tmp1271_;
										ValaSymbolAccessibility _tmp1272_;
										ValaSymbolAccessibility _tmp1273_;
										_tmp1269_ = prop;
										_tmp1270_ = vala_property_get_set_accessor (_tmp1269_);
										_tmp1271_ = _tmp1270_;
										_tmp1272_ = vala_symbol_get_access ((ValaSymbol*) _tmp1271_);
										_tmp1273_ = _tmp1272_;
										_tmp1265_ = _tmp1273_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1265_ = FALSE;
									}
									if (_tmp1265_) {
										ValaProperty* _tmp1274_;
										ValaPropertyAccessor* _tmp1275_;
										ValaPropertyAccessor* _tmp1276_;
										ValaSymbolAccessibility _tmp1277_;
										ValaSymbolAccessibility _tmp1278_;
										_tmp1274_ = prop;
										_tmp1275_ = vala_property_get_set_accessor (_tmp1274_);
										_tmp1276_ = _tmp1275_;
										_tmp1277_ = vala_symbol_get_access ((ValaSymbol*) _tmp1276_);
										_tmp1278_ = _tmp1277_;
										access = _tmp1278_;
									}
								}
							} else {
								ValaProperty* _tmp1279_;
								ValaPropertyAccessor* _tmp1280_;
								ValaPropertyAccessor* _tmp1281_;
								ValaProperty* _tmp1287_;
								ValaSymbolAccessibility _tmp1288_;
								ValaSymbolAccessibility _tmp1289_;
								_tmp1279_ = prop;
								_tmp1280_ = vala_property_get_get_accessor (_tmp1279_);
								_tmp1281_ = _tmp1280_;
								if (_tmp1281_ == NULL) {
									ValaSourceReference* _tmp1282_;
									ValaSourceReference* _tmp1283_;
									ValaProperty* _tmp1284_;
									gchar* _tmp1285_;
									gchar* _tmp1286_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1282_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1283_ = _tmp1282_;
									_tmp1284_ = prop;
									_tmp1285_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1284_);
									_tmp1286_ = _tmp1285_;
									vala_report_error (_tmp1283_, "Property `%s' is write-only", _tmp1286_);
									_g_free0 (_tmp1286_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1287_ = prop;
								_tmp1288_ = vala_symbol_get_access ((ValaSymbol*) _tmp1287_);
								_tmp1289_ = _tmp1288_;
								if (_tmp1289_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1290_;
									ValaPropertyAccessor* _tmp1291_;
									ValaPropertyAccessor* _tmp1292_;
									ValaSymbolAccessibility _tmp1293_;
									ValaSymbolAccessibility _tmp1294_;
									_tmp1290_ = prop;
									_tmp1291_ = vala_property_get_get_accessor (_tmp1290_);
									_tmp1292_ = _tmp1291_;
									_tmp1293_ = vala_symbol_get_access ((ValaSymbol*) _tmp1292_);
									_tmp1294_ = _tmp1293_;
									access = _tmp1294_;
								} else {
									gboolean _tmp1295_ = FALSE;
									ValaProperty* _tmp1296_;
									ValaSymbolAccessibility _tmp1297_;
									ValaSymbolAccessibility _tmp1298_;
									_tmp1296_ = prop;
									_tmp1297_ = vala_symbol_get_access ((ValaSymbol*) _tmp1296_);
									_tmp1298_ = _tmp1297_;
									if (_tmp1298_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1299_;
										ValaPropertyAccessor* _tmp1300_;
										ValaPropertyAccessor* _tmp1301_;
										ValaSymbolAccessibility _tmp1302_;
										ValaSymbolAccessibility _tmp1303_;
										_tmp1299_ = prop;
										_tmp1300_ = vala_property_get_get_accessor (_tmp1299_);
										_tmp1301_ = _tmp1300_;
										_tmp1302_ = vala_symbol_get_access ((ValaSymbol*) _tmp1301_);
										_tmp1303_ = _tmp1302_;
										_tmp1295_ = _tmp1303_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1295_ = FALSE;
									}
									if (_tmp1295_) {
										ValaProperty* _tmp1304_;
										ValaPropertyAccessor* _tmp1305_;
										ValaPropertyAccessor* _tmp1306_;
										ValaSymbolAccessibility _tmp1307_;
										ValaSymbolAccessibility _tmp1308_;
										_tmp1304_ = prop;
										_tmp1305_ = vala_property_get_get_accessor (_tmp1304_);
										_tmp1306_ = _tmp1305_;
										_tmp1307_ = vala_symbol_get_access ((ValaSymbol*) _tmp1306_);
										_tmp1308_ = _tmp1307_;
										access = _tmp1308_;
									}
								}
							}
							_tmp1309_ = prop;
							_tmp1310_ = vala_property_get_binding (_tmp1309_);
							_tmp1311_ = _tmp1310_;
							instance = _tmp1311_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1312_ = prop;
							_tmp1313_ = vala_property_get_property_type (_tmp1312_);
							_tmp1314_ = _tmp1313_;
							if (VALA_IS_GENERIC_TYPE (_tmp1314_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1315_;
							_tmp1315_ = member;
							if (VALA_IS_SIGNAL (_tmp1315_)) {
								ValaSymbol* _tmp1316_;
								ValaSymbolAccessibility _tmp1317_;
								ValaSymbolAccessibility _tmp1318_;
								instance = TRUE;
								_tmp1316_ = member;
								_tmp1317_ = vala_symbol_get_access (_tmp1316_);
								_tmp1318_ = _tmp1317_;
								access = _tmp1318_;
							} else {
								gboolean _tmp1319_ = FALSE;
								gboolean _tmp1320_;
								_tmp1320_ = self->priv->_creation_member;
								if (!_tmp1320_) {
									ValaSymbol* _tmp1321_;
									_tmp1321_ = member;
									_tmp1319_ = VALA_IS_ERROR_CODE (_tmp1321_);
								} else {
									_tmp1319_ = FALSE;
								}
								if (_tmp1319_) {
									ValaSymbol* _tmp1322_;
									ValaConstant* _tmp1323_;
									ValaConstant* _tmp1324_;
									ValaSymbol* _tmp1325_;
									ValaSymbol* _tmp1326_;
									_tmp1322_ = member;
									_tmp1323_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1322_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1324_ = _tmp1323_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1324_);
									_tmp1325_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1326_ = _tmp1325_;
									member = _tmp1326_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1327_;
		ValaSymbol* _tmp1328_;
		ValaCodeNode* _tmp1329_;
		ValaCodeNode* _tmp1330_;
		ValaCodeNode* _tmp1331_;
		gboolean _tmp1332_ = FALSE;
		ValaCodeNode* _tmp1333_;
		_tmp1327_ = parent;
		_tmp1328_ = member;
		if (!(_tmp1327_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1328_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1329_ = parent;
		_tmp1330_ = vala_code_node_get_parent_node (_tmp1329_);
		_tmp1331_ = _tmp1330_;
		parent = _tmp1331_;
		_tmp1333_ = parent;
		if (_tmp1333_ == NULL) {
			_tmp1332_ = TRUE;
		} else {
			ValaCodeNode* _tmp1334_;
			ValaSymbol* _tmp1335_;
			_tmp1334_ = parent;
			_tmp1335_ = member;
			_tmp1332_ = _tmp1334_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1335_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1332_) {
			break;
		}
	}
	_tmp1336_ = parent;
	_tmp1337_ = member;
	if (_tmp1336_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1337_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1338_;
		_tmp1338_ = member;
		vala_symbol_set_used (_tmp1338_, TRUE);
	}
	_tmp1339_ = member;
	_tmp1340_ = vala_symbol_get_version (_tmp1339_);
	_tmp1341_ = _tmp1340_;
	_tmp1342_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1343_ = _tmp1342_;
	vala_version_attribute_check (_tmp1341_, context, _tmp1343_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1345_;
		ValaSymbol* _tmp1346_;
		ValaSymbol* _tmp1347_;
		_tmp1345_ = member;
		_tmp1346_ = vala_symbol_get_parent_symbol (_tmp1345_);
		_tmp1347_ = _tmp1346_;
		_tmp1344_ = VALA_IS_TYPESYMBOL (_tmp1347_);
	} else {
		_tmp1344_ = FALSE;
	}
	if (_tmp1344_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1348_;
		ValaSymbol* _tmp1349_;
		ValaSymbol* _tmp1350_;
		gboolean in_subtype = FALSE;
		_tmp1348_ = member;
		_tmp1349_ = vala_symbol_get_parent_symbol (_tmp1348_);
		_tmp1350_ = _tmp1349_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1350_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1351_;
			ValaSemanticAnalyzer* _tmp1352_;
			ValaSymbol* _tmp1353_;
			ValaSymbol* _tmp1354_;
			ValaSymbol* _tmp1355_;
			_tmp1351_ = vala_code_context_get_analyzer (context);
			_tmp1352_ = _tmp1351_;
			_tmp1353_ = vala_semantic_analyzer_get_current_symbol (_tmp1352_);
			_tmp1354_ = _tmp1353_;
			_tmp1355_ = _vala_code_node_ref0 (_tmp1354_);
			this_symbol = _tmp1355_;
			{
				gboolean _tmp1356_ = FALSE;
				_tmp1356_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1361_;
					ValaSymbol* _tmp1362_;
					ValaTypeSymbol* _tmp1363_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1364_;
					gboolean _tmp1365_ = FALSE;
					ValaClass* _tmp1366_;
					if (!_tmp1356_) {
						ValaSymbol* _tmp1357_;
						ValaSymbol* _tmp1358_;
						ValaSymbol* _tmp1359_;
						ValaSymbol* _tmp1360_;
						_tmp1357_ = this_symbol;
						_tmp1358_ = vala_symbol_get_parent_symbol (_tmp1357_);
						_tmp1359_ = _tmp1358_;
						_tmp1360_ = _vala_code_node_ref0 (_tmp1359_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1360_;
					}
					_tmp1356_ = FALSE;
					_tmp1361_ = this_symbol;
					if (!(_tmp1361_ != NULL)) {
						break;
					}
					_tmp1362_ = this_symbol;
					_tmp1363_ = target_type;
					if (_tmp1362_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1363_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1364_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1364_) ? ((ValaClass*) _tmp1364_) : NULL;
					_tmp1366_ = cl;
					if (_tmp1366_ != NULL) {
						ValaClass* _tmp1367_;
						ValaTypeSymbol* _tmp1368_;
						_tmp1367_ = cl;
						_tmp1368_ = target_type;
						_tmp1365_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1367_, _tmp1368_);
					} else {
						_tmp1365_ = FALSE;
					}
					if (_tmp1365_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1369_;
			ValaSourceReference* _tmp1370_;
			ValaSymbol* _tmp1371_;
			gchar* _tmp1372_;
			gchar* _tmp1373_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1369_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1370_ = _tmp1369_;
			_tmp1371_ = member;
			_tmp1372_ = vala_symbol_get_full_name (_tmp1371_);
			_tmp1373_ = _tmp1372_;
			vala_report_error (_tmp1370_, "Access to protected member `%s' denied", _tmp1373_);
			_g_free0 (_tmp1373_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1374_;
			ValaSymbol* _tmp1375_;
			ValaSymbol* _tmp1376_;
			gboolean in_target_type = FALSE;
			_tmp1374_ = member;
			_tmp1375_ = vala_symbol_get_parent_symbol (_tmp1374_);
			_tmp1376_ = _tmp1375_;
			target_type = _tmp1376_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1377_;
				ValaSemanticAnalyzer* _tmp1378_;
				ValaSymbol* _tmp1379_;
				ValaSymbol* _tmp1380_;
				ValaSymbol* _tmp1381_;
				_tmp1377_ = vala_code_context_get_analyzer (context);
				_tmp1378_ = _tmp1377_;
				_tmp1379_ = vala_semantic_analyzer_get_current_symbol (_tmp1378_);
				_tmp1380_ = _tmp1379_;
				_tmp1381_ = _vala_code_node_ref0 (_tmp1380_);
				this_symbol = _tmp1381_;
				{
					gboolean _tmp1382_ = FALSE;
					_tmp1382_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1387_;
						ValaSymbol* _tmp1388_;
						ValaSymbol* _tmp1389_;
						if (!_tmp1382_) {
							ValaSymbol* _tmp1383_;
							ValaSymbol* _tmp1384_;
							ValaSymbol* _tmp1385_;
							ValaSymbol* _tmp1386_;
							_tmp1383_ = this_symbol;
							_tmp1384_ = vala_symbol_get_parent_symbol (_tmp1383_);
							_tmp1385_ = _tmp1384_;
							_tmp1386_ = _vala_code_node_ref0 (_tmp1385_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1386_;
						}
						_tmp1382_ = FALSE;
						_tmp1387_ = this_symbol;
						if (!(_tmp1387_ != NULL)) {
							break;
						}
						_tmp1388_ = target_type;
						_tmp1389_ = this_symbol;
						if (_tmp1388_ == _tmp1389_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1390_;
				ValaSourceReference* _tmp1391_;
				ValaSymbol* _tmp1392_;
				gchar* _tmp1393_;
				gchar* _tmp1394_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1390_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1391_ = _tmp1390_;
				_tmp1392_ = member;
				_tmp1393_ = vala_symbol_get_full_name (_tmp1392_);
				_tmp1394_ = _tmp1393_;
				vala_report_error (_tmp1391_, "Access to private member `%s' denied", _tmp1394_);
				_g_free0 (_tmp1394_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1396_;
		ValaExpression* _tmp1397_;
		_tmp1396_ = vala_member_access_get_inner (self);
		_tmp1397_ = _tmp1396_;
		_tmp1395_ = _tmp1397_ != NULL;
	} else {
		_tmp1395_ = FALSE;
	}
	if (_tmp1395_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1398_;
		ValaExpression* _tmp1399_;
		ValaDataType* _tmp1400_;
		ValaDataType* _tmp1401_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1402_;
		ValaExpression* _tmp1403_;
		ValaDataType* _tmp1404_;
		ValaDataType* _tmp1405_;
		ValaPointerType* _tmp1406_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1410_;
		gboolean _tmp1411_ = FALSE;
		gboolean _tmp1412_ = FALSE;
		ValaObjectType* _tmp1413_;
		_tmp1398_ = vala_member_access_get_inner (self);
		_tmp1399_ = _tmp1398_;
		_tmp1400_ = vala_expression_get_value_type (_tmp1399_);
		_tmp1401_ = _tmp1400_;
		instance_type = _tmp1401_;
		_tmp1402_ = vala_member_access_get_inner (self);
		_tmp1403_ = _tmp1402_;
		_tmp1404_ = vala_expression_get_value_type (_tmp1403_);
		_tmp1405_ = _tmp1404_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1405_) ? ((ValaPointerType*) _tmp1405_) : NULL;
		_tmp1406_ = pointer_type;
		if (_tmp1406_ != NULL) {
			ValaPointerType* _tmp1407_;
			ValaDataType* _tmp1408_;
			ValaDataType* _tmp1409_;
			_tmp1407_ = pointer_type;
			_tmp1408_ = vala_pointer_type_get_base_type (_tmp1407_);
			_tmp1409_ = _tmp1408_;
			instance_type = _tmp1409_;
		}
		_tmp1410_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1410_) ? ((ValaObjectType*) _tmp1410_) : NULL;
		_tmp1413_ = object_type;
		if (_tmp1413_ != NULL) {
			ValaObjectType* _tmp1414_;
			ValaObjectTypeSymbol* _tmp1415_;
			ValaObjectTypeSymbol* _tmp1416_;
			_tmp1414_ = object_type;
			_tmp1415_ = vala_object_type_get_object_type_symbol (_tmp1414_);
			_tmp1416_ = _tmp1415_;
			_tmp1412_ = vala_object_type_symbol_has_type_parameters (_tmp1416_);
		} else {
			_tmp1412_ = FALSE;
		}
		if (_tmp1412_) {
			ValaDataType* _tmp1417_;
			_tmp1417_ = instance_type;
			_tmp1411_ = !vala_data_type_has_type_arguments (_tmp1417_);
		} else {
			_tmp1411_ = FALSE;
		}
		if (_tmp1411_) {
			ValaExpression* _tmp1418_;
			ValaExpression* _tmp1419_;
			ValaSourceReference* _tmp1420_;
			ValaSourceReference* _tmp1421_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1418_ = vala_member_access_get_inner (self);
			_tmp1419_ = _tmp1418_;
			_tmp1420_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1419_);
			_tmp1421_ = _tmp1420_;
			vala_report_error (_tmp1421_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1423_ = !may_access_instance_members;
	} else {
		_tmp1423_ = FALSE;
	}
	if (_tmp1423_) {
		_tmp1422_ = TRUE;
	} else {
		gboolean _tmp1424_ = FALSE;
		if (klass) {
			_tmp1424_ = !may_access_klass_members;
		} else {
			_tmp1424_ = FALSE;
		}
		_tmp1422_ = _tmp1424_;
	}
	if (_tmp1422_) {
		ValaSymbol* _tmp1425_;
		ValaSymbol* _tmp1426_;
		ValaDataType* _tmp1457_;
		ValaDataType* _tmp1458_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1425_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1426_ = _tmp1425_;
		if (VALA_IS_METHOD (_tmp1426_)) {
			ValaSemanticAnalyzer* _tmp1427_;
			ValaSemanticAnalyzer* _tmp1428_;
			ValaSymbol* _tmp1429_;
			ValaSymbol* _tmp1430_;
			gboolean _tmp1431_;
			gboolean _tmp1432_;
			ValaDataType* _tmp1433_;
			ValaDataType* _tmp1434_;
			ValaDataType* _tmp1435_;
			ValaDataType* _tmp1436_;
			ValaSourceReference* _tmp1437_;
			ValaSourceReference* _tmp1438_;
			_tmp1427_ = vala_code_context_get_analyzer (context);
			_tmp1428_ = _tmp1427_;
			_tmp1429_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1430_ = _tmp1429_;
			_tmp1431_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1432_ = _tmp1431_;
			_tmp1433_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1428_, _tmp1430_, _tmp1432_);
			_tmp1434_ = _tmp1433_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1434_);
			_vala_code_node_unref0 (_tmp1434_);
			_tmp1435_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1436_ = _tmp1435_;
			_tmp1437_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1438_ = _tmp1437_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1436_, _tmp1438_);
		} else {
			ValaSymbol* _tmp1439_;
			ValaSymbol* _tmp1440_;
			_tmp1439_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1440_ = _tmp1439_;
			if (VALA_IS_FIELD (_tmp1440_)) {
				ValaSymbol* _tmp1441_;
				ValaSymbol* _tmp1442_;
				ValaSourceReference* _tmp1443_;
				ValaSourceReference* _tmp1444_;
				ValaFieldPrototype* _tmp1445_;
				ValaFieldPrototype* _tmp1446_;
				_tmp1441_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1444_ = _tmp1443_;
				_tmp1445_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1442_, VALA_TYPE_FIELD, ValaField), _tmp1444_);
				_tmp1446_ = _tmp1445_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1446_);
				_vala_code_node_unref0 (_tmp1446_);
			} else {
				ValaSymbol* _tmp1447_;
				ValaSymbol* _tmp1448_;
				_tmp1447_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1448_ = _tmp1447_;
				if (VALA_IS_PROPERTY (_tmp1448_)) {
					ValaSymbol* _tmp1449_;
					ValaSymbol* _tmp1450_;
					ValaSourceReference* _tmp1451_;
					ValaSourceReference* _tmp1452_;
					ValaPropertyPrototype* _tmp1453_;
					ValaPropertyPrototype* _tmp1454_;
					_tmp1449_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1450_ = _tmp1449_;
					_tmp1451_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1452_ = _tmp1451_;
					_tmp1453_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1450_, VALA_TYPE_PROPERTY, ValaProperty), _tmp1452_);
					_tmp1454_ = _tmp1453_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1454_);
					_vala_code_node_unref0 (_tmp1454_);
				} else {
					ValaInvalidType* _tmp1455_;
					ValaInvalidType* _tmp1456_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1455_ = vala_invalid_type_new ();
					_tmp1456_ = _tmp1455_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1456_);
					_vala_code_node_unref0 (_tmp1456_);
				}
			}
		}
		_tmp1457_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1458_ = _tmp1457_;
		if (_tmp1458_ != NULL) {
			ValaDataType* _tmp1459_;
			ValaDataType* _tmp1460_;
			ValaDataType* _tmp1461_;
			ValaDataType* _tmp1462_;
			gboolean _tmp1463_;
			gboolean _tmp1464_;
			_tmp1459_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1460_ = _tmp1459_;
			_tmp1461_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1462_ = _tmp1461_;
			_tmp1463_ = vala_data_type_get_value_owned (_tmp1462_);
			_tmp1464_ = _tmp1463_;
			vala_data_type_set_value_owned (_tmp1460_, _tmp1464_);
		}
	} else {
		gboolean _tmp1465_ = FALSE;
		gboolean _tmp1486_ = FALSE;
		gboolean _tmp1487_ = FALSE;
		gboolean _tmp1488_ = FALSE;
		gboolean _tmp1489_ = FALSE;
		gboolean _tmp1530_ = FALSE;
		gboolean _tmp1531_ = FALSE;
		gboolean _tmp1532_ = FALSE;
		gboolean _tmp1533_ = FALSE;
		gboolean _tmp1534_ = FALSE;
		gboolean _tmp1535_;
		gboolean _tmp1536_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1561_;
		ValaSymbol* _tmp1562_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1563_;
		ValaExpression* _tmp1564_;
		gboolean _tmp1565_ = FALSE;
		gboolean _tmp1566_ = FALSE;
		gboolean _tmp1567_ = FALSE;
		gboolean _tmp1568_ = FALSE;
		gboolean _tmp1569_ = FALSE;
		ValaMethod* _tmp1570_;
		ValaSemanticAnalyzer* _tmp1610_;
		ValaSemanticAnalyzer* _tmp1611_;
		ValaSymbol* _tmp1612_;
		ValaSymbol* _tmp1613_;
		gboolean _tmp1614_;
		gboolean _tmp1615_;
		ValaDataType* _tmp1616_;
		ValaDataType* _tmp1617_;
		gboolean _tmp1618_ = FALSE;
		ValaExpression* _tmp1619_;
		ValaExpression* _tmp1620_;
		ValaSymbol* _tmp1633_;
		ValaSymbol* _tmp1634_;
		gboolean _tmp1708_ = FALSE;
		gboolean _tmp1709_ = FALSE;
		ValaExpression* _tmp1710_;
		ValaExpression* _tmp1711_;
		if (instance) {
			ValaExpression* _tmp1466_;
			ValaExpression* _tmp1467_;
			_tmp1466_ = vala_member_access_get_inner (self);
			_tmp1467_ = _tmp1466_;
			_tmp1465_ = _tmp1467_ == NULL;
		} else {
			_tmp1465_ = FALSE;
		}
		if (_tmp1465_) {
			ValaSourceReference* _tmp1468_;
			ValaSourceReference* _tmp1469_;
			ValaMemberAccess* _tmp1470_;
			ValaMemberAccess* _tmp1471_;
			ValaExpression* _tmp1472_;
			ValaExpression* _tmp1473_;
			ValaParameter* _tmp1474_;
			ValaDataType* _tmp1475_;
			ValaDataType* _tmp1476_;
			ValaDataType* _tmp1477_;
			ValaDataType* _tmp1478_;
			ValaExpression* _tmp1479_;
			ValaExpression* _tmp1480_;
			ValaDataType* _tmp1481_;
			ValaDataType* _tmp1482_;
			ValaExpression* _tmp1483_;
			ValaExpression* _tmp1484_;
			ValaParameter* _tmp1485_;
			_tmp1468_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1469_ = _tmp1468_;
			_tmp1470_ = vala_member_access_new (NULL, "this", _tmp1469_);
			_tmp1471_ = _tmp1470_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1471_);
			_vala_code_node_unref0 (_tmp1471_);
			_tmp1472_ = vala_member_access_get_inner (self);
			_tmp1473_ = _tmp1472_;
			_tmp1474_ = this_parameter;
			_tmp1475_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1474_);
			_tmp1476_ = _tmp1475_;
			_tmp1477_ = vala_data_type_copy (_tmp1476_);
			_tmp1478_ = _tmp1477_;
			vala_expression_set_value_type (_tmp1473_, _tmp1478_);
			_vala_code_node_unref0 (_tmp1478_);
			_tmp1479_ = vala_member_access_get_inner (self);
			_tmp1480_ = _tmp1479_;
			_tmp1481_ = vala_expression_get_value_type (_tmp1480_);
			_tmp1482_ = _tmp1481_;
			vala_data_type_set_value_owned (_tmp1482_, FALSE);
			_tmp1483_ = vala_member_access_get_inner (self);
			_tmp1484_ = _tmp1483_;
			_tmp1485_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1484_, (ValaSymbol*) _tmp1485_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1489_ = !klass;
		} else {
			_tmp1489_ = FALSE;
		}
		if (_tmp1489_) {
			ValaSymbol* _tmp1490_;
			ValaSymbol* _tmp1491_;
			_tmp1490_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1491_ = _tmp1490_;
			_tmp1488_ = !VALA_IS_CREATION_METHOD (_tmp1491_);
		} else {
			_tmp1488_ = FALSE;
		}
		if (_tmp1488_) {
			_tmp1487_ = may_access_instance_members;
		} else {
			_tmp1487_ = FALSE;
		}
		if (_tmp1487_) {
			ValaExpression* _tmp1492_;
			ValaExpression* _tmp1493_;
			_tmp1492_ = vala_member_access_get_inner (self);
			_tmp1493_ = _tmp1492_;
			_tmp1486_ = _tmp1493_ != NULL;
		} else {
			_tmp1486_ = FALSE;
		}
		if (_tmp1486_) {
			ValaExpression* _tmp1494_;
			ValaExpression* _tmp1495_;
			ValaSymbol* _tmp1496_;
			ValaSymbol* _tmp1497_;
			_tmp1494_ = vala_member_access_get_inner (self);
			_tmp1495_ = _tmp1494_;
			_tmp1496_ = vala_expression_get_symbol_reference (_tmp1495_);
			_tmp1497_ = _tmp1496_;
			if (VALA_IS_METHOD (_tmp1497_)) {
			} else {
				ValaSourceReference* _tmp1498_;
				ValaSourceReference* _tmp1499_;
				ValaSymbol* _tmp1500_;
				ValaSymbol* _tmp1501_;
				gchar* _tmp1502_;
				gchar* _tmp1503_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1504_;
				ValaSymbol* _tmp1505_;
				ValaSymbol* _tmp1506_;
				ValaSymbol* _tmp1507_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1527_;
				ValaExpression* _tmp1528_;
				ValaExpression* _tmp1529_;
				_tmp1498_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1499_ = _tmp1498_;
				_tmp1500_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1501_ = _tmp1500_;
				_tmp1502_ = vala_symbol_get_full_name (_tmp1501_);
				_tmp1503_ = _tmp1502_;
				vala_report_warning (_tmp1499_, "Access to static member `%s' with an instance reference", _tmp1503_);
				_g_free0 (_tmp1503_);
				_tmp1504_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1505_ = _tmp1504_;
				_tmp1506_ = vala_symbol_get_parent_symbol (_tmp1505_);
				_tmp1507_ = _tmp1506_;
				inner_sym = _tmp1507_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1508_ = FALSE;
					ValaSymbol* _tmp1509_;
					ValaMemberAccess* _tmp1513_;
					ValaSymbol* _tmp1514_;
					const gchar* _tmp1515_;
					const gchar* _tmp1516_;
					ValaSourceReference* _tmp1517_;
					ValaSourceReference* _tmp1518_;
					ValaMemberAccess* _tmp1519_;
					ValaMemberAccess* _tmp1520_;
					ValaMemberAccess* _tmp1521_;
					ValaExpression* _tmp1522_;
					ValaExpression* _tmp1523_;
					ValaSymbol* _tmp1524_;
					ValaSymbol* _tmp1525_;
					ValaSymbol* _tmp1526_;
					_tmp1509_ = inner_sym;
					if (_tmp1509_ != NULL) {
						ValaSymbol* _tmp1510_;
						const gchar* _tmp1511_;
						const gchar* _tmp1512_;
						_tmp1510_ = inner_sym;
						_tmp1511_ = vala_symbol_get_name (_tmp1510_);
						_tmp1512_ = _tmp1511_;
						_tmp1508_ = _tmp1512_ != NULL;
					} else {
						_tmp1508_ = FALSE;
					}
					if (!_tmp1508_) {
						break;
					}
					_tmp1513_ = inner_ma;
					_tmp1514_ = inner_sym;
					_tmp1515_ = vala_symbol_get_name (_tmp1514_);
					_tmp1516_ = _tmp1515_;
					_tmp1517_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1518_ = _tmp1517_;
					_tmp1519_ = vala_member_access_new (NULL, _tmp1516_, _tmp1518_);
					_tmp1520_ = _tmp1519_;
					vala_member_access_set_inner (_tmp1513_, (ValaExpression*) _tmp1520_);
					_vala_code_node_unref0 (_tmp1520_);
					_tmp1521_ = inner_ma;
					_tmp1522_ = vala_member_access_get_inner (_tmp1521_);
					_tmp1523_ = _tmp1522_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1523_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1524_ = inner_sym;
					_tmp1525_ = vala_symbol_get_parent_symbol (_tmp1524_);
					_tmp1526_ = _tmp1525_;
					inner_sym = _tmp1526_;
				}
				_tmp1527_ = inner_ma;
				vala_member_access_set_qualified (_tmp1527_, TRUE);
				_tmp1528_ = vala_member_access_get_inner (self);
				_tmp1529_ = _tmp1528_;
				vala_code_node_check ((ValaCodeNode*) _tmp1529_, context);
			}
		}
		_tmp1535_ = vala_code_context_get_experimental_non_null (context);
		_tmp1536_ = _tmp1535_;
		if (_tmp1536_) {
			_tmp1534_ = instance;
		} else {
			_tmp1534_ = FALSE;
		}
		if (_tmp1534_) {
			ValaExpression* _tmp1537_;
			ValaExpression* _tmp1538_;
			ValaDataType* _tmp1539_;
			ValaDataType* _tmp1540_;
			gboolean _tmp1541_;
			gboolean _tmp1542_;
			_tmp1537_ = vala_member_access_get_inner (self);
			_tmp1538_ = _tmp1537_;
			_tmp1539_ = vala_expression_get_value_type (_tmp1538_);
			_tmp1540_ = _tmp1539_;
			_tmp1541_ = vala_data_type_get_nullable (_tmp1540_);
			_tmp1542_ = _tmp1541_;
			_tmp1533_ = _tmp1542_;
		} else {
			_tmp1533_ = FALSE;
		}
		if (_tmp1533_) {
			ValaExpression* _tmp1543_;
			ValaExpression* _tmp1544_;
			ValaDataType* _tmp1545_;
			ValaDataType* _tmp1546_;
			_tmp1543_ = vala_member_access_get_inner (self);
			_tmp1544_ = _tmp1543_;
			_tmp1545_ = vala_expression_get_value_type (_tmp1544_);
			_tmp1546_ = _tmp1545_;
			_tmp1532_ = !VALA_IS_POINTER_TYPE (_tmp1546_);
		} else {
			_tmp1532_ = FALSE;
		}
		if (_tmp1532_) {
			ValaExpression* _tmp1547_;
			ValaExpression* _tmp1548_;
			ValaDataType* _tmp1549_;
			ValaDataType* _tmp1550_;
			_tmp1547_ = vala_member_access_get_inner (self);
			_tmp1548_ = _tmp1547_;
			_tmp1549_ = vala_expression_get_value_type (_tmp1548_);
			_tmp1550_ = _tmp1549_;
			_tmp1531_ = !VALA_IS_GENERIC_TYPE (_tmp1550_);
		} else {
			_tmp1531_ = FALSE;
		}
		if (_tmp1531_) {
			ValaExpression* _tmp1551_;
			ValaExpression* _tmp1552_;
			ValaDataType* _tmp1553_;
			ValaDataType* _tmp1554_;
			_tmp1551_ = vala_member_access_get_inner (self);
			_tmp1552_ = _tmp1551_;
			_tmp1553_ = vala_expression_get_value_type (_tmp1552_);
			_tmp1554_ = _tmp1553_;
			_tmp1530_ = !VALA_IS_ARRAY_TYPE (_tmp1554_);
		} else {
			_tmp1530_ = FALSE;
		}
		if (_tmp1530_) {
			ValaSourceReference* _tmp1555_;
			ValaSourceReference* _tmp1556_;
			ValaSymbol* _tmp1557_;
			ValaSymbol* _tmp1558_;
			gchar* _tmp1559_;
			gchar* _tmp1560_;
			_tmp1555_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1556_ = _tmp1555_;
			_tmp1557_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1558_ = _tmp1557_;
			_tmp1559_ = vala_symbol_get_full_name (_tmp1558_);
			_tmp1560_ = _tmp1559_;
			vala_report_error (_tmp1556_, "Access to instance member `%s' from nullable reference denied", _tmp1560_);
			_g_free0 (_tmp1560_);
		}
		_tmp1561_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1562_ = _tmp1561_;
		m = VALA_IS_METHOD (_tmp1562_) ? ((ValaMethod*) _tmp1562_) : NULL;
		_tmp1563_ = vala_member_access_get_inner (self);
		_tmp1564_ = _tmp1563_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1564_) ? ((ValaMemberAccess*) _tmp1564_) : NULL;
		_tmp1570_ = m;
		if (_tmp1570_ != NULL) {
			ValaMethod* _tmp1571_;
			ValaMemberBinding _tmp1572_;
			ValaMemberBinding _tmp1573_;
			_tmp1571_ = m;
			_tmp1572_ = vala_method_get_binding (_tmp1571_);
			_tmp1573_ = _tmp1572_;
			_tmp1569_ = _tmp1573_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1569_ = FALSE;
		}
		if (_tmp1569_) {
			ValaMethod* _tmp1574_;
			ValaSymbol* _tmp1575_;
			ValaSymbol* _tmp1576_;
			_tmp1574_ = m;
			_tmp1575_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1574_);
			_tmp1576_ = _tmp1575_;
			_tmp1568_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1576_);
		} else {
			_tmp1568_ = FALSE;
		}
		if (_tmp1568_) {
			ValaExpression* _tmp1577_;
			ValaExpression* _tmp1578_;
			_tmp1577_ = vala_member_access_get_inner (self);
			_tmp1578_ = _tmp1577_;
			_tmp1567_ = _tmp1578_ != NULL;
		} else {
			_tmp1567_ = FALSE;
		}
		if (_tmp1567_) {
			ValaExpression* _tmp1579_;
			ValaExpression* _tmp1580_;
			ValaDataType* _tmp1581_;
			ValaDataType* _tmp1582_;
			_tmp1579_ = vala_member_access_get_inner (self);
			_tmp1580_ = _tmp1579_;
			_tmp1581_ = vala_expression_get_value_type (_tmp1580_);
			_tmp1582_ = _tmp1581_;
			_tmp1566_ = _tmp1582_ == NULL;
		} else {
			_tmp1566_ = FALSE;
		}
		if (_tmp1566_) {
			ValaMemberAccess* _tmp1583_;
			ValaList* _tmp1584_;
			gint _tmp1585_;
			gint _tmp1586_;
			_tmp1583_ = inner_ma;
			_tmp1584_ = _tmp1583_->priv->type_argument_list;
			_tmp1585_ = vala_collection_get_size ((ValaCollection*) _tmp1584_);
			_tmp1586_ = _tmp1585_;
			_tmp1565_ = _tmp1586_ > 0;
		} else {
			_tmp1565_ = FALSE;
		}
		if (_tmp1565_) {
			ValaExpression* _tmp1587_;
			ValaExpression* _tmp1588_;
			ValaMethod* _tmp1589_;
			ValaSymbol* _tmp1590_;
			ValaSymbol* _tmp1591_;
			ValaSourceReference* _tmp1592_;
			ValaSourceReference* _tmp1593_;
			ValaObjectType* _tmp1594_;
			ValaObjectType* _tmp1595_;
			_tmp1587_ = vala_member_access_get_inner (self);
			_tmp1588_ = _tmp1587_;
			_tmp1589_ = m;
			_tmp1590_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1589_);
			_tmp1591_ = _tmp1590_;
			_tmp1592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1593_ = _tmp1592_;
			_tmp1594_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1591_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), _tmp1593_);
			_tmp1595_ = _tmp1594_;
			vala_expression_set_value_type (_tmp1588_, (ValaDataType*) _tmp1595_);
			_vala_code_node_unref0 (_tmp1595_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1596_;
				ValaList* _tmp1597_;
				gint _type_argument_size = 0;
				ValaList* _tmp1598_;
				gint _tmp1599_;
				gint _tmp1600_;
				gint _type_argument_index = 0;
				_tmp1596_ = inner_ma;
				_tmp1597_ = _tmp1596_->priv->type_argument_list;
				_type_argument_list = _tmp1597_;
				_tmp1598_ = _type_argument_list;
				_tmp1599_ = vala_collection_get_size ((ValaCollection*) _tmp1598_);
				_tmp1600_ = _tmp1599_;
				_type_argument_size = _tmp1600_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1601_;
					gint _tmp1602_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1603_;
					gpointer _tmp1604_;
					ValaExpression* _tmp1605_;
					ValaExpression* _tmp1606_;
					ValaDataType* _tmp1607_;
					ValaDataType* _tmp1608_;
					ValaDataType* _tmp1609_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1601_ = _type_argument_index;
					_tmp1602_ = _type_argument_size;
					if (!(_tmp1601_ < _tmp1602_)) {
						break;
					}
					_tmp1603_ = _type_argument_list;
					_tmp1604_ = vala_list_get (_tmp1603_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1604_;
					_tmp1605_ = vala_member_access_get_inner (self);
					_tmp1606_ = _tmp1605_;
					_tmp1607_ = vala_expression_get_value_type (_tmp1606_);
					_tmp1608_ = _tmp1607_;
					_tmp1609_ = type_argument;
					vala_data_type_add_type_argument (_tmp1608_, _tmp1609_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1610_ = vala_code_context_get_analyzer (context);
		_tmp1611_ = _tmp1610_;
		_tmp1612_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1613_ = _tmp1612_;
		_tmp1614_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1615_ = _tmp1614_;
		_tmp1616_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1611_, _tmp1613_, _tmp1615_);
		_tmp1617_ = _tmp1616_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1617_);
		_vala_code_node_unref0 (_tmp1617_);
		_tmp1619_ = vala_member_access_get_inner (self);
		_tmp1620_ = _tmp1619_;
		if (_tmp1620_ != NULL) {
			ValaDataType* _tmp1621_;
			ValaDataType* _tmp1622_;
			_tmp1621_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1622_ = _tmp1621_;
			_tmp1618_ = _tmp1622_ != NULL;
		} else {
			_tmp1618_ = FALSE;
		}
		if (_tmp1618_) {
			ValaDataType* _tmp1623_;
			ValaDataType* _tmp1624_;
			ValaExpression* _tmp1625_;
			ValaExpression* _tmp1626_;
			ValaDataType* _tmp1627_;
			ValaDataType* _tmp1628_;
			ValaDataType* _tmp1629_;
			ValaDataType* _tmp1630_;
			_tmp1623_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1624_ = _tmp1623_;
			_tmp1625_ = vala_member_access_get_inner (self);
			_tmp1626_ = _tmp1625_;
			_tmp1627_ = vala_expression_get_value_type (_tmp1626_);
			_tmp1628_ = _tmp1627_;
			_tmp1629_ = vala_data_type_get_actual_type (_tmp1624_, _tmp1628_, NULL, (ValaCodeNode*) self);
			_tmp1630_ = _tmp1629_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1630_);
			_vala_code_node_unref0 (_tmp1630_);
		} else {
			ValaDataType* _tmp1631_;
			ValaDataType* _tmp1632_;
			_tmp1631_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1632_ = _tmp1631_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1632_);
		}
		_tmp1633_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1634_ = _tmp1633_;
		if (VALA_IS_METHOD (_tmp1634_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1635_;
			ValaSymbol* _tmp1636_;
			ValaDataType* _tmp1637_;
			ValaDataType* _tmp1638_;
			gboolean _tmp1645_ = FALSE;
			_tmp1635_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1636_ = _tmp1635_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1636_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1637_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1638_ = _tmp1637_;
			if (_tmp1638_ != NULL) {
				ValaDataType* _tmp1639_;
				ValaDataType* _tmp1640_;
				ValaDataType* _tmp1641_;
				ValaDataType* _tmp1642_;
				gboolean _tmp1643_;
				gboolean _tmp1644_;
				_tmp1639_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1640_ = _tmp1639_;
				_tmp1641_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1642_ = _tmp1641_;
				_tmp1643_ = vala_data_type_get_value_owned (_tmp1642_);
				_tmp1644_ = _tmp1643_;
				vala_data_type_set_value_owned (_tmp1640_, _tmp1644_);
			}
			if (instance) {
				ValaMethod* _tmp1646_;
				ValaSymbol* _tmp1647_;
				ValaSymbol* _tmp1648_;
				_tmp1646_ = method;
				_tmp1647_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1646_);
				_tmp1648_ = _tmp1647_;
				_tmp1645_ = VALA_IS_TYPESYMBOL (_tmp1648_);
			} else {
				_tmp1645_ = FALSE;
			}
			if (_tmp1645_) {
				ValaExpression* _tmp1649_;
				ValaExpression* _tmp1650_;
				ValaMethod* _tmp1651_;
				ValaSymbol* _tmp1652_;
				ValaSymbol* _tmp1653_;
				ValaDataType* _tmp1654_;
				ValaDataType* _tmp1655_;
				ValaExpression* _tmp1656_;
				ValaExpression* _tmp1657_;
				ValaDataType* _tmp1658_;
				ValaDataType* _tmp1659_;
				ValaMethod* _tmp1660_;
				ValaParameter* _tmp1661_;
				ValaParameter* _tmp1662_;
				ValaDataType* _tmp1663_;
				ValaDataType* _tmp1664_;
				gboolean _tmp1665_;
				gboolean _tmp1666_;
				_tmp1649_ = vala_member_access_get_inner (self);
				_tmp1650_ = _tmp1649_;
				_tmp1651_ = method;
				_tmp1652_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1651_);
				_tmp1653_ = _tmp1652_;
				_tmp1654_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1653_);
				_tmp1655_ = _tmp1654_;
				vala_expression_set_target_type (_tmp1650_, _tmp1655_);
				_vala_code_node_unref0 (_tmp1655_);
				_tmp1656_ = vala_member_access_get_inner (self);
				_tmp1657_ = _tmp1656_;
				_tmp1658_ = vala_expression_get_target_type (_tmp1657_);
				_tmp1659_ = _tmp1658_;
				_tmp1660_ = method;
				_tmp1661_ = vala_method_get_this_parameter (_tmp1660_);
				_tmp1662_ = _tmp1661_;
				_tmp1663_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1662_);
				_tmp1664_ = _tmp1663_;
				_tmp1665_ = vala_data_type_get_value_owned (_tmp1664_);
				_tmp1666_ = _tmp1665_;
				vala_data_type_set_value_owned (_tmp1659_, _tmp1666_);
			}
		} else {
			gboolean _tmp1667_ = FALSE;
			gboolean _tmp1668_ = FALSE;
			ValaSymbol* _tmp1669_;
			ValaSymbol* _tmp1670_;
			_tmp1669_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1670_ = _tmp1669_;
			if (VALA_IS_PROPERTY (_tmp1670_)) {
				_tmp1668_ = instance;
			} else {
				_tmp1668_ = FALSE;
			}
			if (_tmp1668_) {
				ValaSymbol* _tmp1671_;
				ValaSymbol* _tmp1672_;
				ValaSymbol* _tmp1673_;
				ValaSymbol* _tmp1674_;
				_tmp1671_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1672_ = _tmp1671_;
				_tmp1673_ = vala_symbol_get_parent_symbol (_tmp1672_);
				_tmp1674_ = _tmp1673_;
				_tmp1667_ = _tmp1674_ != NULL;
			} else {
				_tmp1667_ = FALSE;
			}
			if (_tmp1667_) {
				ValaExpression* _tmp1675_;
				ValaExpression* _tmp1676_;
				ValaSymbol* _tmp1677_;
				ValaSymbol* _tmp1678_;
				ValaSymbol* _tmp1679_;
				ValaSymbol* _tmp1680_;
				ValaDataType* _tmp1681_;
				ValaDataType* _tmp1682_;
				_tmp1675_ = vala_member_access_get_inner (self);
				_tmp1676_ = _tmp1675_;
				_tmp1677_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1678_ = _tmp1677_;
				_tmp1679_ = vala_symbol_get_parent_symbol (_tmp1678_);
				_tmp1680_ = _tmp1679_;
				_tmp1681_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1680_);
				_tmp1682_ = _tmp1681_;
				vala_expression_set_target_type (_tmp1676_, _tmp1682_);
				_vala_code_node_unref0 (_tmp1682_);
			} else {
				gboolean _tmp1683_ = FALSE;
				gboolean _tmp1684_ = FALSE;
				gboolean _tmp1685_ = FALSE;
				ValaSymbol* _tmp1686_;
				ValaSymbol* _tmp1687_;
				_tmp1686_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1687_ = _tmp1686_;
				if (VALA_IS_FIELD (_tmp1687_)) {
					_tmp1685_ = TRUE;
				} else {
					ValaSymbol* _tmp1688_;
					ValaSymbol* _tmp1689_;
					_tmp1688_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1689_ = _tmp1688_;
					_tmp1685_ = VALA_IS_SIGNAL (_tmp1689_);
				}
				if (_tmp1685_) {
					_tmp1684_ = instance;
				} else {
					_tmp1684_ = FALSE;
				}
				if (_tmp1684_) {
					ValaSymbol* _tmp1690_;
					ValaSymbol* _tmp1691_;
					ValaSymbol* _tmp1692_;
					ValaSymbol* _tmp1693_;
					_tmp1690_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1691_ = _tmp1690_;
					_tmp1692_ = vala_symbol_get_parent_symbol (_tmp1691_);
					_tmp1693_ = _tmp1692_;
					_tmp1683_ = _tmp1693_ != NULL;
				} else {
					_tmp1683_ = FALSE;
				}
				if (_tmp1683_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1694_;
					ValaSymbol* _tmp1695_;
					ValaSymbol* _tmp1696_;
					ValaSymbol* _tmp1697_;
					ValaDataType* _tmp1698_;
					ValaExpression* _tmp1699_;
					ValaExpression* _tmp1700_;
					ValaDataType* _tmp1701_;
					ValaExpression* _tmp1702_;
					ValaExpression* _tmp1703_;
					ValaDataType* _tmp1704_;
					ValaDataType* _tmp1705_;
					ValaDataType* _tmp1706_;
					ValaDataType* _tmp1707_;
					_tmp1694_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1695_ = _tmp1694_;
					_tmp1696_ = vala_symbol_get_parent_symbol (_tmp1695_);
					_tmp1697_ = _tmp1696_;
					_tmp1698_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1697_);
					parent_type = _tmp1698_;
					_tmp1699_ = vala_member_access_get_inner (self);
					_tmp1700_ = _tmp1699_;
					_tmp1701_ = parent_type;
					_tmp1702_ = vala_member_access_get_inner (self);
					_tmp1703_ = _tmp1702_;
					_tmp1704_ = vala_expression_get_value_type (_tmp1703_);
					_tmp1705_ = _tmp1704_;
					_tmp1706_ = vala_data_type_get_actual_type (_tmp1701_, _tmp1705_, NULL, (ValaCodeNode*) self);
					_tmp1707_ = _tmp1706_;
					vala_expression_set_target_type (_tmp1700_, _tmp1707_);
					_vala_code_node_unref0 (_tmp1707_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1710_ = vala_member_access_get_inner (self);
		_tmp1711_ = _tmp1710_;
		if (_tmp1711_ == NULL) {
			ValaDataType* _tmp1712_;
			ValaDataType* _tmp1713_;
			_tmp1712_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1713_ = _tmp1712_;
			_tmp1709_ = _tmp1713_ != NULL;
		} else {
			_tmp1709_ = FALSE;
		}
		if (_tmp1709_) {
			ValaProfile _tmp1714_;
			ValaProfile _tmp1715_;
			_tmp1714_ = vala_code_context_get_profile (context);
			_tmp1715_ = _tmp1714_;
			_tmp1708_ = _tmp1715_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1708_ = FALSE;
		}
		if (_tmp1708_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1716_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1717_ = _tmp1716_;
	if (_tmp1717_ != NULL) {
		ValaDataType* _tmp1718_;
		ValaDataType* _tmp1719_;
		_tmp1718_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1719_ = _tmp1718_;
		vala_code_node_check ((ValaCodeNode*) _tmp1719_, context);
	}
	_tmp1720_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1721_ = _tmp1720_;
	if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp1721_)) {
		gboolean _tmp1722_ = FALSE;
		gboolean _tmp1723_ = FALSE;
		ValaExpression* _tmp1724_;
		ValaExpression* _tmp1725_;
		ValaDataType* _tmp1726_;
		ValaDataType* _tmp1727_;
		_tmp1724_ = vala_member_access_get_inner (self);
		_tmp1725_ = _tmp1724_;
		_tmp1726_ = vala_expression_get_value_type (_tmp1725_);
		_tmp1727_ = _tmp1726_;
		if (VALA_IS_ARRAY_TYPE (_tmp1727_)) {
			ValaExpression* _tmp1728_;
			ValaExpression* _tmp1729_;
			ValaDataType* _tmp1730_;
			ValaDataType* _tmp1731_;
			gint _tmp1732_;
			gint _tmp1733_;
			_tmp1728_ = vala_member_access_get_inner (self);
			_tmp1729_ = _tmp1728_;
			_tmp1730_ = vala_expression_get_value_type (_tmp1729_);
			_tmp1731_ = _tmp1730_;
			_tmp1732_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp1731_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp1733_ = _tmp1732_;
			_tmp1723_ = _tmp1733_ > 1;
		} else {
			_tmp1723_ = FALSE;
		}
		if (_tmp1723_) {
			ValaCodeNode* _tmp1734_;
			ValaCodeNode* _tmp1735_;
			_tmp1734_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp1735_ = _tmp1734_;
			_tmp1722_ = !VALA_IS_ELEMENT_ACCESS (_tmp1735_);
		} else {
			_tmp1722_ = FALSE;
		}
		if (_tmp1722_) {
			ValaSourceReference* _tmp1736_;
			ValaSourceReference* _tmp1737_;
			_tmp1736_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1737_ = _tmp1736_;
			vala_report_error (_tmp1737_, "unsupported use of length field of multi-dimensional array");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	} else {
		ValaSymbol* _tmp1738_;
		ValaSymbol* _tmp1739_;
		_tmp1738_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1739_ = _tmp1738_;
		if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp1739_)) {
			ValaExpression* _tmp1740_;
			ValaExpression* _tmp1741_;
			ValaDataType* _tmp1742_;
			ValaDataType* _tmp1743_;
			ValaDelegate* _tmp1744_;
			ValaDelegate* _tmp1745_;
			gboolean _tmp1746_;
			gboolean _tmp1747_;
			_tmp1740_ = vala_member_access_get_inner (self);
			_tmp1741_ = _tmp1740_;
			_tmp1742_ = vala_expression_get_value_type (_tmp1741_);
			_tmp1743_ = _tmp1742_;
			_tmp1744_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1743_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			_tmp1745_ = _tmp1744_;
			_tmp1746_ = vala_delegate_get_has_target (_tmp1745_);
			_tmp1747_ = _tmp1746_;
			if (!_tmp1747_) {
				ValaSourceReference* _tmp1748_;
				ValaSourceReference* _tmp1749_;
				_tmp1748_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1749_ = _tmp1748_;
				vala_report_error (_tmp1749_, "unsupported use of target field of delegate without target");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		} else {
			ValaSymbol* _tmp1750_;
			ValaSymbol* _tmp1751_;
			_tmp1750_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1751_ = _tmp1750_;
			if (VALA_IS_DELEGATE_DESTROY_FIELD (_tmp1751_)) {
				ValaExpression* _tmp1752_;
				ValaExpression* _tmp1753_;
				ValaDataType* _tmp1754_;
				ValaDataType* _tmp1755_;
				ValaDelegate* _tmp1756_;
				ValaDelegate* _tmp1757_;
				gboolean _tmp1758_;
				gboolean _tmp1759_;
				_tmp1752_ = vala_member_access_get_inner (self);
				_tmp1753_ = _tmp1752_;
				_tmp1754_ = vala_expression_get_value_type (_tmp1753_);
				_tmp1755_ = _tmp1754_;
				_tmp1756_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1755_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp1757_ = _tmp1756_;
				_tmp1758_ = vala_delegate_get_has_target (_tmp1757_);
				_tmp1759_ = _tmp1758_;
				if (!_tmp1759_) {
					ValaSourceReference* _tmp1760_;
					ValaSourceReference* _tmp1761_;
					_tmp1760_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1761_ = _tmp1760_;
					vala_report_error (_tmp1761_, "unsupported use of destroy field of delegate without target");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp1762_ = self->priv->_tainted_access;
	if (!_tmp1762_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1763_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1764_ = _tmp1763_;
	result = !_tmp1764_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	gboolean _tmp93_ = FALSE;
	ValaSymbol* _tmp94_;
	ValaSymbol* _tmp95_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp85_)) {
		_tmp83_ = TRUE;
	} else {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp83_ = VALA_IS_DELEGATE_DESTROY_FIELD (_tmp87_);
	}
	if (_tmp83_) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaMemberAccess* _tmp90_;
		_tmp88_ = vala_member_access_get_inner (self);
		_tmp89_ = _tmp88_;
		vala_expression_set_lvalue (_tmp89_, TRUE);
		_tmp90_ = ma;
		if (_tmp90_ != NULL) {
			ValaMemberAccess* _tmp91_;
			ValaMemberAccess* _tmp92_;
			_tmp91_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp91_, TRUE);
			_tmp92_ = ma;
			vala_member_access_check_lvalue_access (_tmp92_);
		}
	}
	_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp95_ = _tmp94_;
	if (VALA_IS_METHOD (_tmp95_)) {
		ValaSymbol* _tmp96_;
		ValaSymbol* _tmp97_;
		ValaAttribute* _tmp98_;
		_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp93_ = _tmp98_ != NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp102_;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		ValaClass* _tmp105_;
		_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_METHOD, ValaMethod));
		_tmp102_ = _tmp101_;
		cl = VALA_IS_CLASS (_tmp102_) ? ((ValaClass*) _tmp102_) : NULL;
		_tmp105_ = cl;
		if (_tmp105_ != NULL) {
			ValaClass* _tmp106_;
			gboolean _tmp107_;
			gboolean _tmp108_;
			_tmp106_ = cl;
			_tmp107_ = vala_class_get_is_compact (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp104_ = _tmp108_;
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			ValaMemberAccess* _tmp109_;
			_tmp109_ = ma;
			_tmp103_ = _tmp109_ != NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp110_;
			ValaMemberAccess* _tmp111_;
			_tmp110_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp110_, TRUE);
			_tmp111_ = ma;
			vala_member_access_check_lvalue_access (_tmp111_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__once = 0;
	if (g_once_init_enter (&vala_member_access_type_id__once)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__once, vala_member_access_type_id);
	}
	return vala_member_access_type_id__once;
}

