/* valagirwriter.c generated by valac, the Vala compiler
 * generated from valagirwriter.vala, do not modify */

/* valagirwriter.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib/gstdio.h>

#define VALA_GIR_WRITER_TYPE_GIR_NAMESPACE (vala_gir_writer_gir_namespace_get_type ())
typedef struct _ValaGIRWriterGIRNamespace ValaGIRWriterGIRNamespace;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_gir_writer_gir_namespace_free0(var) ((var == NULL) ? NULL : (var = (vala_gir_writer_gir_namespace_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGIRWriterGIRNamespace {
	gchar* ns;
	gchar* version;
};

struct _ValaGIRWriterPrivate {
	ValaCodeContext* context;
	gchar* directory;
	gchar* gir_namespace;
	gchar* gir_version;
	gchar* gir_shared_library;
	GString* buffer;
	FILE* stream;
	ValaHashSet* unannotated_namespaces;
	ValaHashSet* our_namespaces;
	ValaArrayList* hierarchy;
	ValaArrayList* deferred;
	gint indent;
	ValaTypeSymbol* gobject_type;
	ValaTypeSymbol* ginitiallyunowned_type;
	ValaTypeSymbol* gtypeinterface_type;
	ValaTypeSymbol* gtypeinstance_type;
	ValaTypeSymbol* gtype_type;
	ValaArrayList* externals;
	gint enum_value;
};

static gint ValaGIRWriter_private_offset;
static gpointer vala_gir_writer_parent_class = NULL;

static GType vala_gir_writer_gir_namespace_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self,
                                         ValaGIRWriterGIRNamespace* dest);
static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self);
static gchar* vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self,
                                                   ValaInterface* iface);
static gchar* vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self,
                                                ValaStruct* st);
static gchar* vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self,
                                              ValaEnum* en);
static gchar* vala_gir_writer_real_get_class_comment (ValaGIRWriter* self,
                                               ValaClass* c);
static gchar* vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self,
                                                    ValaErrorCode* ecode);
static gchar* vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self,
                                                    ValaEnumValue* ev);
static gchar* vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self,
                                                  ValaConstant* c);
static gchar* vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self,
                                                      ValaErrorDomain* edomain);
static gchar* vala_gir_writer_real_get_field_comment (ValaGIRWriter* self,
                                               ValaField* f);
static gchar* vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self,
                                                  ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_method_comment (ValaGIRWriter* self,
                                                ValaMethod* m);
static gchar* vala_gir_writer_real_get_property_comment (ValaGIRWriter* self,
                                                  ValaProperty* prop);
static gchar* vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self,
                                                         ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self,
                                                       ValaSignal* sig);
static gchar* vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self,
                                                       ValaMethod* m);
static gchar* vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self,
                                                ValaSignal* sig);
static gchar* vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self,
                                                   ValaParameter* param);
static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self,
                                              ValaGIRWriterGIRNamespace* g);
static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self);
static void vala_gir_writer_write_package (ValaGIRWriter* self,
                                    const gchar* package);
static void vala_gir_writer_write_doc (ValaGIRWriter* self,
                                const gchar* comment);
static void vala_gir_writer_write_indent (ValaGIRWriter* self);
static void vala_gir_writer_write_c_includes (ValaGIRWriter* self,
                                       ValaNamespace* ns);
static void vala_gir_writer_write_c_include (ValaGIRWriter* self,
                                      const gchar* name);
static void vala_gir_writer_real_visit_source_file (ValaCodeVisitor* base,
                                             ValaSourceFile* source_file);
static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base,
                                           ValaNamespace* ns);
static gboolean vala_gir_writer_is_visibility (ValaGIRWriter* self,
                                        ValaSymbol* sym);
static void vala_gir_writer_visit_deferred (ValaGIRWriter* self);
static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self,
                                              ValaSymbol* symbol);
static gboolean vala_gir_writer_is_introspectable (ValaGIRWriter* self,
                                            ValaSymbol* sym);
static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base,
                                       ValaClass* cl);
static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self,
                                              ValaSymbol* sym);
static gboolean vala_gir_writer_has_namespace (ValaGIRWriter* self,
                                        ValaSymbol* sym);
static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self,
                                     ValaSymbol* symbol);
static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self,
                                             ValaTypeSymbol* symbol,
                                             gboolean symbol_prefix);
static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self,
                                     ValaTypeSymbol* type_symbol);
static void vala_gir_writer_write_type_parameter (ValaGIRWriter* self,
                                           ValaTypeParameter* type_parameter,
                                           const gchar* tag_type);
static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self,
                                             ValaTypeSymbol* symbol,
                                             const gchar* suffix,
                                             gboolean symbol_prefix);
static void vala_gir_writer_do_write_signature (ValaGIRWriter* self,
                                         ValaMethod* m,
                                         const gchar* tag_name,
                                         gboolean instance,
                                         const gchar* name,
                                         const gchar* cname,
                                         ValaList* params,
                                         ValaDataType* return_type,
                                         gboolean can_fail,
                                         gboolean write_comment,
                                         gboolean write_attributes);
static void vala_gir_writer_write_signature (ValaGIRWriter* self,
                                      ValaMethod* m,
                                      const gchar* tag_name,
                                      gboolean write_doc,
                                      gboolean instance,
                                      gboolean write_attributes);
static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base,
                                        ValaStruct* st);
static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base,
                                           ValaInterface* iface);
static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base,
                                      ValaEnum* en);
static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base,
                                            ValaEnumValue* ev);
static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self,
                                                           ValaExpression* literal);
static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base,
                                              ValaErrorDomain* edomain);
static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base,
                                            ValaErrorCode* ecode);
static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base,
                                          ValaConstant* c);
static void vala_gir_writer_write_type (ValaGIRWriter* self,
                                 ValaDataType* type,
                                 gint index,
                                 ValaParameterDirection direction);
static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base,
                                       ValaField* f);
static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self,
                                            ValaDataType* type,
                                            gint* index,
                                            gboolean has_array_length,
                                            const gchar* name,
                                            ValaParameterDirection direction);
static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self,
                                            ValaDataType* type,
                                            const gchar* tag,
                                            gint* index,
                                            gboolean has_array_length,
                                            const gchar* name,
                                            const gchar* comment,
                                            ValaParameterDirection direction,
                                            gboolean constructor,
                                            gboolean caller_allocates,
                                            gboolean ellipsis);
static void vala_gir_writer_skip_implicit_params (ValaGIRWriter* self,
                                           ValaDataType* type,
                                           gint* index,
                                           gboolean has_array_length);
static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self,
                                              const gchar* tag_name,
                                              ValaList* params,
                                              ValaList* type_params,
                                              ValaDataType* return_type,
                                              gboolean return_array_length,
                                              const gchar* return_comment,
                                              gboolean constructor,
                                              ValaParameter* instance_param,
                                              gboolean user_data);
static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base,
                                          ValaDelegate* cb);
static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base,
                                        ValaMethod* m);
static gboolean vala_gir_writer_is_type_introspectable (ValaGIRWriter* self,
                                                 ValaDataType* type);
static gboolean vala_gir_writer_is_method_introspectable (ValaGIRWriter* self,
                                                   ValaMethod* m);
static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base,
                                                 ValaCreationMethod* m);
static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base,
                                          ValaProperty* prop);
static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base,
                                        ValaSignal* sig);
static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self,
                                          ValaSymbol* sym);
static void vala_gir_writer_gir_namespace_for_symbol (ValaSymbol* sym,
                                               ValaGIRWriterGIRNamespace* result);
static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self,
                                         const gchar* ns,
                                         const gchar* version);
static void vala_gir_writer_finalize (ValaCodeVisitor * obj);
static GType vala_gir_writer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
vala_gir_writer_get_instance_private (ValaGIRWriter* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGIRWriter_private_offset);
}

static gchar*
vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self,
                                            ValaInterface* iface)
{
	gchar* result;
	g_return_val_if_fail (iface != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_interface_comment (ValaGIRWriter* self,
                                       ValaInterface* iface)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_interface_comment) {
		return _klass_->get_interface_comment (self, iface);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self,
                                         ValaStruct* st)
{
	gchar* result;
	g_return_val_if_fail (st != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_struct_comment (ValaGIRWriter* self,
                                    ValaStruct* st)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_struct_comment) {
		return _klass_->get_struct_comment (self, st);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self,
                                       ValaEnum* en)
{
	gchar* result;
	g_return_val_if_fail (en != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_enum_comment (ValaGIRWriter* self,
                                  ValaEnum* en)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_enum_comment) {
		return _klass_->get_enum_comment (self, en);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_class_comment (ValaGIRWriter* self,
                                        ValaClass* c)
{
	gchar* result;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_class_comment (ValaGIRWriter* self,
                                   ValaClass* c)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_class_comment) {
		return _klass_->get_class_comment (self, c);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self,
                                             ValaErrorCode* ecode)
{
	gchar* result;
	g_return_val_if_fail (ecode != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_error_code_comment (ValaGIRWriter* self,
                                        ValaErrorCode* ecode)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_error_code_comment) {
		return _klass_->get_error_code_comment (self, ecode);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self,
                                             ValaEnumValue* ev)
{
	gchar* result;
	g_return_val_if_fail (ev != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_enum_value_comment (ValaGIRWriter* self,
                                        ValaEnumValue* ev)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_enum_value_comment) {
		return _klass_->get_enum_value_comment (self, ev);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self,
                                           ValaConstant* c)
{
	gchar* result;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_constant_comment (ValaGIRWriter* self,
                                      ValaConstant* c)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_constant_comment) {
		return _klass_->get_constant_comment (self, c);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self,
                                               ValaErrorDomain* edomain)
{
	gchar* result;
	g_return_val_if_fail (edomain != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_error_domain_comment (ValaGIRWriter* self,
                                          ValaErrorDomain* edomain)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_error_domain_comment) {
		return _klass_->get_error_domain_comment (self, edomain);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_field_comment (ValaGIRWriter* self,
                                        ValaField* f)
{
	gchar* result;
	g_return_val_if_fail (f != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_field_comment (ValaGIRWriter* self,
                                   ValaField* f)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_field_comment) {
		return _klass_->get_field_comment (self, f);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self,
                                           ValaDelegate* cb)
{
	gchar* result;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_delegate_comment (ValaGIRWriter* self,
                                      ValaDelegate* cb)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_delegate_comment) {
		return _klass_->get_delegate_comment (self, cb);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_method_comment (ValaGIRWriter* self,
                                         ValaMethod* m)
{
	gchar* result;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_method_comment (ValaGIRWriter* self,
                                    ValaMethod* m)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_method_comment) {
		return _klass_->get_method_comment (self, m);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_property_comment (ValaGIRWriter* self,
                                           ValaProperty* prop)
{
	gchar* result;
	g_return_val_if_fail (prop != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_property_comment (ValaGIRWriter* self,
                                      ValaProperty* prop)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_property_comment) {
		return _klass_->get_property_comment (self, prop);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self,
                                                  ValaDelegate* cb)
{
	gchar* result;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_delegate_return_comment (ValaGIRWriter* self,
                                             ValaDelegate* cb)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_delegate_return_comment) {
		return _klass_->get_delegate_return_comment (self, cb);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self,
                                                ValaSignal* sig)
{
	gchar* result;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_signal_return_comment (ValaGIRWriter* self,
                                           ValaSignal* sig)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_signal_return_comment) {
		return _klass_->get_signal_return_comment (self, sig);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self,
                                                ValaMethod* m)
{
	gchar* result;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_method_return_comment (ValaGIRWriter* self,
                                           ValaMethod* m)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_method_return_comment) {
		return _klass_->get_method_return_comment (self, m);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self,
                                         ValaSignal* sig)
{
	gchar* result;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_signal_comment (ValaGIRWriter* self,
                                    ValaSignal* sig)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_signal_comment) {
		return _klass_->get_signal_comment (self, sig);
	}
	return NULL;
}

static gchar*
vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self,
                                            ValaParameter* param)
{
	gchar* result;
	g_return_val_if_fail (param != NULL, NULL);
	result = NULL;
	return result;
}

gchar*
vala_gir_writer_get_parameter_comment (ValaGIRWriter* self,
                                       ValaParameter* param)
{
	ValaGIRWriterClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_GIR_WRITER_GET_CLASS (self);
	if (_klass_->get_parameter_comment) {
		return _klass_->get_parameter_comment (self, param);
	}
	return NULL;
}

void
vala_gir_writer_write_includes (ValaGIRWriter* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _i_list = NULL;
		ValaArrayList* _tmp0_;
		gint _i_size = 0;
		ValaArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _i_index = 0;
		_tmp0_ = self->priv->externals;
		_i_list = _tmp0_;
		_tmp1_ = _i_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_i_size = _tmp3_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaGIRWriterGIRNamespace* i = NULL;
			ValaArrayList* _tmp6_;
			gpointer _tmp7_;
			ValaGIRWriterGIRNamespace* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_i_index = _i_index + 1;
			_tmp4_ = _i_index;
			_tmp5_ = _i_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _i_list;
			_tmp7_ = vala_list_get ((ValaList*) _tmp6_, _i_index);
			i = (ValaGIRWriterGIRNamespace*) _tmp7_;
			_tmp8_ = i;
			_tmp9_ = (*_tmp8_).ns;
			_tmp10_ = self->priv->gir_namespace;
			if (g_strcmp0 (_tmp9_, _tmp10_) != 0) {
				FILE* _tmp11_;
				ValaGIRWriterGIRNamespace* _tmp12_;
				const gchar* _tmp13_;
				ValaGIRWriterGIRNamespace* _tmp14_;
				const gchar* _tmp15_;
				vala_gir_writer_write_indent_stream (self);
				_tmp11_ = self->priv->stream;
				_tmp12_ = i;
				_tmp13_ = (*_tmp12_).ns;
				_tmp14_ = i;
				_tmp15_ = (*_tmp14_).version;
				fprintf (_tmp11_, "<include name=\"%s\" version=\"%s\"/>\n", _tmp13_, _tmp15_);
			}
			_vala_gir_writer_gir_namespace_free0 (i);
		}
	}
}

/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context      a code context
 * @param gir_filename a relative or absolute filename
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_gir_writer_write_file (ValaGIRWriter* self,
                            ValaCodeContext* context,
                            const gchar* directory,
                            const gchar* gir_filename,
                            const gchar* gir_namespace,
                            const gchar* gir_version,
                            const gchar* package,
                            const gchar* gir_shared_library)
{
	ValaCodeContext* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValaNamespace* root_symbol = NULL;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaSymbol* glib_ns = NULL;
	ValaNamespace* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaScope* _tmp17_;
	ValaScope* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaScope* _tmp21_;
	ValaScope* _tmp22_;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaScope* _tmp25_;
	ValaScope* _tmp26_;
	ValaSymbol* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	gint _tmp41_;
	GString* _tmp42_;
	gchar* filename = NULL;
	gchar* _tmp43_;
	gboolean file_exists = FALSE;
	const gchar* _tmp44_;
	gchar* temp_filename = NULL;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	FILE* _tmp51_;
	FILE* _tmp53_;
	gchar* _tmp54_ = NULL;
	gboolean _tmp55_;
	gboolean _tmp56_;
	gchar* header = NULL;
	gchar* _tmp67_;
	FILE* _tmp68_;
	const gchar* _tmp69_;
	FILE* _tmp70_;
	FILE* _tmp71_;
	FILE* _tmp72_;
	FILE* _tmp73_;
	FILE* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	FILE* _tmp77_;
	GString* _tmp78_;
	const gchar* _tmp79_;
	ValaHashSet* _tmp121_;
	gint _tmp122_;
	gint _tmp123_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (gir_filename != NULL);
	g_return_if_fail (gir_namespace != NULL);
	g_return_if_fail (gir_version != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = g_strdup (directory);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp1_;
	_tmp2_ = g_strdup (gir_namespace);
	_g_free0 (self->priv->gir_namespace);
	self->priv->gir_namespace = _tmp2_;
	_tmp3_ = g_strdup (gir_version);
	_g_free0 (self->priv->gir_version);
	self->priv->gir_version = _tmp3_;
	_tmp4_ = g_strdup (gir_shared_library);
	_g_free0 (self->priv->gir_shared_library);
	self->priv->gir_shared_library = _tmp4_;
	_tmp5_ = vala_code_context_get_root (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	root_symbol = _tmp7_;
	_tmp8_ = root_symbol;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_scope_lookup (_tmp10_, "GLib");
	glib_ns = _tmp11_;
	_tmp12_ = glib_ns;
	_tmp13_ = vala_symbol_get_scope (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_scope_lookup (_tmp14_, "Object");
	_vala_code_node_unref0 (self->priv->gobject_type);
	self->priv->gobject_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp16_ = glib_ns;
	_tmp17_ = vala_symbol_get_scope (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_scope_lookup (_tmp18_, "InitiallyUnowned");
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	self->priv->ginitiallyunowned_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp20_ = glib_ns;
	_tmp21_ = vala_symbol_get_scope (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_scope_lookup (_tmp22_, "TypeInterface");
	_vala_code_node_unref0 (self->priv->gtypeinterface_type);
	self->priv->gtypeinterface_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp24_ = glib_ns;
	_tmp25_ = vala_symbol_get_scope (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_scope_lookup (_tmp26_, "TypeInstance");
	_vala_code_node_unref0 (self->priv->gtypeinstance_type);
	self->priv->gtypeinstance_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "Type");
	_vala_code_node_unref0 (self->priv->gtype_type);
	self->priv->gtype_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	vala_gir_writer_write_package (self, package);
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp32_;
		gint _file_size = 0;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _file_index = 0;
		_tmp32_ = vala_code_context_get_source_files (context);
		_file_list = _tmp32_;
		_tmp33_ = _file_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_file_size = _tmp35_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp38_;
			gpointer _tmp39_;
			ValaSourceFile* _tmp40_;
			_file_index = _file_index + 1;
			_tmp36_ = _file_index;
			_tmp37_ = _file_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _file_list;
			_tmp39_ = vala_list_get (_tmp38_, _file_index);
			file = (ValaSourceFile*) _tmp39_;
			_tmp40_ = file;
			vala_source_file_accept (_tmp40_, (ValaCodeVisitor*) self);
			_vala_source_file_unref0 (file);
		}
	}
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_tmp41_ = self->priv->indent;
	self->priv->indent = _tmp41_ - 1;
	_tmp42_ = self->priv->buffer;
	g_string_append_printf (_tmp42_, "</repository>\n");
	_tmp43_ = g_strdup_printf ("%s%c%s", directory, (gint) G_DIR_SEPARATOR, gir_filename);
	filename = _tmp43_;
	_tmp44_ = filename;
	file_exists = g_file_test (_tmp44_, G_FILE_TEST_EXISTS);
	_tmp45_ = filename;
	_tmp46_ = g_strdup_printf ("%s.valatmp", _tmp45_);
	temp_filename = _tmp46_;
	if (file_exists) {
		const gchar* _tmp47_;
		FILE* _tmp48_;
		_tmp47_ = temp_filename;
		_tmp48_ = g_fopen (_tmp47_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp48_;
	} else {
		const gchar* _tmp49_;
		FILE* _tmp50_;
		_tmp49_ = filename;
		_tmp50_ = g_fopen (_tmp49_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp50_;
	}
	_tmp51_ = self->priv->stream;
	if (_tmp51_ == NULL) {
		const gchar* _tmp52_;
		_tmp52_ = filename;
		vala_report_error (NULL, "unable to open `%s' for writing", _tmp52_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
		_g_free0 (temp_filename);
		_g_free0 (filename);
		_vala_code_node_unref0 (glib_ns);
		_vala_code_node_unref0 (root_symbol);
		return;
	}
	_tmp53_ = self->priv->stream;
	fprintf (_tmp53_, "<?xml version=\"1.0\"?>\n");
	_tmp55_ = vala_code_context_get_version_header (context);
	_tmp56_ = _tmp55_;
	if (_tmp56_) {
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp57_ = filename;
		_tmp58_ = g_path_get_basename (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_get_prgname ();
		_tmp61_ = g_strdup_printf ("<!-- %s generated by %s %s, do not modify. -->", _tmp59_, _tmp60_, VALA_BUILD_VERSION);
		_g_free0 (_tmp54_);
		_tmp54_ = _tmp61_;
		_g_free0 (_tmp59_);
	} else {
		const gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp62_ = filename;
		_tmp63_ = g_path_get_basename (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_get_prgname ();
		_tmp66_ = g_strdup_printf ("<!-- %s generated by %s, do not modify. -->", _tmp64_, _tmp65_);
		_g_free0 (_tmp54_);
		_tmp54_ = _tmp66_;
		_g_free0 (_tmp64_);
	}
	_tmp67_ = g_strdup (_tmp54_);
	header = _tmp67_;
	_tmp68_ = self->priv->stream;
	_tmp69_ = header;
	fprintf (_tmp68_, "%s\n", _tmp69_);
	_tmp70_ = self->priv->stream;
	fprintf (_tmp70_, "<repository version=\"1.2\"");
	_tmp71_ = self->priv->stream;
	fprintf (_tmp71_, " xmlns=\"http://www.gtk.org/introspection/core/1.0\"");
	_tmp72_ = self->priv->stream;
	fprintf (_tmp72_, " xmlns:c=\"http://www.gtk.org/introspection/c/1.0\"");
	_tmp73_ = self->priv->stream;
	fprintf (_tmp73_, " xmlns:glib=\"http://www.gtk.org/introspection/glib/1.0\"");
	_tmp74_ = self->priv->stream;
	fprintf (_tmp74_, ">\n");
	_tmp75_ = self->priv->indent;
	self->priv->indent = _tmp75_ + 1;
	vala_gir_writer_write_includes (self);
	_tmp76_ = self->priv->indent;
	self->priv->indent = _tmp76_ - 1;
	_tmp77_ = self->priv->stream;
	_tmp78_ = self->priv->buffer;
	_tmp79_ = _tmp78_->str;
	fputs (_tmp79_, _tmp77_);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
	if (file_exists) {
		gboolean changed = FALSE;
		changed = TRUE;
		{
			GMappedFile* old_file = NULL;
			const gchar* _tmp80_;
			GMappedFile* _tmp81_;
			GMappedFile* new_file = NULL;
			const gchar* _tmp82_;
			GMappedFile* _tmp83_;
			gsize len = 0UL;
			GMappedFile* _tmp84_;
			GMappedFile* _tmp85_;
			_tmp80_ = filename;
			_tmp81_ = g_mapped_file_new (_tmp80_, FALSE, &_inner_error0_);
			old_file = _tmp81_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (header);
				_g_free0 (_tmp54_);
				_g_free0 (temp_filename);
				_g_free0 (filename);
				_vala_code_node_unref0 (glib_ns);
				_vala_code_node_unref0 (root_symbol);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp82_ = temp_filename;
			_tmp83_ = g_mapped_file_new (_tmp82_, FALSE, &_inner_error0_);
			new_file = _tmp83_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_mapped_file_unref0 (old_file);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (header);
				_g_free0 (_tmp54_);
				_g_free0 (temp_filename);
				_g_free0 (filename);
				_vala_code_node_unref0 (glib_ns);
				_vala_code_node_unref0 (root_symbol);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp84_ = old_file;
			len = g_mapped_file_get_length (_tmp84_);
			_tmp85_ = new_file;
			if (len == g_mapped_file_get_length (_tmp85_)) {
				GMappedFile* _tmp86_;
				gchar* _tmp87_;
				GMappedFile* _tmp88_;
				gchar* _tmp89_;
				_tmp86_ = old_file;
				_tmp87_ = g_mapped_file_get_contents (_tmp86_);
				_tmp88_ = new_file;
				_tmp89_ = g_mapped_file_get_contents (_tmp88_);
				if (memcmp (_tmp87_, _tmp89_, len) == 0) {
					changed = FALSE;
				}
			}
			_g_mapped_file_unref0 (old_file);
			old_file = NULL;
			_g_mapped_file_unref0 (new_file);
			new_file = NULL;
			_g_mapped_file_unref0 (new_file);
			_g_mapped_file_unref0 (old_file);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (header);
			_g_free0 (_tmp54_);
			_g_free0 (temp_filename);
			_g_free0 (filename);
			_vala_code_node_unref0 (glib_ns);
			_vala_code_node_unref0 (root_symbol);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (changed) {
			const gchar* _tmp90_;
			const gchar* _tmp91_;
			_tmp90_ = temp_filename;
			_tmp91_ = filename;
			g_rename (_tmp90_, _tmp91_);
		} else {
			const gchar* _tmp92_;
			_tmp92_ = temp_filename;
			g_unlink (_tmp92_);
		}
	}
	{
		ValaIterator* _ns_it = NULL;
		ValaHashSet* _tmp93_;
		ValaIterator* _tmp94_;
		_tmp93_ = self->priv->unannotated_namespaces;
		_tmp94_ = vala_iterable_iterator ((ValaIterable*) _tmp93_);
		_ns_it = _tmp94_;
		while (TRUE) {
			ValaIterator* _tmp95_;
			ValaNamespace* ns = NULL;
			ValaIterator* _tmp96_;
			gpointer _tmp97_;
			ValaHashSet* _tmp98_;
			ValaNamespace* _tmp99_;
			_tmp95_ = _ns_it;
			if (!vala_iterator_next (_tmp95_)) {
				break;
			}
			_tmp96_ = _ns_it;
			_tmp97_ = vala_iterator_get (_tmp96_);
			ns = (ValaNamespace*) _tmp97_;
			_tmp98_ = self->priv->our_namespaces;
			_tmp99_ = ns;
			if (!vala_collection_contains ((ValaCollection*) _tmp98_, _tmp99_)) {
				ValaNamespace* _tmp100_;
				ValaSourceReference* _tmp101_;
				ValaSourceReference* _tmp102_;
				ValaNamespace* _tmp103_;
				const gchar* _tmp104_;
				const gchar* _tmp105_;
				_tmp100_ = ns;
				_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp100_);
				_tmp102_ = _tmp101_;
				_tmp103_ = ns;
				_tmp104_ = vala_symbol_get_name ((ValaSymbol*) _tmp103_);
				_tmp105_ = _tmp104_;
				vala_report_warning (_tmp102_, "Namespace `%s' does not have a GIR namespace and version annotation", _tmp105_);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	{
		ValaIterator* _ns_it = NULL;
		ValaHashSet* _tmp106_;
		ValaIterator* _tmp107_;
		_tmp106_ = self->priv->our_namespaces;
		_tmp107_ = vala_iterable_iterator ((ValaIterable*) _tmp106_);
		_ns_it = _tmp107_;
		while (TRUE) {
			ValaIterator* _tmp108_;
			ValaNamespace* ns = NULL;
			ValaIterator* _tmp109_;
			gpointer _tmp110_;
			ValaNamespace* _tmp111_;
			ValaSourceReference* _tmp112_;
			ValaSourceReference* _tmp113_;
			ValaSourceFile* _tmp114_;
			ValaSourceFile* _tmp115_;
			ValaNamespace* _tmp116_;
			ValaSourceReference* _tmp117_;
			ValaSourceReference* _tmp118_;
			ValaSourceFile* _tmp119_;
			ValaSourceFile* _tmp120_;
			_tmp108_ = _ns_it;
			if (!vala_iterator_next (_tmp108_)) {
				break;
			}
			_tmp109_ = _ns_it;
			_tmp110_ = vala_iterator_get (_tmp109_);
			ns = (ValaNamespace*) _tmp110_;
			_tmp111_ = ns;
			_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp111_);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_source_reference_get_file (_tmp113_);
			_tmp115_ = _tmp114_;
			vala_source_file_set_gir_namespace (_tmp115_, gir_namespace);
			_tmp116_ = ns;
			_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp116_);
			_tmp118_ = _tmp117_;
			_tmp119_ = vala_source_reference_get_file (_tmp118_);
			_tmp120_ = _tmp119_;
			vala_source_file_set_gir_version (_tmp120_, gir_version);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	_tmp121_ = self->priv->our_namespaces;
	_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
	_tmp123_ = _tmp122_;
	if (_tmp123_ == 0) {
		vala_report_error (NULL, "No suitable namespace found to export for GIR");
	}
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_g_free0 (header);
	_g_free0 (_tmp54_);
	_g_free0 (temp_filename);
	_g_free0 (filename);
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (root_symbol);
}

static void
vala_gir_writer_write_doc (ValaGIRWriter* self,
                           const gchar* comment)
{
	g_return_if_fail (self != NULL);
	if (comment != NULL) {
		GString* _tmp0_;
		GString* _tmp1_;
		GString* _tmp2_;
		vala_gir_writer_write_indent (self);
		_tmp0_ = self->priv->buffer;
		g_string_append (_tmp0_, "<doc xml:whitespace=\"preserve\">");
		_tmp1_ = self->priv->buffer;
		g_string_append (_tmp1_, comment);
		_tmp2_ = self->priv->buffer;
		g_string_append (_tmp2_, "</doc>\n");
	}
}

static void
vala_gir_writer_write_package (ValaGIRWriter* self,
                               const gchar* package)
{
	GString* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	g_string_append_printf (_tmp0_, "<package name=\"%s\"/>\n", package);
}

static void
vala_gir_writer_write_c_includes (ValaGIRWriter* self,
                                  ValaNamespace* ns)
{
	ValaSet* header_filenames = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_, _tmp1_);
	header_filenames = (ValaSet*) _tmp2_;
	_tmp3_ = vala_get_ccode_header_filenames ((ValaSymbol*) ns);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ",", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_free0 (_tmp4_);
	{
		gchar** c_header_filename_collection = NULL;
		gint c_header_filename_collection_length1 = 0;
		gint _c_header_filename_collection_size_ = 0;
		gint c_header_filename_it = 0;
		c_header_filename_collection = _tmp7_;
		c_header_filename_collection_length1 = _tmp7__length1;
		for (c_header_filename_it = 0; c_header_filename_it < c_header_filename_collection_length1; c_header_filename_it = c_header_filename_it + 1) {
			const gchar* c_header_filename = NULL;
			c_header_filename = c_header_filename_collection[c_header_filename_it];
			{
				ValaSet* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = header_filenames;
				_tmp9_ = c_header_filename;
				vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
			}
		}
		c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaIterator* _symbol_it = NULL;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMap* _tmp12_;
		ValaCollection* _tmp13_;
		ValaCollection* _tmp14_;
		ValaIterator* _tmp15_;
		ValaIterator* _tmp16_;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) ns);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_scope_get_symbol_table (_tmp11_);
		_tmp13_ = vala_map_get_values (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_iterable_iterator ((ValaIterable*) _tmp14_);
		_tmp16_ = _tmp15_;
		_vala_iterable_unref0 (_tmp14_);
		_symbol_it = _tmp16_;
		while (TRUE) {
			ValaIterator* _tmp17_;
			ValaSymbol* symbol = NULL;
			ValaIterator* _tmp18_;
			gpointer _tmp19_;
			ValaSymbol* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaSymbol* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar** _tmp26_;
			gchar** _tmp27_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			_tmp17_ = _symbol_it;
			if (!vala_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _symbol_it;
			_tmp19_ = vala_iterator_get (_tmp18_);
			symbol = (ValaSymbol*) _tmp19_;
			_tmp20_ = symbol;
			_tmp21_ = vala_symbol_get_external_package (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				_vala_code_node_unref0 (symbol);
				continue;
			}
			_tmp23_ = symbol;
			_tmp24_ = vala_get_ccode_header_filenames (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, ",", 0);
			_tmp28_ = _tmp27_;
			_tmp28__length1 = _vala_array_length (_tmp26_);
			_g_free0 (_tmp25_);
			{
				gchar** c_header_filename_collection = NULL;
				gint c_header_filename_collection_length1 = 0;
				gint _c_header_filename_collection_size_ = 0;
				gint c_header_filename_it = 0;
				c_header_filename_collection = _tmp28_;
				c_header_filename_collection_length1 = _tmp28__length1;
				for (c_header_filename_it = 0; c_header_filename_it < c_header_filename_collection_length1; c_header_filename_it = c_header_filename_it + 1) {
					const gchar* c_header_filename = NULL;
					c_header_filename = c_header_filename_collection[c_header_filename_it];
					{
						ValaSet* _tmp29_;
						const gchar* _tmp30_;
						_tmp29_ = header_filenames;
						_tmp30_ = c_header_filename;
						vala_collection_add ((ValaCollection*) _tmp29_, _tmp30_);
					}
				}
				c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_vala_code_node_unref0 (symbol);
		}
		_vala_iterator_unref0 (_symbol_it);
	}
	{
		ValaIterator* _c_header_filename_it = NULL;
		ValaSet* _tmp31_;
		ValaIterator* _tmp32_;
		_tmp31_ = header_filenames;
		_tmp32_ = vala_iterable_iterator ((ValaIterable*) _tmp31_);
		_c_header_filename_it = _tmp32_;
		while (TRUE) {
			ValaIterator* _tmp33_;
			gchar* c_header_filename = NULL;
			ValaIterator* _tmp34_;
			gpointer _tmp35_;
			const gchar* _tmp36_;
			_tmp33_ = _c_header_filename_it;
			if (!vala_iterator_next (_tmp33_)) {
				break;
			}
			_tmp34_ = _c_header_filename_it;
			_tmp35_ = vala_iterator_get (_tmp34_);
			c_header_filename = (gchar*) _tmp35_;
			_tmp36_ = c_header_filename;
			vala_gir_writer_write_c_include (self, _tmp36_);
			_g_free0 (c_header_filename);
		}
		_vala_iterator_unref0 (_c_header_filename_it);
	}
	_vala_iterable_unref0 (header_filenames);
}

static void
vala_gir_writer_write_c_include (ValaGIRWriter* self,
                                 const gchar* name)
{
	GString* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	g_string_append_printf (_tmp0_, "<c:include name=\"%s\"/>\n", name);
}

static void
vala_gir_writer_real_visit_source_file (ValaCodeVisitor* base,
                                        ValaSourceFile* source_file)
{
	ValaGIRWriter * self;
	ValaSourceFileType _tmp0_;
	ValaSourceFileType _tmp1_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_file_type (source_file);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_SOURCE_FILE_TYPE_PACKAGE) {
		return;
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp2_;
		gint _node_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _node_index = 0;
		_tmp2_ = vala_source_file_get_nodes (source_file);
		_node_list = _tmp2_;
		_tmp3_ = _node_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_node_size = _tmp5_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaCodeNode* _tmp11_;
			_node_index = _node_index + 1;
			_tmp6_ = _node_index;
			_tmp7_ = _node_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _node_list;
			_tmp9_ = vala_list_get (_tmp8_, _node_index);
			node = (ValaCodeNode*) _tmp9_;
			_tmp11_ = node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_NAMESPACE)) {
				ValaCodeNode* _tmp12_;
				ValaSymbol* _tmp13_;
				ValaSymbol* _tmp14_;
				ValaCodeContext* _tmp15_;
				ValaNamespace* _tmp16_;
				ValaNamespace* _tmp17_;
				_tmp12_ = node;
				_tmp13_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_NAMESPACE, ValaNamespace));
				_tmp14_ = _tmp13_;
				_tmp15_ = self->priv->context;
				_tmp16_ = vala_code_context_get_root (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp10_ = _tmp14_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_SYMBOL, ValaSymbol);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaAttribute* a = NULL;
				ValaCodeNode* _tmp18_;
				ValaAttribute* _tmp19_;
				ValaAttribute* _tmp20_;
				gboolean _tmp21_ = FALSE;
				ValaAttribute* _tmp22_;
				gboolean _tmp34_ = FALSE;
				ValaAttribute* _tmp35_;
				_tmp18_ = node;
				_tmp19_ = vala_code_node_get_attribute (_tmp18_, "CCode");
				_tmp20_ = _vala_code_node_ref0 (_tmp19_);
				a = _tmp20_;
				_tmp22_ = a;
				if (_tmp22_ != NULL) {
					ValaAttribute* _tmp23_;
					_tmp23_ = a;
					_tmp21_ = vala_attribute_has_argument (_tmp23_, "gir_namespace");
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					gchar* new_gir = NULL;
					ValaAttribute* _tmp24_;
					gchar* _tmp25_;
					gchar* old_gir = NULL;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gboolean _tmp29_ = FALSE;
					const gchar* _tmp30_;
					const gchar* _tmp33_;
					_tmp24_ = a;
					_tmp25_ = vala_attribute_get_string (_tmp24_, "gir_namespace", NULL);
					new_gir = _tmp25_;
					_tmp26_ = vala_source_file_get_gir_namespace (source_file);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strdup (_tmp27_);
					old_gir = _tmp28_;
					_tmp30_ = old_gir;
					if (_tmp30_ != NULL) {
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						_tmp31_ = old_gir;
						_tmp32_ = new_gir;
						_tmp29_ = g_strcmp0 (_tmp31_, _tmp32_) != 0;
					} else {
						_tmp29_ = FALSE;
					}
					if (_tmp29_) {
						vala_source_file_set_gir_ambiguous (source_file, TRUE);
					}
					_tmp33_ = new_gir;
					vala_source_file_set_gir_namespace (source_file, _tmp33_);
					_g_free0 (old_gir);
					_g_free0 (new_gir);
				}
				_tmp35_ = a;
				if (_tmp35_ != NULL) {
					ValaAttribute* _tmp36_;
					_tmp36_ = a;
					_tmp34_ = vala_attribute_has_argument (_tmp36_, "gir_version");
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					ValaAttribute* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp37_ = a;
					_tmp38_ = vala_attribute_get_string (_tmp37_, "gir_version", NULL);
					_tmp39_ = _tmp38_;
					vala_source_file_set_gir_version (source_file, _tmp39_);
					_g_free0 (_tmp39_);
				}
				_vala_code_node_unref0 (a);
				_vala_code_node_unref0 (node);
				break;
			}
			_vala_code_node_unref0 (node);
		}
	}
}

static void
vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base,
                                      ValaNamespace* ns)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaHashSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* old_gir_namespace = NULL;
	gchar* _tmp19_;
	gchar* old_gir_version = NULL;
	gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* cprefix = NULL;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp43_;
	gchar* csymbol_prefix = NULL;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	GString* _tmp52_;
	gint _tmp53_;
	ValaArrayList* _tmp54_;
	ValaArrayList* _tmp55_;
	gpointer _tmp56_;
	ValaSymbol* _tmp57_;
	gint _tmp58_;
	GString* _tmp59_;
	ValaHashSet* _tmp60_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_is_visibility (self, (ValaSymbol*) ns)) {
		return;
	}
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaArrayList* _tmp4_;
		ValaArrayList* _tmp5_;
		gpointer _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp4_ = self->priv->hierarchy;
		vala_list_insert ((ValaList*) _tmp4_, 0, (ValaSymbol*) ns);
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		_tmp5_ = self->priv->hierarchy;
		_tmp6_ = vala_list_remove_at ((ValaList*) _tmp5_, 0);
		_tmp7_ = (ValaSymbol*) _tmp6_;
		_vala_code_node_unref0 (_tmp7_);
		return;
	}
	_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) ns);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_symbol_get_name (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		return;
	}
	_tmp12_ = self->priv->our_namespaces;
	_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ > 0) {
		ValaSourceReference* _tmp15_;
		ValaSourceReference* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp18_ = _tmp17_;
		vala_report_error (_tmp16_, "Secondary top-level namespace `%s' is not supported by GIR format", _tmp18_);
		return;
	}
	_tmp19_ = vala_code_node_get_attribute_string ((ValaCodeNode*) ns, "CCode", "gir_namespace", NULL);
	old_gir_namespace = _tmp19_;
	_tmp20_ = vala_code_node_get_attribute_string ((ValaCodeNode*) ns, "CCode", "gir_version", NULL);
	old_gir_version = _tmp20_;
	_tmp23_ = old_gir_namespace;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = old_gir_namespace;
		_tmp25_ = self->priv->gir_namespace;
		_tmp22_ = g_strcmp0 (_tmp24_, _tmp25_) != 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		gboolean _tmp26_ = FALSE;
		const gchar* _tmp27_;
		_tmp27_ = old_gir_version;
		if (_tmp27_ != NULL) {
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp28_ = old_gir_version;
			_tmp29_ = self->priv->gir_version;
			_tmp26_ = g_strcmp0 (_tmp28_, _tmp29_) != 0;
		} else {
			_tmp26_ = FALSE;
		}
		_tmp21_ = _tmp26_;
	}
	if (_tmp21_) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp33_ = _tmp32_;
		vala_report_warning (_tmp31_, "Replace conflicting CCode.gir_* attributes for namespace `%s'", _tmp33_);
	}
	_tmp34_ = self->priv->gir_namespace;
	vala_code_node_set_attribute_string ((ValaCodeNode*) ns, "CCode", "gir_namespace", _tmp34_, NULL);
	_tmp35_ = self->priv->gir_version;
	vala_code_node_set_attribute_string ((ValaCodeNode*) ns, "CCode", "gir_version", _tmp35_, NULL);
	vala_gir_writer_write_c_includes (self, ns);
	vala_gir_writer_write_indent (self);
	_tmp36_ = self->priv->buffer;
	_tmp37_ = self->priv->gir_namespace;
	_tmp38_ = self->priv->gir_version;
	g_string_append_printf (_tmp36_, "<namespace name=\"%s\" version=\"%s\"", _tmp37_, _tmp38_);
	_tmp39_ = vala_get_ccode_prefix ((ValaSymbol*) ns);
	cprefix = _tmp39_;
	_tmp40_ = self->priv->gir_shared_library;
	if (_tmp40_ != NULL) {
		GString* _tmp41_;
		const gchar* _tmp42_;
		_tmp41_ = self->priv->buffer;
		_tmp42_ = self->priv->gir_shared_library;
		g_string_append_printf (_tmp41_, " shared-library=\"%s\"", _tmp42_);
	}
	_tmp43_ = cprefix;
	if (_tmp43_ != NULL) {
		GString* _tmp44_;
		const gchar* _tmp45_;
		GString* _tmp46_;
		const gchar* _tmp47_;
		_tmp44_ = self->priv->buffer;
		_tmp45_ = cprefix;
		g_string_append_printf (_tmp44_, " c:prefix=\"%s\"", _tmp45_);
		_tmp46_ = self->priv->buffer;
		_tmp47_ = cprefix;
		g_string_append_printf (_tmp46_, " c:identifier-prefixes=\"%s\"", _tmp47_);
	}
	_tmp48_ = vala_get_ccode_lower_case_suffix ((ValaSymbol*) ns);
	csymbol_prefix = _tmp48_;
	_tmp49_ = csymbol_prefix;
	if (_tmp49_ != NULL) {
		GString* _tmp50_;
		const gchar* _tmp51_;
		_tmp50_ = self->priv->buffer;
		_tmp51_ = csymbol_prefix;
		g_string_append_printf (_tmp50_, " c:symbol-prefixes=\"%s\"", _tmp51_);
	}
	_tmp52_ = self->priv->buffer;
	g_string_append_printf (_tmp52_, ">\n");
	_tmp53_ = self->priv->indent;
	self->priv->indent = _tmp53_ + 1;
	_tmp54_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp54_, 0, (ValaSymbol*) ns);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
	_tmp55_ = self->priv->hierarchy;
	_tmp56_ = vala_list_remove_at ((ValaList*) _tmp55_, 0);
	_tmp57_ = (ValaSymbol*) _tmp56_;
	_vala_code_node_unref0 (_tmp57_);
	_tmp58_ = self->priv->indent;
	self->priv->indent = _tmp58_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp59_ = self->priv->buffer;
	g_string_append_printf (_tmp59_, "</namespace>\n");
	_tmp60_ = self->priv->our_namespaces;
	vala_collection_add ((ValaCollection*) _tmp60_, ns);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (csymbol_prefix);
	_g_free0 (cprefix);
	_g_free0 (old_gir_version);
	_g_free0 (old_gir_namespace);
}

static void
vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self,
                                         ValaSymbol* symbol)
{
	ValaVersionAttribute* _tmp1_;
	ValaVersionAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaVersionAttribute* _tmp18_;
	ValaVersionAttribute* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	if (!vala_gir_writer_is_introspectable (self, symbol)) {
		GString* _tmp0_;
		_tmp0_ = self->priv->buffer;
		g_string_append_printf (_tmp0_, " introspectable=\"0\"");
	}
	_tmp1_ = vala_symbol_get_version (symbol);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_version_attribute_get_deprecated (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GString* _tmp5_;
		ValaVersionAttribute* _tmp6_;
		ValaVersionAttribute* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp5_ = self->priv->buffer;
		g_string_append_printf (_tmp5_, " deprecated=\"1\"");
		_tmp6_ = vala_symbol_get_version (symbol);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_version_attribute_get_deprecated_since (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_ != NULL;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			GString* _tmp12_;
			ValaVersionAttribute* _tmp13_;
			ValaVersionAttribute* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp12_ = self->priv->buffer;
			_tmp13_ = vala_symbol_get_version (symbol);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_version_attribute_get_deprecated_since (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			g_string_append_printf (_tmp12_, " deprecated-version=\"%s\"", _tmp17_);
			_g_free0 (_tmp17_);
		}
	}
	_tmp18_ = vala_symbol_get_version (symbol);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_version_attribute_get_since (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_ != NULL;
	_g_free0 (_tmp22_);
	if (_tmp23_) {
		GString* _tmp24_;
		ValaVersionAttribute* _tmp25_;
		ValaVersionAttribute* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp24_ = self->priv->buffer;
		_tmp25_ = vala_symbol_get_version (symbol);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_version_attribute_get_since (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		g_string_append_printf (_tmp24_, " version=\"%s\"", _tmp29_);
		_g_free0 (_tmp29_);
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
vala_gir_writer_real_visit_class (ValaCodeVisitor* base,
                                  ValaClass* cl)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaArrayList* _tmp2_;
	gpointer _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) cl)) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) cl)) {
		return;
	}
	_tmp2_ = self->priv->hierarchy;
	_tmp3_ = vala_list_get ((ValaList*) _tmp2_, 0);
	_tmp4_ = (ValaSymbol*) _tmp3_;
	_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp4_);
	if (_tmp5_) {
		ValaArrayList* _tmp6_;
		_tmp6_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp6_, (ValaCodeNode*) cl);
		return;
	}
	_tmp7_ = vala_class_get_is_compact (cl);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		gchar* gtype_struct_name = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GString* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GString* _tmp16_;
		const gchar* _tmp17_;
		ValaClass* _tmp18_;
		ValaClass* _tmp19_;
		gboolean _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp41_;
		gboolean _tmp42_;
		GString* _tmp44_;
		gint _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		GString* _tmp67_;
		gint _tmp68_;
		ValaClass* _tmp69_;
		ValaClass* _tmp70_;
		gint _tmp87_;
		GString* _tmp88_;
		ValaClass* _tmp89_;
		ValaClass* _tmp90_;
		ValaCodeContext* _tmp96_;
		gboolean _tmp97_;
		gboolean _tmp98_;
		gboolean _tmp108_ = FALSE;
		ValaClass* _tmp109_;
		ValaClass* _tmp110_;
		ValaArrayList* _tmp123_;
		ValaArrayList* _tmp124_;
		gpointer _tmp125_;
		ValaSymbol* _tmp126_;
		ValaCodeContext* _tmp127_;
		gboolean _tmp128_;
		gboolean _tmp129_;
		gint _tmp139_;
		GString* _tmp140_;
		GString* _tmp141_;
		const gchar* _tmp142_;
		GString* _tmp143_;
		gchar* _tmp144_;
		gchar* _tmp145_;
		GString* _tmp146_;
		gint _tmp147_;
		GString* _tmp148_;
		gint _tmp149_;
		ValaClass* _tmp150_;
		ValaClass* _tmp151_;
		gint _tmp165_;
		GString* _tmp166_;
		gint _tmp286_;
		GString* _tmp287_;
		GString* _tmp288_;
		gchar* _tmp289_;
		gchar* _tmp290_;
		gchar* _tmp291_;
		gchar* _tmp292_;
		_tmp9_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "Class", NULL);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		gtype_struct_name = _tmp12_;
		vala_gir_writer_write_indent (self);
		_tmp13_ = self->priv->buffer;
		_tmp14_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp15_ = _tmp14_;
		g_string_append_printf (_tmp13_, "<class name=\"%s\"", _tmp15_);
		_g_free0 (_tmp15_);
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) cl, TRUE);
		_tmp16_ = self->priv->buffer;
		_tmp17_ = gtype_struct_name;
		g_string_append_printf (_tmp16_, " glib:type-struct=\"%s\"", _tmp17_);
		_tmp18_ = vala_class_get_base_class (cl);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == NULL) {
			GString* _tmp20_;
			GString* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GString* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GString* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			GString* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp20_ = self->priv->buffer;
			g_string_append_printf (_tmp20_, " glib:fundamental=\"1\"");
			_tmp21_ = self->priv->buffer;
			_tmp22_ = vala_get_ccode_ref_function ((ValaTypeSymbol*) cl);
			_tmp23_ = _tmp22_;
			g_string_append_printf (_tmp21_, " glib:ref-func=\"%s\"", _tmp23_);
			_g_free0 (_tmp23_);
			_tmp24_ = self->priv->buffer;
			_tmp25_ = vala_get_ccode_unref_function ((ValaObjectTypeSymbol*) cl);
			_tmp26_ = _tmp25_;
			g_string_append_printf (_tmp24_, " glib:unref-func=\"%s\"", _tmp26_);
			_g_free0 (_tmp26_);
			_tmp27_ = self->priv->buffer;
			_tmp28_ = vala_get_ccode_set_value_function ((ValaCodeNode*) cl);
			_tmp29_ = _tmp28_;
			g_string_append_printf (_tmp27_, " glib:set-value-func=\"%s\"", _tmp29_);
			_g_free0 (_tmp29_);
			_tmp30_ = self->priv->buffer;
			_tmp31_ = vala_get_ccode_get_value_function ((ValaCodeNode*) cl);
			_tmp32_ = _tmp31_;
			g_string_append_printf (_tmp30_, " glib:get-value-func=\"%s\"", _tmp32_);
			_g_free0 (_tmp32_);
		} else {
			GString* _tmp33_;
			ValaClass* _tmp34_;
			ValaClass* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp33_ = self->priv->buffer;
			_tmp34_ = vala_class_get_base_class (cl);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			g_string_append_printf (_tmp33_, " parent=\"%s\"", _tmp37_);
			_g_free0 (_tmp37_);
		}
		_tmp38_ = vala_class_get_is_abstract (cl);
		_tmp39_ = _tmp38_;
		if (_tmp39_) {
			GString* _tmp40_;
			_tmp40_ = self->priv->buffer;
			g_string_append_printf (_tmp40_, " abstract=\"1\"");
		}
		_tmp41_ = vala_class_get_is_sealed (cl);
		_tmp42_ = _tmp41_;
		if (_tmp42_) {
			GString* _tmp43_;
			_tmp43_ = self->priv->buffer;
			g_string_append_printf (_tmp43_, " final=\"1\"");
		}
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cl);
		_tmp44_ = self->priv->buffer;
		g_string_append_printf (_tmp44_, ">\n");
		_tmp45_ = self->priv->indent;
		self->priv->indent = _tmp45_ + 1;
		_tmp46_ = vala_gir_writer_get_class_comment (self, cl);
		_tmp47_ = _tmp46_;
		vala_gir_writer_write_doc (self, _tmp47_);
		_g_free0 (_tmp47_);
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp48_;
			gint _base_type_size = 0;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _base_type_index = 0;
			_tmp48_ = vala_class_get_base_types (cl);
			_base_type_list = _tmp48_;
			_tmp49_ = _base_type_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_base_type_size = _tmp51_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp52_;
				gint _tmp53_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp54_;
				gpointer _tmp55_;
				ValaObjectType* object_type = NULL;
				ValaDataType* _tmp56_;
				ValaObjectType* _tmp57_;
				ValaObjectType* _tmp58_;
				ValaTypeSymbol* _tmp59_;
				ValaTypeSymbol* _tmp60_;
				_base_type_index = _base_type_index + 1;
				_tmp52_ = _base_type_index;
				_tmp53_ = _base_type_size;
				if (!(_tmp52_ < _tmp53_)) {
					break;
				}
				_tmp54_ = _base_type_list;
				_tmp55_ = vala_list_get (_tmp54_, _base_type_index);
				base_type = (ValaDataType*) _tmp55_;
				_tmp56_ = base_type;
				_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				object_type = _tmp57_;
				_tmp58_ = object_type;
				_tmp59_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp58_);
				_tmp60_ = _tmp59_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_INTERFACE)) {
					GString* _tmp61_;
					ValaObjectType* _tmp62_;
					ValaTypeSymbol* _tmp63_;
					ValaTypeSymbol* _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					vala_gir_writer_write_indent (self);
					_tmp61_ = self->priv->buffer;
					_tmp62_ = object_type;
					_tmp63_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = vala_gir_writer_gi_type_name (self, _tmp64_);
					_tmp66_ = _tmp65_;
					g_string_append_printf (_tmp61_, "<implements name=\"%s\"/>\n", _tmp66_);
					_g_free0 (_tmp66_);
				}
				_vala_code_node_unref0 (object_type);
				_vala_code_node_unref0 (base_type);
			}
		}
		vala_gir_writer_write_indent (self);
		_tmp67_ = self->priv->buffer;
		g_string_append_printf (_tmp67_, "<field name=\"parent_instance\" readable=\"0\" private=\"1\">\n");
		_tmp68_ = self->priv->indent;
		self->priv->indent = _tmp68_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp69_ = vala_class_get_base_class (cl);
		_tmp70_ = _tmp69_;
		if (_tmp70_ == NULL) {
			GString* _tmp71_;
			ValaTypeSymbol* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			ValaTypeSymbol* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			_tmp71_ = self->priv->buffer;
			_tmp72_ = self->priv->gtypeinstance_type;
			_tmp73_ = vala_gir_writer_gi_type_name (self, _tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = self->priv->gtypeinstance_type;
			_tmp76_ = vala_get_ccode_name ((ValaCodeNode*) _tmp75_);
			_tmp77_ = _tmp76_;
			g_string_append_printf (_tmp71_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp74_, _tmp77_);
			_g_free0 (_tmp77_);
			_g_free0 (_tmp74_);
		} else {
			GString* _tmp78_;
			ValaClass* _tmp79_;
			ValaClass* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			ValaClass* _tmp83_;
			ValaClass* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp78_ = self->priv->buffer;
			_tmp79_ = vala_class_get_base_class (cl);
			_tmp80_ = _tmp79_;
			_tmp81_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_class_get_base_class (cl);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_get_ccode_name ((ValaCodeNode*) _tmp84_);
			_tmp86_ = _tmp85_;
			g_string_append_printf (_tmp78_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp82_, _tmp86_);
			_g_free0 (_tmp86_);
			_g_free0 (_tmp82_);
		}
		_tmp87_ = self->priv->indent;
		self->priv->indent = _tmp87_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp88_ = self->priv->buffer;
		g_string_append_printf (_tmp88_, "</field>\n");
		_tmp89_ = vala_class_get_base_class (cl);
		_tmp90_ = _tmp89_;
		if (_tmp90_ == NULL) {
			GString* _tmp91_;
			gint _tmp92_;
			GString* _tmp93_;
			gint _tmp94_;
			GString* _tmp95_;
			vala_gir_writer_write_indent (self);
			_tmp91_ = self->priv->buffer;
			g_string_append_printf (_tmp91_, "<field name=\"ref_count\">\n");
			_tmp92_ = self->priv->indent;
			self->priv->indent = _tmp92_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp93_ = self->priv->buffer;
			g_string_append_printf (_tmp93_, "<type name=\"gint\" c:type=\"volatile int\"/>\n");
			_tmp94_ = self->priv->indent;
			self->priv->indent = _tmp94_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp95_ = self->priv->buffer;
			g_string_append_printf (_tmp95_, "</field>\n");
		}
		_tmp96_ = self->priv->context;
		_tmp97_ = vala_code_context_get_abi_stability (_tmp96_);
		_tmp98_ = _tmp97_;
		if (!_tmp98_) {
			GString* _tmp99_;
			gint _tmp100_;
			GString* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gint _tmp106_;
			GString* _tmp107_;
			vala_gir_writer_write_indent (self);
			_tmp99_ = self->priv->buffer;
			g_string_append_printf (_tmp99_, "<field name=\"priv\" readable=\"0\" private=\"1\">\n");
			_tmp100_ = self->priv->indent;
			self->priv->indent = _tmp100_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp101_ = self->priv->buffer;
			_tmp102_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_get_ccode_name ((ValaCodeNode*) cl);
			_tmp105_ = _tmp104_;
			g_string_append_printf (_tmp101_, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", _tmp103_, _tmp105_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp103_);
			_tmp106_ = self->priv->indent;
			self->priv->indent = _tmp106_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp107_ = self->priv->buffer;
			g_string_append_printf (_tmp107_, "</field>\n");
		}
		_tmp109_ = vala_class_get_base_class (cl);
		_tmp110_ = _tmp109_;
		if (_tmp110_ != NULL) {
			ValaClass* _tmp111_;
			ValaClass* _tmp112_;
			ValaTypeSymbol* _tmp113_;
			_tmp111_ = vala_class_get_base_class (cl);
			_tmp112_ = _tmp111_;
			_tmp113_ = self->priv->gobject_type;
			_tmp108_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp112_, _tmp113_);
		} else {
			_tmp108_ = FALSE;
		}
		if (_tmp108_) {
			{
				ValaList* _p_list = NULL;
				ValaList* _tmp114_;
				gint _p_size = 0;
				ValaList* _tmp115_;
				gint _tmp116_;
				gint _tmp117_;
				gint _p_index = 0;
				_tmp114_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
				_p_list = _tmp114_;
				_tmp115_ = _p_list;
				_tmp116_ = vala_collection_get_size ((ValaCollection*) _tmp115_);
				_tmp117_ = _tmp116_;
				_p_size = _tmp117_;
				_p_index = -1;
				while (TRUE) {
					gint _tmp118_;
					gint _tmp119_;
					ValaTypeParameter* p = NULL;
					ValaList* _tmp120_;
					gpointer _tmp121_;
					ValaTypeParameter* _tmp122_;
					_p_index = _p_index + 1;
					_tmp118_ = _p_index;
					_tmp119_ = _p_size;
					if (!(_tmp118_ < _tmp119_)) {
						break;
					}
					_tmp120_ = _p_list;
					_tmp121_ = vala_list_get (_tmp120_, _p_index);
					p = (ValaTypeParameter*) _tmp121_;
					_tmp122_ = p;
					vala_gir_writer_write_type_parameter (self, _tmp122_, "property");
					_vala_code_node_unref0 (p);
				}
			}
		}
		_tmp123_ = self->priv->hierarchy;
		vala_list_insert ((ValaList*) _tmp123_, 0, (ValaSymbol*) cl);
		vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
		_tmp124_ = self->priv->hierarchy;
		_tmp125_ = vala_list_remove_at ((ValaList*) _tmp124_, 0);
		_tmp126_ = (ValaSymbol*) _tmp125_;
		_vala_code_node_unref0 (_tmp126_);
		_tmp127_ = self->priv->context;
		_tmp128_ = vala_code_context_get_abi_stability (_tmp127_);
		_tmp129_ = _tmp128_;
		if (_tmp129_) {
			GString* _tmp130_;
			gint _tmp131_;
			GString* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			gint _tmp137_;
			GString* _tmp138_;
			vala_gir_writer_write_indent (self);
			_tmp130_ = self->priv->buffer;
			g_string_append_printf (_tmp130_, "<field name=\"priv\" readable=\"0\" private=\"1\">\n");
			_tmp131_ = self->priv->indent;
			self->priv->indent = _tmp131_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp132_ = self->priv->buffer;
			_tmp133_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
			_tmp134_ = _tmp133_;
			_tmp135_ = vala_get_ccode_name ((ValaCodeNode*) cl);
			_tmp136_ = _tmp135_;
			g_string_append_printf (_tmp132_, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", _tmp134_, _tmp136_);
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			_tmp137_ = self->priv->indent;
			self->priv->indent = _tmp137_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp138_ = self->priv->buffer;
			g_string_append_printf (_tmp138_, "</field>\n");
		}
		_tmp139_ = self->priv->indent;
		self->priv->indent = _tmp139_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp140_ = self->priv->buffer;
		g_string_append_printf (_tmp140_, "</class>\n");
		vala_gir_writer_write_indent (self);
		_tmp141_ = self->priv->buffer;
		_tmp142_ = gtype_struct_name;
		g_string_append_printf (_tmp141_, "<record name=\"%s\"", _tmp142_);
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) cl, "Class", FALSE);
		_tmp143_ = self->priv->buffer;
		_tmp144_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp145_ = _tmp144_;
		g_string_append_printf (_tmp143_, " glib:is-gtype-struct-for=\"%s\"", _tmp145_);
		_g_free0 (_tmp145_);
		_tmp146_ = self->priv->buffer;
		g_string_append_printf (_tmp146_, ">\n");
		_tmp147_ = self->priv->indent;
		self->priv->indent = _tmp147_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp148_ = self->priv->buffer;
		g_string_append_printf (_tmp148_, "<field name=\"parent_class\" readable=\"0\" private=\"1\">\n");
		_tmp149_ = self->priv->indent;
		self->priv->indent = _tmp149_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp150_ = vala_class_get_base_class (cl);
		_tmp151_ = _tmp150_;
		if (_tmp151_ == NULL) {
			GString* _tmp152_;
			ValaTypeSymbol* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			_tmp152_ = self->priv->buffer;
			_tmp153_ = self->priv->gtype_type;
			_tmp154_ = vala_get_ccode_name ((ValaCodeNode*) _tmp153_);
			_tmp155_ = _tmp154_;
			g_string_append_printf (_tmp152_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", "GObject.Type", _tmp155_);
			_g_free0 (_tmp155_);
		} else {
			GString* _tmp156_;
			ValaClass* _tmp157_;
			ValaClass* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			ValaClass* _tmp161_;
			ValaClass* _tmp162_;
			gchar* _tmp163_;
			gchar* _tmp164_;
			_tmp156_ = self->priv->buffer;
			_tmp157_ = vala_class_get_base_class (cl);
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp158_);
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_class_get_base_class (cl);
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_get_ccode_name ((ValaCodeNode*) _tmp162_);
			_tmp164_ = _tmp163_;
			g_string_append_printf (_tmp156_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", _tmp160_, _tmp164_);
			_g_free0 (_tmp164_);
			_g_free0 (_tmp160_);
		}
		_tmp165_ = self->priv->indent;
		self->priv->indent = _tmp165_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp166_ = self->priv->buffer;
		g_string_append_printf (_tmp166_, "</field>\n");
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp167_;
			gint _m_size = 0;
			ValaList* _tmp168_;
			gint _tmp169_;
			gint _tmp170_;
			gint _m_index = 0;
			_tmp167_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
			_m_list = _tmp167_;
			_tmp168_ = _m_list;
			_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
			_tmp170_ = _tmp169_;
			_m_size = _tmp170_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp171_;
				gint _tmp172_;
				ValaMethod* m = NULL;
				ValaList* _tmp173_;
				gpointer _tmp174_;
				gboolean _tmp175_ = FALSE;
				ValaMethod* _tmp176_;
				gboolean _tmp177_;
				gboolean _tmp178_;
				_m_index = _m_index + 1;
				_tmp171_ = _m_index;
				_tmp172_ = _m_size;
				if (!(_tmp171_ < _tmp172_)) {
					break;
				}
				_tmp173_ = _m_list;
				_tmp174_ = vala_list_get (_tmp173_, _m_index);
				m = (ValaMethod*) _tmp174_;
				_tmp176_ = m;
				_tmp177_ = vala_method_get_is_abstract (_tmp176_);
				_tmp178_ = _tmp177_;
				if (_tmp178_) {
					_tmp175_ = TRUE;
				} else {
					ValaMethod* _tmp179_;
					gboolean _tmp180_;
					gboolean _tmp181_;
					_tmp179_ = m;
					_tmp180_ = vala_method_get_is_virtual (_tmp179_);
					_tmp181_ = _tmp180_;
					_tmp175_ = _tmp181_;
				}
				if (_tmp175_) {
					ValaMethod* _tmp182_;
					gboolean _tmp183_;
					gboolean _tmp184_;
					_tmp182_ = m;
					_tmp183_ = vala_method_get_coroutine (_tmp182_);
					_tmp184_ = _tmp183_;
					if (_tmp184_) {
						gchar* finish_name = NULL;
						ValaMethod* _tmp185_;
						const gchar* _tmp186_;
						const gchar* _tmp187_;
						gchar* _tmp188_;
						const gchar* _tmp189_;
						const gchar* _tmp197_;
						gchar* _tmp198_;
						GString* _tmp199_;
						ValaMethod* _tmp200_;
						const gchar* _tmp201_;
						const gchar* _tmp202_;
						ValaMethod* _tmp203_;
						GString* _tmp204_;
						gint _tmp205_;
						ValaMethod* _tmp206_;
						ValaMethod* _tmp207_;
						const gchar* _tmp208_;
						const gchar* _tmp209_;
						ValaMethod* _tmp210_;
						gchar* _tmp211_;
						gchar* _tmp212_;
						ValaMethod* _tmp213_;
						ValaList* _tmp214_;
						ValaVoidType* _tmp215_;
						ValaVoidType* _tmp216_;
						gint _tmp217_;
						GString* _tmp218_;
						GString* _tmp219_;
						const gchar* _tmp220_;
						ValaMethod* _tmp221_;
						GString* _tmp222_;
						gint _tmp223_;
						ValaMethod* _tmp224_;
						const gchar* _tmp225_;
						ValaMethod* _tmp226_;
						gchar* _tmp227_;
						gchar* _tmp228_;
						ValaMethod* _tmp229_;
						ValaList* _tmp230_;
						ValaMethod* _tmp231_;
						ValaDataType* _tmp232_;
						ValaDataType* _tmp233_;
						ValaMethod* _tmp234_;
						gboolean _tmp235_;
						gboolean _tmp236_;
						gint _tmp237_;
						GString* _tmp238_;
						_tmp185_ = m;
						_tmp186_ = vala_symbol_get_name ((ValaSymbol*) _tmp185_);
						_tmp187_ = _tmp186_;
						_tmp188_ = g_strdup (_tmp187_);
						finish_name = _tmp188_;
						_tmp189_ = finish_name;
						if (g_str_has_suffix (_tmp189_, "_async")) {
							const gchar* _tmp190_;
							const gchar* _tmp191_;
							gint _tmp192_;
							gint _tmp193_;
							gint _tmp194_;
							gint _tmp195_;
							gchar* _tmp196_;
							_tmp190_ = finish_name;
							_tmp191_ = finish_name;
							_tmp192_ = strlen (_tmp191_);
							_tmp193_ = _tmp192_;
							_tmp194_ = strlen ("_async");
							_tmp195_ = _tmp194_;
							_tmp196_ = string_substring (_tmp190_, (glong) 0, (glong) (_tmp193_ - _tmp195_));
							_g_free0 (finish_name);
							finish_name = _tmp196_;
						}
						_tmp197_ = finish_name;
						_tmp198_ = g_strconcat (_tmp197_, "_finish", NULL);
						_g_free0 (finish_name);
						finish_name = _tmp198_;
						vala_gir_writer_write_indent (self);
						_tmp199_ = self->priv->buffer;
						_tmp200_ = m;
						_tmp201_ = vala_symbol_get_name ((ValaSymbol*) _tmp200_);
						_tmp202_ = _tmp201_;
						g_string_append_printf (_tmp199_, "<field name=\"%s\"", _tmp202_);
						_tmp203_ = m;
						vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp203_);
						_tmp204_ = self->priv->buffer;
						g_string_append_printf (_tmp204_, ">\n");
						_tmp205_ = self->priv->indent;
						self->priv->indent = _tmp205_ + 1;
						_tmp206_ = m;
						_tmp207_ = m;
						_tmp208_ = vala_symbol_get_name ((ValaSymbol*) _tmp207_);
						_tmp209_ = _tmp208_;
						_tmp210_ = m;
						_tmp211_ = vala_get_ccode_name ((ValaCodeNode*) _tmp210_);
						_tmp212_ = _tmp211_;
						_tmp213_ = m;
						_tmp214_ = vala_method_get_async_begin_parameters (_tmp213_);
						_tmp215_ = vala_void_type_new (NULL);
						_tmp216_ = _tmp215_;
						vala_gir_writer_do_write_signature (self, _tmp206_, "callback", TRUE, _tmp209_, _tmp212_, _tmp214_, (ValaDataType*) _tmp216_, FALSE, FALSE, FALSE);
						_vala_code_node_unref0 (_tmp216_);
						_g_free0 (_tmp212_);
						_tmp217_ = self->priv->indent;
						self->priv->indent = _tmp217_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp218_ = self->priv->buffer;
						g_string_append_printf (_tmp218_, "</field>\n");
						vala_gir_writer_write_indent (self);
						_tmp219_ = self->priv->buffer;
						_tmp220_ = finish_name;
						g_string_append_printf (_tmp219_, "<field name=\"%s\"", _tmp220_);
						_tmp221_ = m;
						vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp221_);
						_tmp222_ = self->priv->buffer;
						g_string_append_printf (_tmp222_, ">\n");
						_tmp223_ = self->priv->indent;
						self->priv->indent = _tmp223_ + 1;
						_tmp224_ = m;
						_tmp225_ = finish_name;
						_tmp226_ = m;
						_tmp227_ = vala_get_ccode_finish_name (_tmp226_);
						_tmp228_ = _tmp227_;
						_tmp229_ = m;
						_tmp230_ = vala_method_get_async_end_parameters (_tmp229_);
						_tmp231_ = m;
						_tmp232_ = vala_callable_get_return_type ((ValaCallable*) _tmp231_);
						_tmp233_ = _tmp232_;
						_tmp234_ = m;
						_tmp235_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp234_);
						_tmp236_ = _tmp235_;
						vala_gir_writer_do_write_signature (self, _tmp224_, "callback", TRUE, _tmp225_, _tmp228_, _tmp230_, _tmp233_, _tmp236_, FALSE, FALSE);
						_g_free0 (_tmp228_);
						_tmp237_ = self->priv->indent;
						self->priv->indent = _tmp237_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp238_ = self->priv->buffer;
						g_string_append_printf (_tmp238_, "</field>\n");
						_g_free0 (finish_name);
					} else {
						GString* _tmp239_;
						ValaMethod* _tmp240_;
						const gchar* _tmp241_;
						const gchar* _tmp242_;
						ValaMethod* _tmp243_;
						GString* _tmp244_;
						gint _tmp245_;
						ValaMethod* _tmp246_;
						ValaMethod* _tmp247_;
						const gchar* _tmp248_;
						const gchar* _tmp249_;
						ValaMethod* _tmp250_;
						gchar* _tmp251_;
						gchar* _tmp252_;
						ValaMethod* _tmp253_;
						ValaList* _tmp254_;
						ValaMethod* _tmp255_;
						ValaDataType* _tmp256_;
						ValaDataType* _tmp257_;
						ValaMethod* _tmp258_;
						gboolean _tmp259_;
						gboolean _tmp260_;
						gint _tmp261_;
						GString* _tmp262_;
						vala_gir_writer_write_indent (self);
						_tmp239_ = self->priv->buffer;
						_tmp240_ = m;
						_tmp241_ = vala_symbol_get_name ((ValaSymbol*) _tmp240_);
						_tmp242_ = _tmp241_;
						g_string_append_printf (_tmp239_, "<field name=\"%s\"", _tmp242_);
						_tmp243_ = m;
						vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp243_);
						_tmp244_ = self->priv->buffer;
						g_string_append_printf (_tmp244_, ">\n");
						_tmp245_ = self->priv->indent;
						self->priv->indent = _tmp245_ + 1;
						_tmp246_ = m;
						_tmp247_ = m;
						_tmp248_ = vala_symbol_get_name ((ValaSymbol*) _tmp247_);
						_tmp249_ = _tmp248_;
						_tmp250_ = m;
						_tmp251_ = vala_get_ccode_name ((ValaCodeNode*) _tmp250_);
						_tmp252_ = _tmp251_;
						_tmp253_ = m;
						_tmp254_ = vala_callable_get_parameters ((ValaCallable*) _tmp253_);
						_tmp255_ = m;
						_tmp256_ = vala_callable_get_return_type ((ValaCallable*) _tmp255_);
						_tmp257_ = _tmp256_;
						_tmp258_ = m;
						_tmp259_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp258_);
						_tmp260_ = _tmp259_;
						vala_gir_writer_do_write_signature (self, _tmp246_, "callback", TRUE, _tmp249_, _tmp252_, _tmp254_, _tmp257_, _tmp260_, FALSE, FALSE);
						_g_free0 (_tmp252_);
						_tmp261_ = self->priv->indent;
						self->priv->indent = _tmp261_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp262_ = self->priv->buffer;
						g_string_append_printf (_tmp262_, "</field>\n");
					}
				}
				_vala_code_node_unref0 (m);
			}
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp263_;
			gint _sig_size = 0;
			ValaList* _tmp264_;
			gint _tmp265_;
			gint _tmp266_;
			gint _sig_index = 0;
			_tmp263_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) cl);
			_sig_list = _tmp263_;
			_tmp264_ = _sig_list;
			_tmp265_ = vala_collection_get_size ((ValaCollection*) _tmp264_);
			_tmp266_ = _tmp265_;
			_sig_size = _tmp266_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp267_;
				gint _tmp268_;
				ValaSignal* sig = NULL;
				ValaList* _tmp269_;
				gpointer _tmp270_;
				ValaSignal* _tmp271_;
				ValaMethod* _tmp272_;
				ValaMethod* _tmp273_;
				_sig_index = _sig_index + 1;
				_tmp267_ = _sig_index;
				_tmp268_ = _sig_size;
				if (!(_tmp267_ < _tmp268_)) {
					break;
				}
				_tmp269_ = _sig_list;
				_tmp270_ = vala_list_get (_tmp269_, _sig_index);
				sig = (ValaSignal*) _tmp270_;
				_tmp271_ = sig;
				_tmp272_ = vala_signal_get_default_handler (_tmp271_);
				_tmp273_ = _tmp272_;
				if (_tmp273_ != NULL) {
					GString* _tmp274_;
					ValaSignal* _tmp275_;
					gchar* _tmp276_;
					gchar* _tmp277_;
					ValaSignal* _tmp278_;
					GString* _tmp279_;
					gint _tmp280_;
					ValaSignal* _tmp281_;
					ValaMethod* _tmp282_;
					ValaMethod* _tmp283_;
					gint _tmp284_;
					GString* _tmp285_;
					vala_gir_writer_write_indent (self);
					_tmp274_ = self->priv->buffer;
					_tmp275_ = sig;
					_tmp276_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp275_, NULL);
					_tmp277_ = _tmp276_;
					g_string_append_printf (_tmp274_, "<field name=\"%s\"", _tmp277_);
					_g_free0 (_tmp277_);
					_tmp278_ = sig;
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp278_);
					_tmp279_ = self->priv->buffer;
					g_string_append_printf (_tmp279_, ">\n");
					_tmp280_ = self->priv->indent;
					self->priv->indent = _tmp280_ + 1;
					_tmp281_ = sig;
					_tmp282_ = vala_signal_get_default_handler (_tmp281_);
					_tmp283_ = _tmp282_;
					vala_gir_writer_write_signature (self, _tmp283_, "callback", FALSE, TRUE, FALSE);
					_tmp284_ = self->priv->indent;
					self->priv->indent = _tmp284_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp285_ = self->priv->buffer;
					g_string_append_printf (_tmp285_, "</field>\n");
				}
				_vala_code_node_unref0 (sig);
			}
		}
		_tmp286_ = self->priv->indent;
		self->priv->indent = _tmp286_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp287_ = self->priv->buffer;
		g_string_append_printf (_tmp287_, "</record>\n");
		vala_gir_writer_write_indent (self);
		_tmp288_ = self->priv->buffer;
		_tmp289_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_get_ccode_name ((ValaCodeNode*) cl);
		_tmp292_ = _tmp291_;
		g_string_append_printf (_tmp288_, "<record name=\"%sPrivate\" c:type=\"%sPrivate\" disguised=\"1\"/>\n", _tmp290_, _tmp292_);
		_g_free0 (_tmp292_);
		_g_free0 (_tmp290_);
		_g_free0 (gtype_struct_name);
	} else {
		GString* _tmp293_;
		gchar* _tmp294_;
		gchar* _tmp295_;
		GString* _tmp296_;
		gint _tmp297_;
		gchar* _tmp298_;
		gchar* _tmp299_;
		ValaArrayList* _tmp300_;
		ValaArrayList* _tmp301_;
		gpointer _tmp302_;
		ValaSymbol* _tmp303_;
		gint _tmp304_;
		GString* _tmp305_;
		vala_gir_writer_write_indent (self);
		_tmp293_ = self->priv->buffer;
		_tmp294_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cl);
		_tmp295_ = _tmp294_;
		g_string_append_printf (_tmp293_, "<record name=\"%s\"", _tmp295_);
		_g_free0 (_tmp295_);
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) cl, "", FALSE);
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cl);
		_tmp296_ = self->priv->buffer;
		g_string_append_printf (_tmp296_, ">\n");
		_tmp297_ = self->priv->indent;
		self->priv->indent = _tmp297_ + 1;
		_tmp298_ = vala_gir_writer_get_class_comment (self, cl);
		_tmp299_ = _tmp298_;
		vala_gir_writer_write_doc (self, _tmp299_);
		_g_free0 (_tmp299_);
		_tmp300_ = self->priv->hierarchy;
		vala_list_insert ((ValaList*) _tmp300_, 0, (ValaSymbol*) cl);
		vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
		_tmp301_ = self->priv->hierarchy;
		_tmp302_ = vala_list_remove_at ((ValaList*) _tmp301_, 0);
		_tmp303_ = (ValaSymbol*) _tmp302_;
		_vala_code_node_unref0 (_tmp303_);
		_tmp304_ = self->priv->indent;
		self->priv->indent = _tmp304_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp305_ = self->priv->buffer;
		g_string_append_printf (_tmp305_, "</record>\n");
	}
	vala_gir_writer_visit_deferred (self);
}

static void
vala_gir_writer_real_visit_struct (ValaCodeVisitor* base,
                                   ValaStruct* st)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaArrayList* _tmp2_;
	gpointer _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	GString* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GString* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaArrayList* _tmp14_;
	ValaArrayList* _tmp15_;
	gpointer _tmp16_;
	ValaSymbol* _tmp17_;
	gint _tmp18_;
	GString* _tmp19_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) st);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) st)) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) st)) {
		return;
	}
	_tmp2_ = self->priv->hierarchy;
	_tmp3_ = vala_list_get ((ValaList*) _tmp2_, 0);
	_tmp4_ = (ValaSymbol*) _tmp3_;
	_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp4_);
	if (_tmp5_) {
		ValaArrayList* _tmp6_;
		_tmp6_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp6_, (ValaCodeNode*) st);
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp7_ = self->priv->buffer;
	_tmp8_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) st);
	_tmp9_ = _tmp8_;
	g_string_append_printf (_tmp7_, "<record name=\"%s\"", _tmp9_);
	_g_free0 (_tmp9_);
	if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) st)) {
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) st, TRUE);
	} else {
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) st, "", TRUE);
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) st);
	_tmp10_ = self->priv->buffer;
	g_string_append_printf (_tmp10_, ">\n");
	_tmp11_ = self->priv->indent;
	self->priv->indent = _tmp11_ + 1;
	_tmp12_ = vala_gir_writer_get_struct_comment (self, st);
	_tmp13_ = _tmp12_;
	vala_gir_writer_write_doc (self, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp14_, 0, (ValaSymbol*) st);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
	_tmp15_ = self->priv->hierarchy;
	_tmp16_ = vala_list_remove_at ((ValaList*) _tmp15_, 0);
	_tmp17_ = (ValaSymbol*) _tmp16_;
	_vala_code_node_unref0 (_tmp17_);
	_tmp18_ = self->priv->indent;
	self->priv->indent = _tmp18_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp19_ = self->priv->buffer;
	g_string_append_printf (_tmp19_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
}

static void
vala_gir_writer_real_visit_interface (ValaCodeVisitor* base,
                                      ValaInterface* iface)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaArrayList* _tmp2_;
	gpointer _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	gchar* gtype_struct_name = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GString* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GString* _tmp14_;
	const gchar* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	ValaArrayList* _tmp37_;
	ValaArrayList* _tmp38_;
	gpointer _tmp39_;
	ValaSymbol* _tmp40_;
	gint _tmp41_;
	GString* _tmp42_;
	GString* _tmp43_;
	const gchar* _tmp44_;
	GString* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GString* _tmp48_;
	gint _tmp49_;
	GString* _tmp50_;
	gint _tmp51_;
	GString* _tmp52_;
	ValaTypeSymbol* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gint _tmp59_;
	GString* _tmp60_;
	gint _tmp246_;
	GString* _tmp247_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) iface);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) iface)) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) iface)) {
		return;
	}
	_tmp2_ = self->priv->hierarchy;
	_tmp3_ = vala_list_get ((ValaList*) _tmp2_, 0);
	_tmp4_ = (ValaSymbol*) _tmp3_;
	_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp4_);
	if (_tmp5_) {
		ValaArrayList* _tmp6_;
		_tmp6_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp6_, (ValaCodeNode*) iface);
		return;
	}
	_tmp7_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) iface);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "Iface", NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	gtype_struct_name = _tmp10_;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) iface);
	_tmp13_ = _tmp12_;
	g_string_append_printf (_tmp11_, "<interface name=\"%s\"", _tmp13_);
	_g_free0 (_tmp13_);
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) iface, TRUE);
	_tmp14_ = self->priv->buffer;
	_tmp15_ = gtype_struct_name;
	g_string_append_printf (_tmp14_, " glib:type-struct=\"%s\"", _tmp15_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) iface);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = vala_gir_writer_get_interface_comment (self, iface);
	_tmp19_ = _tmp18_;
	vala_gir_writer_write_doc (self, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = vala_interface_get_prerequisites (iface);
	_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > 0) {
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp23_;
			gint _base_type_size = 0;
			ValaList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _base_type_index = 0;
			_tmp23_ = vala_interface_get_prerequisites (iface);
			_base_type_list = _tmp23_;
			_tmp24_ = _base_type_list;
			_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_base_type_size = _tmp26_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp29_;
				gpointer _tmp30_;
				GString* _tmp31_;
				ValaDataType* _tmp32_;
				ValaTypeSymbol* _tmp33_;
				ValaTypeSymbol* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_base_type_index = _base_type_index + 1;
				_tmp27_ = _base_type_index;
				_tmp28_ = _base_type_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _base_type_list;
				_tmp30_ = vala_list_get (_tmp29_, _base_type_index);
				base_type = (ValaDataType*) _tmp30_;
				vala_gir_writer_write_indent (self);
				_tmp31_ = self->priv->buffer;
				_tmp32_ = base_type;
				_tmp33_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_gir_writer_gi_type_name (self, _tmp34_);
				_tmp36_ = _tmp35_;
				g_string_append_printf (_tmp31_, "<prerequisite name=\"%s\"/>\n", _tmp36_);
				_g_free0 (_tmp36_);
				_vala_code_node_unref0 (base_type);
			}
		}
	}
	_tmp37_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp37_, 0, (ValaSymbol*) iface);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
	_tmp38_ = self->priv->hierarchy;
	_tmp39_ = vala_list_remove_at ((ValaList*) _tmp38_, 0);
	_tmp40_ = (ValaSymbol*) _tmp39_;
	_vala_code_node_unref0 (_tmp40_);
	_tmp41_ = self->priv->indent;
	self->priv->indent = _tmp41_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp42_ = self->priv->buffer;
	g_string_append_printf (_tmp42_, "</interface>\n");
	vala_gir_writer_write_indent (self);
	_tmp43_ = self->priv->buffer;
	_tmp44_ = gtype_struct_name;
	g_string_append_printf (_tmp43_, "<record name=\"%s\"", _tmp44_);
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) iface, "Iface", FALSE);
	_tmp45_ = self->priv->buffer;
	_tmp46_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) iface);
	_tmp47_ = _tmp46_;
	g_string_append_printf (_tmp45_, " glib:is-gtype-struct-for=\"%s\"", _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = self->priv->buffer;
	g_string_append_printf (_tmp48_, ">\n");
	_tmp49_ = self->priv->indent;
	self->priv->indent = _tmp49_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp50_ = self->priv->buffer;
	g_string_append_printf (_tmp50_, "<field name=\"parent_iface\" readable=\"0\" private=\"1\">\n");
	_tmp51_ = self->priv->indent;
	self->priv->indent = _tmp51_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp52_ = self->priv->buffer;
	_tmp53_ = self->priv->gtypeinterface_type;
	_tmp54_ = vala_gir_writer_gi_type_name (self, _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = self->priv->gtypeinterface_type;
	_tmp57_ = vala_get_ccode_name ((ValaCodeNode*) _tmp56_);
	_tmp58_ = _tmp57_;
	g_string_append_printf (_tmp52_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp55_, _tmp58_);
	_g_free0 (_tmp58_);
	_g_free0 (_tmp55_);
	_tmp59_ = self->priv->indent;
	self->priv->indent = _tmp59_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp60_ = self->priv->buffer;
	g_string_append_printf (_tmp60_, "</field>\n");
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp61_;
		gint _m_size = 0;
		ValaList* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		gint _m_index = 0;
		_tmp61_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface);
		_m_list = _tmp61_;
		_tmp62_ = _m_list;
		_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
		_tmp64_ = _tmp63_;
		_m_size = _tmp64_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp65_;
			gint _tmp66_;
			ValaMethod* m = NULL;
			ValaList* _tmp67_;
			gpointer _tmp68_;
			gboolean _tmp69_ = FALSE;
			ValaMethod* _tmp70_;
			gboolean _tmp71_;
			gboolean _tmp72_;
			_m_index = _m_index + 1;
			_tmp65_ = _m_index;
			_tmp66_ = _m_size;
			if (!(_tmp65_ < _tmp66_)) {
				break;
			}
			_tmp67_ = _m_list;
			_tmp68_ = vala_list_get (_tmp67_, _m_index);
			m = (ValaMethod*) _tmp68_;
			_tmp70_ = m;
			_tmp71_ = vala_method_get_is_abstract (_tmp70_);
			_tmp72_ = _tmp71_;
			if (_tmp72_) {
				_tmp69_ = TRUE;
			} else {
				ValaMethod* _tmp73_;
				gboolean _tmp74_;
				gboolean _tmp75_;
				_tmp73_ = m;
				_tmp74_ = vala_method_get_is_virtual (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp69_ = _tmp75_;
			}
			if (_tmp69_) {
				ValaMethod* _tmp76_;
				gboolean _tmp77_;
				gboolean _tmp78_;
				_tmp76_ = m;
				_tmp77_ = vala_method_get_coroutine (_tmp76_);
				_tmp78_ = _tmp77_;
				if (_tmp78_) {
					gchar* finish_name = NULL;
					ValaMethod* _tmp79_;
					const gchar* _tmp80_;
					const gchar* _tmp81_;
					gchar* _tmp82_;
					const gchar* _tmp83_;
					const gchar* _tmp91_;
					gchar* _tmp92_;
					GString* _tmp93_;
					ValaMethod* _tmp94_;
					const gchar* _tmp95_;
					const gchar* _tmp96_;
					ValaMethod* _tmp97_;
					GString* _tmp98_;
					gint _tmp99_;
					ValaMethod* _tmp100_;
					ValaMethod* _tmp101_;
					const gchar* _tmp102_;
					const gchar* _tmp103_;
					ValaMethod* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					ValaMethod* _tmp107_;
					ValaList* _tmp108_;
					ValaVoidType* _tmp109_;
					ValaVoidType* _tmp110_;
					gint _tmp111_;
					GString* _tmp112_;
					GString* _tmp113_;
					const gchar* _tmp114_;
					ValaMethod* _tmp115_;
					GString* _tmp116_;
					gint _tmp117_;
					ValaMethod* _tmp118_;
					const gchar* _tmp119_;
					ValaMethod* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					ValaMethod* _tmp123_;
					ValaList* _tmp124_;
					ValaMethod* _tmp125_;
					ValaDataType* _tmp126_;
					ValaDataType* _tmp127_;
					ValaMethod* _tmp128_;
					gboolean _tmp129_;
					gboolean _tmp130_;
					gint _tmp131_;
					GString* _tmp132_;
					_tmp79_ = m;
					_tmp80_ = vala_symbol_get_name ((ValaSymbol*) _tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = g_strdup (_tmp81_);
					finish_name = _tmp82_;
					_tmp83_ = finish_name;
					if (g_str_has_suffix (_tmp83_, "_async")) {
						const gchar* _tmp84_;
						const gchar* _tmp85_;
						gint _tmp86_;
						gint _tmp87_;
						gint _tmp88_;
						gint _tmp89_;
						gchar* _tmp90_;
						_tmp84_ = finish_name;
						_tmp85_ = finish_name;
						_tmp86_ = strlen (_tmp85_);
						_tmp87_ = _tmp86_;
						_tmp88_ = strlen ("_async");
						_tmp89_ = _tmp88_;
						_tmp90_ = string_substring (_tmp84_, (glong) 0, (glong) (_tmp87_ - _tmp89_));
						_g_free0 (finish_name);
						finish_name = _tmp90_;
					}
					_tmp91_ = finish_name;
					_tmp92_ = g_strconcat (_tmp91_, "_finish", NULL);
					_g_free0 (finish_name);
					finish_name = _tmp92_;
					vala_gir_writer_write_indent (self);
					_tmp93_ = self->priv->buffer;
					_tmp94_ = m;
					_tmp95_ = vala_symbol_get_name ((ValaSymbol*) _tmp94_);
					_tmp96_ = _tmp95_;
					g_string_append_printf (_tmp93_, "<field name=\"%s\"", _tmp96_);
					_tmp97_ = m;
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp97_);
					_tmp98_ = self->priv->buffer;
					g_string_append_printf (_tmp98_, ">\n");
					_tmp99_ = self->priv->indent;
					self->priv->indent = _tmp99_ + 1;
					_tmp100_ = m;
					_tmp101_ = m;
					_tmp102_ = vala_symbol_get_name ((ValaSymbol*) _tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = m;
					_tmp105_ = vala_get_ccode_name ((ValaCodeNode*) _tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = m;
					_tmp108_ = vala_method_get_async_begin_parameters (_tmp107_);
					_tmp109_ = vala_void_type_new (NULL);
					_tmp110_ = _tmp109_;
					vala_gir_writer_do_write_signature (self, _tmp100_, "callback", TRUE, _tmp103_, _tmp106_, _tmp108_, (ValaDataType*) _tmp110_, FALSE, FALSE, FALSE);
					_vala_code_node_unref0 (_tmp110_);
					_g_free0 (_tmp106_);
					_tmp111_ = self->priv->indent;
					self->priv->indent = _tmp111_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp112_ = self->priv->buffer;
					g_string_append_printf (_tmp112_, "</field>\n");
					vala_gir_writer_write_indent (self);
					_tmp113_ = self->priv->buffer;
					_tmp114_ = finish_name;
					g_string_append_printf (_tmp113_, "<field name=\"%s\"", _tmp114_);
					_tmp115_ = m;
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp115_);
					_tmp116_ = self->priv->buffer;
					g_string_append_printf (_tmp116_, ">\n");
					_tmp117_ = self->priv->indent;
					self->priv->indent = _tmp117_ + 1;
					_tmp118_ = m;
					_tmp119_ = finish_name;
					_tmp120_ = m;
					_tmp121_ = vala_get_ccode_finish_name (_tmp120_);
					_tmp122_ = _tmp121_;
					_tmp123_ = m;
					_tmp124_ = vala_method_get_async_end_parameters (_tmp123_);
					_tmp125_ = m;
					_tmp126_ = vala_callable_get_return_type ((ValaCallable*) _tmp125_);
					_tmp127_ = _tmp126_;
					_tmp128_ = m;
					_tmp129_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp128_);
					_tmp130_ = _tmp129_;
					vala_gir_writer_do_write_signature (self, _tmp118_, "callback", TRUE, _tmp119_, _tmp122_, _tmp124_, _tmp127_, _tmp130_, FALSE, FALSE);
					_g_free0 (_tmp122_);
					_tmp131_ = self->priv->indent;
					self->priv->indent = _tmp131_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp132_ = self->priv->buffer;
					g_string_append_printf (_tmp132_, "</field>\n");
					_g_free0 (finish_name);
				} else {
					GString* _tmp133_;
					ValaMethod* _tmp134_;
					const gchar* _tmp135_;
					const gchar* _tmp136_;
					ValaMethod* _tmp137_;
					GString* _tmp138_;
					gint _tmp139_;
					ValaMethod* _tmp140_;
					ValaMethod* _tmp141_;
					const gchar* _tmp142_;
					const gchar* _tmp143_;
					ValaMethod* _tmp144_;
					gchar* _tmp145_;
					gchar* _tmp146_;
					ValaMethod* _tmp147_;
					ValaList* _tmp148_;
					ValaMethod* _tmp149_;
					ValaDataType* _tmp150_;
					ValaDataType* _tmp151_;
					ValaMethod* _tmp152_;
					gboolean _tmp153_;
					gboolean _tmp154_;
					gint _tmp155_;
					GString* _tmp156_;
					vala_gir_writer_write_indent (self);
					_tmp133_ = self->priv->buffer;
					_tmp134_ = m;
					_tmp135_ = vala_symbol_get_name ((ValaSymbol*) _tmp134_);
					_tmp136_ = _tmp135_;
					g_string_append_printf (_tmp133_, "<field name=\"%s\"", _tmp136_);
					_tmp137_ = m;
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp137_);
					_tmp138_ = self->priv->buffer;
					g_string_append_printf (_tmp138_, ">\n");
					_tmp139_ = self->priv->indent;
					self->priv->indent = _tmp139_ + 1;
					_tmp140_ = m;
					_tmp141_ = m;
					_tmp142_ = vala_symbol_get_name ((ValaSymbol*) _tmp141_);
					_tmp143_ = _tmp142_;
					_tmp144_ = m;
					_tmp145_ = vala_get_ccode_name ((ValaCodeNode*) _tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = m;
					_tmp148_ = vala_callable_get_parameters ((ValaCallable*) _tmp147_);
					_tmp149_ = m;
					_tmp150_ = vala_callable_get_return_type ((ValaCallable*) _tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = m;
					_tmp153_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp152_);
					_tmp154_ = _tmp153_;
					vala_gir_writer_do_write_signature (self, _tmp140_, "callback", TRUE, _tmp143_, _tmp146_, _tmp148_, _tmp151_, _tmp154_, FALSE, FALSE);
					_g_free0 (_tmp146_);
					_tmp155_ = self->priv->indent;
					self->priv->indent = _tmp155_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp156_ = self->priv->buffer;
					g_string_append_printf (_tmp156_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp157_;
		gint _prop_size = 0;
		ValaList* _tmp158_;
		gint _tmp159_;
		gint _tmp160_;
		gint _prop_index = 0;
		_tmp157_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface);
		_prop_list = _tmp157_;
		_tmp158_ = _prop_list;
		_tmp159_ = vala_collection_get_size ((ValaCollection*) _tmp158_);
		_tmp160_ = _tmp159_;
		_prop_size = _tmp160_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp161_;
			gint _tmp162_;
			ValaProperty* prop = NULL;
			ValaList* _tmp163_;
			gpointer _tmp164_;
			gboolean _tmp165_ = FALSE;
			ValaProperty* _tmp166_;
			gboolean _tmp167_;
			gboolean _tmp168_;
			_prop_index = _prop_index + 1;
			_tmp161_ = _prop_index;
			_tmp162_ = _prop_size;
			if (!(_tmp161_ < _tmp162_)) {
				break;
			}
			_tmp163_ = _prop_list;
			_tmp164_ = vala_list_get (_tmp163_, _prop_index);
			prop = (ValaProperty*) _tmp164_;
			_tmp166_ = prop;
			_tmp167_ = vala_property_get_is_abstract (_tmp166_);
			_tmp168_ = _tmp167_;
			if (_tmp168_) {
				_tmp165_ = TRUE;
			} else {
				ValaProperty* _tmp169_;
				gboolean _tmp170_;
				gboolean _tmp171_;
				_tmp169_ = prop;
				_tmp170_ = vala_property_get_is_virtual (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp165_ = _tmp171_;
			}
			if (_tmp165_) {
				gboolean _tmp172_ = FALSE;
				ValaProperty* _tmp173_;
				ValaPropertyAccessor* _tmp174_;
				ValaPropertyAccessor* _tmp175_;
				gboolean _tmp209_ = FALSE;
				ValaProperty* _tmp210_;
				ValaPropertyAccessor* _tmp211_;
				ValaPropertyAccessor* _tmp212_;
				_tmp173_ = prop;
				_tmp174_ = vala_property_get_get_accessor (_tmp173_);
				_tmp175_ = _tmp174_;
				if (_tmp175_ != NULL) {
					ValaProperty* _tmp176_;
					ValaPropertyAccessor* _tmp177_;
					ValaPropertyAccessor* _tmp178_;
					gboolean _tmp179_;
					gboolean _tmp180_;
					_tmp176_ = prop;
					_tmp177_ = vala_property_get_get_accessor (_tmp176_);
					_tmp178_ = _tmp177_;
					_tmp179_ = vala_property_accessor_get_readable (_tmp178_);
					_tmp180_ = _tmp179_;
					_tmp172_ = _tmp180_;
				} else {
					_tmp172_ = FALSE;
				}
				if (_tmp172_) {
					ValaMethod* m = NULL;
					ValaProperty* _tmp181_;
					ValaPropertyAccessor* _tmp182_;
					ValaPropertyAccessor* _tmp183_;
					ValaMethod* _tmp184_;
					GString* _tmp185_;
					ValaMethod* _tmp186_;
					const gchar* _tmp187_;
					const gchar* _tmp188_;
					ValaMethod* _tmp189_;
					GString* _tmp190_;
					gint _tmp191_;
					ValaMethod* _tmp192_;
					ValaMethod* _tmp193_;
					const gchar* _tmp194_;
					const gchar* _tmp195_;
					ValaMethod* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					ValaMethod* _tmp199_;
					ValaList* _tmp200_;
					ValaMethod* _tmp201_;
					ValaDataType* _tmp202_;
					ValaDataType* _tmp203_;
					ValaMethod* _tmp204_;
					gboolean _tmp205_;
					gboolean _tmp206_;
					gint _tmp207_;
					GString* _tmp208_;
					_tmp181_ = prop;
					_tmp182_ = vala_property_get_get_accessor (_tmp181_);
					_tmp183_ = _tmp182_;
					_tmp184_ = vala_property_accessor_get_method (_tmp183_);
					m = _tmp184_;
					vala_gir_writer_write_indent (self);
					_tmp185_ = self->priv->buffer;
					_tmp186_ = m;
					_tmp187_ = vala_symbol_get_name ((ValaSymbol*) _tmp186_);
					_tmp188_ = _tmp187_;
					g_string_append_printf (_tmp185_, "<field name=\"%s\"", _tmp188_);
					_tmp189_ = m;
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp189_);
					_tmp190_ = self->priv->buffer;
					g_string_append_printf (_tmp190_, ">\n");
					_tmp191_ = self->priv->indent;
					self->priv->indent = _tmp191_ + 1;
					_tmp192_ = m;
					_tmp193_ = m;
					_tmp194_ = vala_symbol_get_name ((ValaSymbol*) _tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = m;
					_tmp197_ = vala_get_ccode_name ((ValaCodeNode*) _tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = m;
					_tmp200_ = vala_callable_get_parameters ((ValaCallable*) _tmp199_);
					_tmp201_ = m;
					_tmp202_ = vala_callable_get_return_type ((ValaCallable*) _tmp201_);
					_tmp203_ = _tmp202_;
					_tmp204_ = m;
					_tmp205_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp204_);
					_tmp206_ = _tmp205_;
					vala_gir_writer_do_write_signature (self, _tmp192_, "callback", TRUE, _tmp195_, _tmp198_, _tmp200_, _tmp203_, _tmp206_, FALSE, FALSE);
					_g_free0 (_tmp198_);
					_tmp207_ = self->priv->indent;
					self->priv->indent = _tmp207_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp208_ = self->priv->buffer;
					g_string_append_printf (_tmp208_, "</field>\n");
					_vala_code_node_unref0 (m);
				}
				_tmp210_ = prop;
				_tmp211_ = vala_property_get_set_accessor (_tmp210_);
				_tmp212_ = _tmp211_;
				if (_tmp212_ != NULL) {
					ValaProperty* _tmp213_;
					ValaPropertyAccessor* _tmp214_;
					ValaPropertyAccessor* _tmp215_;
					gboolean _tmp216_;
					gboolean _tmp217_;
					_tmp213_ = prop;
					_tmp214_ = vala_property_get_set_accessor (_tmp213_);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_property_accessor_get_writable (_tmp215_);
					_tmp217_ = _tmp216_;
					_tmp209_ = _tmp217_;
				} else {
					_tmp209_ = FALSE;
				}
				if (_tmp209_) {
					ValaMethod* m = NULL;
					ValaProperty* _tmp218_;
					ValaPropertyAccessor* _tmp219_;
					ValaPropertyAccessor* _tmp220_;
					ValaMethod* _tmp221_;
					GString* _tmp222_;
					ValaMethod* _tmp223_;
					const gchar* _tmp224_;
					const gchar* _tmp225_;
					ValaMethod* _tmp226_;
					GString* _tmp227_;
					gint _tmp228_;
					ValaMethod* _tmp229_;
					ValaMethod* _tmp230_;
					const gchar* _tmp231_;
					const gchar* _tmp232_;
					ValaMethod* _tmp233_;
					gchar* _tmp234_;
					gchar* _tmp235_;
					ValaMethod* _tmp236_;
					ValaList* _tmp237_;
					ValaMethod* _tmp238_;
					ValaDataType* _tmp239_;
					ValaDataType* _tmp240_;
					ValaMethod* _tmp241_;
					gboolean _tmp242_;
					gboolean _tmp243_;
					gint _tmp244_;
					GString* _tmp245_;
					_tmp218_ = prop;
					_tmp219_ = vala_property_get_set_accessor (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_property_accessor_get_method (_tmp220_);
					m = _tmp221_;
					vala_gir_writer_write_indent (self);
					_tmp222_ = self->priv->buffer;
					_tmp223_ = m;
					_tmp224_ = vala_symbol_get_name ((ValaSymbol*) _tmp223_);
					_tmp225_ = _tmp224_;
					g_string_append_printf (_tmp222_, "<field name=\"%s\"", _tmp225_);
					_tmp226_ = m;
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp226_);
					_tmp227_ = self->priv->buffer;
					g_string_append_printf (_tmp227_, ">\n");
					_tmp228_ = self->priv->indent;
					self->priv->indent = _tmp228_ + 1;
					_tmp229_ = m;
					_tmp230_ = m;
					_tmp231_ = vala_symbol_get_name ((ValaSymbol*) _tmp230_);
					_tmp232_ = _tmp231_;
					_tmp233_ = m;
					_tmp234_ = vala_get_ccode_name ((ValaCodeNode*) _tmp233_);
					_tmp235_ = _tmp234_;
					_tmp236_ = m;
					_tmp237_ = vala_callable_get_parameters ((ValaCallable*) _tmp236_);
					_tmp238_ = m;
					_tmp239_ = vala_callable_get_return_type ((ValaCallable*) _tmp238_);
					_tmp240_ = _tmp239_;
					_tmp241_ = m;
					_tmp242_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp241_);
					_tmp243_ = _tmp242_;
					vala_gir_writer_do_write_signature (self, _tmp229_, "callback", TRUE, _tmp232_, _tmp235_, _tmp237_, _tmp240_, _tmp243_, FALSE, FALSE);
					_g_free0 (_tmp235_);
					_tmp244_ = self->priv->indent;
					self->priv->indent = _tmp244_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp245_ = self->priv->buffer;
					g_string_append_printf (_tmp245_, "</field>\n");
					_vala_code_node_unref0 (m);
				}
			}
			_vala_code_node_unref0 (prop);
		}
	}
	_tmp246_ = self->priv->indent;
	self->priv->indent = _tmp246_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp247_ = self->priv->buffer;
	g_string_append_printf (_tmp247_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
	_g_free0 (gtype_struct_name);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_gir_writer_visit_deferred (ValaGIRWriter* self)
{
	ValaArrayList* nodes = NULL;
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deferred;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	nodes = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	_vala_iterable_unref0 (self->priv->deferred);
	self->priv->deferred = _tmp3_;
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp4_;
		gint _node_size = 0;
		ValaArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _node_index = 0;
		_tmp4_ = nodes;
		_node_list = _tmp4_;
		_tmp5_ = _node_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_node_size = _tmp7_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaCodeNode* node = NULL;
			ValaArrayList* _tmp10_;
			gpointer _tmp11_;
			ValaCodeNode* _tmp12_;
			_node_index = _node_index + 1;
			_tmp8_ = _node_index;
			_tmp9_ = _node_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _node_list;
			_tmp11_ = vala_list_get ((ValaList*) _tmp10_, _node_index);
			node = (ValaCodeNode*) _tmp11_;
			_tmp12_ = node;
			vala_code_node_accept (_tmp12_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (node);
		}
	}
	_vala_iterable_unref0 (nodes);
}

static gchar*
vala_gir_writer_get_gir_name (ValaGIRWriter* self,
                              ValaSymbol* symbol)
{
	gchar* gir_name = NULL;
	ValaSymbol* h0 = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	gir_name = NULL;
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	h0 = (ValaSymbol*) _tmp1_;
	{
		ValaSymbol* cur_sym = NULL;
		ValaSymbol* _tmp2_;
		_tmp2_ = _vala_code_node_ref0 (symbol);
		cur_sym = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				ValaSymbol* _tmp8_;
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				gchar* cur_name = NULL;
				ValaSymbol* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				if (!_tmp3_) {
					ValaSymbol* _tmp4_;
					ValaSymbol* _tmp5_;
					ValaSymbol* _tmp6_;
					ValaSymbol* _tmp7_;
					_tmp4_ = cur_sym;
					_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp7_ = _vala_code_node_ref0 (_tmp6_);
					_vala_code_node_unref0 (cur_sym);
					cur_sym = _tmp7_;
				}
				_tmp3_ = FALSE;
				_tmp8_ = cur_sym;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = cur_sym;
				_tmp10_ = h0;
				if (_tmp9_ == _tmp10_) {
					break;
				}
				_tmp11_ = cur_sym;
				_tmp12_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp11_, "GIR", "name", NULL);
				cur_name = _tmp12_;
				_tmp13_ = cur_name;
				if (_tmp13_ == NULL) {
					ValaSymbol* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp14_ = cur_sym;
					_tmp15_ = vala_symbol_get_name (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (cur_name);
					cur_name = _tmp17_;
				}
				_tmp18_ = cur_name;
				_tmp19_ = gir_name;
				_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
				_g_free0 (gir_name);
				gir_name = _tmp20_;
				_g_free0 (cur_name);
			}
		}
		_vala_code_node_unref0 (cur_sym);
	}
	result = gir_name;
	_vala_code_node_unref0 (h0);
	return result;
}

static void
vala_gir_writer_real_visit_enum (ValaCodeVisitor* base,
                                 ValaEnum* en)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaArrayList* _tmp2_;
	gpointer _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gchar* element_name = NULL;
	gchar* _tmp10_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GString* _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	ValaArrayList* _tmp19_;
	ValaArrayList* _tmp20_;
	gpointer _tmp21_;
	ValaSymbol* _tmp22_;
	gint _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) en);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) en)) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) en)) {
		return;
	}
	_tmp2_ = self->priv->hierarchy;
	_tmp3_ = vala_list_get ((ValaList*) _tmp2_, 0);
	_tmp4_ = (ValaSymbol*) _tmp3_;
	_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp4_);
	if (_tmp5_) {
		ValaArrayList* _tmp6_;
		_tmp6_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp6_, (ValaCodeNode*) en);
		return;
	}
	_tmp8_ = vala_enum_get_is_flags (en);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		_tmp7_ = "bitfield";
	} else {
		_tmp7_ = "enumeration";
	}
	_tmp10_ = g_strdup (_tmp7_);
	element_name = _tmp10_;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = element_name;
	_tmp13_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) en);
	_tmp14_ = _tmp13_;
	g_string_append_printf (_tmp11_, "<%s name=\"%s\"", _tmp12_, _tmp14_);
	_g_free0 (_tmp14_);
	if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) en)) {
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) en, FALSE);
	} else {
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) en, "", FALSE);
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) en);
	_tmp15_ = self->priv->buffer;
	g_string_append_printf (_tmp15_, ">\n");
	_tmp16_ = self->priv->indent;
	self->priv->indent = _tmp16_ + 1;
	_tmp17_ = vala_gir_writer_get_enum_comment (self, en);
	_tmp18_ = _tmp17_;
	vala_gir_writer_write_doc (self, _tmp18_);
	_g_free0 (_tmp18_);
	self->priv->enum_value = 0;
	_tmp19_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp19_, 0, (ValaSymbol*) en);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
	_tmp20_ = self->priv->hierarchy;
	_tmp21_ = vala_list_remove_at ((ValaList*) _tmp20_, 0);
	_tmp22_ = (ValaSymbol*) _tmp21_;
	_vala_code_node_unref0 (_tmp22_);
	_tmp23_ = self->priv->indent;
	self->priv->indent = _tmp23_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp24_ = self->priv->buffer;
	_tmp25_ = element_name;
	g_string_append_printf (_tmp24_, "</%s>\n", _tmp25_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (element_name);
}

static void
vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base,
                                       ValaEnumValue* ev)
{
	ValaGIRWriter * self;
	ValaEnum* en = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gchar* comment = NULL;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ev != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	en = G_TYPE_CHECK_INSTANCE_CAST ((ValaSymbol*) _tmp1_, VALA_TYPE_ENUM, ValaEnum);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) ev);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_ascii_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_get_ccode_name ((ValaCodeNode*) ev);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp2_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp9_ = vala_constant_get_value ((ValaConstant*) ev);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		gchar* value = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		gchar* _tmp13_;
		GString* _tmp14_;
		const gchar* _tmp15_;
		_tmp11_ = vala_constant_get_value ((ValaConstant*) ev);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp12_);
		value = _tmp13_;
		_tmp14_ = self->priv->buffer;
		_tmp15_ = value;
		g_string_append_printf (_tmp14_, " value=\"%s\"", _tmp15_);
		_g_free0 (value);
	} else {
		ValaEnum* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = en;
		_tmp17_ = vala_enum_get_is_flags (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			GString* _tmp19_;
			gint _tmp20_;
			_tmp19_ = self->priv->buffer;
			_tmp20_ = self->priv->enum_value;
			self->priv->enum_value = _tmp20_ + 1;
			g_string_append_printf (_tmp19_, " value=\"%d\"", 1 << _tmp20_);
		} else {
			GString* _tmp21_;
			gint _tmp22_;
			_tmp21_ = self->priv->buffer;
			_tmp22_ = self->priv->enum_value;
			self->priv->enum_value = _tmp22_ + 1;
			g_string_append_printf (_tmp21_, " value=\"%d\"", _tmp22_);
		}
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) ev);
	_tmp23_ = vala_gir_writer_get_enum_value_comment (self, ev);
	comment = _tmp23_;
	_tmp24_ = comment;
	if (_tmp24_ == NULL) {
		GString* _tmp25_;
		_tmp25_ = self->priv->buffer;
		g_string_append_printf (_tmp25_, "/>\n");
	} else {
		GString* _tmp26_;
		gint _tmp27_;
		const gchar* _tmp28_;
		gint _tmp29_;
		GString* _tmp30_;
		_tmp26_ = self->priv->buffer;
		g_string_append_printf (_tmp26_, ">\n");
		_tmp27_ = self->priv->indent;
		self->priv->indent = _tmp27_ + 1;
		_tmp28_ = comment;
		vala_gir_writer_write_doc (self, _tmp28_);
		_tmp29_ = self->priv->indent;
		self->priv->indent = _tmp29_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp30_ = self->priv->buffer;
		g_string_append_printf (_tmp30_, "</member>\n");
	}
	_g_free0 (comment);
	_vala_code_node_unref0 (en);
}

static void
vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base,
                                         ValaErrorDomain* edomain)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GString* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	ValaArrayList* _tmp12_;
	ValaArrayList* _tmp13_;
	gpointer _tmp14_;
	ValaSymbol* _tmp15_;
	gint _tmp16_;
	GString* _tmp17_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) edomain)) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) edomain)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) edomain);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp2_, "<enumeration name=\"%s\"", _tmp4_);
	_g_free0 (_tmp4_);
	if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) edomain)) {
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) edomain, FALSE);
	} else {
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) edomain, "", FALSE);
	}
	_tmp5_ = self->priv->buffer;
	_tmp6_ = vala_get_ccode_quark_name (edomain);
	_tmp7_ = _tmp6_;
	g_string_append_printf (_tmp5_, " glib:error-domain=\"%s\"", _tmp7_);
	_g_free0 (_tmp7_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) edomain);
	_tmp8_ = self->priv->buffer;
	g_string_append_printf (_tmp8_, ">\n");
	_tmp9_ = self->priv->indent;
	self->priv->indent = _tmp9_ + 1;
	_tmp10_ = vala_gir_writer_get_error_domain_comment (self, edomain);
	_tmp11_ = _tmp10_;
	vala_gir_writer_write_doc (self, _tmp11_);
	_g_free0 (_tmp11_);
	self->priv->enum_value = 0;
	_tmp12_ = self->priv->hierarchy;
	vala_list_insert ((ValaList*) _tmp12_, 0, (ValaSymbol*) edomain);
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) self);
	_tmp13_ = self->priv->hierarchy;
	_tmp14_ = vala_list_remove_at ((ValaList*) _tmp13_, 0);
	_tmp15_ = (ValaSymbol*) _tmp14_;
	_vala_code_node_unref0 (_tmp15_);
	_tmp16_ = self->priv->indent;
	self->priv->indent = _tmp16_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	g_string_append_printf (_tmp17_, "</enumeration>\n");
	vala_gir_writer_visit_deferred (self);
}

static void
vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base,
                                       ValaErrorCode* ecode)
{
	ValaGIRWriter * self;
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	gchar* comment = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ecode != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) ecode);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_ascii_strdown (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) ecode);
	_tmp6_ = _tmp5_;
	g_string_append_printf (_tmp0_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = vala_error_code_get_value (ecode);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		gchar* value = NULL;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		gchar* _tmp11_;
		GString* _tmp12_;
		const gchar* _tmp13_;
		_tmp9_ = vala_error_code_get_value (ecode);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp10_);
		value = _tmp11_;
		_tmp12_ = self->priv->buffer;
		_tmp13_ = value;
		g_string_append_printf (_tmp12_, " value=\"%s\"", _tmp13_);
		_g_free0 (value);
	} else {
		GString* _tmp14_;
		gint _tmp15_;
		_tmp14_ = self->priv->buffer;
		_tmp15_ = self->priv->enum_value;
		self->priv->enum_value = _tmp15_ + 1;
		g_string_append_printf (_tmp14_, " value=\"%d\"", _tmp15_);
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) ecode);
	_tmp16_ = vala_gir_writer_get_error_code_comment (self, ecode);
	comment = _tmp16_;
	_tmp17_ = comment;
	if (_tmp17_ == NULL) {
		GString* _tmp18_;
		_tmp18_ = self->priv->buffer;
		g_string_append_printf (_tmp18_, "/>\n");
	} else {
		GString* _tmp19_;
		gint _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		GString* _tmp23_;
		_tmp19_ = self->priv->buffer;
		g_string_append_printf (_tmp19_, ">\n");
		_tmp20_ = self->priv->indent;
		self->priv->indent = _tmp20_ + 1;
		_tmp21_ = comment;
		vala_gir_writer_write_doc (self, _tmp21_);
		_tmp22_ = self->priv->indent;
		self->priv->indent = _tmp22_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp23_ = self->priv->buffer;
		g_string_append_printf (_tmp23_, "</member>\n");
	}
	_g_free0 (comment);
}

static void
vala_gir_writer_real_visit_constant (ValaCodeVisitor* base,
                                     ValaConstant* c)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* initializer = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	gchar* value = NULL;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	GString* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	GString* _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ValaExpression* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	gint _tmp21_;
	GString* _tmp22_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) c);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) c)) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) c)) {
		return;
	}
	_tmp2_ = vala_constant_get_value (c);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	initializer = _tmp4_;
	_tmp5_ = initializer;
	_tmp6_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp5_);
	value = _tmp6_;
	vala_gir_writer_write_indent (self);
	_tmp7_ = self->priv->buffer;
	_tmp8_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) c);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_get_ccode_name ((ValaCodeNode*) c);
	_tmp11_ = _tmp10_;
	g_string_append_printf (_tmp7_, "<constant name=\"%s\" c:identifier=\"%s\"", _tmp9_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = self->priv->buffer;
	_tmp13_ = value;
	g_string_append_printf (_tmp12_, " value=\"%s\"", _tmp13_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) c);
	_tmp14_ = self->priv->buffer;
	g_string_append_printf (_tmp14_, ">\n");
	_tmp15_ = self->priv->indent;
	self->priv->indent = _tmp15_ + 1;
	_tmp16_ = vala_gir_writer_get_constant_comment (self, c);
	_tmp17_ = _tmp16_;
	vala_gir_writer_write_doc (self, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = initializer;
	_tmp19_ = vala_expression_get_value_type (_tmp18_);
	_tmp20_ = _tmp19_;
	vala_gir_writer_write_type (self, _tmp20_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp21_ = self->priv->indent;
	self->priv->indent = _tmp21_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp22_ = self->priv->buffer;
	g_string_append_printf (_tmp22_, "</constant>\n");
	_g_free0 (value);
	_vala_code_node_unref0 (initializer);
}

static void
vala_gir_writer_real_visit_field (ValaCodeVisitor* base,
                                  ValaField* f)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GString* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	gint _tmp16_;
	GString* _tmp17_;
	gboolean _tmp18_ = FALSE;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) f);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) f)) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) f)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = vala_get_ccode_name ((ValaCodeNode*) f);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp2_, "<field name=\"%s\" writable=\"1\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_data_type_get_nullable (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		GString* _tmp9_;
		_tmp9_ = self->priv->buffer;
		g_string_append_printf (_tmp9_, " nullable=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
	_tmp10_ = self->priv->buffer;
	g_string_append_printf (_tmp10_, ">\n");
	_tmp11_ = self->priv->indent;
	self->priv->indent = _tmp11_ + 1;
	_tmp12_ = vala_gir_writer_get_field_comment (self, f);
	_tmp13_ = _tmp12_;
	vala_gir_writer_write_doc (self, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp15_ = _tmp14_;
	vala_gir_writer_write_type (self, _tmp15_, -1, VALA_PARAMETER_DIRECTION_IN);
	_tmp16_ = self->priv->indent;
	self->priv->indent = _tmp16_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	g_string_append_printf (_tmp17_, "</field>\n");
	_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp20_ = _tmp19_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_ARRAY_TYPE)) {
		_tmp18_ = vala_get_ccode_array_length ((ValaCodeNode*) f);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaArrayType* _tmp23_;
		ValaArrayType* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp21_ = vala_variable_get_variable_type ((ValaVariable*) f);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp23_;
		_tmp24_ = array_type;
		_tmp25_ = vala_array_type_get_fixed_length (_tmp24_);
		_tmp26_ = _tmp25_;
		if (!_tmp26_) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp27_ = FALSE;
					_tmp27_ = TRUE;
					while (TRUE) {
						ValaArrayType* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						GString* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						GString* _tmp35_;
						gint _tmp36_;
						ValaArrayType* _tmp37_;
						ValaDataType* _tmp38_;
						ValaDataType* _tmp39_;
						gint _tmp40_;
						GString* _tmp41_;
						if (!_tmp27_) {
							gint _tmp28_;
							_tmp28_ = i;
							i = _tmp28_ + 1;
						}
						_tmp27_ = FALSE;
						_tmp29_ = array_type;
						_tmp30_ = vala_array_type_get_rank (_tmp29_);
						_tmp31_ = _tmp30_;
						if (!(i < _tmp31_)) {
							break;
						}
						vala_gir_writer_write_indent (self);
						_tmp32_ = self->priv->buffer;
						_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) f);
						_tmp34_ = _tmp33_;
						g_string_append_printf (_tmp32_, "<field name=\"%s_length%i\"", _tmp34_, i + 1);
						_g_free0 (_tmp34_);
						vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
						_tmp35_ = self->priv->buffer;
						g_string_append_printf (_tmp35_, ">\n");
						_tmp36_ = self->priv->indent;
						self->priv->indent = _tmp36_ + 1;
						_tmp37_ = array_type;
						_tmp38_ = vala_array_type_get_length_type (_tmp37_);
						_tmp39_ = _tmp38_;
						vala_gir_writer_write_type (self, _tmp39_, -1, VALA_PARAMETER_DIRECTION_IN);
						_tmp40_ = self->priv->indent;
						self->priv->indent = _tmp40_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp41_ = self->priv->buffer;
						g_string_append_printf (_tmp41_, "</field>\n");
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) f);
		_tmp43_ = _tmp42_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_DELEGATE_TYPE)) {
			ValaDelegateType* deleg_type = NULL;
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDelegateType* _tmp46_;
			ValaDelegateType* _tmp47_;
			ValaDelegate* _tmp48_;
			ValaDelegate* _tmp49_;
			gboolean _tmp50_;
			gboolean _tmp51_;
			_tmp44_ = vala_variable_get_variable_type ((ValaVariable*) f);
			_tmp45_ = _tmp44_;
			_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp46_;
			_tmp47_ = deleg_type;
			_tmp48_ = vala_delegate_type_get_delegate_symbol (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_delegate_get_has_target (_tmp49_);
			_tmp51_ = _tmp50_;
			if (_tmp51_) {
				GString* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				GString* _tmp55_;
				gint _tmp56_;
				GString* _tmp57_;
				gint _tmp58_;
				GString* _tmp59_;
				ValaDelegateType* _tmp60_;
				vala_gir_writer_write_indent (self);
				_tmp52_ = self->priv->buffer;
				_tmp53_ = vala_get_ccode_delegate_target_name ((ValaVariable*) f);
				_tmp54_ = _tmp53_;
				g_string_append_printf (_tmp52_, "<field name=\"%s\"", _tmp54_);
				_g_free0 (_tmp54_);
				vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
				_tmp55_ = self->priv->buffer;
				g_string_append_printf (_tmp55_, ">\n");
				_tmp56_ = self->priv->indent;
				self->priv->indent = _tmp56_ + 1;
				vala_gir_writer_write_indent (self);
				_tmp57_ = self->priv->buffer;
				g_string_append_printf (_tmp57_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
				_tmp58_ = self->priv->indent;
				self->priv->indent = _tmp58_ - 1;
				vala_gir_writer_write_indent (self);
				_tmp59_ = self->priv->buffer;
				g_string_append_printf (_tmp59_, "</field>\n");
				_tmp60_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp60_)) {
					GString* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					GString* _tmp64_;
					gint _tmp65_;
					GString* _tmp66_;
					gint _tmp67_;
					GString* _tmp68_;
					vala_gir_writer_write_indent (self);
					_tmp61_ = self->priv->buffer;
					_tmp62_ = vala_get_ccode_delegate_target_destroy_notify_name ((ValaVariable*) f);
					_tmp63_ = _tmp62_;
					g_string_append_printf (_tmp61_, "<field name=\"%s\"", _tmp63_);
					_g_free0 (_tmp63_);
					vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) f);
					_tmp64_ = self->priv->buffer;
					g_string_append_printf (_tmp64_, ">\n");
					_tmp65_ = self->priv->indent;
					self->priv->indent = _tmp65_ + 1;
					vala_gir_writer_write_indent (self);
					_tmp66_ = self->priv->buffer;
					g_string_append_printf (_tmp66_, "<type name=\"GLib.DestroyNotify\" c:type=\"GDestroyNotify\"/>\n");
					_tmp67_ = self->priv->indent;
					self->priv->indent = _tmp67_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp68_ = self->priv->buffer;
					g_string_append_printf (_tmp68_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}

static void
vala_gir_writer_write_implicit_params (ValaGIRWriter* self,
                                       ValaDataType* type,
                                       gint* index,
                                       gboolean has_array_length,
                                       const gchar* name,
                                       ValaParameterDirection direction)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
		_tmp0_ = has_array_length;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					gint _tmp4_;
					ValaDataType* _tmp5_;
					ValaDataType* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp4_ = _tmp3_;
					if (!(i < _tmp4_)) {
						break;
					}
					_tmp5_ = vala_array_type_get_length_type (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strdup_printf ("%s_length%i", name, i + 1);
					_tmp8_ = _tmp7_;
					vala_gir_writer_write_param_or_return (self, _tmp6_, "parameter", index, has_array_length, _tmp8_, NULL, direction, FALSE, FALSE, FALSE);
					_g_free0 (_tmp8_);
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_DELEGATE_TYPE)) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegateType* _tmp9_;
			ValaDelegateType* _tmp10_;
			ValaDelegate* _tmp11_;
			ValaDelegate* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp9_;
			_tmp10_ = deleg_type;
			_tmp11_ = vala_delegate_type_get_delegate_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_delegate_get_has_target (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				ValaPointerType* data_type = NULL;
				ValaVoidType* _tmp15_;
				ValaVoidType* _tmp16_;
				ValaPointerType* _tmp17_;
				ValaPointerType* _tmp18_;
				ValaPointerType* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				ValaDelegateType* _tmp22_;
				_tmp15_ = vala_void_type_new (NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_pointer_type_new ((ValaDataType*) _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_vala_code_node_unref0 (_tmp16_);
				data_type = _tmp18_;
				_tmp19_ = data_type;
				_tmp20_ = g_strdup_printf ("%s_target", name);
				_tmp21_ = _tmp20_;
				vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp19_, "parameter", index, FALSE, _tmp21_, NULL, direction, FALSE, FALSE, FALSE);
				_g_free0 (_tmp21_);
				_tmp22_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp22_)) {
					ValaDelegateType* notify_type = NULL;
					ValaCodeContext* _tmp23_;
					ValaNamespace* _tmp24_;
					ValaNamespace* _tmp25_;
					ValaScope* _tmp26_;
					ValaScope* _tmp27_;
					ValaSymbol* _tmp28_;
					ValaSymbol* _tmp29_;
					ValaScope* _tmp30_;
					ValaScope* _tmp31_;
					ValaSymbol* _tmp32_;
					ValaDelegate* _tmp33_;
					ValaDelegate* _tmp34_;
					ValaDelegateType* _tmp35_;
					ValaDelegateType* _tmp36_;
					ValaDelegateType* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp23_ = self->priv->context;
					_tmp24_ = vala_code_context_get_root (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = vala_scope_lookup (_tmp27_, "GLib");
					_tmp29_ = _tmp28_;
					_tmp30_ = vala_symbol_get_scope (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_scope_lookup (_tmp31_, "DestroyNotify");
					_tmp33_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, VALA_TYPE_DELEGATE) ? ((ValaDelegate*) _tmp32_) : NULL;
					if (_tmp33_ == NULL) {
						_vala_code_node_unref0 (_tmp32_);
					}
					_tmp34_ = _tmp33_;
					_tmp35_ = vala_delegate_type_new (_tmp34_, NULL);
					_tmp36_ = _tmp35_;
					_vala_code_node_unref0 (_tmp34_);
					_vala_code_node_unref0 (_tmp29_);
					notify_type = _tmp36_;
					_tmp37_ = notify_type;
					_tmp38_ = g_strdup_printf ("%s_target_destroy_notify", name);
					_tmp39_ = _tmp38_;
					vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp37_, "parameter", index, FALSE, _tmp39_, NULL, direction, FALSE, FALSE, FALSE);
					_g_free0 (_tmp39_);
					_vala_code_node_unref0 (notify_type);
				}
				_vala_code_node_unref0 (data_type);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}

static void
vala_gir_writer_skip_implicit_params (ValaGIRWriter* self,
                                      ValaDataType* type,
                                      gint* index,
                                      gboolean has_array_length)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
		_tmp0_ = has_array_length;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp2_ = _tmp1_;
		*index = (*index) + _tmp2_;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_DELEGATE_TYPE)) {
			gint _tmp3_;
			ValaDelegateType* deleg_type = NULL;
			ValaDelegateType* _tmp4_;
			ValaDelegateType* _tmp5_;
			_tmp3_ = *index;
			*index = _tmp3_ + 1;
			_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp4_;
			_tmp5_ = deleg_type;
			if (vala_data_type_is_disposable ((ValaDataType*) _tmp5_)) {
				gint _tmp6_;
				_tmp6_ = *index;
				*index = _tmp6_ + 1;
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_gir_writer_write_type_parameter (ValaGIRWriter* self,
                                      ValaTypeParameter* type_parameter,
                                      const gchar* tag_type)
{
	gint _tmp8_;
	GString* _tmp9_;
	gint _tmp10_;
	GString* _tmp11_;
	gint _tmp20_;
	GString* _tmp21_;
	gint _tmp22_;
	GString* _tmp23_;
	gint _tmp32_;
	GString* _tmp33_;
	gint _tmp34_;
	GString* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_parameter != NULL);
	g_return_if_fail (tag_type != NULL);
	vala_gir_writer_write_indent (self);
	if (g_strcmp0 (tag_type, "property") == 0) {
		GString* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->buffer;
		_tmp1_ = vala_get_ccode_type_id ((ValaCodeNode*) type_parameter);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_replace (_tmp2_, "_", "-");
		_tmp4_ = _tmp3_;
		g_string_append_printf (_tmp0_, "<%s name=\"%s\" writable=\"1\" construct-only=\"1\">\n", tag_type, _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		GString* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->buffer;
		_tmp6_ = vala_get_ccode_type_id ((ValaCodeNode*) type_parameter);
		_tmp7_ = _tmp6_;
		g_string_append_printf (_tmp5_, "<%s name=\"%s\" transfer-ownership=\"none\">\n", tag_type, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = self->priv->indent;
	self->priv->indent = _tmp8_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp9_ = self->priv->buffer;
	g_string_append_printf (_tmp9_, "<type name=\"GType\" c:type=\"GType\"/>\n");
	_tmp10_ = self->priv->indent;
	self->priv->indent = _tmp10_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	g_string_append_printf (_tmp11_, "</%s>\n", tag_type);
	vala_gir_writer_write_indent (self);
	if (g_strcmp0 (tag_type, "property") == 0) {
		GString* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = self->priv->buffer;
		_tmp13_ = vala_get_ccode_copy_function ((ValaTypeSymbol*) type_parameter);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_replace (_tmp14_, "_", "-");
		_tmp16_ = _tmp15_;
		g_string_append_printf (_tmp12_, "<%s name=\"%s\" writable=\"1\" construct-only=\"1\">\n", tag_type, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
	} else {
		GString* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = self->priv->buffer;
		_tmp18_ = vala_get_ccode_copy_function ((ValaTypeSymbol*) type_parameter);
		_tmp19_ = _tmp18_;
		g_string_append_printf (_tmp17_, "<%s name=\"%s\" transfer-ownership=\"none\">\n", tag_type, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->indent;
	self->priv->indent = _tmp20_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp21_ = self->priv->buffer;
	g_string_append_printf (_tmp21_, "<type name=\"GObject.BoxedCopyFunc\" c:type=\"GBoxedCopyFunc\"/>\n");
	_tmp22_ = self->priv->indent;
	self->priv->indent = _tmp22_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp23_ = self->priv->buffer;
	g_string_append_printf (_tmp23_, "</%s>\n", tag_type);
	vala_gir_writer_write_indent (self);
	if (g_strcmp0 (tag_type, "property") == 0) {
		GString* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = self->priv->buffer;
		_tmp25_ = vala_get_ccode_destroy_function ((ValaTypeSymbol*) type_parameter);
		_tmp26_ = _tmp25_;
		_tmp27_ = string_replace (_tmp26_, "_", "-");
		_tmp28_ = _tmp27_;
		g_string_append_printf (_tmp24_, "<%s name=\"%s\" writable=\"1\" construct-only=\"1\">\n", tag_type, _tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
	} else {
		GString* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp29_ = self->priv->buffer;
		_tmp30_ = vala_get_ccode_destroy_function ((ValaTypeSymbol*) type_parameter);
		_tmp31_ = _tmp30_;
		g_string_append_printf (_tmp29_, "<%s name=\"%s\" transfer-ownership=\"none\">\n", tag_type, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = self->priv->indent;
	self->priv->indent = _tmp32_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp33_ = self->priv->buffer;
	g_string_append_printf (_tmp33_, "<type name=\"GLib.DestroyNotify\" c:type=\"GDestroyNotify\"/>\n");
	_tmp34_ = self->priv->indent;
	self->priv->indent = _tmp34_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp35_ = self->priv->buffer;
	g_string_append_printf (_tmp35_, "</%s>\n", tag_type);
}

static void
vala_gir_writer_write_params_and_return (ValaGIRWriter* self,
                                         const gchar* tag_name,
                                         ValaList* params,
                                         ValaList* type_params,
                                         ValaDataType* return_type,
                                         gboolean return_array_length,
                                         const gchar* return_comment,
                                         gboolean constructor,
                                         ValaParameter* instance_param,
                                         gboolean user_data)
{
	gint last_index = 0;
	gboolean _tmp0_ = FALSE;
	gboolean ret_is_struct = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gint _tmp31_;
	gint _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (params != NULL);
	last_index = 0;
	if (return_type != NULL) {
		_tmp0_ = vala_data_type_is_real_non_null_struct_type (return_type);
	} else {
		_tmp0_ = FALSE;
	}
	ret_is_struct = _tmp0_;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) params);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != 0) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE)) {
			_tmp6_ = return_array_length;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp3_ = _tmp6_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_DELEGATE_TYPE);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ret_is_struct;
	}
	if (_tmp1_) {
		gint index = 0;
		index = 0;
		{
			ValaList* _param_list = NULL;
			gint _param_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _param_index = 0;
			_param_list = params;
			_tmp7_ = _param_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_param_size = _tmp9_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				ValaParameter* param = NULL;
				ValaList* _tmp12_;
				gpointer _tmp13_;
				gint _tmp14_;
				ValaParameter* _tmp15_;
				ValaDataType* _tmp16_;
				ValaDataType* _tmp17_;
				ValaParameter* _tmp18_;
				_param_index = _param_index + 1;
				_tmp10_ = _param_index;
				_tmp11_ = _param_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _param_list;
				_tmp13_ = vala_list_get (_tmp12_, _param_index);
				param = (ValaParameter*) _tmp13_;
				_tmp14_ = index;
				index = _tmp14_ + 1;
				_tmp15_ = param;
				_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = param;
				vala_gir_writer_skip_implicit_params (self, _tmp17_, &index, vala_get_ccode_array_length ((ValaCodeNode*) _tmp18_));
				_vala_code_node_unref0 (param);
			}
		}
		if (ret_is_struct) {
			gint _tmp19_;
			_tmp19_ = index;
			index = _tmp19_ + 1;
		} else {
			gboolean _tmp20_ = FALSE;
			vala_gir_writer_skip_implicit_params (self, return_type, &index, return_array_length);
			if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE)) {
				_tmp20_ = return_array_length;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				gint _tmp21_;
				gint _tmp22_;
				_tmp21_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (return_type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp22_ = _tmp21_;
				index -= _tmp22_ - 1;
			}
		}
		last_index = index - 1;
	}
	if (return_type != NULL) {
		_tmp23_ = !ret_is_struct;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		vala_gir_writer_write_param_or_return (self, return_type, "return-value", &last_index, return_array_length, NULL, return_comment, VALA_PARAMETER_DIRECTION_IN, constructor, FALSE, FALSE);
	} else {
		if (ret_is_struct) {
			ValaVoidType* _tmp24_;
			ValaVoidType* _tmp25_;
			_tmp24_ = vala_void_type_new (NULL);
			_tmp25_ = _tmp24_;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp25_, "return-value", &last_index, FALSE, NULL, return_comment, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE, FALSE);
			_vala_code_node_unref0 (_tmp25_);
		}
	}
	_tmp31_ = vala_collection_get_size ((ValaCollection*) params);
	_tmp32_ = _tmp31_;
	if (_tmp32_ != 0) {
		_tmp30_ = TRUE;
	} else {
		gboolean _tmp33_ = FALSE;
		if (type_params != NULL) {
			gint _tmp34_;
			gint _tmp35_;
			_tmp34_ = vala_collection_get_size ((ValaCollection*) type_params);
			_tmp35_ = _tmp34_;
			_tmp33_ = _tmp35_ > 0;
		} else {
			_tmp33_ = FALSE;
		}
		_tmp30_ = _tmp33_;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = instance_param != NULL;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		gboolean _tmp36_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE)) {
			_tmp36_ = return_array_length;
		} else {
			_tmp36_ = FALSE;
		}
		_tmp28_ = _tmp36_;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_DELEGATE_TYPE);
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = ret_is_struct;
	}
	if (_tmp26_) {
		GString* _tmp37_;
		gint _tmp38_;
		gint index = 0;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp98_ = FALSE;
		gint _tmp104_;
		GString* _tmp105_;
		vala_gir_writer_write_indent (self);
		_tmp37_ = self->priv->buffer;
		g_string_append_printf (_tmp37_, "<parameters>\n");
		_tmp38_ = self->priv->indent;
		self->priv->indent = _tmp38_ + 1;
		index = 0;
		if (instance_param != NULL) {
			ValaDataType* type = NULL;
			ValaDataType* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaStruct* st = NULL;
			ValaDataType* _tmp42_;
			ValaTypeSymbol* _tmp43_;
			ValaTypeSymbol* _tmp44_;
			gboolean _tmp45_ = FALSE;
			ValaStruct* _tmp46_;
			gint skip = 0;
			_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) instance_param);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_data_type_copy (_tmp40_);
			type = _tmp41_;
			_tmp42_ = type;
			_tmp43_ = vala_data_type_get_type_symbol (_tmp42_);
			_tmp44_ = _tmp43_;
			st = G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp44_) : NULL;
			_tmp46_ = st;
			if (_tmp46_ != NULL) {
				ValaStruct* _tmp47_;
				_tmp47_ = st;
				_tmp45_ = !vala_struct_is_simple_type (_tmp47_);
			} else {
				_tmp45_ = FALSE;
			}
			if (_tmp45_) {
				ValaDataType* _tmp48_;
				_tmp48_ = type;
				vala_data_type_set_nullable (_tmp48_, TRUE);
			}
			skip = 0;
			if (g_strcmp0 (tag_name, "callback") == 0) {
				ValaDataType* _tmp49_;
				gint _tmp50_;
				_tmp49_ = type;
				vala_gir_writer_write_param_or_return (self, _tmp49_, "parameter", &skip, FALSE, "self", NULL, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE, FALSE);
				_tmp50_ = index;
				index = _tmp50_ + 1;
			} else {
				ValaDataType* _tmp51_;
				_tmp51_ = type;
				vala_gir_writer_write_param_or_return (self, _tmp51_, "instance-parameter", &skip, FALSE, "self", NULL, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE, FALSE);
			}
			_vala_code_node_unref0 (type);
		}
		if (constructor) {
			_tmp52_ = ret_is_struct;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			vala_gir_writer_write_param_or_return (self, return_type, "instance-parameter", &index, FALSE, "self", return_comment, VALA_PARAMETER_DIRECTION_OUT, constructor, TRUE, FALSE);
		}
		if (type_params != NULL) {
			{
				ValaList* _p_list = NULL;
				gint _p_size = 0;
				ValaList* _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				gint _p_index = 0;
				_p_list = type_params;
				_tmp53_ = _p_list;
				_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
				_tmp55_ = _tmp54_;
				_p_size = _tmp55_;
				_p_index = -1;
				while (TRUE) {
					gint _tmp56_;
					gint _tmp57_;
					ValaTypeParameter* p = NULL;
					ValaList* _tmp58_;
					gpointer _tmp59_;
					ValaTypeParameter* _tmp60_;
					_p_index = _p_index + 1;
					_tmp56_ = _p_index;
					_tmp57_ = _p_size;
					if (!(_tmp56_ < _tmp57_)) {
						break;
					}
					_tmp58_ = _p_list;
					_tmp59_ = vala_list_get (_tmp58_, _p_index);
					p = (ValaTypeParameter*) _tmp59_;
					_tmp60_ = p;
					vala_gir_writer_write_type_parameter (self, _tmp60_, "parameter");
					index += 3;
					_vala_code_node_unref0 (p);
				}
			}
		}
		{
			ValaList* _param_list = NULL;
			gint _param_size = 0;
			ValaList* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			gint _param_index = 0;
			_param_list = params;
			_tmp61_ = _param_list;
			_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
			_tmp63_ = _tmp62_;
			_param_size = _tmp63_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp64_;
				gint _tmp65_;
				ValaParameter* param = NULL;
				ValaList* _tmp66_;
				gpointer _tmp67_;
				gboolean _tmp68_ = FALSE;
				ValaParameter* _tmp69_;
				gboolean _tmp70_;
				gboolean _tmp71_;
				ValaParameter* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaParameter* _tmp78_;
				ValaParameter* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				ValaParameter* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				ValaParameter* _tmp85_;
				ValaParameterDirection _tmp86_;
				ValaParameterDirection _tmp87_;
				ValaParameter* _tmp88_;
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				ValaParameter* _tmp91_;
				ValaParameter* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				ValaParameter* _tmp95_;
				ValaParameterDirection _tmp96_;
				ValaParameterDirection _tmp97_;
				_param_index = _param_index + 1;
				_tmp64_ = _param_index;
				_tmp65_ = _param_size;
				if (!(_tmp64_ < _tmp65_)) {
					break;
				}
				_tmp66_ = _param_list;
				_tmp67_ = vala_list_get (_tmp66_, _param_index);
				param = (ValaParameter*) _tmp67_;
				_tmp69_ = param;
				_tmp70_ = vala_parameter_get_ellipsis (_tmp69_);
				_tmp71_ = _tmp70_;
				if (_tmp71_) {
					_tmp68_ = TRUE;
				} else {
					ValaParameter* _tmp72_;
					gboolean _tmp73_;
					gboolean _tmp74_;
					_tmp72_ = param;
					_tmp73_ = vala_parameter_get_params_array (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp68_ = _tmp74_;
				}
				_tmp75_ = param;
				_tmp76_ = vala_variable_get_variable_type ((ValaVariable*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = param;
				_tmp79_ = param;
				_tmp80_ = vala_get_ccode_name ((ValaCodeNode*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = param;
				_tmp83_ = vala_gir_writer_get_parameter_comment (self, _tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = param;
				_tmp86_ = vala_parameter_get_direction (_tmp85_);
				_tmp87_ = _tmp86_;
				vala_gir_writer_write_param_or_return (self, _tmp77_, "parameter", &index, vala_get_ccode_array_length ((ValaCodeNode*) _tmp78_), _tmp81_, _tmp84_, _tmp87_, FALSE, FALSE, _tmp68_);
				_g_free0 (_tmp84_);
				_g_free0 (_tmp81_);
				_tmp88_ = param;
				_tmp89_ = vala_variable_get_variable_type ((ValaVariable*) _tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = param;
				_tmp92_ = param;
				_tmp93_ = vala_get_ccode_name ((ValaCodeNode*) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = param;
				_tmp96_ = vala_parameter_get_direction (_tmp95_);
				_tmp97_ = _tmp96_;
				vala_gir_writer_write_implicit_params (self, _tmp90_, &index, vala_get_ccode_array_length ((ValaCodeNode*) _tmp91_), _tmp94_, _tmp97_);
				_g_free0 (_tmp94_);
				_vala_code_node_unref0 (param);
			}
		}
		if (!constructor) {
			_tmp98_ = ret_is_struct;
		} else {
			_tmp98_ = FALSE;
		}
		if (_tmp98_) {
			vala_gir_writer_write_param_or_return (self, return_type, "parameter", &index, FALSE, "result", return_comment, VALA_PARAMETER_DIRECTION_OUT, constructor, TRUE, FALSE);
		} else {
			if (!constructor) {
				vala_gir_writer_write_implicit_params (self, return_type, &index, return_array_length, "result", VALA_PARAMETER_DIRECTION_OUT);
			}
		}
		if (user_data) {
			GString* _tmp99_;
			gint _tmp100_;
			GString* _tmp101_;
			gint _tmp102_;
			GString* _tmp103_;
			vala_gir_writer_write_indent (self);
			_tmp99_ = self->priv->buffer;
			g_string_append_printf (_tmp99_, "<parameter name=\"user_data\" transfer-ownership=\"none\" closure=\"%d" \
"\">\n", index);
			_tmp100_ = self->priv->indent;
			self->priv->indent = _tmp100_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp101_ = self->priv->buffer;
			g_string_append_printf (_tmp101_, "<type name=\"gpointer\" c:type=\"void*\"/>\n");
			_tmp102_ = self->priv->indent;
			self->priv->indent = _tmp102_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp103_ = self->priv->buffer;
			g_string_append_printf (_tmp103_, "</parameter>\n");
		}
		_tmp104_ = self->priv->indent;
		self->priv->indent = _tmp104_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp105_ = self->priv->buffer;
		g_string_append_printf (_tmp105_, "</parameters>\n");
	}
}

static void
vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base,
                                     ValaDelegate* cb)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GString* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaList* _tmp15_;
	ValaList* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gint _tmp23_;
	GString* _tmp24_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) cb);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) cb)) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) cb)) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) cb);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp2_, "<callback name=\"%s\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = vala_get_ccode_name ((ValaCodeNode*) cb);
	_tmp7_ = _tmp6_;
	g_string_append_printf (_tmp5_, " c:type=\"%s\"", _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) cb);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GString* _tmp10_;
		_tmp10_ = self->priv->buffer;
		g_string_append_printf (_tmp10_, " throws=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) cb);
	_tmp11_ = self->priv->buffer;
	g_string_append_printf (_tmp11_, ">\n");
	_tmp12_ = self->priv->indent;
	self->priv->indent = _tmp12_ + 1;
	_tmp13_ = vala_gir_writer_get_delegate_comment (self, cb);
	_tmp14_ = _tmp13_;
	vala_gir_writer_write_doc (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = vala_callable_get_parameters ((ValaCallable*) cb);
	_tmp16_ = vala_delegate_get_type_parameters (cb);
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) cb);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_gir_writer_get_delegate_return_comment (self, cb);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_delegate_get_has_target (cb);
	_tmp22_ = _tmp21_;
	vala_gir_writer_write_params_and_return (self, "callback", _tmp15_, _tmp16_, _tmp18_, vala_get_ccode_array_length ((ValaCodeNode*) cb), _tmp20_, FALSE, NULL, _tmp22_);
	_g_free0 (_tmp20_);
	_tmp23_ = self->priv->indent;
	self->priv->indent = _tmp23_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp24_ = self->priv->buffer;
	g_string_append_printf (_tmp24_, "</callback>\n");
}

static void
vala_gir_writer_real_visit_method (ValaCodeVisitor* base,
                                   ValaMethod* m)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* tag_name = NULL;
	gchar* _tmp14_;
	ValaSymbol* parent = NULL;
	ValaArrayList* _tmp15_;
	gpointer _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	ValaSymbol* _tmp21_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp34_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) m);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) m)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = vala_method_get_overrides (m);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_interface_method (m);
		_tmp9_ = _tmp8_;
		if (_tmp9_ != NULL) {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = vala_method_get_is_abstract (m);
			_tmp11_ = _tmp10_;
			_tmp7_ = !_tmp11_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp12_ = vala_method_get_is_virtual (m);
			_tmp13_ = _tmp12_;
			_tmp6_ = !_tmp13_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		return;
	}
	if (!vala_gir_writer_has_namespace (self, (ValaSymbol*) m)) {
		return;
	}
	_tmp14_ = g_strdup ("method");
	tag_name = _tmp14_;
	_tmp15_ = self->priv->hierarchy;
	_tmp16_ = vala_list_get ((ValaList*) _tmp15_, 0);
	parent = (ValaSymbol*) _tmp16_;
	_tmp17_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_ENUM)) {
		ValaArrayList* _tmp18_;
		_tmp18_ = self->priv->deferred;
		vala_collection_add ((ValaCollection*) _tmp18_, (ValaCodeNode*) m);
		_vala_code_node_unref0 (parent);
		_g_free0 (tag_name);
		return;
	}
	_tmp21_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_NAMESPACE)) {
		_tmp20_ = TRUE;
	} else {
		ValaMemberBinding _tmp22_;
		ValaMemberBinding _tmp23_;
		_tmp22_ = vala_method_get_binding (m);
		_tmp23_ = _tmp22_;
		_tmp20_ = _tmp23_ == VALA_MEMBER_BINDING_STATIC;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp24_ = parent;
		_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp26_ = _tmp25_;
		_tmp19_ = _tmp24_ != _tmp26_;
	}
	if (_tmp19_) {
		gchar* _tmp27_;
		_tmp27_ = g_strdup ("function");
		_g_free0 (tag_name);
		tag_name = _tmp27_;
	}
	if (!vala_get_ccode_no_wrapper (m)) {
		ValaSignal* _tmp29_;
		ValaSignal* _tmp30_;
		_tmp29_ = vala_method_get_signal_reference (m);
		_tmp30_ = _tmp29_;
		_tmp28_ = _tmp30_ == NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		const gchar* _tmp31_;
		_tmp31_ = tag_name;
		vala_gir_writer_write_signature (self, m, _tmp31_, TRUE, FALSE, TRUE);
	}
	_tmp33_ = vala_method_get_is_abstract (m);
	_tmp34_ = _tmp33_;
	if (_tmp34_) {
		_tmp32_ = TRUE;
	} else {
		gboolean _tmp35_;
		gboolean _tmp36_;
		_tmp35_ = vala_method_get_is_virtual (m);
		_tmp36_ = _tmp35_;
		_tmp32_ = _tmp36_;
	}
	if (_tmp32_) {
		vala_gir_writer_write_signature (self, m, "virtual-method", TRUE, FALSE, TRUE);
	}
	_vala_code_node_unref0 (parent);
	_g_free0 (tag_name);
}

static gboolean
vala_gir_writer_is_type_introspectable (ValaGIRWriter* self,
                                        ValaDataType* type)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "va_list") == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
vala_gir_writer_is_method_introspectable (ValaGIRWriter* self,
                                          ValaMethod* m)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp1_ = _tmp0_;
	if (!vala_gir_writer_is_type_introspectable (self, _tmp1_)) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		gint _param_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _param_index = 0;
		_tmp2_ = vala_callable_get_parameters ((ValaCallable*) m);
		_param_list = _tmp2_;
		_tmp3_ = _param_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaParameter* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_param_index = _param_index + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = vala_list_get (_tmp8_, _param_index);
			param = (ValaParameter*) _tmp9_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_ellipsis (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				_tmp11_ = TRUE;
			} else {
				ValaParameter* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = param;
				_tmp16_ = vala_parameter_get_params_array (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = _tmp17_;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				ValaParameter* _tmp18_;
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				_tmp18_ = param;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp10_ = !vala_gir_writer_is_type_introspectable (self, _tmp20_);
			}
			if (_tmp10_) {
				result = FALSE;
				_vala_code_node_unref0 (param);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_gir_writer_is_introspectable (ValaGIRWriter* self,
                                   ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
		_tmp0_ = !vala_gir_writer_is_method_introspectable (self, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = vala_gir_writer_is_visibility (self, sym);
	return result;
}

static void
vala_gir_writer_write_signature (ValaGIRWriter* self,
                                 ValaMethod* m,
                                 const gchar* tag_name,
                                 gboolean write_doc,
                                 gboolean instance,
                                 gboolean write_attributes)
{
	ValaSymbol* parent = NULL;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_;
	gchar* name = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	parent = (ValaSymbol*) _tmp1_;
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp3_ = _tmp2_;
	_tmp4_ = parent;
	if (_tmp3_ != _tmp4_) {
		gchar* _tmp5_;
		gchar* parent_prefix = NULL;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		instance = FALSE;
		_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_g_free0 (name);
		name = _tmp5_;
		_tmp6_ = parent;
		_tmp7_ = vala_get_ccode_lower_case_prefix (_tmp6_);
		parent_prefix = _tmp7_;
		_tmp8_ = name;
		_tmp9_ = parent_prefix;
		if (g_str_has_prefix (_tmp8_, _tmp9_)) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gchar* _tmp14_;
			_tmp10_ = name;
			_tmp11_ = parent_prefix;
			_tmp12_ = strlen (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = string_substring (_tmp10_, (glong) _tmp13_, (glong) -1);
			_g_free0 (name);
			name = _tmp14_;
		}
		_g_free0 (parent_prefix);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (name);
		name = _tmp17_;
	}
	_tmp18_ = vala_method_get_coroutine (m);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		gchar* finish_name = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		ValaList* _tmp35_;
		ValaVoidType* _tmp36_;
		ValaVoidType* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		ValaList* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp20_ = name;
		_tmp21_ = g_strdup (_tmp20_);
		finish_name = _tmp21_;
		_tmp22_ = finish_name;
		if (g_str_has_suffix (_tmp22_, "_async")) {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gchar* _tmp29_;
			_tmp23_ = finish_name;
			_tmp24_ = finish_name;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = strlen ("_async");
			_tmp28_ = _tmp27_;
			_tmp29_ = string_substring (_tmp23_, (glong) 0, (glong) (_tmp26_ - _tmp28_));
			_g_free0 (finish_name);
			finish_name = _tmp29_;
		}
		_tmp30_ = finish_name;
		_tmp31_ = g_strconcat (_tmp30_, "_finish", NULL);
		_g_free0 (finish_name);
		finish_name = _tmp31_;
		_tmp32_ = name;
		_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_method_get_async_begin_parameters (m);
		_tmp36_ = vala_void_type_new (NULL);
		_tmp37_ = _tmp36_;
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, _tmp32_, _tmp34_, _tmp35_, (ValaDataType*) _tmp37_, FALSE, TRUE, write_attributes);
		_vala_code_node_unref0 (_tmp37_);
		_g_free0 (_tmp34_);
		_tmp38_ = finish_name;
		_tmp39_ = vala_get_ccode_finish_name (m);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_method_get_async_end_parameters (m);
		_tmp42_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
		_tmp45_ = _tmp44_;
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, _tmp38_, _tmp40_, _tmp41_, _tmp43_, _tmp45_, FALSE, write_attributes);
		_g_free0 (_tmp40_);
		_g_free0 (finish_name);
	} else {
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		ValaList* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		gboolean _tmp52_;
		gboolean _tmp53_;
		_tmp46_ = name;
		_tmp47_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_callable_get_parameters ((ValaCallable*) m);
		_tmp50_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
		_tmp53_ = _tmp52_;
		vala_gir_writer_do_write_signature (self, m, tag_name, instance, _tmp46_, _tmp48_, _tmp49_, _tmp51_, _tmp53_, TRUE, write_attributes);
		_g_free0 (_tmp48_);
	}
	_g_free0 (name);
	_vala_code_node_unref0 (parent);
}

static void
vala_gir_writer_do_write_signature (ValaGIRWriter* self,
                                    ValaMethod* m,
                                    const gchar* tag_name,
                                    gboolean instance,
                                    const gchar* name,
                                    const gchar* cname,
                                    ValaList* params,
                                    ValaDataType* return_type,
                                    gboolean can_fail,
                                    gboolean write_comment,
                                    gboolean write_attributes)
{
	GString* _tmp0_;
	GString* _tmp5_;
	gint _tmp6_;
	gchar* return_comment = NULL;
	ValaList* _tmp10_;
	const gchar* _tmp11_;
	ValaParameter* _tmp12_;
	ValaParameter* _tmp13_;
	gint _tmp14_;
	GString* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	g_string_append_printf (_tmp0_, "<%s name=\"%s\"", tag_name, name);
	if (g_strcmp0 (tag_name, "virtual-method") == 0) {
		if (!vala_get_ccode_no_wrapper (m)) {
			GString* _tmp1_;
			_tmp1_ = self->priv->buffer;
			g_string_append_printf (_tmp1_, " invoker=\"%s\"", name);
		}
	} else {
		if (g_strcmp0 (tag_name, "callback") == 0) {
			GString* _tmp2_;
			_tmp2_ = self->priv->buffer;
			g_string_append_printf (_tmp2_, " c:type=\"%s\"", name);
		} else {
			GString* _tmp3_;
			_tmp3_ = self->priv->buffer;
			g_string_append_printf (_tmp3_, " c:identifier=\"%s\"", cname);
		}
	}
	if (can_fail) {
		GString* _tmp4_;
		_tmp4_ = self->priv->buffer;
		g_string_append_printf (_tmp4_, " throws=\"1\"");
	}
	if (write_attributes) {
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) m);
	}
	_tmp5_ = self->priv->buffer;
	g_string_append_printf (_tmp5_, ">\n");
	_tmp6_ = self->priv->indent;
	self->priv->indent = _tmp6_ + 1;
	return_comment = NULL;
	if (write_comment) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = vala_gir_writer_get_method_return_comment (self, m);
		_g_free0 (return_comment);
		return_comment = _tmp7_;
		_tmp8_ = vala_gir_writer_get_method_comment (self, m);
		_tmp9_ = _tmp8_;
		vala_gir_writer_write_doc (self, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = vala_method_get_type_parameters (m);
	_tmp11_ = return_comment;
	_tmp12_ = vala_method_get_this_parameter (m);
	_tmp13_ = _tmp12_;
	vala_gir_writer_write_params_and_return (self, tag_name, params, _tmp10_, return_type, vala_get_ccode_array_length ((ValaCodeNode*) m), _tmp11_, FALSE, _tmp13_, FALSE);
	_tmp14_ = self->priv->indent;
	self->priv->indent = _tmp14_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp15_ = self->priv->buffer;
	g_string_append_printf (_tmp15_, "</%s>\n", tag_name);
	_g_free0 (return_comment);
}

static void
vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base,
                                            ValaCreationMethod* m)
{
	ValaGIRWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean is_struct = FALSE;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* tag_name = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	GString* _tmp50_;
	gint _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	ValaDataType* datatype = NULL;
	ValaSymbol* _tmp54_;
	ValaSymbol* _tmp55_;
	ValaDataType* _tmp56_;
	ValaList* type_params = NULL;
	ValaSymbol* _tmp57_;
	ValaSymbol* _tmp58_;
	const gchar* _tmp63_;
	ValaList* _tmp64_;
	ValaList* _tmp65_;
	ValaDataType* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gint _tmp69_;
	GString* _tmp70_;
	const gchar* _tmp71_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) m);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) m)) {
		return;
	}
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_class_get_is_abstract (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_CLASS, ValaClass));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp10_ = _tmp9_;
	is_struct = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_STRUCT);
	if (is_struct) {
		_tmp11_ = "method";
	} else {
		_tmp11_ = "constructor";
	}
	_tmp12_ = g_strdup (_tmp11_);
	tag_name = _tmp12_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp16_ = _tmp15_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaCreationMethod* _tmp19_;
		ValaCreationMethod* _tmp20_;
		_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_class_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass));
		_tmp20_ = _tmp19_;
		_tmp14_ = m == _tmp20_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp23_ = _tmp22_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_STRUCT)) {
			ValaSymbol* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaCreationMethod* _tmp26_;
			ValaCreationMethod* _tmp27_;
			_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_struct_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_STRUCT, ValaStruct));
			_tmp27_ = _tmp26_;
			_tmp21_ = m == _tmp27_;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp13_ = _tmp21_;
	}
	if (_tmp13_) {
		const gchar* _tmp28_ = NULL;
		gchar* m_name = NULL;
		gchar* _tmp29_;
		GString* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		if (is_struct) {
			_tmp28_ = "init";
		} else {
			_tmp28_ = "new";
		}
		_tmp29_ = g_strdup (_tmp28_);
		m_name = _tmp29_;
		_tmp30_ = self->priv->buffer;
		_tmp31_ = tag_name;
		_tmp32_ = m_name;
		_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_tmp34_ = _tmp33_;
		g_string_append_printf (_tmp30_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp31_, _tmp32_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (m_name);
	} else {
		if (is_struct) {
			GString* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp35_ = self->priv->buffer;
			_tmp36_ = tag_name;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_get_ccode_name ((ValaCodeNode*) m);
			_tmp40_ = _tmp39_;
			g_string_append_printf (_tmp35_, "<%s name=\"init_%s\" c:identifier=\"%s\"", _tmp36_, _tmp38_, _tmp40_);
			_g_free0 (_tmp40_);
		} else {
			GString* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp41_ = self->priv->buffer;
			_tmp42_ = tag_name;
			_tmp43_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_get_ccode_name ((ValaCodeNode*) m);
			_tmp46_ = _tmp45_;
			g_string_append_printf (_tmp41_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp42_, _tmp44_, _tmp46_);
			_g_free0 (_tmp46_);
		}
	}
	_tmp47_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) m);
	_tmp48_ = _tmp47_;
	if (_tmp48_) {
		GString* _tmp49_;
		_tmp49_ = self->priv->buffer;
		g_string_append_printf (_tmp49_, " throws=\"1\"");
	}
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) m);
	_tmp50_ = self->priv->buffer;
	g_string_append_printf (_tmp50_, ">\n");
	_tmp51_ = self->priv->indent;
	self->priv->indent = _tmp51_ + 1;
	_tmp52_ = vala_gir_writer_get_method_comment (self, (ValaMethod*) m);
	_tmp53_ = _tmp52_;
	vala_gir_writer_write_doc (self, _tmp53_);
	_g_free0 (_tmp53_);
	_tmp54_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp55_);
	datatype = _tmp56_;
	type_params = NULL;
	_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp58_ = _tmp57_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp59_;
		ValaSymbol* _tmp60_;
		ValaList* _tmp61_;
		ValaList* _tmp62_;
		_tmp59_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_CLASS, ValaClass));
		_tmp62_ = _vala_iterable_ref0 (_tmp61_);
		_vala_iterable_unref0 (type_params);
		type_params = _tmp62_;
	}
	_tmp63_ = tag_name;
	_tmp64_ = vala_callable_get_parameters ((ValaCallable*) m);
	_tmp65_ = type_params;
	_tmp66_ = datatype;
	_tmp67_ = vala_gir_writer_get_method_return_comment (self, (ValaMethod*) m);
	_tmp68_ = _tmp67_;
	vala_gir_writer_write_params_and_return (self, _tmp63_, _tmp64_, _tmp65_, _tmp66_, FALSE, _tmp68_, TRUE, NULL, FALSE);
	_g_free0 (_tmp68_);
	_tmp69_ = self->priv->indent;
	self->priv->indent = _tmp69_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp70_ = self->priv->buffer;
	_tmp71_ = tag_name;
	g_string_append_printf (_tmp70_, "</%s>\n", _tmp71_);
	_vala_iterable_unref0 (type_params);
	_vala_code_node_unref0 (datatype);
	_g_free0 (tag_name);
}

static void
vala_gir_writer_real_visit_property (ValaCodeVisitor* base,
                                     ValaProperty* prop)
{
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp12_;
	ValaSemanticAnalyzer* _tmp13_;
	ValaSemanticAnalyzer* _tmp14_;
	gboolean _tmp42_ = FALSE;
	ValaPropertyAccessor* _tmp43_;
	ValaPropertyAccessor* _tmp44_;
	gboolean _tmp54_ = FALSE;
	ValaPropertyAccessor* _tmp55_;
	ValaPropertyAccessor* _tmp56_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (prop != NULL);
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) prop)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_property_get_overrides (prop);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaProperty* _tmp6_;
		ValaProperty* _tmp7_;
		_tmp6_ = vala_property_get_base_interface_property (prop);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = vala_property_get_is_abstract (prop);
			_tmp9_ = _tmp8_;
			_tmp5_ = !_tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = vala_property_get_is_virtual (prop);
			_tmp11_ = _tmp10_;
			_tmp4_ = !_tmp11_;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp12_ = self->priv->context;
	_tmp13_ = vala_code_context_get_analyzer (_tmp12_);
	_tmp14_ = _tmp13_;
	if (vala_semantic_analyzer_is_gobject_property (_tmp14_, prop)) {
		GString* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaPropertyAccessor* _tmp18_;
		ValaPropertyAccessor* _tmp19_;
		ValaPropertyAccessor* _tmp21_;
		ValaPropertyAccessor* _tmp22_;
		GString* _tmp34_;
		gint _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		gint _tmp40_;
		GString* _tmp41_;
		vala_gir_writer_write_indent (self);
		_tmp15_ = self->priv->buffer;
		_tmp16_ = vala_get_ccode_name ((ValaCodeNode*) prop);
		_tmp17_ = _tmp16_;
		g_string_append_printf (_tmp15_, "<property name=\"%s\"", _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = vala_property_get_get_accessor (prop);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == NULL) {
			GString* _tmp20_;
			_tmp20_ = self->priv->buffer;
			g_string_append_printf (_tmp20_, " readable=\"0\"");
		}
		_tmp21_ = vala_property_get_set_accessor (prop);
		_tmp22_ = _tmp21_;
		if (_tmp22_ != NULL) {
			GString* _tmp23_;
			ValaPropertyAccessor* _tmp24_;
			ValaPropertyAccessor* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			_tmp23_ = self->priv->buffer;
			g_string_append_printf (_tmp23_, " writable=\"1\"");
			_tmp24_ = vala_property_get_set_accessor (prop);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_property_accessor_get_construction (_tmp25_);
			_tmp27_ = _tmp26_;
			if (_tmp27_) {
				ValaPropertyAccessor* _tmp28_;
				ValaPropertyAccessor* _tmp29_;
				gboolean _tmp30_;
				gboolean _tmp31_;
				_tmp28_ = vala_property_get_set_accessor (prop);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_property_accessor_get_writable (_tmp29_);
				_tmp31_ = _tmp30_;
				if (!_tmp31_) {
					GString* _tmp32_;
					_tmp32_ = self->priv->buffer;
					g_string_append_printf (_tmp32_, " construct-only=\"1\"");
				} else {
					GString* _tmp33_;
					_tmp33_ = self->priv->buffer;
					g_string_append_printf (_tmp33_, " construct=\"1\"");
				}
			}
		}
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) prop);
		_tmp34_ = self->priv->buffer;
		g_string_append_printf (_tmp34_, ">\n");
		_tmp35_ = self->priv->indent;
		self->priv->indent = _tmp35_ + 1;
		_tmp36_ = vala_gir_writer_get_property_comment (self, prop);
		_tmp37_ = _tmp36_;
		vala_gir_writer_write_doc (self, _tmp37_);
		_g_free0 (_tmp37_);
		_tmp38_ = vala_property_get_property_type (prop);
		_tmp39_ = _tmp38_;
		vala_gir_writer_write_type (self, _tmp39_, -1, VALA_PARAMETER_DIRECTION_IN);
		_tmp40_ = self->priv->indent;
		self->priv->indent = _tmp40_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp41_ = self->priv->buffer;
		g_string_append_printf (_tmp41_, "</property>\n");
	}
	_tmp43_ = vala_property_get_get_accessor (prop);
	_tmp44_ = _tmp43_;
	if (_tmp44_ != NULL) {
		ValaPropertyAccessor* _tmp45_;
		ValaPropertyAccessor* _tmp46_;
		gboolean _tmp47_;
		gboolean _tmp48_;
		_tmp45_ = vala_property_get_get_accessor (prop);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_property_accessor_get_readable (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp42_ = _tmp48_;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		ValaMethod* m = NULL;
		ValaPropertyAccessor* _tmp49_;
		ValaPropertyAccessor* _tmp50_;
		ValaMethod* _tmp51_;
		ValaMethod* _tmp52_;
		_tmp49_ = vala_property_get_get_accessor (prop);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_property_accessor_get_method (_tmp50_);
		m = _tmp51_;
		_tmp52_ = m;
		if (_tmp52_ != NULL) {
			ValaMethod* _tmp53_;
			_tmp53_ = m;
			vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp53_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp55_ = vala_property_get_set_accessor (prop);
	_tmp56_ = _tmp55_;
	if (_tmp56_ != NULL) {
		ValaPropertyAccessor* _tmp57_;
		ValaPropertyAccessor* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		_tmp57_ = vala_property_get_set_accessor (prop);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_property_accessor_get_writable (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp54_ = _tmp60_;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		ValaMethod* m = NULL;
		ValaPropertyAccessor* _tmp61_;
		ValaPropertyAccessor* _tmp62_;
		ValaMethod* _tmp63_;
		ValaMethod* _tmp64_;
		_tmp61_ = vala_property_get_set_accessor (prop);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_property_accessor_get_method (_tmp62_);
		m = _tmp63_;
		_tmp64_ = m;
		if (_tmp64_ != NULL) {
			ValaMethod* _tmp65_;
			_tmp65_ = m;
			vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp65_);
		}
		_vala_code_node_unref0 (m);
	}
}

static void
vala_gir_writer_real_visit_signal (ValaCodeVisitor* base,
                                   ValaSignal* sig)
{
	ValaGIRWriter * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	GString* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GString* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gint _tmp20_;
	GString* _tmp21_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (sig != NULL);
	if (!vala_gir_writer_check_accessibility (self, (ValaSymbol*) sig)) {
		return;
	}
	_tmp0_ = vala_signal_get_emitter (sig);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		_tmp2_ = vala_signal_get_emitter (sig);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
	_tmp4_ = vala_signal_get_default_handler (sig);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_signal_get_default_handler (sig);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, (ValaCodeVisitor*) self);
	}
	vala_gir_writer_write_indent (self);
	_tmp8_ = self->priv->buffer;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp10_ = _tmp9_;
	g_string_append_printf (_tmp8_, "<glib:signal name=\"%s\"", _tmp10_);
	_g_free0 (_tmp10_);
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) sig);
	_tmp11_ = self->priv->buffer;
	g_string_append_printf (_tmp11_, ">\n");
	_tmp12_ = self->priv->indent;
	self->priv->indent = _tmp12_ + 1;
	_tmp13_ = vala_gir_writer_get_signal_comment (self, sig);
	_tmp14_ = _tmp13_;
	vala_gir_writer_write_doc (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp16_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_gir_writer_get_signal_return_comment (self, sig);
	_tmp19_ = _tmp18_;
	vala_gir_writer_write_params_and_return (self, "glib:signal", _tmp15_, NULL, _tmp17_, FALSE, _tmp19_, FALSE, NULL, FALSE);
	_g_free0 (_tmp19_);
	_tmp20_ = self->priv->indent;
	self->priv->indent = _tmp20_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp21_ = self->priv->buffer;
	g_string_append_printf (_tmp21_, "</glib:signal>\n");
}

static void
vala_gir_writer_write_indent (ValaGIRWriter* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			GString* _tmp2_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(i < self->priv->indent)) {
				break;
			}
			_tmp2_ = self->priv->buffer;
			g_string_append_c (_tmp2_, '\t');
		}
	}
}

static void
vala_gir_writer_write_indent_stream (ValaGIRWriter* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			FILE* _tmp2_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(i < self->priv->indent)) {
				break;
			}
			_tmp2_ = self->priv->stream;
			fputc ('\t', _tmp2_);
		}
	}
}

static void
vala_gir_writer_write_param_or_return (ValaGIRWriter* self,
                                       ValaDataType* type,
                                       const gchar* tag,
                                       gint* index,
                                       gboolean has_array_length,
                                       const gchar* name,
                                       const gchar* comment,
                                       ValaParameterDirection direction,
                                       gboolean constructor,
                                       gboolean caller_allocates,
                                       gboolean ellipsis)
{
	GString* _tmp0_;
	ValaDelegateType* delegate_type = NULL;
	ValaArrayType* array_type = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp48_ = FALSE;
	ValaDelegateType* _tmp49_;
	GString* _tmp70_;
	gint _tmp71_;
	gint _tmp74_;
	GString* _tmp75_;
	gint _tmp76_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	g_string_append_printf (_tmp0_, "<%s", tag);
	if (ellipsis) {
		name = "...";
	}
	if (name != NULL) {
		GString* _tmp1_;
		_tmp1_ = self->priv->buffer;
		g_string_append_printf (_tmp1_, " name=\"%s\"", name);
	}
	if (direction == VALA_PARAMETER_DIRECTION_REF) {
		GString* _tmp2_;
		_tmp2_ = self->priv->buffer;
		g_string_append_printf (_tmp2_, " direction=\"inout\"");
	} else {
		if (direction == VALA_PARAMETER_DIRECTION_OUT) {
			GString* _tmp3_;
			_tmp3_ = self->priv->buffer;
			g_string_append_printf (_tmp3_, " direction=\"out\"");
		}
	}
	delegate_type = G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) type) : NULL;
	array_type = G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) type) : NULL;
	if (type != NULL) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = vala_data_type_get_value_owned (type);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			ValaDelegateType* _tmp9_;
			_tmp9_ = delegate_type;
			_tmp6_ = _tmp9_ == NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gboolean _tmp10_ = FALSE;
			if (constructor) {
				gboolean _tmp11_ = FALSE;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp12_ = vala_data_type_get_type_symbol (type);
				_tmp13_ = _tmp12_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_STRUCT)) {
					_tmp11_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaTypeSymbol* _tmp16_;
					_tmp14_ = vala_data_type_get_type_symbol (type);
					_tmp15_ = _tmp14_;
					_tmp16_ = self->priv->ginitiallyunowned_type;
					_tmp11_ = vala_typesymbol_is_subtype_of (_tmp15_, _tmp16_);
				}
				_tmp10_ = !_tmp11_;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp5_ = _tmp10_;
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean any_owned = FALSE;
		gboolean _tmp28_ = FALSE;
		any_owned = FALSE;
		{
			ValaList* _generic_arg_list = NULL;
			ValaList* _tmp17_;
			gint _generic_arg_size = 0;
			ValaList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _generic_arg_index = 0;
			_tmp17_ = vala_data_type_get_type_arguments (type);
			_generic_arg_list = _tmp17_;
			_tmp18_ = _generic_arg_list;
			_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_generic_arg_size = _tmp20_;
			_generic_arg_index = -1;
			while (TRUE) {
				gint _tmp21_;
				gint _tmp22_;
				ValaDataType* generic_arg = NULL;
				ValaList* _tmp23_;
				gpointer _tmp24_;
				ValaDataType* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				_generic_arg_index = _generic_arg_index + 1;
				_tmp21_ = _generic_arg_index;
				_tmp22_ = _generic_arg_size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = _generic_arg_list;
				_tmp24_ = vala_list_get (_tmp23_, _generic_arg_index);
				generic_arg = (ValaDataType*) _tmp24_;
				_tmp25_ = generic_arg;
				_tmp26_ = vala_data_type_get_value_owned (_tmp25_);
				_tmp27_ = _tmp26_;
				any_owned |= _tmp27_;
				_vala_code_node_unref0 (generic_arg);
			}
		}
		if (vala_data_type_has_type_arguments (type)) {
			_tmp28_ = !any_owned;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			GString* _tmp29_;
			_tmp29_ = self->priv->buffer;
			g_string_append_printf (_tmp29_, " transfer-ownership=\"container\"");
		} else {
			gboolean _tmp30_ = FALSE;
			ValaArrayType* _tmp31_;
			_tmp31_ = array_type;
			if (_tmp31_ != NULL) {
				ValaArrayType* _tmp32_;
				ValaDataType* _tmp33_;
				ValaDataType* _tmp34_;
				gboolean _tmp35_;
				gboolean _tmp36_;
				_tmp32_ = array_type;
				_tmp33_ = vala_array_type_get_element_type (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_data_type_get_value_owned (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp30_ = !_tmp36_;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				GString* _tmp37_;
				_tmp37_ = self->priv->buffer;
				g_string_append_printf (_tmp37_, " transfer-ownership=\"container\"");
			} else {
				GString* _tmp38_;
				_tmp38_ = self->priv->buffer;
				g_string_append_printf (_tmp38_, " transfer-ownership=\"full\"");
			}
		}
	} else {
		GString* _tmp39_;
		_tmp39_ = self->priv->buffer;
		g_string_append_printf (_tmp39_, " transfer-ownership=\"none\"");
	}
	if (caller_allocates) {
		GString* _tmp40_;
		_tmp40_ = self->priv->buffer;
		g_string_append_printf (_tmp40_, " caller-allocates=\"1\"");
	}
	if (type != NULL) {
		gboolean _tmp42_;
		gboolean _tmp43_;
		_tmp42_ = vala_data_type_get_nullable (type);
		_tmp43_ = _tmp42_;
		_tmp41_ = _tmp43_;
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		gboolean _tmp44_ = FALSE;
		if (g_strcmp0 (tag, "parameter") == 0) {
			gboolean _tmp45_ = FALSE;
			if (direction == VALA_PARAMETER_DIRECTION_OUT) {
				_tmp45_ = TRUE;
			} else {
				_tmp45_ = direction == VALA_PARAMETER_DIRECTION_REF;
			}
			_tmp44_ = _tmp45_;
		} else {
			_tmp44_ = FALSE;
		}
		if (_tmp44_) {
			GString* _tmp46_;
			_tmp46_ = self->priv->buffer;
			g_string_append_printf (_tmp46_, " optional=\"1\"");
		} else {
			GString* _tmp47_;
			_tmp47_ = self->priv->buffer;
			g_string_append_printf (_tmp47_, " nullable=\"1\"");
		}
	}
	_tmp49_ = delegate_type;
	if (_tmp49_ != NULL) {
		ValaDelegateType* _tmp50_;
		ValaDelegate* _tmp51_;
		ValaDelegate* _tmp52_;
		gboolean _tmp53_;
		gboolean _tmp54_;
		_tmp50_ = delegate_type;
		_tmp51_ = vala_delegate_type_get_delegate_symbol (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_delegate_get_has_target (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp48_ = _tmp54_;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		gint _tmp55_ = 0;
		gint closure_index = 0;
		GString* _tmp59_;
		ValaDelegateType* _tmp60_;
		gboolean _tmp61_;
		gboolean _tmp62_;
		if (g_strcmp0 (tag, "parameter") == 0) {
			_tmp55_ = (*index) + 1;
		} else {
			gint _tmp56_ = 0;
			gboolean _tmp57_;
			gboolean _tmp58_;
			_tmp57_ = vala_data_type_get_value_owned (type);
			_tmp58_ = _tmp57_;
			if (_tmp58_) {
				_tmp56_ = (*index) - 1;
			} else {
				_tmp56_ = *index;
			}
			_tmp55_ = _tmp56_;
		}
		closure_index = _tmp55_;
		_tmp59_ = self->priv->buffer;
		g_string_append_printf (_tmp59_, " closure=\"%i\"", closure_index);
		_tmp60_ = delegate_type;
		_tmp61_ = vala_delegate_type_get_is_called_once (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp62_) {
			GString* _tmp63_;
			_tmp63_ = self->priv->buffer;
			g_string_append (_tmp63_, " scope=\"async\"");
		} else {
			gboolean _tmp64_;
			gboolean _tmp65_;
			_tmp64_ = vala_data_type_get_value_owned (type);
			_tmp65_ = _tmp64_;
			if (_tmp65_) {
				GString* _tmp66_;
				_tmp66_ = self->priv->buffer;
				g_string_append_printf (_tmp66_, " scope=\"notified\" destroy=\"%i\"", closure_index + 1);
			} else {
				GString* _tmp67_;
				_tmp67_ = self->priv->buffer;
				g_string_append (_tmp67_, " scope=\"call\"");
			}
		}
	} else {
		ValaDelegateType* _tmp68_;
		_tmp68_ = delegate_type;
		if (_tmp68_ != NULL) {
			GString* _tmp69_;
			_tmp69_ = self->priv->buffer;
			g_string_append (_tmp69_, " scope=\"call\"");
		}
	}
	_tmp70_ = self->priv->buffer;
	g_string_append_printf (_tmp70_, ">\n");
	_tmp71_ = self->priv->indent;
	self->priv->indent = _tmp71_ + 1;
	vala_gir_writer_write_doc (self, comment);
	if (ellipsis) {
		GString* _tmp72_;
		vala_gir_writer_write_indent (self);
		_tmp72_ = self->priv->buffer;
		g_string_append (_tmp72_, "<varargs/>\n");
	} else {
		if (type != NULL) {
			gint length_param_index = 0;
			length_param_index = -1;
			if (has_array_length) {
				gint _tmp73_ = 0;
				if (g_strcmp0 (tag, "parameter") == 0) {
					_tmp73_ = (*index) + 1;
				} else {
					_tmp73_ = *index;
				}
				length_param_index = _tmp73_;
			}
			vala_gir_writer_write_type (self, type, length_param_index, direction);
		}
	}
	_tmp74_ = self->priv->indent;
	self->priv->indent = _tmp74_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp75_ = self->priv->buffer;
	g_string_append_printf (_tmp75_, "</%s>\n", tag);
	_tmp76_ = *index;
	*index = _tmp76_ + 1;
}

static void
vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self,
                                        ValaTypeSymbol* symbol,
                                        const gchar* suffix,
                                        gboolean symbol_prefix)
{
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (suffix != NULL);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = vala_get_ccode_name ((ValaCodeNode*) symbol);
	_tmp2_ = _tmp1_;
	g_string_append_printf (_tmp0_, " c:type=\"%s%s\"", _tmp2_, suffix);
	_g_free0 (_tmp2_);
	if (symbol_prefix) {
		GString* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->buffer;
		_tmp4_ = vala_get_ccode_lower_case_suffix ((ValaSymbol*) symbol);
		_tmp5_ = _tmp4_;
		g_string_append_printf (_tmp3_, " c:symbol-prefix=\"%s\"", _tmp5_);
		_g_free0 (_tmp5_);
	}
}

static void
vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self,
                                        ValaTypeSymbol* symbol,
                                        gboolean symbol_prefix)
{
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GString* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	vala_gir_writer_write_ctype_attributes (self, symbol, "", symbol_prefix);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = vala_get_ccode_name ((ValaCodeNode*) symbol);
	_tmp2_ = _tmp1_;
	g_string_append_printf (_tmp0_, " glib:type-name=\"%s\"", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->buffer;
	_tmp4_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) symbol);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp3_, " glib:get-type=\"%sget_type\"", _tmp5_);
	_g_free0 (_tmp5_);
}

static void
vala_gir_writer_write_type (ValaGIRWriter* self,
                            ValaDataType* type,
                            gint index,
                            ValaParameterDirection direction)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_ARRAY_TYPE)) {
		ValaArrayType* array_type = NULL;
		ValaArrayType* _tmp0_;
		GString* _tmp1_;
		gboolean _tmp2_ = FALSE;
		ValaArrayType* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		const gchar* _tmp18_ = NULL;
		GString* _tmp19_;
		ValaArrayType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GString* _tmp25_;
		gint _tmp26_;
		ValaArrayType* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		gint _tmp30_;
		GString* _tmp31_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp0_;
		vala_gir_writer_write_indent (self);
		_tmp1_ = self->priv->buffer;
		g_string_append_printf (_tmp1_, "<array");
		_tmp3_ = array_type;
		_tmp4_ = vala_array_type_get_fixed_length (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			ValaArrayType* _tmp6_;
			ValaExpression* _tmp7_;
			ValaExpression* _tmp8_;
			_tmp6_ = array_type;
			_tmp7_ = vala_array_type_get_length (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_INTEGER_LITERAL);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ValaIntegerLiteral* lit = NULL;
			ValaArrayType* _tmp9_;
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaIntegerLiteral* _tmp12_;
			GString* _tmp13_;
			ValaIntegerLiteral* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp9_ = array_type;
			_tmp10_ = vala_array_type_get_length (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
			lit = _tmp12_;
			_tmp13_ = self->priv->buffer;
			_tmp14_ = lit;
			_tmp15_ = vala_integer_literal_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			g_string_append_printf (_tmp13_, " fixed-size=\"%i\"", atoi (_tmp16_));
			_vala_code_node_unref0 (lit);
		} else {
			if (index != -1) {
				GString* _tmp17_;
				_tmp17_ = self->priv->buffer;
				g_string_append_printf (_tmp17_, " length=\"%i\"", index);
			}
		}
		if (direction == VALA_PARAMETER_DIRECTION_IN) {
			_tmp18_ = "*";
		} else {
			_tmp18_ = "**";
		}
		_tmp19_ = self->priv->buffer;
		_tmp20_ = array_type;
		_tmp21_ = vala_array_type_get_element_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_get_ccode_name ((ValaCodeNode*) _tmp22_);
		_tmp24_ = _tmp23_;
		g_string_append_printf (_tmp19_, " c:type=\"%s%s\"", _tmp24_, _tmp18_);
		_g_free0 (_tmp24_);
		_tmp25_ = self->priv->buffer;
		g_string_append_printf (_tmp25_, ">\n");
		_tmp26_ = self->priv->indent;
		self->priv->indent = _tmp26_ + 1;
		_tmp27_ = array_type;
		_tmp28_ = vala_array_type_get_element_type (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_gir_writer_write_type (self, _tmp29_, -1, VALA_PARAMETER_DIRECTION_IN);
		_tmp30_ = self->priv->indent;
		self->priv->indent = _tmp30_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, "</array>\n");
		_vala_code_node_unref0 (array_type);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_VOID_TYPE)) {
			GString* _tmp32_;
			vala_gir_writer_write_indent (self);
			_tmp32_ = self->priv->buffer;
			g_string_append_printf (_tmp32_, "<type name=\"none\" c:type=\"void\"/>\n");
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_POINTER_TYPE)) {
				const gchar* _tmp33_ = NULL;
				GString* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				vala_gir_writer_write_indent (self);
				if (direction == VALA_PARAMETER_DIRECTION_IN) {
					_tmp33_ = "";
				} else {
					_tmp33_ = "*";
				}
				_tmp34_ = self->priv->buffer;
				_tmp35_ = vala_get_ccode_name ((ValaCodeNode*) type);
				_tmp36_ = _tmp35_;
				g_string_append_printf (_tmp34_, "<type name=\"gpointer\" c:type=\"%s%s\"/>\n", _tmp36_, _tmp33_);
				_g_free0 (_tmp36_);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_GENERIC_TYPE)) {
					GString* _tmp37_;
					vala_gir_writer_write_indent (self);
					_tmp37_ = self->priv->buffer;
					g_string_append (_tmp37_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDelegateType* deleg_type = NULL;
						ValaDelegateType* _tmp38_;
						const gchar* _tmp39_ = NULL;
						GString* _tmp40_;
						ValaDelegateType* _tmp41_;
						ValaDelegate* _tmp42_;
						ValaDelegate* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						deleg_type = _tmp38_;
						vala_gir_writer_write_indent (self);
						if (direction == VALA_PARAMETER_DIRECTION_IN) {
							_tmp39_ = "";
						} else {
							_tmp39_ = "*";
						}
						_tmp40_ = self->priv->buffer;
						_tmp41_ = deleg_type;
						_tmp42_ = vala_delegate_type_get_delegate_symbol (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = vala_get_ccode_name ((ValaCodeNode*) type);
						_tmp47_ = _tmp46_;
						g_string_append_printf (_tmp40_, "<type name=\"%s\" c:type=\"%s%s\"/>\n", _tmp45_, _tmp47_, _tmp39_);
						_g_free0 (_tmp47_);
						_g_free0 (_tmp45_);
						_vala_code_node_unref0 (deleg_type);
					} else {
						ValaTypeSymbol* _tmp48_;
						ValaTypeSymbol* _tmp49_;
						_tmp48_ = vala_data_type_get_type_symbol (type);
						_tmp49_ = _tmp48_;
						if (_tmp49_ != NULL) {
							gchar* type_name = NULL;
							ValaTypeSymbol* _tmp50_;
							ValaTypeSymbol* _tmp51_;
							gchar* _tmp52_;
							gboolean is_array = FALSE;
							gboolean _tmp53_ = FALSE;
							const gchar* _tmp54_;
							const gchar* _tmp56_ = NULL;
							const gchar* _tmp57_ = NULL;
							GString* _tmp58_;
							ValaTypeSymbol* _tmp59_;
							ValaTypeSymbol* _tmp60_;
							gchar* _tmp61_;
							gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							ValaList* type_arguments = NULL;
							ValaList* _tmp65_;
							ValaList* _tmp66_;
							ValaList* _tmp67_;
							gint _tmp68_;
							gint _tmp69_;
							vala_gir_writer_write_indent (self);
							_tmp50_ = vala_data_type_get_type_symbol (type);
							_tmp51_ = _tmp50_;
							_tmp52_ = vala_gir_writer_gi_type_name (self, _tmp51_);
							type_name = _tmp52_;
							is_array = FALSE;
							_tmp54_ = type_name;
							if (g_strcmp0 (_tmp54_, "GLib.Array") == 0) {
								_tmp53_ = TRUE;
							} else {
								const gchar* _tmp55_;
								_tmp55_ = type_name;
								_tmp53_ = g_strcmp0 (_tmp55_, "GLib.PtrArray") == 0;
							}
							if (_tmp53_) {
								is_array = TRUE;
							}
							if (is_array) {
								_tmp56_ = "array";
							} else {
								_tmp56_ = "type";
							}
							if (direction == VALA_PARAMETER_DIRECTION_IN) {
								_tmp57_ = "";
							} else {
								_tmp57_ = "*";
							}
							_tmp58_ = self->priv->buffer;
							_tmp59_ = vala_data_type_get_type_symbol (type);
							_tmp60_ = _tmp59_;
							_tmp61_ = vala_gir_writer_gi_type_name (self, _tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = vala_get_ccode_name ((ValaCodeNode*) type);
							_tmp64_ = _tmp63_;
							g_string_append_printf (_tmp58_, "<%s name=\"%s\" c:type=\"%s%s\"", _tmp56_, _tmp62_, _tmp64_, _tmp57_);
							_g_free0 (_tmp64_);
							_g_free0 (_tmp62_);
							_tmp65_ = vala_data_type_get_type_arguments (type);
							_tmp66_ = _vala_iterable_ref0 (_tmp65_);
							type_arguments = _tmp66_;
							_tmp67_ = type_arguments;
							_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
							_tmp69_ = _tmp68_;
							if (_tmp69_ == 0) {
								GString* _tmp70_;
								_tmp70_ = self->priv->buffer;
								g_string_append_printf (_tmp70_, "/>\n");
							} else {
								GString* _tmp71_;
								gint _tmp72_;
								gint _tmp82_;
								const gchar* _tmp83_ = NULL;
								GString* _tmp84_;
								_tmp71_ = self->priv->buffer;
								g_string_append_printf (_tmp71_, ">\n");
								_tmp72_ = self->priv->indent;
								self->priv->indent = _tmp72_ + 1;
								{
									ValaList* _type_argument_list = NULL;
									ValaList* _tmp73_;
									gint _type_argument_size = 0;
									ValaList* _tmp74_;
									gint _tmp75_;
									gint _tmp76_;
									gint _type_argument_index = 0;
									_tmp73_ = type_arguments;
									_type_argument_list = _tmp73_;
									_tmp74_ = _type_argument_list;
									_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
									_tmp76_ = _tmp75_;
									_type_argument_size = _tmp76_;
									_type_argument_index = -1;
									while (TRUE) {
										gint _tmp77_;
										gint _tmp78_;
										ValaDataType* type_argument = NULL;
										ValaList* _tmp79_;
										gpointer _tmp80_;
										ValaDataType* _tmp81_;
										_type_argument_index = _type_argument_index + 1;
										_tmp77_ = _type_argument_index;
										_tmp78_ = _type_argument_size;
										if (!(_tmp77_ < _tmp78_)) {
											break;
										}
										_tmp79_ = _type_argument_list;
										_tmp80_ = vala_list_get (_tmp79_, _type_argument_index);
										type_argument = (ValaDataType*) _tmp80_;
										_tmp81_ = type_argument;
										vala_gir_writer_write_type (self, _tmp81_, -1, VALA_PARAMETER_DIRECTION_IN);
										_vala_code_node_unref0 (type_argument);
									}
								}
								_tmp82_ = self->priv->indent;
								self->priv->indent = _tmp82_ - 1;
								vala_gir_writer_write_indent (self);
								if (is_array) {
									_tmp83_ = "array";
								} else {
									_tmp83_ = "type";
								}
								_tmp84_ = self->priv->buffer;
								g_string_append_printf (_tmp84_, "</%s>\n", _tmp83_);
							}
							_vala_iterable_unref0 (type_arguments);
							_g_free0 (type_name);
						} else {
							GString* _tmp85_;
							gchar* _tmp86_;
							gchar* _tmp87_;
							vala_gir_writer_write_indent (self);
							_tmp85_ = self->priv->buffer;
							_tmp86_ = vala_code_node_to_string ((ValaCodeNode*) type);
							_tmp87_ = _tmp86_;
							g_string_append_printf (_tmp85_, "<type name=\"%s\"/>\n", _tmp87_);
							_g_free0 (_tmp87_);
						}
					}
				}
			}
		}
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
vala_gir_writer_get_full_gir_name (ValaGIRWriter* self,
                                   ValaSymbol* sym)
{
	gchar* gir_fullname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* gir_name = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* parent_gir_name = NULL;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	gchar* self_gir_name = NULL;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "GIR", "fullname", NULL);
	gir_fullname = _tmp0_;
	_tmp1_ = gir_fullname;
	if (_tmp1_ != NULL) {
		result = gir_fullname;
		return result;
	}
	_tmp2_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "GIR", "name", NULL);
	gir_name = _tmp2_;
	_tmp4_ = gir_name;
	if (_tmp4_ == NULL) {
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp5_;
		_tmp5_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "gir_namespace", NULL);
		_g_free0 (gir_name);
		gir_name = _tmp5_;
	}
	_tmp6_ = gir_name;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = vala_symbol_get_name (sym);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (gir_name);
		gir_name = _tmp9_;
	}
	_tmp10_ = vala_symbol_get_parent_symbol (sym);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == NULL) {
		result = gir_name;
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp12_ = vala_symbol_get_name (sym);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = vala_symbol_get_parent_symbol (sym);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_gir_writer_get_full_gir_name (self, _tmp15_);
		result = _tmp16_;
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp17_ = vala_symbol_get_parent_symbol (sym);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_gir_writer_get_full_gir_name (self, _tmp18_);
	parent_gir_name = _tmp19_;
	_tmp20_ = parent_gir_name;
	if (_tmp20_ == NULL) {
		result = gir_name;
		_g_free0 (parent_gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
	_tmp22_ = gir_name;
	if (g_str_has_prefix (_tmp22_, ".")) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = gir_name;
		_tmp24_ = string_substring (_tmp23_, (glong) 1, (glong) -1);
		_g_free0 (_tmp21_);
		_tmp21_ = _tmp24_;
	} else {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = gir_name;
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (_tmp21_);
		_tmp21_ = _tmp26_;
	}
	_tmp27_ = g_strdup (_tmp21_);
	self_gir_name = _tmp27_;
	_tmp28_ = parent_gir_name;
	if (string_contains (_tmp28_, ".")) {
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp29_ = parent_gir_name;
		_tmp30_ = self_gir_name;
		_tmp31_ = g_strdup_printf ("%s%s", _tmp29_, _tmp30_);
		result = _tmp31_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp21_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	} else {
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp32_ = parent_gir_name;
		_tmp33_ = self_gir_name;
		_tmp34_ = g_strdup_printf ("%s.%s", _tmp32_, _tmp33_);
		result = _tmp34_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp21_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (gir_fullname);
		return result;
	}
}

static gchar*
vala_gir_writer_gi_type_name (ValaGIRWriter* self,
                              ValaTypeSymbol* type_symbol)
{
	ValaSymbol* parent = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gchar* _tmp50_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) type_symbol);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	parent = _tmp2_;
	_tmp3_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_NAMESPACE)) {
		ValaNamespace* ns = NULL;
		ValaSymbol* _tmp4_;
		ValaNamespace* _tmp5_;
		gchar* _tmp6_ = NULL;
		ValaNamespace* _tmp7_;
		gchar* _tmp8_;
		gchar* ns_gir_name = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp4_ = parent;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE) ? ((ValaNamespace*) _tmp4_) : NULL);
		ns = _tmp5_;
		_tmp7_ = ns;
		_tmp8_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp7_, "GIR", "name", NULL);
		_tmp6_ = _tmp8_;
		if (_tmp6_ == NULL) {
			ValaNamespace* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp9_ = ns;
			_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp12_;
		}
		_tmp13_ = _tmp6_;
		_tmp6_ = NULL;
		ns_gir_name = _tmp13_;
		_tmp14_ = ns_gir_name;
		if (_tmp14_ != NULL) {
			ValaSourceFile* source_file = NULL;
			ValaSourceReference* _tmp15_;
			ValaSourceReference* _tmp16_;
			ValaSourceFile* _tmp17_;
			ValaSourceFile* _tmp18_;
			ValaSourceFile* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) type_symbol);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_source_reference_get_file (_tmp16_);
			_tmp18_ = _tmp17_;
			source_file = _tmp18_;
			_tmp19_ = source_file;
			_tmp20_ = vala_source_file_get_gir_namespace (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_ != NULL) {
				ValaGIRWriterGIRNamespace external = {0};
				ValaSourceFile* _tmp22_;
				gboolean _tmp23_;
				gboolean _tmp24_;
				ValaArrayList* _tmp32_;
				ValaGIRWriterGIRNamespace _tmp33_;
				gchar* gir_fullname = NULL;
				gchar* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_;
				gchar* type_name = NULL;
				gchar* _tmp43_;
				ValaGIRWriterGIRNamespace _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				_tmp22_ = source_file;
				_tmp23_ = vala_source_file_get_gir_ambiguous (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_) {
					ValaGIRWriterGIRNamespace _tmp25_ = {0};
					vala_gir_writer_gir_namespace_for_symbol ((ValaSymbol*) type_symbol, &_tmp25_);
					vala_gir_writer_gir_namespace_destroy (&external);
					external = _tmp25_;
				} else {
					ValaSourceFile* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					ValaSourceFile* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					_tmp26_ = source_file;
					_tmp27_ = vala_source_file_get_gir_namespace (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = source_file;
					_tmp30_ = vala_source_file_get_gir_version (_tmp29_);
					_tmp31_ = _tmp30_;
					vala_gir_writer_gir_namespace_destroy (&external);
					vala_gir_writer_gir_namespace_init (&external, _tmp28_, _tmp31_);
				}
				_tmp32_ = self->priv->externals;
				_tmp33_ = external;
				if (!vala_collection_contains ((ValaCollection*) _tmp32_, &_tmp33_)) {
					ValaArrayList* _tmp34_;
					ValaGIRWriterGIRNamespace _tmp35_;
					_tmp34_ = self->priv->externals;
					_tmp35_ = external;
					vala_collection_add ((ValaCollection*) _tmp34_, &_tmp35_);
				}
				_tmp36_ = vala_code_node_get_attribute_string ((ValaCodeNode*) type_symbol, "GIR", "fullname", NULL);
				gir_fullname = _tmp36_;
				_tmp37_ = gir_fullname;
				if (_tmp37_ != NULL) {
					result = gir_fullname;
					vala_gir_writer_gir_namespace_destroy (&external);
					_g_free0 (ns_gir_name);
					_g_free0 (_tmp6_);
					_vala_code_node_unref0 (ns);
					_vala_code_node_unref0 (parent);
					return result;
				}
				_tmp39_ = vala_code_node_get_attribute_string ((ValaCodeNode*) type_symbol, "GIR", "name", NULL);
				_tmp38_ = _tmp39_;
				if (_tmp38_ == NULL) {
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp40_ = vala_symbol_get_name ((ValaSymbol*) type_symbol);
					_tmp41_ = _tmp40_;
					_tmp42_ = g_strdup (_tmp41_);
					_g_free0 (_tmp38_);
					_tmp38_ = _tmp42_;
				}
				_tmp43_ = _tmp38_;
				_tmp38_ = NULL;
				type_name = _tmp43_;
				_tmp44_ = external;
				_tmp45_ = _tmp44_.ns;
				_tmp46_ = type_name;
				_tmp47_ = g_strdup_printf ("%s.%s", _tmp45_, _tmp46_);
				result = _tmp47_;
				_g_free0 (type_name);
				_g_free0 (_tmp38_);
				_g_free0 (gir_fullname);
				vala_gir_writer_gir_namespace_destroy (&external);
				_g_free0 (ns_gir_name);
				_g_free0 (_tmp6_);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (parent);
				return result;
			} else {
				ValaHashSet* _tmp48_;
				ValaNamespace* _tmp49_;
				_tmp48_ = self->priv->unannotated_namespaces;
				_tmp49_ = ns;
				vala_collection_add ((ValaCollection*) _tmp48_, _tmp49_);
			}
		}
		_g_free0 (ns_gir_name);
		_g_free0 (_tmp6_);
		_vala_code_node_unref0 (ns);
	}
	_tmp50_ = vala_gir_writer_get_full_gir_name (self, (ValaSymbol*) type_symbol);
	result = _tmp50_;
	_vala_code_node_unref0 (parent);
	return result;
}

static gchar*
vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self,
                                                    ValaExpression* literal)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_STRING_LITERAL)) {
		ValaStringLiteral* lit = NULL;
		ValaStringLiteral* _tmp0_;
		ValaStringLiteral* _tmp1_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) literal) : NULL);
		lit = _tmp0_;
		_tmp1_ = lit;
		if (_tmp1_ != NULL) {
			ValaStringLiteral* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = lit;
			_tmp3_ = vala_string_literal_eval (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) -1);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp4_);
			result = _tmp6_;
			_vala_code_node_unref0 (lit);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_CHARACTER_LITERAL)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup_printf ("%c", (gint) ((gchar) vala_character_literal_get_char (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))));
			result = _tmp7_;
			return result;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_BOOLEAN_LITERAL)) {
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_;
				gboolean _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = vala_boolean_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral));
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					_tmp8_ = "true";
				} else {
					_tmp8_ = "false";
				}
				_tmp11_ = g_strdup (_tmp8_);
				result = _tmp11_;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_REAL_LITERAL)) {
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strdup (_tmp13_);
					result = _tmp14_;
					return result;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_INTEGER_LITERAL)) {
						const gchar* _tmp15_;
						const gchar* _tmp16_;
						gchar* _tmp17_;
						_tmp15_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
						_tmp16_ = _tmp15_;
						_tmp17_ = g_strdup (_tmp16_);
						result = _tmp17_;
						return result;
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (literal, VALA_TYPE_UNARY_EXPRESSION)) {
							ValaUnaryExpression* unary = NULL;
							ValaUnaryExpression* _tmp18_;
							ValaUnaryExpression* _tmp19_;
							ValaUnaryOperator _tmp20_;
							ValaUnaryOperator _tmp21_;
							_tmp18_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (literal, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
							unary = _tmp18_;
							_tmp19_ = unary;
							_tmp20_ = vala_unary_expression_get_operator (_tmp19_);
							_tmp21_ = _tmp20_;
							if (_tmp21_ == VALA_UNARY_OPERATOR_MINUS) {
								ValaUnaryExpression* _tmp22_;
								ValaExpression* _tmp23_;
								ValaExpression* _tmp24_;
								_tmp22_ = unary;
								_tmp23_ = vala_unary_expression_get_inner (_tmp22_);
								_tmp24_ = _tmp23_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_REAL_LITERAL)) {
									ValaUnaryExpression* _tmp25_;
									ValaExpression* _tmp26_;
									ValaExpression* _tmp27_;
									const gchar* _tmp28_;
									const gchar* _tmp29_;
									gchar* _tmp30_;
									_tmp25_ = unary;
									_tmp26_ = vala_unary_expression_get_inner (_tmp25_);
									_tmp27_ = _tmp26_;
									_tmp28_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
									_tmp29_ = _tmp28_;
									_tmp30_ = g_strconcat ("-", _tmp29_, NULL);
									result = _tmp30_;
									_vala_code_node_unref0 (unary);
									return result;
								} else {
									ValaUnaryExpression* _tmp31_;
									ValaExpression* _tmp32_;
									ValaExpression* _tmp33_;
									_tmp31_ = unary;
									_tmp32_ = vala_unary_expression_get_inner (_tmp31_);
									_tmp33_ = _tmp32_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_INTEGER_LITERAL)) {
										ValaUnaryExpression* _tmp34_;
										ValaExpression* _tmp35_;
										ValaExpression* _tmp36_;
										const gchar* _tmp37_;
										const gchar* _tmp38_;
										gchar* _tmp39_;
										_tmp34_ = unary;
										_tmp35_ = vala_unary_expression_get_inner (_tmp34_);
										_tmp36_ = _tmp35_;
										_tmp37_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
										_tmp38_ = _tmp37_;
										_tmp39_ = g_strconcat ("-", _tmp38_, NULL);
										result = _tmp39_;
										_vala_code_node_unref0 (unary);
										return result;
									}
								}
							}
							_vala_code_node_unref0 (unary);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gboolean
vala_gir_writer_check_accessibility (ValaGIRWriter* self,
                                     ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp5_;
	ValaSymbolAccessibility _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_symbol_get_access (sym);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbolAccessibility _tmp3_;
		ValaSymbolAccessibility _tmp4_;
		_tmp3_ = vala_symbol_get_access (sym);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = vala_symbol_get_access (sym);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_SYMBOL_ACCESSIBILITY_INTERNAL) {
		ValaSymbol* parent = NULL;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaSymbol* _tmp11_;
		_tmp7_ = vala_symbol_get_parent_symbol (sym);
		_tmp8_ = _tmp7_;
		parent = _tmp8_;
		_tmp11_ = parent;
		if (_tmp11_ != NULL) {
			gboolean _tmp12_ = FALSE;
			ValaSymbol* _tmp13_;
			_tmp13_ = parent;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_CLASS)) {
				_tmp12_ = TRUE;
			} else {
				ValaSymbol* _tmp14_;
				_tmp14_ = parent;
				_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE);
			}
			_tmp10_ = _tmp12_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_FIELD)) {
				ValaMemberBinding _tmp17_;
				ValaMemberBinding _tmp18_;
				_tmp17_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
				_tmp18_ = _tmp17_;
				_tmp16_ = _tmp18_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				_tmp15_ = TRUE;
			} else {
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_METHOD)) {
					ValaMemberBinding _tmp21_;
					ValaMemberBinding _tmp22_;
					_tmp21_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					_tmp22_ = _tmp21_;
					_tmp20_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					gboolean _tmp23_ = FALSE;
					gboolean _tmp24_;
					gboolean _tmp25_;
					_tmp24_ = vala_method_get_is_abstract (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					_tmp25_ = _tmp24_;
					if (_tmp25_) {
						_tmp23_ = TRUE;
					} else {
						gboolean _tmp26_;
						gboolean _tmp27_;
						_tmp26_ = vala_method_get_is_virtual (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						_tmp27_ = _tmp26_;
						_tmp23_ = _tmp27_;
					}
					_tmp19_ = _tmp23_;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp15_ = _tmp19_;
			}
			_tmp9_ = _tmp15_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_gir_writer_is_visibility (ValaGIRWriter* self,
                               ValaSymbol* sym)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) sym, "GIR", "visible", TRUE);
	return result;
}

static gboolean
vala_gir_writer_has_namespace (ValaGIRWriter* self,
                               ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_symbol_get_parent_symbol (sym);
	_tmp2_ = _tmp1_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_NAMESPACE)) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = vala_symbol_get_parent_symbol (sym);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_symbol_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ != NULL;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_name (sym);
	_tmp10_ = _tmp9_;
	vala_report_warning (_tmp8_, "`%s' must be part of namespace to be included in GIR", _tmp10_);
	result = FALSE;
	return result;
}

ValaGIRWriter*
vala_gir_writer_construct (GType object_type)
{
	ValaGIRWriter* self = NULL;
	self = (ValaGIRWriter*) vala_code_visitor_construct (object_type);
	return self;
}

ValaGIRWriter*
vala_gir_writer_new (void)
{
	return vala_gir_writer_construct (VALA_TYPE_GIR_WRITER);
}

static void
vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self,
                                    const gchar* ns,
                                    const gchar* version)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (ns != NULL);
	g_return_if_fail (version != NULL);
	memset (self, 0, sizeof (ValaGIRWriterGIRNamespace));
	_tmp0_ = g_strdup (ns);
	_g_free0 ((*self).ns);
	(*self).ns = _tmp0_;
	_tmp1_ = g_strdup (version);
	_g_free0 ((*self).version);
	(*self).version = _tmp1_;
}

static gboolean
vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self,
                                     ValaGIRWriterGIRNamespace* g)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaGIRWriterGIRNamespace _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (g != NULL, FALSE);
	_tmp1_ = (*self).ns;
	_tmp2_ = *g;
	_tmp3_ = _tmp2_.ns;
	if (g_strcmp0 (_tmp1_, _tmp3_) == 0) {
		const gchar* _tmp4_;
		ValaGIRWriterGIRNamespace _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = (*self).version;
		_tmp5_ = *g;
		_tmp6_ = _tmp5_.version;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_gir_writer_gir_namespace_for_symbol (ValaSymbol* sym,
                                          ValaGIRWriterGIRNamespace* result)
{
	gchar* gir_namespace = NULL;
	gchar* _tmp9_;
	gchar* gir_version = NULL;
	gchar* _tmp10_;
	ValaGIRWriterGIRNamespace _tmp11_ = {0};
	g_return_if_fail (sym != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp1_ = vala_symbol_get_parent_symbol (sym);
		_tmp2_ = _tmp1_;
		if (_tmp2_ != NULL) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp3_ = vala_symbol_get_parent_symbol (sym);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_symbol_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp0_ = _tmp6_ != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp7_ = vala_symbol_get_parent_symbol (sym);
		_tmp8_ = _tmp7_;
		sym = _tmp8_;
	}
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_NAMESPACE), "sym is Namespace");
	_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "gir_namespace", NULL);
	gir_namespace = _tmp9_;
	_tmp10_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "gir_version", NULL);
	gir_version = _tmp10_;
	vala_gir_writer_gir_namespace_init (&_tmp11_, gir_namespace, gir_version);
	*result = _tmp11_;
	_g_free0 (gir_version);
	_g_free0 (gir_namespace);
	return;
}

static void
vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self,
                                    ValaGIRWriterGIRNamespace* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).ns);
	(*dest).ns = _tmp1_;
	_tmp2_ = (*self).version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).version);
	(*dest).version = _tmp3_;
}

static void
vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self)
{
	_g_free0 ((*self).ns);
	_g_free0 ((*self).version);
}

static ValaGIRWriterGIRNamespace*
vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self)
{
	ValaGIRWriterGIRNamespace* dup;
	dup = g_new0 (ValaGIRWriterGIRNamespace, 1);
	vala_gir_writer_gir_namespace_copy (self, dup);
	return dup;
}

static void
vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self)
{
	vala_gir_writer_gir_namespace_destroy (self);
	g_free (self);
}

static GType
vala_gir_writer_gir_namespace_get_type_once (void)
{
	GType vala_gir_writer_gir_namespace_type_id;
	vala_gir_writer_gir_namespace_type_id = g_boxed_type_register_static ("ValaGIRWriterGIRNamespace", (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GBoxedFreeFunc) vala_gir_writer_gir_namespace_free);
	return vala_gir_writer_gir_namespace_type_id;
}

static GType
vala_gir_writer_gir_namespace_get_type (void)
{
	static volatile gsize vala_gir_writer_gir_namespace_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_writer_gir_namespace_type_id__once)) {
		GType vala_gir_writer_gir_namespace_type_id;
		vala_gir_writer_gir_namespace_type_id = vala_gir_writer_gir_namespace_get_type_once ();
		g_once_init_leave (&vala_gir_writer_gir_namespace_type_id__once, vala_gir_writer_gir_namespace_type_id);
	}
	return vala_gir_writer_gir_namespace_type_id__once;
}

static void
vala_gir_writer_class_init (ValaGIRWriterClass * klass,
                            gpointer klass_data)
{
	vala_gir_writer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_writer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGIRWriter_private_offset);
	((ValaGIRWriterClass *) klass)->get_interface_comment = (gchar* (*) (ValaGIRWriter*, ValaInterface*)) vala_gir_writer_real_get_interface_comment;
	((ValaGIRWriterClass *) klass)->get_struct_comment = (gchar* (*) (ValaGIRWriter*, ValaStruct*)) vala_gir_writer_real_get_struct_comment;
	((ValaGIRWriterClass *) klass)->get_enum_comment = (gchar* (*) (ValaGIRWriter*, ValaEnum*)) vala_gir_writer_real_get_enum_comment;
	((ValaGIRWriterClass *) klass)->get_class_comment = (gchar* (*) (ValaGIRWriter*, ValaClass*)) vala_gir_writer_real_get_class_comment;
	((ValaGIRWriterClass *) klass)->get_error_code_comment = (gchar* (*) (ValaGIRWriter*, ValaErrorCode*)) vala_gir_writer_real_get_error_code_comment;
	((ValaGIRWriterClass *) klass)->get_enum_value_comment = (gchar* (*) (ValaGIRWriter*, ValaEnumValue*)) vala_gir_writer_real_get_enum_value_comment;
	((ValaGIRWriterClass *) klass)->get_constant_comment = (gchar* (*) (ValaGIRWriter*, ValaConstant*)) vala_gir_writer_real_get_constant_comment;
	((ValaGIRWriterClass *) klass)->get_error_domain_comment = (gchar* (*) (ValaGIRWriter*, ValaErrorDomain*)) vala_gir_writer_real_get_error_domain_comment;
	((ValaGIRWriterClass *) klass)->get_field_comment = (gchar* (*) (ValaGIRWriter*, ValaField*)) vala_gir_writer_real_get_field_comment;
	((ValaGIRWriterClass *) klass)->get_delegate_comment = (gchar* (*) (ValaGIRWriter*, ValaDelegate*)) vala_gir_writer_real_get_delegate_comment;
	((ValaGIRWriterClass *) klass)->get_method_comment = (gchar* (*) (ValaGIRWriter*, ValaMethod*)) vala_gir_writer_real_get_method_comment;
	((ValaGIRWriterClass *) klass)->get_property_comment = (gchar* (*) (ValaGIRWriter*, ValaProperty*)) vala_gir_writer_real_get_property_comment;
	((ValaGIRWriterClass *) klass)->get_delegate_return_comment = (gchar* (*) (ValaGIRWriter*, ValaDelegate*)) vala_gir_writer_real_get_delegate_return_comment;
	((ValaGIRWriterClass *) klass)->get_signal_return_comment = (gchar* (*) (ValaGIRWriter*, ValaSignal*)) vala_gir_writer_real_get_signal_return_comment;
	((ValaGIRWriterClass *) klass)->get_method_return_comment = (gchar* (*) (ValaGIRWriter*, ValaMethod*)) vala_gir_writer_real_get_method_return_comment;
	((ValaGIRWriterClass *) klass)->get_signal_comment = (gchar* (*) (ValaGIRWriter*, ValaSignal*)) vala_gir_writer_real_get_signal_comment;
	((ValaGIRWriterClass *) klass)->get_parameter_comment = (gchar* (*) (ValaGIRWriter*, ValaParameter*)) vala_gir_writer_real_get_parameter_comment;
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gir_writer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) vala_gir_writer_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gir_writer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_gir_writer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_gir_writer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_gir_writer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_enum_value = (void (*) (ValaCodeVisitor*, ValaEnumValue*)) vala_gir_writer_real_visit_enum_value;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gir_writer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_error_code = (void (*) (ValaCodeVisitor*, ValaErrorCode*)) vala_gir_writer_real_visit_error_code;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor*, ValaConstant*)) vala_gir_writer_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_gir_writer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) vala_gir_writer_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_gir_writer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) vala_gir_writer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gir_writer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gir_writer_real_visit_signal;
}

static void
vala_gir_writer_instance_init (ValaGIRWriter * self,
                               gpointer klass)
{
	GString* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaArrayList* _tmp11_;
	self->priv = vala_gir_writer_get_instance_private (self);
	_tmp0_ = g_string_new ("");
	self->priv->buffer = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_);
	self->priv->unannotated_namespaces = _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	self->priv->our_namespaces = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->hierarchy = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	self->priv->deferred = _tmp10_;
	_tmp11_ = vala_array_list_new (VALA_GIR_WRITER_TYPE_GIR_NAMESPACE, (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GDestroyNotify) vala_gir_writer_gir_namespace_free, (GEqualFunc) vala_gir_writer_gir_namespace_equal);
	self->priv->externals = _tmp11_;
}

static void
vala_gir_writer_finalize (ValaCodeVisitor * obj)
{
	ValaGIRWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_WRITER, ValaGIRWriter);
	_vala_code_context_unref0 (self->priv->context);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->gir_namespace);
	_g_free0 (self->priv->gir_version);
	_g_free0 (self->priv->gir_shared_library);
	_g_string_free0 (self->priv->buffer);
	_fclose0 (self->priv->stream);
	_vala_iterable_unref0 (self->priv->unannotated_namespaces);
	_vala_iterable_unref0 (self->priv->our_namespaces);
	_vala_iterable_unref0 (self->priv->hierarchy);
	_vala_iterable_unref0 (self->priv->deferred);
	_vala_code_node_unref0 (self->priv->gobject_type);
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	_vala_code_node_unref0 (self->priv->gtypeinterface_type);
	_vala_code_node_unref0 (self->priv->gtypeinstance_type);
	_vala_code_node_unref0 (self->priv->gtype_type);
	_vala_iterable_unref0 (self->priv->externals);
	VALA_CODE_VISITOR_CLASS (vala_gir_writer_parent_class)->finalize (obj);
}

/**
 * Code visitor generating .gir file for the public interface.
 */
static GType
vala_gir_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGIRWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIRWriter), 0, (GInstanceInitFunc) vala_gir_writer_instance_init, NULL };
	GType vala_gir_writer_type_id;
	vala_gir_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIRWriter", &g_define_type_info, 0);
	ValaGIRWriter_private_offset = g_type_add_instance_private (vala_gir_writer_type_id, sizeof (ValaGIRWriterPrivate));
	return vala_gir_writer_type_id;
}

GType
vala_gir_writer_get_type (void)
{
	static volatile gsize vala_gir_writer_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_writer_type_id__once)) {
		GType vala_gir_writer_type_id;
		vala_gir_writer_type_id = vala_gir_writer_get_type_once ();
		g_once_init_leave (&vala_gir_writer_type_id__once, vala_gir_writer_type_id);
	}
	return vala_gir_writer_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

