// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkAxisUse")]
pub enum AxisUse {
    #[doc(alias = "GDK_AXIS_IGNORE")]
    Ignore,
    #[doc(alias = "GDK_AXIS_X")]
    X,
    #[doc(alias = "GDK_AXIS_Y")]
    Y,
    #[doc(alias = "GDK_AXIS_DELTA_X")]
    DeltaX,
    #[doc(alias = "GDK_AXIS_DELTA_Y")]
    DeltaY,
    #[doc(alias = "GDK_AXIS_PRESSURE")]
    Pressure,
    #[doc(alias = "GDK_AXIS_XTILT")]
    Xtilt,
    #[doc(alias = "GDK_AXIS_YTILT")]
    Ytilt,
    #[doc(alias = "GDK_AXIS_WHEEL")]
    Wheel,
    #[doc(alias = "GDK_AXIS_DISTANCE")]
    Distance,
    #[doc(alias = "GDK_AXIS_ROTATION")]
    Rotation,
    #[doc(alias = "GDK_AXIS_SLIDER")]
    Slider,
    #[doc(alias = "GDK_AXIS_LAST")]
    Last,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AxisUse {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AxisUse::{}",
            match *self {
                Self::Ignore => "Ignore",
                Self::X => "X",
                Self::Y => "Y",
                Self::DeltaX => "DeltaX",
                Self::DeltaY => "DeltaY",
                Self::Pressure => "Pressure",
                Self::Xtilt => "Xtilt",
                Self::Ytilt => "Ytilt",
                Self::Wheel => "Wheel",
                Self::Distance => "Distance",
                Self::Rotation => "Rotation",
                Self::Slider => "Slider",
                Self::Last => "Last",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AxisUse {
    type GlibType = ffi::GdkAxisUse;

    fn into_glib(self) -> ffi::GdkAxisUse {
        match self {
            Self::Ignore => ffi::GDK_AXIS_IGNORE,
            Self::X => ffi::GDK_AXIS_X,
            Self::Y => ffi::GDK_AXIS_Y,
            Self::DeltaX => ffi::GDK_AXIS_DELTA_X,
            Self::DeltaY => ffi::GDK_AXIS_DELTA_Y,
            Self::Pressure => ffi::GDK_AXIS_PRESSURE,
            Self::Xtilt => ffi::GDK_AXIS_XTILT,
            Self::Ytilt => ffi::GDK_AXIS_YTILT,
            Self::Wheel => ffi::GDK_AXIS_WHEEL,
            Self::Distance => ffi::GDK_AXIS_DISTANCE,
            Self::Rotation => ffi::GDK_AXIS_ROTATION,
            Self::Slider => ffi::GDK_AXIS_SLIDER,
            Self::Last => ffi::GDK_AXIS_LAST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkAxisUse> for AxisUse {
    unsafe fn from_glib(value: ffi::GdkAxisUse) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_AXIS_IGNORE => Self::Ignore,
            ffi::GDK_AXIS_X => Self::X,
            ffi::GDK_AXIS_Y => Self::Y,
            ffi::GDK_AXIS_DELTA_X => Self::DeltaX,
            ffi::GDK_AXIS_DELTA_Y => Self::DeltaY,
            ffi::GDK_AXIS_PRESSURE => Self::Pressure,
            ffi::GDK_AXIS_XTILT => Self::Xtilt,
            ffi::GDK_AXIS_YTILT => Self::Ytilt,
            ffi::GDK_AXIS_WHEEL => Self::Wheel,
            ffi::GDK_AXIS_DISTANCE => Self::Distance,
            ffi::GDK_AXIS_ROTATION => Self::Rotation,
            ffi::GDK_AXIS_SLIDER => Self::Slider,
            ffi::GDK_AXIS_LAST => Self::Last,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AxisUse {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_axis_use_get_type()) }
    }
}

impl glib::value::ValueType for AxisUse {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AxisUse {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AxisUse {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkCrossingMode")]
pub enum CrossingMode {
    #[doc(alias = "GDK_CROSSING_NORMAL")]
    Normal,
    #[doc(alias = "GDK_CROSSING_GRAB")]
    Grab,
    #[doc(alias = "GDK_CROSSING_UNGRAB")]
    Ungrab,
    #[doc(alias = "GDK_CROSSING_GTK_GRAB")]
    GtkGrab,
    #[doc(alias = "GDK_CROSSING_GTK_UNGRAB")]
    GtkUngrab,
    #[doc(alias = "GDK_CROSSING_STATE_CHANGED")]
    StateChanged,
    #[doc(alias = "GDK_CROSSING_TOUCH_BEGIN")]
    TouchBegin,
    #[doc(alias = "GDK_CROSSING_TOUCH_END")]
    TouchEnd,
    #[doc(alias = "GDK_CROSSING_DEVICE_SWITCH")]
    DeviceSwitch,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CrossingMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CrossingMode::{}",
            match *self {
                Self::Normal => "Normal",
                Self::Grab => "Grab",
                Self::Ungrab => "Ungrab",
                Self::GtkGrab => "GtkGrab",
                Self::GtkUngrab => "GtkUngrab",
                Self::StateChanged => "StateChanged",
                Self::TouchBegin => "TouchBegin",
                Self::TouchEnd => "TouchEnd",
                Self::DeviceSwitch => "DeviceSwitch",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CrossingMode {
    type GlibType = ffi::GdkCrossingMode;

    fn into_glib(self) -> ffi::GdkCrossingMode {
        match self {
            Self::Normal => ffi::GDK_CROSSING_NORMAL,
            Self::Grab => ffi::GDK_CROSSING_GRAB,
            Self::Ungrab => ffi::GDK_CROSSING_UNGRAB,
            Self::GtkGrab => ffi::GDK_CROSSING_GTK_GRAB,
            Self::GtkUngrab => ffi::GDK_CROSSING_GTK_UNGRAB,
            Self::StateChanged => ffi::GDK_CROSSING_STATE_CHANGED,
            Self::TouchBegin => ffi::GDK_CROSSING_TOUCH_BEGIN,
            Self::TouchEnd => ffi::GDK_CROSSING_TOUCH_END,
            Self::DeviceSwitch => ffi::GDK_CROSSING_DEVICE_SWITCH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkCrossingMode> for CrossingMode {
    unsafe fn from_glib(value: ffi::GdkCrossingMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_CROSSING_NORMAL => Self::Normal,
            ffi::GDK_CROSSING_GRAB => Self::Grab,
            ffi::GDK_CROSSING_UNGRAB => Self::Ungrab,
            ffi::GDK_CROSSING_GTK_GRAB => Self::GtkGrab,
            ffi::GDK_CROSSING_GTK_UNGRAB => Self::GtkUngrab,
            ffi::GDK_CROSSING_STATE_CHANGED => Self::StateChanged,
            ffi::GDK_CROSSING_TOUCH_BEGIN => Self::TouchBegin,
            ffi::GDK_CROSSING_TOUCH_END => Self::TouchEnd,
            ffi::GDK_CROSSING_DEVICE_SWITCH => Self::DeviceSwitch,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CrossingMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_crossing_mode_get_type()) }
    }
}

impl glib::value::ValueType for CrossingMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CrossingMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CrossingMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkDevicePadFeature")]
pub enum DevicePadFeature {
    #[doc(alias = "GDK_DEVICE_PAD_FEATURE_BUTTON")]
    Button,
    #[doc(alias = "GDK_DEVICE_PAD_FEATURE_RING")]
    Ring,
    #[doc(alias = "GDK_DEVICE_PAD_FEATURE_STRIP")]
    Strip,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DevicePadFeature {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DevicePadFeature::{}",
            match *self {
                Self::Button => "Button",
                Self::Ring => "Ring",
                Self::Strip => "Strip",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DevicePadFeature {
    type GlibType = ffi::GdkDevicePadFeature;

    fn into_glib(self) -> ffi::GdkDevicePadFeature {
        match self {
            Self::Button => ffi::GDK_DEVICE_PAD_FEATURE_BUTTON,
            Self::Ring => ffi::GDK_DEVICE_PAD_FEATURE_RING,
            Self::Strip => ffi::GDK_DEVICE_PAD_FEATURE_STRIP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkDevicePadFeature> for DevicePadFeature {
    unsafe fn from_glib(value: ffi::GdkDevicePadFeature) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_DEVICE_PAD_FEATURE_BUTTON => Self::Button,
            ffi::GDK_DEVICE_PAD_FEATURE_RING => Self::Ring,
            ffi::GDK_DEVICE_PAD_FEATURE_STRIP => Self::Strip,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DevicePadFeature {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_device_pad_feature_get_type()) }
    }
}

impl glib::value::ValueType for DevicePadFeature {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DevicePadFeature {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DevicePadFeature {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkDeviceToolType")]
pub enum DeviceToolType {
    #[doc(alias = "GDK_DEVICE_TOOL_TYPE_UNKNOWN")]
    Unknown,
    #[doc(alias = "GDK_DEVICE_TOOL_TYPE_PEN")]
    Pen,
    #[doc(alias = "GDK_DEVICE_TOOL_TYPE_ERASER")]
    Eraser,
    #[doc(alias = "GDK_DEVICE_TOOL_TYPE_BRUSH")]
    Brush,
    #[doc(alias = "GDK_DEVICE_TOOL_TYPE_PENCIL")]
    Pencil,
    #[doc(alias = "GDK_DEVICE_TOOL_TYPE_AIRBRUSH")]
    Airbrush,
    #[doc(alias = "GDK_DEVICE_TOOL_TYPE_MOUSE")]
    Mouse,
    #[doc(alias = "GDK_DEVICE_TOOL_TYPE_LENS")]
    Lens,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DeviceToolType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DeviceToolType::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Pen => "Pen",
                Self::Eraser => "Eraser",
                Self::Brush => "Brush",
                Self::Pencil => "Pencil",
                Self::Airbrush => "Airbrush",
                Self::Mouse => "Mouse",
                Self::Lens => "Lens",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DeviceToolType {
    type GlibType = ffi::GdkDeviceToolType;

    fn into_glib(self) -> ffi::GdkDeviceToolType {
        match self {
            Self::Unknown => ffi::GDK_DEVICE_TOOL_TYPE_UNKNOWN,
            Self::Pen => ffi::GDK_DEVICE_TOOL_TYPE_PEN,
            Self::Eraser => ffi::GDK_DEVICE_TOOL_TYPE_ERASER,
            Self::Brush => ffi::GDK_DEVICE_TOOL_TYPE_BRUSH,
            Self::Pencil => ffi::GDK_DEVICE_TOOL_TYPE_PENCIL,
            Self::Airbrush => ffi::GDK_DEVICE_TOOL_TYPE_AIRBRUSH,
            Self::Mouse => ffi::GDK_DEVICE_TOOL_TYPE_MOUSE,
            Self::Lens => ffi::GDK_DEVICE_TOOL_TYPE_LENS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkDeviceToolType> for DeviceToolType {
    unsafe fn from_glib(value: ffi::GdkDeviceToolType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_DEVICE_TOOL_TYPE_UNKNOWN => Self::Unknown,
            ffi::GDK_DEVICE_TOOL_TYPE_PEN => Self::Pen,
            ffi::GDK_DEVICE_TOOL_TYPE_ERASER => Self::Eraser,
            ffi::GDK_DEVICE_TOOL_TYPE_BRUSH => Self::Brush,
            ffi::GDK_DEVICE_TOOL_TYPE_PENCIL => Self::Pencil,
            ffi::GDK_DEVICE_TOOL_TYPE_AIRBRUSH => Self::Airbrush,
            ffi::GDK_DEVICE_TOOL_TYPE_MOUSE => Self::Mouse,
            ffi::GDK_DEVICE_TOOL_TYPE_LENS => Self::Lens,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DeviceToolType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_device_tool_type_get_type()) }
    }
}

impl glib::value::ValueType for DeviceToolType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DeviceToolType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DeviceToolType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkDragCancelReason")]
pub enum DragCancelReason {
    #[doc(alias = "GDK_DRAG_CANCEL_NO_TARGET")]
    NoTarget,
    #[doc(alias = "GDK_DRAG_CANCEL_USER_CANCELLED")]
    UserCancelled,
    #[doc(alias = "GDK_DRAG_CANCEL_ERROR")]
    Error,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DragCancelReason {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DragCancelReason::{}",
            match *self {
                Self::NoTarget => "NoTarget",
                Self::UserCancelled => "UserCancelled",
                Self::Error => "Error",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DragCancelReason {
    type GlibType = ffi::GdkDragCancelReason;

    fn into_glib(self) -> ffi::GdkDragCancelReason {
        match self {
            Self::NoTarget => ffi::GDK_DRAG_CANCEL_NO_TARGET,
            Self::UserCancelled => ffi::GDK_DRAG_CANCEL_USER_CANCELLED,
            Self::Error => ffi::GDK_DRAG_CANCEL_ERROR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkDragCancelReason> for DragCancelReason {
    unsafe fn from_glib(value: ffi::GdkDragCancelReason) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_DRAG_CANCEL_NO_TARGET => Self::NoTarget,
            ffi::GDK_DRAG_CANCEL_USER_CANCELLED => Self::UserCancelled,
            ffi::GDK_DRAG_CANCEL_ERROR => Self::Error,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DragCancelReason {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_drag_cancel_reason_get_type()) }
    }
}

impl glib::value::ValueType for DragCancelReason {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DragCancelReason {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DragCancelReason {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkEventType")]
pub enum EventType {
    #[doc(alias = "GDK_DELETE")]
    Delete,
    #[doc(alias = "GDK_MOTION_NOTIFY")]
    MotionNotify,
    #[doc(alias = "GDK_BUTTON_PRESS")]
    ButtonPress,
    #[doc(alias = "GDK_BUTTON_RELEASE")]
    ButtonRelease,
    #[doc(alias = "GDK_KEY_PRESS")]
    KeyPress,
    #[doc(alias = "GDK_KEY_RELEASE")]
    KeyRelease,
    #[doc(alias = "GDK_ENTER_NOTIFY")]
    EnterNotify,
    #[doc(alias = "GDK_LEAVE_NOTIFY")]
    LeaveNotify,
    #[doc(alias = "GDK_FOCUS_CHANGE")]
    FocusChange,
    #[doc(alias = "GDK_PROXIMITY_IN")]
    ProximityIn,
    #[doc(alias = "GDK_PROXIMITY_OUT")]
    ProximityOut,
    #[doc(alias = "GDK_DRAG_ENTER")]
    DragEnter,
    #[doc(alias = "GDK_DRAG_LEAVE")]
    DragLeave,
    #[doc(alias = "GDK_DRAG_MOTION")]
    DragMotion,
    #[doc(alias = "GDK_DROP_START")]
    DropStart,
    #[doc(alias = "GDK_SCROLL")]
    Scroll,
    #[doc(alias = "GDK_GRAB_BROKEN")]
    GrabBroken,
    #[doc(alias = "GDK_TOUCH_BEGIN")]
    TouchBegin,
    #[doc(alias = "GDK_TOUCH_UPDATE")]
    TouchUpdate,
    #[doc(alias = "GDK_TOUCH_END")]
    TouchEnd,
    #[doc(alias = "GDK_TOUCH_CANCEL")]
    TouchCancel,
    #[doc(alias = "GDK_TOUCHPAD_SWIPE")]
    TouchpadSwipe,
    #[doc(alias = "GDK_TOUCHPAD_PINCH")]
    TouchpadPinch,
    #[doc(alias = "GDK_PAD_BUTTON_PRESS")]
    PadButtonPress,
    #[doc(alias = "GDK_PAD_BUTTON_RELEASE")]
    PadButtonRelease,
    #[doc(alias = "GDK_PAD_RING")]
    PadRing,
    #[doc(alias = "GDK_PAD_STRIP")]
    PadStrip,
    #[doc(alias = "GDK_PAD_GROUP_MODE")]
    PadGroupMode,
    #[doc(alias = "GDK_EVENT_LAST")]
    EventLast,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for EventType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "EventType::{}",
            match *self {
                Self::Delete => "Delete",
                Self::MotionNotify => "MotionNotify",
                Self::ButtonPress => "ButtonPress",
                Self::ButtonRelease => "ButtonRelease",
                Self::KeyPress => "KeyPress",
                Self::KeyRelease => "KeyRelease",
                Self::EnterNotify => "EnterNotify",
                Self::LeaveNotify => "LeaveNotify",
                Self::FocusChange => "FocusChange",
                Self::ProximityIn => "ProximityIn",
                Self::ProximityOut => "ProximityOut",
                Self::DragEnter => "DragEnter",
                Self::DragLeave => "DragLeave",
                Self::DragMotion => "DragMotion",
                Self::DropStart => "DropStart",
                Self::Scroll => "Scroll",
                Self::GrabBroken => "GrabBroken",
                Self::TouchBegin => "TouchBegin",
                Self::TouchUpdate => "TouchUpdate",
                Self::TouchEnd => "TouchEnd",
                Self::TouchCancel => "TouchCancel",
                Self::TouchpadSwipe => "TouchpadSwipe",
                Self::TouchpadPinch => "TouchpadPinch",
                Self::PadButtonPress => "PadButtonPress",
                Self::PadButtonRelease => "PadButtonRelease",
                Self::PadRing => "PadRing",
                Self::PadStrip => "PadStrip",
                Self::PadGroupMode => "PadGroupMode",
                Self::EventLast => "EventLast",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for EventType {
    type GlibType = ffi::GdkEventType;

    fn into_glib(self) -> ffi::GdkEventType {
        match self {
            Self::Delete => ffi::GDK_DELETE,
            Self::MotionNotify => ffi::GDK_MOTION_NOTIFY,
            Self::ButtonPress => ffi::GDK_BUTTON_PRESS,
            Self::ButtonRelease => ffi::GDK_BUTTON_RELEASE,
            Self::KeyPress => ffi::GDK_KEY_PRESS,
            Self::KeyRelease => ffi::GDK_KEY_RELEASE,
            Self::EnterNotify => ffi::GDK_ENTER_NOTIFY,
            Self::LeaveNotify => ffi::GDK_LEAVE_NOTIFY,
            Self::FocusChange => ffi::GDK_FOCUS_CHANGE,
            Self::ProximityIn => ffi::GDK_PROXIMITY_IN,
            Self::ProximityOut => ffi::GDK_PROXIMITY_OUT,
            Self::DragEnter => ffi::GDK_DRAG_ENTER,
            Self::DragLeave => ffi::GDK_DRAG_LEAVE,
            Self::DragMotion => ffi::GDK_DRAG_MOTION,
            Self::DropStart => ffi::GDK_DROP_START,
            Self::Scroll => ffi::GDK_SCROLL,
            Self::GrabBroken => ffi::GDK_GRAB_BROKEN,
            Self::TouchBegin => ffi::GDK_TOUCH_BEGIN,
            Self::TouchUpdate => ffi::GDK_TOUCH_UPDATE,
            Self::TouchEnd => ffi::GDK_TOUCH_END,
            Self::TouchCancel => ffi::GDK_TOUCH_CANCEL,
            Self::TouchpadSwipe => ffi::GDK_TOUCHPAD_SWIPE,
            Self::TouchpadPinch => ffi::GDK_TOUCHPAD_PINCH,
            Self::PadButtonPress => ffi::GDK_PAD_BUTTON_PRESS,
            Self::PadButtonRelease => ffi::GDK_PAD_BUTTON_RELEASE,
            Self::PadRing => ffi::GDK_PAD_RING,
            Self::PadStrip => ffi::GDK_PAD_STRIP,
            Self::PadGroupMode => ffi::GDK_PAD_GROUP_MODE,
            Self::EventLast => ffi::GDK_EVENT_LAST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkEventType> for EventType {
    unsafe fn from_glib(value: ffi::GdkEventType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_DELETE => Self::Delete,
            ffi::GDK_MOTION_NOTIFY => Self::MotionNotify,
            ffi::GDK_BUTTON_PRESS => Self::ButtonPress,
            ffi::GDK_BUTTON_RELEASE => Self::ButtonRelease,
            ffi::GDK_KEY_PRESS => Self::KeyPress,
            ffi::GDK_KEY_RELEASE => Self::KeyRelease,
            ffi::GDK_ENTER_NOTIFY => Self::EnterNotify,
            ffi::GDK_LEAVE_NOTIFY => Self::LeaveNotify,
            ffi::GDK_FOCUS_CHANGE => Self::FocusChange,
            ffi::GDK_PROXIMITY_IN => Self::ProximityIn,
            ffi::GDK_PROXIMITY_OUT => Self::ProximityOut,
            ffi::GDK_DRAG_ENTER => Self::DragEnter,
            ffi::GDK_DRAG_LEAVE => Self::DragLeave,
            ffi::GDK_DRAG_MOTION => Self::DragMotion,
            ffi::GDK_DROP_START => Self::DropStart,
            ffi::GDK_SCROLL => Self::Scroll,
            ffi::GDK_GRAB_BROKEN => Self::GrabBroken,
            ffi::GDK_TOUCH_BEGIN => Self::TouchBegin,
            ffi::GDK_TOUCH_UPDATE => Self::TouchUpdate,
            ffi::GDK_TOUCH_END => Self::TouchEnd,
            ffi::GDK_TOUCH_CANCEL => Self::TouchCancel,
            ffi::GDK_TOUCHPAD_SWIPE => Self::TouchpadSwipe,
            ffi::GDK_TOUCHPAD_PINCH => Self::TouchpadPinch,
            ffi::GDK_PAD_BUTTON_PRESS => Self::PadButtonPress,
            ffi::GDK_PAD_BUTTON_RELEASE => Self::PadButtonRelease,
            ffi::GDK_PAD_RING => Self::PadRing,
            ffi::GDK_PAD_STRIP => Self::PadStrip,
            ffi::GDK_PAD_GROUP_MODE => Self::PadGroupMode,
            ffi::GDK_EVENT_LAST => Self::EventLast,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for EventType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_event_type_get_type()) }
    }
}

impl glib::value::ValueType for EventType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for EventType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for EventType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkFullscreenMode")]
pub enum FullscreenMode {
    #[doc(alias = "GDK_FULLSCREEN_ON_CURRENT_MONITOR")]
    CurrentMonitor,
    #[doc(alias = "GDK_FULLSCREEN_ON_ALL_MONITORS")]
    AllMonitors,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FullscreenMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FullscreenMode::{}",
            match *self {
                Self::CurrentMonitor => "CurrentMonitor",
                Self::AllMonitors => "AllMonitors",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FullscreenMode {
    type GlibType = ffi::GdkFullscreenMode;

    fn into_glib(self) -> ffi::GdkFullscreenMode {
        match self {
            Self::CurrentMonitor => ffi::GDK_FULLSCREEN_ON_CURRENT_MONITOR,
            Self::AllMonitors => ffi::GDK_FULLSCREEN_ON_ALL_MONITORS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkFullscreenMode> for FullscreenMode {
    unsafe fn from_glib(value: ffi::GdkFullscreenMode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_FULLSCREEN_ON_CURRENT_MONITOR => Self::CurrentMonitor,
            ffi::GDK_FULLSCREEN_ON_ALL_MONITORS => Self::AllMonitors,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FullscreenMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_fullscreen_mode_get_type()) }
    }
}

impl glib::value::ValueType for FullscreenMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FullscreenMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FullscreenMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkGLError")]
pub enum GLError {
    #[doc(alias = "GDK_GL_ERROR_NOT_AVAILABLE")]
    NotAvailable,
    #[doc(alias = "GDK_GL_ERROR_UNSUPPORTED_FORMAT")]
    UnsupportedFormat,
    #[doc(alias = "GDK_GL_ERROR_UNSUPPORTED_PROFILE")]
    UnsupportedProfile,
    #[doc(alias = "GDK_GL_ERROR_COMPILATION_FAILED")]
    CompilationFailed,
    #[doc(alias = "GDK_GL_ERROR_LINK_FAILED")]
    LinkFailed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for GLError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "GLError::{}",
            match *self {
                Self::NotAvailable => "NotAvailable",
                Self::UnsupportedFormat => "UnsupportedFormat",
                Self::UnsupportedProfile => "UnsupportedProfile",
                Self::CompilationFailed => "CompilationFailed",
                Self::LinkFailed => "LinkFailed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for GLError {
    type GlibType = ffi::GdkGLError;

    fn into_glib(self) -> ffi::GdkGLError {
        match self {
            Self::NotAvailable => ffi::GDK_GL_ERROR_NOT_AVAILABLE,
            Self::UnsupportedFormat => ffi::GDK_GL_ERROR_UNSUPPORTED_FORMAT,
            Self::UnsupportedProfile => ffi::GDK_GL_ERROR_UNSUPPORTED_PROFILE,
            Self::CompilationFailed => ffi::GDK_GL_ERROR_COMPILATION_FAILED,
            Self::LinkFailed => ffi::GDK_GL_ERROR_LINK_FAILED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkGLError> for GLError {
    unsafe fn from_glib(value: ffi::GdkGLError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_GL_ERROR_NOT_AVAILABLE => Self::NotAvailable,
            ffi::GDK_GL_ERROR_UNSUPPORTED_FORMAT => Self::UnsupportedFormat,
            ffi::GDK_GL_ERROR_UNSUPPORTED_PROFILE => Self::UnsupportedProfile,
            ffi::GDK_GL_ERROR_COMPILATION_FAILED => Self::CompilationFailed,
            ffi::GDK_GL_ERROR_LINK_FAILED => Self::LinkFailed,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for GLError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gdk_gl_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GDK_GL_ERROR_NOT_AVAILABLE => Some(Self::NotAvailable),
            ffi::GDK_GL_ERROR_UNSUPPORTED_FORMAT => Some(Self::UnsupportedFormat),
            ffi::GDK_GL_ERROR_UNSUPPORTED_PROFILE => Some(Self::UnsupportedProfile),
            ffi::GDK_GL_ERROR_COMPILATION_FAILED => Some(Self::CompilationFailed),
            ffi::GDK_GL_ERROR_LINK_FAILED => Some(Self::LinkFailed),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for GLError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_gl_error_get_type()) }
    }
}

impl glib::value::ValueType for GLError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for GLError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for GLError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkGravity")]
pub enum Gravity {
    #[doc(alias = "GDK_GRAVITY_NORTH_WEST")]
    NorthWest,
    #[doc(alias = "GDK_GRAVITY_NORTH")]
    North,
    #[doc(alias = "GDK_GRAVITY_NORTH_EAST")]
    NorthEast,
    #[doc(alias = "GDK_GRAVITY_WEST")]
    West,
    #[doc(alias = "GDK_GRAVITY_CENTER")]
    Center,
    #[doc(alias = "GDK_GRAVITY_EAST")]
    East,
    #[doc(alias = "GDK_GRAVITY_SOUTH_WEST")]
    SouthWest,
    #[doc(alias = "GDK_GRAVITY_SOUTH")]
    South,
    #[doc(alias = "GDK_GRAVITY_SOUTH_EAST")]
    SouthEast,
    #[doc(alias = "GDK_GRAVITY_STATIC")]
    Static,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Gravity {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Gravity::{}",
            match *self {
                Self::NorthWest => "NorthWest",
                Self::North => "North",
                Self::NorthEast => "NorthEast",
                Self::West => "West",
                Self::Center => "Center",
                Self::East => "East",
                Self::SouthWest => "SouthWest",
                Self::South => "South",
                Self::SouthEast => "SouthEast",
                Self::Static => "Static",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Gravity {
    type GlibType = ffi::GdkGravity;

    fn into_glib(self) -> ffi::GdkGravity {
        match self {
            Self::NorthWest => ffi::GDK_GRAVITY_NORTH_WEST,
            Self::North => ffi::GDK_GRAVITY_NORTH,
            Self::NorthEast => ffi::GDK_GRAVITY_NORTH_EAST,
            Self::West => ffi::GDK_GRAVITY_WEST,
            Self::Center => ffi::GDK_GRAVITY_CENTER,
            Self::East => ffi::GDK_GRAVITY_EAST,
            Self::SouthWest => ffi::GDK_GRAVITY_SOUTH_WEST,
            Self::South => ffi::GDK_GRAVITY_SOUTH,
            Self::SouthEast => ffi::GDK_GRAVITY_SOUTH_EAST,
            Self::Static => ffi::GDK_GRAVITY_STATIC,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkGravity> for Gravity {
    unsafe fn from_glib(value: ffi::GdkGravity) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_GRAVITY_NORTH_WEST => Self::NorthWest,
            ffi::GDK_GRAVITY_NORTH => Self::North,
            ffi::GDK_GRAVITY_NORTH_EAST => Self::NorthEast,
            ffi::GDK_GRAVITY_WEST => Self::West,
            ffi::GDK_GRAVITY_CENTER => Self::Center,
            ffi::GDK_GRAVITY_EAST => Self::East,
            ffi::GDK_GRAVITY_SOUTH_WEST => Self::SouthWest,
            ffi::GDK_GRAVITY_SOUTH => Self::South,
            ffi::GDK_GRAVITY_SOUTH_EAST => Self::SouthEast,
            ffi::GDK_GRAVITY_STATIC => Self::Static,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Gravity {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_gravity_get_type()) }
    }
}

impl glib::value::ValueType for Gravity {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Gravity {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Gravity {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkInputSource")]
pub enum InputSource {
    #[doc(alias = "GDK_SOURCE_MOUSE")]
    Mouse,
    #[doc(alias = "GDK_SOURCE_PEN")]
    Pen,
    #[doc(alias = "GDK_SOURCE_KEYBOARD")]
    Keyboard,
    #[doc(alias = "GDK_SOURCE_TOUCHSCREEN")]
    Touchscreen,
    #[doc(alias = "GDK_SOURCE_TOUCHPAD")]
    Touchpad,
    #[doc(alias = "GDK_SOURCE_TRACKPOINT")]
    Trackpoint,
    #[doc(alias = "GDK_SOURCE_TABLET_PAD")]
    TabletPad,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for InputSource {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "InputSource::{}",
            match *self {
                Self::Mouse => "Mouse",
                Self::Pen => "Pen",
                Self::Keyboard => "Keyboard",
                Self::Touchscreen => "Touchscreen",
                Self::Touchpad => "Touchpad",
                Self::Trackpoint => "Trackpoint",
                Self::TabletPad => "TabletPad",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for InputSource {
    type GlibType = ffi::GdkInputSource;

    fn into_glib(self) -> ffi::GdkInputSource {
        match self {
            Self::Mouse => ffi::GDK_SOURCE_MOUSE,
            Self::Pen => ffi::GDK_SOURCE_PEN,
            Self::Keyboard => ffi::GDK_SOURCE_KEYBOARD,
            Self::Touchscreen => ffi::GDK_SOURCE_TOUCHSCREEN,
            Self::Touchpad => ffi::GDK_SOURCE_TOUCHPAD,
            Self::Trackpoint => ffi::GDK_SOURCE_TRACKPOINT,
            Self::TabletPad => ffi::GDK_SOURCE_TABLET_PAD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkInputSource> for InputSource {
    unsafe fn from_glib(value: ffi::GdkInputSource) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_SOURCE_MOUSE => Self::Mouse,
            ffi::GDK_SOURCE_PEN => Self::Pen,
            ffi::GDK_SOURCE_KEYBOARD => Self::Keyboard,
            ffi::GDK_SOURCE_TOUCHSCREEN => Self::Touchscreen,
            ffi::GDK_SOURCE_TOUCHPAD => Self::Touchpad,
            ffi::GDK_SOURCE_TRACKPOINT => Self::Trackpoint,
            ffi::GDK_SOURCE_TABLET_PAD => Self::TabletPad,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for InputSource {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_input_source_get_type()) }
    }
}

impl glib::value::ValueType for InputSource {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for InputSource {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for InputSource {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkKeyMatch")]
pub enum KeyMatch {
    #[doc(alias = "GDK_KEY_MATCH_NONE")]
    None,
    #[doc(alias = "GDK_KEY_MATCH_PARTIAL")]
    Partial,
    #[doc(alias = "GDK_KEY_MATCH_EXACT")]
    Exact,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for KeyMatch {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "KeyMatch::{}",
            match *self {
                Self::None => "None",
                Self::Partial => "Partial",
                Self::Exact => "Exact",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for KeyMatch {
    type GlibType = ffi::GdkKeyMatch;

    fn into_glib(self) -> ffi::GdkKeyMatch {
        match self {
            Self::None => ffi::GDK_KEY_MATCH_NONE,
            Self::Partial => ffi::GDK_KEY_MATCH_PARTIAL,
            Self::Exact => ffi::GDK_KEY_MATCH_EXACT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkKeyMatch> for KeyMatch {
    unsafe fn from_glib(value: ffi::GdkKeyMatch) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_KEY_MATCH_NONE => Self::None,
            ffi::GDK_KEY_MATCH_PARTIAL => Self::Partial,
            ffi::GDK_KEY_MATCH_EXACT => Self::Exact,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for KeyMatch {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_key_match_get_type()) }
    }
}

impl glib::value::ValueType for KeyMatch {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for KeyMatch {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for KeyMatch {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkMemoryFormat")]
pub enum MemoryFormat {
    #[doc(alias = "GDK_MEMORY_B8G8R8A8_PREMULTIPLIED")]
    B8g8r8a8Premultiplied,
    #[doc(alias = "GDK_MEMORY_A8R8G8B8_PREMULTIPLIED")]
    A8r8g8b8Premultiplied,
    #[doc(alias = "GDK_MEMORY_R8G8B8A8_PREMULTIPLIED")]
    R8g8b8a8Premultiplied,
    #[doc(alias = "GDK_MEMORY_B8G8R8A8")]
    B8g8r8a8,
    #[doc(alias = "GDK_MEMORY_A8R8G8B8")]
    A8r8g8b8,
    #[doc(alias = "GDK_MEMORY_R8G8B8A8")]
    R8g8b8a8,
    #[doc(alias = "GDK_MEMORY_A8B8G8R8")]
    A8b8g8r8,
    #[doc(alias = "GDK_MEMORY_R8G8B8")]
    R8g8b8,
    #[doc(alias = "GDK_MEMORY_B8G8R8")]
    B8g8r8,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R16G16B16")]
    R16g16b16,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R16G16B16A16_PREMULTIPLIED")]
    R16g16b16a16Premultiplied,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R16G16B16A16")]
    R16g16b16a16,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R16G16B16_FLOAT")]
    R16g16b16Float,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R16G16B16A16_FLOAT_PREMULTIPLIED")]
    R16g16b16a16FloatPremultiplied,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R16G16B16A16_FLOAT")]
    R16g16b16a16Float,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R32G32B32_FLOAT")]
    R32g32b32Float,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R32G32B32A32_FLOAT_PREMULTIPLIED")]
    R32g32b32a32FloatPremultiplied,
    #[cfg(any(feature = "v4_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
    #[doc(alias = "GDK_MEMORY_R32G32B32A32_FLOAT")]
    R32g32b32a32Float,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MemoryFormat {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MemoryFormat::{}",
            match *self {
                Self::B8g8r8a8Premultiplied => "B8g8r8a8Premultiplied",
                Self::A8r8g8b8Premultiplied => "A8r8g8b8Premultiplied",
                Self::R8g8b8a8Premultiplied => "R8g8b8a8Premultiplied",
                Self::B8g8r8a8 => "B8g8r8a8",
                Self::A8r8g8b8 => "A8r8g8b8",
                Self::R8g8b8a8 => "R8g8b8a8",
                Self::A8b8g8r8 => "A8b8g8r8",
                Self::R8g8b8 => "R8g8b8",
                Self::B8g8r8 => "B8g8r8",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R16g16b16 => "R16g16b16",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R16g16b16a16Premultiplied => "R16g16b16a16Premultiplied",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R16g16b16a16 => "R16g16b16a16",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R16g16b16Float => "R16g16b16Float",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R16g16b16a16FloatPremultiplied => "R16g16b16a16FloatPremultiplied",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R16g16b16a16Float => "R16g16b16a16Float",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R32g32b32Float => "R32g32b32Float",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R32g32b32a32FloatPremultiplied => "R32g32b32a32FloatPremultiplied",
                #[cfg(any(feature = "v4_6", feature = "dox"))]
                Self::R32g32b32a32Float => "R32g32b32a32Float",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MemoryFormat {
    type GlibType = ffi::GdkMemoryFormat;

    fn into_glib(self) -> ffi::GdkMemoryFormat {
        match self {
            Self::B8g8r8a8Premultiplied => ffi::GDK_MEMORY_B8G8R8A8_PREMULTIPLIED,
            Self::A8r8g8b8Premultiplied => ffi::GDK_MEMORY_A8R8G8B8_PREMULTIPLIED,
            Self::R8g8b8a8Premultiplied => ffi::GDK_MEMORY_R8G8B8A8_PREMULTIPLIED,
            Self::B8g8r8a8 => ffi::GDK_MEMORY_B8G8R8A8,
            Self::A8r8g8b8 => ffi::GDK_MEMORY_A8R8G8B8,
            Self::R8g8b8a8 => ffi::GDK_MEMORY_R8G8B8A8,
            Self::A8b8g8r8 => ffi::GDK_MEMORY_A8B8G8R8,
            Self::R8g8b8 => ffi::GDK_MEMORY_R8G8B8,
            Self::B8g8r8 => ffi::GDK_MEMORY_B8G8R8,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R16g16b16 => ffi::GDK_MEMORY_R16G16B16,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R16g16b16a16Premultiplied => ffi::GDK_MEMORY_R16G16B16A16_PREMULTIPLIED,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R16g16b16a16 => ffi::GDK_MEMORY_R16G16B16A16,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R16g16b16Float => ffi::GDK_MEMORY_R16G16B16_FLOAT,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R16g16b16a16FloatPremultiplied => {
                ffi::GDK_MEMORY_R16G16B16A16_FLOAT_PREMULTIPLIED
            }
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R16g16b16a16Float => ffi::GDK_MEMORY_R16G16B16A16_FLOAT,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R32g32b32Float => ffi::GDK_MEMORY_R32G32B32_FLOAT,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R32g32b32a32FloatPremultiplied => {
                ffi::GDK_MEMORY_R32G32B32A32_FLOAT_PREMULTIPLIED
            }
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            Self::R32g32b32a32Float => ffi::GDK_MEMORY_R32G32B32A32_FLOAT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkMemoryFormat> for MemoryFormat {
    unsafe fn from_glib(value: ffi::GdkMemoryFormat) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_MEMORY_B8G8R8A8_PREMULTIPLIED => Self::B8g8r8a8Premultiplied,
            ffi::GDK_MEMORY_A8R8G8B8_PREMULTIPLIED => Self::A8r8g8b8Premultiplied,
            ffi::GDK_MEMORY_R8G8B8A8_PREMULTIPLIED => Self::R8g8b8a8Premultiplied,
            ffi::GDK_MEMORY_B8G8R8A8 => Self::B8g8r8a8,
            ffi::GDK_MEMORY_A8R8G8B8 => Self::A8r8g8b8,
            ffi::GDK_MEMORY_R8G8B8A8 => Self::R8g8b8a8,
            ffi::GDK_MEMORY_A8B8G8R8 => Self::A8b8g8r8,
            ffi::GDK_MEMORY_R8G8B8 => Self::R8g8b8,
            ffi::GDK_MEMORY_B8G8R8 => Self::B8g8r8,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R16G16B16 => Self::R16g16b16,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R16G16B16A16_PREMULTIPLIED => Self::R16g16b16a16Premultiplied,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R16G16B16A16 => Self::R16g16b16a16,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R16G16B16_FLOAT => Self::R16g16b16Float,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R16G16B16A16_FLOAT_PREMULTIPLIED => {
                Self::R16g16b16a16FloatPremultiplied
            }
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R16G16B16A16_FLOAT => Self::R16g16b16a16Float,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R32G32B32_FLOAT => Self::R32g32b32Float,
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R32G32B32A32_FLOAT_PREMULTIPLIED => {
                Self::R32g32b32a32FloatPremultiplied
            }
            #[cfg(any(feature = "v4_6", feature = "dox"))]
            ffi::GDK_MEMORY_R32G32B32A32_FLOAT => Self::R32g32b32a32Float,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MemoryFormat {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_memory_format_get_type()) }
    }
}

impl glib::value::ValueType for MemoryFormat {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MemoryFormat {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MemoryFormat {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkNotifyType")]
pub enum NotifyType {
    #[doc(alias = "GDK_NOTIFY_ANCESTOR")]
    Ancestor,
    #[doc(alias = "GDK_NOTIFY_VIRTUAL")]
    Virtual,
    #[doc(alias = "GDK_NOTIFY_INFERIOR")]
    Inferior,
    #[doc(alias = "GDK_NOTIFY_NONLINEAR")]
    Nonlinear,
    #[doc(alias = "GDK_NOTIFY_NONLINEAR_VIRTUAL")]
    NonlinearVirtual,
    #[doc(alias = "GDK_NOTIFY_UNKNOWN")]
    Unknown,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for NotifyType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "NotifyType::{}",
            match *self {
                Self::Ancestor => "Ancestor",
                Self::Virtual => "Virtual",
                Self::Inferior => "Inferior",
                Self::Nonlinear => "Nonlinear",
                Self::NonlinearVirtual => "NonlinearVirtual",
                Self::Unknown => "Unknown",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for NotifyType {
    type GlibType = ffi::GdkNotifyType;

    fn into_glib(self) -> ffi::GdkNotifyType {
        match self {
            Self::Ancestor => ffi::GDK_NOTIFY_ANCESTOR,
            Self::Virtual => ffi::GDK_NOTIFY_VIRTUAL,
            Self::Inferior => ffi::GDK_NOTIFY_INFERIOR,
            Self::Nonlinear => ffi::GDK_NOTIFY_NONLINEAR,
            Self::NonlinearVirtual => ffi::GDK_NOTIFY_NONLINEAR_VIRTUAL,
            Self::Unknown => ffi::GDK_NOTIFY_UNKNOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkNotifyType> for NotifyType {
    unsafe fn from_glib(value: ffi::GdkNotifyType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_NOTIFY_ANCESTOR => Self::Ancestor,
            ffi::GDK_NOTIFY_VIRTUAL => Self::Virtual,
            ffi::GDK_NOTIFY_INFERIOR => Self::Inferior,
            ffi::GDK_NOTIFY_NONLINEAR => Self::Nonlinear,
            ffi::GDK_NOTIFY_NONLINEAR_VIRTUAL => Self::NonlinearVirtual,
            ffi::GDK_NOTIFY_UNKNOWN => Self::Unknown,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NotifyType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_notify_type_get_type()) }
    }
}

impl glib::value::ValueType for NotifyType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for NotifyType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NotifyType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkScrollDirection")]
pub enum ScrollDirection {
    #[doc(alias = "GDK_SCROLL_UP")]
    Up,
    #[doc(alias = "GDK_SCROLL_DOWN")]
    Down,
    #[doc(alias = "GDK_SCROLL_LEFT")]
    Left,
    #[doc(alias = "GDK_SCROLL_RIGHT")]
    Right,
    #[doc(alias = "GDK_SCROLL_SMOOTH")]
    Smooth,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ScrollDirection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ScrollDirection::{}",
            match *self {
                Self::Up => "Up",
                Self::Down => "Down",
                Self::Left => "Left",
                Self::Right => "Right",
                Self::Smooth => "Smooth",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ScrollDirection {
    type GlibType = ffi::GdkScrollDirection;

    fn into_glib(self) -> ffi::GdkScrollDirection {
        match self {
            Self::Up => ffi::GDK_SCROLL_UP,
            Self::Down => ffi::GDK_SCROLL_DOWN,
            Self::Left => ffi::GDK_SCROLL_LEFT,
            Self::Right => ffi::GDK_SCROLL_RIGHT,
            Self::Smooth => ffi::GDK_SCROLL_SMOOTH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkScrollDirection> for ScrollDirection {
    unsafe fn from_glib(value: ffi::GdkScrollDirection) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_SCROLL_UP => Self::Up,
            ffi::GDK_SCROLL_DOWN => Self::Down,
            ffi::GDK_SCROLL_LEFT => Self::Left,
            ffi::GDK_SCROLL_RIGHT => Self::Right,
            ffi::GDK_SCROLL_SMOOTH => Self::Smooth,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ScrollDirection {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_scroll_direction_get_type()) }
    }
}

impl glib::value::ValueType for ScrollDirection {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ScrollDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ScrollDirection {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkSubpixelLayout")]
pub enum SubpixelLayout {
    #[doc(alias = "GDK_SUBPIXEL_LAYOUT_UNKNOWN")]
    Unknown,
    #[doc(alias = "GDK_SUBPIXEL_LAYOUT_NONE")]
    None,
    #[doc(alias = "GDK_SUBPIXEL_LAYOUT_HORIZONTAL_RGB")]
    HorizontalRgb,
    #[doc(alias = "GDK_SUBPIXEL_LAYOUT_HORIZONTAL_BGR")]
    HorizontalBgr,
    #[doc(alias = "GDK_SUBPIXEL_LAYOUT_VERTICAL_RGB")]
    VerticalRgb,
    #[doc(alias = "GDK_SUBPIXEL_LAYOUT_VERTICAL_BGR")]
    VerticalBgr,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SubpixelLayout {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SubpixelLayout::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::None => "None",
                Self::HorizontalRgb => "HorizontalRgb",
                Self::HorizontalBgr => "HorizontalBgr",
                Self::VerticalRgb => "VerticalRgb",
                Self::VerticalBgr => "VerticalBgr",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SubpixelLayout {
    type GlibType = ffi::GdkSubpixelLayout;

    fn into_glib(self) -> ffi::GdkSubpixelLayout {
        match self {
            Self::Unknown => ffi::GDK_SUBPIXEL_LAYOUT_UNKNOWN,
            Self::None => ffi::GDK_SUBPIXEL_LAYOUT_NONE,
            Self::HorizontalRgb => ffi::GDK_SUBPIXEL_LAYOUT_HORIZONTAL_RGB,
            Self::HorizontalBgr => ffi::GDK_SUBPIXEL_LAYOUT_HORIZONTAL_BGR,
            Self::VerticalRgb => ffi::GDK_SUBPIXEL_LAYOUT_VERTICAL_RGB,
            Self::VerticalBgr => ffi::GDK_SUBPIXEL_LAYOUT_VERTICAL_BGR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkSubpixelLayout> for SubpixelLayout {
    unsafe fn from_glib(value: ffi::GdkSubpixelLayout) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_SUBPIXEL_LAYOUT_UNKNOWN => Self::Unknown,
            ffi::GDK_SUBPIXEL_LAYOUT_NONE => Self::None,
            ffi::GDK_SUBPIXEL_LAYOUT_HORIZONTAL_RGB => Self::HorizontalRgb,
            ffi::GDK_SUBPIXEL_LAYOUT_HORIZONTAL_BGR => Self::HorizontalBgr,
            ffi::GDK_SUBPIXEL_LAYOUT_VERTICAL_RGB => Self::VerticalRgb,
            ffi::GDK_SUBPIXEL_LAYOUT_VERTICAL_BGR => Self::VerticalBgr,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SubpixelLayout {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_subpixel_layout_get_type()) }
    }
}

impl glib::value::ValueType for SubpixelLayout {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SubpixelLayout {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SubpixelLayout {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkSurfaceEdge")]
pub enum SurfaceEdge {
    #[doc(alias = "GDK_SURFACE_EDGE_NORTH_WEST")]
    NorthWest,
    #[doc(alias = "GDK_SURFACE_EDGE_NORTH")]
    North,
    #[doc(alias = "GDK_SURFACE_EDGE_NORTH_EAST")]
    NorthEast,
    #[doc(alias = "GDK_SURFACE_EDGE_WEST")]
    West,
    #[doc(alias = "GDK_SURFACE_EDGE_EAST")]
    East,
    #[doc(alias = "GDK_SURFACE_EDGE_SOUTH_WEST")]
    SouthWest,
    #[doc(alias = "GDK_SURFACE_EDGE_SOUTH")]
    South,
    #[doc(alias = "GDK_SURFACE_EDGE_SOUTH_EAST")]
    SouthEast,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SurfaceEdge {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SurfaceEdge::{}",
            match *self {
                Self::NorthWest => "NorthWest",
                Self::North => "North",
                Self::NorthEast => "NorthEast",
                Self::West => "West",
                Self::East => "East",
                Self::SouthWest => "SouthWest",
                Self::South => "South",
                Self::SouthEast => "SouthEast",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SurfaceEdge {
    type GlibType = ffi::GdkSurfaceEdge;

    fn into_glib(self) -> ffi::GdkSurfaceEdge {
        match self {
            Self::NorthWest => ffi::GDK_SURFACE_EDGE_NORTH_WEST,
            Self::North => ffi::GDK_SURFACE_EDGE_NORTH,
            Self::NorthEast => ffi::GDK_SURFACE_EDGE_NORTH_EAST,
            Self::West => ffi::GDK_SURFACE_EDGE_WEST,
            Self::East => ffi::GDK_SURFACE_EDGE_EAST,
            Self::SouthWest => ffi::GDK_SURFACE_EDGE_SOUTH_WEST,
            Self::South => ffi::GDK_SURFACE_EDGE_SOUTH,
            Self::SouthEast => ffi::GDK_SURFACE_EDGE_SOUTH_EAST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkSurfaceEdge> for SurfaceEdge {
    unsafe fn from_glib(value: ffi::GdkSurfaceEdge) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_SURFACE_EDGE_NORTH_WEST => Self::NorthWest,
            ffi::GDK_SURFACE_EDGE_NORTH => Self::North,
            ffi::GDK_SURFACE_EDGE_NORTH_EAST => Self::NorthEast,
            ffi::GDK_SURFACE_EDGE_WEST => Self::West,
            ffi::GDK_SURFACE_EDGE_EAST => Self::East,
            ffi::GDK_SURFACE_EDGE_SOUTH_WEST => Self::SouthWest,
            ffi::GDK_SURFACE_EDGE_SOUTH => Self::South,
            ffi::GDK_SURFACE_EDGE_SOUTH_EAST => Self::SouthEast,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SurfaceEdge {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_surface_edge_get_type()) }
    }
}

impl glib::value::ValueType for SurfaceEdge {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SurfaceEdge {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SurfaceEdge {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkTextureError")]
pub enum TextureError {
    #[doc(alias = "GDK_TEXTURE_ERROR_TOO_LARGE")]
    TooLarge,
    #[doc(alias = "GDK_TEXTURE_ERROR_CORRUPT_IMAGE")]
    CorruptImage,
    #[doc(alias = "GDK_TEXTURE_ERROR_UNSUPPORTED_CONTENT")]
    UnsupportedContent,
    #[doc(alias = "GDK_TEXTURE_ERROR_UNSUPPORTED_FORMAT")]
    UnsupportedFormat,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
impl fmt::Display for TextureError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextureError::{}",
            match *self {
                Self::TooLarge => "TooLarge",
                Self::CorruptImage => "CorruptImage",
                Self::UnsupportedContent => "UnsupportedContent",
                Self::UnsupportedFormat => "UnsupportedFormat",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
#[doc(hidden)]
impl IntoGlib for TextureError {
    type GlibType = ffi::GdkTextureError;

    fn into_glib(self) -> ffi::GdkTextureError {
        match self {
            Self::TooLarge => ffi::GDK_TEXTURE_ERROR_TOO_LARGE,
            Self::CorruptImage => ffi::GDK_TEXTURE_ERROR_CORRUPT_IMAGE,
            Self::UnsupportedContent => ffi::GDK_TEXTURE_ERROR_UNSUPPORTED_CONTENT,
            Self::UnsupportedFormat => ffi::GDK_TEXTURE_ERROR_UNSUPPORTED_FORMAT,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
#[doc(hidden)]
impl FromGlib<ffi::GdkTextureError> for TextureError {
    unsafe fn from_glib(value: ffi::GdkTextureError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_TEXTURE_ERROR_TOO_LARGE => Self::TooLarge,
            ffi::GDK_TEXTURE_ERROR_CORRUPT_IMAGE => Self::CorruptImage,
            ffi::GDK_TEXTURE_ERROR_UNSUPPORTED_CONTENT => Self::UnsupportedContent,
            ffi::GDK_TEXTURE_ERROR_UNSUPPORTED_FORMAT => Self::UnsupportedFormat,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
impl ErrorDomain for TextureError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gdk_texture_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GDK_TEXTURE_ERROR_TOO_LARGE => Some(Self::TooLarge),
            ffi::GDK_TEXTURE_ERROR_CORRUPT_IMAGE => Some(Self::CorruptImage),
            ffi::GDK_TEXTURE_ERROR_UNSUPPORTED_CONTENT => Some(Self::UnsupportedContent),
            ffi::GDK_TEXTURE_ERROR_UNSUPPORTED_FORMAT => Some(Self::UnsupportedFormat),
            value => Some(Self::__Unknown(value)),
        }
    }
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
impl StaticType for TextureError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_texture_error_get_type()) }
    }
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
impl glib::value::ValueType for TextureError {
    type Type = Self;
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
unsafe impl<'a> FromValue<'a> for TextureError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v4_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_6")))]
impl ToValue for TextureError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v4_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkTitlebarGesture")]
pub enum TitlebarGesture {
    #[doc(alias = "GDK_TITLEBAR_GESTURE_DOUBLE_CLICK")]
    DoubleClick,
    #[doc(alias = "GDK_TITLEBAR_GESTURE_RIGHT_CLICK")]
    RightClick,
    #[doc(alias = "GDK_TITLEBAR_GESTURE_MIDDLE_CLICK")]
    MiddleClick,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v4_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
impl fmt::Display for TitlebarGesture {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TitlebarGesture::{}",
            match *self {
                Self::DoubleClick => "DoubleClick",
                Self::RightClick => "RightClick",
                Self::MiddleClick => "MiddleClick",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v4_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
#[doc(hidden)]
impl IntoGlib for TitlebarGesture {
    type GlibType = ffi::GdkTitlebarGesture;

    fn into_glib(self) -> ffi::GdkTitlebarGesture {
        match self {
            Self::DoubleClick => ffi::GDK_TITLEBAR_GESTURE_DOUBLE_CLICK,
            Self::RightClick => ffi::GDK_TITLEBAR_GESTURE_RIGHT_CLICK,
            Self::MiddleClick => ffi::GDK_TITLEBAR_GESTURE_MIDDLE_CLICK,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v4_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
#[doc(hidden)]
impl FromGlib<ffi::GdkTitlebarGesture> for TitlebarGesture {
    unsafe fn from_glib(value: ffi::GdkTitlebarGesture) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_TITLEBAR_GESTURE_DOUBLE_CLICK => Self::DoubleClick,
            ffi::GDK_TITLEBAR_GESTURE_RIGHT_CLICK => Self::RightClick,
            ffi::GDK_TITLEBAR_GESTURE_MIDDLE_CLICK => Self::MiddleClick,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v4_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
impl StaticType for TitlebarGesture {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_titlebar_gesture_get_type()) }
    }
}

#[cfg(any(feature = "v4_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
impl glib::value::ValueType for TitlebarGesture {
    type Type = Self;
}

#[cfg(any(feature = "v4_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
unsafe impl<'a> FromValue<'a> for TitlebarGesture {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v4_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v4_4")))]
impl ToValue for TitlebarGesture {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkTouchpadGesturePhase")]
pub enum TouchpadGesturePhase {
    #[doc(alias = "GDK_TOUCHPAD_GESTURE_PHASE_BEGIN")]
    Begin,
    #[doc(alias = "GDK_TOUCHPAD_GESTURE_PHASE_UPDATE")]
    Update,
    #[doc(alias = "GDK_TOUCHPAD_GESTURE_PHASE_END")]
    End,
    #[doc(alias = "GDK_TOUCHPAD_GESTURE_PHASE_CANCEL")]
    Cancel,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TouchpadGesturePhase {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TouchpadGesturePhase::{}",
            match *self {
                Self::Begin => "Begin",
                Self::Update => "Update",
                Self::End => "End",
                Self::Cancel => "Cancel",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TouchpadGesturePhase {
    type GlibType = ffi::GdkTouchpadGesturePhase;

    fn into_glib(self) -> ffi::GdkTouchpadGesturePhase {
        match self {
            Self::Begin => ffi::GDK_TOUCHPAD_GESTURE_PHASE_BEGIN,
            Self::Update => ffi::GDK_TOUCHPAD_GESTURE_PHASE_UPDATE,
            Self::End => ffi::GDK_TOUCHPAD_GESTURE_PHASE_END,
            Self::Cancel => ffi::GDK_TOUCHPAD_GESTURE_PHASE_CANCEL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkTouchpadGesturePhase> for TouchpadGesturePhase {
    unsafe fn from_glib(value: ffi::GdkTouchpadGesturePhase) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_TOUCHPAD_GESTURE_PHASE_BEGIN => Self::Begin,
            ffi::GDK_TOUCHPAD_GESTURE_PHASE_UPDATE => Self::Update,
            ffi::GDK_TOUCHPAD_GESTURE_PHASE_END => Self::End,
            ffi::GDK_TOUCHPAD_GESTURE_PHASE_CANCEL => Self::Cancel,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TouchpadGesturePhase {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_touchpad_gesture_phase_get_type()) }
    }
}

impl glib::value::ValueType for TouchpadGesturePhase {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TouchpadGesturePhase {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TouchpadGesturePhase {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GdkVulkanError")]
pub enum VulkanError {
    #[doc(alias = "GDK_VULKAN_ERROR_UNSUPPORTED")]
    Unsupported,
    #[doc(alias = "GDK_VULKAN_ERROR_NOT_AVAILABLE")]
    NotAvailable,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for VulkanError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "VulkanError::{}",
            match *self {
                Self::Unsupported => "Unsupported",
                Self::NotAvailable => "NotAvailable",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for VulkanError {
    type GlibType = ffi::GdkVulkanError;

    fn into_glib(self) -> ffi::GdkVulkanError {
        match self {
            Self::Unsupported => ffi::GDK_VULKAN_ERROR_UNSUPPORTED,
            Self::NotAvailable => ffi::GDK_VULKAN_ERROR_NOT_AVAILABLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkVulkanError> for VulkanError {
    unsafe fn from_glib(value: ffi::GdkVulkanError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::GDK_VULKAN_ERROR_UNSUPPORTED => Self::Unsupported,
            ffi::GDK_VULKAN_ERROR_NOT_AVAILABLE => Self::NotAvailable,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for VulkanError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::gdk_vulkan_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::GDK_VULKAN_ERROR_UNSUPPORTED => Some(Self::Unsupported),
            ffi::GDK_VULKAN_ERROR_NOT_AVAILABLE => Some(Self::NotAvailable),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for VulkanError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_vulkan_error_get_type()) }
    }
}

impl glib::value::ValueType for VulkanError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for VulkanError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for VulkanError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
