/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*- */
/*
 * Copyright © 2017 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#if !defined (__GOA_BACKEND_INSIDE_GOA_BACKEND_H__) && !defined (GOA_BACKEND_COMPILATION)
#error "Only <goabackend/goabackend.h> can be included directly."
#endif

#ifndef __GOA_SOUP_LOGGER_H__
#define __GOA_SOUP_LOGGER_H__

#include <libsoup/soup.h>

G_BEGIN_DECLS

#define GOA_TYPE_SOUP_LOGGER (goa_soup_logger_get_type ())
G_DECLARE_FINAL_TYPE (GoaSoupLogger, goa_soup_logger, GOA, SOUP_LOGGER, SoupLogger);

SoupLogger     *goa_soup_logger_new                (SoupLoggerLogLevel   level,
                                                    gint                 max_body_size);

G_END_DECLS

#endif /* __GOA_SOUP_LOGGER_H__ */
