/* valaelementaccess.c generated by valac, the Vala compiler
 * generated from valaelementaccess.vala, do not modify */

/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaElementAccessPrivate {
	gboolean _null_safe_access;
	ValaList* indices;
	ValaExpression* _container;
};

static gint ValaElementAccess_private_offset;
static gpointer vala_element_access_parent_class = NULL;

static void vala_element_access_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_element_access_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static gchar* vala_element_access_real_to_string (ValaCodeNode* base);
static void vala_element_access_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static gboolean vala_element_access_real_is_pure (ValaExpression* base);
static gboolean vala_element_access_real_is_accessible (ValaExpression* base,
                                                 ValaSymbol* sym);
static void vala_element_access_real_get_error_types (ValaCodeNode* base,
                                               ValaCollection* collection,
                                               ValaSourceReference* source_reference);
static gboolean vala_element_access_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_element_access_real_emit (ValaCodeNode* base,
                                    ValaCodeGenerator* codegen);
static void vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_element_access_finalize (ValaCodeNode * obj);
static GType vala_element_access_get_type_once (void);

static inline gpointer
vala_element_access_get_instance_private (ValaElementAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaElementAccess_private_offset);
}

ValaExpression*
vala_element_access_get_container (ValaElementAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_container;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_element_access_set_container (ValaElementAccess* self,
                                   ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_container);
	self->priv->_container = _tmp0_;
	_tmp1_ = self->priv->_container;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_element_access_get_null_safe_access (ValaElementAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_null_safe_access;
	return result;
}

void
vala_element_access_set_null_safe_access (ValaElementAccess* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_null_safe_access = value;
}

void
vala_element_access_append_index (ValaElementAccess* self,
                                  ValaExpression* index)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->indices;
	vala_collection_add ((ValaCollection*) _tmp0_, index);
	vala_code_node_set_parent_node ((ValaCodeNode*) index, (ValaCodeNode*) self);
}

ValaList*
vala_element_access_get_indices (ValaElementAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indices;
	result = _tmp0_;
	return result;
}

ValaElementAccess*
vala_element_access_construct (GType object_type,
                               ValaExpression* container,
                               ValaSourceReference* source_reference)
{
	ValaElementAccess* self = NULL;
	g_return_val_if_fail (container != NULL, NULL);
	self = (ValaElementAccess*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_element_access_set_container (self, container);
	return self;
}

ValaElementAccess*
vala_element_access_new (ValaExpression* container,
                         ValaSourceReference* source_reference)
{
	return vala_element_access_construct (VALA_TYPE_ELEMENT_ACCESS, container, source_reference);
}

static void
vala_element_access_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_element_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_element_access_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		gint _e_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_e_list = _tmp2_;
		_tmp3_ = _e_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_e_size = _tmp5_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = vala_list_get (_tmp8_, _e_index);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (e);
		}
	}
}

static gchar*
vala_element_access_real_to_string (ValaCodeNode* base)
{
	ValaElementAccess * self;
	gchar* s = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* result = NULL;
	self = (ValaElementAccess*) base;
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s[", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	s = _tmp5_;
	first = TRUE;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp6_;
		gint _index_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _index_index = 0;
		_tmp6_ = self->priv->indices;
		_index_list = _tmp6_;
		_tmp7_ = _index_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_index_size = _tmp9_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* index = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			_index_index = _index_index + 1;
			_tmp10_ = _index_index;
			_tmp11_ = _index_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _index_list;
			_tmp13_ = vala_list_get (_tmp12_, _index_index);
			index = (ValaExpression*) _tmp13_;
			if (first) {
				const gchar* _tmp14_;
				ValaExpression* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = s;
				_tmp15_ = index;
				_tmp16_ = vala_code_node_to_string ((ValaCodeNode*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
				_g_free0 (s);
				s = _tmp18_;
				_g_free0 (_tmp17_);
				first = FALSE;
			} else {
				const gchar* _tmp19_;
				ValaExpression* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp19_ = s;
				_tmp20_ = index;
				_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup_printf (", %s", _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
				_g_free0 (s);
				s = _tmp25_;
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
			}
			_vala_code_node_unref0 (index);
		}
	}
	_tmp26_ = s;
	_tmp27_ = g_strconcat (_tmp26_, "]", NULL);
	result = _tmp27_;
	_g_free0 (s);
	return result;
}

static void
vala_element_access_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_element_access_set_container (self, new_node);
	}
	_tmp2_ = self->priv->indices;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->indices;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_element_access_real_is_pure (ValaExpression* base)
{
	ValaElementAccess * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		gint _index_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_index_list = _tmp0_;
		_tmp1_ = _index_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_index_size = _tmp3_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* index = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_index_index = _index_index + 1;
			_tmp4_ = _index_index;
			_tmp5_ = _index_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _index_list;
			_tmp7_ = vala_list_get (_tmp6_, _index_index);
			index = (ValaExpression*) _tmp7_;
			_tmp8_ = index;
			if (!vala_expression_is_pure (_tmp8_)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
	}
	_tmp9_ = vala_element_access_get_container (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_pure (_tmp10_);
	return result;
}

static gboolean
vala_element_access_real_is_accessible (ValaExpression* base,
                                        ValaSymbol* sym)
{
	ValaElementAccess * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		gint _index_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_index_list = _tmp0_;
		_tmp1_ = _index_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_index_size = _tmp3_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* index = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_index_index = _index_index + 1;
			_tmp4_ = _index_index;
			_tmp5_ = _index_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _index_list;
			_tmp7_ = vala_list_get (_tmp6_, _index_index);
			index = (ValaExpression*) _tmp7_;
			_tmp8_ = index;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
	}
	_tmp9_ = vala_element_access_get_container (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_element_access_real_get_error_types (ValaCodeNode* base,
                                          ValaCollection* collection,
                                          ValaSourceReference* source_reference)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		gint _e_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_e_list = _tmp2_;
		_tmp3_ = _e_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_e_size = _tmp5_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = vala_list_get (_tmp8_, _e_index);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp10_, collection, source_reference);
			_vala_code_node_unref0 (e);
		}
	}
}

static gboolean
vala_element_access_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaElementAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	gboolean _tmp17_ = FALSE;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	gboolean index_int_type_check = FALSE;
	ValaPointerType* pointer_type = NULL;
	ValaExpression* _tmp60_;
	ValaExpression* _tmp61_;
	ValaDataType* _tmp62_;
	ValaDataType* _tmp63_;
	ValaExpression* _tmp64_;
	ValaExpression* _tmp65_;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp266_;
	ValaDataType* _tmp267_;
	gboolean _tmp268_;
	gboolean _tmp269_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_null_safe_access;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_element_access_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		result = !_tmp6_;
		return result;
	}
	_tmp7_ = vala_element_access_get_container (self);
	_tmp8_ = _tmp7_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp8_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp9_ = vala_element_access_get_container (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == NULL) {
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaSourceReference* _tmp16_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp13_ = vala_element_access_get_container (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp14_);
		_tmp16_ = _tmp15_;
		vala_report_error (_tmp16_, "Invalid container expression");
		result = FALSE;
		return result;
	}
	_tmp18_ = vala_element_access_get_container (self);
	_tmp19_ = _tmp18_;
	if (VALA_IS_MEMBER_ACCESS (_tmp19_)) {
		ValaExpression* _tmp20_;
		ValaExpression* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		_tmp20_ = vala_element_access_get_container (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_expression_get_symbol_reference (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = VALA_IS_SIGNAL (_tmp23_);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		ValaExpression* detail_expr = NULL;
		ValaList* _tmp29_;
		gpointer _tmp30_;
		ValaExpression* _tmp31_;
		ValaSemanticAnalyzer* _tmp32_;
		ValaSemanticAnalyzer* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		ValaExpression* _tmp37_;
		gboolean _tmp38_ = FALSE;
		ValaExpression* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		_tmp24_ = vala_element_access_get_indices (self);
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_ != 1) {
			ValaSourceReference* _tmp27_;
			ValaSourceReference* _tmp28_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp28_ = _tmp27_;
			vala_report_error (_tmp28_, "Element access with more than one dimension is not supported for signa" \
"ls");
			result = FALSE;
			return result;
		}
		_tmp29_ = vala_element_access_get_indices (self);
		_tmp30_ = vala_list_get (_tmp29_, 0);
		detail_expr = (ValaExpression*) _tmp30_;
		_tmp31_ = detail_expr;
		_tmp32_ = vala_code_context_get_analyzer (context);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_->string_type;
		_tmp35_ = vala_data_type_copy (_tmp34_);
		_tmp36_ = _tmp35_;
		vala_expression_set_target_type (_tmp31_, _tmp36_);
		_vala_code_node_unref0 (_tmp36_);
		_tmp37_ = detail_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp37_, context);
		_tmp39_ = detail_expr;
		_tmp40_ = vala_expression_get_value_type (_tmp39_);
		_tmp41_ = _tmp40_;
		if (VALA_IS_NULL_TYPE (_tmp41_)) {
			_tmp38_ = TRUE;
		} else {
			ValaExpression* _tmp42_;
			ValaDataType* _tmp43_;
			ValaDataType* _tmp44_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaSemanticAnalyzer* _tmp46_;
			ValaDataType* _tmp47_;
			_tmp42_ = detail_expr;
			_tmp43_ = vala_expression_get_value_type (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_code_context_get_analyzer (context);
			_tmp46_ = _tmp45_;
			_tmp47_ = _tmp46_->string_type;
			_tmp38_ = !vala_data_type_compatible (_tmp44_, _tmp47_);
		}
		if (_tmp38_) {
			ValaExpression* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaSourceReference* _tmp50_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp48_ = detail_expr;
			_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
			_tmp50_ = _tmp49_;
			vala_report_error (_tmp50_, "only string details are supported");
			result = FALSE;
			_vala_code_node_unref0 (detail_expr);
			return result;
		}
		_vala_code_node_unref0 (detail_expr);
	}
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp51_;
		gint _index_size = 0;
		ValaList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _index_index = 0;
		_tmp51_ = vala_element_access_get_indices (self);
		_index_list = _tmp51_;
		_tmp52_ = _index_list;
		_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_index_size = _tmp54_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			ValaExpression* index = NULL;
			ValaList* _tmp57_;
			gpointer _tmp58_;
			ValaExpression* _tmp59_;
			_index_index = _index_index + 1;
			_tmp55_ = _index_index;
			_tmp56_ = _index_size;
			if (!(_tmp55_ < _tmp56_)) {
				break;
			}
			_tmp57_ = _index_list;
			_tmp58_ = vala_list_get (_tmp57_, _index_index);
			index = (ValaExpression*) _tmp58_;
			_tmp59_ = index;
			vala_code_node_check ((ValaCodeNode*) _tmp59_, context);
			_vala_code_node_unref0 (index);
		}
	}
	index_int_type_check = TRUE;
	_tmp60_ = vala_element_access_get_container (self);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_expression_get_value_type (_tmp61_);
	_tmp63_ = _tmp62_;
	pointer_type = VALA_IS_POINTER_TYPE (_tmp63_) ? ((ValaPointerType*) _tmp63_) : NULL;
	_tmp64_ = vala_element_access_get_container (self);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_expression_get_value_type (_tmp65_);
	_tmp67_ = _tmp66_;
	if (VALA_IS_ARRAY_TYPE (_tmp67_)) {
		ValaArrayType* array_type = NULL;
		ValaExpression* _tmp68_;
		ValaExpression* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		ValaArrayType* _tmp72_;
		ValaDataType* _tmp73_;
		ValaDataType* _tmp74_;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		gboolean _tmp77_;
		gboolean _tmp78_;
		ValaArrayType* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		ValaList* _tmp131_;
		gint _tmp132_;
		gint _tmp133_;
		_tmp68_ = vala_element_access_get_container (self);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_expression_get_value_type (_tmp69_);
		_tmp71_ = _tmp70_;
		array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
		_tmp72_ = array_type;
		_tmp73_ = vala_array_type_get_element_type (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_data_type_copy (_tmp74_);
		_tmp76_ = _tmp75_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp76_);
		_vala_code_node_unref0 (_tmp76_);
		_tmp77_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp78_ = _tmp77_;
		if (!_tmp78_) {
			ValaDataType* _tmp79_;
			ValaDataType* _tmp80_;
			_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp80_ = _tmp79_;
			vala_data_type_set_value_owned (_tmp80_, FALSE);
		} else {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp81_;
			ValaExpression* _tmp82_;
			gboolean _tmp83_ = FALSE;
			gboolean _tmp84_ = FALSE;
			ValaProfile _tmp85_;
			ValaProfile _tmp86_;
			_tmp81_ = vala_element_access_get_container (self);
			_tmp82_ = _tmp81_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp82_) ? ((ValaMemberAccess*) _tmp82_) : NULL;
			_tmp85_ = vala_code_context_get_profile (context);
			_tmp86_ = _tmp85_;
			if (_tmp86_ == VALA_PROFILE_GOBJECT) {
				ValaMemberAccess* _tmp87_;
				_tmp87_ = ma;
				_tmp84_ = _tmp87_ != NULL;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				ValaMemberAccess* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				_tmp88_ = ma;
				_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp88_);
				_tmp90_ = _tmp89_;
				_tmp83_ = VALA_IS_ARRAY_LENGTH_FIELD (_tmp90_);
			} else {
				_tmp83_ = FALSE;
			}
			if (_tmp83_) {
				ValaMemberAccess* _tmp91_;
				ValaExpression* _tmp92_;
				ValaExpression* _tmp93_;
				ValaMemberAccess* _tmp94_;
				ValaExpression* _tmp95_;
				ValaExpression* _tmp96_;
				_tmp91_ = ma;
				_tmp92_ = vala_member_access_get_inner (_tmp91_);
				_tmp93_ = _tmp92_;
				vala_expression_set_lvalue (_tmp93_, TRUE);
				_tmp94_ = ma;
				_tmp95_ = vala_member_access_get_inner (_tmp94_);
				_tmp96_ = _tmp95_;
				vala_member_access_check_lvalue_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			} else {
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
				ValaMemberAccess* _tmp102_;
				_tmp102_ = ma;
				if (_tmp102_ != NULL) {
					ValaMemberAccess* _tmp103_;
					ValaSymbol* _tmp104_;
					ValaSymbol* _tmp105_;
					_tmp103_ = ma;
					_tmp104_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp103_);
					_tmp105_ = _tmp104_;
					_tmp101_ = VALA_IS_FIELD (_tmp105_);
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					ValaMemberAccess* _tmp106_;
					ValaExpression* _tmp107_;
					ValaExpression* _tmp108_;
					_tmp106_ = ma;
					_tmp107_ = vala_member_access_get_inner (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp100_ = _tmp108_ != NULL;
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					ValaMemberAccess* _tmp109_;
					ValaExpression* _tmp110_;
					ValaExpression* _tmp111_;
					ValaSymbol* _tmp112_;
					ValaSymbol* _tmp113_;
					_tmp109_ = ma;
					_tmp110_ = vala_member_access_get_inner (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = vala_expression_get_symbol_reference (_tmp111_);
					_tmp113_ = _tmp112_;
					_tmp99_ = VALA_IS_VARIABLE (_tmp113_);
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaMemberAccess* _tmp114_;
					ValaExpression* _tmp115_;
					ValaExpression* _tmp116_;
					ValaDataType* _tmp117_;
					ValaDataType* _tmp118_;
					_tmp114_ = ma;
					_tmp115_ = vala_member_access_get_inner (_tmp114_);
					_tmp116_ = _tmp115_;
					_tmp117_ = vala_expression_get_value_type (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp98_ = VALA_IS_STRUCT_VALUE_TYPE (_tmp118_);
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaMemberAccess* _tmp119_;
					ValaExpression* _tmp120_;
					ValaExpression* _tmp121_;
					ValaDataType* _tmp122_;
					ValaDataType* _tmp123_;
					gboolean _tmp124_;
					gboolean _tmp125_;
					_tmp119_ = ma;
					_tmp120_ = vala_member_access_get_inner (_tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_expression_get_value_type (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_data_type_get_nullable (_tmp123_);
					_tmp125_ = _tmp124_;
					_tmp97_ = !_tmp125_;
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaMemberAccess* _tmp126_;
					ValaMemberAccess* _tmp127_;
					_tmp126_ = ma;
					vala_expression_set_lvalue ((ValaExpression*) _tmp126_, TRUE);
					_tmp127_ = ma;
					vala_member_access_check_lvalue_access (_tmp127_);
				}
			}
		}
		_tmp128_ = array_type;
		_tmp129_ = vala_array_type_get_rank (_tmp128_);
		_tmp130_ = _tmp129_;
		_tmp131_ = vala_element_access_get_indices (self);
		_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
		_tmp133_ = _tmp132_;
		if (_tmp130_ < _tmp133_) {
			ValaSourceReference* _tmp134_;
			ValaSourceReference* _tmp135_;
			ValaList* _tmp136_;
			gint _tmp137_;
			gint _tmp138_;
			ValaArrayType* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp135_ = _tmp134_;
			_tmp136_ = vala_element_access_get_indices (self);
			_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = array_type;
			_tmp140_ = vala_array_type_get_rank (_tmp139_);
			_tmp141_ = _tmp140_;
			vala_report_error (_tmp135_, "%d extra indices for element access", _tmp138_ - _tmp141_);
		} else {
			ValaArrayType* _tmp142_;
			gint _tmp143_;
			gint _tmp144_;
			ValaList* _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
			_tmp142_ = array_type;
			_tmp143_ = vala_array_type_get_rank (_tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_element_access_get_indices (self);
			_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
			_tmp147_ = _tmp146_;
			if (_tmp144_ > _tmp147_) {
				ValaSourceReference* _tmp148_;
				ValaSourceReference* _tmp149_;
				ValaArrayType* _tmp150_;
				gint _tmp151_;
				gint _tmp152_;
				ValaList* _tmp153_;
				gint _tmp154_;
				gint _tmp155_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp149_ = _tmp148_;
				_tmp150_ = array_type;
				_tmp151_ = vala_array_type_get_rank (_tmp150_);
				_tmp152_ = _tmp151_;
				_tmp153_ = vala_element_access_get_indices (self);
				_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
				_tmp155_ = _tmp154_;
				vala_report_error (_tmp149_, "%d missing indices for element access", _tmp152_ - _tmp155_);
			}
		}
	} else {
		gboolean _tmp156_ = FALSE;
		ValaPointerType* _tmp157_;
		_tmp157_ = pointer_type;
		if (_tmp157_ != NULL) {
			ValaPointerType* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			_tmp158_ = pointer_type;
			_tmp159_ = vala_pointer_type_get_base_type (_tmp158_);
			_tmp160_ = _tmp159_;
			_tmp156_ = !vala_data_type_is_reference_type_or_type_parameter (_tmp160_);
		} else {
			_tmp156_ = FALSE;
		}
		if (_tmp156_) {
			ValaPointerType* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			ValaDataType* _tmp164_;
			ValaDataType* _tmp165_;
			_tmp161_ = pointer_type;
			_tmp162_ = vala_pointer_type_get_base_type (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_data_type_copy (_tmp163_);
			_tmp165_ = _tmp164_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp165_);
			_vala_code_node_unref0 (_tmp165_);
		} else {
			gboolean _tmp166_ = FALSE;
			ValaExpression* _tmp167_;
			ValaExpression* _tmp168_;
			_tmp167_ = vala_element_access_get_container (self);
			_tmp168_ = _tmp167_;
			if (VALA_IS_MEMBER_ACCESS (_tmp168_)) {
				ValaExpression* _tmp169_;
				ValaExpression* _tmp170_;
				ValaSymbol* _tmp171_;
				ValaSymbol* _tmp172_;
				_tmp169_ = vala_element_access_get_container (self);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_expression_get_symbol_reference (_tmp170_);
				_tmp172_ = _tmp171_;
				_tmp166_ = VALA_IS_SIGNAL (_tmp172_);
			} else {
				_tmp166_ = FALSE;
			}
			if (_tmp166_) {
				ValaExpression* _tmp173_;
				ValaExpression* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaSymbol* _tmp176_;
				ValaExpression* _tmp177_;
				ValaExpression* _tmp178_;
				ValaDataType* _tmp179_;
				ValaDataType* _tmp180_;
				index_int_type_check = FALSE;
				_tmp173_ = vala_element_access_get_container (self);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_expression_get_symbol_reference (_tmp174_);
				_tmp176_ = _tmp175_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp176_);
				_tmp177_ = vala_element_access_get_container (self);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_expression_get_value_type (_tmp178_);
				_tmp180_ = _tmp179_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp180_);
			} else {
				gboolean _tmp181_;
				gboolean _tmp182_;
				ValaSourceReference* _tmp237_;
				ValaSourceReference* _tmp238_;
				ValaExpression* _tmp239_;
				ValaExpression* _tmp240_;
				ValaDataType* _tmp241_;
				ValaDataType* _tmp242_;
				gchar* _tmp243_;
				gchar* _tmp244_;
				_tmp181_ = vala_expression_get_lvalue ((ValaExpression*) self);
				_tmp182_ = _tmp181_;
				if (_tmp182_) {
					ValaMethod* set_method = NULL;
					ValaExpression* _tmp183_;
					ValaExpression* _tmp184_;
					ValaDataType* _tmp185_;
					ValaDataType* _tmp186_;
					ValaSymbol* _tmp187_;
					ValaMethod* _tmp188_;
					ValaAssignment* assignment = NULL;
					ValaCodeNode* _tmp189_;
					ValaCodeNode* _tmp190_;
					gboolean _tmp191_ = FALSE;
					gboolean _tmp192_ = FALSE;
					ValaMethod* _tmp193_;
					_tmp183_ = vala_element_access_get_container (self);
					_tmp184_ = _tmp183_;
					_tmp185_ = vala_expression_get_value_type (_tmp184_);
					_tmp186_ = _tmp185_;
					_tmp187_ = vala_data_type_get_member (_tmp186_, "set");
					_tmp188_ = VALA_IS_METHOD (_tmp187_) ? ((ValaMethod*) _tmp187_) : NULL;
					if (_tmp188_ == NULL) {
						_vala_code_node_unref0 (_tmp187_);
					}
					set_method = _tmp188_;
					_tmp189_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp190_ = _tmp189_;
					assignment = VALA_IS_ASSIGNMENT (_tmp190_) ? ((ValaAssignment*) _tmp190_) : NULL;
					_tmp193_ = set_method;
					if (_tmp193_ != NULL) {
						ValaMethod* _tmp194_;
						ValaDataType* _tmp195_;
						ValaDataType* _tmp196_;
						_tmp194_ = set_method;
						_tmp195_ = vala_callable_get_return_type ((ValaCallable*) _tmp194_);
						_tmp196_ = _tmp195_;
						_tmp192_ = VALA_IS_VOID_TYPE (_tmp196_);
					} else {
						_tmp192_ = FALSE;
					}
					if (_tmp192_) {
						ValaAssignment* _tmp197_;
						_tmp197_ = assignment;
						_tmp191_ = _tmp197_ != NULL;
					} else {
						_tmp191_ = FALSE;
					}
					if (_tmp191_) {
						gboolean _tmp198_;
						gboolean _tmp199_;
						_tmp198_ = vala_code_node_get_error ((ValaCodeNode*) self);
						_tmp199_ = _tmp198_;
						result = !_tmp199_;
						_vala_code_node_unref0 (set_method);
						return result;
					}
					_vala_code_node_unref0 (set_method);
				} else {
					ValaMethod* get_method = NULL;
					ValaExpression* _tmp200_;
					ValaExpression* _tmp201_;
					ValaDataType* _tmp202_;
					ValaDataType* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaMethod* _tmp205_;
					ValaMethod* _tmp206_;
					_tmp200_ = vala_element_access_get_container (self);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_expression_get_value_type (_tmp201_);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_data_type_get_member (_tmp203_, "get");
					_tmp205_ = VALA_IS_METHOD (_tmp204_) ? ((ValaMethod*) _tmp204_) : NULL;
					if (_tmp205_ == NULL) {
						_vala_code_node_unref0 (_tmp204_);
					}
					get_method = _tmp205_;
					_tmp206_ = get_method;
					if (_tmp206_ != NULL) {
						ValaMethodCall* get_call = NULL;
						ValaExpression* _tmp207_;
						ValaExpression* _tmp208_;
						ValaSourceReference* _tmp209_;
						ValaSourceReference* _tmp210_;
						ValaMemberAccess* _tmp211_;
						ValaMemberAccess* _tmp212_;
						ValaSourceReference* _tmp213_;
						ValaSourceReference* _tmp214_;
						ValaMethodCall* _tmp215_;
						ValaMethodCall* _tmp216_;
						ValaMethodCall* _tmp227_;
						ValaDataType* _tmp228_;
						ValaDataType* _tmp229_;
						ValaMethodCall* _tmp230_;
						ValaDataType* _tmp231_;
						ValaDataType* _tmp232_;
						ValaCodeNode* _tmp233_;
						ValaCodeNode* _tmp234_;
						ValaMethodCall* _tmp235_;
						ValaMethodCall* _tmp236_;
						_tmp207_ = vala_element_access_get_container (self);
						_tmp208_ = _tmp207_;
						_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp210_ = _tmp209_;
						_tmp211_ = vala_member_access_new (_tmp208_, "get", _tmp210_);
						_tmp212_ = _tmp211_;
						_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp214_ = _tmp213_;
						_tmp215_ = vala_method_call_new ((ValaExpression*) _tmp212_, _tmp214_);
						_tmp216_ = _tmp215_;
						_vala_code_node_unref0 (_tmp212_);
						get_call = _tmp216_;
						{
							ValaList* _e_list = NULL;
							ValaList* _tmp217_;
							gint _e_size = 0;
							ValaList* _tmp218_;
							gint _tmp219_;
							gint _tmp220_;
							gint _e_index = 0;
							_tmp217_ = vala_element_access_get_indices (self);
							_e_list = _tmp217_;
							_tmp218_ = _e_list;
							_tmp219_ = vala_collection_get_size ((ValaCollection*) _tmp218_);
							_tmp220_ = _tmp219_;
							_e_size = _tmp220_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp221_;
								gint _tmp222_;
								ValaExpression* e = NULL;
								ValaList* _tmp223_;
								gpointer _tmp224_;
								ValaMethodCall* _tmp225_;
								ValaExpression* _tmp226_;
								_e_index = _e_index + 1;
								_tmp221_ = _e_index;
								_tmp222_ = _e_size;
								if (!(_tmp221_ < _tmp222_)) {
									break;
								}
								_tmp223_ = _e_list;
								_tmp224_ = vala_list_get (_tmp223_, _e_index);
								e = (ValaExpression*) _tmp224_;
								_tmp225_ = get_call;
								_tmp226_ = e;
								vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp225_, _tmp226_);
								_vala_code_node_unref0 (e);
							}
						}
						_tmp227_ = get_call;
						_tmp228_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
						_tmp229_ = _tmp228_;
						vala_expression_set_formal_target_type ((ValaExpression*) _tmp227_, _tmp229_);
						_tmp230_ = get_call;
						_tmp231_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp232_ = _tmp231_;
						vala_expression_set_target_type ((ValaExpression*) _tmp230_, _tmp232_);
						_tmp233_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp234_ = _tmp233_;
						_tmp235_ = get_call;
						vala_code_node_replace_expression (_tmp234_, (ValaExpression*) self, (ValaExpression*) _tmp235_);
						_tmp236_ = get_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp236_, context);
						_vala_code_node_unref0 (get_call);
						_vala_code_node_unref0 (get_method);
						return result;
					}
					_vala_code_node_unref0 (get_method);
				}
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp238_ = _tmp237_;
				_tmp239_ = vala_element_access_get_container (self);
				_tmp240_ = _tmp239_;
				_tmp241_ = vala_expression_get_value_type (_tmp240_);
				_tmp242_ = _tmp241_;
				_tmp243_ = vala_code_node_to_string ((ValaCodeNode*) _tmp242_);
				_tmp244_ = _tmp243_;
				vala_report_error (_tmp238_, "The expression `%s' does not denote an array", _tmp244_);
				_g_free0 (_tmp244_);
				result = FALSE;
				return result;
			}
		}
	}
	if (index_int_type_check) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp245_;
			gint _e_size = 0;
			ValaList* _tmp246_;
			gint _tmp247_;
			gint _tmp248_;
			gint _e_index = 0;
			_tmp245_ = vala_element_access_get_indices (self);
			_e_list = _tmp245_;
			_tmp246_ = _e_list;
			_tmp247_ = vala_collection_get_size ((ValaCollection*) _tmp246_);
			_tmp248_ = _tmp247_;
			_e_size = _tmp248_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp249_;
				gint _tmp250_;
				ValaExpression* e = NULL;
				ValaList* _tmp251_;
				gpointer _tmp252_;
				ValaExpression* _tmp253_;
				ValaDataType* _tmp254_;
				ValaDataType* _tmp255_;
				gboolean _tmp256_ = FALSE;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				_e_index = _e_index + 1;
				_tmp249_ = _e_index;
				_tmp250_ = _e_size;
				if (!(_tmp249_ < _tmp250_)) {
					break;
				}
				_tmp251_ = _e_list;
				_tmp252_ = vala_list_get (_tmp251_, _e_index);
				e = (ValaExpression*) _tmp252_;
				_tmp253_ = e;
				_tmp254_ = vala_expression_get_value_type (_tmp253_);
				_tmp255_ = _tmp254_;
				if (_tmp255_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					return result;
				}
				_tmp257_ = e;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				if (VALA_IS_INTEGER_TYPE (_tmp259_)) {
					_tmp256_ = TRUE;
				} else {
					ValaExpression* _tmp260_;
					ValaDataType* _tmp261_;
					ValaDataType* _tmp262_;
					_tmp260_ = e;
					_tmp261_ = vala_expression_get_value_type (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = VALA_IS_ENUM_VALUE_TYPE (_tmp262_);
				}
				if (!_tmp256_) {
					ValaExpression* _tmp263_;
					ValaSourceReference* _tmp264_;
					ValaSourceReference* _tmp265_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp263_ = e;
					_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
					_tmp265_ = _tmp264_;
					vala_report_error (_tmp265_, "Expression of integer type expected");
				}
				_vala_code_node_unref0 (e);
			}
		}
	}
	_tmp266_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp267_ = _tmp266_;
	vala_code_node_check ((ValaCodeNode*) _tmp267_, context);
	_tmp268_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp269_ = _tmp268_;
	result = !_tmp269_;
	return result;
}

static void
vala_element_access_real_emit (ValaCodeNode* base,
                               ValaCodeGenerator* codegen)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		gint _e_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_e_list = _tmp2_;
		_tmp3_ = _e_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_e_size = _tmp5_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = vala_list_get (_tmp8_, _e_index);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp10_, codegen);
			_vala_code_node_unref0 (e);
		}
	}
	vala_code_visitor_visit_element_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		gint _index_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_index_list = _tmp2_;
		_tmp3_ = _index_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_index_size = _tmp5_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* index = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_index_index = _index_index + 1;
			_tmp6_ = _index_index;
			_tmp7_ = _index_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _index_list;
			_tmp9_ = vala_list_get (_tmp8_, _index_index);
			index = (ValaExpression*) _tmp9_;
			_tmp10_ = index;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (index);
		}
	}
}

static void
vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		gint _index_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_index_list = _tmp2_;
		_tmp3_ = _index_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_index_size = _tmp5_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* index = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_index_index = _index_index + 1;
			_tmp6_ = _index_index;
			_tmp7_ = _index_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _index_list;
			_tmp9_ = vala_list_get (_tmp8_, _index_index);
			index = (ValaExpression*) _tmp9_;
			_tmp10_ = index;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (index);
		}
	}
}

static void
vala_element_access_class_init (ValaElementAccessClass * klass,
                                gpointer klass_data)
{
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_element_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaElementAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_element_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_element_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_element_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_element_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_element_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_element_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_element_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_used_variables;
}

static void
vala_element_access_instance_init (ValaElementAccess * self,
                                   gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_element_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->indices = (ValaList*) _tmp1_;
}

static void
vala_element_access_finalize (ValaCodeNode * obj)
{
	ValaElementAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
	_vala_iterable_unref0 (self->priv->indices);
	_vala_code_node_unref0 (self->priv->_container);
	VALA_CODE_NODE_CLASS (vala_element_access_parent_class)->finalize (obj);
}

/**
 * Represents an array access expression.
 *
 * {{{ foo[1,2] }}}
 */
static GType
vala_element_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_instance_init, NULL };
	GType vala_element_access_type_id;
	vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
	ValaElementAccess_private_offset = g_type_add_instance_private (vala_element_access_type_id, sizeof (ValaElementAccessPrivate));
	return vala_element_access_type_id;
}

GType
vala_element_access_get_type (void)
{
	static volatile gsize vala_element_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_element_access_type_id__volatile)) {
		GType vala_element_access_type_id;
		vala_element_access_type_id = vala_element_access_get_type_once ();
		g_once_init_leave (&vala_element_access_type_id__volatile, vala_element_access_type_id);
	}
	return vala_element_access_type_id__volatile;
}

