/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);
static GType vala_creation_method_get_type_once (void);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp9_;
	ValaBlock* _tmp37_;
	ValaBlock* _tmp38_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaParameter* _tmp8_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp8_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp9_ = ((ValaMethod*) self)->error_types;
	if (_tmp9_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp10_;
			gint _error_type_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _error_type_index = 0;
			_tmp10_ = ((ValaMethod*) self)->error_types;
			_error_type_list = _tmp10_;
			_tmp11_ = _error_type_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_error_type_size = _tmp13_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp14_;
				gint _tmp15_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaDataType* _tmp18_;
				_error_type_index = _error_type_index + 1;
				_tmp14_ = _error_type_index;
				_tmp15_ = _error_type_size;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = _error_type_list;
				_tmp17_ = vala_list_get (_tmp16_, _error_type_index);
				error_type = (ValaDataType*) _tmp17_;
				_tmp18_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp19_;
		gint _precondition_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _precondition_index = 0;
		_tmp19_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp19_;
		_tmp20_ = _precondition_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_precondition_size = _tmp22_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaExpression* _tmp27_;
			_precondition_index = _precondition_index + 1;
			_tmp23_ = _precondition_index;
			_tmp24_ = _precondition_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _precondition_list;
			_tmp26_ = vala_list_get (_tmp25_, _precondition_index);
			precondition = (ValaExpression*) _tmp26_;
			_tmp27_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (precondition);
		}
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp28_;
		gint _postcondition_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _postcondition_index = 0;
		_tmp28_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp28_;
		_tmp29_ = _postcondition_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_postcondition_size = _tmp31_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp34_;
			gpointer _tmp35_;
			ValaExpression* _tmp36_;
			_postcondition_index = _postcondition_index + 1;
			_tmp32_ = _postcondition_index;
			_tmp33_ = _postcondition_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _postcondition_list;
			_tmp35_ = vala_list_get (_tmp34_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp35_;
			_tmp36_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
	}
	_tmp37_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaBlock* _tmp39_;
		ValaBlock* _tmp40_;
		_tmp39_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp40_ = _tmp39_;
		vala_code_node_accept ((ValaCodeNode*) _tmp40_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaParameter* _tmp20_;
	ValaParameter* _tmp21_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_;
	gboolean _tmp27_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaSourceFile* _tmp34_;
	ValaSourceFile* _tmp35_;
	ValaSourceFile* _tmp36_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp37_;
	ValaSemanticAnalyzer* _tmp38_;
	ValaSymbol* _tmp39_;
	ValaSymbol* _tmp40_;
	ValaSymbol* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaSourceReference* _tmp43_;
	ValaSemanticAnalyzer* _tmp50_;
	ValaSemanticAnalyzer* _tmp51_;
	gint i = 0;
	ValaList* _tmp135_;
	ValaBlock* _tmp173_;
	ValaBlock* _tmp174_;
	ValaSemanticAnalyzer* _tmp309_;
	ValaSemanticAnalyzer* _tmp310_;
	ValaSourceFile* _tmp311_;
	ValaSemanticAnalyzer* _tmp312_;
	ValaSemanticAnalyzer* _tmp313_;
	ValaSymbol* _tmp314_;
	gboolean _tmp315_ = FALSE;
	gboolean _tmp316_ = FALSE;
	gboolean _tmp317_;
	gboolean _tmp318_;
	gboolean _tmp327_ = FALSE;
	ValaBlock* _tmp328_;
	ValaBlock* _tmp329_;
	gboolean _tmp368_;
	gboolean _tmp369_;
	gboolean result = FALSE;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		vala_report_error (_tmp12_, "missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp20_ = vala_method_get_this_parameter ((ValaMethod*) self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp22_ = vala_method_get_this_parameter ((ValaMethod*) self);
		_tmp23_ = _tmp22_;
		vala_code_node_check ((ValaCodeNode*) _tmp23_, context);
	}
	_tmp26_ = vala_method_get_coroutine ((ValaMethod*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_) {
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp28_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp29_ = _tmp28_;
		_tmp25_ = !_tmp29_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		_tmp24_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		vala_report_error (_tmp31_, "gio-2.0 package required for async constructors");
		result = FALSE;
		return result;
	}
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_semantic_analyzer_get_current_source_file (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _vala_source_file_ref0 (_tmp35_);
	old_source_file = _tmp36_;
	_tmp37_ = vala_code_context_get_analyzer (context);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_semantic_analyzer_get_current_symbol (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _vala_code_node_ref0 (_tmp40_);
	old_symbol = _tmp41_;
	_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp43_ = _tmp42_;
	if (_tmp43_ != NULL) {
		ValaSemanticAnalyzer* _tmp44_;
		ValaSemanticAnalyzer* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaSourceFile* _tmp48_;
		ValaSourceFile* _tmp49_;
		_tmp44_ = vala_code_context_get_analyzer (context);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_source_reference_get_file (_tmp47_);
		_tmp49_ = _tmp48_;
		vala_semantic_analyzer_set_current_source_file (_tmp45_, _tmp49_);
	}
	_tmp50_ = vala_code_context_get_analyzer (context);
	_tmp51_ = _tmp50_;
	vala_semantic_analyzer_set_current_symbol (_tmp51_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp52_;
		gint _param_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _param_index = 0;
		_tmp52_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp52_;
		_tmp53_ = _param_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_param_size = _tmp55_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			ValaParameter* param = NULL;
			ValaList* _tmp58_;
			gpointer _tmp59_;
			ValaParameter* _tmp60_;
			gboolean _tmp61_ = FALSE;
			gboolean _tmp62_ = FALSE;
			gint _tmp71_;
			gboolean _tmp72_ = FALSE;
			ValaParameter* _tmp73_;
			gboolean _tmp74_;
			gboolean _tmp75_;
			_param_index = _param_index + 1;
			_tmp56_ = _param_index;
			_tmp57_ = _param_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _param_list;
			_tmp59_ = vala_list_get (_tmp58_, _param_index);
			param = (ValaParameter*) _tmp59_;
			_tmp60_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp60_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (i == 0) {
				ValaParameter* _tmp63_;
				gboolean _tmp64_;
				gboolean _tmp65_;
				_tmp63_ = param;
				_tmp64_ = vala_parameter_get_ellipsis (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp62_ = _tmp65_;
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				ValaBlock* _tmp66_;
				ValaBlock* _tmp67_;
				_tmp66_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp67_ = _tmp66_;
				_tmp61_ = _tmp67_ != NULL;
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValaParameter* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp68_ = param;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp68_);
				_tmp70_ = _tmp69_;
				vala_report_error (_tmp70_, "Named parameter required before `...'");
			}
			_tmp71_ = i;
			i = _tmp71_ + 1;
			_tmp73_ = param;
			_tmp74_ = vala_parameter_get_params_array (_tmp73_);
			_tmp75_ = _tmp74_;
			if (_tmp75_) {
				ValaBlock* _tmp76_;
				ValaBlock* _tmp77_;
				_tmp76_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp77_ = _tmp76_;
				_tmp72_ = _tmp77_ != NULL;
			} else {
				_tmp72_ = FALSE;
			}
			if (_tmp72_) {
				ValaLocalVariable* _tmp78_;
				ValaLocalVariable* _tmp79_;
				gboolean _tmp83_;
				gboolean _tmp84_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp88_;
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				ValaDataType* _tmp91_;
				ValaArrayType* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaArrayType* _tmp95_;
				gboolean _tmp96_;
				gboolean _tmp97_;
				ValaArrayType* _tmp98_;
				gboolean _tmp99_ = FALSE;
				ValaArrayType* _tmp100_;
				ValaDataType* _tmp101_;
				ValaDataType* _tmp102_;
				ValaArrayType* _tmp111_;
				ValaExpression* _tmp112_;
				ValaExpression* _tmp113_;
				ValaArrayType* _tmp117_;
				ValaParameter* _tmp118_;
				const gchar* _tmp119_;
				const gchar* _tmp120_;
				ValaParameter* _tmp121_;
				ValaSourceReference* _tmp122_;
				ValaSourceReference* _tmp123_;
				ValaLocalVariable* _tmp124_;
				ValaLocalVariable* _tmp125_;
				ValaBlock* _tmp126_;
				ValaBlock* _tmp127_;
				ValaLocalVariable* _tmp128_;
				ValaLocalVariable* _tmp129_;
				ValaParameter* _tmp130_;
				ValaSourceReference* _tmp131_;
				ValaSourceReference* _tmp132_;
				ValaDeclarationStatement* _tmp133_;
				ValaDeclarationStatement* _tmp134_;
				_tmp78_ = vala_method_get_params_array_var ((ValaMethod*) self);
				_tmp79_ = _tmp78_;
				if (_tmp79_ != NULL) {
					ValaParameter* _tmp80_;
					ValaSourceReference* _tmp81_;
					ValaSourceReference* _tmp82_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp80_ = param;
					_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp80_);
					_tmp82_ = _tmp81_;
					vala_report_error (_tmp82_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp83_ = vala_code_context_get_experimental (context);
				_tmp84_ = _tmp83_;
				if (!_tmp84_) {
					ValaParameter* _tmp85_;
					ValaSourceReference* _tmp86_;
					ValaSourceReference* _tmp87_;
					_tmp85_ = param;
					_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp85_);
					_tmp87_ = _tmp86_;
					vala_report_warning (_tmp87_, "Support of params-arrays is experimental");
				}
				_tmp88_ = param;
				_tmp89_ = vala_variable_get_variable_type ((ValaVariable*) _tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_data_type_copy (_tmp90_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp92_ = type;
				_tmp93_ = vala_array_type_get_element_type (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = type;
				_tmp96_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp95_);
				_tmp97_ = _tmp96_;
				vala_data_type_set_value_owned (_tmp94_, _tmp97_);
				_tmp98_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp98_, TRUE);
				_tmp100_ = type;
				_tmp101_ = vala_array_type_get_element_type (_tmp100_);
				_tmp102_ = _tmp101_;
				if (vala_data_type_is_real_struct_type (_tmp102_)) {
					ValaArrayType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					gboolean _tmp106_;
					gboolean _tmp107_;
					_tmp103_ = type;
					_tmp104_ = vala_array_type_get_element_type (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_nullable (_tmp105_);
					_tmp107_ = _tmp106_;
					_tmp99_ = !_tmp107_;
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaParameter* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp108_ = param;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_report_error (_tmp110_, "Only nullable struct elements are supported in params-array");
				}
				_tmp111_ = type;
				_tmp112_ = vala_array_type_get_length (_tmp111_);
				_tmp113_ = _tmp112_;
				if (_tmp113_ != NULL) {
					ValaParameter* _tmp114_;
					ValaSourceReference* _tmp115_;
					ValaSourceReference* _tmp116_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp114_ = param;
					_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp114_);
					_tmp116_ = _tmp115_;
					vala_report_error (_tmp116_, "Passing length to params-array is not supported yet");
				}
				_tmp117_ = type;
				_tmp118_ = param;
				_tmp119_ = vala_symbol_get_name ((ValaSymbol*) _tmp118_);
				_tmp120_ = _tmp119_;
				_tmp121_ = param;
				_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = vala_local_variable_new ((ValaDataType*) _tmp117_, _tmp120_, NULL, _tmp123_);
				_tmp125_ = _tmp124_;
				vala_method_set_params_array_var ((ValaMethod*) self, _tmp125_);
				_vala_code_node_unref0 (_tmp125_);
				_tmp126_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_method_get_params_array_var ((ValaMethod*) self);
				_tmp129_ = _tmp128_;
				_tmp130_ = param;
				_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_declaration_statement_new ((ValaSymbol*) _tmp129_, _tmp132_);
				_tmp134_ = _tmp133_;
				vala_block_insert_statement (_tmp127_, 0, (ValaStatement*) _tmp134_);
				_vala_code_node_unref0 (_tmp134_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp135_ = ((ValaMethod*) self)->error_types;
	if (_tmp135_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp136_;
			gint _error_type_size = 0;
			ValaList* _tmp137_;
			gint _tmp138_;
			gint _tmp139_;
			gint _error_type_index = 0;
			_tmp136_ = ((ValaMethod*) self)->error_types;
			_error_type_list = _tmp136_;
			_tmp137_ = _error_type_list;
			_tmp138_ = vala_collection_get_size ((ValaCollection*) _tmp137_);
			_tmp139_ = _tmp138_;
			_error_type_size = _tmp139_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp140_;
				gint _tmp141_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp142_;
				gpointer _tmp143_;
				ValaDataType* _tmp144_;
				ValaSemanticAnalyzer* _tmp145_;
				ValaSemanticAnalyzer* _tmp146_;
				ValaDataType* _tmp147_;
				_error_type_index = _error_type_index + 1;
				_tmp140_ = _error_type_index;
				_tmp141_ = _error_type_size;
				if (!(_tmp140_ < _tmp141_)) {
					break;
				}
				_tmp142_ = _error_type_list;
				_tmp143_ = vala_list_get (_tmp142_, _error_type_index);
				error_type = (ValaDataType*) _tmp143_;
				_tmp144_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp144_, context);
				_tmp145_ = vala_code_context_get_analyzer (context);
				_tmp146_ = _tmp145_;
				_tmp147_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp146_, (ValaSymbol*) self, _tmp147_)) {
					ValaSourceReference* _tmp148_;
					ValaSourceReference* _tmp149_;
					ValaDataType* _tmp150_;
					gchar* _tmp151_;
					gchar* _tmp152_;
					gchar* _tmp153_;
					gchar* _tmp154_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp149_ = _tmp148_;
					_tmp150_ = error_type;
					_tmp151_ = vala_code_node_to_string ((ValaCodeNode*) _tmp150_);
					_tmp152_ = _tmp151_;
					_tmp153_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp154_ = _tmp153_;
					vala_report_error (_tmp149_, "error type `%s' is less accessible than creation method `%s'", _tmp152_, _tmp154_);
					_g_free0 (_tmp154_);
					_g_free0 (_tmp152_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp155_;
		gint _precondition_size = 0;
		ValaList* _tmp156_;
		gint _tmp157_;
		gint _tmp158_;
		gint _precondition_index = 0;
		_tmp155_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp155_;
		_tmp156_ = _precondition_list;
		_tmp157_ = vala_collection_get_size ((ValaCollection*) _tmp156_);
		_tmp158_ = _tmp157_;
		_precondition_size = _tmp158_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp159_;
			gint _tmp160_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp161_;
			gpointer _tmp162_;
			ValaExpression* _tmp163_;
			_precondition_index = _precondition_index + 1;
			_tmp159_ = _precondition_index;
			_tmp160_ = _precondition_size;
			if (!(_tmp159_ < _tmp160_)) {
				break;
			}
			_tmp161_ = _precondition_list;
			_tmp162_ = vala_list_get (_tmp161_, _precondition_index);
			precondition = (ValaExpression*) _tmp162_;
			_tmp163_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp163_, context);
			_vala_code_node_unref0 (precondition);
		}
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp164_;
		gint _postcondition_size = 0;
		ValaList* _tmp165_;
		gint _tmp166_;
		gint _tmp167_;
		gint _postcondition_index = 0;
		_tmp164_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp164_;
		_tmp165_ = _postcondition_list;
		_tmp166_ = vala_collection_get_size ((ValaCollection*) _tmp165_);
		_tmp167_ = _tmp166_;
		_postcondition_size = _tmp167_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp168_;
			gint _tmp169_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp170_;
			gpointer _tmp171_;
			ValaExpression* _tmp172_;
			_postcondition_index = _postcondition_index + 1;
			_tmp168_ = _postcondition_index;
			_tmp169_ = _postcondition_size;
			if (!(_tmp168_ < _tmp169_)) {
				break;
			}
			_tmp170_ = _postcondition_list;
			_tmp171_ = vala_list_get (_tmp170_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp171_;
			_tmp172_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp172_, context);
			_vala_code_node_unref0 (postcondition);
		}
	}
	_tmp173_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp174_ = _tmp173_;
	if (_tmp174_ != NULL) {
		ValaBlock* _tmp175_;
		ValaBlock* _tmp176_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp177_;
		ValaSymbol* _tmp178_;
		gboolean _tmp179_ = FALSE;
		gboolean _tmp180_ = FALSE;
		gboolean _tmp181_;
		_tmp175_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp176_ = _tmp175_;
		vala_code_node_check ((ValaCodeNode*) _tmp176_, context);
		_tmp177_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp178_ = _tmp177_;
		cl = VALA_IS_CLASS (_tmp178_) ? ((ValaClass*) _tmp178_) : NULL;
		_tmp181_ = self->priv->_chain_up;
		if (!_tmp181_) {
			ValaClass* _tmp182_;
			_tmp182_ = cl;
			_tmp180_ = _tmp182_ != NULL;
		} else {
			_tmp180_ = FALSE;
		}
		if (_tmp180_) {
			ValaClass* _tmp183_;
			ValaClass* _tmp184_;
			ValaClass* _tmp185_;
			_tmp183_ = cl;
			_tmp184_ = vala_class_get_base_class (_tmp183_);
			_tmp185_ = _tmp184_;
			_tmp179_ = _tmp185_ != NULL;
		} else {
			_tmp179_ = FALSE;
		}
		if (_tmp179_) {
			gboolean _tmp186_ = FALSE;
			gboolean _tmp187_ = FALSE;
			ValaProfile _tmp188_;
			ValaProfile _tmp189_;
			_tmp188_ = vala_code_context_get_profile (context);
			_tmp189_ = _tmp188_;
			if (_tmp189_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp190_;
				ValaClass* _tmp191_;
				ValaClass* _tmp192_;
				ValaCreationMethod* _tmp193_;
				ValaCreationMethod* _tmp194_;
				_tmp190_ = cl;
				_tmp191_ = vala_class_get_base_class (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_class_get_default_construction_method (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp187_ = _tmp194_ != NULL;
			} else {
				_tmp187_ = FALSE;
			}
			if (_tmp187_) {
				ValaClass* _tmp195_;
				ValaClass* _tmp196_;
				ValaClass* _tmp197_;
				ValaCreationMethod* _tmp198_;
				ValaCreationMethod* _tmp199_;
				gboolean _tmp200_;
				gboolean _tmp201_;
				_tmp195_ = cl;
				_tmp196_ = vala_class_get_base_class (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_class_get_default_construction_method (_tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp199_);
				_tmp201_ = _tmp200_;
				_tmp186_ = !_tmp201_;
			} else {
				_tmp186_ = FALSE;
			}
			if (_tmp186_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp202_;
				ValaSemanticAnalyzer* _tmp203_;
				ValaBlock* _tmp204_;
				ValaBlock* _tmp205_;
				ValaSemanticAnalyzer* _tmp206_;
				ValaSemanticAnalyzer* _tmp207_;
				ValaBlock* _tmp208_;
				ValaBlock* _tmp209_;
				ValaSemanticAnalyzer* _tmp210_;
				ValaSemanticAnalyzer* _tmp211_;
				ValaBlock* _tmp212_;
				ValaBlock* _tmp213_;
				ValaBlock* _tmp214_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp215_;
				ValaSourceReference* _tmp216_;
				ValaMemberAccess* _tmp217_;
				ValaMemberAccess* _tmp218_;
				ValaSourceReference* _tmp219_;
				ValaSourceReference* _tmp220_;
				ValaMemberAccess* _tmp221_;
				ValaMemberAccess* _tmp222_;
				ValaSourceReference* _tmp223_;
				ValaSourceReference* _tmp224_;
				ValaMethodCall* _tmp225_;
				ValaMethodCall* _tmp226_;
				ValaSourceReference* _tmp227_;
				ValaSourceReference* _tmp228_;
				ValaExpressionStatement* _tmp229_;
				ValaExpressionStatement* _tmp230_;
				ValaBlock* _tmp231_;
				ValaBlock* _tmp232_;
				ValaExpressionStatement* _tmp233_;
				ValaExpressionStatement* _tmp234_;
				ValaSemanticAnalyzer* _tmp235_;
				ValaSemanticAnalyzer* _tmp236_;
				ValaSemanticAnalyzer* _tmp237_;
				ValaSemanticAnalyzer* _tmp238_;
				ValaBlock* _tmp239_;
				ValaBlock* _tmp240_;
				_tmp202_ = vala_code_context_get_analyzer (context);
				_tmp203_ = _tmp202_;
				_tmp204_ = _tmp203_->insert_block;
				_tmp205_ = _vala_code_node_ref0 (_tmp204_);
				old_insert_block = _tmp205_;
				_tmp206_ = vala_code_context_get_analyzer (context);
				_tmp207_ = _tmp206_;
				_tmp208_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp209_ = _tmp208_;
				vala_semantic_analyzer_set_current_symbol (_tmp207_, (ValaSymbol*) _tmp209_);
				_tmp210_ = vala_code_context_get_analyzer (context);
				_tmp211_ = _tmp210_;
				_tmp212_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp213_ = _tmp212_;
				_tmp214_ = _vala_code_node_ref0 (_tmp213_);
				_vala_code_node_unref0 (_tmp211_->insert_block);
				_tmp211_->insert_block = _tmp214_;
				_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_member_access_new_simple ("GLib", _tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_member_access_new ((ValaExpression*) _tmp218_, "Object", _tmp220_);
				_tmp222_ = _tmp221_;
				_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp224_ = _tmp223_;
				_tmp225_ = vala_method_call_new ((ValaExpression*) _tmp222_, _tmp224_);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_expression_statement_new ((ValaExpression*) _tmp226_, _tmp228_);
				_tmp230_ = _tmp229_;
				_vala_code_node_unref0 (_tmp226_);
				_vala_code_node_unref0 (_tmp222_);
				_vala_code_node_unref0 (_tmp218_);
				stmt = _tmp230_;
				_tmp231_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp232_ = _tmp231_;
				_tmp233_ = stmt;
				vala_block_insert_statement (_tmp232_, 0, (ValaStatement*) _tmp233_);
				_tmp234_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp234_, context);
				_tmp235_ = vala_code_context_get_analyzer (context);
				_tmp236_ = _tmp235_;
				vala_semantic_analyzer_set_current_symbol (_tmp236_, (ValaSymbol*) self);
				_tmp237_ = vala_code_context_get_analyzer (context);
				_tmp238_ = _tmp237_;
				_tmp239_ = old_insert_block;
				_tmp240_ = _vala_code_node_ref0 (_tmp239_);
				_vala_code_node_unref0 (_tmp238_->insert_block);
				_tmp238_->insert_block = _tmp240_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp241_ = FALSE;
				ValaClass* _tmp242_;
				ValaClass* _tmp243_;
				ValaClass* _tmp244_;
				ValaCreationMethod* _tmp245_;
				ValaCreationMethod* _tmp246_;
				_tmp242_ = cl;
				_tmp243_ = vala_class_get_base_class (_tmp242_);
				_tmp244_ = _tmp243_;
				_tmp245_ = vala_class_get_default_construction_method (_tmp244_);
				_tmp246_ = _tmp245_;
				if (_tmp246_ == NULL) {
					_tmp241_ = TRUE;
				} else {
					ValaClass* _tmp247_;
					ValaClass* _tmp248_;
					ValaClass* _tmp249_;
					ValaCreationMethod* _tmp250_;
					ValaCreationMethod* _tmp251_;
					ValaSymbolAccessibility _tmp252_;
					ValaSymbolAccessibility _tmp253_;
					_tmp247_ = cl;
					_tmp248_ = vala_class_get_base_class (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = vala_class_get_default_construction_method (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_symbol_get_access ((ValaSymbol*) _tmp251_);
					_tmp253_ = _tmp252_;
					_tmp241_ = _tmp253_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp241_) {
					ValaSourceReference* _tmp254_;
					ValaSourceReference* _tmp255_;
					_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp255_ = _tmp254_;
					vala_report_error (_tmp255_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp256_;
					ValaClass* _tmp257_;
					ValaClass* _tmp258_;
					ValaCreationMethod* _tmp259_;
					ValaCreationMethod* _tmp260_;
					_tmp256_ = cl;
					_tmp257_ = vala_class_get_base_class (_tmp256_);
					_tmp258_ = _tmp257_;
					_tmp259_ = vala_class_get_default_construction_method (_tmp258_);
					_tmp260_ = _tmp259_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp260_) > 0) {
						ValaSourceReference* _tmp261_;
						ValaSourceReference* _tmp262_;
						_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp262_ = _tmp261_;
						vala_report_error (_tmp262_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp263_;
						ValaSemanticAnalyzer* _tmp264_;
						ValaBlock* _tmp265_;
						ValaBlock* _tmp266_;
						ValaSemanticAnalyzer* _tmp267_;
						ValaSemanticAnalyzer* _tmp268_;
						ValaBlock* _tmp269_;
						ValaBlock* _tmp270_;
						ValaSemanticAnalyzer* _tmp271_;
						ValaSemanticAnalyzer* _tmp272_;
						ValaBlock* _tmp273_;
						ValaBlock* _tmp274_;
						ValaBlock* _tmp275_;
						ValaMethodCall* base_call = NULL;
						ValaSourceReference* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaBaseAccess* _tmp278_;
						ValaBaseAccess* _tmp279_;
						ValaSourceReference* _tmp280_;
						ValaSourceReference* _tmp281_;
						ValaMethodCall* _tmp282_;
						ValaMethodCall* _tmp283_;
						gboolean _tmp284_ = FALSE;
						gboolean _tmp285_;
						gboolean _tmp286_;
						ValaExpressionStatement* stmt = NULL;
						ValaMethodCall* _tmp295_;
						ValaSourceReference* _tmp296_;
						ValaSourceReference* _tmp297_;
						ValaExpressionStatement* _tmp298_;
						ValaBlock* _tmp299_;
						ValaBlock* _tmp300_;
						ValaExpressionStatement* _tmp301_;
						ValaExpressionStatement* _tmp302_;
						ValaSemanticAnalyzer* _tmp303_;
						ValaSemanticAnalyzer* _tmp304_;
						ValaSemanticAnalyzer* _tmp305_;
						ValaSemanticAnalyzer* _tmp306_;
						ValaBlock* _tmp307_;
						ValaBlock* _tmp308_;
						_tmp263_ = vala_code_context_get_analyzer (context);
						_tmp264_ = _tmp263_;
						_tmp265_ = _tmp264_->insert_block;
						_tmp266_ = _vala_code_node_ref0 (_tmp265_);
						old_insert_block = _tmp266_;
						_tmp267_ = vala_code_context_get_analyzer (context);
						_tmp268_ = _tmp267_;
						_tmp269_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp270_ = _tmp269_;
						vala_semantic_analyzer_set_current_symbol (_tmp268_, (ValaSymbol*) _tmp270_);
						_tmp271_ = vala_code_context_get_analyzer (context);
						_tmp272_ = _tmp271_;
						_tmp273_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp274_ = _tmp273_;
						_tmp275_ = _vala_code_node_ref0 (_tmp274_);
						_vala_code_node_unref0 (_tmp272_->insert_block);
						_tmp272_->insert_block = _tmp275_;
						_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp277_ = _tmp276_;
						_tmp278_ = vala_base_access_new (_tmp277_);
						_tmp279_ = _tmp278_;
						_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp281_ = _tmp280_;
						_tmp282_ = vala_method_call_new ((ValaExpression*) _tmp279_, _tmp281_);
						_tmp283_ = _tmp282_;
						_vala_code_node_unref0 (_tmp279_);
						base_call = _tmp283_;
						_tmp285_ = vala_method_get_coroutine ((ValaMethod*) self);
						_tmp286_ = _tmp285_;
						if (_tmp286_) {
							ValaClass* _tmp287_;
							ValaClass* _tmp288_;
							ValaClass* _tmp289_;
							ValaCreationMethod* _tmp290_;
							ValaCreationMethod* _tmp291_;
							gboolean _tmp292_;
							gboolean _tmp293_;
							_tmp287_ = cl;
							_tmp288_ = vala_class_get_base_class (_tmp287_);
							_tmp289_ = _tmp288_;
							_tmp290_ = vala_class_get_default_construction_method (_tmp289_);
							_tmp291_ = _tmp290_;
							_tmp292_ = vala_method_get_coroutine ((ValaMethod*) _tmp291_);
							_tmp293_ = _tmp292_;
							_tmp284_ = _tmp293_;
						} else {
							_tmp284_ = FALSE;
						}
						if (_tmp284_) {
							ValaMethodCall* _tmp294_;
							_tmp294_ = base_call;
							vala_callable_expression_set_is_yield_expression ((ValaCallableExpression*) _tmp294_, TRUE);
						}
						_tmp295_ = base_call;
						_tmp296_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp297_ = _tmp296_;
						_tmp298_ = vala_expression_statement_new ((ValaExpression*) _tmp295_, _tmp297_);
						stmt = _tmp298_;
						_tmp299_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp300_ = _tmp299_;
						_tmp301_ = stmt;
						vala_block_insert_statement (_tmp300_, 0, (ValaStatement*) _tmp301_);
						_tmp302_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp302_, context);
						_tmp303_ = vala_code_context_get_analyzer (context);
						_tmp304_ = _tmp303_;
						vala_semantic_analyzer_set_current_symbol (_tmp304_, (ValaSymbol*) self);
						_tmp305_ = vala_code_context_get_analyzer (context);
						_tmp306_ = _tmp305_;
						_tmp307_ = old_insert_block;
						_tmp308_ = _vala_code_node_ref0 (_tmp307_);
						_vala_code_node_unref0 (_tmp306_->insert_block);
						_tmp306_->insert_block = _tmp308_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (base_call);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
	}
	_tmp309_ = vala_code_context_get_analyzer (context);
	_tmp310_ = _tmp309_;
	_tmp311_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp310_, _tmp311_);
	_tmp312_ = vala_code_context_get_analyzer (context);
	_tmp313_ = _tmp312_;
	_tmp314_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp313_, _tmp314_);
	_tmp317_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp318_ = _tmp317_;
	if (_tmp318_) {
		_tmp316_ = TRUE;
	} else {
		gboolean _tmp319_;
		gboolean _tmp320_;
		_tmp319_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp320_ = _tmp319_;
		_tmp316_ = _tmp320_;
	}
	if (_tmp316_) {
		_tmp315_ = TRUE;
	} else {
		gboolean _tmp321_;
		gboolean _tmp322_;
		_tmp321_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp322_ = _tmp321_;
		_tmp315_ = _tmp322_;
	}
	if (_tmp315_) {
		ValaSourceReference* _tmp323_;
		ValaSourceReference* _tmp324_;
		gchar* _tmp325_;
		gchar* _tmp326_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp323_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp324_ = _tmp323_;
		_tmp325_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp326_ = _tmp325_;
		vala_report_error (_tmp324_, "The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp326_);
		_g_free0 (_tmp326_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp328_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp329_ = _tmp328_;
	if (_tmp329_ != NULL) {
		ValaBlock* _tmp330_;
		ValaBlock* _tmp331_;
		gboolean _tmp332_;
		gboolean _tmp333_;
		_tmp330_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp331_ = _tmp330_;
		_tmp332_ = vala_code_node_get_error ((ValaCodeNode*) _tmp331_);
		_tmp333_ = _tmp332_;
		_tmp327_ = !_tmp333_;
	} else {
		_tmp327_ = FALSE;
	}
	if (_tmp327_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp334_;
		ValaArrayList* _tmp335_;
		ValaBlock* _tmp336_;
		ValaBlock* _tmp337_;
		ValaArrayList* _tmp338_;
		_tmp334_ = g_direct_equal;
		_tmp335_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp334_);
		body_errors = _tmp335_;
		_tmp336_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp337_ = _tmp336_;
		_tmp338_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp337_, (ValaCollection*) _tmp338_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp339_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp340_;
			gint _tmp341_;
			gint _tmp342_;
			gint _body_error_type_index = 0;
			_tmp339_ = body_errors;
			_body_error_type_list = _tmp339_;
			_tmp340_ = _body_error_type_list;
			_tmp341_ = vala_collection_get_size ((ValaCollection*) _tmp340_);
			_tmp342_ = _tmp341_;
			_body_error_type_size = _tmp342_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp343_;
				gint _tmp344_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp345_;
				gpointer _tmp346_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp347_;
				gboolean _tmp358_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp343_ = _body_error_type_index;
				_tmp344_ = _body_error_type_size;
				if (!(_tmp343_ < _tmp344_)) {
					break;
				}
				_tmp345_ = _body_error_type_list;
				_tmp346_ = vala_list_get ((ValaList*) _tmp345_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp346_;
				can_propagate_error = FALSE;
				_tmp347_ = ((ValaMethod*) self)->error_types;
				if (_tmp347_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp348_;
						gint _method_error_type_size = 0;
						ValaList* _tmp349_;
						gint _tmp350_;
						gint _tmp351_;
						gint _method_error_type_index = 0;
						_tmp348_ = ((ValaMethod*) self)->error_types;
						_method_error_type_list = _tmp348_;
						_tmp349_ = _method_error_type_list;
						_tmp350_ = vala_collection_get_size ((ValaCollection*) _tmp349_);
						_tmp351_ = _tmp350_;
						_method_error_type_size = _tmp351_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp352_;
							gint _tmp353_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp354_;
							gpointer _tmp355_;
							ValaDataType* _tmp356_;
							ValaDataType* _tmp357_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp352_ = _method_error_type_index;
							_tmp353_ = _method_error_type_size;
							if (!(_tmp352_ < _tmp353_)) {
								break;
							}
							_tmp354_ = _method_error_type_list;
							_tmp355_ = vala_list_get (_tmp354_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp355_;
							_tmp356_ = body_error_type;
							_tmp357_ = method_error_type;
							if (vala_data_type_compatible (_tmp356_, _tmp357_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp359_;
					gboolean _tmp360_;
					gboolean _tmp361_;
					_tmp359_ = body_error_type;
					_tmp360_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp359_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp361_ = _tmp360_;
					_tmp358_ = !_tmp361_;
				} else {
					_tmp358_ = FALSE;
				}
				if (_tmp358_) {
					ValaDataType* _tmp362_;
					ValaSourceReference* _tmp363_;
					ValaSourceReference* _tmp364_;
					ValaDataType* _tmp365_;
					gchar* _tmp366_;
					gchar* _tmp367_;
					_tmp362_ = body_error_type;
					_tmp363_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = body_error_type;
					_tmp366_ = vala_code_node_to_string ((ValaCodeNode*) _tmp365_);
					_tmp367_ = _tmp366_;
					vala_report_warning (_tmp364_, "unhandled error `%s'", _tmp367_);
					_g_free0 (_tmp367_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp368_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp369_ = _tmp368_;
	result = !_tmp369_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
static GType
vala_creation_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
	GType vala_creation_method_type_id;
	vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
	return vala_creation_method_type_id;
}

GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = vala_creation_method_get_type_once ();
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

