/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;
static ValaCallableExpressionIface * vala_object_creation_expression_vala_callable_expression_parent_iface = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                        ValaExpression* arg);
static ValaList* vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_object_creation_expression_real_set_is_yield_expression (ValaCallableExpression* base,
                                                              gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                   ValaExpression* arg)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		gint _arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_arg_list = _tmp8_;
		_tmp9_ = _arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_arg_size = _tmp11_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_arg_index = _arg_index + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _arg_index);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaMemberInitializer* _tmp25_;
			_init_index = _init_index + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = vala_list_get (_tmp23_, _init_index);
			init = (ValaMemberInitializer*) _tmp24_;
			_tmp25_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (init);
		}
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		gint _arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_arg_index = _arg_index + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _arg_index);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			if (!vala_expression_is_accessible (_tmp13_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp14_ = self->priv->object_initializer;
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaMemberInitializer* _tmp22_;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_init_index = _init_index + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = vala_list_get (_tmp20_, _init_index);
			init = (ValaMemberInitializer*) _tmp21_;
			_tmp22_ = init;
			_tmp23_ = vala_member_initializer_get_initializer (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!vala_expression_is_accessible (_tmp24_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaTypeSymbol* _tmp112_;
	ValaDataType* _tmp218_;
	ValaDataType* _tmp219_;
	gboolean _tmp220_ = FALSE;
	ValaSymbol* _tmp221_;
	ValaSymbol* _tmp222_;
	ValaSymbol* _tmp231_;
	ValaSymbol* _tmp232_;
	ValaTypeSymbol* _tmp485_;
	gboolean _tmp486_;
	gboolean _tmp487_;
	gboolean _tmp575_;
	gboolean _tmp576_;
	gboolean _tmp632_;
	gboolean _tmp633_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp54_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		type_args = _tmp31_;
		_tmp32_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp32_)) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp37_;
			ValaMethod* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaMethod* _tmp45_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp46_;
			ValaMemberAccess* _tmp47_;
			ValaExpression* _tmp48_;
			ValaExpression* _tmp49_;
			ValaMemberAccess* _tmp50_;
			_tmp33_ = constructor_sym;
			_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _vala_code_node_ref0 (_tmp35_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp36_;
			_tmp37_ = constructor_sym;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp38_;
			_tmp39_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaMethod* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = constructor;
				_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp41_, "`%s' is not a creation method", _tmp44_);
				_g_free0 (_tmp44_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp45_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp45_);
			_tmp46_ = vala_object_creation_expression_get_member_name (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_member_access_get_inner (_tmp47_);
			_tmp49_ = _tmp48_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp49_) ? ((ValaMemberAccess*) _tmp49_) : NULL;
			_tmp50_ = ma;
			if (_tmp50_ != NULL) {
				ValaMemberAccess* _tmp51_;
				ValaList* _tmp52_;
				ValaList* _tmp53_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_type_arguments (_tmp51_);
				_tmp53_ = _vala_iterable_ref0 (_tmp52_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp53_;
			}
			_vala_code_node_unref0 (constructor);
		}
		_tmp54_ = type_sym;
		if (VALA_IS_CLASS (_tmp54_)) {
			ValaSymbol* _tmp55_;
			ValaTypeSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			gboolean _tmp58_;
			gboolean _tmp59_;
			_tmp55_ = type_sym;
			_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp56_;
			_tmp57_ = type;
			_tmp58_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_CLASS, ValaClass));
			_tmp59_ = _tmp58_;
			if (_tmp59_) {
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaErrorType* _tmp62_;
				ValaErrorType* _tmp63_;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_error_type_new (NULL, NULL, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp63_);
				_vala_code_node_unref0 (_tmp63_);
			} else {
				ValaTypeSymbol* _tmp64_;
				ValaObjectType* _tmp65_;
				ValaObjectType* _tmp66_;
				_tmp64_ = type;
				_tmp65_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CLASS, ValaClass));
				_tmp66_ = _tmp65_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
			}
		} else {
			ValaSymbol* _tmp67_;
			_tmp67_ = type_sym;
			if (VALA_IS_STRUCT (_tmp67_)) {
				ValaSymbol* _tmp68_;
				ValaTypeSymbol* _tmp69_;
				ValaTypeSymbol* _tmp70_;
				ValaStructValueType* _tmp71_;
				ValaStructValueType* _tmp72_;
				_tmp68_ = type_sym;
				_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp69_;
				_tmp70_ = type;
				_tmp71_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp72_ = _tmp71_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp72_);
				_vala_code_node_unref0 (_tmp72_);
			} else {
				ValaSymbol* _tmp73_;
				_tmp73_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp73_)) {
					ValaSymbol* _tmp74_;
					ValaTypeSymbol* _tmp75_;
					ValaSymbol* _tmp76_;
					ValaSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSymbol* _tmp79_;
					ValaSourceReference* _tmp80_;
					ValaSourceReference* _tmp81_;
					ValaErrorType* _tmp82_;
					ValaErrorType* _tmp83_;
					ValaSymbol* _tmp84_;
					_tmp74_ = type_sym;
					_tmp75_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
					_vala_code_node_unref0 (type);
					type = _tmp75_;
					_tmp76_ = type_sym;
					_tmp77_ = vala_symbol_get_parent_symbol (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = type_sym;
					_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp81_ = _tmp80_;
					_tmp82_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp81_);
					_tmp83_ = _tmp82_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp83_);
					_vala_code_node_unref0 (_tmp83_);
					_tmp84_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp84_);
				} else {
					ValaSourceReference* _tmp85_;
					ValaSourceReference* _tmp86_;
					ValaSymbol* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp86_ = _tmp85_;
					_tmp87_ = type_sym;
					_tmp88_ = vala_symbol_get_full_name (_tmp87_);
					_tmp89_ = _tmp88_;
					vala_report_error (_tmp86_, "`%s' is not a class, struct, or error code", _tmp89_);
					_g_free0 (_tmp89_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp90_;
			gint _type_arg_size = 0;
			ValaList* _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			gint _type_arg_index = 0;
			_tmp90_ = type_args;
			_type_arg_list = _tmp90_;
			_tmp91_ = _type_arg_list;
			_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
			_tmp93_ = _tmp92_;
			_type_arg_size = _tmp93_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp94_;
				gint _tmp95_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp96_;
				gpointer _tmp97_;
				ValaDataType* _tmp98_;
				ValaDataType* _tmp99_;
				ValaDataType* _tmp100_;
				_type_arg_index = _type_arg_index + 1;
				_tmp94_ = _type_arg_index;
				_tmp95_ = _type_arg_size;
				if (!(_tmp94_ < _tmp95_)) {
					break;
				}
				_tmp96_ = _type_arg_list;
				_tmp97_ = vala_list_get (_tmp96_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp97_;
				_tmp98_ = vala_object_creation_expression_get_type_reference (self);
				_tmp99_ = _tmp98_;
				_tmp100_ = type_arg;
				vala_data_type_add_type_argument (_tmp99_, _tmp100_);
				_vala_code_node_unref0 (type_arg);
			}
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		ValaTypeSymbol* _tmp103_;
		ValaTypeSymbol* _tmp104_;
		ValaTypeSymbol* _tmp105_;
		_tmp101_ = vala_object_creation_expression_get_type_reference (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_data_type_get_type_symbol (_tmp102_);
		_tmp104_ = _tmp103_;
		_tmp105_ = _vala_code_node_ref0 (_tmp104_);
		_vala_code_node_unref0 (type);
		type = _tmp105_;
	}
	_tmp106_ = vala_object_creation_expression_get_type_reference (self);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_data_type_copy (_tmp107_);
	_tmp109_ = _tmp108_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp109_);
	_vala_code_node_unref0 (_tmp109_);
	_tmp110_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp111_ = _tmp110_;
	vala_data_type_set_value_owned (_tmp111_, TRUE);
	_tmp112_ = type;
	if (VALA_IS_CLASS (_tmp112_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp113_;
		ValaClass* _tmp114_;
		gboolean _tmp115_;
		ValaClass* _tmp118_;
		gboolean _tmp119_;
		gboolean _tmp120_;
		ValaSymbol* _tmp126_;
		ValaSymbol* _tmp127_;
		gboolean _tmp146_ = FALSE;
		ValaSymbol* _tmp147_;
		ValaSymbol* _tmp148_;
		_tmp113_ = type;
		_tmp114_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp114_;
		_tmp115_ = self->priv->_struct_creation;
		if (_tmp115_) {
			ValaSourceReference* _tmp116_;
			ValaSourceReference* _tmp117_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp117_ = _tmp116_;
			vala_report_error (_tmp117_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp118_ = cl;
		_tmp119_ = vala_class_get_is_abstract (_tmp118_);
		_tmp120_ = _tmp119_;
		if (_tmp120_) {
			ValaSourceReference* _tmp121_;
			ValaSourceReference* _tmp122_;
			ValaClass* _tmp123_;
			gchar* _tmp124_;
			gchar* _tmp125_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp122_ = _tmp121_;
			_tmp123_ = cl;
			_tmp124_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp123_);
			_tmp125_ = _tmp124_;
			vala_report_error (_tmp122_, "Can't create instance of abstract class `%s'", _tmp125_);
			_g_free0 (_tmp125_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp126_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp127_ = _tmp126_;
		if (_tmp127_ == NULL) {
			ValaClass* _tmp128_;
			ValaCreationMethod* _tmp129_;
			ValaCreationMethod* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaSymbol* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaSymbol* _tmp141_;
			ValaVersionAttribute* _tmp142_;
			ValaVersionAttribute* _tmp143_;
			ValaSourceReference* _tmp144_;
			ValaSourceReference* _tmp145_;
			_tmp128_ = cl;
			_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
			_tmp130_ = _tmp129_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp130_);
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp132_ = _tmp131_;
			if (_tmp132_ == NULL) {
				ValaSourceReference* _tmp133_;
				ValaSourceReference* _tmp134_;
				ValaClass* _tmp135_;
				gchar* _tmp136_;
				gchar* _tmp137_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp134_ = _tmp133_;
				_tmp135_ = cl;
				_tmp136_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp135_);
				_tmp137_ = _tmp136_;
				vala_report_error (_tmp134_, "`%s' does not have a default constructor", _tmp137_);
				_g_free0 (_tmp137_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp138_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp139_ = _tmp138_;
			vala_symbol_set_used (_tmp139_, TRUE);
			_tmp140_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_symbol_get_version (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp145_ = _tmp144_;
			vala_version_attribute_check (_tmp143_, context, _tmp145_);
		}
		_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp148_ = _tmp147_;
		if (_tmp148_ != NULL) {
			gboolean _tmp149_ = FALSE;
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp151_;
			ValaSymbolAccessibility _tmp152_;
			ValaSymbolAccessibility _tmp153_;
			_tmp150_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_symbol_get_access (_tmp151_);
			_tmp153_ = _tmp152_;
			if (_tmp153_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp149_ = TRUE;
			} else {
				ValaSymbol* _tmp154_;
				ValaSymbol* _tmp155_;
				ValaSymbolAccessibility _tmp156_;
				ValaSymbolAccessibility _tmp157_;
				_tmp154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp155_ = _tmp154_;
				_tmp156_ = vala_symbol_get_access (_tmp155_);
				_tmp157_ = _tmp156_;
				_tmp149_ = _tmp157_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp146_ = _tmp149_;
		} else {
			_tmp146_ = FALSE;
		}
		if (_tmp146_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp158_;
				ValaSemanticAnalyzer* _tmp159_;
				ValaSymbol* _tmp160_;
				ValaSymbol* _tmp161_;
				ValaSymbol* _tmp162_;
				_tmp158_ = vala_code_context_get_analyzer (context);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_semantic_analyzer_get_current_symbol (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = _vala_code_node_ref0 (_tmp161_);
				this_symbol = _tmp162_;
				{
					gboolean _tmp163_ = FALSE;
					_tmp163_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp168_;
						ValaSymbol* _tmp169_;
						ValaClass* _tmp170_;
						if (!_tmp163_) {
							ValaSymbol* _tmp164_;
							ValaSymbol* _tmp165_;
							ValaSymbol* _tmp166_;
							ValaSymbol* _tmp167_;
							_tmp164_ = this_symbol;
							_tmp165_ = vala_symbol_get_parent_symbol (_tmp164_);
							_tmp166_ = _tmp165_;
							_tmp167_ = _vala_code_node_ref0 (_tmp166_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp167_;
						}
						_tmp163_ = FALSE;
						_tmp168_ = this_symbol;
						if (!(_tmp168_ != NULL)) {
							break;
						}
						_tmp169_ = this_symbol;
						_tmp170_ = cl;
						if (_tmp169_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_symbol_get_full_name (_tmp174_);
				_tmp176_ = _tmp175_;
				vala_report_error (_tmp172_, "Access to non-public constructor `%s' denied", _tmp176_);
				_g_free0 (_tmp176_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp177_;
			ValaClass* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			gboolean _tmp181_;
			ValaClass* _tmp184_;
			ValaClass* _tmp185_;
			ValaClass* _tmp186_;
			ValaClass* _tmp187_;
			_tmp177_ = cl;
			if (!(_tmp177_ != NULL)) {
				break;
			}
			_tmp178_ = cl;
			_tmp179_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp178_, "CCode", "ref_sink_function", NULL);
			_tmp180_ = _tmp179_;
			_tmp181_ = _tmp180_ != NULL;
			_g_free0 (_tmp180_);
			if (_tmp181_) {
				ValaDataType* _tmp182_;
				ValaDataType* _tmp183_;
				_tmp182_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp183_ = _tmp182_;
				vala_data_type_set_floating_reference (_tmp183_, TRUE);
				break;
			}
			_tmp184_ = cl;
			_tmp185_ = vala_class_get_base_class (_tmp184_);
			_tmp186_ = _tmp185_;
			_tmp187_ = _vala_code_node_ref0 (_tmp186_);
			_vala_code_node_unref0 (cl);
			cl = _tmp187_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp188_;
		_tmp188_ = type;
		if (VALA_IS_STRUCT (_tmp188_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp189_;
			ValaStruct* _tmp190_;
			gboolean _tmp191_ = FALSE;
			gboolean _tmp192_;
			ValaSymbol* _tmp197_;
			ValaSymbol* _tmp198_;
			gboolean _tmp202_ = FALSE;
			gboolean _tmp203_ = FALSE;
			gboolean _tmp204_ = FALSE;
			ValaProfile _tmp205_;
			ValaProfile _tmp206_;
			_tmp189_ = type;
			_tmp190_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp190_;
			_tmp192_ = self->priv->_struct_creation;
			if (!_tmp192_) {
				gboolean _tmp193_;
				gboolean _tmp194_;
				_tmp193_ = vala_code_context_get_deprecated (context);
				_tmp194_ = _tmp193_;
				_tmp191_ = !_tmp194_;
			} else {
				_tmp191_ = FALSE;
			}
			if (_tmp191_) {
				ValaSourceReference* _tmp195_;
				ValaSourceReference* _tmp196_;
				_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp196_ = _tmp195_;
				vala_report_warning (_tmp196_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp197_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp198_ = _tmp197_;
			if (_tmp198_ == NULL) {
				ValaStruct* _tmp199_;
				ValaCreationMethod* _tmp200_;
				ValaCreationMethod* _tmp201_;
				_tmp199_ = st;
				_tmp200_ = vala_struct_get_default_construction_method (_tmp199_);
				_tmp201_ = _tmp200_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp201_);
			}
			_tmp205_ = vala_code_context_get_profile (context);
			_tmp206_ = _tmp205_;
			if (_tmp206_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp207_;
				_tmp207_ = st;
				_tmp204_ = vala_struct_is_simple_type (_tmp207_);
			} else {
				_tmp204_ = FALSE;
			}
			if (_tmp204_) {
				ValaSymbol* _tmp208_;
				ValaSymbol* _tmp209_;
				_tmp208_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp209_ = _tmp208_;
				_tmp203_ = _tmp209_ == NULL;
			} else {
				_tmp203_ = FALSE;
			}
			if (_tmp203_) {
				ValaList* _tmp210_;
				gint _tmp211_;
				gint _tmp212_;
				_tmp210_ = self->priv->object_initializer;
				_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp202_ = _tmp212_ == 0;
			} else {
				_tmp202_ = FALSE;
			}
			if (_tmp202_) {
				ValaSourceReference* _tmp213_;
				ValaSourceReference* _tmp214_;
				ValaStruct* _tmp215_;
				gchar* _tmp216_;
				gchar* _tmp217_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp214_ = _tmp213_;
				_tmp215_ = st;
				_tmp216_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp215_);
				_tmp217_ = _tmp216_;
				vala_report_error (_tmp214_, "`%s' does not have a default constructor", _tmp217_);
				_g_free0 (_tmp217_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp218_ = vala_object_creation_expression_get_type_reference (self);
	_tmp219_ = _tmp218_;
	if (!vala_data_type_check_type_arguments (_tmp219_, context, FALSE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp221_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp222_ = _tmp221_;
	if (_tmp222_ == NULL) {
		ValaList* _tmp223_;
		gint _tmp224_;
		gint _tmp225_;
		_tmp223_ = self->priv->argument_list;
		_tmp224_ = vala_collection_get_size ((ValaCollection*) _tmp223_);
		_tmp225_ = _tmp224_;
		_tmp220_ = _tmp225_ != 0;
	} else {
		_tmp220_ = FALSE;
	}
	if (_tmp220_) {
		ValaSourceReference* _tmp226_;
		ValaSourceReference* _tmp227_;
		ValaTypeSymbol* _tmp228_;
		gchar* _tmp229_;
		gchar* _tmp230_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp226_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp227_ = _tmp226_;
		_tmp228_ = type;
		_tmp229_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp228_);
		_tmp230_ = _tmp229_;
		vala_report_error (_tmp227_, "No arguments allowed when constructing type `%s'", _tmp230_);
		_g_free0 (_tmp230_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp231_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp232_ = _tmp231_;
	if (VALA_IS_METHOD (_tmp232_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp233_;
		ValaSymbol* _tmp234_;
		ValaMethod* _tmp235_;
		gboolean _tmp236_;
		gboolean _tmp237_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp262_;
		ValaIterator* _tmp263_;
		ValaMethod* _tmp314_;
		gboolean _tmp315_;
		gboolean _tmp316_;
		ValaSemanticAnalyzer* _tmp379_;
		ValaSemanticAnalyzer* _tmp380_;
		ValaMethod* _tmp381_;
		ValaMethodType* _tmp382_;
		ValaMethodType* _tmp383_;
		ValaMethod* _tmp384_;
		ValaList* _tmp385_;
		ValaList* _tmp386_;
		_tmp233_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp234_ = _tmp233_;
		_tmp235_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp234_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp235_;
		_tmp236_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
		_tmp237_ = _tmp236_;
		if (_tmp237_) {
			ValaMethod* _tmp238_;
			gboolean _tmp239_;
			gboolean _tmp240_;
			gboolean _tmp243_ = FALSE;
			ValaSemanticAnalyzer* _tmp244_;
			ValaSemanticAnalyzer* _tmp245_;
			ValaMethod* _tmp246_;
			ValaMethod* _tmp247_;
			_tmp238_ = m;
			_tmp239_ = vala_method_get_coroutine (_tmp238_);
			_tmp240_ = _tmp239_;
			if (!_tmp240_) {
				ValaSourceReference* _tmp241_;
				ValaSourceReference* _tmp242_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp242_ = _tmp241_;
				vala_report_error (_tmp242_, "yield expression requires async method");
			}
			_tmp244_ = vala_code_context_get_analyzer (context);
			_tmp245_ = _tmp244_;
			_tmp246_ = vala_semantic_analyzer_get_current_method (_tmp245_);
			_tmp247_ = _tmp246_;
			if (_tmp247_ == NULL) {
				_tmp243_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp248_;
				ValaSemanticAnalyzer* _tmp249_;
				ValaMethod* _tmp250_;
				ValaMethod* _tmp251_;
				gboolean _tmp252_;
				gboolean _tmp253_;
				_tmp248_ = vala_code_context_get_analyzer (context);
				_tmp249_ = _tmp248_;
				_tmp250_ = vala_semantic_analyzer_get_current_method (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_method_get_coroutine (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp243_ = !_tmp253_;
			}
			if (_tmp243_) {
				ValaSourceReference* _tmp254_;
				ValaSourceReference* _tmp255_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp255_ = _tmp254_;
				vala_report_error (_tmp255_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp256_;
			_tmp256_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp256_)) {
				ValaMethod* _tmp257_;
				gboolean _tmp258_;
				gboolean _tmp259_;
				_tmp257_ = m;
				_tmp258_ = vala_method_get_coroutine (_tmp257_);
				_tmp259_ = _tmp258_;
				if (_tmp259_) {
					ValaSourceReference* _tmp260_;
					ValaSourceReference* _tmp261_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp261_ = _tmp260_;
					vala_report_error (_tmp261_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp262_ = self->priv->argument_list;
		_tmp263_ = vala_iterable_iterator ((ValaIterable*) _tmp262_);
		arg_it = _tmp263_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp264_;
			ValaList* _tmp265_;
			gint _param_size = 0;
			ValaList* _tmp266_;
			gint _tmp267_;
			gint _tmp268_;
			gint _param_index = 0;
			_tmp264_ = m;
			_tmp265_ = vala_callable_get_parameters ((ValaCallable*) _tmp264_);
			_param_list = _tmp265_;
			_tmp266_ = _param_list;
			_tmp267_ = vala_collection_get_size ((ValaCollection*) _tmp266_);
			_tmp268_ = _tmp267_;
			_param_size = _tmp268_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp269_;
				gint _tmp270_;
				ValaParameter* param = NULL;
				ValaList* _tmp271_;
				gpointer _tmp272_;
				ValaParameter* _tmp273_;
				ValaParameter* _tmp274_;
				gboolean _tmp275_;
				gboolean _tmp276_;
				ValaParameter* _tmp277_;
				gboolean _tmp278_;
				gboolean _tmp279_;
				ValaIterator* _tmp297_;
				_param_index = _param_index + 1;
				_tmp269_ = _param_index;
				_tmp270_ = _param_size;
				if (!(_tmp269_ < _tmp270_)) {
					break;
				}
				_tmp271_ = _param_list;
				_tmp272_ = vala_list_get (_tmp271_, _param_index);
				param = (ValaParameter*) _tmp272_;
				_tmp273_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp273_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp274_ = param;
				_tmp275_ = vala_parameter_get_ellipsis (_tmp274_);
				_tmp276_ = _tmp275_;
				if (_tmp276_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp277_ = param;
				_tmp278_ = vala_parameter_get_params_array (_tmp277_);
				_tmp279_ = _tmp278_;
				if (_tmp279_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp280_;
					ValaDataType* _tmp281_;
					ValaDataType* _tmp282_;
					ValaArrayType* _tmp283_;
					_tmp280_ = param;
					_tmp281_ = vala_variable_get_variable_type ((ValaVariable*) _tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp282_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp283_;
					while (TRUE) {
						ValaIterator* _tmp284_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp285_;
						gpointer _tmp286_;
						ValaExpression* _tmp287_;
						ValaArrayType* _tmp288_;
						ValaDataType* _tmp289_;
						ValaDataType* _tmp290_;
						ValaExpression* _tmp291_;
						ValaDataType* _tmp292_;
						ValaDataType* _tmp293_;
						ValaArrayType* _tmp294_;
						gboolean _tmp295_;
						gboolean _tmp296_;
						_tmp284_ = arg_it;
						if (!vala_iterator_next (_tmp284_)) {
							break;
						}
						_tmp285_ = arg_it;
						_tmp286_ = vala_iterator_get (_tmp285_);
						arg = (ValaExpression*) _tmp286_;
						_tmp287_ = arg;
						_tmp288_ = array_type;
						_tmp289_ = vala_array_type_get_element_type (_tmp288_);
						_tmp290_ = _tmp289_;
						vala_expression_set_target_type (_tmp287_, _tmp290_);
						_tmp291_ = arg;
						_tmp292_ = vala_expression_get_target_type (_tmp291_);
						_tmp293_ = _tmp292_;
						_tmp294_ = array_type;
						_tmp295_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp294_);
						_tmp296_ = _tmp295_;
						vala_data_type_set_value_owned (_tmp293_, _tmp296_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp297_ = arg_it;
				if (vala_iterator_next (_tmp297_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp298_;
					gpointer _tmp299_;
					ValaExpression* _tmp300_;
					ValaParameter* _tmp301_;
					ValaDataType* _tmp302_;
					ValaDataType* _tmp303_;
					ValaExpression* _tmp304_;
					ValaExpression* _tmp305_;
					ValaDataType* _tmp306_;
					ValaDataType* _tmp307_;
					ValaDataType* _tmp308_;
					ValaDataType* _tmp309_;
					ValaDataType* _tmp310_;
					ValaDataType* _tmp311_;
					ValaExpression* _tmp312_;
					ValaExpression* _tmp313_;
					_tmp298_ = arg_it;
					_tmp299_ = vala_iterator_get (_tmp298_);
					arg = (ValaExpression*) _tmp299_;
					_tmp300_ = arg;
					_tmp301_ = param;
					_tmp302_ = vala_variable_get_variable_type ((ValaVariable*) _tmp301_);
					_tmp303_ = _tmp302_;
					vala_expression_set_formal_target_type (_tmp300_, _tmp303_);
					_tmp304_ = arg;
					_tmp305_ = arg;
					_tmp306_ = vala_expression_get_formal_target_type (_tmp305_);
					_tmp307_ = _tmp306_;
					_tmp308_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp309_ = _tmp308_;
					_tmp310_ = vala_data_type_get_actual_type (_tmp307_, _tmp309_, NULL, (ValaCodeNode*) self);
					_tmp311_ = _tmp310_;
					vala_expression_set_target_type (_tmp304_, _tmp311_);
					_vala_code_node_unref0 (_tmp311_);
					_tmp312_ = arg;
					_tmp313_ = _vala_code_node_ref0 (_tmp312_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp313_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
		}
		_tmp314_ = m;
		_tmp315_ = vala_method_get_printf_format (_tmp314_);
		_tmp316_ = _tmp315_;
		if (_tmp316_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp317_;
			ValaStringLiteral* _tmp361_;
			format_literal = NULL;
			_tmp317_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp317_)) {
			} else {
				ValaExpression* _tmp318_;
				_tmp318_ = last_arg;
				if (_tmp318_ != NULL) {
					ValaExpression* _tmp319_;
					ValaStringLiteral* _tmp320_;
					gboolean _tmp321_ = FALSE;
					ValaStringLiteral* _tmp322_;
					_tmp319_ = last_arg;
					_tmp320_ = vala_string_literal_get_format_literal (_tmp319_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp320_;
					_tmp322_ = format_literal;
					if (_tmp322_ == NULL) {
						ValaList* _tmp323_;
						gint _tmp324_;
						gint _tmp325_;
						ValaMethod* _tmp326_;
						ValaList* _tmp327_;
						gint _tmp328_;
						gint _tmp329_;
						_tmp323_ = self->priv->argument_list;
						_tmp324_ = vala_collection_get_size ((ValaCollection*) _tmp323_);
						_tmp325_ = _tmp324_;
						_tmp326_ = m;
						_tmp327_ = vala_callable_get_parameters ((ValaCallable*) _tmp326_);
						_tmp328_ = vala_collection_get_size ((ValaCollection*) _tmp327_);
						_tmp329_ = _tmp328_;
						_tmp321_ = _tmp325_ == (_tmp329_ - 1);
					} else {
						_tmp321_ = FALSE;
					}
					if (_tmp321_) {
						ValaStringLiteral* _tmp330_;
						ValaStringLiteral* _tmp331_;
						ValaSemanticAnalyzer* _tmp332_;
						ValaSemanticAnalyzer* _tmp333_;
						ValaDataType* _tmp334_;
						ValaDataType* _tmp335_;
						ValaDataType* _tmp336_;
						ValaList* _tmp337_;
						ValaList* _tmp338_;
						gint _tmp339_;
						gint _tmp340_;
						ValaStringLiteral* _tmp341_;
						ValaList* _tmp342_;
						ValaIterator* _tmp343_;
						_tmp330_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp330_;
						_tmp331_ = format_literal;
						_tmp332_ = vala_code_context_get_analyzer (context);
						_tmp333_ = _tmp332_;
						_tmp334_ = _tmp333_->string_type;
						_tmp335_ = vala_data_type_copy (_tmp334_);
						_tmp336_ = _tmp335_;
						vala_expression_set_target_type ((ValaExpression*) _tmp331_, _tmp336_);
						_vala_code_node_unref0 (_tmp336_);
						_tmp337_ = self->priv->argument_list;
						_tmp338_ = self->priv->argument_list;
						_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
						_tmp340_ = _tmp339_;
						_tmp341_ = format_literal;
						vala_list_insert (_tmp337_, _tmp340_ - 1, (ValaExpression*) _tmp341_);
						_tmp342_ = self->priv->argument_list;
						_tmp343_ = vala_iterable_iterator ((ValaIterable*) _tmp342_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp343_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp344_;
							ValaList* _tmp345_;
							gint _param_size = 0;
							ValaList* _tmp346_;
							gint _tmp347_;
							gint _tmp348_;
							gint _param_index = 0;
							_tmp344_ = m;
							_tmp345_ = vala_callable_get_parameters ((ValaCallable*) _tmp344_);
							_param_list = _tmp345_;
							_tmp346_ = _param_list;
							_tmp347_ = vala_collection_get_size ((ValaCollection*) _tmp346_);
							_tmp348_ = _tmp347_;
							_param_size = _tmp348_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp349_;
								gint _tmp350_;
								ValaParameter* param = NULL;
								ValaList* _tmp351_;
								gpointer _tmp352_;
								gboolean _tmp353_ = FALSE;
								ValaParameter* _tmp354_;
								gboolean _tmp355_;
								gboolean _tmp356_;
								ValaIterator* _tmp360_;
								_param_index = _param_index + 1;
								_tmp349_ = _param_index;
								_tmp350_ = _param_size;
								if (!(_tmp349_ < _tmp350_)) {
									break;
								}
								_tmp351_ = _param_list;
								_tmp352_ = vala_list_get (_tmp351_, _param_index);
								param = (ValaParameter*) _tmp352_;
								_tmp354_ = param;
								_tmp355_ = vala_parameter_get_ellipsis (_tmp354_);
								_tmp356_ = _tmp355_;
								if (_tmp356_) {
									_tmp353_ = TRUE;
								} else {
									ValaParameter* _tmp357_;
									gboolean _tmp358_;
									gboolean _tmp359_;
									_tmp357_ = param;
									_tmp358_ = vala_parameter_get_params_array (_tmp357_);
									_tmp359_ = _tmp358_;
									_tmp353_ = _tmp359_;
								}
								if (_tmp353_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp360_ = arg_it;
								vala_iterator_next (_tmp360_);
								_vala_code_node_unref0 (param);
							}
						}
					}
				}
			}
			_tmp361_ = format_literal;
			if (_tmp361_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp362_;
				gchar* _tmp363_;
				ValaSemanticAnalyzer* _tmp364_;
				ValaSemanticAnalyzer* _tmp365_;
				const gchar* _tmp366_;
				ValaIterator* _tmp367_;
				ValaSourceReference* _tmp368_;
				ValaSourceReference* _tmp369_;
				_tmp362_ = format_literal;
				_tmp363_ = vala_string_literal_eval (_tmp362_);
				format = _tmp363_;
				_tmp364_ = vala_code_context_get_analyzer (context);
				_tmp365_ = _tmp364_;
				_tmp366_ = format;
				_tmp367_ = arg_it;
				_tmp368_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp369_ = _tmp368_;
				if (!vala_semantic_analyzer_check_print_format (_tmp365_, _tmp366_, _tmp367_, _tmp369_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp370_;
			gint _arg_size = 0;
			ValaList* _tmp371_;
			gint _tmp372_;
			gint _tmp373_;
			gint _arg_index = 0;
			_tmp370_ = self->priv->argument_list;
			_arg_list = _tmp370_;
			_tmp371_ = _arg_list;
			_tmp372_ = vala_collection_get_size ((ValaCollection*) _tmp371_);
			_tmp373_ = _tmp372_;
			_arg_size = _tmp373_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp374_;
				gint _tmp375_;
				ValaExpression* arg = NULL;
				ValaList* _tmp376_;
				gpointer _tmp377_;
				ValaExpression* _tmp378_;
				_arg_index = _arg_index + 1;
				_tmp374_ = _arg_index;
				_tmp375_ = _arg_size;
				if (!(_tmp374_ < _tmp375_)) {
					break;
				}
				_tmp376_ = _arg_list;
				_tmp377_ = vala_list_get (_tmp376_, _arg_index);
				arg = (ValaExpression*) _tmp377_;
				_tmp378_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp378_, context);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp379_ = vala_code_context_get_analyzer (context);
		_tmp380_ = _tmp379_;
		_tmp381_ = m;
		_tmp382_ = vala_method_type_new (_tmp381_);
		_tmp383_ = _tmp382_;
		_tmp384_ = m;
		_tmp385_ = vala_callable_get_parameters ((ValaCallable*) _tmp384_);
		_tmp386_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp380_, (ValaExpression*) self, (ValaDataType*) _tmp383_, _tmp385_, _tmp386_);
		_vala_code_node_unref0 (_tmp383_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp387_;
		ValaDataType* _tmp388_;
		_tmp387_ = vala_object_creation_expression_get_type_reference (self);
		_tmp388_ = _tmp387_;
		if (VALA_IS_ERROR_TYPE (_tmp388_)) {
			ValaDataType* _tmp389_;
			ValaDataType* _tmp390_;
			ValaMemberAccess* _tmp393_;
			ValaMemberAccess* _tmp394_;
			ValaList* _tmp415_;
			gint _tmp416_;
			gint _tmp417_;
			_tmp389_ = vala_object_creation_expression_get_type_reference (self);
			_tmp390_ = _tmp389_;
			if (_tmp390_ != NULL) {
				ValaDataType* _tmp391_;
				ValaDataType* _tmp392_;
				_tmp391_ = vala_object_creation_expression_get_type_reference (self);
				_tmp392_ = _tmp391_;
				vala_code_node_check ((ValaCodeNode*) _tmp392_, context);
			}
			_tmp393_ = vala_object_creation_expression_get_member_name (self);
			_tmp394_ = _tmp393_;
			if (_tmp394_ != NULL) {
				ValaMemberAccess* _tmp395_;
				ValaMemberAccess* _tmp396_;
				_tmp395_ = vala_object_creation_expression_get_member_name (self);
				_tmp396_ = _tmp395_;
				vala_code_node_check ((ValaCodeNode*) _tmp396_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp397_;
				gint _arg_size = 0;
				ValaList* _tmp398_;
				gint _tmp399_;
				gint _tmp400_;
				gint _arg_index = 0;
				_tmp397_ = self->priv->argument_list;
				_arg_list = _tmp397_;
				_tmp398_ = _arg_list;
				_tmp399_ = vala_collection_get_size ((ValaCollection*) _tmp398_);
				_tmp400_ = _tmp399_;
				_arg_size = _tmp400_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp401_;
					gint _tmp402_;
					ValaExpression* arg = NULL;
					ValaList* _tmp403_;
					gpointer _tmp404_;
					ValaExpression* _tmp405_;
					_arg_index = _arg_index + 1;
					_tmp401_ = _arg_index;
					_tmp402_ = _arg_size;
					if (!(_tmp401_ < _tmp402_)) {
						break;
					}
					_tmp403_ = _arg_list;
					_tmp404_ = vala_list_get (_tmp403_, _arg_index);
					arg = (ValaExpression*) _tmp404_;
					_tmp405_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp405_, context);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp406_;
				gint _init_size = 0;
				ValaList* _tmp407_;
				gint _tmp408_;
				gint _tmp409_;
				gint _init_index = 0;
				_tmp406_ = self->priv->object_initializer;
				_init_list = _tmp406_;
				_tmp407_ = _init_list;
				_tmp408_ = vala_collection_get_size ((ValaCollection*) _tmp407_);
				_tmp409_ = _tmp408_;
				_init_size = _tmp409_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp410_;
					gint _tmp411_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp412_;
					gpointer _tmp413_;
					ValaMemberInitializer* _tmp414_;
					_init_index = _init_index + 1;
					_tmp410_ = _init_index;
					_tmp411_ = _init_size;
					if (!(_tmp410_ < _tmp411_)) {
						break;
					}
					_tmp412_ = _init_list;
					_tmp413_ = vala_list_get (_tmp412_, _init_index);
					init = (ValaMemberInitializer*) _tmp413_;
					_tmp414_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp414_, context);
					_vala_code_node_unref0 (init);
				}
			}
			_tmp415_ = self->priv->argument_list;
			_tmp416_ = vala_collection_get_size ((ValaCollection*) _tmp415_);
			_tmp417_ = _tmp416_;
			if (_tmp417_ == 0) {
				ValaSourceReference* _tmp418_;
				ValaSourceReference* _tmp419_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp418_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp419_ = _tmp418_;
				vala_report_error (_tmp419_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp420_;
				ValaIterator* _tmp421_;
				ValaIterator* _tmp422_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp423_;
				gpointer _tmp424_;
				gboolean _tmp425_ = FALSE;
				ValaExpression* _tmp426_;
				ValaDataType* _tmp427_;
				ValaDataType* _tmp428_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp437_;
				ValaStringLiteral* _tmp438_;
				ValaStringLiteral* _tmp439_;
				ValaList* _tmp448_;
				ValaIterator* _tmp449_;
				ValaIterator* _tmp450_;
				ValaSemanticAnalyzer* _tmp451_;
				ValaSemanticAnalyzer* _tmp452_;
				ValaIterator* _tmp453_;
				ValaSourceReference* _tmp454_;
				ValaSourceReference* _tmp455_;
				_tmp420_ = self->priv->argument_list;
				_tmp421_ = vala_iterable_iterator ((ValaIterable*) _tmp420_);
				arg_it = _tmp421_;
				_tmp422_ = arg_it;
				vala_iterator_next (_tmp422_);
				_tmp423_ = arg_it;
				_tmp424_ = vala_iterator_get (_tmp423_);
				ex = (ValaExpression*) _tmp424_;
				_tmp426_ = ex;
				_tmp427_ = vala_expression_get_value_type (_tmp426_);
				_tmp428_ = _tmp427_;
				if (_tmp428_ == NULL) {
					_tmp425_ = TRUE;
				} else {
					ValaExpression* _tmp429_;
					ValaDataType* _tmp430_;
					ValaDataType* _tmp431_;
					ValaSemanticAnalyzer* _tmp432_;
					ValaSemanticAnalyzer* _tmp433_;
					ValaDataType* _tmp434_;
					_tmp429_ = ex;
					_tmp430_ = vala_expression_get_value_type (_tmp429_);
					_tmp431_ = _tmp430_;
					_tmp432_ = vala_code_context_get_analyzer (context);
					_tmp433_ = _tmp432_;
					_tmp434_ = _tmp433_->string_type;
					_tmp425_ = !vala_data_type_compatible (_tmp431_, _tmp434_);
				}
				if (_tmp425_) {
					ValaSourceReference* _tmp435_;
					ValaSourceReference* _tmp436_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp435_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp436_ = _tmp435_;
					vala_report_error (_tmp436_, "Invalid type for argument 1");
				}
				_tmp437_ = ex;
				_tmp438_ = vala_string_literal_get_format_literal (_tmp437_);
				format_literal = _tmp438_;
				_tmp439_ = format_literal;
				if (_tmp439_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp440_;
					gchar* _tmp441_;
					ValaSemanticAnalyzer* _tmp442_;
					ValaSemanticAnalyzer* _tmp443_;
					const gchar* _tmp444_;
					ValaIterator* _tmp445_;
					ValaSourceReference* _tmp446_;
					ValaSourceReference* _tmp447_;
					_tmp440_ = format_literal;
					_tmp441_ = vala_string_literal_eval (_tmp440_);
					format = _tmp441_;
					_tmp442_ = vala_code_context_get_analyzer (context);
					_tmp443_ = _tmp442_;
					_tmp444_ = format;
					_tmp445_ = arg_it;
					_tmp446_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp447_ = _tmp446_;
					if (!vala_semantic_analyzer_check_print_format (_tmp443_, _tmp444_, _tmp445_, _tmp447_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp448_ = self->priv->argument_list;
				_tmp449_ = vala_iterable_iterator ((ValaIterable*) _tmp448_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp449_;
				_tmp450_ = arg_it;
				vala_iterator_next (_tmp450_);
				_tmp451_ = vala_code_context_get_analyzer (context);
				_tmp452_ = _tmp451_;
				_tmp453_ = arg_it;
				_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp455_ = _tmp454_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp452_, _tmp453_, 1, _tmp455_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp456_;
		gint _arg_size = 0;
		ValaList* _tmp457_;
		gint _tmp458_;
		gint _tmp459_;
		gint _arg_index = 0;
		_tmp456_ = self->priv->argument_list;
		_arg_list = _tmp456_;
		_tmp457_ = _arg_list;
		_tmp458_ = vala_collection_get_size ((ValaCollection*) _tmp457_);
		_tmp459_ = _tmp458_;
		_arg_size = _tmp459_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp460_;
			gint _tmp461_;
			ValaExpression* arg = NULL;
			ValaList* _tmp462_;
			gpointer _tmp463_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp464_;
			gboolean _tmp465_ = FALSE;
			ValaSizeofExpression* _tmp466_;
			_arg_index = _arg_index + 1;
			_tmp460_ = _arg_index;
			_tmp461_ = _arg_size;
			if (!(_tmp460_ < _tmp461_)) {
				break;
			}
			_tmp462_ = _arg_list;
			_tmp463_ = vala_list_get (_tmp462_, _arg_index);
			arg = (ValaExpression*) _tmp463_;
			_tmp464_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp464_) ? ((ValaSizeofExpression*) _tmp464_) : NULL;
			_tmp466_ = sizeof_expr;
			if (_tmp466_ != NULL) {
				ValaSizeofExpression* _tmp467_;
				ValaDataType* _tmp468_;
				ValaDataType* _tmp469_;
				_tmp467_ = sizeof_expr;
				_tmp468_ = vala_sizeof_expression_get_type_reference (_tmp467_);
				_tmp469_ = _tmp468_;
				_tmp465_ = VALA_IS_GENERIC_TYPE (_tmp469_);
			} else {
				_tmp465_ = FALSE;
			}
			if (_tmp465_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp470_;
				ValaDataType* _tmp471_;
				ValaDataType* _tmp472_;
				ValaDataType* _tmp473_;
				ValaDataType* _tmp474_;
				ValaDataType* _tmp475_;
				ValaDataType* _tmp476_;
				ValaList* _tmp477_;
				ValaDataType* _tmp478_;
				ValaExpression* _tmp479_;
				ValaDataType* _tmp480_;
				ValaSourceReference* _tmp481_;
				ValaSourceReference* _tmp482_;
				ValaSizeofExpression* _tmp483_;
				ValaSizeofExpression* _tmp484_;
				_tmp470_ = sizeof_expr;
				_tmp471_ = vala_sizeof_expression_get_type_reference (_tmp470_);
				_tmp472_ = _tmp471_;
				_tmp473_ = vala_object_creation_expression_get_type_reference (self);
				_tmp474_ = _tmp473_;
				_tmp475_ = vala_object_creation_expression_get_type_reference (self);
				_tmp476_ = _tmp475_;
				_tmp477_ = vala_data_type_get_type_arguments (_tmp476_);
				_tmp478_ = vala_data_type_get_actual_type (_tmp472_, _tmp474_, _tmp477_, (ValaCodeNode*) self);
				sizeof_type = _tmp478_;
				_tmp479_ = arg;
				_tmp480_ = sizeof_type;
				_tmp481_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp482_ = _tmp481_;
				_tmp483_ = vala_sizeof_expression_new (_tmp480_, _tmp482_);
				_tmp484_ = _tmp483_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp479_, (ValaExpression*) _tmp484_);
				_vala_code_node_unref0 (_tmp484_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp485_ = type;
	_tmp486_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp485_);
	_tmp487_ = _tmp486_;
	if (!_tmp487_) {
		ValaSemanticAnalyzer* _tmp488_;
		ValaSemanticAnalyzer* _tmp489_;
		ValaDataType* _tmp490_;
		ValaDataType* _tmp491_;
		_tmp488_ = vala_code_context_get_analyzer (context);
		_tmp489_ = _tmp488_;
		_tmp490_ = vala_object_creation_expression_get_type_reference (self);
		_tmp491_ = _tmp490_;
		vala_semantic_analyzer_check_type (_tmp489_, _tmp491_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp492_;
		gint _init_size = 0;
		ValaList* _tmp493_;
		gint _tmp494_;
		gint _tmp495_;
		gint _init_index = 0;
		_tmp492_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp492_;
		_tmp493_ = _init_list;
		_tmp494_ = vala_collection_get_size ((ValaCollection*) _tmp493_);
		_tmp495_ = _tmp494_;
		_init_size = _tmp495_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp496_;
			gint _tmp497_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp498_;
			gpointer _tmp499_;
			ValaMemberInitializer* _tmp500_;
			ValaExpression* _tmp501_;
			ValaExpression* _tmp502_;
			gint index = 0;
			ValaList* _tmp503_;
			ValaMemberInitializer* _tmp504_;
			ValaList* _tmp505_;
			gpointer _tmp506_;
			ValaMemberInitializer* _tmp507_;
			ValaMemberInitializer* inner_mi = NULL;
			ValaMemberInitializer* _tmp508_;
			ValaExpression* _tmp509_;
			ValaExpression* _tmp510_;
			ValaLocalVariable* local = NULL;
			gchar* _tmp517_;
			gchar* _tmp518_;
			ValaMemberInitializer* _tmp519_;
			ValaExpression* _tmp520_;
			ValaExpression* _tmp521_;
			ValaMemberInitializer* _tmp522_;
			ValaExpression* _tmp523_;
			ValaExpression* _tmp524_;
			ValaSourceReference* _tmp525_;
			ValaSourceReference* _tmp526_;
			ValaLocalVariable* _tmp527_;
			ValaLocalVariable* _tmp528_;
			ValaDeclarationStatement* decl = NULL;
			ValaLocalVariable* _tmp529_;
			ValaMemberInitializer* _tmp530_;
			ValaExpression* _tmp531_;
			ValaExpression* _tmp532_;
			ValaSourceReference* _tmp533_;
			ValaSourceReference* _tmp534_;
			ValaDeclarationStatement* _tmp535_;
			ValaDeclarationStatement* _tmp536_;
			ValaSemanticAnalyzer* _tmp537_;
			ValaSemanticAnalyzer* _tmp538_;
			ValaBlock* _tmp539_;
			ValaDeclarationStatement* _tmp540_;
			_init_index = _init_index + 1;
			_tmp496_ = _init_index;
			_tmp497_ = _init_size;
			if (!(_tmp496_ < _tmp497_)) {
				break;
			}
			_tmp498_ = _init_list;
			_tmp499_ = vala_list_get (_tmp498_, _init_index);
			init = (ValaMemberInitializer*) _tmp499_;
			_tmp500_ = init;
			_tmp501_ = vala_member_initializer_get_initializer (_tmp500_);
			_tmp502_ = _tmp501_;
			if (!VALA_IS_MEMBER_INITIALIZER (_tmp502_)) {
				_vala_code_node_unref0 (init);
				continue;
			}
			_tmp503_ = self->priv->object_initializer;
			_tmp504_ = init;
			index = vala_list_index_of (_tmp503_, _tmp504_);
			_tmp505_ = self->priv->object_initializer;
			_tmp506_ = vala_list_remove_at (_tmp505_, index);
			_tmp507_ = (ValaMemberInitializer*) _tmp506_;
			_vala_code_node_unref0 (_tmp507_);
			_vala_assert (index >= 0, "index >= 0");
			_tmp508_ = init;
			_tmp509_ = vala_member_initializer_get_initializer (_tmp508_);
			_tmp510_ = _tmp509_;
			inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp510_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			while (TRUE) {
				ValaMemberInitializer* _tmp511_;
				ValaExpression* _tmp512_;
				ValaExpression* _tmp513_;
				ValaMemberInitializer* _tmp514_;
				ValaExpression* _tmp515_;
				ValaExpression* _tmp516_;
				_tmp511_ = inner_mi;
				_tmp512_ = vala_member_initializer_get_initializer (_tmp511_);
				_tmp513_ = _tmp512_;
				if (!VALA_IS_MEMBER_INITIALIZER (_tmp513_)) {
					break;
				}
				_tmp514_ = inner_mi;
				_tmp515_ = vala_member_initializer_get_initializer (_tmp514_);
				_tmp516_ = _tmp515_;
				inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp516_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			}
			_tmp517_ = vala_code_node_get_temp_name ();
			_tmp518_ = _tmp517_;
			_tmp519_ = inner_mi;
			_tmp520_ = vala_member_initializer_get_initializer (_tmp519_);
			_tmp521_ = _tmp520_;
			_tmp522_ = inner_mi;
			_tmp523_ = vala_member_initializer_get_initializer (_tmp522_);
			_tmp524_ = _tmp523_;
			_tmp525_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp524_);
			_tmp526_ = _tmp525_;
			_tmp527_ = vala_local_variable_new (NULL, _tmp518_, _tmp521_, _tmp526_);
			_tmp528_ = _tmp527_;
			_g_free0 (_tmp518_);
			local = _tmp528_;
			_tmp529_ = local;
			_tmp530_ = inner_mi;
			_tmp531_ = vala_member_initializer_get_initializer (_tmp530_);
			_tmp532_ = _tmp531_;
			_tmp533_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp532_);
			_tmp534_ = _tmp533_;
			_tmp535_ = vala_declaration_statement_new ((ValaSymbol*) _tmp529_, _tmp534_);
			decl = _tmp535_;
			_tmp536_ = decl;
			vala_code_node_check ((ValaCodeNode*) _tmp536_, context);
			_tmp537_ = vala_code_context_get_analyzer (context);
			_tmp538_ = _tmp537_;
			_tmp539_ = _tmp538_->insert_block;
			_tmp540_ = decl;
			vala_expression_insert_statement ((ValaExpression*) self, _tmp539_, (ValaStatement*) _tmp540_);
			{
				gboolean _tmp541_ = FALSE;
				_tmp541_ = TRUE;
				while (TRUE) {
					ValaMemberInitializer* member_init = NULL;
					ValaMemberInitializer* _tmp543_;
					const gchar* _tmp544_;
					const gchar* _tmp545_;
					ValaLocalVariable* _tmp546_;
					const gchar* _tmp547_;
					const gchar* _tmp548_;
					ValaMemberInitializer* _tmp549_;
					ValaSourceReference* _tmp550_;
					ValaSourceReference* _tmp551_;
					ValaMemberAccess* _tmp552_;
					ValaMemberAccess* _tmp553_;
					ValaMemberInitializer* _tmp554_;
					ValaSourceReference* _tmp555_;
					ValaSourceReference* _tmp556_;
					ValaMemberInitializer* _tmp557_;
					ValaMemberInitializer* _tmp558_;
					ValaList* _tmp559_;
					gint _tmp560_;
					ValaMemberInitializer* _tmp561_;
					ValaMemberInitializer* _tmp562_;
					ValaCodeNode* _tmp563_;
					ValaCodeNode* _tmp564_;
					if (!_tmp541_) {
						ValaMemberInitializer* _tmp542_;
						_tmp542_ = inner_mi;
						if (!(_tmp542_ != NULL)) {
							break;
						}
					}
					_tmp541_ = FALSE;
					_tmp543_ = inner_mi;
					_tmp544_ = vala_member_initializer_get_name (_tmp543_);
					_tmp545_ = _tmp544_;
					_tmp546_ = local;
					_tmp547_ = vala_symbol_get_name ((ValaSymbol*) _tmp546_);
					_tmp548_ = _tmp547_;
					_tmp549_ = inner_mi;
					_tmp550_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp549_);
					_tmp551_ = _tmp550_;
					_tmp552_ = vala_member_access_new (NULL, _tmp548_, _tmp551_);
					_tmp553_ = _tmp552_;
					_tmp554_ = inner_mi;
					_tmp555_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp554_);
					_tmp556_ = _tmp555_;
					_tmp557_ = vala_member_initializer_new (_tmp545_, (ValaExpression*) _tmp553_, _tmp556_);
					_tmp558_ = _tmp557_;
					_vala_code_node_unref0 (_tmp553_);
					member_init = _tmp558_;
					_tmp559_ = self->priv->object_initializer;
					_tmp560_ = index;
					index = _tmp560_ + 1;
					_tmp561_ = member_init;
					vala_list_insert (_tmp559_, _tmp560_, _tmp561_);
					_tmp562_ = inner_mi;
					_tmp563_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp562_);
					_tmp564_ = _tmp563_;
					inner_mi = VALA_IS_MEMBER_INITIALIZER (_tmp564_) ? ((ValaMemberInitializer*) _tmp564_) : NULL;
					_vala_code_node_unref0 (member_init);
				}
			}
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (init);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp565_;
		gint _init_size = 0;
		ValaList* _tmp566_;
		gint _tmp567_;
		gint _tmp568_;
		gint _init_index = 0;
		_tmp565_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp565_;
		_tmp566_ = _init_list;
		_tmp567_ = vala_collection_get_size ((ValaCollection*) _tmp566_);
		_tmp568_ = _tmp567_;
		_init_size = _tmp568_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp569_;
			gint _tmp570_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp571_;
			gpointer _tmp572_;
			ValaMemberInitializer* _tmp573_;
			ValaMemberInitializer* _tmp574_;
			_init_index = _init_index + 1;
			_tmp569_ = _init_index;
			_tmp570_ = _init_size;
			if (!(_tmp569_ < _tmp570_)) {
				break;
			}
			_tmp571_ = _init_list;
			_tmp572_ = vala_list_get (_tmp571_, _init_index);
			init = (ValaMemberInitializer*) _tmp572_;
			_tmp573_ = init;
			vala_code_node_set_parent_node ((ValaCodeNode*) _tmp573_, (ValaCodeNode*) self);
			_tmp574_ = init;
			vala_code_node_check ((ValaCodeNode*) _tmp574_, context);
			_vala_code_node_unref0 (init);
		}
	}
	_tmp575_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp576_ = _tmp575_;
	if (_tmp576_) {
		gboolean _tmp577_ = FALSE;
		ValaCodeNode* _tmp578_;
		ValaCodeNode* _tmp579_;
		_tmp578_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp579_ = _tmp578_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp579_)) {
			_tmp577_ = TRUE;
		} else {
			ValaCodeNode* _tmp580_;
			ValaCodeNode* _tmp581_;
			_tmp580_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp581_ = _tmp580_;
			_tmp577_ = VALA_IS_EXPRESSION_STATEMENT (_tmp581_);
		}
		if (_tmp577_) {
		} else {
			ValaSemanticAnalyzer* _tmp582_;
			ValaSemanticAnalyzer* _tmp583_;
			ValaSymbol* _tmp584_;
			ValaSymbol* _tmp585_;
			_tmp582_ = vala_code_context_get_analyzer (context);
			_tmp583_ = _tmp582_;
			_tmp584_ = vala_semantic_analyzer_get_current_symbol (_tmp583_);
			_tmp585_ = _tmp584_;
			if (!VALA_IS_BLOCK (_tmp585_)) {
				ValaSourceReference* _tmp586_;
				ValaSourceReference* _tmp587_;
				_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp587_ = _tmp586_;
				vala_report_error (_tmp587_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp588_;
				ValaCodeNode* _tmp589_;
				ValaCodeNode* _tmp590_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp591_;
				ValaDataType* _tmp592_;
				ValaDataType* _tmp593_;
				ValaDataType* _tmp594_;
				gchar* _tmp595_;
				gchar* _tmp596_;
				ValaSourceReference* _tmp597_;
				ValaSourceReference* _tmp598_;
				ValaLocalVariable* _tmp599_;
				ValaLocalVariable* _tmp600_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp601_;
				ValaSourceReference* _tmp602_;
				ValaSourceReference* _tmp603_;
				ValaDeclarationStatement* _tmp604_;
				ValaSemanticAnalyzer* _tmp605_;
				ValaSemanticAnalyzer* _tmp606_;
				ValaBlock* _tmp607_;
				ValaDeclarationStatement* _tmp608_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp609_;
				ValaDataType* _tmp610_;
				ValaDataType* _tmp611_;
				ValaExpression* _tmp612_;
				ValaExpression* _tmp613_;
				ValaDataType* _tmp614_;
				ValaDataType* _tmp615_;
				ValaLocalVariable* _tmp616_;
				ValaDeclarationStatement* _tmp617_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp618_;
				ValaSemanticAnalyzer* _tmp619_;
				ValaSymbol* _tmp620_;
				ValaSymbol* _tmp621_;
				ValaBlock* _tmp622_;
				ValaBlock* _tmp623_;
				ValaLocalVariable* _tmp624_;
				ValaSemanticAnalyzer* _tmp625_;
				ValaSemanticAnalyzer* _tmp626_;
				ValaBlock* _tmp627_;
				ValaLocalVariable* _tmp628_;
				ValaCodeNode* _tmp629_;
				ValaExpression* _tmp630_;
				ValaExpression* _tmp631_;
				_tmp588_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp589_ = _tmp588_;
				_tmp590_ = _vala_code_node_ref0 (_tmp589_);
				old_parent_node = _tmp590_;
				_tmp591_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp592_ = _tmp591_;
				_tmp593_ = vala_data_type_copy (_tmp592_);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_code_node_get_temp_name ();
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp598_ = _tmp597_;
				_tmp599_ = vala_local_variable_new (_tmp594_, _tmp596_, NULL, _tmp598_);
				_tmp600_ = _tmp599_;
				_g_free0 (_tmp596_);
				_vala_code_node_unref0 (_tmp594_);
				local = _tmp600_;
				_tmp601_ = local;
				_tmp602_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp603_ = _tmp602_;
				_tmp604_ = vala_declaration_statement_new ((ValaSymbol*) _tmp601_, _tmp603_);
				decl = _tmp604_;
				_tmp605_ = vala_code_context_get_analyzer (context);
				_tmp606_ = _tmp605_;
				_tmp607_ = _tmp606_->insert_block;
				_tmp608_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp607_, (ValaStatement*) _tmp608_);
				_tmp609_ = local;
				_tmp610_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp611_ = _tmp610_;
				_tmp612_ = vala_semantic_analyzer_create_temp_access (_tmp609_, _tmp611_);
				temp_access = _tmp612_;
				_tmp613_ = temp_access;
				_tmp614_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp615_ = _tmp614_;
				vala_expression_set_formal_target_type (_tmp613_, _tmp615_);
				_tmp616_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp616_, (ValaExpression*) self);
				_tmp617_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp617_, context);
				_tmp618_ = vala_code_context_get_analyzer (context);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_semantic_analyzer_get_current_symbol (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp621_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp622_;
				_tmp623_ = block;
				_tmp624_ = local;
				vala_block_remove_local_variable (_tmp623_, _tmp624_);
				_tmp625_ = vala_code_context_get_analyzer (context);
				_tmp626_ = _tmp625_;
				_tmp627_ = _tmp626_->insert_block;
				_tmp628_ = local;
				vala_block_add_local_variable (_tmp627_, _tmp628_);
				_tmp629_ = old_parent_node;
				_tmp630_ = temp_access;
				vala_code_node_replace_expression (_tmp629_, (ValaExpression*) self, _tmp630_);
				_tmp631_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp631_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp632_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp633_ = _tmp632_;
	result = !_tmp633_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
			_vala_code_node_unref0 (init);
		}
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
			_vala_code_node_unref0 (init);
		}
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	GString* _tmp13_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result = NULL;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = self->priv->_struct_creation;
	if (!_tmp4_) {
		GString* _tmp5_;
		_tmp5_ = b;
		g_string_append (_tmp5_, "new ");
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GString* _tmp8_;
		ValaMemberAccess* _tmp9_;
		ValaMemberAccess* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = b;
		_tmp9_ = vala_object_creation_expression_get_member_name (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = b;
	g_string_append_c (_tmp13_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp14_ = self->priv->argument_list;
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                                         gpointer iface_data)
{
	vala_object_creation_expression_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_object_creation_expression_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_object_creation_expression_real_get_argument_list;
	iface->get_is_yield_expression = vala_object_creation_expression_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_object_creation_expression_real_set_is_yield_expression;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_object_creation_expression_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	g_type_add_interface_static (vala_object_creation_expression_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}

