/* gtkdocmarkdownscanner.c generated by valac, the Vala compiler
 * generated from gtkdocmarkdownscanner.vala, do not modify */

/* gtkdocmarkdownscanner.vala
 *
 * Copyright (C) 2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *  Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <vala.h>

typedef enum  {
	VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL,
	VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST,
	VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST,
	VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK
} ValadocGtkdocMarkdownScannerState;

#define VALADOC_GTKDOC_MARKDOWN_SCANNER_TYPE_STATE (valadoc_gtkdoc_markdown_scanner_state_get_type ())
enum  {
	VALADOC_GTKDOC_MARKDOWN_SCANNER_0_PROPERTY,
	VALADOC_GTKDOC_MARKDOWN_SCANNER_NUM_PROPERTIES
};
static GParamSpec* valadoc_gtkdoc_markdown_scanner_properties[VALADOC_GTKDOC_MARKDOWN_SCANNER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_parser_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_parser_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValadocGtkdocMarkdownScannerPrivate {
	ValadocSettings* _settings;
	ValadocParser* parser;
	const gchar* _content;
	gint _skip;
	GString* _current_string;
	const gchar* _index;
	gboolean contains_at;
	gint _line;
	gint _column;
	gint _last_line;
	gint _last_column;
	gboolean _stop;
	gchar* headline_end;
	GRegex* regex_mail;
	ValaList* states;
};

static gint ValadocGtkdocMarkdownScanner_private_offset;
static gpointer valadoc_gtkdoc_markdown_scanner_parent_class = NULL;
static ValadocScannerIface * valadoc_gtkdoc_markdown_scanner_valadoc_scanner_parent_iface = NULL;

static GType valadoc_gtkdoc_markdown_scanner_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static inline void valadoc_gtkdoc_markdown_scanner_push_state (ValadocGtkdocMarkdownScanner* self,
                                                 ValadocGtkdocMarkdownScannerState state);
static inline ValadocGtkdocMarkdownScannerState valadoc_gtkdoc_markdown_scanner_pop_state (ValadocGtkdocMarkdownScanner* self);
static inline ValadocGtkdocMarkdownScannerState valadoc_gtkdoc_markdown_scanner_peek_state (ValadocGtkdocMarkdownScanner* self);
static void valadoc_gtkdoc_markdown_scanner_real_set_parser (ValadocScanner* base,
                                                      ValadocParser* parser);
static void valadoc_gtkdoc_markdown_scanner_real_reset (ValadocScanner* base);
static void valadoc_gtkdoc_markdown_scanner_real_scan (ValadocScanner* base,
                                                const gchar* content,
                                                GError** error);
static gboolean valadoc_gtkdoc_markdown_scanner_handle_newline (ValadocGtkdocMarkdownScanner* self,
                                                         const gchar* _iter,
                                                         gboolean is_paragraph,
                                                         GError** error);
static void valadoc_gtkdoc_markdown_scanner_emit_token (ValadocGtkdocMarkdownScanner* self,
                                                 ValadocTokenType* type,
                                                 const gchar* value,
                                                 GError** error);
static void valadoc_gtkdoc_markdown_scanner_accept (ValadocGtkdocMarkdownScanner* self,
                                             gunichar c,
                                             GError** error);
static gboolean valadoc_gtkdoc_markdown_scanner_close_block (ValadocGtkdocMarkdownScanner* self,
                                                      GError** error);
static gboolean valadoc_gtkdoc_markdown_scanner_is_headline_end (ValadocGtkdocMarkdownScanner* self,
                                                          const gchar** iter,
                                                          const gchar* separator,
                                                          gchar** hash);
static gunichar valadoc_gtkdoc_markdown_scanner_get_next_char (ValadocGtkdocMarkdownScanner* self,
                                                        gint offset);
static void valadoc_gtkdoc_markdown_scanner_append_char (ValadocGtkdocMarkdownScanner* self,
                                                  gunichar c);
static gboolean valadoc_gtkdoc_markdown_scanner_is_id (ValadocGtkdocMarkdownScanner* self);
static inline gint valadoc_gtkdoc_markdown_scanner_skip_spaces (ValadocGtkdocMarkdownScanner* self,
                                                  const gchar** _iter);
static gboolean valadoc_gtkdoc_markdown_scanner_is_ordered_list (ValadocGtkdocMarkdownScanner* self,
                                                          const gchar* iter,
                                                          gint* numeric_prefix_count);
static void valadoc_gtkdoc_markdown_scanner_real_end (ValadocScanner* base,
                                               GError** error);
static void valadoc_gtkdoc_markdown_scanner_real_stop (ValadocScanner* base);
static gchar* valadoc_gtkdoc_markdown_scanner_real_get_line_content (ValadocScanner* base);
static void valadoc_gtkdoc_markdown_scanner_emit_current_word (ValadocGtkdocMarkdownScanner* self,
                                                        GError** error);
static void valadoc_gtkdoc_markdown_scanner_get_begin (ValadocGtkdocMarkdownScanner* self,
                                                ValaSourceLocation* result);
static void valadoc_gtkdoc_markdown_scanner_get_end (ValadocGtkdocMarkdownScanner* self,
                                              gint offset,
                                              ValaSourceLocation* result);
static inline gboolean valadoc_gtkdoc_markdown_scanner_is_mail (ValadocGtkdocMarkdownScanner* self);
static void valadoc_gtkdoc_markdown_scanner_finalize (GObject * obj);
static GType valadoc_gtkdoc_markdown_scanner_get_type_once (void);

static inline gpointer
valadoc_gtkdoc_markdown_scanner_get_instance_private (ValadocGtkdocMarkdownScanner* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocGtkdocMarkdownScanner_private_offset);
}

static GType
valadoc_gtkdoc_markdown_scanner_state_get_type_once (void)
{
	static const GEnumValue values[] = {{VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL, "VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL", "normal"}, {VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST, "VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST", "unordered-list"}, {VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST, "VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST", "ordered-list"}, {VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK, "VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK", "block"}, {0, NULL, NULL}};
	GType valadoc_gtkdoc_markdown_scanner_state_type_id;
	valadoc_gtkdoc_markdown_scanner_state_type_id = g_enum_register_static ("ValadocGtkdocMarkdownScannerState", values);
	return valadoc_gtkdoc_markdown_scanner_state_type_id;
}

static GType
valadoc_gtkdoc_markdown_scanner_state_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_markdown_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_markdown_scanner_state_type_id__volatile)) {
		GType valadoc_gtkdoc_markdown_scanner_state_type_id;
		valadoc_gtkdoc_markdown_scanner_state_type_id = valadoc_gtkdoc_markdown_scanner_state_get_type_once ();
		g_once_init_leave (&valadoc_gtkdoc_markdown_scanner_state_type_id__volatile, valadoc_gtkdoc_markdown_scanner_state_type_id);
	}
	return valadoc_gtkdoc_markdown_scanner_state_type_id__volatile;
}

static inline void
valadoc_gtkdoc_markdown_scanner_push_state (ValadocGtkdocMarkdownScanner* self,
                                            ValadocGtkdocMarkdownScannerState state)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->states;
	vala_list_insert (_tmp0_, 0, (gpointer) ((gintptr) state));
}

static inline ValadocGtkdocMarkdownScannerState
valadoc_gtkdoc_markdown_scanner_pop_state (ValadocGtkdocMarkdownScanner* self)
{
	ValaList* _tmp0_;
	gpointer _tmp1_;
	ValadocGtkdocMarkdownScannerState result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->states;
	_tmp1_ = vala_list_remove_at (_tmp0_, 0);
	result = (ValadocGtkdocMarkdownScannerState) ((gintptr) _tmp1_);
	return result;
}

static inline ValadocGtkdocMarkdownScannerState
valadoc_gtkdoc_markdown_scanner_peek_state (ValadocGtkdocMarkdownScanner* self)
{
	ValaList* _tmp0_;
	gpointer _tmp1_;
	ValadocGtkdocMarkdownScannerState result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->states;
	_tmp1_ = vala_list_get (_tmp0_, 0);
	result = (ValadocGtkdocMarkdownScannerState) ((gintptr) _tmp1_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ValadocGtkdocMarkdownScanner*
valadoc_gtkdoc_markdown_scanner_construct (GType object_type,
                                           ValadocSettings* settings)
{
	ValadocGtkdocMarkdownScanner * self = NULL;
	ValadocSettings* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (ValadocGtkdocMarkdownScanner*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp2_ = g_regex_new ("^[A-Za-z0-9._-]+@[A-Za-z0-9._-]+$", 0, 0, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (self->priv->regex_mail);
		self->priv->regex_mail = _tmp3_;
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

ValadocGtkdocMarkdownScanner*
valadoc_gtkdoc_markdown_scanner_new (ValadocSettings* settings)
{
	return valadoc_gtkdoc_markdown_scanner_construct (VALADOC_GTKDOC_TYPE_MARKDOWN_SCANNER, settings);
}

static gpointer
_valadoc_parser_ref0 (gpointer self)
{
	return self ? valadoc_parser_ref (self) : NULL;
}

static void
valadoc_gtkdoc_markdown_scanner_real_set_parser (ValadocScanner* base,
                                                 ValadocParser* parser)
{
	ValadocGtkdocMarkdownScanner * self;
	ValadocParser* _tmp0_;
	self = (ValadocGtkdocMarkdownScanner*) base;
	g_return_if_fail (parser != NULL);
	_tmp0_ = _valadoc_parser_ref0 (parser);
	_valadoc_parser_unref0 (self->priv->parser);
	self->priv->parser = _tmp0_;
}

static void
valadoc_gtkdoc_markdown_scanner_real_reset (ValadocScanner* base)
{
	ValadocGtkdocMarkdownScanner * self;
	GString* _tmp0_;
	ValaList* _tmp1_;
	self = (ValadocGtkdocMarkdownScanner*) base;
	self->priv->_stop = FALSE;
	self->priv->_last_line = 0;
	self->priv->_last_column = 0;
	self->priv->_line = 0;
	self->priv->_column = 0;
	self->priv->_skip = 0;
	_tmp0_ = self->priv->_current_string;
	g_string_erase (_tmp0_, (gssize) 0, (gssize) -1);
	self->priv->contains_at = FALSE;
	_tmp1_ = self->priv->states;
	vala_collection_clear ((ValaCollection*) _tmp1_);
	valadoc_gtkdoc_markdown_scanner_push_state (self, VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
valadoc_gtkdoc_markdown_scanner_real_scan (ValadocScanner* base,
                                           const gchar* content,
                                           GError** error)
{
	ValadocGtkdocMarkdownScanner * self;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	ValadocTokenType* _tmp12_;
	GError* _inner_error0_ = NULL;
	self = (ValadocGtkdocMarkdownScanner*) base;
	g_return_if_fail (content != NULL);
	self->priv->_content = content;
	_tmp0_ = self->priv->_content;
	self->priv->_index = _tmp0_;
	_tmp2_ = self->priv->_index;
	_tmp1_ = valadoc_gtkdoc_markdown_scanner_handle_newline (self, _tmp2_, TRUE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (_tmp1_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_index;
		_tmp4_ = g_utf8_next_char (_tmp3_);
		self->priv->_index = _tmp4_;
	} else {
		ValadocTokenType* _tmp5_;
		_tmp5_ = valadoc_token_type_MARKDOWN_PARAGRAPH;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp5_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		gunichar c = 0U;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		if (!self->priv->_stop) {
			const gchar* _tmp7_;
			_tmp7_ = self->priv->_index;
			_tmp6_ = string_get_char (_tmp7_, (glong) 0) != ((gunichar) 0);
		} else {
			_tmp6_ = FALSE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp8_ = self->priv->_index;
		c = string_get_char (_tmp8_, (glong) 0);
		valadoc_gtkdoc_markdown_scanner_accept (self, c, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp9_ = self->priv->_index;
		_tmp10_ = g_utf8_next_char (_tmp9_);
		self->priv->_index = _tmp10_;
	}
	while (TRUE) {
		if (!(valadoc_gtkdoc_markdown_scanner_peek_state (self) != VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_NORMAL)) {
			break;
		}
		if (valadoc_gtkdoc_markdown_scanner_peek_state (self) == VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK) {
			ValadocTokenType* _tmp11_;
			_tmp11_ = valadoc_token_type_MARKDOWN_BLOCK_END;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp11_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			valadoc_gtkdoc_markdown_scanner_pop_state (self);
		} else {
			valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
	_tmp12_ = valadoc_token_type_MARKDOWN_EOC;
	valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp12_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
valadoc_gtkdoc_markdown_scanner_accept (ValadocGtkdocMarkdownScanner* self,
                                        gunichar c,
                                        GError** error)
{
	gint _tmp0_;
	gchar* hash = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_column;
	self->priv->_column = _tmp0_ + 1;
	if (self->priv->_skip > 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->_skip;
		self->priv->_skip = _tmp1_ - 1;
		return;
	}
	hash = NULL;
	_tmp3_ = self->priv->headline_end;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp4_ = self->priv->headline_end;
		_tmp6_ = valadoc_gtkdoc_markdown_scanner_is_headline_end (self, &self->priv->_index, _tmp4_, &_tmp5_);
		_g_free0 (hash);
		hash = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp7_;
		ValadocTokenType* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_ = hash;
		if (_tmp7_ != NULL) {
			ValadocTokenType* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = valadoc_token_type_MARKDOWN_HEADLINE_HASH;
			_tmp9_ = hash;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp8_, _tmp9_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		_tmp10_ = valadoc_token_type_MARKDOWN_HEADLINE_END;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp10_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (hash);
				return;
			} else {
				_g_free0 (hash);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (self->priv->headline_end);
		self->priv->headline_end = NULL;
		_tmp11_ = self->priv->_index;
		valadoc_gtkdoc_markdown_scanner_handle_newline (self, _tmp11_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (hash);
				return;
			} else {
				_g_free0 (hash);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (hash);
		return;
	}
	switch (c) {
		case '\\':
		{
			switch (valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1)) {
				case '(':
				{
					GString* _tmp13_;
					gint _tmp14_;
					if (valadoc_gtkdoc_markdown_scanner_get_next_char (self, 2) == ((gunichar) ')')) {
						GString* _tmp12_;
						_tmp12_ = self->priv->_current_string;
						g_string_append (_tmp12_, "()");
						self->priv->_skip = self->priv->_skip + 2;
						break;
					}
					_tmp13_ = self->priv->_current_string;
					g_string_append (_tmp13_, "\\(");
					_tmp14_ = self->priv->_skip;
					self->priv->_skip = _tmp14_ + 1;
					break;
				}
				case '<':
				{
					gint _tmp15_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '<');
					_tmp15_ = self->priv->_skip;
					self->priv->_skip = _tmp15_ + 1;
					break;
				}
				case '>':
				{
					gint _tmp16_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '>');
					_tmp16_ = self->priv->_skip;
					self->priv->_skip = _tmp16_ + 1;
					break;
				}
				case '@':
				{
					gint _tmp17_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '@');
					_tmp17_ = self->priv->_skip;
					self->priv->_skip = _tmp17_ + 1;
					break;
				}
				case '%':
				{
					gint _tmp18_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '%');
					_tmp18_ = self->priv->_skip;
					self->priv->_skip = _tmp18_ + 1;
					break;
				}
				case '#':
				{
					gint _tmp19_;
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '#');
					_tmp19_ = self->priv->_skip;
					self->priv->_skip = _tmp19_ + 1;
					break;
				}
				default:
				{
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '\\');
					break;
				}
			}
			break;
		}
		case ':':
		{
			gunichar next_char = 0U;
			gunichar next2_char = 0U;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			GString* _tmp22_;
			next_char = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1);
			next2_char = valadoc_gtkdoc_markdown_scanner_get_next_char (self, 2);
			_tmp22_ = self->priv->_current_string;
			if (_tmp22_->len == ((gssize) 0)) {
				_tmp21_ = TRUE;
			} else {
				GString* _tmp23_;
				const gchar* _tmp24_;
				GString* _tmp25_;
				_tmp23_ = self->priv->_current_string;
				_tmp24_ = _tmp23_->str;
				_tmp25_ = self->priv->_current_string;
				_tmp21_ = !g_ascii_isalpha (string_get (_tmp24_, (glong) (_tmp25_->len - 1)));
			}
			if (_tmp21_) {
				gboolean _tmp26_ = FALSE;
				if (g_unichar_isalpha (next_char)) {
					_tmp26_ = TRUE;
				} else {
					gboolean _tmp27_ = FALSE;
					if (next_char == ((gunichar) ':')) {
						_tmp27_ = g_unichar_isalpha (next2_char);
					} else {
						_tmp27_ = FALSE;
					}
					_tmp26_ = _tmp27_;
				}
				_tmp20_ = _tmp26_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				const gchar* _iter = NULL;
				ValadocTokenType* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				if (next_char == ((gunichar) ':')) {
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gint _tmp30_;
					_tmp28_ = self->priv->_index;
					_tmp29_ = string_offset (_tmp28_, (glong) 2);
					_iter = _tmp29_;
					_tmp30_ = self->priv->_skip;
					self->priv->_skip = _tmp30_ + 1;
				} else {
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					_tmp31_ = self->priv->_index;
					_tmp32_ = string_offset (_tmp31_, (glong) 1);
					_iter = _tmp32_;
				}
				while (TRUE) {
					gboolean _tmp33_ = FALSE;
					gboolean _tmp34_ = FALSE;
					const gchar* _tmp35_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gint _tmp42_;
					_tmp35_ = _iter;
					if (g_ascii_isalnum (string_get (_tmp35_, (glong) 0))) {
						_tmp34_ = TRUE;
					} else {
						const gchar* _tmp36_;
						_tmp36_ = _iter;
						_tmp34_ = string_get (_tmp36_, (glong) 0) == '_';
					}
					if (_tmp34_) {
						_tmp33_ = TRUE;
					} else {
						gboolean _tmp37_ = FALSE;
						const gchar* _tmp38_;
						_tmp38_ = _iter;
						if (string_get (_tmp38_, (glong) 0) == '-') {
							const gchar* _tmp39_;
							_tmp39_ = _iter;
							_tmp37_ = g_ascii_isalnum (string_get (_tmp39_, (glong) 1));
						} else {
							_tmp37_ = FALSE;
						}
						_tmp33_ = _tmp37_;
					}
					if (!_tmp33_) {
						break;
					}
					_tmp40_ = _iter;
					_tmp41_ = string_offset (_tmp40_, (glong) 1);
					_iter = _tmp41_;
					_tmp42_ = self->priv->_skip;
					self->priv->_skip = _tmp42_ + 1;
				}
				_tmp43_ = valadoc_token_type_MARKDOWN_LOCAL_GMEMBER;
				_tmp44_ = self->priv->_index;
				_tmp45_ = string_substring (_tmp44_, (glong) 0, (glong) (self->priv->_skip + 1));
				_tmp46_ = _tmp45_;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp43_, _tmp46_, &_inner_error0_);
				_g_free0 (_tmp46_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			valadoc_gtkdoc_markdown_scanner_append_char (self, c);
			break;
		}
		case '%':
		{
			gboolean _tmp47_ = FALSE;
			gboolean _tmp48_ = FALSE;
			GString* _tmp49_;
			gboolean _tmp65_ = FALSE;
			gboolean _tmp66_ = FALSE;
			GString* _tmp67_;
			_tmp49_ = self->priv->_current_string;
			if (_tmp49_->len == ((gssize) 0)) {
				_tmp48_ = TRUE;
			} else {
				GString* _tmp50_;
				const gchar* _tmp51_;
				GString* _tmp52_;
				_tmp50_ = self->priv->_current_string;
				_tmp51_ = _tmp50_->str;
				_tmp52_ = self->priv->_current_string;
				_tmp48_ = !g_ascii_isalpha (string_get (_tmp51_, (glong) (_tmp52_->len - 1)));
			}
			if (_tmp48_) {
				_tmp47_ = g_unichar_isalpha (valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1));
			} else {
				_tmp47_ = FALSE;
			}
			if (_tmp47_) {
				const gchar* _iter = NULL;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				ValadocTokenType* _tmp61_;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				_tmp53_ = self->priv->_index;
				_tmp54_ = string_offset (_tmp53_, (glong) 1);
				_iter = _tmp54_;
				while (TRUE) {
					gboolean _tmp55_ = FALSE;
					const gchar* _tmp56_;
					const gchar* _tmp58_;
					const gchar* _tmp59_;
					gint _tmp60_;
					_tmp56_ = _iter;
					if (g_ascii_isalnum (string_get (_tmp56_, (glong) 0))) {
						_tmp55_ = TRUE;
					} else {
						const gchar* _tmp57_;
						_tmp57_ = _iter;
						_tmp55_ = string_get (_tmp57_, (glong) 0) == '_';
					}
					if (!_tmp55_) {
						break;
					}
					_tmp58_ = _iter;
					_tmp59_ = string_offset (_tmp58_, (glong) 1);
					_iter = _tmp59_;
					_tmp60_ = self->priv->_skip;
					self->priv->_skip = _tmp60_ + 1;
				}
				_tmp61_ = valadoc_token_type_MARKDOWN_CONSTANT;
				_tmp62_ = self->priv->_index;
				_tmp63_ = string_substring (_tmp62_, (glong) 1, (glong) self->priv->_skip);
				_tmp64_ = _tmp63_;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp61_, _tmp64_, &_inner_error0_);
				_g_free0 (_tmp64_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			_tmp67_ = self->priv->_current_string;
			if (_tmp67_->len == ((gssize) 0)) {
				_tmp66_ = TRUE;
			} else {
				GString* _tmp68_;
				const gchar* _tmp69_;
				GString* _tmp70_;
				_tmp68_ = self->priv->_current_string;
				_tmp69_ = _tmp68_->str;
				_tmp70_ = self->priv->_current_string;
				_tmp66_ = !g_ascii_isalpha (string_get (_tmp69_, (glong) (_tmp70_->len - 1)));
			}
			if (_tmp66_) {
				_tmp65_ = g_unichar_isdigit (valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1));
			} else {
				_tmp65_ = FALSE;
			}
			if (_tmp65_) {
				const gchar* _iter = NULL;
				const gchar* _tmp71_;
				const gchar* _tmp72_;
				gboolean _tmp77_ = FALSE;
				const gchar* _tmp78_;
				gboolean _tmp96_ = FALSE;
				const gchar* _tmp97_;
				gboolean _tmp105_ = FALSE;
				const gchar* _tmp106_;
				ValadocTokenType* _tmp111_;
				const gchar* _tmp112_;
				gchar* _tmp113_;
				gchar* _tmp114_;
				_tmp71_ = self->priv->_index;
				_tmp72_ = string_offset (_tmp71_, (glong) 1);
				_iter = _tmp72_;
				while (TRUE) {
					const gchar* _tmp73_;
					const gchar* _tmp74_;
					const gchar* _tmp75_;
					gint _tmp76_;
					_tmp73_ = _iter;
					if (!g_ascii_isdigit (string_get (_tmp73_, (glong) 0))) {
						break;
					}
					_tmp74_ = _iter;
					_tmp75_ = string_offset (_tmp74_, (glong) 1);
					_iter = _tmp75_;
					_tmp76_ = self->priv->_skip;
					self->priv->_skip = _tmp76_ + 1;
				}
				_tmp78_ = _iter;
				if (g_ascii_tolower (string_get (_tmp78_, (glong) 0)) == 'u') {
					const gchar* _tmp79_;
					_tmp79_ = _iter;
					_tmp77_ = g_ascii_tolower (string_get (_tmp79_, (glong) 0)) == 'l';
				} else {
					_tmp77_ = FALSE;
				}
				if (_tmp77_) {
					const gchar* _tmp80_;
					const gchar* _tmp81_;
					ValadocTokenType* _tmp82_;
					const gchar* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					_tmp80_ = _iter;
					_tmp81_ = string_offset (_tmp80_, (glong) 1);
					_iter = _tmp81_;
					self->priv->_skip = self->priv->_skip + 2;
					_tmp82_ = valadoc_token_type_MARKDOWN_CONSTANT;
					_tmp83_ = self->priv->_index;
					_tmp84_ = string_substring (_tmp83_, (glong) 1, (glong) self->priv->_skip);
					_tmp85_ = _tmp84_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp82_, _tmp85_, &_inner_error0_);
					_g_free0 (_tmp85_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					break;
				} else {
					gboolean _tmp86_ = FALSE;
					const gchar* _tmp87_;
					_tmp87_ = _iter;
					if (g_ascii_tolower (string_get (_tmp87_, (glong) 0)) == 'u') {
						_tmp86_ = TRUE;
					} else {
						const gchar* _tmp88_;
						_tmp88_ = _iter;
						_tmp86_ = g_ascii_tolower (string_get (_tmp88_, (glong) 0)) == 'l';
					}
					if (_tmp86_) {
						const gchar* _tmp89_;
						const gchar* _tmp90_;
						gint _tmp91_;
						ValadocTokenType* _tmp92_;
						const gchar* _tmp93_;
						gchar* _tmp94_;
						gchar* _tmp95_;
						_tmp89_ = _iter;
						_tmp90_ = string_offset (_tmp89_, (glong) 1);
						_iter = _tmp90_;
						_tmp91_ = self->priv->_skip;
						self->priv->_skip = _tmp91_ + 1;
						_tmp92_ = valadoc_token_type_MARKDOWN_CONSTANT;
						_tmp93_ = self->priv->_index;
						_tmp94_ = string_substring (_tmp93_, (glong) 1, (glong) self->priv->_skip);
						_tmp95_ = _tmp94_;
						valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp92_, _tmp95_, &_inner_error0_);
						_g_free0 (_tmp95_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_free0 (hash);
								return;
							} else {
								_g_free0 (hash);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
						break;
					}
				}
				_tmp97_ = _iter;
				if (string_get (_tmp97_, (glong) 0) == '.') {
					const gchar* _tmp98_;
					_tmp98_ = _iter;
					_tmp96_ = g_ascii_isdigit (string_get (_tmp98_, (glong) 1));
				} else {
					_tmp96_ = FALSE;
				}
				if (_tmp96_) {
					const gchar* _tmp99_;
					const gchar* _tmp100_;
					_tmp99_ = _iter;
					_tmp100_ = string_offset (_tmp99_, (glong) 2);
					_iter = _tmp100_;
					self->priv->_skip = self->priv->_skip + 2;
				}
				while (TRUE) {
					const gchar* _tmp101_;
					const gchar* _tmp102_;
					const gchar* _tmp103_;
					gint _tmp104_;
					_tmp101_ = _iter;
					if (!g_ascii_isdigit (string_get (_tmp101_, (glong) 0))) {
						break;
					}
					_tmp102_ = _iter;
					_tmp103_ = string_offset (_tmp102_, (glong) 1);
					_iter = _tmp103_;
					_tmp104_ = self->priv->_skip;
					self->priv->_skip = _tmp104_ + 1;
				}
				_tmp106_ = _iter;
				if (g_ascii_tolower (string_get (_tmp106_, (glong) 0)) == 'f') {
					_tmp105_ = TRUE;
				} else {
					const gchar* _tmp107_;
					_tmp107_ = _iter;
					_tmp105_ = g_ascii_tolower (string_get (_tmp107_, (glong) 0)) == 'l';
				}
				if (_tmp105_) {
					const gchar* _tmp108_;
					const gchar* _tmp109_;
					gint _tmp110_;
					_tmp108_ = _iter;
					_tmp109_ = string_offset (_tmp108_, (glong) 1);
					_iter = _tmp109_;
					_tmp110_ = self->priv->_skip;
					self->priv->_skip = _tmp110_ + 1;
				}
				_tmp111_ = valadoc_token_type_MARKDOWN_CONSTANT;
				_tmp112_ = self->priv->_index;
				_tmp113_ = string_substring (_tmp112_, (glong) 1, (glong) self->priv->_skip);
				_tmp114_ = _tmp113_;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp111_, _tmp114_, &_inner_error0_);
				_g_free0 (_tmp114_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			valadoc_gtkdoc_markdown_scanner_append_char (self, c);
			break;
		}
		case '#':
		{
			gboolean _tmp115_ = FALSE;
			gboolean _tmp116_ = FALSE;
			GString* _tmp117_;
			_tmp117_ = self->priv->_current_string;
			if (_tmp117_->len == ((gssize) 0)) {
				_tmp116_ = TRUE;
			} else {
				GString* _tmp118_;
				const gchar* _tmp119_;
				GString* _tmp120_;
				_tmp118_ = self->priv->_current_string;
				_tmp119_ = _tmp118_->str;
				_tmp120_ = self->priv->_current_string;
				_tmp116_ = !g_ascii_isalpha (string_get (_tmp119_, (glong) (_tmp120_->len - 1)));
			}
			if (_tmp116_) {
				_tmp115_ = g_unichar_isalpha (valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1));
			} else {
				_tmp115_ = FALSE;
			}
			if (_tmp115_) {
				const gchar* _iter = NULL;
				const gchar* _tmp121_;
				const gchar* _tmp122_;
				gboolean is_field = FALSE;
				gboolean _tmp129_ = FALSE;
				gboolean _tmp130_ = FALSE;
				gboolean _tmp131_ = FALSE;
				const gchar* _tmp132_;
				gboolean _tmp150_ = FALSE;
				_tmp121_ = self->priv->_index;
				_tmp122_ = string_offset (_tmp121_, (glong) 1);
				_iter = _tmp122_;
				while (TRUE) {
					gboolean _tmp123_ = FALSE;
					const gchar* _tmp124_;
					const gchar* _tmp126_;
					const gchar* _tmp127_;
					gint _tmp128_;
					_tmp124_ = _iter;
					if (g_ascii_isalnum (string_get (_tmp124_, (glong) 0))) {
						_tmp123_ = TRUE;
					} else {
						const gchar* _tmp125_;
						_tmp125_ = _iter;
						_tmp123_ = string_get (_tmp125_, (glong) 0) == '_';
					}
					if (!_tmp123_) {
						break;
					}
					_tmp126_ = _iter;
					_tmp127_ = string_offset (_tmp126_, (glong) 1);
					_iter = _tmp127_;
					_tmp128_ = self->priv->_skip;
					self->priv->_skip = _tmp128_ + 1;
				}
				is_field = FALSE;
				_tmp132_ = _iter;
				if (string_get (_tmp132_, (glong) 0) == ':') {
					_tmp131_ = TRUE;
				} else {
					const gchar* _tmp133_;
					_tmp133_ = _iter;
					_tmp131_ = string_get (_tmp133_, (glong) 0) == '.';
				}
				if (_tmp131_) {
					const gchar* _tmp134_;
					_tmp134_ = _iter;
					_tmp130_ = g_ascii_isalpha (string_get (_tmp134_, (glong) 1));
				} else {
					_tmp130_ = FALSE;
				}
				if (_tmp130_) {
					_tmp129_ = TRUE;
				} else {
					gboolean _tmp135_ = FALSE;
					const gchar* _tmp136_;
					_tmp136_ = _iter;
					if (g_str_has_prefix (_tmp136_, "::")) {
						const gchar* _tmp137_;
						_tmp137_ = _iter;
						_tmp135_ = g_ascii_isalpha (string_get (_tmp137_, (glong) 2));
					} else {
						_tmp135_ = FALSE;
					}
					_tmp129_ = _tmp135_;
				}
				if (_tmp129_) {
					const gchar* _tmp138_;
					const gchar* _tmp139_;
					const gchar* _tmp140_;
					_tmp138_ = _iter;
					is_field = string_get (_tmp138_, (glong) 0) == '.';
					_tmp139_ = _iter;
					_tmp140_ = string_offset (_tmp139_, (glong) 2);
					_iter = _tmp140_;
					self->priv->_skip = self->priv->_skip + 2;
					while (TRUE) {
						gboolean _tmp141_ = FALSE;
						gboolean _tmp142_ = FALSE;
						const gchar* _tmp143_;
						const gchar* _tmp147_;
						const gchar* _tmp148_;
						gint _tmp149_;
						_tmp143_ = _iter;
						if (g_ascii_isalnum (string_get (_tmp143_, (glong) 0))) {
							_tmp142_ = TRUE;
						} else {
							const gchar* _tmp144_;
							_tmp144_ = _iter;
							_tmp142_ = string_get (_tmp144_, (glong) 0) == '_';
						}
						if (_tmp142_) {
							_tmp141_ = TRUE;
						} else {
							gboolean _tmp145_ = FALSE;
							if (!is_field) {
								const gchar* _tmp146_;
								_tmp146_ = _iter;
								_tmp145_ = string_get (_tmp146_, (glong) 0) == '-';
							} else {
								_tmp145_ = FALSE;
							}
							_tmp141_ = _tmp145_;
						}
						if (!_tmp141_) {
							break;
						}
						_tmp147_ = _iter;
						_tmp148_ = string_offset (_tmp147_, (glong) 1);
						_iter = _tmp148_;
						_tmp149_ = self->priv->_skip;
						self->priv->_skip = _tmp149_ + 1;
					}
				}
				if (is_field) {
					const gchar* _tmp151_;
					_tmp151_ = _iter;
					_tmp150_ = g_str_has_prefix (_tmp151_, "()");
				} else {
					_tmp150_ = FALSE;
				}
				if (_tmp150_) {
					ValadocTokenType* _tmp152_;
					const gchar* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					self->priv->_skip = self->priv->_skip + 2;
					_tmp152_ = valadoc_token_type_MARKDOWN_SYMBOL;
					_tmp153_ = self->priv->_index;
					_tmp154_ = string_substring (_tmp153_, (glong) 1, (glong) (self->priv->_skip - 2));
					_tmp155_ = _tmp154_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp152_, _tmp155_, &_inner_error0_);
					_g_free0 (_tmp155_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				} else {
					ValadocTokenType* _tmp156_;
					const gchar* _tmp157_;
					gchar* _tmp158_;
					gchar* _tmp159_;
					_tmp156_ = valadoc_token_type_MARKDOWN_SYMBOL;
					_tmp157_ = self->priv->_index;
					_tmp158_ = string_substring (_tmp157_, (glong) 1, (glong) self->priv->_skip);
					_tmp159_ = _tmp158_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp156_, _tmp159_, &_inner_error0_);
					_g_free0 (_tmp159_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
				break;
			}
			valadoc_gtkdoc_markdown_scanner_append_char (self, c);
			break;
		}
		case '@':
		{
			gboolean _tmp160_ = FALSE;
			GString* _tmp161_;
			_tmp161_ = self->priv->_current_string;
			if (_tmp161_->len == ((gssize) 0)) {
				_tmp160_ = TRUE;
			} else {
				GString* _tmp162_;
				const gchar* _tmp163_;
				GString* _tmp164_;
				_tmp162_ = self->priv->_current_string;
				_tmp163_ = _tmp162_->str;
				_tmp164_ = self->priv->_current_string;
				_tmp160_ = !g_ascii_isalpha (string_get (_tmp163_, (glong) (_tmp164_->len - 1)));
			}
			if (_tmp160_) {
				if (g_unichar_isalpha (valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1))) {
					const gchar* _iter = NULL;
					const gchar* _tmp165_;
					const gchar* _tmp166_;
					ValadocTokenType* _tmp173_;
					const gchar* _tmp174_;
					gchar* _tmp175_;
					gchar* _tmp176_;
					_tmp165_ = self->priv->_index;
					_tmp166_ = string_offset (_tmp165_, (glong) 1);
					_iter = _tmp166_;
					while (TRUE) {
						gboolean _tmp167_ = FALSE;
						const gchar* _tmp168_;
						const gchar* _tmp170_;
						const gchar* _tmp171_;
						gint _tmp172_;
						_tmp168_ = _iter;
						if (g_ascii_isalnum (string_get (_tmp168_, (glong) 0))) {
							_tmp167_ = TRUE;
						} else {
							const gchar* _tmp169_;
							_tmp169_ = _iter;
							_tmp167_ = string_get (_tmp169_, (glong) 0) == '_';
						}
						if (!_tmp167_) {
							break;
						}
						_tmp170_ = _iter;
						_tmp171_ = string_offset (_tmp170_, (glong) 1);
						_iter = _tmp171_;
						_tmp172_ = self->priv->_skip;
						self->priv->_skip = _tmp172_ + 1;
					}
					_tmp173_ = valadoc_token_type_MARKDOWN_PARAMETER;
					_tmp174_ = self->priv->_index;
					_tmp175_ = string_substring (_tmp174_, (glong) 1, (glong) self->priv->_skip);
					_tmp176_ = _tmp175_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp173_, _tmp176_, &_inner_error0_);
					_g_free0 (_tmp176_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					break;
				} else {
					const gchar* _tmp177_;
					_tmp177_ = self->priv->_index;
					if (g_str_has_prefix (_tmp177_, "@...")) {
						ValadocTokenType* _tmp178_;
						self->priv->_skip = self->priv->_skip + 3;
						_tmp178_ = valadoc_token_type_MARKDOWN_PARAMETER;
						valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp178_, "...", &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_free0 (hash);
								return;
							} else {
								_g_free0 (hash);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
						break;
					}
				}
			}
			valadoc_gtkdoc_markdown_scanner_append_char (self, c);
			self->priv->contains_at = TRUE;
			break;
		}
		case '(':
		{
			gboolean _tmp179_ = FALSE;
			ValadocTokenType* _tmp187_;
			if (valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1) == ((gunichar) ')')) {
				_tmp179_ = valadoc_gtkdoc_markdown_scanner_is_id (self);
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				gchar* id = NULL;
				GString* _tmp180_;
				const gchar* _tmp181_;
				gchar* _tmp182_;
				GString* _tmp183_;
				ValadocTokenType* _tmp184_;
				const gchar* _tmp185_;
				gint _tmp186_;
				_tmp180_ = self->priv->_current_string;
				_tmp181_ = _tmp180_->str;
				_tmp182_ = g_strdup (_tmp181_);
				id = _tmp182_;
				_tmp183_ = self->priv->_current_string;
				g_string_erase (_tmp183_, (gssize) 0, (gssize) -1);
				self->priv->contains_at = FALSE;
				_tmp184_ = valadoc_token_type_MARKDOWN_FUNCTION;
				_tmp185_ = id;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp184_, _tmp185_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (id);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (id);
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp186_ = self->priv->_skip;
				self->priv->_skip = _tmp186_ + 1;
				_g_free0 (id);
				break;
			}
			_tmp187_ = valadoc_token_type_MARKDOWN_OPEN_PARENS;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp187_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			break;
		}
		case ')':
		{
			ValadocTokenType* _tmp188_;
			_tmp188_ = valadoc_token_type_MARKDOWN_CLOSE_PARENS;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp188_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			break;
		}
		case '[':
		{
			const gchar* iter = NULL;
			const gchar* _tmp189_;
			gint count = 0;
			const gchar* _tmp199_;
			_tmp189_ = self->priv->_index;
			iter = _tmp189_;
			count = 1;
			while (TRUE) {
				gboolean _tmp190_ = FALSE;
				gboolean _tmp191_ = FALSE;
				const gchar* _tmp192_;
				const gchar* _tmp194_;
				const gchar* _tmp195_;
				const gchar* _tmp196_;
				_tmp192_ = iter;
				if (string_get (_tmp192_, (glong) 0) != '\n') {
					const gchar* _tmp193_;
					_tmp193_ = iter;
					_tmp191_ = string_get (_tmp193_, (glong) 0) != '\0';
				} else {
					_tmp191_ = FALSE;
				}
				if (_tmp191_) {
					_tmp190_ = count > 0;
				} else {
					_tmp190_ = FALSE;
				}
				if (!_tmp190_) {
					break;
				}
				_tmp194_ = iter;
				_tmp195_ = string_offset (_tmp194_, (glong) 1);
				iter = _tmp195_;
				_tmp196_ = iter;
				switch (string_get (_tmp196_, (glong) 0)) {
					case '[':
					{
						gint _tmp197_;
						_tmp197_ = count;
						count = _tmp197_ + 1;
						break;
					}
					case ']':
					{
						gint _tmp198_;
						_tmp198_ = count;
						count = _tmp198_ - 1;
						break;
					}
					default:
					break;
				}
			}
			_tmp199_ = iter;
			if (string_get (_tmp199_, (glong) 0) == ']') {
				ValadocTokenType* _tmp200_;
				_tmp200_ = valadoc_token_type_MARKDOWN_OPEN_BRACKET;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp200_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			} else {
				valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '[');
			}
			break;
		}
		case ']':
		{
			ValadocTokenType* _tmp201_;
			_tmp201_ = valadoc_token_type_MARKDOWN_CLOSE_BRACKET;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp201_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			break;
		}
		case '<':
		{
			ValadocTokenType* _tmp202_;
			_tmp202_ = valadoc_token_type_MARKDOWN_LESS_THAN;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp202_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			break;
		}
		case '>':
		{
			ValadocTokenType* _tmp203_;
			_tmp203_ = valadoc_token_type_MARKDOWN_GREATER_THAN;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp203_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			break;
		}
		case '!':
		{
			ValadocTokenType* _tmp204_;
			_tmp204_ = valadoc_token_type_MARKDOWN_EXCLAMATION_MARK;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp204_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			break;
		}
		case '|':
		{
			if (valadoc_gtkdoc_markdown_scanner_get_next_char (self, 1) == ((gunichar) '[')) {
				const gchar* _iter = NULL;
				const gchar* _tmp205_;
				const gchar* _tmp206_;
				gint end = 0;
				const gchar* _tmp207_;
				_tmp205_ = self->priv->_index;
				_tmp206_ = string_offset (_tmp205_, (glong) 2);
				_iter = _tmp206_;
				_tmp207_ = _iter;
				end = string_index_of (_tmp207_, "]|", 0);
				if (end < 0) {
					valadoc_gtkdoc_markdown_scanner_append_char (self, (gunichar) '|');
				} else {
					ValadocTokenType* _tmp208_;
					const gchar* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					_tmp208_ = valadoc_token_type_MARKDOWN_SOURCE;
					_tmp209_ = self->priv->_index;
					_tmp210_ = string_substring (_tmp209_, (glong) 2, (glong) end);
					_tmp211_ = _tmp210_;
					valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp208_, _tmp211_, &_inner_error0_);
					_g_free0 (_tmp211_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (hash);
							return;
						} else {
							_g_free0 (hash);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					self->priv->_skip = end + 3;
				}
				break;
			}
			valadoc_gtkdoc_markdown_scanner_append_char (self, c);
			break;
		}
		case '\t':
		case ' ':
		{
			const gchar* _iter = NULL;
			const gchar* _tmp212_;
			const gchar* _tmp213_;
			gint _tmp214_;
			gboolean _tmp215_ = FALSE;
			const gchar* _tmp216_;
			_tmp212_ = self->priv->_index;
			_tmp213_ = string_offset (_tmp212_, (glong) 1);
			_iter = _tmp213_;
			_tmp214_ = valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
			self->priv->_skip = self->priv->_skip + _tmp214_;
			_tmp216_ = _iter;
			if (string_get (_tmp216_, (glong) 0) != '\n') {
				const gchar* _tmp217_;
				_tmp217_ = _iter;
				_tmp215_ = string_get (_tmp217_, (glong) 0) != '\0';
			} else {
				_tmp215_ = FALSE;
			}
			if (_tmp215_) {
				ValadocTokenType* _tmp218_;
				_tmp218_ = valadoc_token_type_MARKDOWN_SPACE;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp218_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (hash);
						return;
					} else {
						_g_free0 (hash);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			break;
		}
		case '\r':
		{
			break;
		}
		case '\n':
		{
			const gchar* _iter = NULL;
			const gchar* _tmp219_;
			const gchar* _tmp220_;
			gint _tmp221_;
			const gchar* _tmp222_;
			_tmp219_ = self->priv->_index;
			_tmp220_ = string_offset (_tmp219_, (glong) 1);
			_iter = _tmp220_;
			_tmp221_ = self->priv->_line;
			self->priv->_line = _tmp221_ + 1;
			self->priv->_column = 0;
			self->priv->_last_column = 0;
			_tmp222_ = _iter;
			valadoc_gtkdoc_markdown_scanner_handle_newline (self, _tmp222_, FALSE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (hash);
					return;
				} else {
					_g_free0 (hash);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			break;
		}
		default:
		{
			valadoc_gtkdoc_markdown_scanner_append_char (self, c);
			break;
		}
	}
	_g_free0 (hash);
}

static gboolean
valadoc_gtkdoc_markdown_scanner_handle_newline (ValadocGtkdocMarkdownScanner* self,
                                                const gchar* _iter,
                                                gboolean is_paragraph,
                                                GError** error)
{
	gint leading_spaces = 0;
	gint _tmp0_;
	gboolean in_block = FALSE;
	ValaList* _tmp4_;
	gint list_token_len = 0;
	gboolean _tmp22_ = FALSE;
	gboolean is_unsorted_list = FALSE;
	gboolean is_sorted_list = FALSE;
	gint _tmp23_ = 0;
	gboolean _tmp24_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_iter != NULL, FALSE);
	_tmp0_ = valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
	leading_spaces = _tmp0_;
	if (string_get (_iter, (glong) 0) == '\0') {
		result = FALSE;
		return result;
	}
	if (is_paragraph) {
		while (TRUE) {
			gint _tmp1_;
			const gchar* _tmp2_;
			gint _tmp3_;
			if (!(string_get (_iter, (glong) 0) == '\n')) {
				break;
			}
			_tmp1_ = self->priv->_line;
			self->priv->_line = _tmp1_ + 1;
			_tmp2_ = string_offset (_iter, (glong) 1);
			_iter = _tmp2_;
			_tmp3_ = valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
			leading_spaces = _tmp3_;
		}
	}
	_tmp4_ = self->priv->states;
	in_block = vala_collection_contains ((ValaCollection*) _tmp4_, (gpointer) ((gintptr) VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK));
	if (string_get (_iter, (glong) 0) == '>') {
		gboolean _tmp12_ = FALSE;
		if (!in_block) {
			valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp5_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp5_;
				} else {
					gboolean _tmp6_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp6_;
				}
			}
			if (is_paragraph) {
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValadocTokenType* _tmp9_;
				_tmp7_ = self->priv->_index;
				self->priv->_column = self->priv->_column + ((gint) (((gchar*) _iter) - ((gchar*) _tmp7_)));
				_tmp8_ = string_offset (_iter, (glong) 1);
				self->priv->_index = _tmp8_;
				_tmp9_ = valadoc_token_type_MARKDOWN_BLOCK_START;
				valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp9_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						gboolean _tmp10_ = FALSE;
						g_propagate_error (error, _inner_error0_);
						return _tmp10_;
					} else {
						gboolean _tmp11_ = FALSE;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp11_;
					}
				}
				valadoc_gtkdoc_markdown_scanner_push_state (self, VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_BLOCK);
			}
		}
		if (in_block) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = is_paragraph;
		}
		if (_tmp12_) {
			gint _tmp13_;
			const gchar* _tmp14_;
			_tmp13_ = self->priv->_column;
			self->priv->_column = _tmp13_ + 1;
			self->priv->_index = _iter;
			_tmp14_ = string_offset (_iter, (glong) 1);
			_iter = _tmp14_;
			valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
		}
	} else {
		gboolean _tmp15_ = FALSE;
		if (in_block) {
			_tmp15_ = is_paragraph;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			const gchar* _tmp16_;
			ValadocTokenType* _tmp19_;
			_tmp16_ = self->priv->_index;
			self->priv->_column = self->priv->_column + ((gint) (((gchar*) _iter) - ((gchar*) _tmp16_)));
			self->priv->_index = _iter;
			valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp17_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp17_;
				} else {
					gboolean _tmp18_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp18_;
				}
			}
			_tmp19_ = valadoc_token_type_MARKDOWN_BLOCK_END;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp19_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp20_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp20_;
				} else {
					gboolean _tmp21_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp21_;
				}
			}
			valadoc_gtkdoc_markdown_scanner_pop_state (self);
		}
	}
	list_token_len = 0;
	if (string_get (_iter, (glong) 0) == '-') {
		_tmp22_ = g_ascii_isspace (string_get (_iter, (glong) 1));
	} else {
		_tmp22_ = FALSE;
	}
	is_unsorted_list = _tmp22_;
	_tmp24_ = valadoc_gtkdoc_markdown_scanner_is_ordered_list (self, _iter, &_tmp23_);
	list_token_len = _tmp23_;
	is_sorted_list = _tmp24_;
	if (is_unsorted_list) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = is_sorted_list;
	}
	if (_tmp26_) {
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		if (is_paragraph) {
			_tmp28_ = TRUE;
		} else {
			ValaList* _tmp29_;
			_tmp29_ = self->priv->states;
			_tmp28_ = vala_collection_contains ((ValaCollection*) _tmp29_, (gpointer) ((gintptr) VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST));
		}
		if (_tmp28_) {
			_tmp27_ = TRUE;
		} else {
			ValaList* _tmp30_;
			_tmp30_ = self->priv->states;
			_tmp27_ = vala_collection_contains ((ValaCollection*) _tmp30_, (gpointer) ((gintptr) VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST));
		}
		_tmp25_ = _tmp27_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValadocTokenType* start_token = NULL;
		ValadocTokenType* _tmp31_;
		ValadocTokenType* _tmp32_;
		ValadocGtkdocMarkdownScannerState new_state = 0;
		const gchar* _tmp35_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		ValadocTokenType* _tmp40_;
		ValadocGtkdocMarkdownScannerState _tmp43_;
		ValadocTokenType* _tmp44_;
		_tmp31_ = valadoc_token_type_MARKDOWN_ORDERED_LIST_ITEM_START;
		_tmp32_ = _g_object_ref0 (_tmp31_);
		start_token = _tmp32_;
		new_state = VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST;
		if (is_unsorted_list) {
			ValadocTokenType* _tmp33_;
			ValadocTokenType* _tmp34_;
			_tmp33_ = valadoc_token_type_MARKDOWN_UNORDERED_LIST_ITEM_START;
			_tmp34_ = _g_object_ref0 (_tmp33_);
			_g_object_unref0 (start_token);
			start_token = _tmp34_;
			new_state = VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST;
			list_token_len = 2;
		}
		_tmp35_ = string_offset (_iter, (glong) list_token_len);
		_iter = _tmp35_;
		valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp36_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (start_token);
				return _tmp36_;
			} else {
				gboolean _tmp37_ = FALSE;
				_g_object_unref0 (start_token);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp37_;
			}
		}
		valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
		_tmp38_ = self->priv->_index;
		self->priv->_column = self->priv->_column + ((gint) (((gchar*) _iter) - ((gchar*) _tmp38_)));
		_tmp39_ = string_offset (_iter, (glong) -1);
		self->priv->_index = _tmp39_;
		_tmp40_ = start_token;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp40_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp41_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (start_token);
				return _tmp41_;
			} else {
				gboolean _tmp42_ = FALSE;
				_g_object_unref0 (start_token);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp42_;
			}
		}
		_tmp43_ = new_state;
		valadoc_gtkdoc_markdown_scanner_push_state (self, _tmp43_);
		_tmp44_ = valadoc_token_type_MARKDOWN_PARAGRAPH;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp44_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp45_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (start_token);
				return _tmp45_;
			} else {
				gboolean _tmp46_ = FALSE;
				_g_object_unref0 (start_token);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp46_;
			}
		}
		result = TRUE;
		_g_object_unref0 (start_token);
		return result;
	}
	if (string_get (_iter, (glong) 0) == '#') {
		_tmp48_ = g_ascii_isspace (string_get (_iter, (glong) 1));
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		_tmp47_ = TRUE;
	} else {
		gboolean _tmp49_ = FALSE;
		gboolean _tmp50_ = FALSE;
		gboolean _tmp51_ = FALSE;
		if (string_get (_iter, (glong) 0) == '#') {
			_tmp51_ = string_get (_iter, (glong) 1) == '#';
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			_tmp50_ = g_ascii_isspace (string_get (_iter, (glong) 2));
		} else {
			_tmp50_ = FALSE;
		}
		if (_tmp50_) {
			_tmp49_ = is_paragraph;
		} else {
			_tmp49_ = FALSE;
		}
		_tmp47_ = _tmp49_;
	}
	if (_tmp47_) {
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp52_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				return _tmp52_;
			} else {
				gboolean _tmp53_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp53_;
			}
		}
		if (string_get (_iter, (glong) 1) != '#') {
			const gchar* _tmp54_;
			ValadocTokenType* _tmp55_;
			gchar* _tmp58_;
			_tmp54_ = string_offset (_iter, (glong) 1);
			_iter = _tmp54_;
			_tmp55_ = valadoc_token_type_MARKDOWN_HEADLINE_1;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp55_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp56_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp56_;
				} else {
					gboolean _tmp57_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp57_;
				}
			}
			_tmp58_ = g_strdup ("#");
			_g_free0 (self->priv->headline_end);
			self->priv->headline_end = _tmp58_;
		} else {
			ValadocTokenType* _tmp59_;
			const gchar* _tmp62_;
			gchar* _tmp63_;
			_tmp59_ = valadoc_token_type_MARKDOWN_HEADLINE_2;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp59_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp60_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp60_;
				} else {
					gboolean _tmp61_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp61_;
				}
			}
			_tmp62_ = string_offset (_iter, (glong) 2);
			_iter = _tmp62_;
			_tmp63_ = g_strdup ("##");
			_g_free0 (self->priv->headline_end);
			self->priv->headline_end = _tmp63_;
		}
		_tmp64_ = self->priv->_index;
		self->priv->_column = self->priv->_column + ((gint) (((gchar*) _iter) - ((gchar*) _tmp64_)));
		_tmp65_ = string_offset (_iter, (glong) -1);
		self->priv->_index = _tmp65_;
		result = TRUE;
		return result;
	}
	if (is_paragraph) {
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		ValadocTokenType* _tmp70_;
		if (leading_spaces == 0) {
			valadoc_gtkdoc_markdown_scanner_close_block (self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp66_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp66_;
				} else {
					gboolean _tmp67_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp67_;
				}
			}
		}
		_tmp68_ = self->priv->_index;
		self->priv->_column = self->priv->_column + ((gint) (((gchar*) _iter) - ((gchar*) _tmp68_)));
		_tmp69_ = string_offset (_iter, (glong) -1);
		self->priv->_index = _tmp69_;
		_tmp70_ = valadoc_token_type_MARKDOWN_PARAGRAPH;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp70_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp71_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				return _tmp71_;
			} else {
				gboolean _tmp72_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp72_;
			}
		}
	} else {
		if (string_get (_iter, (glong) 0) == '\n') {
			gint _tmp73_;
			const gchar* _tmp74_;
			_tmp73_ = self->priv->_line;
			self->priv->_line = _tmp73_ + 1;
			self->priv->_column = 0;
			self->priv->_last_column = 0;
			_tmp74_ = string_offset (_iter, (glong) 1);
			valadoc_gtkdoc_markdown_scanner_handle_newline (self, _tmp74_, TRUE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp75_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp75_;
				} else {
					gboolean _tmp76_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp76_;
				}
			}
		} else {
			ValadocTokenType* _tmp77_;
			_tmp77_ = valadoc_token_type_MARKDOWN_SPACE;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp77_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp78_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp78_;
				} else {
					gboolean _tmp79_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp79_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
valadoc_gtkdoc_markdown_scanner_is_headline_end (ValadocGtkdocMarkdownScanner* self,
                                                 const gchar** iter,
                                                 const gchar* separator,
                                                 gchar** hash)
{
	gchar* _vala_hash = NULL;
	const gchar* _iter = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* id_start = NULL;
	const gchar* _tmp17_;
	gint hash_len = 0;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (*iter != NULL, FALSE);
	g_return_val_if_fail (separator != NULL, FALSE);
	_iter = *iter;
	_g_free0 (_vala_hash);
	_vala_hash = NULL;
	_tmp1_ = _iter;
	if (string_get (_tmp1_, (glong) 0) == '\n') {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = _iter;
		_tmp0_ = string_get (_tmp2_, (glong) 0) == '\0';
	}
	if (_tmp0_) {
		gint _tmp3_;
		_tmp3_ = self->priv->_line;
		self->priv->_line = _tmp3_ + 1;
		result = TRUE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	}
	_tmp4_ = _iter;
	if (!g_str_has_prefix (_tmp4_, separator)) {
		result = FALSE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	}
	_tmp5_ = _iter;
	_tmp6_ = strlen (separator);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_offset (_tmp5_, (glong) _tmp7_);
	_iter = _tmp8_;
	valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
	_tmp10_ = _iter;
	if (string_get (_tmp10_, (glong) 0) == '\n') {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = _iter;
		_tmp9_ = string_get (_tmp11_, (glong) 0) == '\0';
	}
	if (_tmp9_) {
		const gchar* _tmp12_;
		gint _tmp13_;
		_tmp12_ = _iter;
		*iter = _tmp12_;
		_tmp13_ = self->priv->_line;
		self->priv->_line = _tmp13_ + 1;
		result = TRUE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	} else {
		const gchar* _tmp14_;
		_tmp14_ = _iter;
		if (!g_str_has_prefix (_tmp14_, "{#")) {
			result = FALSE;
			if (hash) {
				*hash = _vala_hash;
			} else {
				_g_free0 (_vala_hash);
			}
			return result;
		}
	}
	_tmp15_ = _iter;
	_tmp16_ = string_offset (_tmp15_, (glong) 2);
	_iter = _tmp16_;
	_tmp17_ = _iter;
	id_start = _tmp17_;
	hash_len = 0;
	while (TRUE) {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gint _tmp25_;
		_tmp20_ = _iter;
		if (string_get (_tmp20_, (glong) 0) != '}') {
			const gchar* _tmp21_;
			_tmp21_ = _iter;
			_tmp19_ = string_get (_tmp21_, (glong) 0) != '\n';
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			const gchar* _tmp22_;
			_tmp22_ = _iter;
			_tmp18_ = string_get (_tmp22_, (glong) 0) != '\0';
		} else {
			_tmp18_ = FALSE;
		}
		if (!_tmp18_) {
			break;
		}
		_tmp23_ = _iter;
		_tmp24_ = string_offset (_tmp23_, (glong) 1);
		_iter = _tmp24_;
		_tmp25_ = hash_len;
		hash_len = _tmp25_ + 1;
	}
	_tmp26_ = _iter;
	if (string_get (_tmp26_, (glong) 0) != '}') {
		result = FALSE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	}
	_tmp27_ = _iter;
	_tmp28_ = string_offset (_tmp27_, (glong) 1);
	_iter = _tmp28_;
	valadoc_gtkdoc_markdown_scanner_skip_spaces (self, &_iter);
	_tmp30_ = _iter;
	if (string_get (_tmp30_, (glong) 0) == '\n') {
		_tmp29_ = TRUE;
	} else {
		const gchar* _tmp31_;
		_tmp31_ = _iter;
		_tmp29_ = string_get (_tmp31_, (glong) 0) == '\0';
	}
	if (_tmp29_) {
		const gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gint _tmp35_;
		_tmp32_ = id_start;
		_tmp33_ = string_substring (_tmp32_, (glong) 0, (glong) hash_len);
		_g_free0 (_vala_hash);
		_vala_hash = _tmp33_;
		_tmp34_ = _iter;
		*iter = _tmp34_;
		_tmp35_ = self->priv->_line;
		self->priv->_line = _tmp35_ + 1;
		result = TRUE;
		if (hash) {
			*hash = _vala_hash;
		} else {
			_g_free0 (_vala_hash);
		}
		return result;
	}
	result = FALSE;
	if (hash) {
		*hash = _vala_hash;
	} else {
		_g_free0 (_vala_hash);
	}
	return result;
}

static gboolean
valadoc_gtkdoc_markdown_scanner_is_ordered_list (ValadocGtkdocMarkdownScanner* self,
                                                 const gchar* iter,
                                                 gint* numeric_prefix_count)
{
	gint _vala_numeric_prefix_count = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_vala_numeric_prefix_count = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		const gchar* _tmp2_;
		if (string_get (iter, (glong) 0) >= '0') {
			_tmp0_ = string_get (iter, (glong) 0) <= '9';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = _vala_numeric_prefix_count;
		_vala_numeric_prefix_count = _tmp1_ + 1;
		_tmp2_ = string_offset (iter, (glong) 1);
		iter = _tmp2_;
	}
	if (_vala_numeric_prefix_count > 0) {
		_tmp4_ = string_get (iter, (glong) 0) == '.';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = g_ascii_isspace (string_get (iter, (glong) 1));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gint _tmp5_;
		_tmp5_ = _vala_numeric_prefix_count;
		_vala_numeric_prefix_count = _tmp5_ + 1;
		result = TRUE;
		if (numeric_prefix_count) {
			*numeric_prefix_count = _vala_numeric_prefix_count;
		}
		return result;
	}
	result = FALSE;
	if (numeric_prefix_count) {
		*numeric_prefix_count = _vala_numeric_prefix_count;
	}
	return result;
}

static inline gint
valadoc_gtkdoc_markdown_scanner_skip_spaces (ValadocGtkdocMarkdownScanner* self,
                                             const gchar** _iter)
{
	gint count = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (*_iter != NULL, 0);
	count = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		gint _tmp3_;
		if (string_get (*_iter, (glong) 0) == ' ') {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = string_get (*_iter, (glong) 0) == '\t';
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = string_get (*_iter, (glong) 0) == '\r';
		}
		if (!_tmp0_) {
			break;
		}
		_tmp2_ = string_offset (*_iter, (glong) 1);
		*_iter = _tmp2_;
		_tmp3_ = count;
		count = _tmp3_ + 1;
	}
	result = count;
	return result;
}

static gboolean
valadoc_gtkdoc_markdown_scanner_close_block (ValadocGtkdocMarkdownScanner* self,
                                             GError** error)
{
	ValaList* _tmp0_;
	gpointer _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->states;
	_tmp1_ = vala_list_get (_tmp0_, 0);
	if (((ValadocGtkdocMarkdownScannerState) ((gintptr) _tmp1_)) == VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_UNORDERED_LIST) {
		ValadocTokenType* _tmp2_;
		_tmp2_ = valadoc_token_type_MARKDOWN_UNORDERED_LIST_ITEM_END;
		valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				gboolean _tmp3_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				return _tmp3_;
			} else {
				gboolean _tmp4_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp4_;
			}
		}
		valadoc_gtkdoc_markdown_scanner_pop_state (self);
		result = TRUE;
		return result;
	} else {
		ValaList* _tmp5_;
		gpointer _tmp6_;
		_tmp5_ = self->priv->states;
		_tmp6_ = vala_list_get (_tmp5_, 0);
		if (((ValadocGtkdocMarkdownScannerState) ((gintptr) _tmp6_)) == VALADOC_GTKDOC_MARKDOWN_SCANNER_STATE_ORDERED_LIST) {
			ValadocTokenType* _tmp7_;
			_tmp7_ = valadoc_token_type_MARKDOWN_ORDERED_LIST_ITEM_END;
			valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					gboolean _tmp8_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp8_;
				} else {
					gboolean _tmp9_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp9_;
				}
			}
			valadoc_gtkdoc_markdown_scanner_pop_state (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static void
valadoc_gtkdoc_markdown_scanner_real_end (ValadocScanner* base,
                                          GError** error)
{
	ValadocGtkdocMarkdownScanner * self;
	ValadocTokenType* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (ValadocGtkdocMarkdownScanner*) base;
	_tmp0_ = valadoc_token_type_EOF;
	valadoc_gtkdoc_markdown_scanner_emit_token (self, _tmp0_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
valadoc_gtkdoc_markdown_scanner_real_stop (ValadocScanner* base)
{
	ValadocGtkdocMarkdownScanner * self;
	self = (ValadocGtkdocMarkdownScanner*) base;
	self->priv->_stop = TRUE;
}

static gchar*
valadoc_gtkdoc_markdown_scanner_real_get_line_content (ValadocScanner* base)
{
	ValadocGtkdocMarkdownScanner * self;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* line_start = NULL;
	const gchar* _tmp1_;
	gunichar c = 0U;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	self = (ValadocGtkdocMarkdownScanner*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->_index;
	line_start = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = line_start;
		_tmp4_ = self->priv->_content;
		if (((gchar*) _tmp3_) > ((gchar*) _tmp4_)) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = line_start;
			_tmp6_ = g_utf8_prev_char (_tmp5_);
			_tmp2_ = string_get_char (_tmp6_, (glong) 0) != ((gunichar) '\n');
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp7_ = line_start;
		_tmp8_ = g_utf8_prev_char (_tmp7_);
		line_start = _tmp8_;
	}
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp10_ = line_start;
		c = string_get_char (_tmp10_, (glong) 0);
		if (c != ((gunichar) '\n')) {
			_tmp9_ = c != ((gunichar) '\0');
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		if (c == ((gunichar) '\t')) {
			GString* _tmp11_;
			_tmp11_ = builder;
			g_string_append_c (_tmp11_, ' ');
		} else {
			GString* _tmp12_;
			_tmp12_ = builder;
			g_string_append_unichar (_tmp12_, c);
		}
		_tmp13_ = line_start;
		_tmp14_ = g_utf8_next_char (_tmp13_);
		line_start = _tmp14_;
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}

static void
valadoc_gtkdoc_markdown_scanner_emit_token (ValadocGtkdocMarkdownScanner* self,
                                            ValadocTokenType* type,
                                            const gchar* value,
                                            GError** error)
{
	ValadocParser* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValadocToken* _tmp3_;
	ValadocToken* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	valadoc_gtkdoc_markdown_scanner_emit_current_word (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp0_ = self->priv->parser;
	valadoc_gtkdoc_markdown_scanner_get_begin (self, &_tmp1_);
	valadoc_gtkdoc_markdown_scanner_get_end (self, self->priv->_skip, &_tmp2_);
	_tmp3_ = valadoc_token_new_from_type (type, &_tmp1_, &_tmp2_, value);
	_tmp4_ = _tmp3_;
	valadoc_parser_accept_token (_tmp0_, _tmp4_, &_inner_error0_);
	_g_object_unref0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
valadoc_gtkdoc_markdown_scanner_emit_current_word (ValadocGtkdocMarkdownScanner* self,
                                                   GError** error)
{
	GString* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_string;
	if (_tmp0_->len > ((gssize) 0)) {
		GString* _tmp29_;
		if (valadoc_gtkdoc_markdown_scanner_is_mail (self)) {
			ValadocParser* _tmp1_;
			ValadocTokenType* _tmp2_;
			ValaSourceLocation _tmp3_ = {0};
			ValaSourceLocation _tmp4_ = {0};
			GString* _tmp5_;
			const gchar* _tmp6_;
			ValadocToken* _tmp7_;
			ValadocToken* _tmp8_;
			_tmp1_ = self->priv->parser;
			_tmp2_ = valadoc_token_type_MARKDOWN_MAIL;
			valadoc_gtkdoc_markdown_scanner_get_begin (self, &_tmp3_);
			valadoc_gtkdoc_markdown_scanner_get_end (self, self->priv->_skip, &_tmp4_);
			_tmp5_ = self->priv->_current_string;
			_tmp6_ = _tmp5_->str;
			_tmp7_ = valadoc_token_new_from_type (_tmp2_, &_tmp3_, &_tmp4_, _tmp6_);
			_tmp8_ = _tmp7_;
			valadoc_parser_accept_token (_tmp1_, _tmp8_, &_inner_error0_);
			_g_object_unref0 (_tmp8_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		} else {
			gboolean _tmp9_ = FALSE;
			GString* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->priv->_current_string;
			_tmp11_ = _tmp10_->str;
			if (g_str_has_prefix (_tmp11_, "http://")) {
				_tmp9_ = TRUE;
			} else {
				GString* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = self->priv->_current_string;
				_tmp13_ = _tmp12_->str;
				_tmp9_ = g_str_has_prefix (_tmp13_, "https://");
			}
			if (_tmp9_) {
				ValadocParser* _tmp14_;
				ValadocTokenType* _tmp15_;
				ValaSourceLocation _tmp16_ = {0};
				ValaSourceLocation _tmp17_ = {0};
				GString* _tmp18_;
				const gchar* _tmp19_;
				ValadocToken* _tmp20_;
				ValadocToken* _tmp21_;
				_tmp14_ = self->priv->parser;
				_tmp15_ = valadoc_token_type_MARKDOWN_LINK;
				valadoc_gtkdoc_markdown_scanner_get_begin (self, &_tmp16_);
				valadoc_gtkdoc_markdown_scanner_get_end (self, self->priv->_skip, &_tmp17_);
				_tmp18_ = self->priv->_current_string;
				_tmp19_ = _tmp18_->str;
				_tmp20_ = valadoc_token_new_from_type (_tmp15_, &_tmp16_, &_tmp17_, _tmp19_);
				_tmp21_ = _tmp20_;
				valadoc_parser_accept_token (_tmp14_, _tmp21_, &_inner_error0_);
				_g_object_unref0 (_tmp21_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			} else {
				ValadocParser* _tmp22_;
				GString* _tmp23_;
				const gchar* _tmp24_;
				ValaSourceLocation _tmp25_ = {0};
				ValaSourceLocation _tmp26_ = {0};
				ValadocToken* _tmp27_;
				ValadocToken* _tmp28_;
				_tmp22_ = self->priv->parser;
				_tmp23_ = self->priv->_current_string;
				_tmp24_ = _tmp23_->str;
				valadoc_gtkdoc_markdown_scanner_get_begin (self, &_tmp25_);
				valadoc_gtkdoc_markdown_scanner_get_end (self, -1, &_tmp26_);
				_tmp27_ = valadoc_token_new_from_word (_tmp24_, &_tmp25_, &_tmp26_);
				_tmp28_ = _tmp27_;
				valadoc_parser_accept_token (_tmp22_, _tmp28_, &_inner_error0_);
				_g_object_unref0 (_tmp28_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
		_tmp29_ = self->priv->_current_string;
		g_string_erase (_tmp29_, (gssize) 0, (gssize) -1);
		self->priv->contains_at = FALSE;
	}
}

static void
valadoc_gtkdoc_markdown_scanner_get_begin (ValadocGtkdocMarkdownScanner* self,
                                           ValaSourceLocation* result)
{
	const gchar* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_index;
	vala_source_location_init (&_tmp1_, _tmp0_, self->priv->_last_line, valadoc_gtkdoc_markdown_scanner_get_line_start_column (self) + self->priv->_last_column);
	*result = _tmp1_;
	return;
}

static void
valadoc_gtkdoc_markdown_scanner_get_end (ValadocGtkdocMarkdownScanner* self,
                                         gint offset,
                                         ValaSourceLocation* result)
{
	const gchar* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_index;
	vala_source_location_init (&_tmp1_, _tmp0_, self->priv->_line, (valadoc_gtkdoc_markdown_scanner_get_line_start_column (self) + self->priv->_column) + offset);
	*result = _tmp1_;
	return;
}

gint
valadoc_gtkdoc_markdown_scanner_get_line_start_column (ValadocGtkdocMarkdownScanner* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}

static void
valadoc_gtkdoc_markdown_scanner_append_char (ValadocGtkdocMarkdownScanner* self,
                                             gunichar c)
{
	GString* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_string;
	g_string_append_unichar (_tmp0_, c);
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gunichar
valadoc_gtkdoc_markdown_scanner_get_next_char (ValadocGtkdocMarkdownScanner* self,
                                               gint offset)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_index;
	_tmp1_ = self->priv->_index;
	result = string_get_char (_tmp0_, (glong) string_index_of_nth_char (_tmp1_, (glong) offset));
	return result;
}

static inline gboolean
valadoc_gtkdoc_markdown_scanner_is_mail (ValadocGtkdocMarkdownScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->contains_at) {
		GRegex* _tmp1_;
		GString* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->regex_mail;
		_tmp2_ = self->priv->_current_string;
		_tmp3_ = _tmp2_->str;
		_tmp0_ = g_regex_match (_tmp1_, _tmp3_, 0, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
valadoc_gtkdoc_markdown_scanner_is_id (ValadocGtkdocMarkdownScanner* self)
{
	GString* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GString* _tmp2_;
	const gchar* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_string;
	if (_tmp0_->len == ((gssize) 0)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_current_string;
	_tmp3_ = _tmp2_->str;
	if (g_ascii_isalpha (string_get (_tmp3_, (glong) 0)) == FALSE) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->_current_string;
		_tmp5_ = _tmp4_->str;
		_tmp1_ = string_get (_tmp5_, (glong) 0) != '_';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GString* _tmp8_;
				gboolean _tmp9_ = FALSE;
				GString* _tmp10_;
				const gchar* _tmp11_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->_current_string;
				if (!(((gssize) i) < _tmp8_->len)) {
					break;
				}
				_tmp10_ = self->priv->_current_string;
				_tmp11_ = _tmp10_->str;
				if (g_ascii_isalnum (string_get (_tmp11_, (glong) i)) == FALSE) {
					GString* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = self->priv->_current_string;
					_tmp13_ = _tmp12_->str;
					_tmp9_ = string_get (_tmp13_, (glong) i) != '_';
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static void
valadoc_gtkdoc_markdown_scanner_class_init (ValadocGtkdocMarkdownScannerClass * klass,
                                            gpointer klass_data)
{
	valadoc_gtkdoc_markdown_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocGtkdocMarkdownScanner_private_offset);
	G_OBJECT_CLASS (klass)->finalize = valadoc_gtkdoc_markdown_scanner_finalize;
}

static void
valadoc_gtkdoc_markdown_scanner_valadoc_scanner_interface_init (ValadocScannerIface * iface,
                                                                gpointer iface_data)
{
	valadoc_gtkdoc_markdown_scanner_valadoc_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_parser = (void (*) (ValadocScanner*, ValadocParser*)) valadoc_gtkdoc_markdown_scanner_real_set_parser;
	iface->reset = (void (*) (ValadocScanner*)) valadoc_gtkdoc_markdown_scanner_real_reset;
	iface->scan = (void (*) (ValadocScanner*, const gchar*, GError**)) valadoc_gtkdoc_markdown_scanner_real_scan;
	iface->end = (void (*) (ValadocScanner*, GError**)) valadoc_gtkdoc_markdown_scanner_real_end;
	iface->stop = (void (*) (ValadocScanner*)) valadoc_gtkdoc_markdown_scanner_real_stop;
	iface->get_line_content = (gchar* (*) (ValadocScanner*)) valadoc_gtkdoc_markdown_scanner_real_get_line_content;
}

static void
valadoc_gtkdoc_markdown_scanner_instance_init (ValadocGtkdocMarkdownScanner * self,
                                               gpointer klass)
{
	GString* _tmp0_;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	self->priv = valadoc_gtkdoc_markdown_scanner_get_instance_private (self);
	_tmp0_ = g_string_new ("");
	self->priv->_current_string = _tmp0_;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALADOC_GTKDOC_MARKDOWN_SCANNER_TYPE_STATE, NULL, NULL, _tmp1_);
	self->priv->states = (ValaList*) _tmp2_;
}

static void
valadoc_gtkdoc_markdown_scanner_finalize (GObject * obj)
{
	ValadocGtkdocMarkdownScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_MARKDOWN_SCANNER, ValadocGtkdocMarkdownScanner);
	_g_object_unref0 (self->priv->_settings);
	_valadoc_parser_unref0 (self->priv->parser);
	_g_string_free0 (self->priv->_current_string);
	_g_free0 (self->priv->headline_end);
	_g_regex_unref0 (self->priv->regex_mail);
	_vala_iterable_unref0 (self->priv->states);
	G_OBJECT_CLASS (valadoc_gtkdoc_markdown_scanner_parent_class)->finalize (obj);
}

static GType
valadoc_gtkdoc_markdown_scanner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocMarkdownScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_markdown_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocMarkdownScanner), 0, (GInstanceInitFunc) valadoc_gtkdoc_markdown_scanner_instance_init, NULL };
	static const GInterfaceInfo valadoc_scanner_info = { (GInterfaceInitFunc) valadoc_gtkdoc_markdown_scanner_valadoc_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType valadoc_gtkdoc_markdown_scanner_type_id;
	valadoc_gtkdoc_markdown_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocGtkdocMarkdownScanner", &g_define_type_info, 0);
	g_type_add_interface_static (valadoc_gtkdoc_markdown_scanner_type_id, VALADOC_TYPE_SCANNER, &valadoc_scanner_info);
	ValadocGtkdocMarkdownScanner_private_offset = g_type_add_instance_private (valadoc_gtkdoc_markdown_scanner_type_id, sizeof (ValadocGtkdocMarkdownScannerPrivate));
	return valadoc_gtkdoc_markdown_scanner_type_id;
}

GType
valadoc_gtkdoc_markdown_scanner_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_markdown_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_markdown_scanner_type_id__volatile)) {
		GType valadoc_gtkdoc_markdown_scanner_type_id;
		valadoc_gtkdoc_markdown_scanner_type_id = valadoc_gtkdoc_markdown_scanner_get_type_once ();
		g_once_init_leave (&valadoc_gtkdoc_markdown_scanner_type_id__volatile, valadoc_gtkdoc_markdown_scanner_type_id);
	}
	return valadoc_gtkdoc_markdown_scanner_type_id__volatile;
}

