/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp662_ = FALSE;
	gboolean _tmp663_ = FALSE;
	gboolean _tmp664_ = FALSE;
	ValaExpression* _tmp665_;
	ValaExpression* _tmp666_;
	ValaSymbol* _tmp693_;
	ValaSymbol* _tmp694_;
	ValaSymbol* _tmp763_;
	ValaSymbol* _tmp764_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp800_;
	ValaSymbol* _tmp801_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp802_;
	ValaSymbol* _tmp803_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1251_;
	ValaSymbol* _tmp1252_;
	ValaSymbol* _tmp1254_;
	ValaVersionAttribute* _tmp1255_;
	ValaVersionAttribute* _tmp1256_;
	ValaSourceReference* _tmp1257_;
	ValaSourceReference* _tmp1258_;
	gboolean _tmp1259_ = FALSE;
	ValaSymbolAccessibility _tmp1260_;
	gboolean _tmp1312_ = FALSE;
	gboolean _tmp1339_ = FALSE;
	gboolean _tmp1340_ = FALSE;
	ValaDataType* _tmp1641_;
	ValaDataType* _tmp1642_;
	gboolean _tmp1645_;
	gboolean _tmp1646_;
	gboolean _tmp1647_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		gint _type_arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_type_arg_list = _tmp8_;
		_tmp9_ = _type_arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_type_arg_size = _tmp11_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaDataType* _tmp16_;
			_type_arg_index = _type_arg_index + 1;
			_tmp12_ = _type_arg_index;
			_tmp13_ = _type_arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _type_arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp15_;
			_tmp16_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp16_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp17_);
	visited_types = _tmp18_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp19_ = self->priv->_qualified;
	if (_tmp19_) {
		ValaNamespace* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaScope* _tmp23_;
		ValaScope* _tmp24_;
		const gchar* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		_tmp20_ = vala_code_context_get_root (context);
		_tmp21_ = _tmp20_;
		base_symbol = (ValaSymbol*) _tmp21_;
		_tmp22_ = base_symbol;
		_tmp23_ = vala_symbol_get_scope (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_member_name;
		_tmp26_ = vala_scope_lookup (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
	} else {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp179_ = FALSE;
			ValaSymbol* _tmp180_;
			ValaSymbol* _tmp181_;
			_tmp30_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp30_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp31_;
				ValaSemanticAnalyzer* _tmp32_;
				_tmp31_ = vala_code_context_get_analyzer (context);
				_tmp32_ = _tmp31_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp32_)) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp34_ = _tmp33_;
					vala_report_error (_tmp34_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp35_ = vala_code_context_get_analyzer (context);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_semantic_analyzer_get_current_symbol (_tmp36_);
			_tmp38_ = _tmp37_;
			base_symbol = _tmp38_;
			method_found = FALSE;
			_tmp39_ = vala_code_context_get_analyzer (context);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_semantic_analyzer_get_current_symbol (_tmp40_);
			_tmp42_ = _tmp41_;
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp90_;
				const gchar* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaSymbol* _tmp93_;
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp132_ = FALSE;
				gboolean _tmp133_ = FALSE;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaParameter* _tmp50_;
						ValaParameter* _tmp51_;
						_tmp48_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp49_ = cm;
						_tmp50_ = vala_method_get_this_parameter ((ValaMethod*) _tmp49_);
						_tmp51_ = _tmp50_;
						this_parameter = _tmp51_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp52_;
						_tmp52_ = sym;
						if (VALA_IS_PROPERTY (_tmp52_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp53_;
							ValaProperty* _tmp54_;
							ValaParameter* _tmp55_;
							ValaParameter* _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							_tmp53_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_this_parameter (_tmp54_);
							_tmp56_ = _tmp55_;
							this_parameter = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_instance_members = _tmp59_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_klass_members = _tmp62_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp63_;
							_tmp63_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp63_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaParameter* _tmp66_;
								ValaParameter* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaMemberBinding _tmp69_;
								ValaMemberBinding _tmp70_;
								_tmp64_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_this_parameter (_tmp65_);
								_tmp67_ = _tmp66_;
								this_parameter = _tmp67_;
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_binding (_tmp68_);
								_tmp70_ = _tmp69_;
								may_access_instance_members = _tmp70_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp71_;
								_tmp71_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp71_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaParameter* _tmp74_;
									ValaParameter* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaMemberBinding _tmp77_;
									ValaMemberBinding _tmp78_;
									_tmp72_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_this_parameter (_tmp73_);
									_tmp75_ = _tmp74_;
									this_parameter = _tmp75_;
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_binding (_tmp76_);
									_tmp78_ = _tmp77_;
									may_access_instance_members = _tmp78_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp79_;
									_tmp79_ = sym;
									if (VALA_IS_METHOD (_tmp79_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp80_;
										ValaMethod* _tmp81_;
										ValaParameter* _tmp82_;
										ValaParameter* _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										_tmp80_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_METHOD, ValaMethod);
										_tmp81_ = m;
										_tmp82_ = vala_method_get_this_parameter (_tmp81_);
										_tmp83_ = _tmp82_;
										this_parameter = _tmp83_;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_klass_members = _tmp89_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp90_ = sym;
				_tmp91_ = self->priv->_member_name;
				_tmp92_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp90_, _tmp91_);
				_tmp93_ = _tmp92_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp93_);
				_vala_code_node_unref0 (_tmp93_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp96_;
					ValaSymbol* _tmp97_;
					_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp97_ = _tmp96_;
					_tmp95_ = _tmp97_ == NULL;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaSymbol* _tmp98_;
					_tmp98_ = sym;
					_tmp94_ = VALA_IS_WITH_STATEMENT (_tmp98_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp99_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp100_;
					ValaLocalVariable* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaArrayList* _tmp111_;
					ValaDataType* _tmp112_;
					ValaDataType* _tmp113_;
					const gchar* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					_tmp99_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp100_ = w;
					_tmp101_ = vala_with_statement_get_with_variable (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_variable_get_variable_type ((ValaVariable*) _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = _vala_code_node_ref0 (_tmp104_);
					variable_type = _tmp105_;
					_tmp106_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp106_)) {
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						_tmp107_ = variable_type;
						_tmp108_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp109_ = _tmp108_;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp110_;
					}
					_tmp111_ = visited_types;
					_tmp112_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp111_, _tmp112_);
					_tmp113_ = variable_type;
					_tmp114_ = self->priv->_member_name;
					_tmp115_ = vala_data_type_get_member (_tmp113_, _tmp114_);
					_tmp116_ = _tmp115_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp116_);
					_vala_code_node_unref0 (_tmp116_);
					_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp118_ = _tmp117_;
					if (_tmp118_ != NULL) {
						ValaWithStatement* _tmp119_;
						ValaLocalVariable* _tmp120_;
						ValaLocalVariable* _tmp121_;
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						ValaSourceReference* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaMemberAccess* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaExpression* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						_tmp119_ = w;
						_tmp120_ = vala_with_statement_get_with_variable (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_member_access_new (NULL, _tmp123_, _tmp125_);
						_tmp127_ = _tmp126_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp127_);
						_vala_code_node_unref0 (_tmp127_);
						_tmp128_ = vala_member_access_get_inner (self);
						_tmp129_ = _tmp128_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					_tmp133_ = VALA_IS_TYPESYMBOL (_tmp136_);
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					_tmp132_ = may_access_instance_members;
				} else {
					_tmp132_ = FALSE;
				}
				if (_tmp132_) {
					ValaParameter* _tmp137_;
					ValaDataType* _tmp138_;
					ValaDataType* _tmp139_;
					const gchar* _tmp140_;
					ValaSymbol* _tmp141_;
					ValaSymbol* _tmp142_;
					gboolean _tmp143_ = FALSE;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					_tmp137_ = this_parameter;
					_tmp138_ = vala_variable_get_variable_type ((ValaVariable*) _tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = self->priv->_member_name;
					_tmp141_ = vala_data_type_get_member (_tmp139_, _tmp140_);
					_tmp142_ = _tmp141_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp142_);
					_vala_code_node_unref0 (_tmp142_);
					_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp145_ = _tmp144_;
					if (_tmp145_ != NULL) {
						ValaSymbol* _tmp146_;
						ValaSymbol* _tmp147_;
						_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp147_ = _tmp146_;
						_tmp143_ = vala_member_access_is_instance_symbol (_tmp147_);
					} else {
						_tmp143_ = FALSE;
					}
					if (_tmp143_) {
						ValaSourceReference* _tmp148_;
						ValaSourceReference* _tmp149_;
						ValaMemberAccess* _tmp150_;
						ValaMemberAccess* _tmp151_;
						ValaExpression* _tmp152_;
						ValaExpression* _tmp153_;
						ValaParameter* _tmp154_;
						ValaDataType* _tmp155_;
						ValaDataType* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaExpression* _tmp159_;
						ValaExpression* _tmp160_;
						ValaDataType* _tmp161_;
						ValaDataType* _tmp162_;
						ValaExpression* _tmp163_;
						ValaExpression* _tmp164_;
						ValaParameter* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaDataType* _tmp168_;
						ValaDataType* _tmp169_;
						const gchar* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp149_ = _tmp148_;
						_tmp150_ = vala_member_access_new (NULL, "this", _tmp149_);
						_tmp151_ = _tmp150_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp151_);
						_vala_code_node_unref0 (_tmp151_);
						_tmp152_ = vala_member_access_get_inner (self);
						_tmp153_ = _tmp152_;
						_tmp154_ = this_parameter;
						_tmp155_ = vala_variable_get_variable_type ((ValaVariable*) _tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_data_type_copy (_tmp156_);
						_tmp158_ = _tmp157_;
						vala_expression_set_value_type (_tmp153_, _tmp158_);
						_vala_code_node_unref0 (_tmp158_);
						_tmp159_ = vala_member_access_get_inner (self);
						_tmp160_ = _tmp159_;
						_tmp161_ = vala_expression_get_value_type (_tmp160_);
						_tmp162_ = _tmp161_;
						vala_data_type_set_value_owned (_tmp162_, FALSE);
						_tmp163_ = vala_member_access_get_inner (self);
						_tmp164_ = _tmp163_;
						_tmp165_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp164_, (ValaSymbol*) _tmp165_);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = vala_expression_get_value_type (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = self->priv->_member_name;
						_tmp171_ = vala_data_type_get_member (_tmp169_, _tmp170_);
						_tmp172_ = _tmp171_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp172_);
						_vala_code_node_unref0 (_tmp172_);
					}
				}
				_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				if (_tmp174_ == NULL) {
					ValaSymbol* _tmp175_;
					_tmp175_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp175_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp176_ = sym;
				_tmp177_ = vala_symbol_get_parent_symbol (_tmp176_);
				_tmp178_ = _tmp177_;
				sym = _tmp178_;
			}
			_tmp180_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp181_ = _tmp180_;
			if (_tmp181_ == NULL) {
				ValaSourceReference* _tmp182_;
				ValaSourceReference* _tmp183_;
				_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp183_ = _tmp182_;
				_tmp179_ = _tmp183_ != NULL;
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaList* _tmp186_;
					ValaList* _tmp187_;
					gint _ns_size = 0;
					ValaList* _tmp188_;
					gint _tmp189_;
					gint _tmp190_;
					gint _ns_index = 0;
					_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp185_ = _tmp184_;
					_tmp186_ = vala_source_reference_get_using_directives (_tmp185_);
					_tmp187_ = _tmp186_;
					_ns_list = _tmp187_;
					_tmp188_ = _ns_list;
					_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
					_tmp190_ = _tmp189_;
					_ns_size = _tmp190_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp191_;
						gint _tmp192_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp193_;
						gpointer _tmp194_;
						ValaUsingDirective* _tmp195_;
						gboolean _tmp196_;
						gboolean _tmp197_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp198_;
						ValaSymbol* _tmp199_;
						ValaSymbol* _tmp200_;
						ValaScope* _tmp201_;
						ValaScope* _tmp202_;
						const gchar* _tmp203_;
						ValaSymbol* _tmp204_;
						ValaSymbol* _tmp205_;
						_ns_index = _ns_index + 1;
						_tmp191_ = _ns_index;
						_tmp192_ = _ns_size;
						if (!(_tmp191_ < _tmp192_)) {
							break;
						}
						_tmp193_ = _ns_list;
						_tmp194_ = vala_list_get (_tmp193_, _ns_index);
						ns = (ValaUsingDirective*) _tmp194_;
						_tmp195_ = ns;
						_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
						_tmp197_ = _tmp196_;
						if (_tmp197_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp198_ = ns;
						_tmp199_ = vala_using_directive_get_namespace_symbol (_tmp198_);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_symbol_get_scope (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = self->priv->_member_name;
						_tmp204_ = vala_scope_lookup (_tmp202_, _tmp203_);
						local_sym = _tmp204_;
						_tmp205_ = local_sym;
						if (_tmp205_ != NULL) {
							gboolean _tmp206_ = FALSE;
							ValaSymbol* _tmp207_;
							ValaSymbol* _tmp208_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp222_;
							ValaSymbol* _tmp223_;
							ValaSymbol* _tmp224_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp244_;
							ValaExpression* _tmp245_;
							ValaExpression* _tmp246_;
							ValaSymbol* _tmp247_;
							_tmp207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp208_ = _tmp207_;
							if (_tmp208_ != NULL) {
								ValaSymbol* _tmp209_;
								ValaSymbol* _tmp210_;
								ValaSymbol* _tmp211_;
								_tmp209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp210_ = _tmp209_;
								_tmp211_ = local_sym;
								_tmp206_ = _tmp210_ != _tmp211_;
							} else {
								_tmp206_ = FALSE;
							}
							if (_tmp206_) {
								ValaSourceReference* _tmp212_;
								ValaSourceReference* _tmp213_;
								const gchar* _tmp214_;
								ValaSymbol* _tmp215_;
								ValaSymbol* _tmp216_;
								gchar* _tmp217_;
								gchar* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = self->priv->_member_name;
								_tmp215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = vala_symbol_get_full_name (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp219_ = local_sym;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								vala_report_error (_tmp213_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp214_, _tmp218_, _tmp221_);
								_g_free0 (_tmp221_);
								_g_free0 (_tmp218_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp222_ = local_sym;
							_tmp223_ = vala_symbol_get_parent_symbol (_tmp222_);
							_tmp224_ = _tmp223_;
							inner_sym = _tmp224_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp225_ = FALSE;
								ValaSymbol* _tmp226_;
								ValaMemberAccess* _tmp230_;
								ValaSymbol* _tmp231_;
								const gchar* _tmp232_;
								const gchar* _tmp233_;
								ValaSourceReference* _tmp234_;
								ValaSourceReference* _tmp235_;
								ValaMemberAccess* _tmp236_;
								ValaMemberAccess* _tmp237_;
								ValaMemberAccess* _tmp238_;
								ValaExpression* _tmp239_;
								ValaExpression* _tmp240_;
								ValaSymbol* _tmp241_;
								ValaSymbol* _tmp242_;
								ValaSymbol* _tmp243_;
								_tmp226_ = inner_sym;
								if (_tmp226_ != NULL) {
									ValaSymbol* _tmp227_;
									const gchar* _tmp228_;
									const gchar* _tmp229_;
									_tmp227_ = inner_sym;
									_tmp228_ = vala_symbol_get_name (_tmp227_);
									_tmp229_ = _tmp228_;
									_tmp225_ = _tmp229_ != NULL;
								} else {
									_tmp225_ = FALSE;
								}
								if (!_tmp225_) {
									break;
								}
								_tmp230_ = inner_ma;
								_tmp231_ = inner_sym;
								_tmp232_ = vala_symbol_get_name (_tmp231_);
								_tmp233_ = _tmp232_;
								_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp235_ = _tmp234_;
								_tmp236_ = vala_member_access_new (NULL, _tmp233_, _tmp235_);
								_tmp237_ = _tmp236_;
								vala_member_access_set_inner (_tmp230_, (ValaExpression*) _tmp237_);
								_vala_code_node_unref0 (_tmp237_);
								_tmp238_ = inner_ma;
								_tmp239_ = vala_member_access_get_inner (_tmp238_);
								_tmp240_ = _tmp239_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp240_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp241_ = inner_sym;
								_tmp242_ = vala_symbol_get_parent_symbol (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_sym = _tmp243_;
							}
							_tmp244_ = inner_ma;
							vala_member_access_set_qualified (_tmp244_, TRUE);
							_tmp245_ = vala_member_access_get_inner (self);
							_tmp246_ = _tmp245_;
							vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
							_tmp247_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp247_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp250_;
			gboolean _tmp251_;
			ValaExpression* _tmp252_;
			ValaExpression* _tmp253_;
			ValaDataType* _tmp254_;
			ValaDataType* _tmp255_;
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			gboolean _tmp300_ = FALSE;
			ValaExpression* _tmp301_;
			ValaExpression* _tmp302_;
			gboolean _tmp309_ = FALSE;
			ValaExpression* _tmp310_;
			ValaExpression* _tmp311_;
			gboolean _tmp332_ = FALSE;
			ValaExpression* _tmp333_;
			ValaExpression* _tmp334_;
			gboolean _tmp353_ = FALSE;
			ValaSymbol* _tmp354_;
			ValaSymbol* _tmp355_;
			gboolean _tmp389_ = FALSE;
			gboolean _tmp390_ = FALSE;
			ValaSymbol* _tmp391_;
			ValaSymbol* _tmp392_;
			ValaSymbol* _tmp628_;
			ValaSymbol* _tmp629_;
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_code_node_get_error ((ValaCodeNode*) _tmp249_);
			_tmp251_ = _tmp250_;
			if (_tmp251_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp252_ = vala_member_access_get_inner (self);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_expression_get_value_type (_tmp253_);
			_tmp255_ = _tmp254_;
			if (VALA_IS_POINTER_TYPE (_tmp255_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaPointerType* _tmp261_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp259_) ? ((ValaPointerType*) _tmp259_) : NULL;
				_tmp261_ = pointer_type;
				if (_tmp261_ != NULL) {
					ValaPointerType* _tmp262_;
					ValaDataType* _tmp263_;
					ValaDataType* _tmp264_;
					_tmp262_ = pointer_type;
					_tmp263_ = vala_pointer_type_get_base_type (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp260_ = VALA_IS_VALUE_TYPE (_tmp264_);
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaExpression* _tmp265_;
					ValaExpression* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					ValaExpression* _tmp278_;
					ValaExpression* _tmp279_;
					ValaSourceReference* _tmp280_;
					ValaSourceReference* _tmp281_;
					ValaPointerIndirection* _tmp282_;
					ValaPointerIndirection* _tmp283_;
					ValaExpression* _tmp284_;
					ValaExpression* _tmp285_;
					_tmp265_ = vala_member_access_get_inner (self);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_expression_get_formal_value_type (_tmp266_);
					_tmp268_ = _tmp267_;
					if (VALA_IS_GENERIC_TYPE (_tmp268_)) {
						ValaExpression* _tmp269_;
						ValaExpression* _tmp270_;
						ValaPointerType* _tmp271_;
						ValaDataType* _tmp272_;
						ValaDataType* _tmp273_;
						ValaSourceReference* _tmp274_;
						ValaSourceReference* _tmp275_;
						ValaCastExpression* _tmp276_;
						ValaCastExpression* _tmp277_;
						_tmp269_ = vala_member_access_get_inner (self);
						_tmp270_ = _tmp269_;
						_tmp271_ = pointer_type;
						_tmp272_ = vala_data_type_copy ((ValaDataType*) _tmp271_);
						_tmp273_ = _tmp272_;
						_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_cast_expression_new (_tmp270_, _tmp273_, _tmp275_);
						_tmp277_ = _tmp276_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp277_);
						_vala_code_node_unref0 (_tmp277_);
						_vala_code_node_unref0 (_tmp273_);
					}
					_tmp278_ = vala_member_access_get_inner (self);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp281_ = _tmp280_;
					_tmp282_ = vala_pointer_indirection_new (_tmp279_, _tmp281_);
					_tmp283_ = _tmp282_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp283_);
					_vala_code_node_unref0 (_tmp283_);
					_tmp284_ = vala_member_access_get_inner (self);
					_tmp285_ = _tmp284_;
					vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp286_ = vala_member_access_get_inner (self);
			_tmp287_ = _tmp286_;
			if (VALA_IS_MEMBER_ACCESS (_tmp287_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaMemberAccess* _tmp290_;
				gboolean _tmp291_;
				_tmp288_ = vala_member_access_get_inner (self);
				_tmp289_ = _tmp288_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp290_ = ma;
				_tmp291_ = _tmp290_->priv->_prototype_access;
				if (_tmp291_) {
					ValaSourceReference* _tmp292_;
					ValaSourceReference* _tmp293_;
					ValaExpression* _tmp294_;
					ValaExpression* _tmp295_;
					ValaSymbol* _tmp296_;
					ValaSymbol* _tmp297_;
					gchar* _tmp298_;
					gchar* _tmp299_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_member_access_get_inner (self);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_expression_get_symbol_reference (_tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = vala_symbol_get_full_name (_tmp297_);
					_tmp299_ = _tmp298_;
					vala_report_error (_tmp293_, "Access to instance member `%s' denied", _tmp299_);
					_g_free0 (_tmp299_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp301_ = vala_member_access_get_inner (self);
			_tmp302_ = _tmp301_;
			if (VALA_IS_CAST_EXPRESSION (_tmp302_)) {
				ValaExpression* _tmp303_;
				ValaExpression* _tmp304_;
				gboolean _tmp305_;
				gboolean _tmp306_;
				_tmp303_ = vala_member_access_get_inner (self);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp304_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp306_ = _tmp305_;
				_tmp300_ = _tmp306_;
			} else {
				_tmp300_ = FALSE;
			}
			if (_tmp300_) {
				ValaSourceReference* _tmp307_;
				ValaSourceReference* _tmp308_;
				_tmp307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp308_ = _tmp307_;
				vala_report_warning (_tmp308_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp310_ = vala_member_access_get_inner (self);
			_tmp311_ = _tmp310_;
			if (VALA_IS_MEMBER_ACCESS (_tmp311_)) {
				_tmp309_ = TRUE;
			} else {
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp309_ = VALA_IS_BASE_ACCESS (_tmp313_);
			}
			if (_tmp309_) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaSymbol* _tmp316_;
				ValaSymbol* _tmp317_;
				gboolean _tmp318_ = FALSE;
				ValaSymbol* _tmp319_;
				ValaSymbol* _tmp320_;
				_tmp314_ = vala_member_access_get_inner (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_expression_get_symbol_reference (_tmp315_);
				_tmp317_ = _tmp316_;
				base_symbol = _tmp317_;
				_tmp319_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp320_ = _tmp319_;
				if (_tmp320_ == NULL) {
					gboolean _tmp321_ = FALSE;
					ValaSymbol* _tmp322_;
					_tmp322_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp322_)) {
						_tmp321_ = TRUE;
					} else {
						ValaSymbol* _tmp323_;
						_tmp323_ = base_symbol;
						_tmp321_ = VALA_IS_TYPESYMBOL (_tmp323_);
					}
					_tmp318_ = _tmp321_;
				} else {
					_tmp318_ = FALSE;
				}
				if (_tmp318_) {
					ValaSymbol* _tmp324_;
					ValaScope* _tmp325_;
					ValaScope* _tmp326_;
					const gchar* _tmp327_;
					ValaSymbol* _tmp328_;
					ValaSymbol* _tmp329_;
					ValaExpression* _tmp330_;
					ValaExpression* _tmp331_;
					_tmp324_ = base_symbol;
					_tmp325_ = vala_symbol_get_scope (_tmp324_);
					_tmp326_ = _tmp325_;
					_tmp327_ = self->priv->_member_name;
					_tmp328_ = vala_scope_lookup (_tmp326_, _tmp327_);
					_tmp329_ = _tmp328_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp329_);
					_vala_code_node_unref0 (_tmp329_);
					_tmp330_ = vala_member_access_get_inner (self);
					_tmp331_ = _tmp330_;
					if (VALA_IS_BASE_ACCESS (_tmp331_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp333_ = vala_member_access_get_inner (self);
			_tmp334_ = _tmp333_;
			if (VALA_IS_MEMBER_ACCESS (_tmp334_)) {
				ValaExpression* _tmp335_;
				ValaExpression* _tmp336_;
				ValaSymbol* _tmp337_;
				ValaSymbol* _tmp338_;
				_tmp335_ = vala_member_access_get_inner (self);
				_tmp336_ = _tmp335_;
				_tmp337_ = vala_expression_get_symbol_reference (_tmp336_);
				_tmp338_ = _tmp337_;
				_tmp332_ = VALA_IS_TYPEPARAMETER (_tmp338_);
			} else {
				_tmp332_ = FALSE;
			}
			if (_tmp332_) {
				ValaExpression* _tmp339_;
				ValaExpression* _tmp340_;
				ValaExpression* _tmp341_;
				ValaExpression* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaSymbol* _tmp344_;
				ValaGenericType* _tmp345_;
				ValaGenericType* _tmp346_;
				ValaExpression* _tmp347_;
				ValaExpression* _tmp348_;
				ValaDataType* _tmp349_;
				ValaDataType* _tmp350_;
				ValaSourceReference* _tmp351_;
				ValaSourceReference* _tmp352_;
				_tmp339_ = vala_member_access_get_inner (self);
				_tmp340_ = _tmp339_;
				_tmp341_ = vala_member_access_get_inner (self);
				_tmp342_ = _tmp341_;
				_tmp343_ = vala_expression_get_symbol_reference (_tmp342_);
				_tmp344_ = _tmp343_;
				_tmp345_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp344_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp346_ = _tmp345_;
				vala_expression_set_value_type (_tmp340_, (ValaDataType*) _tmp346_);
				_vala_code_node_unref0 (_tmp346_);
				_tmp347_ = vala_member_access_get_inner (self);
				_tmp348_ = _tmp347_;
				_tmp349_ = vala_expression_get_value_type (_tmp348_);
				_tmp350_ = _tmp349_;
				_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp352_ = _tmp351_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp350_, _tmp352_);
			}
			_tmp354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp355_ = _tmp354_;
			if (_tmp355_ == NULL) {
				ValaExpression* _tmp356_;
				ValaExpression* _tmp357_;
				ValaDataType* _tmp358_;
				ValaDataType* _tmp359_;
				_tmp356_ = vala_member_access_get_inner (self);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_expression_get_value_type (_tmp357_);
				_tmp359_ = _tmp358_;
				_tmp353_ = _tmp359_ != NULL;
			} else {
				_tmp353_ = FALSE;
			}
			if (_tmp353_) {
				gboolean _tmp360_;
				ValaSymbol* _tmp387_;
				ValaSymbol* _tmp388_;
				_tmp360_ = self->priv->_pointer_member_access;
				if (_tmp360_) {
					ValaExpression* _tmp361_;
					ValaExpression* _tmp362_;
					ValaDataType* _tmp363_;
					ValaDataType* _tmp364_;
					const gchar* _tmp365_;
					ValaSymbol* _tmp366_;
					ValaSymbol* _tmp367_;
					_tmp361_ = vala_member_access_get_inner (self);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_expression_get_value_type (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = self->priv->_member_name;
					_tmp366_ = vala_data_type_get_pointer_member (_tmp364_, _tmp365_);
					_tmp367_ = _tmp366_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp367_);
					_vala_code_node_unref0 (_tmp367_);
				} else {
					ValaExpression* _tmp368_;
					ValaExpression* _tmp369_;
					ValaDataType* _tmp370_;
					ValaDataType* _tmp371_;
					ValaTypeSymbol* _tmp372_;
					ValaTypeSymbol* _tmp373_;
					ValaExpression* _tmp380_;
					ValaExpression* _tmp381_;
					ValaDataType* _tmp382_;
					ValaDataType* _tmp383_;
					const gchar* _tmp384_;
					ValaSymbol* _tmp385_;
					ValaSymbol* _tmp386_;
					_tmp368_ = vala_member_access_get_inner (self);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_expression_get_value_type (_tmp369_);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_data_type_get_type_symbol (_tmp371_);
					_tmp373_ = _tmp372_;
					if (_tmp373_ != NULL) {
						ValaExpression* _tmp374_;
						ValaExpression* _tmp375_;
						ValaDataType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaTypeSymbol* _tmp378_;
						ValaTypeSymbol* _tmp379_;
						_tmp374_ = vala_member_access_get_inner (self);
						_tmp375_ = _tmp374_;
						_tmp376_ = vala_expression_get_value_type (_tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_data_type_get_type_symbol (_tmp377_);
						_tmp379_ = _tmp378_;
						base_symbol = (ValaSymbol*) _tmp379_;
					}
					_tmp380_ = vala_member_access_get_inner (self);
					_tmp381_ = _tmp380_;
					_tmp382_ = vala_expression_get_value_type (_tmp381_);
					_tmp383_ = _tmp382_;
					_tmp384_ = self->priv->_member_name;
					_tmp385_ = vala_data_type_get_member (_tmp383_, _tmp384_);
					_tmp386_ = _tmp385_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp386_);
					_vala_code_node_unref0 (_tmp386_);
				}
				_tmp387_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp388_ = _tmp387_;
				if (_tmp388_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp391_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp392_ = _tmp391_;
			if (_tmp392_ == NULL) {
				ValaExpression* _tmp393_;
				ValaExpression* _tmp394_;
				ValaDataType* _tmp395_;
				ValaDataType* _tmp396_;
				_tmp393_ = vala_member_access_get_inner (self);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_expression_get_value_type (_tmp394_);
				_tmp396_ = _tmp395_;
				_tmp390_ = _tmp396_ != NULL;
			} else {
				_tmp390_ = FALSE;
			}
			if (_tmp390_) {
				ValaExpression* _tmp397_;
				ValaExpression* _tmp398_;
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				gboolean _tmp401_;
				gboolean _tmp402_;
				_tmp397_ = vala_member_access_get_inner (self);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_expression_get_value_type (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_data_type_get_is_dynamic (_tmp400_);
				_tmp402_ = _tmp401_;
				_tmp389_ = _tmp402_;
			} else {
				_tmp389_ = FALSE;
			}
			if (_tmp389_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp403_;
				ValaExpression* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				ValaObjectType* _tmp407_;
				ValaCodeNode* _tmp408_;
				ValaCodeNode* _tmp409_;
				ValaSymbol* _tmp576_;
				ValaSymbol* _tmp577_;
				ValaSymbol* _tmp626_;
				ValaSymbol* _tmp627_;
				_tmp403_ = vala_member_access_get_inner (self);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_expression_get_value_type (_tmp404_);
				_tmp406_ = _tmp405_;
				_tmp407_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp406_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp407_;
				_tmp408_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp409_ = _tmp408_;
				if (VALA_IS_METHOD_CALL (_tmp409_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp410_;
					ValaCodeNode* _tmp411_;
					ValaMethodCall* _tmp412_;
					ValaExpression* _tmp413_;
					ValaExpression* _tmp414_;
					_tmp410_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp411_ = _tmp410_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp412_ = invoc;
					_tmp413_ = vala_method_call_get_call (_tmp412_);
					_tmp414_ = _tmp413_;
					if (_tmp414_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp415_;
						ValaDataType* _tmp416_;
						ValaDataType* _tmp417_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp432_;
						ValaExpression* _tmp433_;
						ValaDataType* _tmp434_;
						ValaDataType* _tmp435_;
						const gchar* _tmp436_;
						ValaDataType* _tmp437_;
						ValaSourceReference* _tmp438_;
						ValaSourceReference* _tmp439_;
						ValaDynamicMethod* _tmp440_;
						ValaDynamicMethod* _tmp441_;
						ValaMethodCall* _tmp442_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp443_;
						ValaSourceReference* _tmp444_;
						ValaSourceReference* _tmp445_;
						ValaErrorType* _tmp446_;
						ValaErrorType* _tmp447_;
						ValaDynamicMethod* _tmp448_;
						ValaErrorType* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaParameter* _tmp452_;
						ValaParameter* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaObjectType* _tmp455_;
						ValaDataType* _tmp456_;
						ValaDataType* _tmp457_;
						ValaDynamicMethod* _tmp458_;
						ValaSourceReference* _tmp459_;
						ValaSourceReference* _tmp460_;
						ValaParameter* _tmp461_;
						ValaParameter* _tmp462_;
						ValaObjectType* _tmp463_;
						ValaTypeSymbol* _tmp464_;
						ValaTypeSymbol* _tmp465_;
						ValaScope* _tmp466_;
						ValaScope* _tmp467_;
						ValaDynamicMethod* _tmp468_;
						ValaDynamicMethod* _tmp469_;
						_tmp415_ = invoc;
						_tmp416_ = vala_expression_get_target_type ((ValaExpression*) _tmp415_);
						_tmp417_ = _tmp416_;
						if (_tmp417_ != NULL) {
							ValaMethodCall* _tmp418_;
							ValaDataType* _tmp419_;
							ValaDataType* _tmp420_;
							ValaDataType* _tmp421_;
							ValaDataType* _tmp422_;
							_tmp418_ = invoc;
							_tmp419_ = vala_expression_get_target_type ((ValaExpression*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = vala_data_type_copy (_tmp420_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp421_;
							_tmp422_ = ret_type;
							vala_data_type_set_value_owned (_tmp422_, TRUE);
						} else {
							ValaMethodCall* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaCodeNode* _tmp425_;
							_tmp423_ = invoc;
							_tmp424_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp423_);
							_tmp425_ = _tmp424_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp425_)) {
								ValaVoidType* _tmp426_;
								_tmp426_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp426_;
							} else {
								ValaExpression* _tmp427_;
								ValaExpression* _tmp428_;
								ValaDataType* _tmp429_;
								ValaDataType* _tmp430_;
								ValaDataType* _tmp431_;
								_tmp427_ = vala_member_access_get_inner (self);
								_tmp428_ = _tmp427_;
								_tmp429_ = vala_expression_get_value_type (_tmp428_);
								_tmp430_ = _tmp429_;
								_tmp431_ = vala_data_type_copy (_tmp430_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp431_;
							}
						}
						_tmp432_ = vala_member_access_get_inner (self);
						_tmp433_ = _tmp432_;
						_tmp434_ = vala_expression_get_value_type (_tmp433_);
						_tmp435_ = _tmp434_;
						_tmp436_ = self->priv->_member_name;
						_tmp437_ = ret_type;
						_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp439_ = _tmp438_;
						_tmp440_ = vala_dynamic_method_new (_tmp435_, _tmp436_, _tmp437_, _tmp439_, NULL);
						m = _tmp440_;
						_tmp441_ = m;
						_tmp442_ = invoc;
						vala_dynamic_method_set_invocation (_tmp441_, _tmp442_);
						_tmp443_ = m;
						_tmp444_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp443_);
						_tmp445_ = _tmp444_;
						_tmp446_ = vala_error_type_new (NULL, NULL, _tmp445_);
						err = _tmp446_;
						_tmp447_ = err;
						vala_error_type_set_dynamic_error (_tmp447_, TRUE);
						_tmp448_ = m;
						_tmp449_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp448_, (ValaDataType*) _tmp449_);
						_tmp450_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp450_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp451_ = m;
						_tmp452_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp453_ = _tmp452_;
						vala_callable_add_parameter ((ValaCallable*) _tmp451_, _tmp453_);
						_vala_code_node_unref0 (_tmp453_);
						_tmp454_ = m;
						_tmp455_ = dynamic_object_type;
						_tmp456_ = vala_data_type_copy ((ValaDataType*) _tmp455_);
						_tmp457_ = _tmp456_;
						_tmp458_ = m;
						_tmp459_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp458_);
						_tmp460_ = _tmp459_;
						_tmp461_ = vala_parameter_new ("this", _tmp457_, _tmp460_);
						_tmp462_ = _tmp461_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp454_, _tmp462_);
						_vala_code_node_unref0 (_tmp462_);
						_vala_code_node_unref0 (_tmp457_);
						_tmp463_ = dynamic_object_type;
						_tmp464_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp463_);
						_tmp465_ = _tmp464_;
						_tmp466_ = vala_symbol_get_scope ((ValaSymbol*) _tmp465_);
						_tmp467_ = _tmp466_;
						_tmp468_ = m;
						vala_scope_add (_tmp467_, NULL, (ValaSymbol*) _tmp468_);
						_tmp469_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp469_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp470_;
					ValaCodeNode* _tmp471_;
					_tmp470_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp471_ = _tmp470_;
					if (VALA_IS_ASSIGNMENT (_tmp471_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp472_;
						ValaCodeNode* _tmp473_;
						ValaAssignment* _tmp474_;
						ValaExpression* _tmp475_;
						ValaExpression* _tmp476_;
						_tmp472_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp473_ = _tmp472_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp473_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp474_ = a;
						_tmp475_ = vala_assignment_get_left (_tmp474_);
						_tmp476_ = _tmp475_;
						if (_tmp476_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp477_;
							ValaExpression* _tmp478_;
							ValaDataType* _tmp479_;
							ValaDataType* _tmp480_;
							const gchar* _tmp481_;
							ValaSourceReference* _tmp482_;
							ValaSourceReference* _tmp483_;
							ValaDynamicProperty* _tmp484_;
							ValaDynamicProperty* _tmp485_;
							ValaDynamicProperty* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaSourceReference* _tmp488_;
							ValaSourceReference* _tmp489_;
							ValaPropertyAccessor* _tmp490_;
							ValaPropertyAccessor* _tmp491_;
							ValaDynamicProperty* _tmp492_;
							ValaExpression* _tmp493_;
							ValaExpression* _tmp494_;
							ValaDataType* _tmp495_;
							ValaDataType* _tmp496_;
							ValaTypeSymbol* _tmp497_;
							ValaTypeSymbol* _tmp498_;
							ValaScope* _tmp499_;
							ValaScope* _tmp500_;
							ValaObjectType* _tmp501_;
							ValaTypeSymbol* _tmp502_;
							ValaTypeSymbol* _tmp503_;
							ValaScope* _tmp504_;
							ValaScope* _tmp505_;
							ValaDynamicProperty* _tmp506_;
							ValaDynamicProperty* _tmp507_;
							_tmp477_ = vala_member_access_get_inner (self);
							_tmp478_ = _tmp477_;
							_tmp479_ = vala_expression_get_value_type (_tmp478_);
							_tmp480_ = _tmp479_;
							_tmp481_ = self->priv->_member_name;
							_tmp482_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp483_ = _tmp482_;
							_tmp484_ = vala_dynamic_property_new (_tmp480_, _tmp481_, _tmp483_, NULL);
							prop = _tmp484_;
							_tmp485_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp485_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp486_ = prop;
							_tmp487_ = prop;
							_tmp488_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp487_);
							_tmp489_ = _tmp488_;
							_tmp490_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp489_, NULL);
							_tmp491_ = _tmp490_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp486_, _tmp491_);
							_vala_code_node_unref0 (_tmp491_);
							_tmp492_ = prop;
							_tmp493_ = vala_member_access_get_inner (self);
							_tmp494_ = _tmp493_;
							_tmp495_ = vala_expression_get_value_type (_tmp494_);
							_tmp496_ = _tmp495_;
							_tmp497_ = vala_data_type_get_type_symbol (_tmp496_);
							_tmp498_ = _tmp497_;
							_tmp499_ = vala_symbol_get_scope ((ValaSymbol*) _tmp498_);
							_tmp500_ = _tmp499_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp492_, _tmp500_);
							_tmp501_ = dynamic_object_type;
							_tmp502_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp501_);
							_tmp503_ = _tmp502_;
							_tmp504_ = vala_symbol_get_scope ((ValaSymbol*) _tmp503_);
							_tmp505_ = _tmp504_;
							_tmp506_ = prop;
							vala_scope_add (_tmp505_, NULL, (ValaSymbol*) _tmp506_);
							_tmp507_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp507_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp508_ = FALSE;
						gboolean _tmp509_ = FALSE;
						ValaCodeNode* _tmp510_;
						ValaCodeNode* _tmp511_;
						_tmp510_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp511_ = _tmp510_;
						if (VALA_IS_MEMBER_ACCESS (_tmp511_)) {
							ValaExpression* _tmp512_;
							ValaExpression* _tmp513_;
							_tmp512_ = vala_member_access_get_inner (self);
							_tmp513_ = _tmp512_;
							_tmp509_ = VALA_IS_MEMBER_ACCESS (_tmp513_);
						} else {
							_tmp509_ = FALSE;
						}
						if (_tmp509_) {
							ValaCodeNode* _tmp514_;
							ValaCodeNode* _tmp515_;
							ValaCodeNode* _tmp516_;
							ValaCodeNode* _tmp517_;
							_tmp514_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp515_ = _tmp514_;
							_tmp516_ = vala_code_node_get_parent_node (_tmp515_);
							_tmp517_ = _tmp516_;
							_tmp508_ = VALA_IS_METHOD_CALL (_tmp517_);
						} else {
							_tmp508_ = FALSE;
						}
						if (_tmp508_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp518_;
							ValaCodeNode* _tmp519_;
							gboolean _tmp520_ = FALSE;
							ValaMemberAccess* _tmp521_;
							const gchar* _tmp522_;
							_tmp518_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp519_ = _tmp518_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp519_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp521_ = ma;
							_tmp522_ = _tmp521_->priv->_member_name;
							if (g_strcmp0 (_tmp522_, "connect") == 0) {
								_tmp520_ = TRUE;
							} else {
								ValaMemberAccess* _tmp523_;
								const gchar* _tmp524_;
								_tmp523_ = ma;
								_tmp524_ = _tmp523_->priv->_member_name;
								_tmp520_ = g_strcmp0 (_tmp524_, "connect_after") == 0;
							}
							if (_tmp520_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp525_;
								ValaExpression* _tmp526_;
								ValaDataType* _tmp527_;
								ValaDataType* _tmp528_;
								const gchar* _tmp529_;
								ValaVoidType* _tmp530_;
								ValaVoidType* _tmp531_;
								ValaSourceReference* _tmp532_;
								ValaSourceReference* _tmp533_;
								ValaDynamicSignal* _tmp534_;
								ValaDynamicSignal* _tmp535_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp536_;
								ValaCodeNode* _tmp537_;
								ValaCodeNode* _tmp538_;
								ValaCodeNode* _tmp539_;
								ValaMethodCall* _tmp540_;
								ValaMethodCall* _tmp541_;
								ValaList* _tmp542_;
								gint _tmp543_;
								gint _tmp544_;
								ValaDynamicSignal* _tmp568_;
								ValaObjectType* _tmp569_;
								ValaTypeSymbol* _tmp570_;
								ValaTypeSymbol* _tmp571_;
								ValaScope* _tmp572_;
								ValaScope* _tmp573_;
								ValaDynamicSignal* _tmp574_;
								ValaDynamicSignal* _tmp575_;
								_tmp525_ = vala_member_access_get_inner (self);
								_tmp526_ = _tmp525_;
								_tmp527_ = vala_expression_get_value_type (_tmp526_);
								_tmp528_ = _tmp527_;
								_tmp529_ = self->priv->_member_name;
								_tmp530_ = vala_void_type_new (NULL);
								_tmp531_ = _tmp530_;
								_tmp532_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp533_ = _tmp532_;
								_tmp534_ = vala_dynamic_signal_new (_tmp528_, _tmp529_, (ValaDataType*) _tmp531_, _tmp533_, NULL);
								_tmp535_ = _tmp534_;
								_vala_code_node_unref0 (_tmp531_);
								s = _tmp535_;
								_tmp536_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp537_ = _tmp536_;
								_tmp538_ = vala_code_node_get_parent_node (_tmp537_);
								_tmp539_ = _tmp538_;
								_tmp540_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp539_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp540_;
								_tmp541_ = mcall;
								_tmp542_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp541_);
								_tmp543_ = vala_collection_get_size ((ValaCollection*) _tmp542_);
								_tmp544_ = _tmp543_;
								if (_tmp544_ > 0) {
									ValaDynamicSignal* _tmp545_;
									ValaMethodCall* _tmp546_;
									ValaList* _tmp547_;
									gpointer _tmp548_;
									ValaExpression* _tmp549_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp550_;
									ValaExpression* _tmp551_;
									ValaExpression* _tmp552_;
									gboolean _tmp553_ = FALSE;
									gboolean _tmp554_ = FALSE;
									ValaMemberAccess* _tmp555_;
									_tmp545_ = s;
									_tmp546_ = mcall;
									_tmp547_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp546_);
									_tmp548_ = vala_list_get (_tmp547_, 0);
									_tmp549_ = (ValaExpression*) _tmp548_;
									vala_dynamic_signal_set_handler (_tmp545_, _tmp549_);
									_vala_code_node_unref0 (_tmp549_);
									_tmp550_ = s;
									_tmp551_ = vala_dynamic_signal_get_handler (_tmp550_);
									_tmp552_ = _tmp551_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp552_) ? ((ValaMemberAccess*) _tmp552_) : NULL;
									_tmp555_ = arg;
									if (_tmp555_ == NULL) {
										_tmp554_ = TRUE;
									} else {
										ValaMemberAccess* _tmp556_;
										_tmp556_ = arg;
										_tmp554_ = !vala_code_node_check ((ValaCodeNode*) _tmp556_, context);
									}
									if (_tmp554_) {
										_tmp553_ = TRUE;
									} else {
										ValaMemberAccess* _tmp557_;
										ValaSymbol* _tmp558_;
										ValaSymbol* _tmp559_;
										_tmp557_ = arg;
										_tmp558_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp557_);
										_tmp559_ = _tmp558_;
										_tmp553_ = !VALA_IS_METHOD (_tmp559_);
									}
									if (_tmp553_) {
										ValaDynamicSignal* _tmp560_;
										ValaExpression* _tmp561_;
										ValaExpression* _tmp562_;
										ValaSourceReference* _tmp563_;
										ValaSourceReference* _tmp564_;
										ValaDynamicSignal* _tmp565_;
										gchar* _tmp566_;
										gchar* _tmp567_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp560_ = s;
										_tmp561_ = vala_dynamic_signal_get_handler (_tmp560_);
										_tmp562_ = _tmp561_;
										_tmp563_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp562_);
										_tmp564_ = _tmp563_;
										_tmp565_ = s;
										_tmp566_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp565_);
										_tmp567_ = _tmp566_;
										vala_report_error (_tmp564_, "Invalid handler for `%s'", _tmp567_);
										_g_free0 (_tmp567_);
									}
								}
								_tmp568_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp568_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp569_ = dynamic_object_type;
								_tmp570_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp569_);
								_tmp571_ = _tmp570_;
								_tmp572_ = vala_symbol_get_scope ((ValaSymbol*) _tmp571_);
								_tmp573_ = _tmp572_;
								_tmp574_ = s;
								vala_scope_add (_tmp573_, NULL, (ValaSymbol*) _tmp574_);
								_tmp575_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp575_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp576_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp577_ = _tmp576_;
				if (_tmp577_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp578_;
					ValaExpression* _tmp579_;
					ValaDataType* _tmp580_;
					ValaDataType* _tmp581_;
					const gchar* _tmp582_;
					ValaSourceReference* _tmp583_;
					ValaSourceReference* _tmp584_;
					ValaDynamicProperty* _tmp585_;
					ValaDataType* _tmp586_;
					ValaDataType* _tmp587_;
					ValaDynamicProperty* _tmp598_;
					ValaDynamicProperty* _tmp599_;
					ValaDynamicProperty* _tmp600_;
					ValaDataType* _tmp601_;
					ValaDataType* _tmp602_;
					ValaDataType* _tmp603_;
					ValaDataType* _tmp604_;
					ValaDynamicProperty* _tmp605_;
					ValaSourceReference* _tmp606_;
					ValaSourceReference* _tmp607_;
					ValaPropertyAccessor* _tmp608_;
					ValaPropertyAccessor* _tmp609_;
					ValaDynamicProperty* _tmp610_;
					ValaExpression* _tmp611_;
					ValaExpression* _tmp612_;
					ValaDataType* _tmp613_;
					ValaDataType* _tmp614_;
					ValaTypeSymbol* _tmp615_;
					ValaTypeSymbol* _tmp616_;
					ValaScope* _tmp617_;
					ValaScope* _tmp618_;
					ValaObjectType* _tmp619_;
					ValaTypeSymbol* _tmp620_;
					ValaTypeSymbol* _tmp621_;
					ValaScope* _tmp622_;
					ValaScope* _tmp623_;
					ValaDynamicProperty* _tmp624_;
					ValaDynamicProperty* _tmp625_;
					_tmp578_ = vala_member_access_get_inner (self);
					_tmp579_ = _tmp578_;
					_tmp580_ = vala_expression_get_value_type (_tmp579_);
					_tmp581_ = _tmp580_;
					_tmp582_ = self->priv->_member_name;
					_tmp583_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp584_ = _tmp583_;
					_tmp585_ = vala_dynamic_property_new (_tmp581_, _tmp582_, _tmp584_, NULL);
					prop = _tmp585_;
					_tmp586_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp587_ = _tmp586_;
					if (_tmp587_ != NULL) {
						ValaDynamicProperty* _tmp588_;
						ValaDataType* _tmp589_;
						ValaDataType* _tmp590_;
						_tmp588_ = prop;
						_tmp589_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp590_ = _tmp589_;
						vala_property_set_property_type ((ValaProperty*) _tmp588_, _tmp590_);
					} else {
						ValaDynamicProperty* _tmp591_;
						ValaExpression* _tmp592_;
						ValaExpression* _tmp593_;
						ValaDataType* _tmp594_;
						ValaDataType* _tmp595_;
						ValaDataType* _tmp596_;
						ValaDataType* _tmp597_;
						_tmp591_ = prop;
						_tmp592_ = vala_member_access_get_inner (self);
						_tmp593_ = _tmp592_;
						_tmp594_ = vala_expression_get_value_type (_tmp593_);
						_tmp595_ = _tmp594_;
						_tmp596_ = vala_data_type_copy (_tmp595_);
						_tmp597_ = _tmp596_;
						vala_property_set_property_type ((ValaProperty*) _tmp591_, _tmp597_);
						_vala_code_node_unref0 (_tmp597_);
					}
					_tmp598_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp598_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp599_ = prop;
					_tmp600_ = prop;
					_tmp601_ = vala_property_get_property_type ((ValaProperty*) _tmp600_);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_data_type_copy (_tmp602_);
					_tmp604_ = _tmp603_;
					_tmp605_ = prop;
					_tmp606_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp605_);
					_tmp607_ = _tmp606_;
					_tmp608_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp604_, NULL, _tmp607_, NULL);
					_tmp609_ = _tmp608_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp599_, _tmp609_);
					_vala_code_node_unref0 (_tmp609_);
					_vala_code_node_unref0 (_tmp604_);
					_tmp610_ = prop;
					_tmp611_ = vala_member_access_get_inner (self);
					_tmp612_ = _tmp611_;
					_tmp613_ = vala_expression_get_value_type (_tmp612_);
					_tmp614_ = _tmp613_;
					_tmp615_ = vala_data_type_get_type_symbol (_tmp614_);
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_symbol_get_scope ((ValaSymbol*) _tmp616_);
					_tmp618_ = _tmp617_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp610_, _tmp618_);
					_tmp619_ = dynamic_object_type;
					_tmp620_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp619_);
					_tmp621_ = _tmp620_;
					_tmp622_ = vala_symbol_get_scope ((ValaSymbol*) _tmp621_);
					_tmp623_ = _tmp622_;
					_tmp624_ = prop;
					vala_scope_add (_tmp623_, NULL, (ValaSymbol*) _tmp624_);
					_tmp625_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp625_);
					_vala_code_node_unref0 (prop);
				}
				_tmp626_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp627_ = _tmp626_;
				if (_tmp627_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp628_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp629_ = _tmp628_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp629_)) {
				ValaExpression* _tmp630_;
				ValaExpression* _tmp631_;
				ValaSymbol* _tmp632_;
				ValaSymbol* _tmp633_;
				_tmp630_ = vala_member_access_get_inner (self);
				_tmp631_ = _tmp630_;
				_tmp632_ = vala_expression_get_symbol_reference (_tmp631_);
				_tmp633_ = _tmp632_;
				if (VALA_IS_VARIABLE (_tmp633_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp634_;
					ValaSemanticAnalyzer* _tmp635_;
					ValaExpression* _tmp636_;
					ValaExpression* _tmp637_;
					ValaSymbol* _tmp638_;
					ValaSymbol* _tmp639_;
					ValaDataType* _tmp640_;
					ValaArrayType* _tmp641_;
					gboolean _tmp642_ = FALSE;
					ValaArrayType* _tmp643_;
					_tmp634_ = vala_code_context_get_analyzer (context);
					_tmp635_ = _tmp634_;
					_tmp636_ = vala_member_access_get_inner (self);
					_tmp637_ = _tmp636_;
					_tmp638_ = vala_expression_get_symbol_reference (_tmp637_);
					_tmp639_ = _tmp638_;
					_tmp640_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp635_, _tmp639_, TRUE);
					_tmp641_ = VALA_IS_ARRAY_TYPE (_tmp640_) ? ((ValaArrayType*) _tmp640_) : NULL;
					if (_tmp641_ == NULL) {
						_vala_code_node_unref0 (_tmp640_);
					}
					inner_type = _tmp641_;
					_tmp643_ = inner_type;
					if (_tmp643_ != NULL) {
						ValaArrayType* _tmp644_;
						gboolean _tmp645_;
						gboolean _tmp646_;
						_tmp644_ = inner_type;
						_tmp645_ = vala_array_type_get_inline_allocated (_tmp644_);
						_tmp646_ = _tmp645_;
						_tmp642_ = _tmp646_;
					} else {
						_tmp642_ = FALSE;
					}
					if (_tmp642_) {
						ValaSourceReference* _tmp647_;
						ValaSourceReference* _tmp648_;
						_tmp647_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp648_ = _tmp647_;
						vala_report_error (_tmp648_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp649_ = FALSE;
						ValaArrayType* _tmp650_;
						_tmp650_ = inner_type;
						if (_tmp650_ != NULL) {
							ValaArrayType* _tmp651_;
							gboolean _tmp652_;
							gboolean _tmp653_;
							_tmp651_ = inner_type;
							_tmp652_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp651_);
							_tmp653_ = _tmp652_;
							_tmp649_ = !_tmp653_;
						} else {
							_tmp649_ = FALSE;
						}
						if (_tmp649_) {
							ValaSourceReference* _tmp654_;
							ValaSourceReference* _tmp655_;
							_tmp654_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp655_ = _tmp654_;
							vala_report_error (_tmp655_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp656_;
					ValaExpression* _tmp657_;
					ValaSymbol* _tmp658_;
					ValaSymbol* _tmp659_;
					_tmp656_ = vala_member_access_get_inner (self);
					_tmp657_ = _tmp656_;
					_tmp658_ = vala_expression_get_symbol_reference (_tmp657_);
					_tmp659_ = _tmp658_;
					if (VALA_IS_CONSTANT (_tmp659_)) {
						ValaSourceReference* _tmp660_;
						ValaSourceReference* _tmp661_;
						_tmp660_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp661_ = _tmp660_;
						vala_report_error (_tmp661_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp665_ = vala_member_access_get_inner (self);
	_tmp666_ = _tmp665_;
	if (_tmp666_ == NULL) {
		ValaSymbol* _tmp667_;
		ValaSymbol* _tmp668_;
		_tmp667_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp668_ = _tmp667_;
		_tmp664_ = _tmp668_ == NULL;
	} else {
		_tmp664_ = FALSE;
	}
	if (_tmp664_) {
		ValaDataType* _tmp669_;
		ValaDataType* _tmp670_;
		_tmp669_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp670_ = _tmp669_;
		_tmp663_ = _tmp670_ != NULL;
	} else {
		_tmp663_ = FALSE;
	}
	if (_tmp663_) {
		ValaDataType* _tmp671_;
		ValaDataType* _tmp672_;
		ValaTypeSymbol* _tmp673_;
		ValaTypeSymbol* _tmp674_;
		_tmp671_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp672_ = _tmp671_;
		_tmp673_ = vala_data_type_get_type_symbol (_tmp672_);
		_tmp674_ = _tmp673_;
		_tmp662_ = VALA_IS_ENUM (_tmp674_);
	} else {
		_tmp662_ = FALSE;
	}
	if (_tmp662_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp675_;
		ValaDataType* _tmp676_;
		ValaTypeSymbol* _tmp677_;
		ValaTypeSymbol* _tmp678_;
		_tmp675_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp676_ = _tmp675_;
		_tmp677_ = vala_data_type_get_type_symbol (_tmp676_);
		_tmp678_ = _tmp677_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp678_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp679_;
			ValaList* _tmp680_;
			gint _val_size = 0;
			ValaList* _tmp681_;
			gint _tmp682_;
			gint _tmp683_;
			gint _val_index = 0;
			_tmp679_ = enum_type;
			_tmp680_ = vala_enum_get_values (_tmp679_);
			_val_list = _tmp680_;
			_tmp681_ = _val_list;
			_tmp682_ = vala_collection_get_size ((ValaCollection*) _tmp681_);
			_tmp683_ = _tmp682_;
			_val_size = _tmp683_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp684_;
				gint _tmp685_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp686_;
				gpointer _tmp687_;
				const gchar* _tmp688_;
				ValaEnumValue* _tmp689_;
				const gchar* _tmp690_;
				const gchar* _tmp691_;
				_val_index = _val_index + 1;
				_tmp684_ = _val_index;
				_tmp685_ = _val_size;
				if (!(_tmp684_ < _tmp685_)) {
					break;
				}
				_tmp686_ = _val_list;
				_tmp687_ = vala_list_get (_tmp686_, _val_index);
				val = (ValaEnumValue*) _tmp687_;
				_tmp688_ = self->priv->_member_name;
				_tmp689_ = val;
				_tmp690_ = vala_symbol_get_name ((ValaSymbol*) _tmp689_);
				_tmp691_ = _tmp690_;
				if (g_strcmp0 (_tmp688_, _tmp691_) == 0) {
					ValaEnumValue* _tmp692_;
					_tmp692_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp692_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp693_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp694_ = _tmp693_;
	if (_tmp694_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp695_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp696_ = FALSE;
		ValaExpression* _tmp697_;
		ValaExpression* _tmp698_;
		gchar* base_type_package = NULL;
		gchar* _tmp718_;
		gboolean _tmp719_ = FALSE;
		ValaSymbol* _tmp720_;
		gchar* visited_types_string = NULL;
		gchar* _tmp735_;
		ValaSourceReference* _tmp751_;
		ValaSourceReference* _tmp752_;
		const gchar* _tmp753_;
		const gchar* _tmp754_;
		const gchar* _tmp755_;
		const gchar* _tmp756_;
		ValaInvalidType* _tmp757_;
		ValaInvalidType* _tmp758_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp695_ = g_strdup ("(null)");
		base_type_name = _tmp695_;
		base_type = NULL;
		_tmp697_ = vala_member_access_get_inner (self);
		_tmp698_ = _tmp697_;
		if (_tmp698_ != NULL) {
			ValaExpression* _tmp699_;
			ValaExpression* _tmp700_;
			ValaDataType* _tmp701_;
			ValaDataType* _tmp702_;
			_tmp699_ = vala_member_access_get_inner (self);
			_tmp700_ = _tmp699_;
			_tmp701_ = vala_expression_get_value_type (_tmp700_);
			_tmp702_ = _tmp701_;
			_tmp696_ = _tmp702_ != NULL;
		} else {
			_tmp696_ = FALSE;
		}
		if (_tmp696_) {
			ValaExpression* _tmp703_;
			ValaExpression* _tmp704_;
			ValaDataType* _tmp705_;
			ValaDataType* _tmp706_;
			gchar* _tmp707_;
			ValaExpression* _tmp708_;
			ValaExpression* _tmp709_;
			ValaDataType* _tmp710_;
			ValaDataType* _tmp711_;
			ValaTypeSymbol* _tmp712_;
			ValaTypeSymbol* _tmp713_;
			_tmp703_ = vala_member_access_get_inner (self);
			_tmp704_ = _tmp703_;
			_tmp705_ = vala_expression_get_value_type (_tmp704_);
			_tmp706_ = _tmp705_;
			_tmp707_ = vala_code_node_to_string ((ValaCodeNode*) _tmp706_);
			_g_free0 (base_type_name);
			base_type_name = _tmp707_;
			_tmp708_ = vala_member_access_get_inner (self);
			_tmp709_ = _tmp708_;
			_tmp710_ = vala_expression_get_value_type (_tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = vala_data_type_get_type_symbol (_tmp711_);
			_tmp713_ = _tmp712_;
			base_type = (ValaSymbol*) _tmp713_;
		} else {
			ValaSymbol* _tmp714_;
			_tmp714_ = base_symbol;
			if (_tmp714_ != NULL) {
				ValaSymbol* _tmp715_;
				gchar* _tmp716_;
				ValaSymbol* _tmp717_;
				_tmp715_ = base_symbol;
				_tmp716_ = vala_symbol_get_full_name (_tmp715_);
				_g_free0 (base_type_name);
				base_type_name = _tmp716_;
				_tmp717_ = base_symbol;
				base_type = _tmp717_;
			}
		}
		_tmp718_ = g_strdup ("");
		base_type_package = _tmp718_;
		_tmp720_ = base_type;
		if (_tmp720_ != NULL) {
			ValaSymbol* _tmp721_;
			gboolean _tmp722_;
			gboolean _tmp723_;
			_tmp721_ = base_type;
			_tmp722_ = vala_symbol_get_external_package (_tmp721_);
			_tmp723_ = _tmp722_;
			_tmp719_ = _tmp723_;
		} else {
			_tmp719_ = FALSE;
		}
		if (_tmp719_) {
			ValaSymbol* _tmp724_;
			ValaSourceReference* _tmp725_;
			ValaSourceReference* _tmp726_;
			ValaSourceFile* _tmp727_;
			ValaSourceFile* _tmp728_;
			const gchar* _tmp729_;
			const gchar* _tmp730_;
			gchar* _tmp731_;
			const gchar* _tmp732_;
			_tmp724_ = base_symbol;
			_tmp725_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp724_);
			_tmp726_ = _tmp725_;
			_tmp727_ = vala_source_reference_get_file (_tmp726_);
			_tmp728_ = _tmp727_;
			_tmp729_ = vala_source_file_get_package_name (_tmp728_);
			_tmp730_ = _tmp729_;
			_tmp731_ = g_strdup (_tmp730_);
			_g_free0 (base_type_package);
			base_type_package = _tmp731_;
			_tmp732_ = base_type_package;
			if (_tmp732_ != NULL) {
				const gchar* _tmp733_;
				gchar* _tmp734_;
				_tmp733_ = base_type_package;
				_tmp734_ = g_strdup_printf (" (%s)", _tmp733_);
				_g_free0 (base_type_package);
				base_type_package = _tmp734_;
			}
		}
		_tmp735_ = g_strdup ("");
		visited_types_string = _tmp735_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp736_;
			gint _type_size = 0;
			ValaArrayList* _tmp737_;
			gint _tmp738_;
			gint _tmp739_;
			gint _type_index = 0;
			_tmp736_ = visited_types;
			_type_list = _tmp736_;
			_tmp737_ = _type_list;
			_tmp738_ = vala_collection_get_size ((ValaCollection*) _tmp737_);
			_tmp739_ = _tmp738_;
			_type_size = _tmp739_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp740_;
				gint _tmp741_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp742_;
				gpointer _tmp743_;
				const gchar* _tmp744_;
				ValaDataType* _tmp745_;
				gchar* _tmp746_;
				gchar* _tmp747_;
				gchar* _tmp748_;
				gchar* _tmp749_;
				gchar* _tmp750_;
				_type_index = _type_index + 1;
				_tmp740_ = _type_index;
				_tmp741_ = _type_size;
				if (!(_tmp740_ < _tmp741_)) {
					break;
				}
				_tmp742_ = _type_list;
				_tmp743_ = vala_list_get ((ValaList*) _tmp742_, _type_index);
				type = (ValaDataType*) _tmp743_;
				_tmp744_ = visited_types_string;
				_tmp745_ = type;
				_tmp746_ = vala_code_node_to_string ((ValaCodeNode*) _tmp745_);
				_tmp747_ = _tmp746_;
				_tmp748_ = g_strdup_printf (" or `%s'", _tmp747_);
				_tmp749_ = _tmp748_;
				_tmp750_ = g_strconcat (_tmp744_, _tmp749_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp750_;
				_g_free0 (_tmp749_);
				_g_free0 (_tmp747_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp751_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp752_ = _tmp751_;
		_tmp753_ = self->priv->_member_name;
		_tmp754_ = base_type_name;
		_tmp755_ = base_type_package;
		_tmp756_ = visited_types_string;
		vala_report_error (_tmp752_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp753_, _tmp754_, _tmp755_, _tmp756_);
		_tmp757_ = vala_invalid_type_new ();
		_tmp758_ = _tmp757_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp758_);
		_vala_code_node_unref0 (_tmp758_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp759_;
		ValaSymbol* _tmp760_;
		gboolean _tmp761_;
		gboolean _tmp762_;
		_tmp759_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp760_ = _tmp759_;
		_tmp761_ = vala_code_node_get_error ((ValaCodeNode*) _tmp760_);
		_tmp762_ = _tmp761_;
		if (_tmp762_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp763_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp764_ = _tmp763_;
	if (VALA_IS_SIGNAL (_tmp764_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp765_;
		ValaSymbol* _tmp766_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp773_;
		ValaCodeNode* _tmp774_;
		ValaCodeNode* _tmp775_;
		gboolean _tmp776_ = FALSE;
		gboolean _tmp777_ = FALSE;
		gboolean _tmp778_ = FALSE;
		ValaCodeNode* _tmp779_;
		_tmp765_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp766_ = _tmp765_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp766_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp767_;
			ValaCodeNode* _tmp768_;
			ValaCodeNode* _tmp769_;
			ValaCodeNode* _tmp770_;
			ValaCodeNode* _tmp771_;
			ValaCodeNode* _tmp772_;
			_tmp767_ = ma;
			_tmp768_ = vala_code_node_get_parent_node (_tmp767_);
			_tmp769_ = _tmp768_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp769_)) {
				break;
			}
			_tmp770_ = ma;
			_tmp771_ = vala_code_node_get_parent_node (_tmp770_);
			_tmp772_ = _tmp771_;
			ma = _tmp772_;
		}
		_tmp773_ = ma;
		_tmp774_ = vala_code_node_get_parent_node (_tmp773_);
		_tmp775_ = _tmp774_;
		parent = _tmp775_;
		_tmp779_ = parent;
		if (_tmp779_ != NULL) {
			ValaCodeNode* _tmp780_;
			_tmp780_ = parent;
			_tmp778_ = !VALA_IS_ELEMENT_ACCESS (_tmp780_);
		} else {
			_tmp778_ = FALSE;
		}
		if (_tmp778_) {
			ValaCodeNode* _tmp781_;
			ValaExpression* _tmp782_;
			ValaExpression* _tmp783_;
			_tmp781_ = ma;
			_tmp782_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp781_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp783_ = _tmp782_;
			_tmp777_ = !VALA_IS_BASE_ACCESS (_tmp783_);
		} else {
			_tmp777_ = FALSE;
		}
		if (_tmp777_) {
			gboolean _tmp784_ = FALSE;
			ValaCodeNode* _tmp785_;
			_tmp785_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp785_)) {
				_tmp784_ = TRUE;
			} else {
				ValaCodeNode* _tmp786_;
				ValaList* _tmp787_;
				_tmp786_ = parent;
				_tmp787_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp786_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp784_ = vala_collection_contains ((ValaCollection*) _tmp787_, (ValaExpression*) self);
			}
			_tmp776_ = _tmp784_;
		} else {
			_tmp776_ = FALSE;
		}
		if (_tmp776_) {
			ValaSignal* _tmp788_;
			ValaAttribute* _tmp789_;
			_tmp788_ = sig;
			_tmp789_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp788_, "HasEmitter");
			if (_tmp789_ != NULL) {
				ValaSignal* _tmp790_;
				ValaSignal* _tmp791_;
				ValaMethod* _tmp792_;
				ValaMethod* _tmp793_;
				_tmp790_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp790_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp791_ = sig;
				_tmp792_ = vala_signal_get_emitter (_tmp791_);
				_tmp793_ = _tmp792_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp793_);
			} else {
				ValaSourceReference* _tmp794_;
				ValaSourceReference* _tmp795_;
				ValaSymbol* _tmp796_;
				ValaSymbol* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp794_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp795_ = _tmp794_;
				_tmp796_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_symbol_get_full_name (_tmp797_);
				_tmp799_ = _tmp798_;
				vala_report_error (_tmp795_, "Signal `%s' requires emitter in this context", _tmp799_);
				_g_free0 (_tmp799_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp800_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp801_ = _tmp800_;
	member = _tmp801_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp802_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp802_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp803_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp803_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp804_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp805_;
		ValaSymbol* _tmp806_;
		ValaSymbol* _tmp807_;
		gboolean _tmp808_ = FALSE;
		ValaBlock* _tmp809_;
		_tmp804_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp804_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp805_ = local;
		_tmp806_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp805_);
		_tmp807_ = _tmp806_;
		block = VALA_IS_BLOCK (_tmp807_) ? ((ValaBlock*) _tmp807_) : NULL;
		_tmp809_ = block;
		if (_tmp809_ != NULL) {
			ValaBlock* _tmp810_;
			ValaSymbol* _tmp811_;
			ValaSemanticAnalyzer* _tmp812_;
			ValaSemanticAnalyzer* _tmp813_;
			ValaSymbol* _tmp814_;
			ValaSymbol* _tmp815_;
			_tmp810_ = block;
			_tmp811_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp810_);
			_tmp812_ = vala_code_context_get_analyzer (context);
			_tmp813_ = _tmp812_;
			_tmp814_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp813_);
			_tmp815_ = _tmp814_;
			_tmp808_ = _tmp811_ != _tmp815_;
		} else {
			_tmp808_ = FALSE;
		}
		if (_tmp808_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp816_;
			ValaSemanticAnalyzer* _tmp817_;
			ValaSymbol* _tmp818_;
			ValaSymbol* _tmp819_;
			ValaLocalVariable* _tmp830_;
			ValaBlock* _tmp831_;
			ValaLocalVariable* _tmp832_;
			ValaDataType* _tmp833_;
			ValaDataType* _tmp834_;
			ValaTypeSymbol* _tmp835_;
			ValaTypeSymbol* _tmp836_;
			ValaSemanticAnalyzer* _tmp837_;
			ValaSemanticAnalyzer* _tmp838_;
			ValaDataType* _tmp839_;
			ValaTypeSymbol* _tmp840_;
			ValaTypeSymbol* _tmp841_;
			_tmp816_ = vala_code_context_get_analyzer (context);
			_tmp817_ = _tmp816_;
			_tmp818_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp817_);
			_tmp819_ = _tmp818_;
			sym = _tmp819_;
			while (TRUE) {
				ValaSymbol* _tmp820_;
				ValaBlock* _tmp821_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp822_;
				ValaMethod* _tmp823_;
				ValaSymbol* _tmp827_;
				ValaSymbol* _tmp828_;
				ValaSymbol* _tmp829_;
				_tmp820_ = sym;
				_tmp821_ = block;
				if (!(_tmp820_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp821_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp822_ = sym;
				method = VALA_IS_METHOD (_tmp822_) ? ((ValaMethod*) _tmp822_) : NULL;
				_tmp823_ = method;
				if (_tmp823_ != NULL) {
					ValaMethod* _tmp824_;
					ValaMethod* _tmp825_;
					ValaLocalVariable* _tmp826_;
					_tmp824_ = method;
					vala_method_set_closure (_tmp824_, TRUE);
					_tmp825_ = method;
					_tmp826_ = local;
					vala_method_add_captured_variable (_tmp825_, _tmp826_);
				}
				_tmp827_ = sym;
				_tmp828_ = vala_symbol_get_parent_symbol (_tmp827_);
				_tmp829_ = _tmp828_;
				sym = _tmp829_;
			}
			_tmp830_ = local;
			vala_local_variable_set_captured (_tmp830_, TRUE);
			_tmp831_ = block;
			vala_block_set_captured (_tmp831_, TRUE);
			_tmp832_ = local;
			_tmp833_ = vala_variable_get_variable_type ((ValaVariable*) _tmp832_);
			_tmp834_ = _tmp833_;
			_tmp835_ = vala_data_type_get_type_symbol (_tmp834_);
			_tmp836_ = _tmp835_;
			_tmp837_ = vala_code_context_get_analyzer (context);
			_tmp838_ = _tmp837_;
			_tmp839_ = _tmp838_->va_list_type;
			_tmp840_ = vala_data_type_get_type_symbol (_tmp839_);
			_tmp841_ = _tmp840_;
			if (_tmp836_ == _tmp841_) {
				ValaSourceReference* _tmp842_;
				ValaSourceReference* _tmp843_;
				ValaLocalVariable* _tmp844_;
				gchar* _tmp845_;
				gchar* _tmp846_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp842_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp843_ = _tmp842_;
				_tmp844_ = local;
				_tmp845_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp844_);
				_tmp846_ = _tmp845_;
				vala_report_error (_tmp843_, "Capturing `va_list' variable `%s' is not allowed", _tmp846_);
				_g_free0 (_tmp846_);
			}
		}
	} else {
		ValaSymbol* _tmp847_;
		_tmp847_ = member;
		if (VALA_IS_PARAMETER (_tmp847_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp848_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp849_;
			ValaSymbol* _tmp850_;
			ValaSymbol* _tmp851_;
			gboolean _tmp852_ = FALSE;
			gboolean _tmp853_ = FALSE;
			ValaMethod* _tmp854_;
			_tmp848_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp848_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp849_ = param;
			_tmp850_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp849_);
			_tmp851_ = _tmp850_;
			m = VALA_IS_METHOD (_tmp851_) ? ((ValaMethod*) _tmp851_) : NULL;
			_tmp854_ = m;
			if (_tmp854_ != NULL) {
				ValaMethod* _tmp855_;
				ValaSemanticAnalyzer* _tmp856_;
				ValaSemanticAnalyzer* _tmp857_;
				ValaSymbol* _tmp858_;
				ValaSymbol* _tmp859_;
				_tmp855_ = m;
				_tmp856_ = vala_code_context_get_analyzer (context);
				_tmp857_ = _tmp856_;
				_tmp858_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp857_);
				_tmp859_ = _tmp858_;
				_tmp853_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp855_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp859_;
			} else {
				_tmp853_ = FALSE;
			}
			if (_tmp853_) {
				ValaParameter* _tmp860_;
				ValaMethod* _tmp861_;
				ValaParameter* _tmp862_;
				ValaParameter* _tmp863_;
				_tmp860_ = param;
				_tmp861_ = m;
				_tmp862_ = vala_method_get_this_parameter (_tmp861_);
				_tmp863_ = _tmp862_;
				_tmp852_ = _tmp860_ != _tmp863_;
			} else {
				_tmp852_ = FALSE;
			}
			if (_tmp852_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp864_;
				ValaSemanticAnalyzer* _tmp865_;
				ValaSymbol* _tmp866_;
				ValaSymbol* _tmp867_;
				ValaParameter* _tmp876_;
				ValaMethod* _tmp877_;
				ValaBlock* _tmp878_;
				ValaBlock* _tmp879_;
				ValaParameter* _tmp880_;
				ValaParameterDirection _tmp881_;
				ValaParameterDirection _tmp882_;
				ValaParameter* _tmp888_;
				ValaDataType* _tmp889_;
				ValaDataType* _tmp890_;
				ValaTypeSymbol* _tmp891_;
				ValaTypeSymbol* _tmp892_;
				ValaSemanticAnalyzer* _tmp893_;
				ValaSemanticAnalyzer* _tmp894_;
				ValaDataType* _tmp895_;
				ValaTypeSymbol* _tmp896_;
				ValaTypeSymbol* _tmp897_;
				_tmp864_ = vala_code_context_get_analyzer (context);
				_tmp865_ = _tmp864_;
				_tmp866_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp865_);
				_tmp867_ = _tmp866_;
				sym = _tmp867_;
				while (TRUE) {
					ValaSymbol* _tmp868_;
					ValaMethod* _tmp869_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp870_;
					ValaMethod* _tmp871_;
					ValaSymbol* _tmp873_;
					ValaSymbol* _tmp874_;
					ValaSymbol* _tmp875_;
					_tmp868_ = sym;
					_tmp869_ = m;
					if (!(_tmp868_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp869_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp870_ = sym;
					method = VALA_IS_METHOD (_tmp870_) ? ((ValaMethod*) _tmp870_) : NULL;
					_tmp871_ = method;
					if (_tmp871_ != NULL) {
						ValaMethod* _tmp872_;
						_tmp872_ = method;
						vala_method_set_closure (_tmp872_, TRUE);
					}
					_tmp873_ = sym;
					_tmp874_ = vala_symbol_get_parent_symbol (_tmp873_);
					_tmp875_ = _tmp874_;
					sym = _tmp875_;
				}
				_tmp876_ = param;
				vala_parameter_set_captured (_tmp876_, TRUE);
				_tmp877_ = m;
				_tmp878_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp877_);
				_tmp879_ = _tmp878_;
				vala_block_set_captured (_tmp879_, TRUE);
				_tmp880_ = param;
				_tmp881_ = vala_parameter_get_direction (_tmp880_);
				_tmp882_ = _tmp881_;
				if (_tmp882_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp883_;
					ValaSourceReference* _tmp884_;
					ValaParameter* _tmp885_;
					gchar* _tmp886_;
					gchar* _tmp887_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp883_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp884_ = _tmp883_;
					_tmp885_ = param;
					_tmp886_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp885_);
					_tmp887_ = _tmp886_;
					vala_report_error (_tmp884_, "Cannot capture reference or output parameter `%s'", _tmp887_);
					_g_free0 (_tmp887_);
				}
				_tmp888_ = param;
				_tmp889_ = vala_variable_get_variable_type ((ValaVariable*) _tmp888_);
				_tmp890_ = _tmp889_;
				_tmp891_ = vala_data_type_get_type_symbol (_tmp890_);
				_tmp892_ = _tmp891_;
				_tmp893_ = vala_code_context_get_analyzer (context);
				_tmp894_ = _tmp893_;
				_tmp895_ = _tmp894_->va_list_type;
				_tmp896_ = vala_data_type_get_type_symbol (_tmp895_);
				_tmp897_ = _tmp896_;
				if (_tmp892_ == _tmp897_) {
					ValaSourceReference* _tmp898_;
					ValaSourceReference* _tmp899_;
					ValaParameter* _tmp900_;
					gchar* _tmp901_;
					gchar* _tmp902_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp898_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp899_ = _tmp898_;
					_tmp900_ = param;
					_tmp901_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp900_);
					_tmp902_ = _tmp901_;
					vala_report_error (_tmp899_, "Capturing `va_list' parameter `%s' is not allowed", _tmp902_);
					_g_free0 (_tmp902_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp903_;
				ValaSymbol* _tmp904_;
				ValaSymbol* _tmp905_;
				ValaSymbol* _tmp906_;
				ValaSymbol* _tmp907_;
				gboolean _tmp908_ = FALSE;
				gboolean _tmp909_ = FALSE;
				ValaPropertyAccessor* _tmp910_;
				_tmp903_ = param;
				_tmp904_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp903_);
				_tmp905_ = _tmp904_;
				_tmp906_ = vala_symbol_get_parent_symbol (_tmp905_);
				_tmp907_ = _tmp906_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp907_) ? ((ValaPropertyAccessor*) _tmp907_) : NULL;
				_tmp910_ = acc;
				if (_tmp910_ != NULL) {
					ValaPropertyAccessor* _tmp911_;
					ValaSemanticAnalyzer* _tmp912_;
					ValaSemanticAnalyzer* _tmp913_;
					ValaSymbol* _tmp914_;
					ValaSymbol* _tmp915_;
					_tmp911_ = acc;
					_tmp912_ = vala_code_context_get_analyzer (context);
					_tmp913_ = _tmp912_;
					_tmp914_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp913_);
					_tmp915_ = _tmp914_;
					_tmp909_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp911_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp915_;
				} else {
					_tmp909_ = FALSE;
				}
				if (_tmp909_) {
					ValaParameter* _tmp916_;
					ValaPropertyAccessor* _tmp917_;
					ValaProperty* _tmp918_;
					ValaProperty* _tmp919_;
					ValaParameter* _tmp920_;
					ValaParameter* _tmp921_;
					_tmp916_ = param;
					_tmp917_ = acc;
					_tmp918_ = vala_property_accessor_get_prop (_tmp917_);
					_tmp919_ = _tmp918_;
					_tmp920_ = vala_property_get_this_parameter (_tmp919_);
					_tmp921_ = _tmp920_;
					_tmp908_ = _tmp916_ != _tmp921_;
				} else {
					_tmp908_ = FALSE;
				}
				if (_tmp908_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp922_;
					ValaSemanticAnalyzer* _tmp923_;
					ValaSymbol* _tmp924_;
					ValaSymbol* _tmp925_;
					ValaParameter* _tmp934_;
					ValaPropertyAccessor* _tmp935_;
					ValaBlock* _tmp936_;
					ValaBlock* _tmp937_;
					_tmp922_ = vala_code_context_get_analyzer (context);
					_tmp923_ = _tmp922_;
					_tmp924_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp923_);
					_tmp925_ = _tmp924_;
					sym = _tmp925_;
					while (TRUE) {
						ValaSymbol* _tmp926_;
						ValaMethod* _tmp927_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp928_;
						ValaMethod* _tmp929_;
						ValaSymbol* _tmp931_;
						ValaSymbol* _tmp932_;
						ValaSymbol* _tmp933_;
						_tmp926_ = sym;
						_tmp927_ = m;
						if (!(_tmp926_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp927_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp928_ = sym;
						method = VALA_IS_METHOD (_tmp928_) ? ((ValaMethod*) _tmp928_) : NULL;
						_tmp929_ = method;
						if (_tmp929_ != NULL) {
							ValaMethod* _tmp930_;
							_tmp930_ = method;
							vala_method_set_closure (_tmp930_, TRUE);
						}
						_tmp931_ = sym;
						_tmp932_ = vala_symbol_get_parent_symbol (_tmp931_);
						_tmp933_ = _tmp932_;
						sym = _tmp933_;
					}
					_tmp934_ = param;
					vala_parameter_set_captured (_tmp934_, TRUE);
					_tmp935_ = acc;
					_tmp936_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp935_);
					_tmp937_ = _tmp936_;
					vala_block_set_captured (_tmp937_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp938_;
			_tmp938_ = member;
			if (VALA_IS_FIELD (_tmp938_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp939_;
				ValaField* _tmp940_;
				ValaSymbolAccessibility _tmp941_;
				ValaSymbolAccessibility _tmp942_;
				ValaField* _tmp943_;
				ValaMemberBinding _tmp944_;
				ValaMemberBinding _tmp945_;
				ValaField* _tmp946_;
				ValaMemberBinding _tmp947_;
				ValaMemberBinding _tmp948_;
				ValaField* _tmp949_;
				ValaDataType* _tmp950_;
				ValaDataType* _tmp951_;
				_tmp939_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp939_, VALA_TYPE_FIELD, ValaField);
				_tmp940_ = f;
				_tmp941_ = vala_symbol_get_access ((ValaSymbol*) _tmp940_);
				_tmp942_ = _tmp941_;
				access = _tmp942_;
				_tmp943_ = f;
				_tmp944_ = vala_field_get_binding (_tmp943_);
				_tmp945_ = _tmp944_;
				instance = _tmp945_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp946_ = f;
				_tmp947_ = vala_field_get_binding (_tmp946_);
				_tmp948_ = _tmp947_;
				klass = _tmp948_ == VALA_MEMBER_BINDING_CLASS;
				_tmp949_ = f;
				_tmp950_ = vala_variable_get_variable_type ((ValaVariable*) _tmp949_);
				_tmp951_ = _tmp950_;
				if (VALA_IS_GENERIC_TYPE (_tmp951_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp952_;
				_tmp952_ = member;
				if (VALA_IS_CONSTANT (_tmp952_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp953_;
					ValaConstant* _tmp954_;
					ValaSymbolAccessibility _tmp955_;
					ValaSymbolAccessibility _tmp956_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp957_;
					ValaSymbol* _tmp958_;
					ValaSymbol* _tmp959_;
					gboolean _tmp960_ = FALSE;
					ValaBlock* _tmp961_;
					_tmp953_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp953_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp954_ = c;
					_tmp955_ = vala_symbol_get_access ((ValaSymbol*) _tmp954_);
					_tmp956_ = _tmp955_;
					access = _tmp956_;
					_tmp957_ = c;
					_tmp958_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp957_);
					_tmp959_ = _tmp958_;
					block = VALA_IS_BLOCK (_tmp959_) ? ((ValaBlock*) _tmp959_) : NULL;
					_tmp961_ = block;
					if (_tmp961_ != NULL) {
						ValaBlock* _tmp962_;
						ValaSymbol* _tmp963_;
						ValaSemanticAnalyzer* _tmp964_;
						ValaSemanticAnalyzer* _tmp965_;
						ValaSymbol* _tmp966_;
						ValaSymbol* _tmp967_;
						_tmp962_ = block;
						_tmp963_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp962_);
						_tmp964_ = vala_code_context_get_analyzer (context);
						_tmp965_ = _tmp964_;
						_tmp966_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp965_);
						_tmp967_ = _tmp966_;
						_tmp960_ = _tmp963_ != _tmp967_;
					} else {
						_tmp960_ = FALSE;
					}
					if (_tmp960_) {
						ValaSourceReference* _tmp968_;
						ValaSourceReference* _tmp969_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp968_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp969_ = _tmp968_;
						vala_report_error (_tmp969_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp970_;
					_tmp970_ = member;
					if (VALA_IS_METHOD (_tmp970_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp971_;
						ValaMethod* _tmp972_;
						gboolean _tmp973_;
						gboolean _tmp974_;
						ValaMethod* _tmp1061_;
						ValaSymbolAccessibility _tmp1062_;
						ValaSymbolAccessibility _tmp1063_;
						ValaMethod* _tmp1064_;
						ValaMethod* _tmp1068_;
						ValaMemberBinding _tmp1069_;
						ValaMemberBinding _tmp1070_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1090_;
						ValaDataType* _tmp1091_;
						ValaDataType* _tmp1092_;
						gboolean _tmp1093_ = FALSE;
						ValaGenericType* _tmp1094_;
						_tmp971_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp971_, VALA_TYPE_METHOD, ValaMethod);
						_tmp972_ = m;
						_tmp973_ = vala_method_get_is_async_callback (_tmp972_);
						_tmp974_ = _tmp973_;
						if (_tmp974_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp975_;
							ValaSemanticAnalyzer* _tmp976_;
							ValaMethod* _tmp977_;
							ValaMethod* _tmp978_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp979_;
							ValaMethod* _tmp1006_;
							ValaSemanticAnalyzer* _tmp1007_;
							ValaSemanticAnalyzer* _tmp1008_;
							ValaMethod* _tmp1009_;
							ValaMethod* _tmp1010_;
							ValaMethod* _tmp1026_;
							ValaMethod* _tmp1027_;
							ValaMethod* _tmp1028_;
							ValaSymbol* _tmp1029_;
							ValaSymbol* _tmp1030_;
							_tmp975_ = vala_code_context_get_analyzer (context);
							_tmp976_ = _tmp975_;
							_tmp977_ = vala_semantic_analyzer_get_current_async_method (_tmp976_);
							_tmp978_ = _tmp977_;
							async_method = _tmp978_;
							is_valid_access = FALSE;
							_tmp979_ = async_method;
							if (_tmp979_ != NULL) {
								ValaMethod* _tmp980_;
								ValaMethod* _tmp981_;
								ValaMethod* _tmp982_;
								_tmp980_ = m;
								_tmp981_ = async_method;
								_tmp982_ = vala_method_get_callback_method (_tmp981_);
								if (_tmp980_ == _tmp982_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp983_ = FALSE;
									ValaMethod* _tmp984_;
									ValaMethod* _tmp985_;
									ValaMethod* _tmp986_;
									_tmp984_ = async_method;
									_tmp985_ = vala_method_get_base_method (_tmp984_);
									_tmp986_ = _tmp985_;
									if (_tmp986_ != NULL) {
										ValaMethod* _tmp987_;
										ValaMethod* _tmp988_;
										ValaMethod* _tmp989_;
										ValaMethod* _tmp990_;
										ValaMethod* _tmp991_;
										_tmp987_ = m;
										_tmp988_ = async_method;
										_tmp989_ = vala_method_get_base_method (_tmp988_);
										_tmp990_ = _tmp989_;
										_tmp991_ = vala_method_get_callback_method (_tmp990_);
										_tmp983_ = _tmp987_ == _tmp991_;
									} else {
										_tmp983_ = FALSE;
									}
									if (_tmp983_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp992_ = FALSE;
										ValaMethod* _tmp993_;
										ValaMethod* _tmp994_;
										ValaMethod* _tmp995_;
										_tmp993_ = async_method;
										_tmp994_ = vala_method_get_base_interface_method (_tmp993_);
										_tmp995_ = _tmp994_;
										if (_tmp995_ != NULL) {
											ValaMethod* _tmp996_;
											ValaMethod* _tmp997_;
											ValaMethod* _tmp998_;
											ValaMethod* _tmp999_;
											ValaMethod* _tmp1000_;
											_tmp996_ = m;
											_tmp997_ = async_method;
											_tmp998_ = vala_method_get_base_interface_method (_tmp997_);
											_tmp999_ = _tmp998_;
											_tmp1000_ = vala_method_get_callback_method (_tmp999_);
											_tmp992_ = _tmp996_ == _tmp1000_;
										} else {
											_tmp992_ = FALSE;
										}
										if (_tmp992_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1001_;
								ValaSourceReference* _tmp1002_;
								ValaMethod* _tmp1003_;
								gchar* _tmp1004_;
								gchar* _tmp1005_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1001_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1002_ = _tmp1001_;
								_tmp1003_ = m;
								_tmp1004_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1003_);
								_tmp1005_ = _tmp1004_;
								vala_report_error (_tmp1002_, "Access to async callback `%s' not allowed in this context", _tmp1005_);
								_g_free0 (_tmp1005_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1006_ = async_method;
							_tmp1007_ = vala_code_context_get_analyzer (context);
							_tmp1008_ = _tmp1007_;
							_tmp1009_ = vala_semantic_analyzer_get_current_method (_tmp1008_);
							_tmp1010_ = _tmp1009_;
							if (_tmp1006_ != _tmp1010_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1011_;
								ValaSemanticAnalyzer* _tmp1012_;
								ValaMethod* _tmp1013_;
								ValaMethod* _tmp1014_;
								ValaMethod* _tmp1023_;
								ValaBlock* _tmp1024_;
								ValaBlock* _tmp1025_;
								_tmp1011_ = vala_code_context_get_analyzer (context);
								_tmp1012_ = _tmp1011_;
								_tmp1013_ = vala_semantic_analyzer_get_current_method (_tmp1012_);
								_tmp1014_ = _tmp1013_;
								sym = (ValaSymbol*) _tmp1014_;
								while (TRUE) {
									ValaSymbol* _tmp1015_;
									ValaMethod* _tmp1016_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1017_;
									ValaMethod* _tmp1018_;
									ValaSymbol* _tmp1020_;
									ValaSymbol* _tmp1021_;
									ValaSymbol* _tmp1022_;
									_tmp1015_ = sym;
									_tmp1016_ = async_method;
									if (!(_tmp1015_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1016_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1017_ = sym;
									method = VALA_IS_METHOD (_tmp1017_) ? ((ValaMethod*) _tmp1017_) : NULL;
									_tmp1018_ = method;
									if (_tmp1018_ != NULL) {
										ValaMethod* _tmp1019_;
										_tmp1019_ = method;
										vala_method_set_closure (_tmp1019_, TRUE);
									}
									_tmp1020_ = sym;
									_tmp1021_ = vala_symbol_get_parent_symbol (_tmp1020_);
									_tmp1022_ = _tmp1021_;
									sym = _tmp1022_;
								}
								_tmp1023_ = async_method;
								_tmp1024_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1023_);
								_tmp1025_ = _tmp1024_;
								vala_block_set_captured (_tmp1025_, TRUE);
							}
							_tmp1026_ = async_method;
							_tmp1027_ = vala_method_get_callback_method (_tmp1026_);
							m = _tmp1027_;
							_tmp1028_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1028_);
							_tmp1029_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1030_ = _tmp1029_;
							member = _tmp1030_;
						} else {
							ValaMethod* _tmp1031_;
							ValaMethod* _tmp1032_;
							ValaMethod* _tmp1033_;
							_tmp1031_ = m;
							_tmp1032_ = vala_method_get_base_method (_tmp1031_);
							_tmp1033_ = _tmp1032_;
							if (_tmp1033_ != NULL) {
								ValaMethod* _tmp1034_;
								ValaMethod* _tmp1035_;
								ValaMethod* _tmp1036_;
								ValaMethod* _tmp1037_;
								ValaSignal* _tmp1038_;
								ValaSignal* _tmp1039_;
								ValaSymbol* _tmp1044_;
								ValaSymbol* _tmp1045_;
								_tmp1034_ = m;
								_tmp1035_ = vala_method_get_base_method (_tmp1034_);
								_tmp1036_ = _tmp1035_;
								m = _tmp1036_;
								_tmp1037_ = m;
								_tmp1038_ = vala_method_get_signal_reference (_tmp1037_);
								_tmp1039_ = _tmp1038_;
								if (_tmp1039_ != NULL) {
									ValaMethod* _tmp1040_;
									ValaSignal* _tmp1041_;
									ValaSignal* _tmp1042_;
									_tmp1040_ = m;
									_tmp1041_ = vala_method_get_signal_reference (_tmp1040_);
									_tmp1042_ = _tmp1041_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1042_);
								} else {
									ValaMethod* _tmp1043_;
									_tmp1043_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1043_);
								}
								_tmp1044_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1045_ = _tmp1044_;
								member = _tmp1045_;
							} else {
								ValaMethod* _tmp1046_;
								ValaMethod* _tmp1047_;
								ValaMethod* _tmp1048_;
								_tmp1046_ = m;
								_tmp1047_ = vala_method_get_base_interface_method (_tmp1046_);
								_tmp1048_ = _tmp1047_;
								if (_tmp1048_ != NULL) {
									ValaMethod* _tmp1049_;
									ValaMethod* _tmp1050_;
									ValaMethod* _tmp1051_;
									ValaMethod* _tmp1052_;
									ValaSignal* _tmp1053_;
									ValaSignal* _tmp1054_;
									ValaSymbol* _tmp1059_;
									ValaSymbol* _tmp1060_;
									_tmp1049_ = m;
									_tmp1050_ = vala_method_get_base_interface_method (_tmp1049_);
									_tmp1051_ = _tmp1050_;
									m = _tmp1051_;
									_tmp1052_ = m;
									_tmp1053_ = vala_method_get_signal_reference (_tmp1052_);
									_tmp1054_ = _tmp1053_;
									if (_tmp1054_ != NULL) {
										ValaMethod* _tmp1055_;
										ValaSignal* _tmp1056_;
										ValaSignal* _tmp1057_;
										_tmp1055_ = m;
										_tmp1056_ = vala_method_get_signal_reference (_tmp1055_);
										_tmp1057_ = _tmp1056_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1057_);
									} else {
										ValaMethod* _tmp1058_;
										_tmp1058_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1058_);
									}
									_tmp1059_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1060_ = _tmp1059_;
									member = _tmp1060_;
								}
							}
						}
						_tmp1061_ = m;
						_tmp1062_ = vala_symbol_get_access ((ValaSymbol*) _tmp1061_);
						_tmp1063_ = _tmp1062_;
						access = _tmp1063_;
						_tmp1064_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1064_)) {
							ValaMethod* _tmp1065_;
							ValaMemberBinding _tmp1066_;
							ValaMemberBinding _tmp1067_;
							_tmp1065_ = m;
							_tmp1066_ = vala_method_get_binding (_tmp1065_);
							_tmp1067_ = _tmp1066_;
							instance = _tmp1067_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1068_ = m;
						_tmp1069_ = vala_method_get_binding (_tmp1068_);
						_tmp1070_ = _tmp1069_;
						klass = _tmp1070_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1071_;
							ValaList* _tmp1072_;
							gint _param_size = 0;
							ValaList* _tmp1073_;
							gint _tmp1074_;
							gint _tmp1075_;
							gint _param_index = 0;
							_tmp1071_ = m;
							_tmp1072_ = vala_callable_get_parameters ((ValaCallable*) _tmp1071_);
							_param_list = _tmp1072_;
							_tmp1073_ = _param_list;
							_tmp1074_ = vala_collection_get_size ((ValaCollection*) _tmp1073_);
							_tmp1075_ = _tmp1074_;
							_param_size = _tmp1075_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1076_;
								gint _tmp1077_;
								ValaParameter* param = NULL;
								ValaList* _tmp1078_;
								gpointer _tmp1079_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1080_;
								ValaDataType* _tmp1081_;
								ValaDataType* _tmp1082_;
								gboolean _tmp1083_ = FALSE;
								ValaGenericType* _tmp1084_;
								_param_index = _param_index + 1;
								_tmp1076_ = _param_index;
								_tmp1077_ = _param_size;
								if (!(_tmp1076_ < _tmp1077_)) {
									break;
								}
								_tmp1078_ = _param_list;
								_tmp1079_ = vala_list_get (_tmp1078_, _param_index);
								param = (ValaParameter*) _tmp1079_;
								_tmp1080_ = param;
								_tmp1081_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1080_);
								_tmp1082_ = _tmp1081_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1082_) ? ((ValaGenericType*) _tmp1082_) : NULL;
								_tmp1084_ = generic_type;
								if (_tmp1084_ != NULL) {
									ValaGenericType* _tmp1085_;
									ValaTypeParameter* _tmp1086_;
									ValaTypeParameter* _tmp1087_;
									ValaSymbol* _tmp1088_;
									ValaSymbol* _tmp1089_;
									_tmp1085_ = generic_type;
									_tmp1086_ = vala_generic_type_get_type_parameter (_tmp1085_);
									_tmp1087_ = _tmp1086_;
									_tmp1088_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1087_);
									_tmp1089_ = _tmp1088_;
									_tmp1083_ = VALA_IS_TYPESYMBOL (_tmp1089_);
								} else {
									_tmp1083_ = FALSE;
								}
								if (_tmp1083_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1090_ = m;
						_tmp1091_ = vala_callable_get_return_type ((ValaCallable*) _tmp1090_);
						_tmp1092_ = _tmp1091_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1092_) ? ((ValaGenericType*) _tmp1092_) : NULL;
						_tmp1094_ = generic_type;
						if (_tmp1094_ != NULL) {
							ValaGenericType* _tmp1095_;
							ValaTypeParameter* _tmp1096_;
							ValaTypeParameter* _tmp1097_;
							ValaSymbol* _tmp1098_;
							ValaSymbol* _tmp1099_;
							_tmp1095_ = generic_type;
							_tmp1096_ = vala_generic_type_get_type_parameter (_tmp1095_);
							_tmp1097_ = _tmp1096_;
							_tmp1098_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1097_);
							_tmp1099_ = _tmp1098_;
							_tmp1093_ = VALA_IS_TYPESYMBOL (_tmp1099_);
						} else {
							_tmp1093_ = FALSE;
						}
						if (_tmp1093_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1100_;
						_tmp1100_ = member;
						if (VALA_IS_PROPERTY (_tmp1100_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1101_;
							ValaProperty* _tmp1102_;
							ValaProperty* _tmp1103_;
							ValaProperty* _tmp1104_;
							ValaProperty* _tmp1105_;
							ValaProperty* _tmp1121_;
							ValaSymbolAccessibility _tmp1122_;
							ValaSymbolAccessibility _tmp1123_;
							gboolean _tmp1124_;
							gboolean _tmp1125_;
							ValaProperty* _tmp1224_;
							ValaMemberBinding _tmp1225_;
							ValaMemberBinding _tmp1226_;
							ValaProperty* _tmp1227_;
							ValaDataType* _tmp1228_;
							ValaDataType* _tmp1229_;
							_tmp1101_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1101_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1102_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1102_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1103_ = prop;
							_tmp1104_ = vala_property_get_base_property (_tmp1103_);
							_tmp1105_ = _tmp1104_;
							if (_tmp1105_ != NULL) {
								ValaProperty* _tmp1106_;
								ValaProperty* _tmp1107_;
								ValaProperty* _tmp1108_;
								ValaProperty* _tmp1109_;
								ValaSymbol* _tmp1110_;
								ValaSymbol* _tmp1111_;
								_tmp1106_ = prop;
								_tmp1107_ = vala_property_get_base_property (_tmp1106_);
								_tmp1108_ = _tmp1107_;
								prop = _tmp1108_;
								_tmp1109_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1109_);
								_tmp1110_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1111_ = _tmp1110_;
								member = _tmp1111_;
							} else {
								ValaProperty* _tmp1112_;
								ValaProperty* _tmp1113_;
								ValaProperty* _tmp1114_;
								_tmp1112_ = prop;
								_tmp1113_ = vala_property_get_base_interface_property (_tmp1112_);
								_tmp1114_ = _tmp1113_;
								if (_tmp1114_ != NULL) {
									ValaProperty* _tmp1115_;
									ValaProperty* _tmp1116_;
									ValaProperty* _tmp1117_;
									ValaProperty* _tmp1118_;
									ValaSymbol* _tmp1119_;
									ValaSymbol* _tmp1120_;
									_tmp1115_ = prop;
									_tmp1116_ = vala_property_get_base_interface_property (_tmp1115_);
									_tmp1117_ = _tmp1116_;
									prop = _tmp1117_;
									_tmp1118_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1118_);
									_tmp1119_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1120_ = _tmp1119_;
									member = _tmp1120_;
								}
							}
							_tmp1121_ = prop;
							_tmp1122_ = vala_symbol_get_access ((ValaSymbol*) _tmp1121_);
							_tmp1123_ = _tmp1122_;
							access = _tmp1123_;
							_tmp1124_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1125_ = _tmp1124_;
							if (_tmp1125_) {
								ValaProperty* _tmp1126_;
								ValaPropertyAccessor* _tmp1127_;
								ValaPropertyAccessor* _tmp1128_;
								ValaProperty* _tmp1172_;
								ValaSymbolAccessibility _tmp1173_;
								ValaSymbolAccessibility _tmp1174_;
								_tmp1126_ = prop;
								_tmp1127_ = vala_property_get_set_accessor (_tmp1126_);
								_tmp1128_ = _tmp1127_;
								if (_tmp1128_ == NULL) {
									ValaSourceReference* _tmp1129_;
									ValaSourceReference* _tmp1130_;
									ValaProperty* _tmp1131_;
									gchar* _tmp1132_;
									gchar* _tmp1133_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1130_ = _tmp1129_;
									_tmp1131_ = prop;
									_tmp1132_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1131_);
									_tmp1133_ = _tmp1132_;
									vala_report_error (_tmp1130_, "Property `%s' is read-only", _tmp1133_);
									_g_free0 (_tmp1133_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1134_ = FALSE;
									ValaProperty* _tmp1135_;
									ValaPropertyAccessor* _tmp1136_;
									ValaPropertyAccessor* _tmp1137_;
									gboolean _tmp1138_;
									gboolean _tmp1139_;
									_tmp1135_ = prop;
									_tmp1136_ = vala_property_get_set_accessor (_tmp1135_);
									_tmp1137_ = _tmp1136_;
									_tmp1138_ = vala_property_accessor_get_writable (_tmp1137_);
									_tmp1139_ = _tmp1138_;
									if (!_tmp1139_) {
										ValaProperty* _tmp1140_;
										ValaPropertyAccessor* _tmp1141_;
										ValaPropertyAccessor* _tmp1142_;
										gboolean _tmp1143_;
										gboolean _tmp1144_;
										_tmp1140_ = prop;
										_tmp1141_ = vala_property_get_set_accessor (_tmp1140_);
										_tmp1142_ = _tmp1141_;
										_tmp1143_ = vala_property_accessor_get_construction (_tmp1142_);
										_tmp1144_ = _tmp1143_;
										_tmp1134_ = _tmp1144_;
									} else {
										_tmp1134_ = FALSE;
									}
									if (_tmp1134_) {
										ValaSemanticAnalyzer* _tmp1145_;
										ValaSemanticAnalyzer* _tmp1146_;
										ValaMethod* _tmp1147_;
										_tmp1145_ = vala_code_context_get_analyzer (context);
										_tmp1146_ = _tmp1145_;
										_tmp1147_ = vala_semantic_analyzer_find_current_method (_tmp1146_);
										if (VALA_IS_CREATION_METHOD (_tmp1147_)) {
											ValaSourceReference* _tmp1148_;
											ValaSourceReference* _tmp1149_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1149_ = _tmp1148_;
											vala_report_error (_tmp1149_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1150_;
											ValaSemanticAnalyzer* _tmp1151_;
											_tmp1150_ = vala_code_context_get_analyzer (context);
											_tmp1151_ = _tmp1150_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1151_)) {
												ValaSemanticAnalyzer* _tmp1152_;
												ValaSemanticAnalyzer* _tmp1153_;
												ValaTypeSymbol* _tmp1154_;
												ValaTypeSymbol* _tmp1155_;
												ValaProperty* _tmp1156_;
												ValaSymbol* _tmp1157_;
												ValaSymbol* _tmp1158_;
												_tmp1152_ = vala_code_context_get_analyzer (context);
												_tmp1153_ = _tmp1152_;
												_tmp1154_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1153_);
												_tmp1155_ = _tmp1154_;
												_tmp1156_ = prop;
												_tmp1157_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1156_);
												_tmp1158_ = _tmp1157_;
												if (!vala_typesymbol_is_subtype_of (_tmp1155_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1158_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1159_;
													ValaSourceReference* _tmp1160_;
													ValaProperty* _tmp1161_;
													gchar* _tmp1162_;
													gchar* _tmp1163_;
													ValaSemanticAnalyzer* _tmp1164_;
													ValaSemanticAnalyzer* _tmp1165_;
													ValaTypeSymbol* _tmp1166_;
													ValaTypeSymbol* _tmp1167_;
													gchar* _tmp1168_;
													gchar* _tmp1169_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1159_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1160_ = _tmp1159_;
													_tmp1161_ = prop;
													_tmp1162_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1161_);
													_tmp1163_ = _tmp1162_;
													_tmp1164_ = vala_code_context_get_analyzer (context);
													_tmp1165_ = _tmp1164_;
													_tmp1166_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1165_);
													_tmp1167_ = _tmp1166_;
													_tmp1168_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1167_);
													_tmp1169_ = _tmp1168_;
													vala_report_error (_tmp1160_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1163_, _tmp1169_);
													_g_free0 (_tmp1169_);
													_g_free0 (_tmp1163_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1170_;
												ValaSourceReference* _tmp1171_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1171_ = _tmp1170_;
												vala_report_error (_tmp1171_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1172_ = prop;
								_tmp1173_ = vala_symbol_get_access ((ValaSymbol*) _tmp1172_);
								_tmp1174_ = _tmp1173_;
								if (_tmp1174_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1175_;
									ValaPropertyAccessor* _tmp1176_;
									ValaPropertyAccessor* _tmp1177_;
									ValaSymbolAccessibility _tmp1178_;
									ValaSymbolAccessibility _tmp1179_;
									_tmp1175_ = prop;
									_tmp1176_ = vala_property_get_set_accessor (_tmp1175_);
									_tmp1177_ = _tmp1176_;
									_tmp1178_ = vala_symbol_get_access ((ValaSymbol*) _tmp1177_);
									_tmp1179_ = _tmp1178_;
									access = _tmp1179_;
								} else {
									gboolean _tmp1180_ = FALSE;
									ValaProperty* _tmp1181_;
									ValaSymbolAccessibility _tmp1182_;
									ValaSymbolAccessibility _tmp1183_;
									_tmp1181_ = prop;
									_tmp1182_ = vala_symbol_get_access ((ValaSymbol*) _tmp1181_);
									_tmp1183_ = _tmp1182_;
									if (_tmp1183_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1184_;
										ValaPropertyAccessor* _tmp1185_;
										ValaPropertyAccessor* _tmp1186_;
										ValaSymbolAccessibility _tmp1187_;
										ValaSymbolAccessibility _tmp1188_;
										_tmp1184_ = prop;
										_tmp1185_ = vala_property_get_set_accessor (_tmp1184_);
										_tmp1186_ = _tmp1185_;
										_tmp1187_ = vala_symbol_get_access ((ValaSymbol*) _tmp1186_);
										_tmp1188_ = _tmp1187_;
										_tmp1180_ = _tmp1188_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1180_ = FALSE;
									}
									if (_tmp1180_) {
										ValaProperty* _tmp1189_;
										ValaPropertyAccessor* _tmp1190_;
										ValaPropertyAccessor* _tmp1191_;
										ValaSymbolAccessibility _tmp1192_;
										ValaSymbolAccessibility _tmp1193_;
										_tmp1189_ = prop;
										_tmp1190_ = vala_property_get_set_accessor (_tmp1189_);
										_tmp1191_ = _tmp1190_;
										_tmp1192_ = vala_symbol_get_access ((ValaSymbol*) _tmp1191_);
										_tmp1193_ = _tmp1192_;
										access = _tmp1193_;
									}
								}
							} else {
								ValaProperty* _tmp1194_;
								ValaPropertyAccessor* _tmp1195_;
								ValaPropertyAccessor* _tmp1196_;
								ValaProperty* _tmp1202_;
								ValaSymbolAccessibility _tmp1203_;
								ValaSymbolAccessibility _tmp1204_;
								_tmp1194_ = prop;
								_tmp1195_ = vala_property_get_get_accessor (_tmp1194_);
								_tmp1196_ = _tmp1195_;
								if (_tmp1196_ == NULL) {
									ValaSourceReference* _tmp1197_;
									ValaSourceReference* _tmp1198_;
									ValaProperty* _tmp1199_;
									gchar* _tmp1200_;
									gchar* _tmp1201_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1198_ = _tmp1197_;
									_tmp1199_ = prop;
									_tmp1200_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1199_);
									_tmp1201_ = _tmp1200_;
									vala_report_error (_tmp1198_, "Property `%s' is write-only", _tmp1201_);
									_g_free0 (_tmp1201_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1202_ = prop;
								_tmp1203_ = vala_symbol_get_access ((ValaSymbol*) _tmp1202_);
								_tmp1204_ = _tmp1203_;
								if (_tmp1204_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1205_;
									ValaPropertyAccessor* _tmp1206_;
									ValaPropertyAccessor* _tmp1207_;
									ValaSymbolAccessibility _tmp1208_;
									ValaSymbolAccessibility _tmp1209_;
									_tmp1205_ = prop;
									_tmp1206_ = vala_property_get_get_accessor (_tmp1205_);
									_tmp1207_ = _tmp1206_;
									_tmp1208_ = vala_symbol_get_access ((ValaSymbol*) _tmp1207_);
									_tmp1209_ = _tmp1208_;
									access = _tmp1209_;
								} else {
									gboolean _tmp1210_ = FALSE;
									ValaProperty* _tmp1211_;
									ValaSymbolAccessibility _tmp1212_;
									ValaSymbolAccessibility _tmp1213_;
									_tmp1211_ = prop;
									_tmp1212_ = vala_symbol_get_access ((ValaSymbol*) _tmp1211_);
									_tmp1213_ = _tmp1212_;
									if (_tmp1213_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1214_;
										ValaPropertyAccessor* _tmp1215_;
										ValaPropertyAccessor* _tmp1216_;
										ValaSymbolAccessibility _tmp1217_;
										ValaSymbolAccessibility _tmp1218_;
										_tmp1214_ = prop;
										_tmp1215_ = vala_property_get_get_accessor (_tmp1214_);
										_tmp1216_ = _tmp1215_;
										_tmp1217_ = vala_symbol_get_access ((ValaSymbol*) _tmp1216_);
										_tmp1218_ = _tmp1217_;
										_tmp1210_ = _tmp1218_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1210_ = FALSE;
									}
									if (_tmp1210_) {
										ValaProperty* _tmp1219_;
										ValaPropertyAccessor* _tmp1220_;
										ValaPropertyAccessor* _tmp1221_;
										ValaSymbolAccessibility _tmp1222_;
										ValaSymbolAccessibility _tmp1223_;
										_tmp1219_ = prop;
										_tmp1220_ = vala_property_get_get_accessor (_tmp1219_);
										_tmp1221_ = _tmp1220_;
										_tmp1222_ = vala_symbol_get_access ((ValaSymbol*) _tmp1221_);
										_tmp1223_ = _tmp1222_;
										access = _tmp1223_;
									}
								}
							}
							_tmp1224_ = prop;
							_tmp1225_ = vala_property_get_binding (_tmp1224_);
							_tmp1226_ = _tmp1225_;
							instance = _tmp1226_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1227_ = prop;
							_tmp1228_ = vala_property_get_property_type (_tmp1227_);
							_tmp1229_ = _tmp1228_;
							if (VALA_IS_GENERIC_TYPE (_tmp1229_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1230_;
							_tmp1230_ = member;
							if (VALA_IS_SIGNAL (_tmp1230_)) {
								ValaSymbol* _tmp1231_;
								ValaSymbolAccessibility _tmp1232_;
								ValaSymbolAccessibility _tmp1233_;
								instance = TRUE;
								_tmp1231_ = member;
								_tmp1232_ = vala_symbol_get_access (_tmp1231_);
								_tmp1233_ = _tmp1232_;
								access = _tmp1233_;
							} else {
								gboolean _tmp1234_ = FALSE;
								gboolean _tmp1235_;
								_tmp1235_ = self->priv->_creation_member;
								if (!_tmp1235_) {
									ValaSymbol* _tmp1236_;
									_tmp1236_ = member;
									_tmp1234_ = VALA_IS_ERROR_CODE (_tmp1236_);
								} else {
									_tmp1234_ = FALSE;
								}
								if (_tmp1234_) {
									ValaSymbol* _tmp1237_;
									ValaConstant* _tmp1238_;
									ValaConstant* _tmp1239_;
									ValaSymbol* _tmp1240_;
									ValaSymbol* _tmp1241_;
									_tmp1237_ = member;
									_tmp1238_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1237_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1239_ = _tmp1238_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1239_);
									_tmp1240_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1241_ = _tmp1240_;
									member = _tmp1241_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1242_;
		ValaSymbol* _tmp1243_;
		ValaCodeNode* _tmp1244_;
		ValaCodeNode* _tmp1245_;
		ValaCodeNode* _tmp1246_;
		gboolean _tmp1247_ = FALSE;
		ValaCodeNode* _tmp1248_;
		_tmp1242_ = parent;
		_tmp1243_ = member;
		if (!(_tmp1242_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1243_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1244_ = parent;
		_tmp1245_ = vala_code_node_get_parent_node (_tmp1244_);
		_tmp1246_ = _tmp1245_;
		parent = _tmp1246_;
		_tmp1248_ = parent;
		if (_tmp1248_ == NULL) {
			_tmp1247_ = TRUE;
		} else {
			ValaCodeNode* _tmp1249_;
			ValaSymbol* _tmp1250_;
			_tmp1249_ = parent;
			_tmp1250_ = member;
			_tmp1247_ = _tmp1249_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1250_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1247_) {
			break;
		}
	}
	_tmp1251_ = parent;
	_tmp1252_ = member;
	if (_tmp1251_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1252_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1253_;
		_tmp1253_ = member;
		vala_symbol_set_used (_tmp1253_, TRUE);
	}
	_tmp1254_ = member;
	_tmp1255_ = vala_symbol_get_version (_tmp1254_);
	_tmp1256_ = _tmp1255_;
	_tmp1257_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1258_ = _tmp1257_;
	vala_version_attribute_check (_tmp1256_, context, _tmp1258_);
	_tmp1260_ = access;
	if (_tmp1260_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1261_;
		ValaSymbol* _tmp1262_;
		ValaSymbol* _tmp1263_;
		_tmp1261_ = member;
		_tmp1262_ = vala_symbol_get_parent_symbol (_tmp1261_);
		_tmp1263_ = _tmp1262_;
		_tmp1259_ = VALA_IS_TYPESYMBOL (_tmp1263_);
	} else {
		_tmp1259_ = FALSE;
	}
	if (_tmp1259_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1264_;
		ValaSymbol* _tmp1265_;
		ValaSymbol* _tmp1266_;
		gboolean in_subtype = FALSE;
		_tmp1264_ = member;
		_tmp1265_ = vala_symbol_get_parent_symbol (_tmp1264_);
		_tmp1266_ = _tmp1265_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1266_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1267_;
			ValaSemanticAnalyzer* _tmp1268_;
			ValaSymbol* _tmp1269_;
			ValaSymbol* _tmp1270_;
			ValaSymbol* _tmp1271_;
			_tmp1267_ = vala_code_context_get_analyzer (context);
			_tmp1268_ = _tmp1267_;
			_tmp1269_ = vala_semantic_analyzer_get_current_symbol (_tmp1268_);
			_tmp1270_ = _tmp1269_;
			_tmp1271_ = _vala_code_node_ref0 (_tmp1270_);
			this_symbol = _tmp1271_;
			{
				gboolean _tmp1272_ = FALSE;
				_tmp1272_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1277_;
					ValaSymbol* _tmp1278_;
					ValaTypeSymbol* _tmp1279_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1280_;
					gboolean _tmp1281_ = FALSE;
					ValaClass* _tmp1282_;
					if (!_tmp1272_) {
						ValaSymbol* _tmp1273_;
						ValaSymbol* _tmp1274_;
						ValaSymbol* _tmp1275_;
						ValaSymbol* _tmp1276_;
						_tmp1273_ = this_symbol;
						_tmp1274_ = vala_symbol_get_parent_symbol (_tmp1273_);
						_tmp1275_ = _tmp1274_;
						_tmp1276_ = _vala_code_node_ref0 (_tmp1275_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1276_;
					}
					_tmp1272_ = FALSE;
					_tmp1277_ = this_symbol;
					if (!(_tmp1277_ != NULL)) {
						break;
					}
					_tmp1278_ = this_symbol;
					_tmp1279_ = target_type;
					if (_tmp1278_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1279_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1280_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1280_) ? ((ValaClass*) _tmp1280_) : NULL;
					_tmp1282_ = cl;
					if (_tmp1282_ != NULL) {
						ValaClass* _tmp1283_;
						ValaTypeSymbol* _tmp1284_;
						_tmp1283_ = cl;
						_tmp1284_ = target_type;
						_tmp1281_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1283_, _tmp1284_);
					} else {
						_tmp1281_ = FALSE;
					}
					if (_tmp1281_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1285_;
			ValaSourceReference* _tmp1286_;
			ValaSymbol* _tmp1287_;
			gchar* _tmp1288_;
			gchar* _tmp1289_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1285_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1286_ = _tmp1285_;
			_tmp1287_ = member;
			_tmp1288_ = vala_symbol_get_full_name (_tmp1287_);
			_tmp1289_ = _tmp1288_;
			vala_report_error (_tmp1286_, "Access to protected member `%s' denied", _tmp1289_);
			_g_free0 (_tmp1289_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1290_;
		_tmp1290_ = access;
		if (_tmp1290_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1291_;
			ValaSymbol* _tmp1292_;
			ValaSymbol* _tmp1293_;
			gboolean in_target_type = FALSE;
			_tmp1291_ = member;
			_tmp1292_ = vala_symbol_get_parent_symbol (_tmp1291_);
			_tmp1293_ = _tmp1292_;
			target_type = _tmp1293_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1294_;
				ValaSemanticAnalyzer* _tmp1295_;
				ValaSymbol* _tmp1296_;
				ValaSymbol* _tmp1297_;
				ValaSymbol* _tmp1298_;
				_tmp1294_ = vala_code_context_get_analyzer (context);
				_tmp1295_ = _tmp1294_;
				_tmp1296_ = vala_semantic_analyzer_get_current_symbol (_tmp1295_);
				_tmp1297_ = _tmp1296_;
				_tmp1298_ = _vala_code_node_ref0 (_tmp1297_);
				this_symbol = _tmp1298_;
				{
					gboolean _tmp1299_ = FALSE;
					_tmp1299_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1304_;
						ValaSymbol* _tmp1305_;
						ValaSymbol* _tmp1306_;
						if (!_tmp1299_) {
							ValaSymbol* _tmp1300_;
							ValaSymbol* _tmp1301_;
							ValaSymbol* _tmp1302_;
							ValaSymbol* _tmp1303_;
							_tmp1300_ = this_symbol;
							_tmp1301_ = vala_symbol_get_parent_symbol (_tmp1300_);
							_tmp1302_ = _tmp1301_;
							_tmp1303_ = _vala_code_node_ref0 (_tmp1302_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1303_;
						}
						_tmp1299_ = FALSE;
						_tmp1304_ = this_symbol;
						if (!(_tmp1304_ != NULL)) {
							break;
						}
						_tmp1305_ = target_type;
						_tmp1306_ = this_symbol;
						if (_tmp1305_ == _tmp1306_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1307_;
				ValaSourceReference* _tmp1308_;
				ValaSymbol* _tmp1309_;
				gchar* _tmp1310_;
				gchar* _tmp1311_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1308_ = _tmp1307_;
				_tmp1309_ = member;
				_tmp1310_ = vala_symbol_get_full_name (_tmp1309_);
				_tmp1311_ = _tmp1310_;
				vala_report_error (_tmp1308_, "Access to private member `%s' denied", _tmp1311_);
				_g_free0 (_tmp1311_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1313_;
		ValaExpression* _tmp1314_;
		_tmp1313_ = vala_member_access_get_inner (self);
		_tmp1314_ = _tmp1313_;
		_tmp1312_ = _tmp1314_ != NULL;
	} else {
		_tmp1312_ = FALSE;
	}
	if (_tmp1312_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1315_;
		ValaExpression* _tmp1316_;
		ValaDataType* _tmp1317_;
		ValaDataType* _tmp1318_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1319_;
		ValaExpression* _tmp1320_;
		ValaDataType* _tmp1321_;
		ValaDataType* _tmp1322_;
		ValaPointerType* _tmp1323_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1327_;
		gboolean _tmp1328_ = FALSE;
		gboolean _tmp1329_ = FALSE;
		ValaObjectType* _tmp1330_;
		_tmp1315_ = vala_member_access_get_inner (self);
		_tmp1316_ = _tmp1315_;
		_tmp1317_ = vala_expression_get_value_type (_tmp1316_);
		_tmp1318_ = _tmp1317_;
		instance_type = _tmp1318_;
		_tmp1319_ = vala_member_access_get_inner (self);
		_tmp1320_ = _tmp1319_;
		_tmp1321_ = vala_expression_get_value_type (_tmp1320_);
		_tmp1322_ = _tmp1321_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1322_) ? ((ValaPointerType*) _tmp1322_) : NULL;
		_tmp1323_ = pointer_type;
		if (_tmp1323_ != NULL) {
			ValaPointerType* _tmp1324_;
			ValaDataType* _tmp1325_;
			ValaDataType* _tmp1326_;
			_tmp1324_ = pointer_type;
			_tmp1325_ = vala_pointer_type_get_base_type (_tmp1324_);
			_tmp1326_ = _tmp1325_;
			instance_type = _tmp1326_;
		}
		_tmp1327_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1327_) ? ((ValaObjectType*) _tmp1327_) : NULL;
		_tmp1330_ = object_type;
		if (_tmp1330_ != NULL) {
			ValaObjectType* _tmp1331_;
			ValaObjectTypeSymbol* _tmp1332_;
			ValaObjectTypeSymbol* _tmp1333_;
			_tmp1331_ = object_type;
			_tmp1332_ = vala_object_type_get_object_type_symbol (_tmp1331_);
			_tmp1333_ = _tmp1332_;
			_tmp1329_ = vala_object_type_symbol_has_type_parameters (_tmp1333_);
		} else {
			_tmp1329_ = FALSE;
		}
		if (_tmp1329_) {
			ValaDataType* _tmp1334_;
			_tmp1334_ = instance_type;
			_tmp1328_ = !vala_data_type_has_type_arguments (_tmp1334_);
		} else {
			_tmp1328_ = FALSE;
		}
		if (_tmp1328_) {
			ValaExpression* _tmp1335_;
			ValaExpression* _tmp1336_;
			ValaSourceReference* _tmp1337_;
			ValaSourceReference* _tmp1338_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1335_ = vala_member_access_get_inner (self);
			_tmp1336_ = _tmp1335_;
			_tmp1337_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1336_);
			_tmp1338_ = _tmp1337_;
			vala_report_error (_tmp1338_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1340_ = !may_access_instance_members;
	} else {
		_tmp1340_ = FALSE;
	}
	if (_tmp1340_) {
		_tmp1339_ = TRUE;
	} else {
		gboolean _tmp1341_ = FALSE;
		if (klass) {
			_tmp1341_ = !may_access_klass_members;
		} else {
			_tmp1341_ = FALSE;
		}
		_tmp1339_ = _tmp1341_;
	}
	if (_tmp1339_) {
		ValaSymbol* _tmp1342_;
		ValaSymbol* _tmp1343_;
		ValaDataType* _tmp1378_;
		ValaDataType* _tmp1379_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1342_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1343_ = _tmp1342_;
		if (VALA_IS_METHOD (_tmp1343_)) {
			ValaSemanticAnalyzer* _tmp1344_;
			ValaSemanticAnalyzer* _tmp1345_;
			ValaSymbol* _tmp1346_;
			ValaSymbol* _tmp1347_;
			gboolean _tmp1348_;
			gboolean _tmp1349_;
			ValaDataType* _tmp1350_;
			ValaDataType* _tmp1351_;
			ValaDataType* _tmp1352_;
			ValaDataType* _tmp1353_;
			ValaSourceReference* _tmp1354_;
			ValaSourceReference* _tmp1355_;
			_tmp1344_ = vala_code_context_get_analyzer (context);
			_tmp1345_ = _tmp1344_;
			_tmp1346_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1347_ = _tmp1346_;
			_tmp1348_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1349_ = _tmp1348_;
			_tmp1350_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1345_, _tmp1347_, _tmp1349_);
			_tmp1351_ = _tmp1350_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1351_);
			_vala_code_node_unref0 (_tmp1351_);
			_tmp1352_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1353_ = _tmp1352_;
			_tmp1354_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1355_ = _tmp1354_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1353_, _tmp1355_);
		} else {
			ValaSymbol* _tmp1356_;
			ValaSymbol* _tmp1357_;
			_tmp1356_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1357_ = _tmp1356_;
			if (VALA_IS_FIELD (_tmp1357_)) {
				ValaSymbol* _tmp1358_;
				ValaSymbol* _tmp1359_;
				ValaFieldPrototype* _tmp1360_;
				ValaFieldPrototype* _tmp1361_;
				ValaDataType* _tmp1362_;
				ValaDataType* _tmp1363_;
				ValaSourceReference* _tmp1364_;
				ValaSourceReference* _tmp1365_;
				_tmp1358_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1359_ = _tmp1358_;
				_tmp1360_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1359_, VALA_TYPE_FIELD, ValaField));
				_tmp1361_ = _tmp1360_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1361_);
				_vala_code_node_unref0 (_tmp1361_);
				_tmp1362_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1363_ = _tmp1362_;
				_tmp1364_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1365_ = _tmp1364_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1363_, _tmp1365_);
			} else {
				ValaSymbol* _tmp1366_;
				ValaSymbol* _tmp1367_;
				_tmp1366_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1367_ = _tmp1366_;
				if (VALA_IS_PROPERTY (_tmp1367_)) {
					ValaSymbol* _tmp1368_;
					ValaSymbol* _tmp1369_;
					ValaPropertyPrototype* _tmp1370_;
					ValaPropertyPrototype* _tmp1371_;
					ValaDataType* _tmp1372_;
					ValaDataType* _tmp1373_;
					ValaSourceReference* _tmp1374_;
					ValaSourceReference* _tmp1375_;
					_tmp1368_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1369_ = _tmp1368_;
					_tmp1370_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1369_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1371_ = _tmp1370_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1371_);
					_vala_code_node_unref0 (_tmp1371_);
					_tmp1372_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp1373_ = _tmp1372_;
					_tmp1374_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1375_ = _tmp1374_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1373_, _tmp1375_);
				} else {
					ValaInvalidType* _tmp1376_;
					ValaInvalidType* _tmp1377_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1376_ = vala_invalid_type_new ();
					_tmp1377_ = _tmp1376_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1377_);
					_vala_code_node_unref0 (_tmp1377_);
				}
			}
		}
		_tmp1378_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1379_ = _tmp1378_;
		if (_tmp1379_ != NULL) {
			ValaDataType* _tmp1380_;
			ValaDataType* _tmp1381_;
			ValaDataType* _tmp1382_;
			ValaDataType* _tmp1383_;
			gboolean _tmp1384_;
			gboolean _tmp1385_;
			_tmp1380_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1381_ = _tmp1380_;
			_tmp1382_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1383_ = _tmp1382_;
			_tmp1384_ = vala_data_type_get_value_owned (_tmp1383_);
			_tmp1385_ = _tmp1384_;
			vala_data_type_set_value_owned (_tmp1381_, _tmp1385_);
		}
	} else {
		gboolean _tmp1386_ = FALSE;
		gboolean _tmp1407_ = FALSE;
		gboolean _tmp1408_ = FALSE;
		gboolean _tmp1409_ = FALSE;
		gboolean _tmp1410_ = FALSE;
		gboolean _tmp1451_ = FALSE;
		gboolean _tmp1452_ = FALSE;
		gboolean _tmp1453_ = FALSE;
		gboolean _tmp1454_ = FALSE;
		gboolean _tmp1455_ = FALSE;
		gboolean _tmp1456_;
		gboolean _tmp1457_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1482_;
		ValaSymbol* _tmp1483_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1484_;
		ValaExpression* _tmp1485_;
		gboolean _tmp1486_ = FALSE;
		gboolean _tmp1487_ = FALSE;
		gboolean _tmp1488_ = FALSE;
		gboolean _tmp1489_ = FALSE;
		gboolean _tmp1490_ = FALSE;
		ValaMethod* _tmp1491_;
		ValaSemanticAnalyzer* _tmp1535_;
		ValaSemanticAnalyzer* _tmp1536_;
		ValaSymbol* _tmp1537_;
		ValaSymbol* _tmp1538_;
		gboolean _tmp1539_;
		gboolean _tmp1540_;
		ValaDataType* _tmp1541_;
		ValaDataType* _tmp1542_;
		gboolean _tmp1543_ = FALSE;
		ValaExpression* _tmp1544_;
		ValaExpression* _tmp1545_;
		ValaSymbol* _tmp1558_;
		ValaSymbol* _tmp1559_;
		gboolean _tmp1633_ = FALSE;
		gboolean _tmp1634_ = FALSE;
		ValaExpression* _tmp1635_;
		ValaExpression* _tmp1636_;
		if (instance) {
			ValaExpression* _tmp1387_;
			ValaExpression* _tmp1388_;
			_tmp1387_ = vala_member_access_get_inner (self);
			_tmp1388_ = _tmp1387_;
			_tmp1386_ = _tmp1388_ == NULL;
		} else {
			_tmp1386_ = FALSE;
		}
		if (_tmp1386_) {
			ValaSourceReference* _tmp1389_;
			ValaSourceReference* _tmp1390_;
			ValaMemberAccess* _tmp1391_;
			ValaMemberAccess* _tmp1392_;
			ValaExpression* _tmp1393_;
			ValaExpression* _tmp1394_;
			ValaParameter* _tmp1395_;
			ValaDataType* _tmp1396_;
			ValaDataType* _tmp1397_;
			ValaDataType* _tmp1398_;
			ValaDataType* _tmp1399_;
			ValaExpression* _tmp1400_;
			ValaExpression* _tmp1401_;
			ValaDataType* _tmp1402_;
			ValaDataType* _tmp1403_;
			ValaExpression* _tmp1404_;
			ValaExpression* _tmp1405_;
			ValaParameter* _tmp1406_;
			_tmp1389_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1390_ = _tmp1389_;
			_tmp1391_ = vala_member_access_new (NULL, "this", _tmp1390_);
			_tmp1392_ = _tmp1391_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1392_);
			_vala_code_node_unref0 (_tmp1392_);
			_tmp1393_ = vala_member_access_get_inner (self);
			_tmp1394_ = _tmp1393_;
			_tmp1395_ = this_parameter;
			_tmp1396_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1395_);
			_tmp1397_ = _tmp1396_;
			_tmp1398_ = vala_data_type_copy (_tmp1397_);
			_tmp1399_ = _tmp1398_;
			vala_expression_set_value_type (_tmp1394_, _tmp1399_);
			_vala_code_node_unref0 (_tmp1399_);
			_tmp1400_ = vala_member_access_get_inner (self);
			_tmp1401_ = _tmp1400_;
			_tmp1402_ = vala_expression_get_value_type (_tmp1401_);
			_tmp1403_ = _tmp1402_;
			vala_data_type_set_value_owned (_tmp1403_, FALSE);
			_tmp1404_ = vala_member_access_get_inner (self);
			_tmp1405_ = _tmp1404_;
			_tmp1406_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1405_, (ValaSymbol*) _tmp1406_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1410_ = !klass;
		} else {
			_tmp1410_ = FALSE;
		}
		if (_tmp1410_) {
			ValaSymbol* _tmp1411_;
			ValaSymbol* _tmp1412_;
			_tmp1411_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1412_ = _tmp1411_;
			_tmp1409_ = !VALA_IS_CREATION_METHOD (_tmp1412_);
		} else {
			_tmp1409_ = FALSE;
		}
		if (_tmp1409_) {
			_tmp1408_ = may_access_instance_members;
		} else {
			_tmp1408_ = FALSE;
		}
		if (_tmp1408_) {
			ValaExpression* _tmp1413_;
			ValaExpression* _tmp1414_;
			_tmp1413_ = vala_member_access_get_inner (self);
			_tmp1414_ = _tmp1413_;
			_tmp1407_ = _tmp1414_ != NULL;
		} else {
			_tmp1407_ = FALSE;
		}
		if (_tmp1407_) {
			ValaExpression* _tmp1415_;
			ValaExpression* _tmp1416_;
			ValaSymbol* _tmp1417_;
			ValaSymbol* _tmp1418_;
			_tmp1415_ = vala_member_access_get_inner (self);
			_tmp1416_ = _tmp1415_;
			_tmp1417_ = vala_expression_get_symbol_reference (_tmp1416_);
			_tmp1418_ = _tmp1417_;
			if (VALA_IS_METHOD (_tmp1418_)) {
			} else {
				ValaSourceReference* _tmp1419_;
				ValaSourceReference* _tmp1420_;
				ValaSymbol* _tmp1421_;
				ValaSymbol* _tmp1422_;
				gchar* _tmp1423_;
				gchar* _tmp1424_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1425_;
				ValaSymbol* _tmp1426_;
				ValaSymbol* _tmp1427_;
				ValaSymbol* _tmp1428_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1448_;
				ValaExpression* _tmp1449_;
				ValaExpression* _tmp1450_;
				_tmp1419_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1420_ = _tmp1419_;
				_tmp1421_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1422_ = _tmp1421_;
				_tmp1423_ = vala_symbol_get_full_name (_tmp1422_);
				_tmp1424_ = _tmp1423_;
				vala_report_warning (_tmp1420_, "Access to static member `%s' with an instance reference", _tmp1424_);
				_g_free0 (_tmp1424_);
				_tmp1425_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1426_ = _tmp1425_;
				_tmp1427_ = vala_symbol_get_parent_symbol (_tmp1426_);
				_tmp1428_ = _tmp1427_;
				inner_sym = _tmp1428_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1429_ = FALSE;
					ValaSymbol* _tmp1430_;
					ValaMemberAccess* _tmp1434_;
					ValaSymbol* _tmp1435_;
					const gchar* _tmp1436_;
					const gchar* _tmp1437_;
					ValaSourceReference* _tmp1438_;
					ValaSourceReference* _tmp1439_;
					ValaMemberAccess* _tmp1440_;
					ValaMemberAccess* _tmp1441_;
					ValaMemberAccess* _tmp1442_;
					ValaExpression* _tmp1443_;
					ValaExpression* _tmp1444_;
					ValaSymbol* _tmp1445_;
					ValaSymbol* _tmp1446_;
					ValaSymbol* _tmp1447_;
					_tmp1430_ = inner_sym;
					if (_tmp1430_ != NULL) {
						ValaSymbol* _tmp1431_;
						const gchar* _tmp1432_;
						const gchar* _tmp1433_;
						_tmp1431_ = inner_sym;
						_tmp1432_ = vala_symbol_get_name (_tmp1431_);
						_tmp1433_ = _tmp1432_;
						_tmp1429_ = _tmp1433_ != NULL;
					} else {
						_tmp1429_ = FALSE;
					}
					if (!_tmp1429_) {
						break;
					}
					_tmp1434_ = inner_ma;
					_tmp1435_ = inner_sym;
					_tmp1436_ = vala_symbol_get_name (_tmp1435_);
					_tmp1437_ = _tmp1436_;
					_tmp1438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1439_ = _tmp1438_;
					_tmp1440_ = vala_member_access_new (NULL, _tmp1437_, _tmp1439_);
					_tmp1441_ = _tmp1440_;
					vala_member_access_set_inner (_tmp1434_, (ValaExpression*) _tmp1441_);
					_vala_code_node_unref0 (_tmp1441_);
					_tmp1442_ = inner_ma;
					_tmp1443_ = vala_member_access_get_inner (_tmp1442_);
					_tmp1444_ = _tmp1443_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1444_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1445_ = inner_sym;
					_tmp1446_ = vala_symbol_get_parent_symbol (_tmp1445_);
					_tmp1447_ = _tmp1446_;
					inner_sym = _tmp1447_;
				}
				_tmp1448_ = inner_ma;
				vala_member_access_set_qualified (_tmp1448_, TRUE);
				_tmp1449_ = vala_member_access_get_inner (self);
				_tmp1450_ = _tmp1449_;
				vala_code_node_check ((ValaCodeNode*) _tmp1450_, context);
			}
		}
		_tmp1456_ = vala_code_context_get_experimental_non_null (context);
		_tmp1457_ = _tmp1456_;
		if (_tmp1457_) {
			_tmp1455_ = instance;
		} else {
			_tmp1455_ = FALSE;
		}
		if (_tmp1455_) {
			ValaExpression* _tmp1458_;
			ValaExpression* _tmp1459_;
			ValaDataType* _tmp1460_;
			ValaDataType* _tmp1461_;
			gboolean _tmp1462_;
			gboolean _tmp1463_;
			_tmp1458_ = vala_member_access_get_inner (self);
			_tmp1459_ = _tmp1458_;
			_tmp1460_ = vala_expression_get_value_type (_tmp1459_);
			_tmp1461_ = _tmp1460_;
			_tmp1462_ = vala_data_type_get_nullable (_tmp1461_);
			_tmp1463_ = _tmp1462_;
			_tmp1454_ = _tmp1463_;
		} else {
			_tmp1454_ = FALSE;
		}
		if (_tmp1454_) {
			ValaExpression* _tmp1464_;
			ValaExpression* _tmp1465_;
			ValaDataType* _tmp1466_;
			ValaDataType* _tmp1467_;
			_tmp1464_ = vala_member_access_get_inner (self);
			_tmp1465_ = _tmp1464_;
			_tmp1466_ = vala_expression_get_value_type (_tmp1465_);
			_tmp1467_ = _tmp1466_;
			_tmp1453_ = !VALA_IS_POINTER_TYPE (_tmp1467_);
		} else {
			_tmp1453_ = FALSE;
		}
		if (_tmp1453_) {
			ValaExpression* _tmp1468_;
			ValaExpression* _tmp1469_;
			ValaDataType* _tmp1470_;
			ValaDataType* _tmp1471_;
			_tmp1468_ = vala_member_access_get_inner (self);
			_tmp1469_ = _tmp1468_;
			_tmp1470_ = vala_expression_get_value_type (_tmp1469_);
			_tmp1471_ = _tmp1470_;
			_tmp1452_ = !VALA_IS_GENERIC_TYPE (_tmp1471_);
		} else {
			_tmp1452_ = FALSE;
		}
		if (_tmp1452_) {
			ValaExpression* _tmp1472_;
			ValaExpression* _tmp1473_;
			ValaDataType* _tmp1474_;
			ValaDataType* _tmp1475_;
			_tmp1472_ = vala_member_access_get_inner (self);
			_tmp1473_ = _tmp1472_;
			_tmp1474_ = vala_expression_get_value_type (_tmp1473_);
			_tmp1475_ = _tmp1474_;
			_tmp1451_ = !VALA_IS_ARRAY_TYPE (_tmp1475_);
		} else {
			_tmp1451_ = FALSE;
		}
		if (_tmp1451_) {
			ValaSourceReference* _tmp1476_;
			ValaSourceReference* _tmp1477_;
			ValaSymbol* _tmp1478_;
			ValaSymbol* _tmp1479_;
			gchar* _tmp1480_;
			gchar* _tmp1481_;
			_tmp1476_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1477_ = _tmp1476_;
			_tmp1478_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1479_ = _tmp1478_;
			_tmp1480_ = vala_symbol_get_full_name (_tmp1479_);
			_tmp1481_ = _tmp1480_;
			vala_report_error (_tmp1477_, "Access to instance member `%s' from nullable reference denied", _tmp1481_);
			_g_free0 (_tmp1481_);
		}
		_tmp1482_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1483_ = _tmp1482_;
		m = VALA_IS_METHOD (_tmp1483_) ? ((ValaMethod*) _tmp1483_) : NULL;
		_tmp1484_ = vala_member_access_get_inner (self);
		_tmp1485_ = _tmp1484_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1485_) ? ((ValaMemberAccess*) _tmp1485_) : NULL;
		_tmp1491_ = m;
		if (_tmp1491_ != NULL) {
			ValaMethod* _tmp1492_;
			ValaMemberBinding _tmp1493_;
			ValaMemberBinding _tmp1494_;
			_tmp1492_ = m;
			_tmp1493_ = vala_method_get_binding (_tmp1492_);
			_tmp1494_ = _tmp1493_;
			_tmp1490_ = _tmp1494_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1490_ = FALSE;
		}
		if (_tmp1490_) {
			ValaMethod* _tmp1495_;
			ValaSymbol* _tmp1496_;
			ValaSymbol* _tmp1497_;
			_tmp1495_ = m;
			_tmp1496_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1495_);
			_tmp1497_ = _tmp1496_;
			_tmp1489_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1497_);
		} else {
			_tmp1489_ = FALSE;
		}
		if (_tmp1489_) {
			ValaExpression* _tmp1498_;
			ValaExpression* _tmp1499_;
			_tmp1498_ = vala_member_access_get_inner (self);
			_tmp1499_ = _tmp1498_;
			_tmp1488_ = _tmp1499_ != NULL;
		} else {
			_tmp1488_ = FALSE;
		}
		if (_tmp1488_) {
			ValaExpression* _tmp1500_;
			ValaExpression* _tmp1501_;
			ValaDataType* _tmp1502_;
			ValaDataType* _tmp1503_;
			_tmp1500_ = vala_member_access_get_inner (self);
			_tmp1501_ = _tmp1500_;
			_tmp1502_ = vala_expression_get_value_type (_tmp1501_);
			_tmp1503_ = _tmp1502_;
			_tmp1487_ = _tmp1503_ == NULL;
		} else {
			_tmp1487_ = FALSE;
		}
		if (_tmp1487_) {
			ValaMemberAccess* _tmp1504_;
			ValaList* _tmp1505_;
			gint _tmp1506_;
			gint _tmp1507_;
			_tmp1504_ = inner_ma;
			_tmp1505_ = _tmp1504_->priv->type_argument_list;
			_tmp1506_ = vala_collection_get_size ((ValaCollection*) _tmp1505_);
			_tmp1507_ = _tmp1506_;
			_tmp1486_ = _tmp1507_ > 0;
		} else {
			_tmp1486_ = FALSE;
		}
		if (_tmp1486_) {
			ValaExpression* _tmp1508_;
			ValaExpression* _tmp1509_;
			ValaMethod* _tmp1510_;
			ValaSymbol* _tmp1511_;
			ValaSymbol* _tmp1512_;
			ValaObjectType* _tmp1513_;
			ValaObjectType* _tmp1514_;
			ValaExpression* _tmp1515_;
			ValaExpression* _tmp1516_;
			ValaDataType* _tmp1517_;
			ValaDataType* _tmp1518_;
			ValaSourceReference* _tmp1519_;
			ValaSourceReference* _tmp1520_;
			_tmp1508_ = vala_member_access_get_inner (self);
			_tmp1509_ = _tmp1508_;
			_tmp1510_ = m;
			_tmp1511_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1510_);
			_tmp1512_ = _tmp1511_;
			_tmp1513_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1512_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1514_ = _tmp1513_;
			vala_expression_set_value_type (_tmp1509_, (ValaDataType*) _tmp1514_);
			_vala_code_node_unref0 (_tmp1514_);
			_tmp1515_ = vala_member_access_get_inner (self);
			_tmp1516_ = _tmp1515_;
			_tmp1517_ = vala_expression_get_value_type (_tmp1516_);
			_tmp1518_ = _tmp1517_;
			_tmp1519_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1520_ = _tmp1519_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1518_, _tmp1520_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1521_;
				ValaList* _tmp1522_;
				gint _type_argument_size = 0;
				ValaList* _tmp1523_;
				gint _tmp1524_;
				gint _tmp1525_;
				gint _type_argument_index = 0;
				_tmp1521_ = inner_ma;
				_tmp1522_ = _tmp1521_->priv->type_argument_list;
				_type_argument_list = _tmp1522_;
				_tmp1523_ = _type_argument_list;
				_tmp1524_ = vala_collection_get_size ((ValaCollection*) _tmp1523_);
				_tmp1525_ = _tmp1524_;
				_type_argument_size = _tmp1525_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1526_;
					gint _tmp1527_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1528_;
					gpointer _tmp1529_;
					ValaExpression* _tmp1530_;
					ValaExpression* _tmp1531_;
					ValaDataType* _tmp1532_;
					ValaDataType* _tmp1533_;
					ValaDataType* _tmp1534_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1526_ = _type_argument_index;
					_tmp1527_ = _type_argument_size;
					if (!(_tmp1526_ < _tmp1527_)) {
						break;
					}
					_tmp1528_ = _type_argument_list;
					_tmp1529_ = vala_list_get (_tmp1528_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1529_;
					_tmp1530_ = vala_member_access_get_inner (self);
					_tmp1531_ = _tmp1530_;
					_tmp1532_ = vala_expression_get_value_type (_tmp1531_);
					_tmp1533_ = _tmp1532_;
					_tmp1534_ = type_argument;
					vala_data_type_add_type_argument (_tmp1533_, _tmp1534_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1535_ = vala_code_context_get_analyzer (context);
		_tmp1536_ = _tmp1535_;
		_tmp1537_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1538_ = _tmp1537_;
		_tmp1539_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1540_ = _tmp1539_;
		_tmp1541_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1536_, _tmp1538_, _tmp1540_);
		_tmp1542_ = _tmp1541_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1542_);
		_vala_code_node_unref0 (_tmp1542_);
		_tmp1544_ = vala_member_access_get_inner (self);
		_tmp1545_ = _tmp1544_;
		if (_tmp1545_ != NULL) {
			ValaDataType* _tmp1546_;
			ValaDataType* _tmp1547_;
			_tmp1546_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1547_ = _tmp1546_;
			_tmp1543_ = _tmp1547_ != NULL;
		} else {
			_tmp1543_ = FALSE;
		}
		if (_tmp1543_) {
			ValaDataType* _tmp1548_;
			ValaDataType* _tmp1549_;
			ValaExpression* _tmp1550_;
			ValaExpression* _tmp1551_;
			ValaDataType* _tmp1552_;
			ValaDataType* _tmp1553_;
			ValaDataType* _tmp1554_;
			ValaDataType* _tmp1555_;
			_tmp1548_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1549_ = _tmp1548_;
			_tmp1550_ = vala_member_access_get_inner (self);
			_tmp1551_ = _tmp1550_;
			_tmp1552_ = vala_expression_get_value_type (_tmp1551_);
			_tmp1553_ = _tmp1552_;
			_tmp1554_ = vala_data_type_get_actual_type (_tmp1549_, _tmp1553_, NULL, (ValaCodeNode*) self);
			_tmp1555_ = _tmp1554_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1555_);
			_vala_code_node_unref0 (_tmp1555_);
		} else {
			ValaDataType* _tmp1556_;
			ValaDataType* _tmp1557_;
			_tmp1556_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1557_ = _tmp1556_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1557_);
		}
		_tmp1558_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1559_ = _tmp1558_;
		if (VALA_IS_METHOD (_tmp1559_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1560_;
			ValaSymbol* _tmp1561_;
			ValaDataType* _tmp1562_;
			ValaDataType* _tmp1563_;
			gboolean _tmp1570_ = FALSE;
			_tmp1560_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1561_ = _tmp1560_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1561_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1562_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1563_ = _tmp1562_;
			if (_tmp1563_ != NULL) {
				ValaDataType* _tmp1564_;
				ValaDataType* _tmp1565_;
				ValaDataType* _tmp1566_;
				ValaDataType* _tmp1567_;
				gboolean _tmp1568_;
				gboolean _tmp1569_;
				_tmp1564_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1565_ = _tmp1564_;
				_tmp1566_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1567_ = _tmp1566_;
				_tmp1568_ = vala_data_type_get_value_owned (_tmp1567_);
				_tmp1569_ = _tmp1568_;
				vala_data_type_set_value_owned (_tmp1565_, _tmp1569_);
			}
			if (instance) {
				ValaMethod* _tmp1571_;
				ValaSymbol* _tmp1572_;
				ValaSymbol* _tmp1573_;
				_tmp1571_ = method;
				_tmp1572_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1571_);
				_tmp1573_ = _tmp1572_;
				_tmp1570_ = VALA_IS_TYPESYMBOL (_tmp1573_);
			} else {
				_tmp1570_ = FALSE;
			}
			if (_tmp1570_) {
				ValaExpression* _tmp1574_;
				ValaExpression* _tmp1575_;
				ValaMethod* _tmp1576_;
				ValaSymbol* _tmp1577_;
				ValaSymbol* _tmp1578_;
				ValaDataType* _tmp1579_;
				ValaDataType* _tmp1580_;
				ValaExpression* _tmp1581_;
				ValaExpression* _tmp1582_;
				ValaDataType* _tmp1583_;
				ValaDataType* _tmp1584_;
				ValaMethod* _tmp1585_;
				ValaParameter* _tmp1586_;
				ValaParameter* _tmp1587_;
				ValaDataType* _tmp1588_;
				ValaDataType* _tmp1589_;
				gboolean _tmp1590_;
				gboolean _tmp1591_;
				_tmp1574_ = vala_member_access_get_inner (self);
				_tmp1575_ = _tmp1574_;
				_tmp1576_ = method;
				_tmp1577_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1576_);
				_tmp1578_ = _tmp1577_;
				_tmp1579_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1578_);
				_tmp1580_ = _tmp1579_;
				vala_expression_set_target_type (_tmp1575_, _tmp1580_);
				_vala_code_node_unref0 (_tmp1580_);
				_tmp1581_ = vala_member_access_get_inner (self);
				_tmp1582_ = _tmp1581_;
				_tmp1583_ = vala_expression_get_target_type (_tmp1582_);
				_tmp1584_ = _tmp1583_;
				_tmp1585_ = method;
				_tmp1586_ = vala_method_get_this_parameter (_tmp1585_);
				_tmp1587_ = _tmp1586_;
				_tmp1588_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1587_);
				_tmp1589_ = _tmp1588_;
				_tmp1590_ = vala_data_type_get_value_owned (_tmp1589_);
				_tmp1591_ = _tmp1590_;
				vala_data_type_set_value_owned (_tmp1584_, _tmp1591_);
			}
		} else {
			gboolean _tmp1592_ = FALSE;
			gboolean _tmp1593_ = FALSE;
			ValaSymbol* _tmp1594_;
			ValaSymbol* _tmp1595_;
			_tmp1594_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1595_ = _tmp1594_;
			if (VALA_IS_PROPERTY (_tmp1595_)) {
				_tmp1593_ = instance;
			} else {
				_tmp1593_ = FALSE;
			}
			if (_tmp1593_) {
				ValaSymbol* _tmp1596_;
				ValaSymbol* _tmp1597_;
				ValaSymbol* _tmp1598_;
				ValaSymbol* _tmp1599_;
				_tmp1596_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1597_ = _tmp1596_;
				_tmp1598_ = vala_symbol_get_parent_symbol (_tmp1597_);
				_tmp1599_ = _tmp1598_;
				_tmp1592_ = _tmp1599_ != NULL;
			} else {
				_tmp1592_ = FALSE;
			}
			if (_tmp1592_) {
				ValaExpression* _tmp1600_;
				ValaExpression* _tmp1601_;
				ValaSymbol* _tmp1602_;
				ValaSymbol* _tmp1603_;
				ValaSymbol* _tmp1604_;
				ValaSymbol* _tmp1605_;
				ValaDataType* _tmp1606_;
				ValaDataType* _tmp1607_;
				_tmp1600_ = vala_member_access_get_inner (self);
				_tmp1601_ = _tmp1600_;
				_tmp1602_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1603_ = _tmp1602_;
				_tmp1604_ = vala_symbol_get_parent_symbol (_tmp1603_);
				_tmp1605_ = _tmp1604_;
				_tmp1606_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1605_);
				_tmp1607_ = _tmp1606_;
				vala_expression_set_target_type (_tmp1601_, _tmp1607_);
				_vala_code_node_unref0 (_tmp1607_);
			} else {
				gboolean _tmp1608_ = FALSE;
				gboolean _tmp1609_ = FALSE;
				gboolean _tmp1610_ = FALSE;
				ValaSymbol* _tmp1611_;
				ValaSymbol* _tmp1612_;
				_tmp1611_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1612_ = _tmp1611_;
				if (VALA_IS_FIELD (_tmp1612_)) {
					_tmp1610_ = TRUE;
				} else {
					ValaSymbol* _tmp1613_;
					ValaSymbol* _tmp1614_;
					_tmp1613_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1614_ = _tmp1613_;
					_tmp1610_ = VALA_IS_SIGNAL (_tmp1614_);
				}
				if (_tmp1610_) {
					_tmp1609_ = instance;
				} else {
					_tmp1609_ = FALSE;
				}
				if (_tmp1609_) {
					ValaSymbol* _tmp1615_;
					ValaSymbol* _tmp1616_;
					ValaSymbol* _tmp1617_;
					ValaSymbol* _tmp1618_;
					_tmp1615_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1616_ = _tmp1615_;
					_tmp1617_ = vala_symbol_get_parent_symbol (_tmp1616_);
					_tmp1618_ = _tmp1617_;
					_tmp1608_ = _tmp1618_ != NULL;
				} else {
					_tmp1608_ = FALSE;
				}
				if (_tmp1608_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1619_;
					ValaSymbol* _tmp1620_;
					ValaSymbol* _tmp1621_;
					ValaSymbol* _tmp1622_;
					ValaDataType* _tmp1623_;
					ValaExpression* _tmp1624_;
					ValaExpression* _tmp1625_;
					ValaDataType* _tmp1626_;
					ValaExpression* _tmp1627_;
					ValaExpression* _tmp1628_;
					ValaDataType* _tmp1629_;
					ValaDataType* _tmp1630_;
					ValaDataType* _tmp1631_;
					ValaDataType* _tmp1632_;
					_tmp1619_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1620_ = _tmp1619_;
					_tmp1621_ = vala_symbol_get_parent_symbol (_tmp1620_);
					_tmp1622_ = _tmp1621_;
					_tmp1623_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1622_);
					parent_type = _tmp1623_;
					_tmp1624_ = vala_member_access_get_inner (self);
					_tmp1625_ = _tmp1624_;
					_tmp1626_ = parent_type;
					_tmp1627_ = vala_member_access_get_inner (self);
					_tmp1628_ = _tmp1627_;
					_tmp1629_ = vala_expression_get_value_type (_tmp1628_);
					_tmp1630_ = _tmp1629_;
					_tmp1631_ = vala_data_type_get_actual_type (_tmp1626_, _tmp1630_, NULL, (ValaCodeNode*) self);
					_tmp1632_ = _tmp1631_;
					vala_expression_set_target_type (_tmp1625_, _tmp1632_);
					_vala_code_node_unref0 (_tmp1632_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1635_ = vala_member_access_get_inner (self);
		_tmp1636_ = _tmp1635_;
		if (_tmp1636_ == NULL) {
			ValaDataType* _tmp1637_;
			ValaDataType* _tmp1638_;
			_tmp1637_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1638_ = _tmp1637_;
			_tmp1634_ = _tmp1638_ != NULL;
		} else {
			_tmp1634_ = FALSE;
		}
		if (_tmp1634_) {
			ValaProfile _tmp1639_;
			ValaProfile _tmp1640_;
			_tmp1639_ = vala_code_context_get_profile (context);
			_tmp1640_ = _tmp1639_;
			_tmp1633_ = _tmp1640_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1633_ = FALSE;
		}
		if (_tmp1633_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1641_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1642_ = _tmp1641_;
	if (_tmp1642_ != NULL) {
		ValaDataType* _tmp1643_;
		ValaDataType* _tmp1644_;
		_tmp1643_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1644_ = _tmp1643_;
		vala_code_node_check ((ValaCodeNode*) _tmp1644_, context);
	}
	_tmp1645_ = self->priv->_tainted_access;
	if (!_tmp1645_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1646_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1647_ = _tmp1646_;
	result = !_tmp1647_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

