/* gnome-calculator.c generated by valac 0.18.1, the Vala compiler
 * generated from gnome-calculator.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <stdio.h>
#include "langinfo.h"


#define TYPE_CALCULATOR (calculator_get_type ())
#define CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALCULATOR, Calculator))
#define CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALCULATOR, CalculatorClass))
#define IS_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALCULATOR))
#define IS_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALCULATOR))
#define CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALCULATOR, CalculatorClass))

typedef struct _Calculator Calculator;
typedef struct _CalculatorClass CalculatorClass;
typedef struct _CalculatorPrivate CalculatorPrivate;

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;

#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_EQUATION (equation_get_type ())
#define EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION, Equation))
#define EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION, EquationClass))
#define IS_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION))
#define IS_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION))
#define EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION, EquationClass))

typedef struct _Equation Equation;
typedef struct _EquationClass EquationClass;

#define TYPE_SOLVE_EQUATION (solve_equation_get_type ())
#define SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOLVE_EQUATION, SolveEquation))
#define SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOLVE_EQUATION, SolveEquationClass))
#define IS_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOLVE_EQUATION))
#define IS_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOLVE_EQUATION))
#define SOLVE_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOLVE_EQUATION, SolveEquationClass))

typedef struct _SolveEquation SolveEquation;
typedef struct _SolveEquationClass SolveEquationClass;
typedef struct _EquationPrivate EquationPrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_ERROR_CODE (error_code_get_type ())

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))
#define _equation_unref0(var) ((var == NULL) ? NULL : (var = (equation_unref (var), NULL)))
typedef struct _SolveEquationPrivate SolveEquationPrivate;

#define TYPE_UNIT_MANAGER (unit_manager_get_type ())
#define UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_MANAGER, UnitManager))
#define UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_MANAGER, UnitManagerClass))
#define IS_UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_MANAGER))
#define IS_UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_MANAGER))
#define UNIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_MANAGER, UnitManagerClass))

typedef struct _UnitManager UnitManager;
typedef struct _UnitManagerClass UnitManagerClass;

struct _Calculator {
	GtkApplication parent_instance;
	CalculatorPrivate * priv;
};

struct _CalculatorClass {
	GtkApplicationClass parent_class;
};

struct _CalculatorPrivate {
	GSettings* settings;
	MathWindow* window;
	MathPreferencesDialog* preferences_dialog;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING
} ButtonMode;

struct _Equation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EquationPrivate * priv;
	gint base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _EquationClass {
	GTypeClass parent_class;
	void (*finalize) (Equation *self);
	gboolean (*variable_is_defined) (Equation* self, const gchar* name);
	Number* (*get_variable) (Equation* self, const gchar* name);
	void (*set_variable) (Equation* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Equation* self, const gchar* name);
	Number* (*get_function) (Equation* self, const gchar* name, Number* x);
	Number* (*convert) (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

struct _SolveEquation {
	Equation parent_instance;
	SolveEquationPrivate * priv;
};

struct _SolveEquationClass {
	EquationClass parent_class;
};


static gpointer calculator_parent_class = NULL;
static gchar* calculator_program_name;
static gchar* calculator_program_name = NULL;
static gchar* calculator_equation_string;
static gchar* calculator_equation_string = NULL;
static gpointer solve_equation_parent_class = NULL;

GType calculator_get_type (void) G_GNUC_CONST;
GType math_window_get_type (void) G_GNUC_CONST;
GType math_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CALCULATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CALCULATOR, CalculatorPrivate))
enum  {
	CALCULATOR_DUMMY_PROPERTY
};
static void calculator_copy_cb (Calculator* self);
static void _calculator_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_paste_cb (Calculator* self);
static void _calculator_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_undo_cb (Calculator* self);
static void _calculator_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_redo_cb (Calculator* self);
static void _calculator_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_mode_changed_cb (Calculator* self, GSimpleAction* action, GVariant* parameter);
static void _calculator_mode_changed_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_show_preferences_cb (Calculator* self);
static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_help_cb (Calculator* self);
static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_about_cb (Calculator* self);
static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_quit_cb (Calculator* self);
static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Calculator* calculator_new (void);
Calculator* calculator_construct (GType object_type);
static void calculator_real_startup (GApplication* base);
GType display_format_get_type (void) G_GNUC_CONST;
GType angle_unit_get_type (void) G_GNUC_CONST;
GType button_mode_get_type (void) G_GNUC_CONST;
MathEquation* math_equation_new (void);
MathEquation* math_equation_construct (GType object_type);
GType math_equation_get_type (void) G_GNUC_CONST;
void math_equation_set_accuracy (MathEquation* self, gint value);
void math_equation_set_word_size (MathEquation* self, gint value);
void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value);
void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value);
void math_equation_set_number_format (MathEquation* self, DisplayFormat value);
void math_equation_set_angle_units (MathEquation* self, AngleUnit value);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
MathWindow* math_window_new (GtkApplication* app, MathEquation* equation);
MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation);
GType math_buttons_get_type (void) G_GNUC_CONST;
MathButtons* math_window_get_buttons (MathWindow* self);
void math_buttons_set_programming_base (MathButtons* self, gint value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
static void __lambda41_ (Calculator* self, GParamSpec* pspec);
static void calculator_mode_cb (Calculator* self);
static void ___lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void calculator_real_activate (GApplication* base);
MathEquation* math_window_get_equation (MathWindow* self);
void math_equation_set (MathEquation* self, const gchar* text);
void math_equation_solve (MathEquation* self);
static void calculator_real_shutdown (GApplication* base);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_equation_get_accuracy (MathEquation* self);
gint math_equation_get_word_size (MathEquation* self);
gboolean math_equation_get_show_thousands_separators (MathEquation* self);
gboolean math_equation_get_show_trailing_zeroes (MathEquation* self);
DisplayFormat math_equation_get_number_format (MathEquation* self);
AngleUnit math_equation_get_angle_units (MathEquation* self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gint math_buttons_get_programming_base (MathButtons* self);
void math_equation_copy (MathEquation* self);
void math_equation_paste (MathEquation* self);
void math_equation_undo (MathEquation* self);
void math_equation_redo (MathEquation* self);
MathPreferencesDialog* math_preferences_dialog_new (MathEquation* equation);
MathPreferencesDialog* math_preferences_dialog_construct (GType object_type, MathEquation* equation);
gint calculator_main (gchar** args, int args_length1);
SolveEquation* solve_equation_new (const gchar* text);
SolveEquation* solve_equation_construct (GType object_type, const gchar* text);
gpointer equation_ref (gpointer instance);
void equation_unref (gpointer instance);
GParamSpec* param_spec_equation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_equation (GValue* value, gpointer v_object);
void value_take_equation (GValue* value, gpointer v_object);
gpointer value_get_equation (const GValue* value);
GType equation_get_type (void) G_GNUC_CONST;
GType solve_equation_get_type (void) G_GNUC_CONST;
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
GType error_code_get_type (void) G_GNUC_CONST;
Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
GType serializer_get_type (void) G_GNUC_CONST;
void serializer_set_representation_base (Serializer* self, guint representation_base);
gchar* serializer_to_string (Serializer* self, Number* x);
gchar* mp_get_error (void);
gchar* mp_error_code_to_string (ErrorCode error_code);
static void calculator_finalize (GObject* obj);
enum  {
	SOLVE_EQUATION_DUMMY_PROPERTY
};
Equation* equation_new (const gchar* expression);
Equation* equation_construct (GType object_type, const gchar* expression);
static Number* solve_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
GType unit_manager_get_type (void) G_GNUC_CONST;
UnitManager* unit_manager_get_default (void);
Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry CALCULATOR_app_entries[9] = {{"copy", _calculator_copy_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"paste", _calculator_paste_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"undo", _calculator_undo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"redo", _calculator_redo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"mode", _calculator_mode_changed_cb_gsimple_action_activate_callback, "s", "\"basic\"", NULL}, {"preferences", _calculator_show_preferences_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"help", _calculator_help_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"about", _calculator_about_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"quit", _calculator_quit_cb_gsimple_action_activate_callback, NULL, NULL, NULL}};

static void _calculator_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_copy_cb (self);
}


static void _calculator_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_paste_cb (self);
}


static void _calculator_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_undo_cb (self);
}


static void _calculator_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_redo_cb (self);
}


static void _calculator_mode_changed_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_mode_changed_cb (self, action, parameter);
}


static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_show_preferences_cb (self);
}


static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_help_cb (self);
}


static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_about_cb (self);
}


static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_quit_cb (self);
}


Calculator* calculator_construct (GType object_type) {
	Calculator * self = NULL;
	self = (Calculator*) g_object_new (object_type, "flags", G_APPLICATION_NON_UNIQUE, NULL);
	return self;
}


Calculator* calculator_new (void) {
	return calculator_construct (TYPE_CALCULATOR);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda41_ (Calculator* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	calculator_mode_cb (self);
}


static void ___lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda41_ (self, pspec);
}


static void calculator_real_startup (GApplication* base) {
	Calculator * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gint _tmp2_ = 0;
	gint accuracy;
	GSettings* _tmp3_;
	gint _tmp4_ = 0;
	gint word_size;
	GSettings* _tmp5_;
	gint _tmp6_ = 0;
	gint number_base;
	GSettings* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean show_tsep;
	GSettings* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean show_zeroes;
	GSettings* _tmp11_;
	gint _tmp12_ = 0;
	DisplayFormat number_format;
	GSettings* _tmp13_;
	gint _tmp14_ = 0;
	AngleUnit angle_units;
	GSettings* _tmp15_;
	gint _tmp16_ = 0;
	ButtonMode button_mode;
	GSettings* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* source_currency;
	GSettings* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* target_currency;
	GSettings* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* source_units;
	GSettings* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* target_units;
	MathEquation* _tmp25_;
	MathEquation* equation;
	MathWindow* _tmp26_;
	MathWindow* _tmp27_;
	MathButtons* _tmp28_;
	MathButtons* _tmp29_;
	MathButtons* _tmp30_;
	MathButtons* buttons;
	GtkBuilder* _tmp31_;
	GtkBuilder* builder;
	GObject* _tmp33_ = NULL;
	GMenuModel* _tmp34_;
	GMenuModel* menu;
	GError * _inner_error_ = NULL;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.calculator");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_int (_tmp1_, "accuracy");
	accuracy = _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, "word-size");
	word_size = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_int (_tmp5_, "base");
	number_base = _tmp6_;
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_boolean (_tmp7_, "show-thousands");
	show_tsep = _tmp8_;
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_boolean (_tmp9_, "show-zeroes");
	show_zeroes = _tmp10_;
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_enum (_tmp11_, "number-format");
	number_format = (DisplayFormat) _tmp12_;
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_enum (_tmp13_, "angle-units");
	angle_units = (AngleUnit) _tmp14_;
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_enum (_tmp15_, "button-mode");
	button_mode = (ButtonMode) _tmp16_;
	_tmp17_ = self->priv->settings;
	_tmp18_ = g_settings_get_string (_tmp17_, "source-currency");
	source_currency = _tmp18_;
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_string (_tmp19_, "target-currency");
	target_currency = _tmp20_;
	_tmp21_ = self->priv->settings;
	_tmp22_ = g_settings_get_string (_tmp21_, "source-units");
	source_units = _tmp22_;
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_get_string (_tmp23_, "target-units");
	target_units = _tmp24_;
	_tmp25_ = math_equation_new ();
	equation = _tmp25_;
	math_equation_set_accuracy (equation, accuracy);
	math_equation_set_word_size (equation, word_size);
	math_equation_set_show_thousands_separators (equation, show_tsep);
	math_equation_set_show_trailing_zeroes (equation, show_zeroes);
	math_equation_set_number_format (equation, number_format);
	math_equation_set_angle_units (equation, angle_units);
	math_equation_set_source_currency (equation, source_currency);
	math_equation_set_target_currency (equation, target_currency);
	math_equation_set_source_units (equation, source_units);
	math_equation_set_target_units (equation, target_units);
	g_action_map_add_action_entries ((GActionMap*) self, (const GActionEntry*) CALCULATOR_app_entries, G_N_ELEMENTS (CALCULATOR_app_entries), self);
	_tmp26_ = math_window_new ((GtkApplication*) self, equation);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp26_;
	_tmp27_ = self->priv->window;
	_tmp28_ = math_window_get_buttons (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _g_object_ref0 (_tmp29_);
	buttons = _tmp30_;
	math_buttons_set_programming_base (buttons, number_base);
	math_buttons_set_mode (buttons, button_mode);
	g_signal_connect_object ((GObject*) buttons, "notify::mode", (GCallback) ___lambda41__g_object_notify, self, 0);
	calculator_mode_cb (self);
	_tmp31_ = gtk_builder_new ();
	builder = _tmp31_;
	{
		gtk_builder_add_from_resource (builder, "/org/gnome/calculator/menu.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = e->message;
		g_error ("gnome-calculator.vala:84: Error loading menu UI: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_object_unref0 (buttons);
		_g_object_unref0 (equation);
		_g_free0 (target_units);
		_g_free0 (source_units);
		_g_free0 (target_currency);
		_g_free0 (source_currency);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp33_ = gtk_builder_get_object (builder, "appmenu");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp33_) : NULL);
	menu = _tmp34_;
	gtk_application_set_app_menu ((GtkApplication*) self, menu);
	gtk_application_add_accelerator ((GtkApplication*) self, "<control>C", "app.copy", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<control>V", "app.paste", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<control>Z", "app.undo", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<control><shift>Z", "app.redo", NULL);
	_g_object_unref0 (menu);
	_g_object_unref0 (builder);
	_g_object_unref0 (buttons);
	_g_object_unref0 (equation);
	_g_free0 (target_units);
	_g_free0 (source_units);
	_g_free0 (target_currency);
	_g_free0 (source_currency);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void calculator_real_activate (GApplication* base) {
	Calculator * self;
	MathWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp4_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	_tmp2_ = calculator_equation_string;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = calculator_equation_string;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_ = NULL;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar** equations;
		gint equations_length1;
		gint _equations_size_;
		_tmp5_ = calculator_equation_string;
		_tmp6_ = g_strcompress (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\n", 0);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = _vala_array_length (_tmp8_);
		_g_free0 (_tmp7_);
		equations = _tmp10_;
		equations_length1 = _tmp10__length1;
		_equations_size_ = equations_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp11_;
				_tmp11_ = TRUE;
				while (TRUE) {
					gboolean _tmp12_;
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gchar** _tmp16_;
					gint _tmp16__length1;
					gint _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gboolean _tmp23_;
					_tmp12_ = _tmp11_;
					if (!_tmp12_) {
						gint _tmp13_;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp14_ = i;
					_tmp15_ = equations;
					_tmp15__length1 = equations_length1;
					if (!(_tmp14_ < _tmp15__length1)) {
						break;
					}
					_tmp16_ = equations;
					_tmp16__length1 = equations_length1;
					_tmp17_ = i;
					_tmp18_ = _tmp16_[_tmp17_];
					_tmp19_ = string_strip (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = strlen (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = _tmp22_ > 0;
					_g_free0 (_tmp20_);
					if (_tmp23_) {
						MathWindow* _tmp24_;
						MathEquation* _tmp25_;
						MathEquation* _tmp26_;
						gchar** _tmp27_;
						gint _tmp27__length1;
						gint _tmp28_;
						const gchar* _tmp29_;
						_tmp24_ = self->priv->window;
						_tmp25_ = math_window_get_equation (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = equations;
						_tmp27__length1 = equations_length1;
						_tmp28_ = i;
						_tmp29_ = _tmp27_[_tmp28_];
						math_equation_set (_tmp26_, _tmp29_);
					} else {
						MathWindow* _tmp30_;
						MathEquation* _tmp31_;
						MathEquation* _tmp32_;
						_tmp30_ = self->priv->window;
						_tmp31_ = math_window_get_equation (_tmp30_);
						_tmp32_ = _tmp31_;
						math_equation_solve (_tmp32_);
					}
				}
			}
		}
		equations = (_vala_array_free (equations, equations_length1, (GDestroyNotify) g_free), NULL);
	}
}


static void calculator_real_shutdown (GApplication* base) {
	Calculator * self;
	MathWindow* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	MathEquation* _tmp3_;
	MathEquation* equation;
	MathWindow* _tmp4_;
	MathButtons* _tmp5_;
	MathButtons* _tmp6_;
	MathButtons* _tmp7_;
	MathButtons* buttons;
	GSettings* _tmp8_;
	ButtonMode _tmp9_;
	ButtonMode _tmp10_;
	GSettings* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GSettings* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GSettings* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GSettings* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GSettings* _tmp23_;
	DisplayFormat _tmp24_;
	DisplayFormat _tmp25_;
	GSettings* _tmp26_;
	AngleUnit _tmp27_;
	AngleUnit _tmp28_;
	GSettings* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GSettings* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GSettings* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GSettings* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GSettings* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->window;
	_tmp1_ = math_window_get_equation (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	equation = _tmp3_;
	_tmp4_ = self->priv->window;
	_tmp5_ = math_window_get_buttons (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	buttons = _tmp7_;
	_tmp8_ = self->priv->settings;
	_tmp9_ = math_buttons_get_mode (buttons);
	_tmp10_ = _tmp9_;
	g_settings_set_enum (_tmp8_, "button-mode", (gint) _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = math_equation_get_accuracy (equation);
	_tmp13_ = _tmp12_;
	g_settings_set_int (_tmp11_, "accuracy", _tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = math_equation_get_word_size (equation);
	_tmp16_ = _tmp15_;
	g_settings_set_int (_tmp14_, "word-size", _tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = math_equation_get_show_thousands_separators (equation);
	_tmp19_ = _tmp18_;
	g_settings_set_boolean (_tmp17_, "show-thousands", _tmp19_);
	_tmp20_ = self->priv->settings;
	_tmp21_ = math_equation_get_show_trailing_zeroes (equation);
	_tmp22_ = _tmp21_;
	g_settings_set_boolean (_tmp20_, "show-zeroes", _tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = math_equation_get_number_format (equation);
	_tmp25_ = _tmp24_;
	g_settings_set_enum (_tmp23_, "number-format", (gint) _tmp25_);
	_tmp26_ = self->priv->settings;
	_tmp27_ = math_equation_get_angle_units (equation);
	_tmp28_ = _tmp27_;
	g_settings_set_enum (_tmp26_, "angle-units", (gint) _tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = math_equation_get_source_currency (equation);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_;
	g_settings_set_string (_tmp29_, "source-currency", _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = self->priv->settings;
	_tmp34_ = math_equation_get_target_currency (equation);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	g_settings_set_string (_tmp33_, "target-currency", _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = self->priv->settings;
	_tmp38_ = math_equation_get_source_units (equation);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_;
	g_settings_set_string (_tmp37_, "source-units", _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = self->priv->settings;
	_tmp42_ = math_equation_get_target_units (equation);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_;
	g_settings_set_string (_tmp41_, "target-units", _tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = self->priv->settings;
	_tmp46_ = math_buttons_get_programming_base (buttons);
	_tmp47_ = _tmp46_;
	g_settings_set_int (_tmp45_, "base", _tmp47_);
	_g_object_unref0 (buttons);
	_g_object_unref0 (equation);
}


static void calculator_mode_cb (Calculator* self) {
	MathWindow* _tmp0_;
	MathButtons* _tmp1_;
	MathButtons* _tmp2_;
	MathButtons* _tmp3_;
	MathButtons* buttons;
	gchar* _tmp4_;
	gchar* state;
	MathButtons* _tmp5_;
	ButtonMode _tmp6_;
	ButtonMode _tmp7_;
	GAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_;
	GSimpleAction* action;
	const gchar* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = math_window_get_buttons (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buttons = _tmp3_;
	_tmp4_ = g_strdup ("basic");
	state = _tmp4_;
	_tmp5_ = buttons;
	_tmp6_ = math_buttons_get_mode (_tmp5_);
	_tmp7_ = _tmp6_;
	switch (_tmp7_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("basic");
			_g_free0 (state);
			state = _tmp8_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("advanced");
			_g_free0 (state);
			state = _tmp9_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("financial");
			_g_free0 (state);
			state = _tmp10_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("programming");
			_g_free0 (state);
			state = _tmp11_;
			break;
		}
	}
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp12_) : NULL);
	action = _tmp13_;
	_tmp14_ = state;
	_tmp15_ = g_variant_new_string (_tmp14_);
	g_variant_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	g_simple_action_set_state (action, _tmp16_);
	_g_variant_unref0 (_tmp16_);
	_g_object_unref0 (action);
	_g_free0 (state);
	_g_object_unref0 (buttons);
}


static void calculator_copy_cb (Calculator* self) {
	MathWindow* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = math_window_get_equation (_tmp0_);
	_tmp2_ = _tmp1_;
	math_equation_copy (_tmp2_);
}


static void calculator_paste_cb (Calculator* self) {
	MathWindow* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = math_window_get_equation (_tmp0_);
	_tmp2_ = _tmp1_;
	math_equation_paste (_tmp2_);
}


static void calculator_undo_cb (Calculator* self) {
	MathWindow* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = math_window_get_equation (_tmp0_);
	_tmp2_ = _tmp1_;
	math_equation_undo (_tmp2_);
}


static void calculator_redo_cb (Calculator* self) {
	MathWindow* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = math_window_get_equation (_tmp0_);
	_tmp2_ = _tmp1_;
	math_equation_redo (_tmp2_);
}


static void calculator_mode_changed_cb (Calculator* self, GSimpleAction* action, GVariant* parameter) {
	ButtonMode mode;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* mode_str;
	const gchar* _tmp3_;
	MathWindow* _tmp7_;
	MathButtons* _tmp8_;
	MathButtons* _tmp9_;
	ButtonMode _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	mode = BUTTON_MODE_BASIC;
	_tmp0_ = parameter;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	mode_str = _tmp2_;
	_tmp3_ = mode_str;
	if (g_strcmp0 (_tmp3_, "basic") == 0) {
		mode = BUTTON_MODE_BASIC;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = mode_str;
		if (g_strcmp0 (_tmp4_, "advanced") == 0) {
			mode = BUTTON_MODE_ADVANCED;
		} else {
			const gchar* _tmp5_;
			_tmp5_ = mode_str;
			if (g_strcmp0 (_tmp5_, "financial") == 0) {
				mode = BUTTON_MODE_FINANCIAL;
			} else {
				const gchar* _tmp6_;
				_tmp6_ = mode_str;
				if (g_strcmp0 (_tmp6_, "programming") == 0) {
					mode = BUTTON_MODE_PROGRAMMING;
				}
			}
		}
	}
	_tmp7_ = self->priv->window;
	_tmp8_ = math_window_get_buttons (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = mode;
	math_buttons_set_mode (_tmp9_, _tmp10_);
	_g_free0 (mode_str);
}


static void calculator_show_preferences_cb (Calculator* self) {
	MathPreferencesDialog* _tmp0_;
	MathPreferencesDialog* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ == NULL) {
		MathWindow* _tmp1_;
		MathEquation* _tmp2_;
		MathEquation* _tmp3_;
		MathPreferencesDialog* _tmp4_;
		MathPreferencesDialog* _tmp5_;
		MathWindow* _tmp6_;
		_tmp1_ = self->priv->window;
		_tmp2_ = math_window_get_equation (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = math_preferences_dialog_new (_tmp3_);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp4_;
		_tmp5_ = self->priv->preferences_dialog;
		_tmp6_ = self->priv->window;
		gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp6_);
	}
	_tmp7_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp7_);
}


static void calculator_help_cb (Calculator* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		MathWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-calculator", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* message;
		MathWindow* _tmp5_;
		const gchar* _tmp6_;
		GtkMessageDialog* _tmp7_;
		GtkMessageDialog* d;
		GtkMessageDialog* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GtkMessageDialog* _tmp11_;
		GtkMessageDialog* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Unable to open help file");
		_tmp4_ = g_strdup (_tmp3_);
		message = _tmp4_;
		_tmp5_ = self->priv->window;
		_tmp6_ = message;
		_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp5_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp6_);
		g_object_ref_sink (_tmp7_);
		d = _tmp7_;
		_tmp8_ = d;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		gtk_message_dialog_format_secondary_text (_tmp8_, "%s", _tmp10_);
		_tmp11_ = d;
		gtk_dialog_run ((GtkDialog*) _tmp11_);
		_tmp12_ = d;
		gtk_widget_destroy ((GtkWidget*) _tmp12_);
		_g_object_unref0 (d);
		_g_free0 (message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void calculator_about_cb (Calculator* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** documenters;
	gint documenters_length1;
	gint _documenters_size_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* translator_credits;
	gchar* _tmp9_;
	gchar* license;
	MathWindow* _tmp10_;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Rich Burridge <rich.burridge@gmail.com>");
	_tmp1_ = g_strdup ("Robert Ancell <robert.ancell@gmail.com>");
	_tmp2_ = g_strdup ("Klaus Niederkrüger <kniederk@umpa.ens-lyon.fr>");
	_tmp3_ = g_strdup ("Robin Sonefors <ozamosi@flukkost.nu>");
	_tmp4_ = g_new0 (gchar*, 5 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp4_[4] = NULL;
	authors = _tmp4_;
	authors_length1 = 5;
	_authors_size_ = authors_length1;
	_tmp5_ = g_strdup ("Sun Microsystems");
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp6_[1] = NULL;
	documenters = _tmp6_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp7_ = _ ("translator-credits");
	_tmp8_ = g_strdup (_tmp7_);
	translator_credits = _tmp8_;
	_tmp9_ = g_strdup ("This program is free software; you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation; either version 2 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program; if not, write to the Free Software Foundation" \
", Inc.,\n" \
"51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA");
	license = _tmp9_;
	_tmp10_ = self->priv->window;
	_tmp11_ = _ ("Calculator");
	_tmp12_ = _ ("Calculator with financial and scientific modes.");
	gtk_show_about_dialog ((GtkWindow*) _tmp10_, "name", _tmp11_, "version", VERSION, "copyright", "\xc2\xa9 1986–2012 The Calculator authors", "license", license, "comments", _tmp12_, "authors", authors, "documenters", documenters, "translator_credits", translator_credits, "logo-icon-name", "accessories-calculator", NULL);
	_g_free0 (license);
	_g_free0 (translator_credits);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void calculator_quit_cb (Calculator* self) {
	MathWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gint calculator_main (gchar** args, int args_length1) {
	gint result = 0;
	GDateTime* _tmp0_;
	GDateTime* now;
	GDateTime* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	GOptionEntry* _tmp6_ = NULL;
	GOptionEntry* options;
	gint options_length1;
	gint _options_size_;
	gchar* solve_equation;
	GOptionEntry* _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_ = NULL;
	GOptionEntry _tmp9_ = {0};
	GOptionEntry _tmp10_;
	GOptionEntry* _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_ = NULL;
	GOptionEntry _tmp13_ = {0};
	GOptionEntry _tmp14_;
	gboolean show_version;
	GOptionEntry* _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_ = NULL;
	GOptionEntry _tmp17_ = {0};
	GOptionEntry _tmp18_;
	GOptionEntry* _tmp19_;
	gint _tmp19__length1;
	GOptionEntry _tmp20_ = {0};
	GOptionEntry _tmp21_;
	gboolean _tmp30_;
	const gchar* _tmp33_;
	Calculator* _tmp71_;
	Calculator* app;
	Calculator* _tmp72_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	gint _tmp74_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	_tmp1_ = now;
	_tmp2_ = g_date_time_get_microsecond (_tmp1_);
	g_random_set_seed ((guint32) _tmp2_);
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_path_get_basename (_tmp4_);
	_g_free0 (calculator_program_name);
	calculator_program_name = _tmp5_;
	_tmp6_ = g_new0 (GOptionEntry, 4);
	options = _tmp6_;
	options_length1 = 4;
	_options_size_ = options_length1;
	solve_equation = NULL;
	_tmp7_ = options;
	_tmp7__length1 = options_length1;
	_tmp8_ = _ ("Solve given equation");
	_tmp9_.long_name = "solve";
	_tmp9_.short_name = 's';
	_tmp9_.flags = 0;
	_tmp9_.arg = G_OPTION_ARG_STRING;
	_tmp9_.arg_data = &solve_equation;
	_tmp9_.description = _tmp8_;
	_tmp9_.arg_description = "equation";
	_tmp7_[0] = _tmp9_;
	_tmp10_ = _tmp7_[0];
	_tmp11_ = options;
	_tmp11__length1 = options_length1;
	_tmp12_ = _ ("Start with given equation");
	_tmp13_.long_name = "equation";
	_tmp13_.short_name = 'e';
	_tmp13_.flags = 0;
	_tmp13_.arg = G_OPTION_ARG_STRING;
	_tmp13_.arg_data = &calculator_equation_string;
	_tmp13_.description = _tmp12_;
	_tmp13_.arg_description = "equation";
	_tmp11_[1] = _tmp13_;
	_tmp14_ = _tmp11_[1];
	show_version = FALSE;
	_tmp15_ = options;
	_tmp15__length1 = options_length1;
	_tmp16_ = _ ("Show release version");
	_tmp17_.long_name = "version";
	_tmp17_.short_name = 'v';
	_tmp17_.flags = 0;
	_tmp17_.arg = G_OPTION_ARG_NONE;
	_tmp17_.arg_data = &show_version;
	_tmp17_.description = _tmp16_;
	_tmp17_.arg_description = NULL;
	_tmp15_[2] = _tmp17_;
	_tmp18_ = _tmp15_[2];
	_tmp19_ = options;
	_tmp19__length1 = options_length1;
	_tmp20_.long_name = NULL;
	_tmp20_.short_name = (gchar) 0;
	_tmp20_.flags = 0;
	_tmp20_.arg = 0;
	_tmp20_.arg_data = NULL;
	_tmp20_.description = NULL;
	_tmp20_.arg_description = NULL;
	_tmp19_[3] = _tmp20_;
	_tmp21_ = _tmp19_[3];
	{
		GOptionEntry* _tmp22_;
		gint _tmp22__length1;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
		_tmp22_ = options;
		_tmp22__length1 = options_length1;
		_tmp23_ = gtk_init_with_args (&args_length1, &args, "Perform mathematical calculations", _tmp22_, NULL, &_inner_error_);
		_tmp24_ = _tmp23_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		if (!_tmp24_) {
			FILE* _tmp25_;
			_tmp25_ = stderr;
			fprintf (_tmp25_, "Unable to initialize GTK+\n");
			result = EXIT_FAILURE;
			_g_free0 (solve_equation);
			options = (g_free (options), NULL);
			_g_date_time_unref0 (now);
			return result;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp26_;
		GError* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = stderr;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		_tmp29_ = calculator_program_name;
		fprintf (_tmp26_, "%s\nUse '%s --help' to display help.\n", _tmp28_, _tmp29_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_free0 (solve_equation);
		options = (g_free (options), NULL);
		_g_date_time_unref0 (now);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (solve_equation);
		options = (g_free (options), NULL);
		_g_date_time_unref0 (now);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp30_ = show_version;
	if (_tmp30_) {
		FILE* _tmp31_;
		const gchar* _tmp32_;
		_tmp31_ = stderr;
		_tmp32_ = calculator_program_name;
		fprintf (_tmp31_, "%1$s %2$s\n", _tmp32_, VERSION);
		result = EXIT_SUCCESS;
		_g_free0 (solve_equation);
		options = (g_free (options), NULL);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp33_ = solve_equation;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* tsep_string;
		gboolean _tmp36_ = FALSE;
		const gchar* _tmp37_;
		gboolean _tmp39_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		SolveEquation* _tmp45_;
		SolveEquation* _tmp46_;
		SolveEquation* e;
		SolveEquation* _tmp47_;
		SolveEquation* _tmp48_;
		SolveEquation* _tmp49_;
		ErrorCode _error_ = 0;
		guint representation_base = 0U;
		SolveEquation* _tmp50_;
		guint _tmp51_ = 0U;
		ErrorCode _tmp52_ = 0;
		Number* _tmp53_ = NULL;
		Number* _result_;
		Number* _tmp54_;
		_tmp34_ = nl_langinfo (THOUSEP);
		_tmp35_ = g_strdup (_tmp34_);
		tsep_string = _tmp35_;
		_tmp37_ = tsep_string;
		if (_tmp37_ == NULL) {
			_tmp36_ = TRUE;
		} else {
			const gchar* _tmp38_;
			_tmp38_ = tsep_string;
			_tmp36_ = g_strcmp0 (_tmp38_, "") == 0;
		}
		_tmp39_ = _tmp36_;
		if (_tmp39_) {
			gchar* _tmp40_;
			_tmp40_ = g_strdup (" ");
			_g_free0 (tsep_string);
			tsep_string = _tmp40_;
		}
		_tmp41_ = solve_equation;
		_tmp42_ = tsep_string;
		_tmp43_ = string_replace (_tmp41_, _tmp42_, "");
		_tmp44_ = _tmp43_;
		_tmp45_ = solve_equation_new (_tmp44_);
		_tmp46_ = _tmp45_;
		_g_free0 (_tmp44_);
		e = _tmp46_;
		_tmp47_ = e;
		((Equation*) _tmp47_)->base = 10;
		_tmp48_ = e;
		((Equation*) _tmp48_)->wordlen = 32;
		_tmp49_ = e;
		((Equation*) _tmp49_)->angle_units = ANGLE_UNIT_DEGREES;
		_tmp50_ = e;
		_tmp53_ = equation_parse ((Equation*) _tmp50_, &_tmp51_, &_tmp52_, NULL, NULL, NULL);
		representation_base = _tmp51_;
		_error_ = _tmp52_;
		_result_ = _tmp53_;
		_tmp54_ = _result_;
		if (_tmp54_ != NULL) {
			Serializer* _tmp55_;
			Serializer* serializer;
			Serializer* _tmp56_;
			guint _tmp57_;
			FILE* _tmp58_;
			Serializer* _tmp59_;
			Number* _tmp60_;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_;
			_tmp55_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
			serializer = _tmp55_;
			_tmp56_ = serializer;
			_tmp57_ = representation_base;
			serializer_set_representation_base (_tmp56_, _tmp57_);
			_tmp58_ = stdout;
			_tmp59_ = serializer;
			_tmp60_ = _result_;
			_tmp61_ = serializer_to_string (_tmp59_, _tmp60_);
			_tmp62_ = _tmp61_;
			fprintf (_tmp58_, "%s\n", _tmp62_);
			_g_free0 (_tmp62_);
			result = EXIT_SUCCESS;
			_g_object_unref0 (serializer);
			_number_unref0 (_result_);
			_equation_unref0 (e);
			_g_free0 (tsep_string);
			_g_free0 (solve_equation);
			options = (g_free (options), NULL);
			_g_date_time_unref0 (now);
			return result;
		} else {
			ErrorCode _tmp63_;
			_tmp63_ = _error_;
			if (_tmp63_ == ERROR_CODE_MP) {
				FILE* _tmp64_;
				gchar* _tmp65_ = NULL;
				gchar* _tmp66_;
				_tmp64_ = stderr;
				_tmp65_ = mp_get_error ();
				_tmp66_ = _tmp65_;
				fprintf (_tmp64_, "Error: %s\n", _tmp66_);
				_g_free0 (_tmp66_);
				result = EXIT_FAILURE;
				_number_unref0 (_result_);
				_equation_unref0 (e);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				options = (g_free (options), NULL);
				_g_date_time_unref0 (now);
				return result;
			} else {
				FILE* _tmp67_;
				ErrorCode _tmp68_;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_;
				_tmp67_ = stderr;
				_tmp68_ = _error_;
				_tmp69_ = mp_error_code_to_string (_tmp68_);
				_tmp70_ = _tmp69_;
				fprintf (_tmp67_, "Error: %s\n", _tmp70_);
				_g_free0 (_tmp70_);
				result = EXIT_FAILURE;
				_number_unref0 (_result_);
				_equation_unref0 (e);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				options = (g_free (options), NULL);
				_g_date_time_unref0 (now);
				return result;
			}
		}
		_number_unref0 (_result_);
		_equation_unref0 (e);
		_g_free0 (tsep_string);
	}
	gtk_window_set_default_icon_name ("accessories-calculator");
	_tmp71_ = calculator_new ();
	app = _tmp71_;
	_tmp72_ = app;
	_tmp73_ = args;
	_tmp73__length1 = args_length1;
	_tmp74_ = g_application_run ((GApplication*) _tmp72_, _tmp73__length1, _tmp73_);
	result = _tmp74_;
	_g_object_unref0 (app);
	_g_free0 (solve_equation);
	options = (g_free (options), NULL);
	_g_date_time_unref0 (now);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return calculator_main (argv, argc);
}


static void calculator_class_init (CalculatorClass * klass) {
	calculator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CalculatorPrivate));
	G_APPLICATION_CLASS (klass)->startup = calculator_real_startup;
	G_APPLICATION_CLASS (klass)->activate = calculator_real_activate;
	G_APPLICATION_CLASS (klass)->shutdown = calculator_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = calculator_finalize;
}


static void calculator_instance_init (Calculator * self) {
	self->priv = CALCULATOR_GET_PRIVATE (self);
}


static void calculator_finalize (GObject* obj) {
	Calculator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALCULATOR, Calculator);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->preferences_dialog);
	G_OBJECT_CLASS (calculator_parent_class)->finalize (obj);
}


GType calculator_get_type (void) {
	static volatile gsize calculator_type_id__volatile = 0;
	if (g_once_init_enter (&calculator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Calculator), 0, (GInstanceInitFunc) calculator_instance_init, NULL };
		GType calculator_type_id;
		calculator_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Calculator", &g_define_type_info, 0);
		g_once_init_leave (&calculator_type_id__volatile, calculator_type_id);
	}
	return calculator_type_id__volatile;
}


SolveEquation* solve_equation_construct (GType object_type, const gchar* text) {
	SolveEquation* self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	self = (SolveEquation*) equation_construct (object_type, _tmp0_);
	return self;
}


SolveEquation* solve_equation_new (const gchar* text) {
	return solve_equation_construct (TYPE_SOLVE_EQUATION, text);
}


static Number* solve_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	SolveEquation * self;
	Number* result = NULL;
	UnitManager* _tmp0_ = NULL;
	UnitManager* _tmp1_;
	Number* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	Number* _tmp5_ = NULL;
	Number* _tmp6_;
	self = (SolveEquation*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = unit_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = x_units;
	_tmp4_ = z_units;
	_tmp5_ = unit_manager_convert_by_symbol (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	result = _tmp6_;
	return result;
}


static void solve_equation_class_init (SolveEquationClass * klass) {
	solve_equation_parent_class = g_type_class_peek_parent (klass);
	EQUATION_CLASS (klass)->convert = solve_equation_real_convert;
}


static void solve_equation_instance_init (SolveEquation * self) {
}


GType solve_equation_get_type (void) {
	static volatile gsize solve_equation_type_id__volatile = 0;
	if (g_once_init_enter (&solve_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SolveEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) solve_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SolveEquation), 0, (GInstanceInitFunc) solve_equation_instance_init, NULL };
		GType solve_equation_type_id;
		solve_equation_type_id = g_type_register_static (TYPE_EQUATION, "SolveEquation", &g_define_type_info, 0);
		g_once_init_leave (&solve_equation_type_id__volatile, solve_equation_type_id);
	}
	return solve_equation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



