/* avatar-cache.c generated by valac 0.20.1.51-7ff1, the Vala compiler
 * generated from avatar-cache.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_AVATAR_CACHE_TESTS (avatar_cache_tests_get_type ())
#define AVATAR_CACHE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTests))
#define AVATAR_CACHE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsClass))
#define IS_AVATAR_CACHE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_CACHE_TESTS))
#define IS_AVATAR_CACHE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_CACHE_TESTS))
#define AVATAR_CACHE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsClass))

typedef struct _AvatarCacheTests AvatarCacheTests;
typedef struct _AvatarCacheTestsClass AvatarCacheTestsClass;
typedef struct _AvatarCacheTestsPrivate AvatarCacheTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AvatarCacheTests {
	FolksTestCase parent_instance;
	AvatarCacheTestsPrivate * priv;
};

struct _AvatarCacheTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AvatarCacheTestsPrivate {
	FolksAvatarCache* _cache;
	GFile* _cache_dir;
	GLoadableIcon* _avatar;
	GMainLoop* _main_loop;
};

struct _Block1Data {
	int _ref_count_;
	AvatarCacheTests * self;
	GLoadableIcon* avatar;
};


static gpointer avatar_cache_tests_parent_class = NULL;

GType avatar_cache_tests_get_type (void) G_GNUC_CONST;
#define AVATAR_CACHE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsPrivate))
enum  {
	AVATAR_CACHE_TESTS_DUMMY_PROPERTY
};
AvatarCacheTests* avatar_cache_tests_new (void);
AvatarCacheTests* avatar_cache_tests_construct (GType object_type);
void avatar_cache_tests_test_store_and_load_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_store_avatar_overwrite (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_load_avatar_non_existent (AvatarCacheTests* self);
static void _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_remove_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_remove_avatar_non_existent (AvatarCacheTests* self);
static void _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_build_uri_for_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method (gpointer self);
static void avatar_cache_tests_real_set_up (FolksTestCase* base);
void _avatar_cache_tests_delete_cache_directory (AvatarCacheTests* self);
static void avatar_cache_tests_real_tear_down (FolksTestCase* base);
void _avatar_cache_tests_delete_directory (AvatarCacheTests* self, GFile* dir, GError** error);
void _avatar_cache_tests_assert_store_avatar (AvatarCacheTests* self, const gchar* id, GLoadableIcon* avatar);
static void __lambda2_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GLoadableIcon* _avatar_cache_tests_assert_load_avatar (AvatarCacheTests* self, const gchar* id);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void _avatar_cache_tests_assert_remove_avatar (AvatarCacheTests* self, const gchar* id);
static void __lambda5_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void _avatar_cache_tests_assert_avatars_equal (AvatarCacheTests* self, GLoadableIcon* a, GLoadableIcon* b);
static void __lambda4_ (AvatarCacheTests* self, GObject* object, GAsyncResult* _result_);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void avatar_cache_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method (gpointer self) {
#line 43 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_store_and_load_avatar (self);
#line 120 "avatar-cache.c"
}


static void _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method (gpointer self) {
#line 44 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_store_avatar_overwrite (self);
#line 127 "avatar-cache.c"
}


static void _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method (gpointer self) {
#line 46 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_load_avatar_non_existent (self);
#line 134 "avatar-cache.c"
}


static void _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method (gpointer self) {
#line 48 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_remove_avatar (self);
#line 141 "avatar-cache.c"
}


static void _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method (gpointer self) {
#line 49 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_remove_avatar_non_existent (self);
#line 148 "avatar-cache.c"
}


static void _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method (gpointer self) {
#line 51 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_build_uri_for_avatar (self);
#line 155 "avatar-cache.c"
}


AvatarCacheTests* avatar_cache_tests_construct (GType object_type) {
	AvatarCacheTests * self = NULL;
	gchar* tmp_path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 34 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) folks_test_case_construct (object_type, "AvatarCache");
#line 38 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = g_get_tmp_dir ();
#line 38 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = g_strconcat (_tmp0_, "/folks-avatar-cache-tests", NULL);
#line 38 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	tmp_path = _tmp1_;
#line 39 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_setenv ("XDG_CACHE_HOME", tmp_path, TRUE);
#line 40 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = g_get_user_cache_dir ();
#line 40 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (g_strcmp0 (_tmp2_, tmp_path) == 0, "Environment.get_user_cache_dir () == tmp_path");
#line 41 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = g_file_new_for_path (tmp_path);
#line 41 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache_dir);
#line 41 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache_dir = _tmp3_;
#line 43 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "store-and-load-avatar", _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method, self);
#line 44 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "store-avatar-overwrite", _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method, self);
#line 46 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "load-avatar-non-existent", _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method, self);
#line 48 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "remove-avatar", _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method, self);
#line 49 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "remove-avatar-non-existent", _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method, self);
#line 51 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "build-uri-for-avatar", _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method, self);
#line 32 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_free0 (tmp_path);
#line 32 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	return self;
#line 202 "avatar-cache.c"
}


AvatarCacheTests* avatar_cache_tests_new (void) {
#line 32 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	return avatar_cache_tests_construct (TYPE_AVATAR_CACHE_TESTS);
#line 209 "avatar-cache.c"
}


static void avatar_cache_tests_real_set_up (FolksTestCase* base) {
	AvatarCacheTests * self;
	FolksAvatarCache* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFileIcon* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
#line 54 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) base;
#line 56 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	FOLKS_TEST_CASE_CLASS (avatar_cache_tests_parent_class)->set_up (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 57 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_delete_cache_directory (self);
#line 59 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = folks_avatar_cache_dup ();
#line 59 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 59 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache = _tmp0_;
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = folks_test_utils_get_source_test_data ("data/avatar-01.jpg");
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = _tmp1_;
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp4_ = _tmp3_;
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp5_ = (GFileIcon*) g_file_icon_new (_tmp4_);
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_avatar = (GLoadableIcon*) _tmp5_;
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (_tmp4_);
#line 60 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_free0 (_tmp2_);
#line 64 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp6_ = g_main_loop_new (NULL, FALSE);
#line 64 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 64 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_main_loop = _tmp6_;
#line 258 "avatar-cache.c"
}


static void avatar_cache_tests_real_tear_down (FolksTestCase* base) {
	AvatarCacheTests * self;
#line 67 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) base;
#line 69 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 69 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_main_loop = NULL;
#line 70 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 70 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_avatar = NULL;
#line 71 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 71 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache = NULL;
#line 72 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_delete_cache_directory (self);
#line 73 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	FOLKS_TEST_CASE_CLASS (avatar_cache_tests_parent_class)->tear_down (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 282 "avatar-cache.c"
}


void _avatar_cache_tests_delete_directory (AvatarCacheTests* self, GFile* dir, GError** error) {
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp0_ = NULL;
	GFileEnumerator* _tmp1_ = NULL;
	GFileInfo* file_info = NULL;
	GFileEnumerator* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileEnumerator* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 76 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 76 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (dir != NULL);
#line 79 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = dir;
#line 79 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = g_file_enumerate_children (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 79 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	enumerator = _tmp1_;
#line 79 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 79 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 79 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 312 "avatar-cache.c"
	}
#line 83 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = enumerator;
#line 83 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error_);
#line 83 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	file_info = _tmp3_;
#line 83 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 83 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 83 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 83 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 328 "avatar-cache.c"
	}
#line 84 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	while (TRUE) {
#line 332 "avatar-cache.c"
		GFileInfo* _tmp4_ = NULL;
		GFile* child_file = NULL;
		GFile* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFileType _tmp10_ = 0;
		GFileInfo* _tmp13_ = NULL;
		GFileEnumerator* _tmp14_ = NULL;
		GFileInfo* _tmp15_ = NULL;
#line 84 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = file_info;
#line 84 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		if (!(_tmp4_ != NULL)) {
#line 84 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			break;
#line 350 "avatar-cache.c"
		}
#line 86 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp5_ = dir;
#line 86 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp6_ = file_info;
#line 86 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp7_ = g_file_info_get_name (_tmp6_);
#line 86 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp8_ = g_file_get_child (_tmp5_, _tmp7_);
#line 86 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		child_file = _tmp8_;
#line 88 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp9_ = child_file;
#line 88 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp10_ = g_file_query_file_type (_tmp9_, G_FILE_QUERY_INFO_NONE, NULL);
#line 88 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		if (_tmp10_ == G_FILE_TYPE_DIRECTORY) {
#line 368 "avatar-cache.c"
			GFile* _tmp11_ = NULL;
#line 91 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			_tmp11_ = child_file;
#line 91 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			_avatar_cache_tests_delete_directory (self, _tmp11_, &_inner_error_);
#line 91 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			if (_inner_error_ != NULL) {
#line 91 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 91 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (child_file);
#line 91 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (file_info);
#line 91 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (enumerator);
#line 91 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				return;
#line 386 "avatar-cache.c"
			}
		} else {
			GFile* _tmp12_ = NULL;
#line 95 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			_tmp12_ = child_file;
#line 95 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			g_file_delete (_tmp12_, NULL, &_inner_error_);
#line 95 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			if (_inner_error_ != NULL) {
#line 95 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 95 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (child_file);
#line 95 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (file_info);
#line 95 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (enumerator);
#line 95 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
				return;
#line 406 "avatar-cache.c"
			}
		}
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp14_ = enumerator;
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp15_ = g_file_enumerator_next_file (_tmp14_, NULL, &_inner_error_);
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp13_ = _tmp15_;
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (child_file);
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (file_info);
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (enumerator);
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
			return;
#line 427 "avatar-cache.c"
		}
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 98 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		file_info = _tmp13_;
#line 84 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (child_file);
#line 435 "avatar-cache.c"
	}
#line 100 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp16_ = enumerator;
#line 100 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_file_enumerator_close (_tmp16_, NULL, &_inner_error_);
#line 100 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 100 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 100 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 100 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 100 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 451 "avatar-cache.c"
	}
#line 103 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp17_ = dir;
#line 103 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_file_delete (_tmp17_, NULL, &_inner_error_);
#line 103 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 103 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 103 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 103 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 103 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 467 "avatar-cache.c"
	}
#line 76 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (file_info);
#line 76 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (enumerator);
#line 473 "avatar-cache.c"
}


void _avatar_cache_tests_delete_cache_directory (AvatarCacheTests* self) {
	GError * _inner_error_ = NULL;
#line 106 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 481 "avatar-cache.c"
	{
		GFile* _tmp0_ = NULL;
#line 110 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache_dir;
#line 110 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_avatar_cache_tests_delete_directory (self, _tmp0_, &_inner_error_);
#line 110 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 490 "avatar-cache.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 108 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 108 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 108 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 504 "avatar-cache.c"
	}
	__finally0:
#line 108 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 108 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 108 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 108 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 515 "avatar-cache.c"
	}
}


static void __lambda2_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res) {
	GMainLoop* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 120 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 525 "avatar-cache.c"
	{
		FolksAvatarCache* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 124 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache;
#line 124 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = res;
#line 124 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = folks_avatar_cache_store_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 124 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp3_ = _tmp2_;
#line 124 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_free0 (_tmp3_);
#line 124 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 543 "avatar-cache.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
#line 122 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 122 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 128 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = e->message;
#line 128 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:128: Error storing avatar: %s", _tmp4_);
#line 122 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 562 "avatar-cache.c"
	}
	__finally1:
#line 122 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 122 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 122 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 573 "avatar-cache.c"
	}
#line 131 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp5_ = self->priv->_main_loop;
#line 131 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp5_);
#line 579 "avatar-cache.c"
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 120 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	__lambda2_ (self, source_object, res);
#line 120 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 588 "avatar-cache.c"
}


void _avatar_cache_tests_assert_store_avatar (AvatarCacheTests* self, const gchar* id, GLoadableIcon* avatar) {
	FolksAvatarCache* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GLoadableIcon* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
#line 118 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 118 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (id != NULL);
#line 118 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (avatar != NULL);
#line 120 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 120 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 120 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = avatar;
#line 120 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_store_avatar (_tmp0_, _tmp1_, _tmp2_, ___lambda2__gasync_ready_callback, g_object_ref (self));
#line 134 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_main_loop;
#line 134 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp3_);
#line 615 "avatar-cache.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	return _data1_;
#line 624 "avatar-cache.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 633 "avatar-cache.c"
		AvatarCacheTests * self;
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		self = _data1_->self;
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_data1_->avatar);
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (self);
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_slice_free (Block1Data, _data1_);
#line 643 "avatar-cache.c"
	}
}


static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	AvatarCacheTests * self;
	GMainLoop* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 141 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self = _data1_->self;
#line 141 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 656 "avatar-cache.c"
	{
		GLoadableIcon* _tmp0_ = NULL;
		FolksAvatarCache* _tmp1_ = NULL;
		GAsyncResult* _tmp2_ = NULL;
		GLoadableIcon* _tmp3_ = NULL;
#line 145 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = self->priv->_cache;
#line 145 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = res;
#line 145 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp3_ = folks_avatar_cache_load_avatar_finish (_tmp1_, _tmp2_, &_inner_error_);
#line 145 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = _tmp3_;
#line 145 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 672 "avatar-cache.c"
			goto __catch2_g_error;
		}
#line 145 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_data1_->avatar);
#line 145 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_data1_->avatar = _tmp0_;
#line 679 "avatar-cache.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
#line 143 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 143 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 149 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = e->message;
#line 149 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:149: Error loading avatar: %s", _tmp4_);
#line 143 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 696 "avatar-cache.c"
	}
	__finally2:
#line 143 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 143 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 143 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 707 "avatar-cache.c"
	}
#line 152 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp5_ = self->priv->_main_loop;
#line 152 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp5_);
#line 713 "avatar-cache.c"
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 141 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	__lambda3_ (self, source_object, res);
#line 141 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	block1_data_unref (self);
#line 722 "avatar-cache.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 157 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	return self ? g_object_ref (self) : NULL;
#line 729 "avatar-cache.c"
}


GLoadableIcon* _avatar_cache_tests_assert_load_avatar (AvatarCacheTests* self, const gchar* id) {
	GLoadableIcon* result = NULL;
	Block1Data* _data1_;
	FolksAvatarCache* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	GLoadableIcon* _tmp3_ = NULL;
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_data1_->_ref_count_ = 1;
#line 137 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_data1_->self = g_object_ref (self);
#line 139 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_data1_->avatar = NULL;
#line 141 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 141 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 141 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_load_avatar (_tmp0_, _tmp1_, ___lambda3__gasync_ready_callback, block1_data_ref (_data1_));
#line 155 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 155 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 157 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _g_object_ref0 (_data1_->avatar);
#line 157 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	result = _tmp3_;
#line 157 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	block1_data_unref (_data1_);
#line 157 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_data1_ = NULL;
#line 157 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	return result;
#line 772 "avatar-cache.c"
}


static void __lambda5_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res) {
	GMainLoop* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 162 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 781 "avatar-cache.c"
	{
		FolksAvatarCache* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
#line 166 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache;
#line 166 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = res;
#line 166 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		folks_avatar_cache_remove_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 166 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 793 "avatar-cache.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
#line 164 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 164 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 170 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = e->message;
#line 170 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:170: Error removing avatar: %s", _tmp2_);
#line 164 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 812 "avatar-cache.c"
	}
	__finally3:
#line 164 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 164 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 164 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 823 "avatar-cache.c"
	}
#line 173 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_main_loop;
#line 173 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp3_);
#line 829 "avatar-cache.c"
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 162 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	__lambda5_ (self, source_object, res);
#line 162 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 838 "avatar-cache.c"
}


void _avatar_cache_tests_assert_remove_avatar (AvatarCacheTests* self, const gchar* id) {
	FolksAvatarCache* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
#line 160 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 160 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (id != NULL);
#line 162 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 162 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 162 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_remove_avatar (_tmp0_, _tmp1_, ___lambda5__gasync_ready_callback, g_object_ref (self));
#line 176 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 176 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 860 "avatar-cache.c"
}


static void __lambda4_ (AvatarCacheTests* self, GObject* object, GAsyncResult* _result_) {
	GAsyncResult* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GMainLoop* _tmp2_ = NULL;
#line 181 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (_result_ != NULL);
#line 183 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _result_;
#line 183 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = folks_test_utils_loadable_icons_content_equal_finish (_tmp0_);
#line 183 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (_tmp1_, "TestUtils.loadable_icons_content_equal.end (result)");
#line 184 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 184 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp2_);
#line 880 "avatar-cache.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 181 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	__lambda4_ (self, source_object, res);
#line 181 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 889 "avatar-cache.c"
}


void _avatar_cache_tests_assert_avatars_equal (AvatarCacheTests* self, GLoadableIcon* a, GLoadableIcon* b) {
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
#line 179 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 179 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (a != NULL);
#line 179 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (b != NULL);
#line 181 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = a;
#line 181 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = b;
#line 181 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_utils_loadable_icons_content_equal (_tmp0_, _tmp1_, -1, ___lambda4__gasync_ready_callback, g_object_ref (self));
#line 187 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 187 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 913 "avatar-cache.c"
}


void avatar_cache_tests_test_store_and_load_avatar (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* avatar = NULL;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* _tmp2_ = NULL;
#line 190 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 193 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 193 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-id", _tmp0_);
#line 196 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = _avatar_cache_tests_assert_load_avatar (self, "test-store-avatar-id");
#line 196 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp1_;
#line 199 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (avatar != NULL, "avatar != null");
#line 200 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (avatar, g_loadable_icon_get_type ()), "avatar is LoadableIcon");
#line 201 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_avatar;
#line 201 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_avatars_equal (self, _tmp2_, avatar);
#line 190 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 942 "avatar-cache.c"
}


void avatar_cache_tests_test_store_avatar_overwrite (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* avatar = NULL;
	GLoadableIcon* _tmp2_ = NULL;
	GLoadableIcon* _tmp3_ = NULL;
#line 204 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 207 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 207 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-ow-id", _tmp0_);
#line 208 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = self->priv->_avatar;
#line 208 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-ow-id", _tmp1_);
#line 211 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = _avatar_cache_tests_assert_load_avatar (self, "test-store-avatar-ow-id");
#line 211 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp2_;
#line 214 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (avatar != NULL, "avatar != null");
#line 215 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (avatar, g_loadable_icon_get_type ()), "avatar is LoadableIcon");
#line 216 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_avatar;
#line 216 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_avatars_equal (self, _tmp3_, avatar);
#line 204 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 976 "avatar-cache.c"
}


void avatar_cache_tests_test_load_avatar_non_existent (AvatarCacheTests* self) {
	GLoadableIcon* avatar = NULL;
	GLoadableIcon* _tmp0_ = NULL;
#line 219 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 222 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _avatar_cache_tests_assert_load_avatar (self, "test-load-avatar-non-existent");
#line 222 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp0_;
#line 223 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (avatar == NULL, "avatar == null");
#line 219 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 993 "avatar-cache.c"
}


void avatar_cache_tests_test_remove_avatar (AvatarCacheTests* self) {
	GLoadableIcon* avatar = NULL;
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* _tmp2_ = NULL;
	GLoadableIcon* _tmp3_ = NULL;
	GLoadableIcon* _tmp4_ = NULL;
#line 226 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 228 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar = NULL;
#line 231 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 231 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-remove-avatar", _tmp0_);
#line 234 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar");
#line 234 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 234 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp1_;
#line 235 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = avatar;
#line 235 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (_tmp2_ != NULL, "avatar != null");
#line 238 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_remove_avatar (self, "test-remove-avatar");
#line 241 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar");
#line 241 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 241 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp3_;
#line 242 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp4_ = avatar;
#line 242 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (_tmp4_ == NULL, "avatar == null");
#line 226 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 1036 "avatar-cache.c"
}


void avatar_cache_tests_test_remove_avatar_non_existent (AvatarCacheTests* self) {
	GLoadableIcon* avatar = NULL;
	GLoadableIcon* _tmp0_ = NULL;
#line 245 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 248 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar-non-existent");
#line 248 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp0_;
#line 249 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (avatar == NULL, "avatar == null");
#line 252 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_remove_avatar (self, "test-remove-avatar-non-existent");
#line 245 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 1055 "avatar-cache.c"
}


void avatar_cache_tests_test_build_uri_for_avatar (AvatarCacheTests* self) {
	gchar* uri = NULL;
	FolksAvatarCache* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 255 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 258 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 258 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = folks_avatar_cache_build_uri_for_avatar (_tmp0_, "test-id");
#line 258 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	uri = _tmp1_;
#line 259 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (uri != NULL, "uri != null");
#line 260 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = g_uri_parse_scheme (uri);
#line 260 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _tmp2_;
#line 260 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (_tmp3_ != NULL, "Uri.parse_scheme (uri) != null");
#line 260 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_free0 (_tmp3_);
#line 255 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_free0 (uri);
#line 1085 "avatar-cache.c"
}


static void avatar_cache_tests_class_init (AvatarCacheTestsClass * klass) {
#line 25 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_parent_class = g_type_class_peek_parent (klass);
#line 25 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_type_class_add_private (klass, sizeof (AvatarCacheTestsPrivate));
#line 25 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	FOLKS_TEST_CASE_CLASS (klass)->set_up = avatar_cache_tests_real_set_up;
#line 25 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = avatar_cache_tests_real_tear_down;
#line 25 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	G_OBJECT_CLASS (klass)->finalize = avatar_cache_tests_finalize;
#line 1100 "avatar-cache.c"
}


static void avatar_cache_tests_instance_init (AvatarCacheTests * self) {
#line 25 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self->priv = AVATAR_CACHE_TESTS_GET_PRIVATE (self);
#line 1107 "avatar-cache.c"
}


static void avatar_cache_tests_finalize (GObject* obj) {
	AvatarCacheTests * self;
#line 25 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_CACHE_TESTS, AvatarCacheTests);
#line 27 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 28 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache_dir);
#line 29 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 30 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 25 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	G_OBJECT_CLASS (avatar_cache_tests_parent_class)->finalize (obj);
#line 1125 "avatar-cache.c"
}


GType avatar_cache_tests_get_type (void) {
	static volatile gsize avatar_cache_tests_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_cache_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarCacheTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_cache_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarCacheTests), 0, (GInstanceInitFunc) avatar_cache_tests_instance_init, NULL };
		GType avatar_cache_tests_type_id;
		avatar_cache_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AvatarCacheTests", &g_define_type_info, 0);
		g_once_init_leave (&avatar_cache_tests_type_id__volatile, avatar_cache_tests_type_id);
	}
	return avatar_cache_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	AvatarCacheTests* tests = NULL;
	AvatarCacheTests* _tmp0_ = NULL;
#line 266 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_test_init (&args_length1, &args, NULL);
#line 268 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = avatar_cache_tests_new ();
#line 268 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	tests = _tmp0_;
#line 269 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_register ((FolksTestCase*) tests);
#line 270 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_test_run ();
#line 271 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_final_tear_down ((FolksTestCase*) tests);
#line 273 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	result = 0;
#line 273 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (tests);
#line 273 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	return result;
#line 1163 "avatar-cache.c"
}


int main (int argc, char ** argv) {
#line 264 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	g_type_init ();
#line 264 "/opt/gnome3/source/folks/tests/folks/avatar-cache.vala"
	return _vala_main (argv, argc);
#line 1172 "avatar-cache.c"
}



