/* contacts-contact-sheet.c generated by valac 0.20.1.71-45f6, the Vala compiler
 * generated from contacts-contact-sheet.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <folks/folks.h>
#include <gee.h>
#include <gio/gio.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks-telepathy.h>
#include <glib/gi18n-lib.h>


#define CONTACTS_TYPE_CONTACT_SHEET (contacts_contact_sheet_get_type ())
#define CONTACTS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet))
#define CONTACTS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))
#define CONTACTS_IS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_IS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_CONTACT_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))

typedef struct _ContactsContactSheet ContactsContactSheet;
typedef struct _ContactsContactSheetClass ContactsContactSheetClass;
typedef struct _ContactsContactSheetPrivate ContactsContactSheetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _Block16Data Block16Data;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block17Data Block17Data;

#define CONTACTS_TYPE_TYPESET (contacts_typeset_get_type ())
#define CONTACTS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSet))
#define CONTACTS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))
#define CONTACTS_IS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPESET))
#define CONTACTS_IS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPESET))
#define CONTACTS_TYPESET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))

typedef struct _ContactsTypeSet ContactsTypeSet;
typedef struct _ContactsTypeSetClass ContactsTypeSetClass;
typedef struct _Block18Data Block18Data;

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
typedef struct _ContactsStorePrivate ContactsStorePrivate;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;

#define CONTACTS_CONTACT_TYPE_IM_DISPLAY (contacts_contact_im_display_get_type ())
typedef struct _Block21Data Block21Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ContactsContactSheet {
	GtkGrid parent_instance;
	ContactsContactSheetPrivate * priv;
};

struct _ContactsContactSheetClass {
	GtkGridClass parent_class;
};

struct _Block16Data {
	int _ref_count_;
	ContactsContactSheet * self;
	ContactsContact* c;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	FolksEmailFieldDetails* email;
};

struct _Block18Data {
	int _ref_count_;
	Block16Data * _data16_;
	FolksPhoneFieldDetails* phone;
};

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsStore* contacts_store;
	ContactsWindow* window;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};

struct _ContactsStore {
	GObject parent_instance;
	ContactsStorePrivate * priv;
	GeeHashMap* calling_accounts;
	GeeHashMultiMap* dont_suggest_link;
};

struct _ContactsStoreClass {
	GObjectClass parent_class;
};

struct _Block19Data {
	int _ref_count_;
	Block16Data * _data16_;
	gchar* protocol;
};

struct _Block20Data {
	int _ref_count_;
	Block19Data * _data19_;
	FolksImFieldDetails* id;
};

typedef enum  {
	CONTACTS_CONTACT_IM_DISPLAY_DEFAULT,
	CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE
} ContactsContactImDisplay;

struct _Block21Data {
	int _ref_count_;
	Block16Data * _data16_;
	FolksUrlFieldDetails* url;
};


static gpointer contacts_contact_sheet_parent_class = NULL;
extern ContactsApp* contacts_app_app;

GType contacts_contact_sheet_get_type (void) G_GNUC_CONST;
enum  {
	CONTACTS_CONTACT_SHEET_DUMMY_PROPERTY
};
static GtkButton* contacts_contact_sheet_add_row_with_button (ContactsContactSheet* self, gint* row, const gchar* label_value, const gchar* value);
static void contacts_contact_sheet_add_row_with_label (ContactsContactSheet* self, gint* row, const gchar* label_value, const gchar* value);
ContactsContactSheet* contacts_contact_sheet_new (void);
ContactsContactSheet* contacts_contact_sheet_construct (GType object_type);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_contact_sheet_update (ContactsContactSheet* self, ContactsContact* c);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define PROFILE_SIZE 128
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static void __lambda29_ (Block16Data* _data16_, GtkWidget* w);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
GType contacts_store_get_type (void) G_GNUC_CONST;
static void ___lambda29__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda30_ (Block16Data* _data16_, GtkWidget* w);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void ___lambda30__gtk_callback (GtkWidget* widget, gpointer self);
GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self);
GeeList* contacts_contact_get_personas_for_display (ContactsContact* self);
gchar* contacts_contact_format_persona_store_name_for_contact (FolksPersona* persona);
GeeArrayList* contacts_contact_sort_fields (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* fields);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
GType contacts_typeset_get_type (void) G_GNUC_CONST;
ContactsTypeSet* contacts_typeset_get_email (void);
gchar* contacts_typeset_format_type (ContactsTypeSet* self, FolksAbstractFieldDetails* detail);
static void _______lambda31_ (Block17Data* _data17_);
void contacts_utils_compose_mail (const gchar* email);
static void ________lambda31__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_window_get_type (void) G_GNUC_CONST;
gboolean contacts_store_get_can_call (ContactsStore* self);
ContactsTypeSet* contacts_typeset_get_phone (void);
static void ________lambda32_ (Block18Data* _data18_);
void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts);
static void _________lambda32__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
GType contacts_contact_im_display_get_type (void) G_GNUC_CONST;
gchar* contacts_contact_format_im_service (const gchar* service, ContactsContactImDisplay* display);
static void __________lambda33_ (Block20Data* _data20_);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
static void ___________lambda33__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
gchar* contacts_contact_format_uri_link_text (FolksUrlFieldDetails* detail);
static void _______lambda34_ (Block21Data* _data21_);
static void ________lambda34__gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean contacts_is_set (const gchar* str);
gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1);
ContactsTypeSet* contacts_typeset_get_general (void);
void contacts_contact_sheet_clear (ContactsContactSheet* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GtkButton* contacts_contact_sheet_add_row_with_button (ContactsContactSheet* self, gint* row, const gchar* label_value, const gchar* value) {
	GtkButton* result = NULL;
	GtkLabel* type_label = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkButton* value_button = NULL;
	const gchar* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label_value != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = label_value;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	type_label = _tmp1_;
	g_object_set ((GtkMisc*) type_label, "xalign", 1.0f, NULL);
	gtk_widget_set_halign ((GtkWidget*) type_label, GTK_ALIGN_END);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) type_label);
	gtk_style_context_add_class (_tmp2_, "dim-label");
	_tmp3_ = *row;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) type_label, 0, _tmp3_, 1, 1);
	_tmp4_ = value;
	_tmp5_ = (GtkButton*) gtk_button_new_with_label (_tmp4_);
	g_object_ref_sink (_tmp5_);
	value_button = _tmp5_;
	gtk_button_set_focus_on_click (value_button, FALSE);
	gtk_button_set_relief (value_button, GTK_RELIEF_NONE);
	g_object_set (value_button, "xalign", 0.0f, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) value_button, TRUE);
	_tmp6_ = *row;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) value_button, 1, _tmp6_, 1, 1);
	_tmp7_ = *row;
	*row = _tmp7_ + 1;
	_tmp8_ = gtk_bin_get_child ((GtkBin*) value_button);
	gtk_label_set_ellipsize (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp8_) : NULL, PANGO_ELLIPSIZE_END);
	_tmp9_ = gtk_bin_get_child ((GtkBin*) value_button);
	g_object_set (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp9_) : NULL, "wrap-mode", PANGO_WRAP_CHAR, NULL);
	result = value_button;
	_g_object_unref0 (type_label);
	return result;
}


static void contacts_contact_sheet_add_row_with_label (ContactsContactSheet* self, gint* row, const gchar* label_value, const gchar* value) {
	GtkLabel* type_label = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkLabel* value_label = NULL;
	const gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label_value != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = label_value;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	type_label = _tmp1_;
	g_object_set ((GtkMisc*) type_label, "xalign", 1.0f, NULL);
	gtk_widget_set_halign ((GtkWidget*) type_label, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) type_label, GTK_ALIGN_START);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) type_label);
	gtk_style_context_add_class (_tmp2_, "dim-label");
	_tmp3_ = *row;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) type_label, 0, _tmp3_, 1, 1);
	_tmp4_ = value;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	value_label = _tmp5_;
	gtk_label_set_line_wrap (value_label, TRUE);
	g_object_set ((GtkMisc*) value_label, "xalign", 0.0f, NULL);
	gtk_widget_set_halign ((GtkWidget*) value_label, GTK_ALIGN_START);
	gtk_label_set_ellipsize (value_label, PANGO_ELLIPSIZE_END);
	g_object_set (value_label, "wrap-mode", PANGO_WRAP_CHAR, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) type_label, 3);
	gtk_widget_set_margin_left ((GtkWidget*) value_label, 6);
	gtk_widget_set_margin_top ((GtkWidget*) value_label, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) value_label, 3);
	_tmp6_ = *row;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) value_label, 1, _tmp6_, 1, 1);
	_tmp7_ = *row;
	*row = _tmp7_ + 1;
	_g_object_unref0 (value_label);
	_g_object_unref0 (type_label);
}


ContactsContactSheet* contacts_contact_sheet_construct (GType object_type) {
	ContactsContactSheet * self = NULL;
	self = (ContactsContactSheet*) g_object_new (object_type, NULL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, (guint) 12);
	gtk_grid_set_column_spacing ((GtkGrid*) self, (guint) 16);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	return self;
}


ContactsContactSheet* contacts_contact_sheet_new (void) {
	return contacts_contact_sheet_construct (CONTACTS_TYPE_CONTACT_SHEET);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->c);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}


static void __lambda29_ (Block16Data* _data16_, GtkWidget* w) {
	ContactsContactSheet * self;
	GtkWidget* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	self = _data16_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data16_->c;
	_tmp2_ = _tmp1_->individual;
	_tmp3_ = _data16_->c;
	contacts_contact_frame_set_image (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_CONTACT_FRAME) ? ((ContactsContactFrame*) _tmp0_) : NULL, (FolksAvatarDetails*) _tmp2_, _tmp3_);
}


static void ___lambda29__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda29_ (self, widget);
}


static void __lambda30_ (Block16Data* _data16_, GtkWidget* w) {
	ContactsContactSheet * self;
	GtkWidget* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	self = _data16_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data16_->c;
	_tmp2_ = contacts_contact_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_printf_escaped ("<span font='16'>%s</span>", _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp0_) : NULL, _tmp5_);
	_g_free0 (_tmp5_);
}


static void ___lambda30__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda30_ (self, widget);
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data17_->_data16_->self;
		_g_object_unref0 (_data17_->email);
		block16_data_unref (_data17_->_data16_);
		_data17_->_data16_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}


static void _______lambda31_ (Block17Data* _data17_) {
	Block16Data* _data16_;
	ContactsContactSheet * self;
	ContactsContact* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	FolksEmailFieldDetails* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	_tmp0_ = _data16_->c;
	_tmp1_ = contacts_contact_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data17_->email;
	_tmp4_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s <%s>", _tmp2_, (const gchar*) _tmp5_);
	_tmp7_ = _tmp6_;
	contacts_utils_compose_mail (_tmp7_);
	_g_free0 (_tmp7_);
}


static void ________lambda31__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_______lambda31_ (self);
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data18_->_data16_->self;
		_g_object_unref0 (_data18_->phone);
		block16_data_unref (_data18_->_data16_);
		_data18_->_data16_ = NULL;
		g_slice_free (Block18Data, _data18_);
	}
}


static void ________lambda32_ (Block18Data* _data18_) {
	Block16Data* _data16_;
	ContactsContactSheet * self;
	FolksPhoneFieldDetails* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ContactsApp* _tmp3_ = NULL;
	ContactsStore* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	_data16_ = _data18_->_data16_;
	self = _data16_->self;
	_tmp0_ = _data18_->phone;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_app_app;
	_tmp4_ = _tmp3_->contacts_store;
	_tmp5_ = _tmp4_->calling_accounts;
	contacts_utils_start_call ((const gchar*) _tmp2_, _tmp5_);
}


static void _________lambda32__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	________lambda32_ (self);
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (void * _userdata_) {
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data19_->_data16_->self;
		_g_free0 (_data19_->protocol);
		block16_data_unref (_data19_->_data16_);
		_data19_->_data16_ = NULL;
		g_slice_free (Block19Data, _data19_);
	}
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data20_->_data19_->_data16_->self;
		_g_object_unref0 (_data20_->id);
		block19_data_unref (_data20_->_data19_);
		_data20_->_data19_ = NULL;
		g_slice_free (Block20Data, _data20_);
	}
}


static void __________lambda33_ (Block20Data* _data20_) {
	Block19Data* _data19_;
	Block16Data* _data16_;
	ContactsContactSheet * self;
	TpfPersona* im_persona = NULL;
	ContactsContact* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	FolksImFieldDetails* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	TpfPersona* _tmp5_ = NULL;
	TpfPersona* _tmp6_ = NULL;
	_data19_ = _data20_->_data19_;
	_data16_ = _data19_->_data16_;
	self = _data16_->self;
	_tmp0_ = _data16_->c;
	_tmp1_ = _data19_->protocol;
	_tmp2_ = _data20_->id;
	_tmp3_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = contacts_contact_find_im_persona (_tmp0_, _tmp1_, (const gchar*) _tmp4_);
	im_persona = _tmp5_;
	_tmp6_ = im_persona;
	if (_tmp6_ != NULL) {
		FolksPresenceType type = 0;
		TpfPersona* _tmp7_ = NULL;
		FolksPresenceType _tmp8_ = 0;
		FolksPresenceType _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		FolksPresenceType _tmp13_ = 0;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp7_ = im_persona;
		_tmp8_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _tmp7_);
		_tmp9_ = _tmp8_;
		type = _tmp9_;
		_tmp13_ = type;
		if (_tmp13_ != FOLKS_PRESENCE_TYPE_UNSET) {
			FolksPresenceType _tmp14_ = 0;
			_tmp14_ = type;
			_tmp12_ = _tmp14_ != FOLKS_PRESENCE_TYPE_ERROR;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			FolksPresenceType _tmp16_ = 0;
			_tmp16_ = type;
			_tmp11_ = _tmp16_ != FOLKS_PRESENCE_TYPE_OFFLINE;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp17_ = _tmp11_;
		if (_tmp17_) {
			FolksPresenceType _tmp18_ = 0;
			_tmp18_ = type;
			_tmp10_ = _tmp18_ != FOLKS_PRESENCE_TYPE_UNKNOWN;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp19_ = _tmp10_;
		if (_tmp19_) {
			ContactsContact* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			FolksImFieldDetails* _tmp22_ = NULL;
			gconstpointer _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp20_ = _data16_->c;
			_tmp21_ = _data19_->protocol;
			_tmp22_ = _data20_->id;
			_tmp23_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp22_);
			_tmp24_ = _tmp23_;
			contacts_utils_start_chat (_tmp20_, _tmp21_, (const gchar*) _tmp24_);
		}
	}
	_g_object_unref0 (im_persona);
}


static void ___________lambda33__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__________lambda33_ (self);
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (void * _userdata_) {
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data21_->_data16_->self;
		_g_object_unref0 (_data21_->url);
		block16_data_unref (_data21_->_data16_);
		_data21_->_data16_ = NULL;
		g_slice_free (Block21Data, _data21_);
	}
}


static void _______lambda34_ (Block21Data* _data21_) {
	Block16Data* _data16_;
	ContactsContactSheet * self;
	FolksUrlFieldDetails* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	_data16_ = _data21_->_data16_;
	self = _data16_->self;
	_tmp0_ = _data21_->url;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	gtk_show_uri (NULL, (const gchar*) _tmp2_, (guint32) 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ________lambda34__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_______lambda34_ (self);
}


void contacts_contact_sheet_update (ContactsContactSheet* self, ContactsContact* c) {
	Block16Data* _data16_;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	ContactsContactFrame* image_frame = NULL;
	ContactsContactFrame* _tmp2_ = NULL;
	ContactsContactFrame* _tmp3_ = NULL;
	ContactsContactFrame* _tmp4_ = NULL;
	ContactsContact* _tmp5_ = NULL;
	ContactsContactFrame* _tmp6_ = NULL;
	ContactsContactFrame* _tmp7_ = NULL;
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	ContactsContact* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkWidget* merged_presence = NULL;
	ContactsContact* _tmp18_ = NULL;
	GtkWidget* _tmp19_ = NULL;
	GtkWidget* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	GtkWidget* _tmp22_ = NULL;
	gint i = 0;
	gint last_store_position = 0;
	gboolean is_first_persona = FALSE;
	GeeList* personas = NULL;
	ContactsContact* _tmp23_ = NULL;
	GeeList* _tmp24_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = c;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data16_->c);
	_data16_->c = _tmp1_;
	_tmp2_ = contacts_contact_frame_new (PROFILE_SIZE, FALSE);
	g_object_ref_sink (_tmp2_);
	image_frame = _tmp2_;
	_tmp3_ = image_frame;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = image_frame;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = _data16_->c;
	_tmp6_ = image_frame;
	contacts_contact_keep_widget_uptodate (_tmp5_, (GtkWidget*) _tmp6_, ___lambda29__gtk_callback, block16_data_ref (_data16_), block16_data_unref);
	_tmp7_ = image_frame;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp7_, 0, 0, 1, 3);
	_tmp8_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp8_);
	name_label = _tmp8_;
	_tmp9_ = name_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = name_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
	_tmp11_ = name_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
	_tmp12_ = name_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, 4);
	_tmp13_ = name_label;
	gtk_label_set_ellipsize (_tmp13_, PANGO_ELLIPSIZE_END);
	_tmp14_ = name_label;
	g_object_set ((GtkMisc*) _tmp14_, "xalign", 0.0f, NULL);
	_tmp15_ = _data16_->c;
	_tmp16_ = name_label;
	contacts_contact_keep_widget_uptodate (_tmp15_, (GtkWidget*) _tmp16_, ___lambda30__gtk_callback, block16_data_ref (_data16_), block16_data_unref);
	_tmp17_ = name_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp17_, 1, 0, 1, 1);
	_tmp18_ = _data16_->c;
	_tmp19_ = contacts_contact_create_merged_presence_widget (_tmp18_);
	merged_presence = _tmp19_;
	_tmp20_ = merged_presence;
	gtk_widget_set_halign (_tmp20_, GTK_ALIGN_START);
	_tmp21_ = merged_presence;
	gtk_widget_set_valign (_tmp21_, GTK_ALIGN_START);
	_tmp22_ = merged_presence;
	gtk_grid_attach ((GtkGrid*) self, _tmp22_, 1, 1, 1, 1);
	i = 3;
	last_store_position = 0;
	is_first_persona = TRUE;
	_tmp23_ = _data16_->c;
	_tmp24_ = contacts_contact_get_personas_for_display (_tmp23_);
	personas = _tmp24_;
	{
		GeeList* _p_list = NULL;
		GeeList* _tmp25_ = NULL;
		GeeList* _tmp26_ = NULL;
		gint _p_size = 0;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _p_index = 0;
		_tmp25_ = personas;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_p_list = _tmp26_;
		_tmp27_ = _p_list;
		_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_p_size = _tmp29_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			FolksPersona* p = NULL;
			GeeList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gpointer _tmp35_ = NULL;
			gboolean _tmp36_ = FALSE;
			FolksEmailDetails* details = NULL;
			FolksPersona* _tmp51_ = NULL;
			FolksEmailDetails* _tmp52_ = NULL;
			FolksEmailDetails* _tmp53_ = NULL;
			FolksPhoneDetails* phone_details = NULL;
			FolksPersona* _tmp80_ = NULL;
			FolksPhoneDetails* _tmp81_ = NULL;
			FolksPhoneDetails* _tmp82_ = NULL;
			FolksImDetails* im_details = NULL;
			FolksPersona* _tmp121_ = NULL;
			FolksImDetails* _tmp122_ = NULL;
			FolksImDetails* _tmp123_ = NULL;
			FolksUrlDetails* url_details = NULL;
			FolksPersona* _tmp157_ = NULL;
			FolksUrlDetails* _tmp158_ = NULL;
			FolksUrlDetails* _tmp159_ = NULL;
			FolksNameDetails* name_details = NULL;
			FolksPersona* _tmp175_ = NULL;
			FolksNameDetails* _tmp176_ = NULL;
			FolksNameDetails* _tmp177_ = NULL;
			FolksBirthdayDetails* birthday_details = NULL;
			FolksPersona* _tmp186_ = NULL;
			FolksBirthdayDetails* _tmp187_ = NULL;
			FolksBirthdayDetails* _tmp188_ = NULL;
			FolksNoteDetails* note_details = NULL;
			FolksPersona* _tmp200_ = NULL;
			FolksNoteDetails* _tmp201_ = NULL;
			FolksNoteDetails* _tmp202_ = NULL;
			FolksPostalAddressDetails* addr_details = NULL;
			FolksPersona* _tmp215_ = NULL;
			FolksPostalAddressDetails* _tmp216_ = NULL;
			FolksPostalAddressDetails* _tmp217_ = NULL;
			gint _tmp245_ = 0;
			gint _tmp246_ = 0;
			gint _tmp247_ = 0;
			_tmp30_ = _p_index;
			_p_index = _tmp30_ + 1;
			_tmp31_ = _p_index;
			_tmp32_ = _p_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _p_list;
			_tmp34_ = _p_index;
			_tmp35_ = gee_list_get (_tmp33_, _tmp34_);
			p = (FolksPersona*) _tmp35_;
			_tmp36_ = is_first_persona;
			if (!_tmp36_) {
				GtkLabel* store_name = NULL;
				GtkLabel* _tmp37_ = NULL;
				GtkLabel* _tmp38_ = NULL;
				FolksPersona* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				GtkLabel* _tmp44_ = NULL;
				GtkLabel* _tmp45_ = NULL;
				GtkLabel* _tmp46_ = NULL;
				GtkLabel* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				_tmp37_ = (GtkLabel*) gtk_label_new ("");
				g_object_ref_sink (_tmp37_);
				store_name = _tmp37_;
				_tmp38_ = store_name;
				_tmp39_ = p;
				_tmp40_ = contacts_contact_format_persona_store_name_for_contact (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_markup_printf_escaped ("<span font='16px bold'>%s</span>", _tmp41_);
				_tmp43_ = _tmp42_;
				gtk_label_set_markup (_tmp38_, _tmp43_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				_tmp44_ = store_name;
				gtk_widget_set_halign ((GtkWidget*) _tmp44_, GTK_ALIGN_START);
				_tmp45_ = store_name;
				g_object_set ((GtkMisc*) _tmp45_, "xalign", 0.0f, NULL);
				_tmp46_ = store_name;
				gtk_widget_set_margin_left ((GtkWidget*) _tmp46_, 6);
				_tmp47_ = store_name;
				_tmp48_ = i;
				gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp47_, 0, _tmp48_, 3, 1);
				_tmp49_ = i;
				i = _tmp49_ + 1;
				_tmp50_ = i;
				last_store_position = _tmp50_;
				_g_object_unref0 (store_name);
			}
			_tmp51_ = p;
			_tmp52_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) _tmp51_) : NULL);
			details = _tmp52_;
			_tmp53_ = details;
			if (_tmp53_ != NULL) {
				GeeArrayList* emails = NULL;
				FolksEmailDetails* _tmp54_ = NULL;
				GeeSet* _tmp55_ = NULL;
				GeeSet* _tmp56_ = NULL;
				GeeArrayList* _tmp57_ = NULL;
				_tmp54_ = details;
				_tmp55_ = folks_email_details_get_email_addresses (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = contacts_contact_sort_fields (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeCollection*) _tmp56_);
				emails = _tmp57_;
				{
					GeeArrayList* _email_list = NULL;
					GeeArrayList* _tmp58_ = NULL;
					GeeArrayList* _tmp59_ = NULL;
					gint _email_size = 0;
					GeeArrayList* _tmp60_ = NULL;
					gint _tmp61_ = 0;
					gint _tmp62_ = 0;
					gint _email_index = 0;
					_tmp58_ = emails;
					_tmp59_ = _g_object_ref0 (_tmp58_);
					_email_list = _tmp59_;
					_tmp60_ = _email_list;
					_tmp61_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp60_);
					_tmp62_ = _tmp61_;
					_email_size = _tmp62_;
					_email_index = -1;
					while (TRUE) {
						Block17Data* _data17_;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						GeeArrayList* _tmp66_ = NULL;
						gint _tmp67_ = 0;
						gpointer _tmp68_ = NULL;
						GtkButton* button = NULL;
						ContactsTypeSet* _tmp69_ = NULL;
						ContactsTypeSet* _tmp70_ = NULL;
						FolksEmailFieldDetails* _tmp71_ = NULL;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_ = NULL;
						FolksEmailFieldDetails* _tmp74_ = NULL;
						gconstpointer _tmp75_ = NULL;
						const gchar* _tmp76_ = NULL;
						GtkButton* _tmp77_ = NULL;
						GtkButton* _tmp78_ = NULL;
						GtkButton* _tmp79_ = NULL;
						_data17_ = g_slice_new0 (Block17Data);
						_data17_->_ref_count_ = 1;
						_data17_->_data16_ = block16_data_ref (_data16_);
						_tmp63_ = _email_index;
						_email_index = _tmp63_ + 1;
						_tmp64_ = _email_index;
						_tmp65_ = _email_size;
						if (!(_tmp64_ < _tmp65_)) {
							block17_data_unref (_data17_);
							_data17_ = NULL;
							break;
						}
						_tmp66_ = _email_list;
						_tmp67_ = _email_index;
						_tmp68_ = gee_abstract_list_get ((GeeAbstractList*) _tmp66_, _tmp67_);
						_data17_->email = (FolksEmailFieldDetails*) _tmp68_;
						_tmp69_ = contacts_typeset_get_email ();
						_tmp70_ = _tmp69_;
						_tmp71_ = _data17_->email;
						_tmp72_ = contacts_typeset_format_type (_tmp70_, (FolksAbstractFieldDetails*) _tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = _data17_->email;
						_tmp75_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp74_);
						_tmp76_ = _tmp75_;
						_tmp77_ = contacts_contact_sheet_add_row_with_button (self, &i, _tmp73_, (const gchar*) _tmp76_);
						_tmp78_ = _tmp77_;
						_g_free0 (_tmp73_);
						button = _tmp78_;
						_tmp79_ = button;
						g_signal_connect_data (_tmp79_, "clicked", (GCallback) ________lambda31__gtk_button_clicked, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
						_g_object_unref0 (button);
						block17_data_unref (_data17_);
						_data17_ = NULL;
					}
					_g_object_unref0 (_email_list);
				}
				_g_object_unref0 (emails);
			}
			_tmp80_ = p;
			_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, FOLKS_TYPE_PHONE_DETAILS) ? ((FolksPhoneDetails*) _tmp80_) : NULL);
			phone_details = _tmp81_;
			_tmp82_ = phone_details;
			if (_tmp82_ != NULL) {
				GeeArrayList* phones = NULL;
				FolksPhoneDetails* _tmp83_ = NULL;
				GeeSet* _tmp84_ = NULL;
				GeeSet* _tmp85_ = NULL;
				GeeArrayList* _tmp86_ = NULL;
				_tmp83_ = phone_details;
				_tmp84_ = folks_phone_details_get_phone_numbers (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = contacts_contact_sort_fields (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeCollection*) _tmp85_);
				phones = _tmp86_;
				{
					GeeArrayList* _phone_list = NULL;
					GeeArrayList* _tmp87_ = NULL;
					GeeArrayList* _tmp88_ = NULL;
					gint _phone_size = 0;
					GeeArrayList* _tmp89_ = NULL;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _phone_index = 0;
					_tmp87_ = phones;
					_tmp88_ = _g_object_ref0 (_tmp87_);
					_phone_list = _tmp88_;
					_tmp89_ = _phone_list;
					_tmp90_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp89_);
					_tmp91_ = _tmp90_;
					_phone_size = _tmp91_;
					_phone_index = -1;
					while (TRUE) {
						Block18Data* _data18_;
						gint _tmp92_ = 0;
						gint _tmp93_ = 0;
						gint _tmp94_ = 0;
						GeeArrayList* _tmp95_ = NULL;
						gint _tmp96_ = 0;
						gpointer _tmp97_ = NULL;
						ContactsApp* _tmp98_ = NULL;
						ContactsStore* _tmp99_ = NULL;
						gboolean _tmp100_ = FALSE;
						gboolean _tmp101_ = FALSE;
						_data18_ = g_slice_new0 (Block18Data);
						_data18_->_ref_count_ = 1;
						_data18_->_data16_ = block16_data_ref (_data16_);
						_tmp92_ = _phone_index;
						_phone_index = _tmp92_ + 1;
						_tmp93_ = _phone_index;
						_tmp94_ = _phone_size;
						if (!(_tmp93_ < _tmp94_)) {
							block18_data_unref (_data18_);
							_data18_ = NULL;
							break;
						}
						_tmp95_ = _phone_list;
						_tmp96_ = _phone_index;
						_tmp97_ = gee_abstract_list_get ((GeeAbstractList*) _tmp95_, _tmp96_);
						_data18_->phone = (FolksPhoneFieldDetails*) _tmp97_;
						_tmp98_ = contacts_app_app;
						_tmp99_ = _tmp98_->contacts_store;
						_tmp100_ = contacts_store_get_can_call (_tmp99_);
						_tmp101_ = _tmp100_;
						if (_tmp101_) {
							GtkButton* button = NULL;
							ContactsTypeSet* _tmp102_ = NULL;
							ContactsTypeSet* _tmp103_ = NULL;
							FolksPhoneFieldDetails* _tmp104_ = NULL;
							gchar* _tmp105_ = NULL;
							gchar* _tmp106_ = NULL;
							FolksPhoneFieldDetails* _tmp107_ = NULL;
							gconstpointer _tmp108_ = NULL;
							const gchar* _tmp109_ = NULL;
							GtkButton* _tmp110_ = NULL;
							GtkButton* _tmp111_ = NULL;
							GtkButton* _tmp112_ = NULL;
							_tmp102_ = contacts_typeset_get_phone ();
							_tmp103_ = _tmp102_;
							_tmp104_ = _data18_->phone;
							_tmp105_ = contacts_typeset_format_type (_tmp103_, (FolksAbstractFieldDetails*) _tmp104_);
							_tmp106_ = _tmp105_;
							_tmp107_ = _data18_->phone;
							_tmp108_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp107_);
							_tmp109_ = _tmp108_;
							_tmp110_ = contacts_contact_sheet_add_row_with_button (self, &i, _tmp106_, (const gchar*) _tmp109_);
							_tmp111_ = _tmp110_;
							_g_free0 (_tmp106_);
							button = _tmp111_;
							_tmp112_ = button;
							g_signal_connect_data (_tmp112_, "clicked", (GCallback) _________lambda32__gtk_button_clicked, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
							_g_object_unref0 (button);
						} else {
							ContactsTypeSet* _tmp113_ = NULL;
							ContactsTypeSet* _tmp114_ = NULL;
							FolksPhoneFieldDetails* _tmp115_ = NULL;
							gchar* _tmp116_ = NULL;
							gchar* _tmp117_ = NULL;
							FolksPhoneFieldDetails* _tmp118_ = NULL;
							gconstpointer _tmp119_ = NULL;
							const gchar* _tmp120_ = NULL;
							_tmp113_ = contacts_typeset_get_phone ();
							_tmp114_ = _tmp113_;
							_tmp115_ = _data18_->phone;
							_tmp116_ = contacts_typeset_format_type (_tmp114_, (FolksAbstractFieldDetails*) _tmp115_);
							_tmp117_ = _tmp116_;
							_tmp118_ = _data18_->phone;
							_tmp119_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp118_);
							_tmp120_ = _tmp119_;
							contacts_contact_sheet_add_row_with_label (self, &i, _tmp117_, (const gchar*) _tmp120_);
							_g_free0 (_tmp117_);
						}
						block18_data_unref (_data18_);
						_data18_ = NULL;
					}
					_g_object_unref0 (_phone_list);
				}
				_g_object_unref0 (phones);
			}
			_tmp121_ = p;
			_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, FOLKS_TYPE_IM_DETAILS) ? ((FolksImDetails*) _tmp121_) : NULL);
			im_details = _tmp122_;
			_tmp123_ = im_details;
			if (_tmp123_ != NULL) {
				{
					GeeIterator* _protocol_it = NULL;
					FolksImDetails* _tmp124_ = NULL;
					GeeMultiMap* _tmp125_ = NULL;
					GeeMultiMap* _tmp126_ = NULL;
					GeeSet* _tmp127_ = NULL;
					GeeSet* _tmp128_ = NULL;
					GeeIterator* _tmp129_ = NULL;
					GeeIterator* _tmp130_ = NULL;
					_tmp124_ = im_details;
					_tmp125_ = folks_im_details_get_im_addresses (_tmp124_);
					_tmp126_ = _tmp125_;
					_tmp127_ = gee_multi_map_get_keys (_tmp126_);
					_tmp128_ = _tmp127_;
					_tmp129_ = gee_iterable_iterator ((GeeIterable*) _tmp128_);
					_tmp130_ = _tmp129_;
					_g_object_unref0 (_tmp128_);
					_protocol_it = _tmp130_;
					while (TRUE) {
						Block19Data* _data19_;
						GeeIterator* _tmp131_ = NULL;
						gboolean _tmp132_ = FALSE;
						GeeIterator* _tmp133_ = NULL;
						gpointer _tmp134_ = NULL;
						_data19_ = g_slice_new0 (Block19Data);
						_data19_->_ref_count_ = 1;
						_data19_->_data16_ = block16_data_ref (_data16_);
						_tmp131_ = _protocol_it;
						_tmp132_ = gee_iterator_next (_tmp131_);
						if (!_tmp132_) {
							block19_data_unref (_data19_);
							_data19_ = NULL;
							break;
						}
						_tmp133_ = _protocol_it;
						_tmp134_ = gee_iterator_get (_tmp133_);
						_data19_->protocol = (gchar*) _tmp134_;
						{
							GeeIterator* _id_it = NULL;
							FolksImDetails* _tmp135_ = NULL;
							GeeMultiMap* _tmp136_ = NULL;
							GeeMultiMap* _tmp137_ = NULL;
							const gchar* _tmp138_ = NULL;
							GeeCollection* _tmp139_ = NULL;
							GeeCollection* _tmp140_ = NULL;
							GeeIterator* _tmp141_ = NULL;
							GeeIterator* _tmp142_ = NULL;
							_tmp135_ = im_details;
							_tmp136_ = folks_im_details_get_im_addresses (_tmp135_);
							_tmp137_ = _tmp136_;
							_tmp138_ = _data19_->protocol;
							_tmp139_ = gee_multi_map_get (_tmp137_, _tmp138_);
							_tmp140_ = _tmp139_;
							_tmp141_ = gee_iterable_iterator ((GeeIterable*) _tmp140_);
							_tmp142_ = _tmp141_;
							_g_object_unref0 (_tmp140_);
							_id_it = _tmp142_;
							while (TRUE) {
								Block20Data* _data20_;
								GeeIterator* _tmp143_ = NULL;
								gboolean _tmp144_ = FALSE;
								GeeIterator* _tmp145_ = NULL;
								gpointer _tmp146_ = NULL;
								FolksPersona* _tmp147_ = NULL;
								_data20_ = g_slice_new0 (Block20Data);
								_data20_->_ref_count_ = 1;
								_data20_->_data19_ = block19_data_ref (_data19_);
								_tmp143_ = _id_it;
								_tmp144_ = gee_iterator_next (_tmp143_);
								if (!_tmp144_) {
									block20_data_unref (_data20_);
									_data20_ = NULL;
									break;
								}
								_tmp145_ = _id_it;
								_tmp146_ = gee_iterator_get (_tmp145_);
								_data20_->id = (FolksImFieldDetails*) _tmp146_;
								_tmp147_ = p;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, TPF_TYPE_PERSONA)) {
									GtkButton* button = NULL;
									const gchar* _tmp148_ = NULL;
									gchar* _tmp149_ = NULL;
									gchar* _tmp150_ = NULL;
									FolksImFieldDetails* _tmp151_ = NULL;
									gconstpointer _tmp152_ = NULL;
									const gchar* _tmp153_ = NULL;
									GtkButton* _tmp154_ = NULL;
									GtkButton* _tmp155_ = NULL;
									GtkButton* _tmp156_ = NULL;
									_tmp148_ = _data19_->protocol;
									_tmp149_ = contacts_contact_format_im_service (_tmp148_, NULL);
									_tmp150_ = _tmp149_;
									_tmp151_ = _data20_->id;
									_tmp152_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp151_);
									_tmp153_ = _tmp152_;
									_tmp154_ = contacts_contact_sheet_add_row_with_button (self, &i, _tmp150_, (const gchar*) _tmp153_);
									_tmp155_ = _tmp154_;
									_g_free0 (_tmp150_);
									button = _tmp155_;
									_tmp156_ = button;
									g_signal_connect_data (_tmp156_, "clicked", (GCallback) ___________lambda33__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
									_g_object_unref0 (button);
								}
								block20_data_unref (_data20_);
								_data20_ = NULL;
							}
							_g_object_unref0 (_id_it);
						}
						block19_data_unref (_data19_);
						_data19_ = NULL;
					}
					_g_object_unref0 (_protocol_it);
				}
			}
			_tmp157_ = p;
			_tmp158_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp157_, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) _tmp157_) : NULL);
			url_details = _tmp158_;
			_tmp159_ = url_details;
			if (_tmp159_ != NULL) {
				{
					GeeIterator* _url_it = NULL;
					FolksUrlDetails* _tmp160_ = NULL;
					GeeSet* _tmp161_ = NULL;
					GeeSet* _tmp162_ = NULL;
					GeeIterator* _tmp163_ = NULL;
					_tmp160_ = url_details;
					_tmp161_ = folks_url_details_get_urls (_tmp160_);
					_tmp162_ = _tmp161_;
					_tmp163_ = gee_iterable_iterator ((GeeIterable*) _tmp162_);
					_url_it = _tmp163_;
					while (TRUE) {
						Block21Data* _data21_;
						GeeIterator* _tmp164_ = NULL;
						gboolean _tmp165_ = FALSE;
						GeeIterator* _tmp166_ = NULL;
						gpointer _tmp167_ = NULL;
						GtkButton* button = NULL;
						const gchar* _tmp168_ = NULL;
						FolksUrlFieldDetails* _tmp169_ = NULL;
						gchar* _tmp170_ = NULL;
						gchar* _tmp171_ = NULL;
						GtkButton* _tmp172_ = NULL;
						GtkButton* _tmp173_ = NULL;
						GtkButton* _tmp174_ = NULL;
						_data21_ = g_slice_new0 (Block21Data);
						_data21_->_ref_count_ = 1;
						_data21_->_data16_ = block16_data_ref (_data16_);
						_tmp164_ = _url_it;
						_tmp165_ = gee_iterator_next (_tmp164_);
						if (!_tmp165_) {
							block21_data_unref (_data21_);
							_data21_ = NULL;
							break;
						}
						_tmp166_ = _url_it;
						_tmp167_ = gee_iterator_get (_tmp166_);
						_data21_->url = (FolksUrlFieldDetails*) _tmp167_;
						_tmp168_ = _ ("Website");
						_tmp169_ = _data21_->url;
						_tmp170_ = contacts_contact_format_uri_link_text (_tmp169_);
						_tmp171_ = _tmp170_;
						_tmp172_ = contacts_contact_sheet_add_row_with_button (self, &i, _tmp168_, _tmp171_);
						_tmp173_ = _tmp172_;
						_g_free0 (_tmp171_);
						button = _tmp173_;
						_tmp174_ = button;
						g_signal_connect_data (_tmp174_, "clicked", (GCallback) ________lambda34__gtk_button_clicked, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
						_g_object_unref0 (button);
						block21_data_unref (_data21_);
						_data21_ = NULL;
					}
					_g_object_unref0 (_url_it);
				}
			}
			_tmp175_ = p;
			_tmp176_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp175_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _tmp175_) : NULL);
			name_details = _tmp176_;
			_tmp177_ = name_details;
			if (_tmp177_ != NULL) {
				FolksNameDetails* _tmp178_ = NULL;
				const gchar* _tmp179_ = NULL;
				const gchar* _tmp180_ = NULL;
				gboolean _tmp181_ = FALSE;
				_tmp178_ = name_details;
				_tmp179_ = folks_name_details_get_nickname (_tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = contacts_is_set (_tmp180_);
				if (_tmp181_) {
					const gchar* _tmp182_ = NULL;
					FolksNameDetails* _tmp183_ = NULL;
					const gchar* _tmp184_ = NULL;
					const gchar* _tmp185_ = NULL;
					_tmp182_ = _ ("Nickname");
					_tmp183_ = name_details;
					_tmp184_ = folks_name_details_get_nickname (_tmp183_);
					_tmp185_ = _tmp184_;
					contacts_contact_sheet_add_row_with_label (self, &i, _tmp182_, _tmp185_);
				}
			}
			_tmp186_ = p;
			_tmp187_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp186_, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) _tmp186_) : NULL);
			birthday_details = _tmp187_;
			_tmp188_ = birthday_details;
			if (_tmp188_ != NULL) {
				FolksBirthdayDetails* _tmp189_ = NULL;
				GDateTime* _tmp190_ = NULL;
				GDateTime* _tmp191_ = NULL;
				_tmp189_ = birthday_details;
				_tmp190_ = folks_birthday_details_get_birthday (_tmp189_);
				_tmp191_ = _tmp190_;
				if (_tmp191_ != NULL) {
					const gchar* _tmp192_ = NULL;
					FolksBirthdayDetails* _tmp193_ = NULL;
					GDateTime* _tmp194_ = NULL;
					GDateTime* _tmp195_ = NULL;
					GDateTime* _tmp196_ = NULL;
					GDateTime* _tmp197_ = NULL;
					gchar* _tmp198_ = NULL;
					gchar* _tmp199_ = NULL;
					_tmp192_ = _ ("Birthday");
					_tmp193_ = birthday_details;
					_tmp194_ = folks_birthday_details_get_birthday (_tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = g_date_time_to_local (_tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = g_date_time_format (_tmp197_, "%d %B");
					_tmp199_ = _tmp198_;
					contacts_contact_sheet_add_row_with_label (self, &i, _tmp192_, _tmp199_);
					_g_free0 (_tmp199_);
					_g_date_time_unref0 (_tmp197_);
				}
			}
			_tmp200_ = p;
			_tmp201_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp200_, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) _tmp200_) : NULL);
			note_details = _tmp201_;
			_tmp202_ = note_details;
			if (_tmp202_ != NULL) {
				{
					GeeIterator* _note_it = NULL;
					FolksNoteDetails* _tmp203_ = NULL;
					GeeSet* _tmp204_ = NULL;
					GeeSet* _tmp205_ = NULL;
					GeeIterator* _tmp206_ = NULL;
					_tmp203_ = note_details;
					_tmp204_ = folks_note_details_get_notes (_tmp203_);
					_tmp205_ = _tmp204_;
					_tmp206_ = gee_iterable_iterator ((GeeIterable*) _tmp205_);
					_note_it = _tmp206_;
					while (TRUE) {
						GeeIterator* _tmp207_ = NULL;
						gboolean _tmp208_ = FALSE;
						FolksNoteFieldDetails* note = NULL;
						GeeIterator* _tmp209_ = NULL;
						gpointer _tmp210_ = NULL;
						const gchar* _tmp211_ = NULL;
						FolksNoteFieldDetails* _tmp212_ = NULL;
						gconstpointer _tmp213_ = NULL;
						const gchar* _tmp214_ = NULL;
						_tmp207_ = _note_it;
						_tmp208_ = gee_iterator_next (_tmp207_);
						if (!_tmp208_) {
							break;
						}
						_tmp209_ = _note_it;
						_tmp210_ = gee_iterator_get (_tmp209_);
						note = (FolksNoteFieldDetails*) _tmp210_;
						_tmp211_ = _ ("Note");
						_tmp212_ = note;
						_tmp213_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp212_);
						_tmp214_ = _tmp213_;
						contacts_contact_sheet_add_row_with_label (self, &i, _tmp211_, (const gchar*) _tmp214_);
						_g_object_unref0 (note);
					}
					_g_object_unref0 (_note_it);
				}
			}
			_tmp215_ = p;
			_tmp216_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp215_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS) ? ((FolksPostalAddressDetails*) _tmp215_) : NULL);
			addr_details = _tmp216_;
			_tmp217_ = addr_details;
			if (_tmp217_ != NULL) {
				{
					GeeIterator* _addr_it = NULL;
					FolksPostalAddressDetails* _tmp218_ = NULL;
					GeeSet* _tmp219_ = NULL;
					GeeSet* _tmp220_ = NULL;
					GeeIterator* _tmp221_ = NULL;
					_tmp218_ = addr_details;
					_tmp219_ = folks_postal_address_details_get_postal_addresses (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = gee_iterable_iterator ((GeeIterable*) _tmp220_);
					_addr_it = _tmp221_;
					while (TRUE) {
						GeeIterator* _tmp222_ = NULL;
						gboolean _tmp223_ = FALSE;
						FolksPostalAddressFieldDetails* addr = NULL;
						GeeIterator* _tmp224_ = NULL;
						gpointer _tmp225_ = NULL;
						gchar** strs = NULL;
						FolksPostalAddressFieldDetails* _tmp226_ = NULL;
						gconstpointer _tmp227_ = NULL;
						FolksPostalAddress* _tmp228_ = NULL;
						gint _tmp229_ = 0;
						gchar** _tmp230_ = NULL;
						gint strs_length1 = 0;
						gint _strs_size_ = 0;
						gchar* all_strs = NULL;
						gchar* _tmp231_ = NULL;
						gchar** _tmp232_ = NULL;
						gint _tmp232__length1 = 0;
						ContactsTypeSet* _tmp239_ = NULL;
						ContactsTypeSet* _tmp240_ = NULL;
						FolksPostalAddressFieldDetails* _tmp241_ = NULL;
						gchar* _tmp242_ = NULL;
						gchar* _tmp243_ = NULL;
						const gchar* _tmp244_ = NULL;
						_tmp222_ = _addr_it;
						_tmp223_ = gee_iterator_next (_tmp222_);
						if (!_tmp223_) {
							break;
						}
						_tmp224_ = _addr_it;
						_tmp225_ = gee_iterator_get (_tmp224_);
						addr = (FolksPostalAddressFieldDetails*) _tmp225_;
						_tmp226_ = addr;
						_tmp227_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp226_);
						_tmp228_ = _tmp227_;
						_tmp230_ = contacts_contact_format_address ((FolksPostalAddress*) _tmp228_, &_tmp229_);
						strs = _tmp230_;
						strs_length1 = _tmp229_;
						_strs_size_ = strs_length1;
						_tmp231_ = g_strdup ("");
						all_strs = _tmp231_;
						_tmp232_ = strs;
						_tmp232__length1 = strs_length1;
						{
							gchar** s_collection = NULL;
							gint s_collection_length1 = 0;
							gint _s_collection_size_ = 0;
							gint s_it = 0;
							s_collection = _tmp232_;
							s_collection_length1 = _tmp232__length1;
							for (s_it = 0; s_it < _tmp232__length1; s_it = s_it + 1) {
								gchar* _tmp233_ = NULL;
								gchar* s = NULL;
								_tmp233_ = g_strdup (s_collection[s_it]);
								s = _tmp233_;
								{
									const gchar* _tmp234_ = NULL;
									const gchar* _tmp235_ = NULL;
									gchar* _tmp236_ = NULL;
									gchar* _tmp237_ = NULL;
									gchar* _tmp238_ = NULL;
									_tmp234_ = all_strs;
									_tmp235_ = s;
									_tmp236_ = g_strconcat (_tmp235_, "\n", NULL);
									_tmp237_ = _tmp236_;
									_tmp238_ = g_strconcat (_tmp234_, _tmp237_, NULL);
									_g_free0 (all_strs);
									all_strs = _tmp238_;
									_g_free0 (_tmp237_);
									_g_free0 (s);
								}
							}
						}
						_tmp239_ = contacts_typeset_get_general ();
						_tmp240_ = _tmp239_;
						_tmp241_ = addr;
						_tmp242_ = contacts_typeset_format_type (_tmp240_, (FolksAbstractFieldDetails*) _tmp241_);
						_tmp243_ = _tmp242_;
						_tmp244_ = all_strs;
						contacts_contact_sheet_add_row_with_label (self, &i, _tmp243_, _tmp244_);
						_g_free0 (_tmp243_);
						_g_free0 (all_strs);
						strs = (_vala_array_free (strs, strs_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (addr);
					}
					_g_object_unref0 (_addr_it);
				}
			}
			_tmp245_ = i;
			if (_tmp245_ != 3) {
				is_first_persona = FALSE;
			}
			_tmp246_ = i;
			_tmp247_ = last_store_position;
			if (_tmp246_ == _tmp247_) {
				gint _tmp248_ = 0;
				GtkWidget* _tmp249_ = NULL;
				_tmp248_ = i;
				_tmp249_ = gtk_grid_get_child_at ((GtkGrid*) self, 0, _tmp248_ - 1);
				gtk_widget_destroy (_tmp249_);
			}
			_g_object_unref0 (addr_details);
			_g_object_unref0 (note_details);
			_g_object_unref0 (birthday_details);
			_g_object_unref0 (name_details);
			_g_object_unref0 (url_details);
			_g_object_unref0 (im_details);
			_g_object_unref0 (phone_details);
			_g_object_unref0 (details);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (personas);
	_g_object_unref0 (merged_presence);
	_g_object_unref0 (name_label);
	_g_object_unref0 (image_frame);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}


void contacts_contact_sheet_clear (ContactsContactSheet* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				GtkWidget* _tmp1_ = NULL;
				_tmp1_ = w;
				gtk_widget_destroy (_tmp1_);
			}
		}
		_g_list_free0 (w_collection);
	}
}


static void contacts_contact_sheet_class_init (ContactsContactSheetClass * klass) {
	contacts_contact_sheet_parent_class = g_type_class_peek_parent (klass);
}


static void contacts_contact_sheet_instance_init (ContactsContactSheet * self) {
}


GType contacts_contact_sheet_get_type (void) {
	static volatile gsize contacts_contact_sheet_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_sheet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheet), 0, (GInstanceInitFunc) contacts_contact_sheet_instance_init, NULL };
		GType contacts_contact_sheet_type_id;
		contacts_contact_sheet_type_id = g_type_register_static (GTK_TYPE_GRID, "ContactsContactSheet", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_sheet_type_id__volatile, contacts_contact_sheet_type_id);
	}
	return contacts_contact_sheet_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



