/* eds-backend.c generated by valac 0.20.1.30-1b1d, the Vala compiler
 * generated from eds-backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libedataserver/libedataserver.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks-eds.h>
#include <folks-internal.h>
#include <glib/gstdio.h>


#define FOLKS_BACKENDS_EDS_TYPE_BACKEND (folks_backends_eds_backend_get_type ())
#define FOLKS_BACKENDS_EDS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackend))
#define FOLKS_BACKENDS_EDS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendClass))
#define FOLKS_BACKENDS_EDS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND))
#define FOLKS_BACKENDS_EDS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_EDS_TYPE_BACKEND))
#define FOLKS_BACKENDS_EDS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendClass))

typedef struct _FolksBackendsEdsBackend FolksBackendsEdsBackend;
typedef struct _FolksBackendsEdsBackendClass FolksBackendsEdsBackendClass;
typedef struct _FolksBackendsEdsBackendPrivate FolksBackendsEdsBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksBackendsEdsBackendPrepareData FolksBackendsEdsBackendPrepareData;
typedef struct _FolksBackendsEdsBackendUnprepareData FolksBackendsEdsBackendUnprepareData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _FolksBackendsEdsBackend {
	FolksBackend parent_instance;
	FolksBackendsEdsBackendPrivate * priv;
};

struct _FolksBackendsEdsBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsEdsBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
	ESourceRegistry* _ab_sources;
	GeeSet* _storeids;
};

struct _FolksBackendsEdsBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ESourceRegistry* _tmp4_;
	ESourceRegistry* _tmp5_;
	ESourceRegistry* _tmp6_;
	ESourceRegistry* _tmp7_;
	GError * _inner_error_;
};

struct _FolksBackendsEdsBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeIterator* _persona_store_it;
	GeeHashMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GeeIterator* _tmp10_;
	gboolean _tmp11_;
	FolksPersonaStore* persona_store;
	GeeIterator* _tmp12_;
	gpointer _tmp13_;
	FolksPersonaStore* _tmp14_;
	ESourceRegistry* _tmp15_;
	guint _tmp16_;
	ESourceRegistry* _tmp17_;
	guint _tmp18_;
	GError * _inner_error_;
};


static gpointer folks_backends_eds_backend_parent_class = NULL;

void e_source_registry_new (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ESourceRegistry* e_source_registry_new_finish (GAsyncResult* _res_, GError** error);
GType folks_backends_eds_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_EDS_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendPrivate))
enum  {
	FOLKS_BACKENDS_EDS_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_EDS_BACKEND_NAME,
	FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT
};
#define FOLKS_BACKENDS_EDS_BACKEND__use_address_books "FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS"
static void folks_backends_eds_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_eds_backend_remove_address_book (FolksBackendsEdsBackend* self, FolksPersonaStore* store, gboolean notify);
static void folks_backends_eds_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_eds_backend_add_persona_store (FolksBackendsEdsBackend* self, FolksPersonaStore* store, gboolean notify);
static void _folks_backends_eds_backend_store_removed_cb (FolksBackendsEdsBackend* self, FolksPersonaStore* store);
static void __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_eds_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids);
static void _folks_backends_eds_backend_ab_source_list_changed_cb (FolksBackendsEdsBackend* self);
static void _vala_array_add1 (FolksPersonaStore*** array, int* length, int* size, FolksPersonaStore* value);
FolksBackendsEdsBackend* folks_backends_eds_backend_new (void);
FolksBackendsEdsBackend* folks_backends_eds_backend_construct (GType object_type);
static void folks_backends_eds_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_eds_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_eds_backend_real_prepare_co (FolksBackendsEdsBackendPrepareData* _data_);
static void _folks_backends_eds_backend_create_avatars_cache_dir (FolksBackendsEdsBackend* self);
static void folks_backends_eds_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self);
static void __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_registry_source_enabled (ESourceRegistry* _sender, ESource* source, gpointer self);
static void folks_backends_eds_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_eds_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_eds_backend_real_unprepare_co (FolksBackendsEdsBackendUnprepareData* _data_);
static gchar** _folks_backends_eds_backend_get_addressbooks_from_env (FolksBackendsEdsBackend* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _folks_backends_eds_backend_add_address_book (FolksBackendsEdsBackend* self, ESource* s);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static GObject * folks_backends_eds_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_eds_backend_finalize (GObject* obj);
static void _vala_folks_backends_eds_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
   * {@inheritDoc}
   */
static void folks_backends_eds_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsEdsBackend * self;
	GeeHashMap* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = (FolksBackendsEdsBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_) {
		FolksPersonaStore* _tmp5_;
		_tmp5_ = store;
		_folks_backends_eds_backend_remove_address_book (self, _tmp5_, TRUE);
	}
}


/**
   * {@inheritDoc}
   */
static void folks_backends_eds_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsEdsBackend * self;
	GeeHashMap* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = (FolksBackendsEdsBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_ == FALSE) {
		FolksPersonaStore* _tmp5_;
		_tmp5_ = store;
		_folks_backends_eds_backend_add_persona_store (self, _tmp5_, TRUE);
	}
}


static void __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_eds_backend_store_removed_cb (self, _sender);
}


static void _folks_backends_eds_backend_add_persona_store (FolksBackendsEdsBackend* self, FolksPersonaStore* store, gboolean notify) {
	FolksPersonaStore* _tmp0_;
	GeeHashMap* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FolksPersonaStore* _tmp5_;
	FolksPersonaStore* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_connect_object (_tmp0_, "removed", (GCallback) __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = store;
	_tmp3_ = folks_persona_store_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp4_, _tmp5_);
	_tmp6_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", _tmp6_);
	_tmp7_ = notify;
	if (_tmp7_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}


/**
   * {@inheritDoc}
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (FolksPersonaStore*** array, int* length, int* size, FolksPersonaStore* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void folks_backends_eds_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids) {
	FolksBackendsEdsBackend * self;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	gboolean stores_changed = FALSE;
	FolksPersonaStore** stores_to_remove = NULL;
	FolksPersonaStore** _tmp21_ = NULL;
	gint stores_to_remove_length1;
	gint _stores_to_remove_size_;
	gboolean _tmp48_;
	self = (FolksBackendsEdsBackend*) base;
	_tmp0_ = storeids;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_storeids);
	self->priv->_storeids = _tmp1_;
	_tmp2_ = storeids;
	if (_tmp2_ == NULL) {
		_folks_backends_eds_backend_ab_source_list_changed_cb (self);
		return;
	}
	stores_changed = FALSE;
	{
		GeeIterator* _id_it = NULL;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		_tmp3_ = storeids;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_id_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			gchar* id = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			GeeHashMap* _tmp9_;
			const gchar* _tmp10_;
			gboolean _tmp11_ = FALSE;
			_tmp5_ = _id_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _id_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			id = (gchar*) _tmp8_;
			_tmp9_ = self->priv->_persona_stores;
			_tmp10_ = id;
			_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp10_);
			if (_tmp11_ == FALSE) {
				ESource* s = NULL;
				ESourceRegistry* _tmp12_;
				const gchar* _tmp13_;
				ESource* _tmp14_ = NULL;
				ESource* _tmp15_;
				EdsfPersonaStore* store = NULL;
				ESourceRegistry* _tmp17_;
				ESource* _tmp18_;
				EdsfPersonaStore* _tmp19_;
				EdsfPersonaStore* _tmp20_;
				_tmp12_ = self->priv->_ab_sources;
				_tmp13_ = id;
				_tmp14_ = e_source_registry_ref_source (_tmp12_, _tmp13_);
				s = _tmp14_;
				_tmp15_ = s;
				if (_tmp15_ == NULL) {
					const gchar* _tmp16_;
					_tmp16_ = id;
					g_warning ("eds-backend.vala:124: Unable to reference EDS source with ID %s", _tmp16_);
					_g_object_unref0 (s);
					_g_free0 (id);
					continue;
				}
				_tmp17_ = self->priv->_ab_sources;
				_tmp18_ = s;
				_tmp19_ = edsf_persona_store_new_with_source_registry (_tmp17_, _tmp18_);
				store = _tmp19_;
				_tmp20_ = store;
				_folks_backends_eds_backend_add_persona_store (self, (FolksPersonaStore*) _tmp20_, FALSE);
				stores_changed = TRUE;
				_g_object_unref0 (store);
				_g_object_unref0 (s);
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp21_ = g_new0 (FolksPersonaStore*, 0 + 1);
	stores_to_remove = _tmp21_;
	stores_to_remove_length1 = 0;
	_stores_to_remove_size_ = stores_to_remove_length1;
	{
		GeeIterator* _store_it = NULL;
		GeeHashMap* _tmp22_;
		GeeCollection* _tmp23_;
		GeeCollection* _tmp24_;
		GeeCollection* _tmp25_;
		GeeIterator* _tmp26_ = NULL;
		GeeIterator* _tmp27_;
		_tmp22_ = self->priv->_persona_stores;
		_tmp23_ = gee_abstract_map_get_values ((GeeMap*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
		_tmp27_ = _tmp26_;
		_g_object_unref0 (_tmp25_);
		_store_it = _tmp27_;
		while (TRUE) {
			GeeIterator* _tmp28_;
			gboolean _tmp29_ = FALSE;
			FolksPersonaStore* store = NULL;
			GeeIterator* _tmp30_;
			gpointer _tmp31_ = NULL;
			GeeSet* _tmp32_;
			FolksPersonaStore* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gboolean _tmp36_ = FALSE;
			_tmp28_ = _store_it;
			_tmp29_ = gee_iterator_next (_tmp28_);
			if (!_tmp29_) {
				break;
			}
			_tmp30_ = _store_it;
			_tmp31_ = gee_iterator_get (_tmp30_);
			store = (FolksPersonaStore*) _tmp31_;
			_tmp32_ = storeids;
			_tmp33_ = store;
			_tmp34_ = folks_persona_store_get_id (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = gee_collection_contains ((GeeCollection*) _tmp32_, _tmp35_);
			if (!_tmp36_) {
				FolksPersonaStore** _tmp37_;
				gint _tmp37__length1;
				FolksPersonaStore* _tmp38_;
				FolksPersonaStore* _tmp39_;
				_tmp37_ = stores_to_remove;
				_tmp37__length1 = stores_to_remove_length1;
				_tmp38_ = store;
				_tmp39_ = _g_object_ref0 (_tmp38_);
				_vala_array_add1 (&stores_to_remove, &stores_to_remove_length1, &_stores_to_remove_size_, _tmp39_);
				stores_changed = TRUE;
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp40_ = FALSE;
			_tmp40_ = TRUE;
			while (TRUE) {
				gboolean _tmp41_;
				gint _tmp43_;
				FolksPersonaStore** _tmp44_;
				gint _tmp44__length1;
				FolksPersonaStore** _tmp45_;
				gint _tmp45__length1;
				gint _tmp46_;
				FolksPersonaStore* _tmp47_;
				_tmp41_ = _tmp40_;
				if (!_tmp41_) {
					gint _tmp42_;
					_tmp42_ = i;
					i = _tmp42_ + 1;
				}
				_tmp40_ = FALSE;
				_tmp43_ = i;
				_tmp44_ = stores_to_remove;
				_tmp44__length1 = stores_to_remove_length1;
				if (!(_tmp43_ < _tmp44__length1)) {
					break;
				}
				_tmp45_ = stores_to_remove;
				_tmp45__length1 = stores_to_remove_length1;
				_tmp46_ = i;
				_tmp47_ = _tmp45_[_tmp46_];
				_folks_backends_eds_backend_remove_address_book (self, _tmp47_, FALSE);
			}
		}
	}
	_tmp48_ = stores_changed;
	if (_tmp48_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
	stores_to_remove = (_vala_array_free (stores_to_remove, stores_to_remove_length1, (GDestroyNotify) g_object_unref), NULL);
}


/**
   * {@inheritDoc}
   */
FolksBackendsEdsBackend* folks_backends_eds_backend_construct (GType object_type) {
	FolksBackendsEdsBackend * self = NULL;
	self = (FolksBackendsEdsBackend*) g_object_new (object_type, NULL);
	return self;
}


FolksBackendsEdsBackend* folks_backends_eds_backend_new (void) {
	return folks_backends_eds_backend_construct (FOLKS_BACKENDS_EDS_TYPE_BACKEND);
}


static void folks_backends_eds_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsEdsBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsEdsBackendPrepareData, _data_);
}


static void folks_backends_eds_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsEdsBackend * self;
	FolksBackendsEdsBackendPrepareData* _data_;
	FolksBackendsEdsBackend* _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsEdsBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_eds_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_eds_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_eds_backend_real_prepare_co (_data_);
}


static void folks_backends_eds_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsEdsBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void folks_backends_eds_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsEdsBackendPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_eds_backend_real_prepare_co (_data_);
}


static void __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self) {
	_folks_backends_eds_backend_ab_source_list_changed_cb (self);
}


static void __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_registry_source_enabled (ESourceRegistry* _sender, ESource* source, gpointer self) {
	_folks_backends_eds_backend_ab_source_list_changed_cb (self);
}


static gboolean folks_backends_eds_backend_real_prepare_co (FolksBackendsEdsBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	folks_internal_profiling_start ("preparing Eds.Backend", NULL);
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_folks_backends_eds_backend_create_avatars_cache_dir (_data_->self);
		_data_->_state_ = 1;
		e_source_registry_new (NULL, folks_backends_eds_backend_prepare_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp4_ = _data_->_tmp5_;
		if (_data_->_inner_error_ != NULL) {
			goto __finally0;
		}
		_g_object_unref0 (_data_->self->priv->_ab_sources);
		_data_->self->priv->_ab_sources = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->self->priv->_ab_sources;
		g_signal_connect_object (_data_->_tmp6_, "source-added", (GCallback) __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_registry_source_added, _data_->self, 0);
		_data_->_tmp7_ = _data_->self->priv->_ab_sources;
		g_signal_connect_object (_data_->_tmp7_, "source-enabled", (GCallback) __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_registry_source_enabled, _data_->self, 0);
		_folks_backends_eds_backend_ab_source_list_changed_cb (_data_->self);
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
	}
	__finally0:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	folks_internal_profiling_end ("preparing Eds.Backend", NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_eds_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsEdsBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsEdsBackendUnprepareData, _data_);
}


static void folks_backends_eds_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsEdsBackend * self;
	FolksBackendsEdsBackendUnprepareData* _data_;
	FolksBackendsEdsBackend* _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsEdsBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_eds_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_eds_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_eds_backend_real_unprepare_co (_data_);
}


static void folks_backends_eds_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsEdsBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static gboolean folks_backends_eds_backend_real_unprepare_co (FolksBackendsEdsBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (!_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		{
			_data_->_tmp4_ = _data_->self->priv->_persona_stores;
			_data_->_tmp5_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp4_);
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_g_object_unref0 (_data_->_tmp7_);
			_data_->_persona_store_it = _data_->_tmp9_;
			while (TRUE) {
				_data_->_tmp10_ = _data_->_persona_store_it;
				_data_->_tmp11_ = FALSE;
				_data_->_tmp11_ = gee_iterator_next (_data_->_tmp10_);
				if (!_data_->_tmp11_) {
					break;
				}
				_data_->_tmp12_ = _data_->_persona_store_it;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = gee_iterator_get (_data_->_tmp12_);
				_data_->persona_store = (FolksPersonaStore*) _data_->_tmp13_;
				_data_->_tmp14_ = _data_->persona_store;
				_folks_backends_eds_backend_remove_address_book (_data_->self, _data_->_tmp14_, TRUE);
				_g_object_unref0 (_data_->persona_store);
			}
			_g_object_unref0 (_data_->_persona_store_it);
		}
		_data_->_tmp15_ = _data_->self->priv->_ab_sources;
		_data_->_tmp16_ = 0U;
		g_signal_parse_name ("source-added", e_source_registry_get_type (), &_data_->_tmp16_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp16_, 0, NULL, (GCallback) __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_registry_source_added, _data_->self);
		_data_->_tmp17_ = _data_->self->priv->_ab_sources;
		_data_->_tmp18_ = 0U;
		g_signal_parse_name ("source-enabled", e_source_registry_get_type (), &_data_->_tmp18_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_data_->_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp18_, 0, NULL, (GCallback) __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_registry_source_enabled, _data_->self);
		_g_object_unref0 (_data_->self->priv->_ab_sources);
		_data_->self->priv->_ab_sources = NULL;
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
	}
	__finally1:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_eds_backend_create_avatars_cache_dir (FolksBackendsEdsBackend* self) {
	gchar* avatars_dir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "folks", "avatars", NULL);
	avatars_dir = _tmp1_;
	g_mkdir_with_parents (avatars_dir, 0700);
	_g_free0 (avatars_dir);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _folks_backends_eds_backend_ab_source_list_changed_cb (FolksBackendsEdsBackend* self) {
	gchar** use_addressbooks = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gint use_addressbooks_length1;
	gint _use_addressbooks_size_;
	GList* books = NULL;
	ESourceRegistry* _tmp2_;
	GList* _tmp3_ = NULL;
	GeeLinkedList* added_sources = NULL;
	GeeLinkedList* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _folks_backends_eds_backend_get_addressbooks_from_env (self, &_tmp0_);
	use_addressbooks = _tmp1_;
	use_addressbooks_length1 = _tmp0_;
	_use_addressbooks_size_ = use_addressbooks_length1;
	_tmp2_ = self->priv->_ab_sources;
	_tmp3_ = e_source_registry_list_sources (_tmp2_, E_SOURCE_EXTENSION_ADDRESS_BOOK);
	books = _tmp3_;
	g_debug ("eds-backend.vala:293: Address book source list changed.");
	_tmp4_ = gee_linked_list_new (e_source_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	added_sources = _tmp4_;
	_tmp5_ = books;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp5_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			ESource* _tmp6_;
			ESource* s = NULL;
			_tmp6_ = _g_object_ref0 ((ESource*) s_it->data);
			s = _tmp6_;
			{
				gchar* uid = NULL;
				ESource* _tmp7_;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gboolean _tmp14_;
				gboolean _tmp15_ = FALSE;
				GeeSet* _tmp16_;
				gboolean _tmp20_;
				GeeHashMap* _tmp21_;
				const gchar* _tmp22_;
				gboolean _tmp23_ = FALSE;
				_tmp7_ = s;
				_tmp8_ = e_source_get_uid (_tmp7_);
				_tmp9_ = g_strdup (_tmp8_);
				uid = _tmp9_;
				_tmp11_ = use_addressbooks;
				_tmp11__length1 = use_addressbooks_length1;
				if (_tmp11__length1 > 0) {
					const gchar* _tmp12_;
					gchar** _tmp13_;
					gint _tmp13__length1;
					_tmp12_ = uid;
					_tmp13_ = use_addressbooks;
					_tmp13__length1 = use_addressbooks_length1;
					_tmp10_ = !_vala_string_array_contains (_tmp13_, _tmp13__length1, _tmp12_);
				} else {
					_tmp10_ = FALSE;
				}
				_tmp14_ = _tmp10_;
				if (_tmp14_) {
					_g_free0 (uid);
					_g_object_unref0 (s);
					continue;
				}
				_tmp16_ = self->priv->_storeids;
				if (_tmp16_ != NULL) {
					GeeSet* _tmp17_;
					const gchar* _tmp18_;
					gboolean _tmp19_ = FALSE;
					_tmp17_ = self->priv->_storeids;
					_tmp18_ = uid;
					_tmp19_ = gee_collection_contains ((GeeCollection*) _tmp17_, _tmp18_);
					_tmp15_ = !_tmp19_;
				} else {
					_tmp15_ = FALSE;
				}
				_tmp20_ = _tmp15_;
				if (_tmp20_) {
					_g_free0 (uid);
					_g_object_unref0 (s);
					continue;
				}
				_tmp21_ = self->priv->_persona_stores;
				_tmp22_ = uid;
				_tmp23_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp21_, _tmp22_);
				if (!_tmp23_) {
					GeeLinkedList* _tmp24_;
					ESource* _tmp25_;
					_tmp24_ = added_sources;
					_tmp25_ = s;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
				}
				_g_free0 (uid);
				_g_object_unref0 (s);
			}
		}
	}
	{
		GeeLinkedList* _s_list = NULL;
		GeeLinkedList* _tmp26_;
		GeeLinkedList* _tmp27_;
		gint _s_size = 0;
		GeeLinkedList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _s_index = 0;
		_tmp26_ = added_sources;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_s_list = _tmp27_;
		_tmp28_ = _s_list;
		_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_s_size = _tmp30_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			ESource* s = NULL;
			GeeLinkedList* _tmp34_;
			gint _tmp35_;
			gpointer _tmp36_ = NULL;
			ESource* _tmp37_;
			_tmp31_ = _s_index;
			_s_index = _tmp31_ + 1;
			_tmp32_ = _s_index;
			_tmp33_ = _s_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _s_list;
			_tmp35_ = _s_index;
			_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
			s = (ESource*) _tmp36_;
			_tmp37_ = s;
			_folks_backends_eds_backend_add_address_book (self, _tmp37_);
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	_g_object_unref0 (added_sources);
	__g_list_free__g_object_unref0_0 (books);
	use_addressbooks = (_vala_array_free (use_addressbooks, use_addressbooks_length1, (GDestroyNotify) g_free), NULL);
}


/**
   * Add a new addressbook connected to a Persona Store.
   */
static void _folks_backends_eds_backend_add_address_book (FolksBackendsEdsBackend* self, ESource* s) {
	gchar* uid = NULL;
	ESource* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	EdsfPersonaStore* store = NULL;
	ESourceRegistry* _tmp7_;
	ESource* _tmp8_;
	EdsfPersonaStore* _tmp9_;
	EdsfPersonaStore* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = e_source_get_uid (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	uid = _tmp2_;
	_tmp3_ = self->priv->_persona_stores;
	_tmp4_ = uid;
	_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_);
	if (_tmp5_) {
		_g_free0 (uid);
		return;
	}
	_tmp6_ = uid;
	g_debug ("eds-backend.vala:340: Adding address book '%s'.", _tmp6_);
	_tmp7_ = self->priv->_ab_sources;
	_tmp8_ = s;
	_tmp9_ = edsf_persona_store_new_with_source_registry (_tmp7_, _tmp8_);
	store = _tmp9_;
	_tmp10_ = store;
	folks_backend_enable_persona_store ((FolksBackend*) self, (FolksPersonaStore*) _tmp10_);
	_g_object_unref0 (store);
	_g_free0 (uid);
}


static void _folks_backends_eds_backend_remove_address_book (FolksBackendsEdsBackend* self, FolksPersonaStore* store, gboolean notify) {
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	FolksPersonaStore* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	FolksPersonaStore* _tmp7_;
	gboolean _tmp8_;
	FolksPersonaStore* _tmp9_;
	guint _tmp10_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("eds-backend.vala:350: Removing address book '%s'.", _tmp2_);
	_tmp3_ = self->priv->_persona_stores;
	_tmp4_ = store;
	_tmp5_ = folks_persona_store_get_id (_tmp4_);
	_tmp6_ = _tmp5_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, _tmp6_, NULL);
	_tmp7_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", _tmp7_);
	_tmp8_ = notify;
	if (_tmp8_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
	_tmp9_ = store;
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed, self);
}


static void _folks_backends_eds_backend_store_removed_cb (FolksBackendsEdsBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_backends_eds_backend_remove_address_book (self, _tmp0_, TRUE);
}


static gchar** _folks_backends_eds_backend_get_addressbooks_from_env (FolksBackendsEdsBackend* self, int* result_length1) {
	gchar** result = NULL;
	gchar** addressbooks = NULL;
	gchar** _tmp0_ = NULL;
	gint addressbooks_length1;
	gint _addressbooks_size_;
	gchar* ab_list = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	addressbooks = _tmp0_;
	addressbooks_length1 = 0;
	_addressbooks_size_ = addressbooks_length1;
	_tmp1_ = g_getenv (FOLKS_BACKENDS_EDS_BACKEND__use_address_books);
	_tmp2_ = g_strdup (_tmp1_);
	ab_list = _tmp2_;
	_tmp4_ = ab_list;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = ab_list;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_ = NULL;
		_tmp7_ = ab_list;
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ":", 0);
		addressbooks = (_vala_array_free (addressbooks, addressbooks_length1, (GDestroyNotify) g_free), NULL);
		addressbooks = _tmp9_;
		addressbooks_length1 = _vala_array_length (_tmp8_);
		_addressbooks_size_ = addressbooks_length1;
	}
	_tmp10_ = addressbooks;
	_tmp10__length1 = addressbooks_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_free0 (ab_list);
	return result;
}


static const gchar* folks_backends_eds_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsEdsBackend* self;
	self = (FolksBackendsEdsBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_eds_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsEdsBackend* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_eds_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_eds_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsEdsBackend*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GObject * folks_backends_eds_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsEdsBackend * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (folks_backends_eds_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	_g_object_unref0 (self->priv->_storeids);
	self->priv->_storeids = NULL;
	return obj;
}


static void folks_backends_eds_backend_class_init (FolksBackendsEdsBackendClass * klass) {
	folks_backends_eds_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsEdsBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->disable_persona_store = folks_backends_eds_backend_real_disable_persona_store;
	FOLKS_BACKEND_CLASS (klass)->enable_persona_store = folks_backends_eds_backend_real_enable_persona_store;
	FOLKS_BACKEND_CLASS (klass)->set_persona_stores = folks_backends_eds_backend_real_set_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_eds_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_eds_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_eds_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_eds_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_eds_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_eds_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_eds_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_eds_backend_real_get_is_quiescent;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_eds_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_eds_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_eds_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES, g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void folks_backends_eds_backend_instance_init (FolksBackendsEdsBackend * self) {
	self->priv = FOLKS_BACKENDS_EDS_BACKEND_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void folks_backends_eds_backend_finalize (GObject* obj) {
	FolksBackendsEdsBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackend);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	_g_object_unref0 (self->priv->_ab_sources);
	_g_object_unref0 (self->priv->_storeids);
	G_OBJECT_CLASS (folks_backends_eds_backend_parent_class)->finalize (obj);
}


/**
 * A backend which connects to EDS and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_eds_backend_get_type (void) {
	static volatile gsize folks_backends_eds_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_eds_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsEdsBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_eds_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsEdsBackend), 0, (GInstanceInitFunc) folks_backends_eds_backend_instance_init, NULL };
		GType folks_backends_eds_backend_type_id;
		folks_backends_eds_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsEdsBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_eds_backend_type_id__volatile, folks_backends_eds_backend_type_id);
	}
	return folks_backends_eds_backend_type_id__volatile;
}


static void _vala_folks_backends_eds_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsEdsBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackend);
	switch (property_id) {
		case FOLKS_BACKENDS_EDS_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



