/* valagirwriter.c generated by valac, the Vala compiler
 * generated from valagirwriter.vala, do not modify */

/* valagirwriter.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valagee.h>
#include <glib/gstdio.h>


#define VALA_TYPE_GIR_WRITER (vala_gir_writer_get_type ())
#define VALA_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriter))
#define VALA_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))
#define VALA_IS_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIR_WRITER))
#define VALA_IS_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIR_WRITER))
#define VALA_GIR_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))

typedef struct _ValaGIRWriter ValaGIRWriter;
typedef struct _ValaGIRWriterClass ValaGIRWriterClass;
typedef struct _ValaGIRWriterPrivate ValaGIRWriterPrivate;

#define VALA_GIR_WRITER_TYPE_GIR_NAMESPACE (vala_gir_writer_gir_namespace_get_type ())
typedef struct _ValaGIRWriterGIRNamespace ValaGIRWriterGIRNamespace;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_gir_writer_gir_namespace_free0(var) ((var == NULL) ? NULL : (var = (vala_gir_writer_gir_namespace_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaGIRWriter {
	ValaCodeVisitor parent_instance;
	ValaGIRWriterPrivate * priv;
};

struct _ValaGIRWriterClass {
	ValaCodeVisitorClass parent_class;
	gchar* (*get_interface_comment) (ValaGIRWriter* self, ValaInterface* iface);
	gchar* (*get_struct_comment) (ValaGIRWriter* self, ValaStruct* st);
	gchar* (*get_enum_comment) (ValaGIRWriter* self, ValaEnum* en);
	gchar* (*get_class_comment) (ValaGIRWriter* self, ValaClass* c);
	gchar* (*get_error_code_comment) (ValaGIRWriter* self, ValaErrorCode* ecode);
	gchar* (*get_enum_value_comment) (ValaGIRWriter* self, ValaEnumValue* ev);
	gchar* (*get_constant_comment) (ValaGIRWriter* self, ValaConstant* c);
	gchar* (*get_error_domain_comment) (ValaGIRWriter* self, ValaErrorDomain* edomain);
	gchar* (*get_field_comment) (ValaGIRWriter* self, ValaField* f);
	gchar* (*get_delegate_comment) (ValaGIRWriter* self, ValaDelegate* cb);
	gchar* (*get_method_comment) (ValaGIRWriter* self, ValaMethod* m);
	gchar* (*get_property_comment) (ValaGIRWriter* self, ValaProperty* prop);
	gchar* (*get_delegate_return_comment) (ValaGIRWriter* self, ValaDelegate* cb);
	gchar* (*get_signal_return_comment) (ValaGIRWriter* self, ValaSignal* sig);
	gchar* (*get_method_return_comment) (ValaGIRWriter* self, ValaMethod* m);
	gchar* (*get_signal_comment) (ValaGIRWriter* self, ValaSignal* sig);
	gchar* (*get_parameter_comment) (ValaGIRWriter* self, ValaParameter* param);
};

struct _ValaGIRWriterGIRNamespace {
	gchar* ns;
	gchar* version;
};

struct _ValaGIRWriterPrivate {
	ValaCodeContext* context;
	gchar* directory;
	gchar* gir_namespace;
	gchar* gir_version;
	GString* buffer;
	FILE* stream;
	ValaHashSet* unannotated_namespaces;
	ValaHashSet* our_namespaces;
	ValaArrayList* hierarchy;
	ValaArrayList* deferred;
	gint indent;
	ValaTypeSymbol* gobject_type;
	ValaTypeSymbol* ginitiallyunowned_type;
	ValaArrayList* externals;
	gint enum_value;
};


static gpointer vala_gir_writer_parent_class = NULL;

GType vala_gir_writer_get_type (void) G_GNUC_CONST;
static GType vala_gir_writer_gir_namespace_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest);
static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self);
#define VALA_GIR_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_WRITER, ValaGIRWriterPrivate))
enum  {
	VALA_GIR_WRITER_DUMMY_PROPERTY
};
static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g);
gchar* vala_gir_writer_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface);
static gchar* vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface);
gchar* vala_gir_writer_get_struct_comment (ValaGIRWriter* self, ValaStruct* st);
static gchar* vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self, ValaStruct* st);
gchar* vala_gir_writer_get_enum_comment (ValaGIRWriter* self, ValaEnum* en);
static gchar* vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self, ValaEnum* en);
gchar* vala_gir_writer_get_class_comment (ValaGIRWriter* self, ValaClass* c);
static gchar* vala_gir_writer_real_get_class_comment (ValaGIRWriter* self, ValaClass* c);
gchar* vala_gir_writer_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode);
static gchar* vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode);
gchar* vala_gir_writer_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev);
static gchar* vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev);
gchar* vala_gir_writer_get_constant_comment (ValaGIRWriter* self, ValaConstant* c);
static gchar* vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self, ValaConstant* c);
gchar* vala_gir_writer_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain);
static gchar* vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain);
gchar* vala_gir_writer_get_field_comment (ValaGIRWriter* self, ValaField* f);
static gchar* vala_gir_writer_real_get_field_comment (ValaGIRWriter* self, ValaField* f);
gchar* vala_gir_writer_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb);
gchar* vala_gir_writer_get_method_comment (ValaGIRWriter* self, ValaMethod* m);
static gchar* vala_gir_writer_real_get_method_comment (ValaGIRWriter* self, ValaMethod* m);
gchar* vala_gir_writer_get_property_comment (ValaGIRWriter* self, ValaProperty* prop);
static gchar* vala_gir_writer_real_get_property_comment (ValaGIRWriter* self, ValaProperty* prop);
gchar* vala_gir_writer_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb);
static gchar* vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb);
gchar* vala_gir_writer_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig);
static gchar* vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig);
gchar* vala_gir_writer_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m);
static gchar* vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m);
gchar* vala_gir_writer_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig);
static gchar* vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig);
gchar* vala_gir_writer_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param);
static gchar* vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param);
void vala_gir_writer_write_includes (ValaGIRWriter* self);
static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self);
void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_namespace, const gchar* gir_version, const gchar* package);
static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package);
static void vala_gir_writer_write_doc (ValaGIRWriter* self, const gchar* comment);
static void vala_gir_writer_write_indent (ValaGIRWriter* self);
static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns);
gchar* vala_ccode_base_module_get_ccode_header_filenames (ValaSymbol* sym);
static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name);
static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
gchar* vala_ccode_base_module_get_ccode_prefix (ValaSymbol* sym);
static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node);
static void vala_gir_writer_visit_deferred (ValaGIRWriter* self);
static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym);
static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol);
static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol);
gchar* vala_ccode_base_module_get_ccode_name (ValaCodeNode* node);
static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix);
static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail, gboolean write_comment);
gchar* vala_ccode_base_module_get_ccode_finish_name (ValaMethod* m);
static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean write_doc, gboolean instance);
static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal);
static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
gchar* vala_ccode_base_module_get_ccode_lower_case_prefix (ValaSymbol* sym);
static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index);
static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction);
static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, gboolean is_parameter, gint* index, gboolean has_array_length, const gchar* name, const gchar* comment, ValaParameterDirection direction, gboolean constructor, gboolean caller_allocates);
static void vala_gir_writer_skip_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length);
static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, const gchar* return_comment, gboolean constructor, ValaDataType* instance_type, gboolean user_data);
gboolean vala_ccode_base_module_get_ccode_array_length (ValaCodeNode* node);
static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static gboolean vala_gir_writer_check_signature (ValaGIRWriter* self, ValaMethod* m);
static gboolean vala_gir_writer_check_type (ValaGIRWriter* self, ValaDataType* type);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static gchar* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const gchar* name);
static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self, ValaSymbol* sym);
static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version);
ValaGIRWriter* vala_gir_writer_new (void);
ValaGIRWriter* vala_gir_writer_construct (GType object_type);
static void vala_gir_writer_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* vala_gir_writer_real_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface) {
	gchar* result = NULL;
	g_return_val_if_fail (iface != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_interface_comment (ValaGIRWriter* self, ValaInterface* iface) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_interface_comment (self, iface);
}


static gchar* vala_gir_writer_real_get_struct_comment (ValaGIRWriter* self, ValaStruct* st) {
	gchar* result = NULL;
	g_return_val_if_fail (st != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_struct_comment (ValaGIRWriter* self, ValaStruct* st) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_struct_comment (self, st);
}


static gchar* vala_gir_writer_real_get_enum_comment (ValaGIRWriter* self, ValaEnum* en) {
	gchar* result = NULL;
	g_return_val_if_fail (en != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_enum_comment (ValaGIRWriter* self, ValaEnum* en) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_enum_comment (self, en);
}


static gchar* vala_gir_writer_real_get_class_comment (ValaGIRWriter* self, ValaClass* c) {
	gchar* result = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_class_comment (ValaGIRWriter* self, ValaClass* c) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_class_comment (self, c);
}


static gchar* vala_gir_writer_real_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode) {
	gchar* result = NULL;
	g_return_val_if_fail (ecode != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_error_code_comment (ValaGIRWriter* self, ValaErrorCode* ecode) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_error_code_comment (self, ecode);
}


static gchar* vala_gir_writer_real_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev) {
	gchar* result = NULL;
	g_return_val_if_fail (ev != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_enum_value_comment (ValaGIRWriter* self, ValaEnumValue* ev) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_enum_value_comment (self, ev);
}


static gchar* vala_gir_writer_real_get_constant_comment (ValaGIRWriter* self, ValaConstant* c) {
	gchar* result = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_constant_comment (ValaGIRWriter* self, ValaConstant* c) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_constant_comment (self, c);
}


static gchar* vala_gir_writer_real_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain) {
	gchar* result = NULL;
	g_return_val_if_fail (edomain != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_error_domain_comment (ValaGIRWriter* self, ValaErrorDomain* edomain) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_error_domain_comment (self, edomain);
}


static gchar* vala_gir_writer_real_get_field_comment (ValaGIRWriter* self, ValaField* f) {
	gchar* result = NULL;
	g_return_val_if_fail (f != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_field_comment (ValaGIRWriter* self, ValaField* f) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_field_comment (self, f);
}


static gchar* vala_gir_writer_real_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	gchar* result = NULL;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_delegate_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_delegate_comment (self, cb);
}


static gchar* vala_gir_writer_real_get_method_comment (ValaGIRWriter* self, ValaMethod* m) {
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_method_comment (ValaGIRWriter* self, ValaMethod* m) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_method_comment (self, m);
}


static gchar* vala_gir_writer_real_get_property_comment (ValaGIRWriter* self, ValaProperty* prop) {
	gchar* result = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_property_comment (ValaGIRWriter* self, ValaProperty* prop) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_property_comment (self, prop);
}


static gchar* vala_gir_writer_real_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	gchar* result = NULL;
	g_return_val_if_fail (cb != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_delegate_return_comment (ValaGIRWriter* self, ValaDelegate* cb) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_delegate_return_comment (self, cb);
}


static gchar* vala_gir_writer_real_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig) {
	gchar* result = NULL;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_signal_return_comment (ValaGIRWriter* self, ValaSignal* sig) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_signal_return_comment (self, sig);
}


static gchar* vala_gir_writer_real_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m) {
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_method_return_comment (ValaGIRWriter* self, ValaMethod* m) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_method_return_comment (self, m);
}


static gchar* vala_gir_writer_real_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig) {
	gchar* result = NULL;
	g_return_val_if_fail (sig != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_signal_comment (ValaGIRWriter* self, ValaSignal* sig) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_signal_comment (self, sig);
}


static gchar* vala_gir_writer_real_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param) {
	gchar* result = NULL;
	g_return_val_if_fail (param != NULL, NULL);
	result = NULL;
	return result;
}


gchar* vala_gir_writer_get_parameter_comment (ValaGIRWriter* self, ValaParameter* param) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_GIR_WRITER_GET_CLASS (self)->get_parameter_comment (self, param);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void vala_gir_writer_write_includes (ValaGIRWriter* self) {
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		ValaArrayList* _i_list;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _i_size;
		gint _i_index;
		_tmp0_ = self->priv->externals;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_i_list = _tmp1_;
		_tmp2_ = _i_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_i_size = _tmp4_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaGIRWriterGIRNamespace* i;
			ValaGIRWriterGIRNamespace* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp5_ = _i_index;
			_i_index = _tmp5_ + 1;
			_tmp6_ = _i_index;
			_tmp7_ = _i_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _i_list;
			_tmp9_ = _i_index;
			_tmp10_ = vala_list_get ((ValaList*) _tmp8_, _tmp9_);
			i = (ValaGIRWriterGIRNamespace*) _tmp10_;
			_tmp11_ = i;
			_tmp12_ = (*_tmp11_).ns;
			_tmp13_ = self->priv->gir_namespace;
			if (g_strcmp0 (_tmp12_, _tmp13_) != 0) {
				FILE* _tmp14_;
				ValaGIRWriterGIRNamespace* _tmp15_;
				const gchar* _tmp16_;
				ValaGIRWriterGIRNamespace* _tmp17_;
				const gchar* _tmp18_;
				vala_gir_writer_write_indent_stream (self);
				_tmp14_ = self->priv->stream;
				_tmp15_ = i;
				_tmp16_ = (*_tmp15_).ns;
				_tmp17_ = i;
				_tmp18_ = (*_tmp17_).version;
				fprintf (_tmp14_, "<include name=\"%s\" version=\"%s\"/>\n", _tmp16_, _tmp18_);
			}
			_vala_gir_writer_gir_namespace_free0 (i);
		}
		_vala_iterable_unref0 (_i_list);
	}
}


/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context  a code context
 * @param filename a relative or absolute filename
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_namespace, const gchar* gir_version, const gchar* package) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCodeContext* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaNamespace* _tmp10_;
	ValaNamespace* _tmp11_;
	ValaNamespace* root_symbol;
	ValaNamespace* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaSymbol* _tmp15_ = NULL;
	ValaSymbol* glib_ns;
	ValaSymbol* _tmp16_;
	ValaScope* _tmp17_;
	ValaScope* _tmp18_;
	ValaSymbol* _tmp19_ = NULL;
	ValaSymbol* _tmp20_;
	ValaScope* _tmp21_;
	ValaScope* _tmp22_;
	ValaSymbol* _tmp23_ = NULL;
	const gchar* _tmp24_;
	ValaCodeContext* _tmp25_;
	gint _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* filename;
	const gchar* _tmp32_;
	FILE* _tmp33_ = NULL;
	FILE* _tmp34_;
	FILE* _tmp38_;
	FILE* _tmp39_;
	FILE* _tmp40_;
	FILE* _tmp41_;
	FILE* _tmp42_;
	FILE* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	FILE* _tmp46_;
	GString* _tmp47_;
	const gchar* _tmp48_;
	ValaHashSet* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (gir_namespace != NULL);
	g_return_if_fail (gir_version != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = context;
	_tmp1_ = _vala_code_context_ref0 (_tmp0_);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = directory;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp3_;
	_tmp4_ = gir_namespace;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->gir_namespace);
	self->priv->gir_namespace = _tmp5_;
	_tmp6_ = gir_version;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->gir_version);
	self->priv->gir_version = _tmp7_;
	_tmp8_ = context;
	_tmp9_ = vala_code_context_get_root (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	root_symbol = _tmp11_;
	_tmp12_ = root_symbol;
	_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_scope_lookup (_tmp14_, "GLib");
	glib_ns = _tmp15_;
	_tmp16_ = glib_ns;
	_tmp17_ = vala_symbol_get_scope (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_scope_lookup (_tmp18_, "Object");
	_vala_code_node_unref0 (self->priv->gobject_type);
	self->priv->gobject_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp20_ = glib_ns;
	_tmp21_ = vala_symbol_get_scope (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_scope_lookup (_tmp22_, "InitiallyUnowned");
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	self->priv->ginitiallyunowned_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
	_tmp24_ = package;
	vala_gir_writer_write_package (self, _tmp24_);
	_tmp25_ = context;
	vala_code_context_accept (_tmp25_, (ValaCodeVisitor*) self);
	_tmp26_ = self->priv->indent;
	self->priv->indent = _tmp26_ - 1;
	_tmp27_ = self->priv->buffer;
	g_string_append_printf (_tmp27_, "</repository>\n");
	_tmp28_ = directory;
	_tmp29_ = gir_namespace;
	_tmp30_ = gir_version;
	_tmp31_ = g_strdup_printf ("%s%c%s-%s.gir", _tmp28_, (gint) G_DIR_SEPARATOR, _tmp29_, _tmp30_);
	filename = _tmp31_;
	_tmp32_ = filename;
	_tmp33_ = g_fopen (_tmp32_, "w");
	_fclose0 (self->priv->stream);
	self->priv->stream = _tmp33_;
	_tmp34_ = self->priv->stream;
	if (_tmp34_ == NULL) {
		const gchar* _tmp35_;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		_tmp35_ = filename;
		_tmp36_ = g_strdup_printf ("unable to open `%s' for writing", _tmp35_);
		_tmp37_ = _tmp36_;
		vala_report_error (NULL, _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (filename);
		_vala_code_node_unref0 (glib_ns);
		_vala_code_node_unref0 (root_symbol);
		return;
	}
	_tmp38_ = self->priv->stream;
	fprintf (_tmp38_, "<?xml version=\"1.0\"?>\n");
	_tmp39_ = self->priv->stream;
	fprintf (_tmp39_, "<repository version=\"1.2\"");
	_tmp40_ = self->priv->stream;
	fprintf (_tmp40_, " xmlns=\"http://www.gtk.org/introspection/core/1.0\"");
	_tmp41_ = self->priv->stream;
	fprintf (_tmp41_, " xmlns:c=\"http://www.gtk.org/introspection/c/1.0\"");
	_tmp42_ = self->priv->stream;
	fprintf (_tmp42_, " xmlns:glib=\"http://www.gtk.org/introspection/glib/1.0\"");
	_tmp43_ = self->priv->stream;
	fprintf (_tmp43_, ">\n");
	_tmp44_ = self->priv->indent;
	self->priv->indent = _tmp44_ + 1;
	vala_gir_writer_write_includes (self);
	_tmp45_ = self->priv->indent;
	self->priv->indent = _tmp45_ - 1;
	_tmp46_ = self->priv->stream;
	_tmp47_ = self->priv->buffer;
	_tmp48_ = _tmp47_->str;
	fputs (_tmp48_, _tmp46_);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
	{
		ValaHashSet* _tmp49_;
		ValaIterator* _tmp50_ = NULL;
		ValaIterator* _ns_it;
		_tmp49_ = self->priv->unannotated_namespaces;
		_tmp50_ = vala_iterable_iterator ((ValaIterable*) _tmp49_);
		_ns_it = _tmp50_;
		while (TRUE) {
			ValaIterator* _tmp51_;
			gboolean _tmp52_ = FALSE;
			ValaIterator* _tmp53_;
			gpointer _tmp54_ = NULL;
			ValaNamespace* ns;
			ValaHashSet* _tmp55_;
			ValaNamespace* _tmp56_;
			gboolean _tmp57_ = FALSE;
			_tmp51_ = _ns_it;
			_tmp52_ = vala_iterator_next (_tmp51_);
			if (!_tmp52_) {
				break;
			}
			_tmp53_ = _ns_it;
			_tmp54_ = vala_iterator_get (_tmp53_);
			ns = (ValaNamespace*) _tmp54_;
			_tmp55_ = self->priv->our_namespaces;
			_tmp56_ = ns;
			_tmp57_ = vala_collection_contains ((ValaCollection*) _tmp55_, _tmp56_);
			if (!_tmp57_) {
				ValaNamespace* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaNamespace* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_;
				_tmp58_ = ns;
				_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = ns;
				_tmp62_ = vala_symbol_get_name ((ValaSymbol*) _tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = g_strdup_printf ("Namespace %s does not have a GIR namespace and version annotation", _tmp63_);
				_tmp65_ = _tmp64_;
				vala_report_warning (_tmp60_, _tmp65_);
				_g_free0 (_tmp65_);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	{
		ValaHashSet* _tmp66_;
		ValaIterator* _tmp67_ = NULL;
		ValaIterator* _ns_it;
		_tmp66_ = self->priv->our_namespaces;
		_tmp67_ = vala_iterable_iterator ((ValaIterable*) _tmp66_);
		_ns_it = _tmp67_;
		while (TRUE) {
			ValaIterator* _tmp68_;
			gboolean _tmp69_ = FALSE;
			ValaIterator* _tmp70_;
			gpointer _tmp71_ = NULL;
			ValaNamespace* ns;
			ValaNamespace* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			ValaSourceFile* _tmp75_;
			ValaSourceFile* _tmp76_;
			const gchar* _tmp77_;
			ValaNamespace* _tmp78_;
			ValaSourceReference* _tmp79_;
			ValaSourceReference* _tmp80_;
			ValaSourceFile* _tmp81_;
			ValaSourceFile* _tmp82_;
			const gchar* _tmp83_;
			_tmp68_ = _ns_it;
			_tmp69_ = vala_iterator_next (_tmp68_);
			if (!_tmp69_) {
				break;
			}
			_tmp70_ = _ns_it;
			_tmp71_ = vala_iterator_get (_tmp70_);
			ns = (ValaNamespace*) _tmp71_;
			_tmp72_ = ns;
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_source_reference_get_file (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = gir_namespace;
			vala_source_file_set_gir_namespace (_tmp76_, _tmp77_);
			_tmp78_ = ns;
			_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp78_);
			_tmp80_ = _tmp79_;
			_tmp81_ = vala_source_reference_get_file (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = gir_version;
			vala_source_file_set_gir_version (_tmp82_, _tmp83_);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	_tmp84_ = self->priv->our_namespaces;
	_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp86_ == 0) {
		vala_report_error (NULL, "No suitable namespace found to export for GIR");
	}
	_g_free0 (filename);
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (root_symbol);
}


static void vala_gir_writer_write_doc (ValaGIRWriter* self, const gchar* comment) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = comment;
	if (_tmp0_ != NULL) {
		GString* _tmp1_;
		GString* _tmp2_;
		const gchar* _tmp3_;
		GString* _tmp4_;
		vala_gir_writer_write_indent (self);
		_tmp1_ = self->priv->buffer;
		g_string_append (_tmp1_, "<doc xml:whitespace=\"preserve\">");
		_tmp2_ = self->priv->buffer;
		_tmp3_ = comment;
		g_string_append (_tmp2_, _tmp3_);
		_tmp4_ = self->priv->buffer;
		g_string_append (_tmp4_, "</doc>\n");
	}
}


static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = package;
	g_string_append_printf (_tmp0_, "<package name=\"%s\"/>\n", _tmp1_);
}


static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaSet* header_filenames;
	ValaNamespace* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	header_filenames = (ValaSet*) _tmp2_;
	_tmp3_ = ns;
	_tmp4_ = vala_ccode_base_module_get_ccode_header_filenames ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_g_free0 (_tmp5_);
	{
		gchar** c_header_filename_collection = NULL;
		gint c_header_filename_collection_length1 = 0;
		gint _c_header_filename_collection_size_ = 0;
		gint c_header_filename_it = 0;
		c_header_filename_collection = _tmp8_;
		c_header_filename_collection_length1 = _tmp8__length1;
		for (c_header_filename_it = 0; c_header_filename_it < _tmp8__length1; c_header_filename_it = c_header_filename_it + 1) {
			gchar* _tmp9_;
			gchar* c_header_filename = NULL;
			_tmp9_ = g_strdup (c_header_filename_collection[c_header_filename_it]);
			c_header_filename = _tmp9_;
			{
				ValaSet* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = header_filenames;
				_tmp11_ = c_header_filename;
				vala_collection_add ((ValaCollection*) _tmp10_, _tmp11_);
				_g_free0 (c_header_filename);
			}
		}
		c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaNamespace* _tmp12_;
		ValaScope* _tmp13_;
		ValaScope* _tmp14_;
		ValaMap* _tmp15_ = NULL;
		ValaMap* _tmp16_;
		ValaCollection* _tmp17_ = NULL;
		ValaCollection* _tmp18_;
		ValaIterator* _tmp19_ = NULL;
		ValaIterator* _tmp20_;
		ValaIterator* _symbol_it;
		_tmp12_ = ns;
		_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_scope_get_symbol_table (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_map_get_values (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_iterable_iterator ((ValaIterable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_vala_iterable_unref0 (_tmp18_);
		_vala_map_unref0 (_tmp16_);
		_symbol_it = _tmp20_;
		while (TRUE) {
			ValaIterator* _tmp21_;
			gboolean _tmp22_ = FALSE;
			ValaIterator* _tmp23_;
			gpointer _tmp24_ = NULL;
			ValaSymbol* symbol;
			ValaSymbol* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_ = NULL;
			gchar** _tmp30_;
			gint _tmp30__length1;
			_tmp21_ = _symbol_it;
			_tmp22_ = vala_iterator_next (_tmp21_);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = _symbol_it;
			_tmp24_ = vala_iterator_get (_tmp23_);
			symbol = (ValaSymbol*) _tmp24_;
			_tmp25_ = symbol;
			_tmp26_ = vala_ccode_base_module_get_ccode_header_filenames (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, ",", 0);
			_tmp30_ = _tmp29_;
			_tmp30__length1 = _vala_array_length (_tmp28_);
			_g_free0 (_tmp27_);
			{
				gchar** c_header_filename_collection = NULL;
				gint c_header_filename_collection_length1 = 0;
				gint _c_header_filename_collection_size_ = 0;
				gint c_header_filename_it = 0;
				c_header_filename_collection = _tmp30_;
				c_header_filename_collection_length1 = _tmp30__length1;
				for (c_header_filename_it = 0; c_header_filename_it < _tmp30__length1; c_header_filename_it = c_header_filename_it + 1) {
					gchar* _tmp31_;
					gchar* c_header_filename = NULL;
					_tmp31_ = g_strdup (c_header_filename_collection[c_header_filename_it]);
					c_header_filename = _tmp31_;
					{
						ValaSet* _tmp32_;
						const gchar* _tmp33_;
						_tmp32_ = header_filenames;
						_tmp33_ = c_header_filename;
						vala_collection_add ((ValaCollection*) _tmp32_, _tmp33_);
						_g_free0 (c_header_filename);
					}
				}
				c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_vala_code_node_unref0 (symbol);
		}
		_vala_iterator_unref0 (_symbol_it);
	}
	{
		ValaSet* _tmp34_;
		ValaIterator* _tmp35_ = NULL;
		ValaIterator* _c_header_filename_it;
		_tmp34_ = header_filenames;
		_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
		_c_header_filename_it = _tmp35_;
		while (TRUE) {
			ValaIterator* _tmp36_;
			gboolean _tmp37_ = FALSE;
			ValaIterator* _tmp38_;
			gpointer _tmp39_ = NULL;
			gchar* c_header_filename;
			const gchar* _tmp40_;
			_tmp36_ = _c_header_filename_it;
			_tmp37_ = vala_iterator_next (_tmp36_);
			if (!_tmp37_) {
				break;
			}
			_tmp38_ = _c_header_filename_it;
			_tmp39_ = vala_iterator_get (_tmp38_);
			c_header_filename = (gchar*) _tmp39_;
			_tmp40_ = c_header_filename;
			vala_gir_writer_write_c_include (self, _tmp40_);
			_g_free0 (c_header_filename);
		}
		_vala_iterator_unref0 (_c_header_filename_it);
	}
	_vala_iterable_unref0 (header_filenames);
}


static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = name;
	g_string_append_printf (_tmp0_, "<c:include name=\"%s\"/>\n", _tmp1_);
}


static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIRWriter * self;
	ValaNamespace* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaNamespace* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaNamespace* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaNamespace* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	ValaNamespace* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* cprefix;
	const gchar* _tmp22_;
	GString* _tmp25_;
	gint _tmp26_;
	ValaNamespace* _tmp27_;
	ValaArrayList* _tmp28_;
	ValaNamespace* _tmp29_;
	ValaNamespace* _tmp30_;
	ValaArrayList* _tmp31_;
	gint _tmp32_;
	GString* _tmp33_;
	ValaHashSet* _tmp34_;
	ValaNamespace* _tmp35_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = ns;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaArrayList* _tmp6_;
		ValaNamespace* _tmp7_;
		ValaNamespace* _tmp8_;
		ValaArrayList* _tmp9_;
		_tmp6_ = self->priv->hierarchy;
		_tmp7_ = ns;
		vala_list_insert ((ValaList*) _tmp6_, 0, (ValaSymbol*) _tmp7_);
		_tmp8_ = ns;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
		_tmp9_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp9_, 0);
		return;
	}
	_tmp10_ = ns;
	_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_symbol_get_name (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaNamespace* _tmp15_;
		_tmp15_ = ns;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp15_, (ValaCodeVisitor*) self);
		return;
	}
	_tmp16_ = ns;
	vala_gir_writer_write_c_includes (self, _tmp16_);
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	_tmp18_ = self->priv->gir_namespace;
	_tmp19_ = self->priv->gir_version;
	g_string_append_printf (_tmp17_, "<namespace name=\"%s\" version=\"%s\"", _tmp18_, _tmp19_);
	_tmp20_ = ns;
	_tmp21_ = vala_ccode_base_module_get_ccode_prefix ((ValaSymbol*) _tmp20_);
	cprefix = _tmp21_;
	_tmp22_ = cprefix;
	if (_tmp22_ != NULL) {
		GString* _tmp23_;
		const gchar* _tmp24_;
		_tmp23_ = self->priv->buffer;
		_tmp24_ = cprefix;
		g_string_append_printf (_tmp23_, " c:prefix=\"%s\"", _tmp24_);
	}
	_tmp25_ = self->priv->buffer;
	g_string_append_printf (_tmp25_, ">\n");
	_tmp26_ = self->priv->indent;
	self->priv->indent = _tmp26_ + 1;
	_tmp27_ = ns;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp27_);
	_tmp28_ = self->priv->hierarchy;
	_tmp29_ = ns;
	vala_list_insert ((ValaList*) _tmp28_, 0, (ValaSymbol*) _tmp29_);
	_tmp30_ = ns;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp30_, (ValaCodeVisitor*) self);
	_tmp31_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp31_, 0);
	_tmp32_ = self->priv->indent;
	self->priv->indent = _tmp32_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp33_ = self->priv->buffer;
	g_string_append_printf (_tmp33_, "</namespace>\n");
	_tmp34_ = self->priv->our_namespaces;
	_tmp35_ = ns;
	vala_collection_add ((ValaCollection*) _tmp34_, _tmp35_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (cprefix);
}


static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol) {
	ValaSymbol* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = symbol;
	_tmp1_ = vala_symbol_get_deprecated (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gchar* _tmp3_ = NULL;
		ValaSymbol* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		GString* _tmp15_;
		const gchar* _tmp16_;
		ValaSymbol* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gboolean _tmp21_;
		_tmp4_ = symbol;
		_tmp5_ = vala_symbol_get_replacement (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_ == NULL;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("");
			_g_free0 (_tmp3_);
			_tmp3_ = _tmp9_;
		} else {
			ValaSymbol* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			_tmp10_ = symbol;
			_tmp11_ = vala_symbol_get_replacement (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Use %s", _tmp13_);
			_g_free0 (_tmp3_);
			_tmp3_ = _tmp14_;
			_g_free0 (_tmp13_);
		}
		_tmp15_ = self->priv->buffer;
		_tmp16_ = _tmp3_;
		g_string_append_printf (_tmp15_, " deprecated=\"%s\"", _tmp16_);
		_tmp17_ = symbol;
		_tmp18_ = vala_symbol_get_deprecated_since (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_ != NULL;
		_g_free0 (_tmp20_);
		if (_tmp21_) {
			GString* _tmp22_;
			ValaSymbol* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp22_ = self->priv->buffer;
			_tmp23_ = symbol;
			_tmp24_ = vala_symbol_get_deprecated_since (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = _tmp25_;
			g_string_append_printf (_tmp22_, " deprecated-version=\"%s\"", _tmp26_);
			_g_free0 (_tmp26_);
		}
		_g_free0 (_tmp3_);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIRWriter * self;
	ValaClass* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaClass* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	ValaClass* _tmp11_;
	ValaTypeSymbol* _tmp12_;
	gboolean _tmp13_ = FALSE;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = cl;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaClass* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = cl;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp11_ = cl;
	_tmp12_ = self->priv->gobject_type;
	_tmp13_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp11_, _tmp12_);
	if (_tmp13_) {
		ValaClass* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* gtype_struct_name;
		GString* _tmp19_;
		ValaClass* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		ValaClass* _tmp23_;
		GString* _tmp24_;
		const gchar* _tmp25_;
		GString* _tmp26_;
		ValaClass* _tmp27_;
		ValaClass* _tmp28_;
		ValaClass* _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		ValaClass* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		ValaClass* _tmp36_;
		GString* _tmp37_;
		gint _tmp38_;
		ValaClass* _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		ValaClass* _tmp64_;
		GString* _tmp65_;
		gint _tmp66_;
		GString* _tmp67_;
		ValaClass* _tmp68_;
		ValaClass* _tmp69_;
		ValaClass* _tmp70_;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_;
		ValaClass* _tmp73_;
		ValaClass* _tmp74_;
		ValaClass* _tmp75_;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_;
		gint _tmp78_;
		GString* _tmp79_;
		GString* _tmp80_;
		gint _tmp81_;
		GString* _tmp82_;
		ValaClass* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp85_;
		ValaClass* _tmp86_;
		gchar* _tmp87_ = NULL;
		gchar* _tmp88_;
		gint _tmp89_;
		GString* _tmp90_;
		ValaArrayList* _tmp91_;
		ValaClass* _tmp92_;
		ValaClass* _tmp93_;
		ValaArrayList* _tmp94_;
		gint _tmp95_;
		GString* _tmp96_;
		GString* _tmp97_;
		const gchar* _tmp98_;
		ValaClass* _tmp99_;
		GString* _tmp100_;
		ValaClass* _tmp101_;
		const gchar* _tmp102_;
		const gchar* _tmp103_;
		GString* _tmp104_;
		gint _tmp105_;
		GString* _tmp106_;
		gint _tmp107_;
		GString* _tmp108_;
		ValaClass* _tmp109_;
		ValaClass* _tmp110_;
		ValaClass* _tmp111_;
		gchar* _tmp112_ = NULL;
		gchar* _tmp113_;
		ValaClass* _tmp114_;
		ValaClass* _tmp115_;
		ValaClass* _tmp116_;
		gchar* _tmp117_ = NULL;
		gchar* _tmp118_;
		gint _tmp119_;
		GString* _tmp120_;
		gint _tmp243_;
		GString* _tmp244_;
		GString* _tmp245_;
		ValaClass* _tmp246_;
		const gchar* _tmp247_;
		const gchar* _tmp248_;
		ValaClass* _tmp249_;
		gchar* _tmp250_ = NULL;
		gchar* _tmp251_;
		_tmp14_ = cl;
		_tmp15_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "Class", NULL);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		gtype_struct_name = _tmp18_;
		vala_gir_writer_write_indent (self);
		_tmp19_ = self->priv->buffer;
		_tmp20_ = cl;
		_tmp21_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		g_string_append_printf (_tmp19_, "<class name=\"%s\"", _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = cl;
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp23_);
		_tmp24_ = self->priv->buffer;
		_tmp25_ = gtype_struct_name;
		g_string_append_printf (_tmp24_, " glib:type-struct=\"%s\"", _tmp25_);
		_tmp26_ = self->priv->buffer;
		_tmp27_ = cl;
		_tmp28_ = vala_class_get_base_class (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp29_);
		_tmp31_ = _tmp30_;
		g_string_append_printf (_tmp26_, " parent=\"%s\"", _tmp31_);
		_g_free0 (_tmp31_);
		_tmp32_ = cl;
		_tmp33_ = vala_class_get_is_abstract (_tmp32_);
		_tmp34_ = _tmp33_;
		if (_tmp34_) {
			GString* _tmp35_;
			_tmp35_ = self->priv->buffer;
			g_string_append_printf (_tmp35_, " abstract=\"1\"");
		}
		_tmp36_ = cl;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp36_);
		_tmp37_ = self->priv->buffer;
		g_string_append_printf (_tmp37_, ">\n");
		_tmp38_ = self->priv->indent;
		self->priv->indent = _tmp38_ + 1;
		_tmp39_ = cl;
		_tmp40_ = vala_gir_writer_get_class_comment (self, _tmp39_);
		_tmp41_ = _tmp40_;
		vala_gir_writer_write_doc (self, _tmp41_);
		_g_free0 (_tmp41_);
		{
			ValaClass* _tmp42_;
			ValaList* _tmp43_ = NULL;
			ValaList* _base_type_list;
			ValaList* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp42_ = cl;
			_tmp43_ = vala_class_get_base_types (_tmp42_);
			_base_type_list = _tmp43_;
			_tmp44_ = _base_type_list;
			_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
			_tmp46_ = _tmp45_;
			_base_type_size = _tmp46_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				ValaList* _tmp50_;
				gint _tmp51_;
				gpointer _tmp52_ = NULL;
				ValaDataType* base_type;
				ValaDataType* _tmp53_;
				ValaObjectType* _tmp54_;
				ValaObjectType* object_type;
				ValaObjectType* _tmp55_;
				ValaObjectTypeSymbol* _tmp56_;
				ValaObjectTypeSymbol* _tmp57_;
				_tmp47_ = _base_type_index;
				_base_type_index = _tmp47_ + 1;
				_tmp48_ = _base_type_index;
				_tmp49_ = _base_type_size;
				if (!(_tmp48_ < _tmp49_)) {
					break;
				}
				_tmp50_ = _base_type_list;
				_tmp51_ = _base_type_index;
				_tmp52_ = vala_list_get (_tmp50_, _tmp51_);
				base_type = (ValaDataType*) _tmp52_;
				_tmp53_ = base_type;
				_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				object_type = _tmp54_;
				_tmp55_ = object_type;
				_tmp56_ = vala_object_type_get_type_symbol (_tmp55_);
				_tmp57_ = _tmp56_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_INTERFACE)) {
					GString* _tmp58_;
					ValaObjectType* _tmp59_;
					ValaObjectTypeSymbol* _tmp60_;
					ValaObjectTypeSymbol* _tmp61_;
					gchar* _tmp62_ = NULL;
					gchar* _tmp63_;
					vala_gir_writer_write_indent (self);
					_tmp58_ = self->priv->buffer;
					_tmp59_ = object_type;
					_tmp60_ = vala_object_type_get_type_symbol (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp61_);
					_tmp63_ = _tmp62_;
					g_string_append_printf (_tmp58_, "<implements name=\"%s\"/>\n", _tmp63_);
					_g_free0 (_tmp63_);
				}
				_vala_code_node_unref0 (object_type);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp64_ = cl;
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp64_);
		vala_gir_writer_write_indent (self);
		_tmp65_ = self->priv->buffer;
		g_string_append_printf (_tmp65_, "<field name=\"parent_instance\">\n");
		_tmp66_ = self->priv->indent;
		self->priv->indent = _tmp66_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp67_ = self->priv->buffer;
		_tmp68_ = cl;
		_tmp69_ = vala_class_get_base_class (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = cl;
		_tmp74_ = vala_class_get_base_class (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp75_);
		_tmp77_ = _tmp76_;
		g_string_append_printf (_tmp67_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp72_, _tmp77_);
		_g_free0 (_tmp77_);
		_g_free0 (_tmp72_);
		_tmp78_ = self->priv->indent;
		self->priv->indent = _tmp78_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp79_ = self->priv->buffer;
		g_string_append_printf (_tmp79_, "</field>\n");
		vala_gir_writer_write_indent (self);
		_tmp80_ = self->priv->buffer;
		g_string_append_printf (_tmp80_, "<field name=\"priv\">\n");
		_tmp81_ = self->priv->indent;
		self->priv->indent = _tmp81_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp82_ = self->priv->buffer;
		_tmp83_ = cl;
		_tmp84_ = vala_symbol_get_name ((ValaSymbol*) _tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = cl;
		_tmp87_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp86_);
		_tmp88_ = _tmp87_;
		g_string_append_printf (_tmp82_, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", _tmp85_, _tmp88_);
		_g_free0 (_tmp88_);
		_tmp89_ = self->priv->indent;
		self->priv->indent = _tmp89_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp90_ = self->priv->buffer;
		g_string_append_printf (_tmp90_, "</field>\n");
		_tmp91_ = self->priv->hierarchy;
		_tmp92_ = cl;
		vala_list_insert ((ValaList*) _tmp91_, 0, (ValaSymbol*) _tmp92_);
		_tmp93_ = cl;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp93_, (ValaCodeVisitor*) self);
		_tmp94_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp94_, 0);
		_tmp95_ = self->priv->indent;
		self->priv->indent = _tmp95_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp96_ = self->priv->buffer;
		g_string_append_printf (_tmp96_, "</class>\n");
		vala_gir_writer_write_indent (self);
		_tmp97_ = self->priv->buffer;
		_tmp98_ = gtype_struct_name;
		g_string_append_printf (_tmp97_, "<record name=\"%s\"", _tmp98_);
		_tmp99_ = cl;
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp99_, "Class");
		_tmp100_ = self->priv->buffer;
		_tmp101_ = cl;
		_tmp102_ = vala_symbol_get_name ((ValaSymbol*) _tmp101_);
		_tmp103_ = _tmp102_;
		g_string_append_printf (_tmp100_, " glib:is-gtype-struct-for=\"%s\"", _tmp103_);
		_tmp104_ = self->priv->buffer;
		g_string_append_printf (_tmp104_, ">\n");
		_tmp105_ = self->priv->indent;
		self->priv->indent = _tmp105_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp106_ = self->priv->buffer;
		g_string_append_printf (_tmp106_, "<field name=\"parent_class\">\n");
		_tmp107_ = self->priv->indent;
		self->priv->indent = _tmp107_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp108_ = self->priv->buffer;
		_tmp109_ = cl;
		_tmp110_ = vala_class_get_base_class (_tmp109_);
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = cl;
		_tmp115_ = vala_class_get_base_class (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp116_);
		_tmp118_ = _tmp117_;
		g_string_append_printf (_tmp108_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", _tmp113_, _tmp118_);
		_g_free0 (_tmp118_);
		_g_free0 (_tmp113_);
		_tmp119_ = self->priv->indent;
		self->priv->indent = _tmp119_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp120_ = self->priv->buffer;
		g_string_append_printf (_tmp120_, "</field>\n");
		{
			ValaClass* _tmp121_;
			ValaList* _tmp122_ = NULL;
			ValaList* _m_list;
			ValaList* _tmp123_;
			gint _tmp124_;
			gint _tmp125_;
			gint _m_size;
			gint _m_index;
			_tmp121_ = cl;
			_tmp122_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp121_);
			_m_list = _tmp122_;
			_tmp123_ = _m_list;
			_tmp124_ = vala_collection_get_size ((ValaCollection*) _tmp123_);
			_tmp125_ = _tmp124_;
			_m_size = _tmp125_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp126_;
				gint _tmp127_;
				gint _tmp128_;
				ValaList* _tmp129_;
				gint _tmp130_;
				gpointer _tmp131_ = NULL;
				ValaMethod* m;
				gboolean _tmp132_ = FALSE;
				ValaMethod* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				gboolean _tmp139_;
				_tmp126_ = _m_index;
				_m_index = _tmp126_ + 1;
				_tmp127_ = _m_index;
				_tmp128_ = _m_size;
				if (!(_tmp127_ < _tmp128_)) {
					break;
				}
				_tmp129_ = _m_list;
				_tmp130_ = _m_index;
				_tmp131_ = vala_list_get (_tmp129_, _tmp130_);
				m = (ValaMethod*) _tmp131_;
				_tmp133_ = m;
				_tmp134_ = vala_method_get_is_abstract (_tmp133_);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					_tmp132_ = TRUE;
				} else {
					ValaMethod* _tmp136_;
					gboolean _tmp137_;
					gboolean _tmp138_;
					_tmp136_ = m;
					_tmp137_ = vala_method_get_is_virtual (_tmp136_);
					_tmp138_ = _tmp137_;
					_tmp132_ = _tmp138_;
				}
				_tmp139_ = _tmp132_;
				if (_tmp139_) {
					ValaMethod* _tmp140_;
					gboolean _tmp141_;
					gboolean _tmp142_;
					vala_gir_writer_write_indent (self);
					_tmp140_ = m;
					_tmp141_ = vala_method_get_coroutine (_tmp140_);
					_tmp142_ = _tmp141_;
					if (_tmp142_) {
						ValaMethod* _tmp143_;
						const gchar* _tmp144_;
						const gchar* _tmp145_;
						gchar* _tmp146_;
						gchar* finish_name;
						const gchar* _tmp147_;
						gboolean _tmp148_ = FALSE;
						const gchar* _tmp156_;
						gchar* _tmp157_;
						GString* _tmp158_;
						ValaMethod* _tmp159_;
						const gchar* _tmp160_;
						const gchar* _tmp161_;
						gint _tmp162_;
						ValaMethod* _tmp163_;
						ValaMethod* _tmp164_;
						const gchar* _tmp165_;
						const gchar* _tmp166_;
						ValaMethod* _tmp167_;
						gchar* _tmp168_ = NULL;
						gchar* _tmp169_;
						ValaMethod* _tmp170_;
						ValaList* _tmp171_ = NULL;
						ValaList* _tmp172_;
						ValaVoidType* _tmp173_;
						ValaVoidType* _tmp174_;
						gint _tmp175_;
						GString* _tmp176_;
						GString* _tmp177_;
						const gchar* _tmp178_;
						gint _tmp179_;
						ValaMethod* _tmp180_;
						const gchar* _tmp181_;
						ValaMethod* _tmp182_;
						gchar* _tmp183_ = NULL;
						gchar* _tmp184_;
						ValaMethod* _tmp185_;
						ValaList* _tmp186_ = NULL;
						ValaList* _tmp187_;
						ValaMethod* _tmp188_;
						ValaDataType* _tmp189_;
						ValaDataType* _tmp190_;
						ValaMethod* _tmp191_;
						gboolean _tmp192_;
						gboolean _tmp193_;
						gint _tmp194_;
						GString* _tmp195_;
						_tmp143_ = m;
						_tmp144_ = vala_symbol_get_name ((ValaSymbol*) _tmp143_);
						_tmp145_ = _tmp144_;
						_tmp146_ = g_strdup (_tmp145_);
						finish_name = _tmp146_;
						_tmp147_ = finish_name;
						_tmp148_ = g_str_has_suffix (_tmp147_, "_async");
						if (_tmp148_) {
							const gchar* _tmp149_;
							const gchar* _tmp150_;
							gint _tmp151_;
							gint _tmp152_;
							gint _tmp153_;
							gint _tmp154_;
							gchar* _tmp155_ = NULL;
							_tmp149_ = finish_name;
							_tmp150_ = finish_name;
							_tmp151_ = strlen (_tmp150_);
							_tmp152_ = _tmp151_;
							_tmp153_ = strlen ("_async");
							_tmp154_ = _tmp153_;
							_tmp155_ = string_substring (_tmp149_, (glong) 0, (glong) (_tmp152_ - _tmp154_));
							_g_free0 (finish_name);
							finish_name = _tmp155_;
						}
						_tmp156_ = finish_name;
						_tmp157_ = g_strconcat (_tmp156_, "_finish", NULL);
						_g_free0 (finish_name);
						finish_name = _tmp157_;
						vala_gir_writer_write_indent (self);
						_tmp158_ = self->priv->buffer;
						_tmp159_ = m;
						_tmp160_ = vala_symbol_get_name ((ValaSymbol*) _tmp159_);
						_tmp161_ = _tmp160_;
						g_string_append_printf (_tmp158_, "<field name=\"%s\">\n", _tmp161_);
						_tmp162_ = self->priv->indent;
						self->priv->indent = _tmp162_ + 1;
						_tmp163_ = m;
						_tmp164_ = m;
						_tmp165_ = vala_symbol_get_name ((ValaSymbol*) _tmp164_);
						_tmp166_ = _tmp165_;
						_tmp167_ = m;
						_tmp168_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = m;
						_tmp171_ = vala_method_get_async_begin_parameters (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = vala_void_type_new (NULL);
						_tmp174_ = _tmp173_;
						vala_gir_writer_do_write_signature (self, _tmp163_, "callback", TRUE, _tmp166_, _tmp169_, _tmp172_, (ValaDataType*) _tmp174_, FALSE, FALSE);
						_vala_code_node_unref0 (_tmp174_);
						_vala_iterable_unref0 (_tmp172_);
						_g_free0 (_tmp169_);
						_tmp175_ = self->priv->indent;
						self->priv->indent = _tmp175_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp176_ = self->priv->buffer;
						g_string_append_printf (_tmp176_, "</field>\n");
						vala_gir_writer_write_indent (self);
						_tmp177_ = self->priv->buffer;
						_tmp178_ = finish_name;
						g_string_append_printf (_tmp177_, "<field name=\"%s\">\n", _tmp178_);
						_tmp179_ = self->priv->indent;
						self->priv->indent = _tmp179_ + 1;
						_tmp180_ = m;
						_tmp181_ = finish_name;
						_tmp182_ = m;
						_tmp183_ = vala_ccode_base_module_get_ccode_finish_name (_tmp182_);
						_tmp184_ = _tmp183_;
						_tmp185_ = m;
						_tmp186_ = vala_method_get_async_end_parameters (_tmp185_);
						_tmp187_ = _tmp186_;
						_tmp188_ = m;
						_tmp189_ = vala_method_get_return_type (_tmp188_);
						_tmp190_ = _tmp189_;
						_tmp191_ = m;
						_tmp192_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp191_);
						_tmp193_ = _tmp192_;
						vala_gir_writer_do_write_signature (self, _tmp180_, "callback", TRUE, _tmp181_, _tmp184_, _tmp187_, _tmp190_, _tmp193_, FALSE);
						_vala_iterable_unref0 (_tmp187_);
						_g_free0 (_tmp184_);
						_tmp194_ = self->priv->indent;
						self->priv->indent = _tmp194_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp195_ = self->priv->buffer;
						g_string_append_printf (_tmp195_, "</field>\n");
						_g_free0 (finish_name);
					} else {
						GString* _tmp196_;
						ValaMethod* _tmp197_;
						const gchar* _tmp198_;
						const gchar* _tmp199_;
						gint _tmp200_;
						ValaMethod* _tmp201_;
						ValaMethod* _tmp202_;
						const gchar* _tmp203_;
						const gchar* _tmp204_;
						ValaMethod* _tmp205_;
						gchar* _tmp206_ = NULL;
						gchar* _tmp207_;
						ValaMethod* _tmp208_;
						ValaList* _tmp209_ = NULL;
						ValaList* _tmp210_;
						ValaMethod* _tmp211_;
						ValaDataType* _tmp212_;
						ValaDataType* _tmp213_;
						ValaMethod* _tmp214_;
						gboolean _tmp215_;
						gboolean _tmp216_;
						gint _tmp217_;
						GString* _tmp218_;
						vala_gir_writer_write_indent (self);
						_tmp196_ = self->priv->buffer;
						_tmp197_ = m;
						_tmp198_ = vala_symbol_get_name ((ValaSymbol*) _tmp197_);
						_tmp199_ = _tmp198_;
						g_string_append_printf (_tmp196_, "<field name=\"%s\">\n", _tmp199_);
						_tmp200_ = self->priv->indent;
						self->priv->indent = _tmp200_ + 1;
						_tmp201_ = m;
						_tmp202_ = m;
						_tmp203_ = vala_symbol_get_name ((ValaSymbol*) _tmp202_);
						_tmp204_ = _tmp203_;
						_tmp205_ = m;
						_tmp206_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp205_);
						_tmp207_ = _tmp206_;
						_tmp208_ = m;
						_tmp209_ = vala_method_get_parameters (_tmp208_);
						_tmp210_ = _tmp209_;
						_tmp211_ = m;
						_tmp212_ = vala_method_get_return_type (_tmp211_);
						_tmp213_ = _tmp212_;
						_tmp214_ = m;
						_tmp215_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp214_);
						_tmp216_ = _tmp215_;
						vala_gir_writer_do_write_signature (self, _tmp201_, "callback", TRUE, _tmp204_, _tmp207_, _tmp210_, _tmp213_, _tmp216_, FALSE);
						_vala_iterable_unref0 (_tmp210_);
						_g_free0 (_tmp207_);
						_tmp217_ = self->priv->indent;
						self->priv->indent = _tmp217_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp218_ = self->priv->buffer;
						g_string_append_printf (_tmp218_, "</field>\n");
					}
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaClass* _tmp219_;
			ValaList* _tmp220_ = NULL;
			ValaList* _sig_list;
			ValaList* _tmp221_;
			gint _tmp222_;
			gint _tmp223_;
			gint _sig_size;
			gint _sig_index;
			_tmp219_ = cl;
			_tmp220_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) _tmp219_);
			_sig_list = _tmp220_;
			_tmp221_ = _sig_list;
			_tmp222_ = vala_collection_get_size ((ValaCollection*) _tmp221_);
			_tmp223_ = _tmp222_;
			_sig_size = _tmp223_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp224_;
				gint _tmp225_;
				gint _tmp226_;
				ValaList* _tmp227_;
				gint _tmp228_;
				gpointer _tmp229_ = NULL;
				ValaSignal* sig;
				ValaSignal* _tmp230_;
				ValaMethod* _tmp231_;
				ValaMethod* _tmp232_;
				_tmp224_ = _sig_index;
				_sig_index = _tmp224_ + 1;
				_tmp225_ = _sig_index;
				_tmp226_ = _sig_size;
				if (!(_tmp225_ < _tmp226_)) {
					break;
				}
				_tmp227_ = _sig_list;
				_tmp228_ = _sig_index;
				_tmp229_ = vala_list_get (_tmp227_, _tmp228_);
				sig = (ValaSignal*) _tmp229_;
				_tmp230_ = sig;
				_tmp231_ = vala_signal_get_default_handler (_tmp230_);
				_tmp232_ = _tmp231_;
				if (_tmp232_ != NULL) {
					GString* _tmp233_;
					ValaSignal* _tmp234_;
					const gchar* _tmp235_;
					const gchar* _tmp236_;
					gint _tmp237_;
					ValaSignal* _tmp238_;
					ValaMethod* _tmp239_;
					ValaMethod* _tmp240_;
					gint _tmp241_;
					GString* _tmp242_;
					vala_gir_writer_write_indent (self);
					_tmp233_ = self->priv->buffer;
					_tmp234_ = sig;
					_tmp235_ = vala_symbol_get_name ((ValaSymbol*) _tmp234_);
					_tmp236_ = _tmp235_;
					g_string_append_printf (_tmp233_, "<field name=\"%s\">\n", _tmp236_);
					_tmp237_ = self->priv->indent;
					self->priv->indent = _tmp237_ + 1;
					_tmp238_ = sig;
					_tmp239_ = vala_signal_get_default_handler (_tmp238_);
					_tmp240_ = _tmp239_;
					vala_gir_writer_write_signature (self, _tmp240_, "callback", FALSE, TRUE);
					_tmp241_ = self->priv->indent;
					self->priv->indent = _tmp241_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp242_ = self->priv->buffer;
					g_string_append_printf (_tmp242_, "</field>\n");
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp243_ = self->priv->indent;
		self->priv->indent = _tmp243_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp244_ = self->priv->buffer;
		g_string_append_printf (_tmp244_, "</record>\n");
		vala_gir_writer_write_indent (self);
		_tmp245_ = self->priv->buffer;
		_tmp246_ = cl;
		_tmp247_ = vala_symbol_get_name ((ValaSymbol*) _tmp246_);
		_tmp248_ = _tmp247_;
		_tmp249_ = cl;
		_tmp250_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp249_);
		_tmp251_ = _tmp250_;
		g_string_append_printf (_tmp245_, "<record name=\"%sPrivate\" c:type=\"%sPrivate\" disguised=\"1\"/>\n", _tmp248_, _tmp251_);
		_g_free0 (_tmp251_);
		_g_free0 (gtype_struct_name);
	} else {
		GString* _tmp252_;
		ValaClass* _tmp253_;
		gchar* _tmp254_ = NULL;
		gchar* _tmp255_;
		ValaClass* _tmp256_;
		GString* _tmp257_;
		gint _tmp258_;
		ValaClass* _tmp259_;
		gchar* _tmp260_ = NULL;
		gchar* _tmp261_;
		ValaClass* _tmp262_;
		ValaArrayList* _tmp263_;
		ValaClass* _tmp264_;
		ValaClass* _tmp265_;
		ValaArrayList* _tmp266_;
		gint _tmp267_;
		GString* _tmp268_;
		vala_gir_writer_write_indent (self);
		_tmp252_ = self->priv->buffer;
		_tmp253_ = cl;
		_tmp254_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp253_);
		_tmp255_ = _tmp254_;
		g_string_append_printf (_tmp252_, "<record name=\"%s\"", _tmp255_);
		_g_free0 (_tmp255_);
		_tmp256_ = cl;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp256_);
		_tmp257_ = self->priv->buffer;
		g_string_append_printf (_tmp257_, ">\n");
		_tmp258_ = self->priv->indent;
		self->priv->indent = _tmp258_ + 1;
		_tmp259_ = cl;
		_tmp260_ = vala_gir_writer_get_class_comment (self, _tmp259_);
		_tmp261_ = _tmp260_;
		vala_gir_writer_write_doc (self, _tmp261_);
		_g_free0 (_tmp261_);
		_tmp262_ = cl;
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp262_);
		_tmp263_ = self->priv->hierarchy;
		_tmp264_ = cl;
		vala_list_insert ((ValaList*) _tmp263_, 0, (ValaSymbol*) _tmp264_);
		_tmp265_ = cl;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp265_, (ValaCodeVisitor*) self);
		_tmp266_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp266_, 0);
		_tmp267_ = self->priv->indent;
		self->priv->indent = _tmp267_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp268_ = self->priv->buffer;
		g_string_append_printf (_tmp268_, "</record>\n");
	}
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIRWriter * self;
	ValaStruct* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaStruct* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	GString* _tmp11_;
	ValaStruct* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	ValaStruct* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	ValaStruct* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	ValaStruct* _tmp21_;
	ValaArrayList* _tmp22_;
	ValaStruct* _tmp23_;
	ValaStruct* _tmp24_;
	ValaArrayList* _tmp25_;
	gint _tmp26_;
	GString* _tmp27_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = st;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaStruct* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = st;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = st;
	_tmp13_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	g_string_append_printf (_tmp11_, "<record name=\"%s\"", _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = st;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = st;
	_tmp19_ = vala_gir_writer_get_struct_comment (self, _tmp18_);
	_tmp20_ = _tmp19_;
	vala_gir_writer_write_doc (self, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = st;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp21_);
	_tmp22_ = self->priv->hierarchy;
	_tmp23_ = st;
	vala_list_insert ((ValaList*) _tmp22_, 0, (ValaSymbol*) _tmp23_);
	_tmp24_ = st;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp24_, (ValaCodeVisitor*) self);
	_tmp25_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp25_, 0);
	_tmp26_ = self->priv->indent;
	self->priv->indent = _tmp26_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp27_ = self->priv->buffer;
	g_string_append_printf (_tmp27_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIRWriter * self;
	ValaInterface* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaInterface* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	ValaInterface* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* gtype_struct_name;
	GString* _tmp15_;
	ValaInterface* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	ValaInterface* _tmp19_;
	GString* _tmp20_;
	const gchar* _tmp21_;
	ValaInterface* _tmp22_;
	GString* _tmp23_;
	gint _tmp24_;
	ValaInterface* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	ValaInterface* _tmp28_;
	ValaList* _tmp29_ = NULL;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_;
	ValaInterface* _tmp51_;
	ValaArrayList* _tmp52_;
	ValaInterface* _tmp53_;
	ValaInterface* _tmp54_;
	ValaArrayList* _tmp55_;
	gint _tmp56_;
	GString* _tmp57_;
	GString* _tmp58_;
	const gchar* _tmp59_;
	ValaInterface* _tmp60_;
	GString* _tmp61_;
	ValaInterface* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	GString* _tmp65_;
	gint _tmp66_;
	GString* _tmp67_;
	gint _tmp68_;
	GString* _tmp69_;
	gint _tmp70_;
	GString* _tmp71_;
	gint _tmp170_;
	GString* _tmp171_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = iface;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaInterface* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = iface;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp11_ = iface;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "Iface", NULL);
	gtype_struct_name = _tmp14_;
	vala_gir_writer_write_indent (self);
	_tmp15_ = self->priv->buffer;
	_tmp16_ = iface;
	_tmp17_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp16_);
	_tmp18_ = _tmp17_;
	g_string_append_printf (_tmp15_, "<interface name=\"%s\"", _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = iface;
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp19_);
	_tmp20_ = self->priv->buffer;
	_tmp21_ = gtype_struct_name;
	g_string_append_printf (_tmp20_, " glib:type-struct=\"%s\"", _tmp21_);
	_tmp22_ = iface;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp22_);
	_tmp23_ = self->priv->buffer;
	g_string_append_printf (_tmp23_, ">\n");
	_tmp24_ = self->priv->indent;
	self->priv->indent = _tmp24_ + 1;
	_tmp25_ = iface;
	_tmp26_ = vala_gir_writer_get_interface_comment (self, _tmp25_);
	_tmp27_ = _tmp26_;
	vala_gir_writer_write_doc (self, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = iface;
	_tmp29_ = vala_interface_get_prerequisites (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_ > 0;
	_vala_iterable_unref0 (_tmp30_);
	if (_tmp33_) {
		{
			ValaInterface* _tmp34_;
			ValaList* _tmp35_ = NULL;
			ValaList* _base_type_list;
			ValaList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp34_ = iface;
			_tmp35_ = vala_interface_get_prerequisites (_tmp34_);
			_base_type_list = _tmp35_;
			_tmp36_ = _base_type_list;
			_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_base_type_size = _tmp38_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				ValaList* _tmp42_;
				gint _tmp43_;
				gpointer _tmp44_ = NULL;
				ValaDataType* base_type;
				GString* _tmp45_;
				ValaDataType* _tmp46_;
				ValaObjectTypeSymbol* _tmp47_;
				ValaObjectTypeSymbol* _tmp48_;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				_tmp39_ = _base_type_index;
				_base_type_index = _tmp39_ + 1;
				_tmp40_ = _base_type_index;
				_tmp41_ = _base_type_size;
				if (!(_tmp40_ < _tmp41_)) {
					break;
				}
				_tmp42_ = _base_type_list;
				_tmp43_ = _base_type_index;
				_tmp44_ = vala_list_get (_tmp42_, _tmp43_);
				base_type = (ValaDataType*) _tmp44_;
				vala_gir_writer_write_indent (self);
				_tmp45_ = self->priv->buffer;
				_tmp46_ = base_type;
				_tmp47_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp48_);
				_tmp50_ = _tmp49_;
				g_string_append_printf (_tmp45_, "<prerequisite name=\"%s\"/>\n", _tmp50_);
				_g_free0 (_tmp50_);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	_tmp51_ = iface;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp51_);
	_tmp52_ = self->priv->hierarchy;
	_tmp53_ = iface;
	vala_list_insert ((ValaList*) _tmp52_, 0, (ValaSymbol*) _tmp53_);
	_tmp54_ = iface;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp54_, (ValaCodeVisitor*) self);
	_tmp55_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp55_, 0);
	_tmp56_ = self->priv->indent;
	self->priv->indent = _tmp56_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp57_ = self->priv->buffer;
	g_string_append_printf (_tmp57_, "</interface>\n");
	vala_gir_writer_write_indent (self);
	_tmp58_ = self->priv->buffer;
	_tmp59_ = gtype_struct_name;
	g_string_append_printf (_tmp58_, "<record name=\"%s\"", _tmp59_);
	_tmp60_ = iface;
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp60_, "Iface");
	_tmp61_ = self->priv->buffer;
	_tmp62_ = iface;
	_tmp63_ = vala_symbol_get_name ((ValaSymbol*) _tmp62_);
	_tmp64_ = _tmp63_;
	g_string_append_printf (_tmp61_, " glib:is-gtype-struct-for=\"%s\"", _tmp64_);
	_tmp65_ = self->priv->buffer;
	g_string_append_printf (_tmp65_, ">\n");
	_tmp66_ = self->priv->indent;
	self->priv->indent = _tmp66_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp67_ = self->priv->buffer;
	g_string_append_printf (_tmp67_, "<field name=\"parent_iface\">\n");
	_tmp68_ = self->priv->indent;
	self->priv->indent = _tmp68_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp69_ = self->priv->buffer;
	g_string_append_printf (_tmp69_, "<type name=\"GObject.TypeInterface\" c:type=\"GTypeInterface\"/>\n");
	_tmp70_ = self->priv->indent;
	self->priv->indent = _tmp70_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp71_ = self->priv->buffer;
	g_string_append_printf (_tmp71_, "</field>\n");
	{
		ValaInterface* _tmp72_;
		ValaList* _tmp73_ = NULL;
		ValaList* _m_list;
		ValaList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gint _m_size;
		gint _m_index;
		_tmp72_ = iface;
		_tmp73_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp72_);
		_m_list = _tmp73_;
		_tmp74_ = _m_list;
		_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
		_tmp76_ = _tmp75_;
		_m_size = _tmp76_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			ValaList* _tmp80_;
			gint _tmp81_;
			gpointer _tmp82_ = NULL;
			ValaMethod* m;
			gboolean _tmp83_ = FALSE;
			ValaMethod* _tmp84_;
			gboolean _tmp85_;
			gboolean _tmp86_;
			gboolean _tmp90_;
			_tmp77_ = _m_index;
			_m_index = _tmp77_ + 1;
			_tmp78_ = _m_index;
			_tmp79_ = _m_size;
			if (!(_tmp78_ < _tmp79_)) {
				break;
			}
			_tmp80_ = _m_list;
			_tmp81_ = _m_index;
			_tmp82_ = vala_list_get (_tmp80_, _tmp81_);
			m = (ValaMethod*) _tmp82_;
			_tmp84_ = m;
			_tmp85_ = vala_method_get_is_abstract (_tmp84_);
			_tmp86_ = _tmp85_;
			if (_tmp86_) {
				_tmp83_ = TRUE;
			} else {
				ValaMethod* _tmp87_;
				gboolean _tmp88_;
				gboolean _tmp89_;
				_tmp87_ = m;
				_tmp88_ = vala_method_get_is_virtual (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp83_ = _tmp89_;
			}
			_tmp90_ = _tmp83_;
			if (_tmp90_) {
				ValaMethod* _tmp91_;
				gboolean _tmp92_;
				gboolean _tmp93_;
				_tmp91_ = m;
				_tmp92_ = vala_method_get_coroutine (_tmp91_);
				_tmp93_ = _tmp92_;
				if (_tmp93_) {
					ValaMethod* _tmp94_;
					const gchar* _tmp95_;
					const gchar* _tmp96_;
					gchar* _tmp97_;
					gchar* finish_name;
					const gchar* _tmp98_;
					gboolean _tmp99_ = FALSE;
					const gchar* _tmp107_;
					gchar* _tmp108_;
					GString* _tmp109_;
					ValaMethod* _tmp110_;
					const gchar* _tmp111_;
					const gchar* _tmp112_;
					gint _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					const gchar* _tmp116_;
					const gchar* _tmp117_;
					ValaMethod* _tmp118_;
					gchar* _tmp119_ = NULL;
					gchar* _tmp120_;
					ValaMethod* _tmp121_;
					ValaList* _tmp122_ = NULL;
					ValaList* _tmp123_;
					ValaVoidType* _tmp124_;
					ValaVoidType* _tmp125_;
					gint _tmp126_;
					GString* _tmp127_;
					GString* _tmp128_;
					const gchar* _tmp129_;
					gint _tmp130_;
					ValaMethod* _tmp131_;
					const gchar* _tmp132_;
					ValaMethod* _tmp133_;
					gchar* _tmp134_ = NULL;
					gchar* _tmp135_;
					ValaMethod* _tmp136_;
					ValaList* _tmp137_ = NULL;
					ValaList* _tmp138_;
					ValaMethod* _tmp139_;
					ValaDataType* _tmp140_;
					ValaDataType* _tmp141_;
					ValaMethod* _tmp142_;
					gboolean _tmp143_;
					gboolean _tmp144_;
					gint _tmp145_;
					GString* _tmp146_;
					_tmp94_ = m;
					_tmp95_ = vala_symbol_get_name ((ValaSymbol*) _tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = g_strdup (_tmp96_);
					finish_name = _tmp97_;
					_tmp98_ = finish_name;
					_tmp99_ = g_str_has_suffix (_tmp98_, "_async");
					if (_tmp99_) {
						const gchar* _tmp100_;
						const gchar* _tmp101_;
						gint _tmp102_;
						gint _tmp103_;
						gint _tmp104_;
						gint _tmp105_;
						gchar* _tmp106_ = NULL;
						_tmp100_ = finish_name;
						_tmp101_ = finish_name;
						_tmp102_ = strlen (_tmp101_);
						_tmp103_ = _tmp102_;
						_tmp104_ = strlen ("_async");
						_tmp105_ = _tmp104_;
						_tmp106_ = string_substring (_tmp100_, (glong) 0, (glong) (_tmp103_ - _tmp105_));
						_g_free0 (finish_name);
						finish_name = _tmp106_;
					}
					_tmp107_ = finish_name;
					_tmp108_ = g_strconcat (_tmp107_, "_finish", NULL);
					_g_free0 (finish_name);
					finish_name = _tmp108_;
					vala_gir_writer_write_indent (self);
					_tmp109_ = self->priv->buffer;
					_tmp110_ = m;
					_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
					_tmp112_ = _tmp111_;
					g_string_append_printf (_tmp109_, "<field name=\"%s\">\n", _tmp112_);
					_tmp113_ = self->priv->indent;
					self->priv->indent = _tmp113_ + 1;
					_tmp114_ = m;
					_tmp115_ = m;
					_tmp116_ = vala_symbol_get_name ((ValaSymbol*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = m;
					_tmp119_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = m;
					_tmp122_ = vala_method_get_async_begin_parameters (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_void_type_new (NULL);
					_tmp125_ = _tmp124_;
					vala_gir_writer_do_write_signature (self, _tmp114_, "callback", TRUE, _tmp117_, _tmp120_, _tmp123_, (ValaDataType*) _tmp125_, FALSE, FALSE);
					_vala_code_node_unref0 (_tmp125_);
					_vala_iterable_unref0 (_tmp123_);
					_g_free0 (_tmp120_);
					_tmp126_ = self->priv->indent;
					self->priv->indent = _tmp126_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp127_ = self->priv->buffer;
					g_string_append_printf (_tmp127_, "</field>\n");
					vala_gir_writer_write_indent (self);
					_tmp128_ = self->priv->buffer;
					_tmp129_ = finish_name;
					g_string_append_printf (_tmp128_, "<field name=\"%s\">\n", _tmp129_);
					_tmp130_ = self->priv->indent;
					self->priv->indent = _tmp130_ + 1;
					_tmp131_ = m;
					_tmp132_ = finish_name;
					_tmp133_ = m;
					_tmp134_ = vala_ccode_base_module_get_ccode_finish_name (_tmp133_);
					_tmp135_ = _tmp134_;
					_tmp136_ = m;
					_tmp137_ = vala_method_get_async_end_parameters (_tmp136_);
					_tmp138_ = _tmp137_;
					_tmp139_ = m;
					_tmp140_ = vala_method_get_return_type (_tmp139_);
					_tmp141_ = _tmp140_;
					_tmp142_ = m;
					_tmp143_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp142_);
					_tmp144_ = _tmp143_;
					vala_gir_writer_do_write_signature (self, _tmp131_, "callback", TRUE, _tmp132_, _tmp135_, _tmp138_, _tmp141_, _tmp144_, FALSE);
					_vala_iterable_unref0 (_tmp138_);
					_g_free0 (_tmp135_);
					_tmp145_ = self->priv->indent;
					self->priv->indent = _tmp145_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp146_ = self->priv->buffer;
					g_string_append_printf (_tmp146_, "</field>\n");
					_g_free0 (finish_name);
				} else {
					GString* _tmp147_;
					ValaMethod* _tmp148_;
					const gchar* _tmp149_;
					const gchar* _tmp150_;
					gint _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					const gchar* _tmp154_;
					const gchar* _tmp155_;
					ValaMethod* _tmp156_;
					gchar* _tmp157_ = NULL;
					gchar* _tmp158_;
					ValaMethod* _tmp159_;
					ValaList* _tmp160_ = NULL;
					ValaList* _tmp161_;
					ValaMethod* _tmp162_;
					ValaDataType* _tmp163_;
					ValaDataType* _tmp164_;
					ValaMethod* _tmp165_;
					gboolean _tmp166_;
					gboolean _tmp167_;
					gint _tmp168_;
					GString* _tmp169_;
					vala_gir_writer_write_indent (self);
					_tmp147_ = self->priv->buffer;
					_tmp148_ = m;
					_tmp149_ = vala_symbol_get_name ((ValaSymbol*) _tmp148_);
					_tmp150_ = _tmp149_;
					g_string_append_printf (_tmp147_, "<field name=\"%s\">\n", _tmp150_);
					_tmp151_ = self->priv->indent;
					self->priv->indent = _tmp151_ + 1;
					_tmp152_ = m;
					_tmp153_ = m;
					_tmp154_ = vala_symbol_get_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = m;
					_tmp157_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp156_);
					_tmp158_ = _tmp157_;
					_tmp159_ = m;
					_tmp160_ = vala_method_get_parameters (_tmp159_);
					_tmp161_ = _tmp160_;
					_tmp162_ = m;
					_tmp163_ = vala_method_get_return_type (_tmp162_);
					_tmp164_ = _tmp163_;
					_tmp165_ = m;
					_tmp166_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp165_);
					_tmp167_ = _tmp166_;
					vala_gir_writer_do_write_signature (self, _tmp152_, "callback", TRUE, _tmp155_, _tmp158_, _tmp161_, _tmp164_, _tmp167_, FALSE);
					_vala_iterable_unref0 (_tmp161_);
					_g_free0 (_tmp158_);
					_tmp168_ = self->priv->indent;
					self->priv->indent = _tmp168_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp169_ = self->priv->buffer;
					g_string_append_printf (_tmp169_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp170_ = self->priv->indent;
	self->priv->indent = _tmp170_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp171_ = self->priv->buffer;
	g_string_append_printf (_tmp171_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
	_g_free0 (gtype_struct_name);
}


static void vala_gir_writer_visit_deferred (ValaGIRWriter* self) {
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* nodes;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deferred;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	nodes = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp2_);
	_vala_iterable_unref0 (self->priv->deferred);
	self->priv->deferred = _tmp3_;
	{
		ValaArrayList* _tmp4_;
		ValaArrayList* _tmp5_;
		ValaArrayList* _node_list;
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _node_size;
		gint _node_index;
		_tmp4_ = nodes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_node_list = _tmp5_;
		_tmp6_ = _node_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_node_size = _tmp8_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			ValaCodeNode* node;
			ValaCodeNode* _tmp15_;
			_tmp9_ = _node_index;
			_node_index = _tmp9_ + 1;
			_tmp10_ = _node_index;
			_tmp11_ = _node_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _node_list;
			_tmp13_ = _node_index;
			_tmp14_ = vala_list_get ((ValaList*) _tmp12_, _tmp13_);
			node = (ValaCodeNode*) _tmp14_;
			_tmp15_ = node;
			vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_iterable_unref0 (nodes);
}


static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol) {
	gchar* result = NULL;
	gchar* gir_name;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	ValaSymbol* h0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	gir_name = NULL;
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	h0 = (ValaSymbol*) _tmp1_;
	{
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* cur_sym;
		_tmp2_ = symbol;
		_tmp3_ = _vala_code_node_ref0 (_tmp2_);
		cur_sym = _tmp3_;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				ValaSymbol* _tmp12_;
				ValaSymbol* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* cur_name;
				const gchar* _tmp15_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					ValaSymbol* _tmp6_;
					ValaSymbol* _tmp7_;
					ValaSymbol* _tmp8_;
					ValaSymbol* _tmp9_;
					_tmp6_ = cur_sym;
					_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = _vala_code_node_ref0 (_tmp8_);
					_vala_code_node_unref0 (cur_sym);
					cur_sym = _tmp9_;
				}
				_tmp4_ = FALSE;
				_tmp10_ = cur_sym;
				if (!(_tmp10_ != NULL)) {
					break;
				}
				_tmp11_ = cur_sym;
				_tmp12_ = h0;
				if (_tmp11_ == _tmp12_) {
					break;
				}
				_tmp13_ = cur_sym;
				_tmp14_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp13_, "GIR", "name");
				cur_name = _tmp14_;
				_tmp15_ = cur_name;
				if (_tmp15_ == NULL) {
					ValaSymbol* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp16_ = cur_sym;
					_tmp17_ = vala_symbol_get_name (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (cur_name);
					cur_name = _tmp19_;
				}
				_tmp20_ = cur_name;
				_tmp21_ = gir_name;
				_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
				_g_free0 (gir_name);
				gir_name = _tmp22_;
				_g_free0 (cur_name);
			}
		}
		_vala_code_node_unref0 (cur_sym);
	}
	result = gir_name;
	_vala_code_node_unref0 (h0);
	return result;
}


static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIRWriter * self;
	ValaEnum* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaEnum* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp11_ = NULL;
	ValaEnum* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* element_name;
	GString* _tmp17_;
	const gchar* _tmp18_;
	ValaEnum* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	ValaEnum* _tmp22_;
	ValaEnum* _tmp23_;
	GString* _tmp24_;
	gint _tmp25_;
	ValaEnum* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	ValaEnum* _tmp29_;
	ValaArrayList* _tmp30_;
	ValaEnum* _tmp31_;
	ValaEnum* _tmp32_;
	ValaArrayList* _tmp33_;
	gint _tmp34_;
	GString* _tmp35_;
	const gchar* _tmp36_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = en;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_NAMESPACE);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaEnum* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = en;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp12_ = en;
	_tmp13_ = vala_enum_get_is_flags (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		_tmp11_ = "bitfield";
	} else {
		_tmp11_ = "enumeration";
	}
	_tmp15_ = _tmp11_;
	_tmp16_ = g_strdup (_tmp15_);
	element_name = _tmp16_;
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	_tmp18_ = element_name;
	_tmp19_ = en;
	_tmp20_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp19_);
	_tmp21_ = _tmp20_;
	g_string_append_printf (_tmp17_, "<%s name=\"%s\"", _tmp18_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = en;
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp22_);
	_tmp23_ = en;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp23_);
	_tmp24_ = self->priv->buffer;
	g_string_append_printf (_tmp24_, ">\n");
	_tmp25_ = self->priv->indent;
	self->priv->indent = _tmp25_ + 1;
	_tmp26_ = en;
	_tmp27_ = vala_gir_writer_get_enum_comment (self, _tmp26_);
	_tmp28_ = _tmp27_;
	vala_gir_writer_write_doc (self, _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = en;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp29_);
	self->priv->enum_value = 0;
	_tmp30_ = self->priv->hierarchy;
	_tmp31_ = en;
	vala_list_insert ((ValaList*) _tmp30_, 0, (ValaSymbol*) _tmp31_);
	_tmp32_ = en;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp32_, (ValaCodeVisitor*) self);
	_tmp33_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp33_, 0);
	_tmp34_ = self->priv->indent;
	self->priv->indent = _tmp34_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp35_ = self->priv->buffer;
	_tmp36_ = element_name;
	g_string_append_printf (_tmp35_, "</%s>\n", _tmp36_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (element_name);
}


static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaGIRWriter * self;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	ValaEnum* en;
	GString* _tmp2_;
	ValaEnumValue* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	ValaEnumValue* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	ValaEnumValue* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaEnumValue* _tmp27_;
	ValaEnumValue* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* comment;
	const gchar* _tmp30_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ev != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	en = G_TYPE_CHECK_INSTANCE_CAST ((ValaSymbol*) _tmp1_, VALA_TYPE_ENUM, ValaEnum);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = ev;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) (-1));
	_tmp7_ = _tmp6_;
	_tmp8_ = ev;
	_tmp9_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp8_);
	_tmp10_ = _tmp9_;
	g_string_append_printf (_tmp2_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	_tmp11_ = ev;
	_tmp12_ = vala_constant_get_value ((ValaConstant*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaEnumValue* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* value;
		GString* _tmp18_;
		const gchar* _tmp19_;
		_tmp14_ = ev;
		_tmp15_ = vala_constant_get_value ((ValaConstant*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp16_);
		value = _tmp17_;
		_tmp18_ = self->priv->buffer;
		_tmp19_ = value;
		g_string_append_printf (_tmp18_, " value=\"%s\"", _tmp19_);
		_g_free0 (value);
	} else {
		ValaEnum* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = en;
		_tmp21_ = vala_enum_get_is_flags (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			GString* _tmp23_;
			gint _tmp24_;
			_tmp23_ = self->priv->buffer;
			_tmp24_ = self->priv->enum_value;
			self->priv->enum_value = _tmp24_ + 1;
			g_string_append_printf (_tmp23_, " value=\"%d\"", 1 << _tmp24_);
		} else {
			GString* _tmp25_;
			gint _tmp26_;
			_tmp25_ = self->priv->buffer;
			_tmp26_ = self->priv->enum_value;
			self->priv->enum_value = _tmp26_ + 1;
			g_string_append_printf (_tmp25_, " value=\"%d\"", _tmp26_);
		}
	}
	_tmp27_ = ev;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp27_);
	_tmp28_ = ev;
	_tmp29_ = vala_gir_writer_get_enum_value_comment (self, _tmp28_);
	comment = _tmp29_;
	_tmp30_ = comment;
	if (_tmp30_ == NULL) {
		GString* _tmp31_;
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, "/>\n");
	} else {
		GString* _tmp32_;
		gint _tmp33_;
		const gchar* _tmp34_;
		gint _tmp35_;
		GString* _tmp36_;
		_tmp32_ = self->priv->buffer;
		g_string_append_printf (_tmp32_, ">\n");
		_tmp33_ = self->priv->indent;
		self->priv->indent = _tmp33_ + 1;
		_tmp34_ = comment;
		vala_gir_writer_write_doc (self, _tmp34_);
		_tmp35_ = self->priv->indent;
		self->priv->indent = _tmp35_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp36_ = self->priv->buffer;
		g_string_append_printf (_tmp36_, "</member>\n");
	}
	_g_free0 (comment);
	_vala_code_node_unref0 (en);
}


static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaGIRWriter * self;
	ValaErrorDomain* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaErrorDomain* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GString* _tmp5_;
	ValaErrorDomain* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	ValaErrorDomain* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	GString* _tmp13_;
	ValaErrorDomain* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaErrorDomain* _tmp17_;
	GString* _tmp18_;
	ValaErrorDomain* _tmp19_;
	GString* _tmp20_;
	GString* _tmp21_;
	ValaErrorDomain* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	ValaErrorDomain* _tmp25_;
	GString* _tmp26_;
	gint _tmp27_;
	ValaErrorDomain* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	ValaArrayList* _tmp31_;
	ValaErrorDomain* _tmp32_;
	ValaErrorDomain* _tmp33_;
	ValaArrayList* _tmp34_;
	gint _tmp35_;
	GString* _tmp36_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = edomain;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = edomain;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = edomain;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<errordomain name=\"%s\"", _tmp8_);
	_tmp9_ = self->priv->buffer;
	_tmp10_ = edomain;
	_tmp11_ = vala_ccode_base_module_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_string_append_printf (_tmp9_, " get-quark=\"%squark\"", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->buffer;
	_tmp14_ = edomain;
	_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	g_string_append_printf (_tmp13_, " codes=\"%s\"", _tmp16_);
	_tmp17_ = edomain;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp17_);
	_tmp18_ = self->priv->buffer;
	g_string_append_printf (_tmp18_, ">\n");
	_tmp19_ = edomain;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp19_);
	_tmp20_ = self->priv->buffer;
	g_string_append_printf (_tmp20_, "</errordomain>\n");
	vala_gir_writer_write_indent (self);
	_tmp21_ = self->priv->buffer;
	_tmp22_ = edomain;
	_tmp23_ = vala_symbol_get_name ((ValaSymbol*) _tmp22_);
	_tmp24_ = _tmp23_;
	g_string_append_printf (_tmp21_, "<enumeration name=\"%s\"", _tmp24_);
	_tmp25_ = edomain;
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp25_, "");
	_tmp26_ = self->priv->buffer;
	g_string_append_printf (_tmp26_, ">\n");
	_tmp27_ = self->priv->indent;
	self->priv->indent = _tmp27_ + 1;
	_tmp28_ = edomain;
	_tmp29_ = vala_gir_writer_get_error_domain_comment (self, _tmp28_);
	_tmp30_ = _tmp29_;
	vala_gir_writer_write_doc (self, _tmp30_);
	_g_free0 (_tmp30_);
	self->priv->enum_value = 0;
	_tmp31_ = self->priv->hierarchy;
	_tmp32_ = edomain;
	vala_list_insert ((ValaList*) _tmp31_, 0, (ValaSymbol*) _tmp32_);
	_tmp33_ = edomain;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp33_, (ValaCodeVisitor*) self);
	_tmp34_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp34_, 0);
	_tmp35_ = self->priv->indent;
	self->priv->indent = _tmp35_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp36_ = self->priv->buffer;
	g_string_append_printf (_tmp36_, "</enumeration>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaGIRWriter * self;
	GString* _tmp0_;
	ValaErrorCode* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	ValaErrorCode* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	ValaErrorCode* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaErrorCode* _tmp20_;
	ValaErrorCode* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* comment;
	const gchar* _tmp23_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ecode != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = ecode;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) (-1));
	_tmp5_ = _tmp4_;
	_tmp6_ = ecode;
	_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp0_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_tmp9_ = ecode;
	_tmp10_ = vala_error_code_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaErrorCode* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* value;
		GString* _tmp16_;
		const gchar* _tmp17_;
		_tmp12_ = ecode;
		_tmp13_ = vala_error_code_get_value (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp14_);
		value = _tmp15_;
		_tmp16_ = self->priv->buffer;
		_tmp17_ = value;
		g_string_append_printf (_tmp16_, " value=\"%s\"", _tmp17_);
		_g_free0 (value);
	} else {
		GString* _tmp18_;
		gint _tmp19_;
		_tmp18_ = self->priv->buffer;
		_tmp19_ = self->priv->enum_value;
		self->priv->enum_value = _tmp19_ + 1;
		g_string_append_printf (_tmp18_, " value=\"%d\"", _tmp19_);
	}
	_tmp20_ = ecode;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp20_);
	_tmp21_ = ecode;
	_tmp22_ = vala_gir_writer_get_error_code_comment (self, _tmp21_);
	comment = _tmp22_;
	_tmp23_ = comment;
	if (_tmp23_ == NULL) {
		GString* _tmp24_;
		_tmp24_ = self->priv->buffer;
		g_string_append_printf (_tmp24_, "/>\n");
	} else {
		GString* _tmp25_;
		gint _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		GString* _tmp29_;
		_tmp25_ = self->priv->buffer;
		g_string_append_printf (_tmp25_, ">\n");
		_tmp26_ = self->priv->indent;
		self->priv->indent = _tmp26_ + 1;
		_tmp27_ = comment;
		vala_gir_writer_write_doc (self, _tmp27_);
		_tmp28_ = self->priv->indent;
		self->priv->indent = _tmp28_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp29_ = self->priv->buffer;
		g_string_append_printf (_tmp29_, "</member>\n");
	}
	_g_free0 (comment);
}


static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaGIRWriter * self;
	ValaConstant* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaConstant* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaConstant* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* initializer;
	ValaExpression* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* value;
	GString* _tmp11_;
	ValaConstant* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaConstant* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	ValaConstant* _tmp20_;
	GString* _tmp21_;
	gint _tmp22_;
	ValaConstant* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	ValaExpression* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gint _tmp29_;
	GString* _tmp30_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = c;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = c;
	_tmp6_ = vala_constant_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	initializer = _tmp8_;
	_tmp9_ = initializer;
	_tmp10_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp9_);
	value = _tmp10_;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = c;
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = c;
	_tmp16_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp15_);
	_tmp17_ = _tmp16_;
	g_string_append_printf (_tmp11_, "<constant name=\"%s\" c:identifier=\"%s\"", _tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->buffer;
	_tmp19_ = value;
	g_string_append_printf (_tmp18_, " value=\"%s\"", _tmp19_);
	_tmp20_ = c;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp20_);
	_tmp21_ = self->priv->buffer;
	g_string_append_printf (_tmp21_, ">\n");
	_tmp22_ = self->priv->indent;
	self->priv->indent = _tmp22_ + 1;
	_tmp23_ = c;
	_tmp24_ = vala_gir_writer_get_constant_comment (self, _tmp23_);
	_tmp25_ = _tmp24_;
	vala_gir_writer_write_doc (self, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = initializer;
	_tmp27_ = vala_expression_get_value_type (_tmp26_);
	_tmp28_ = _tmp27_;
	vala_gir_writer_write_type (self, _tmp28_, -1);
	_tmp29_ = self->priv->indent;
	self->priv->indent = _tmp29_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp30_ = self->priv->buffer;
	g_string_append_printf (_tmp30_, "</constant>\n");
	_g_free0 (value);
	_vala_code_node_unref0 (initializer);
}


static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaGIRWriter * self;
	ValaField* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaField* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GString* _tmp5_;
	ValaField* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	ValaField* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	ValaField* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	ValaField* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	ValaField* _tmp21_;
	ValaField* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	gint _tmp25_;
	GString* _tmp26_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = f;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = f;
	_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<field name=\"%s\"", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = f;
	_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_data_type_get_nullable (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		GString* _tmp14_;
		_tmp14_ = self->priv->buffer;
		g_string_append_printf (_tmp14_, " allow-none=\"1\"");
	}
	_tmp15_ = f;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = f;
	_tmp19_ = vala_gir_writer_get_field_comment (self, _tmp18_);
	_tmp20_ = _tmp19_;
	vala_gir_writer_write_doc (self, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = f;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp21_);
	_tmp22_ = f;
	_tmp23_ = vala_variable_get_variable_type ((ValaVariable*) _tmp22_);
	_tmp24_ = _tmp23_;
	vala_gir_writer_write_type (self, _tmp24_, -1);
	_tmp25_ = self->priv->indent;
	self->priv->indent = _tmp25_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp26_ = self->priv->buffer;
	g_string_append_printf (_tmp26_, "</field>\n");
}


static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction) {
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE)) {
		gboolean _tmp2_;
		_tmp2_ = has_array_length;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		ValaCodeContext* _tmp4_ = NULL;
		ValaCodeContext* _tmp5_;
		ValaNamespace* _tmp6_;
		ValaNamespace* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaSymbol* _tmp10_ = NULL;
		ValaStruct* _tmp11_;
		ValaIntegerType* _tmp12_;
		ValaIntegerType* _tmp13_;
		ValaIntegerType* int_type;
		ValaIntegerType* _tmp14_;
		gboolean _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		ValaParameterDirection _tmp19_;
		_tmp4_ = vala_code_context_get ();
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_code_context_get_root (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_scope_lookup (_tmp9_, "int");
		_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp10_) : NULL;
		_tmp12_ = vala_integer_type_new (_tmp11_, NULL, NULL);
		_tmp13_ = _tmp12_;
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_context_unref0 (_tmp5_);
		int_type = _tmp13_;
		_tmp14_ = int_type;
		_tmp15_ = has_array_length;
		_tmp16_ = name;
		_tmp17_ = g_strdup_printf ("%s_length1", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = direction;
		vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp14_, TRUE, index, _tmp15_, _tmp18_, NULL, _tmp19_, FALSE, FALSE);
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (int_type);
	} else {
		ValaDataType* _tmp20_;
		_tmp20_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_DELEGATE_TYPE)) {
			ValaVoidType* _tmp21_;
			ValaVoidType* _tmp22_;
			ValaPointerType* _tmp23_;
			ValaPointerType* _tmp24_;
			ValaPointerType* data_type;
			ValaPointerType* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			ValaParameterDirection _tmp29_;
			ValaDataType* _tmp30_;
			gboolean _tmp31_;
			gboolean _tmp32_;
			_tmp21_ = vala_void_type_new (NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_pointer_type_new ((ValaDataType*) _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_vala_code_node_unref0 (_tmp22_);
			data_type = _tmp24_;
			_tmp25_ = data_type;
			_tmp26_ = name;
			_tmp27_ = g_strdup_printf ("%s_target", _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = direction;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp25_, TRUE, index, FALSE, _tmp28_, NULL, _tmp29_, FALSE, FALSE);
			_g_free0 (_tmp28_);
			_tmp30_ = type;
			_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_) {
				ValaCodeContext* _tmp33_ = NULL;
				ValaCodeContext* _tmp34_;
				ValaNamespace* _tmp35_;
				ValaNamespace* _tmp36_;
				ValaScope* _tmp37_;
				ValaScope* _tmp38_;
				ValaSymbol* _tmp39_ = NULL;
				ValaSymbol* _tmp40_;
				ValaScope* _tmp41_;
				ValaScope* _tmp42_;
				ValaSymbol* _tmp43_ = NULL;
				ValaDelegate* _tmp44_;
				ValaDelegateType* _tmp45_;
				ValaDelegateType* _tmp46_;
				ValaDelegateType* notify_type;
				ValaDelegateType* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				ValaParameterDirection _tmp51_;
				_tmp33_ = vala_code_context_get ();
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_code_context_get_root (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_scope ((ValaSymbol*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_scope_lookup (_tmp38_, "GLib");
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_scope (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = vala_scope_lookup (_tmp42_, "DestroyNotify");
				_tmp44_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_DELEGATE) ? ((ValaDelegate*) _tmp43_) : NULL;
				_tmp45_ = vala_delegate_type_new (_tmp44_);
				_tmp46_ = _tmp45_;
				_vala_code_node_unref0 (_tmp44_);
				_vala_code_node_unref0 (_tmp40_);
				_vala_code_context_unref0 (_tmp34_);
				notify_type = _tmp46_;
				_tmp47_ = notify_type;
				_tmp48_ = name;
				_tmp49_ = g_strdup_printf ("%s_target_destroy_notify", _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = direction;
				vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp47_, TRUE, index, FALSE, _tmp50_, NULL, _tmp51_, FALSE, FALSE);
				_g_free0 (_tmp50_);
				_vala_code_node_unref0 (notify_type);
			}
			_vala_code_node_unref0 (data_type);
		}
	}
}


static void vala_gir_writer_skip_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length) {
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp1_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_ARRAY_TYPE)) {
		gboolean _tmp2_;
		_tmp2_ = has_array_length;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gint _tmp4_;
		_tmp4_ = *index;
		*index = _tmp4_ + 1;
	} else {
		ValaDataType* _tmp5_;
		_tmp5_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE)) {
			gint _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp6_ = *index;
			*index = _tmp6_ + 1;
			_tmp7_ = type;
			_tmp8_ = vala_data_type_get_value_owned (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				gint _tmp10_;
				_tmp10_ = *index;
				*index = _tmp10_ + 1;
			}
		}
	}
}


static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, const gchar* return_comment, gboolean constructor, ValaDataType* instance_type, gboolean user_data) {
	gint last_index;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	gboolean _tmp4_;
	gboolean ret_is_struct;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ValaList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	gboolean _tmp20_;
	gboolean _tmp22_;
	gboolean _tmp47_ = FALSE;
	ValaDataType* _tmp48_;
	gboolean _tmp50_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	ValaList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gboolean _tmp67_;
	gboolean _tmp72_;
	gboolean _tmp74_;
	gboolean _tmp76_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	last_index = 0;
	_tmp1_ = return_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = return_type;
		_tmp3_ = vala_data_type_is_real_non_null_struct_type (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	ret_is_struct = _tmp4_;
	_tmp9_ = params;
	_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != 0) {
		_tmp8_ = TRUE;
	} else {
		ValaDataType* _tmp12_;
		_tmp12_ = instance_type;
		_tmp8_ = _tmp12_ != NULL;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		ValaDataType* _tmp15_;
		gboolean _tmp17_;
		_tmp15_ = return_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_ARRAY_TYPE)) {
			gboolean _tmp16_;
			_tmp16_ = return_array_length;
			_tmp14_ = _tmp16_;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp17_ = _tmp14_;
		_tmp7_ = _tmp17_;
	}
	_tmp18_ = _tmp7_;
	if (_tmp18_) {
		_tmp6_ = TRUE;
	} else {
		ValaDataType* _tmp19_;
		_tmp19_ = return_type;
		_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_DELEGATE_TYPE);
	}
	_tmp20_ = _tmp6_;
	if (_tmp20_) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp21_;
		_tmp21_ = ret_is_struct;
		_tmp5_ = _tmp21_;
	}
	_tmp22_ = _tmp5_;
	if (_tmp22_) {
		gint index;
		ValaDataType* _tmp23_;
		gboolean _tmp42_;
		gint _tmp46_;
		index = 0;
		_tmp23_ = instance_type;
		if (_tmp23_ != NULL) {
			gint _tmp24_;
			_tmp24_ = index;
			index = _tmp24_ + 1;
		}
		{
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			ValaList* _param_list;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _param_size;
			gint _param_index;
			_tmp25_ = params;
			_tmp26_ = _vala_iterable_ref0 (_tmp25_);
			_param_list = _tmp26_;
			_tmp27_ = _param_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_param_size = _tmp29_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				ValaList* _tmp33_;
				gint _tmp34_;
				gpointer _tmp35_ = NULL;
				ValaParameter* param;
				gint _tmp36_;
				ValaParameter* _tmp37_;
				ValaDataType* _tmp38_;
				ValaDataType* _tmp39_;
				ValaParameter* _tmp40_;
				gboolean _tmp41_ = FALSE;
				_tmp30_ = _param_index;
				_param_index = _tmp30_ + 1;
				_tmp31_ = _param_index;
				_tmp32_ = _param_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _param_list;
				_tmp34_ = _param_index;
				_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
				param = (ValaParameter*) _tmp35_;
				_tmp36_ = index;
				index = _tmp36_ + 1;
				_tmp37_ = param;
				_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = param;
				_tmp41_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp40_);
				vala_gir_writer_skip_implicit_params (self, _tmp39_, &index, _tmp41_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp42_ = ret_is_struct;
		if (_tmp42_) {
			gint _tmp43_;
			_tmp43_ = index;
			index = _tmp43_ + 1;
		} else {
			ValaDataType* _tmp44_;
			gboolean _tmp45_;
			_tmp44_ = return_type;
			_tmp45_ = return_array_length;
			vala_gir_writer_skip_implicit_params (self, _tmp44_, &index, _tmp45_);
		}
		_tmp46_ = index;
		last_index = _tmp46_ - 1;
	}
	_tmp48_ = return_type;
	if (_tmp48_ != NULL) {
		gboolean _tmp49_;
		_tmp49_ = ret_is_struct;
		_tmp47_ = !_tmp49_;
	} else {
		_tmp47_ = FALSE;
	}
	_tmp50_ = _tmp47_;
	if (_tmp50_) {
		ValaDataType* _tmp51_;
		gboolean _tmp52_;
		const gchar* _tmp53_;
		gboolean _tmp54_;
		_tmp51_ = return_type;
		_tmp52_ = return_array_length;
		_tmp53_ = return_comment;
		_tmp54_ = constructor;
		vala_gir_writer_write_param_or_return (self, _tmp51_, FALSE, &last_index, _tmp52_, NULL, _tmp53_, VALA_PARAMETER_DIRECTION_IN, _tmp54_, FALSE);
	} else {
		gboolean _tmp55_;
		_tmp55_ = ret_is_struct;
		if (_tmp55_) {
			ValaVoidType* _tmp56_;
			ValaVoidType* _tmp57_;
			const gchar* _tmp58_;
			_tmp56_ = vala_void_type_new (NULL);
			_tmp57_ = _tmp56_;
			_tmp58_ = return_comment;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp57_, FALSE, &last_index, FALSE, NULL, _tmp58_, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE);
			_vala_code_node_unref0 (_tmp57_);
		}
	}
	_tmp63_ = params;
	_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
	_tmp65_ = _tmp64_;
	if (_tmp65_ != 0) {
		_tmp62_ = TRUE;
	} else {
		ValaDataType* _tmp66_;
		_tmp66_ = instance_type;
		_tmp62_ = _tmp66_ != NULL;
	}
	_tmp67_ = _tmp62_;
	if (_tmp67_) {
		_tmp61_ = TRUE;
	} else {
		gboolean _tmp68_ = FALSE;
		ValaDataType* _tmp69_;
		gboolean _tmp71_;
		_tmp69_ = return_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALA_TYPE_ARRAY_TYPE)) {
			gboolean _tmp70_;
			_tmp70_ = return_array_length;
			_tmp68_ = _tmp70_;
		} else {
			_tmp68_ = FALSE;
		}
		_tmp71_ = _tmp68_;
		_tmp61_ = _tmp71_;
	}
	_tmp72_ = _tmp61_;
	if (_tmp72_) {
		_tmp60_ = TRUE;
	} else {
		ValaDataType* _tmp73_;
		_tmp73_ = return_type;
		_tmp60_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, VALA_TYPE_DELEGATE_TYPE);
	}
	_tmp74_ = _tmp60_;
	if (_tmp74_) {
		_tmp59_ = TRUE;
	} else {
		gboolean _tmp75_;
		_tmp75_ = ret_is_struct;
		_tmp59_ = _tmp75_;
	}
	_tmp76_ = _tmp59_;
	if (_tmp76_) {
		GString* _tmp77_;
		gint _tmp78_;
		gint index;
		ValaDataType* _tmp79_;
		gboolean _tmp117_;
		gboolean _tmp123_;
		gint _tmp130_;
		GString* _tmp131_;
		vala_gir_writer_write_indent (self);
		_tmp77_ = self->priv->buffer;
		g_string_append_printf (_tmp77_, "<parameters>\n");
		_tmp78_ = self->priv->indent;
		self->priv->indent = _tmp78_ + 1;
		index = 0;
		_tmp79_ = instance_type;
		if (_tmp79_ != NULL) {
			ValaDataType* _tmp80_;
			_tmp80_ = instance_type;
			vala_gir_writer_write_param_or_return (self, _tmp80_, TRUE, &index, FALSE, "self", NULL, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE);
		}
		{
			ValaList* _tmp81_;
			ValaList* _tmp82_;
			ValaList* _param_list;
			ValaList* _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			gint _param_size;
			gint _param_index;
			_tmp81_ = params;
			_tmp82_ = _vala_iterable_ref0 (_tmp81_);
			_param_list = _tmp82_;
			_tmp83_ = _param_list;
			_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
			_tmp85_ = _tmp84_;
			_param_size = _tmp85_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp86_;
				gint _tmp87_;
				gint _tmp88_;
				ValaList* _tmp89_;
				gint _tmp90_;
				gpointer _tmp91_ = NULL;
				ValaParameter* param;
				ValaParameter* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaParameter* _tmp95_;
				gboolean _tmp96_ = FALSE;
				ValaParameter* _tmp97_;
				const gchar* _tmp98_;
				const gchar* _tmp99_;
				ValaParameter* _tmp100_;
				gchar* _tmp101_ = NULL;
				gchar* _tmp102_;
				ValaParameter* _tmp103_;
				ValaParameterDirection _tmp104_;
				ValaParameterDirection _tmp105_;
				ValaParameter* _tmp106_;
				ValaDataType* _tmp107_;
				ValaDataType* _tmp108_;
				ValaParameter* _tmp109_;
				gboolean _tmp110_ = FALSE;
				ValaParameter* _tmp111_;
				const gchar* _tmp112_;
				const gchar* _tmp113_;
				ValaParameter* _tmp114_;
				ValaParameterDirection _tmp115_;
				ValaParameterDirection _tmp116_;
				_tmp86_ = _param_index;
				_param_index = _tmp86_ + 1;
				_tmp87_ = _param_index;
				_tmp88_ = _param_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _param_list;
				_tmp90_ = _param_index;
				_tmp91_ = vala_list_get (_tmp89_, _tmp90_);
				param = (ValaParameter*) _tmp91_;
				_tmp92_ = param;
				_tmp93_ = vala_variable_get_variable_type ((ValaVariable*) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = param;
				_tmp96_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp95_);
				_tmp97_ = param;
				_tmp98_ = vala_symbol_get_name ((ValaSymbol*) _tmp97_);
				_tmp99_ = _tmp98_;
				_tmp100_ = param;
				_tmp101_ = vala_gir_writer_get_parameter_comment (self, _tmp100_);
				_tmp102_ = _tmp101_;
				_tmp103_ = param;
				_tmp104_ = vala_parameter_get_direction (_tmp103_);
				_tmp105_ = _tmp104_;
				vala_gir_writer_write_param_or_return (self, _tmp94_, TRUE, &index, _tmp96_, _tmp99_, _tmp102_, _tmp105_, FALSE, FALSE);
				_g_free0 (_tmp102_);
				_tmp106_ = param;
				_tmp107_ = vala_variable_get_variable_type ((ValaVariable*) _tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = param;
				_tmp110_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp109_);
				_tmp111_ = param;
				_tmp112_ = vala_symbol_get_name ((ValaSymbol*) _tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = param;
				_tmp115_ = vala_parameter_get_direction (_tmp114_);
				_tmp116_ = _tmp115_;
				vala_gir_writer_write_implicit_params (self, _tmp108_, &index, _tmp110_, _tmp113_, _tmp116_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp117_ = ret_is_struct;
		if (_tmp117_) {
			ValaDataType* _tmp118_;
			const gchar* _tmp119_;
			gboolean _tmp120_;
			_tmp118_ = return_type;
			_tmp119_ = return_comment;
			_tmp120_ = constructor;
			vala_gir_writer_write_param_or_return (self, _tmp118_, TRUE, &index, FALSE, "result", _tmp119_, VALA_PARAMETER_DIRECTION_OUT, _tmp120_, TRUE);
		} else {
			ValaDataType* _tmp121_;
			gboolean _tmp122_;
			_tmp121_ = return_type;
			_tmp122_ = return_array_length;
			vala_gir_writer_write_implicit_params (self, _tmp121_, &index, _tmp122_, "result", VALA_PARAMETER_DIRECTION_OUT);
		}
		_tmp123_ = user_data;
		if (_tmp123_) {
			GString* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			GString* _tmp127_;
			gint _tmp128_;
			GString* _tmp129_;
			vala_gir_writer_write_indent (self);
			_tmp124_ = self->priv->buffer;
			_tmp125_ = index;
			g_string_append_printf (_tmp124_, "<parameter name=\"user_data\" transfer-ownership=\"none\" closure=\"%d" \
"\">\n", _tmp125_);
			_tmp126_ = self->priv->indent;
			self->priv->indent = _tmp126_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp127_ = self->priv->buffer;
			g_string_append_printf (_tmp127_, "<type name=\"gpointer\" c:type=\"void*\"/>\n");
			_tmp128_ = self->priv->indent;
			self->priv->indent = _tmp128_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp129_ = self->priv->buffer;
			g_string_append_printf (_tmp129_, "</parameter>\n");
		}
		_tmp130_ = self->priv->indent;
		self->priv->indent = _tmp130_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp131_ = self->priv->buffer;
		g_string_append_printf (_tmp131_, "</parameters>\n");
	}
}


static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	ValaGIRWriter * self;
	ValaDelegate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaDelegate* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GString* _tmp5_;
	ValaDelegate* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	ValaDelegate* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	ValaDelegate* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ValaDelegate* _tmp17_;
	GString* _tmp18_;
	gint _tmp19_;
	ValaDelegate* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	ValaDelegate* _tmp23_;
	ValaDelegate* _tmp24_;
	ValaList* _tmp25_ = NULL;
	ValaList* _tmp26_;
	ValaDelegate* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDelegate* _tmp30_;
	gboolean _tmp31_ = FALSE;
	ValaDelegate* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	ValaDelegate* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gint _tmp38_;
	GString* _tmp39_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = cb;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = cb;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = cb;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<callback name=\"%s\"", _tmp8_);
	_tmp9_ = self->priv->buffer;
	_tmp10_ = cb;
	_tmp11_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_string_append_printf (_tmp9_, " c:type=\"%s\"", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = cb;
	_tmp14_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		GString* _tmp16_;
		_tmp16_ = self->priv->buffer;
		g_string_append_printf (_tmp16_, " throws=\"1\"");
	}
	_tmp17_ = cb;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp17_);
	_tmp18_ = self->priv->buffer;
	g_string_append_printf (_tmp18_, ">\n");
	_tmp19_ = self->priv->indent;
	self->priv->indent = _tmp19_ + 1;
	_tmp20_ = cb;
	_tmp21_ = vala_gir_writer_get_delegate_comment (self, _tmp20_);
	_tmp22_ = _tmp21_;
	vala_gir_writer_write_doc (self, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = cb;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp23_);
	_tmp24_ = cb;
	_tmp25_ = vala_delegate_get_parameters (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = cb;
	_tmp28_ = vala_delegate_get_return_type (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = cb;
	_tmp31_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp30_);
	_tmp32_ = cb;
	_tmp33_ = vala_gir_writer_get_delegate_return_comment (self, _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = cb;
	_tmp36_ = vala_delegate_get_has_target (_tmp35_);
	_tmp37_ = _tmp36_;
	vala_gir_writer_write_params_and_return (self, _tmp26_, _tmp29_, _tmp31_, _tmp34_, FALSE, NULL, _tmp37_);
	_g_free0 (_tmp34_);
	_vala_iterable_unref0 (_tmp26_);
	_tmp38_ = self->priv->indent;
	self->priv->indent = _tmp38_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp39_ = self->priv->buffer;
	g_string_append_printf (_tmp39_, "</callback>\n");
}


static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaGIRWriter * self;
	ValaMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaMethod* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp10_;
	gboolean _tmp24_;
	ValaMethod* _tmp25_;
	gboolean _tmp26_ = FALSE;
	gchar* _tmp27_;
	gchar* tag_name;
	ValaArrayList* _tmp28_;
	gpointer _tmp29_ = NULL;
	ValaSymbol* parent;
	ValaSymbol* _tmp30_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	ValaSymbol* _tmp35_;
	gboolean _tmp39_;
	gboolean _tmp44_;
	ValaMethod* _tmp46_;
	const gchar* _tmp47_;
	gboolean _tmp48_ = FALSE;
	ValaMethod* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp55_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp5_ = m;
	_tmp6_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp5_);
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		ValaMethod* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = m;
		_tmp8_ = vala_method_get_overrides (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_;
	}
	_tmp10_ = _tmp4_;
	if (_tmp10_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		ValaMethod* _tmp13_;
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		gboolean _tmp19_;
		gboolean _tmp23_;
		_tmp13_ = m;
		_tmp14_ = vala_method_get_base_interface_method (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ != NULL) {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = m;
			_tmp17_ = vala_method_get_is_abstract (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp12_ = !_tmp18_;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp19_ = _tmp12_;
		if (_tmp19_) {
			ValaMethod* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			_tmp20_ = m;
			_tmp21_ = vala_method_get_is_virtual (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp11_ = !_tmp22_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp23_ = _tmp11_;
		_tmp3_ = _tmp23_;
	}
	_tmp24_ = _tmp3_;
	if (_tmp24_) {
		return;
	}
	_tmp25_ = m;
	_tmp26_ = vala_gir_writer_check_signature (self, _tmp25_);
	if (!_tmp26_) {
		return;
	}
	_tmp27_ = g_strdup ("method");
	tag_name = _tmp27_;
	_tmp28_ = self->priv->hierarchy;
	_tmp29_ = vala_list_get ((ValaList*) _tmp28_, 0);
	parent = (ValaSymbol*) _tmp29_;
	_tmp30_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_ENUM)) {
		ValaArrayList* _tmp31_;
		ValaMethod* _tmp32_;
		_tmp31_ = self->priv->deferred;
		_tmp32_ = m;
		vala_collection_add ((ValaCollection*) _tmp31_, (ValaCodeNode*) _tmp32_);
		_vala_code_node_unref0 (parent);
		_g_free0 (tag_name);
		return;
	}
	_tmp35_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_NAMESPACE)) {
		_tmp34_ = TRUE;
	} else {
		ValaMethod* _tmp36_;
		ValaMemberBinding _tmp37_;
		ValaMemberBinding _tmp38_;
		_tmp36_ = m;
		_tmp37_ = vala_method_get_binding (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp34_ = _tmp38_ == VALA_MEMBER_BINDING_STATIC;
	}
	_tmp39_ = _tmp34_;
	if (_tmp39_) {
		_tmp33_ = TRUE;
	} else {
		ValaSymbol* _tmp40_;
		ValaMethod* _tmp41_;
		ValaSymbol* _tmp42_;
		ValaSymbol* _tmp43_;
		_tmp40_ = parent;
		_tmp41_ = m;
		_tmp42_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp33_ = _tmp40_ != _tmp43_;
	}
	_tmp44_ = _tmp33_;
	if (_tmp44_) {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("function");
		_g_free0 (tag_name);
		tag_name = _tmp45_;
	}
	_tmp46_ = m;
	_tmp47_ = tag_name;
	vala_gir_writer_write_signature (self, _tmp46_, _tmp47_, TRUE, FALSE);
	_tmp49_ = m;
	_tmp50_ = vala_method_get_is_abstract (_tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_) {
		_tmp48_ = TRUE;
	} else {
		ValaMethod* _tmp52_;
		gboolean _tmp53_;
		gboolean _tmp54_;
		_tmp52_ = m;
		_tmp53_ = vala_method_get_is_virtual (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp48_ = _tmp54_;
	}
	_tmp55_ = _tmp48_;
	if (_tmp55_) {
		ValaMethod* _tmp56_;
		_tmp56_ = m;
		vala_gir_writer_write_signature (self, _tmp56_, "virtual-method", TRUE, FALSE);
	}
	_vala_code_node_unref0 (parent);
	_g_free0 (tag_name);
}


static gboolean vala_gir_writer_check_type (ValaGIRWriter* self, ValaDataType* type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "va_list") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean vala_gir_writer_check_signature (ValaGIRWriter* self, ValaMethod* m) {
	gboolean result = FALSE;
	ValaMethod* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = m;
	_tmp1_ = vala_method_get_return_type (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_writer_check_type (self, _tmp2_);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	{
		ValaMethod* _tmp4_;
		ValaList* _tmp5_ = NULL;
		ValaList* _param_list;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _param_size;
		gint _param_index;
		_tmp4_ = m;
		_tmp5_ = vala_method_get_parameters (_tmp4_);
		_param_list = _tmp5_;
		_tmp6_ = _param_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_param_size = _tmp8_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			ValaParameter* param;
			gboolean _tmp15_ = FALSE;
			ValaParameter* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			gboolean _tmp23_;
			_tmp9_ = _param_index;
			_param_index = _tmp9_ + 1;
			_tmp10_ = _param_index;
			_tmp11_ = _param_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _param_list;
			_tmp13_ = _param_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			param = (ValaParameter*) _tmp14_;
			_tmp16_ = param;
			_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == NULL) {
				_tmp15_ = TRUE;
			} else {
				ValaParameter* _tmp19_;
				ValaDataType* _tmp20_;
				ValaDataType* _tmp21_;
				gboolean _tmp22_ = FALSE;
				_tmp19_ = param;
				_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_gir_writer_check_type (self, _tmp21_);
				_tmp15_ = !_tmp22_;
			}
			_tmp23_ = _tmp15_;
			if (_tmp23_) {
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = TRUE;
	return result;
}


static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean write_doc, gboolean instance) {
	ValaArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	ValaSymbol* parent;
	gchar* name = NULL;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaMethod* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	parent = (ValaSymbol*) _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = parent;
	if (_tmp4_ != _tmp5_) {
		ValaMethod* _tmp6_;
		gchar* _tmp7_ = NULL;
		ValaSymbol* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* parent_prefix;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		instance = FALSE;
		_tmp6_ = m;
		_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
		_g_free0 (name);
		name = _tmp7_;
		_tmp8_ = parent;
		_tmp9_ = vala_ccode_base_module_get_ccode_lower_case_prefix (_tmp8_);
		parent_prefix = _tmp9_;
		_tmp10_ = name;
		_tmp11_ = parent_prefix;
		_tmp12_ = g_str_has_prefix (_tmp10_, _tmp11_);
		if (_tmp12_) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_ = NULL;
			_tmp13_ = name;
			_tmp14_ = parent_prefix;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp13_, (glong) _tmp16_, (glong) (-1));
			_g_free0 (name);
			name = _tmp17_;
		}
		_g_free0 (parent_prefix);
	} else {
		ValaMethod* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = m;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (name);
		name = _tmp21_;
	}
	_tmp22_ = m;
	_tmp23_ = vala_method_get_coroutine (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* finish_name;
		const gchar* _tmp27_;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		ValaMethod* _tmp38_;
		const gchar* _tmp39_;
		gboolean _tmp40_;
		const gchar* _tmp41_;
		ValaMethod* _tmp42_;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		ValaMethod* _tmp45_;
		ValaList* _tmp46_ = NULL;
		ValaList* _tmp47_;
		ValaVoidType* _tmp48_;
		ValaVoidType* _tmp49_;
		ValaMethod* _tmp50_;
		const gchar* _tmp51_;
		gboolean _tmp52_;
		const gchar* _tmp53_;
		ValaMethod* _tmp54_;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_;
		ValaMethod* _tmp57_;
		ValaList* _tmp58_ = NULL;
		ValaList* _tmp59_;
		ValaMethod* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaMethod* _tmp63_;
		gboolean _tmp64_;
		gboolean _tmp65_;
		_tmp25_ = name;
		_tmp26_ = g_strdup (_tmp25_);
		finish_name = _tmp26_;
		_tmp27_ = finish_name;
		_tmp28_ = g_str_has_suffix (_tmp27_, "_async");
		if (_tmp28_) {
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_ = NULL;
			_tmp29_ = finish_name;
			_tmp30_ = finish_name;
			_tmp31_ = strlen (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = strlen ("_async");
			_tmp34_ = _tmp33_;
			_tmp35_ = string_substring (_tmp29_, (glong) 0, (glong) (_tmp32_ - _tmp34_));
			_g_free0 (finish_name);
			finish_name = _tmp35_;
		}
		_tmp36_ = finish_name;
		_tmp37_ = g_strconcat (_tmp36_, "_finish", NULL);
		_g_free0 (finish_name);
		finish_name = _tmp37_;
		_tmp38_ = m;
		_tmp39_ = tag_name;
		_tmp40_ = instance;
		_tmp41_ = name;
		_tmp42_ = m;
		_tmp43_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = m;
		_tmp46_ = vala_method_get_async_begin_parameters (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_void_type_new (NULL);
		_tmp49_ = _tmp48_;
		vala_gir_writer_do_write_signature (self, _tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp44_, _tmp47_, (ValaDataType*) _tmp49_, FALSE, TRUE);
		_vala_code_node_unref0 (_tmp49_);
		_vala_iterable_unref0 (_tmp47_);
		_g_free0 (_tmp44_);
		_tmp50_ = m;
		_tmp51_ = tag_name;
		_tmp52_ = instance;
		_tmp53_ = finish_name;
		_tmp54_ = m;
		_tmp55_ = vala_ccode_base_module_get_ccode_finish_name (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = m;
		_tmp58_ = vala_method_get_async_end_parameters (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = m;
		_tmp61_ = vala_method_get_return_type (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = m;
		_tmp64_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp63_);
		_tmp65_ = _tmp64_;
		vala_gir_writer_do_write_signature (self, _tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp56_, _tmp59_, _tmp62_, _tmp65_, FALSE);
		_vala_iterable_unref0 (_tmp59_);
		_g_free0 (_tmp56_);
		_g_free0 (finish_name);
	} else {
		ValaMethod* _tmp66_;
		const gchar* _tmp67_;
		gboolean _tmp68_;
		const gchar* _tmp69_;
		ValaMethod* _tmp70_;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_;
		ValaMethod* _tmp73_;
		ValaList* _tmp74_ = NULL;
		ValaList* _tmp75_;
		ValaMethod* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaMethod* _tmp79_;
		gboolean _tmp80_;
		gboolean _tmp81_;
		_tmp66_ = m;
		_tmp67_ = tag_name;
		_tmp68_ = instance;
		_tmp69_ = name;
		_tmp70_ = m;
		_tmp71_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = m;
		_tmp74_ = vala_method_get_parameters (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = m;
		_tmp77_ = vala_method_get_return_type (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = m;
		_tmp80_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp79_);
		_tmp81_ = _tmp80_;
		vala_gir_writer_do_write_signature (self, _tmp66_, _tmp67_, _tmp68_, _tmp69_, _tmp72_, _tmp75_, _tmp78_, _tmp81_, TRUE);
		_vala_iterable_unref0 (_tmp75_);
		_g_free0 (_tmp72_);
	}
	_g_free0 (name);
	_vala_code_node_unref0 (parent);
}


static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail, gboolean write_comment) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp11_;
	ValaMethod* _tmp13_;
	GString* _tmp14_;
	gint _tmp15_;
	gchar* return_comment;
	gboolean _tmp16_;
	ValaMethod* _tmp22_;
	ValaDataType* instance_type;
	gboolean _tmp23_;
	ValaList* _tmp28_;
	ValaDataType* _tmp29_;
	ValaMethod* _tmp30_;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_;
	ValaDataType* _tmp33_;
	gint _tmp34_;
	GString* _tmp35_;
	const gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = tag_name;
	_tmp2_ = name;
	g_string_append_printf (_tmp0_, "<%s name=\"%s\"", _tmp1_, _tmp2_);
	_tmp3_ = tag_name;
	if (g_strcmp0 (_tmp3_, "virtual-method") == 0) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->buffer;
		_tmp5_ = name;
		g_string_append_printf (_tmp4_, " invoker=\"%s\"", _tmp5_);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = tag_name;
		if (g_strcmp0 (_tmp6_, "callback") == 0) {
			GString* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->buffer;
			_tmp8_ = name;
			g_string_append_printf (_tmp7_, " c:type=\"%s\"", _tmp8_);
		} else {
			GString* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->buffer;
			_tmp10_ = cname;
			g_string_append_printf (_tmp9_, " c:identifier=\"%s\"", _tmp10_);
		}
	}
	_tmp11_ = can_fail;
	if (_tmp11_) {
		GString* _tmp12_;
		_tmp12_ = self->priv->buffer;
		g_string_append_printf (_tmp12_, " throws=\"1\"");
	}
	_tmp13_ = m;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp13_);
	_tmp14_ = self->priv->buffer;
	g_string_append_printf (_tmp14_, ">\n");
	_tmp15_ = self->priv->indent;
	self->priv->indent = _tmp15_ + 1;
	return_comment = NULL;
	_tmp16_ = write_comment;
	if (_tmp16_) {
		ValaMethod* _tmp17_;
		gchar* _tmp18_ = NULL;
		ValaMethod* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		_tmp17_ = m;
		_tmp18_ = vala_gir_writer_get_method_return_comment (self, _tmp17_);
		_g_free0 (return_comment);
		return_comment = _tmp18_;
		_tmp19_ = m;
		_tmp20_ = vala_gir_writer_get_method_comment (self, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_gir_writer_write_doc (self, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = m;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp22_);
	instance_type = NULL;
	_tmp23_ = instance;
	if (_tmp23_) {
		ValaMethod* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaDataType* _tmp27_ = NULL;
		_tmp24_ = m;
		_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_ccode_base_module_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		_vala_code_node_unref0 (instance_type);
		instance_type = _tmp27_;
	}
	_tmp28_ = params;
	_tmp29_ = return_type;
	_tmp30_ = m;
	_tmp31_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp30_);
	_tmp32_ = return_comment;
	_tmp33_ = instance_type;
	vala_gir_writer_write_params_and_return (self, _tmp28_, _tmp29_, _tmp31_, _tmp32_, FALSE, _tmp33_, FALSE);
	_tmp34_ = self->priv->indent;
	self->priv->indent = _tmp34_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp35_ = self->priv->buffer;
	_tmp36_ = tag_name;
	g_string_append_printf (_tmp35_, "</%s>\n", _tmp36_);
	_vala_code_node_unref0 (instance_type);
	_g_free0 (return_comment);
}


static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaGIRWriter * self;
	ValaCreationMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaCreationMethod* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaCreationMethod* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	gboolean _tmp14_;
	ValaCreationMethod* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean is_struct;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* tag_name;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaCreationMethod* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaSymbol* _tmp26_;
	gboolean _tmp33_;
	gboolean _tmp45_;
	ValaCreationMethod* _tmp64_;
	gboolean _tmp65_;
	gboolean _tmp66_;
	GString* _tmp68_;
	gint _tmp69_;
	ValaCreationMethod* _tmp70_;
	gchar* _tmp71_ = NULL;
	gchar* _tmp72_;
	ValaCreationMethod* _tmp73_;
	ValaCreationMethod* _tmp74_;
	ValaSymbol* _tmp75_;
	ValaSymbol* _tmp76_;
	ValaDataType* _tmp77_ = NULL;
	ValaDataType* datatype;
	ValaCreationMethod* _tmp78_;
	ValaList* _tmp79_ = NULL;
	ValaList* _tmp80_;
	ValaDataType* _tmp81_;
	ValaCreationMethod* _tmp82_;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_;
	gint _tmp85_;
	GString* _tmp86_;
	const gchar* _tmp87_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = m;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp6_ = m;
	_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_CLASS)) {
		ValaCreationMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = m;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_class_get_is_abstract (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass));
		_tmp13_ = _tmp12_;
		_tmp5_ = _tmp13_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp14_ = _tmp5_;
	if (_tmp14_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp15_ = m;
	_tmp16_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp15_);
	_tmp17_ = _tmp16_;
	is_struct = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_STRUCT);
	_tmp19_ = is_struct;
	if (_tmp19_) {
		_tmp18_ = "function";
	} else {
		_tmp18_ = "constructor";
	}
	_tmp20_ = _tmp18_;
	_tmp21_ = g_strdup (_tmp20_);
	tag_name = _tmp21_;
	_tmp24_ = m;
	_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_CLASS)) {
		ValaCreationMethod* _tmp27_;
		ValaCreationMethod* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaMethod* _tmp31_;
		ValaMethod* _tmp32_;
		_tmp27_ = m;
		_tmp28_ = m;
		_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_class_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_CLASS, ValaClass));
		_tmp32_ = _tmp31_;
		_tmp23_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_METHOD, ValaMethod) == _tmp32_;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp33_ = _tmp23_;
	if (_tmp33_) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp34_ = FALSE;
		ValaCreationMethod* _tmp35_;
		ValaSymbol* _tmp36_;
		ValaSymbol* _tmp37_;
		gboolean _tmp44_;
		_tmp35_ = m;
		_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALA_TYPE_STRUCT)) {
			ValaCreationMethod* _tmp38_;
			ValaCreationMethod* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp38_ = m;
			_tmp39_ = m;
			_tmp40_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_struct_get_default_construction_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_STRUCT, ValaStruct));
			_tmp43_ = _tmp42_;
			_tmp34_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_METHOD, ValaMethod) == _tmp43_;
		} else {
			_tmp34_ = FALSE;
		}
		_tmp44_ = _tmp34_;
		_tmp22_ = _tmp44_;
	}
	_tmp45_ = _tmp22_;
	if (_tmp45_) {
		const gchar* _tmp46_ = NULL;
		gboolean _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* m_name;
		GString* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaCreationMethod* _tmp53_;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		_tmp47_ = is_struct;
		if (_tmp47_) {
			_tmp46_ = "init";
		} else {
			_tmp46_ = "new";
		}
		_tmp48_ = _tmp46_;
		_tmp49_ = g_strdup (_tmp48_);
		m_name = _tmp49_;
		_tmp50_ = self->priv->buffer;
		_tmp51_ = tag_name;
		_tmp52_ = m_name;
		_tmp53_ = m;
		_tmp54_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp53_);
		_tmp55_ = _tmp54_;
		g_string_append_printf (_tmp50_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp51_, _tmp52_, _tmp55_);
		_g_free0 (_tmp55_);
		_g_free0 (m_name);
	} else {
		GString* _tmp56_;
		const gchar* _tmp57_;
		ValaCreationMethod* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		ValaCreationMethod* _tmp61_;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_;
		_tmp56_ = self->priv->buffer;
		_tmp57_ = tag_name;
		_tmp58_ = m;
		_tmp59_ = vala_symbol_get_name ((ValaSymbol*) _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = m;
		_tmp62_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		g_string_append_printf (_tmp56_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp57_, _tmp60_, _tmp63_);
		_g_free0 (_tmp63_);
	}
	_tmp64_ = m;
	_tmp65_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp64_);
	_tmp66_ = _tmp65_;
	if (_tmp66_) {
		GString* _tmp67_;
		_tmp67_ = self->priv->buffer;
		g_string_append_printf (_tmp67_, " throws=\"1\"");
	}
	_tmp68_ = self->priv->buffer;
	g_string_append_printf (_tmp68_, ">\n");
	_tmp69_ = self->priv->indent;
	self->priv->indent = _tmp69_ + 1;
	_tmp70_ = m;
	_tmp71_ = vala_gir_writer_get_method_comment (self, (ValaMethod*) _tmp70_);
	_tmp72_ = _tmp71_;
	vala_gir_writer_write_doc (self, _tmp72_);
	_g_free0 (_tmp72_);
	_tmp73_ = m;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp73_);
	_tmp74_ = m;
	_tmp75_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_ccode_base_module_get_data_type_for_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	datatype = _tmp77_;
	_tmp78_ = m;
	_tmp79_ = vala_method_get_parameters ((ValaMethod*) _tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = datatype;
	_tmp82_ = m;
	_tmp83_ = vala_gir_writer_get_method_return_comment (self, (ValaMethod*) _tmp82_);
	_tmp84_ = _tmp83_;
	vala_gir_writer_write_params_and_return (self, _tmp80_, _tmp81_, FALSE, _tmp84_, TRUE, NULL, FALSE);
	_g_free0 (_tmp84_);
	_vala_iterable_unref0 (_tmp80_);
	_tmp85_ = self->priv->indent;
	self->priv->indent = _tmp85_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp86_ = self->priv->buffer;
	_tmp87_ = tag_name;
	g_string_append_printf (_tmp86_, "</%s>\n", _tmp87_);
	_vala_code_node_unref0 (datatype);
	_g_free0 (tag_name);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaProperty* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp21_;
	GString* _tmp22_;
	ValaProperty* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	ValaProperty* _tmp28_;
	ValaPropertyAccessor* _tmp29_;
	ValaPropertyAccessor* _tmp30_;
	ValaProperty* _tmp32_;
	ValaPropertyAccessor* _tmp33_;
	ValaPropertyAccessor* _tmp34_;
	ValaProperty* _tmp48_;
	GString* _tmp49_;
	gint _tmp50_;
	ValaProperty* _tmp51_;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_;
	ValaProperty* _tmp54_;
	ValaProperty* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	gint _tmp58_;
	GString* _tmp59_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (prop != NULL);
	_tmp2_ = prop;
	_tmp3_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp2_);
	if (!_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		ValaProperty* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = prop;
		_tmp5_ = vala_property_get_overrides (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		ValaProperty* _tmp10_;
		ValaProperty* _tmp11_;
		ValaProperty* _tmp12_;
		gboolean _tmp16_;
		gboolean _tmp20_;
		_tmp10_ = prop;
		_tmp11_ = vala_property_get_base_interface_property (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaProperty* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = prop;
			_tmp14_ = vala_property_get_is_abstract (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp9_ = !_tmp15_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp16_ = _tmp9_;
		if (_tmp16_) {
			ValaProperty* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = prop;
			_tmp18_ = vala_property_get_is_virtual (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp8_ = !_tmp19_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp20_ = _tmp8_;
		_tmp0_ = _tmp20_;
	}
	_tmp21_ = _tmp0_;
	if (_tmp21_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp22_ = self->priv->buffer;
	_tmp23_ = prop;
	_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_replace (_tmp25_, "_", "-");
	_tmp27_ = _tmp26_;
	g_string_append_printf (_tmp22_, "<property name=\"%s\"", _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = prop;
	_tmp29_ = vala_property_get_get_accessor (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == NULL) {
		GString* _tmp31_;
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, " readable=\"0\"");
	}
	_tmp32_ = prop;
	_tmp33_ = vala_property_get_set_accessor (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		GString* _tmp35_;
		ValaProperty* _tmp36_;
		ValaPropertyAccessor* _tmp37_;
		ValaPropertyAccessor* _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp40_;
		_tmp35_ = self->priv->buffer;
		g_string_append_printf (_tmp35_, " writable=\"1\"");
		_tmp36_ = prop;
		_tmp37_ = vala_property_get_set_accessor (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_property_accessor_get_construction (_tmp38_);
		_tmp40_ = _tmp39_;
		if (_tmp40_) {
			ValaProperty* _tmp41_;
			ValaPropertyAccessor* _tmp42_;
			ValaPropertyAccessor* _tmp43_;
			gboolean _tmp44_;
			gboolean _tmp45_;
			_tmp41_ = prop;
			_tmp42_ = vala_property_get_set_accessor (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_property_accessor_get_writable (_tmp43_);
			_tmp45_ = _tmp44_;
			if (!_tmp45_) {
				GString* _tmp46_;
				_tmp46_ = self->priv->buffer;
				g_string_append_printf (_tmp46_, " construct-only=\"1\"");
			} else {
				GString* _tmp47_;
				_tmp47_ = self->priv->buffer;
				g_string_append_printf (_tmp47_, " construct=\"1\"");
			}
		}
	}
	_tmp48_ = prop;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp48_);
	_tmp49_ = self->priv->buffer;
	g_string_append_printf (_tmp49_, ">\n");
	_tmp50_ = self->priv->indent;
	self->priv->indent = _tmp50_ + 1;
	_tmp51_ = prop;
	_tmp52_ = vala_gir_writer_get_property_comment (self, _tmp51_);
	_tmp53_ = _tmp52_;
	vala_gir_writer_write_doc (self, _tmp53_);
	_g_free0 (_tmp53_);
	_tmp54_ = prop;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp54_);
	_tmp55_ = prop;
	_tmp56_ = vala_property_get_property_type (_tmp55_);
	_tmp57_ = _tmp56_;
	vala_gir_writer_write_type (self, _tmp57_, -1);
	_tmp58_ = self->priv->indent;
	self->priv->indent = _tmp58_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp59_ = self->priv->buffer;
	g_string_append_printf (_tmp59_, "</property>\n");
}


static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaGIRWriter * self;
	ValaSignal* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GString* _tmp2_;
	ValaSignal* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	ValaSignal* _tmp6_;
	GString* _tmp7_;
	gint _tmp8_;
	ValaSignal* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	ValaSignal* _tmp12_;
	ValaSignal* _tmp13_;
	ValaList* _tmp14_ = NULL;
	ValaList* _tmp15_;
	ValaSignal* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaSignal* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gint _tmp22_;
	GString* _tmp23_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = sig;
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp0_);
	if (!_tmp1_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = sig;
	_tmp4_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp2_, "<glib:signal name=\"%s\"", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = sig;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp6_);
	_tmp7_ = self->priv->buffer;
	g_string_append_printf (_tmp7_, ">\n");
	_tmp8_ = self->priv->indent;
	self->priv->indent = _tmp8_ + 1;
	_tmp9_ = sig;
	_tmp10_ = vala_gir_writer_get_signal_comment (self, _tmp9_);
	_tmp11_ = _tmp10_;
	vala_gir_writer_write_doc (self, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = sig;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp12_);
	_tmp13_ = sig;
	_tmp14_ = vala_signal_get_parameters (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = sig;
	_tmp17_ = vala_signal_get_return_type (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = sig;
	_tmp20_ = vala_gir_writer_get_signal_return_comment (self, _tmp19_);
	_tmp21_ = _tmp20_;
	vala_gir_writer_write_params_and_return (self, _tmp15_, _tmp18_, FALSE, _tmp21_, FALSE, NULL, FALSE);
	_g_free0 (_tmp21_);
	_vala_iterable_unref0 (_tmp15_);
	_tmp22_ = self->priv->indent;
	self->priv->indent = _tmp22_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp23_ = self->priv->buffer;
	g_string_append_printf (_tmp23_, "</glib:signal>\n");
}


static void vala_gir_writer_write_indent (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			gint _tmp3_;
			gint _tmp4_;
			GString* _tmp5_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = i;
				i = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = i;
			_tmp4_ = self->priv->indent;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = self->priv->buffer;
			g_string_append_c (_tmp5_, '\t');
		}
	}
}


static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			gint _tmp3_;
			gint _tmp4_;
			FILE* _tmp5_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = i;
				i = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = i;
			_tmp4_ = self->priv->indent;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = self->priv->stream;
			fputc ('\t', _tmp5_);
		}
	}
}


static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, gboolean is_parameter, gint* index, gboolean has_array_length, const gchar* name, const gchar* comment, ValaParameterDirection direction, gboolean constructor, gboolean caller_allocates) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* tag;
	GString* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaParameterDirection _tmp9_;
	ValaDataType* _tmp13_;
	ValaDelegateType* _tmp14_;
	ValaDelegateType* delegate_type;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp21_;
	gboolean _tmp30_;
	gboolean _tmp33_;
	ValaDataType* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp39_ = FALSE;
	ValaDelegateType* _tmp40_;
	gboolean _tmp46_;
	GString* _tmp69_;
	gint _tmp70_;
	const gchar* _tmp71_;
	gint length_param_index;
	gboolean _tmp72_;
	ValaDataType* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	GString* _tmp81_;
	const gchar* _tmp82_;
	gint _tmp83_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp1_ = is_parameter;
	if (_tmp1_) {
		_tmp0_ = "parameter";
	} else {
		_tmp0_ = "return-value";
	}
	_tmp2_ = _tmp0_;
	_tmp3_ = g_strdup (_tmp2_);
	tag = _tmp3_;
	_tmp4_ = self->priv->buffer;
	_tmp5_ = tag;
	g_string_append_printf (_tmp4_, "<%s", _tmp5_);
	_tmp6_ = name;
	if (_tmp6_ != NULL) {
		GString* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->buffer;
		_tmp8_ = name;
		g_string_append_printf (_tmp7_, " name=\"%s\"", _tmp8_);
	}
	_tmp9_ = direction;
	if (_tmp9_ == VALA_PARAMETER_DIRECTION_REF) {
		GString* _tmp10_;
		_tmp10_ = self->priv->buffer;
		g_string_append_printf (_tmp10_, " direction=\"inout\"");
	} else {
		ValaParameterDirection _tmp11_;
		_tmp11_ = direction;
		if (_tmp11_ == VALA_PARAMETER_DIRECTION_OUT) {
			GString* _tmp12_;
			_tmp12_ = self->priv->buffer;
			g_string_append_printf (_tmp12_, " direction=\"out\"");
		}
	}
	_tmp13_ = type;
	_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp13_) : NULL);
	delegate_type = _tmp14_;
	_tmp17_ = type;
	_tmp18_ = vala_data_type_get_value_owned (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		ValaDelegateType* _tmp20_;
		_tmp20_ = delegate_type;
		_tmp16_ = _tmp20_ == NULL;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp21_ = _tmp16_;
	if (_tmp21_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_;
		gboolean _tmp29_;
		_tmp23_ = constructor;
		if (_tmp23_) {
			ValaDataType* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaTypeSymbol* _tmp26_;
			ValaTypeSymbol* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp24_ = type;
			_tmp25_ = vala_data_type_get_data_type (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = self->priv->ginitiallyunowned_type;
			_tmp28_ = vala_typesymbol_is_subtype_of (_tmp26_, _tmp27_);
			_tmp22_ = !_tmp28_;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp29_ = _tmp22_;
		_tmp15_ = _tmp29_;
	}
	_tmp30_ = _tmp15_;
	if (_tmp30_) {
		GString* _tmp31_;
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, " transfer-ownership=\"full\"");
	} else {
		GString* _tmp32_;
		_tmp32_ = self->priv->buffer;
		g_string_append_printf (_tmp32_, " transfer-ownership=\"none\"");
	}
	_tmp33_ = caller_allocates;
	if (_tmp33_) {
		GString* _tmp34_;
		_tmp34_ = self->priv->buffer;
		g_string_append_printf (_tmp34_, " caller-allocates=\"1\"");
	}
	_tmp35_ = type;
	_tmp36_ = vala_data_type_get_nullable (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		GString* _tmp38_;
		_tmp38_ = self->priv->buffer;
		g_string_append_printf (_tmp38_, " allow-none=\"1\"");
	}
	_tmp40_ = delegate_type;
	if (_tmp40_ != NULL) {
		ValaDelegateType* _tmp41_;
		ValaDelegate* _tmp42_;
		ValaDelegate* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp41_ = delegate_type;
		_tmp42_ = vala_delegate_type_get_delegate_symbol (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_delegate_get_has_target (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = _tmp45_;
	} else {
		_tmp39_ = FALSE;
	}
	_tmp46_ = _tmp39_;
	if (_tmp46_) {
		gint _tmp47_ = 0;
		gboolean _tmp48_;
		gint _tmp57_;
		gint closure_index;
		GString* _tmp58_;
		gint _tmp59_;
		ValaDataType* _tmp60_;
		gboolean _tmp61_;
		gboolean _tmp62_;
		ValaDelegateType* _tmp65_;
		gboolean _tmp66_;
		gboolean _tmp67_;
		_tmp48_ = is_parameter;
		if (_tmp48_) {
			gint _tmp49_;
			_tmp49_ = *index;
			_tmp47_ = _tmp49_ + 1;
		} else {
			gint _tmp50_ = 0;
			ValaDataType* _tmp51_;
			gboolean _tmp52_;
			gboolean _tmp53_;
			gint _tmp56_;
			_tmp51_ = type;
			_tmp52_ = vala_data_type_get_value_owned (_tmp51_);
			_tmp53_ = _tmp52_;
			if (_tmp53_) {
				gint _tmp54_;
				_tmp54_ = *index;
				_tmp50_ = _tmp54_ - 1;
			} else {
				gint _tmp55_;
				_tmp55_ = *index;
				_tmp50_ = _tmp55_;
			}
			_tmp56_ = _tmp50_;
			_tmp47_ = _tmp56_;
		}
		_tmp57_ = _tmp47_;
		closure_index = _tmp57_;
		_tmp58_ = self->priv->buffer;
		_tmp59_ = closure_index;
		g_string_append_printf (_tmp58_, " closure=\"%i\"", _tmp59_);
		_tmp60_ = type;
		_tmp61_ = vala_data_type_get_value_owned (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp62_) {
			GString* _tmp63_;
			gint _tmp64_;
			_tmp63_ = self->priv->buffer;
			_tmp64_ = closure_index;
			g_string_append_printf (_tmp63_, " destroy=\"%i\"", _tmp64_ + 1);
		}
		_tmp65_ = delegate_type;
		_tmp66_ = vala_delegate_type_get_is_called_once (_tmp65_);
		_tmp67_ = _tmp66_;
		if (_tmp67_) {
			GString* _tmp68_;
			_tmp68_ = self->priv->buffer;
			g_string_append (_tmp68_, " scope=\"async\"");
		}
	}
	_tmp69_ = self->priv->buffer;
	g_string_append_printf (_tmp69_, ">\n");
	_tmp70_ = self->priv->indent;
	self->priv->indent = _tmp70_ + 1;
	_tmp71_ = comment;
	vala_gir_writer_write_doc (self, _tmp71_);
	length_param_index = -1;
	_tmp72_ = has_array_length;
	if (_tmp72_) {
		gint _tmp73_ = 0;
		gboolean _tmp74_;
		gint _tmp77_;
		_tmp74_ = is_parameter;
		if (_tmp74_) {
			gint _tmp75_;
			_tmp75_ = *index;
			_tmp73_ = _tmp75_ + 1;
		} else {
			gint _tmp76_;
			_tmp76_ = *index;
			_tmp73_ = _tmp76_;
		}
		_tmp77_ = _tmp73_;
		length_param_index = _tmp77_;
	}
	_tmp78_ = type;
	_tmp79_ = length_param_index;
	vala_gir_writer_write_type (self, _tmp78_, _tmp79_);
	_tmp80_ = self->priv->indent;
	self->priv->indent = _tmp80_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp81_ = self->priv->buffer;
	_tmp82_ = tag;
	g_string_append_printf (_tmp81_, "</%s>\n", _tmp82_);
	_tmp83_ = *index;
	*index = _tmp83_ + 1;
	_vala_code_node_unref0 (delegate_type);
	_g_free0 (tag);
}


static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix) {
	GString* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (suffix != NULL);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = symbol;
	_tmp2_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = suffix;
	g_string_append_printf (_tmp0_, " c:type=\"%s%s\"", _tmp3_, _tmp4_);
	_g_free0 (_tmp3_);
}


static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol) {
	ValaTypeSymbol* _tmp0_;
	GString* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GString* _tmp5_;
	ValaTypeSymbol* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = symbol;
	vala_gir_writer_write_ctype_attributes (self, _tmp0_, "");
	_tmp1_ = self->priv->buffer;
	_tmp2_ = symbol;
	_tmp3_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp1_, " glib:type-name=\"%s\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = symbol;
	_tmp7_ = vala_ccode_base_module_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, " glib:get-type=\"%sget_type\"", _tmp8_);
	_g_free0 (_tmp8_);
}


static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_ARRAY_TYPE)) {
		ValaDataType* _tmp1_;
		ValaArrayType* _tmp2_;
		ValaArrayType* array_type;
		GString* _tmp3_;
		ValaArrayType* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		GString* _tmp14_;
		gint _tmp15_;
		ValaArrayType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		gint _tmp19_;
		GString* _tmp20_;
		_tmp1_ = type;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2_;
		vala_gir_writer_write_indent (self);
		_tmp3_ = self->priv->buffer;
		g_string_append_printf (_tmp3_, "<array");
		_tmp4_ = array_type;
		_tmp5_ = vala_array_type_get_fixed_length (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			GString* _tmp7_;
			ValaArrayType* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			_tmp7_ = self->priv->buffer;
			_tmp8_ = array_type;
			_tmp9_ = vala_array_type_get_length (_tmp8_);
			_tmp10_ = _tmp9_;
			g_string_append_printf (_tmp7_, " fixed-size=\"%i\"", _tmp10_);
		} else {
			gint _tmp11_;
			_tmp11_ = index;
			if (_tmp11_ != (-1)) {
				GString* _tmp12_;
				gint _tmp13_;
				_tmp12_ = self->priv->buffer;
				_tmp13_ = index;
				g_string_append_printf (_tmp12_, " length=\"%i\"", _tmp13_);
			}
		}
		_tmp14_ = self->priv->buffer;
		g_string_append_printf (_tmp14_, ">\n");
		_tmp15_ = self->priv->indent;
		self->priv->indent = _tmp15_ + 1;
		_tmp16_ = array_type;
		_tmp17_ = vala_array_type_get_element_type (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_gir_writer_write_type (self, _tmp18_, -1);
		_tmp19_ = self->priv->indent;
		self->priv->indent = _tmp19_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp20_ = self->priv->buffer;
		g_string_append_printf (_tmp20_, "</array>\n");
		_vala_code_node_unref0 (array_type);
	} else {
		ValaDataType* _tmp21_;
		_tmp21_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_VOID_TYPE)) {
			GString* _tmp22_;
			vala_gir_writer_write_indent (self);
			_tmp22_ = self->priv->buffer;
			g_string_append_printf (_tmp22_, "<type name=\"none\"/>\n");
		} else {
			ValaDataType* _tmp23_;
			_tmp23_ = type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_POINTER_TYPE)) {
				GString* _tmp24_;
				ValaDataType* _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				vala_gir_writer_write_indent (self);
				_tmp24_ = self->priv->buffer;
				_tmp25_ = type;
				_tmp26_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp25_);
				_tmp27_ = _tmp26_;
				g_string_append_printf (_tmp24_, "<type name=\"gpointer\" c:type=\"%s\"/>\n", _tmp27_);
				_g_free0 (_tmp27_);
			} else {
				ValaDataType* _tmp28_;
				ValaTypeSymbol* _tmp29_;
				ValaTypeSymbol* _tmp30_;
				_tmp28_ = type;
				_tmp29_ = vala_data_type_get_data_type (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ != NULL) {
					ValaDataType* _tmp31_;
					ValaTypeSymbol* _tmp32_;
					ValaTypeSymbol* _tmp33_;
					gchar* _tmp34_ = NULL;
					gchar* type_name;
					gboolean is_array;
					gboolean _tmp35_ = FALSE;
					const gchar* _tmp36_;
					gboolean _tmp38_;
					const gchar* _tmp39_ = NULL;
					gboolean _tmp40_;
					GString* _tmp41_;
					const gchar* _tmp42_;
					ValaDataType* _tmp43_;
					ValaTypeSymbol* _tmp44_;
					ValaTypeSymbol* _tmp45_;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_;
					ValaDataType* _tmp48_;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_;
					ValaDataType* _tmp51_;
					ValaList* _tmp52_ = NULL;
					ValaList* type_arguments;
					ValaList* _tmp53_;
					gint _tmp54_;
					gint _tmp55_;
					vala_gir_writer_write_indent (self);
					_tmp31_ = type;
					_tmp32_ = vala_data_type_get_data_type (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = vala_gir_writer_gi_type_name (self, _tmp33_);
					type_name = _tmp34_;
					is_array = FALSE;
					_tmp36_ = type_name;
					if (g_strcmp0 (_tmp36_, "GLib.Array") == 0) {
						_tmp35_ = TRUE;
					} else {
						const gchar* _tmp37_;
						_tmp37_ = type_name;
						_tmp35_ = g_strcmp0 (_tmp37_, "GLib.PtrArray") == 0;
					}
					_tmp38_ = _tmp35_;
					if (_tmp38_) {
						is_array = TRUE;
					}
					_tmp40_ = is_array;
					if (_tmp40_) {
						_tmp39_ = "array";
					} else {
						_tmp39_ = "type";
					}
					_tmp41_ = self->priv->buffer;
					_tmp42_ = _tmp39_;
					_tmp43_ = type;
					_tmp44_ = vala_data_type_get_data_type (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = vala_gir_writer_gi_type_name (self, _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = type;
					_tmp49_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp48_);
					_tmp50_ = _tmp49_;
					g_string_append_printf (_tmp41_, "<%s name=\"%s\" c:type=\"%s\"", _tmp42_, _tmp47_, _tmp50_);
					_g_free0 (_tmp50_);
					_g_free0 (_tmp47_);
					_tmp51_ = type;
					_tmp52_ = vala_data_type_get_type_arguments (_tmp51_);
					type_arguments = _tmp52_;
					_tmp53_ = type_arguments;
					_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
					_tmp55_ = _tmp54_;
					if (_tmp55_ == 0) {
						GString* _tmp56_;
						_tmp56_ = self->priv->buffer;
						g_string_append_printf (_tmp56_, "/>\n");
					} else {
						GString* _tmp57_;
						gint _tmp58_;
						gint _tmp71_;
						const gchar* _tmp72_ = NULL;
						gboolean _tmp73_;
						GString* _tmp74_;
						const gchar* _tmp75_;
						_tmp57_ = self->priv->buffer;
						g_string_append_printf (_tmp57_, ">\n");
						_tmp58_ = self->priv->indent;
						self->priv->indent = _tmp58_ + 1;
						{
							ValaList* _tmp59_;
							ValaList* _tmp60_;
							ValaList* _type_argument_list;
							ValaList* _tmp61_;
							gint _tmp62_;
							gint _tmp63_;
							gint _type_argument_size;
							gint _type_argument_index;
							_tmp59_ = type_arguments;
							_tmp60_ = _vala_iterable_ref0 (_tmp59_);
							_type_argument_list = _tmp60_;
							_tmp61_ = _type_argument_list;
							_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
							_tmp63_ = _tmp62_;
							_type_argument_size = _tmp63_;
							_type_argument_index = -1;
							while (TRUE) {
								gint _tmp64_;
								gint _tmp65_;
								gint _tmp66_;
								ValaList* _tmp67_;
								gint _tmp68_;
								gpointer _tmp69_ = NULL;
								ValaDataType* type_argument;
								ValaDataType* _tmp70_;
								_tmp64_ = _type_argument_index;
								_type_argument_index = _tmp64_ + 1;
								_tmp65_ = _type_argument_index;
								_tmp66_ = _type_argument_size;
								if (!(_tmp65_ < _tmp66_)) {
									break;
								}
								_tmp67_ = _type_argument_list;
								_tmp68_ = _type_argument_index;
								_tmp69_ = vala_list_get (_tmp67_, _tmp68_);
								type_argument = (ValaDataType*) _tmp69_;
								_tmp70_ = type_argument;
								vala_gir_writer_write_type (self, _tmp70_, -1);
								_vala_code_node_unref0 (type_argument);
							}
							_vala_iterable_unref0 (_type_argument_list);
						}
						_tmp71_ = self->priv->indent;
						self->priv->indent = _tmp71_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp73_ = is_array;
						if (_tmp73_) {
							_tmp72_ = "array";
						} else {
							_tmp72_ = "type";
						}
						_tmp74_ = self->priv->buffer;
						_tmp75_ = _tmp72_;
						g_string_append_printf (_tmp74_, "</%s>\n", _tmp75_);
					}
					_vala_iterable_unref0 (type_arguments);
					_g_free0 (type_name);
				} else {
					ValaDataType* _tmp76_;
					_tmp76_ = type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp77_;
						ValaDelegateType* _tmp78_;
						ValaDelegateType* deleg_type;
						GString* _tmp79_;
						ValaDelegateType* _tmp80_;
						ValaDelegate* _tmp81_;
						ValaDelegate* _tmp82_;
						gchar* _tmp83_ = NULL;
						gchar* _tmp84_;
						ValaDataType* _tmp85_;
						gchar* _tmp86_ = NULL;
						gchar* _tmp87_;
						_tmp77_ = type;
						_tmp78_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						deleg_type = _tmp78_;
						vala_gir_writer_write_indent (self);
						_tmp79_ = self->priv->buffer;
						_tmp80_ = deleg_type;
						_tmp81_ = vala_delegate_type_get_delegate_symbol (_tmp80_);
						_tmp82_ = _tmp81_;
						_tmp83_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp82_);
						_tmp84_ = _tmp83_;
						_tmp85_ = type;
						_tmp86_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp85_);
						_tmp87_ = _tmp86_;
						g_string_append_printf (_tmp79_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp84_, _tmp87_);
						_g_free0 (_tmp87_);
						_g_free0 (_tmp84_);
						_vala_code_node_unref0 (deleg_type);
					} else {
						ValaDataType* _tmp88_;
						_tmp88_ = type;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALA_TYPE_GENERIC_TYPE)) {
							GString* _tmp89_;
							vala_gir_writer_write_indent (self);
							_tmp89_ = self->priv->buffer;
							g_string_append (_tmp89_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
						} else {
							GString* _tmp90_;
							ValaDataType* _tmp91_;
							gchar* _tmp92_ = NULL;
							gchar* _tmp93_;
							vala_gir_writer_write_indent (self);
							_tmp90_ = self->priv->buffer;
							_tmp91_ = type;
							_tmp92_ = vala_code_node_to_string ((ValaCodeNode*) _tmp91_);
							_tmp93_ = _tmp92_;
							g_string_append_printf (_tmp90_, "<type name=\"%s\"/>\n", _tmp93_);
							_g_free0 (_tmp93_);
						}
					}
				}
			}
		}
	}
}


static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node) {
	ValaCodeNode* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->attributes;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp1_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			ValaAttribute* _tmp2_;
			ValaAttribute* attr = NULL;
			_tmp2_ = _vala_code_node_ref0 ((ValaAttribute*) attr_it->data);
			attr = _tmp2_;
			{
				ValaAttribute* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* name;
				_tmp3_ = attr;
				_tmp4_ = vala_attribute_get_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = vala_gir_writer_camel_case_to_canonical (self, _tmp5_);
				name = _tmp6_;
				{
					ValaAttribute* _tmp7_;
					ValaMap* _tmp8_;
					ValaSet* _tmp9_ = NULL;
					ValaSet* _tmp10_;
					ValaIterator* _tmp11_ = NULL;
					ValaIterator* _tmp12_;
					ValaIterator* _arg_name_it;
					_tmp7_ = attr;
					_tmp8_ = _tmp7_->args;
					_tmp9_ = vala_map_get_keys (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = vala_iterable_iterator ((ValaIterable*) _tmp10_);
					_tmp12_ = _tmp11_;
					_vala_iterable_unref0 (_tmp10_);
					_arg_name_it = _tmp12_;
					while (TRUE) {
						ValaIterator* _tmp13_;
						gboolean _tmp14_ = FALSE;
						ValaIterator* _tmp15_;
						gpointer _tmp16_ = NULL;
						gchar* arg_name;
						ValaAttribute* _tmp17_;
						ValaMap* _tmp18_;
						const gchar* _tmp19_;
						gpointer _tmp20_ = NULL;
						gchar* value;
						const gchar* _tmp21_;
						gboolean _tmp22_ = FALSE;
						GString* _tmp26_;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_ = NULL;
						gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp13_ = _arg_name_it;
						_tmp14_ = vala_iterator_next (_tmp13_);
						if (!_tmp14_) {
							break;
						}
						_tmp15_ = _arg_name_it;
						_tmp16_ = vala_iterator_get (_tmp15_);
						arg_name = (gchar*) _tmp16_;
						_tmp17_ = attr;
						_tmp18_ = _tmp17_->args;
						_tmp19_ = arg_name;
						_tmp20_ = vala_map_get (_tmp18_, _tmp19_);
						value = (gchar*) _tmp20_;
						_tmp21_ = value;
						_tmp22_ = g_str_has_prefix (_tmp21_, "\"");
						if (_tmp22_) {
							ValaAttribute* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_ = NULL;
							_tmp23_ = attr;
							_tmp24_ = arg_name;
							_tmp25_ = vala_attribute_get_string (_tmp23_, _tmp24_);
							_g_free0 (value);
							value = _tmp25_;
						}
						vala_gir_writer_write_indent (self);
						_tmp26_ = self->priv->buffer;
						_tmp27_ = name;
						_tmp28_ = arg_name;
						_tmp29_ = vala_gir_writer_camel_case_to_canonical (self, _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = value;
						g_string_append_printf (_tmp26_, "<annotation key=\"%s.%s\" value=\"%s\"/>\n", _tmp27_, _tmp30_, _tmp31_);
						_g_free0 (_tmp30_);
						_g_free0 (value);
						_g_free0 (arg_name);
					}
					_vala_iterator_unref0 (_arg_name_it);
				}
				_g_free0 (name);
				_vala_code_node_unref0 (attr);
			}
		}
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self, ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* gir_name;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	ValaSymbol* _tmp20_;
	ValaSymbol* _tmp21_;
	ValaSymbol* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* parent_gir_name;
	const gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* self_gir_name;
	const gchar* _tmp34_;
	gboolean _tmp35_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "GIR", "name");
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSymbol* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp7_;
	}
	_tmp8_ = _tmp2_;
	_tmp9_ = g_strdup (_tmp8_);
	gir_name = _tmp9_;
	_tmp10_ = sym;
	_tmp11_ = vala_symbol_get_parent_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == NULL) {
		result = gir_name;
		_g_free0 (_tmp2_);
		return result;
	}
	_tmp13_ = sym;
	_tmp14_ = vala_symbol_get_name (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == NULL) {
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gchar* _tmp19_ = NULL;
		_tmp16_ = sym;
		_tmp17_ = vala_symbol_get_parent_symbol (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_gir_writer_get_full_gir_name (self, _tmp18_);
		result = _tmp19_;
		_g_free0 (gir_name);
		_g_free0 (_tmp2_);
		return result;
	}
	_tmp20_ = sym;
	_tmp21_ = vala_symbol_get_parent_symbol (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_gir_writer_get_full_gir_name (self, _tmp22_);
	parent_gir_name = _tmp23_;
	_tmp24_ = parent_gir_name;
	if (_tmp24_ == NULL) {
		result = gir_name;
		_g_free0 (parent_gir_name);
		_g_free0 (_tmp2_);
		return result;
	}
	_tmp26_ = gir_name;
	_tmp27_ = g_str_has_prefix (_tmp26_, ".");
	if (_tmp27_) {
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		_tmp28_ = gir_name;
		_tmp29_ = string_substring (_tmp28_, (glong) 1, (glong) (-1));
		_g_free0 (_tmp25_);
		_tmp25_ = _tmp29_;
	} else {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = gir_name;
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (_tmp25_);
		_tmp25_ = _tmp31_;
	}
	_tmp32_ = _tmp25_;
	_tmp33_ = g_strdup (_tmp32_);
	self_gir_name = _tmp33_;
	_tmp34_ = parent_gir_name;
	_tmp35_ = string_contains (_tmp34_, ".");
	if (_tmp35_) {
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_ = NULL;
		_tmp36_ = parent_gir_name;
		_tmp37_ = self_gir_name;
		_tmp38_ = g_strdup_printf ("%s%s", _tmp36_, _tmp37_);
		result = _tmp38_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp25_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (_tmp2_);
		return result;
	} else {
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_ = NULL;
		_tmp39_ = parent_gir_name;
		_tmp40_ = self_gir_name;
		_tmp41_ = g_strdup_printf ("%s.%s", _tmp39_, _tmp40_);
		result = _tmp41_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp25_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (_tmp2_);
		return result;
	}
	_g_free0 (self_gir_name);
	_g_free0 (_tmp25_);
	_g_free0 (parent_gir_name);
	_g_free0 (gir_name);
	_g_free0 (_tmp2_);
}


static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol) {
	gchar* result = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* parent;
	ValaSymbol* _tmp4_;
	ValaTypeSymbol* _tmp65_;
	gchar* _tmp66_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	_tmp0_ = type_symbol;
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	parent = _tmp3_;
	_tmp4_ = parent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp5_;
		ValaNamespace* _tmp6_;
		ValaNamespace* ns;
		ValaNamespace* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* ns_gir_name;
		const gchar* _tmp17_;
		_tmp5_ = parent;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_NAMESPACE) ? ((ValaNamespace*) _tmp5_) : NULL);
		ns = _tmp6_;
		_tmp7_ = ns;
		_tmp8_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp7_, "GIR", "name");
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NULL) {
			ValaNamespace* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = ns;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (_tmp9_);
			_tmp9_ = _tmp14_;
		}
		_tmp15_ = _tmp9_;
		_tmp16_ = g_strdup (_tmp15_);
		ns_gir_name = _tmp16_;
		_tmp17_ = ns_gir_name;
		if (_tmp17_ != NULL) {
			ValaTypeSymbol* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaSourceFile* _tmp21_;
			ValaSourceFile* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp18_ = type_symbol;
			_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_source_reference_get_file (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_source_file_get_gir_namespace (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ != NULL) {
				ValaTypeSymbol* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaSourceReference* _tmp27_;
				ValaSourceFile* _tmp28_;
				ValaSourceFile* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				ValaTypeSymbol* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaSourceFile* _tmp35_;
				ValaSourceFile* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				ValaGIRWriterGIRNamespace external = {0};
				ValaArrayList* _tmp39_;
				ValaGIRWriterGIRNamespace _tmp40_;
				gboolean _tmp41_ = FALSE;
				ValaTypeSymbol* _tmp44_;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* type_name;
				ValaTypeSymbol* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceFile* _tmp57_;
				ValaSourceFile* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				gchar* _tmp62_ = NULL;
				_tmp25_ = type_symbol;
				_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_source_reference_get_file (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_source_file_get_gir_namespace (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = type_symbol;
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_source_reference_get_file (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_source_file_get_gir_version (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_gir_writer_gir_namespace_init (&external, _tmp31_, _tmp38_);
				_tmp39_ = self->priv->externals;
				_tmp40_ = external;
				_tmp41_ = vala_collection_contains ((ValaCollection*) _tmp39_, &_tmp40_);
				if (!_tmp41_) {
					ValaArrayList* _tmp42_;
					ValaGIRWriterGIRNamespace _tmp43_;
					_tmp42_ = self->priv->externals;
					_tmp43_ = external;
					vala_collection_add ((ValaCollection*) _tmp42_, &_tmp43_);
				}
				_tmp44_ = type_symbol;
				_tmp45_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp44_, "GIR", "name");
				_tmp46_ = _tmp45_;
				_tmp47_ = _tmp46_;
				if (_tmp47_ == NULL) {
					ValaTypeSymbol* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = type_symbol;
					_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup (_tmp50_);
					_g_free0 (_tmp46_);
					_tmp46_ = _tmp51_;
				}
				_tmp52_ = _tmp46_;
				_tmp53_ = g_strdup (_tmp52_);
				type_name = _tmp53_;
				_tmp54_ = type_symbol;
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_source_reference_get_file (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_source_file_get_gir_namespace (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = type_name;
				_tmp62_ = g_strdup_printf ("%s.%s", _tmp60_, _tmp61_);
				result = _tmp62_;
				_g_free0 (type_name);
				_g_free0 (_tmp46_);
				vala_gir_writer_gir_namespace_destroy (&external);
				_g_free0 (ns_gir_name);
				_g_free0 (_tmp9_);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (parent);
				return result;
			} else {
				ValaHashSet* _tmp63_;
				ValaNamespace* _tmp64_;
				_tmp63_ = self->priv->unannotated_namespaces;
				_tmp64_ = ns;
				vala_collection_add ((ValaCollection*) _tmp63_, _tmp64_);
			}
		}
		_g_free0 (ns_gir_name);
		_g_free0 (_tmp9_);
		_vala_code_node_unref0 (ns);
	}
	_tmp65_ = type_symbol;
	_tmp66_ = vala_gir_writer_get_full_gir_name (self, (ValaSymbol*) _tmp65_);
	result = _tmp66_;
	_vala_code_node_unref0 (parent);
	return result;
}


static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal) {
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	_tmp0_ = literal;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRING_LITERAL)) {
		ValaExpression* _tmp1_;
		ValaStringLiteral* _tmp2_;
		ValaStringLiteral* lit;
		ValaStringLiteral* _tmp3_;
		_tmp1_ = literal;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_STRING_LITERAL) ? ((ValaStringLiteral*) _tmp1_) : NULL);
		lit = _tmp2_;
		_tmp3_ = lit;
		if (_tmp3_ != NULL) {
			ValaStringLiteral* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp4_ = lit;
			_tmp5_ = vala_string_literal_eval (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) (-1));
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			result = _tmp8_;
			_vala_code_node_unref0 (lit);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaExpression* _tmp9_;
		_tmp9_ = literal;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_CHARACTER_LITERAL)) {
			ValaExpression* _tmp10_;
			gunichar _tmp11_ = 0U;
			gchar* _tmp12_ = NULL;
			_tmp10_ = literal;
			_tmp11_ = vala_character_literal_get_char (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral));
			_tmp12_ = g_strdup_printf ("%c", (gint) ((gchar) _tmp11_));
			result = _tmp12_;
			return result;
		} else {
			ValaExpression* _tmp13_;
			_tmp13_ = literal;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_BOOLEAN_LITERAL)) {
				const gchar* _tmp14_ = NULL;
				ValaExpression* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp15_ = literal;
				_tmp16_ = vala_boolean_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral));
				_tmp17_ = _tmp16_;
				if (_tmp17_) {
					_tmp14_ = "true";
				} else {
					_tmp14_ = "false";
				}
				_tmp18_ = _tmp14_;
				_tmp19_ = g_strdup (_tmp18_);
				result = _tmp19_;
				return result;
			} else {
				ValaExpression* _tmp20_;
				_tmp20_ = literal;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_REAL_LITERAL)) {
					ValaExpression* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp21_ = literal;
					_tmp22_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strdup (_tmp23_);
					result = _tmp24_;
					return result;
				} else {
					ValaExpression* _tmp25_;
					_tmp25_ = literal;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_INTEGER_LITERAL)) {
						ValaExpression* _tmp26_;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp26_ = literal;
						_tmp27_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
						_tmp28_ = _tmp27_;
						_tmp29_ = g_strdup (_tmp28_);
						result = _tmp29_;
						return result;
					} else {
						ValaExpression* _tmp30_;
						_tmp30_ = literal;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_UNARY_EXPRESSION)) {
							ValaExpression* _tmp31_;
							ValaUnaryExpression* _tmp32_;
							ValaUnaryExpression* unary;
							ValaUnaryExpression* _tmp33_;
							ValaUnaryOperator _tmp34_;
							ValaUnaryOperator _tmp35_;
							_tmp31_ = literal;
							_tmp32_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
							unary = _tmp32_;
							_tmp33_ = unary;
							_tmp34_ = vala_unary_expression_get_operator (_tmp33_);
							_tmp35_ = _tmp34_;
							if (_tmp35_ == VALA_UNARY_OPERATOR_MINUS) {
								ValaUnaryExpression* _tmp36_;
								ValaExpression* _tmp37_;
								ValaExpression* _tmp38_;
								_tmp36_ = unary;
								_tmp37_ = vala_unary_expression_get_inner (_tmp36_);
								_tmp38_ = _tmp37_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, VALA_TYPE_REAL_LITERAL)) {
									ValaUnaryExpression* _tmp39_;
									ValaExpression* _tmp40_;
									ValaExpression* _tmp41_;
									const gchar* _tmp42_;
									const gchar* _tmp43_;
									gchar* _tmp44_;
									_tmp39_ = unary;
									_tmp40_ = vala_unary_expression_get_inner (_tmp39_);
									_tmp41_ = _tmp40_;
									_tmp42_ = vala_real_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_REAL_LITERAL, ValaRealLiteral));
									_tmp43_ = _tmp42_;
									_tmp44_ = g_strconcat ("-", _tmp43_, NULL);
									result = _tmp44_;
									_vala_code_node_unref0 (unary);
									return result;
								} else {
									ValaUnaryExpression* _tmp45_;
									ValaExpression* _tmp46_;
									ValaExpression* _tmp47_;
									_tmp45_ = unary;
									_tmp46_ = vala_unary_expression_get_inner (_tmp45_);
									_tmp47_ = _tmp46_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_INTEGER_LITERAL)) {
										ValaUnaryExpression* _tmp48_;
										ValaExpression* _tmp49_;
										ValaExpression* _tmp50_;
										const gchar* _tmp51_;
										const gchar* _tmp52_;
										gchar* _tmp53_;
										_tmp48_ = unary;
										_tmp49_ = vala_unary_expression_get_inner (_tmp48_);
										_tmp50_ = _tmp49_;
										_tmp51_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
										_tmp52_ = _tmp51_;
										_tmp53_ = g_strconcat ("-", _tmp52_, NULL);
										result = _tmp53_;
										_vala_code_node_unref0 (unary);
										return result;
									}
								}
							}
							_vala_code_node_unref0 (unary);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "_", 0);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_free0 (_tmp2_);
	parts = _tmp5_;
	parts_length1 = _tmp5__length1;
	_parts_size_ = parts_length1;
	_tmp6_ = g_strjoinv ("-", parts);
	result = _tmp6_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = sym;
	_tmp2_ = vala_symbol_get_access (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp4_;
		ValaSymbolAccessibility _tmp5_;
		ValaSymbolAccessibility _tmp6_;
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_access (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


ValaGIRWriter* vala_gir_writer_construct (GType object_type) {
	ValaGIRWriter* self = NULL;
	self = (ValaGIRWriter*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIRWriter* vala_gir_writer_new (void) {
	return vala_gir_writer_construct (VALA_TYPE_GIR_WRITER);
}


static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (ns != NULL);
	g_return_if_fail (version != NULL);
	memset (self, 0, sizeof (ValaGIRWriterGIRNamespace));
	_tmp0_ = ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).ns);
	(*self).ns = _tmp1_;
	_tmp2_ = version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*self).version);
	(*self).version = _tmp3_;
}


static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaGIRWriterGIRNamespace _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	g_return_val_if_fail (g != NULL, FALSE);
	_tmp1_ = (*self).ns;
	_tmp2_ = *g;
	_tmp3_ = _tmp2_.ns;
	if (g_strcmp0 (_tmp1_, _tmp3_) == 0) {
		const gchar* _tmp4_;
		ValaGIRWriterGIRNamespace _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = (*self).version;
		_tmp5_ = *g;
		_tmp6_ = _tmp5_.version;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).ns);
	(*dest).ns = _tmp1_;
	_tmp2_ = (*self).version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).version);
	(*dest).version = _tmp3_;
}


static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self) {
	_g_free0 ((*self).ns);
	_g_free0 ((*self).version);
}


static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self) {
	ValaGIRWriterGIRNamespace* dup;
	dup = g_new0 (ValaGIRWriterGIRNamespace, 1);
	vala_gir_writer_gir_namespace_copy (self, dup);
	return dup;
}


static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self) {
	vala_gir_writer_gir_namespace_destroy (self);
	g_free (self);
}


static GType vala_gir_writer_gir_namespace_get_type (void) {
	static volatile gsize vala_gir_writer_gir_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_gir_namespace_type_id__volatile)) {
		GType vala_gir_writer_gir_namespace_type_id;
		vala_gir_writer_gir_namespace_type_id = g_boxed_type_register_static ("ValaGIRWriterGIRNamespace", (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GBoxedFreeFunc) vala_gir_writer_gir_namespace_free);
		g_once_init_leave (&vala_gir_writer_gir_namespace_type_id__volatile, vala_gir_writer_gir_namespace_type_id);
	}
	return vala_gir_writer_gir_namespace_type_id__volatile;
}


static void vala_gir_writer_class_init (ValaGIRWriterClass * klass) {
	vala_gir_writer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gir_writer_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIRWriterPrivate));
	VALA_GIR_WRITER_CLASS (klass)->get_interface_comment = vala_gir_writer_real_get_interface_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_struct_comment = vala_gir_writer_real_get_struct_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_enum_comment = vala_gir_writer_real_get_enum_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_class_comment = vala_gir_writer_real_get_class_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_error_code_comment = vala_gir_writer_real_get_error_code_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_enum_value_comment = vala_gir_writer_real_get_enum_value_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_constant_comment = vala_gir_writer_real_get_constant_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_error_domain_comment = vala_gir_writer_real_get_error_domain_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_field_comment = vala_gir_writer_real_get_field_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_delegate_comment = vala_gir_writer_real_get_delegate_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_method_comment = vala_gir_writer_real_get_method_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_property_comment = vala_gir_writer_real_get_property_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_delegate_return_comment = vala_gir_writer_real_get_delegate_return_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_signal_return_comment = vala_gir_writer_real_get_signal_return_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_method_return_comment = vala_gir_writer_real_get_method_return_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_signal_comment = vala_gir_writer_real_get_signal_comment;
	VALA_GIR_WRITER_CLASS (klass)->get_parameter_comment = vala_gir_writer_real_get_parameter_comment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gir_writer_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gir_writer_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gir_writer_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gir_writer_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gir_writer_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_gir_writer_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gir_writer_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = vala_gir_writer_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_gir_writer_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_gir_writer_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gir_writer_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_gir_writer_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_gir_writer_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_gir_writer_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_gir_writer_real_visit_signal;
}


static void vala_gir_writer_instance_init (ValaGIRWriter * self) {
	GString* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaArrayList* _tmp11_;
	self->priv = VALA_GIR_WRITER_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->buffer = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp1_, _tmp2_);
	self->priv->unannotated_namespaces = _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp4_, _tmp5_);
	self->priv->our_namespaces = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp7_);
	self->priv->hierarchy = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp9_);
	self->priv->deferred = _tmp10_;
	_tmp11_ = vala_array_list_new (VALA_GIR_WRITER_TYPE_GIR_NAMESPACE, (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, vala_gir_writer_gir_namespace_free, (GEqualFunc) vala_gir_writer_gir_namespace_equal);
	self->priv->externals = _tmp11_;
}


static void vala_gir_writer_finalize (ValaCodeVisitor* obj) {
	ValaGIRWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_WRITER, ValaGIRWriter);
	_vala_code_context_unref0 (self->priv->context);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->gir_namespace);
	_g_free0 (self->priv->gir_version);
	_g_string_free0 (self->priv->buffer);
	_fclose0 (self->priv->stream);
	_vala_iterable_unref0 (self->priv->unannotated_namespaces);
	_vala_iterable_unref0 (self->priv->our_namespaces);
	_vala_iterable_unref0 (self->priv->hierarchy);
	_vala_iterable_unref0 (self->priv->deferred);
	_vala_code_node_unref0 (self->priv->gobject_type);
	_vala_code_node_unref0 (self->priv->ginitiallyunowned_type);
	_vala_iterable_unref0 (self->priv->externals);
	VALA_CODE_VISITOR_CLASS (vala_gir_writer_parent_class)->finalize (obj);
}


/**
 * Code visitor generating .gir file for the public interface.
 */
GType vala_gir_writer_get_type (void) {
	static volatile gsize vala_gir_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIRWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIRWriter), 0, (GInstanceInitFunc) vala_gir_writer_instance_init, NULL };
		GType vala_gir_writer_type_id;
		vala_gir_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIRWriter", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_writer_type_id__volatile, vala_gir_writer_type_id);
	}
	return vala_gir_writer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



