// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_FILEATTRIBUTEINFO_H
#define _GIOMM_FILEATTRIBUTEINFO_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string>
#include <gio/gio.h> //TODO: avoid this include
#include <glibmm/object.h>


namespace Gio
{

//TODO: Fix the need for NO_GTYPE.
//It guesses gfile_attribute_type_get_type() instead of g_file_attribute_type_get_type(). murrayc.
/** @addtogroup giommEnums giomm Enums and Flags */

/** 
 * The data types for file attributes.
 * @ingroup giommEnums
 */
enum FileAttributeType
{
  /** indicates an invalid or uninitalized type.
   */
  FILE_ATTRIBUTE_TYPE_INVALID,
  /** a null terminated UTF8 string.
   */
  FILE_ATTRIBUTE_TYPE_STRING,
  /** a zero terminated string of non-zero bytes.
   */
  FILE_ATTRIBUTE_TYPE_BYTE_STRING,
  /** a boolean value.
   */
  FILE_ATTRIBUTE_TYPE_BOOLEAN,
  /** an unsigned 4-byte/32-bit integer.
   */
  FILE_ATTRIBUTE_TYPE_UINT32,
  /** a signed 4-byte/32-bit integer.
   */
  FILE_ATTRIBUTE_TYPE_INT32,
  /** an unsigned 8-byte/64-bit integer.
   */
  FILE_ATTRIBUTE_TYPE_UINT64,
  /** a signed 8-byte/64-bit integer.
   */
  FILE_ATTRIBUTE_TYPE_INT64,
  /** a Object.
   */
  FILE_ATTRIBUTE_TYPE_OBJECT,
  /** a <tt>0</tt> terminated char **. @newin{2,22}
   */
  FILE_ATTRIBUTE_TYPE_STRINGV
};


/** 
 * Flags specifying the behaviour of an attribute.
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%FileAttributeInfoFlags operator|(FileAttributeInfoFlags, FileAttributeInfoFlags)</tt><br>
 * <tt>%FileAttributeInfoFlags operator&(FileAttributeInfoFlags, FileAttributeInfoFlags)</tt><br>
 * <tt>%FileAttributeInfoFlags operator^(FileAttributeInfoFlags, FileAttributeInfoFlags)</tt><br>
 * <tt>%FileAttributeInfoFlags operator~(FileAttributeInfoFlags)</tt><br>
 * <tt>%FileAttributeInfoFlags& operator|=(FileAttributeInfoFlags&, FileAttributeInfoFlags)</tt><br>
 * <tt>%FileAttributeInfoFlags& operator&=(FileAttributeInfoFlags&, FileAttributeInfoFlags)</tt><br>
 * <tt>%FileAttributeInfoFlags& operator^=(FileAttributeInfoFlags&, FileAttributeInfoFlags)</tt><br>
 */
enum FileAttributeInfoFlags
{
  /** no flags set.
   */
  FILE_ATTRIBUTE_INFO_NONE = 0x0,
  /** copy the attribute values when the file is copied.
   */
  FILE_ATTRIBUTE_INFO_COPY_WITH_FILE = (1 << 0),
  /** copy the attribute values when the file is moved.
   */
  FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED = (1 << 1)
};

/** @ingroup giommEnums */
inline FileAttributeInfoFlags operator|(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)
  { return static_cast<FileAttributeInfoFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline FileAttributeInfoFlags operator&(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)
  { return static_cast<FileAttributeInfoFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline FileAttributeInfoFlags operator^(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)
  { return static_cast<FileAttributeInfoFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline FileAttributeInfoFlags operator~(FileAttributeInfoFlags flags)
  { return static_cast<FileAttributeInfoFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline FileAttributeInfoFlags& operator|=(FileAttributeInfoFlags& lhs, FileAttributeInfoFlags rhs)
  { return (lhs = static_cast<FileAttributeInfoFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline FileAttributeInfoFlags& operator&=(FileAttributeInfoFlags& lhs, FileAttributeInfoFlags rhs)
  { return (lhs = static_cast<FileAttributeInfoFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline FileAttributeInfoFlags& operator^=(FileAttributeInfoFlags& lhs, FileAttributeInfoFlags rhs)
  { return (lhs = static_cast<FileAttributeInfoFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** 
 * Used by g_file_set_attributes_from_info() when setting file attributes.
 * @ingroup giommEnums
 */
enum FileAttributeStatus
{
  /** Attribute value is unset (empty).
   */
  FILE_ATTRIBUTE_STATUS_UNSET,
  /** Attribute value is set.
   */
  FILE_ATTRIBUTE_STATUS_SET,
  /** Indicates an error in setting the value.
   */
  FILE_ATTRIBUTE_STATUS_ERROR_SETTING
};


/** Information about a specific attribute - see FileAttributeInfoList.
 *
 * @newin{2,16}
 */
class FileAttributeInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileAttributeInfo CppObjectType;
  typedef GFileAttributeInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
  explicit FileAttributeInfo(const GFileAttributeInfo* ginfo);

  FileAttributeInfo(const FileAttributeInfo& other);
  FileAttributeInfo& operator=(const FileAttributeInfo& other);

  ~FileAttributeInfo();

  std::string get_name() const;
  FileAttributeType get_type() const;
  FileAttributeInfoFlags get_flags() const;

protected:
  std::string m_name;
  FileAttributeType m_type;
  FileAttributeInfoFlags m_flags;


};

} // namespace Gio


#endif /* _GIOMM_FILEATTRIBUTEINFO_H */

