/* arraylist.c generated by valac 0.18.0.32-44bf7, the Vala compiler
 * generated from arraylist.vala, do not modify */

/* arraylist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;

#define GEE_ARRAY_LIST_TYPE_ITERATOR (gee_array_list_iterator_get_type ())
#define GEE_ARRAY_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator))
#define GEE_ARRAY_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorClass))
#define GEE_ARRAY_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR))
#define GEE_ARRAY_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ARRAY_LIST_TYPE_ITERATOR))
#define GEE_ARRAY_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorClass))

typedef struct _GeeArrayListIterator GeeArrayListIterator;
typedef struct _GeeArrayListIteratorClass GeeArrayListIteratorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeArrayListIteratorPrivate GeeArrayListIteratorPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*insert) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareFunc compare_func);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeArrayList {
	GeeAbstractList parent_instance;
	GeeArrayListPrivate * priv;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _size;
};

struct _GeeArrayListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeArrayListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GEqualFunc _equal_func;
	gint _stamp;
};

struct _GeeArrayListIterator {
	GObject parent_instance;
	GeeArrayListIteratorPrivate * priv;
};

struct _GeeArrayListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeArrayListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayList* _list;
	gint _index;
	gboolean _removed;
	gint _stamp;
};


static gpointer gee_array_list_parent_class = NULL;
static gpointer gee_array_list_iterator_parent_class = NULL;
static GeeIteratorIface* gee_array_list_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_array_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeListIteratorIface* gee_array_list_iterator_gee_list_iterator_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_array_list_get_type (void) G_GNUC_CONST;
#define GEE_ARRAY_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ARRAY_LIST, GeeArrayListPrivate))
enum  {
	GEE_ARRAY_LIST_DUMMY_PROPERTY,
	GEE_ARRAY_LIST_G_TYPE,
	GEE_ARRAY_LIST_G_DUP_FUNC,
	GEE_ARRAY_LIST_G_DESTROY_FUNC,
	GEE_ARRAY_LIST_SIZE,
	GEE_ARRAY_LIST_EQUAL_FUNC
};
GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeAbstractList* gee_abstract_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GEqualFunc gee_functions_get_equal_func_for (GType t);
static void gee_array_list_set_equal_func (GeeArrayList* self, GEqualFunc value);
static GeeIterator* gee_array_list_real_iterator (GeeAbstractCollection* base);
static GeeArrayListIterator* gee_array_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list);
static GeeArrayListIterator* gee_array_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list);
static GType gee_array_list_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeListIterator* gee_array_list_real_list_iterator (GeeAbstractList* base);
static gboolean gee_array_list_real_contains (GeeAbstractCollection* base, gconstpointer item);
gint gee_abstract_list_index_of (GeeAbstractList* self, gconstpointer item);
static gint gee_array_list_real_index_of (GeeAbstractList* base, gconstpointer item);
GEqualFunc gee_array_list_get_equal_func (GeeArrayList* self);
static gpointer gee_array_list_real_get (GeeAbstractList* base, gint index);
static void gee_array_list_real_set (GeeAbstractList* base, gint index, gconstpointer item);
static gboolean gee_array_list_real_add (GeeAbstractCollection* base, gconstpointer item);
static void gee_array_list_grow_if_needed (GeeArrayList* self, gint new_count);
static void gee_array_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
static void gee_array_list_shift (GeeArrayList* self, gint start, gint delta);
static gboolean gee_array_list_real_remove (GeeAbstractCollection* base, gconstpointer item);
gpointer gee_abstract_list_remove_at (GeeAbstractList* self, gint index);
static gpointer gee_array_list_real_remove_at (GeeAbstractList* base, gint index);
static void gee_array_list_real_clear (GeeAbstractCollection* base);
static GeeList* gee_array_list_real_slice (GeeAbstractList* base, gint start, gint stop);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
gpointer gee_abstract_list_get (GeeAbstractList* self, gint index);
static gboolean gee_array_list_real_add_all (GeeAbstractCollection* base, GeeCollection* collection);
gboolean gee_collection_get_is_empty (GeeCollection* self);
gint gee_collection_get_size (GeeCollection* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
void gee_array_list_sort_with_data (GeeArrayList* self, GCompareDataFunc compare, void* compare_target);
void gee_tim_sort_sort_with_data (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare_data, void* compare_data_target);
static void gee_array_list_set_capacity (GeeArrayList* self, gint value);
#define GEE_ARRAY_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorPrivate))
enum  {
	GEE_ARRAY_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_ARRAY_LIST_ITERATOR_G_TYPE,
	GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC,
	GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_array_list_iterator_real_next (GeeIterator* base);
static gboolean gee_array_list_iterator_real_has_next (GeeIterator* base);
static gboolean gee_array_list_iterator_real_first (GeeIterator* base);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static gpointer gee_array_list_iterator_real_get (GeeIterator* base);
static void gee_array_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_array_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_array_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_array_list_iterator_real_last (GeeBidirIterator* base);
static void gee_array_list_iterator_real_set (GeeListIterator* base, gconstpointer item);
static void gee_array_list_iterator_real_insert (GeeListIterator* base, gconstpointer item);
void gee_abstract_list_insert (GeeAbstractList* self, gint index, gconstpointer item);
static void gee_array_list_iterator_real_add (GeeListIterator* base, gconstpointer item);
static gint gee_array_list_iterator_real_index (GeeListIterator* base);
static void gee_array_list_iterator_finalize (GObject* obj);
static void _vala_gee_array_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_array_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_array_list_finalize (GObject* obj);
static void _vala_gee_array_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_array_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);


/**
 * Constructs a new, empty array list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	GeeArrayList * self = NULL;
	GEqualFunc _tmp0_;
	GEqualFunc _tmp2_;
	self = (GeeArrayList*) gee_abstract_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = equal_func;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_ = NULL;
		_tmp1_ = gee_functions_get_equal_func_for (g_type);
		equal_func = _tmp1_;
	}
	_tmp2_ = equal_func;
	gee_array_list_set_equal_func (self, _tmp2_);
	return self;
}


GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	return gee_array_list_construct (GEE_TYPE_ARRAY_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_array_list_real_iterator (GeeAbstractCollection* base) {
	GeeArrayList * self;
	GeeIterator* result = NULL;
	GeeArrayListIterator* _tmp0_;
	self = (GeeArrayList*) base;
	_tmp0_ = gee_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeListIterator* gee_array_list_real_list_iterator (GeeAbstractList* base) {
	GeeArrayList * self;
	GeeListIterator* result = NULL;
	GeeArrayListIterator* _tmp0_;
	self = (GeeArrayList*) base;
	_tmp0_ = gee_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeListIterator*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_list_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayList * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gint _tmp1_ = 0;
	self = (GeeArrayList*) base;
	_tmp0_ = item;
	_tmp1_ = gee_abstract_list_index_of ((GeeAbstractList*) self, _tmp0_);
	result = _tmp1_ != (-1);
	return result;
}


/**
 * {@inheritDoc}
 */
static gint gee_array_list_real_index_of (GeeAbstractList* base, gconstpointer item) {
	GeeArrayList * self;
	gint result = 0;
	self = (GeeArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				GEqualFunc _tmp5_;
				GEqualFunc _tmp6_;
				gpointer* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				gconstpointer _tmp9_;
				gconstpointer _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = index;
					index = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = index;
				_tmp4_ = self->_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = gee_array_list_get_equal_func (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = self->_items;
				_tmp7__length1 = self->_items_length1;
				_tmp8_ = index;
				_tmp9_ = _tmp7_[_tmp8_];
				_tmp10_ = item;
				_tmp11_ = _tmp6_ (_tmp9_, _tmp10_);
				if (_tmp11_) {
					result = index;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_list_real_get (GeeAbstractList* base, gint index) {
	GeeArrayList * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
	self = (GeeArrayList*) base;
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= 0, "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->_size;
	_vala_assert (_tmp1_ < _tmp2_, "index < _size");
	_tmp3_ = self->_items;
	_tmp3__length1 = self->_items_length1;
	_tmp4_ = index;
	_tmp5_ = _tmp3_[_tmp4_];
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	result = _tmp6_;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_array_list_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeArrayList * self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
	gpointer _tmp7_;
	self = (GeeArrayList*) base;
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= 0, "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->_size;
	_vala_assert (_tmp1_ < _tmp2_, "index < _size");
	_tmp3_ = self->_items;
	_tmp3__length1 = self->_items_length1;
	_tmp4_ = index;
	_tmp5_ = item;
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	((_tmp3_[_tmp4_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_[_tmp4_] = (self->priv->g_destroy_func (_tmp3_[_tmp4_]), NULL));
	_tmp3_[_tmp4_] = _tmp6_;
	_tmp7_ = _tmp3_[_tmp4_];
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_list_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayList * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	gpointer _tmp6_;
	gint _tmp7_;
	self = (GeeArrayList*) base;
	_tmp0_ = self->_size;
	_tmp1_ = self->_items;
	_tmp1__length1 = self->_items_length1;
	if (_tmp0_ == _tmp1__length1) {
		gee_array_list_grow_if_needed (self, 1);
	}
	_tmp2_ = self->_items;
	_tmp2__length1 = self->_items_length1;
	_tmp3_ = self->_size;
	self->_size = _tmp3_ + 1;
	_tmp4_ = item;
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
	((_tmp2_[_tmp3_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp2_[_tmp3_] = (self->priv->g_destroy_func (_tmp2_[_tmp3_]), NULL));
	_tmp2_[_tmp3_] = _tmp5_;
	_tmp6_ = _tmp2_[_tmp3_];
	_tmp7_ = self->priv->_stamp;
	self->priv->_stamp = _tmp7_ + 1;
	result = TRUE;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_array_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeArrayList * self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	gconstpointer _tmp8_;
	gpointer _tmp9_;
	gpointer _tmp10_;
	gint _tmp11_;
	self = (GeeArrayList*) base;
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= 0, "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->_size;
	_vala_assert (_tmp1_ <= _tmp2_, "index <= _size");
	_tmp3_ = self->_size;
	_tmp4_ = self->_items;
	_tmp4__length1 = self->_items_length1;
	if (_tmp3_ == _tmp4__length1) {
		gee_array_list_grow_if_needed (self, 1);
	}
	_tmp5_ = index;
	gee_array_list_shift (self, _tmp5_, 1);
	_tmp6_ = self->_items;
	_tmp6__length1 = self->_items_length1;
	_tmp7_ = index;
	_tmp8_ = item;
	_tmp9_ = ((_tmp8_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp8_) : ((gpointer) _tmp8_);
	((_tmp6_[_tmp7_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp6_[_tmp7_] = (self->priv->g_destroy_func (_tmp6_[_tmp7_]), NULL));
	_tmp6_[_tmp7_] = _tmp9_;
	_tmp10_ = _tmp6_[_tmp7_];
	_tmp11_ = self->priv->_stamp;
	self->priv->_stamp = _tmp11_ + 1;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_list_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayList * self;
	gboolean result = FALSE;
	self = (GeeArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				GEqualFunc _tmp5_;
				GEqualFunc _tmp6_;
				gpointer* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				gconstpointer _tmp9_;
				gconstpointer _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = index;
					index = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = index;
				_tmp4_ = self->_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = gee_array_list_get_equal_func (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = self->_items;
				_tmp7__length1 = self->_items_length1;
				_tmp8_ = index;
				_tmp9_ = _tmp7_[_tmp8_];
				_tmp10_ = item;
				_tmp11_ = _tmp6_ (_tmp9_, _tmp10_);
				if (_tmp11_) {
					gint _tmp12_;
					gpointer _tmp13_ = NULL;
					gpointer _tmp14_;
					_tmp12_ = index;
					_tmp13_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, _tmp12_);
					_tmp14_ = _tmp13_;
					((_tmp14_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp14_ = (self->priv->g_destroy_func (_tmp14_), NULL));
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_list_real_remove_at (GeeAbstractList* base, gint index) {
	GeeArrayList * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
	gpointer item;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	gpointer _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	self = (GeeArrayList*) base;
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= 0, "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->_size;
	_vala_assert (_tmp1_ < _tmp2_, "index < _size");
	_tmp3_ = self->_items;
	_tmp3__length1 = self->_items_length1;
	_tmp4_ = index;
	_tmp5_ = _tmp3_[_tmp4_];
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	item = _tmp6_;
	_tmp7_ = self->_items;
	_tmp7__length1 = self->_items_length1;
	_tmp8_ = index;
	((_tmp7_[_tmp8_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_[_tmp8_] = (self->priv->g_destroy_func (_tmp7_[_tmp8_]), NULL));
	_tmp7_[_tmp8_] = NULL;
	_tmp9_ = _tmp7_[_tmp8_];
	_tmp10_ = index;
	gee_array_list_shift (self, _tmp10_ + 1, -1);
	_tmp11_ = self->priv->_stamp;
	self->priv->_stamp = _tmp11_ + 1;
	result = item;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_array_list_real_clear (GeeAbstractCollection* base) {
	GeeArrayList * self;
	gint _tmp8_;
	self = (GeeArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				gpointer* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gpointer _tmp7_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = index;
					index = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = index;
				_tmp4_ = self->_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = self->_items;
				_tmp5__length1 = self->_items_length1;
				_tmp6_ = index;
				((_tmp5_[_tmp6_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp5_[_tmp6_] = (self->priv->g_destroy_func (_tmp5_[_tmp6_]), NULL));
				_tmp5_[_tmp6_] = NULL;
				_tmp7_ = _tmp5_[_tmp6_];
			}
		}
	}
	self->_size = 0;
	_tmp8_ = self->priv->_stamp;
	self->priv->_stamp = _tmp8_ + 1;
}


/**
 * {@inheritDoc}
 */
static GeeList* gee_array_list_real_slice (GeeAbstractList* base, gint start, gint stop) {
	GeeArrayList * self;
	GeeList* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* slice;
	self = (GeeArrayList*) base;
	_tmp0_ = start;
	_tmp1_ = stop;
	g_return_val_if_fail (_tmp0_ <= _tmp1_, NULL);
	_tmp2_ = start;
	g_return_val_if_fail (_tmp2_ >= 0, NULL);
	_tmp3_ = stop;
	_tmp4_ = self->_size;
	g_return_val_if_fail (_tmp3_ <= _tmp4_, NULL);
	_tmp5_ = gee_array_list_get_equal_func (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp6_);
	slice = _tmp7_;
	{
		gint _tmp8_;
		gint i;
		_tmp8_ = start;
		i = _tmp8_;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				gint _tmp13_;
				GeeArrayList* _tmp14_;
				gint _tmp15_;
				gpointer _tmp16_ = NULL;
				gpointer _tmp17_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = stop;
				if (!(_tmp12_ < _tmp13_)) {
					break;
				}
				_tmp14_ = slice;
				_tmp15_ = i;
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) self, _tmp15_);
				_tmp17_ = _tmp16_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
				((_tmp17_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp17_ = (self->priv->g_destroy_func (_tmp17_), NULL));
			}
		}
	}
	result = (GeeList*) slice;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_list_real_add_all (GeeAbstractCollection* base, GeeCollection* collection) {
	GeeArrayList * self;
	gboolean result = FALSE;
	GeeCollection* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp17_;
	self = (GeeArrayList*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp0_ = collection;
	_tmp1_ = gee_collection_get_is_empty (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = collection;
	_tmp4_ = gee_collection_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	gee_array_list_grow_if_needed (self, _tmp5_);
	{
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _item_it;
		_tmp6_ = collection;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_item_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GeeIterator* _tmp10_;
			gpointer _tmp11_ = NULL;
			gpointer item;
			gpointer* _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			gconstpointer _tmp14_;
			gpointer _tmp15_;
			gpointer _tmp16_;
			_tmp8_ = _item_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _item_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			item = _tmp11_;
			_tmp12_ = self->_items;
			_tmp12__length1 = self->_items_length1;
			_tmp13_ = self->_size;
			self->_size = _tmp13_ + 1;
			_tmp14_ = item;
			_tmp15_ = ((_tmp14_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp14_) : ((gpointer) _tmp14_);
			((_tmp12_[_tmp13_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp12_[_tmp13_] = (self->priv->g_destroy_func (_tmp12_[_tmp13_]), NULL));
			_tmp12_[_tmp13_] = _tmp15_;
			_tmp16_ = _tmp12_[_tmp13_];
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	_tmp17_ = self->priv->_stamp;
	self->priv->_stamp = _tmp17_ + 1;
	result = TRUE;
	return result;
}


/**
 * Sorts items by comparing with the specified compare function.
 *
 * @deprecated This method has only been added as hack and will be
 * deprecated after the next odd minor version bump (>= 0.7.x).
 *
 * @param compare_func compare function to use to compare items
 */
void gee_array_list_sort_with_data (GeeArrayList* self, GCompareDataFunc compare, void* compare_target) {
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = compare;
	_tmp0__target = compare_target;
	gee_tim_sort_sort_with_data (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, (GeeList*) self, _tmp0_, _tmp0__target);
}


static void gee_array_list_shift (GeeArrayList* self, gint start, gint delta) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = start;
	_vala_assert (_tmp0_ >= 0, "start >= 0");
	_tmp1_ = start;
	_tmp2_ = self->_size;
	_vala_assert (_tmp1_ <= _tmp2_, "start <= _size");
	_tmp3_ = start;
	_tmp4_ = delta;
	_vala_assert (_tmp3_ >= (-_tmp4_), "start >= -delta");
	_tmp5_ = start;
	_tmp6_ = start;
	_tmp7_ = delta;
	_tmp8_ = self->_size;
	_tmp9_ = start;
	_vala_array_move (self->_items, sizeof (gpointer), _tmp5_, _tmp6_ + _tmp7_, _tmp8_ - _tmp9_);
	_tmp10_ = self->_size;
	_tmp11_ = delta;
	self->_size = _tmp10_ + _tmp11_;
}


static void gee_array_list_grow_if_needed (GeeArrayList* self, gint new_count) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint minimum_size;
	gint _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_count;
	_vala_assert (_tmp0_ >= 0, "new_count >= 0");
	_tmp1_ = self->_size;
	_tmp2_ = new_count;
	minimum_size = _tmp1_ + _tmp2_;
	_tmp3_ = minimum_size;
	_tmp4_ = self->_items;
	_tmp4__length1 = self->_items_length1;
	if (_tmp3_ > _tmp4__length1) {
		gint _tmp5_ = 0;
		gint _tmp6_;
		gpointer* _tmp7_;
		gint _tmp7__length1;
		gint _tmp10_;
		_tmp6_ = new_count;
		_tmp7_ = self->_items;
		_tmp7__length1 = self->_items_length1;
		if (_tmp6_ > _tmp7__length1) {
			gint _tmp8_;
			_tmp8_ = minimum_size;
			_tmp5_ = _tmp8_;
		} else {
			gpointer* _tmp9_;
			gint _tmp9__length1;
			_tmp9_ = self->_items;
			_tmp9__length1 = self->_items_length1;
			_tmp5_ = 2 * _tmp9__length1;
		}
		_tmp10_ = _tmp5_;
		gee_array_list_set_capacity (self, _tmp10_);
	}
}


static void gee_array_list_set_capacity (GeeArrayList* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->_size;
	_vala_assert (_tmp0_ >= _tmp1_, "value >= _size");
	_tmp2_ = value;
	_tmp3_ = _tmp2_;
	self->_items = g_renew (gpointer, self->_items, _tmp2_);
	(_tmp3_ > self->_items_length1) ? memset (self->_items + self->_items_length1, 0, sizeof (gpointer) * (_tmp3_ - self->_items_length1)) : NULL;
	self->_items_length1 = _tmp3_;
	self->__items_size_ = _tmp3_;
}


static gint gee_array_list_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeArrayList* self;
	gint _tmp0_;
	self = (GeeArrayList*) base;
	_tmp0_ = self->_size;
	result = _tmp0_;
	return result;
}


GEqualFunc gee_array_list_get_equal_func (GeeArrayList* self) {
	GEqualFunc result;
	GEqualFunc _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	result = _tmp0_;
	return result;
}


static void gee_array_list_set_equal_func (GeeArrayList* self, GEqualFunc value) {
	GEqualFunc _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_equal_func = _tmp0_;
	g_object_notify ((GObject *) self, "equal-func");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeArrayListIterator* gee_array_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list) {
	GeeArrayListIterator * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (GeeArrayListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = list;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_list);
	self->priv->_list = _tmp1_;
	_tmp2_ = self->priv->_list;
	_tmp3_ = _tmp2_->priv->_stamp;
	self->priv->_stamp = _tmp3_;
	return self;
}


static GeeArrayListIterator* gee_array_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list) {
	return gee_array_list_iterator_construct (GEE_ARRAY_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}


static gboolean gee_array_list_iterator_real_next (GeeIterator* base) {
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	_tmp4_ = self->priv->_list;
	_tmp5_ = _tmp4_->_size;
	if ((_tmp3_ + 1) < _tmp5_) {
		gint _tmp6_;
		_tmp6_ = self->priv->_index;
		self->priv->_index = _tmp6_ + 1;
		self->priv->_removed = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean gee_array_list_iterator_real_has_next (GeeIterator* base) {
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	_tmp4_ = self->priv->_list;
	_tmp5_ = _tmp4_->_size;
	result = (_tmp3_ + 1) < _tmp5_;
	return result;
}


static gboolean gee_array_list_iterator_real_first (GeeIterator* base) {
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_list;
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		result = FALSE;
		return result;
	}
	self->priv->_index = 0;
	self->priv->_removed = FALSE;
	result = TRUE;
	return result;
}


static gpointer gee_array_list_iterator_real_get (GeeIterator* base) {
	GeeArrayListIterator * self;
	gpointer result = NULL;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	GeeArrayList* _tmp8_;
	gpointer* _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	gconstpointer _tmp11_;
	gpointer _tmp12_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	_vala_assert (_tmp3_ >= 0, "_index >= 0");
	_tmp4_ = self->priv->_index;
	_tmp5_ = self->priv->_list;
	_tmp6_ = _tmp5_->_size;
	_vala_assert (_tmp4_ < _tmp6_, "_index < _list._size");
	_tmp7_ = self->priv->_removed;
	_vala_assert (!_tmp7_, "! _removed");
	_tmp8_ = self->priv->_list;
	_tmp9_ = _tmp8_->_items;
	_tmp9__length1 = _tmp8_->_items_length1;
	_tmp10_ = self->priv->_index;
	_tmp11_ = _tmp9_[_tmp10_];
	_tmp12_ = ((_tmp11_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp11_) : ((gpointer) _tmp11_);
	result = _tmp12_;
	return result;
}


static void gee_array_list_iterator_real_remove (GeeIterator* base) {
	GeeArrayListIterator * self;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_ = NULL;
	gpointer _tmp11_;
	gint _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	_vala_assert (_tmp3_ >= 0, "_index >= 0");
	_tmp4_ = self->priv->_index;
	_tmp5_ = self->priv->_list;
	_tmp6_ = _tmp5_->_size;
	_vala_assert (_tmp4_ < _tmp6_, "_index < _list._size");
	_tmp7_ = self->priv->_removed;
	_vala_assert (!_tmp7_, "! _removed");
	_tmp8_ = self->priv->_list;
	_tmp9_ = self->priv->_index;
	_tmp10_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	((_tmp11_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp11_ = (self->priv->g_destroy_func (_tmp11_), NULL));
	_tmp12_ = self->priv->_index;
	self->priv->_index = _tmp12_ - 1;
	self->priv->_removed = TRUE;
	_tmp13_ = self->priv->_list;
	_tmp14_ = _tmp13_->priv->_stamp;
	self->priv->_stamp = _tmp14_;
}


static gboolean gee_array_list_iterator_real_previous (GeeBidirIterator* base) {
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	if (_tmp3_ > 0) {
		gint _tmp4_;
		_tmp4_ = self->priv->_index;
		self->priv->_index = _tmp4_ - 1;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean gee_array_list_iterator_real_has_previous (GeeBidirIterator* base) {
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	result = (_tmp3_ - 1) >= 0;
	return result;
}


static gboolean gee_array_list_iterator_real_last (GeeBidirIterator* base) {
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_list;
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->_list;
	_tmp7_ = _tmp6_->_size;
	self->priv->_index = _tmp7_ - 1;
	result = TRUE;
	return result;
}


static void gee_array_list_iterator_real_set (GeeListIterator* base, gconstpointer item) {
	GeeArrayListIterator * self;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	GeeArrayList* _tmp7_;
	gpointer* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gconstpointer _tmp10_;
	gpointer _tmp11_;
	gpointer _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	_vala_assert (_tmp3_ >= 0, "_index >= 0");
	_tmp4_ = self->priv->_index;
	_tmp5_ = self->priv->_list;
	_tmp6_ = _tmp5_->_size;
	_vala_assert (_tmp4_ < _tmp6_, "_index < _list._size");
	_tmp7_ = self->priv->_list;
	_tmp8_ = _tmp7_->_items;
	_tmp8__length1 = _tmp7_->_items_length1;
	_tmp9_ = self->priv->_index;
	_tmp10_ = item;
	_tmp11_ = ((_tmp10_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp10_) : ((gpointer) _tmp10_);
	((_tmp8_[_tmp9_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp8_[_tmp9_] = (self->priv->g_destroy_func (_tmp8_[_tmp9_]), NULL));
	_tmp8_[_tmp9_] = _tmp11_;
	_tmp12_ = _tmp8_[_tmp9_];
	_tmp13_ = self->priv->_list;
	_tmp14_ = self->priv->_list;
	_tmp15_ = _tmp14_->priv->_stamp;
	_tmp14_->priv->_stamp = _tmp15_ + 1;
	_tmp16_ = _tmp14_->priv->_stamp;
	self->priv->_stamp = _tmp16_;
}


static void gee_array_list_iterator_real_insert (GeeListIterator* base, gconstpointer item) {
	GeeArrayListIterator * self;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gconstpointer _tmp9_;
	gint _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	_vala_assert (_tmp3_ >= 0, "_index >= 0");
	_tmp4_ = self->priv->_index;
	_tmp5_ = self->priv->_list;
	_tmp6_ = _tmp5_->_size;
	_vala_assert (_tmp4_ < _tmp6_, "_index < _list._size");
	_tmp7_ = self->priv->_list;
	_tmp8_ = self->priv->_index;
	_tmp9_ = item;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp7_, _tmp8_, _tmp9_);
	_tmp10_ = self->priv->_index;
	self->priv->_index = _tmp10_ + 1;
	_tmp11_ = self->priv->_list;
	_tmp12_ = _tmp11_->priv->_stamp;
	self->priv->_stamp = _tmp12_;
}


static void gee_array_list_iterator_real_add (GeeListIterator* base, gconstpointer item) {
	GeeArrayListIterator * self;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gconstpointer _tmp9_;
	gint _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	_vala_assert (_tmp3_ >= 0, "_index >= 0");
	_tmp4_ = self->priv->_index;
	_tmp5_ = self->priv->_list;
	_tmp6_ = _tmp5_->_size;
	_vala_assert (_tmp4_ < _tmp6_, "_index < _list._size");
	_tmp7_ = self->priv->_list;
	_tmp8_ = self->priv->_index;
	_tmp9_ = item;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp7_, _tmp8_ + 1, _tmp9_);
	_tmp10_ = self->priv->_index;
	self->priv->_index = _tmp10_ + 1;
	_tmp11_ = self->priv->_list;
	_tmp12_ = _tmp11_->priv->_stamp;
	self->priv->_stamp = _tmp12_;
}


static gint gee_array_list_iterator_real_index (GeeListIterator* base) {
	GeeArrayListIterator * self;
	gint result = 0;
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	self = (GeeArrayListIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_list;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _list._stamp");
	_tmp3_ = self->priv->_index;
	_vala_assert (_tmp3_ >= 0, "_index >= 0");
	_tmp4_ = self->priv->_index;
	_tmp5_ = self->priv->_list;
	_tmp6_ = _tmp5_->_size;
	_vala_assert (_tmp4_ < _tmp6_, "_index < _list._size");
	_tmp7_ = self->priv->_index;
	result = _tmp7_;
	return result;
}


static void gee_array_list_iterator_class_init (GeeArrayListIteratorClass * klass) {
	gee_array_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeArrayListIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_array_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_array_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) gee_array_list_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_array_list_iterator_real_has_next;
	iface->first = (gboolean (*)(GeeIterator*)) gee_array_list_iterator_real_first;
	iface->get = (gpointer (*)(GeeIterator*)) gee_array_list_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) gee_array_list_iterator_real_remove;
}


static void gee_array_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_array_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = (gboolean (*)(GeeBidirIterator*)) gee_array_list_iterator_real_previous;
	iface->has_previous = (gboolean (*)(GeeBidirIterator*)) gee_array_list_iterator_real_has_previous;
	iface->last = (gboolean (*)(GeeBidirIterator*)) gee_array_list_iterator_real_last;
}


static void gee_array_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface) {
	gee_array_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = (void (*)(GeeListIterator*, gconstpointer)) gee_array_list_iterator_real_set;
	iface->insert = (void (*)(GeeListIterator*, gconstpointer)) gee_array_list_iterator_real_insert;
	iface->add = (void (*)(GeeListIterator*, gconstpointer)) gee_array_list_iterator_real_add;
	iface->index = (gint (*)(GeeListIterator*)) gee_array_list_iterator_real_index;
}


static void gee_array_list_iterator_instance_init (GeeArrayListIterator * self) {
	self->priv = GEE_ARRAY_LIST_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
	self->priv->_removed = FALSE;
	self->priv->_stamp = 0;
}


static void gee_array_list_iterator_finalize (GObject* obj) {
	GeeArrayListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (gee_array_list_iterator_parent_class)->finalize (obj);
}


static GType gee_array_list_iterator_get_type (void) {
	static volatile gsize gee_array_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_list_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayListIterator), 0, (GInstanceInitFunc) gee_array_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_list_iterator_type_id;
		gee_array_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeArrayListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
		g_once_init_leave (&gee_array_list_iterator_type_id__volatile, gee_array_list_iterator_type_id);
	}
	return gee_array_list_iterator_type_id__volatile;
}


static void _vala_gee_array_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_array_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator);
	switch (property_id) {
		case GEE_ARRAY_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_array_list_class_init (GeeArrayListClass * klass) {
	gee_array_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeArrayListPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_array_list_real_iterator;
	GEE_ABSTRACT_LIST_CLASS (klass)->list_iterator = gee_array_list_real_list_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_array_list_real_contains;
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = gee_array_list_real_index_of;
	GEE_ABSTRACT_LIST_CLASS (klass)->get = gee_array_list_real_get;
	GEE_ABSTRACT_LIST_CLASS (klass)->set = gee_array_list_real_set;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_array_list_real_add;
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = gee_array_list_real_insert;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_array_list_real_remove;
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = gee_array_list_real_remove_at;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_array_list_real_clear;
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = gee_array_list_real_slice;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add_all = gee_array_list_real_add_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_array_list_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The elements' equality testing function.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_EQUAL_FUNC, g_param_spec_pointer ("equal-func", "equal-func", "equal-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_array_list_instance_init (GeeArrayList * self) {
	gpointer* _tmp0_ = NULL;
	self->priv = GEE_ARRAY_LIST_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gpointer, 4);
	self->_items = _tmp0_;
	self->_items_length1 = 4;
	self->__items_size_ = self->_items_length1;
	self->priv->_stamp = 0;
}


static void gee_array_list_finalize (GObject* obj) {
	GeeArrayList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_ARRAY_LIST, GeeArrayList);
	self->_items = (_vala_array_free (self->_items, self->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	G_OBJECT_CLASS (gee_array_list_parent_class)->finalize (obj);
}


/**
 * Resizable array implementation of the {@link List} interface.
 *
 * The storage array grows automatically when needed.
 *
 * This implementation is pretty good for rarely modified data. Because they are
 * stored in an array this structure does not fit for highly mutable data. For an
 * alternative implementation see {@link LinkedList}.
 *
 * @see LinkedList
 */
GType gee_array_list_get_type (void) {
	static volatile gsize gee_array_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayList), 0, (GInstanceInitFunc) gee_array_list_instance_init, NULL };
		GType gee_array_list_type_id;
		gee_array_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_LIST, "GeeArrayList", &g_define_type_info, 0);
		g_once_init_leave (&gee_array_list_type_id__volatile, gee_array_list_type_id);
	}
	return gee_array_list_type_id__volatile;
}


static void _vala_gee_array_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_LIST, GeeArrayList);
	switch (property_id) {
		case GEE_ARRAY_LIST_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_LIST_EQUAL_FUNC:
		g_value_set_pointer (value, gee_array_list_get_equal_func (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_array_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_LIST, GeeArrayList);
	switch (property_id) {
		case GEE_ARRAY_LIST_EQUAL_FUNC:
		gee_array_list_set_equal_func (self, g_value_get_pointer (value));
		break;
		case GEE_ARRAY_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}



