/* name-details.c generated by valac 0.17.3, the Vala compiler
 * generated from name-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_STRUCTURED_NAME (folks_structured_name_get_type ())
#define FOLKS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName))
#define FOLKS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))
#define FOLKS_IS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_IS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_STRUCTURED_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))

typedef struct _FolksStructuredName FolksStructuredName;
typedef struct _FolksStructuredNameClass FolksStructuredNameClass;
typedef struct _FolksStructuredNamePrivate FolksStructuredNamePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_NAME_DETAILS (folks_name_details_get_type ())
#define FOLKS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetails))
#define FOLKS_IS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_NAME_DETAILS))
#define FOLKS_NAME_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetailsIface))

typedef struct _FolksNameDetails FolksNameDetails;
typedef struct _FolksNameDetailsIface FolksNameDetailsIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksNameDetailsChangeStructuredNameData FolksNameDetailsChangeStructuredNameData;
typedef struct _FolksNameDetailsChangeFullNameData FolksNameDetailsChangeFullNameData;
typedef struct _FolksNameDetailsChangeNicknameData FolksNameDetailsChangeNicknameData;

struct _FolksStructuredName {
	GObject parent_instance;
	FolksStructuredNamePrivate * priv;
};

struct _FolksStructuredNameClass {
	GObjectClass parent_class;
};

struct _FolksStructuredNamePrivate {
	gchar* _family_name;
	gchar* _given_name;
	gchar* _additional_names;
	gchar* _prefixes;
	gchar* _suffixes;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksNameDetailsIface {
	GTypeInterface parent_iface;
	void (*change_structured_name) (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_structured_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_full_name) (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_full_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_nickname) (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_nickname_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	FolksStructuredName* (*get_structured_name) (FolksNameDetails* self);
	void (*set_structured_name) (FolksNameDetails* self, FolksStructuredName* value);
	const gchar* (*get_full_name) (FolksNameDetails* self);
	void (*set_full_name) (FolksNameDetails* self, const gchar* value);
	const gchar* (*get_nickname) (FolksNameDetails* self);
	void (*set_nickname) (FolksNameDetails* self, const gchar* value);
};

struct _FolksNameDetailsChangeStructuredNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksNameDetails* self;
	FolksStructuredName* name;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};

struct _FolksNameDetailsChangeFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksNameDetails* self;
	gchar* full_name;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};

struct _FolksNameDetailsChangeNicknameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksNameDetails* self;
	gchar* nickname;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};


static gpointer folks_structured_name_parent_class = NULL;

GType folks_structured_name_get_type (void) G_GNUC_CONST;
#define FOLKS_STRUCTURED_NAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNamePrivate))
enum  {
	FOLKS_STRUCTURED_NAME_DUMMY_PROPERTY,
	FOLKS_STRUCTURED_NAME_FAMILY_NAME,
	FOLKS_STRUCTURED_NAME_GIVEN_NAME,
	FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES,
	FOLKS_STRUCTURED_NAME_PREFIXES,
	FOLKS_STRUCTURED_NAME_SUFFIXES
};
FolksStructuredName* folks_structured_name_new (const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes);
FolksStructuredName* folks_structured_name_construct (GType object_type, const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes);
FolksStructuredName* folks_structured_name_new_simple (const gchar* family_name, const gchar* given_name);
FolksStructuredName* folks_structured_name_construct_simple (GType object_type, const gchar* family_name, const gchar* given_name);
gboolean folks_structured_name_is_empty (FolksStructuredName* self);
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other);
const gchar* folks_structured_name_get_family_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_given_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self);
const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self);
const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self);
gchar* folks_structured_name_to_string (FolksStructuredName* self);
void folks_structured_name_set_family_name (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_given_name (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_additional_names (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_prefixes (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_suffixes (FolksStructuredName* self, const gchar* value);
static void folks_structured_name_finalize (GObject* obj);
static void _vala_folks_structured_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_structured_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GQuark folks_property_error_quark (void);
GType folks_name_details_get_type (void) G_GNUC_CONST;
static void folks_name_details_real_change_structured_name_data_free (gpointer _data);
static void folks_name_details_real_change_structured_name (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_structured_name (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_structured_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_name_details_real_change_structured_name_co (FolksNameDetailsChangeStructuredNameData* _data_);
static void folks_name_details_real_change_full_name_data_free (gpointer _data);
static void folks_name_details_real_change_full_name (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_full_name (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_full_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_name_details_real_change_full_name_co (FolksNameDetailsChangeFullNameData* _data_);
static void folks_name_details_real_change_nickname_data_free (gpointer _data);
static void folks_name_details_real_change_nickname (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_nickname (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_nickname_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_name_details_real_change_nickname_co (FolksNameDetailsChangeNicknameData* _data_);
FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self);
void folks_name_details_set_structured_name (FolksNameDetails* self, FolksStructuredName* value);
const gchar* folks_name_details_get_full_name (FolksNameDetails* self);
void folks_name_details_set_full_name (FolksNameDetails* self, const gchar* value);
const gchar* folks_name_details_get_nickname (FolksNameDetails* self);
void folks_name_details_set_nickname (FolksNameDetails* self, const gchar* value);


/**
   * Create a StructuredName.
   *
   * You can pass `null` if a component is not set.
   *
   * @param family_name the family (last) name
   * @param given_name the given (first) name
   * @param additional_names additional names
   * @param prefixes prefixes of the name
   * @param suffixes suffixes of the name
   * @return a new StructuredName
   *
   * @since 0.3.5
   */
FolksStructuredName* folks_structured_name_construct (GType object_type, const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes) {
	FolksStructuredName * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = family_name;
	_tmp1_ = given_name;
	_tmp2_ = additional_names;
	_tmp3_ = prefixes;
	_tmp4_ = suffixes;
	self = (FolksStructuredName*) g_object_new (object_type, "family-name", _tmp0_, "given-name", _tmp1_, "additional-names", _tmp2_, "prefixes", _tmp3_, "suffixes", _tmp4_, NULL);
	return self;
}


FolksStructuredName* folks_structured_name_new (const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes) {
	return folks_structured_name_construct (FOLKS_TYPE_STRUCTURED_NAME, family_name, given_name, additional_names, prefixes, suffixes);
}


/**
   * Create a StructuredName.
   *
   * Shorthand for the common case of just having the family and given
   * name of a contact. It's equivalent to calling
   * {@link StructuredName.StructuredName} and passing `null` for all
   * the other components.
   *
   * @param family_name the family (last) name
   * @param given_name the given (first) name
   * @return a new StructuredName
   *
   * @since 0.3.5
   */
FolksStructuredName* folks_structured_name_construct_simple (GType object_type, const gchar* family_name, const gchar* given_name) {
	FolksStructuredName * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = family_name;
	_tmp1_ = given_name;
	self = (FolksStructuredName*) g_object_new (object_type, "family-name", _tmp0_, "given-name", _tmp1_, NULL);
	return self;
}


FolksStructuredName* folks_structured_name_new_simple (const gchar* family_name, const gchar* given_name) {
	return folks_structured_name_construct_simple (FOLKS_TYPE_STRUCTURED_NAME, family_name, given_name);
}


/**
   * Whether none of the components is set.
   *
   * @return `true` if all the components are the empty string, `false`
   * otherwise.
   *
   * @since 0.3.5
   */
gboolean folks_structured_name_is_empty (FolksStructuredName* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp4_ = self->priv->_family_name;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->_given_name;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->_additional_names;
		_tmp2_ = g_strcmp0 (_tmp7_, "") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		const gchar* _tmp9_;
		_tmp9_ = self->priv->_prefixes;
		_tmp1_ = g_strcmp0 (_tmp9_, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		const gchar* _tmp11_;
		_tmp11_ = self->priv->_suffixes;
		_tmp0_ = g_strcmp0 (_tmp11_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = _tmp0_;
	result = _tmp12_;
	return result;
}


/**
   * Whether two StructuredNames are the same.
   *
   * @param other the other structured name to compare with
   * @return `true` if all the components are the same, `false`
   * otherwise.
   *
   * @since 0.5.0
   */
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	FolksStructuredName* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp12_;
	gboolean _tmp17_;
	gboolean _tmp22_;
	gboolean _tmp27_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp4_ = self->priv->_family_name;
	_tmp5_ = other;
	_tmp6_ = folks_structured_name_get_family_name (_tmp5_);
	_tmp7_ = _tmp6_;
	if (g_strcmp0 (_tmp4_, _tmp7_) == 0) {
		const gchar* _tmp8_;
		FolksStructuredName* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = self->priv->_given_name;
		_tmp9_ = other;
		_tmp10_ = folks_structured_name_get_given_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp3_ = g_strcmp0 (_tmp8_, _tmp11_) == 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp12_ = _tmp3_;
	if (_tmp12_) {
		const gchar* _tmp13_;
		FolksStructuredName* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = self->priv->_additional_names;
		_tmp14_ = other;
		_tmp15_ = folks_structured_name_get_additional_names (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp2_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp17_ = _tmp2_;
	if (_tmp17_) {
		const gchar* _tmp18_;
		FolksStructuredName* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp18_ = self->priv->_prefixes;
		_tmp19_ = other;
		_tmp20_ = folks_structured_name_get_prefixes (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp1_ = g_strcmp0 (_tmp18_, _tmp21_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp22_ = _tmp1_;
	if (_tmp22_) {
		const gchar* _tmp23_;
		FolksStructuredName* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp23_ = self->priv->_suffixes;
		_tmp24_ = other;
		_tmp25_ = folks_structured_name_get_suffixes (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp0_ = g_strcmp0 (_tmp23_, _tmp26_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp27_ = _tmp0_;
	result = _tmp27_;
	return result;
}


/**
   * Formatted version of the structured name.
   *
   * @since 0.4.0
   */
gchar* folks_structured_name_to_string (FolksStructuredName* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("%s, %s, %s, %s, %s");
	str = _tmp0_;
	_tmp1_ = folks_structured_name_get_prefixes (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_structured_name_get_given_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_structured_name_get_family_name (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = folks_structured_name_get_additional_names (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = folks_structured_name_get_suffixes (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf (str, _tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp10_);
	result = _tmp11_;
	_g_free0 (str);
	return result;
}


const gchar* folks_structured_name_get_family_name (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_family_name;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_family_name (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_family_name);
	self->priv->_family_name = _tmp4_;
	g_object_notify ((GObject *) self, "family-name");
}


const gchar* folks_structured_name_get_given_name (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_given_name;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_given_name (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_given_name);
	self->priv->_given_name = _tmp4_;
	g_object_notify ((GObject *) self, "given-name");
}


const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_additional_names;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_additional_names (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_additional_names);
	self->priv->_additional_names = _tmp4_;
	g_object_notify ((GObject *) self, "additional-names");
}


const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prefixes;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_prefixes (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_prefixes);
	self->priv->_prefixes = _tmp4_;
	g_object_notify ((GObject *) self, "prefixes");
}


const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_suffixes;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_suffixes (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_suffixes);
	self->priv->_suffixes = _tmp4_;
	g_object_notify ((GObject *) self, "suffixes");
}


static void folks_structured_name_class_init (FolksStructuredNameClass * klass) {
	folks_structured_name_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksStructuredNamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_structured_name_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_structured_name_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_structured_name_finalize;
	/**
	   * The family name.
	   *
	   * The family name (also known as surname or last name) of a contact.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_FAMILY_NAME, g_param_spec_string ("family-name", "family-name", "family-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The given name.
	   *
	   * The family name (also known as first name) of a contact.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_GIVEN_NAME, g_param_spec_string ("given-name", "given-name", "given-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * Additional names.
	   *
	   * The additional names of a contact, for instance the contact's
	   * middle name.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES, g_param_spec_string ("additional-names", "additional-names", "additional-names", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The prefixes of a name.
	   *
	   * The prefixes used in front of the name (for instance "Mr", "Mrs",
	   * "Doctor" or honorific titles).
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_PREFIXES, g_param_spec_string ("prefixes", "prefixes", "prefixes", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The suffixes of a name.
	   *
	   * The suffixes used after a name (for instance "PhD" or "Junior").
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_SUFFIXES, g_param_spec_string ("suffixes", "suffixes", "suffixes", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void folks_structured_name_instance_init (FolksStructuredName * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = FOLKS_STRUCTURED_NAME_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_family_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_given_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_additional_names = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_prefixes = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_suffixes = _tmp4_;
}


static void folks_structured_name_finalize (GObject* obj) {
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	_g_free0 (self->priv->_family_name);
	_g_free0 (self->priv->_given_name);
	_g_free0 (self->priv->_additional_names);
	_g_free0 (self->priv->_prefixes);
	_g_free0 (self->priv->_suffixes);
	G_OBJECT_CLASS (folks_structured_name_parent_class)->finalize (obj);
}


/**
 * Object for a full name split in its constituent parts (given name,
 * family name, etc.). This structure corresponds to the "N" field in
 * VCards.  The parts of the name are never null, an empty string
 * indicates that a property is not set.
 *
 * @since 0.3.5
 */
GType folks_structured_name_get_type (void) {
	static volatile gsize folks_structured_name_type_id__volatile = 0;
	if (g_once_init_enter (&folks_structured_name_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksStructuredNameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_structured_name_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksStructuredName), 0, (GInstanceInitFunc) folks_structured_name_instance_init, NULL };
		GType folks_structured_name_type_id;
		folks_structured_name_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksStructuredName", &g_define_type_info, 0);
		g_once_init_leave (&folks_structured_name_type_id__volatile, folks_structured_name_type_id);
	}
	return folks_structured_name_type_id__volatile;
}


static void _vala_folks_structured_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	switch (property_id) {
		case FOLKS_STRUCTURED_NAME_FAMILY_NAME:
		g_value_set_string (value, folks_structured_name_get_family_name (self));
		break;
		case FOLKS_STRUCTURED_NAME_GIVEN_NAME:
		g_value_set_string (value, folks_structured_name_get_given_name (self));
		break;
		case FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES:
		g_value_set_string (value, folks_structured_name_get_additional_names (self));
		break;
		case FOLKS_STRUCTURED_NAME_PREFIXES:
		g_value_set_string (value, folks_structured_name_get_prefixes (self));
		break;
		case FOLKS_STRUCTURED_NAME_SUFFIXES:
		g_value_set_string (value, folks_structured_name_get_suffixes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_structured_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	switch (property_id) {
		case FOLKS_STRUCTURED_NAME_FAMILY_NAME:
		folks_structured_name_set_family_name (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_GIVEN_NAME:
		folks_structured_name_set_given_name (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES:
		folks_structured_name_set_additional_names (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_PREFIXES:
		folks_structured_name_set_prefixes (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_SUFFIXES:
		folks_structured_name_set_suffixes (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_name_details_real_change_structured_name_data_free (gpointer _data) {
	FolksNameDetailsChangeStructuredNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeStructuredNameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_name_details_real_change_structured_name (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksNameDetailsChangeStructuredNameData* _data_;
	FolksNameDetails* _tmp0_;
	FolksStructuredName* _tmp1_;
	FolksStructuredName* _tmp2_;
	_data_ = g_slice_new0 (FolksNameDetailsChangeStructuredNameData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_name_details_real_change_structured_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_name_details_real_change_structured_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->name = _tmp2_;
	folks_name_details_real_change_structured_name_co (_data_);
}


static void folks_name_details_real_change_structured_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FolksNameDetailsChangeStructuredNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's structured name.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.structured_name} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param name the structured name (`null` to unset it)
   * @throws PropertyError if setting the structured name failed
   * @since 0.6.2
   */
static gboolean folks_name_details_real_change_structured_name_co (FolksNameDetailsChangeStructuredNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Structured name is not writeable on this contact.");
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_name_details_change_structured_name (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_structured_name (self, name, _callback_, _user_data_);
}


void folks_name_details_change_structured_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_structured_name_finish (self, _res_, error);
}


static void folks_name_details_real_change_full_name_data_free (gpointer _data) {
	FolksNameDetailsChangeFullNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeFullNameData, _data_);
}


static void folks_name_details_real_change_full_name (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksNameDetailsChangeFullNameData* _data_;
	FolksNameDetails* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (FolksNameDetailsChangeFullNameData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_name_details_real_change_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_name_details_real_change_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = full_name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->full_name = _tmp2_;
	folks_name_details_real_change_full_name_co (_data_);
}


static void folks_name_details_real_change_full_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FolksNameDetailsChangeFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's full name.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.full_name} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param full_name the full name (empty string to unset it)
   * @throws PropertyError if setting the full name failed
   * @since 0.6.2
   */
static gboolean folks_name_details_real_change_full_name_co (FolksNameDetailsChangeFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Full name is not writeable on this contact.");
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_name_details_change_full_name (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_full_name (self, full_name, _callback_, _user_data_);
}


void folks_name_details_change_full_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_full_name_finish (self, _res_, error);
}


static void folks_name_details_real_change_nickname_data_free (gpointer _data) {
	FolksNameDetailsChangeNicknameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->nickname);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeNicknameData, _data_);
}


static void folks_name_details_real_change_nickname (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksNameDetailsChangeNicknameData* _data_;
	FolksNameDetails* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (FolksNameDetailsChangeNicknameData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_name_details_real_change_nickname);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_name_details_real_change_nickname_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = nickname;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->nickname = _tmp2_;
	folks_name_details_real_change_nickname_co (_data_);
}


static void folks_name_details_real_change_nickname_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FolksNameDetailsChangeNicknameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's nickname.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.nickname} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param nickname the nickname (empty string to unset it)
   * @throws PropertyError if setting the nickname failed
   * @since 0.6.2
   */
static gboolean folks_name_details_real_change_nickname_co (FolksNameDetailsChangeNicknameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Nickname is not writeable on this contact.");
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_name_details_change_nickname (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_nickname (self, nickname, _callback_, _user_data_);
}


void folks_name_details_change_nickname_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_nickname_finish (self, _res_, error);
}


FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_structured_name (self);
}


void folks_name_details_set_structured_name (FolksNameDetails* self, FolksStructuredName* value) {
	g_return_if_fail (self != NULL);
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->set_structured_name (self, value);
}


const gchar* folks_name_details_get_full_name (FolksNameDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_full_name (self);
}


void folks_name_details_set_full_name (FolksNameDetails* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->set_full_name (self, value);
}


const gchar* folks_name_details_get_nickname (FolksNameDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_nickname (self);
}


void folks_name_details_set_nickname (FolksNameDetails* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->set_nickname (self, value);
}


static void folks_name_details_base_init (FolksNameDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The contact name split in its constituent parts.
		   *
		   * Note that most of the time the structured name is not set (i.e.
		   * it's `null`) or just some of the components are set.
		   * The components are immutable. To get notification of changes of
		   * the structured name, you just have to connect to the `notify` signal
		   * of this property.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * The full name of the contact.
		   *
		   * The full name is the name of the contact written in the way the contact
		   * prefers. For instance for English names this is usually the given name
		   * followed by the family name, but Chinese names are usually the family
		   * name followed by the given name.
		   * The full name could or could not contain additional names (like a
		   * middle name), prefixes or suffixes.
		   *
		   * The full name must not be `null`: the empty string represents an unset full
		   * name.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * The nickname of the contact.
		   *
		   * The nickname is the name that the contact chose for himself. This is
		   * different from {@link AliasDetails.alias} as aliases can be chosen by
		   * the user and not by the contacts themselves.
		   *
		   * Consequently, setting the nickname only makes sense in the context of an
		   * address book when updating the information a contact has specified about
		   * themselves.
		   *
		   * The nickname must not be `null`: the empty string represents an unset
		   * nickname.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_structured_name = folks_name_details_real_change_structured_name;
		iface->change_structured_name_finish = folks_name_details_real_change_structured_name_finish;
		iface->change_full_name = folks_name_details_real_change_full_name;
		iface->change_full_name_finish = folks_name_details_real_change_full_name_finish;
		iface->change_nickname = folks_name_details_real_change_nickname;
		iface->change_nickname_finish = folks_name_details_real_change_nickname_finish;
	}
}


/**
 * Interface for classes which represent contacts with names, such as
 * {@link Persona} and {@link Individual}.
 *
 * @since 0.3.5
 */
GType folks_name_details_get_type (void) {
	static volatile gsize folks_name_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_name_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksNameDetailsIface), (GBaseInitFunc) folks_name_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_name_details_type_id;
		folks_name_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksNameDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_name_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_name_details_type_id__volatile, folks_name_details_type_id);
	}
	return folks_name_details_type_id__volatile;
}



