/* contacts-avatar-dialog.c generated by valac 0.17.4.21-3126, the Vala compiler
 * generated from contacts-avatar-dialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <um-crop-area.h>
#include <cheese-flash.h>
#include <gst/gst.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gst/interfaces/xoverlay.h>
#include <gdk/gdkx.h>
#include <gdk/gdk.h>
#include <gst/interfaces/propertyprobe.h>


#define CONTACTS_TYPE_AVATAR_DIALOG (contacts_avatar_dialog_get_type ())
#define CONTACTS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog))
#define CONTACTS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))
#define CONTACTS_IS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_IS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_AVATAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))

typedef struct _ContactsAvatarDialog ContactsAvatarDialog;
typedef struct _ContactsAvatarDialogClass ContactsAvatarDialogClass;
typedef struct _ContactsAvatarDialogPrivate ContactsAvatarDialogPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
typedef struct _Block34Data Block34Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block35Data Block35Data;
typedef struct _Block36Data Block36Data;

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;

#define CONTACTS_TYPE_MEMORY_ICON (contacts_memory_icon_get_type ())
#define CONTACTS_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MEMORY_ICON, ContactsMemoryIcon))
#define CONTACTS_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MEMORY_ICON, ContactsMemoryIconClass))
#define CONTACTS_IS_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MEMORY_ICON))
#define CONTACTS_IS_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MEMORY_ICON))
#define CONTACTS_MEMORY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MEMORY_ICON, ContactsMemoryIconClass))

typedef struct _ContactsMemoryIcon ContactsMemoryIcon;
typedef struct _ContactsMemoryIconClass ContactsMemoryIconClass;

struct _ContactsAvatarDialog {
	GtkDialog parent_instance;
	ContactsAvatarDialogPrivate * priv;
};

struct _ContactsAvatarDialogClass {
	GtkDialogClass parent_class;
};

struct _ContactsAvatarDialogPrivate {
	GnomeDesktopThumbnailFactory* thumbnail_factory;
	ContactsContact* contact;
	GtkNotebook* notebook;
	UmCropArea* crop_area;
	GtkGrid* view_grid;
	ContactsContactFrame* main_frame;
	gboolean has_device;
	GtkDrawingArea* photobooth_area;
	CheeseFlash* flash;
	GstPipeline* pipeline;
	GstElement* sink;
	GdkPixbuf* new_pixbuf;
};

struct _Block34Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	GdkPixbuf* avatar_pixbuf;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block35Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	GtkFileChooserDialog* chooser;
};

struct _Block36Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	ContactsContact* contact;
};

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsWindow* window;
	ContactsStore* contacts_store;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};


static gpointer contacts_avatar_dialog_parent_class = NULL;
extern ContactsApp* contacts_app_app;

GType contacts_avatar_dialog_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define CONTACTS_AVATAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogPrivate))
enum  {
	CONTACTS_AVATAR_DIALOG_DUMMY_PROPERTY
};
#define CONTACTS_AVATAR_DIALOG_main_size 128
#define CONTACTS_AVATAR_DIALOG_icons_size 64
#define CONTACTS_AVATAR_DIALOG_n_columns 6
static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_frame_set_pixbuf (ContactsContactFrame* self, GdkPixbuf* a_pixbuf);
static void __lambda30_ (Block34Data* _data34_);
static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void ___lambda30__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename);
static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self);
GType contacts_store_get_type (void) G_GNUC_CONST;
gchar** contacts_utils_get_stock_avatars (int* result_length1);
void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser);
static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self);
static void __lambda31_ (Block35Data* _data35_, gint response);
static void ___lambda31__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact);
ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_window_get_type (void) G_GNUC_CONST;
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target);
static void __lambda32_ (Block36Data* _data36_, GtkWidget* w);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
static void ___lambda32__gtk_callback (GtkWidget* widget, gpointer self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static gboolean contacts_avatar_dialog_setup_gstreamer_pipeline (ContactsAvatarDialog* self);
static void ___lambda33_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ____lambda33__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda34_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ___lambda34__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda35_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ___lambda35__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void ___lambda36_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ____lambda36__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void ___lambda37_ (ContactsAvatarDialog* self, GtkToolButton* button);
static void ____lambda37__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda38_ (ContactsAvatarDialog* self, gint response_id);
ContactsMemoryIcon* contacts_memory_icon_new_from_pixbuf (GdkPixbuf* pixbuf, GError** error);
ContactsMemoryIcon* contacts_memory_icon_construct_from_pixbuf (GType object_type, GdkPixbuf* pixbuf, GError** error);
GType contacts_memory_icon_get_type (void) G_GNUC_CONST;
static void ___lambda38__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_avatar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	gint _tmp1_ = 0;
	gint w;
	GdkPixbuf* _tmp2_;
	gint _tmp3_ = 0;
	gint h;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gboolean _tmp7_;
	gint _tmp10_;
	gint _tmp11_;
	GdkPixbuf* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GdkPixbuf* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	w = _tmp1_;
	_tmp2_ = pixbuf;
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
	h = _tmp3_;
	_tmp5_ = w;
	if (_tmp5_ <= 128) {
		gint _tmp6_;
		_tmp6_ = h;
		_tmp4_ = _tmp6_ <= 128;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		_tmp8_ = pixbuf;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = w;
	_tmp11_ = h;
	if (_tmp10_ > _tmp11_) {
		gint _tmp12_;
		gint _tmp13_;
		gdouble _tmp14_ = 0.0;
		_tmp12_ = h;
		_tmp13_ = w;
		_tmp14_ = round ((_tmp12_ * 128.0) / _tmp13_);
		h = (gint) _tmp14_;
		w = 128;
	} else {
		gint _tmp15_;
		gint _tmp16_;
		gdouble _tmp17_ = 0.0;
		_tmp15_ = w;
		_tmp16_ = h;
		_tmp17_ = round ((_tmp15_ * 128.0) / _tmp16_);
		w = (gint) _tmp17_;
		h = 128;
	}
	_tmp18_ = pixbuf;
	_tmp19_ = w;
	_tmp20_ = h;
	_tmp21_ = gdk_pixbuf_scale_simple (_tmp18_, _tmp19_, _tmp20_, GDK_INTERP_HYPER);
	result = _tmp21_;
	return result;
}


static Block34Data* block34_data_ref (Block34Data* _data34_) {
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}


static void block34_data_unref (void * _userdata_) {
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->avatar_pixbuf);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}


static void __lambda30_ (Block34Data* _data34_) {
	ContactsAvatarDialog * self;
	self = _data34_->self;
	contacts_avatar_dialog_selected_pixbuf (self, _data34_->avatar_pixbuf);
}


static void ___lambda30__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self) {
	__lambda30_ (self);
}


static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf) {
	ContactsContactFrame* result = NULL;
	Block34Data* _data34_;
	ContactsContactFrame* _tmp0_;
	ContactsContactFrame* image_frame;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_pixbuf != NULL, NULL);
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	_tmp0_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_icons_size, TRUE);
	g_object_ref_sink (_tmp0_);
	image_frame = _tmp0_;
	_tmp1_ = source_pixbuf;
	_tmp2_ = gdk_pixbuf_scale_simple (_tmp1_, CONTACTS_AVATAR_DIALOG_icons_size, CONTACTS_AVATAR_DIALOG_icons_size, GDK_INTERP_HYPER);
	pixbuf = _tmp2_;
	contacts_contact_frame_set_pixbuf (image_frame, pixbuf);
	_tmp3_ = source_pixbuf;
	_tmp4_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp3_);
	_data34_->avatar_pixbuf = _tmp4_;
	g_signal_connect_data (image_frame, "clicked", (GCallback) ___lambda30__contacts_contact_frame_clicked, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
	result = image_frame;
	_g_object_unref0 (pixbuf);
	block34_data_unref (_data34_);
	_data34_ = NULL;
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona) {
	ContactsContactFrame* result = NULL;
	FolksPersona* _tmp0_;
	FolksAvatarDetails* _tmp1_;
	FolksAvatarDetails* details;
	gboolean _tmp2_ = FALSE;
	FolksAvatarDetails* _tmp3_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _tmp0_) : NULL);
	details = _tmp1_;
	_tmp3_ = details;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		FolksAvatarDetails* _tmp4_;
		GLoadableIcon* _tmp5_;
		GLoadableIcon* _tmp6_;
		_tmp4_ = details;
		_tmp5_ = folks_avatar_details_get_avatar (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == NULL;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		result = NULL;
		_g_object_unref0 (details);
		return result;
	}
	{
		FolksAvatarDetails* _tmp8_;
		GLoadableIcon* _tmp9_;
		GLoadableIcon* _tmp10_;
		GInputStream* _tmp11_ = NULL;
		GInputStream* stream;
		GInputStream* _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* pixbuf;
		GdkPixbuf* _tmp14_;
		ContactsContactFrame* _tmp15_ = NULL;
		_tmp8_ = details;
		_tmp9_ = folks_avatar_details_get_avatar (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_loadable_icon_load (_tmp10_, 128, NULL, NULL, &_inner_error_);
		stream = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
		_tmp12_ = stream;
		_tmp13_ = gdk_pixbuf_new_from_stream (_tmp12_, NULL, &_inner_error_);
		pixbuf = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			goto __catch25_g_error;
		}
		_tmp14_ = pixbuf;
		_tmp15_ = contacts_avatar_dialog_create_frame (self, _tmp14_);
		result = _tmp15_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (stream);
		_g_object_unref0 (details);
		return result;
	}
	goto __finally25;
	__catch25_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (details);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (details);
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename) {
	ContactsContactFrame* result = NULL;
	ContactsContactFrame* image_frame;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	image_frame = NULL;
	{
		const gchar* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* pixbuf;
		ContactsContactFrame* _tmp2_ = NULL;
		_tmp0_ = filename;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		pixbuf = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		_tmp2_ = contacts_avatar_dialog_create_frame (self, pixbuf);
		result = _tmp2_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (image_frame);
		return result;
	}
	goto __finally26;
	__catch26_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (image_frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = image_frame;
	return result;
}


static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* p;
	ContactsContactFrame* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_scale_simple (_tmp0_, CONTACTS_AVATAR_DIALOG_main_size, CONTACTS_AVATAR_DIALOG_main_size, GDK_INTERP_HYPER);
	p = _tmp1_;
	_tmp2_ = self->priv->main_frame;
	contacts_contact_frame_set_pixbuf (_tmp2_, p);
	_tmp3_ = pixbuf;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->new_pixbuf);
	self->priv->new_pixbuf = _tmp4_;
	_g_object_unref0 (p);
}


static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self) {
	gint i;
	gint j;
	gint _tmp20_;
	gint _tmp22_;
	gint _tmp27_ = 0;
	gchar** _tmp28_ = NULL;
	gchar** stock_files;
	gint stock_files_length1;
	gint _stock_files_size_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GtkGrid* _tmp42_;
	g_return_if_fail (self != NULL);
	i = 0;
	j = 0;
	{
		ContactsContact* _tmp0_;
		FolksIndividual* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = self->priv->contact;
		_tmp1_ = _tmp0_->individual;
		_tmp2_ = folks_individual_get_personas (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_p_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp9_;
			ContactsContactFrame* _tmp10_ = NULL;
			ContactsContactFrame* frame;
			ContactsContactFrame* _tmp11_;
			_tmp5_ = _p_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _p_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			p = (FolksPersona*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = contacts_avatar_dialog_frame_for_persona (self, _tmp9_);
			frame = _tmp10_;
			_tmp11_ = frame;
			if (_tmp11_ != NULL) {
				GtkGrid* _tmp12_;
				ContactsContactFrame* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				_tmp12_ = self->priv->view_grid;
				_tmp13_ = frame;
				_tmp14_ = i;
				_tmp15_ = j;
				gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, _tmp14_, _tmp15_, 1, 1);
				_tmp16_ = i;
				i = _tmp16_ + 1;
				_tmp17_ = i;
				if (_tmp17_ >= CONTACTS_AVATAR_DIALOG_n_columns) {
					gint _tmp18_;
					gint _tmp19_;
					_tmp18_ = i;
					i = _tmp18_ - CONTACTS_AVATAR_DIALOG_n_columns;
					_tmp19_ = j;
					j = _tmp19_ + 1;
				}
			}
			_g_object_unref0 (frame);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp20_ = i;
	if (_tmp20_ != 0) {
		gint _tmp21_;
		i = 0;
		_tmp21_ = j;
		j = _tmp21_ + 1;
	}
	_tmp22_ = j;
	if (_tmp22_ != 0) {
		GtkSeparator* _tmp23_;
		GtkSeparator* s;
		GtkGrid* _tmp24_;
		GtkSeparator* _tmp25_;
		gint _tmp26_;
		_tmp23_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp23_);
		s = _tmp23_;
		_tmp24_ = self->priv->view_grid;
		_tmp25_ = s;
		_tmp26_ = j;
		j = _tmp26_ + 1;
		gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, _tmp26_, CONTACTS_AVATAR_DIALOG_n_columns, 1);
		_g_object_unref0 (s);
	}
	_tmp28_ = contacts_utils_get_stock_avatars (&_tmp27_);
	stock_files = _tmp28_;
	stock_files_length1 = _tmp27_;
	_stock_files_size_ = stock_files_length1;
	_tmp29_ = stock_files;
	_tmp29__length1 = stock_files_length1;
	{
		gchar** file_name_collection = NULL;
		gint file_name_collection_length1 = 0;
		gint _file_name_collection_size_ = 0;
		gint file_name_it = 0;
		file_name_collection = _tmp29_;
		file_name_collection_length1 = _tmp29__length1;
		for (file_name_it = 0; file_name_it < _tmp29__length1; file_name_it = file_name_it + 1) {
			gchar* _tmp30_;
			gchar* file_name = NULL;
			_tmp30_ = g_strdup (file_name_collection[file_name_it]);
			file_name = _tmp30_;
			{
				const gchar* _tmp31_;
				ContactsContactFrame* _tmp32_ = NULL;
				ContactsContactFrame* frame;
				ContactsContactFrame* _tmp33_;
				_tmp31_ = file_name;
				_tmp32_ = contacts_avatar_dialog_frame_for_filename (self, _tmp31_);
				frame = _tmp32_;
				_tmp33_ = frame;
				if (_tmp33_ != NULL) {
					GtkGrid* _tmp34_;
					ContactsContactFrame* _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					_tmp34_ = self->priv->view_grid;
					_tmp35_ = frame;
					_tmp36_ = i;
					_tmp37_ = j;
					gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, _tmp36_, _tmp37_, 1, 1);
					_tmp38_ = i;
					i = _tmp38_ + 1;
					_tmp39_ = i;
					if (_tmp39_ >= CONTACTS_AVATAR_DIALOG_n_columns) {
						gint _tmp40_;
						gint _tmp41_;
						_tmp40_ = i;
						i = _tmp40_ - CONTACTS_AVATAR_DIALOG_n_columns;
						_tmp41_ = j;
						j = _tmp41_ + 1;
					}
				}
				_g_object_unref0 (frame);
				_g_free0 (file_name);
			}
		}
	}
	_tmp42_ = self->priv->view_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp42_);
	stock_files = (_vala_array_free (stock_files, stock_files_length1, (GDestroyNotify) g_free), NULL);
}


void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser) {
	GtkFileChooser* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	const gchar* _tmp2_;
	GtkFileChooser* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chooser != NULL);
	_tmp0_ = chooser;
	_tmp1_ = gtk_file_chooser_get_preview_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	if (_tmp2_ != NULL) {
		GdkPixbuf* pixbuf;
		GtkFileChooser* _tmp3_;
		GtkWidget* _tmp4_ = NULL;
		GtkImage* _tmp5_;
		GtkImage* preview;
		const gchar* _tmp6_;
		GFile* _tmp7_ = NULL;
		GFile* file;
		GtkFileChooser* _tmp20_;
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		pixbuf = NULL;
		_tmp3_ = chooser;
		_tmp4_ = gtk_file_chooser_get_preview_widget (_tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp4_) : NULL);
		preview = _tmp5_;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		file = _tmp7_;
		{
			GFile* _tmp8_;
			GFileInfo* _tmp9_ = NULL;
			GFileInfo* file_info;
			GFileInfo* _tmp10_;
			_tmp8_ = file;
			_tmp9_ = g_file_query_info (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			file_info = _tmp9_;
			if (_inner_error_ != NULL) {
				goto __catch27_g_error;
			}
			_tmp10_ = file_info;
			if (_tmp10_ != NULL) {
				GFileInfo* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* mime_type;
				const gchar* _tmp14_;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				mime_type = _tmp13_;
				_tmp14_ = mime_type;
				if (_tmp14_ != NULL) {
					GnomeDesktopThumbnailFactory* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					GdkPixbuf* _tmp18_ = NULL;
					GdkPixbuf* _tmp19_;
					_tmp15_ = self->priv->thumbnail_factory;
					_tmp16_ = uri;
					_tmp17_ = mime_type;
					_tmp18_ = gnome_desktop_thumbnail_factory_generate_thumbnail (_tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp19_;
				}
				_g_free0 (mime_type);
			}
			_g_object_unref0 (file_info);
		}
		goto __finally27;
		__catch27_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally27:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_object_unref0 (preview);
			_g_object_unref0 (pixbuf);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp20_ = chooser;
		_tmp21_ = pixbuf;
		gtk_dialog_set_response_sensitive (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp20_) : NULL, (gint) GTK_RESPONSE_ACCEPT, _tmp21_ != NULL);
		_tmp22_ = pixbuf;
		if (_tmp22_ != NULL) {
			GtkImage* _tmp23_;
			GdkPixbuf* _tmp24_;
			_tmp23_ = preview;
			_tmp24_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp23_, _tmp24_);
		} else {
			GtkImage* _tmp25_;
			_tmp25_ = preview;
			gtk_image_set_from_stock (_tmp25_, GTK_STOCK_DIALOG_QUESTION, GTK_ICON_SIZE_DIALOG);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (preview);
		_g_object_unref0 (pixbuf);
	}
	_tmp26_ = chooser;
	gtk_file_chooser_set_preview_widget_active (_tmp26_, TRUE);
	_g_free0 (uri);
}


static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GtkNotebook* _tmp0_;
	GtkWidget* _tmp1_ = NULL;
	GtkGrid* _tmp2_;
	GtkGrid* frame_grid;
	UmCropArea* _tmp3_;
	UmCropArea* _tmp4_;
	UmCropArea* _tmp5_;
	UmCropArea* _tmp6_;
	UmCropArea* _tmp7_;
	UmCropArea* _tmp8_;
	GdkPixbuf* _tmp9_;
	UmCropArea* _tmp10_;
	GtkNotebook* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_nth_page (_tmp0_, 1);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp1_) : NULL);
	frame_grid = _tmp2_;
	_tmp3_ = (UmCropArea*) um_crop_area_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->crop_area);
	self->priv->crop_area = _tmp3_;
	_tmp4_ = self->priv->crop_area;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->crop_area;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->crop_area;
	um_crop_area_set_min_size (_tmp6_, 48, 48);
	_tmp7_ = self->priv->crop_area;
	um_crop_area_set_constrain_aspect (_tmp7_, TRUE);
	_tmp8_ = self->priv->crop_area;
	_tmp9_ = pixbuf;
	um_crop_area_set_picture (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->crop_area;
	gtk_grid_attach (frame_grid, (GtkWidget*) _tmp10_, 0, 0, 1, 1);
	gtk_widget_show_all ((GtkWidget*) frame_grid);
	_tmp11_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp11_, 1);
	_g_object_unref0 (frame_grid);
}


static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (void * _userdata_) {
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}


static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self) {
	contacts_avatar_dialog_update_preview (self, _sender);
}


static void __lambda31_ (Block35Data* _data35_, gint response) {
	ContactsAvatarDialog * self;
	gint _tmp0_;
	GtkFileChooserDialog* _tmp22_;
	GError * _inner_error_ = NULL;
	self = _data35_->self;
	_tmp0_ = response;
	if (_tmp0_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp1_;
		_tmp1_ = _data35_->chooser;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
		return;
	}
	{
		GtkFileChooserDialog* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFile* file;
		GFile* _tmp7_;
		GFileInputStream* _tmp8_ = NULL;
		GFileInputStream* in_stream;
		GFileInputStream* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* pixbuf;
		GFileInputStream* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GdkPixbuf* _tmp13_;
		gint _tmp14_ = 0;
		gboolean _tmp17_;
		_tmp2_ = _data35_->chooser;
		_tmp3_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		file = _tmp6_;
		_tmp7_ = file;
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error_);
		in_stream = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch28_g_error;
		}
		_tmp9_ = in_stream;
		_tmp10_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp9_, NULL, &_inner_error_);
		pixbuf = _tmp10_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch28_g_error;
		}
		_tmp11_ = in_stream;
		g_input_stream_close ((GInputStream*) _tmp11_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch28_g_error;
		}
		_tmp13_ = pixbuf;
		_tmp14_ = gdk_pixbuf_get_width (_tmp13_);
		if (_tmp14_ > 128) {
			_tmp12_ = TRUE;
		} else {
			GdkPixbuf* _tmp15_;
			gint _tmp16_ = 0;
			_tmp15_ = pixbuf;
			_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
			_tmp12_ = _tmp16_ > 128;
		}
		_tmp17_ = _tmp12_;
		if (_tmp17_) {
			GdkPixbuf* _tmp18_;
			_tmp18_ = pixbuf;
			contacts_avatar_dialog_set_crop_widget (self, _tmp18_);
		} else {
			GdkPixbuf* _tmp19_;
			GdkPixbuf* _tmp20_ = NULL;
			GdkPixbuf* _tmp21_;
			_tmp19_ = pixbuf;
			_tmp20_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp19_);
			_tmp21_ = _tmp20_;
			contacts_avatar_dialog_selected_pixbuf (self, _tmp21_);
			_g_object_unref0 (_tmp21_);
		}
		contacts_avatar_dialog_update_grid (self);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (in_stream);
		_g_object_unref0 (file);
	}
	goto __finally28;
	__catch28_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp22_ = _data35_->chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp22_);
}


static void ___lambda31__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda31_ (self, response_id);
}


static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self) {
	Block35Data* _data35_;
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* preview;
	GtkImage* _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	GtkImage* _tmp8_;
	GtkFileChooserDialog* _tmp9_;
	GtkImage* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* folder;
	const gchar* _tmp14_;
	GtkFileChooserDialog* _tmp17_;
	GtkFileChooserDialog* _tmp18_;
	g_return_if_fail (self != NULL);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	_tmp0_ = _ ("Browse for more pictures");
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_WINDOW, GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp2_);
	_data35_->chooser = _tmp2_;
	_tmp3_ = _data35_->chooser;
	gtk_window_set_modal ((GtkWindow*) _tmp3_, TRUE);
	_tmp4_ = _data35_->chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp4_, FALSE);
	_tmp5_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp5_);
	preview = _tmp5_;
	_tmp6_ = preview;
	gtk_widget_set_size_request ((GtkWidget*) _tmp6_, 128, -1);
	_tmp7_ = _data35_->chooser;
	_tmp8_ = preview;
	gtk_file_chooser_set_preview_widget ((GtkFileChooser*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = _data35_->chooser;
	gtk_file_chooser_set_use_preview_label ((GtkFileChooser*) _tmp9_, FALSE);
	_tmp10_ = preview;
	gtk_widget_show ((GtkWidget*) _tmp10_);
	_tmp11_ = _data35_->chooser;
	g_signal_connect_object ((GtkFileChooser*) _tmp11_, "update-preview", (GCallback) _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview, self, 0);
	_tmp12_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp13_ = g_strdup (_tmp12_);
	folder = _tmp13_;
	_tmp14_ = folder;
	if (_tmp14_ != NULL) {
		GtkFileChooserDialog* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = _data35_->chooser;
		_tmp16_ = folder;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp15_, _tmp16_);
	}
	_tmp17_ = _data35_->chooser;
	g_signal_connect_data ((GtkDialog*) _tmp17_, "response", (GCallback) ___lambda31__gtk_dialog_response, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
	_tmp18_ = _data35_->chooser;
	gtk_window_present ((GtkWindow*) _tmp18_);
	_g_free0 (folder);
	_g_object_unref0 (preview);
	block35_data_unref (_data35_);
	_data35_ = NULL;
}


static Block36Data* block36_data_ref (Block36Data* _data36_) {
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}


static void block36_data_unref (void * _userdata_) {
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->contact);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}


static void __lambda32_ (Block36Data* _data36_, GtkWidget* w) {
	ContactsAvatarDialog * self;
	GtkWidget* _tmp0_;
	ContactsContact* _tmp1_;
	FolksIndividual* _tmp2_;
	ContactsContact* _tmp3_;
	self = _data36_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data36_->contact;
	_tmp2_ = _tmp1_->individual;
	_tmp3_ = _data36_->contact;
	contacts_contact_frame_set_image (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_CONTACT_FRAME) ? ((ContactsContactFrame*) _tmp0_) : NULL, (FolksAvatarDetails*) _tmp2_, _tmp3_);
}


static void ___lambda32__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda32_ (self, widget);
}


static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	contacts_avatar_dialog_select_avatar_file_cb (self);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static void ___lambda33_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	GtkNotebook* _tmp0_;
	GstElement* _tmp1_;
	GstXOverlay* _tmp2_;
	GstXOverlay* xoverlay;
	GtkDrawingArea* _tmp3_;
	GdkWindow* _tmp4_ = NULL;
	Window _tmp5_ = 0;
	GstPipeline* _tmp6_;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp0_, 2);
	_tmp1_ = self->priv->sink;
	_tmp2_ = _gst_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GST_TYPE_X_OVERLAY) ? ((GstXOverlay*) _tmp1_) : NULL);
	xoverlay = _tmp2_;
	_tmp3_ = self->priv->photobooth_area;
	_tmp4_ = gtk_widget_get_window ((GtkWidget*) _tmp3_);
	_tmp5_ = gdk_x11_window_get_xid (_tmp4_);
	gst_x_overlay_set_xwindow_id (xoverlay, (gulong) _tmp5_);
	_tmp6_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp6_, GST_STATE_PLAYING);
	_gst_object_unref0 (xoverlay);
}


static void ____lambda33__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	___lambda33_ (self, _sender);
}


static void __lambda34_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	UmCropArea* _tmp0_;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* pix;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_;
	UmCropArea* _tmp4_;
	GtkNotebook* _tmp5_;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->crop_area;
	_tmp1_ = um_crop_area_get_picture (_tmp0_);
	pix = _tmp1_;
	_tmp2_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, pix);
	_tmp3_ = _tmp2_;
	contacts_avatar_dialog_selected_pixbuf (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->crop_area;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp5_, 0);
	_g_object_unref0 (pix);
}


static void ___lambda34__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda34_ (self, _sender);
}


static void __lambda35_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	UmCropArea* _tmp0_;
	GtkNotebook* _tmp1_;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->crop_area;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp1_, 0);
}


static void ___lambda35__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda35_ (self, _sender);
}


static void ___lambda36_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	gint x = 0;
	gint y = 0;
	GtkDrawingArea* _tmp0_;
	GdkWindow* _tmp1_ = NULL;
	GdkWindow* _tmp2_;
	GdkWindow* win;
	GdkWindow* _tmp3_ = NULL;
	GdkWindow* _tmp4_;
	GdkWindow* flash_win;
	GdkWindow* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	GdkRectangle rect;
	gint _tmp9_;
	gint _tmp10_;
	GdkWindow* _tmp11_;
	gint _tmp12_ = 0;
	GdkWindow* _tmp13_;
	gint _tmp14_ = 0;
	CheeseFlash* _tmp15_;
	GdkRectangle _tmp16_;
	GstPipeline* _tmp17_;
	GdkWindow* _tmp19_;
	GtkDrawingArea* _tmp20_;
	gint _tmp21_ = 0;
	GtkDrawingArea* _tmp22_;
	gint _tmp23_ = 0;
	GdkPixbuf* _tmp24_ = NULL;
	GdkPixbuf* pix;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->photobooth_area;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	win = _tmp2_;
	_tmp3_ = gdk_get_default_root_window ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	flash_win = _tmp4_;
	_tmp5_ = flash_win;
	gdk_window_get_origin (_tmp5_, &_tmp6_, &_tmp7_);
	x = _tmp6_;
	y = _tmp7_;
	rect = _tmp8_;
	_tmp9_ = x;
	rect.x = _tmp9_;
	_tmp10_ = y;
	rect.y = _tmp10_;
	_tmp11_ = flash_win;
	_tmp12_ = gdk_window_get_width (_tmp11_);
	rect.width = _tmp12_;
	_tmp13_ = flash_win;
	_tmp14_ = gdk_window_get_height (_tmp13_);
	rect.height = _tmp14_;
	_tmp15_ = self->priv->flash;
	_tmp16_ = rect;
	cheese_flash_fire (_tmp15_, &_tmp16_);
	_tmp17_ = self->priv->pipeline;
	if (_tmp17_ != NULL) {
		GstPipeline* _tmp18_;
		_tmp18_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp18_, GST_STATE_PAUSED);
	}
	_tmp19_ = win;
	_tmp20_ = self->priv->photobooth_area;
	_tmp21_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp20_);
	_tmp22_ = self->priv->photobooth_area;
	_tmp23_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp22_);
	_tmp24_ = gdk_pixbuf_get_from_window (_tmp19_, 0, 0, _tmp21_, _tmp23_);
	pix = _tmp24_;
	contacts_avatar_dialog_set_crop_widget (self, pix);
	_g_object_unref0 (pix);
	_g_object_unref0 (flash_win);
	_g_object_unref0 (win);
}


static void ____lambda36__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	___lambda36_ (self, _sender);
}


static void ___lambda37_ (ContactsAvatarDialog* self, GtkToolButton* button) {
	GstPipeline* _tmp0_;
	GtkNotebook* _tmp2_;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->pipeline;
	if (_tmp0_ != NULL) {
		GstPipeline* _tmp1_;
		_tmp1_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp1_, GST_STATE_READY);
	}
	_tmp2_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp2_, 0);
}


static void ____lambda37__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	___lambda37_ (self, _sender);
}


static void __lambda38_ (ContactsAvatarDialog* self, gint response_id) {
	gint _tmp0_;
	GstPipeline* _tmp5_;
	GError * _inner_error_ = NULL;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_CLOSE)) {
		GdkPixbuf* _tmp1_;
		_tmp1_ = self->priv->new_pixbuf;
		if (_tmp1_ != NULL) {
			{
				GdkPixbuf* _tmp2_;
				ContactsMemoryIcon* _tmp3_;
				ContactsMemoryIcon* icon;
				ContactsMemoryIcon* _tmp4_;
				_tmp2_ = self->priv->new_pixbuf;
				_tmp3_ = contacts_memory_icon_new_from_pixbuf (_tmp2_, &_inner_error_);
				icon = _tmp3_;
				if (_inner_error_ != NULL) {
					goto __catch29_g_error;
				}
				_tmp4_ = icon;
				g_signal_emit_by_name (self, "set-avatar", (GIcon*) _tmp4_);
				_g_object_unref0 (icon);
			}
			goto __finally29;
			__catch29_g_error:
			{
				g_clear_error (&_inner_error_);
				_inner_error_ = NULL;
			}
			__finally29:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp5_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp5_, GST_STATE_NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}


static void ___lambda38__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda38_ (self, response_id);
}


ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact) {
	ContactsAvatarDialog * self = NULL;
	Block36Data* _data36_;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	GnomeDesktopThumbnailFactory* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsContact* _tmp4_;
	const gchar* _tmp5_ = NULL;
	ContactsApp* _tmp6_;
	ContactsWindow* _tmp7_;
	const gchar* _tmp8_ = NULL;
	GtkGrid* _tmp9_;
	GtkGrid* grid;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkBox* _tmp12_ = NULL;
	GtkContainer* _tmp13_;
	GtkContainer* container;
	GtkContainer* _tmp14_;
	GtkGrid* _tmp15_;
	ContactsContactFrame* _tmp16_;
	ContactsContact* _tmp17_;
	ContactsContactFrame* _tmp18_;
	ContactsContactFrame* _tmp19_;
	GtkGrid* _tmp20_;
	ContactsContactFrame* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* label;
	GtkLabel* _tmp23_;
	ContactsContact* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkGrid* _tmp35_;
	GtkLabel* _tmp36_;
	GtkGrid* _tmp37_;
	GtkFrame* _tmp38_;
	GtkFrame* frame;
	GtkFrame* _tmp39_;
	GtkStyleContext* _tmp40_ = NULL;
	GtkGrid* _tmp41_;
	GtkFrame* _tmp42_;
	GtkNotebook* _tmp43_;
	GtkNotebook* _tmp44_;
	GtkFrame* _tmp45_;
	GtkNotebook* _tmp46_;
	GtkGrid* _tmp47_;
	GtkGrid* frame_grid;
	GtkGrid* _tmp48_;
	GtkScrolledWindow* _tmp49_;
	GtkScrolledWindow* scrolled;
	GtkScrolledWindow* _tmp50_;
	GtkScrolledWindow* _tmp51_;
	GtkScrolledWindow* _tmp52_;
	GtkScrolledWindow* _tmp53_;
	GtkGrid* _tmp54_;
	GtkScrolledWindow* _tmp55_;
	GtkGrid* _tmp56_;
	GtkScrolledWindow* _tmp57_;
	GtkGrid* _tmp58_;
	GtkToolbar* _tmp59_;
	GtkToolbar* toolbar;
	GtkToolbar* _tmp60_;
	GtkStyleContext* _tmp61_ = NULL;
	GtkToolbar* _tmp62_;
	GtkToolbar* _tmp63_;
	GtkGrid* _tmp64_;
	GtkToolbar* _tmp65_;
	GtkToolButton* _tmp66_;
	GtkToolButton* the_add_button;
	GtkToolButton* _tmp67_;
	GtkToolButton* _tmp68_;
	GtkStyleContext* _tmp69_ = NULL;
	GtkToolButton* _tmp70_;
	GtkToolbar* _tmp71_;
	GtkToolButton* _tmp72_;
	GtkToolButton* _tmp73_;
	gboolean _tmp74_ = FALSE;
	GtkGrid* _tmp83_;
	GtkNotebook* _tmp84_;
	GtkGrid* _tmp85_;
	GtkGrid* _tmp86_;
	GtkGrid* _tmp87_;
	GtkToolbar* _tmp88_;
	GtkToolbar* _tmp89_;
	GtkStyleContext* _tmp90_ = NULL;
	GtkToolbar* _tmp91_;
	GtkToolbar* _tmp92_;
	GtkGrid* _tmp93_;
	GtkToolbar* _tmp94_;
	GtkToolButton* _tmp95_;
	GtkToolButton* accept_button;
	GtkToolButton* _tmp96_;
	GtkToolButton* _tmp97_;
	GtkStyleContext* _tmp98_ = NULL;
	GtkToolButton* _tmp99_;
	GtkToolbar* _tmp100_;
	GtkToolButton* _tmp101_;
	GtkToolButton* _tmp102_;
	GtkToolButton* _tmp103_;
	GtkToolButton* cancel_button;
	GtkToolButton* _tmp104_;
	GtkToolButton* _tmp105_;
	GtkStyleContext* _tmp106_ = NULL;
	GtkToolButton* _tmp107_;
	GtkToolbar* _tmp108_;
	GtkToolButton* _tmp109_;
	GtkToolButton* _tmp110_;
	GtkGrid* _tmp111_;
	GtkNotebook* _tmp112_;
	GtkGrid* _tmp113_;
	gboolean _tmp114_;
	GtkNotebook* _tmp149_;
	GtkGrid* _tmp150_;
	g_return_val_if_fail (contact != NULL, NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data36_->contact = _tmp1_;
	self = (ContactsAvatarDialog*) g_object_new (object_type, NULL);
	_data36_->self = g_object_ref (self);
	_tmp2_ = gnome_desktop_thumbnail_factory_new (GNOME_DESKTOP_THUMBNAIL_SIZE_NORMAL);
	_g_object_unref0 (self->priv->thumbnail_factory);
	self->priv->thumbnail_factory = _tmp2_;
	_tmp3_ = _data36_->contact;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp4_;
	_tmp5_ = _ ("Select Picture");
	gtk_window_set_title ((GtkWindow*) self, _tmp5_);
	_tmp6_ = contacts_app_app;
	_tmp7_ = _tmp6_->window;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp7_);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	_tmp8_ = _ ("Close");
	gtk_dialog_add_buttons ((GtkDialog*) self, _tmp8_, GTK_RESPONSE_CLOSE, NULL, NULL);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp9_);
	grid = _tmp9_;
	_tmp10_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp10_, (guint) 8);
	_tmp11_ = grid;
	gtk_grid_set_column_spacing (_tmp11_, (guint) 16);
	_tmp12_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GTK_TYPE_CONTAINER) ? ((GtkContainer*) _tmp12_) : NULL);
	container = _tmp13_;
	_tmp14_ = container;
	_tmp15_ = grid;
	gtk_container_add (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_main_size, FALSE);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->main_frame);
	self->priv->main_frame = _tmp16_;
	_tmp17_ = _data36_->contact;
	_tmp18_ = self->priv->main_frame;
	contacts_contact_keep_widget_uptodate (_tmp17_, (GtkWidget*) _tmp18_, ___lambda32__gtk_callback, _data36_);
	_tmp19_ = self->priv->main_frame;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp19_, FALSE);
	_tmp20_ = grid;
	_tmp21_ = self->priv->main_frame;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 0, 1, 1);
	_tmp22_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp22_);
	label = _tmp22_;
	_tmp23_ = label;
	_tmp24_ = _data36_->contact;
	_tmp25_ = contacts_contact_get_display_name (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_markup_printf_escaped ("<span font='16'>%s</span>", _tmp26_);
	_tmp28_ = _tmp27_;
	gtk_label_set_markup (_tmp23_, _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = label;
	gtk_widget_set_valign ((GtkWidget*) _tmp29_, GTK_ALIGN_START);
	_tmp30_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp30_, GTK_ALIGN_START);
	_tmp31_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp31_, TRUE);
	_tmp32_ = label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp32_, 4);
	_tmp33_ = label;
	g_object_set ((GtkMisc*) _tmp33_, "xalign", 0.0f, NULL);
	_tmp34_ = label;
	gtk_label_set_ellipsize (_tmp34_, PANGO_ELLIPSIZE_END);
	_tmp35_ = grid;
	_tmp36_ = label;
	gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, 1, 0, 1, 1);
	_tmp37_ = grid;
	gtk_grid_set_row_spacing (_tmp37_, (guint) 11);
	_tmp38_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp38_);
	frame = _tmp38_;
	_tmp39_ = frame;
	_tmp40_ = gtk_widget_get_style_context ((GtkWidget*) _tmp39_);
	gtk_style_context_add_class (_tmp40_, "contacts-avatar-frame");
	_tmp41_ = grid;
	_tmp42_ = frame;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 0, 1, 2, 1);
	_tmp43_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp43_;
	_tmp44_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp44_, FALSE);
	_tmp45_ = frame;
	_tmp46_ = self->priv->notebook;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp47_);
	frame_grid = _tmp47_;
	_tmp48_ = frame_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp48_, GTK_ORIENTATION_VERTICAL);
	_tmp49_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp49_);
	scrolled = _tmp49_;
	_tmp50_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp50_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp51_ = scrolled;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp51_, TRUE);
	_tmp52_ = scrolled;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp52_, TRUE);
	_tmp53_ = scrolled;
	gtk_widget_set_size_request ((GtkWidget*) _tmp53_, -1, 300);
	_tmp54_ = frame_grid;
	_tmp55_ = scrolled;
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->view_grid);
	self->priv->view_grid = _tmp56_;
	_tmp57_ = scrolled;
	_tmp58_ = self->priv->view_grid;
	gtk_scrolled_window_add_with_viewport (_tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp59_);
	toolbar = _tmp59_;
	_tmp60_ = toolbar;
	_tmp61_ = gtk_widget_get_style_context ((GtkWidget*) _tmp60_);
	gtk_style_context_add_class (_tmp61_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp62_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp62_, GTK_ICON_SIZE_MENU);
	_tmp63_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp63_, FALSE);
	_tmp64_ = frame_grid;
	_tmp65_ = toolbar;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp66_);
	the_add_button = _tmp66_;
	_tmp67_ = the_add_button;
	gtk_tool_button_set_icon_name (_tmp67_, "list-add-symbolic");
	_tmp68_ = the_add_button;
	_tmp69_ = gtk_widget_get_style_context ((GtkWidget*) _tmp68_);
	gtk_style_context_add_class (_tmp69_, GTK_STYLE_CLASS_RAISED);
	_tmp70_ = the_add_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp70_, TRUE);
	_tmp71_ = toolbar;
	_tmp72_ = the_add_button;
	gtk_container_add ((GtkContainer*) _tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = the_add_button;
	g_signal_connect_object (_tmp73_, "clicked", (GCallback) _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked, self, 0);
	_tmp74_ = contacts_avatar_dialog_setup_gstreamer_pipeline (self);
	if (_tmp74_) {
		GtkToolButton* _tmp75_;
		GtkToolButton* webcam_button;
		GtkToolButton* _tmp76_;
		GtkToolButton* _tmp77_;
		GtkStyleContext* _tmp78_ = NULL;
		GtkToolButton* _tmp79_;
		GtkToolbar* _tmp80_;
		GtkToolButton* _tmp81_;
		GtkToolButton* _tmp82_;
		_tmp75_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
		g_object_ref_sink (_tmp75_);
		webcam_button = _tmp75_;
		_tmp76_ = webcam_button;
		gtk_tool_button_set_icon_name (_tmp76_, "camera-photo-symbolic");
		_tmp77_ = webcam_button;
		_tmp78_ = gtk_widget_get_style_context ((GtkWidget*) _tmp77_);
		gtk_style_context_add_class (_tmp78_, GTK_STYLE_CLASS_RAISED);
		_tmp79_ = webcam_button;
		gtk_tool_item_set_is_important ((GtkToolItem*) _tmp79_, TRUE);
		_tmp80_ = toolbar;
		_tmp81_ = webcam_button;
		gtk_container_add ((GtkContainer*) _tmp80_, (GtkWidget*) _tmp81_);
		_tmp82_ = webcam_button;
		g_signal_connect_object (_tmp82_, "clicked", (GCallback) ____lambda33__gtk_tool_button_clicked, self, 0);
		self->priv->has_device = TRUE;
		_g_object_unref0 (webcam_button);
	}
	_tmp83_ = frame_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp83_);
	_tmp84_ = self->priv->notebook;
	_tmp85_ = frame_grid;
	gtk_notebook_append_page (_tmp84_, (GtkWidget*) _tmp85_, NULL);
	_tmp86_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp86_);
	_g_object_unref0 (frame_grid);
	frame_grid = _tmp86_;
	_tmp87_ = frame_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp87_, GTK_ORIENTATION_VERTICAL);
	_tmp88_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp88_);
	_g_object_unref0 (toolbar);
	toolbar = _tmp88_;
	_tmp89_ = toolbar;
	_tmp90_ = gtk_widget_get_style_context ((GtkWidget*) _tmp89_);
	gtk_style_context_add_class (_tmp90_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp91_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp91_, GTK_ICON_SIZE_MENU);
	_tmp92_ = toolbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp92_, FALSE);
	_tmp93_ = frame_grid;
	_tmp94_ = toolbar;
	gtk_grid_attach (_tmp93_, (GtkWidget*) _tmp94_, 0, 1, 1, 1);
	_tmp95_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp95_);
	accept_button = _tmp95_;
	_tmp96_ = accept_button;
	gtk_tool_button_set_icon_name (_tmp96_, "object-select-symbolic");
	_tmp97_ = accept_button;
	_tmp98_ = gtk_widget_get_style_context ((GtkWidget*) _tmp97_);
	gtk_style_context_add_class (_tmp98_, GTK_STYLE_CLASS_RAISED);
	_tmp99_ = accept_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp99_, TRUE);
	_tmp100_ = toolbar;
	_tmp101_ = accept_button;
	gtk_container_add ((GtkContainer*) _tmp100_, (GtkWidget*) _tmp101_);
	_tmp102_ = accept_button;
	g_signal_connect_object (_tmp102_, "clicked", (GCallback) ___lambda34__gtk_tool_button_clicked, self, 0);
	_tmp103_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp103_);
	cancel_button = _tmp103_;
	_tmp104_ = cancel_button;
	gtk_tool_button_set_icon_name (_tmp104_, "edit-undo-symbolic");
	_tmp105_ = cancel_button;
	_tmp106_ = gtk_widget_get_style_context ((GtkWidget*) _tmp105_);
	gtk_style_context_add_class (_tmp106_, GTK_STYLE_CLASS_RAISED);
	_tmp107_ = cancel_button;
	gtk_tool_item_set_is_important ((GtkToolItem*) _tmp107_, TRUE);
	_tmp108_ = toolbar;
	_tmp109_ = cancel_button;
	gtk_container_add ((GtkContainer*) _tmp108_, (GtkWidget*) _tmp109_);
	_tmp110_ = cancel_button;
	g_signal_connect_object (_tmp110_, "clicked", (GCallback) ___lambda35__gtk_tool_button_clicked, self, 0);
	_tmp111_ = frame_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp111_);
	_tmp112_ = self->priv->notebook;
	_tmp113_ = frame_grid;
	gtk_notebook_append_page (_tmp112_, (GtkWidget*) _tmp113_, NULL);
	_tmp114_ = self->priv->has_device;
	if (_tmp114_) {
		GtkGrid* _tmp115_;
		GtkGrid* _tmp116_;
		GtkDrawingArea* _tmp117_;
		GtkDrawingArea* _tmp118_;
		GtkDrawingArea* _tmp119_;
		GtkGrid* _tmp120_;
		GtkDrawingArea* _tmp121_;
		CheeseFlash* _tmp122_;
		GtkToolbar* _tmp123_;
		GtkToolbar* _tmp124_;
		GtkStyleContext* _tmp125_ = NULL;
		GtkToolbar* _tmp126_;
		GtkToolbar* _tmp127_;
		GtkGrid* _tmp128_;
		GtkToolbar* _tmp129_;
		GtkToolButton* _tmp130_;
		GtkToolButton* _tmp131_;
		GtkToolButton* _tmp132_;
		GtkStyleContext* _tmp133_ = NULL;
		GtkToolButton* _tmp134_;
		GtkToolbar* _tmp135_;
		GtkToolButton* _tmp136_;
		GtkToolButton* _tmp137_;
		GtkToolButton* _tmp138_;
		GtkToolButton* _tmp139_;
		GtkToolButton* _tmp140_;
		GtkStyleContext* _tmp141_ = NULL;
		GtkToolButton* _tmp142_;
		GtkToolbar* _tmp143_;
		GtkToolButton* _tmp144_;
		GtkToolButton* _tmp145_;
		GtkGrid* _tmp146_;
		GtkNotebook* _tmp147_;
		GtkGrid* _tmp148_;
		_tmp115_ = (GtkGrid*) gtk_grid_new ();
		g_object_ref_sink (_tmp115_);
		_g_object_unref0 (frame_grid);
		frame_grid = _tmp115_;
		_tmp116_ = frame_grid;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp116_, GTK_ORIENTATION_VERTICAL);
		_tmp117_ = (GtkDrawingArea*) gtk_drawing_area_new ();
		g_object_ref_sink (_tmp117_);
		_g_object_unref0 (self->priv->photobooth_area);
		self->priv->photobooth_area = _tmp117_;
		_tmp118_ = self->priv->photobooth_area;
		gtk_widget_set_vexpand ((GtkWidget*) _tmp118_, TRUE);
		_tmp119_ = self->priv->photobooth_area;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp119_, TRUE);
		_tmp120_ = frame_grid;
		_tmp121_ = self->priv->photobooth_area;
		gtk_container_add ((GtkContainer*) _tmp120_, (GtkWidget*) _tmp121_);
		_tmp122_ = (CheeseFlash*) cheese_flash_new ();
		g_object_ref_sink (_tmp122_);
		_g_object_unref0 (self->priv->flash);
		self->priv->flash = _tmp122_;
		_tmp123_ = (GtkToolbar*) gtk_toolbar_new ();
		g_object_ref_sink (_tmp123_);
		_g_object_unref0 (toolbar);
		toolbar = _tmp123_;
		_tmp124_ = toolbar;
		_tmp125_ = gtk_widget_get_style_context ((GtkWidget*) _tmp124_);
		gtk_style_context_add_class (_tmp125_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
		_tmp126_ = toolbar;
		gtk_toolbar_set_icon_size (_tmp126_, GTK_ICON_SIZE_MENU);
		_tmp127_ = toolbar;
		gtk_widget_set_vexpand ((GtkWidget*) _tmp127_, FALSE);
		_tmp128_ = frame_grid;
		_tmp129_ = toolbar;
		gtk_grid_attach (_tmp128_, (GtkWidget*) _tmp129_, 0, 1, 1, 1);
		_tmp130_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
		g_object_ref_sink (_tmp130_);
		_g_object_unref0 (accept_button);
		accept_button = _tmp130_;
		_tmp131_ = accept_button;
		gtk_tool_button_set_icon_name (_tmp131_, "object-select-symbolic");
		_tmp132_ = accept_button;
		_tmp133_ = gtk_widget_get_style_context ((GtkWidget*) _tmp132_);
		gtk_style_context_add_class (_tmp133_, GTK_STYLE_CLASS_RAISED);
		_tmp134_ = accept_button;
		gtk_tool_item_set_is_important ((GtkToolItem*) _tmp134_, TRUE);
		_tmp135_ = toolbar;
		_tmp136_ = accept_button;
		gtk_container_add ((GtkContainer*) _tmp135_, (GtkWidget*) _tmp136_);
		_tmp137_ = accept_button;
		g_signal_connect_object (_tmp137_, "clicked", (GCallback) ____lambda36__gtk_tool_button_clicked, self, 0);
		_tmp138_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
		g_object_ref_sink (_tmp138_);
		_g_object_unref0 (cancel_button);
		cancel_button = _tmp138_;
		_tmp139_ = cancel_button;
		gtk_tool_button_set_icon_name (_tmp139_, "edit-undo-symbolic");
		_tmp140_ = cancel_button;
		_tmp141_ = gtk_widget_get_style_context ((GtkWidget*) _tmp140_);
		gtk_style_context_add_class (_tmp141_, GTK_STYLE_CLASS_RAISED);
		_tmp142_ = cancel_button;
		gtk_tool_item_set_is_important ((GtkToolItem*) _tmp142_, TRUE);
		_tmp143_ = toolbar;
		_tmp144_ = cancel_button;
		gtk_container_add ((GtkContainer*) _tmp143_, (GtkWidget*) _tmp144_);
		_tmp145_ = cancel_button;
		g_signal_connect_object (_tmp145_, "clicked", (GCallback) ____lambda37__gtk_tool_button_clicked, self, 0);
		_tmp146_ = frame_grid;
		gtk_widget_show_all ((GtkWidget*) _tmp146_);
		_tmp147_ = self->priv->notebook;
		_tmp148_ = frame_grid;
		gtk_notebook_append_page (_tmp147_, (GtkWidget*) _tmp148_, NULL);
	}
	_tmp149_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp149_, 0);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda38__gtk_dialog_response, self, 0);
	contacts_avatar_dialog_update_grid (self);
	_tmp150_ = grid;
	gtk_widget_show_all ((GtkWidget*) _tmp150_);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (accept_button);
	_g_object_unref0 (the_add_button);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (frame_grid);
	_g_object_unref0 (frame);
	_g_object_unref0 (label);
	_g_object_unref0 (container);
	_g_object_unref0 (grid);
	block36_data_unref (_data36_);
	_data36_ = NULL;
	return self;
}


ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact) {
	return contacts_avatar_dialog_construct (CONTACTS_TYPE_AVATAR_DIALOG, contact);
}


static gboolean contacts_avatar_dialog_setup_gstreamer_pipeline (ContactsAvatarDialog* self) {
	gboolean result = FALSE;
	GstPipeline* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* src;
	GstElement* _tmp2_ = NULL;
	GstPipeline* _tmp3_;
	GstElement* _tmp4_;
	GstElement* _tmp5_;
	GstElement* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GParamSpec* _tmp9_ = NULL;
	GParamSpec* pspec;
	GParamSpec* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = (GstPipeline*) gst_pipeline_new ("booth_pipeline");
	gst_object_ref_sink (_tmp0_);
	_gst_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp0_;
	_tmp1_ = gst_element_factory_make ("v4l2src", "video");
	if (_tmp1_ != NULL) {
		gst_object_ref_sink (_tmp1_);
	}
	src = _tmp1_;
	_tmp2_ = gst_element_factory_make ("xvimagesink", "sink");
	if (_tmp2_ != NULL) {
		gst_object_ref_sink (_tmp2_);
	}
	_gst_object_unref0 (self->priv->sink);
	self->priv->sink = _tmp2_;
	_tmp3_ = self->priv->pipeline;
	_tmp4_ = src;
	_tmp5_ = self->priv->sink;
	gst_bin_add_many ((GstBin*) _tmp3_, _tmp4_, _tmp5_, NULL);
	_tmp6_ = src;
	_tmp7_ = self->priv->sink;
	gst_element_link (_tmp6_, _tmp7_);
	_tmp8_ = src;
	_tmp9_ = gst_property_probe_get_property (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GST_TYPE_PROPERTY_PROBE) ? ((GstPropertyProbe*) _tmp8_) : NULL, "device");
	pspec = _tmp9_;
	_tmp10_ = pspec;
	if (_tmp10_ != NULL) {
		GstElement* _tmp11_;
		GParamSpec* _tmp12_;
		GValueArray* _tmp13_ = NULL;
		GValueArray* values;
		GValueArray* _tmp14_;
		_tmp11_ = src;
		_tmp12_ = pspec;
		_tmp13_ = gst_property_probe_probe_and_get_values (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GST_TYPE_PROPERTY_PROBE) ? ((GstPropertyProbe*) _tmp11_) : NULL, _tmp12_);
		values = _tmp13_;
		_tmp14_ = values;
		result = _tmp14_ != NULL;
		_gst_object_unref0 (src);
		return result;
	}
	result = FALSE;
	_gst_object_unref0 (src);
	return result;
}


static void contacts_avatar_dialog_class_init (ContactsAvatarDialogClass * klass) {
	contacts_avatar_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAvatarDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_dialog_finalize;
	g_signal_new ("set_avatar", CONTACTS_TYPE_AVATAR_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_ICON);
}


static void contacts_avatar_dialog_instance_init (ContactsAvatarDialog * self) {
	self->priv = CONTACTS_AVATAR_DIALOG_GET_PRIVATE (self);
	self->priv->has_device = FALSE;
}


static void contacts_avatar_dialog_finalize (GObject* obj) {
	ContactsAvatarDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog);
	_g_object_unref0 (self->priv->thumbnail_factory);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->crop_area);
	_g_object_unref0 (self->priv->view_grid);
	_g_object_unref0 (self->priv->main_frame);
	_g_object_unref0 (self->priv->photobooth_area);
	_g_object_unref0 (self->priv->flash);
	_gst_object_unref0 (self->priv->pipeline);
	_gst_object_unref0 (self->priv->sink);
	_g_object_unref0 (self->priv->new_pixbuf);
	G_OBJECT_CLASS (contacts_avatar_dialog_parent_class)->finalize (obj);
}


GType contacts_avatar_dialog_get_type (void) {
	static volatile gsize contacts_avatar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_avatar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatarDialog), 0, (GInstanceInitFunc) contacts_avatar_dialog_instance_init, NULL };
		GType contacts_avatar_dialog_type_id;
		contacts_avatar_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ContactsAvatarDialog", &g_define_type_info, 0);
		g_once_init_leave (&contacts_avatar_dialog_type_id__volatile, contacts_avatar_dialog_type_id);
	}
	return contacts_avatar_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



