/* valascope.c generated by valac, the Vala compiler
 * generated from valascope.vala, do not modify */

/* valascope.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
typedef struct _ValaScopePrivate ValaScopePrivate;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaParamSpecScope ValaParamSpecScope;

struct _ValaScope {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScopePrivate * priv;
};

struct _ValaScopeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScope *self);
};

struct _ValaScopePrivate {
	ValaSymbol* _owner;
	ValaScope* _parent_scope;
	ValaMap* symbol_table;
	ValaList* anonymous_members;
};

struct _ValaParamSpecScope {
	GParamSpec parent_instance;
};


static gpointer vala_scope_parent_class = NULL;

gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
#define VALA_SCOPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SCOPE, ValaScopePrivate))
enum  {
	VALA_SCOPE_DUMMY_PROPERTY
};
ValaScope* vala_scope_new (ValaSymbol* owner);
ValaScope* vala_scope_construct (GType object_type, ValaSymbol* owner);
void vala_scope_set_owner (ValaScope* self, ValaSymbol* value);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
ValaSymbol* vala_scope_get_owner (ValaScope* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
void vala_report_notice (ValaSourceReference* source, const gchar* message);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
void vala_scope_remove (ValaScope* self, const gchar* name);
gboolean vala_symbol_get_active (ValaSymbol* self);
gboolean vala_scope_is_subscope_of (ValaScope* self, ValaScope* scope);
ValaScope* vala_scope_get_parent_scope (ValaScope* self);
ValaMap* vala_scope_get_symbol_table (ValaScope* self);
void vala_scope_set_parent_scope (ValaScope* self, ValaScope* value);
static void vala_scope_finalize (ValaScope* obj);


/**
 * Creates a new scope.
 *
 * @return newly created scope
 */
ValaScope* vala_scope_construct (GType object_type, ValaSymbol* owner) {
	ValaScope* self = NULL;
	ValaSymbol* _tmp0_;
	self = (ValaScope*) g_type_create_instance (object_type);
	_tmp0_ = owner;
	vala_scope_set_owner (self, _tmp0_);
	return self;
}


ValaScope* vala_scope_new (ValaSymbol* owner) {
	return vala_scope_construct (VALA_TYPE_SCOPE, owner);
}


/**
 * Adds the specified symbol with the specified name to the symbol table
 * of this scope.
 *
 * @param name name for the specified symbol
 * @param sym  a symbol
 */
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym) {
	const gchar* _tmp0_;
	ValaSymbol* _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = name;
	if (_tmp0_ != NULL) {
		ValaMap* _tmp1_;
		ValaMap* _tmp42_;
		const gchar* _tmp43_;
		ValaSymbol* _tmp44_;
		_tmp1_ = self->priv->symbol_table;
		if (_tmp1_ == NULL) {
			GHashFunc _tmp2_;
			GEqualFunc _tmp3_;
			GEqualFunc _tmp4_;
			ValaHashMap* _tmp5_;
			_tmp2_ = g_str_hash;
			_tmp3_ = g_str_equal;
			_tmp4_ = g_direct_equal;
			_tmp5_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp2_, _tmp3_, _tmp4_);
			_vala_map_unref0 (self->priv->symbol_table);
			self->priv->symbol_table = (ValaMap*) _tmp5_;
		} else {
			const gchar* _tmp6_;
			ValaSymbol* _tmp7_ = NULL;
			ValaSymbol* _tmp8_;
			gboolean _tmp9_;
			_tmp6_ = name;
			_tmp7_ = vala_scope_lookup (self, _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_ != NULL;
			_vala_code_node_unref0 (_tmp8_);
			if (_tmp9_) {
				ValaSymbol* _tmp10_;
				gboolean _tmp11_ = FALSE;
				ValaSymbol* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gboolean _tmp18_;
				const gchar* _tmp34_;
				ValaSymbol* _tmp35_ = NULL;
				ValaSymbol* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_;
				_tmp10_ = self->priv->_owner;
				vala_code_node_set_error ((ValaCodeNode*) _tmp10_, TRUE);
				_tmp12_ = self->priv->_owner;
				_tmp13_ = vala_symbol_get_name (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == NULL) {
					ValaSymbol* _tmp15_;
					ValaSymbol* _tmp16_;
					ValaSymbol* _tmp17_;
					_tmp15_ = self->priv->_owner;
					_tmp16_ = vala_symbol_get_parent_symbol (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp11_ = _tmp17_ == NULL;
				} else {
					_tmp11_ = FALSE;
				}
				_tmp18_ = _tmp11_;
				if (_tmp18_) {
					ValaSymbol* _tmp19_;
					ValaSourceReference* _tmp20_;
					ValaSourceReference* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					_tmp19_ = sym;
					_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = name;
					_tmp23_ = g_strdup_printf ("The root namespace already contains a definition for `%s'", _tmp22_);
					_tmp24_ = _tmp23_;
					vala_report_error (_tmp21_, _tmp24_);
					_g_free0 (_tmp24_);
				} else {
					ValaSymbol* _tmp25_;
					ValaSourceReference* _tmp26_;
					ValaSourceReference* _tmp27_;
					ValaSymbol* _tmp28_;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_;
					_tmp25_ = sym;
					_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = self->priv->_owner;
					_tmp29_ = vala_symbol_get_full_name (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = name;
					_tmp32_ = g_strdup_printf ("`%s' already contains a definition for `%s'", _tmp30_, _tmp31_);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp27_, _tmp33_);
					_g_free0 (_tmp33_);
					_g_free0 (_tmp30_);
				}
				_tmp34_ = name;
				_tmp35_ = vala_scope_lookup (self, _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = name;
				_tmp40_ = g_strdup_printf ("previous definition of `%s' was here", _tmp39_);
				_tmp41_ = _tmp40_;
				vala_report_notice (_tmp38_, _tmp41_);
				_g_free0 (_tmp41_);
				_vala_code_node_unref0 (_tmp36_);
				return;
			}
		}
		_tmp42_ = self->priv->symbol_table;
		_tmp43_ = name;
		_tmp44_ = sym;
		vala_map_set (_tmp42_, (const gchar*) _tmp43_, _tmp44_);
	} else {
		ValaList* _tmp45_;
		ValaList* _tmp48_;
		ValaSymbol* _tmp49_;
		_tmp45_ = self->priv->anonymous_members;
		if (_tmp45_ == NULL) {
			GEqualFunc _tmp46_;
			ValaArrayList* _tmp47_;
			_tmp46_ = g_direct_equal;
			_tmp47_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp46_);
			_vala_iterable_unref0 (self->priv->anonymous_members);
			self->priv->anonymous_members = (ValaList*) _tmp47_;
		}
		_tmp48_ = self->priv->anonymous_members;
		_tmp49_ = sym;
		vala_collection_add ((ValaCollection*) _tmp48_, _tmp49_);
	}
	_tmp50_ = sym;
	vala_symbol_set_owner (_tmp50_, self);
}


void vala_scope_remove (ValaScope* self, const gchar* name) {
	ValaMap* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->symbol_table;
	_tmp1_ = name;
	vala_map_remove (_tmp0_, _tmp1_);
}


/**
 * Returns the symbol stored in the symbol table with the specified
 * name.
 *
 * @param name name of the symbol to be returned
 * @return     found symbol or null
 */
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name) {
	ValaSymbol* result = NULL;
	ValaMap* _tmp0_;
	ValaMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_ = NULL;
	ValaSymbol* sym;
	gboolean _tmp4_ = FALSE;
	ValaSymbol* _tmp5_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->symbol_table;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->symbol_table;
	_tmp2_ = name;
	_tmp3_ = vala_map_get (_tmp1_, _tmp2_);
	sym = (ValaSymbol*) _tmp3_;
	_tmp5_ = sym;
	if (_tmp5_ != NULL) {
		ValaSymbol* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = sym;
		_tmp7_ = vala_symbol_get_active (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = !_tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		_vala_code_node_unref0 (sym);
		sym = NULL;
	}
	result = sym;
	return result;
}


/**
 * Returns whether the specified scope is an ancestor of this scope.
 *
 * @param scope a scope or null for the root scope
 * @return      true if this scope is a subscope of the specified
 *              scope, false otherwise
 */
gboolean vala_scope_is_subscope_of (ValaScope* self, ValaScope* scope) {
	gboolean result = FALSE;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = scope;
	if (_tmp0_ == self) {
		result = TRUE;
		return result;
	}
	_tmp1_ = scope;
	if (_tmp1_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->_parent_scope;
	if (_tmp2_ != NULL) {
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = self->priv->_parent_scope;
		_tmp4_ = scope;
		_tmp5_ = vala_scope_is_subscope_of (_tmp3_, _tmp4_);
		result = _tmp5_;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _vala_map_ref0 (gpointer self) {
	return self ? vala_map_ref (self) : NULL;
}


ValaMap* vala_scope_get_symbol_table (ValaScope* self) {
	ValaMap* result = NULL;
	ValaMap* _tmp0_;
	ValaMap* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->symbol_table;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaSymbol* vala_scope_get_owner (ValaScope* self) {
	ValaSymbol* result;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}


void vala_scope_set_owner (ValaScope* self, ValaSymbol* value) {
	ValaSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_owner = _tmp0_;
}


ValaScope* vala_scope_get_parent_scope (ValaScope* self) {
	ValaScope* result;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_scope;
	result = _tmp0_;
	return result;
}


void vala_scope_set_parent_scope (ValaScope* self, ValaScope* value) {
	ValaScope* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_parent_scope = _tmp0_;
}


static void vala_value_scope_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_scope_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_scope_unref (value->data[0].v_pointer);
	}
}


static void vala_value_scope_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scope_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_scope_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_scope_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaScope* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scope_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_scope_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaScope** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scope_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecScope* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCOPE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_scope (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_scope (GValue* value, gpointer v_object) {
	ValaScope* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCOPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scope_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scope_unref (old);
	}
}


void vala_value_take_scope (GValue* value, gpointer v_object) {
	ValaScope* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCOPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scope_unref (old);
	}
}


static void vala_scope_class_init (ValaScopeClass * klass) {
	vala_scope_parent_class = g_type_class_peek_parent (klass);
	VALA_SCOPE_CLASS (klass)->finalize = vala_scope_finalize;
	g_type_class_add_private (klass, sizeof (ValaScopePrivate));
}


static void vala_scope_instance_init (ValaScope * self) {
	self->priv = VALA_SCOPE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_scope_finalize (ValaScope* obj) {
	ValaScope * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SCOPE, ValaScope);
	_vala_map_unref0 (self->priv->symbol_table);
	_vala_iterable_unref0 (self->priv->anonymous_members);
}


/**
 * Represents a part of the symbol tree.
 */
GType vala_scope_get_type (void) {
	static volatile gsize vala_scope_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scope_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scope_init, vala_value_scope_free_value, vala_value_scope_copy_value, vala_value_scope_peek_pointer, "p", vala_value_scope_collect_value, "p", vala_value_scope_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScopeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scope_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScope), 0, (GInstanceInitFunc) vala_scope_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scope_type_id;
		vala_scope_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScope", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_scope_type_id__volatile, vala_scope_type_id);
	}
	return vala_scope_type_id__volatile;
}


gpointer vala_scope_ref (gpointer instance) {
	ValaScope* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_scope_unref (gpointer instance) {
	ValaScope* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCOPE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



