/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaExpression* arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaExpression* _tmp17_;
			_arg_index = _arg_index + 1;
			_tmp13_ = _arg_index;
			_tmp14_ = _arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _arg_index);
			arg = (ValaExpression*) _tmp16_;
			_tmp17_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _init_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _init_index = 0;
		_tmp18_ = self->priv->object_initializer;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_init_list = _tmp19_;
		_tmp20_ = _init_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_init_size = _tmp22_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaMemberInitializer* _tmp27_;
			_init_index = _init_index + 1;
			_tmp23_ = _init_index;
			_tmp24_ = _init_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _init_list;
			_tmp26_ = vala_list_get (_tmp25_, _init_index);
			init = (ValaMemberInitializer*) _tmp26_;
			_tmp27_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* arg = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			_arg_index = _arg_index + 1;
			_tmp10_ = _arg_index;
			_tmp11_ = _arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _arg_list;
			_tmp13_ = vala_list_get (_tmp12_, _arg_index);
			arg = (ValaExpression*) _tmp13_;
			_tmp14_ = arg;
			if (!vala_expression_is_accessible (_tmp14_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _init_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _init_index = 0;
		_tmp15_ = self->priv->object_initializer;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_init_list = _tmp16_;
		_tmp17_ = _init_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_init_size = _tmp19_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaMemberInitializer* _tmp24_;
			ValaExpression* _tmp25_;
			ValaExpression* _tmp26_;
			_init_index = _init_index + 1;
			_tmp20_ = _init_index;
			_tmp21_ = _init_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _init_list;
			_tmp23_ = vala_list_get (_tmp22_, _init_index);
			init = (ValaMemberInitializer*) _tmp23_;
			_tmp24_ = init;
			_tmp25_ = vala_member_initializer_get_initializer (_tmp24_);
			_tmp26_ = _tmp25_;
			if (!vala_expression_is_accessible (_tmp26_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	ValaDataType* _tmp116_;
	ValaTypeSymbol* _tmp117_;
	ValaDataType* _tmp231_;
	ValaDataType* _tmp232_;
	gboolean _tmp233_ = FALSE;
	ValaSymbol* _tmp234_;
	ValaSymbol* _tmp235_;
	ValaSymbol* _tmp246_;
	ValaSymbol* _tmp247_;
	ValaTypeSymbol* _tmp505_;
	gboolean _tmp506_;
	gboolean _tmp507_;
	gboolean _tmp526_;
	gboolean _tmp527_;
	gboolean _tmp583_;
	gboolean _tmp584_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp56_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		type_args = _tmp31_;
		_tmp32_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp32_)) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp37_;
			ValaMethod* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaMethod* _tmp47_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp48_;
			ValaMemberAccess* _tmp49_;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp33_ = constructor_sym;
			_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _vala_code_node_ref0 (_tmp35_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp36_;
			_tmp37_ = constructor_sym;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp38_;
			_tmp39_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaMethod* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = constructor;
				_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strdup_printf ("`%s' is not a creation method", _tmp44_);
				_tmp46_ = _tmp45_;
				vala_report_error (_tmp41_, _tmp46_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp44_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp47_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp47_);
			_tmp48_ = vala_object_creation_expression_get_member_name (self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_member_access_get_inner (_tmp49_);
			_tmp51_ = _tmp50_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				ValaList* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_tmp55_ = _vala_iterable_ref0 (_tmp54_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp55_;
			}
			_vala_code_node_unref0 (constructor);
		}
		_tmp56_ = type_sym;
		if (VALA_IS_CLASS (_tmp56_)) {
			ValaSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			gboolean _tmp60_;
			gboolean _tmp61_;
			_tmp57_ = type_sym;
			_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp58_;
			_tmp59_ = type;
			_tmp60_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CLASS, ValaClass));
			_tmp61_ = _tmp60_;
			if (_tmp61_) {
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaErrorType* _tmp64_;
				ValaErrorType* _tmp65_;
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_error_type_new (NULL, NULL, _tmp63_);
				_tmp65_ = _tmp64_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp65_);
				_vala_code_node_unref0 (_tmp65_);
			} else {
				ValaTypeSymbol* _tmp66_;
				ValaObjectType* _tmp67_;
				ValaObjectType* _tmp68_;
				_tmp66_ = type;
				_tmp67_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_CLASS, ValaClass));
				_tmp68_ = _tmp67_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
			}
		} else {
			ValaSymbol* _tmp69_;
			_tmp69_ = type_sym;
			if (VALA_IS_STRUCT (_tmp69_)) {
				ValaSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaStructValueType* _tmp73_;
				ValaStructValueType* _tmp74_;
				_tmp70_ = type_sym;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp71_;
				_tmp72_ = type;
				_tmp73_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp74_ = _tmp73_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp74_);
				_vala_code_node_unref0 (_tmp74_);
			} else {
				ValaSymbol* _tmp75_;
				_tmp75_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp75_)) {
					ValaSymbol* _tmp76_;
					ValaTypeSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSymbol* _tmp79_;
					ValaSymbol* _tmp80_;
					ValaSymbol* _tmp81_;
					ValaSourceReference* _tmp82_;
					ValaSourceReference* _tmp83_;
					ValaErrorType* _tmp84_;
					ValaErrorType* _tmp85_;
					ValaSymbol* _tmp86_;
					_tmp76_ = type_sym;
					_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
					_vala_code_node_unref0 (type);
					type = _tmp77_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_symbol_get_parent_symbol (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = type_sym;
					_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp83_ = _tmp82_;
					_tmp84_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp83_);
					_tmp85_ = _tmp84_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp85_);
					_vala_code_node_unref0 (_tmp85_);
					_tmp86_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp86_);
				} else {
					ValaSourceReference* _tmp87_;
					ValaSourceReference* _tmp88_;
					ValaSymbol* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp88_ = _tmp87_;
					_tmp89_ = type_sym;
					_tmp90_ = vala_symbol_get_full_name (_tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp91_);
					_tmp93_ = _tmp92_;
					vala_report_error (_tmp88_, _tmp93_);
					_g_free0 (_tmp93_);
					_g_free0 (_tmp91_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp94_;
			ValaList* _tmp95_;
			gint _type_arg_size = 0;
			ValaList* _tmp96_;
			gint _tmp97_;
			gint _tmp98_;
			gint _type_arg_index = 0;
			_tmp94_ = type_args;
			_tmp95_ = _vala_iterable_ref0 (_tmp94_);
			_type_arg_list = _tmp95_;
			_tmp96_ = _type_arg_list;
			_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
			_tmp98_ = _tmp97_;
			_type_arg_size = _tmp98_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp99_;
				gint _tmp100_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp101_;
				gpointer _tmp102_;
				ValaDataType* _tmp103_;
				ValaDataType* _tmp104_;
				ValaDataType* _tmp105_;
				_type_arg_index = _type_arg_index + 1;
				_tmp99_ = _type_arg_index;
				_tmp100_ = _type_arg_size;
				if (!(_tmp99_ < _tmp100_)) {
					break;
				}
				_tmp101_ = _type_arg_list;
				_tmp102_ = vala_list_get (_tmp101_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp102_;
				_tmp103_ = vala_object_creation_expression_get_type_reference (self);
				_tmp104_ = _tmp103_;
				_tmp105_ = type_arg;
				vala_data_type_add_type_argument (_tmp104_, _tmp105_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp106_;
		ValaDataType* _tmp107_;
		ValaTypeSymbol* _tmp108_;
		ValaTypeSymbol* _tmp109_;
		ValaTypeSymbol* _tmp110_;
		_tmp106_ = vala_object_creation_expression_get_type_reference (self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_data_type_get_type_symbol (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = _vala_code_node_ref0 (_tmp109_);
		_vala_code_node_unref0 (type);
		type = _tmp110_;
	}
	_tmp111_ = vala_object_creation_expression_get_type_reference (self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_data_type_copy (_tmp112_);
	_tmp114_ = _tmp113_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp114_);
	_vala_code_node_unref0 (_tmp114_);
	_tmp115_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp116_ = _tmp115_;
	vala_data_type_set_value_owned (_tmp116_, TRUE);
	_tmp117_ = type;
	if (VALA_IS_CLASS (_tmp117_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp118_;
		ValaClass* _tmp119_;
		gboolean _tmp120_;
		ValaClass* _tmp123_;
		gboolean _tmp124_;
		gboolean _tmp125_;
		ValaSymbol* _tmp133_;
		ValaSymbol* _tmp134_;
		gboolean _tmp155_ = FALSE;
		ValaSymbol* _tmp156_;
		ValaSymbol* _tmp157_;
		_tmp118_ = type;
		_tmp119_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp119_;
		_tmp120_ = self->priv->_struct_creation;
		if (_tmp120_) {
			ValaSourceReference* _tmp121_;
			ValaSourceReference* _tmp122_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp122_ = _tmp121_;
			vala_report_error (_tmp122_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp123_ = cl;
		_tmp124_ = vala_class_get_is_abstract (_tmp123_);
		_tmp125_ = _tmp124_;
		if (_tmp125_) {
			ValaSourceReference* _tmp126_;
			ValaSourceReference* _tmp127_;
			ValaClass* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp127_ = _tmp126_;
			_tmp128_ = cl;
			_tmp129_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp130_);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp127_, _tmp132_);
			_g_free0 (_tmp132_);
			_g_free0 (_tmp130_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp133_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp134_ = _tmp133_;
		if (_tmp134_ == NULL) {
			ValaClass* _tmp135_;
			ValaCreationMethod* _tmp136_;
			ValaCreationMethod* _tmp137_;
			ValaSymbol* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp147_;
			ValaSymbol* _tmp148_;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaVersionAttribute* _tmp151_;
			ValaVersionAttribute* _tmp152_;
			ValaSourceReference* _tmp153_;
			ValaSourceReference* _tmp154_;
			_tmp135_ = cl;
			_tmp136_ = vala_class_get_default_construction_method (_tmp135_);
			_tmp137_ = _tmp136_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp137_);
			_tmp138_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp139_ = _tmp138_;
			if (_tmp139_ == NULL) {
				ValaSourceReference* _tmp140_;
				ValaSourceReference* _tmp141_;
				ValaClass* _tmp142_;
				gchar* _tmp143_;
				gchar* _tmp144_;
				gchar* _tmp145_;
				gchar* _tmp146_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp141_ = _tmp140_;
				_tmp142_ = cl;
				_tmp143_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp142_);
				_tmp144_ = _tmp143_;
				_tmp145_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp144_);
				_tmp146_ = _tmp145_;
				vala_report_error (_tmp141_, _tmp146_);
				_g_free0 (_tmp146_);
				_g_free0 (_tmp144_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp148_ = _tmp147_;
			vala_symbol_set_used (_tmp148_, TRUE);
			_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_symbol_get_version (_tmp150_);
			_tmp152_ = _tmp151_;
			_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp154_ = _tmp153_;
			vala_version_attribute_check (_tmp152_, context, _tmp154_);
		}
		_tmp156_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp157_ = _tmp156_;
		if (_tmp157_ != NULL) {
			gboolean _tmp158_ = FALSE;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			ValaSymbolAccessibility _tmp161_;
			ValaSymbolAccessibility _tmp162_;
			_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_symbol_get_access (_tmp160_);
			_tmp162_ = _tmp161_;
			if (_tmp162_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp158_ = TRUE;
			} else {
				ValaSymbol* _tmp163_;
				ValaSymbol* _tmp164_;
				ValaSymbolAccessibility _tmp165_;
				ValaSymbolAccessibility _tmp166_;
				_tmp163_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp164_ = _tmp163_;
				_tmp165_ = vala_symbol_get_access (_tmp164_);
				_tmp166_ = _tmp165_;
				_tmp158_ = _tmp166_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp155_ = _tmp158_;
		} else {
			_tmp155_ = FALSE;
		}
		if (_tmp155_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp167_;
				ValaSemanticAnalyzer* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaSymbol* _tmp170_;
				ValaSymbol* _tmp171_;
				_tmp167_ = vala_code_context_get_analyzer (context);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_semantic_analyzer_get_current_symbol (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = _vala_code_node_ref0 (_tmp170_);
				this_symbol = _tmp171_;
				{
					gboolean _tmp172_ = FALSE;
					_tmp172_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp177_;
						ValaSymbol* _tmp178_;
						ValaClass* _tmp179_;
						if (!_tmp172_) {
							ValaSymbol* _tmp173_;
							ValaSymbol* _tmp174_;
							ValaSymbol* _tmp175_;
							ValaSymbol* _tmp176_;
							_tmp173_ = this_symbol;
							_tmp174_ = vala_symbol_get_parent_symbol (_tmp173_);
							_tmp175_ = _tmp174_;
							_tmp176_ = _vala_code_node_ref0 (_tmp175_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp176_;
						}
						_tmp172_ = FALSE;
						_tmp177_ = this_symbol;
						if (!(_tmp177_ != NULL)) {
							break;
						}
						_tmp178_ = this_symbol;
						_tmp179_ = cl;
						if (_tmp178_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp179_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp180_;
				ValaSourceReference* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp180_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_symbol_get_full_name (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp186_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp185_);
				_tmp187_ = _tmp186_;
				vala_report_error (_tmp181_, _tmp187_);
				_g_free0 (_tmp187_);
				_g_free0 (_tmp185_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp188_;
			ValaClass* _tmp189_;
			gchar* _tmp190_;
			gchar* _tmp191_;
			gboolean _tmp192_;
			ValaClass* _tmp195_;
			ValaClass* _tmp196_;
			ValaClass* _tmp197_;
			ValaClass* _tmp198_;
			_tmp188_ = cl;
			if (!(_tmp188_ != NULL)) {
				break;
			}
			_tmp189_ = cl;
			_tmp190_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp189_, "CCode", "ref_sink_function", NULL);
			_tmp191_ = _tmp190_;
			_tmp192_ = _tmp191_ != NULL;
			_g_free0 (_tmp191_);
			if (_tmp192_) {
				ValaDataType* _tmp193_;
				ValaDataType* _tmp194_;
				_tmp193_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp194_ = _tmp193_;
				vala_data_type_set_floating_reference (_tmp194_, TRUE);
				break;
			}
			_tmp195_ = cl;
			_tmp196_ = vala_class_get_base_class (_tmp195_);
			_tmp197_ = _tmp196_;
			_tmp198_ = _vala_code_node_ref0 (_tmp197_);
			_vala_code_node_unref0 (cl);
			cl = _tmp198_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp199_;
		_tmp199_ = type;
		if (VALA_IS_STRUCT (_tmp199_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp200_;
			ValaStruct* _tmp201_;
			gboolean _tmp202_ = FALSE;
			gboolean _tmp203_;
			ValaSymbol* _tmp208_;
			ValaSymbol* _tmp209_;
			gboolean _tmp213_ = FALSE;
			gboolean _tmp214_ = FALSE;
			gboolean _tmp215_ = FALSE;
			ValaProfile _tmp216_;
			ValaProfile _tmp217_;
			_tmp200_ = type;
			_tmp201_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp201_;
			_tmp203_ = self->priv->_struct_creation;
			if (!_tmp203_) {
				gboolean _tmp204_;
				gboolean _tmp205_;
				_tmp204_ = vala_code_context_get_deprecated (context);
				_tmp205_ = _tmp204_;
				_tmp202_ = !_tmp205_;
			} else {
				_tmp202_ = FALSE;
			}
			if (_tmp202_) {
				ValaSourceReference* _tmp206_;
				ValaSourceReference* _tmp207_;
				_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp207_ = _tmp206_;
				vala_report_warning (_tmp207_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp208_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp209_ = _tmp208_;
			if (_tmp209_ == NULL) {
				ValaStruct* _tmp210_;
				ValaCreationMethod* _tmp211_;
				ValaCreationMethod* _tmp212_;
				_tmp210_ = st;
				_tmp211_ = vala_struct_get_default_construction_method (_tmp210_);
				_tmp212_ = _tmp211_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp212_);
			}
			_tmp216_ = vala_code_context_get_profile (context);
			_tmp217_ = _tmp216_;
			if (_tmp217_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp218_;
				_tmp218_ = st;
				_tmp215_ = vala_struct_is_simple_type (_tmp218_);
			} else {
				_tmp215_ = FALSE;
			}
			if (_tmp215_) {
				ValaSymbol* _tmp219_;
				ValaSymbol* _tmp220_;
				_tmp219_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp220_ = _tmp219_;
				_tmp214_ = _tmp220_ == NULL;
			} else {
				_tmp214_ = FALSE;
			}
			if (_tmp214_) {
				ValaList* _tmp221_;
				gint _tmp222_;
				gint _tmp223_;
				_tmp221_ = self->priv->object_initializer;
				_tmp222_ = vala_collection_get_size ((ValaCollection*) _tmp221_);
				_tmp223_ = _tmp222_;
				_tmp213_ = _tmp223_ == 0;
			} else {
				_tmp213_ = FALSE;
			}
			if (_tmp213_) {
				ValaSourceReference* _tmp224_;
				ValaSourceReference* _tmp225_;
				ValaStruct* _tmp226_;
				gchar* _tmp227_;
				gchar* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp225_ = _tmp224_;
				_tmp226_ = st;
				_tmp227_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp226_);
				_tmp228_ = _tmp227_;
				_tmp229_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp228_);
				_tmp230_ = _tmp229_;
				vala_report_error (_tmp225_, _tmp230_);
				_g_free0 (_tmp230_);
				_g_free0 (_tmp228_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp231_ = vala_object_creation_expression_get_type_reference (self);
	_tmp232_ = _tmp231_;
	if (!vala_data_type_check_type_arguments (_tmp232_, context, FALSE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp234_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp235_ = _tmp234_;
	if (_tmp235_ == NULL) {
		ValaList* _tmp236_;
		gint _tmp237_;
		gint _tmp238_;
		_tmp236_ = self->priv->argument_list;
		_tmp237_ = vala_collection_get_size ((ValaCollection*) _tmp236_);
		_tmp238_ = _tmp237_;
		_tmp233_ = _tmp238_ != 0;
	} else {
		_tmp233_ = FALSE;
	}
	if (_tmp233_) {
		ValaSourceReference* _tmp239_;
		ValaSourceReference* _tmp240_;
		ValaTypeSymbol* _tmp241_;
		gchar* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp239_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp240_ = _tmp239_;
		_tmp241_ = type;
		_tmp242_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp241_);
		_tmp243_ = _tmp242_;
		_tmp244_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp243_);
		_tmp245_ = _tmp244_;
		vala_report_error (_tmp240_, _tmp245_);
		_g_free0 (_tmp245_);
		_g_free0 (_tmp243_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp246_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp247_ = _tmp246_;
	if (VALA_IS_METHOD (_tmp247_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp248_;
		ValaSymbol* _tmp249_;
		ValaMethod* _tmp250_;
		gboolean _tmp251_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp276_;
		ValaIterator* _tmp277_;
		ValaMethod* _tmp329_;
		gboolean _tmp330_;
		gboolean _tmp331_;
		ValaSemanticAnalyzer* _tmp396_;
		ValaSemanticAnalyzer* _tmp397_;
		ValaMethod* _tmp398_;
		ValaMethodType* _tmp399_;
		ValaMethodType* _tmp400_;
		ValaMethod* _tmp401_;
		ValaList* _tmp402_;
		ValaList* _tmp403_;
		_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp249_ = _tmp248_;
		_tmp250_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp249_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp250_;
		_tmp251_ = self->priv->_is_yield_expression;
		if (_tmp251_) {
			ValaMethod* _tmp252_;
			gboolean _tmp253_;
			gboolean _tmp254_;
			gboolean _tmp257_ = FALSE;
			ValaSemanticAnalyzer* _tmp258_;
			ValaSemanticAnalyzer* _tmp259_;
			ValaMethod* _tmp260_;
			ValaMethod* _tmp261_;
			_tmp252_ = m;
			_tmp253_ = vala_method_get_coroutine (_tmp252_);
			_tmp254_ = _tmp253_;
			if (!_tmp254_) {
				ValaSourceReference* _tmp255_;
				ValaSourceReference* _tmp256_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp256_ = _tmp255_;
				vala_report_error (_tmp256_, "yield expression requires async method");
			}
			_tmp258_ = vala_code_context_get_analyzer (context);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_semantic_analyzer_get_current_method (_tmp259_);
			_tmp261_ = _tmp260_;
			if (_tmp261_ == NULL) {
				_tmp257_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp262_;
				ValaSemanticAnalyzer* _tmp263_;
				ValaMethod* _tmp264_;
				ValaMethod* _tmp265_;
				gboolean _tmp266_;
				gboolean _tmp267_;
				_tmp262_ = vala_code_context_get_analyzer (context);
				_tmp263_ = _tmp262_;
				_tmp264_ = vala_semantic_analyzer_get_current_method (_tmp263_);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_method_get_coroutine (_tmp265_);
				_tmp267_ = _tmp266_;
				_tmp257_ = !_tmp267_;
			}
			if (_tmp257_) {
				ValaSourceReference* _tmp268_;
				ValaSourceReference* _tmp269_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp269_ = _tmp268_;
				vala_report_error (_tmp269_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp270_;
			_tmp270_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp270_)) {
				ValaMethod* _tmp271_;
				gboolean _tmp272_;
				gboolean _tmp273_;
				_tmp271_ = m;
				_tmp272_ = vala_method_get_coroutine (_tmp271_);
				_tmp273_ = _tmp272_;
				if (_tmp273_) {
					ValaSourceReference* _tmp274_;
					ValaSourceReference* _tmp275_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp275_ = _tmp274_;
					vala_report_error (_tmp275_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp276_ = self->priv->argument_list;
		_tmp277_ = vala_iterable_iterator ((ValaIterable*) _tmp276_);
		arg_it = _tmp277_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp278_;
			ValaList* _tmp279_;
			ValaList* _tmp280_;
			gint _param_size = 0;
			ValaList* _tmp281_;
			gint _tmp282_;
			gint _tmp283_;
			gint _param_index = 0;
			_tmp278_ = m;
			_tmp279_ = vala_callable_get_parameters ((ValaCallable*) _tmp278_);
			_tmp280_ = _vala_iterable_ref0 (_tmp279_);
			_param_list = _tmp280_;
			_tmp281_ = _param_list;
			_tmp282_ = vala_collection_get_size ((ValaCollection*) _tmp281_);
			_tmp283_ = _tmp282_;
			_param_size = _tmp283_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp284_;
				gint _tmp285_;
				ValaParameter* param = NULL;
				ValaList* _tmp286_;
				gpointer _tmp287_;
				ValaParameter* _tmp288_;
				ValaParameter* _tmp289_;
				gboolean _tmp290_;
				gboolean _tmp291_;
				ValaParameter* _tmp292_;
				gboolean _tmp293_;
				gboolean _tmp294_;
				ValaIterator* _tmp312_;
				_param_index = _param_index + 1;
				_tmp284_ = _param_index;
				_tmp285_ = _param_size;
				if (!(_tmp284_ < _tmp285_)) {
					break;
				}
				_tmp286_ = _param_list;
				_tmp287_ = vala_list_get (_tmp286_, _param_index);
				param = (ValaParameter*) _tmp287_;
				_tmp288_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp288_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp289_ = param;
				_tmp290_ = vala_parameter_get_ellipsis (_tmp289_);
				_tmp291_ = _tmp290_;
				if (_tmp291_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp292_ = param;
				_tmp293_ = vala_parameter_get_params_array (_tmp292_);
				_tmp294_ = _tmp293_;
				if (_tmp294_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp295_;
					ValaDataType* _tmp296_;
					ValaDataType* _tmp297_;
					ValaArrayType* _tmp298_;
					_tmp295_ = param;
					_tmp296_ = vala_variable_get_variable_type ((ValaVariable*) _tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp297_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp298_;
					while (TRUE) {
						ValaIterator* _tmp299_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp300_;
						gpointer _tmp301_;
						ValaExpression* _tmp302_;
						ValaArrayType* _tmp303_;
						ValaDataType* _tmp304_;
						ValaDataType* _tmp305_;
						ValaExpression* _tmp306_;
						ValaDataType* _tmp307_;
						ValaDataType* _tmp308_;
						ValaArrayType* _tmp309_;
						gboolean _tmp310_;
						gboolean _tmp311_;
						_tmp299_ = arg_it;
						if (!vala_iterator_next (_tmp299_)) {
							break;
						}
						_tmp300_ = arg_it;
						_tmp301_ = vala_iterator_get (_tmp300_);
						arg = (ValaExpression*) _tmp301_;
						_tmp302_ = arg;
						_tmp303_ = array_type;
						_tmp304_ = vala_array_type_get_element_type (_tmp303_);
						_tmp305_ = _tmp304_;
						vala_expression_set_target_type (_tmp302_, _tmp305_);
						_tmp306_ = arg;
						_tmp307_ = vala_expression_get_target_type (_tmp306_);
						_tmp308_ = _tmp307_;
						_tmp309_ = array_type;
						_tmp310_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp309_);
						_tmp311_ = _tmp310_;
						vala_data_type_set_value_owned (_tmp308_, _tmp311_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp312_ = arg_it;
				if (vala_iterator_next (_tmp312_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp313_;
					gpointer _tmp314_;
					ValaExpression* _tmp315_;
					ValaParameter* _tmp316_;
					ValaDataType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaExpression* _tmp319_;
					ValaExpression* _tmp320_;
					ValaDataType* _tmp321_;
					ValaDataType* _tmp322_;
					ValaDataType* _tmp323_;
					ValaDataType* _tmp324_;
					ValaDataType* _tmp325_;
					ValaDataType* _tmp326_;
					ValaExpression* _tmp327_;
					ValaExpression* _tmp328_;
					_tmp313_ = arg_it;
					_tmp314_ = vala_iterator_get (_tmp313_);
					arg = (ValaExpression*) _tmp314_;
					_tmp315_ = arg;
					_tmp316_ = param;
					_tmp317_ = vala_variable_get_variable_type ((ValaVariable*) _tmp316_);
					_tmp318_ = _tmp317_;
					vala_expression_set_formal_target_type (_tmp315_, _tmp318_);
					_tmp319_ = arg;
					_tmp320_ = arg;
					_tmp321_ = vala_expression_get_formal_target_type (_tmp320_);
					_tmp322_ = _tmp321_;
					_tmp323_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp324_ = _tmp323_;
					_tmp325_ = vala_data_type_get_actual_type (_tmp322_, _tmp324_, NULL, (ValaCodeNode*) self);
					_tmp326_ = _tmp325_;
					vala_expression_set_target_type (_tmp319_, _tmp326_);
					_vala_code_node_unref0 (_tmp326_);
					_tmp327_ = arg;
					_tmp328_ = _vala_code_node_ref0 (_tmp327_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp328_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp329_ = m;
		_tmp330_ = vala_method_get_printf_format (_tmp329_);
		_tmp331_ = _tmp330_;
		if (_tmp331_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp332_;
			ValaStringLiteral* _tmp377_;
			format_literal = NULL;
			_tmp332_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp332_)) {
			} else {
				ValaExpression* _tmp333_;
				_tmp333_ = last_arg;
				if (_tmp333_ != NULL) {
					ValaExpression* _tmp334_;
					ValaStringLiteral* _tmp335_;
					gboolean _tmp336_ = FALSE;
					ValaStringLiteral* _tmp337_;
					_tmp334_ = last_arg;
					_tmp335_ = vala_string_literal_get_format_literal (_tmp334_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp335_;
					_tmp337_ = format_literal;
					if (_tmp337_ == NULL) {
						ValaList* _tmp338_;
						gint _tmp339_;
						gint _tmp340_;
						ValaMethod* _tmp341_;
						ValaList* _tmp342_;
						gint _tmp343_;
						gint _tmp344_;
						_tmp338_ = self->priv->argument_list;
						_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
						_tmp340_ = _tmp339_;
						_tmp341_ = m;
						_tmp342_ = vala_callable_get_parameters ((ValaCallable*) _tmp341_);
						_tmp343_ = vala_collection_get_size ((ValaCollection*) _tmp342_);
						_tmp344_ = _tmp343_;
						_tmp336_ = _tmp340_ == (_tmp344_ - 1);
					} else {
						_tmp336_ = FALSE;
					}
					if (_tmp336_) {
						ValaStringLiteral* _tmp345_;
						ValaStringLiteral* _tmp346_;
						ValaSemanticAnalyzer* _tmp347_;
						ValaSemanticAnalyzer* _tmp348_;
						ValaDataType* _tmp349_;
						ValaDataType* _tmp350_;
						ValaDataType* _tmp351_;
						ValaList* _tmp352_;
						ValaList* _tmp353_;
						gint _tmp354_;
						gint _tmp355_;
						ValaStringLiteral* _tmp356_;
						ValaList* _tmp357_;
						ValaIterator* _tmp358_;
						_tmp345_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp345_;
						_tmp346_ = format_literal;
						_tmp347_ = vala_code_context_get_analyzer (context);
						_tmp348_ = _tmp347_;
						_tmp349_ = _tmp348_->string_type;
						_tmp350_ = vala_data_type_copy (_tmp349_);
						_tmp351_ = _tmp350_;
						vala_expression_set_target_type ((ValaExpression*) _tmp346_, _tmp351_);
						_vala_code_node_unref0 (_tmp351_);
						_tmp352_ = self->priv->argument_list;
						_tmp353_ = self->priv->argument_list;
						_tmp354_ = vala_collection_get_size ((ValaCollection*) _tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = format_literal;
						vala_list_insert (_tmp352_, _tmp355_ - 1, (ValaExpression*) _tmp356_);
						_tmp357_ = self->priv->argument_list;
						_tmp358_ = vala_iterable_iterator ((ValaIterable*) _tmp357_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp358_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp359_;
							ValaList* _tmp360_;
							ValaList* _tmp361_;
							gint _param_size = 0;
							ValaList* _tmp362_;
							gint _tmp363_;
							gint _tmp364_;
							gint _param_index = 0;
							_tmp359_ = m;
							_tmp360_ = vala_callable_get_parameters ((ValaCallable*) _tmp359_);
							_tmp361_ = _vala_iterable_ref0 (_tmp360_);
							_param_list = _tmp361_;
							_tmp362_ = _param_list;
							_tmp363_ = vala_collection_get_size ((ValaCollection*) _tmp362_);
							_tmp364_ = _tmp363_;
							_param_size = _tmp364_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp365_;
								gint _tmp366_;
								ValaParameter* param = NULL;
								ValaList* _tmp367_;
								gpointer _tmp368_;
								gboolean _tmp369_ = FALSE;
								ValaParameter* _tmp370_;
								gboolean _tmp371_;
								gboolean _tmp372_;
								ValaIterator* _tmp376_;
								_param_index = _param_index + 1;
								_tmp365_ = _param_index;
								_tmp366_ = _param_size;
								if (!(_tmp365_ < _tmp366_)) {
									break;
								}
								_tmp367_ = _param_list;
								_tmp368_ = vala_list_get (_tmp367_, _param_index);
								param = (ValaParameter*) _tmp368_;
								_tmp370_ = param;
								_tmp371_ = vala_parameter_get_ellipsis (_tmp370_);
								_tmp372_ = _tmp371_;
								if (_tmp372_) {
									_tmp369_ = TRUE;
								} else {
									ValaParameter* _tmp373_;
									gboolean _tmp374_;
									gboolean _tmp375_;
									_tmp373_ = param;
									_tmp374_ = vala_parameter_get_params_array (_tmp373_);
									_tmp375_ = _tmp374_;
									_tmp369_ = _tmp375_;
								}
								if (_tmp369_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp376_ = arg_it;
								vala_iterator_next (_tmp376_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp377_ = format_literal;
			if (_tmp377_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp378_;
				gchar* _tmp379_;
				ValaSemanticAnalyzer* _tmp380_;
				ValaSemanticAnalyzer* _tmp381_;
				const gchar* _tmp382_;
				ValaIterator* _tmp383_;
				ValaSourceReference* _tmp384_;
				ValaSourceReference* _tmp385_;
				_tmp378_ = format_literal;
				_tmp379_ = vala_string_literal_eval (_tmp378_);
				format = _tmp379_;
				_tmp380_ = vala_code_context_get_analyzer (context);
				_tmp381_ = _tmp380_;
				_tmp382_ = format;
				_tmp383_ = arg_it;
				_tmp384_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp385_ = _tmp384_;
				if (!vala_semantic_analyzer_check_print_format (_tmp381_, _tmp382_, _tmp383_, _tmp385_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp386_;
			ValaList* _tmp387_;
			gint _arg_size = 0;
			ValaList* _tmp388_;
			gint _tmp389_;
			gint _tmp390_;
			gint _arg_index = 0;
			_tmp386_ = self->priv->argument_list;
			_tmp387_ = _vala_iterable_ref0 (_tmp386_);
			_arg_list = _tmp387_;
			_tmp388_ = _arg_list;
			_tmp389_ = vala_collection_get_size ((ValaCollection*) _tmp388_);
			_tmp390_ = _tmp389_;
			_arg_size = _tmp390_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp391_;
				gint _tmp392_;
				ValaExpression* arg = NULL;
				ValaList* _tmp393_;
				gpointer _tmp394_;
				ValaExpression* _tmp395_;
				_arg_index = _arg_index + 1;
				_tmp391_ = _arg_index;
				_tmp392_ = _arg_size;
				if (!(_tmp391_ < _tmp392_)) {
					break;
				}
				_tmp393_ = _arg_list;
				_tmp394_ = vala_list_get (_tmp393_, _arg_index);
				arg = (ValaExpression*) _tmp394_;
				_tmp395_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp395_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp396_ = vala_code_context_get_analyzer (context);
		_tmp397_ = _tmp396_;
		_tmp398_ = m;
		_tmp399_ = vala_method_type_new (_tmp398_);
		_tmp400_ = _tmp399_;
		_tmp401_ = m;
		_tmp402_ = vala_callable_get_parameters ((ValaCallable*) _tmp401_);
		_tmp403_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp397_, (ValaExpression*) self, (ValaDataType*) _tmp400_, _tmp402_, _tmp403_);
		_vala_code_node_unref0 (_tmp400_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp404_;
		ValaDataType* _tmp405_;
		_tmp404_ = vala_object_creation_expression_get_type_reference (self);
		_tmp405_ = _tmp404_;
		if (VALA_IS_ERROR_TYPE (_tmp405_)) {
			ValaDataType* _tmp406_;
			ValaDataType* _tmp407_;
			ValaMemberAccess* _tmp410_;
			ValaMemberAccess* _tmp411_;
			ValaList* _tmp434_;
			gint _tmp435_;
			gint _tmp436_;
			_tmp406_ = vala_object_creation_expression_get_type_reference (self);
			_tmp407_ = _tmp406_;
			if (_tmp407_ != NULL) {
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				_tmp408_ = vala_object_creation_expression_get_type_reference (self);
				_tmp409_ = _tmp408_;
				vala_code_node_check ((ValaCodeNode*) _tmp409_, context);
			}
			_tmp410_ = vala_object_creation_expression_get_member_name (self);
			_tmp411_ = _tmp410_;
			if (_tmp411_ != NULL) {
				ValaMemberAccess* _tmp412_;
				ValaMemberAccess* _tmp413_;
				_tmp412_ = vala_object_creation_expression_get_member_name (self);
				_tmp413_ = _tmp412_;
				vala_code_node_check ((ValaCodeNode*) _tmp413_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp414_;
				ValaList* _tmp415_;
				gint _arg_size = 0;
				ValaList* _tmp416_;
				gint _tmp417_;
				gint _tmp418_;
				gint _arg_index = 0;
				_tmp414_ = self->priv->argument_list;
				_tmp415_ = _vala_iterable_ref0 (_tmp414_);
				_arg_list = _tmp415_;
				_tmp416_ = _arg_list;
				_tmp417_ = vala_collection_get_size ((ValaCollection*) _tmp416_);
				_tmp418_ = _tmp417_;
				_arg_size = _tmp418_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp419_;
					gint _tmp420_;
					ValaExpression* arg = NULL;
					ValaList* _tmp421_;
					gpointer _tmp422_;
					ValaExpression* _tmp423_;
					_arg_index = _arg_index + 1;
					_tmp419_ = _arg_index;
					_tmp420_ = _arg_size;
					if (!(_tmp419_ < _tmp420_)) {
						break;
					}
					_tmp421_ = _arg_list;
					_tmp422_ = vala_list_get (_tmp421_, _arg_index);
					arg = (ValaExpression*) _tmp422_;
					_tmp423_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp423_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp424_;
				ValaList* _tmp425_;
				gint _init_size = 0;
				ValaList* _tmp426_;
				gint _tmp427_;
				gint _tmp428_;
				gint _init_index = 0;
				_tmp424_ = self->priv->object_initializer;
				_tmp425_ = _vala_iterable_ref0 (_tmp424_);
				_init_list = _tmp425_;
				_tmp426_ = _init_list;
				_tmp427_ = vala_collection_get_size ((ValaCollection*) _tmp426_);
				_tmp428_ = _tmp427_;
				_init_size = _tmp428_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp429_;
					gint _tmp430_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp431_;
					gpointer _tmp432_;
					ValaMemberInitializer* _tmp433_;
					_init_index = _init_index + 1;
					_tmp429_ = _init_index;
					_tmp430_ = _init_size;
					if (!(_tmp429_ < _tmp430_)) {
						break;
					}
					_tmp431_ = _init_list;
					_tmp432_ = vala_list_get (_tmp431_, _init_index);
					init = (ValaMemberInitializer*) _tmp432_;
					_tmp433_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp433_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp434_ = self->priv->argument_list;
			_tmp435_ = vala_collection_get_size ((ValaCollection*) _tmp434_);
			_tmp436_ = _tmp435_;
			if (_tmp436_ == 0) {
				ValaSourceReference* _tmp437_;
				ValaSourceReference* _tmp438_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp437_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp438_ = _tmp437_;
				vala_report_error (_tmp438_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp439_;
				ValaIterator* _tmp440_;
				ValaIterator* _tmp441_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp442_;
				gpointer _tmp443_;
				gboolean _tmp444_ = FALSE;
				ValaExpression* _tmp445_;
				ValaDataType* _tmp446_;
				ValaDataType* _tmp447_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp456_;
				ValaStringLiteral* _tmp457_;
				ValaStringLiteral* _tmp458_;
				ValaList* _tmp467_;
				ValaIterator* _tmp468_;
				ValaIterator* _tmp469_;
				ValaSemanticAnalyzer* _tmp470_;
				ValaSemanticAnalyzer* _tmp471_;
				ValaIterator* _tmp472_;
				ValaSourceReference* _tmp473_;
				ValaSourceReference* _tmp474_;
				_tmp439_ = self->priv->argument_list;
				_tmp440_ = vala_iterable_iterator ((ValaIterable*) _tmp439_);
				arg_it = _tmp440_;
				_tmp441_ = arg_it;
				vala_iterator_next (_tmp441_);
				_tmp442_ = arg_it;
				_tmp443_ = vala_iterator_get (_tmp442_);
				ex = (ValaExpression*) _tmp443_;
				_tmp445_ = ex;
				_tmp446_ = vala_expression_get_value_type (_tmp445_);
				_tmp447_ = _tmp446_;
				if (_tmp447_ == NULL) {
					_tmp444_ = TRUE;
				} else {
					ValaExpression* _tmp448_;
					ValaDataType* _tmp449_;
					ValaDataType* _tmp450_;
					ValaSemanticAnalyzer* _tmp451_;
					ValaSemanticAnalyzer* _tmp452_;
					ValaDataType* _tmp453_;
					_tmp448_ = ex;
					_tmp449_ = vala_expression_get_value_type (_tmp448_);
					_tmp450_ = _tmp449_;
					_tmp451_ = vala_code_context_get_analyzer (context);
					_tmp452_ = _tmp451_;
					_tmp453_ = _tmp452_->string_type;
					_tmp444_ = !vala_data_type_compatible (_tmp450_, _tmp453_);
				}
				if (_tmp444_) {
					ValaSourceReference* _tmp454_;
					ValaSourceReference* _tmp455_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp455_ = _tmp454_;
					vala_report_error (_tmp455_, "Invalid type for argument 1");
				}
				_tmp456_ = ex;
				_tmp457_ = vala_string_literal_get_format_literal (_tmp456_);
				format_literal = _tmp457_;
				_tmp458_ = format_literal;
				if (_tmp458_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp459_;
					gchar* _tmp460_;
					ValaSemanticAnalyzer* _tmp461_;
					ValaSemanticAnalyzer* _tmp462_;
					const gchar* _tmp463_;
					ValaIterator* _tmp464_;
					ValaSourceReference* _tmp465_;
					ValaSourceReference* _tmp466_;
					_tmp459_ = format_literal;
					_tmp460_ = vala_string_literal_eval (_tmp459_);
					format = _tmp460_;
					_tmp461_ = vala_code_context_get_analyzer (context);
					_tmp462_ = _tmp461_;
					_tmp463_ = format;
					_tmp464_ = arg_it;
					_tmp465_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp466_ = _tmp465_;
					if (!vala_semantic_analyzer_check_print_format (_tmp462_, _tmp463_, _tmp464_, _tmp466_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp467_ = self->priv->argument_list;
				_tmp468_ = vala_iterable_iterator ((ValaIterable*) _tmp467_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp468_;
				_tmp469_ = arg_it;
				vala_iterator_next (_tmp469_);
				_tmp470_ = vala_code_context_get_analyzer (context);
				_tmp471_ = _tmp470_;
				_tmp472_ = arg_it;
				_tmp473_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp474_ = _tmp473_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp471_, _tmp472_, 1, _tmp474_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp475_;
		ValaList* _tmp476_;
		gint _arg_size = 0;
		ValaList* _tmp477_;
		gint _tmp478_;
		gint _tmp479_;
		gint _arg_index = 0;
		_tmp475_ = self->priv->argument_list;
		_tmp476_ = _vala_iterable_ref0 (_tmp475_);
		_arg_list = _tmp476_;
		_tmp477_ = _arg_list;
		_tmp478_ = vala_collection_get_size ((ValaCollection*) _tmp477_);
		_tmp479_ = _tmp478_;
		_arg_size = _tmp479_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp480_;
			gint _tmp481_;
			ValaExpression* arg = NULL;
			ValaList* _tmp482_;
			gpointer _tmp483_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp484_;
			gboolean _tmp485_ = FALSE;
			ValaSizeofExpression* _tmp486_;
			_arg_index = _arg_index + 1;
			_tmp480_ = _arg_index;
			_tmp481_ = _arg_size;
			if (!(_tmp480_ < _tmp481_)) {
				break;
			}
			_tmp482_ = _arg_list;
			_tmp483_ = vala_list_get (_tmp482_, _arg_index);
			arg = (ValaExpression*) _tmp483_;
			_tmp484_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp484_) ? ((ValaSizeofExpression*) _tmp484_) : NULL;
			_tmp486_ = sizeof_expr;
			if (_tmp486_ != NULL) {
				ValaSizeofExpression* _tmp487_;
				ValaDataType* _tmp488_;
				ValaDataType* _tmp489_;
				_tmp487_ = sizeof_expr;
				_tmp488_ = vala_sizeof_expression_get_type_reference (_tmp487_);
				_tmp489_ = _tmp488_;
				_tmp485_ = VALA_IS_GENERIC_TYPE (_tmp489_);
			} else {
				_tmp485_ = FALSE;
			}
			if (_tmp485_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp490_;
				ValaDataType* _tmp491_;
				ValaDataType* _tmp492_;
				ValaDataType* _tmp493_;
				ValaDataType* _tmp494_;
				ValaDataType* _tmp495_;
				ValaDataType* _tmp496_;
				ValaList* _tmp497_;
				ValaDataType* _tmp498_;
				ValaExpression* _tmp499_;
				ValaDataType* _tmp500_;
				ValaSourceReference* _tmp501_;
				ValaSourceReference* _tmp502_;
				ValaSizeofExpression* _tmp503_;
				ValaSizeofExpression* _tmp504_;
				_tmp490_ = sizeof_expr;
				_tmp491_ = vala_sizeof_expression_get_type_reference (_tmp490_);
				_tmp492_ = _tmp491_;
				_tmp493_ = vala_object_creation_expression_get_type_reference (self);
				_tmp494_ = _tmp493_;
				_tmp495_ = vala_object_creation_expression_get_type_reference (self);
				_tmp496_ = _tmp495_;
				_tmp497_ = vala_data_type_get_type_arguments (_tmp496_);
				_tmp498_ = vala_data_type_get_actual_type (_tmp492_, _tmp494_, _tmp497_, (ValaCodeNode*) self);
				sizeof_type = _tmp498_;
				_tmp499_ = arg;
				_tmp500_ = sizeof_type;
				_tmp501_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp502_ = _tmp501_;
				_tmp503_ = vala_sizeof_expression_new (_tmp500_, _tmp502_);
				_tmp504_ = _tmp503_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp499_, (ValaExpression*) _tmp504_);
				_vala_code_node_unref0 (_tmp504_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp505_ = type;
	_tmp506_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp505_);
	_tmp507_ = _tmp506_;
	if (!_tmp507_) {
		ValaSemanticAnalyzer* _tmp508_;
		ValaSemanticAnalyzer* _tmp509_;
		ValaDataType* _tmp510_;
		ValaDataType* _tmp511_;
		_tmp508_ = vala_code_context_get_analyzer (context);
		_tmp509_ = _tmp508_;
		_tmp510_ = vala_object_creation_expression_get_type_reference (self);
		_tmp511_ = _tmp510_;
		vala_semantic_analyzer_check_type (_tmp509_, _tmp511_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp512_;
		ValaList* _tmp513_;
		gint _init_size = 0;
		ValaList* _tmp514_;
		gint _tmp515_;
		gint _tmp516_;
		gint _init_index = 0;
		_tmp512_ = vala_object_creation_expression_get_object_initializer (self);
		_tmp513_ = _vala_iterable_ref0 (_tmp512_);
		_init_list = _tmp513_;
		_tmp514_ = _init_list;
		_tmp515_ = vala_collection_get_size ((ValaCollection*) _tmp514_);
		_tmp516_ = _tmp515_;
		_init_size = _tmp516_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp517_;
			gint _tmp518_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp519_;
			gpointer _tmp520_;
			ValaSemanticAnalyzer* _tmp521_;
			ValaSemanticAnalyzer* _tmp522_;
			ValaMemberInitializer* _tmp523_;
			ValaDataType* _tmp524_;
			ValaDataType* _tmp525_;
			_init_index = _init_index + 1;
			_tmp517_ = _init_index;
			_tmp518_ = _init_size;
			if (!(_tmp517_ < _tmp518_)) {
				break;
			}
			_tmp519_ = _init_list;
			_tmp520_ = vala_list_get (_tmp519_, _init_index);
			init = (ValaMemberInitializer*) _tmp520_;
			_tmp521_ = vala_code_context_get_analyzer (context);
			_tmp522_ = _tmp521_;
			_tmp523_ = init;
			_tmp524_ = vala_object_creation_expression_get_type_reference (self);
			_tmp525_ = _tmp524_;
			vala_semantic_analyzer_visit_member_initializer (_tmp522_, _tmp523_, _tmp525_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp526_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp527_ = _tmp526_;
	if (_tmp527_) {
		gboolean _tmp528_ = FALSE;
		ValaCodeNode* _tmp529_;
		ValaCodeNode* _tmp530_;
		_tmp529_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp530_ = _tmp529_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp530_)) {
			_tmp528_ = TRUE;
		} else {
			ValaCodeNode* _tmp531_;
			ValaCodeNode* _tmp532_;
			_tmp531_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp532_ = _tmp531_;
			_tmp528_ = VALA_IS_EXPRESSION_STATEMENT (_tmp532_);
		}
		if (_tmp528_) {
		} else {
			ValaSemanticAnalyzer* _tmp533_;
			ValaSemanticAnalyzer* _tmp534_;
			ValaSymbol* _tmp535_;
			ValaSymbol* _tmp536_;
			_tmp533_ = vala_code_context_get_analyzer (context);
			_tmp534_ = _tmp533_;
			_tmp535_ = vala_semantic_analyzer_get_current_symbol (_tmp534_);
			_tmp536_ = _tmp535_;
			if (!VALA_IS_BLOCK (_tmp536_)) {
				ValaSourceReference* _tmp537_;
				ValaSourceReference* _tmp538_;
				_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp538_ = _tmp537_;
				vala_report_error (_tmp538_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp539_;
				ValaCodeNode* _tmp540_;
				ValaCodeNode* _tmp541_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp542_;
				ValaDataType* _tmp543_;
				ValaDataType* _tmp544_;
				ValaDataType* _tmp545_;
				gchar* _tmp546_;
				gchar* _tmp547_;
				ValaSourceReference* _tmp548_;
				ValaSourceReference* _tmp549_;
				ValaLocalVariable* _tmp550_;
				ValaLocalVariable* _tmp551_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp552_;
				ValaSourceReference* _tmp553_;
				ValaSourceReference* _tmp554_;
				ValaDeclarationStatement* _tmp555_;
				ValaSemanticAnalyzer* _tmp556_;
				ValaSemanticAnalyzer* _tmp557_;
				ValaBlock* _tmp558_;
				ValaDeclarationStatement* _tmp559_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp560_;
				ValaDataType* _tmp561_;
				ValaDataType* _tmp562_;
				ValaExpression* _tmp563_;
				ValaExpression* _tmp564_;
				ValaDataType* _tmp565_;
				ValaDataType* _tmp566_;
				ValaLocalVariable* _tmp567_;
				ValaDeclarationStatement* _tmp568_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp569_;
				ValaSemanticAnalyzer* _tmp570_;
				ValaSymbol* _tmp571_;
				ValaSymbol* _tmp572_;
				ValaBlock* _tmp573_;
				ValaBlock* _tmp574_;
				ValaLocalVariable* _tmp575_;
				ValaSemanticAnalyzer* _tmp576_;
				ValaSemanticAnalyzer* _tmp577_;
				ValaBlock* _tmp578_;
				ValaLocalVariable* _tmp579_;
				ValaCodeNode* _tmp580_;
				ValaExpression* _tmp581_;
				ValaExpression* _tmp582_;
				_tmp539_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp540_ = _tmp539_;
				_tmp541_ = _vala_code_node_ref0 (_tmp540_);
				old_parent_node = _tmp541_;
				_tmp542_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp543_ = _tmp542_;
				_tmp544_ = vala_data_type_copy (_tmp543_);
				_tmp545_ = _tmp544_;
				_tmp546_ = vala_code_node_get_temp_name ();
				_tmp547_ = _tmp546_;
				_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp549_ = _tmp548_;
				_tmp550_ = vala_local_variable_new (_tmp545_, _tmp547_, NULL, _tmp549_);
				_tmp551_ = _tmp550_;
				_g_free0 (_tmp547_);
				_vala_code_node_unref0 (_tmp545_);
				local = _tmp551_;
				_tmp552_ = local;
				_tmp553_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp554_ = _tmp553_;
				_tmp555_ = vala_declaration_statement_new ((ValaSymbol*) _tmp552_, _tmp554_);
				decl = _tmp555_;
				_tmp556_ = vala_code_context_get_analyzer (context);
				_tmp557_ = _tmp556_;
				_tmp558_ = _tmp557_->insert_block;
				_tmp559_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp558_, (ValaStatement*) _tmp559_);
				_tmp560_ = local;
				_tmp561_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp562_ = _tmp561_;
				_tmp563_ = vala_semantic_analyzer_create_temp_access (_tmp560_, _tmp562_);
				temp_access = _tmp563_;
				_tmp564_ = temp_access;
				_tmp565_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp566_ = _tmp565_;
				vala_expression_set_formal_target_type (_tmp564_, _tmp566_);
				_tmp567_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp567_, (ValaExpression*) self);
				_tmp568_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp568_, context);
				_tmp569_ = vala_code_context_get_analyzer (context);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_semantic_analyzer_get_current_symbol (_tmp570_);
				_tmp572_ = _tmp571_;
				_tmp573_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp572_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp573_;
				_tmp574_ = block;
				_tmp575_ = local;
				vala_block_remove_local_variable (_tmp574_, _tmp575_);
				_tmp576_ = vala_code_context_get_analyzer (context);
				_tmp577_ = _tmp576_;
				_tmp578_ = _tmp577_->insert_block;
				_tmp579_ = local;
				vala_block_add_local_variable (_tmp578_, _tmp579_);
				_tmp580_ = old_parent_node;
				_tmp581_ = temp_access;
				vala_code_node_replace_expression (_tmp580_, (ValaExpression*) self, _tmp581_);
				_tmp582_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp582_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp583_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp584_ = _tmp583_;
	result = !_tmp584_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp9_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _init_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _init_index = 0;
		_tmp10_ = self->priv->object_initializer;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_init_list = _tmp11_;
		_tmp12_ = _init_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_init_size = _tmp14_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaMemberInitializer* _tmp19_;
			_init_index = _init_index + 1;
			_tmp15_ = _init_index;
			_tmp16_ = _init_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _init_list;
			_tmp18_ = vala_list_get (_tmp17_, _init_index);
			init = (ValaMemberInitializer*) _tmp18_;
			_tmp19_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _init_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _init_index = 0;
		_tmp10_ = self->priv->object_initializer;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_init_list = _tmp11_;
		_tmp12_ = _init_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_init_size = _tmp14_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaMemberInitializer* _tmp19_;
			_init_index = _init_index + 1;
			_tmp15_ = _init_index;
			_tmp16_ = _init_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _init_list;
			_tmp18_ = vala_list_get (_tmp17_, _init_index);
			init = (ValaMemberInitializer*) _tmp18_;
			_tmp19_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp19_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp3_;
	ValaMemberAccess* _tmp5_;
	ValaMemberAccess* _tmp6_;
	GString* _tmp12_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result = NULL;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = self->priv->_is_yield_expression;
	if (_tmp1_) {
		GString* _tmp2_;
		_tmp2_ = b;
		g_string_append (_tmp2_, "yield ");
	}
	_tmp3_ = self->priv->_struct_creation;
	if (!_tmp3_) {
		GString* _tmp4_;
		_tmp4_ = b;
		g_string_append (_tmp4_, "new ");
	}
	_tmp5_ = vala_object_creation_expression_get_member_name (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		GString* _tmp7_;
		ValaMemberAccess* _tmp8_;
		ValaMemberAccess* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = b;
		_tmp8_ = vala_object_creation_expression_get_member_name (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		g_string_append (_tmp7_, _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp12_ = b;
	g_string_append_c (_tmp12_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp13_ = self->priv->argument_list;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}

