/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaExpression* arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaExpression* _tmp17_;
			_arg_index = _arg_index + 1;
			_tmp13_ = _arg_index;
			_tmp14_ = _arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _arg_index);
			arg = (ValaExpression*) _tmp16_;
			_tmp17_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _init_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _init_index = 0;
		_tmp18_ = self->priv->object_initializer;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_init_list = _tmp19_;
		_tmp20_ = _init_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_init_size = _tmp22_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaMemberInitializer* _tmp27_;
			_init_index = _init_index + 1;
			_tmp23_ = _init_index;
			_tmp24_ = _init_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _init_list;
			_tmp26_ = vala_list_get (_tmp25_, _init_index);
			init = (ValaMemberInitializer*) _tmp26_;
			_tmp27_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* arg = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			_arg_index = _arg_index + 1;
			_tmp10_ = _arg_index;
			_tmp11_ = _arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _arg_list;
			_tmp13_ = vala_list_get (_tmp12_, _arg_index);
			arg = (ValaExpression*) _tmp13_;
			_tmp14_ = arg;
			if (!vala_expression_is_accessible (_tmp14_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _init_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _init_index = 0;
		_tmp15_ = self->priv->object_initializer;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_init_list = _tmp16_;
		_tmp17_ = _init_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_init_size = _tmp19_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaMemberInitializer* _tmp24_;
			ValaExpression* _tmp25_;
			ValaExpression* _tmp26_;
			_init_index = _init_index + 1;
			_tmp20_ = _init_index;
			_tmp21_ = _init_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _init_list;
			_tmp23_ = vala_list_get (_tmp22_, _init_index);
			init = (ValaMemberInitializer*) _tmp23_;
			_tmp24_ = init;
			_tmp25_ = vala_member_initializer_get_initializer (_tmp24_);
			_tmp26_ = _tmp25_;
			if (!vala_expression_is_accessible (_tmp26_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	ValaDataType* _tmp116_;
	gint given_num_type_args = 0;
	ValaDataType* _tmp117_;
	ValaDataType* _tmp118_;
	ValaList* _tmp119_;
	gint _tmp120_;
	gint _tmp121_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp122_;
	gboolean _tmp248_ = FALSE;
	ValaSymbol* _tmp249_;
	ValaSymbol* _tmp250_;
	ValaSymbol* _tmp261_;
	ValaSymbol* _tmp262_;
	ValaTypeSymbol* _tmp496_;
	gboolean _tmp497_;
	gboolean _tmp498_;
	gboolean _tmp517_;
	gboolean _tmp518_;
	gboolean _tmp574_;
	gboolean _tmp575_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp56_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		type_args = _tmp31_;
		_tmp32_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp32_)) {
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp37_;
			ValaMethod* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaMethod* _tmp47_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp48_;
			ValaMemberAccess* _tmp49_;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp33_ = constructor_sym;
			_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _vala_code_node_ref0 (_tmp35_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp36_;
			_tmp37_ = constructor_sym;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp38_;
			_tmp39_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp39_)) {
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaMethod* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = constructor;
				_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strdup_printf ("`%s' is not a creation method", _tmp44_);
				_tmp46_ = _tmp45_;
				vala_report_error (_tmp41_, _tmp46_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp44_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp47_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp47_);
			_tmp48_ = vala_object_creation_expression_get_member_name (self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_member_access_get_inner (_tmp49_);
			_tmp51_ = _tmp50_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				ValaList* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_tmp55_ = _vala_iterable_ref0 (_tmp54_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp55_;
			}
			_vala_code_node_unref0 (constructor);
		}
		_tmp56_ = type_sym;
		if (VALA_IS_CLASS (_tmp56_)) {
			ValaSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			gboolean _tmp60_;
			gboolean _tmp61_;
			_tmp57_ = type_sym;
			_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp58_;
			_tmp59_ = type;
			_tmp60_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CLASS, ValaClass));
			_tmp61_ = _tmp60_;
			if (_tmp61_) {
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaErrorType* _tmp64_;
				ValaErrorType* _tmp65_;
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = vala_error_type_new (NULL, NULL, _tmp63_);
				_tmp65_ = _tmp64_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp65_);
				_vala_code_node_unref0 (_tmp65_);
			} else {
				ValaTypeSymbol* _tmp66_;
				ValaObjectType* _tmp67_;
				ValaObjectType* _tmp68_;
				_tmp66_ = type;
				_tmp67_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_CLASS, ValaClass));
				_tmp68_ = _tmp67_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
			}
		} else {
			ValaSymbol* _tmp69_;
			_tmp69_ = type_sym;
			if (VALA_IS_STRUCT (_tmp69_)) {
				ValaSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaStructValueType* _tmp73_;
				ValaStructValueType* _tmp74_;
				_tmp70_ = type_sym;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp71_;
				_tmp72_ = type;
				_tmp73_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp74_ = _tmp73_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp74_);
				_vala_code_node_unref0 (_tmp74_);
			} else {
				ValaSymbol* _tmp75_;
				_tmp75_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp75_)) {
					ValaSymbol* _tmp76_;
					ValaTypeSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSymbol* _tmp79_;
					ValaSymbol* _tmp80_;
					ValaSymbol* _tmp81_;
					ValaSourceReference* _tmp82_;
					ValaSourceReference* _tmp83_;
					ValaErrorType* _tmp84_;
					ValaErrorType* _tmp85_;
					ValaSymbol* _tmp86_;
					_tmp76_ = type_sym;
					_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
					_vala_code_node_unref0 (type);
					type = _tmp77_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_symbol_get_parent_symbol (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = type_sym;
					_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp83_ = _tmp82_;
					_tmp84_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp83_);
					_tmp85_ = _tmp84_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp85_);
					_vala_code_node_unref0 (_tmp85_);
					_tmp86_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp86_);
				} else {
					ValaSourceReference* _tmp87_;
					ValaSourceReference* _tmp88_;
					ValaSymbol* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp88_ = _tmp87_;
					_tmp89_ = type_sym;
					_tmp90_ = vala_symbol_get_full_name (_tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp91_);
					_tmp93_ = _tmp92_;
					vala_report_error (_tmp88_, _tmp93_);
					_g_free0 (_tmp93_);
					_g_free0 (_tmp91_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp94_;
			ValaList* _tmp95_;
			gint _type_arg_size = 0;
			ValaList* _tmp96_;
			gint _tmp97_;
			gint _tmp98_;
			gint _type_arg_index = 0;
			_tmp94_ = type_args;
			_tmp95_ = _vala_iterable_ref0 (_tmp94_);
			_type_arg_list = _tmp95_;
			_tmp96_ = _type_arg_list;
			_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
			_tmp98_ = _tmp97_;
			_type_arg_size = _tmp98_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp99_;
				gint _tmp100_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp101_;
				gpointer _tmp102_;
				ValaDataType* _tmp103_;
				ValaDataType* _tmp104_;
				ValaDataType* _tmp105_;
				_type_arg_index = _type_arg_index + 1;
				_tmp99_ = _type_arg_index;
				_tmp100_ = _type_arg_size;
				if (!(_tmp99_ < _tmp100_)) {
					break;
				}
				_tmp101_ = _type_arg_list;
				_tmp102_ = vala_list_get (_tmp101_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp102_;
				_tmp103_ = vala_object_creation_expression_get_type_reference (self);
				_tmp104_ = _tmp103_;
				_tmp105_ = type_arg;
				vala_data_type_add_type_argument (_tmp104_, _tmp105_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp106_;
		ValaDataType* _tmp107_;
		ValaTypeSymbol* _tmp108_;
		ValaTypeSymbol* _tmp109_;
		ValaTypeSymbol* _tmp110_;
		_tmp106_ = vala_object_creation_expression_get_type_reference (self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_data_type_get_type_symbol (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = _vala_code_node_ref0 (_tmp109_);
		_vala_code_node_unref0 (type);
		type = _tmp110_;
	}
	_tmp111_ = vala_object_creation_expression_get_type_reference (self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_data_type_copy (_tmp112_);
	_tmp114_ = _tmp113_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp114_);
	_vala_code_node_unref0 (_tmp114_);
	_tmp115_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp116_ = _tmp115_;
	vala_data_type_set_value_owned (_tmp116_, TRUE);
	_tmp117_ = vala_object_creation_expression_get_type_reference (self);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_data_type_get_type_arguments (_tmp118_);
	_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
	_tmp121_ = _tmp120_;
	given_num_type_args = _tmp121_;
	expected_num_type_args = 0;
	_tmp122_ = type;
	if (VALA_IS_CLASS (_tmp122_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp123_;
		ValaClass* _tmp124_;
		ValaClass* _tmp125_;
		ValaList* _tmp126_;
		gint _tmp127_;
		gint _tmp128_;
		gboolean _tmp129_;
		ValaClass* _tmp132_;
		gboolean _tmp133_;
		gboolean _tmp134_;
		ValaSymbol* _tmp142_;
		ValaSymbol* _tmp143_;
		gboolean _tmp164_ = FALSE;
		ValaSymbol* _tmp165_;
		ValaSymbol* _tmp166_;
		_tmp123_ = type;
		_tmp124_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp124_;
		_tmp125_ = cl;
		_tmp126_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp125_);
		_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
		_tmp128_ = _tmp127_;
		expected_num_type_args = _tmp128_;
		_tmp129_ = self->priv->_struct_creation;
		if (_tmp129_) {
			ValaSourceReference* _tmp130_;
			ValaSourceReference* _tmp131_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp131_ = _tmp130_;
			vala_report_error (_tmp131_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp132_ = cl;
		_tmp133_ = vala_class_get_is_abstract (_tmp132_);
		_tmp134_ = _tmp133_;
		if (_tmp134_) {
			ValaSourceReference* _tmp135_;
			ValaSourceReference* _tmp136_;
			ValaClass* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp136_ = _tmp135_;
			_tmp137_ = cl;
			_tmp138_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp137_);
			_tmp139_ = _tmp138_;
			_tmp140_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp139_);
			_tmp141_ = _tmp140_;
			vala_report_error (_tmp136_, _tmp141_);
			_g_free0 (_tmp141_);
			_g_free0 (_tmp139_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp143_ = _tmp142_;
		if (_tmp143_ == NULL) {
			ValaClass* _tmp144_;
			ValaCreationMethod* _tmp145_;
			ValaCreationMethod* _tmp146_;
			ValaSymbol* _tmp147_;
			ValaSymbol* _tmp148_;
			ValaSymbol* _tmp156_;
			ValaSymbol* _tmp157_;
			ValaSymbol* _tmp158_;
			ValaSymbol* _tmp159_;
			ValaVersionAttribute* _tmp160_;
			ValaVersionAttribute* _tmp161_;
			ValaSourceReference* _tmp162_;
			ValaSourceReference* _tmp163_;
			_tmp144_ = cl;
			_tmp145_ = vala_class_get_default_construction_method (_tmp144_);
			_tmp146_ = _tmp145_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp146_);
			_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp148_ = _tmp147_;
			if (_tmp148_ == NULL) {
				ValaSourceReference* _tmp149_;
				ValaSourceReference* _tmp150_;
				ValaClass* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				gchar* _tmp154_;
				gchar* _tmp155_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp150_ = _tmp149_;
				_tmp151_ = cl;
				_tmp152_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp153_);
				_tmp155_ = _tmp154_;
				vala_report_error (_tmp150_, _tmp155_);
				_g_free0 (_tmp155_);
				_g_free0 (_tmp153_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp156_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp157_ = _tmp156_;
			vala_symbol_set_used (_tmp157_, TRUE);
			_tmp158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_symbol_get_version (_tmp159_);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp163_ = _tmp162_;
			vala_version_attribute_check (_tmp161_, context, _tmp163_);
		}
		_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp166_ = _tmp165_;
		if (_tmp166_ != NULL) {
			gboolean _tmp167_ = FALSE;
			ValaSymbol* _tmp168_;
			ValaSymbol* _tmp169_;
			ValaSymbolAccessibility _tmp170_;
			ValaSymbolAccessibility _tmp171_;
			_tmp168_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_symbol_get_access (_tmp169_);
			_tmp171_ = _tmp170_;
			if (_tmp171_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp167_ = TRUE;
			} else {
				ValaSymbol* _tmp172_;
				ValaSymbol* _tmp173_;
				ValaSymbolAccessibility _tmp174_;
				ValaSymbolAccessibility _tmp175_;
				_tmp172_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp173_ = _tmp172_;
				_tmp174_ = vala_symbol_get_access (_tmp173_);
				_tmp175_ = _tmp174_;
				_tmp167_ = _tmp175_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp164_ = _tmp167_;
		} else {
			_tmp164_ = FALSE;
		}
		if (_tmp164_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp176_;
				ValaSemanticAnalyzer* _tmp177_;
				ValaSymbol* _tmp178_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				_tmp176_ = vala_code_context_get_analyzer (context);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_semantic_analyzer_get_current_symbol (_tmp177_);
				_tmp179_ = _tmp178_;
				_tmp180_ = _vala_code_node_ref0 (_tmp179_);
				this_symbol = _tmp180_;
				{
					gboolean _tmp181_ = FALSE;
					_tmp181_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp186_;
						ValaSymbol* _tmp187_;
						ValaClass* _tmp188_;
						if (!_tmp181_) {
							ValaSymbol* _tmp182_;
							ValaSymbol* _tmp183_;
							ValaSymbol* _tmp184_;
							ValaSymbol* _tmp185_;
							_tmp182_ = this_symbol;
							_tmp183_ = vala_symbol_get_parent_symbol (_tmp182_);
							_tmp184_ = _tmp183_;
							_tmp185_ = _vala_code_node_ref0 (_tmp184_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp185_;
						}
						_tmp181_ = FALSE;
						_tmp186_ = this_symbol;
						if (!(_tmp186_ != NULL)) {
							break;
						}
						_tmp187_ = this_symbol;
						_tmp188_ = cl;
						if (_tmp187_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp188_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp189_;
				ValaSourceReference* _tmp190_;
				ValaSymbol* _tmp191_;
				ValaSymbol* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				gchar* _tmp195_;
				gchar* _tmp196_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_symbol_get_full_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp194_);
				_tmp196_ = _tmp195_;
				vala_report_error (_tmp190_, _tmp196_);
				_g_free0 (_tmp196_);
				_g_free0 (_tmp194_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp197_;
			ValaClass* _tmp198_;
			gchar* _tmp199_;
			gchar* _tmp200_;
			gboolean _tmp201_;
			ValaClass* _tmp204_;
			ValaClass* _tmp205_;
			ValaClass* _tmp206_;
			ValaClass* _tmp207_;
			_tmp197_ = cl;
			if (!(_tmp197_ != NULL)) {
				break;
			}
			_tmp198_ = cl;
			_tmp199_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp198_, "CCode", "ref_sink_function", NULL);
			_tmp200_ = _tmp199_;
			_tmp201_ = _tmp200_ != NULL;
			_g_free0 (_tmp200_);
			if (_tmp201_) {
				ValaDataType* _tmp202_;
				ValaDataType* _tmp203_;
				_tmp202_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp203_ = _tmp202_;
				vala_data_type_set_floating_reference (_tmp203_, TRUE);
				break;
			}
			_tmp204_ = cl;
			_tmp205_ = vala_class_get_base_class (_tmp204_);
			_tmp206_ = _tmp205_;
			_tmp207_ = _vala_code_node_ref0 (_tmp206_);
			_vala_code_node_unref0 (cl);
			cl = _tmp207_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp208_;
		_tmp208_ = type;
		if (VALA_IS_STRUCT (_tmp208_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp209_;
			ValaStruct* _tmp210_;
			ValaStruct* _tmp211_;
			ValaList* _tmp212_;
			gint _tmp213_;
			gint _tmp214_;
			gboolean _tmp215_ = FALSE;
			gboolean _tmp216_;
			ValaSymbol* _tmp221_;
			ValaSymbol* _tmp222_;
			gboolean _tmp226_ = FALSE;
			gboolean _tmp227_ = FALSE;
			gboolean _tmp228_ = FALSE;
			ValaProfile _tmp229_;
			ValaProfile _tmp230_;
			_tmp209_ = type;
			_tmp210_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp209_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp210_;
			_tmp211_ = st;
			_tmp212_ = vala_struct_get_type_parameters (_tmp211_);
			_tmp213_ = vala_collection_get_size ((ValaCollection*) _tmp212_);
			_tmp214_ = _tmp213_;
			expected_num_type_args = _tmp214_;
			_tmp216_ = self->priv->_struct_creation;
			if (!_tmp216_) {
				gboolean _tmp217_;
				gboolean _tmp218_;
				_tmp217_ = vala_code_context_get_deprecated (context);
				_tmp218_ = _tmp217_;
				_tmp215_ = !_tmp218_;
			} else {
				_tmp215_ = FALSE;
			}
			if (_tmp215_) {
				ValaSourceReference* _tmp219_;
				ValaSourceReference* _tmp220_;
				_tmp219_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp220_ = _tmp219_;
				vala_report_warning (_tmp220_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp221_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp222_ = _tmp221_;
			if (_tmp222_ == NULL) {
				ValaStruct* _tmp223_;
				ValaCreationMethod* _tmp224_;
				ValaCreationMethod* _tmp225_;
				_tmp223_ = st;
				_tmp224_ = vala_struct_get_default_construction_method (_tmp223_);
				_tmp225_ = _tmp224_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp225_);
			}
			_tmp229_ = vala_code_context_get_profile (context);
			_tmp230_ = _tmp229_;
			if (_tmp230_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp231_;
				_tmp231_ = st;
				_tmp228_ = vala_struct_is_simple_type (_tmp231_);
			} else {
				_tmp228_ = FALSE;
			}
			if (_tmp228_) {
				ValaSymbol* _tmp232_;
				ValaSymbol* _tmp233_;
				_tmp232_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp233_ = _tmp232_;
				_tmp227_ = _tmp233_ == NULL;
			} else {
				_tmp227_ = FALSE;
			}
			if (_tmp227_) {
				ValaList* _tmp234_;
				gint _tmp235_;
				gint _tmp236_;
				_tmp234_ = self->priv->object_initializer;
				_tmp235_ = vala_collection_get_size ((ValaCollection*) _tmp234_);
				_tmp236_ = _tmp235_;
				_tmp226_ = _tmp236_ == 0;
			} else {
				_tmp226_ = FALSE;
			}
			if (_tmp226_) {
				ValaSourceReference* _tmp237_;
				ValaSourceReference* _tmp238_;
				ValaStruct* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				gchar* _tmp243_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp238_ = _tmp237_;
				_tmp239_ = st;
				_tmp240_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp239_);
				_tmp241_ = _tmp240_;
				_tmp242_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp241_);
				_tmp243_ = _tmp242_;
				vala_report_error (_tmp238_, _tmp243_);
				_g_free0 (_tmp243_);
				_g_free0 (_tmp241_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	if (expected_num_type_args > given_num_type_args) {
		ValaSourceReference* _tmp244_;
		ValaSourceReference* _tmp245_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp245_ = _tmp244_;
		vala_report_error (_tmp245_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		if (expected_num_type_args < given_num_type_args) {
			ValaSourceReference* _tmp246_;
			ValaSourceReference* _tmp247_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp247_ = _tmp246_;
			vala_report_error (_tmp247_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp249_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp250_ = _tmp249_;
	if (_tmp250_ == NULL) {
		ValaList* _tmp251_;
		gint _tmp252_;
		gint _tmp253_;
		_tmp251_ = self->priv->argument_list;
		_tmp252_ = vala_collection_get_size ((ValaCollection*) _tmp251_);
		_tmp253_ = _tmp252_;
		_tmp248_ = _tmp253_ != 0;
	} else {
		_tmp248_ = FALSE;
	}
	if (_tmp248_) {
		ValaSourceReference* _tmp254_;
		ValaSourceReference* _tmp255_;
		ValaTypeSymbol* _tmp256_;
		gchar* _tmp257_;
		gchar* _tmp258_;
		gchar* _tmp259_;
		gchar* _tmp260_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp255_ = _tmp254_;
		_tmp256_ = type;
		_tmp257_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp256_);
		_tmp258_ = _tmp257_;
		_tmp259_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp258_);
		_tmp260_ = _tmp259_;
		vala_report_error (_tmp255_, _tmp260_);
		_g_free0 (_tmp260_);
		_g_free0 (_tmp258_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp262_ = _tmp261_;
	if (VALA_IS_METHOD (_tmp262_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp263_;
		ValaSymbol* _tmp264_;
		ValaMethod* _tmp265_;
		gboolean _tmp266_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp291_;
		ValaIterator* _tmp292_;
		ValaMethod* _tmp324_;
		gboolean _tmp325_;
		gboolean _tmp326_;
		ValaSemanticAnalyzer* _tmp387_;
		ValaSemanticAnalyzer* _tmp388_;
		ValaMethod* _tmp389_;
		ValaMethodType* _tmp390_;
		ValaMethodType* _tmp391_;
		ValaMethod* _tmp392_;
		ValaList* _tmp393_;
		ValaList* _tmp394_;
		_tmp263_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp264_ = _tmp263_;
		_tmp265_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp265_;
		_tmp266_ = self->priv->_is_yield_expression;
		if (_tmp266_) {
			ValaMethod* _tmp267_;
			gboolean _tmp268_;
			gboolean _tmp269_;
			gboolean _tmp272_ = FALSE;
			ValaSemanticAnalyzer* _tmp273_;
			ValaSemanticAnalyzer* _tmp274_;
			ValaMethod* _tmp275_;
			ValaMethod* _tmp276_;
			_tmp267_ = m;
			_tmp268_ = vala_method_get_coroutine (_tmp267_);
			_tmp269_ = _tmp268_;
			if (!_tmp269_) {
				ValaSourceReference* _tmp270_;
				ValaSourceReference* _tmp271_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp271_ = _tmp270_;
				vala_report_error (_tmp271_, "yield expression requires async method");
			}
			_tmp273_ = vala_code_context_get_analyzer (context);
			_tmp274_ = _tmp273_;
			_tmp275_ = vala_semantic_analyzer_get_current_method (_tmp274_);
			_tmp276_ = _tmp275_;
			if (_tmp276_ == NULL) {
				_tmp272_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp277_;
				ValaSemanticAnalyzer* _tmp278_;
				ValaMethod* _tmp279_;
				ValaMethod* _tmp280_;
				gboolean _tmp281_;
				gboolean _tmp282_;
				_tmp277_ = vala_code_context_get_analyzer (context);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_semantic_analyzer_get_current_method (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp281_ = vala_method_get_coroutine (_tmp280_);
				_tmp282_ = _tmp281_;
				_tmp272_ = !_tmp282_;
			}
			if (_tmp272_) {
				ValaSourceReference* _tmp283_;
				ValaSourceReference* _tmp284_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp284_ = _tmp283_;
				vala_report_error (_tmp284_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp285_;
			_tmp285_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp285_)) {
				ValaMethod* _tmp286_;
				gboolean _tmp287_;
				gboolean _tmp288_;
				_tmp286_ = m;
				_tmp287_ = vala_method_get_coroutine (_tmp286_);
				_tmp288_ = _tmp287_;
				if (_tmp288_) {
					ValaSourceReference* _tmp289_;
					ValaSourceReference* _tmp290_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp290_ = _tmp289_;
					vala_report_error (_tmp290_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp291_ = self->priv->argument_list;
		_tmp292_ = vala_iterable_iterator ((ValaIterable*) _tmp291_);
		arg_it = _tmp292_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp293_;
			ValaList* _tmp294_;
			ValaList* _tmp295_;
			gint _param_size = 0;
			ValaList* _tmp296_;
			gint _tmp297_;
			gint _tmp298_;
			gint _param_index = 0;
			_tmp293_ = m;
			_tmp294_ = vala_callable_get_parameters ((ValaCallable*) _tmp293_);
			_tmp295_ = _vala_iterable_ref0 (_tmp294_);
			_param_list = _tmp295_;
			_tmp296_ = _param_list;
			_tmp297_ = vala_collection_get_size ((ValaCollection*) _tmp296_);
			_tmp298_ = _tmp297_;
			_param_size = _tmp298_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp299_;
				gint _tmp300_;
				ValaParameter* param = NULL;
				ValaList* _tmp301_;
				gpointer _tmp302_;
				ValaParameter* _tmp303_;
				ValaParameter* _tmp304_;
				gboolean _tmp305_;
				gboolean _tmp306_;
				ValaIterator* _tmp307_;
				_param_index = _param_index + 1;
				_tmp299_ = _param_index;
				_tmp300_ = _param_size;
				if (!(_tmp299_ < _tmp300_)) {
					break;
				}
				_tmp301_ = _param_list;
				_tmp302_ = vala_list_get (_tmp301_, _param_index);
				param = (ValaParameter*) _tmp302_;
				_tmp303_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp303_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp304_ = param;
				_tmp305_ = vala_parameter_get_ellipsis (_tmp304_);
				_tmp306_ = _tmp305_;
				if (_tmp306_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp307_ = arg_it;
				if (vala_iterator_next (_tmp307_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp308_;
					gpointer _tmp309_;
					ValaExpression* _tmp310_;
					ValaParameter* _tmp311_;
					ValaDataType* _tmp312_;
					ValaDataType* _tmp313_;
					ValaExpression* _tmp314_;
					ValaExpression* _tmp315_;
					ValaDataType* _tmp316_;
					ValaDataType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					ValaDataType* _tmp320_;
					ValaDataType* _tmp321_;
					ValaExpression* _tmp322_;
					ValaExpression* _tmp323_;
					_tmp308_ = arg_it;
					_tmp309_ = vala_iterator_get (_tmp308_);
					arg = (ValaExpression*) _tmp309_;
					_tmp310_ = arg;
					_tmp311_ = param;
					_tmp312_ = vala_variable_get_variable_type ((ValaVariable*) _tmp311_);
					_tmp313_ = _tmp312_;
					vala_expression_set_formal_target_type (_tmp310_, _tmp313_);
					_tmp314_ = arg;
					_tmp315_ = arg;
					_tmp316_ = vala_expression_get_formal_target_type (_tmp315_);
					_tmp317_ = _tmp316_;
					_tmp318_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp319_ = _tmp318_;
					_tmp320_ = vala_data_type_get_actual_type (_tmp317_, _tmp319_, NULL, (ValaCodeNode*) self);
					_tmp321_ = _tmp320_;
					vala_expression_set_target_type (_tmp314_, _tmp321_);
					_vala_code_node_unref0 (_tmp321_);
					_tmp322_ = arg;
					_tmp323_ = _vala_code_node_ref0 (_tmp322_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp323_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp324_ = m;
		_tmp325_ = vala_method_get_printf_format (_tmp324_);
		_tmp326_ = _tmp325_;
		if (_tmp326_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp327_;
			ValaStringLiteral* _tmp368_;
			format_literal = NULL;
			_tmp327_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp327_)) {
			} else {
				ValaExpression* _tmp328_;
				_tmp328_ = last_arg;
				if (_tmp328_ != NULL) {
					ValaExpression* _tmp329_;
					ValaStringLiteral* _tmp330_;
					gboolean _tmp331_ = FALSE;
					ValaStringLiteral* _tmp332_;
					_tmp329_ = last_arg;
					_tmp330_ = vala_string_literal_get_format_literal (_tmp329_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp330_;
					_tmp332_ = format_literal;
					if (_tmp332_ == NULL) {
						ValaList* _tmp333_;
						gint _tmp334_;
						gint _tmp335_;
						ValaMethod* _tmp336_;
						ValaList* _tmp337_;
						gint _tmp338_;
						gint _tmp339_;
						_tmp333_ = self->priv->argument_list;
						_tmp334_ = vala_collection_get_size ((ValaCollection*) _tmp333_);
						_tmp335_ = _tmp334_;
						_tmp336_ = m;
						_tmp337_ = vala_callable_get_parameters ((ValaCallable*) _tmp336_);
						_tmp338_ = vala_collection_get_size ((ValaCollection*) _tmp337_);
						_tmp339_ = _tmp338_;
						_tmp331_ = _tmp335_ == (_tmp339_ - 1);
					} else {
						_tmp331_ = FALSE;
					}
					if (_tmp331_) {
						ValaStringLiteral* _tmp340_;
						ValaStringLiteral* _tmp341_;
						ValaSemanticAnalyzer* _tmp342_;
						ValaSemanticAnalyzer* _tmp343_;
						ValaDataType* _tmp344_;
						ValaDataType* _tmp345_;
						ValaDataType* _tmp346_;
						ValaList* _tmp347_;
						ValaList* _tmp348_;
						gint _tmp349_;
						gint _tmp350_;
						ValaStringLiteral* _tmp351_;
						ValaList* _tmp352_;
						ValaIterator* _tmp353_;
						_tmp340_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp340_;
						_tmp341_ = format_literal;
						_tmp342_ = vala_code_context_get_analyzer (context);
						_tmp343_ = _tmp342_;
						_tmp344_ = _tmp343_->string_type;
						_tmp345_ = vala_data_type_copy (_tmp344_);
						_tmp346_ = _tmp345_;
						vala_expression_set_target_type ((ValaExpression*) _tmp341_, _tmp346_);
						_vala_code_node_unref0 (_tmp346_);
						_tmp347_ = self->priv->argument_list;
						_tmp348_ = self->priv->argument_list;
						_tmp349_ = vala_collection_get_size ((ValaCollection*) _tmp348_);
						_tmp350_ = _tmp349_;
						_tmp351_ = format_literal;
						vala_list_insert (_tmp347_, _tmp350_ - 1, (ValaExpression*) _tmp351_);
						_tmp352_ = self->priv->argument_list;
						_tmp353_ = vala_iterable_iterator ((ValaIterable*) _tmp352_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp353_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp354_;
							ValaList* _tmp355_;
							ValaList* _tmp356_;
							gint _param_size = 0;
							ValaList* _tmp357_;
							gint _tmp358_;
							gint _tmp359_;
							gint _param_index = 0;
							_tmp354_ = m;
							_tmp355_ = vala_callable_get_parameters ((ValaCallable*) _tmp354_);
							_tmp356_ = _vala_iterable_ref0 (_tmp355_);
							_param_list = _tmp356_;
							_tmp357_ = _param_list;
							_tmp358_ = vala_collection_get_size ((ValaCollection*) _tmp357_);
							_tmp359_ = _tmp358_;
							_param_size = _tmp359_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp360_;
								gint _tmp361_;
								ValaParameter* param = NULL;
								ValaList* _tmp362_;
								gpointer _tmp363_;
								ValaParameter* _tmp364_;
								gboolean _tmp365_;
								gboolean _tmp366_;
								ValaIterator* _tmp367_;
								_param_index = _param_index + 1;
								_tmp360_ = _param_index;
								_tmp361_ = _param_size;
								if (!(_tmp360_ < _tmp361_)) {
									break;
								}
								_tmp362_ = _param_list;
								_tmp363_ = vala_list_get (_tmp362_, _param_index);
								param = (ValaParameter*) _tmp363_;
								_tmp364_ = param;
								_tmp365_ = vala_parameter_get_ellipsis (_tmp364_);
								_tmp366_ = _tmp365_;
								if (_tmp366_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp367_ = arg_it;
								vala_iterator_next (_tmp367_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp368_ = format_literal;
			if (_tmp368_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp369_;
				gchar* _tmp370_;
				ValaSemanticAnalyzer* _tmp371_;
				ValaSemanticAnalyzer* _tmp372_;
				const gchar* _tmp373_;
				ValaIterator* _tmp374_;
				ValaSourceReference* _tmp375_;
				ValaSourceReference* _tmp376_;
				_tmp369_ = format_literal;
				_tmp370_ = vala_string_literal_eval (_tmp369_);
				format = _tmp370_;
				_tmp371_ = vala_code_context_get_analyzer (context);
				_tmp372_ = _tmp371_;
				_tmp373_ = format;
				_tmp374_ = arg_it;
				_tmp375_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp376_ = _tmp375_;
				if (!vala_semantic_analyzer_check_print_format (_tmp372_, _tmp373_, _tmp374_, _tmp376_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp377_;
			ValaList* _tmp378_;
			gint _arg_size = 0;
			ValaList* _tmp379_;
			gint _tmp380_;
			gint _tmp381_;
			gint _arg_index = 0;
			_tmp377_ = self->priv->argument_list;
			_tmp378_ = _vala_iterable_ref0 (_tmp377_);
			_arg_list = _tmp378_;
			_tmp379_ = _arg_list;
			_tmp380_ = vala_collection_get_size ((ValaCollection*) _tmp379_);
			_tmp381_ = _tmp380_;
			_arg_size = _tmp381_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp382_;
				gint _tmp383_;
				ValaExpression* arg = NULL;
				ValaList* _tmp384_;
				gpointer _tmp385_;
				ValaExpression* _tmp386_;
				_arg_index = _arg_index + 1;
				_tmp382_ = _arg_index;
				_tmp383_ = _arg_size;
				if (!(_tmp382_ < _tmp383_)) {
					break;
				}
				_tmp384_ = _arg_list;
				_tmp385_ = vala_list_get (_tmp384_, _arg_index);
				arg = (ValaExpression*) _tmp385_;
				_tmp386_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp386_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp387_ = vala_code_context_get_analyzer (context);
		_tmp388_ = _tmp387_;
		_tmp389_ = m;
		_tmp390_ = vala_method_type_new (_tmp389_);
		_tmp391_ = _tmp390_;
		_tmp392_ = m;
		_tmp393_ = vala_callable_get_parameters ((ValaCallable*) _tmp392_);
		_tmp394_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp388_, (ValaExpression*) self, (ValaDataType*) _tmp391_, _tmp393_, _tmp394_);
		_vala_code_node_unref0 (_tmp391_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp395_;
		ValaDataType* _tmp396_;
		_tmp395_ = vala_object_creation_expression_get_type_reference (self);
		_tmp396_ = _tmp395_;
		if (VALA_IS_ERROR_TYPE (_tmp396_)) {
			ValaDataType* _tmp397_;
			ValaDataType* _tmp398_;
			ValaMemberAccess* _tmp401_;
			ValaMemberAccess* _tmp402_;
			ValaList* _tmp425_;
			gint _tmp426_;
			gint _tmp427_;
			_tmp397_ = vala_object_creation_expression_get_type_reference (self);
			_tmp398_ = _tmp397_;
			if (_tmp398_ != NULL) {
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				_tmp399_ = vala_object_creation_expression_get_type_reference (self);
				_tmp400_ = _tmp399_;
				vala_code_node_check ((ValaCodeNode*) _tmp400_, context);
			}
			_tmp401_ = vala_object_creation_expression_get_member_name (self);
			_tmp402_ = _tmp401_;
			if (_tmp402_ != NULL) {
				ValaMemberAccess* _tmp403_;
				ValaMemberAccess* _tmp404_;
				_tmp403_ = vala_object_creation_expression_get_member_name (self);
				_tmp404_ = _tmp403_;
				vala_code_node_check ((ValaCodeNode*) _tmp404_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp405_;
				ValaList* _tmp406_;
				gint _arg_size = 0;
				ValaList* _tmp407_;
				gint _tmp408_;
				gint _tmp409_;
				gint _arg_index = 0;
				_tmp405_ = self->priv->argument_list;
				_tmp406_ = _vala_iterable_ref0 (_tmp405_);
				_arg_list = _tmp406_;
				_tmp407_ = _arg_list;
				_tmp408_ = vala_collection_get_size ((ValaCollection*) _tmp407_);
				_tmp409_ = _tmp408_;
				_arg_size = _tmp409_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp410_;
					gint _tmp411_;
					ValaExpression* arg = NULL;
					ValaList* _tmp412_;
					gpointer _tmp413_;
					ValaExpression* _tmp414_;
					_arg_index = _arg_index + 1;
					_tmp410_ = _arg_index;
					_tmp411_ = _arg_size;
					if (!(_tmp410_ < _tmp411_)) {
						break;
					}
					_tmp412_ = _arg_list;
					_tmp413_ = vala_list_get (_tmp412_, _arg_index);
					arg = (ValaExpression*) _tmp413_;
					_tmp414_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp414_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp415_;
				ValaList* _tmp416_;
				gint _init_size = 0;
				ValaList* _tmp417_;
				gint _tmp418_;
				gint _tmp419_;
				gint _init_index = 0;
				_tmp415_ = self->priv->object_initializer;
				_tmp416_ = _vala_iterable_ref0 (_tmp415_);
				_init_list = _tmp416_;
				_tmp417_ = _init_list;
				_tmp418_ = vala_collection_get_size ((ValaCollection*) _tmp417_);
				_tmp419_ = _tmp418_;
				_init_size = _tmp419_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp420_;
					gint _tmp421_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp422_;
					gpointer _tmp423_;
					ValaMemberInitializer* _tmp424_;
					_init_index = _init_index + 1;
					_tmp420_ = _init_index;
					_tmp421_ = _init_size;
					if (!(_tmp420_ < _tmp421_)) {
						break;
					}
					_tmp422_ = _init_list;
					_tmp423_ = vala_list_get (_tmp422_, _init_index);
					init = (ValaMemberInitializer*) _tmp423_;
					_tmp424_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp424_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp425_ = self->priv->argument_list;
			_tmp426_ = vala_collection_get_size ((ValaCollection*) _tmp425_);
			_tmp427_ = _tmp426_;
			if (_tmp427_ == 0) {
				ValaSourceReference* _tmp428_;
				ValaSourceReference* _tmp429_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp428_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp429_ = _tmp428_;
				vala_report_error (_tmp429_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp430_;
				ValaIterator* _tmp431_;
				ValaIterator* _tmp432_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp433_;
				gpointer _tmp434_;
				gboolean _tmp435_ = FALSE;
				ValaExpression* _tmp436_;
				ValaDataType* _tmp437_;
				ValaDataType* _tmp438_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp447_;
				ValaStringLiteral* _tmp448_;
				ValaStringLiteral* _tmp449_;
				ValaList* _tmp458_;
				ValaIterator* _tmp459_;
				ValaIterator* _tmp460_;
				ValaSemanticAnalyzer* _tmp461_;
				ValaSemanticAnalyzer* _tmp462_;
				ValaIterator* _tmp463_;
				ValaSourceReference* _tmp464_;
				ValaSourceReference* _tmp465_;
				_tmp430_ = self->priv->argument_list;
				_tmp431_ = vala_iterable_iterator ((ValaIterable*) _tmp430_);
				arg_it = _tmp431_;
				_tmp432_ = arg_it;
				vala_iterator_next (_tmp432_);
				_tmp433_ = arg_it;
				_tmp434_ = vala_iterator_get (_tmp433_);
				ex = (ValaExpression*) _tmp434_;
				_tmp436_ = ex;
				_tmp437_ = vala_expression_get_value_type (_tmp436_);
				_tmp438_ = _tmp437_;
				if (_tmp438_ == NULL) {
					_tmp435_ = TRUE;
				} else {
					ValaExpression* _tmp439_;
					ValaDataType* _tmp440_;
					ValaDataType* _tmp441_;
					ValaSemanticAnalyzer* _tmp442_;
					ValaSemanticAnalyzer* _tmp443_;
					ValaDataType* _tmp444_;
					_tmp439_ = ex;
					_tmp440_ = vala_expression_get_value_type (_tmp439_);
					_tmp441_ = _tmp440_;
					_tmp442_ = vala_code_context_get_analyzer (context);
					_tmp443_ = _tmp442_;
					_tmp444_ = _tmp443_->string_type;
					_tmp435_ = !vala_data_type_compatible (_tmp441_, _tmp444_);
				}
				if (_tmp435_) {
					ValaSourceReference* _tmp445_;
					ValaSourceReference* _tmp446_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp445_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp446_ = _tmp445_;
					vala_report_error (_tmp446_, "Invalid type for argument 1");
				}
				_tmp447_ = ex;
				_tmp448_ = vala_string_literal_get_format_literal (_tmp447_);
				format_literal = _tmp448_;
				_tmp449_ = format_literal;
				if (_tmp449_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp450_;
					gchar* _tmp451_;
					ValaSemanticAnalyzer* _tmp452_;
					ValaSemanticAnalyzer* _tmp453_;
					const gchar* _tmp454_;
					ValaIterator* _tmp455_;
					ValaSourceReference* _tmp456_;
					ValaSourceReference* _tmp457_;
					_tmp450_ = format_literal;
					_tmp451_ = vala_string_literal_eval (_tmp450_);
					format = _tmp451_;
					_tmp452_ = vala_code_context_get_analyzer (context);
					_tmp453_ = _tmp452_;
					_tmp454_ = format;
					_tmp455_ = arg_it;
					_tmp456_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp457_ = _tmp456_;
					if (!vala_semantic_analyzer_check_print_format (_tmp453_, _tmp454_, _tmp455_, _tmp457_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp458_ = self->priv->argument_list;
				_tmp459_ = vala_iterable_iterator ((ValaIterable*) _tmp458_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp459_;
				_tmp460_ = arg_it;
				vala_iterator_next (_tmp460_);
				_tmp461_ = vala_code_context_get_analyzer (context);
				_tmp462_ = _tmp461_;
				_tmp463_ = arg_it;
				_tmp464_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp465_ = _tmp464_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp462_, _tmp463_, 1, _tmp465_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp466_;
		ValaList* _tmp467_;
		gint _arg_size = 0;
		ValaList* _tmp468_;
		gint _tmp469_;
		gint _tmp470_;
		gint _arg_index = 0;
		_tmp466_ = self->priv->argument_list;
		_tmp467_ = _vala_iterable_ref0 (_tmp466_);
		_arg_list = _tmp467_;
		_tmp468_ = _arg_list;
		_tmp469_ = vala_collection_get_size ((ValaCollection*) _tmp468_);
		_tmp470_ = _tmp469_;
		_arg_size = _tmp470_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp471_;
			gint _tmp472_;
			ValaExpression* arg = NULL;
			ValaList* _tmp473_;
			gpointer _tmp474_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp475_;
			gboolean _tmp476_ = FALSE;
			ValaSizeofExpression* _tmp477_;
			_arg_index = _arg_index + 1;
			_tmp471_ = _arg_index;
			_tmp472_ = _arg_size;
			if (!(_tmp471_ < _tmp472_)) {
				break;
			}
			_tmp473_ = _arg_list;
			_tmp474_ = vala_list_get (_tmp473_, _arg_index);
			arg = (ValaExpression*) _tmp474_;
			_tmp475_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp475_) ? ((ValaSizeofExpression*) _tmp475_) : NULL;
			_tmp477_ = sizeof_expr;
			if (_tmp477_ != NULL) {
				ValaSizeofExpression* _tmp478_;
				ValaDataType* _tmp479_;
				ValaDataType* _tmp480_;
				_tmp478_ = sizeof_expr;
				_tmp479_ = vala_sizeof_expression_get_type_reference (_tmp478_);
				_tmp480_ = _tmp479_;
				_tmp476_ = VALA_IS_GENERIC_TYPE (_tmp480_);
			} else {
				_tmp476_ = FALSE;
			}
			if (_tmp476_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp481_;
				ValaDataType* _tmp482_;
				ValaDataType* _tmp483_;
				ValaDataType* _tmp484_;
				ValaDataType* _tmp485_;
				ValaDataType* _tmp486_;
				ValaDataType* _tmp487_;
				ValaList* _tmp488_;
				ValaDataType* _tmp489_;
				ValaExpression* _tmp490_;
				ValaDataType* _tmp491_;
				ValaSourceReference* _tmp492_;
				ValaSourceReference* _tmp493_;
				ValaSizeofExpression* _tmp494_;
				ValaSizeofExpression* _tmp495_;
				_tmp481_ = sizeof_expr;
				_tmp482_ = vala_sizeof_expression_get_type_reference (_tmp481_);
				_tmp483_ = _tmp482_;
				_tmp484_ = vala_object_creation_expression_get_type_reference (self);
				_tmp485_ = _tmp484_;
				_tmp486_ = vala_object_creation_expression_get_type_reference (self);
				_tmp487_ = _tmp486_;
				_tmp488_ = vala_data_type_get_type_arguments (_tmp487_);
				_tmp489_ = vala_data_type_get_actual_type (_tmp483_, _tmp485_, _tmp488_, (ValaCodeNode*) self);
				sizeof_type = _tmp489_;
				_tmp490_ = arg;
				_tmp491_ = sizeof_type;
				_tmp492_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp493_ = _tmp492_;
				_tmp494_ = vala_sizeof_expression_new (_tmp491_, _tmp493_);
				_tmp495_ = _tmp494_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp490_, (ValaExpression*) _tmp495_);
				_vala_code_node_unref0 (_tmp495_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp496_ = type;
	_tmp497_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp496_);
	_tmp498_ = _tmp497_;
	if (!_tmp498_) {
		ValaSemanticAnalyzer* _tmp499_;
		ValaSemanticAnalyzer* _tmp500_;
		ValaDataType* _tmp501_;
		ValaDataType* _tmp502_;
		_tmp499_ = vala_code_context_get_analyzer (context);
		_tmp500_ = _tmp499_;
		_tmp501_ = vala_object_creation_expression_get_type_reference (self);
		_tmp502_ = _tmp501_;
		vala_semantic_analyzer_check_type (_tmp500_, _tmp502_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp503_;
		ValaList* _tmp504_;
		gint _init_size = 0;
		ValaList* _tmp505_;
		gint _tmp506_;
		gint _tmp507_;
		gint _init_index = 0;
		_tmp503_ = vala_object_creation_expression_get_object_initializer (self);
		_tmp504_ = _vala_iterable_ref0 (_tmp503_);
		_init_list = _tmp504_;
		_tmp505_ = _init_list;
		_tmp506_ = vala_collection_get_size ((ValaCollection*) _tmp505_);
		_tmp507_ = _tmp506_;
		_init_size = _tmp507_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp508_;
			gint _tmp509_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp510_;
			gpointer _tmp511_;
			ValaSemanticAnalyzer* _tmp512_;
			ValaSemanticAnalyzer* _tmp513_;
			ValaMemberInitializer* _tmp514_;
			ValaDataType* _tmp515_;
			ValaDataType* _tmp516_;
			_init_index = _init_index + 1;
			_tmp508_ = _init_index;
			_tmp509_ = _init_size;
			if (!(_tmp508_ < _tmp509_)) {
				break;
			}
			_tmp510_ = _init_list;
			_tmp511_ = vala_list_get (_tmp510_, _init_index);
			init = (ValaMemberInitializer*) _tmp511_;
			_tmp512_ = vala_code_context_get_analyzer (context);
			_tmp513_ = _tmp512_;
			_tmp514_ = init;
			_tmp515_ = vala_object_creation_expression_get_type_reference (self);
			_tmp516_ = _tmp515_;
			vala_semantic_analyzer_visit_member_initializer (_tmp513_, _tmp514_, _tmp516_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp517_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp518_ = _tmp517_;
	if (_tmp518_) {
		gboolean _tmp519_ = FALSE;
		ValaCodeNode* _tmp520_;
		ValaCodeNode* _tmp521_;
		_tmp520_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp521_ = _tmp520_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp521_)) {
			_tmp519_ = TRUE;
		} else {
			ValaCodeNode* _tmp522_;
			ValaCodeNode* _tmp523_;
			_tmp522_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp523_ = _tmp522_;
			_tmp519_ = VALA_IS_EXPRESSION_STATEMENT (_tmp523_);
		}
		if (_tmp519_) {
		} else {
			ValaSemanticAnalyzer* _tmp524_;
			ValaSemanticAnalyzer* _tmp525_;
			ValaSymbol* _tmp526_;
			ValaSymbol* _tmp527_;
			_tmp524_ = vala_code_context_get_analyzer (context);
			_tmp525_ = _tmp524_;
			_tmp526_ = vala_semantic_analyzer_get_current_symbol (_tmp525_);
			_tmp527_ = _tmp526_;
			if (!VALA_IS_BLOCK (_tmp527_)) {
				ValaSourceReference* _tmp528_;
				ValaSourceReference* _tmp529_;
				_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp529_ = _tmp528_;
				vala_report_error (_tmp529_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp530_;
				ValaCodeNode* _tmp531_;
				ValaCodeNode* _tmp532_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp533_;
				ValaDataType* _tmp534_;
				ValaDataType* _tmp535_;
				ValaDataType* _tmp536_;
				gchar* _tmp537_;
				gchar* _tmp538_;
				ValaSourceReference* _tmp539_;
				ValaSourceReference* _tmp540_;
				ValaLocalVariable* _tmp541_;
				ValaLocalVariable* _tmp542_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp543_;
				ValaSourceReference* _tmp544_;
				ValaSourceReference* _tmp545_;
				ValaDeclarationStatement* _tmp546_;
				ValaSemanticAnalyzer* _tmp547_;
				ValaSemanticAnalyzer* _tmp548_;
				ValaBlock* _tmp549_;
				ValaDeclarationStatement* _tmp550_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp551_;
				ValaDataType* _tmp552_;
				ValaDataType* _tmp553_;
				ValaExpression* _tmp554_;
				ValaExpression* _tmp555_;
				ValaDataType* _tmp556_;
				ValaDataType* _tmp557_;
				ValaLocalVariable* _tmp558_;
				ValaDeclarationStatement* _tmp559_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp560_;
				ValaSemanticAnalyzer* _tmp561_;
				ValaSymbol* _tmp562_;
				ValaSymbol* _tmp563_;
				ValaBlock* _tmp564_;
				ValaBlock* _tmp565_;
				ValaLocalVariable* _tmp566_;
				ValaSemanticAnalyzer* _tmp567_;
				ValaSemanticAnalyzer* _tmp568_;
				ValaBlock* _tmp569_;
				ValaLocalVariable* _tmp570_;
				ValaCodeNode* _tmp571_;
				ValaExpression* _tmp572_;
				ValaExpression* _tmp573_;
				_tmp530_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp531_ = _tmp530_;
				_tmp532_ = _vala_code_node_ref0 (_tmp531_);
				old_parent_node = _tmp532_;
				_tmp533_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp534_ = _tmp533_;
				_tmp535_ = vala_data_type_copy (_tmp534_);
				_tmp536_ = _tmp535_;
				_tmp537_ = vala_code_node_get_temp_name ();
				_tmp538_ = _tmp537_;
				_tmp539_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp540_ = _tmp539_;
				_tmp541_ = vala_local_variable_new (_tmp536_, _tmp538_, NULL, _tmp540_);
				_tmp542_ = _tmp541_;
				_g_free0 (_tmp538_);
				_vala_code_node_unref0 (_tmp536_);
				local = _tmp542_;
				_tmp543_ = local;
				_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp545_ = _tmp544_;
				_tmp546_ = vala_declaration_statement_new ((ValaSymbol*) _tmp543_, _tmp545_);
				decl = _tmp546_;
				_tmp547_ = vala_code_context_get_analyzer (context);
				_tmp548_ = _tmp547_;
				_tmp549_ = _tmp548_->insert_block;
				_tmp550_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp549_, (ValaStatement*) _tmp550_);
				_tmp551_ = local;
				_tmp552_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp553_ = _tmp552_;
				_tmp554_ = vala_semantic_analyzer_create_temp_access (_tmp551_, _tmp553_);
				temp_access = _tmp554_;
				_tmp555_ = temp_access;
				_tmp556_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp557_ = _tmp556_;
				vala_expression_set_formal_target_type (_tmp555_, _tmp557_);
				_tmp558_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp558_, (ValaExpression*) self);
				_tmp559_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp559_, context);
				_tmp560_ = vala_code_context_get_analyzer (context);
				_tmp561_ = _tmp560_;
				_tmp562_ = vala_semantic_analyzer_get_current_symbol (_tmp561_);
				_tmp563_ = _tmp562_;
				_tmp564_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp563_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp564_;
				_tmp565_ = block;
				_tmp566_ = local;
				vala_block_remove_local_variable (_tmp565_, _tmp566_);
				_tmp567_ = vala_code_context_get_analyzer (context);
				_tmp568_ = _tmp567_;
				_tmp569_ = _tmp568_->insert_block;
				_tmp570_ = local;
				vala_block_add_local_variable (_tmp569_, _tmp570_);
				_tmp571_ = old_parent_node;
				_tmp572_ = temp_access;
				vala_code_node_replace_expression (_tmp571_, (ValaExpression*) self, _tmp572_);
				_tmp573_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp573_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp574_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp575_ = _tmp574_;
	result = !_tmp575_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp9_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _init_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _init_index = 0;
		_tmp10_ = self->priv->object_initializer;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_init_list = _tmp11_;
		_tmp12_ = _init_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_init_size = _tmp14_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaMemberInitializer* _tmp19_;
			_init_index = _init_index + 1;
			_tmp15_ = _init_index;
			_tmp16_ = _init_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _init_list;
			_tmp18_ = vala_list_get (_tmp17_, _init_index);
			init = (ValaMemberInitializer*) _tmp18_;
			_tmp19_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _init_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _init_index = 0;
		_tmp10_ = self->priv->object_initializer;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_init_list = _tmp11_;
		_tmp12_ = _init_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_init_size = _tmp14_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaMemberInitializer* _tmp19_;
			_init_index = _init_index + 1;
			_tmp15_ = _init_index;
			_tmp16_ = _init_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _init_list;
			_tmp18_ = vala_list_get (_tmp17_, _init_index);
			init = (ValaMemberInitializer*) _tmp18_;
			_tmp19_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp19_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp3_;
	ValaMemberAccess* _tmp5_;
	ValaMemberAccess* _tmp6_;
	GString* _tmp12_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result = NULL;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = self->priv->_is_yield_expression;
	if (_tmp1_) {
		GString* _tmp2_;
		_tmp2_ = b;
		g_string_append (_tmp2_, "yield ");
	}
	_tmp3_ = self->priv->_struct_creation;
	if (!_tmp3_) {
		GString* _tmp4_;
		_tmp4_ = b;
		g_string_append (_tmp4_, "new ");
	}
	_tmp5_ = vala_object_creation_expression_get_member_name (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		GString* _tmp7_;
		ValaMemberAccess* _tmp8_;
		ValaMemberAccess* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = b;
		_tmp8_ = vala_object_creation_expression_get_member_name (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		g_string_append (_tmp7_, _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp12_ = b;
	g_string_append_c (_tmp12_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp13_ = self->priv->argument_list;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}

