/* valaforstatement.c generated by valac, the Vala compiler
 * generated from valaforstatement.vala, do not modify */

/* valaforstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaForStatementPrivate {
	ValaList* initializer;
	ValaList* iterator;
	ValaExpression* _condition;
	ValaBlock* _body;
};

static gint ValaForStatement_private_offset;
static gpointer vala_for_statement_parent_class = NULL;
static ValaStatementIface * vala_for_statement_vala_statement_parent_iface = NULL;

static void vala_for_statement_set_condition (ValaForStatement* self,
                                       ValaExpression* value);
static void vala_for_statement_set_body (ValaForStatement* self,
                                  ValaBlock* value);
static void vala_for_statement_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_for_statement_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static void vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_for_statement_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static void vala_for_statement_finalize (ValaCodeNode * obj);
static GType vala_for_statement_get_type_once (void);

static inline gpointer
vala_for_statement_get_instance_private (ValaForStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaForStatement_private_offset);
}

ValaExpression*
vala_for_statement_get_condition (ValaForStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_for_statement_set_condition (ValaForStatement* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp0_;
	_tmp1_ = self->priv->_condition;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_condition;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

ValaBlock*
vala_for_statement_get_body (ValaForStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

static void
vala_for_statement_set_body (ValaForStatement* self,
                             ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new for statement.
 *
 * @param condition        loop condition
 * @param body             loop body
 * @param source_reference reference to source code
 * @return                 newly created for statement
 */
ValaForStatement*
vala_for_statement_construct (GType object_type,
                              ValaExpression* condition,
                              ValaBlock* body,
                              ValaSourceReference* source_reference)
{
	ValaForStatement* self = NULL;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaForStatement*) vala_code_node_construct (object_type);
	vala_for_statement_set_condition (self, condition);
	vala_for_statement_set_body (self, body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaForStatement*
vala_for_statement_new (ValaExpression* condition,
                        ValaBlock* body,
                        ValaSourceReference* source_reference)
{
	return vala_for_statement_construct (VALA_TYPE_FOR_STATEMENT, condition, body, source_reference);
}

/**
 * Appends the specified expression to the list of initializers.
 *
 * @param init an initializer expression
 */
void
vala_for_statement_add_initializer (ValaForStatement* self,
                                    ValaExpression* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
	_tmp0_ = self->priv->initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
}

/**
 * Returns the list of initializers.
 *
 * @return initializer list
 */
ValaList*
vala_for_statement_get_initializer (ValaForStatement* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializer;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified expression to the iterator.
 *
 * @param iter an iterator expression
 */
void
vala_for_statement_add_iterator (ValaForStatement* self,
                                 ValaExpression* iter)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) iter, (ValaCodeNode*) self);
	_tmp0_ = self->priv->iterator;
	vala_collection_add ((ValaCollection*) _tmp0_, iter);
}

/**
 * Returns the iterator.
 *
 * @return iterator
 */
ValaList*
vala_for_statement_get_iterator (ValaForStatement* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->iterator;
	result = _tmp0_;
	return result;
}

static void
vala_for_statement_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_for_statement (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_for_statement_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	ValaExpression* _tmp11_;
	ValaExpression* _tmp12_;
	ValaBlock* _tmp28_;
	ValaBlock* _tmp29_;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _init_expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _init_expr_index = 0;
		_tmp0_ = self->priv->initializer;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_init_expr_list = _tmp1_;
		_tmp2_ = _init_expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_init_expr_size = _tmp4_;
		_init_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* init_expr = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_init_expr_index = _init_expr_index + 1;
			_tmp5_ = _init_expr_index;
			_tmp6_ = _init_expr_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _init_expr_list;
			_tmp8_ = vala_list_get (_tmp7_, _init_expr_index);
			init_expr = (ValaExpression*) _tmp8_;
			_tmp9_ = init_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_tmp10_ = init_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp10_);
			_vala_code_node_unref0 (init_expr);
		}
		_vala_iterable_unref0 (_init_expr_list);
	}
	_tmp11_ = vala_for_statement_get_condition (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp13_ = vala_for_statement_get_condition (self);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
		_tmp15_ = vala_for_statement_get_condition (self);
		_tmp16_ = _tmp15_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp16_);
	}
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _it_expr_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _it_expr_index = 0;
		_tmp17_ = self->priv->iterator;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_it_expr_list = _tmp18_;
		_tmp19_ = _it_expr_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_it_expr_size = _tmp21_;
		_it_expr_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			ValaExpression* it_expr = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			_it_expr_index = _it_expr_index + 1;
			_tmp22_ = _it_expr_index;
			_tmp23_ = _it_expr_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _it_expr_list;
			_tmp25_ = vala_list_get (_tmp24_, _it_expr_index);
			it_expr = (ValaExpression*) _tmp25_;
			_tmp26_ = it_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp26_, visitor);
			_tmp27_ = it_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp27_);
			_vala_code_node_unref0 (it_expr);
		}
		_vala_iterable_unref0 (_it_expr_list);
	}
	_tmp28_ = vala_for_statement_get_body (self);
	_tmp29_ = _tmp28_;
	vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
}

static void
vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaForStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaForStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_for_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_for_statement_set_condition (self, new_node);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				ValaList* _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->initializer;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->initializer;
				_tmp8_ = vala_list_get (_tmp7_, i);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = _tmp9_ == old_node;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					_tmp11_ = self->priv->initializer;
					vala_list_set (_tmp11_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				ValaList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				ValaList* _tmp17_;
				gpointer _tmp18_;
				ValaExpression* _tmp19_;
				gboolean _tmp20_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = self->priv->iterator;
				_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				if (!(i < _tmp16_)) {
					break;
				}
				_tmp17_ = self->priv->iterator;
				_tmp18_ = vala_list_get (_tmp17_, i);
				_tmp19_ = (ValaExpression*) _tmp18_;
				_tmp20_ = _tmp19_ == old_node;
				_vala_code_node_unref0 (_tmp19_);
				if (_tmp20_) {
					ValaList* _tmp21_;
					_tmp21_ = self->priv->iterator;
					vala_list_set (_tmp21_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gboolean
vala_for_statement_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaForStatement * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* block = NULL;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaBlock* _tmp6_;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaLocalVariable* first_local = NULL;
	ValaSemanticAnalyzer* _tmp67_;
	ValaSemanticAnalyzer* _tmp68_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	ValaDataType* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaSourceReference* _tmp75_;
	ValaBooleanLiteral* _tmp76_;
	ValaBooleanLiteral* _tmp77_;
	ValaSourceReference* _tmp78_;
	ValaSourceReference* _tmp79_;
	ValaLocalVariable* _tmp80_;
	ValaLocalVariable* _tmp81_;
	ValaBlock* _tmp82_;
	ValaLocalVariable* _tmp83_;
	ValaSourceReference* _tmp84_;
	ValaSourceReference* _tmp85_;
	ValaDeclarationStatement* _tmp86_;
	ValaDeclarationStatement* _tmp87_;
	ValaBlock* iterator_block = NULL;
	ValaSourceReference* _tmp88_;
	ValaSourceReference* _tmp89_;
	ValaBlock* _tmp90_;
	ValaIfStatement* first_if = NULL;
	ValaLocalVariable* _tmp107_;
	const gchar* _tmp108_;
	const gchar* _tmp109_;
	ValaSourceReference* _tmp110_;
	ValaSourceReference* _tmp111_;
	ValaMemberAccess* _tmp112_;
	ValaMemberAccess* _tmp113_;
	ValaSourceReference* _tmp114_;
	ValaSourceReference* _tmp115_;
	ValaUnaryExpression* _tmp116_;
	ValaUnaryExpression* _tmp117_;
	ValaBlock* _tmp118_;
	ValaSourceReference* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaIfStatement* _tmp121_;
	ValaIfStatement* _tmp122_;
	ValaBlock* _tmp123_;
	ValaBlock* _tmp124_;
	ValaIfStatement* _tmp125_;
	ValaBlock* _tmp126_;
	ValaBlock* _tmp127_;
	ValaLocalVariable* _tmp128_;
	const gchar* _tmp129_;
	const gchar* _tmp130_;
	ValaSourceReference* _tmp131_;
	ValaSourceReference* _tmp132_;
	ValaMemberAccess* _tmp133_;
	ValaMemberAccess* _tmp134_;
	ValaSourceReference* _tmp135_;
	ValaSourceReference* _tmp136_;
	ValaBooleanLiteral* _tmp137_;
	ValaBooleanLiteral* _tmp138_;
	ValaSourceReference* _tmp139_;
	ValaSourceReference* _tmp140_;
	ValaAssignment* _tmp141_;
	ValaAssignment* _tmp142_;
	ValaSourceReference* _tmp143_;
	ValaSourceReference* _tmp144_;
	ValaExpressionStatement* _tmp145_;
	ValaExpressionStatement* _tmp146_;
	ValaBlock* _tmp147_;
	ValaBlock* _tmp148_;
	ValaBlock* _tmp149_;
	ValaSourceReference* _tmp150_;
	ValaSourceReference* _tmp151_;
	ValaLoop* _tmp152_;
	ValaLoop* _tmp153_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp154_;
	ValaCodeNode* _tmp155_;
	ValaBlock* _tmp156_;
	ValaBlock* _tmp157_;
	ValaBlock* _tmp158_;
	gboolean _tmp159_;
	gboolean _tmp160_;
	gboolean result = FALSE;
	self = (ValaForStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_block_new (_tmp5_);
	block = _tmp6_;
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp7_;
		ValaList* _tmp8_;
		gint _init_expr_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _init_expr_index = 0;
		_tmp7_ = self->priv->initializer;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_init_expr_list = _tmp8_;
		_tmp9_ = _init_expr_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_init_expr_size = _tmp11_;
		_init_expr_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* init_expr = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaBlock* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaExpressionStatement* _tmp21_;
			ValaExpressionStatement* _tmp22_;
			_init_expr_index = _init_expr_index + 1;
			_tmp12_ = _init_expr_index;
			_tmp13_ = _init_expr_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _init_expr_list;
			_tmp15_ = vala_list_get (_tmp14_, _init_expr_index);
			init_expr = (ValaExpression*) _tmp15_;
			_tmp16_ = block;
			_tmp17_ = init_expr;
			_tmp18_ = init_expr;
			_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_expression_statement_new (_tmp17_, _tmp20_);
			_tmp22_ = _tmp21_;
			vala_block_add_statement (_tmp16_, (ValaStatement*) _tmp22_);
			_vala_code_node_unref0 (_tmp22_);
			_vala_code_node_unref0 (init_expr);
		}
		_vala_iterable_unref0 (_init_expr_list);
	}
	_tmp24_ = vala_for_statement_get_condition (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == NULL) {
		_tmp23_ = TRUE;
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_for_statement_get_condition (self);
		_tmp27_ = _tmp26_;
		_tmp23_ = vala_expression_is_always_true (_tmp27_);
	}
	if (_tmp23_) {
	} else {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		_tmp28_ = vala_for_statement_get_condition (self);
		_tmp29_ = _tmp28_;
		if (vala_expression_is_always_false (_tmp29_)) {
			ValaBlock* _tmp30_;
			ValaBlock* _tmp31_;
			ValaExpression* _tmp32_;
			ValaExpression* _tmp33_;
			ValaSourceReference* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaBreakStatement* _tmp36_;
			ValaBreakStatement* _tmp37_;
			_tmp30_ = vala_for_statement_get_body (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_for_statement_get_condition (self);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_break_statement_new (_tmp35_);
			_tmp37_ = _tmp36_;
			vala_block_insert_statement (_tmp31_, 0, (ValaStatement*) _tmp37_);
			_vala_code_node_unref0 (_tmp37_);
		} else {
			ValaUnaryExpression* if_condition = NULL;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaExpression* _tmp40_;
			ValaExpression* _tmp41_;
			ValaSourceReference* _tmp42_;
			ValaSourceReference* _tmp43_;
			ValaUnaryExpression* _tmp44_;
			ValaBlock* true_block = NULL;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaSourceReference* _tmp47_;
			ValaSourceReference* _tmp48_;
			ValaBlock* _tmp49_;
			ValaBlock* _tmp50_;
			ValaExpression* _tmp51_;
			ValaExpression* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaBreakStatement* _tmp55_;
			ValaBreakStatement* _tmp56_;
			ValaIfStatement* if_stmt = NULL;
			ValaUnaryExpression* _tmp57_;
			ValaBlock* _tmp58_;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaIfStatement* _tmp63_;
			ValaBlock* _tmp64_;
			ValaBlock* _tmp65_;
			ValaIfStatement* _tmp66_;
			_tmp38_ = vala_for_statement_get_condition (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_for_statement_get_condition (self);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp39_, _tmp43_);
			if_condition = _tmp44_;
			_tmp45_ = vala_for_statement_get_condition (self);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_block_new (_tmp48_);
			true_block = _tmp49_;
			_tmp50_ = true_block;
			_tmp51_ = vala_for_statement_get_condition (self);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_break_statement_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_block_add_statement (_tmp50_, (ValaStatement*) _tmp56_);
			_vala_code_node_unref0 (_tmp56_);
			_tmp57_ = if_condition;
			_tmp58_ = true_block;
			_tmp59_ = vala_for_statement_get_condition (self);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_if_statement_new ((ValaExpression*) _tmp57_, _tmp58_, NULL, _tmp62_);
			if_stmt = _tmp63_;
			_tmp64_ = vala_for_statement_get_body (self);
			_tmp65_ = _tmp64_;
			_tmp66_ = if_stmt;
			vala_block_insert_statement (_tmp65_, 0, (ValaStatement*) _tmp66_);
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (if_condition);
		}
	}
	_tmp67_ = vala_code_context_get_analyzer (context);
	_tmp68_ = _tmp67_;
	_tmp69_ = _tmp68_->bool_type;
	_tmp70_ = vala_data_type_copy (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_code_node_get_temp_name ();
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_boolean_literal_new (TRUE, _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp79_ = _tmp78_;
	_tmp80_ = vala_local_variable_new (_tmp71_, _tmp73_, (ValaExpression*) _tmp77_, _tmp79_);
	_tmp81_ = _tmp80_;
	_vala_code_node_unref0 (_tmp77_);
	_g_free0 (_tmp73_);
	_vala_code_node_unref0 (_tmp71_);
	first_local = _tmp81_;
	_tmp82_ = block;
	_tmp83_ = first_local;
	_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_declaration_statement_new ((ValaSymbol*) _tmp83_, _tmp85_);
	_tmp87_ = _tmp86_;
	vala_block_add_statement (_tmp82_, (ValaStatement*) _tmp87_);
	_vala_code_node_unref0 (_tmp87_);
	_tmp88_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp89_ = _tmp88_;
	_tmp90_ = vala_block_new (_tmp89_);
	iterator_block = _tmp90_;
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp91_;
		ValaList* _tmp92_;
		gint _it_expr_size = 0;
		ValaList* _tmp93_;
		gint _tmp94_;
		gint _tmp95_;
		gint _it_expr_index = 0;
		_tmp91_ = self->priv->iterator;
		_tmp92_ = _vala_iterable_ref0 (_tmp91_);
		_it_expr_list = _tmp92_;
		_tmp93_ = _it_expr_list;
		_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
		_tmp95_ = _tmp94_;
		_it_expr_size = _tmp95_;
		_it_expr_index = -1;
		while (TRUE) {
			gint _tmp96_;
			gint _tmp97_;
			ValaExpression* it_expr = NULL;
			ValaList* _tmp98_;
			gpointer _tmp99_;
			ValaBlock* _tmp100_;
			ValaExpression* _tmp101_;
			ValaExpression* _tmp102_;
			ValaSourceReference* _tmp103_;
			ValaSourceReference* _tmp104_;
			ValaExpressionStatement* _tmp105_;
			ValaExpressionStatement* _tmp106_;
			_it_expr_index = _it_expr_index + 1;
			_tmp96_ = _it_expr_index;
			_tmp97_ = _it_expr_size;
			if (!(_tmp96_ < _tmp97_)) {
				break;
			}
			_tmp98_ = _it_expr_list;
			_tmp99_ = vala_list_get (_tmp98_, _it_expr_index);
			it_expr = (ValaExpression*) _tmp99_;
			_tmp100_ = iterator_block;
			_tmp101_ = it_expr;
			_tmp102_ = it_expr;
			_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp102_);
			_tmp104_ = _tmp103_;
			_tmp105_ = vala_expression_statement_new (_tmp101_, _tmp104_);
			_tmp106_ = _tmp105_;
			vala_block_add_statement (_tmp100_, (ValaStatement*) _tmp106_);
			_vala_code_node_unref0 (_tmp106_);
			_vala_code_node_unref0 (it_expr);
		}
		_vala_iterable_unref0 (_it_expr_list);
	}
	_tmp107_ = first_local;
	_tmp108_ = vala_symbol_get_name ((ValaSymbol*) _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_member_access_new_simple (_tmp109_, _tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaExpression*) _tmp113_, _tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = iterator_block;
	_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_if_statement_new ((ValaExpression*) _tmp117_, _tmp118_, NULL, _tmp120_);
	_tmp122_ = _tmp121_;
	_vala_code_node_unref0 (_tmp117_);
	_vala_code_node_unref0 (_tmp113_);
	first_if = _tmp122_;
	_tmp123_ = vala_for_statement_get_body (self);
	_tmp124_ = _tmp123_;
	_tmp125_ = first_if;
	vala_block_insert_statement (_tmp124_, 0, (ValaStatement*) _tmp125_);
	_tmp126_ = vala_for_statement_get_body (self);
	_tmp127_ = _tmp126_;
	_tmp128_ = first_local;
	_tmp129_ = vala_symbol_get_name ((ValaSymbol*) _tmp128_);
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_member_access_new_simple (_tmp130_, _tmp132_);
	_tmp134_ = _tmp133_;
	_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_boolean_literal_new (FALSE, _tmp136_);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_assignment_new ((ValaExpression*) _tmp134_, (ValaExpression*) _tmp138_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp140_);
	_tmp142_ = _tmp141_;
	_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp144_ = _tmp143_;
	_tmp145_ = vala_expression_statement_new ((ValaExpression*) _tmp142_, _tmp144_);
	_tmp146_ = _tmp145_;
	vala_block_insert_statement (_tmp127_, 1, (ValaStatement*) _tmp146_);
	_vala_code_node_unref0 (_tmp146_);
	_vala_code_node_unref0 (_tmp142_);
	_vala_code_node_unref0 (_tmp138_);
	_vala_code_node_unref0 (_tmp134_);
	_tmp147_ = block;
	_tmp148_ = vala_for_statement_get_body (self);
	_tmp149_ = _tmp148_;
	_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp151_ = _tmp150_;
	_tmp152_ = vala_loop_new (_tmp149_, _tmp151_);
	_tmp153_ = _tmp152_;
	vala_block_add_statement (_tmp147_, (ValaStatement*) _tmp153_);
	_vala_code_node_unref0 (_tmp153_);
	_tmp154_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp155_ = _tmp154_;
	parent_block = G_TYPE_CHECK_INSTANCE_CAST (_tmp155_, VALA_TYPE_BLOCK, ValaBlock);
	_tmp156_ = parent_block;
	_tmp157_ = block;
	vala_block_replace_statement (_tmp156_, (ValaStatement*) self, (ValaStatement*) _tmp157_);
	_tmp158_ = block;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp158_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
	}
	_tmp159_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp160_ = _tmp159_;
	result = !_tmp160_;
	_vala_code_node_unref0 (first_if);
	_vala_code_node_unref0 (iterator_block);
	_vala_code_node_unref0 (first_local);
	_vala_code_node_unref0 (block);
	return result;
}

static void
vala_for_statement_class_init (ValaForStatementClass * klass,
                               gpointer klass_data)
{
	vala_for_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_for_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaForStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_for_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_for_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_for_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_for_statement_real_check;
}

static void
vala_for_statement_vala_statement_interface_init (ValaStatementIface * iface,
                                                  gpointer iface_data)
{
	vala_for_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}

static void
vala_for_statement_instance_init (ValaForStatement * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_for_statement_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializer = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->iterator = (ValaList*) _tmp3_;
}

static void
vala_for_statement_finalize (ValaCodeNode * obj)
{
	ValaForStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FOR_STATEMENT, ValaForStatement);
	_vala_iterable_unref0 (self->priv->initializer);
	_vala_iterable_unref0 (self->priv->iterator);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_for_statement_parent_class)->finalize (obj);
}

/**
 * Represents a for iteration statement in the source code.
 */
static GType
vala_for_statement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForStatement), 0, (GInstanceInitFunc) vala_for_statement_instance_init, NULL };
	static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_for_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_for_statement_type_id;
	vala_for_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaForStatement", &g_define_type_info, 0);
	g_type_add_interface_static (vala_for_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	ValaForStatement_private_offset = g_type_add_instance_private (vala_for_statement_type_id, sizeof (ValaForStatementPrivate));
	return vala_for_statement_type_id;
}

GType
vala_for_statement_get_type (void)
{
	static volatile gsize vala_for_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_for_statement_type_id__volatile)) {
		GType vala_for_statement_type_id;
		vala_for_statement_type_id = vala_for_statement_get_type_once ();
		g_once_init_leave (&vala_for_statement_type_id__volatile, vala_for_statement_type_id);
	}
	return vala_for_statement_type_id__volatile;
}

