/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_gsignal_module_parent_class = NULL;

static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                                    ValaSignal* sig,
                                                    ValaList* params,
                                                    ValaDataType* return_type,
                                                    const gchar* prefix);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                                     ValaSignal* sig,
                                                     ValaList* params,
                                                     ValaDataType* return_type);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                                    ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                               ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                                      ValaSignal* sig,
                                                                      ValaExpression* detail_expr,
                                                                      ValaCodeNode* node);
static ValaCCodeExpression* vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                                                    ValaSignal* sig);
static ValaCCodeExpression* vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                                                 ValaExpression* detail_expr,
                                                                 ValaCodeNode* node);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                            ValaSignal* sig);
static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                              ValaSignal* sig,
                                              ValaList* params,
                                              ValaDataType* return_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                                                   ValaSignal* sig,
                                                                   ValaTypeSymbol* type);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                                    ValaElementAccess* expr);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                                  ValaMethod* m);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                                   ValaMemberAccess* expr);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                                         ValaSignal* sig,
                                                         ValaExpression* signal_access,
                                                         ValaExpression* handler,
                                                         gboolean disconnect,
                                                         gboolean after,
                                                         ValaCodeNode* expr);
static GType vala_gsignal_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                             ValaSignal* sig,
                                             ValaList* params,
                                             ValaDataType* return_type,
                                             const gchar* prefix)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* ret = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, sig, params, return_type);
	signature = _tmp0_;
	if (prefix == NULL) {
		ValaSet* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
		_tmp2_ = signature;
		if (vala_collection_contains ((ValaCollection*) _tmp1_, _tmp2_)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp3_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_%s_", prefix, _tmp4_);
	_g_free0 (ret);
	ret = _tmp5_;
	_g_free0 (_tmp4_);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp6_;
		gint _p_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _p_index = 0;
		_tmp6_ = _vala_iterable_ref0 (params);
		_p_list = _tmp6_;
		_tmp7_ = _p_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_p_size = _tmp9_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
			ValaParameter* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp10_ = _p_list;
			_tmp11_ = vala_list_get (_tmp10_, _p_index);
			p = (ValaParameter*) _tmp11_;
			_tmp12_ = ret;
			_tmp13_ = p;
			_tmp14_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = string_replace (_tmp15_, ",", "_");
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("%s_%s", _tmp12_, _tmp17_);
			_g_free0 (ret);
			ret = _tmp18_;
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp19_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp20_ = _tmp19_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp20_)) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp21_ = ret;
		_tmp22_ = g_strconcat (_tmp21_, "_POINTER", NULL);
		_g_free0 (ret);
		ret = _tmp22_;
	} else {
		gint _tmp23_;
		gint _tmp24_;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp24_ = _tmp23_;
		if (_tmp24_ == 0) {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = ret;
			_tmp26_ = g_strconcat (_tmp25_, "_VOID", NULL);
			_g_free0 (ret);
			ret = _tmp26_;
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                             ValaDataType* t)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_POINTER_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gpointer");
		result = _tmp1_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VOID_TYPE)) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("void");
			result = _tmp2_;
			return result;
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			ValaDataType* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = vala_get_ccode_type_id ((ValaCodeNode*) t);
			_tmp4_ = _tmp3_;
			_tmp5_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp6_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp4_, _tmp7_) == 0;
			_g_free0 (_tmp7_);
			_g_free0 (_tmp4_);
			if (_tmp8_) {
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("const char*");
				result = _tmp9_;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp11_ = vala_data_type_get_type_symbol (t);
				_tmp12_ = _tmp11_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
					_tmp10_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					_tmp13_ = vala_data_type_get_type_symbol (t);
					_tmp14_ = _tmp13_;
					_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE);
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("gpointer");
					result = _tmp15_;
					return result;
				} else {
					gboolean _tmp16_ = FALSE;
					if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VALUE_TYPE)) {
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp17_ = vala_data_type_get_nullable (t);
						_tmp18_ = _tmp17_;
						_tmp16_ = _tmp18_;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						gchar* _tmp19_;
						_tmp19_ = g_strdup ("gpointer");
						result = _tmp19_;
						return result;
					} else {
						ValaTypeSymbol* _tmp20_;
						ValaTypeSymbol* _tmp21_;
						_tmp20_ = vala_data_type_get_type_symbol (t);
						_tmp21_ = _tmp20_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_STRUCT)) {
							ValaStruct* st = NULL;
							ValaTypeSymbol* _tmp22_;
							ValaTypeSymbol* _tmp23_;
							ValaStruct* _tmp24_;
							_tmp22_ = vala_data_type_get_type_symbol (t);
							_tmp23_ = _tmp22_;
							st = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_STRUCT, ValaStruct);
							_tmp24_ = st;
							if (vala_struct_is_simple_type (_tmp24_)) {
								ValaTypeSymbol* _tmp25_;
								ValaTypeSymbol* _tmp26_;
								gchar* _tmp27_;
								_tmp25_ = vala_data_type_get_type_symbol (t);
								_tmp26_ = _tmp25_;
								_tmp27_ = vala_get_ccode_name ((ValaCodeNode*) _tmp26_);
								result = _tmp27_;
								return result;
							} else {
								gchar* _tmp28_;
								_tmp28_ = g_strdup ("gpointer");
								result = _tmp28_;
								return result;
							}
						} else {
							ValaTypeSymbol* _tmp29_;
							ValaTypeSymbol* _tmp30_;
							_tmp29_ = vala_data_type_get_type_symbol (t);
							_tmp30_ = _tmp29_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_ENUM)) {
								ValaEnum* en = NULL;
								ValaTypeSymbol* _tmp31_;
								ValaTypeSymbol* _tmp32_;
								ValaEnum* _tmp33_;
								gboolean _tmp34_;
								gboolean _tmp35_;
								_tmp31_ = vala_data_type_get_type_symbol (t);
								_tmp32_ = _tmp31_;
								en = G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_ENUM, ValaEnum);
								_tmp33_ = en;
								_tmp34_ = vala_enum_get_is_flags (_tmp33_);
								_tmp35_ = _tmp34_;
								if (_tmp35_) {
									gchar* _tmp36_;
									_tmp36_ = g_strdup ("guint");
									result = _tmp36_;
									return result;
								} else {
									gchar* _tmp37_;
									_tmp37_ = g_strdup ("gint");
									result = _tmp37_;
									return result;
								}
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ARRAY_TYPE)) {
									gchar* _tmp38_;
									_tmp38_ = g_strdup ("gpointer");
									result = _tmp38_;
									return result;
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_DELEGATE_TYPE)) {
										gchar* _tmp39_;
										_tmp39_ = g_strdup ("gpointer");
										result = _tmp39_;
										return result;
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ERROR_TYPE)) {
											gchar* _tmp40_;
											_tmp40_ = g_strdup ("gpointer");
											result = _tmp40_;
											return result;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                        ValaParameter* p)
{
	ValaParameterDirection _tmp0_;
	ValaParameterDirection _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp4_);
		result = _tmp5_;
		return result;
	}
}

static gchar*
vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                              ValaSignal* sig,
                                              ValaList* params,
                                              ValaDataType* return_type)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean first = FALSE;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_g_free0 (signature);
	signature = _tmp2_;
	_g_free0 (_tmp1_);
	first = TRUE;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp3_;
		gint _p_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp3_ = _vala_iterable_ref0 (params);
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = vala_list_get (_tmp7_, _p_index);
			p = (ValaParameter*) _tmp8_;
			if (first) {
				const gchar* _tmp9_;
				ValaParameter* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp9_ = signature;
				_tmp10_ = p;
				_tmp11_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
				_g_free0 (signature);
				signature = _tmp13_;
				_g_free0 (_tmp12_);
				first = FALSE;
			} else {
				const gchar* _tmp14_;
				ValaParameter* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = signature;
				_tmp15_ = p;
				_tmp16_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup_printf ("%s,%s", _tmp14_, _tmp17_);
				_g_free0 (signature);
				signature = _tmp18_;
				_g_free0 (_tmp17_);
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp19_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp20_ = _tmp19_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp20_)) {
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		if (first) {
			_tmp21_ = "POINTER";
		} else {
			_tmp21_ = ",POINTER";
		}
		_tmp22_ = signature;
		_tmp23_ = g_strconcat (_tmp22_, _tmp21_, NULL);
		_g_free0 (signature);
		signature = _tmp23_;
	} else {
		gint _tmp24_;
		gint _tmp25_;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == 0) {
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp26_ = signature;
			_tmp27_ = g_strconcat (_tmp26_, "VOID", NULL);
			_g_free0 (signature);
			signature = _tmp27_;
		}
	}
	result = signature;
	return result;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                 ValaSignal* sig,
                                                 ValaExpression* detail_expr,
                                                 ValaCodeNode* node)
{
	ValaTargetValue* detail_value = NULL;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	ValaTargetValue* _tmp8_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	ValaTargetValue* _tmp11_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeExpression* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeConstant* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	ValaTargetValue* _tmp26_;
	ValaCCodeExpression* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaTargetValue* _tmp29_;
	ValaCCodeExpression* _tmp30_;
	ValaCCodeExpression* _tmp31_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_;
		_tmp0_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (detail_expr, VALA_TYPE_STRING_LITERAL)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeExpression* _tmp4_;
		_tmp1_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (detail_expr, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, _tmp2_);
		_tmp4_ = (ValaCCodeExpression*) _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = vala_expression_get_value_type (detail_expr);
	_tmp6_ = _tmp5_;
	_tmp7_ = TRUE;
	_tmp8_ = vala_ccode_base_module_create_temp_value ((ValaCCodeBaseModule*) self, _tmp6_, FALSE, node, &_tmp7_);
	detail_value = _tmp8_;
	_tmp9_ = vala_ccode_base_module_get_temp_ref_values ((ValaCCodeBaseModule*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = detail_value;
	vala_list_insert ((ValaList*) _tmp10_, 0, _tmp11_);
	_tmp12_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	ccall = _tmp15_;
	_tmp16_ = ccall;
	_tmp17_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, "");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = ccall;
	_tmp20_ = vala_get_cvalue (detail_expr);
	vala_ccode_function_call_add_argument (_tmp19_, _tmp20_);
	_tmp21_ = ccall;
	_tmp22_ = vala_ccode_constant_new ("NULL");
	_tmp23_ = _tmp22_;
	vala_ccode_function_call_add_argument (_tmp21_, (ValaCCodeExpression*) _tmp23_);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = detail_value;
	_tmp27_ = vala_get_cvalue_ (_tmp26_);
	_tmp28_ = ccall;
	vala_ccode_function_add_assignment (_tmp25_, _tmp27_, (ValaCCodeExpression*) _tmp28_);
	_tmp29_ = detail_value;
	_tmp30_ = vala_get_cvalue_ (_tmp29_);
	_tmp31_ = _vala_ccode_node_ref0 (_tmp30_);
	result = _tmp31_;
	_vala_ccode_node_unref0 (ccall);
	_vala_target_value_unref0 (detail_value);
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                               ValaSignal* sig)
{
	ValaTypeSymbol* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaCCodeIdentifier* signal_array = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* signal_enum_value = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeElementAccess* _tmp17_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	cl = _tmp2_;
	_tmp3_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_signals", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_identifier_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	signal_array = _tmp8_;
	_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_identifier_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	signal_enum_value = _tmp16_;
	_tmp17_ = vala_ccode_element_access_new ((ValaCCodeExpression*) signal_array, (ValaCCodeExpression*) signal_enum_value);
	result = (ValaCCodeExpression*) _tmp17_;
	_vala_ccode_node_unref0 (signal_enum_value);
	_vala_ccode_node_unref0 (signal_array);
	_vala_code_node_unref0 (cl);
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                            ValaExpression* detail_expr,
                                            ValaCodeNode* node)
{
	ValaCCodeExpression* detail_cexpr = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* _tmp1_;
	ValaCCodeFunctionCall* detail_ccall = NULL;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp9_;
	ValaCCodeExpression* _tmp10_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail_expr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_cvalue (detail_expr);
	_tmp1_ = _vala_ccode_node_ref0 (_tmp0_);
	detail_cexpr = _tmp1_;
	_tmp2_ = detail_cexpr;
	if (vala_ccode_base_module_is_constant_ccode_expression (_tmp2_)) {
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeIdentifier* _tmp4_;
		ValaCCodeFunctionCall* _tmp5_;
		_tmp3_ = vala_ccode_identifier_new ("g_quark_from_static_string");
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp4_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp5_;
		_vala_ccode_node_unref0 (_tmp4_);
	} else {
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeFunctionCall* _tmp8_;
		_tmp6_ = vala_ccode_identifier_new ("g_quark_from_string");
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp7_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp8_;
		_vala_ccode_node_unref0 (_tmp7_);
	}
	_tmp9_ = detail_ccall;
	_tmp10_ = detail_cexpr;
	vala_ccode_function_call_add_argument (_tmp9_, _tmp10_);
	result = (ValaCCodeExpression*) detail_ccall;
	_vala_ccode_node_unref0 (detail_cexpr);
	return result;
}

static void
vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                       ValaSignal* sig)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCCodeEnum* _tmp1_;
	ValaList* params = NULL;
	ValaList* _tmp15_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp1_ = ((ValaCCodeBaseModule*) self)->signal_enum;
	if (_tmp1_ != NULL) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp3_ = _tmp2_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		ValaCCodeEnumValue* _tmp14_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->signal_enum;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_get_ccode_upper_case_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_ccode_enum_value_new (_tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_ccode_enum_add_value (_tmp4_, _tmp14_);
		_vala_ccode_node_unref0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp15_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp15_;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _p_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _p_index = 0;
		_tmp16_ = params;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_p_list = _tmp17_;
		_tmp18_ = _p_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_p_size = _tmp20_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValaParameter* _tmp23_;
			ValaCCodeFile* _tmp24_;
			GHashFunc _tmp25_;
			GEqualFunc _tmp26_;
			GEqualFunc _tmp27_;
			ValaHashMap* _tmp28_;
			ValaHashMap* _tmp29_;
			ValaCCodeParameter* _tmp30_;
			ValaCCodeParameter* _tmp31_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp21_ = _p_list;
			_tmp22_ = vala_list_get (_tmp21_, _p_index);
			p = (ValaParameter*) _tmp22_;
			_tmp23_ = p;
			_tmp24_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp25_ = g_direct_hash;
			_tmp26_ = g_direct_equal;
			_tmp27_ = g_direct_equal;
			_tmp28_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp25_, _tmp26_, _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, _tmp23_, _tmp24_, (ValaMap*) _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			_vala_ccode_node_unref0 (_tmp31_);
			_vala_map_unref0 (_tmp29_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp32_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp33_ = _tmp32_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp33_)) {
		ValaList* _tmp34_;
		ValaVoidType* _tmp35_;
		ValaVoidType* _tmp36_;
		_tmp34_ = params;
		_tmp35_ = vala_void_type_new (NULL);
		_tmp36_ = _tmp35_;
		vala_gsignal_module_generate_marshaller (self, sig, _tmp34_, (ValaDataType*) _tmp36_);
		_vala_code_node_unref0 (_tmp36_);
	} else {
		ValaList* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		_tmp37_ = params;
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp39_ = _tmp38_;
		vala_gsignal_module_generate_marshaller (self, sig, _tmp37_, _tmp39_);
	}
}

static void
vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                         ValaSignal* sig,
                                         ValaList* params,
                                         ValaDataType* return_type)
{
	gchar* signature = NULL;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSet* _tmp2_;
	const gchar* _tmp3_;
	ValaCCodeFunction* signal_marshaller = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunctionDeclarator* callback_decl = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaCCodeFunctionDeclarator* _tmp32_;
	ValaCCodeFunctionDeclarator* _tmp33_;
	ValaCCodeFunctionDeclarator* _tmp34_;
	ValaCCodeParameter* _tmp35_;
	ValaCCodeParameter* _tmp36_;
	ValaDataType* _tmp103_;
	ValaDataType* _tmp104_;
	ValaCCodeFunctionDeclarator* _tmp111_;
	ValaCCodeParameter* _tmp112_;
	ValaCCodeParameter* _tmp113_;
	ValaCCodeFunction* _tmp114_;
	ValaCCodeFunction* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	ValaCCodeFunctionDeclarator* _tmp118_;
	ValaCCodeTypeDefinition* _tmp119_;
	ValaCCodeTypeDefinition* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunction* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	ValaCCodeVariableDeclarator* _tmp125_;
	ValaCCodeVariableDeclarator* _tmp126_;
	ValaCCodeFunction* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeIdentifier* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeCastExpression* _tmp131_;
	ValaCCodeCastExpression* _tmp132_;
	ValaCCodeVariableDeclarator* _tmp133_;
	ValaCCodeVariableDeclarator* _tmp134_;
	ValaCCodeFunction* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	ValaCCodeVariableDeclarator* _tmp137_;
	ValaCCodeVariableDeclarator* _tmp138_;
	ValaCCodeFunction* _tmp139_;
	ValaCCodeFunction* _tmp140_;
	ValaCCodeVariableDeclarator* _tmp141_;
	ValaCCodeVariableDeclarator* _tmp142_;
	ValaCCodeFunctionCall* fc = NULL;
	gboolean _tmp143_ = FALSE;
	ValaTypeSymbol* _tmp144_;
	ValaTypeSymbol* _tmp145_;
	ValaCCodeIdentifier* _tmp165_;
	ValaCCodeIdentifier* _tmp166_;
	ValaCCodeFunctionCall* _tmp167_;
	ValaCCodeFunctionCall* _tmp168_;
	ValaCCodeIdentifier* _tmp169_;
	ValaCCodeIdentifier* _tmp170_;
	gchar* _tmp171_;
	gchar* _tmp172_;
	ValaCCodeConstant* _tmp173_;
	ValaCCodeConstant* _tmp174_;
	ValaCCodeBinaryExpression* _tmp175_;
	ValaCCodeBinaryExpression* _tmp176_;
	ValaCCodeFunction* _tmp177_;
	ValaCCodeFunction* _tmp178_;
	ValaCCodeFunctionCall* _tmp179_;
	ValaCCodeMemberAccess* data = NULL;
	ValaCCodeIdentifier* _tmp180_;
	ValaCCodeIdentifier* _tmp181_;
	ValaCCodeMemberAccess* _tmp182_;
	ValaCCodeMemberAccess* _tmp183_;
	ValaCCodeMemberAccess* param = NULL;
	ValaCCodeIdentifier* _tmp184_;
	ValaCCodeIdentifier* _tmp185_;
	ValaCCodeMemberAccess* _tmp186_;
	ValaCCodeMemberAccess* _tmp187_;
	ValaCCodeMemberAccess* _tmp188_;
	ValaCCodeMemberAccess* _tmp189_;
	ValaCCodeFunctionCall* cond = NULL;
	ValaCCodeConstant* _tmp190_;
	ValaCCodeConstant* _tmp191_;
	ValaCCodeFunctionCall* _tmp192_;
	ValaCCodeFunctionCall* _tmp193_;
	ValaCCodeFunctionCall* _tmp194_;
	ValaCCodeIdentifier* _tmp195_;
	ValaCCodeIdentifier* _tmp196_;
	ValaCCodeFunction* _tmp197_;
	ValaCCodeFunction* _tmp198_;
	ValaCCodeFunctionCall* _tmp199_;
	ValaCCodeFunction* _tmp200_;
	ValaCCodeFunction* _tmp201_;
	ValaCCodeIdentifier* _tmp202_;
	ValaCCodeIdentifier* _tmp203_;
	ValaCCodeMemberAccess* _tmp204_;
	ValaCCodeFunction* _tmp205_;
	ValaCCodeFunction* _tmp206_;
	ValaCCodeIdentifier* _tmp207_;
	ValaCCodeIdentifier* _tmp208_;
	ValaCCodeMemberAccess* _tmp209_;
	ValaCCodeFunction* _tmp210_;
	ValaCCodeFunction* _tmp211_;
	ValaCCodeFunction* _tmp212_;
	ValaCCodeFunction* _tmp213_;
	ValaCCodeIdentifier* _tmp214_;
	ValaCCodeIdentifier* _tmp215_;
	ValaCCodeMemberAccess* _tmp216_;
	ValaCCodeFunction* _tmp217_;
	ValaCCodeFunction* _tmp218_;
	ValaCCodeIdentifier* _tmp219_;
	ValaCCodeIdentifier* _tmp220_;
	ValaCCodeMemberAccess* _tmp221_;
	ValaCCodeFunction* _tmp222_;
	ValaCCodeFunction* _tmp223_;
	ValaCCodeCastExpression* c_assign_rhs = NULL;
	ValaCCodeIdentifier* _tmp224_;
	ValaCCodeIdentifier* _tmp225_;
	ValaCCodeIdentifier* _tmp226_;
	ValaCCodeIdentifier* _tmp227_;
	ValaCCodeIdentifier* _tmp228_;
	ValaCCodeIdentifier* _tmp229_;
	ValaCCodeMemberAccess* _tmp230_;
	ValaCCodeMemberAccess* _tmp231_;
	ValaCCodeConditionalExpression* _tmp232_;
	ValaCCodeConditionalExpression* _tmp233_;
	gchar* _tmp234_;
	gchar* _tmp235_;
	ValaCCodeCastExpression* _tmp236_;
	ValaCCodeCastExpression* _tmp237_;
	ValaCCodeFunction* _tmp238_;
	ValaCCodeFunction* _tmp239_;
	ValaCCodeIdentifier* _tmp240_;
	ValaCCodeIdentifier* _tmp241_;
	ValaCCodeCastExpression* _tmp242_;
	ValaCCodeIdentifier* _tmp243_;
	ValaCCodeIdentifier* _tmp244_;
	ValaCCodeFunctionCall* _tmp245_;
	ValaCCodeFunctionCall* _tmp246_;
	ValaCCodeIdentifier* _tmp247_;
	ValaCCodeIdentifier* _tmp248_;
	ValaDataType* _tmp370_;
	ValaDataType* _tmp371_;
	ValaCCodeFunctionCall* _tmp388_;
	ValaCCodeIdentifier* _tmp389_;
	ValaCCodeIdentifier* _tmp390_;
	gboolean _tmp391_ = FALSE;
	ValaTypeSymbol* _tmp392_;
	ValaTypeSymbol* _tmp393_;
	ValaCCodeFile* _tmp422_;
	ValaCCodeFunction* _tmp423_;
	ValaCCodeFile* _tmp424_;
	ValaCCodeFunction* _tmp425_;
	ValaSet* _tmp426_;
	const gchar* _tmp427_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, sig, params, return_type);
	_g_free0 (signature);
	signature = _tmp0_;
	_tmp2_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
	_tmp3_ = signature;
	if (vala_collection_contains ((ValaCollection*) _tmp2_, _tmp3_)) {
		_tmp1_ = TRUE;
	} else {
		ValaSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
		_tmp5_ = signature;
		_tmp1_ = vala_collection_contains ((ValaCollection*) _tmp4_, _tmp5_);
	}
	if (_tmp1_) {
		_g_free0 (signature);
		return;
	}
	_tmp6_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_function_new (_tmp7_, "void");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	signal_marshaller = _tmp9_;
	_tmp10_ = signal_marshaller;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp10_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp11_ = signal_marshaller;
	_tmp12_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (_tmp11_, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_tmp14_ = signal_marshaller;
	_tmp15_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (_tmp14_, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = signal_marshaller;
	_tmp18_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = signal_marshaller;
	_tmp21_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = signal_marshaller;
	_tmp24_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = signal_marshaller;
	_tmp27_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = signal_marshaller;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp30_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_function_declarator_new (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	callback_decl = _tmp33_;
	_tmp34_ = callback_decl;
	_tmp35_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp36_ = _tmp35_;
	vala_ccode_function_declarator_add_parameter (_tmp34_, _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	n_params = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp37_;
		gint _p_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _p_index = 0;
		_tmp37_ = _vala_iterable_ref0 (params);
		_p_list = _tmp37_;
		_tmp38_ = _p_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_p_size = _tmp40_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaCCodeFunctionDeclarator* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaParameter* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			ValaCCodeParameter* _tmp49_;
			ValaCCodeParameter* _tmp50_;
			gint _tmp51_;
			ValaParameter* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp41_ = _p_list;
			_tmp42_ = vala_list_get (_tmp41_, _p_index);
			p = (ValaParameter*) _tmp42_;
			_tmp43_ = callback_decl;
			_tmp44_ = g_strdup_printf ("arg_%d", n_params);
			_tmp45_ = _tmp44_;
			_tmp46_ = p;
			_tmp47_ = vala_gsignal_module_get_value_type_name_from_parameter (self, _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_ccode_parameter_new (_tmp45_, _tmp48_);
			_tmp50_ = _tmp49_;
			vala_ccode_function_declarator_add_parameter (_tmp43_, _tmp50_);
			_vala_ccode_node_unref0 (_tmp50_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp45_);
			_tmp51_ = n_params;
			n_params = _tmp51_ + 1;
			_tmp52_ = p;
			_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) _tmp52_);
			_tmp54_ = _tmp53_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp55_;
				ValaDataType* _tmp56_;
				ValaDataType* _tmp57_;
				ValaArrayType* _tmp58_;
				gchar* length_ctype = NULL;
				ValaParameter* _tmp59_;
				gchar* _tmp60_;
				_tmp55_ = p;
				_tmp56_ = vala_variable_get_variable_type ((ValaVariable*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp58_;
				_tmp59_ = p;
				_tmp60_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp59_);
				length_ctype = _tmp60_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp61_ = FALSE;
						_tmp61_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							ValaCCodeFunctionDeclarator* _tmp66_;
							gchar* _tmp67_;
							gchar* _tmp68_;
							const gchar* _tmp69_;
							ValaCCodeParameter* _tmp70_;
							ValaCCodeParameter* _tmp71_;
							gint _tmp72_;
							if (!_tmp61_) {
								gint _tmp62_;
								_tmp62_ = j;
								j = _tmp62_ + 1;
							}
							_tmp61_ = FALSE;
							_tmp63_ = array_type;
							_tmp64_ = vala_array_type_get_rank (_tmp63_);
							_tmp65_ = _tmp64_;
							if (!(j < _tmp65_)) {
								break;
							}
							_tmp66_ = callback_decl;
							_tmp67_ = g_strdup_printf ("arg_%d", n_params);
							_tmp68_ = _tmp67_;
							_tmp69_ = length_ctype;
							_tmp70_ = vala_ccode_parameter_new (_tmp68_, _tmp69_);
							_tmp71_ = _tmp70_;
							vala_ccode_function_declarator_add_parameter (_tmp66_, _tmp71_);
							_vala_ccode_node_unref0 (_tmp71_);
							_g_free0 (_tmp68_);
							_tmp72_ = n_params;
							n_params = _tmp72_ + 1;
						}
					}
				}
				_g_free0 (length_ctype);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				_tmp73_ = p;
				_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) _tmp73_);
				_tmp75_ = _tmp74_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp76_;
					ValaDataType* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDelegateType* _tmp79_;
					ValaDelegate* _tmp80_;
					ValaDelegate* _tmp81_;
					gboolean _tmp82_;
					gboolean _tmp83_;
					_tmp76_ = p;
					_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) _tmp76_);
					_tmp78_ = _tmp77_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp79_ = delegate_type;
					_tmp80_ = vala_delegate_type_get_delegate_symbol (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = vala_delegate_get_has_target (_tmp81_);
					_tmp83_ = _tmp82_;
					if (_tmp83_) {
						ValaCCodeFunctionDeclarator* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						ValaDataType* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						ValaCCodeParameter* _tmp90_;
						ValaCCodeParameter* _tmp91_;
						gint _tmp92_;
						ValaDelegateType* _tmp93_;
						_tmp84_ = callback_decl;
						_tmp85_ = g_strdup_printf ("arg_%d", n_params);
						_tmp86_ = _tmp85_;
						_tmp87_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
						_tmp88_ = vala_get_ccode_name ((ValaCodeNode*) _tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = vala_ccode_parameter_new (_tmp86_, _tmp89_);
						_tmp91_ = _tmp90_;
						vala_ccode_function_declarator_add_parameter (_tmp84_, _tmp91_);
						_vala_ccode_node_unref0 (_tmp91_);
						_g_free0 (_tmp89_);
						_g_free0 (_tmp86_);
						_tmp92_ = n_params;
						n_params = _tmp92_ + 1;
						_tmp93_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp93_)) {
							ValaCCodeFunctionDeclarator* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							ValaDelegateType* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							ValaCCodeParameter* _tmp100_;
							ValaCCodeParameter* _tmp101_;
							gint _tmp102_;
							_tmp94_ = callback_decl;
							_tmp95_ = g_strdup_printf ("arg_%d", n_params);
							_tmp96_ = _tmp95_;
							_tmp97_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
							_tmp98_ = vala_get_ccode_name ((ValaCodeNode*) _tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = vala_ccode_parameter_new (_tmp96_, _tmp99_);
							_tmp101_ = _tmp100_;
							vala_ccode_function_declarator_add_parameter (_tmp94_, _tmp101_);
							_vala_ccode_node_unref0 (_tmp101_);
							_g_free0 (_tmp99_);
							_g_free0 (_tmp96_);
							_tmp102_ = n_params;
							n_params = _tmp102_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp103_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp104_ = _tmp103_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp104_)) {
		ValaCCodeFunctionDeclarator* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		ValaCCodeParameter* _tmp108_;
		ValaCCodeParameter* _tmp109_;
		gint _tmp110_;
		_tmp105_ = callback_decl;
		_tmp106_ = g_strdup_printf ("arg_%d", n_params);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_ccode_parameter_new (_tmp107_, "gpointer");
		_tmp109_ = _tmp108_;
		vala_ccode_function_declarator_add_parameter (_tmp105_, _tmp109_);
		_vala_ccode_node_unref0 (_tmp109_);
		_g_free0 (_tmp107_);
		_tmp110_ = n_params;
		n_params = _tmp110_ + 1;
	}
	_tmp111_ = callback_decl;
	_tmp112_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp113_ = _tmp112_;
	vala_ccode_function_declarator_add_parameter (_tmp111_, _tmp113_);
	_vala_ccode_node_unref0 (_tmp113_);
	_tmp114_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp117_ = _tmp116_;
	_tmp118_ = callback_decl;
	_tmp119_ = vala_ccode_type_definition_new (_tmp117_, (ValaCCodeDeclarator*) _tmp118_);
	_tmp120_ = _tmp119_;
	vala_ccode_function_add_statement (_tmp115_, (ValaCCodeNode*) _tmp120_);
	_vala_ccode_node_unref0 (_tmp120_);
	_g_free0 (_tmp117_);
	_tmp121_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp122_ = _tmp121_;
	_tmp123_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_declaration (_tmp122_, _tmp124_, (ValaCCodeDeclarator*) _tmp126_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp126_);
	_g_free0 (_tmp124_);
	_tmp127_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_ccode_identifier_new ("closure");
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp130_, "GCClosure *");
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp132_, NULL);
	_tmp134_ = _tmp133_;
	vala_ccode_function_add_declaration (_tmp128_, "GCClosure *", (ValaCCodeDeclarator*) _tmp134_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp134_);
	_vala_ccode_node_unref0 (_tmp132_);
	_vala_ccode_node_unref0 (_tmp130_);
	_tmp135_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp138_ = _tmp137_;
	vala_ccode_function_add_declaration (_tmp136_, "gpointer", (ValaCCodeDeclarator*) _tmp138_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp138_);
	_tmp139_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp142_ = _tmp141_;
	vala_ccode_function_add_declaration (_tmp140_, "gpointer", (ValaCCodeDeclarator*) _tmp142_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp142_);
	_tmp144_ = vala_data_type_get_type_symbol (return_type);
	_tmp145_ = _tmp144_;
	if (_tmp145_ != NULL) {
		_tmp143_ = TRUE;
	} else {
		_tmp143_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp143_) {
		ValaCCodeFunction* _tmp146_;
		ValaCCodeFunction* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeVariableDeclarator* _tmp150_;
		ValaCCodeVariableDeclarator* _tmp151_;
		ValaCCodeIdentifier* _tmp152_;
		ValaCCodeIdentifier* _tmp153_;
		ValaCCodeFunctionCall* _tmp154_;
		ValaCCodeFunctionCall* _tmp155_;
		ValaCCodeIdentifier* _tmp156_;
		ValaCCodeIdentifier* _tmp157_;
		ValaCCodeConstant* _tmp158_;
		ValaCCodeConstant* _tmp159_;
		ValaCCodeBinaryExpression* _tmp160_;
		ValaCCodeBinaryExpression* _tmp161_;
		ValaCCodeFunction* _tmp162_;
		ValaCCodeFunction* _tmp163_;
		ValaCCodeFunctionCall* _tmp164_;
		_tmp146_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp151_ = _tmp150_;
		vala_ccode_function_add_declaration (_tmp147_, _tmp149_, (ValaCCodeDeclarator*) _tmp151_, 0);
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp152_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp153_ = _tmp152_;
		_tmp154_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp153_);
		_vala_ccode_node_unref0 (fc);
		fc = _tmp154_;
		_vala_ccode_node_unref0 (_tmp153_);
		_tmp155_ = fc;
		_tmp156_ = vala_ccode_identifier_new ("return_value");
		_tmp157_ = _tmp156_;
		_tmp158_ = vala_ccode_constant_new ("NULL");
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp157_, (ValaCCodeExpression*) _tmp159_);
		_tmp161_ = _tmp160_;
		vala_ccode_function_call_add_argument (_tmp155_, (ValaCCodeExpression*) _tmp161_);
		_vala_ccode_node_unref0 (_tmp161_);
		_vala_ccode_node_unref0 (_tmp159_);
		_vala_ccode_node_unref0 (_tmp157_);
		_tmp162_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp163_ = _tmp162_;
		_tmp164_ = fc;
		vala_ccode_function_add_expression (_tmp163_, (ValaCCodeExpression*) _tmp164_);
	}
	_tmp165_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp166_ = _tmp165_;
	_tmp167_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp166_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp167_;
	_vala_ccode_node_unref0 (_tmp166_);
	_tmp168_ = fc;
	_tmp169_ = vala_ccode_identifier_new ("n_param_values");
	_tmp170_ = _tmp169_;
	_tmp171_ = g_strdup_printf ("%i", n_params);
	_tmp172_ = _tmp171_;
	_tmp173_ = vala_ccode_constant_new (_tmp172_);
	_tmp174_ = _tmp173_;
	_tmp175_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp170_, (ValaCCodeExpression*) _tmp174_);
	_tmp176_ = _tmp175_;
	vala_ccode_function_call_add_argument (_tmp168_, (ValaCCodeExpression*) _tmp176_);
	_vala_ccode_node_unref0 (_tmp176_);
	_vala_ccode_node_unref0 (_tmp174_);
	_g_free0 (_tmp172_);
	_vala_ccode_node_unref0 (_tmp170_);
	_tmp177_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp178_ = _tmp177_;
	_tmp179_ = fc;
	vala_ccode_function_add_expression (_tmp178_, (ValaCCodeExpression*) _tmp179_);
	_tmp180_ = vala_ccode_identifier_new ("closure");
	_tmp181_ = _tmp180_;
	_tmp182_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp181_, "data", TRUE);
	_tmp183_ = _tmp182_;
	_vala_ccode_node_unref0 (_tmp181_);
	data = _tmp183_;
	_tmp184_ = vala_ccode_identifier_new ("param_values");
	_tmp185_ = _tmp184_;
	_tmp186_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp185_, "data[0]", TRUE);
	_tmp187_ = _tmp186_;
	_tmp188_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp187_, "v_pointer", FALSE);
	_tmp189_ = _tmp188_;
	_vala_ccode_node_unref0 (_tmp187_);
	_vala_ccode_node_unref0 (_tmp185_);
	param = _tmp189_;
	_tmp190_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp191_ = _tmp190_;
	_tmp192_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp191_);
	_tmp193_ = _tmp192_;
	_vala_ccode_node_unref0 (_tmp191_);
	cond = _tmp193_;
	_tmp194_ = cond;
	_tmp195_ = vala_ccode_identifier_new ("closure");
	_tmp196_ = _tmp195_;
	vala_ccode_function_call_add_argument (_tmp194_, (ValaCCodeExpression*) _tmp196_);
	_vala_ccode_node_unref0 (_tmp196_);
	_tmp197_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp198_ = _tmp197_;
	_tmp199_ = cond;
	vala_ccode_function_open_if (_tmp198_, (ValaCCodeExpression*) _tmp199_);
	_tmp200_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp201_ = _tmp200_;
	_tmp202_ = vala_ccode_identifier_new ("data1");
	_tmp203_ = _tmp202_;
	_tmp204_ = data;
	vala_ccode_function_add_assignment (_tmp201_, (ValaCCodeExpression*) _tmp203_, (ValaCCodeExpression*) _tmp204_);
	_vala_ccode_node_unref0 (_tmp203_);
	_tmp205_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp206_ = _tmp205_;
	_tmp207_ = vala_ccode_identifier_new ("data2");
	_tmp208_ = _tmp207_;
	_tmp209_ = param;
	vala_ccode_function_add_assignment (_tmp206_, (ValaCCodeExpression*) _tmp208_, (ValaCCodeExpression*) _tmp209_);
	_vala_ccode_node_unref0 (_tmp208_);
	_tmp210_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp211_ = _tmp210_;
	vala_ccode_function_add_else (_tmp211_);
	_tmp212_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp213_ = _tmp212_;
	_tmp214_ = vala_ccode_identifier_new ("data1");
	_tmp215_ = _tmp214_;
	_tmp216_ = param;
	vala_ccode_function_add_assignment (_tmp213_, (ValaCCodeExpression*) _tmp215_, (ValaCCodeExpression*) _tmp216_);
	_vala_ccode_node_unref0 (_tmp215_);
	_tmp217_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp218_ = _tmp217_;
	_tmp219_ = vala_ccode_identifier_new ("data2");
	_tmp220_ = _tmp219_;
	_tmp221_ = data;
	vala_ccode_function_add_assignment (_tmp218_, (ValaCCodeExpression*) _tmp220_, (ValaCCodeExpression*) _tmp221_);
	_vala_ccode_node_unref0 (_tmp220_);
	_tmp222_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp223_ = _tmp222_;
	vala_ccode_function_close (_tmp223_);
	_tmp224_ = vala_ccode_identifier_new ("marshal_data");
	_tmp225_ = _tmp224_;
	_tmp226_ = vala_ccode_identifier_new ("marshal_data");
	_tmp227_ = _tmp226_;
	_tmp228_ = vala_ccode_identifier_new ("cc");
	_tmp229_ = _tmp228_;
	_tmp230_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp229_, "callback", TRUE);
	_tmp231_ = _tmp230_;
	_tmp232_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp225_, (ValaCCodeExpression*) _tmp227_, (ValaCCodeExpression*) _tmp231_);
	_tmp233_ = _tmp232_;
	_tmp234_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp235_ = _tmp234_;
	_tmp236_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp233_, _tmp235_);
	_tmp237_ = _tmp236_;
	_g_free0 (_tmp235_);
	_vala_ccode_node_unref0 (_tmp233_);
	_vala_ccode_node_unref0 (_tmp231_);
	_vala_ccode_node_unref0 (_tmp229_);
	_vala_ccode_node_unref0 (_tmp227_);
	_vala_ccode_node_unref0 (_tmp225_);
	c_assign_rhs = _tmp237_;
	_tmp238_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp239_ = _tmp238_;
	_tmp240_ = vala_ccode_identifier_new ("callback");
	_tmp241_ = _tmp240_;
	_tmp242_ = c_assign_rhs;
	vala_ccode_function_add_assignment (_tmp239_, (ValaCCodeExpression*) _tmp241_, (ValaCCodeExpression*) _tmp242_);
	_vala_ccode_node_unref0 (_tmp241_);
	_tmp243_ = vala_ccode_identifier_new ("callback");
	_tmp244_ = _tmp243_;
	_tmp245_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp244_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp245_;
	_vala_ccode_node_unref0 (_tmp244_);
	_tmp246_ = fc;
	_tmp247_ = vala_ccode_identifier_new ("data1");
	_tmp248_ = _tmp247_;
	vala_ccode_function_call_add_argument (_tmp246_, (ValaCCodeExpression*) _tmp248_);
	_vala_ccode_node_unref0 (_tmp248_);
	i = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp249_;
		gint _p_size = 0;
		ValaList* _tmp250_;
		gint _tmp251_;
		gint _tmp252_;
		gint _p_index = 0;
		_tmp249_ = _vala_iterable_ref0 (params);
		_p_list = _tmp249_;
		_tmp250_ = _p_list;
		_tmp251_ = vala_collection_get_size ((ValaCollection*) _tmp250_);
		_tmp252_ = _tmp251_;
		_p_size = _tmp252_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp253_;
			gpointer _tmp254_;
			ValaCCodeFunctionCall* inner_fc = NULL;
			ValaParameter* _tmp255_;
			ValaParameterDirection _tmp256_;
			ValaParameterDirection _tmp257_;
			ValaCCodeFunctionCall* _tmp279_;
			ValaCCodeIdentifier* _tmp280_;
			ValaCCodeIdentifier* _tmp281_;
			gchar* _tmp282_;
			gchar* _tmp283_;
			ValaCCodeIdentifier* _tmp284_;
			ValaCCodeIdentifier* _tmp285_;
			ValaCCodeBinaryExpression* _tmp286_;
			ValaCCodeBinaryExpression* _tmp287_;
			ValaCCodeFunctionCall* _tmp288_;
			ValaCCodeFunctionCall* _tmp289_;
			gint _tmp290_;
			ValaParameter* _tmp291_;
			ValaDataType* _tmp292_;
			ValaDataType* _tmp293_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp253_ = _p_list;
			_tmp254_ = vala_list_get (_tmp253_, _p_index);
			p = (ValaParameter*) _tmp254_;
			_tmp255_ = p;
			_tmp256_ = vala_parameter_get_direction (_tmp255_);
			_tmp257_ = _tmp256_;
			if (_tmp257_ != VALA_PARAMETER_DIRECTION_IN) {
				ValaCCodeIdentifier* _tmp258_;
				ValaCCodeIdentifier* _tmp259_;
				ValaCCodeFunctionCall* _tmp260_;
				_tmp258_ = vala_ccode_identifier_new ("g_value_get_pointer");
				_tmp259_ = _tmp258_;
				_tmp260_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp259_);
				_vala_ccode_node_unref0 (inner_fc);
				inner_fc = _tmp260_;
				_vala_ccode_node_unref0 (_tmp259_);
			} else {
				gboolean _tmp261_ = FALSE;
				ValaParameter* _tmp262_;
				ValaDataType* _tmp263_;
				ValaDataType* _tmp264_;
				_tmp262_ = p;
				_tmp263_ = vala_variable_get_variable_type ((ValaVariable*) _tmp262_);
				_tmp264_ = _tmp263_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp264_, VALA_TYPE_VALUE_TYPE)) {
					ValaParameter* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					gboolean _tmp268_;
					gboolean _tmp269_;
					_tmp265_ = p;
					_tmp266_ = vala_variable_get_variable_type ((ValaVariable*) _tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = vala_data_type_get_nullable (_tmp267_);
					_tmp269_ = _tmp268_;
					_tmp261_ = _tmp269_;
				} else {
					_tmp261_ = FALSE;
				}
				if (_tmp261_) {
					ValaCCodeIdentifier* _tmp270_;
					ValaCCodeIdentifier* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					_tmp270_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp271_ = _tmp270_;
					_tmp272_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp271_);
					_vala_ccode_node_unref0 (inner_fc);
					inner_fc = _tmp272_;
					_vala_ccode_node_unref0 (_tmp271_);
				} else {
					ValaParameter* _tmp273_;
					ValaDataType* _tmp274_;
					ValaDataType* _tmp275_;
					ValaCCodeExpression* _tmp276_;
					ValaCCodeExpression* _tmp277_;
					ValaCCodeFunctionCall* _tmp278_;
					_tmp273_ = p;
					_tmp274_ = vala_variable_get_variable_type ((ValaVariable*) _tmp273_);
					_tmp275_ = _tmp274_;
					_tmp276_ = vala_ccode_base_module_get_value_getter_function ((ValaCCodeBaseModule*) self, _tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_ccode_function_call_new (_tmp277_);
					_vala_ccode_node_unref0 (inner_fc);
					inner_fc = _tmp278_;
					_vala_ccode_node_unref0 (_tmp277_);
				}
			}
			_tmp279_ = inner_fc;
			_tmp280_ = vala_ccode_identifier_new ("param_values");
			_tmp281_ = _tmp280_;
			_tmp282_ = g_strdup_printf ("%i", i);
			_tmp283_ = _tmp282_;
			_tmp284_ = vala_ccode_identifier_new (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp281_, (ValaCCodeExpression*) _tmp285_);
			_tmp287_ = _tmp286_;
			vala_ccode_function_call_add_argument (_tmp279_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (_tmp287_);
			_vala_ccode_node_unref0 (_tmp285_);
			_g_free0 (_tmp283_);
			_vala_ccode_node_unref0 (_tmp281_);
			_tmp288_ = fc;
			_tmp289_ = inner_fc;
			vala_ccode_function_call_add_argument (_tmp288_, (ValaCCodeExpression*) _tmp289_);
			_tmp290_ = i;
			i = _tmp290_ + 1;
			_tmp291_ = p;
			_tmp292_ = vala_variable_get_variable_type ((ValaVariable*) _tmp291_);
			_tmp293_ = _tmp292_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp293_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp294_;
				ValaDataType* _tmp295_;
				ValaDataType* _tmp296_;
				ValaArrayType* _tmp297_;
				gchar* length_value_function = NULL;
				ValaArrayType* _tmp298_;
				ValaDataType* _tmp299_;
				ValaDataType* _tmp300_;
				ValaTypeSymbol* _tmp301_;
				ValaTypeSymbol* _tmp302_;
				gchar* _tmp303_;
				gboolean _tmp304_ = FALSE;
				const gchar* _tmp305_;
				_tmp294_ = p;
				_tmp295_ = vala_variable_get_variable_type ((ValaVariable*) _tmp294_);
				_tmp296_ = _tmp295_;
				_tmp297_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp296_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp297_;
				_tmp298_ = array_type;
				_tmp299_ = vala_array_type_get_length_type (_tmp298_);
				_tmp300_ = _tmp299_;
				_tmp301_ = vala_data_type_get_type_symbol (_tmp300_);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp302_);
				length_value_function = _tmp303_;
				_tmp305_ = length_value_function;
				if (_tmp305_ != NULL) {
					const gchar* _tmp306_;
					_tmp306_ = length_value_function;
					_tmp304_ = g_strcmp0 (_tmp306_, "") != 0;
				} else {
					_tmp304_ = FALSE;
				}
				_vala_assert (_tmp304_, "length_value_function != null && length_value_function != \"\"");
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp307_ = FALSE;
						_tmp307_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp309_;
							gint _tmp310_;
							gint _tmp311_;
							const gchar* _tmp312_;
							ValaCCodeIdentifier* _tmp313_;
							ValaCCodeIdentifier* _tmp314_;
							ValaCCodeFunctionCall* _tmp315_;
							ValaCCodeFunctionCall* _tmp316_;
							ValaCCodeIdentifier* _tmp317_;
							ValaCCodeIdentifier* _tmp318_;
							gchar* _tmp319_;
							gchar* _tmp320_;
							ValaCCodeIdentifier* _tmp321_;
							ValaCCodeIdentifier* _tmp322_;
							ValaCCodeBinaryExpression* _tmp323_;
							ValaCCodeBinaryExpression* _tmp324_;
							ValaCCodeFunctionCall* _tmp325_;
							ValaCCodeFunctionCall* _tmp326_;
							gint _tmp327_;
							if (!_tmp307_) {
								gint _tmp308_;
								_tmp308_ = j;
								j = _tmp308_ + 1;
							}
							_tmp307_ = FALSE;
							_tmp309_ = array_type;
							_tmp310_ = vala_array_type_get_rank (_tmp309_);
							_tmp311_ = _tmp310_;
							if (!(j < _tmp311_)) {
								break;
							}
							_tmp312_ = length_value_function;
							_tmp313_ = vala_ccode_identifier_new (_tmp312_);
							_tmp314_ = _tmp313_;
							_tmp315_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp314_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp315_;
							_vala_ccode_node_unref0 (_tmp314_);
							_tmp316_ = inner_fc;
							_tmp317_ = vala_ccode_identifier_new ("param_values");
							_tmp318_ = _tmp317_;
							_tmp319_ = g_strdup_printf ("%i", i);
							_tmp320_ = _tmp319_;
							_tmp321_ = vala_ccode_identifier_new (_tmp320_);
							_tmp322_ = _tmp321_;
							_tmp323_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp318_, (ValaCCodeExpression*) _tmp322_);
							_tmp324_ = _tmp323_;
							vala_ccode_function_call_add_argument (_tmp316_, (ValaCCodeExpression*) _tmp324_);
							_vala_ccode_node_unref0 (_tmp324_);
							_vala_ccode_node_unref0 (_tmp322_);
							_g_free0 (_tmp320_);
							_vala_ccode_node_unref0 (_tmp318_);
							_tmp325_ = fc;
							_tmp326_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp325_, (ValaCCodeExpression*) _tmp326_);
							_tmp327_ = i;
							i = _tmp327_ + 1;
						}
					}
				}
				_g_free0 (length_value_function);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp328_;
				ValaDataType* _tmp329_;
				ValaDataType* _tmp330_;
				_tmp328_ = p;
				_tmp329_ = vala_variable_get_variable_type ((ValaVariable*) _tmp328_);
				_tmp330_ = _tmp329_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp331_;
					ValaDataType* _tmp332_;
					ValaDataType* _tmp333_;
					ValaDelegateType* _tmp334_;
					ValaDelegate* _tmp335_;
					ValaDelegate* _tmp336_;
					gboolean _tmp337_;
					gboolean _tmp338_;
					_tmp331_ = p;
					_tmp332_ = vala_variable_get_variable_type ((ValaVariable*) _tmp331_);
					_tmp333_ = _tmp332_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp333_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp334_ = delegate_type;
					_tmp335_ = vala_delegate_type_get_delegate_symbol (_tmp334_);
					_tmp336_ = _tmp335_;
					_tmp337_ = vala_delegate_get_has_target (_tmp336_);
					_tmp338_ = _tmp337_;
					if (_tmp338_) {
						ValaCCodeIdentifier* _tmp339_;
						ValaCCodeIdentifier* _tmp340_;
						ValaCCodeFunctionCall* _tmp341_;
						ValaCCodeFunctionCall* _tmp342_;
						ValaCCodeIdentifier* _tmp343_;
						ValaCCodeIdentifier* _tmp344_;
						gchar* _tmp345_;
						gchar* _tmp346_;
						ValaCCodeIdentifier* _tmp347_;
						ValaCCodeIdentifier* _tmp348_;
						ValaCCodeBinaryExpression* _tmp349_;
						ValaCCodeBinaryExpression* _tmp350_;
						ValaCCodeFunctionCall* _tmp351_;
						ValaCCodeFunctionCall* _tmp352_;
						gint _tmp353_;
						ValaDelegateType* _tmp354_;
						_tmp339_ = vala_ccode_identifier_new ("g_value_get_pointer");
						_tmp340_ = _tmp339_;
						_tmp341_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp340_);
						_vala_ccode_node_unref0 (inner_fc);
						inner_fc = _tmp341_;
						_vala_ccode_node_unref0 (_tmp340_);
						_tmp342_ = inner_fc;
						_tmp343_ = vala_ccode_identifier_new ("param_values");
						_tmp344_ = _tmp343_;
						_tmp345_ = g_strdup_printf ("%i", i);
						_tmp346_ = _tmp345_;
						_tmp347_ = vala_ccode_identifier_new (_tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp344_, (ValaCCodeExpression*) _tmp348_);
						_tmp350_ = _tmp349_;
						vala_ccode_function_call_add_argument (_tmp342_, (ValaCCodeExpression*) _tmp350_);
						_vala_ccode_node_unref0 (_tmp350_);
						_vala_ccode_node_unref0 (_tmp348_);
						_g_free0 (_tmp346_);
						_vala_ccode_node_unref0 (_tmp344_);
						_tmp351_ = fc;
						_tmp352_ = inner_fc;
						vala_ccode_function_call_add_argument (_tmp351_, (ValaCCodeExpression*) _tmp352_);
						_tmp353_ = i;
						i = _tmp353_ + 1;
						_tmp354_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp354_)) {
							ValaCCodeIdentifier* _tmp355_;
							ValaCCodeIdentifier* _tmp356_;
							ValaCCodeFunctionCall* _tmp357_;
							ValaCCodeFunctionCall* _tmp358_;
							ValaCCodeIdentifier* _tmp359_;
							ValaCCodeIdentifier* _tmp360_;
							gchar* _tmp361_;
							gchar* _tmp362_;
							ValaCCodeIdentifier* _tmp363_;
							ValaCCodeIdentifier* _tmp364_;
							ValaCCodeBinaryExpression* _tmp365_;
							ValaCCodeBinaryExpression* _tmp366_;
							ValaCCodeFunctionCall* _tmp367_;
							ValaCCodeFunctionCall* _tmp368_;
							gint _tmp369_;
							_tmp355_ = vala_ccode_identifier_new ("g_value_get_pointer");
							_tmp356_ = _tmp355_;
							_tmp357_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp356_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp357_;
							_vala_ccode_node_unref0 (_tmp356_);
							_tmp358_ = inner_fc;
							_tmp359_ = vala_ccode_identifier_new ("param_values");
							_tmp360_ = _tmp359_;
							_tmp361_ = g_strdup_printf ("%i", i);
							_tmp362_ = _tmp361_;
							_tmp363_ = vala_ccode_identifier_new (_tmp362_);
							_tmp364_ = _tmp363_;
							_tmp365_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp360_, (ValaCCodeExpression*) _tmp364_);
							_tmp366_ = _tmp365_;
							vala_ccode_function_call_add_argument (_tmp358_, (ValaCCodeExpression*) _tmp366_);
							_vala_ccode_node_unref0 (_tmp366_);
							_vala_ccode_node_unref0 (_tmp364_);
							_g_free0 (_tmp362_);
							_vala_ccode_node_unref0 (_tmp360_);
							_tmp367_ = fc;
							_tmp368_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp367_, (ValaCCodeExpression*) _tmp368_);
							_tmp369_ = i;
							i = _tmp369_ + 1;
						}
					}
				}
			}
			_vala_ccode_node_unref0 (inner_fc);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp370_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp371_ = _tmp370_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp371_)) {
		ValaCCodeFunctionCall* inner_fc = NULL;
		ValaCCodeIdentifier* _tmp372_;
		ValaCCodeIdentifier* _tmp373_;
		ValaCCodeFunctionCall* _tmp374_;
		ValaCCodeFunctionCall* _tmp375_;
		ValaCCodeFunctionCall* _tmp376_;
		ValaCCodeIdentifier* _tmp377_;
		ValaCCodeIdentifier* _tmp378_;
		gchar* _tmp379_;
		gchar* _tmp380_;
		ValaCCodeIdentifier* _tmp381_;
		ValaCCodeIdentifier* _tmp382_;
		ValaCCodeBinaryExpression* _tmp383_;
		ValaCCodeBinaryExpression* _tmp384_;
		ValaCCodeFunctionCall* _tmp385_;
		ValaCCodeFunctionCall* _tmp386_;
		gint _tmp387_;
		_tmp372_ = vala_ccode_identifier_new ("g_value_get_pointer");
		_tmp373_ = _tmp372_;
		_tmp374_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp373_);
		_tmp375_ = _tmp374_;
		_vala_ccode_node_unref0 (_tmp373_);
		inner_fc = _tmp375_;
		_tmp376_ = inner_fc;
		_tmp377_ = vala_ccode_identifier_new ("param_values");
		_tmp378_ = _tmp377_;
		_tmp379_ = g_strdup_printf ("%i", i);
		_tmp380_ = _tmp379_;
		_tmp381_ = vala_ccode_identifier_new (_tmp380_);
		_tmp382_ = _tmp381_;
		_tmp383_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp378_, (ValaCCodeExpression*) _tmp382_);
		_tmp384_ = _tmp383_;
		vala_ccode_function_call_add_argument (_tmp376_, (ValaCCodeExpression*) _tmp384_);
		_vala_ccode_node_unref0 (_tmp384_);
		_vala_ccode_node_unref0 (_tmp382_);
		_g_free0 (_tmp380_);
		_vala_ccode_node_unref0 (_tmp378_);
		_tmp385_ = fc;
		_tmp386_ = inner_fc;
		vala_ccode_function_call_add_argument (_tmp385_, (ValaCCodeExpression*) _tmp386_);
		_tmp387_ = i;
		i = _tmp387_ + 1;
		_vala_ccode_node_unref0 (inner_fc);
	}
	_tmp388_ = fc;
	_tmp389_ = vala_ccode_identifier_new ("data2");
	_tmp390_ = _tmp389_;
	vala_ccode_function_call_add_argument (_tmp388_, (ValaCCodeExpression*) _tmp390_);
	_vala_ccode_node_unref0 (_tmp390_);
	_tmp392_ = vala_data_type_get_type_symbol (return_type);
	_tmp393_ = _tmp392_;
	if (_tmp393_ != NULL) {
		_tmp391_ = TRUE;
	} else {
		_tmp391_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp391_) {
		ValaCCodeFunction* _tmp394_;
		ValaCCodeFunction* _tmp395_;
		ValaCCodeIdentifier* _tmp396_;
		ValaCCodeIdentifier* _tmp397_;
		ValaCCodeFunctionCall* _tmp398_;
		ValaCCodeFunctionCall* set_fc = NULL;
		ValaCCodeFunctionCall* _tmp410_;
		ValaCCodeIdentifier* _tmp411_;
		ValaCCodeIdentifier* _tmp412_;
		ValaCCodeFunctionCall* _tmp413_;
		ValaCCodeIdentifier* _tmp414_;
		ValaCCodeIdentifier* _tmp415_;
		ValaCCodeFunction* _tmp416_;
		ValaCCodeFunction* _tmp417_;
		ValaCCodeFunctionCall* _tmp418_;
		_tmp394_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp395_ = _tmp394_;
		_tmp396_ = vala_ccode_identifier_new ("v_return");
		_tmp397_ = _tmp396_;
		_tmp398_ = fc;
		vala_ccode_function_add_assignment (_tmp395_, (ValaCCodeExpression*) _tmp397_, (ValaCCodeExpression*) _tmp398_);
		_vala_ccode_node_unref0 (_tmp397_);
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_VALUE_TYPE)) {
			gboolean _tmp399_;
			gboolean _tmp400_;
			_tmp399_ = vala_data_type_get_nullable (return_type);
			_tmp400_ = _tmp399_;
			if (_tmp400_) {
				ValaCCodeIdentifier* _tmp401_;
				ValaCCodeIdentifier* _tmp402_;
				ValaCCodeFunctionCall* _tmp403_;
				_tmp401_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp402_ = _tmp401_;
				_tmp403_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp402_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp403_;
				_vala_ccode_node_unref0 (_tmp402_);
			} else {
				ValaCCodeExpression* _tmp404_;
				ValaCCodeExpression* _tmp405_;
				ValaCCodeFunctionCall* _tmp406_;
				_tmp404_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, return_type);
				_tmp405_ = _tmp404_;
				_tmp406_ = vala_ccode_function_call_new (_tmp405_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp406_;
				_vala_ccode_node_unref0 (_tmp405_);
			}
		} else {
			ValaCCodeExpression* _tmp407_;
			ValaCCodeExpression* _tmp408_;
			ValaCCodeFunctionCall* _tmp409_;
			_tmp407_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, return_type);
			_tmp408_ = _tmp407_;
			_tmp409_ = vala_ccode_function_call_new (_tmp408_);
			_vala_ccode_node_unref0 (set_fc);
			set_fc = _tmp409_;
			_vala_ccode_node_unref0 (_tmp408_);
		}
		_tmp410_ = set_fc;
		_tmp411_ = vala_ccode_identifier_new ("return_value");
		_tmp412_ = _tmp411_;
		vala_ccode_function_call_add_argument (_tmp410_, (ValaCCodeExpression*) _tmp412_);
		_vala_ccode_node_unref0 (_tmp412_);
		_tmp413_ = set_fc;
		_tmp414_ = vala_ccode_identifier_new ("v_return");
		_tmp415_ = _tmp414_;
		vala_ccode_function_call_add_argument (_tmp413_, (ValaCCodeExpression*) _tmp415_);
		_vala_ccode_node_unref0 (_tmp415_);
		_tmp416_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp417_ = _tmp416_;
		_tmp418_ = set_fc;
		vala_ccode_function_add_expression (_tmp417_, (ValaCCodeExpression*) _tmp418_);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeFunction* _tmp419_;
		ValaCCodeFunction* _tmp420_;
		ValaCCodeFunctionCall* _tmp421_;
		_tmp419_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp420_ = _tmp419_;
		_tmp421_ = fc;
		vala_ccode_function_add_expression (_tmp420_, (ValaCCodeExpression*) _tmp421_);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp422_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp423_ = signal_marshaller;
	vala_ccode_file_add_function_declaration (_tmp422_, _tmp423_);
	_tmp424_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp425_ = signal_marshaller;
	vala_ccode_file_add_function (_tmp424_, _tmp425_);
	_tmp426_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
	_tmp427_ = signature;
	vala_collection_add ((ValaCollection*) _tmp426_, _tmp427_);
	_vala_ccode_node_unref0 (c_assign_rhs);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static ValaCCodeExpression*
vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                              ValaSignal* sig,
                                              ValaTypeSymbol* type)
{
	ValaGSignalModule * self;
	ValaCCodeFunctionCall* csignew = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	gchar** flags = NULL;
	gchar** _tmp16_;
	gint flags_length1;
	gint _flags_size_;
	gchar* run_type = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	ValaVersionAttribute* _tmp27_;
	ValaVersionAttribute* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	ValaCCodeFunctionCall* _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar* _tmp34_;
	gchar* _tmp35_;
	ValaCCodeConstant* _tmp36_;
	ValaCCodeConstant* _tmp37_;
	ValaMethod* _tmp38_;
	ValaMethod* _tmp39_;
	ValaCCodeFunctionCall* _tmp68_;
	ValaCCodeConstant* _tmp69_;
	ValaCCodeConstant* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeConstant* _tmp72_;
	ValaCCodeConstant* _tmp73_;
	ValaList* params = NULL;
	ValaList* _tmp74_;
	gchar* marshaller = NULL;
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	ValaCCodeIdentifier* marshal_arg = NULL;
	const gchar* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	gboolean _tmp89_ = FALSE;
	ValaDataType* _tmp90_;
	ValaDataType* _tmp91_;
	gint params_len = 0;
	ValaDataType* _tmp163_;
	ValaDataType* _tmp164_;
	ValaCCodeFunctionCall* _tmp166_;
	gchar* _tmp167_;
	gchar* _tmp168_;
	ValaCCodeConstant* _tmp169_;
	ValaCCodeConstant* _tmp170_;
	ValaDataType* _tmp282_;
	ValaDataType* _tmp283_;
	ValaCCodeIdentifier* _tmp287_;
	const gchar* _tmp288_;
	ValaCCodeExpression* _tmp289_;
	ValaCCodeExpression* _tmp290_;
	ValaCCodeFunctionCall* _tmp291_;
	ValaCCodeAssignment* _tmp292_;
	ValaCCodeExpression* _tmp293_;
	ValaCCodeExpression* result = NULL;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_signal_new");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	csignew = _tmp3_;
	_tmp4_ = csignew;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("\"%s\"", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_constant_new (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp11_ = csignew;
	_tmp12_ = vala_get_ccode_type_id ((ValaCodeNode*) type);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_identifier_new (_tmp13_);
	_tmp15_ = _tmp14_;
	vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp16_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp17_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sig, "Signal", "run", NULL);
	run_type = _tmp17_;
	_tmp18_ = run_type;
	if (g_strcmp0 (_tmp18_, "first") == 0) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp19_);
	} else {
		const gchar* _tmp20_;
		_tmp20_ = run_type;
		if (g_strcmp0 (_tmp20_, "cleanup") == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp21_);
		} else {
			gchar* _tmp22_;
			_tmp22_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp22_);
		}
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "detailed", FALSE)) {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp23_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_recurse", FALSE)) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp24_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "action", FALSE)) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp25_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_hooks", FALSE)) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp26_);
	}
	_tmp27_ = vala_symbol_get_version ((ValaSymbol*) sig);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_version_attribute_get_deprecated (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("G_SIGNAL_DEPRECATED");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp31_);
	}
	_tmp32_ = csignew;
	_tmp33_ = flags;
	_tmp33__length1 = flags_length1;
	_tmp34_ = _vala_g_strjoinv (" | ", _tmp33_, (gint) _tmp33__length1);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_ccode_constant_new (_tmp35_);
	_tmp37_ = _tmp36_;
	vala_ccode_function_call_add_argument (_tmp32_, (ValaCCodeExpression*) _tmp37_);
	_vala_ccode_node_unref0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp38_ = vala_signal_get_default_handler (sig);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == NULL) {
		ValaCCodeFunctionCall* _tmp40_;
		ValaCCodeConstant* _tmp41_;
		ValaCCodeConstant* _tmp42_;
		_tmp40_ = csignew;
		_tmp41_ = vala_ccode_constant_new ("0");
		_tmp42_ = _tmp41_;
		vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
		_vala_ccode_node_unref0 (_tmp42_);
	} else {
		ValaCCodeFunctionCall* struct_offset = NULL;
		ValaCCodeIdentifier* _tmp43_;
		ValaCCodeIdentifier* _tmp44_;
		ValaCCodeFunctionCall* _tmp45_;
		ValaCCodeFunctionCall* _tmp46_;
		ValaCCodeFunctionCall* _tmp59_;
		ValaMethod* _tmp60_;
		ValaMethod* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeIdentifier* _tmp65_;
		ValaCCodeFunctionCall* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		_tmp43_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp44_);
		_tmp46_ = _tmp45_;
		_vala_ccode_node_unref0 (_tmp44_);
		struct_offset = _tmp46_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_CLASS)) {
			ValaCCodeFunctionCall* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			ValaCCodeIdentifier* _tmp52_;
			ValaCCodeIdentifier* _tmp53_;
			_tmp47_ = struct_offset;
			_tmp48_ = vala_get_ccode_name ((ValaCodeNode*) type);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strdup_printf ("%sClass", _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_ccode_identifier_new (_tmp51_);
			_tmp53_ = _tmp52_;
			vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp53_);
			_vala_ccode_node_unref0 (_tmp53_);
			_g_free0 (_tmp51_);
			_g_free0 (_tmp49_);
		} else {
			ValaCCodeFunctionCall* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			ValaCCodeIdentifier* _tmp57_;
			ValaCCodeIdentifier* _tmp58_;
			_tmp54_ = struct_offset;
			_tmp55_ = vala_get_ccode_type_name (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_INTERFACE, ValaInterface));
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_ccode_identifier_new (_tmp56_);
			_tmp58_ = _tmp57_;
			vala_ccode_function_call_add_argument (_tmp54_, (ValaCCodeExpression*) _tmp58_);
			_vala_ccode_node_unref0 (_tmp58_);
			_g_free0 (_tmp56_);
		}
		_tmp59_ = struct_offset;
		_tmp60_ = vala_signal_get_default_handler (sig);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_get_ccode_vfunc_name (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_ccode_identifier_new (_tmp63_);
		_tmp65_ = _tmp64_;
		vala_ccode_function_call_add_argument (_tmp59_, (ValaCCodeExpression*) _tmp65_);
		_vala_ccode_node_unref0 (_tmp65_);
		_g_free0 (_tmp63_);
		_tmp66_ = csignew;
		_tmp67_ = struct_offset;
		vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp67_);
		_vala_ccode_node_unref0 (struct_offset);
	}
	_tmp68_ = csignew;
	_tmp69_ = vala_ccode_constant_new ("NULL");
	_tmp70_ = _tmp69_;
	vala_ccode_function_call_add_argument (_tmp68_, (ValaCCodeExpression*) _tmp70_);
	_vala_ccode_node_unref0 (_tmp70_);
	_tmp71_ = csignew;
	_tmp72_ = vala_ccode_constant_new ("NULL");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp74_;
	_tmp75_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp76_ = _tmp75_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp76_)) {
		ValaList* _tmp77_;
		ValaVoidType* _tmp78_;
		ValaVoidType* _tmp79_;
		gchar* _tmp80_;
		_tmp77_ = params;
		_tmp78_ = vala_void_type_new (NULL);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_gsignal_module_get_marshaller_function (self, sig, _tmp77_, (ValaDataType*) _tmp79_, NULL);
		_g_free0 (marshaller);
		marshaller = _tmp80_;
		_vala_code_node_unref0 (_tmp79_);
	} else {
		ValaList* _tmp81_;
		ValaDataType* _tmp82_;
		ValaDataType* _tmp83_;
		gchar* _tmp84_;
		_tmp81_ = params;
		_tmp82_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_gsignal_module_get_marshaller_function (self, sig, _tmp81_, _tmp83_, NULL);
		_g_free0 (marshaller);
		marshaller = _tmp84_;
	}
	_tmp85_ = marshaller;
	_tmp86_ = vala_ccode_identifier_new (_tmp85_);
	marshal_arg = _tmp86_;
	_tmp87_ = csignew;
	_tmp88_ = marshal_arg;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp88_);
	_tmp90_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp91_ = _tmp90_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp91_, VALA_TYPE_POINTER_TYPE)) {
		_tmp89_ = TRUE;
	} else {
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		_tmp92_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp93_ = _tmp92_;
		_tmp89_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp89_) {
		ValaCCodeFunctionCall* _tmp94_;
		ValaCCodeConstant* _tmp95_;
		ValaCCodeConstant* _tmp96_;
		_tmp94_ = csignew;
		_tmp95_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp96_ = _tmp95_;
		vala_ccode_function_call_add_argument (_tmp94_, (ValaCCodeExpression*) _tmp96_);
		_vala_ccode_node_unref0 (_tmp96_);
	} else {
		ValaDataType* _tmp97_;
		ValaDataType* _tmp98_;
		_tmp97_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp98_ = _tmp97_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_ERROR_TYPE)) {
			ValaCCodeFunctionCall* _tmp99_;
			ValaCCodeConstant* _tmp100_;
			ValaCCodeConstant* _tmp101_;
			_tmp99_ = csignew;
			_tmp100_ = vala_ccode_constant_new ("G_TYPE_POINTER");
			_tmp101_ = _tmp100_;
			vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
			_vala_ccode_node_unref0 (_tmp101_);
		} else {
			gboolean _tmp102_ = FALSE;
			ValaDataType* _tmp103_;
			ValaDataType* _tmp104_;
			_tmp103_ = vala_callable_get_return_type ((ValaCallable*) sig);
			_tmp104_ = _tmp103_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, VALA_TYPE_VALUE_TYPE)) {
				ValaDataType* _tmp105_;
				ValaDataType* _tmp106_;
				gboolean _tmp107_;
				gboolean _tmp108_;
				_tmp105_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_data_type_get_nullable (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp102_ = _tmp108_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaCCodeFunctionCall* _tmp109_;
				ValaCCodeConstant* _tmp110_;
				ValaCCodeConstant* _tmp111_;
				_tmp109_ = csignew;
				_tmp110_ = vala_ccode_constant_new ("G_TYPE_POINTER");
				_tmp111_ = _tmp110_;
				vala_ccode_function_call_add_argument (_tmp109_, (ValaCCodeExpression*) _tmp111_);
				_vala_ccode_node_unref0 (_tmp111_);
			} else {
				ValaDataType* _tmp112_;
				ValaDataType* _tmp113_;
				ValaTypeSymbol* _tmp114_;
				ValaTypeSymbol* _tmp115_;
				_tmp112_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp113_ = _tmp112_;
				_tmp114_ = vala_data_type_get_type_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				if (_tmp115_ == NULL) {
					ValaCCodeFunctionCall* _tmp116_;
					ValaCCodeConstant* _tmp117_;
					ValaCCodeConstant* _tmp118_;
					_tmp116_ = csignew;
					_tmp117_ = vala_ccode_constant_new ("G_TYPE_NONE");
					_tmp118_ = _tmp117_;
					vala_ccode_function_call_add_argument (_tmp116_, (ValaCCodeExpression*) _tmp118_);
					_vala_ccode_node_unref0 (_tmp118_);
				} else {
					ValaDataType* _tmp119_;
					ValaDataType* _tmp120_;
					_tmp119_ = vala_callable_get_return_type ((ValaCallable*) sig);
					_tmp120_ = _tmp119_;
					if (vala_data_type_is_real_non_null_struct_type (_tmp120_)) {
						ValaCCodeFunctionCall* _tmp121_;
						ValaCCodeConstant* _tmp122_;
						ValaCCodeConstant* _tmp123_;
						_tmp121_ = csignew;
						_tmp122_ = vala_ccode_constant_new ("G_TYPE_NONE");
						_tmp123_ = _tmp122_;
						vala_ccode_function_call_add_argument (_tmp121_, (ValaCCodeExpression*) _tmp123_);
						_vala_ccode_node_unref0 (_tmp123_);
					} else {
						ValaCCodeFunctionCall* _tmp124_;
						ValaDataType* _tmp125_;
						ValaDataType* _tmp126_;
						ValaTypeSymbol* _tmp127_;
						ValaTypeSymbol* _tmp128_;
						gchar* _tmp129_;
						gchar* _tmp130_;
						ValaCCodeConstant* _tmp131_;
						ValaCCodeConstant* _tmp132_;
						_tmp124_ = csignew;
						_tmp125_ = vala_callable_get_return_type ((ValaCallable*) sig);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_data_type_get_type_symbol (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = vala_ccode_constant_new (_tmp130_);
						_tmp132_ = _tmp131_;
						vala_ccode_function_call_add_argument (_tmp124_, (ValaCCodeExpression*) _tmp132_);
						_vala_ccode_node_unref0 (_tmp132_);
						_g_free0 (_tmp130_);
					}
				}
			}
		}
	}
	params_len = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp133_;
		ValaList* _tmp134_;
		gint _param_size = 0;
		ValaList* _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		gint _param_index = 0;
		_tmp133_ = params;
		_tmp134_ = _vala_iterable_ref0 (_tmp133_);
		_param_list = _tmp134_;
		_tmp135_ = _param_list;
		_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
		_tmp137_ = _tmp136_;
		_param_size = _tmp137_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp138_;
			gpointer _tmp139_;
			gint _tmp140_;
			ValaParameter* _tmp141_;
			ValaDataType* _tmp142_;
			ValaDataType* _tmp143_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp138_ = _param_list;
			_tmp139_ = vala_list_get (_tmp138_, _param_index);
			param = (ValaParameter*) _tmp139_;
			_tmp140_ = params_len;
			params_len = _tmp140_ + 1;
			_tmp141_ = param;
			_tmp142_ = vala_variable_get_variable_type ((ValaVariable*) _tmp141_);
			_tmp143_ = _tmp142_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp143_, VALA_TYPE_ARRAY_TYPE)) {
				ValaParameter* _tmp144_;
				ValaDataType* _tmp145_;
				ValaDataType* _tmp146_;
				gint _tmp147_;
				gint _tmp148_;
				_tmp144_ = param;
				_tmp145_ = vala_variable_get_variable_type ((ValaVariable*) _tmp144_);
				_tmp146_ = _tmp145_;
				_tmp147_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp148_ = _tmp147_;
				params_len += _tmp148_;
			} else {
				ValaParameter* _tmp149_;
				ValaDataType* _tmp150_;
				ValaDataType* _tmp151_;
				_tmp149_ = param;
				_tmp150_ = vala_variable_get_variable_type ((ValaVariable*) _tmp149_);
				_tmp151_ = _tmp150_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp151_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp152_;
					ValaDataType* _tmp153_;
					ValaDataType* _tmp154_;
					ValaDelegateType* _tmp155_;
					ValaDelegate* _tmp156_;
					ValaDelegate* _tmp157_;
					gboolean _tmp158_;
					gboolean _tmp159_;
					_tmp152_ = param;
					_tmp153_ = vala_variable_get_variable_type ((ValaVariable*) _tmp152_);
					_tmp154_ = _tmp153_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp154_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp155_ = delegate_type;
					_tmp156_ = vala_delegate_type_get_delegate_symbol (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_delegate_get_has_target (_tmp157_);
					_tmp159_ = _tmp158_;
					if (_tmp159_) {
						gint _tmp160_;
						ValaDelegateType* _tmp161_;
						_tmp160_ = params_len;
						params_len = _tmp160_ + 1;
						_tmp161_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp161_)) {
							gint _tmp162_;
							_tmp162_ = params_len;
							params_len = _tmp162_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp163_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp164_ = _tmp163_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp164_)) {
		gint _tmp165_;
		_tmp165_ = params_len;
		params_len = _tmp165_ + 1;
	}
	_tmp166_ = csignew;
	_tmp167_ = g_strdup_printf ("%d", params_len);
	_tmp168_ = _tmp167_;
	_tmp169_ = vala_ccode_constant_new (_tmp168_);
	_tmp170_ = _tmp169_;
	vala_ccode_function_call_add_argument (_tmp166_, (ValaCCodeExpression*) _tmp170_);
	_vala_ccode_node_unref0 (_tmp170_);
	_g_free0 (_tmp168_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp171_;
		ValaList* _tmp172_;
		gint _param_size = 0;
		ValaList* _tmp173_;
		gint _tmp174_;
		gint _tmp175_;
		gint _param_index = 0;
		_tmp171_ = params;
		_tmp172_ = _vala_iterable_ref0 (_tmp171_);
		_param_list = _tmp172_;
		_tmp173_ = _param_list;
		_tmp174_ = vala_collection_get_size ((ValaCollection*) _tmp173_);
		_tmp175_ = _tmp174_;
		_param_size = _tmp175_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp176_;
			gpointer _tmp177_;
			ValaParameter* _tmp178_;
			ValaDataType* _tmp179_;
			ValaDataType* _tmp180_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp176_ = _param_list;
			_tmp177_ = vala_list_get (_tmp176_, _param_index);
			param = (ValaParameter*) _tmp177_;
			_tmp178_ = param;
			_tmp179_ = vala_variable_get_variable_type ((ValaVariable*) _tmp178_);
			_tmp180_ = _tmp179_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp180_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp181_;
				ValaDataType* _tmp182_;
				ValaDataType* _tmp183_;
				ValaArrayType* _tmp184_;
				ValaArrayType* _tmp185_;
				ValaDataType* _tmp186_;
				ValaDataType* _tmp187_;
				ValaTypeSymbol* _tmp188_;
				ValaTypeSymbol* _tmp189_;
				ValaDataType* _tmp190_;
				ValaTypeSymbol* _tmp191_;
				ValaTypeSymbol* _tmp192_;
				ValaArrayType* _tmp199_;
				ValaDataType* _tmp200_;
				ValaDataType* _tmp201_;
				ValaTypeSymbol* _tmp202_;
				ValaTypeSymbol* _tmp203_;
				gchar* length_type_id = NULL;
				ValaArrayType* _tmp204_;
				ValaDataType* _tmp205_;
				ValaDataType* _tmp206_;
				ValaTypeSymbol* _tmp207_;
				ValaTypeSymbol* _tmp208_;
				gchar* _tmp209_;
				_tmp181_ = param;
				_tmp182_ = vala_variable_get_variable_type ((ValaVariable*) _tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp183_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp184_;
				_tmp185_ = array_type;
				_tmp186_ = vala_array_type_get_element_type (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_data_type_get_type_symbol (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp191_ = vala_data_type_get_type_symbol (_tmp190_);
				_tmp192_ = _tmp191_;
				if (_tmp189_ == _tmp192_) {
					ValaCCodeFunctionCall* _tmp193_;
					ValaCCodeConstant* _tmp194_;
					ValaCCodeConstant* _tmp195_;
					_tmp193_ = csignew;
					_tmp194_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp195_ = _tmp194_;
					vala_ccode_function_call_add_argument (_tmp193_, (ValaCCodeExpression*) _tmp195_);
					_vala_ccode_node_unref0 (_tmp195_);
				} else {
					ValaCCodeFunctionCall* _tmp196_;
					ValaCCodeConstant* _tmp197_;
					ValaCCodeConstant* _tmp198_;
					_tmp196_ = csignew;
					_tmp197_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp198_ = _tmp197_;
					vala_ccode_function_call_add_argument (_tmp196_, (ValaCCodeExpression*) _tmp198_);
					_vala_ccode_node_unref0 (_tmp198_);
				}
				_tmp199_ = array_type;
				_tmp200_ = vala_array_type_get_length_type (_tmp199_);
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_data_type_get_type_symbol (_tmp201_);
				_tmp203_ = _tmp202_;
				_vala_assert (vala_get_ccode_has_type_id (_tmp203_), "get_ccode_has_type_id (array_type.length_type.type_symbol)");
				_tmp204_ = array_type;
				_tmp205_ = vala_array_type_get_length_type (_tmp204_);
				_tmp206_ = _tmp205_;
				_tmp207_ = vala_data_type_get_type_symbol (_tmp206_);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp208_);
				length_type_id = _tmp209_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp210_ = FALSE;
						_tmp210_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp212_;
							gint _tmp213_;
							gint _tmp214_;
							ValaCCodeFunctionCall* _tmp215_;
							const gchar* _tmp216_;
							ValaCCodeConstant* _tmp217_;
							ValaCCodeConstant* _tmp218_;
							if (!_tmp210_) {
								gint _tmp211_;
								_tmp211_ = i;
								i = _tmp211_ + 1;
							}
							_tmp210_ = FALSE;
							_tmp212_ = array_type;
							_tmp213_ = vala_array_type_get_rank (_tmp212_);
							_tmp214_ = _tmp213_;
							if (!(i < _tmp214_)) {
								break;
							}
							_tmp215_ = csignew;
							_tmp216_ = length_type_id;
							_tmp217_ = vala_ccode_constant_new (_tmp216_);
							_tmp218_ = _tmp217_;
							vala_ccode_function_call_add_argument (_tmp215_, (ValaCCodeExpression*) _tmp218_);
							_vala_ccode_node_unref0 (_tmp218_);
						}
					}
				}
				_g_free0 (length_type_id);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp219_;
				ValaDataType* _tmp220_;
				ValaDataType* _tmp221_;
				_tmp219_ = param;
				_tmp220_ = vala_variable_get_variable_type ((ValaVariable*) _tmp219_);
				_tmp221_ = _tmp220_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp221_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					ValaCCodeFunctionCall* _tmp225_;
					ValaCCodeConstant* _tmp226_;
					ValaCCodeConstant* _tmp227_;
					ValaDelegateType* _tmp228_;
					ValaDelegate* _tmp229_;
					ValaDelegate* _tmp230_;
					gboolean _tmp231_;
					gboolean _tmp232_;
					_tmp222_ = param;
					_tmp223_ = vala_variable_get_variable_type ((ValaVariable*) _tmp222_);
					_tmp224_ = _tmp223_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp224_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp225_ = csignew;
					_tmp226_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp227_ = _tmp226_;
					vala_ccode_function_call_add_argument (_tmp225_, (ValaCCodeExpression*) _tmp227_);
					_vala_ccode_node_unref0 (_tmp227_);
					_tmp228_ = delegate_type;
					_tmp229_ = vala_delegate_type_get_delegate_symbol (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_delegate_get_has_target (_tmp230_);
					_tmp232_ = _tmp231_;
					if (_tmp232_) {
						ValaCCodeFunctionCall* _tmp233_;
						ValaCCodeConstant* _tmp234_;
						ValaCCodeConstant* _tmp235_;
						ValaDelegateType* _tmp236_;
						_tmp233_ = csignew;
						_tmp234_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp235_ = _tmp234_;
						vala_ccode_function_call_add_argument (_tmp233_, (ValaCCodeExpression*) _tmp235_);
						_vala_ccode_node_unref0 (_tmp235_);
						_tmp236_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp236_)) {
							ValaCCodeFunctionCall* _tmp237_;
							ValaCCodeConstant* _tmp238_;
							ValaCCodeConstant* _tmp239_;
							_tmp237_ = csignew;
							_tmp238_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp239_ = _tmp238_;
							vala_ccode_function_call_add_argument (_tmp237_, (ValaCCodeExpression*) _tmp239_);
							_vala_ccode_node_unref0 (_tmp239_);
						}
					}
				} else {
					gboolean _tmp240_ = FALSE;
					gboolean _tmp241_ = FALSE;
					ValaParameter* _tmp242_;
					ValaDataType* _tmp243_;
					ValaDataType* _tmp244_;
					_tmp242_ = param;
					_tmp243_ = vala_variable_get_variable_type ((ValaVariable*) _tmp242_);
					_tmp244_ = _tmp243_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp244_, VALA_TYPE_POINTER_TYPE)) {
						_tmp241_ = TRUE;
					} else {
						ValaParameter* _tmp245_;
						ValaDataType* _tmp246_;
						ValaDataType* _tmp247_;
						_tmp245_ = param;
						_tmp246_ = vala_variable_get_variable_type ((ValaVariable*) _tmp245_);
						_tmp247_ = _tmp246_;
						_tmp241_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, VALA_TYPE_GENERIC_TYPE);
					}
					if (_tmp241_) {
						_tmp240_ = TRUE;
					} else {
						ValaParameter* _tmp248_;
						ValaParameterDirection _tmp249_;
						ValaParameterDirection _tmp250_;
						_tmp248_ = param;
						_tmp249_ = vala_parameter_get_direction (_tmp248_);
						_tmp250_ = _tmp249_;
						_tmp240_ = _tmp250_ != VALA_PARAMETER_DIRECTION_IN;
					}
					if (_tmp240_) {
						ValaCCodeFunctionCall* _tmp251_;
						ValaCCodeConstant* _tmp252_;
						ValaCCodeConstant* _tmp253_;
						_tmp251_ = csignew;
						_tmp252_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp253_ = _tmp252_;
						vala_ccode_function_call_add_argument (_tmp251_, (ValaCCodeExpression*) _tmp253_);
						_vala_ccode_node_unref0 (_tmp253_);
					} else {
						ValaParameter* _tmp254_;
						ValaDataType* _tmp255_;
						ValaDataType* _tmp256_;
						_tmp254_ = param;
						_tmp255_ = vala_variable_get_variable_type ((ValaVariable*) _tmp254_);
						_tmp256_ = _tmp255_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp256_, VALA_TYPE_ERROR_TYPE)) {
							ValaCCodeFunctionCall* _tmp257_;
							ValaCCodeConstant* _tmp258_;
							ValaCCodeConstant* _tmp259_;
							_tmp257_ = csignew;
							_tmp258_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp259_ = _tmp258_;
							vala_ccode_function_call_add_argument (_tmp257_, (ValaCCodeExpression*) _tmp259_);
							_vala_ccode_node_unref0 (_tmp259_);
						} else {
							gboolean _tmp260_ = FALSE;
							ValaParameter* _tmp261_;
							ValaDataType* _tmp262_;
							ValaDataType* _tmp263_;
							_tmp261_ = param;
							_tmp262_ = vala_variable_get_variable_type ((ValaVariable*) _tmp261_);
							_tmp263_ = _tmp262_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp263_, VALA_TYPE_VALUE_TYPE)) {
								ValaParameter* _tmp264_;
								ValaDataType* _tmp265_;
								ValaDataType* _tmp266_;
								gboolean _tmp267_;
								gboolean _tmp268_;
								_tmp264_ = param;
								_tmp265_ = vala_variable_get_variable_type ((ValaVariable*) _tmp264_);
								_tmp266_ = _tmp265_;
								_tmp267_ = vala_data_type_get_nullable (_tmp266_);
								_tmp268_ = _tmp267_;
								_tmp260_ = _tmp268_;
							} else {
								_tmp260_ = FALSE;
							}
							if (_tmp260_) {
								ValaCCodeFunctionCall* _tmp269_;
								ValaCCodeConstant* _tmp270_;
								ValaCCodeConstant* _tmp271_;
								_tmp269_ = csignew;
								_tmp270_ = vala_ccode_constant_new ("G_TYPE_POINTER");
								_tmp271_ = _tmp270_;
								vala_ccode_function_call_add_argument (_tmp269_, (ValaCCodeExpression*) _tmp271_);
								_vala_ccode_node_unref0 (_tmp271_);
							} else {
								ValaCCodeFunctionCall* _tmp272_;
								ValaParameter* _tmp273_;
								ValaDataType* _tmp274_;
								ValaDataType* _tmp275_;
								ValaTypeSymbol* _tmp276_;
								ValaTypeSymbol* _tmp277_;
								gchar* _tmp278_;
								gchar* _tmp279_;
								ValaCCodeConstant* _tmp280_;
								ValaCCodeConstant* _tmp281_;
								_tmp272_ = csignew;
								_tmp273_ = param;
								_tmp274_ = vala_variable_get_variable_type ((ValaVariable*) _tmp273_);
								_tmp275_ = _tmp274_;
								_tmp276_ = vala_data_type_get_type_symbol (_tmp275_);
								_tmp277_ = _tmp276_;
								_tmp278_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp277_);
								_tmp279_ = _tmp278_;
								_tmp280_ = vala_ccode_constant_new (_tmp279_);
								_tmp281_ = _tmp280_;
								vala_ccode_function_call_add_argument (_tmp272_, (ValaCCodeExpression*) _tmp281_);
								_vala_ccode_node_unref0 (_tmp281_);
								_g_free0 (_tmp279_);
							}
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp282_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp283_ = _tmp282_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp283_)) {
		ValaCCodeFunctionCall* _tmp284_;
		ValaCCodeConstant* _tmp285_;
		ValaCCodeConstant* _tmp286_;
		_tmp284_ = csignew;
		_tmp285_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp286_ = _tmp285_;
		vala_ccode_function_call_add_argument (_tmp284_, (ValaCCodeExpression*) _tmp286_);
		_vala_ccode_node_unref0 (_tmp286_);
	}
	_tmp287_ = marshal_arg;
	_tmp288_ = marshaller;
	vala_ccode_identifier_set_name (_tmp287_, _tmp288_);
	_tmp289_ = vala_gsignal_module_get_signal_id_cexpression (self, sig);
	_tmp290_ = _tmp289_;
	_tmp291_ = csignew;
	_tmp292_ = vala_ccode_assignment_new (_tmp290_, (ValaCCodeExpression*) _tmp291_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp293_ = (ValaCCodeExpression*) _tmp292_;
	_vala_ccode_node_unref0 (_tmp290_);
	result = _tmp293_;
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	_g_free0 (run_type);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_vala_ccode_node_unref0 (csignew);
	return result;
}

static void
vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                               ValaElementAccess* expr)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = vala_element_access_get_container (expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp3_ = vala_element_access_get_container (expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_expression_get_symbol_reference (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_SIGNAL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		_tmp7_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD_CALL)) {
			ValaSignal* sig = NULL;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSignal* _tmp11_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaMemberAccess* _tmp14_;
			ValaExpression* detail_expr = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaCCodeFunctionCall* ccall = NULL;
			gboolean _tmp17_ = FALSE;
			ValaSignal* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			ValaCCodeFunctionCall* _tmp59_;
			_tmp9_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SIGNAL, ValaSignal));
			sig = _tmp11_;
			_tmp12_ = vala_element_access_get_container (expr);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp14_;
			_tmp15_ = vala_element_access_get_indices (expr);
			_tmp16_ = vala_list_get (_tmp15_, 0);
			detail_expr = (ValaExpression*) _tmp16_;
			_tmp18_ = sig;
			_tmp19_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			if (!_tmp20_) {
				ValaSourceReference* _tmp21_;
				ValaSourceReference* _tmp22_;
				ValaSourceFile* _tmp23_;
				ValaSourceFile* _tmp24_;
				ValaSignal* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaSourceReference* _tmp27_;
				ValaSourceFile* _tmp28_;
				ValaSourceFile* _tmp29_;
				_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_source_reference_get_file (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = sig;
				_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_source_reference_get_file (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp17_ = _tmp24_ == _tmp29_;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				ValaCCodeExpression* detail_cexpr = NULL;
				ValaExpression* _tmp30_;
				ValaCCodeExpression* _tmp31_;
				ValaCCodeIdentifier* _tmp32_;
				ValaCCodeIdentifier* _tmp33_;
				ValaCCodeFunctionCall* _tmp34_;
				ValaCCodeFunctionCall* _tmp35_;
				ValaMemberAccess* _tmp36_;
				ValaExpression* _tmp37_;
				ValaExpression* _tmp38_;
				ValaCCodeExpression* _tmp39_;
				ValaCCodeFunctionCall* _tmp40_;
				ValaSignal* _tmp41_;
				ValaCCodeExpression* _tmp42_;
				ValaCCodeExpression* _tmp43_;
				ValaCCodeFunctionCall* _tmp44_;
				ValaCCodeExpression* _tmp45_;
				_tmp30_ = detail_expr;
				_tmp31_ = vala_gsignal_module_get_detail_cexpression (self, _tmp30_, (ValaCodeNode*) expr);
				detail_cexpr = _tmp31_;
				_tmp32_ = vala_ccode_identifier_new ("g_signal_emit");
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp33_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp34_;
				_vala_ccode_node_unref0 (_tmp33_);
				_tmp35_ = ccall;
				_tmp36_ = ma;
				_tmp37_ = vala_member_access_get_inner (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_get_cvalue (_tmp38_);
				vala_ccode_function_call_add_argument (_tmp35_, _tmp39_);
				_tmp40_ = ccall;
				_tmp41_ = sig;
				_tmp42_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp41_);
				_tmp43_ = _tmp42_;
				vala_ccode_function_call_add_argument (_tmp40_, _tmp43_);
				_vala_ccode_node_unref0 (_tmp43_);
				_tmp44_ = ccall;
				_tmp45_ = detail_cexpr;
				vala_ccode_function_call_add_argument (_tmp44_, _tmp45_);
				_vala_ccode_node_unref0 (detail_cexpr);
			} else {
				ValaCCodeExpression* signal_name_cexpr = NULL;
				ValaSignal* _tmp46_;
				ValaExpression* _tmp47_;
				ValaCCodeExpression* _tmp48_;
				ValaCCodeIdentifier* _tmp49_;
				ValaCCodeIdentifier* _tmp50_;
				ValaCCodeFunctionCall* _tmp51_;
				ValaCCodeFunctionCall* _tmp52_;
				ValaMemberAccess* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				ValaCCodeExpression* _tmp56_;
				ValaCCodeFunctionCall* _tmp57_;
				ValaCCodeExpression* _tmp58_;
				_tmp46_ = sig;
				_tmp47_ = detail_expr;
				_tmp48_ = vala_gsignal_module_get_signal_name_cexpression (self, _tmp46_, _tmp47_, (ValaCodeNode*) expr);
				signal_name_cexpr = _tmp48_;
				_tmp49_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp50_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp51_;
				_vala_ccode_node_unref0 (_tmp50_);
				_tmp52_ = ccall;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_inner (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = vala_get_cvalue (_tmp55_);
				vala_ccode_function_call_add_argument (_tmp52_, _tmp56_);
				_tmp57_ = ccall;
				_tmp58_ = signal_name_cexpr;
				vala_ccode_function_call_add_argument (_tmp57_, _tmp58_);
				_vala_ccode_node_unref0 (signal_name_cexpr);
			}
			_tmp59_ = ccall;
			vala_set_cvalue ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp59_);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (sig);
		} else {
		}
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}

static gboolean
vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                         ValaMethod* m)
{
	gboolean _result_ = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		_tmp2_ = vala_method_get_this_parameter (m);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_type_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_result_ = vala_typesymbol_is_subtype_of (_tmp7_, _tmp8_);
	}
	result = _result_;
	return result;
}

static void
vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                              ValaMemberAccess* expr)
{
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_SIGNAL)) {
		ValaCCodeExpression* pub_inst = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSignal* _tmp10_;
		ValaTypeSymbol* cl = NULL;
		ValaSignal* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaTypeSymbol* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		gboolean _tmp51_ = FALSE;
		ValaSignal* _tmp52_;
		gboolean _tmp53_;
		gboolean _tmp54_;
		pub_inst = NULL;
		_tmp2_ = vala_member_access_get_inner (expr);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			ValaCCodeExpression* _tmp6_;
			ValaCCodeExpression* _tmp7_;
			_tmp4_ = vala_member_access_get_inner (expr);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_get_cvalue (_tmp5_);
			_tmp7_ = _vala_ccode_node_ref0 (_tmp6_);
			_vala_ccode_node_unref0 (pub_inst);
			pub_inst = _tmp7_;
		}
		_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp10_;
		_tmp11_ = sig;
		_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		cl = _tmp14_;
		_tmp16_ = vala_member_access_get_inner (expr);
		_tmp17_ = _tmp16_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_BASE_ACCESS)) {
			ValaSignal* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp18_ = sig;
			_tmp19_ = vala_signal_get_is_virtual (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp15_ = _tmp20_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaMethod* m = NULL;
			ValaSignal* _tmp21_;
			ValaMethod* _tmp22_;
			ValaMethod* _tmp23_;
			ValaMethod* _tmp24_;
			ValaClass* base_class = NULL;
			ValaMethod* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaSymbol* _tmp27_;
			ValaClass* _tmp28_;
			ValaCCodeFunctionCall* vcast = NULL;
			ValaClass* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaClass* _tmp37_;
			ValaClass* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaCCodeIdentifier* _tmp43_;
			ValaCCodeIdentifier* _tmp44_;
			ValaCCodeFunctionCall* _tmp45_;
			ValaMethod* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			ValaCCodeMemberAccess* _tmp49_;
			ValaCCodeMemberAccess* _tmp50_;
			_tmp21_ = sig;
			_tmp22_ = vala_signal_get_default_handler (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _vala_code_node_ref0 (_tmp23_);
			m = _tmp24_;
			_tmp25_ = m;
			_tmp26_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_CLASS, ValaClass));
			base_class = _tmp28_;
			_tmp29_ = base_class;
			_tmp30_ = vala_get_ccode_class_type_function (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_ccode_identifier_new (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp33_);
			_tmp35_ = _tmp34_;
			_vala_ccode_node_unref0 (_tmp33_);
			_g_free0 (_tmp31_);
			vcast = _tmp35_;
			_tmp36_ = vcast;
			_tmp37_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp38_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strdup_printf ("%s_parent_class", _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_ccode_identifier_new (_tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_function_call_add_argument (_tmp36_, (ValaCCodeExpression*) _tmp44_);
			_vala_ccode_node_unref0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_tmp45_ = vcast;
			_tmp46_ = m;
			_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp45_, _tmp48_);
			_tmp50_ = _tmp49_;
			vala_set_cvalue ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp50_);
			_vala_ccode_node_unref0 (_tmp50_);
			_vala_ccode_node_unref0 (vcast);
			_vala_code_node_unref0 (base_class);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (sig);
			_vala_ccode_node_unref0 (pub_inst);
			return;
		}
		_tmp52_ = sig;
		_tmp53_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp52_);
		_tmp54_ = _tmp53_;
		if (!_tmp54_) {
			ValaSourceReference* _tmp55_;
			ValaSourceReference* _tmp56_;
			ValaSourceFile* _tmp57_;
			ValaSourceFile* _tmp58_;
			ValaSignal* _tmp59_;
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceFile* _tmp62_;
			ValaSourceFile* _tmp63_;
			_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_source_reference_get_file (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = sig;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_source_reference_get_file (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp51_ = _tmp58_ == _tmp63_;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaCCodeFunctionCall* ccall = NULL;
			ValaCCodeIdentifier* _tmp64_;
			ValaCCodeIdentifier* _tmp65_;
			ValaCCodeFunctionCall* _tmp66_;
			ValaCCodeFunctionCall* _tmp67_;
			ValaCCodeFunctionCall* _tmp68_;
			ValaCCodeExpression* _tmp69_;
			ValaCCodeFunctionCall* _tmp70_;
			ValaSignal* _tmp71_;
			ValaCCodeExpression* _tmp72_;
			ValaCCodeExpression* _tmp73_;
			ValaCCodeFunctionCall* _tmp74_;
			ValaCCodeConstant* _tmp75_;
			ValaCCodeConstant* _tmp76_;
			ValaCCodeFunctionCall* _tmp77_;
			_tmp64_ = vala_ccode_identifier_new ("g_signal_emit");
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp65_);
			_tmp67_ = _tmp66_;
			_vala_ccode_node_unref0 (_tmp65_);
			ccall = _tmp67_;
			_tmp68_ = ccall;
			_tmp69_ = pub_inst;
			vala_ccode_function_call_add_argument (_tmp68_, _tmp69_);
			_tmp70_ = ccall;
			_tmp71_ = sig;
			_tmp72_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp71_);
			_tmp73_ = _tmp72_;
			vala_ccode_function_call_add_argument (_tmp70_, _tmp73_);
			_vala_ccode_node_unref0 (_tmp73_);
			_tmp74_ = ccall;
			_tmp75_ = vala_ccode_constant_new ("0");
			_tmp76_ = _tmp75_;
			vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp76_);
			_vala_ccode_node_unref0 (_tmp76_);
			_tmp77_ = ccall;
			vala_set_cvalue ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp77_);
			_vala_ccode_node_unref0 (ccall);
		} else {
			ValaSignal* _tmp78_;
			_tmp78_ = sig;
			if (vala_get_ccode_has_emitter (_tmp78_)) {
				gchar* emitter_func = NULL;
				ValaSignal* _tmp79_;
				ValaMethod* _tmp80_;
				ValaMethod* _tmp81_;
				ValaCCodeFunctionCall* ccall = NULL;
				const gchar* _tmp110_;
				ValaCCodeIdentifier* _tmp111_;
				ValaCCodeIdentifier* _tmp112_;
				ValaCCodeFunctionCall* _tmp113_;
				ValaCCodeFunctionCall* _tmp114_;
				ValaCCodeFunctionCall* _tmp115_;
				ValaCCodeExpression* _tmp116_;
				ValaCCodeFunctionCall* _tmp117_;
				_tmp79_ = sig;
				_tmp80_ = vala_signal_get_emitter (_tmp79_);
				_tmp81_ = _tmp80_;
				if (_tmp81_ != NULL) {
					gboolean _tmp82_ = FALSE;
					ValaSignal* _tmp83_;
					gboolean _tmp84_;
					gboolean _tmp85_;
					ValaSignal* _tmp99_;
					ValaMethod* _tmp100_;
					ValaMethod* _tmp101_;
					gchar* _tmp102_;
					_tmp83_ = sig;
					_tmp84_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp83_);
					_tmp85_ = _tmp84_;
					if (!_tmp85_) {
						ValaSourceReference* _tmp86_;
						ValaSourceReference* _tmp87_;
						ValaSourceFile* _tmp88_;
						ValaSourceFile* _tmp89_;
						ValaSignal* _tmp90_;
						ValaSourceReference* _tmp91_;
						ValaSourceReference* _tmp92_;
						ValaSourceFile* _tmp93_;
						ValaSourceFile* _tmp94_;
						_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp87_ = _tmp86_;
						_tmp88_ = vala_source_reference_get_file (_tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = sig;
						_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp90_);
						_tmp92_ = _tmp91_;
						_tmp93_ = vala_source_reference_get_file (_tmp92_);
						_tmp94_ = _tmp93_;
						_tmp82_ = _tmp89_ != _tmp94_;
					} else {
						_tmp82_ = FALSE;
					}
					if (_tmp82_) {
						ValaSignal* _tmp95_;
						ValaMethod* _tmp96_;
						ValaMethod* _tmp97_;
						ValaCCodeFile* _tmp98_;
						_tmp95_ = sig;
						_tmp96_ = vala_signal_get_emitter (_tmp95_);
						_tmp97_ = _tmp96_;
						_tmp98_ = ((ValaCCodeBaseModule*) self)->cfile;
						vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp97_, _tmp98_);
					}
					_tmp99_ = sig;
					_tmp100_ = vala_signal_get_emitter (_tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp101_, NULL);
					_g_free0 (emitter_func);
					emitter_func = _tmp102_;
				} else {
					ValaTypeSymbol* _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					ValaSignal* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
					_tmp103_ = cl;
					_tmp104_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp103_, NULL);
					_tmp105_ = _tmp104_;
					_tmp106_ = sig;
					_tmp107_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp106_, NULL);
					_tmp108_ = _tmp107_;
					_tmp109_ = g_strdup_printf ("%s_%s", _tmp105_, _tmp108_);
					_g_free0 (emitter_func);
					emitter_func = _tmp109_;
					_g_free0 (_tmp108_);
					_g_free0 (_tmp105_);
				}
				_tmp110_ = emitter_func;
				_tmp111_ = vala_ccode_identifier_new (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp112_);
				_tmp114_ = _tmp113_;
				_vala_ccode_node_unref0 (_tmp112_);
				ccall = _tmp114_;
				_tmp115_ = ccall;
				_tmp116_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp115_, _tmp116_);
				_tmp117_ = ccall;
				vala_set_cvalue ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp117_);
				_vala_ccode_node_unref0 (ccall);
				_g_free0 (emitter_func);
			} else {
				ValaCCodeFunctionCall* ccall = NULL;
				ValaCCodeIdentifier* _tmp118_;
				ValaCCodeIdentifier* _tmp119_;
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				ValaCCodeExpression* _tmp123_;
				ValaCCodeFunctionCall* _tmp124_;
				ValaSignal* _tmp125_;
				ValaCCodeConstant* _tmp126_;
				ValaCCodeConstant* _tmp127_;
				ValaCCodeFunctionCall* _tmp128_;
				_tmp118_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp119_);
				_tmp121_ = _tmp120_;
				_vala_ccode_node_unref0 (_tmp119_);
				ccall = _tmp121_;
				_tmp122_ = ccall;
				_tmp123_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp122_, _tmp123_);
				_tmp124_ = ccall;
				_tmp125_ = sig;
				_tmp126_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, _tmp125_, NULL);
				_tmp127_ = _tmp126_;
				vala_ccode_function_call_add_argument (_tmp124_, (ValaCCodeExpression*) _tmp127_);
				_vala_ccode_node_unref0 (_tmp127_);
				_tmp128_ = ccall;
				vala_set_cvalue ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp128_);
				_vala_ccode_node_unref0 (ccall);
			}
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (sig);
		_vala_ccode_node_unref0 (pub_inst);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}

static void
vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGSignalModule * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	ValaSignal* sig = NULL;
	ValaMethodType* _tmp12_;
	ValaMethod* _tmp13_;
	ValaMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSignal* _tmp17_;
	ValaExpression* signal_access = NULL;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaExpression* handler = NULL;
	ValaList* _tmp23_;
	gpointer _tmp24_;
	gboolean disconnect = FALSE;
	ValaMethodType* _tmp25_;
	ValaMethod* _tmp26_;
	ValaMethod* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gboolean after = FALSE;
	ValaMethodType* _tmp30_;
	ValaMethod* _tmp31_;
	ValaMethod* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	ValaCCodeExpression* cexpr = NULL;
	ValaSignal* _tmp35_;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaCCodeExpression* _tmp38_;
	ValaCCodeExpression* _tmp39_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	}
	if (_tmp5_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp12_ = method_type;
	_tmp13_ = vala_method_type_get_method_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp17_;
	_tmp18_ = vala_method_call_get_call (expr);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	signal_access = _tmp22_;
	_tmp23_ = vala_method_call_get_argument_list (expr);
	_tmp24_ = vala_list_get (_tmp23_, 0);
	handler = (ValaExpression*) _tmp24_;
	_tmp25_ = method_type;
	_tmp26_ = vala_method_type_get_method_symbol (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
	_tmp29_ = _tmp28_;
	disconnect = g_strcmp0 (_tmp29_, "disconnect") == 0;
	_tmp30_ = method_type;
	_tmp31_ = vala_method_type_get_method_symbol (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
	_tmp34_ = _tmp33_;
	after = g_strcmp0 (_tmp34_, "connect_after") == 0;
	_tmp35_ = sig;
	_tmp36_ = signal_access;
	_tmp37_ = handler;
	_tmp38_ = vala_gsignal_module_connect_signal (self, _tmp35_, _tmp36_, _tmp37_, disconnect, after, (ValaCodeNode*) expr);
	cexpr = _tmp38_;
	_tmp39_ = cexpr;
	vala_set_cvalue ((ValaExpression*) expr, _tmp39_);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}

static ValaCCodeExpression*
vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                    ValaSignal* sig,
                                    ValaExpression* signal_access,
                                    ValaExpression* handler,
                                    gboolean disconnect,
                                    gboolean after,
                                    ValaCodeNode* expr)
{
	gchar* connect_func = NULL;
	ValaDelegateType* dt = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaMethod* _tmp25_;
	ValaCCodeFunctionCall* ccall = NULL;
	const gchar* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeFunctionCall* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeExpression* signal_name_cexpr = NULL;
	ValaMemberAccess* ma = NULL;
	ValaMemberAccess* _tmp65_;
	ValaExpression* _tmp66_;
	ValaExpression* _tmp67_;
	ValaCCodeFunctionCall* _tmp160_;
	ValaCCodeExpression* _tmp161_;
	ValaCCodeCastExpression* _tmp162_;
	ValaCCodeCastExpression* _tmp163_;
	gboolean _tmp164_ = FALSE;
	ValaMethod* _tmp165_;
	gboolean _tmp240_ = FALSE;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	dt = NULL;
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VARIABLE)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDelegateType* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValaDelegateType* _tmp8_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		_tmp2_ = vala_expression_get_symbol_reference (handler);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp5_) : NULL);
		_vala_code_node_unref0 (dt);
		dt = _tmp6_;
		_tmp8_ = dt;
		if (_tmp8_ != NULL) {
			ValaCodeContext* _tmp9_;
			ValaCodeContext* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_context_get_experimental (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = !_tmp12_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaSourceReference* _tmp13_;
			ValaSourceReference* _tmp14_;
			_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			_tmp14_ = _tmp13_;
			vala_report_warning (_tmp14_, "Connecting delegates to signals is experimental");
		}
		_tmp15_ = vala_expression_get_symbol_reference (handler);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_LAMBDA_EXPRESSION)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference (handler);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_VARIABLE, ValaVariable));
			_tmp22_ = _tmp21_;
			handler = _tmp22_;
		}
	}
	_tmp23_ = vala_expression_get_symbol_reference (handler);
	_tmp24_ = _tmp23_;
	_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp24_) : NULL);
	m = _tmp25_;
	if (!disconnect) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			if (!after) {
				gchar* _tmp26_;
				_tmp26_ = vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp26_;
			} else {
				gchar* _tmp27_;
				_tmp27_ = vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp27_;
			}
		} else {
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			ValaMethod* _tmp30_;
			_tmp30_ = m;
			if (_tmp30_ != NULL) {
				ValaMethod* _tmp31_;
				gboolean _tmp32_;
				gboolean _tmp33_;
				_tmp31_ = m;
				_tmp32_ = vala_method_get_closure (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp29_ = _tmp33_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				_tmp28_ = TRUE;
			} else {
				gboolean _tmp34_ = FALSE;
				ValaDelegateType* _tmp35_;
				_tmp35_ = dt;
				if (_tmp35_ != NULL) {
					ValaDelegateType* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_;
					_tmp36_ = dt;
					_tmp37_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp34_ = _tmp38_;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp28_ = _tmp34_;
			}
			if (_tmp28_) {
				gchar* _tmp39_;
				_tmp39_ = g_strdup ("g_signal_connect_data");
				_g_free0 (connect_func);
				connect_func = _tmp39_;
			} else {
				gboolean _tmp40_ = FALSE;
				ValaMethod* _tmp41_;
				_tmp41_ = m;
				if (_tmp41_ != NULL) {
					ValaMethod* _tmp42_;
					_tmp42_ = m;
					_tmp40_ = vala_gsignal_module_in_gobject_instance (self, _tmp42_);
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup ("g_signal_connect_object");
					_g_free0 (connect_func);
					connect_func = _tmp43_;
				} else {
					if (!after) {
						gchar* _tmp44_;
						_tmp44_ = g_strdup ("g_signal_connect");
						_g_free0 (connect_func);
						connect_func = _tmp44_;
					} else {
						gchar* _tmp45_;
						_tmp45_ = g_strdup ("g_signal_connect_after");
						_g_free0 (connect_func);
						connect_func = _tmp45_;
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gchar* _tmp46_;
			_tmp46_ = vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
			_g_free0 (connect_func);
			connect_func = _tmp46_;
		} else {
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_g_free0 (connect_func);
			connect_func = _tmp47_;
		}
	}
	_tmp48_ = connect_func;
	_tmp49_ = vala_ccode_identifier_new (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp50_);
	_tmp52_ = _tmp51_;
	_vala_ccode_node_unref0 (_tmp50_);
	ccall = _tmp52_;
	signal_name_cexpr = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
		ValaElementAccess* ea = NULL;
		ValaElementAccess* _tmp53_;
		ValaElementAccess* _tmp54_;
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaExpression* detail_expr = NULL;
		ValaElementAccess* _tmp58_;
		ValaList* _tmp59_;
		gpointer _tmp60_;
		ValaExpression* _tmp61_;
		ValaCCodeExpression* _tmp62_;
		_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
		ea = _tmp53_;
		_tmp54_ = ea;
		_tmp55_ = vala_element_access_get_container (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp57_;
		_tmp58_ = ea;
		_tmp59_ = vala_element_access_get_indices (_tmp58_);
		_tmp60_ = vala_list_get (_tmp59_, 0);
		detail_expr = (ValaExpression*) _tmp60_;
		_tmp61_ = detail_expr;
		_tmp62_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, _tmp61_, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp62_;
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp63_;
		ValaCCodeExpression* _tmp64_;
		_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp63_;
		_tmp64_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp64_;
	}
	_tmp65_ = ma;
	_tmp66_ = vala_member_access_get_inner (_tmp65_);
	_tmp67_ = _tmp66_;
	if (_tmp67_ != NULL) {
		ValaCCodeFunctionCall* _tmp68_;
		ValaMemberAccess* _tmp69_;
		ValaExpression* _tmp70_;
		ValaExpression* _tmp71_;
		ValaCCodeExpression* _tmp72_;
		ValaCCodeExpression* _tmp73_;
		_tmp68_ = ccall;
		_tmp69_ = ma;
		_tmp70_ = vala_member_access_get_inner (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp71_);
		_tmp73_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression);
		vala_ccode_function_call_add_argument (_tmp68_, _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
	} else {
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeExpression* _tmp75_;
		ValaCCodeExpression* _tmp76_;
		_tmp74_ = ccall;
		_tmp75_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp76_ = _tmp75_;
		vala_ccode_function_call_add_argument (_tmp74_, _tmp76_);
		_vala_ccode_node_unref0 (_tmp76_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
		ValaCCodeFunctionCall* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		ValaCCodeConstant* _tmp82_;
		ValaCCodeConstant* _tmp83_;
		_tmp77_ = ccall;
		_tmp78_ = vala_get_ccode_name ((ValaCodeNode*) sig);
		_tmp79_ = _tmp78_;
		_tmp80_ = g_strdup_printf ("\"%s\"", _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_ccode_constant_new (_tmp81_);
		_tmp83_ = _tmp82_;
		vala_ccode_function_call_add_argument (_tmp77_, (ValaCCodeExpression*) _tmp83_);
		_vala_ccode_node_unref0 (_tmp83_);
		_g_free0 (_tmp81_);
		_g_free0 (_tmp79_);
	} else {
		if (!disconnect) {
			ValaCCodeFunctionCall* _tmp84_;
			ValaCCodeExpression* _tmp85_;
			_tmp84_ = ccall;
			_tmp85_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp84_, _tmp85_);
		} else {
			ValaLocalVariable* temp_decl = NULL;
			ValaDataType* _tmp92_;
			ValaLocalVariable* _tmp93_;
			ValaLocalVariable* _tmp94_;
			ValaCCodeFunctionCall* parse_call = NULL;
			ValaCCodeIdentifier* _tmp95_;
			ValaCCodeIdentifier* _tmp96_;
			ValaCCodeFunctionCall* _tmp97_;
			ValaCCodeFunctionCall* _tmp98_;
			ValaCCodeFunctionCall* _tmp99_;
			ValaCCodeExpression* _tmp100_;
			ValaTypeSymbol* decl_type = NULL;
			ValaSymbol* _tmp101_;
			ValaSymbol* _tmp102_;
			ValaTypeSymbol* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaTypeSymbol* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			ValaCCodeIdentifier* _tmp108_;
			ValaCCodeIdentifier* _tmp109_;
			ValaCCodeFunctionCall* _tmp110_;
			ValaLocalVariable* _tmp111_;
			const gchar* _tmp112_;
			const gchar* _tmp113_;
			ValaCCodeExpression* _tmp114_;
			ValaCCodeExpression* _tmp115_;
			ValaCCodeUnaryExpression* _tmp116_;
			ValaCCodeUnaryExpression* _tmp117_;
			ValaLocalVariable* detail_temp_decl = NULL;
			ValaCCodeFunction* _tmp138_;
			ValaCCodeFunction* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaCCodeFunctionCall* _tmp141_;
			ValaLocalVariable* _tmp142_;
			const gchar* _tmp143_;
			const gchar* _tmp144_;
			ValaCCodeExpression* _tmp145_;
			ValaCCodeExpression* _tmp146_;
			ValaLocalVariable* _tmp147_;
			ValaCCodeFunctionCall* _tmp157_;
			ValaCCodeConstant* _tmp158_;
			ValaCCodeConstant* _tmp159_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp86_;
				ValaCCodeConstant* _tmp87_;
				ValaCCodeConstant* _tmp88_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp88_ = _tmp87_;
				vala_ccode_function_call_add_argument (_tmp86_, (ValaCCodeExpression*) _tmp88_);
				_vala_ccode_node_unref0 (_tmp88_);
			} else {
				ValaCCodeFunctionCall* _tmp89_;
				ValaCCodeConstant* _tmp90_;
				ValaCCodeConstant* _tmp91_;
				_tmp89_ = ccall;
				_tmp90_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp91_ = _tmp90_;
				vala_ccode_function_call_add_argument (_tmp89_, (ValaCCodeExpression*) _tmp91_);
				_vala_ccode_node_unref0 (_tmp91_);
			}
			_tmp92_ = ((ValaCCodeBaseModule*) self)->uint_type;
			_tmp93_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp92_, TRUE, NULL, FALSE);
			temp_decl = _tmp93_;
			_tmp94_ = temp_decl;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp94_, FALSE);
			_tmp95_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			_vala_ccode_node_unref0 (_tmp96_);
			parse_call = _tmp98_;
			_tmp99_ = parse_call;
			_tmp100_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp99_, _tmp100_);
			_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp102_ = _tmp101_;
			_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			decl_type = _tmp103_;
			_tmp104_ = parse_call;
			_tmp105_ = decl_type;
			_tmp106_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp105_);
			_tmp107_ = _tmp106_;
			_tmp108_ = vala_ccode_identifier_new (_tmp107_);
			_tmp109_ = _tmp108_;
			vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp109_);
			_vala_ccode_node_unref0 (_tmp109_);
			_g_free0 (_tmp107_);
			_tmp110_ = parse_call;
			_tmp111_ = temp_decl;
			_tmp112_ = vala_symbol_get_name ((ValaSymbol*) _tmp111_);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp115_);
			_tmp117_ = _tmp116_;
			vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp117_);
			_vala_ccode_node_unref0 (_tmp117_);
			_vala_ccode_node_unref0 (_tmp115_);
			detail_temp_decl = NULL;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp118_;
				ValaCCodeConstant* _tmp119_;
				ValaCCodeConstant* _tmp120_;
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeConstant* _tmp122_;
				ValaCCodeConstant* _tmp123_;
				_tmp118_ = parse_call;
				_tmp119_ = vala_ccode_constant_new ("NULL");
				_tmp120_ = _tmp119_;
				vala_ccode_function_call_add_argument (_tmp118_, (ValaCCodeExpression*) _tmp120_);
				_vala_ccode_node_unref0 (_tmp120_);
				_tmp121_ = parse_call;
				_tmp122_ = vala_ccode_constant_new ("FALSE");
				_tmp123_ = _tmp122_;
				vala_ccode_function_call_add_argument (_tmp121_, (ValaCCodeExpression*) _tmp123_);
				_vala_ccode_node_unref0 (_tmp123_);
			} else {
				ValaDataType* _tmp124_;
				ValaLocalVariable* _tmp125_;
				ValaLocalVariable* _tmp126_;
				ValaCCodeFunctionCall* _tmp127_;
				ValaLocalVariable* _tmp128_;
				const gchar* _tmp129_;
				const gchar* _tmp130_;
				ValaCCodeExpression* _tmp131_;
				ValaCCodeExpression* _tmp132_;
				ValaCCodeUnaryExpression* _tmp133_;
				ValaCCodeUnaryExpression* _tmp134_;
				ValaCCodeFunctionCall* _tmp135_;
				ValaCCodeConstant* _tmp136_;
				ValaCCodeConstant* _tmp137_;
				_tmp124_ = ((ValaCCodeBaseModule*) self)->gquark_type;
				_tmp125_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp124_, TRUE, NULL, FALSE);
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp125_;
				_tmp126_ = detail_temp_decl;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp126_, FALSE);
				_tmp127_ = parse_call;
				_tmp128_ = detail_temp_decl;
				_tmp129_ = vala_symbol_get_name ((ValaSymbol*) _tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp132_);
				_tmp134_ = _tmp133_;
				vala_ccode_function_call_add_argument (_tmp127_, (ValaCCodeExpression*) _tmp134_);
				_vala_ccode_node_unref0 (_tmp134_);
				_vala_ccode_node_unref0 (_tmp132_);
				_tmp135_ = parse_call;
				_tmp136_ = vala_ccode_constant_new ("TRUE");
				_tmp137_ = _tmp136_;
				vala_ccode_function_call_add_argument (_tmp135_, (ValaCCodeExpression*) _tmp137_);
				_vala_ccode_node_unref0 (_tmp137_);
			}
			_tmp138_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = parse_call;
			vala_ccode_function_add_expression (_tmp139_, (ValaCCodeExpression*) _tmp140_);
			_tmp141_ = ccall;
			_tmp142_ = temp_decl;
			_tmp143_ = vala_symbol_get_name ((ValaSymbol*) _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp144_);
			_tmp146_ = _tmp145_;
			vala_ccode_function_call_add_argument (_tmp141_, _tmp146_);
			_vala_ccode_node_unref0 (_tmp146_);
			_tmp147_ = detail_temp_decl;
			if (_tmp147_ == NULL) {
				ValaCCodeFunctionCall* _tmp148_;
				ValaCCodeConstant* _tmp149_;
				ValaCCodeConstant* _tmp150_;
				_tmp148_ = ccall;
				_tmp149_ = vala_ccode_constant_new ("0");
				_tmp150_ = _tmp149_;
				vala_ccode_function_call_add_argument (_tmp148_, (ValaCCodeExpression*) _tmp150_);
				_vala_ccode_node_unref0 (_tmp150_);
			} else {
				ValaCCodeFunctionCall* _tmp151_;
				ValaLocalVariable* _tmp152_;
				const gchar* _tmp153_;
				const gchar* _tmp154_;
				ValaCCodeExpression* _tmp155_;
				ValaCCodeExpression* _tmp156_;
				_tmp151_ = ccall;
				_tmp152_ = detail_temp_decl;
				_tmp153_ = vala_symbol_get_name ((ValaSymbol*) _tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp154_);
				_tmp156_ = _tmp155_;
				vala_ccode_function_call_add_argument (_tmp151_, _tmp156_);
				_vala_ccode_node_unref0 (_tmp156_);
			}
			_tmp157_ = ccall;
			_tmp158_ = vala_ccode_constant_new ("NULL");
			_tmp159_ = _tmp158_;
			vala_ccode_function_call_add_argument (_tmp157_, (ValaCCodeExpression*) _tmp159_);
			_vala_ccode_node_unref0 (_tmp159_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp160_ = ccall;
	_tmp161_ = vala_get_cvalue (handler);
	_tmp162_ = vala_ccode_cast_expression_new (_tmp161_, "GCallback");
	_tmp163_ = _tmp162_;
	vala_ccode_function_call_add_argument (_tmp160_, (ValaCCodeExpression*) _tmp163_);
	_vala_ccode_node_unref0 (_tmp163_);
	_tmp165_ = m;
	if (_tmp165_ != NULL) {
		ValaMethod* _tmp166_;
		gboolean _tmp167_;
		gboolean _tmp168_;
		_tmp166_ = m;
		_tmp167_ = vala_method_get_closure (_tmp166_);
		_tmp168_ = _tmp167_;
		_tmp164_ = _tmp168_;
	} else {
		_tmp164_ = FALSE;
	}
	if (_tmp164_) {
		ValaCCodeExpression* handler_destroy_notify = NULL;
		ValaCCodeFunctionCall* _tmp169_;
		ValaCCodeExpression* _tmp170_ = NULL;
		ValaCCodeExpression* _tmp171_;
		ValaCCodeExpression* _tmp172_;
		ValaCCodeFunctionCall* _tmp173_;
		ValaCCodeExpression* _tmp174_;
		ValaCCodeCastExpression* _tmp175_;
		ValaCCodeCastExpression* _tmp176_;
		_tmp169_ = ccall;
		_tmp171_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp170_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp170_;
		_tmp172_ = _tmp171_;
		vala_ccode_function_call_add_argument (_tmp169_, _tmp172_);
		_vala_ccode_node_unref0 (_tmp172_);
		_tmp173_ = ccall;
		_tmp174_ = handler_destroy_notify;
		_tmp175_ = vala_ccode_cast_expression_new (_tmp174_, "GClosureNotify");
		_tmp176_ = _tmp175_;
		vala_ccode_function_call_add_argument (_tmp173_, (ValaCCodeExpression*) _tmp176_);
		_vala_ccode_node_unref0 (_tmp176_);
		if (!after) {
			ValaCCodeFunctionCall* _tmp177_;
			ValaCCodeConstant* _tmp178_;
			ValaCCodeConstant* _tmp179_;
			_tmp177_ = ccall;
			_tmp178_ = vala_ccode_constant_new ("0");
			_tmp179_ = _tmp178_;
			vala_ccode_function_call_add_argument (_tmp177_, (ValaCCodeExpression*) _tmp179_);
			_vala_ccode_node_unref0 (_tmp179_);
		} else {
			ValaCCodeFunctionCall* _tmp180_;
			ValaCCodeConstant* _tmp181_;
			ValaCCodeConstant* _tmp182_;
			_tmp180_ = ccall;
			_tmp181_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp182_ = _tmp181_;
			vala_ccode_function_call_add_argument (_tmp180_, (ValaCCodeExpression*) _tmp182_);
			_vala_ccode_node_unref0 (_tmp182_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		gboolean _tmp183_ = FALSE;
		ValaMethod* _tmp184_;
		_tmp184_ = m;
		if (_tmp184_ != NULL) {
			ValaMethod* _tmp185_;
			ValaMemberBinding _tmp186_;
			ValaMemberBinding _tmp187_;
			_tmp185_ = m;
			_tmp186_ = vala_method_get_binding (_tmp185_);
			_tmp187_ = _tmp186_;
			_tmp183_ = _tmp187_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp183_ = FALSE;
		}
		if (_tmp183_) {
			gboolean _tmp203_ = FALSE;
			gboolean _tmp204_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* right_ma = NULL;
				ValaMemberAccess* _tmp188_;
				ValaMemberAccess* _tmp189_;
				ValaExpression* _tmp190_;
				ValaExpression* _tmp191_;
				_tmp188_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (handler, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				right_ma = _tmp188_;
				_tmp189_ = right_ma;
				_tmp190_ = vala_member_access_get_inner (_tmp189_);
				_tmp191_ = _tmp190_;
				if (_tmp191_ != NULL) {
					ValaCCodeFunctionCall* _tmp192_;
					ValaMemberAccess* _tmp193_;
					ValaExpression* _tmp194_;
					ValaExpression* _tmp195_;
					ValaCCodeExpression* _tmp196_;
					_tmp192_ = ccall;
					_tmp193_ = right_ma;
					_tmp194_ = vala_member_access_get_inner (_tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_get_cvalue (_tmp195_);
					vala_ccode_function_call_add_argument (_tmp192_, _tmp196_);
				} else {
					ValaCCodeFunctionCall* _tmp197_;
					ValaCCodeExpression* _tmp198_;
					ValaCCodeExpression* _tmp199_;
					_tmp197_ = ccall;
					_tmp198_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp199_ = _tmp198_;
					vala_ccode_function_call_add_argument (_tmp197_, _tmp199_);
					_vala_ccode_node_unref0 (_tmp199_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_LAMBDA_EXPRESSION)) {
					ValaCCodeFunctionCall* _tmp200_;
					ValaCCodeExpression* _tmp201_;
					ValaCCodeExpression* _tmp202_;
					_tmp200_ = ccall;
					_tmp201_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp202_ = _tmp201_;
					vala_ccode_function_call_add_argument (_tmp200_, _tmp202_);
					_vala_ccode_node_unref0 (_tmp202_);
				}
			}
			if (!disconnect) {
				_tmp204_ = !G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL);
			} else {
				_tmp204_ = FALSE;
			}
			if (_tmp204_) {
				ValaMethod* _tmp205_;
				_tmp205_ = m;
				_tmp203_ = vala_gsignal_module_in_gobject_instance (self, _tmp205_);
			} else {
				_tmp203_ = FALSE;
			}
			if (_tmp203_) {
				if (!after) {
					ValaCCodeFunctionCall* _tmp206_;
					ValaCCodeConstant* _tmp207_;
					ValaCCodeConstant* _tmp208_;
					_tmp206_ = ccall;
					_tmp207_ = vala_ccode_constant_new ("0");
					_tmp208_ = _tmp207_;
					vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp208_);
					_vala_ccode_node_unref0 (_tmp208_);
				} else {
					ValaCCodeFunctionCall* _tmp209_;
					ValaCCodeConstant* _tmp210_;
					ValaCCodeConstant* _tmp211_;
					_tmp209_ = ccall;
					_tmp210_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp211_ = _tmp210_;
					vala_ccode_function_call_add_argument (_tmp209_, (ValaCCodeExpression*) _tmp211_);
					_vala_ccode_node_unref0 (_tmp211_);
				}
			}
		} else {
			gboolean _tmp212_ = FALSE;
			ValaDelegateType* _tmp213_;
			_tmp213_ = dt;
			if (_tmp213_ != NULL) {
				ValaDelegateType* _tmp214_;
				ValaDelegate* _tmp215_;
				ValaDelegate* _tmp216_;
				gboolean _tmp217_;
				gboolean _tmp218_;
				_tmp214_ = dt;
				_tmp215_ = vala_delegate_type_get_delegate_symbol (_tmp214_);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_delegate_get_has_target (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp212_ = _tmp218_;
			} else {
				_tmp212_ = FALSE;
			}
			if (_tmp212_) {
				ValaCCodeExpression* handler_destroy_notify = NULL;
				ValaCCodeFunctionCall* _tmp219_;
				ValaCCodeExpression* _tmp220_ = NULL;
				ValaCCodeExpression* _tmp221_;
				ValaCCodeExpression* _tmp222_;
				gboolean _tmp223_ = FALSE;
				_tmp219_ = ccall;
				_tmp221_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp220_);
				_vala_ccode_node_unref0 (handler_destroy_notify);
				handler_destroy_notify = _tmp220_;
				_tmp222_ = _tmp221_;
				vala_ccode_function_call_add_argument (_tmp219_, _tmp222_);
				_vala_ccode_node_unref0 (_tmp222_);
				if (!disconnect) {
					ValaDelegateType* _tmp224_;
					gboolean _tmp225_;
					gboolean _tmp226_;
					_tmp224_ = dt;
					_tmp225_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp224_);
					_tmp226_ = _tmp225_;
					_tmp223_ = _tmp226_;
				} else {
					_tmp223_ = FALSE;
				}
				if (_tmp223_) {
					ValaCCodeFunctionCall* _tmp227_;
					ValaCCodeExpression* _tmp228_;
					ValaCCodeCastExpression* _tmp229_;
					ValaCCodeCastExpression* _tmp230_;
					_tmp227_ = ccall;
					_tmp228_ = handler_destroy_notify;
					_tmp229_ = vala_ccode_cast_expression_new (_tmp228_, "GClosureNotify");
					_tmp230_ = _tmp229_;
					vala_ccode_function_call_add_argument (_tmp227_, (ValaCCodeExpression*) _tmp230_);
					_vala_ccode_node_unref0 (_tmp230_);
					if (!after) {
						ValaCCodeFunctionCall* _tmp231_;
						ValaCCodeConstant* _tmp232_;
						ValaCCodeConstant* _tmp233_;
						_tmp231_ = ccall;
						_tmp232_ = vala_ccode_constant_new ("0");
						_tmp233_ = _tmp232_;
						vala_ccode_function_call_add_argument (_tmp231_, (ValaCCodeExpression*) _tmp233_);
						_vala_ccode_node_unref0 (_tmp233_);
					} else {
						ValaCCodeFunctionCall* _tmp234_;
						ValaCCodeConstant* _tmp235_;
						ValaCCodeConstant* _tmp236_;
						_tmp234_ = ccall;
						_tmp235_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
						_tmp236_ = _tmp235_;
						vala_ccode_function_call_add_argument (_tmp234_, (ValaCCodeExpression*) _tmp236_);
						_vala_ccode_node_unref0 (_tmp236_);
					}
				}
				_vala_ccode_node_unref0 (handler_destroy_notify);
			} else {
				ValaCCodeFunctionCall* _tmp237_;
				ValaCCodeConstant* _tmp238_;
				ValaCCodeConstant* _tmp239_;
				_tmp237_ = ccall;
				_tmp238_ = vala_ccode_constant_new ("NULL");
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_add_argument (_tmp237_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
			}
		}
	}
	if (disconnect) {
		_tmp240_ = TRUE;
	} else {
		ValaCodeNode* _tmp241_;
		ValaCodeNode* _tmp242_;
		_tmp241_ = vala_code_node_get_parent_node (expr);
		_tmp242_ = _tmp241_;
		_tmp240_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp242_, VALA_TYPE_EXPRESSION_STATEMENT);
	}
	if (_tmp240_) {
		ValaCCodeFunction* _tmp243_;
		ValaCCodeFunction* _tmp244_;
		ValaCCodeFunctionCall* _tmp245_;
		_tmp243_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp244_ = _tmp243_;
		_tmp245_ = ccall;
		vala_ccode_function_add_expression (_tmp244_, (ValaCCodeExpression*) _tmp245_);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* temp_var = NULL;
		ValaDataType* _tmp246_;
		ValaLocalVariable* _tmp247_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp248_;
		const gchar* _tmp249_;
		const gchar* _tmp250_;
		ValaCCodeExpression* _tmp251_;
		ValaLocalVariable* _tmp252_;
		ValaCCodeFunction* _tmp253_;
		ValaCCodeFunction* _tmp254_;
		ValaCCodeExpression* _tmp255_;
		ValaCCodeFunctionCall* _tmp256_;
		_tmp246_ = ((ValaCCodeBaseModule*) self)->ulong_type;
		_tmp247_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp246_, TRUE, NULL, FALSE);
		temp_var = _tmp247_;
		_tmp248_ = temp_var;
		_tmp249_ = vala_symbol_get_name ((ValaSymbol*) _tmp248_);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp250_);
		temp_ref = _tmp251_;
		_tmp252_ = temp_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp252_, FALSE);
		_tmp253_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp254_ = _tmp253_;
		_tmp255_ = temp_ref;
		_tmp256_ = ccall;
		vala_ccode_function_add_assignment (_tmp254_, _tmp255_, (ValaCCodeExpression*) _tmp256_);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	}
	_vala_code_node_unref0 (ma);
	_vala_ccode_node_unref0 (signal_name_cexpr);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (dt);
	_g_free0 (connect_func);
}

ValaGSignalModule*
vala_gsignal_module_construct (GType object_type)
{
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}

ValaGSignalModule*
vala_gsignal_module_new (void)
{
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}

static void
vala_gsignal_module_class_init (ValaGSignalModuleClass * klass,
                                gpointer klass_data)
{
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gsignal_module_real_visit_signal;
	((ValaCCodeBaseModuleClass *) klass)->get_signal_creation = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaSignal*, ValaTypeSymbol*)) vala_gsignal_module_real_get_signal_creation;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_gsignal_module_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) vala_gsignal_module_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gsignal_module_real_visit_method_call;
}

static void
vala_gsignal_module_instance_init (ValaGSignalModule * self,
                                   gpointer klass)
{
}

static GType
vala_gsignal_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
	GType vala_gsignal_module_type_id;
	vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
	return vala_gsignal_module_type_id;
}

GType
vala_gsignal_module_get_type (void)
{
	static volatile gsize vala_gsignal_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__volatile)) {
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = vala_gsignal_module_get_type_once ();
		g_once_init_leave (&vala_gsignal_module_type_id__volatile, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

