/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaLocalVariable* _params_array_var;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_set_params_array_var (ValaMethod* self,
                                       ValaLocalVariable* value);
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar* * invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);
static GType vala_method_get_type_once (void);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaLocalVariable*
vala_method_get_params_array_var (ValaMethod* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_params_array_var;
	result = _tmp0_;
	return result;
}

static void
vala_method_set_params_array_var (ValaMethod* self,
                                  ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	self->priv->_params_array_var = _tmp0_;
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp17_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			_tmp10_ = vala_parameter_get_ellipsis (_tmp9_);
			_tmp11_ = _tmp10_;
			if (!_tmp11_) {
				ValaScope* _tmp12_;
				ValaScope* _tmp13_;
				ValaParameter* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp13_ = _tmp12_;
				_tmp14_ = param;
				_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
				_tmp16_ = _tmp15_;
				vala_scope_remove (_tmp13_, _tmp16_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp17_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp17_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaParameter* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_ellipsis (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				_tmp9_ = TRUE;
			} else {
				ValaParameter* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = param;
				_tmp14_ = vala_parameter_get_params_array (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaList* _tmp28_;
	ValaLocalVariable* _tmp39_;
	ValaLocalVariable* _tmp40_;
	ValaList* _tmp43_;
	ValaList* _tmp54_;
	ValaBlock* _tmp65_;
	ValaBlock* _tmp66_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaTypeParameter* _tmp9_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = vala_list_get (_tmp7_, _p_index);
			p = (ValaTypeParameter*) _tmp8_;
			_tmp9_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp10_ = vala_method_get_base_interface_type (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp12_ = vala_method_get_base_interface_type (self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
	}
	_tmp14_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		_tmp16_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp17_ = _tmp16_;
		vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _param_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _param_index = 0;
		_tmp18_ = self->priv->parameters;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_param_list = _tmp19_;
		_tmp20_ = _param_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_param_size = _tmp22_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaParameter* param = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaParameter* _tmp27_;
			_param_index = _param_index + 1;
			_tmp23_ = _param_index;
			_tmp24_ = _param_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _param_list;
			_tmp26_ = vala_list_get (_tmp25_, _param_index);
			param = (ValaParameter*) _tmp26_;
			_tmp27_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = self->error_types;
	if (_tmp28_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp29_;
			ValaList* _tmp30_;
			gint _error_type_size = 0;
			ValaList* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _error_type_index = 0;
			_tmp29_ = self->error_types;
			_tmp30_ = _vala_iterable_ref0 (_tmp29_);
			_error_type_list = _tmp30_;
			_tmp31_ = _error_type_list;
			_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
			_tmp33_ = _tmp32_;
			_error_type_size = _tmp33_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp34_;
				gint _tmp35_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp36_;
				gpointer _tmp37_;
				ValaDataType* _tmp38_;
				_error_type_index = _error_type_index + 1;
				_tmp34_ = _error_type_index;
				_tmp35_ = _error_type_size;
				if (!(_tmp34_ < _tmp35_)) {
					break;
				}
				_tmp36_ = _error_type_list;
				_tmp37_ = vala_list_get (_tmp36_, _error_type_index);
				error_type = (ValaDataType*) _tmp37_;
				_tmp38_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp38_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp39_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp40_ = _tmp39_;
	if (_tmp40_ != NULL) {
		ValaLocalVariable* _tmp41_;
		ValaLocalVariable* _tmp42_;
		_tmp41_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp42_ = _tmp41_;
		vala_code_node_accept ((ValaCodeNode*) _tmp42_, visitor);
	}
	_tmp43_ = self->priv->preconditions;
	if (_tmp43_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp44_;
			ValaList* _tmp45_;
			gint _precondition_size = 0;
			ValaList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			gint _precondition_index = 0;
			_tmp44_ = self->priv->preconditions;
			_tmp45_ = _vala_iterable_ref0 (_tmp44_);
			_precondition_list = _tmp45_;
			_tmp46_ = _precondition_list;
			_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_precondition_size = _tmp48_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp49_;
				gint _tmp50_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				ValaExpression* _tmp53_;
				_precondition_index = _precondition_index + 1;
				_tmp49_ = _precondition_index;
				_tmp50_ = _precondition_size;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = _precondition_list;
				_tmp52_ = vala_list_get (_tmp51_, _precondition_index);
				precondition = (ValaExpression*) _tmp52_;
				_tmp53_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp53_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp54_ = self->priv->postconditions;
	if (_tmp54_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp55_;
			ValaList* _tmp56_;
			gint _postcondition_size = 0;
			ValaList* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			gint _postcondition_index = 0;
			_tmp55_ = self->priv->postconditions;
			_tmp56_ = _vala_iterable_ref0 (_tmp55_);
			_postcondition_list = _tmp56_;
			_tmp57_ = _postcondition_list;
			_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
			_tmp59_ = _tmp58_;
			_postcondition_size = _tmp59_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp60_;
				gint _tmp61_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp62_;
				gpointer _tmp63_;
				ValaExpression* _tmp64_;
				_postcondition_index = _postcondition_index + 1;
				_tmp60_ = _postcondition_index;
				_tmp61_ = _postcondition_size;
				if (!(_tmp60_ < _tmp61_)) {
					break;
				}
				_tmp62_ = _postcondition_list;
				_tmp63_ = vala_list_get (_tmp62_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp63_;
				_tmp64_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp64_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp65_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != NULL) {
		ValaBlock* _tmp67_;
		ValaBlock* _tmp68_;
		_tmp67_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp68_ = _tmp67_;
		vala_code_node_accept ((ValaCodeNode*) _tmp68_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar* * invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* method_type_args = NULL;
	ValaDataType* return_type = NULL;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp65_;
	ValaObjectType* _tmp66_;
	ValaList* _tmp67_;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp78_;
	ValaIterator* _tmp79_;
	gint param_index = 0;
	ValaIterator* _tmp129_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp131_;
	ValaArrayList* _tmp132_;
	ValaArrayList* _tmp133_;
	ValaList* _tmp134_;
	gboolean _tmp159_;
	gboolean _tmp160_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			ValaList* _tmp12_;
			gint _type_parameter_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_object_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_type_parameter_list = _tmp12_;
			_tmp13_ = _type_parameter_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_type_parameter_size = _tmp15_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp18_;
				gpointer _tmp19_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp20_;
				ValaGenericType* _tmp21_;
				ValaGenericType* _tmp22_;
				ValaObjectType* _tmp23_;
				ValaGenericType* _tmp24_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp16_ = _type_parameter_index;
				_tmp17_ = _type_parameter_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _type_parameter_list;
				_tmp19_ = vala_list_get (_tmp18_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp19_;
				_tmp20_ = type_parameter;
				_tmp21_ = vala_generic_type_new (_tmp20_);
				type_arg = _tmp21_;
				_tmp22_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp22_, TRUE);
				_tmp23_ = object_type;
				_tmp24_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp23_, (ValaDataType*) _tmp24_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp25_ = vala_method_get_type_parameters (self);
	_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_method_get_type_parameters (base_method);
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp27_ < _tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp31_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		_tmp32_ = vala_method_get_type_parameters (self);
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_method_get_type_parameters (base_method);
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		if (_tmp34_ > _tmp37_) {
			gchar* _tmp38_;
			_tmp38_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp38_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp39_;
		ValaArrayList* _tmp40_;
		_tmp39_ = g_direct_equal;
		_tmp40_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp39_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp40_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp41_;
			ValaList* _tmp42_;
			gint _type_parameter_size = 0;
			ValaList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _type_parameter_index = 0;
			_tmp41_ = vala_method_get_type_parameters (self);
			_tmp42_ = _vala_iterable_ref0 (_tmp41_);
			_type_parameter_list = _tmp42_;
			_tmp43_ = _type_parameter_list;
			_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_type_parameter_size = _tmp45_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp46_;
				gint _tmp47_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp48_;
				gpointer _tmp49_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp50_;
				ValaGenericType* _tmp51_;
				ValaGenericType* _tmp52_;
				ValaList* _tmp53_;
				ValaGenericType* _tmp54_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp46_ = _type_parameter_index;
				_tmp47_ = _type_parameter_size;
				if (!(_tmp46_ < _tmp47_)) {
					break;
				}
				_tmp48_ = _type_parameter_list;
				_tmp49_ = vala_list_get (_tmp48_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp49_;
				_tmp50_ = type_parameter;
				_tmp51_ = vala_generic_type_new (_tmp50_);
				type_arg = _tmp51_;
				_tmp52_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp52_, TRUE);
				_tmp53_ = method_type_args;
				_tmp54_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp53_, (ValaDataType*) _tmp54_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp55_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_data_type_copy (_tmp56_);
	return_type = _tmp57_;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "returns_floating_reference")) {
		ValaDataType* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		_tmp58_ = return_type;
		_tmp59_ = vala_method_get_returns_floating_reference (self);
		_tmp60_ = _tmp59_;
		vala_data_type_set_floating_reference (_tmp58_, _tmp60_);
	} else {
		ValaDataType* _tmp61_;
		gboolean _tmp62_;
		gboolean _tmp63_;
		_tmp61_ = return_type;
		_tmp62_ = vala_method_get_returns_floating_reference (base_method);
		_tmp63_ = _tmp62_;
		vala_data_type_set_floating_reference (_tmp61_, _tmp63_);
	}
	_tmp64_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp65_ = _tmp64_;
	_tmp66_ = object_type;
	_tmp67_ = method_type_args;
	_tmp68_ = vala_data_type_get_actual_type (_tmp65_, (ValaDataType*) _tmp66_, _tmp67_, node_reference);
	actual_base_type = _tmp68_;
	_tmp69_ = return_type;
	_tmp70_ = actual_base_type;
	if (!vala_data_type_equals (_tmp69_, _tmp70_)) {
		ValaDataType* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		ValaDataType* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		_tmp71_ = actual_base_type;
		_tmp72_ = vala_data_type_to_prototype_string (_tmp71_, NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = return_type;
		_tmp75_ = vala_data_type_to_prototype_string (_tmp74_, NULL);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp73_, _tmp76_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp77_;
		_g_free0 (_tmp76_);
		_g_free0 (_tmp73_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp78_ = self->priv->parameters;
	_tmp79_ = vala_iterable_iterator ((ValaIterable*) _tmp78_);
	method_params_it = _tmp79_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp80_;
		ValaList* _tmp81_;
		gint _base_param_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _base_param_index = 0;
		_tmp80_ = base_method->priv->parameters;
		_tmp81_ = _vala_iterable_ref0 (_tmp80_);
		_base_param_list = _tmp81_;
		_tmp82_ = _base_param_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_base_param_size = _tmp84_;
		_base_param_index = -1;
		while (TRUE) {
			gint _tmp85_;
			gint _tmp86_;
			ValaParameter* base_param = NULL;
			ValaList* _tmp87_;
			gpointer _tmp88_;
			ValaIterator* _tmp89_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp91_;
			gpointer _tmp92_;
			ValaParameter* _tmp93_;
			gboolean _tmp94_;
			gboolean _tmp95_;
			ValaParameter* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			ValaParameter* _tmp100_;
			gboolean _tmp101_;
			gboolean _tmp102_;
			ValaParameter* _tmp103_;
			gboolean _tmp104_;
			gboolean _tmp105_;
			ValaParameter* _tmp107_;
			gboolean _tmp108_;
			gboolean _tmp109_;
			gint _tmp128_;
			_base_param_index = _base_param_index + 1;
			_tmp85_ = _base_param_index;
			_tmp86_ = _base_param_size;
			if (!(_tmp85_ < _tmp86_)) {
				break;
			}
			_tmp87_ = _base_param_list;
			_tmp88_ = vala_list_get (_tmp87_, _base_param_index);
			base_param = (ValaParameter*) _tmp88_;
			_tmp89_ = method_params_it;
			if (!vala_iterator_next (_tmp89_)) {
				gchar* _tmp90_;
				_tmp90_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp90_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp91_ = method_params_it;
			_tmp92_ = vala_iterator_get (_tmp91_);
			param = (ValaParameter*) _tmp92_;
			_tmp93_ = base_param;
			_tmp94_ = vala_parameter_get_ellipsis (_tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = param;
			_tmp97_ = vala_parameter_get_ellipsis (_tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp95_ != _tmp98_) {
				gchar* _tmp99_;
				_tmp99_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp99_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp100_ = base_param;
			_tmp101_ = vala_parameter_get_params_array (_tmp100_);
			_tmp102_ = _tmp101_;
			_tmp103_ = param;
			_tmp104_ = vala_parameter_get_params_array (_tmp103_);
			_tmp105_ = _tmp104_;
			if (_tmp102_ != _tmp105_) {
				gchar* _tmp106_;
				_tmp106_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp106_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp107_ = base_param;
			_tmp108_ = vala_parameter_get_ellipsis (_tmp107_);
			_tmp109_ = _tmp108_;
			if (!_tmp109_) {
				ValaParameter* _tmp110_;
				ValaParameterDirection _tmp111_;
				ValaParameterDirection _tmp112_;
				ValaParameter* _tmp113_;
				ValaParameterDirection _tmp114_;
				ValaParameterDirection _tmp115_;
				ValaParameter* _tmp117_;
				ValaDataType* _tmp118_;
				ValaDataType* _tmp119_;
				ValaObjectType* _tmp120_;
				ValaList* _tmp121_;
				ValaDataType* _tmp122_;
				ValaDataType* _tmp123_;
				ValaParameter* _tmp124_;
				ValaDataType* _tmp125_;
				ValaDataType* _tmp126_;
				_tmp110_ = base_param;
				_tmp111_ = vala_parameter_get_direction (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = param;
				_tmp114_ = vala_parameter_get_direction (_tmp113_);
				_tmp115_ = _tmp114_;
				if (_tmp112_ != _tmp115_) {
					gchar* _tmp116_;
					_tmp116_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp116_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp117_ = base_param;
				_tmp118_ = vala_variable_get_variable_type ((ValaVariable*) _tmp117_);
				_tmp119_ = _tmp118_;
				_tmp120_ = object_type;
				_tmp121_ = method_type_args;
				_tmp122_ = vala_data_type_get_actual_type (_tmp119_, (ValaDataType*) _tmp120_, _tmp121_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp122_;
				_tmp123_ = actual_base_type;
				_tmp124_ = param;
				_tmp125_ = vala_variable_get_variable_type ((ValaVariable*) _tmp124_);
				_tmp126_ = _tmp125_;
				if (!vala_data_type_equals (_tmp123_, _tmp126_)) {
					gchar* _tmp127_;
					_tmp127_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp127_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp128_ = param_index;
			param_index = _tmp128_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp129_ = method_params_it;
	if (vala_iterator_next (_tmp129_)) {
		gchar* _tmp130_;
		_tmp130_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp130_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp131_ = g_direct_equal;
	_tmp132_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp131_);
	base_method_errors = _tmp132_;
	_tmp133_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp133_, NULL);
	_tmp134_ = self->error_types;
	if (_tmp134_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp135_;
			ValaList* _tmp136_;
			gint _method_error_type_size = 0;
			ValaList* _tmp137_;
			gint _tmp138_;
			gint _tmp139_;
			gint _method_error_type_index = 0;
			_tmp135_ = self->error_types;
			_tmp136_ = _vala_iterable_ref0 (_tmp135_);
			_method_error_type_list = _tmp136_;
			_tmp137_ = _method_error_type_list;
			_tmp138_ = vala_collection_get_size ((ValaCollection*) _tmp137_);
			_tmp139_ = _tmp138_;
			_method_error_type_size = _tmp139_;
			_method_error_type_index = -1;
			while (TRUE) {
				gint _tmp140_;
				gint _tmp141_;
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp142_;
				gpointer _tmp143_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				_tmp140_ = _method_error_type_index;
				_tmp141_ = _method_error_type_size;
				if (!(_tmp140_ < _tmp141_)) {
					break;
				}
				_tmp142_ = _method_error_type_list;
				_tmp143_ = vala_list_get (_tmp142_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp143_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp144_;
					ValaArrayList* _tmp145_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp146_;
					gint _tmp147_;
					gint _tmp148_;
					gint _base_method_error_type_index = 0;
					_tmp144_ = base_method_errors;
					_tmp145_ = _vala_iterable_ref0 (_tmp144_);
					_base_method_error_type_list = _tmp145_;
					_tmp146_ = _base_method_error_type_list;
					_tmp147_ = vala_collection_get_size ((ValaCollection*) _tmp146_);
					_tmp148_ = _tmp147_;
					_base_method_error_type_size = _tmp148_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp149_;
						gint _tmp150_;
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp151_;
						gpointer _tmp152_;
						ValaDataType* _tmp153_;
						ValaDataType* _tmp154_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						_tmp149_ = _base_method_error_type_index;
						_tmp150_ = _base_method_error_type_size;
						if (!(_tmp149_ < _tmp150_)) {
							break;
						}
						_tmp151_ = _base_method_error_type_list;
						_tmp152_ = vala_list_get ((ValaList*) _tmp151_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp152_;
						_tmp153_ = method_error_type;
						_tmp154_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp153_, _tmp154_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					gchar* _tmp158_;
					_tmp155_ = method_error_type;
					_tmp156_ = vala_code_node_to_string ((ValaCodeNode*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = g_strdup_printf ("incompatible error type `%s'", _tmp157_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp158_;
					_g_free0 (_tmp157_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp159_ = base_method->priv->_coroutine;
	_tmp160_ = self->priv->_coroutine;
	if (_tmp159_ != _tmp160_) {
		gchar* _tmp161_;
		_tmp161_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp161_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->type_parameters;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_type_parameter_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_type_parameter_list;
	result = _tmp5_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaTypeParameter* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gint _tmp13_;
			_parameter_index = _parameter_index + 1;
			_tmp6_ = _parameter_index;
			_tmp7_ = _parameter_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _parameter_list;
			_tmp9_ = vala_list_get (_tmp8_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp9_;
			_tmp10_ = parameter;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp12_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->postconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp8_;
				gpointer _tmp9_;
				_error_type_index = _error_type_index + 1;
				_tmp6_ = _error_type_index;
				_tmp7_ = _error_type_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _error_type_list;
				_tmp9_ = vala_list_get (_tmp8_, _error_type_index);
				error_type = (ValaDataType*) _tmp9_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					ValaDataType* _tmp12_;
					ValaDataType* _tmp13_;
					_tmp10_ = error_type;
					_tmp11_ = vala_data_type_copy (_tmp10_);
					type = _tmp11_;
					_tmp12_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp12_, source_reference);
					_tmp13_ = type;
					vala_collection_add (collection, _tmp13_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp14_;
					_tmp14_ = error_type;
					vala_collection_add (collection, _tmp14_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp11_;
	ValaClass* _tmp36_;
	ValaClass* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = sym;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal);
		_tmp7_ = sig;
		_tmp8_ = vala_signal_get_default_handler (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (sym);
		sym = _tmp10_;
	}
	_tmp11_ = sym;
	if (VALA_IS_METHOD (_tmp11_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValaMethod* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = sym;
		base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_METHOD, ValaMethod);
		_tmp14_ = base_method;
		_tmp15_ = _tmp14_->priv->_is_abstract;
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			_tmp16_ = base_method;
			_tmp17_ = _tmp16_->priv->_is_virtual;
			_tmp13_ = _tmp17_;
		}
		if (_tmp13_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp18_;
			gchar* _tmp19_ = NULL;
			gboolean _tmp20_;
			ValaMethod* _tmp33_;
			ValaMethod* _tmp34_;
			ValaMethod* _tmp35_;
			_tmp18_ = base_method;
			_tmp20_ = vala_method_compatible (self, _tmp18_, &_tmp19_);
			_g_free0 (invalid_match);
			invalid_match = _tmp19_;
			if (!_tmp20_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp21_;
				ValaMethodType* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				ValaMethodType* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp21_ = base_method;
				_tmp22_ = vala_method_type_new (_tmp21_);
				base_method_type = _tmp22_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = base_method_type;
				_tmp28_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = invalid_match;
				_tmp31_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp26_, _tmp29_, _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp26_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp33_ = base_method;
			self->priv->_base_method = _tmp33_;
			_tmp34_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp34_, "CCode", "instance_pos");
			_tmp35_ = base_method;
			vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp35_, "CCode", "returns_floating_reference");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (sym);
			return;
		}
	}
	_tmp36_ = vala_class_get_base_class (cl);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaClass* _tmp38_;
		ValaClass* _tmp39_;
		_tmp38_ = vala_class_get_base_class (cl);
		_tmp39_ = _tmp38_;
		vala_method_find_base_class_method (self, _tmp39_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp71_;
	ValaDataType* _tmp91_;
	ValaDataType* _tmp92_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = vala_list_get (_tmp7_, _type_index);
			type = (ValaDataType*) _tmp8_;
			_tmp9_ = type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (VALA_IS_INTERFACE (_tmp11_)) {
				gboolean _tmp12_ = FALSE;
				ValaDataType* _tmp13_;
				ValaDataType* _tmp14_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				ValaScope* _tmp25_;
				ValaScope* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				ValaSymbol* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaSymbol* _tmp36_;
				_tmp13_ = vala_method_get_base_interface_type (self);
				_tmp14_ = _tmp13_;
				if (_tmp14_ != NULL) {
					ValaDataType* _tmp15_;
					ValaDataType* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaDataType* _tmp19_;
					ValaTypeSymbol* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					_tmp15_ = vala_method_get_base_interface_type (self);
					_tmp16_ = _tmp15_;
					_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = type;
					_tmp20_ = vala_data_type_get_type_symbol (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp12_ = _tmp18_ != _tmp21_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp22_ = type;
				_tmp23_ = vala_data_type_get_type_symbol (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_scope_lookup (_tmp26_, _tmp28_);
				sym = _tmp29_;
				_tmp30_ = sym;
				if (VALA_IS_SIGNAL (_tmp30_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp31_;
					ValaSignal* _tmp32_;
					ValaMethod* _tmp33_;
					ValaMethod* _tmp34_;
					ValaSymbol* _tmp35_;
					_tmp31_ = sym;
					sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_SIGNAL, ValaSignal);
					_tmp32_ = sig;
					_tmp33_ = vala_signal_get_default_handler (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp34_);
					_vala_code_node_unref0 (sym);
					sym = _tmp35_;
				}
				_tmp36_ = sym;
				if (VALA_IS_METHOD (_tmp36_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp37_;
					gboolean _tmp38_ = FALSE;
					ValaMethod* _tmp39_;
					gboolean _tmp40_;
					_tmp37_ = sym;
					base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_METHOD, ValaMethod);
					_tmp39_ = base_method;
					_tmp40_ = _tmp39_->priv->_is_abstract;
					if (_tmp40_) {
						_tmp38_ = TRUE;
					} else {
						ValaMethod* _tmp41_;
						gboolean _tmp42_;
						_tmp41_ = base_method;
						_tmp42_ = _tmp41_->priv->_is_virtual;
						_tmp38_ = _tmp42_;
					}
					if (_tmp38_) {
						ValaDataType* _tmp43_;
						ValaDataType* _tmp44_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp62_;
						gchar* _tmp63_ = NULL;
						gboolean _tmp64_;
						_tmp43_ = vala_method_get_base_interface_type (self);
						_tmp44_ = _tmp43_;
						if (_tmp44_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp45_;
								ValaList* _tmp46_;
								gint _m_size = 0;
								ValaList* _tmp47_;
								gint _tmp48_;
								gint _tmp49_;
								gint _m_index = 0;
								_tmp45_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_tmp46_ = _vala_iterable_ref0 (_tmp45_);
								_m_list = _tmp46_;
								_tmp47_ = _m_list;
								_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
								_tmp49_ = _tmp48_;
								_m_size = _tmp49_;
								_m_index = -1;
								while (TRUE) {
									gint _tmp50_;
									gint _tmp51_;
									ValaMethod* m = NULL;
									ValaList* _tmp52_;
									gpointer _tmp53_;
									gboolean _tmp54_ = FALSE;
									ValaMethod* _tmp55_;
									ValaDataType* _tmp56_;
									ValaDataType* _tmp57_;
									_m_index = _m_index + 1;
									_tmp50_ = _m_index;
									_tmp51_ = _m_size;
									if (!(_tmp50_ < _tmp51_)) {
										break;
									}
									_tmp52_ = _m_list;
									_tmp53_ = vala_list_get (_tmp52_, _m_index);
									m = (ValaMethod*) _tmp53_;
									_tmp55_ = m;
									_tmp56_ = vala_method_get_base_interface_type (_tmp55_);
									_tmp57_ = _tmp56_;
									if (_tmp57_ != NULL) {
										ValaMethod* _tmp58_;
										ValaMethod* _tmp59_;
										ValaMethod* _tmp60_;
										ValaMethod* _tmp61_;
										_tmp58_ = base_method;
										_tmp59_ = m;
										_tmp60_ = vala_method_get_base_interface_method (_tmp59_);
										_tmp61_ = _tmp60_;
										_tmp54_ = _tmp58_ == _tmp61_;
									} else {
										_tmp54_ = FALSE;
									}
									if (_tmp54_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp62_ = base_method;
						_tmp64_ = vala_method_compatible (self, _tmp62_, &_tmp63_);
						_g_free0 (invalid_match);
						invalid_match = _tmp63_;
						if (!_tmp64_) {
							const gchar* _tmp65_;
							gchar* _tmp66_;
							ValaMethod* _tmp67_;
							ValaMethod* _tmp68_;
							_tmp65_ = invalid_match;
							_tmp66_ = g_strdup (_tmp65_);
							_g_free0 (invalid_error);
							invalid_error = _tmp66_;
							_tmp67_ = base_method;
							_tmp68_ = _vala_code_node_ref0 (_tmp67_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp68_;
						} else {
							ValaMethod* _tmp69_;
							ValaMethod* _tmp70_;
							_tmp69_ = base_method;
							_tmp70_ = _vala_code_node_ref0 (_tmp69_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp70_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp71_ = base_match;
	if (_tmp71_ != NULL) {
		ValaMethod* _tmp72_;
		ValaMethod* _tmp73_;
		ValaMethod* _tmp74_;
		_tmp72_ = base_match;
		self->priv->_base_interface_method = _tmp72_;
		_tmp73_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp73_, "CCode", "instance_pos");
		_tmp74_ = base_match;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp74_, "CCode", "returns_floating_reference");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		gboolean _tmp75_ = FALSE;
		gboolean _tmp76_;
		gboolean _tmp77_;
		_tmp76_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp77_ = _tmp76_;
		if (!_tmp77_) {
			ValaMethod* _tmp78_;
			_tmp78_ = invalid_base_match;
			_tmp75_ = _tmp78_ != NULL;
		} else {
			_tmp75_ = FALSE;
		}
		if (_tmp75_) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp79_;
			ValaMethodType* _tmp80_;
			ValaSourceReference* _tmp81_;
			ValaSourceReference* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			ValaMethodType* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp79_ = invalid_base_match;
			_tmp80_ = vala_method_type_new (_tmp79_);
			base_method_type = _tmp80_;
			_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp84_ = _tmp83_;
			_tmp85_ = base_method_type;
			_tmp86_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp85_, NULL);
			_tmp87_ = _tmp86_;
			_tmp88_ = invalid_error;
			_tmp89_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp84_, _tmp87_, _tmp88_);
			_tmp90_ = _tmp89_;
			vala_report_error (_tmp82_, _tmp90_);
			_g_free0 (_tmp90_);
			_g_free0 (_tmp87_);
			_g_free0 (_tmp84_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp91_ = vala_method_get_base_interface_type (self);
	_tmp92_ = _tmp91_;
	if (_tmp92_ != NULL) {
		ValaSourceReference* _tmp93_;
		ValaSourceReference* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp96_);
		_tmp98_ = _tmp97_;
		vala_report_error (_tmp94_, _tmp98_);
		_g_free0 (_tmp98_);
		_g_free0 (_tmp96_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaParameter* _tmp4_;
	ValaAttribute* _tmp6_;
	ValaAttribute* _tmp10_;
	gboolean _tmp11_ = FALSE;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp34_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp103_ = FALSE;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp110_;
	ValaSemanticAnalyzer* _tmp111_;
	ValaSourceFile* _tmp112_;
	ValaSourceFile* _tmp113_;
	ValaSourceFile* _tmp114_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp115_;
	ValaSemanticAnalyzer* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSymbol* _tmp118_;
	ValaSymbol* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaSourceReference* _tmp121_;
	ValaSemanticAnalyzer* _tmp128_;
	ValaSemanticAnalyzer* _tmp129_;
	ValaDataType* _tmp130_;
	ValaDataType* _tmp131_;
	gboolean _tmp132_;
	gboolean _tmp133_;
	ValaDataType* _tmp134_;
	ValaDataType* _tmp135_;
	gboolean _tmp136_;
	gboolean _tmp137_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	ValaTypeSymbol* _tmp144_;
	ValaTypeSymbol* _tmp145_;
	ValaSemanticAnalyzer* _tmp146_;
	ValaSemanticAnalyzer* _tmp147_;
	ValaDataType* _tmp148_;
	ValaTypeSymbol* _tmp149_;
	ValaTypeSymbol* _tmp150_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp161_;
	ValaAttribute* _tmp162_;
	ValaAttribute* _tmp163_;
	ValaDataType* _tmp170_;
	ValaDataType* _tmp171_;
	gboolean _tmp174_ = FALSE;
	gboolean _tmp175_ = FALSE;
	gboolean _tmp176_ = FALSE;
	ValaList* _tmp177_;
	gint _tmp178_;
	gint _tmp179_;
	gboolean _tmp193_ = FALSE;
	ValaAttribute* _tmp194_;
	gboolean optional_param = FALSE;
	gboolean _tmp333_;
	ValaList* _tmp347_;
	ValaLocalVariable* _tmp370_;
	ValaLocalVariable* _tmp371_;
	ValaList* _tmp374_;
	ValaList* _tmp385_;
	ValaBlock* _tmp396_;
	ValaBlock* _tmp397_;
	ValaSemanticAnalyzer* _tmp400_;
	ValaSemanticAnalyzer* _tmp401_;
	ValaStruct* _tmp402_;
	ValaStruct* _tmp403_;
	gboolean _tmp461_ = FALSE;
	gboolean _tmp462_ = FALSE;
	ValaDataType* _tmp463_;
	ValaDataType* _tmp464_;
	ValaSemanticAnalyzer* _tmp510_;
	ValaSemanticAnalyzer* _tmp511_;
	ValaSourceFile* _tmp512_;
	ValaSemanticAnalyzer* _tmp513_;
	ValaSemanticAnalyzer* _tmp514_;
	ValaSymbol* _tmp515_;
	gboolean _tmp516_ = FALSE;
	gboolean _tmp517_ = FALSE;
	gboolean _tmp518_ = FALSE;
	gboolean _tmp519_;
	gboolean _tmp520_;
	ValaSemanticAnalyzer* _tmp536_;
	ValaSemanticAnalyzer* _tmp537_;
	ValaDataType* _tmp538_;
	ValaDataType* _tmp539_;
	gboolean _tmp592_ = FALSE;
	ValaBlock* _tmp593_;
	ValaBlock* _tmp594_;
	gboolean _tmp639_ = FALSE;
	gboolean _tmp640_ = FALSE;
	gboolean _tmp641_ = FALSE;
	gboolean _tmp642_ = FALSE;
	gboolean _tmp643_ = FALSE;
	ValaAttribute* _tmp703_;
	gboolean _tmp704_;
	gboolean _tmp705_;
	gboolean result = FALSE;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_this_parameter;
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		_tmp5_ = self->priv->_this_parameter;
		vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	}
	_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp6_ != NULL) {
		ValaParameter* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp7_ = self->priv->_this_parameter;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
	}
	_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp10_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp13_ = _tmp12_;
	if (VALA_IS_CLASS (_tmp13_)) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = self->priv->_is_abstract;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->_is_virtual;
			_tmp14_ = _tmp16_;
		}
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ValaClass* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp18_ = _tmp17_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass);
		_tmp20_ = cl;
		_tmp21_ = vala_class_get_is_compact (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			ValaClass* _tmp25_;
			_tmp23_ = cl;
			_tmp24_ = vala_class_get_base_class (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp19_ = _tmp25_ != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			return result;
		}
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_;
		_tmp30_ = self->priv->_is_abstract;
		if (_tmp30_) {
			_tmp29_ = TRUE;
		} else {
			gboolean _tmp31_;
			_tmp31_ = self->priv->_is_virtual;
			_tmp29_ = _tmp31_;
		}
		_tmp28_ = _tmp29_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		vala_report_error (_tmp33_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...' or params-array.");
		result = FALSE;
		return result;
	}
	_tmp34_ = self->priv->_is_abstract;
	if (_tmp34_) {
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		_tmp35_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp36_ = _tmp35_;
		if (VALA_IS_CLASS (_tmp36_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp37_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp38_ = _tmp37_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_CLASS, ValaClass);
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				return result;
			}
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!VALA_IS_INTERFACE (_tmp45_)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!VALA_IS_CLASS (_tmp51_)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !VALA_IS_INTERFACE (_tmp53_);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!VALA_IS_CLASS (_tmp58_)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!VALA_IS_CLASS (_tmp65_)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !VALA_IS_INTERFACE (_tmp67_);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_;
		_tmp78_ = self->priv->_is_abstract;
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			gboolean _tmp79_;
			_tmp79_ = self->priv->_is_virtual;
			_tmp77_ = _tmp79_;
		}
		if (_tmp77_) {
			gboolean _tmp80_;
			gboolean _tmp81_;
			_tmp80_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp81_ = _tmp80_;
			_tmp76_ = _tmp81_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp82_;
			ValaSourceReference* _tmp83_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp83_ = _tmp82_;
			vala_report_error (_tmp83_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp84_ = FALSE;
			gboolean _tmp85_;
			gboolean _tmp86_;
			_tmp85_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp86_ = _tmp85_;
			if (_tmp86_) {
				ValaBlock* _tmp87_;
				ValaBlock* _tmp88_;
				_tmp87_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp88_ = _tmp87_;
				_tmp84_ = _tmp88_ != NULL;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp90_ = _tmp89_;
				vala_report_error (_tmp90_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_;
				_tmp94_ = self->priv->_is_abstract;
				if (!_tmp94_) {
					gboolean _tmp95_;
					gboolean _tmp96_;
					_tmp95_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp96_ = _tmp95_;
					_tmp93_ = !_tmp96_;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaSourceFileType _tmp97_;
					ValaSourceFileType _tmp98_;
					_tmp97_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp98_ = _tmp97_;
					_tmp92_ = _tmp98_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					ValaBlock* _tmp99_;
					ValaBlock* _tmp100_;
					_tmp99_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp100_ = _tmp99_;
					_tmp91_ = _tmp100_ == NULL;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp102_ = _tmp101_;
					vala_report_error (_tmp102_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp105_ = self->priv->_coroutine;
	if (_tmp105_) {
		gboolean _tmp106_;
		gboolean _tmp107_;
		_tmp106_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp107_ = _tmp106_;
		_tmp104_ = !_tmp107_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		_tmp103_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		ValaSourceReference* _tmp108_;
		ValaSourceReference* _tmp109_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp109_ = _tmp108_;
		vala_report_error (_tmp109_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp110_ = vala_code_context_get_analyzer (context);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_semantic_analyzer_get_current_source_file (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = _vala_source_file_ref0 (_tmp113_);
	old_source_file = _tmp114_;
	_tmp115_ = vala_code_context_get_analyzer (context);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_semantic_analyzer_get_current_symbol (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = _vala_code_node_ref0 (_tmp118_);
	old_symbol = _tmp119_;
	_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp121_ = _tmp120_;
	if (_tmp121_ != NULL) {
		ValaSemanticAnalyzer* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaSourceFile* _tmp126_;
		ValaSourceFile* _tmp127_;
		_tmp122_ = vala_code_context_get_analyzer (context);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_source_reference_get_file (_tmp125_);
		_tmp127_ = _tmp126_;
		vala_semantic_analyzer_set_current_source_file (_tmp123_, _tmp127_);
	}
	_tmp128_ = vala_code_context_get_analyzer (context);
	_tmp129_ = _tmp128_;
	vala_semantic_analyzer_set_current_symbol (_tmp129_, (ValaSymbol*) self);
	_tmp130_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_method_get_returns_floating_reference (self);
	_tmp133_ = _tmp132_;
	vala_data_type_set_floating_reference (_tmp131_, _tmp133_);
	_tmp134_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp135_ = _tmp134_;
	vala_code_node_check ((ValaCodeNode*) _tmp135_, context);
	_tmp136_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp137_ = _tmp136_;
	if (!_tmp137_) {
		ValaSemanticAnalyzer* _tmp138_;
		ValaSemanticAnalyzer* _tmp139_;
		ValaDataType* _tmp140_;
		ValaDataType* _tmp141_;
		_tmp138_ = vala_code_context_get_analyzer (context);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp141_ = _tmp140_;
		vala_semantic_analyzer_check_type (_tmp139_, _tmp141_);
	}
	_tmp142_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp143_ = _tmp142_;
	_tmp144_ = vala_data_type_get_type_symbol (_tmp143_);
	_tmp145_ = _tmp144_;
	_tmp146_ = vala_code_context_get_analyzer (context);
	_tmp147_ = _tmp146_;
	_tmp148_ = _tmp147_->va_list_type;
	_tmp149_ = vala_data_type_get_type_symbol (_tmp148_);
	_tmp150_ = _tmp149_;
	if (_tmp145_ == _tmp150_) {
		ValaSourceReference* _tmp151_;
		ValaSourceReference* _tmp152_;
		ValaDataType* _tmp153_;
		ValaDataType* _tmp154_;
		ValaTypeSymbol* _tmp155_;
		ValaTypeSymbol* _tmp156_;
		gchar* _tmp157_;
		gchar* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp152_ = _tmp151_;
		_tmp153_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_data_type_get_type_symbol (_tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = g_strdup_printf ("`%s' not supported as return type", _tmp158_);
		_tmp160_ = _tmp159_;
		vala_report_error (_tmp152_, _tmp160_);
		_g_free0 (_tmp160_);
		_g_free0 (_tmp158_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp161_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp162_ = _vala_code_node_ref0 (_tmp161_);
	init_attr = _tmp162_;
	_tmp163_ = init_attr;
	if (_tmp163_ != NULL) {
		ValaSourceReference* _tmp164_;
		ValaSourceReference* _tmp165_;
		ValaSourceFile* _tmp166_;
		ValaSourceFile* _tmp167_;
		ValaCodeContext* _tmp168_;
		ValaCodeContext* _tmp169_;
		_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp165_ = _tmp164_;
		_tmp166_ = vala_source_reference_get_file (_tmp165_);
		_tmp167_ = _tmp166_;
		_tmp168_ = vala_source_file_get_context (_tmp167_);
		_tmp169_ = _tmp168_;
		vala_code_context_set_module_init_method (_tmp169_, self);
	}
	_tmp170_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp171_ = _tmp170_;
	if (_tmp171_ != NULL) {
		ValaDataType* _tmp172_;
		ValaDataType* _tmp173_;
		_tmp172_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp173_ = _tmp172_;
		vala_code_node_check ((ValaCodeNode*) _tmp173_, context);
	}
	_tmp177_ = self->priv->parameters;
	_tmp178_ = vala_collection_get_size ((ValaCollection*) _tmp177_);
	_tmp179_ = _tmp178_;
	if (_tmp179_ == 1) {
		ValaList* _tmp180_;
		gpointer _tmp181_;
		ValaParameter* _tmp182_;
		gboolean _tmp183_;
		gboolean _tmp184_;
		_tmp180_ = self->priv->parameters;
		_tmp181_ = vala_list_get (_tmp180_, 0);
		_tmp182_ = (ValaParameter*) _tmp181_;
		_tmp183_ = vala_parameter_get_ellipsis (_tmp182_);
		_tmp184_ = _tmp183_;
		_tmp176_ = _tmp184_;
		_vala_code_node_unref0 (_tmp182_);
	} else {
		_tmp176_ = FALSE;
	}
	if (_tmp176_) {
		ValaBlock* _tmp185_;
		ValaBlock* _tmp186_;
		_tmp185_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp186_ = _tmp185_;
		_tmp175_ = _tmp186_ != NULL;
	} else {
		_tmp175_ = FALSE;
	}
	if (_tmp175_) {
		ValaMemberBinding _tmp187_;
		_tmp187_ = self->priv->_binding;
		_tmp174_ = _tmp187_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp174_ = FALSE;
	}
	if (_tmp174_) {
		ValaList* _tmp188_;
		gpointer _tmp189_;
		ValaParameter* _tmp190_;
		ValaSourceReference* _tmp191_;
		ValaSourceReference* _tmp192_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp188_ = self->priv->parameters;
		_tmp189_ = vala_list_get (_tmp188_, 0);
		_tmp190_ = (ValaParameter*) _tmp189_;
		_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
		_tmp192_ = _tmp191_;
		vala_report_error (_tmp192_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp190_);
	}
	_tmp194_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Print");
	if (_tmp194_ != NULL) {
		gboolean _tmp195_ = FALSE;
		ValaList* _tmp196_;
		gint _tmp197_;
		gint _tmp198_;
		_tmp196_ = self->priv->parameters;
		_tmp197_ = vala_collection_get_size ((ValaCollection*) _tmp196_);
		_tmp198_ = _tmp197_;
		if (_tmp198_ != 1) {
			_tmp195_ = TRUE;
		} else {
			ValaList* _tmp199_;
			gpointer _tmp200_;
			ValaParameter* _tmp201_;
			ValaDataType* _tmp202_;
			ValaDataType* _tmp203_;
			ValaTypeSymbol* _tmp204_;
			ValaTypeSymbol* _tmp205_;
			ValaSemanticAnalyzer* _tmp206_;
			ValaSemanticAnalyzer* _tmp207_;
			ValaDataType* _tmp208_;
			ValaTypeSymbol* _tmp209_;
			ValaTypeSymbol* _tmp210_;
			_tmp199_ = self->priv->parameters;
			_tmp200_ = vala_list_get (_tmp199_, 0);
			_tmp201_ = (ValaParameter*) _tmp200_;
			_tmp202_ = vala_variable_get_variable_type ((ValaVariable*) _tmp201_);
			_tmp203_ = _tmp202_;
			_tmp204_ = vala_data_type_get_type_symbol (_tmp203_);
			_tmp205_ = _tmp204_;
			_tmp206_ = vala_code_context_get_analyzer (context);
			_tmp207_ = _tmp206_;
			_tmp208_ = _tmp207_->string_type;
			_tmp209_ = vala_data_type_get_type_symbol (_tmp208_);
			_tmp210_ = _tmp209_;
			_tmp195_ = _tmp205_ != _tmp210_;
			_vala_code_node_unref0 (_tmp201_);
		}
		_tmp193_ = _tmp195_;
	} else {
		_tmp193_ = FALSE;
	}
	if (_tmp193_) {
		ValaSourceReference* _tmp211_;
		ValaSourceReference* _tmp212_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp212_ = _tmp211_;
		vala_report_error (_tmp212_, "[Print] methods must have exactly one parameter of type `string'");
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp213_;
		ValaList* _tmp214_;
		gint _param_size = 0;
		ValaList* _tmp215_;
		gint _tmp216_;
		gint _tmp217_;
		gint _param_index = 0;
		_tmp213_ = self->priv->parameters;
		_tmp214_ = _vala_iterable_ref0 (_tmp213_);
		_param_list = _tmp214_;
		_tmp215_ = _param_list;
		_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
		_tmp217_ = _tmp216_;
		_param_size = _tmp217_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp218_;
			gint _tmp219_;
			ValaParameter* param = NULL;
			ValaList* _tmp220_;
			gpointer _tmp221_;
			ValaParameter* _tmp222_;
			gboolean _tmp223_ = FALSE;
			gboolean _tmp224_;
			gboolean _tmp231_ = FALSE;
			gboolean _tmp232_ = FALSE;
			gboolean _tmp233_;
			gboolean _tmp234_;
			gboolean _tmp257_;
			gboolean _tmp258_ = FALSE;
			gboolean _tmp259_ = FALSE;
			gboolean _tmp272_ = FALSE;
			ValaParameter* _tmp273_;
			gboolean _tmp274_;
			gboolean _tmp275_;
			_param_index = _param_index + 1;
			_tmp218_ = _param_index;
			_tmp219_ = _param_size;
			if (!(_tmp218_ < _tmp219_)) {
				break;
			}
			_tmp220_ = _param_list;
			_tmp221_ = vala_list_get (_tmp220_, _param_index);
			param = (ValaParameter*) _tmp221_;
			_tmp222_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp222_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp224_ = self->priv->_coroutine;
			if (_tmp224_) {
				ValaParameter* _tmp225_;
				ValaParameterDirection _tmp226_;
				ValaParameterDirection _tmp227_;
				_tmp225_ = param;
				_tmp226_ = vala_parameter_get_direction (_tmp225_);
				_tmp227_ = _tmp226_;
				_tmp223_ = _tmp227_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp223_ = FALSE;
			}
			if (_tmp223_) {
				ValaParameter* _tmp228_;
				ValaSourceReference* _tmp229_;
				ValaSourceReference* _tmp230_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp228_ = param;
				_tmp229_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp228_);
				_tmp230_ = _tmp229_;
				vala_report_error (_tmp230_, "Reference parameters are not supported for async methods");
			}
			_tmp233_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp234_ = _tmp233_;
			if (!_tmp234_) {
				gboolean _tmp235_;
				_tmp235_ = self->priv->_coroutine;
				_tmp232_ = _tmp235_;
			} else {
				_tmp232_ = FALSE;
			}
			if (_tmp232_) {
				gboolean _tmp236_ = FALSE;
				gboolean _tmp237_ = FALSE;
				ValaParameter* _tmp238_;
				gboolean _tmp239_;
				gboolean _tmp240_;
				_tmp238_ = param;
				_tmp239_ = vala_parameter_get_ellipsis (_tmp238_);
				_tmp240_ = _tmp239_;
				if (_tmp240_) {
					_tmp237_ = TRUE;
				} else {
					ValaParameter* _tmp241_;
					gboolean _tmp242_;
					gboolean _tmp243_;
					_tmp241_ = param;
					_tmp242_ = vala_parameter_get_params_array (_tmp241_);
					_tmp243_ = _tmp242_;
					_tmp237_ = _tmp243_;
				}
				if (_tmp237_) {
					_tmp236_ = TRUE;
				} else {
					ValaParameter* _tmp244_;
					ValaDataType* _tmp245_;
					ValaDataType* _tmp246_;
					ValaTypeSymbol* _tmp247_;
					ValaTypeSymbol* _tmp248_;
					ValaSemanticAnalyzer* _tmp249_;
					ValaSemanticAnalyzer* _tmp250_;
					ValaDataType* _tmp251_;
					ValaTypeSymbol* _tmp252_;
					ValaTypeSymbol* _tmp253_;
					_tmp244_ = param;
					_tmp245_ = vala_variable_get_variable_type ((ValaVariable*) _tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_data_type_get_type_symbol (_tmp246_);
					_tmp248_ = _tmp247_;
					_tmp249_ = vala_code_context_get_analyzer (context);
					_tmp250_ = _tmp249_;
					_tmp251_ = _tmp250_->va_list_type;
					_tmp252_ = vala_data_type_get_type_symbol (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp236_ = _tmp248_ == _tmp253_;
				}
				_tmp231_ = _tmp236_;
			} else {
				_tmp231_ = FALSE;
			}
			if (_tmp231_) {
				ValaParameter* _tmp254_;
				ValaSourceReference* _tmp255_;
				ValaSourceReference* _tmp256_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp254_ = param;
				_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp254_);
				_tmp256_ = _tmp255_;
				vala_report_error (_tmp256_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp257_ = self->priv->_coroutine;
			if (_tmp257_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp260_;
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				_tmp260_ = param;
				_tmp261_ = vala_variable_get_initializer ((ValaVariable*) _tmp260_);
				_tmp262_ = _tmp261_;
				_tmp259_ = _tmp262_ == NULL;
			} else {
				_tmp259_ = FALSE;
			}
			if (_tmp259_) {
				ValaParameter* _tmp263_;
				gboolean _tmp264_;
				gboolean _tmp265_;
				_tmp263_ = param;
				_tmp264_ = vala_parameter_get_ellipsis (_tmp263_);
				_tmp265_ = _tmp264_;
				_tmp258_ = !_tmp265_;
			} else {
				_tmp258_ = FALSE;
			}
			if (_tmp258_) {
				ValaParameter* _tmp266_;
				ValaSourceReference* _tmp267_;
				ValaSourceReference* _tmp268_;
				_tmp266_ = param;
				_tmp267_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp266_);
				_tmp268_ = _tmp267_;
				vala_report_warning (_tmp268_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp269_;
				ValaExpression* _tmp270_;
				ValaExpression* _tmp271_;
				_tmp269_ = param;
				_tmp270_ = vala_variable_get_initializer ((ValaVariable*) _tmp269_);
				_tmp271_ = _tmp270_;
				if (_tmp271_ != NULL) {
					optional_param = TRUE;
				}
			}
			_tmp273_ = param;
			_tmp274_ = vala_parameter_get_params_array (_tmp273_);
			_tmp275_ = _tmp274_;
			if (_tmp275_) {
				ValaBlock* _tmp276_;
				ValaBlock* _tmp277_;
				_tmp276_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp277_ = _tmp276_;
				_tmp272_ = _tmp277_ != NULL;
			} else {
				_tmp272_ = FALSE;
			}
			if (_tmp272_) {
				ValaLocalVariable* _tmp278_;
				gboolean _tmp282_;
				gboolean _tmp283_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp287_;
				ValaDataType* _tmp288_;
				ValaDataType* _tmp289_;
				ValaDataType* _tmp290_;
				ValaArrayType* _tmp291_;
				ValaDataType* _tmp292_;
				ValaDataType* _tmp293_;
				ValaArrayType* _tmp294_;
				gboolean _tmp295_;
				gboolean _tmp296_;
				ValaArrayType* _tmp297_;
				gboolean _tmp298_ = FALSE;
				ValaArrayType* _tmp299_;
				ValaDataType* _tmp300_;
				ValaDataType* _tmp301_;
				ValaArrayType* _tmp310_;
				ValaExpression* _tmp311_;
				ValaExpression* _tmp312_;
				ValaArrayType* _tmp316_;
				ValaParameter* _tmp317_;
				const gchar* _tmp318_;
				const gchar* _tmp319_;
				ValaParameter* _tmp320_;
				ValaSourceReference* _tmp321_;
				ValaSourceReference* _tmp322_;
				ValaLocalVariable* _tmp323_;
				ValaLocalVariable* _tmp324_;
				ValaBlock* _tmp325_;
				ValaBlock* _tmp326_;
				ValaLocalVariable* _tmp327_;
				ValaParameter* _tmp328_;
				ValaSourceReference* _tmp329_;
				ValaSourceReference* _tmp330_;
				ValaDeclarationStatement* _tmp331_;
				ValaDeclarationStatement* _tmp332_;
				_tmp278_ = self->priv->_params_array_var;
				if (_tmp278_ != NULL) {
					ValaParameter* _tmp279_;
					ValaSourceReference* _tmp280_;
					ValaSourceReference* _tmp281_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp279_ = param;
					_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp279_);
					_tmp281_ = _tmp280_;
					vala_report_error (_tmp281_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp282_ = vala_code_context_get_experimental (context);
				_tmp283_ = _tmp282_;
				if (!_tmp283_) {
					ValaParameter* _tmp284_;
					ValaSourceReference* _tmp285_;
					ValaSourceReference* _tmp286_;
					_tmp284_ = param;
					_tmp285_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp284_);
					_tmp286_ = _tmp285_;
					vala_report_warning (_tmp286_, "Support of params-arrays is experimental");
				}
				_tmp287_ = param;
				_tmp288_ = vala_variable_get_variable_type ((ValaVariable*) _tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = vala_data_type_copy (_tmp289_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp290_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp291_ = type;
				_tmp292_ = vala_array_type_get_element_type (_tmp291_);
				_tmp293_ = _tmp292_;
				_tmp294_ = type;
				_tmp295_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp294_);
				_tmp296_ = _tmp295_;
				vala_data_type_set_value_owned (_tmp293_, _tmp296_);
				_tmp297_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp297_, TRUE);
				_tmp299_ = type;
				_tmp300_ = vala_array_type_get_element_type (_tmp299_);
				_tmp301_ = _tmp300_;
				if (vala_data_type_is_real_struct_type (_tmp301_)) {
					ValaArrayType* _tmp302_;
					ValaDataType* _tmp303_;
					ValaDataType* _tmp304_;
					gboolean _tmp305_;
					gboolean _tmp306_;
					_tmp302_ = type;
					_tmp303_ = vala_array_type_get_element_type (_tmp302_);
					_tmp304_ = _tmp303_;
					_tmp305_ = vala_data_type_get_nullable (_tmp304_);
					_tmp306_ = _tmp305_;
					_tmp298_ = !_tmp306_;
				} else {
					_tmp298_ = FALSE;
				}
				if (_tmp298_) {
					ValaParameter* _tmp307_;
					ValaSourceReference* _tmp308_;
					ValaSourceReference* _tmp309_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp307_ = param;
					_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp307_);
					_tmp309_ = _tmp308_;
					vala_report_error (_tmp309_, "Only nullable struct elements are supported in params-array");
				}
				_tmp310_ = type;
				_tmp311_ = vala_array_type_get_length (_tmp310_);
				_tmp312_ = _tmp311_;
				if (_tmp312_ != NULL) {
					ValaParameter* _tmp313_;
					ValaSourceReference* _tmp314_;
					ValaSourceReference* _tmp315_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp313_ = param;
					_tmp314_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp313_);
					_tmp315_ = _tmp314_;
					vala_report_error (_tmp315_, "Passing length to params-array is not supported yet");
				}
				_tmp316_ = type;
				_tmp317_ = param;
				_tmp318_ = vala_symbol_get_name ((ValaSymbol*) _tmp317_);
				_tmp319_ = _tmp318_;
				_tmp320_ = param;
				_tmp321_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp320_);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_local_variable_new ((ValaDataType*) _tmp316_, _tmp319_, NULL, _tmp322_);
				_tmp324_ = _tmp323_;
				vala_method_set_params_array_var (self, _tmp324_);
				_vala_code_node_unref0 (_tmp324_);
				_tmp325_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp326_ = _tmp325_;
				_tmp327_ = self->priv->_params_array_var;
				_tmp328_ = param;
				_tmp329_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp328_);
				_tmp330_ = _tmp329_;
				_tmp331_ = vala_declaration_statement_new ((ValaSymbol*) _tmp327_, _tmp330_);
				_tmp332_ = _tmp331_;
				vala_block_insert_statement (_tmp326_, 0, (ValaStatement*) _tmp332_);
				_vala_code_node_unref0 (_tmp332_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp333_ = self->priv->_coroutine;
	if (_tmp333_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp334_;
			gint _tmp335_;
			gint _tmp336_;
			_tmp334_ = self->priv->parameters;
			_tmp335_ = vala_collection_get_size ((ValaCollection*) _tmp334_);
			_tmp336_ = _tmp335_;
			i = _tmp336_ - 1;
			{
				gboolean _tmp337_ = FALSE;
				_tmp337_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp339_;
					gpointer _tmp340_;
					ValaParameter* _tmp341_;
					ValaParameterDirection _tmp342_;
					ValaParameterDirection _tmp343_;
					if (!_tmp337_) {
						gint _tmp338_;
						_tmp338_ = i;
						i = _tmp338_ - 1;
					}
					_tmp337_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp339_ = self->priv->parameters;
					_tmp340_ = vala_list_get (_tmp339_, i);
					param = (ValaParameter*) _tmp340_;
					_tmp341_ = param;
					_tmp342_ = vala_parameter_get_direction (_tmp341_);
					_tmp343_ = _tmp342_;
					if (_tmp343_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp344_;
							ValaSourceReference* _tmp345_;
							ValaSourceReference* _tmp346_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp344_ = param;
							_tmp345_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp344_);
							_tmp346_ = _tmp345_;
							vala_report_error (_tmp346_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp347_ = self->error_types;
	if (_tmp347_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp348_;
			ValaList* _tmp349_;
			gint _error_type_size = 0;
			ValaList* _tmp350_;
			gint _tmp351_;
			gint _tmp352_;
			gint _error_type_index = 0;
			_tmp348_ = self->error_types;
			_tmp349_ = _vala_iterable_ref0 (_tmp348_);
			_error_type_list = _tmp349_;
			_tmp350_ = _error_type_list;
			_tmp351_ = vala_collection_get_size ((ValaCollection*) _tmp350_);
			_tmp352_ = _tmp351_;
			_error_type_size = _tmp352_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp353_;
				gint _tmp354_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp355_;
				gpointer _tmp356_;
				ValaDataType* _tmp357_;
				ValaSemanticAnalyzer* _tmp358_;
				ValaSemanticAnalyzer* _tmp359_;
				ValaDataType* _tmp360_;
				_error_type_index = _error_type_index + 1;
				_tmp353_ = _error_type_index;
				_tmp354_ = _error_type_size;
				if (!(_tmp353_ < _tmp354_)) {
					break;
				}
				_tmp355_ = _error_type_list;
				_tmp356_ = vala_list_get (_tmp355_, _error_type_index);
				error_type = (ValaDataType*) _tmp356_;
				_tmp357_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp357_, context);
				_tmp358_ = vala_code_context_get_analyzer (context);
				_tmp359_ = _tmp358_;
				_tmp360_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp359_, (ValaSymbol*) self, _tmp360_)) {
					ValaSourceReference* _tmp361_;
					ValaSourceReference* _tmp362_;
					ValaDataType* _tmp363_;
					gchar* _tmp364_;
					gchar* _tmp365_;
					gchar* _tmp366_;
					gchar* _tmp367_;
					gchar* _tmp368_;
					gchar* _tmp369_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp361_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp362_ = _tmp361_;
					_tmp363_ = error_type;
					_tmp364_ = vala_code_node_to_string ((ValaCodeNode*) _tmp363_);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp367_ = _tmp366_;
					_tmp368_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp365_, _tmp367_);
					_tmp369_ = _tmp368_;
					vala_report_error (_tmp362_, _tmp369_);
					_g_free0 (_tmp369_);
					_g_free0 (_tmp367_);
					_g_free0 (_tmp365_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp370_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp371_ = _tmp370_;
	if (_tmp371_ != NULL) {
		ValaLocalVariable* _tmp372_;
		ValaLocalVariable* _tmp373_;
		_tmp372_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp373_ = _tmp372_;
		vala_code_node_check ((ValaCodeNode*) _tmp373_, context);
	}
	_tmp374_ = self->priv->preconditions;
	if (_tmp374_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp375_;
			ValaList* _tmp376_;
			gint _precondition_size = 0;
			ValaList* _tmp377_;
			gint _tmp378_;
			gint _tmp379_;
			gint _precondition_index = 0;
			_tmp375_ = self->priv->preconditions;
			_tmp376_ = _vala_iterable_ref0 (_tmp375_);
			_precondition_list = _tmp376_;
			_tmp377_ = _precondition_list;
			_tmp378_ = vala_collection_get_size ((ValaCollection*) _tmp377_);
			_tmp379_ = _tmp378_;
			_precondition_size = _tmp379_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp380_;
				gint _tmp381_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp382_;
				gpointer _tmp383_;
				ValaExpression* _tmp384_;
				_precondition_index = _precondition_index + 1;
				_tmp380_ = _precondition_index;
				_tmp381_ = _precondition_size;
				if (!(_tmp380_ < _tmp381_)) {
					break;
				}
				_tmp382_ = _precondition_list;
				_tmp383_ = vala_list_get (_tmp382_, _precondition_index);
				precondition = (ValaExpression*) _tmp383_;
				_tmp384_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp384_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp385_ = self->priv->postconditions;
	if (_tmp385_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp386_;
			ValaList* _tmp387_;
			gint _postcondition_size = 0;
			ValaList* _tmp388_;
			gint _tmp389_;
			gint _tmp390_;
			gint _postcondition_index = 0;
			_tmp386_ = self->priv->postconditions;
			_tmp387_ = _vala_iterable_ref0 (_tmp386_);
			_postcondition_list = _tmp387_;
			_tmp388_ = _postcondition_list;
			_tmp389_ = vala_collection_get_size ((ValaCollection*) _tmp388_);
			_tmp390_ = _tmp389_;
			_postcondition_size = _tmp390_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp391_;
				gint _tmp392_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp393_;
				gpointer _tmp394_;
				ValaExpression* _tmp395_;
				_postcondition_index = _postcondition_index + 1;
				_tmp391_ = _postcondition_index;
				_tmp392_ = _postcondition_size;
				if (!(_tmp391_ < _tmp392_)) {
					break;
				}
				_tmp393_ = _postcondition_list;
				_tmp394_ = vala_list_get (_tmp393_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp394_;
				_tmp395_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp395_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp396_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp397_ = _tmp396_;
	if (_tmp397_ != NULL) {
		ValaBlock* _tmp398_;
		ValaBlock* _tmp399_;
		_tmp398_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp399_ = _tmp398_;
		vala_code_node_check ((ValaCodeNode*) _tmp399_, context);
	}
	_tmp400_ = vala_code_context_get_analyzer (context);
	_tmp401_ = _tmp400_;
	_tmp402_ = vala_semantic_analyzer_get_current_struct (_tmp401_);
	_tmp403_ = _tmp402_;
	if (_tmp403_ != NULL) {
		gboolean _tmp404_ = FALSE;
		gboolean _tmp405_ = FALSE;
		gboolean _tmp406_;
		_tmp406_ = self->priv->_is_abstract;
		if (_tmp406_) {
			_tmp405_ = TRUE;
		} else {
			gboolean _tmp407_;
			_tmp407_ = self->priv->_is_virtual;
			_tmp405_ = _tmp407_;
		}
		if (_tmp405_) {
			_tmp404_ = TRUE;
		} else {
			gboolean _tmp408_;
			_tmp408_ = self->priv->_overrides;
			_tmp404_ = _tmp408_;
		}
		if (_tmp404_) {
			ValaSourceReference* _tmp409_;
			ValaSourceReference* _tmp410_;
			gchar* _tmp411_;
			gchar* _tmp412_;
			gchar* _tmp413_;
			gchar* _tmp414_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp409_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp410_ = _tmp409_;
			_tmp411_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp412_ = _tmp411_;
			_tmp413_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp412_);
			_tmp414_ = _tmp413_;
			vala_report_error (_tmp410_, _tmp414_);
			_g_free0 (_tmp414_);
			_g_free0 (_tmp412_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp415_ = FALSE;
		gboolean _tmp416_ = FALSE;
		gboolean _tmp417_ = FALSE;
		gboolean _tmp418_;
		_tmp418_ = self->priv->_overrides;
		if (_tmp418_) {
			ValaMethod* _tmp419_;
			ValaMethod* _tmp420_;
			_tmp419_ = vala_method_get_base_method (self);
			_tmp420_ = _tmp419_;
			_tmp417_ = _tmp420_ == NULL;
		} else {
			_tmp417_ = FALSE;
		}
		if (_tmp417_) {
			ValaMethod* _tmp421_;
			ValaMethod* _tmp422_;
			_tmp421_ = vala_method_get_base_interface_method (self);
			_tmp422_ = _tmp421_;
			_tmp416_ = _tmp422_ != NULL;
		} else {
			_tmp416_ = FALSE;
		}
		if (_tmp416_) {
			ValaMethod* _tmp423_;
			ValaMethod* _tmp424_;
			gboolean _tmp425_;
			_tmp423_ = vala_method_get_base_interface_method (self);
			_tmp424_ = _tmp423_;
			_tmp425_ = _tmp424_->priv->_is_abstract;
			_tmp415_ = _tmp425_;
		} else {
			_tmp415_ = FALSE;
		}
		if (_tmp415_) {
			ValaSourceReference* _tmp426_;
			ValaSourceReference* _tmp427_;
			ValaMethod* _tmp428_;
			ValaMethod* _tmp429_;
			gchar* _tmp430_;
			gchar* _tmp431_;
			gchar* _tmp432_;
			gchar* _tmp433_;
			_tmp426_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp427_ = _tmp426_;
			_tmp428_ = vala_method_get_base_interface_method (self);
			_tmp429_ = _tmp428_;
			_tmp430_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp429_);
			_tmp431_ = _tmp430_;
			_tmp432_ = g_strdup_printf ("`override' not required to implement `abstract' interface method `%s'", _tmp431_);
			_tmp433_ = _tmp432_;
			vala_report_warning (_tmp427_, _tmp433_);
			_g_free0 (_tmp433_);
			_g_free0 (_tmp431_);
			vala_method_set_overrides (self, FALSE);
		} else {
			gboolean _tmp434_ = FALSE;
			gboolean _tmp435_ = FALSE;
			gboolean _tmp436_;
			_tmp436_ = self->priv->_overrides;
			if (_tmp436_) {
				ValaMethod* _tmp437_;
				ValaMethod* _tmp438_;
				_tmp437_ = vala_method_get_base_method (self);
				_tmp438_ = _tmp437_;
				_tmp435_ = _tmp438_ == NULL;
			} else {
				_tmp435_ = FALSE;
			}
			if (_tmp435_) {
				ValaMethod* _tmp439_;
				ValaMethod* _tmp440_;
				_tmp439_ = vala_method_get_base_interface_method (self);
				_tmp440_ = _tmp439_;
				_tmp434_ = _tmp440_ == NULL;
			} else {
				_tmp434_ = FALSE;
			}
			if (_tmp434_) {
				ValaSourceReference* _tmp441_;
				ValaSourceReference* _tmp442_;
				gchar* _tmp443_;
				gchar* _tmp444_;
				gchar* _tmp445_;
				gchar* _tmp446_;
				_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp442_ = _tmp441_;
				_tmp443_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp444_ = _tmp443_;
				_tmp445_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp444_);
				_tmp446_ = _tmp445_;
				vala_report_error (_tmp442_, _tmp446_);
				_g_free0 (_tmp446_);
				_g_free0 (_tmp444_);
			} else {
				gboolean _tmp447_ = FALSE;
				gboolean _tmp448_ = FALSE;
				gboolean _tmp449_ = FALSE;
				gboolean _tmp450_;
				_tmp450_ = self->priv->_is_abstract;
				if (_tmp450_) {
					_tmp449_ = TRUE;
				} else {
					gboolean _tmp451_;
					_tmp451_ = self->priv->_is_virtual;
					_tmp449_ = _tmp451_;
				}
				if (_tmp449_) {
					_tmp448_ = TRUE;
				} else {
					gboolean _tmp452_;
					_tmp452_ = self->priv->_overrides;
					_tmp448_ = _tmp452_;
				}
				if (_tmp448_) {
					ValaSymbolAccessibility _tmp453_;
					ValaSymbolAccessibility _tmp454_;
					_tmp453_ = vala_symbol_get_access ((ValaSymbol*) self);
					_tmp454_ = _tmp453_;
					_tmp447_ = _tmp454_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp447_ = FALSE;
				}
				if (_tmp447_) {
					ValaSourceReference* _tmp455_;
					ValaSourceReference* _tmp456_;
					gchar* _tmp457_;
					gchar* _tmp458_;
					gchar* _tmp459_;
					gchar* _tmp460_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp455_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp456_ = _tmp455_;
					_tmp457_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp458_ = _tmp457_;
					_tmp459_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp458_);
					_tmp460_ = _tmp459_;
					vala_report_error (_tmp456_, _tmp460_);
					_g_free0 (_tmp460_);
					_g_free0 (_tmp458_);
					result = FALSE;
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
		}
	}
	_tmp463_ = vala_method_get_base_interface_type (self);
	_tmp464_ = _tmp463_;
	if (_tmp464_ != NULL) {
		ValaMethod* _tmp465_;
		ValaMethod* _tmp466_;
		_tmp465_ = vala_method_get_base_interface_method (self);
		_tmp466_ = _tmp465_;
		_tmp462_ = _tmp466_ != NULL;
	} else {
		_tmp462_ = FALSE;
	}
	if (_tmp462_) {
		ValaSymbol* _tmp467_;
		ValaSymbol* _tmp468_;
		_tmp467_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp468_ = _tmp467_;
		_tmp461_ = VALA_IS_CLASS (_tmp468_);
	} else {
		_tmp461_ = FALSE;
	}
	if (_tmp461_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp469_;
		ValaSymbol* _tmp470_;
		_tmp469_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp470_ = _tmp469_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp470_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp471_;
			ValaList* _tmp472_;
			ValaList* _tmp473_;
			gint _m_size = 0;
			ValaList* _tmp474_;
			gint _tmp475_;
			gint _tmp476_;
			gint _m_index = 0;
			_tmp471_ = cl;
			_tmp472_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp471_);
			_tmp473_ = _vala_iterable_ref0 (_tmp472_);
			_m_list = _tmp473_;
			_tmp474_ = _m_list;
			_tmp475_ = vala_collection_get_size ((ValaCollection*) _tmp474_);
			_tmp476_ = _tmp475_;
			_m_size = _tmp476_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp477_;
				gint _tmp478_;
				ValaMethod* m = NULL;
				ValaList* _tmp479_;
				gpointer _tmp480_;
				gboolean _tmp481_ = FALSE;
				ValaMethod* _tmp482_;
				_m_index = _m_index + 1;
				_tmp477_ = _m_index;
				_tmp478_ = _m_size;
				if (!(_tmp477_ < _tmp478_)) {
					break;
				}
				_tmp479_ = _m_list;
				_tmp480_ = vala_list_get (_tmp479_, _m_index);
				m = (ValaMethod*) _tmp480_;
				_tmp482_ = m;
				if (_tmp482_ != self) {
					ValaMethod* _tmp483_;
					ValaMethod* _tmp484_;
					ValaMethod* _tmp485_;
					ValaMethod* _tmp486_;
					ValaMethod* _tmp487_;
					_tmp483_ = m;
					_tmp484_ = vala_method_get_base_interface_method (_tmp483_);
					_tmp485_ = _tmp484_;
					_tmp486_ = vala_method_get_base_interface_method (self);
					_tmp487_ = _tmp486_;
					_tmp481_ = _tmp485_ == _tmp487_;
				} else {
					_tmp481_ = FALSE;
				}
				if (_tmp481_) {
					ValaMethod* _tmp488_;
					ValaMethod* _tmp489_;
					ValaSourceReference* _tmp490_;
					ValaSourceReference* _tmp491_;
					ValaClass* _tmp492_;
					gchar* _tmp493_;
					gchar* _tmp494_;
					ValaMethod* _tmp495_;
					ValaMethod* _tmp496_;
					gchar* _tmp497_;
					gchar* _tmp498_;
					gchar* _tmp499_;
					gchar* _tmp500_;
					ValaMethod* _tmp501_;
					ValaSourceReference* _tmp502_;
					ValaSourceReference* _tmp503_;
					ValaMethod* _tmp504_;
					ValaMethod* _tmp505_;
					gchar* _tmp506_;
					gchar* _tmp507_;
					gchar* _tmp508_;
					gchar* _tmp509_;
					_tmp488_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp488_, TRUE);
					_tmp489_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp489_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp490_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp491_ = _tmp490_;
					_tmp492_ = cl;
					_tmp493_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp492_);
					_tmp494_ = _tmp493_;
					_tmp495_ = vala_method_get_base_interface_method (self);
					_tmp496_ = _tmp495_;
					_tmp497_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp494_, _tmp498_);
					_tmp500_ = _tmp499_;
					vala_report_error (_tmp491_, _tmp500_);
					_g_free0 (_tmp500_);
					_g_free0 (_tmp498_);
					_g_free0 (_tmp494_);
					_tmp501_ = m;
					_tmp502_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp501_);
					_tmp503_ = _tmp502_;
					_tmp504_ = vala_method_get_base_interface_method (self);
					_tmp505_ = _tmp504_;
					_tmp506_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp505_);
					_tmp507_ = _tmp506_;
					_tmp508_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp507_);
					_tmp509_ = _tmp508_;
					vala_report_notice (_tmp503_, _tmp509_);
					_g_free0 (_tmp509_);
					_g_free0 (_tmp507_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
	}
	_tmp510_ = vala_code_context_get_analyzer (context);
	_tmp511_ = _tmp510_;
	_tmp512_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp511_, _tmp512_);
	_tmp513_ = vala_code_context_get_analyzer (context);
	_tmp514_ = _tmp513_;
	_tmp515_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp514_, _tmp515_);
	_tmp519_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp520_ = _tmp519_;
	if (!_tmp520_) {
		gboolean _tmp521_;
		_tmp521_ = self->priv->_overrides;
		_tmp518_ = !_tmp521_;
	} else {
		_tmp518_ = FALSE;
	}
	if (_tmp518_) {
		gboolean _tmp522_;
		gboolean _tmp523_;
		_tmp522_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp523_ = _tmp522_;
		_tmp517_ = !_tmp523_;
	} else {
		_tmp517_ = FALSE;
	}
	if (_tmp517_) {
		ValaSymbol* _tmp524_;
		ValaSymbol* _tmp525_;
		_tmp524_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp525_ = _tmp524_;
		_tmp516_ = _tmp525_ != NULL;
		_vala_code_node_unref0 (_tmp525_);
	} else {
		_tmp516_ = FALSE;
	}
	if (_tmp516_) {
		ValaSourceReference* _tmp526_;
		ValaSourceReference* _tmp527_;
		gchar* _tmp528_;
		gchar* _tmp529_;
		ValaSymbol* _tmp530_;
		ValaSymbol* _tmp531_;
		gchar* _tmp532_;
		gchar* _tmp533_;
		gchar* _tmp534_;
		gchar* _tmp535_;
		_tmp526_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp527_ = _tmp526_;
		_tmp528_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp529_ = _tmp528_;
		_tmp530_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp531_ = _tmp530_;
		_tmp532_ = vala_symbol_get_full_name (_tmp531_);
		_tmp533_ = _tmp532_;
		_tmp534_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp529_, _tmp533_);
		_tmp535_ = _tmp534_;
		vala_report_warning (_tmp527_, _tmp535_);
		_g_free0 (_tmp535_);
		_g_free0 (_tmp533_);
		_vala_code_node_unref0 (_tmp531_);
		_g_free0 (_tmp529_);
	}
	_tmp536_ = vala_code_context_get_analyzer (context);
	_tmp537_ = _tmp536_;
	_tmp538_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp539_ = _tmp538_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp537_, (ValaSymbol*) self, _tmp539_)) {
		ValaSourceReference* _tmp540_;
		ValaSourceReference* _tmp541_;
		ValaDataType* _tmp542_;
		ValaDataType* _tmp543_;
		gchar* _tmp544_;
		gchar* _tmp545_;
		gchar* _tmp546_;
		gchar* _tmp547_;
		gchar* _tmp548_;
		gchar* _tmp549_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp540_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp541_ = _tmp540_;
		_tmp542_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp543_ = _tmp542_;
		_tmp544_ = vala_code_node_to_string ((ValaCodeNode*) _tmp543_);
		_tmp545_ = _tmp544_;
		_tmp546_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp547_ = _tmp546_;
		_tmp548_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp545_, _tmp547_);
		_tmp549_ = _tmp548_;
		vala_report_error (_tmp541_, _tmp549_);
		_g_free0 (_tmp549_);
		_g_free0 (_tmp547_);
		_g_free0 (_tmp545_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp550_;
		ValaList* _tmp551_;
		gint _precondition_size = 0;
		ValaList* _tmp552_;
		gint _tmp553_;
		gint _tmp554_;
		gint _precondition_index = 0;
		_tmp550_ = vala_method_get_preconditions (self);
		_tmp551_ = _vala_iterable_ref0 (_tmp550_);
		_precondition_list = _tmp551_;
		_tmp552_ = _precondition_list;
		_tmp553_ = vala_collection_get_size ((ValaCollection*) _tmp552_);
		_tmp554_ = _tmp553_;
		_precondition_size = _tmp554_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp555_;
			gint _tmp556_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp557_;
			gpointer _tmp558_;
			ValaExpression* _tmp559_;
			gboolean _tmp560_;
			gboolean _tmp561_;
			ValaExpression* _tmp562_;
			ValaDataType* _tmp563_;
			ValaDataType* _tmp564_;
			ValaSemanticAnalyzer* _tmp565_;
			ValaSemanticAnalyzer* _tmp566_;
			ValaDataType* _tmp567_;
			_precondition_index = _precondition_index + 1;
			_tmp555_ = _precondition_index;
			_tmp556_ = _precondition_size;
			if (!(_tmp555_ < _tmp556_)) {
				break;
			}
			_tmp557_ = _precondition_list;
			_tmp558_ = vala_list_get (_tmp557_, _precondition_index);
			precondition = (ValaExpression*) _tmp558_;
			_tmp559_ = precondition;
			_tmp560_ = vala_code_node_get_error ((ValaCodeNode*) _tmp559_);
			_tmp561_ = _tmp560_;
			if (_tmp561_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp562_ = precondition;
			_tmp563_ = vala_expression_get_value_type (_tmp562_);
			_tmp564_ = _tmp563_;
			_tmp565_ = vala_code_context_get_analyzer (context);
			_tmp566_ = _tmp565_;
			_tmp567_ = _tmp566_->bool_type;
			if (!vala_data_type_compatible (_tmp564_, _tmp567_)) {
				ValaExpression* _tmp568_;
				ValaSourceReference* _tmp569_;
				ValaSourceReference* _tmp570_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp568_ = precondition;
				_tmp569_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp568_);
				_tmp570_ = _tmp569_;
				vala_report_error (_tmp570_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp571_;
		ValaList* _tmp572_;
		gint _postcondition_size = 0;
		ValaList* _tmp573_;
		gint _tmp574_;
		gint _tmp575_;
		gint _postcondition_index = 0;
		_tmp571_ = vala_method_get_postconditions (self);
		_tmp572_ = _vala_iterable_ref0 (_tmp571_);
		_postcondition_list = _tmp572_;
		_tmp573_ = _postcondition_list;
		_tmp574_ = vala_collection_get_size ((ValaCollection*) _tmp573_);
		_tmp575_ = _tmp574_;
		_postcondition_size = _tmp575_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp576_;
			gint _tmp577_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp578_;
			gpointer _tmp579_;
			ValaExpression* _tmp580_;
			gboolean _tmp581_;
			gboolean _tmp582_;
			ValaExpression* _tmp583_;
			ValaDataType* _tmp584_;
			ValaDataType* _tmp585_;
			ValaSemanticAnalyzer* _tmp586_;
			ValaSemanticAnalyzer* _tmp587_;
			ValaDataType* _tmp588_;
			_postcondition_index = _postcondition_index + 1;
			_tmp576_ = _postcondition_index;
			_tmp577_ = _postcondition_size;
			if (!(_tmp576_ < _tmp577_)) {
				break;
			}
			_tmp578_ = _postcondition_list;
			_tmp579_ = vala_list_get (_tmp578_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp579_;
			_tmp580_ = postcondition;
			_tmp581_ = vala_code_node_get_error ((ValaCodeNode*) _tmp580_);
			_tmp582_ = _tmp581_;
			if (_tmp582_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp583_ = postcondition;
			_tmp584_ = vala_expression_get_value_type (_tmp583_);
			_tmp585_ = _tmp584_;
			_tmp586_ = vala_code_context_get_analyzer (context);
			_tmp587_ = _tmp586_;
			_tmp588_ = _tmp587_->bool_type;
			if (!vala_data_type_compatible (_tmp585_, _tmp588_)) {
				ValaExpression* _tmp589_;
				ValaSourceReference* _tmp590_;
				ValaSourceReference* _tmp591_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp589_ = postcondition;
				_tmp590_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp589_);
				_tmp591_ = _tmp590_;
				vala_report_error (_tmp591_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp593_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp594_ = _tmp593_;
	if (_tmp594_ != NULL) {
		ValaBlock* _tmp595_;
		ValaBlock* _tmp596_;
		gboolean _tmp597_;
		gboolean _tmp598_;
		_tmp595_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp596_ = _tmp595_;
		_tmp597_ = vala_code_node_get_error ((ValaCodeNode*) _tmp596_);
		_tmp598_ = _tmp597_;
		_tmp592_ = !_tmp598_;
	} else {
		_tmp592_ = FALSE;
	}
	if (_tmp592_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp599_;
		ValaArrayList* _tmp600_;
		ValaBlock* _tmp601_;
		ValaBlock* _tmp602_;
		ValaArrayList* _tmp603_;
		_tmp599_ = g_direct_equal;
		_tmp600_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp599_);
		body_errors = _tmp600_;
		_tmp601_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp602_ = _tmp601_;
		_tmp603_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp602_, (ValaCollection*) _tmp603_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp604_;
			ValaArrayList* _tmp605_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp606_;
			gint _tmp607_;
			gint _tmp608_;
			gint _body_error_type_index = 0;
			_tmp604_ = body_errors;
			_tmp605_ = _vala_iterable_ref0 (_tmp604_);
			_body_error_type_list = _tmp605_;
			_tmp606_ = _body_error_type_list;
			_tmp607_ = vala_collection_get_size ((ValaCollection*) _tmp606_);
			_tmp608_ = _tmp607_;
			_body_error_type_size = _tmp608_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp609_;
				gint _tmp610_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp611_;
				gpointer _tmp612_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp613_;
				gboolean _tmp625_ = FALSE;
				ValaDataType* _tmp626_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp630_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp609_ = _body_error_type_index;
				_tmp610_ = _body_error_type_size;
				if (!(_tmp609_ < _tmp610_)) {
					break;
				}
				_tmp611_ = _body_error_type_list;
				_tmp612_ = vala_list_get ((ValaList*) _tmp611_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp612_;
				can_propagate_error = FALSE;
				_tmp613_ = self->error_types;
				if (_tmp613_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp614_;
						ValaList* _tmp615_;
						gint _method_error_type_size = 0;
						ValaList* _tmp616_;
						gint _tmp617_;
						gint _tmp618_;
						gint _method_error_type_index = 0;
						_tmp614_ = self->error_types;
						_tmp615_ = _vala_iterable_ref0 (_tmp614_);
						_method_error_type_list = _tmp615_;
						_tmp616_ = _method_error_type_list;
						_tmp617_ = vala_collection_get_size ((ValaCollection*) _tmp616_);
						_tmp618_ = _tmp617_;
						_method_error_type_size = _tmp618_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp619_;
							gint _tmp620_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp621_;
							gpointer _tmp622_;
							ValaDataType* _tmp623_;
							ValaDataType* _tmp624_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp619_ = _method_error_type_index;
							_tmp620_ = _method_error_type_size;
							if (!(_tmp619_ < _tmp620_)) {
								break;
							}
							_tmp621_ = _method_error_type_list;
							_tmp622_ = vala_list_get (_tmp621_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp622_;
							_tmp623_ = body_error_type;
							_tmp624_ = method_error_type;
							if (vala_data_type_compatible (_tmp623_, _tmp624_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp626_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp626_)) {
					ValaDataType* _tmp627_;
					gboolean _tmp628_;
					gboolean _tmp629_;
					_tmp627_ = body_error_type;
					_tmp628_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp627_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp629_ = _tmp628_;
					_tmp625_ = _tmp629_;
				} else {
					_tmp625_ = FALSE;
				}
				is_dynamic_error = _tmp625_;
				if (!can_propagate_error) {
					_tmp630_ = !is_dynamic_error;
				} else {
					_tmp630_ = FALSE;
				}
				if (_tmp630_) {
					ValaDataType* _tmp631_;
					ValaSourceReference* _tmp632_;
					ValaSourceReference* _tmp633_;
					ValaDataType* _tmp634_;
					gchar* _tmp635_;
					gchar* _tmp636_;
					gchar* _tmp637_;
					gchar* _tmp638_;
					_tmp631_ = body_error_type;
					_tmp632_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp631_);
					_tmp633_ = _tmp632_;
					_tmp634_ = body_error_type;
					_tmp635_ = vala_code_node_to_string ((ValaCodeNode*) _tmp634_);
					_tmp636_ = _tmp635_;
					_tmp637_ = g_strdup_printf ("unhandled error `%s'", _tmp636_);
					_tmp638_ = _tmp637_;
					vala_report_warning (_tmp633_, _tmp638_);
					_g_free0 (_tmp638_);
					_g_free0 (_tmp636_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp644_;
		_tmp644_ = self->priv->_binding;
		_tmp643_ = _tmp644_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp643_ = FALSE;
	}
	if (_tmp643_) {
		gboolean _tmp645_;
		_tmp645_ = self->priv->_overrides;
		_tmp642_ = !_tmp645_;
	} else {
		_tmp642_ = FALSE;
	}
	if (_tmp642_) {
		ValaSymbolAccessibility _tmp646_;
		ValaSymbolAccessibility _tmp647_;
		_tmp646_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp647_ = _tmp646_;
		_tmp641_ = _tmp647_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp641_ = FALSE;
	}
	if (_tmp641_) {
		ValaSymbol* _tmp648_;
		ValaSymbol* _tmp649_;
		_tmp648_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp649_ = _tmp648_;
		_tmp640_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp649_);
	} else {
		_tmp640_ = FALSE;
	}
	if (_tmp640_) {
		ValaSymbol* _tmp650_;
		ValaSymbol* _tmp651_;
		ValaAttribute* _tmp652_;
		_tmp650_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp651_ = _tmp650_;
		_tmp652_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp651_, "DBus");
		_tmp639_ = _tmp652_ != NULL;
	} else {
		_tmp639_ = FALSE;
	}
	if (_tmp639_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp653_;
		ValaAttribute* _tmp654_;
		gboolean _tmp655_ = FALSE;
		ValaAttribute* _tmp656_;
		_tmp653_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp654_ = _vala_code_node_ref0 (_tmp653_);
		dbus_attr = _tmp654_;
		_tmp656_ = dbus_attr;
		if (_tmp656_ == NULL) {
			_tmp655_ = TRUE;
		} else {
			ValaAttribute* _tmp657_;
			_tmp657_ = dbus_attr;
			_tmp655_ = vala_attribute_get_bool (_tmp657_, "visible", TRUE);
		}
		if (_tmp655_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp658_;
			ValaArrayList* _tmp659_;
			ValaArrayList* _tmp660_;
			gboolean _tmp679_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp658_ = g_direct_equal;
			_tmp659_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp658_);
			error_types = _tmp659_;
			_tmp660_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp660_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp661_;
				ValaArrayList* _tmp662_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp663_;
				gint _tmp664_;
				gint _tmp665_;
				gint _error_type_index = 0;
				_tmp661_ = error_types;
				_tmp662_ = _vala_iterable_ref0 (_tmp661_);
				_error_type_list = _tmp662_;
				_tmp663_ = _error_type_list;
				_tmp664_ = vala_collection_get_size ((ValaCollection*) _tmp663_);
				_tmp665_ = _tmp664_;
				_error_type_size = _tmp665_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp666_;
					gint _tmp667_;
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp668_;
					gpointer _tmp669_;
					ValaDataType* _tmp670_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp671_;
					ValaErrorDomain* _tmp672_;
					ValaErrorDomain* _tmp673_;
					ValaErrorDomain* _tmp674_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp675_;
					gchar* _tmp676_;
					const gchar* _tmp677_;
					_error_type_index = _error_type_index + 1;
					_tmp666_ = _error_type_index;
					_tmp667_ = _error_type_size;
					if (!(_tmp666_ < _tmp667_)) {
						break;
					}
					_tmp668_ = _error_type_list;
					_tmp669_ = vala_list_get ((ValaList*) _tmp668_, _error_type_index);
					error_type = (ValaDataType*) _tmp669_;
					_tmp670_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp670_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp671_ = error_type;
					_tmp672_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp671_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp673_ = _tmp672_;
					error_domain = _tmp673_;
					_tmp674_ = error_domain;
					if (_tmp674_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp675_ = error_domain;
					_tmp676_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp675_);
					full_error_domain = _tmp676_;
					_tmp677_ = full_error_domain;
					if (g_strcmp0 (_tmp677_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp678_;
						_tmp678_ = full_error_domain;
						if (g_strcmp0 (_tmp678_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp680_ = FALSE;
				if (throws_gioerror) {
					_tmp680_ = throws_gdbuserror;
				} else {
					_tmp680_ = FALSE;
				}
				_tmp679_ = !_tmp680_;
			} else {
				_tmp679_ = FALSE;
			}
			if (_tmp679_) {
				ValaSourceReference* _tmp681_;
				ValaSourceReference* _tmp682_;
				_tmp681_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp682_ = _tmp681_;
				vala_report_warning (_tmp682_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp683_;
		ValaMethod* _tmp684_;
		gboolean _tmp693_;
		gboolean _tmp694_;
		gboolean _tmp697_;
		gboolean _tmp700_;
		_tmp683_ = vala_code_context_get_entry_point (context);
		_tmp684_ = _tmp683_;
		if (_tmp684_ != NULL) {
			ValaSourceReference* _tmp685_;
			ValaSourceReference* _tmp686_;
			ValaMethod* _tmp687_;
			ValaMethod* _tmp688_;
			gchar* _tmp689_;
			gchar* _tmp690_;
			gchar* _tmp691_;
			gchar* _tmp692_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp685_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp686_ = _tmp685_;
			_tmp687_ = vala_code_context_get_entry_point (context);
			_tmp688_ = _tmp687_;
			_tmp689_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp688_);
			_tmp690_ = _tmp689_;
			_tmp691_ = g_strdup_printf ("program already has an entry point `%s'", _tmp690_);
			_tmp692_ = _tmp691_;
			vala_report_error (_tmp686_, _tmp692_);
			_g_free0 (_tmp692_);
			_g_free0 (_tmp690_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp693_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp694_ = _tmp693_;
		if (_tmp694_) {
			ValaSourceReference* _tmp695_;
			ValaSourceReference* _tmp696_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp695_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp696_ = _tmp695_;
			vala_report_error (_tmp696_, "\"main\" method cannot throw errors");
		}
		_tmp697_ = self->priv->_is_inline;
		if (_tmp697_) {
			ValaSourceReference* _tmp698_;
			ValaSourceReference* _tmp699_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp698_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp699_ = _tmp698_;
			vala_report_error (_tmp699_, "\"main\" method cannot be inline");
		}
		_tmp700_ = self->priv->_coroutine;
		if (_tmp700_) {
			ValaSourceReference* _tmp701_;
			ValaSourceReference* _tmp702_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp701_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp702_ = _tmp701_;
			vala_report_error (_tmp702_, "\"main\" method cannot be async");
		}
	}
	_tmp703_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp703_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp704_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp705_ = _tmp704_;
	result = !_tmp705_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp34_;
	ValaIterator* _tmp35_;
	ValaIterator* _tmp36_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp37_;
	gpointer _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameterDirection _tmp41_;
	ValaParameter* _tmp42_;
	ValaDataType* _tmp43_;
	ValaDataType* _tmp44_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	_tmp27_ = _vala_iterable_ref0 (_tmp26_);
	params = _tmp27_;
	_tmp28_ = params;
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp31_ = params;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp34_ = params;
	_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
	params_it = _tmp35_;
	_tmp36_ = params_it;
	vala_iterator_next (_tmp36_);
	_tmp37_ = params_it;
	_tmp38_ = vala_iterator_get (_tmp37_);
	param = (ValaParameter*) _tmp38_;
	_tmp39_ = param;
	_tmp40_ = vala_parameter_get_direction (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp42_ = param;
	_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (!VALA_IS_ARRAY_TYPE (_tmp44_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp45_ = param;
	_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_type_symbol (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaParameter* _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gint _tmp16_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp10_ = param;
			_tmp11_ = vala_variable_get_initializer ((ValaVariable*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				_tmp9_ = TRUE;
			} else {
				ValaParameter* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = param;
				_tmp14_ = vala_parameter_get_ellipsis (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_;
			}
			if (_tmp9_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp16_ = n;
			n = _tmp16_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp36_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp35_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaParameter* param = NULL;
				ValaList* _tmp18_;
				gpointer _tmp19_;
				ValaMethod* _tmp20_;
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				ValaParameter* _tmp23_;
				_param_index = _param_index + 1;
				_tmp16_ = _param_index;
				_tmp17_ = _param_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _param_list;
				_tmp19_ = vala_list_get (_tmp18_, _param_index);
				param = (ValaParameter*) _tmp19_;
				_tmp20_ = self->priv->end_method;
				_tmp21_ = param;
				_tmp22_ = vala_parameter_copy (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_callable_add_parameter ((ValaCallable*) _tmp20_, _tmp23_);
				_vala_code_node_unref0 (_tmp23_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			gint _param_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _param_index = 0;
			_tmp24_ = vala_method_get_type_parameters (self);
			_tmp25_ = _vala_iterable_ref0 (_tmp24_);
			_param_list = _tmp25_;
			_tmp26_ = _param_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_param_size = _tmp28_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp29_;
				gint _tmp30_;
				ValaTypeParameter* param = NULL;
				ValaList* _tmp31_;
				gpointer _tmp32_;
				ValaMethod* _tmp33_;
				ValaTypeParameter* _tmp34_;
				_param_index = _param_index + 1;
				_tmp29_ = _param_index;
				_tmp30_ = _param_size;
				if (!(_tmp29_ < _tmp30_)) {
					break;
				}
				_tmp31_ = _param_list;
				_tmp32_ = vala_list_get (_tmp31_, _param_index);
				param = (ValaTypeParameter*) _tmp32_;
				_tmp33_ = self->priv->end_method;
				_tmp34_ = param;
				vala_method_add_type_parameter (_tmp33_, _tmp34_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp35_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp35_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp36_ = self->priv->end_method;
	result = _tmp36_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	result = _tmp24_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp30_;
	ValaScope* _tmp31_;
	ValaScope* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaDelegate* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaDelegateType* _tmp38_;
	ValaDelegateType* _tmp39_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp40_;
	ValaParameter* _tmp41_;
	ValaParameter* _tmp42_;
	ValaSourceReference* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaNullLiteral* _tmp45_;
	ValaNullLiteral* _tmp46_;
	ValaParameter* _tmp47_;
	ValaExpression* _tmp48_;
	ValaExpression* _tmp49_;
	ValaDelegateType* _tmp50_;
	ValaDataType* _tmp51_;
	ValaDataType* _tmp52_;
	ValaParameter* _tmp53_;
	ValaParameter* _tmp54_;
	ValaArrayList* _tmp55_;
	ValaParameter* _tmp56_;
	ValaParameter* _tmp57_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaParameter* param = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaParameter* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			_param_index = _param_index + 1;
			_tmp16_ = _param_index;
			_tmp17_ = _param_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _param_list;
			_tmp19_ = vala_list_get (_tmp18_, _param_index);
			param = (ValaParameter*) _tmp19_;
			_tmp20_ = param;
			_tmp21_ = vala_parameter_get_ellipsis (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaParameter* _tmp23_;
				ValaParameter* _tmp24_;
				_tmp23_ = param;
				_tmp24_ = _vala_code_node_ref0 (_tmp23_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp24_;
			} else {
				ValaParameter* _tmp25_;
				ValaParameterDirection _tmp26_;
				ValaParameterDirection _tmp27_;
				_tmp25_ = param;
				_tmp26_ = vala_parameter_get_direction (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp28_;
					ValaParameter* _tmp29_;
					_tmp28_ = params;
					_tmp29_ = param;
					vala_collection_add ((ValaCollection*) _tmp28_, _tmp29_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp30_ = glib_ns;
	_tmp31_ = vala_symbol_get_scope (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_scope_lookup (_tmp32_, "AsyncReadyCallback");
	_tmp34_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp35_ = vala_delegate_type_new (_tmp34_);
	_tmp36_ = _tmp35_;
	_vala_code_node_unref0 (_tmp34_);
	callback_type = _tmp36_;
	_tmp37_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp37_, TRUE);
	_tmp38_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp38_, TRUE);
	_tmp39_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp39_, TRUE);
	_tmp40_ = callback_type;
	_tmp41_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp40_, NULL);
	callback_param = _tmp41_;
	_tmp42_ = callback_param;
	_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_null_literal_new (_tmp44_);
	_tmp46_ = _tmp45_;
	vala_variable_set_initializer ((ValaVariable*) _tmp42_, (ValaExpression*) _tmp46_);
	_vala_code_node_unref0 (_tmp46_);
	_tmp47_ = callback_param;
	_tmp48_ = vala_variable_get_initializer ((ValaVariable*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = callback_type;
	_tmp51_ = vala_data_type_copy ((ValaDataType*) _tmp50_);
	_tmp52_ = _tmp51_;
	vala_expression_set_target_type (_tmp49_, _tmp52_);
	_vala_code_node_unref0 (_tmp52_);
	_tmp53_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp53_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp54_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp54_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp55_ = params;
	_tmp56_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp55_, _tmp56_);
	_tmp57_ = ellipsis;
	if (_tmp57_ != NULL) {
		ValaArrayList* _tmp58_;
		ValaParameter* _tmp59_;
		_tmp58_ = params;
		_tmp59_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp58_, _tmp59_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaParameter* param = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaParameter* _tmp32_;
			ValaParameterDirection _tmp33_;
			ValaParameterDirection _tmp34_;
			_param_index = _param_index + 1;
			_tmp28_ = _param_index;
			_tmp29_ = _param_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _param_list;
			_tmp31_ = vala_list_get (_tmp30_, _param_index);
			param = (ValaParameter*) _tmp31_;
			_tmp32_ = param;
			_tmp33_ = vala_parameter_get_direction (_tmp32_);
			_tmp34_ = _tmp33_;
			if (_tmp34_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp35_;
				ValaParameter* _tmp36_;
				_tmp35_ = params;
				_tmp36_ = param;
				vala_collection_add ((ValaCollection*) _tmp35_, _tmp36_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				ValaLocalVariable* local = NULL;
				ValaList* _tmp8_;
				gpointer _tmp9_;
				ValaLocalVariable* _tmp10_;
				_local_index = _local_index + 1;
				_tmp6_ = _local_index;
				_tmp7_ = _local_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _local_list;
				_tmp9_ = vala_list_get (_tmp8_, _local_index);
				local = (ValaLocalVariable*) _tmp9_;
				_tmp10_ = local;
				vala_collection_add (variables, _tmp10_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	ValaLocalVariable* _tmp4_;
	gboolean _tmp6_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_params_array_var;
	if (_tmp4_ != NULL) {
		ValaLocalVariable* _tmp5_;
		_tmp5_ = self->priv->_params_array_var;
		vala_collection_add (collection, (ValaVariable*) _tmp5_);
	}
	_tmp6_ = self->priv->_closure;
	if (_tmp6_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
static GType
vala_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_type_id;
	vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
	return vala_method_type_id;
}

GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		GType vala_method_type_id;
		vala_method_type_id = vala_method_get_type_once ();
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

