/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaBinaryExpression_private_offset;
static gpointer vala_binary_expression_parent_class = NULL;

static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static void vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);
static GType vala_binary_expression_get_type_once (void);

static inline gpointer
vala_binary_expression_get_instance_private (ValaBinaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBinaryExpression_private_offset);
}

ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chained;
	return result;
}

static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}

/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}

static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaBinaryOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_binary_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp367_ = FALSE;
	gboolean _tmp368_ = FALSE;
	ValaDataType* _tmp369_;
	ValaDataType* _tmp370_;
	ValaExpression* _tmp390_;
	ValaExpression* _tmp391_;
	gboolean _tmp392_ = FALSE;
	gboolean _tmp393_ = FALSE;
	ValaExpression* _tmp394_;
	ValaExpression* _tmp395_;
	ValaDataType* _tmp396_;
	ValaDataType* _tmp397_;
	ValaExpression* _tmp415_;
	ValaExpression* _tmp416_;
	gboolean _tmp417_ = FALSE;
	gboolean _tmp418_ = FALSE;
	ValaExpression* _tmp419_;
	ValaExpression* _tmp420_;
	ValaDataType* _tmp421_;
	ValaDataType* _tmp422_;
	gboolean _tmp440_ = FALSE;
	ValaExpression* _tmp441_;
	ValaExpression* _tmp442_;
	ValaExpression* _tmp445_;
	ValaExpression* _tmp446_;
	ValaDataType* _tmp447_;
	ValaDataType* _tmp448_;
	gboolean _tmp453_ = FALSE;
	ValaBinaryOperator _tmp454_;
	gboolean _tmp463_ = FALSE;
	ValaExpression* _tmp464_;
	ValaExpression* _tmp465_;
	ValaDataType* _tmp466_;
	ValaDataType* _tmp467_;
	gboolean _tmp484_ = FALSE;
	ValaExpression* _tmp485_;
	ValaExpression* _tmp486_;
	ValaDataType* _tmp487_;
	ValaDataType* _tmp488_;
	ValaExpression* _tmp505_;
	ValaExpression* _tmp506_;
	ValaExpression* _tmp507_;
	ValaExpression* _tmp508_;
	ValaDataType* _tmp509_;
	ValaDataType* _tmp510_;
	ValaDataType* _tmp511_;
	ValaDataType* _tmp512_;
	ValaExpression* _tmp513_;
	ValaExpression* _tmp514_;
	ValaDataType* _tmp515_;
	ValaDataType* _tmp516_;
	ValaExpression* _tmp517_;
	ValaExpression* _tmp518_;
	ValaExpression* _tmp519_;
	ValaExpression* _tmp520_;
	ValaDataType* _tmp521_;
	ValaDataType* _tmp522_;
	ValaDataType* _tmp523_;
	ValaDataType* _tmp524_;
	ValaExpression* _tmp525_;
	ValaExpression* _tmp526_;
	ValaDataType* _tmp527_;
	ValaDataType* _tmp528_;
	gboolean _tmp529_ = FALSE;
	gboolean _tmp530_ = FALSE;
	ValaBinaryOperator _tmp531_;
	ValaBinaryOperator _tmp620_;
	ValaDataType* _tmp1163_;
	ValaDataType* _tmp1164_;
	gboolean _tmp1165_;
	gboolean _tmp1166_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (VALA_IS_BLOCK (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaExpression* _tmp141_;
		ValaExpression* _tmp142_;
		gchar* temp_name = NULL;
		gchar* _tmp143_;
		ValaLocalVariable* right_local = NULL;
		const gchar* _tmp144_;
		ValaExpression* _tmp145_;
		ValaExpression* _tmp146_;
		ValaExpression* _tmp147_;
		ValaExpression* _tmp148_;
		ValaSourceReference* _tmp149_;
		ValaSourceReference* _tmp150_;
		ValaLocalVariable* _tmp151_;
		ValaDeclarationStatement* right_decl = NULL;
		ValaLocalVariable* _tmp152_;
		ValaExpression* _tmp153_;
		ValaExpression* _tmp154_;
		ValaSourceReference* _tmp155_;
		ValaSourceReference* _tmp156_;
		ValaDeclarationStatement* _tmp157_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp158_;
		ValaSourceReference* _tmp159_;
		ValaBlock* _tmp160_;
		ValaBlock* _tmp161_;
		ValaDeclarationStatement* _tmp162_;
		ValaBlock* _tmp163_;
		ValaLocalVariable* _tmp164_;
		ValaExpression* _tmp165_;
		ValaExpression* _tmp166_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp167_ = FALSE;
		ValaExpression* _tmp168_;
		ValaExpression* _tmp169_;
		ValaDataType* _tmp170_;
		ValaDataType* _tmp171_;
		gboolean _tmp254_ = FALSE;
		gboolean _tmp255_ = FALSE;
		ValaDataType* _tmp256_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp268_;
		const gchar* _tmp269_;
		ValaExpression* _tmp270_;
		ValaExpression* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaLocalVariable* _tmp274_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp275_;
		ValaSourceReference* _tmp276_;
		ValaSourceReference* _tmp277_;
		ValaDeclarationStatement* _tmp278_;
		ValaSemanticAnalyzer* _tmp279_;
		ValaSemanticAnalyzer* _tmp280_;
		ValaBlock* _tmp281_;
		ValaDeclarationStatement* _tmp282_;
		ValaDeclarationStatement* _tmp283_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp284_;
		const gchar* _tmp285_;
		const gchar* _tmp286_;
		ValaExpression* _tmp287_;
		ValaExpression* _tmp288_;
		ValaSourceReference* _tmp289_;
		ValaSourceReference* _tmp290_;
		ValaMemberAccess* _tmp291_;
		ValaMemberAccess* _tmp292_;
		ValaExpression* _tmp293_;
		ValaExpression* _tmp294_;
		ValaExpression* _tmp295_;
		ValaExpression* _tmp296_;
		ValaSourceReference* _tmp297_;
		ValaSourceReference* _tmp298_;
		ValaAssignment* _tmp299_;
		ValaAssignment* _tmp300_;
		ValaExpression* _tmp301_;
		ValaExpression* _tmp302_;
		ValaSourceReference* _tmp303_;
		ValaSourceReference* _tmp304_;
		ValaExpressionStatement* _tmp305_;
		ValaExpressionStatement* _tmp306_;
		ValaBlock* _tmp307_;
		ValaLocalVariable* _tmp308_;
		ValaBlock* _tmp309_;
		ValaDeclarationStatement* _tmp310_;
		ValaExpressionStatement* _tmp311_;
		ValaExpressionStatement* _tmp312_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp313_;
		const gchar* _tmp314_;
		const gchar* _tmp315_;
		ValaExpression* _tmp316_;
		ValaExpression* _tmp317_;
		ValaSourceReference* _tmp318_;
		ValaSourceReference* _tmp319_;
		ValaMemberAccess* _tmp320_;
		ValaMemberAccess* _tmp321_;
		ValaSourceReference* _tmp322_;
		ValaSourceReference* _tmp323_;
		ValaNullLiteral* _tmp324_;
		ValaNullLiteral* _tmp325_;
		ValaSourceReference* _tmp326_;
		ValaSourceReference* _tmp327_;
		ValaBinaryExpression* _tmp328_;
		ValaBinaryExpression* _tmp329_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp330_;
		ValaBlock* _tmp331_;
		ValaSourceReference* _tmp332_;
		ValaSourceReference* _tmp333_;
		ValaIfStatement* _tmp334_;
		ValaSemanticAnalyzer* _tmp335_;
		ValaSemanticAnalyzer* _tmp336_;
		ValaBlock* _tmp337_;
		ValaIfStatement* _tmp338_;
		ValaIfStatement* _tmp339_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp340_;
		ValaDataType* _tmp341_;
		ValaDataType* _tmp342_;
		ValaExpression* _tmp343_;
		gboolean _tmp344_ = FALSE;
		ValaCodeNode* _tmp363_;
		ValaCodeNode* _tmp364_;
		ValaExpression* _tmp365_;
		ValaExpression* _tmp366_;
		_tmp127_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp128_ = _tmp127_;
		if (_tmp128_ != NULL) {
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			ValaDataType* _tmp131_;
			ValaDataType* _tmp132_;
			ValaDataType* _tmp133_;
			ValaDataType* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaDataType* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			_tmp129_ = vala_binary_expression_get_left (self);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_data_type_copy (_tmp132_);
			_tmp134_ = _tmp133_;
			vala_expression_set_target_type (_tmp130_, _tmp134_);
			_vala_code_node_unref0 (_tmp134_);
			_tmp135_ = vala_binary_expression_get_right (self);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_data_type_copy (_tmp138_);
			_tmp140_ = _tmp139_;
			vala_expression_set_target_type (_tmp136_, _tmp140_);
			_vala_code_node_unref0 (_tmp140_);
		}
		_tmp141_ = vala_binary_expression_get_left (self);
		_tmp142_ = _tmp141_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp142_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp143_ = vala_code_node_get_temp_name ();
		temp_name = _tmp143_;
		_tmp144_ = temp_name;
		_tmp145_ = vala_binary_expression_get_right (self);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_binary_expression_get_right (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_local_variable_new (NULL, _tmp144_, _tmp146_, _tmp150_);
		right_local = _tmp151_;
		_tmp152_ = right_local;
		_tmp153_ = vala_binary_expression_get_right (self);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_declaration_statement_new ((ValaSymbol*) _tmp152_, _tmp156_);
		right_decl = _tmp157_;
		_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_block_new (_tmp159_);
		true_block = _tmp160_;
		_tmp161_ = true_block;
		_tmp162_ = right_decl;
		vala_block_add_statement (_tmp161_, (ValaStatement*) _tmp162_);
		_tmp163_ = true_block;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp163_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp164_ = right_local;
		_tmp165_ = vala_variable_get_initializer ((ValaVariable*) _tmp164_);
		_tmp166_ = _tmp165_;
		vala_binary_expression_set_right (self, _tmp166_);
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp168_ = vala_binary_expression_get_left (self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_expression_get_value_type (_tmp169_);
		_tmp171_ = _tmp170_;
		if (VALA_IS_NULL_TYPE (_tmp171_)) {
			ValaExpression* _tmp172_;
			ValaExpression* _tmp173_;
			ValaDataType* _tmp174_;
			ValaDataType* _tmp175_;
			_tmp172_ = vala_binary_expression_get_right (self);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_expression_get_value_type (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp167_ = _tmp175_ != NULL;
		} else {
			_tmp167_ = FALSE;
		}
		if (_tmp167_) {
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaSourceReference* _tmp178_;
			ValaSourceReference* _tmp179_;
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			ValaDataType* _tmp182_;
			ValaDataType* _tmp183_;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			ValaExpression* _tmp186_;
			ValaExpression* _tmp187_;
			ValaDataType* _tmp188_;
			ValaDataType* _tmp189_;
			gboolean _tmp190_;
			gboolean _tmp191_;
			_tmp176_ = vala_binary_expression_get_left (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
			_tmp179_ = _tmp178_;
			vala_report_warning (_tmp179_, "left operand is always null");
			_tmp180_ = vala_binary_expression_get_right (self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_expression_get_value_type (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_data_type_copy (_tmp183_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp184_;
			_tmp185_ = local_type;
			vala_data_type_set_nullable (_tmp185_, TRUE);
			_tmp186_ = vala_binary_expression_get_right (self);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_expression_get_value_type (_tmp187_);
			_tmp189_ = _tmp188_;
			_tmp190_ = vala_data_type_get_nullable (_tmp189_);
			_tmp191_ = _tmp190_;
			if (!_tmp191_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp192_;
			ValaExpression* _tmp193_;
			ValaDataType* _tmp194_;
			ValaDataType* _tmp195_;
			_tmp192_ = vala_binary_expression_get_left (self);
			_tmp193_ = _tmp192_;
			_tmp194_ = vala_expression_get_value_type (_tmp193_);
			_tmp195_ = _tmp194_;
			if (_tmp195_ != NULL) {
				ValaExpression* _tmp196_;
				ValaExpression* _tmp197_;
				ValaDataType* _tmp198_;
				ValaDataType* _tmp199_;
				ValaDataType* _tmp200_;
				gboolean _tmp201_ = FALSE;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				gboolean _tmp213_;
				gboolean _tmp214_;
				_tmp196_ = vala_binary_expression_get_left (self);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_expression_get_value_type (_tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_data_type_copy (_tmp199_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp200_;
				_tmp202_ = vala_binary_expression_get_right (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				if (_tmp205_ != NULL) {
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					ValaDataType* _tmp208_;
					ValaDataType* _tmp209_;
					gboolean _tmp210_;
					gboolean _tmp211_;
					_tmp206_ = vala_binary_expression_get_right (self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_expression_get_value_type (_tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = vala_data_type_get_value_owned (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp201_ = _tmp211_;
				} else {
					_tmp201_ = FALSE;
				}
				if (_tmp201_) {
					ValaDataType* _tmp212_;
					_tmp212_ = local_type;
					vala_data_type_set_value_owned (_tmp212_, TRUE);
				}
				_tmp213_ = vala_code_context_get_experimental_non_null (context);
				_tmp214_ = _tmp213_;
				if (_tmp214_) {
					ValaDataType* _tmp215_;
					gboolean _tmp216_;
					gboolean _tmp217_;
					_tmp215_ = local_type;
					_tmp216_ = vala_data_type_get_nullable (_tmp215_);
					_tmp217_ = _tmp216_;
					if (!_tmp217_) {
						ValaExpression* _tmp218_;
						ValaExpression* _tmp219_;
						ValaSourceReference* _tmp220_;
						ValaSourceReference* _tmp221_;
						gboolean _tmp222_ = FALSE;
						ValaExpression* _tmp223_;
						ValaExpression* _tmp224_;
						ValaDataType* _tmp225_;
						ValaDataType* _tmp226_;
						_tmp218_ = vala_binary_expression_get_left (self);
						_tmp219_ = _tmp218_;
						_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp219_);
						_tmp221_ = _tmp220_;
						vala_report_warning (_tmp221_, "left operand is never null");
						_tmp223_ = vala_binary_expression_get_right (self);
						_tmp224_ = _tmp223_;
						_tmp225_ = vala_expression_get_value_type (_tmp224_);
						_tmp226_ = _tmp225_;
						if (_tmp226_ != NULL) {
							ValaExpression* _tmp227_;
							ValaExpression* _tmp228_;
							ValaDataType* _tmp229_;
							ValaDataType* _tmp230_;
							gboolean _tmp231_;
							gboolean _tmp232_;
							_tmp227_ = vala_binary_expression_get_right (self);
							_tmp228_ = _tmp227_;
							_tmp229_ = vala_expression_get_value_type (_tmp228_);
							_tmp230_ = _tmp229_;
							_tmp231_ = vala_data_type_get_nullable (_tmp230_);
							_tmp232_ = _tmp231_;
							_tmp222_ = _tmp232_;
						} else {
							_tmp222_ = FALSE;
						}
						if (_tmp222_) {
							ValaDataType* _tmp233_;
							_tmp233_ = local_type;
							vala_data_type_set_nullable (_tmp233_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp234_ = FALSE;
						ValaExpression* _tmp235_;
						ValaExpression* _tmp236_;
						ValaDataType* _tmp237_;
						ValaDataType* _tmp238_;
						_tmp235_ = vala_binary_expression_get_right (self);
						_tmp236_ = _tmp235_;
						_tmp237_ = vala_expression_get_value_type (_tmp236_);
						_tmp238_ = _tmp237_;
						if (_tmp238_ != NULL) {
							ValaExpression* _tmp239_;
							ValaExpression* _tmp240_;
							ValaDataType* _tmp241_;
							ValaDataType* _tmp242_;
							gboolean _tmp243_;
							gboolean _tmp244_;
							_tmp239_ = vala_binary_expression_get_right (self);
							_tmp240_ = _tmp239_;
							_tmp241_ = vala_expression_get_value_type (_tmp240_);
							_tmp242_ = _tmp241_;
							_tmp243_ = vala_data_type_get_nullable (_tmp242_);
							_tmp244_ = _tmp243_;
							_tmp234_ = !_tmp244_;
						} else {
							_tmp234_ = FALSE;
						}
						if (_tmp234_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp245_;
				ValaExpression* _tmp246_;
				ValaDataType* _tmp247_;
				ValaDataType* _tmp248_;
				_tmp245_ = vala_binary_expression_get_right (self);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_expression_get_value_type (_tmp246_);
				_tmp248_ = _tmp247_;
				if (_tmp248_ != NULL) {
					ValaExpression* _tmp249_;
					ValaExpression* _tmp250_;
					ValaDataType* _tmp251_;
					ValaDataType* _tmp252_;
					ValaDataType* _tmp253_;
					_tmp249_ = vala_binary_expression_get_right (self);
					_tmp250_ = _tmp249_;
					_tmp251_ = vala_expression_get_value_type (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = vala_data_type_copy (_tmp252_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp253_;
				}
			}
		}
		_tmp256_ = local_type;
		if (_tmp256_ != NULL) {
			ValaExpression* _tmp257_;
			ValaExpression* _tmp258_;
			ValaDataType* _tmp259_;
			ValaDataType* _tmp260_;
			_tmp257_ = vala_binary_expression_get_right (self);
			_tmp258_ = _tmp257_;
			_tmp259_ = vala_expression_get_value_type (_tmp258_);
			_tmp260_ = _tmp259_;
			_tmp255_ = VALA_IS_VALUE_TYPE (_tmp260_);
		} else {
			_tmp255_ = FALSE;
		}
		if (_tmp255_) {
			ValaExpression* _tmp261_;
			ValaExpression* _tmp262_;
			ValaDataType* _tmp263_;
			ValaDataType* _tmp264_;
			gboolean _tmp265_;
			gboolean _tmp266_;
			_tmp261_ = vala_binary_expression_get_right (self);
			_tmp262_ = _tmp261_;
			_tmp263_ = vala_expression_get_value_type (_tmp262_);
			_tmp264_ = _tmp263_;
			_tmp265_ = vala_data_type_get_nullable (_tmp264_);
			_tmp266_ = _tmp265_;
			_tmp254_ = !_tmp266_;
		} else {
			_tmp254_ = FALSE;
		}
		if (_tmp254_) {
			ValaDataType* _tmp267_;
			_tmp267_ = local_type;
			vala_data_type_set_value_owned (_tmp267_, TRUE);
		}
		_tmp268_ = local_type;
		_tmp269_ = temp_name;
		_tmp270_ = vala_binary_expression_get_left (self);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_local_variable_new (_tmp268_, _tmp269_, _tmp271_, _tmp273_);
		local = _tmp274_;
		_tmp275_ = local;
		_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_declaration_statement_new ((ValaSymbol*) _tmp275_, _tmp277_);
		decl = _tmp278_;
		_tmp279_ = vala_code_context_get_analyzer (context);
		_tmp280_ = _tmp279_;
		_tmp281_ = _tmp280_->insert_block;
		_tmp282_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp281_, (ValaStatement*) _tmp282_);
		_tmp283_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp283_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp284_ = local;
		_tmp285_ = vala_symbol_get_name ((ValaSymbol*) _tmp284_);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_binary_expression_get_right (self);
		_tmp288_ = _tmp287_;
		_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp288_);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_member_access_new_simple (_tmp286_, _tmp290_);
		_tmp292_ = _tmp291_;
		_tmp293_ = vala_binary_expression_get_right (self);
		_tmp294_ = _tmp293_;
		_tmp295_ = vala_binary_expression_get_right (self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp296_);
		_tmp298_ = _tmp297_;
		_tmp299_ = vala_assignment_new ((ValaExpression*) _tmp292_, _tmp294_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp298_);
		_tmp300_ = _tmp299_;
		_tmp301_ = vala_binary_expression_get_right (self);
		_tmp302_ = _tmp301_;
		_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp302_);
		_tmp304_ = _tmp303_;
		_tmp305_ = vala_expression_statement_new ((ValaExpression*) _tmp300_, _tmp304_);
		_tmp306_ = _tmp305_;
		_vala_code_node_unref0 (_tmp300_);
		_vala_code_node_unref0 (_tmp292_);
		right_stmt = _tmp306_;
		_tmp307_ = true_block;
		_tmp308_ = right_local;
		vala_block_remove_local_variable (_tmp307_, _tmp308_);
		_tmp309_ = true_block;
		_tmp310_ = right_decl;
		_tmp311_ = right_stmt;
		vala_block_replace_statement (_tmp309_, (ValaStatement*) _tmp310_, (ValaStatement*) _tmp311_);
		_tmp312_ = right_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp312_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp313_ = local;
		_tmp314_ = vala_symbol_get_name ((ValaSymbol*) _tmp313_);
		_tmp315_ = _tmp314_;
		_tmp316_ = vala_binary_expression_get_left (self);
		_tmp317_ = _tmp316_;
		_tmp318_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp317_);
		_tmp319_ = _tmp318_;
		_tmp320_ = vala_member_access_new_simple (_tmp315_, _tmp319_);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = vala_null_literal_new (_tmp323_);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp327_ = _tmp326_;
		_tmp328_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp321_, (ValaExpression*) _tmp325_, _tmp327_);
		_tmp329_ = _tmp328_;
		_vala_code_node_unref0 (_tmp325_);
		_vala_code_node_unref0 (_tmp321_);
		cond = _tmp329_;
		_tmp330_ = cond;
		_tmp331_ = true_block;
		_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp333_ = _tmp332_;
		_tmp334_ = vala_if_statement_new ((ValaExpression*) _tmp330_, _tmp331_, NULL, _tmp333_);
		if_stmt = _tmp334_;
		_tmp335_ = vala_code_context_get_analyzer (context);
		_tmp336_ = _tmp335_;
		_tmp337_ = _tmp336_->insert_block;
		_tmp338_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp337_, (ValaStatement*) _tmp338_);
		_tmp339_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp339_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp340_ = local;
		_tmp341_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp342_ = _tmp341_;
		_tmp343_ = vala_semantic_analyzer_create_temp_access (_tmp340_, _tmp342_);
		replace_expr = _tmp343_;
		if (cast_non_null) {
			ValaExpression* _tmp345_;
			ValaDataType* _tmp346_;
			ValaDataType* _tmp347_;
			_tmp345_ = replace_expr;
			_tmp346_ = vala_expression_get_target_type (_tmp345_);
			_tmp347_ = _tmp346_;
			_tmp344_ = _tmp347_ != NULL;
		} else {
			_tmp344_ = FALSE;
		}
		if (_tmp344_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp348_;
			ValaSourceReference* _tmp349_;
			ValaSourceReference* _tmp350_;
			ValaCastExpression* _tmp351_;
			ValaCastExpression* _tmp352_;
			ValaExpression* _tmp353_;
			ValaDataType* _tmp354_;
			ValaDataType* _tmp355_;
			ValaDataType* _tmp356_;
			ValaDataType* _tmp357_;
			ValaCastExpression* _tmp358_;
			ValaDataType* _tmp359_;
			ValaDataType* _tmp360_;
			ValaCastExpression* _tmp361_;
			ValaExpression* _tmp362_;
			_tmp348_ = replace_expr;
			_tmp349_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp350_ = _tmp349_;
			_tmp351_ = vala_cast_expression_new_non_null (_tmp348_, _tmp350_);
			cast = _tmp351_;
			_tmp352_ = cast;
			_tmp353_ = replace_expr;
			_tmp354_ = vala_expression_get_target_type (_tmp353_);
			_tmp355_ = _tmp354_;
			_tmp356_ = vala_data_type_copy (_tmp355_);
			_tmp357_ = _tmp356_;
			vala_expression_set_target_type ((ValaExpression*) _tmp352_, _tmp357_);
			_vala_code_node_unref0 (_tmp357_);
			_tmp358_ = cast;
			_tmp359_ = vala_expression_get_target_type ((ValaExpression*) _tmp358_);
			_tmp360_ = _tmp359_;
			vala_data_type_set_nullable (_tmp360_, FALSE);
			_tmp361_ = cast;
			_tmp362_ = _vala_code_node_ref0 ((ValaExpression*) _tmp361_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp362_;
			_vala_code_node_unref0 (cast);
		}
		_tmp363_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp364_ = _tmp363_;
		_tmp365_ = replace_expr;
		vala_code_node_replace_expression (_tmp364_, (ValaExpression*) self, _tmp365_);
		_tmp366_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp366_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_decl);
		_vala_code_node_unref0 (right_local);
		_g_free0 (temp_name);
		return result;
	}
	_tmp369_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp370_ = _tmp369_;
	if (_tmp370_ != NULL) {
		ValaDataType* _tmp371_;
		ValaDataType* _tmp372_;
		ValaTypeSymbol* _tmp373_;
		ValaTypeSymbol* _tmp374_;
		_tmp371_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp372_ = _tmp371_;
		_tmp373_ = vala_data_type_get_type_symbol (_tmp372_);
		_tmp374_ = _tmp373_;
		_tmp368_ = VALA_IS_ENUM (_tmp374_);
	} else {
		_tmp368_ = FALSE;
	}
	if (_tmp368_) {
		gboolean _tmp375_ = FALSE;
		ValaBinaryOperator _tmp376_;
		_tmp376_ = self->priv->_operator;
		if (_tmp376_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp375_ = TRUE;
		} else {
			ValaBinaryOperator _tmp377_;
			_tmp377_ = self->priv->_operator;
			_tmp375_ = _tmp377_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp367_ = _tmp375_;
	} else {
		_tmp367_ = FALSE;
	}
	if (_tmp367_) {
		ValaExpression* _tmp378_;
		ValaExpression* _tmp379_;
		ValaDataType* _tmp380_;
		ValaDataType* _tmp381_;
		ValaDataType* _tmp382_;
		ValaDataType* _tmp383_;
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaDataType* _tmp386_;
		ValaDataType* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		_tmp378_ = vala_binary_expression_get_left (self);
		_tmp379_ = _tmp378_;
		_tmp380_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp381_ = _tmp380_;
		_tmp382_ = vala_data_type_copy (_tmp381_);
		_tmp383_ = _tmp382_;
		vala_expression_set_target_type (_tmp379_, _tmp383_);
		_vala_code_node_unref0 (_tmp383_);
		_tmp384_ = vala_binary_expression_get_right (self);
		_tmp385_ = _tmp384_;
		_tmp386_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp387_ = _tmp386_;
		_tmp388_ = vala_data_type_copy (_tmp387_);
		_tmp389_ = _tmp388_;
		vala_expression_set_target_type (_tmp385_, _tmp389_);
		_vala_code_node_unref0 (_tmp389_);
	}
	_tmp390_ = vala_binary_expression_get_left (self);
	_tmp391_ = _tmp390_;
	vala_code_node_check ((ValaCodeNode*) _tmp391_, context);
	_tmp394_ = vala_binary_expression_get_left (self);
	_tmp395_ = _tmp394_;
	_tmp396_ = vala_expression_get_value_type (_tmp395_);
	_tmp397_ = _tmp396_;
	if (_tmp397_ != NULL) {
		ValaExpression* _tmp398_;
		ValaExpression* _tmp399_;
		ValaDataType* _tmp400_;
		ValaDataType* _tmp401_;
		ValaTypeSymbol* _tmp402_;
		ValaTypeSymbol* _tmp403_;
		_tmp398_ = vala_binary_expression_get_left (self);
		_tmp399_ = _tmp398_;
		_tmp400_ = vala_expression_get_value_type (_tmp399_);
		_tmp401_ = _tmp400_;
		_tmp402_ = vala_data_type_get_type_symbol (_tmp401_);
		_tmp403_ = _tmp402_;
		_tmp393_ = VALA_IS_ENUM (_tmp403_);
	} else {
		_tmp393_ = FALSE;
	}
	if (_tmp393_) {
		gboolean _tmp404_ = FALSE;
		ValaBinaryOperator _tmp405_;
		_tmp405_ = self->priv->_operator;
		if (_tmp405_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp404_ = TRUE;
		} else {
			ValaBinaryOperator _tmp406_;
			_tmp406_ = self->priv->_operator;
			_tmp404_ = _tmp406_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp392_ = _tmp404_;
	} else {
		_tmp392_ = FALSE;
	}
	if (_tmp392_) {
		ValaExpression* _tmp407_;
		ValaExpression* _tmp408_;
		ValaExpression* _tmp409_;
		ValaExpression* _tmp410_;
		ValaDataType* _tmp411_;
		ValaDataType* _tmp412_;
		ValaDataType* _tmp413_;
		ValaDataType* _tmp414_;
		_tmp407_ = vala_binary_expression_get_right (self);
		_tmp408_ = _tmp407_;
		_tmp409_ = vala_binary_expression_get_left (self);
		_tmp410_ = _tmp409_;
		_tmp411_ = vala_expression_get_value_type (_tmp410_);
		_tmp412_ = _tmp411_;
		_tmp413_ = vala_data_type_copy (_tmp412_);
		_tmp414_ = _tmp413_;
		vala_expression_set_target_type (_tmp408_, _tmp414_);
		_vala_code_node_unref0 (_tmp414_);
	}
	_tmp415_ = vala_binary_expression_get_right (self);
	_tmp416_ = _tmp415_;
	vala_code_node_check ((ValaCodeNode*) _tmp416_, context);
	_tmp419_ = vala_binary_expression_get_right (self);
	_tmp420_ = _tmp419_;
	_tmp421_ = vala_expression_get_value_type (_tmp420_);
	_tmp422_ = _tmp421_;
	if (_tmp422_ != NULL) {
		ValaExpression* _tmp423_;
		ValaExpression* _tmp424_;
		ValaDataType* _tmp425_;
		ValaDataType* _tmp426_;
		ValaTypeSymbol* _tmp427_;
		ValaTypeSymbol* _tmp428_;
		_tmp423_ = vala_binary_expression_get_right (self);
		_tmp424_ = _tmp423_;
		_tmp425_ = vala_expression_get_value_type (_tmp424_);
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_data_type_get_type_symbol (_tmp426_);
		_tmp428_ = _tmp427_;
		_tmp418_ = VALA_IS_ENUM (_tmp428_);
	} else {
		_tmp418_ = FALSE;
	}
	if (_tmp418_) {
		gboolean _tmp429_ = FALSE;
		ValaBinaryOperator _tmp430_;
		_tmp430_ = self->priv->_operator;
		if (_tmp430_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp429_ = TRUE;
		} else {
			ValaBinaryOperator _tmp431_;
			_tmp431_ = self->priv->_operator;
			_tmp429_ = _tmp431_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp417_ = _tmp429_;
	} else {
		_tmp417_ = FALSE;
	}
	if (_tmp417_) {
		ValaExpression* _tmp432_;
		ValaExpression* _tmp433_;
		ValaExpression* _tmp434_;
		ValaExpression* _tmp435_;
		ValaDataType* _tmp436_;
		ValaDataType* _tmp437_;
		ValaDataType* _tmp438_;
		ValaDataType* _tmp439_;
		_tmp432_ = vala_binary_expression_get_left (self);
		_tmp433_ = _tmp432_;
		_tmp434_ = vala_binary_expression_get_right (self);
		_tmp435_ = _tmp434_;
		_tmp436_ = vala_expression_get_value_type (_tmp435_);
		_tmp437_ = _tmp436_;
		_tmp438_ = vala_data_type_copy (_tmp437_);
		_tmp439_ = _tmp438_;
		vala_expression_set_target_type (_tmp433_, _tmp439_);
		_vala_code_node_unref0 (_tmp439_);
	}
	_tmp441_ = vala_binary_expression_get_left (self);
	_tmp442_ = _tmp441_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp442_, context)) {
		_tmp440_ = TRUE;
	} else {
		ValaExpression* _tmp443_;
		ValaExpression* _tmp444_;
		_tmp443_ = vala_binary_expression_get_right (self);
		_tmp444_ = _tmp443_;
		_tmp440_ = !vala_code_node_check ((ValaCodeNode*) _tmp444_, context);
	}
	if (_tmp440_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp445_ = vala_binary_expression_get_left (self);
	_tmp446_ = _tmp445_;
	_tmp447_ = vala_expression_get_value_type (_tmp446_);
	_tmp448_ = _tmp447_;
	if (_tmp448_ == NULL) {
		ValaExpression* _tmp449_;
		ValaExpression* _tmp450_;
		ValaSourceReference* _tmp451_;
		ValaSourceReference* _tmp452_;
		_tmp449_ = vala_binary_expression_get_left (self);
		_tmp450_ = _tmp449_;
		_tmp451_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp450_);
		_tmp452_ = _tmp451_;
		vala_report_error (_tmp452_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp454_ = self->priv->_operator;
	if (_tmp454_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp455_;
		ValaExpression* _tmp456_;
		ValaDataType* _tmp457_;
		ValaDataType* _tmp458_;
		_tmp455_ = vala_binary_expression_get_right (self);
		_tmp456_ = _tmp455_;
		_tmp457_ = vala_expression_get_value_type (_tmp456_);
		_tmp458_ = _tmp457_;
		_tmp453_ = _tmp458_ == NULL;
	} else {
		_tmp453_ = FALSE;
	}
	if (_tmp453_) {
		ValaExpression* _tmp459_;
		ValaExpression* _tmp460_;
		ValaSourceReference* _tmp461_;
		ValaSourceReference* _tmp462_;
		_tmp459_ = vala_binary_expression_get_right (self);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp460_);
		_tmp462_ = _tmp461_;
		vala_report_error (_tmp462_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp464_ = vala_binary_expression_get_left (self);
	_tmp465_ = _tmp464_;
	_tmp466_ = vala_expression_get_value_type (_tmp465_);
	_tmp467_ = _tmp466_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp467_)) {
		_tmp463_ = TRUE;
	} else {
		ValaExpression* _tmp468_;
		ValaExpression* _tmp469_;
		ValaDataType* _tmp470_;
		ValaDataType* _tmp471_;
		_tmp468_ = vala_binary_expression_get_left (self);
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_expression_get_value_type (_tmp469_);
		_tmp471_ = _tmp470_;
		_tmp463_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp471_);
	}
	if (_tmp463_) {
		ValaExpression* _tmp472_;
		ValaExpression* _tmp473_;
		ValaSourceReference* _tmp474_;
		ValaSourceReference* _tmp475_;
		ValaExpression* _tmp476_;
		ValaExpression* _tmp477_;
		ValaSymbol* _tmp478_;
		ValaSymbol* _tmp479_;
		gchar* _tmp480_;
		gchar* _tmp481_;
		gchar* _tmp482_;
		gchar* _tmp483_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp472_ = vala_binary_expression_get_left (self);
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp473_);
		_tmp475_ = _tmp474_;
		_tmp476_ = vala_binary_expression_get_left (self);
		_tmp477_ = _tmp476_;
		_tmp478_ = vala_expression_get_symbol_reference (_tmp477_);
		_tmp479_ = _tmp478_;
		_tmp480_ = vala_symbol_get_full_name (_tmp479_);
		_tmp481_ = _tmp480_;
		_tmp482_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp481_);
		_tmp483_ = _tmp482_;
		vala_report_error (_tmp475_, _tmp483_);
		_g_free0 (_tmp483_);
		_g_free0 (_tmp481_);
		result = FALSE;
		return result;
	}
	_tmp485_ = vala_binary_expression_get_right (self);
	_tmp486_ = _tmp485_;
	_tmp487_ = vala_expression_get_value_type (_tmp486_);
	_tmp488_ = _tmp487_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp488_)) {
		_tmp484_ = TRUE;
	} else {
		ValaExpression* _tmp489_;
		ValaExpression* _tmp490_;
		ValaDataType* _tmp491_;
		ValaDataType* _tmp492_;
		_tmp489_ = vala_binary_expression_get_right (self);
		_tmp490_ = _tmp489_;
		_tmp491_ = vala_expression_get_value_type (_tmp490_);
		_tmp492_ = _tmp491_;
		_tmp484_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp492_);
	}
	if (_tmp484_) {
		ValaExpression* _tmp493_;
		ValaExpression* _tmp494_;
		ValaSourceReference* _tmp495_;
		ValaSourceReference* _tmp496_;
		ValaExpression* _tmp497_;
		ValaExpression* _tmp498_;
		ValaSymbol* _tmp499_;
		ValaSymbol* _tmp500_;
		gchar* _tmp501_;
		gchar* _tmp502_;
		gchar* _tmp503_;
		gchar* _tmp504_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp493_ = vala_binary_expression_get_right (self);
		_tmp494_ = _tmp493_;
		_tmp495_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp494_);
		_tmp496_ = _tmp495_;
		_tmp497_ = vala_binary_expression_get_right (self);
		_tmp498_ = _tmp497_;
		_tmp499_ = vala_expression_get_symbol_reference (_tmp498_);
		_tmp500_ = _tmp499_;
		_tmp501_ = vala_symbol_get_full_name (_tmp500_);
		_tmp502_ = _tmp501_;
		_tmp503_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp502_);
		_tmp504_ = _tmp503_;
		vala_report_error (_tmp496_, _tmp504_);
		_g_free0 (_tmp504_);
		_g_free0 (_tmp502_);
		result = FALSE;
		return result;
	}
	_tmp505_ = vala_binary_expression_get_left (self);
	_tmp506_ = _tmp505_;
	_tmp507_ = vala_binary_expression_get_left (self);
	_tmp508_ = _tmp507_;
	_tmp509_ = vala_expression_get_value_type (_tmp508_);
	_tmp510_ = _tmp509_;
	_tmp511_ = vala_data_type_copy (_tmp510_);
	_tmp512_ = _tmp511_;
	vala_expression_set_target_type (_tmp506_, _tmp512_);
	_vala_code_node_unref0 (_tmp512_);
	_tmp513_ = vala_binary_expression_get_left (self);
	_tmp514_ = _tmp513_;
	_tmp515_ = vala_expression_get_target_type (_tmp514_);
	_tmp516_ = _tmp515_;
	vala_data_type_set_value_owned (_tmp516_, FALSE);
	_tmp517_ = vala_binary_expression_get_right (self);
	_tmp518_ = _tmp517_;
	_tmp519_ = vala_binary_expression_get_right (self);
	_tmp520_ = _tmp519_;
	_tmp521_ = vala_expression_get_value_type (_tmp520_);
	_tmp522_ = _tmp521_;
	_tmp523_ = vala_data_type_copy (_tmp522_);
	_tmp524_ = _tmp523_;
	vala_expression_set_target_type (_tmp518_, _tmp524_);
	_vala_code_node_unref0 (_tmp524_);
	_tmp525_ = vala_binary_expression_get_right (self);
	_tmp526_ = _tmp525_;
	_tmp527_ = vala_expression_get_target_type (_tmp526_);
	_tmp528_ = _tmp527_;
	vala_data_type_set_value_owned (_tmp528_, FALSE);
	_tmp531_ = self->priv->_operator;
	if (_tmp531_ == VALA_BINARY_OPERATOR_PLUS) {
		ValaExpression* _tmp532_;
		ValaExpression* _tmp533_;
		ValaDataType* _tmp534_;
		ValaDataType* _tmp535_;
		_tmp532_ = vala_binary_expression_get_left (self);
		_tmp533_ = _tmp532_;
		_tmp534_ = vala_expression_get_value_type (_tmp533_);
		_tmp535_ = _tmp534_;
		_tmp530_ = !VALA_IS_POINTER_TYPE (_tmp535_);
	} else {
		_tmp530_ = FALSE;
	}
	if (_tmp530_) {
		ValaExpression* _tmp536_;
		ValaExpression* _tmp537_;
		ValaDataType* _tmp538_;
		ValaDataType* _tmp539_;
		ValaSemanticAnalyzer* _tmp540_;
		ValaSemanticAnalyzer* _tmp541_;
		ValaDataType* _tmp542_;
		_tmp536_ = vala_binary_expression_get_left (self);
		_tmp537_ = _tmp536_;
		_tmp538_ = vala_expression_get_value_type (_tmp537_);
		_tmp539_ = _tmp538_;
		_tmp540_ = vala_code_context_get_analyzer (context);
		_tmp541_ = _tmp540_;
		_tmp542_ = _tmp541_->string_type;
		_tmp529_ = vala_data_type_compatible (_tmp539_, _tmp542_);
	} else {
		_tmp529_ = FALSE;
	}
	if (_tmp529_) {
		gboolean _tmp543_ = FALSE;
		ValaExpression* _tmp544_;
		ValaExpression* _tmp545_;
		ValaDataType* _tmp546_;
		ValaDataType* _tmp547_;
		ValaSemanticAnalyzer* _tmp557_;
		ValaSemanticAnalyzer* _tmp558_;
		ValaDataType* _tmp559_;
		ValaDataType* _tmp560_;
		ValaDataType* _tmp561_;
		gboolean _tmp562_ = FALSE;
		ValaExpression* _tmp563_;
		ValaExpression* _tmp564_;
		ValaDataType* _tmp571_;
		ValaDataType* _tmp572_;
		gboolean _tmp573_;
		gboolean _tmp574_;
		_tmp544_ = vala_binary_expression_get_right (self);
		_tmp545_ = _tmp544_;
		_tmp546_ = vala_expression_get_value_type (_tmp545_);
		_tmp547_ = _tmp546_;
		if (_tmp547_ == NULL) {
			_tmp543_ = TRUE;
		} else {
			ValaExpression* _tmp548_;
			ValaExpression* _tmp549_;
			ValaDataType* _tmp550_;
			ValaDataType* _tmp551_;
			ValaSemanticAnalyzer* _tmp552_;
			ValaSemanticAnalyzer* _tmp553_;
			ValaDataType* _tmp554_;
			_tmp548_ = vala_binary_expression_get_right (self);
			_tmp549_ = _tmp548_;
			_tmp550_ = vala_expression_get_value_type (_tmp549_);
			_tmp551_ = _tmp550_;
			_tmp552_ = vala_code_context_get_analyzer (context);
			_tmp553_ = _tmp552_;
			_tmp554_ = _tmp553_->string_type;
			_tmp543_ = !vala_data_type_compatible (_tmp551_, _tmp554_);
		}
		if (_tmp543_) {
			ValaSourceReference* _tmp555_;
			ValaSourceReference* _tmp556_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp555_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp556_ = _tmp555_;
			vala_report_error (_tmp556_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp557_ = vala_code_context_get_analyzer (context);
		_tmp558_ = _tmp557_;
		_tmp559_ = _tmp558_->string_type;
		_tmp560_ = vala_data_type_copy (_tmp559_);
		_tmp561_ = _tmp560_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp561_);
		_vala_code_node_unref0 (_tmp561_);
		_tmp563_ = vala_binary_expression_get_left (self);
		_tmp564_ = _tmp563_;
		if (vala_expression_is_constant (_tmp564_)) {
			ValaExpression* _tmp565_;
			ValaExpression* _tmp566_;
			_tmp565_ = vala_binary_expression_get_right (self);
			_tmp566_ = _tmp565_;
			_tmp562_ = vala_expression_is_constant (_tmp566_);
		} else {
			_tmp562_ = FALSE;
		}
		if (_tmp562_) {
			ValaDataType* _tmp567_;
			ValaDataType* _tmp568_;
			_tmp567_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp568_ = _tmp567_;
			vala_data_type_set_value_owned (_tmp568_, FALSE);
		} else {
			ValaDataType* _tmp569_;
			ValaDataType* _tmp570_;
			_tmp569_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp570_ = _tmp569_;
			vala_data_type_set_value_owned (_tmp570_, TRUE);
		}
		_tmp571_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp572_ = _tmp571_;
		vala_code_node_check ((ValaCodeNode*) _tmp572_, context);
		_tmp573_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp574_ = _tmp573_;
		result = !_tmp574_;
		return result;
	} else {
		gboolean _tmp575_ = FALSE;
		ValaBinaryOperator _tmp576_;
		_tmp576_ = self->priv->_operator;
		if (_tmp576_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp577_;
			ValaExpression* _tmp578_;
			ValaDataType* _tmp579_;
			ValaDataType* _tmp580_;
			_tmp577_ = vala_binary_expression_get_left (self);
			_tmp578_ = _tmp577_;
			_tmp579_ = vala_expression_get_value_type (_tmp578_);
			_tmp580_ = _tmp579_;
			_tmp575_ = VALA_IS_ARRAY_TYPE (_tmp580_);
		} else {
			_tmp575_ = FALSE;
		}
		if (_tmp575_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp581_;
			ValaExpression* _tmp582_;
			ValaDataType* _tmp583_;
			ValaDataType* _tmp584_;
			ValaArrayType* _tmp585_;
			gboolean _tmp586_;
			gboolean _tmp587_;
			gboolean _tmp590_ = FALSE;
			ValaExpression* _tmp591_;
			ValaExpression* _tmp592_;
			ValaDataType* _tmp593_;
			ValaDataType* _tmp594_;
			ValaExpression* _tmp604_;
			ValaExpression* _tmp605_;
			ValaArrayType* _tmp606_;
			ValaDataType* _tmp607_;
			ValaDataType* _tmp608_;
			ValaDataType* _tmp609_;
			ValaDataType* _tmp610_;
			ValaArrayType* _tmp611_;
			ValaDataType* _tmp612_;
			ValaDataType* _tmp613_;
			ValaDataType* _tmp614_;
			ValaDataType* _tmp615_;
			ValaDataType* _tmp616_;
			ValaDataType* _tmp617_;
			gboolean _tmp618_;
			gboolean _tmp619_;
			_tmp581_ = vala_binary_expression_get_left (self);
			_tmp582_ = _tmp581_;
			_tmp583_ = vala_expression_get_value_type (_tmp582_);
			_tmp584_ = _tmp583_;
			array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp584_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
			_tmp585_ = array_type;
			_tmp586_ = vala_array_type_get_inline_allocated (_tmp585_);
			_tmp587_ = _tmp586_;
			if (_tmp587_) {
				ValaSourceReference* _tmp588_;
				ValaSourceReference* _tmp589_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp589_ = _tmp588_;
				vala_report_error (_tmp589_, "Array concatenation not supported for fixed length arrays");
			}
			_tmp591_ = vala_binary_expression_get_right (self);
			_tmp592_ = _tmp591_;
			_tmp593_ = vala_expression_get_value_type (_tmp592_);
			_tmp594_ = _tmp593_;
			if (_tmp594_ == NULL) {
				_tmp590_ = TRUE;
			} else {
				ValaExpression* _tmp595_;
				ValaExpression* _tmp596_;
				ValaDataType* _tmp597_;
				ValaDataType* _tmp598_;
				ValaArrayType* _tmp599_;
				ValaDataType* _tmp600_;
				ValaDataType* _tmp601_;
				_tmp595_ = vala_binary_expression_get_right (self);
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_expression_get_value_type (_tmp596_);
				_tmp598_ = _tmp597_;
				_tmp599_ = array_type;
				_tmp600_ = vala_array_type_get_element_type (_tmp599_);
				_tmp601_ = _tmp600_;
				_tmp590_ = !vala_data_type_compatible (_tmp598_, _tmp601_);
			}
			if (_tmp590_) {
				ValaSourceReference* _tmp602_;
				ValaSourceReference* _tmp603_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp602_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp603_ = _tmp602_;
				vala_report_error (_tmp603_, "Incompatible operand");
				result = FALSE;
				return result;
			}
			_tmp604_ = vala_binary_expression_get_right (self);
			_tmp605_ = _tmp604_;
			_tmp606_ = array_type;
			_tmp607_ = vala_array_type_get_element_type (_tmp606_);
			_tmp608_ = _tmp607_;
			_tmp609_ = vala_data_type_copy (_tmp608_);
			_tmp610_ = _tmp609_;
			vala_expression_set_target_type (_tmp605_, _tmp610_);
			_vala_code_node_unref0 (_tmp610_);
			_tmp611_ = array_type;
			_tmp612_ = vala_data_type_copy ((ValaDataType*) _tmp611_);
			_tmp613_ = _tmp612_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp613_);
			_vala_code_node_unref0 (_tmp613_);
			_tmp614_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp615_ = _tmp614_;
			vala_data_type_set_value_owned (_tmp615_, TRUE);
			_tmp616_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp617_ = _tmp616_;
			vala_code_node_check ((ValaCodeNode*) _tmp617_, context);
			_tmp618_ = vala_code_node_get_error ((ValaCodeNode*) self);
			_tmp619_ = _tmp618_;
			result = !_tmp619_;
			return result;
		}
	}
	_tmp620_ = self->priv->_operator;
	switch (_tmp620_) {
		case VALA_BINARY_OPERATOR_PLUS:
		case VALA_BINARY_OPERATOR_MINUS:
		case VALA_BINARY_OPERATOR_MUL:
		case VALA_BINARY_OPERATOR_DIV:
		{
			ValaExpression* _tmp621_;
			ValaExpression* _tmp622_;
			ValaDataType* _tmp623_;
			ValaDataType* _tmp624_;
			ValaDataType* _tmp667_;
			ValaDataType* _tmp668_;
			ValaDataType* _tmp680_;
			ValaDataType* _tmp681_;
			_tmp621_ = vala_binary_expression_get_left (self);
			_tmp622_ = _tmp621_;
			_tmp623_ = vala_expression_get_value_type (_tmp622_);
			_tmp624_ = _tmp623_;
			if (VALA_IS_POINTER_TYPE (_tmp624_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp625_;
				ValaExpression* _tmp626_;
				ValaDataType* _tmp627_;
				ValaDataType* _tmp628_;
				ValaPointerType* _tmp629_;
				ValaDataType* _tmp630_;
				ValaDataType* _tmp631_;
				ValaStruct* offset_type = NULL;
				ValaExpression* _tmp634_;
				ValaExpression* _tmp635_;
				ValaDataType* _tmp636_;
				ValaDataType* _tmp637_;
				ValaTypeSymbol* _tmp638_;
				ValaTypeSymbol* _tmp639_;
				gboolean _tmp640_ = FALSE;
				ValaStruct* _tmp641_;
				_tmp625_ = vala_binary_expression_get_left (self);
				_tmp626_ = _tmp625_;
				_tmp627_ = vala_expression_get_value_type (_tmp626_);
				_tmp628_ = _tmp627_;
				pointer_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp628_, VALA_TYPE_POINTER_TYPE, ValaPointerType);
				_tmp629_ = pointer_type;
				_tmp630_ = vala_pointer_type_get_base_type (_tmp629_);
				_tmp631_ = _tmp630_;
				if (VALA_IS_VOID_TYPE (_tmp631_)) {
					ValaSourceReference* _tmp632_;
					ValaSourceReference* _tmp633_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp632_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp633_ = _tmp632_;
					vala_report_error (_tmp633_, "Pointer arithmetic not supported for `void*'");
					result = FALSE;
					return result;
				}
				_tmp634_ = vala_binary_expression_get_right (self);
				_tmp635_ = _tmp634_;
				_tmp636_ = vala_expression_get_value_type (_tmp635_);
				_tmp637_ = _tmp636_;
				_tmp638_ = vala_data_type_get_type_symbol (_tmp637_);
				_tmp639_ = _tmp638_;
				offset_type = VALA_IS_STRUCT (_tmp639_) ? ((ValaStruct*) _tmp639_) : NULL;
				_tmp641_ = offset_type;
				if (_tmp641_ != NULL) {
					ValaStruct* _tmp642_;
					_tmp642_ = offset_type;
					_tmp640_ = vala_struct_is_integer_type (_tmp642_);
				} else {
					_tmp640_ = FALSE;
				}
				if (_tmp640_) {
					gboolean _tmp643_ = FALSE;
					ValaBinaryOperator _tmp644_;
					_tmp644_ = self->priv->_operator;
					if (_tmp644_ == VALA_BINARY_OPERATOR_PLUS) {
						_tmp643_ = TRUE;
					} else {
						ValaBinaryOperator _tmp645_;
						_tmp645_ = self->priv->_operator;
						_tmp643_ = _tmp645_ == VALA_BINARY_OPERATOR_MINUS;
					}
					if (_tmp643_) {
						ValaExpression* _tmp646_;
						ValaExpression* _tmp647_;
						ValaDataType* _tmp648_;
						ValaDataType* _tmp649_;
						ValaDataType* _tmp650_;
						ValaDataType* _tmp651_;
						_tmp646_ = vala_binary_expression_get_left (self);
						_tmp647_ = _tmp646_;
						_tmp648_ = vala_expression_get_value_type (_tmp647_);
						_tmp649_ = _tmp648_;
						_tmp650_ = vala_data_type_copy (_tmp649_);
						_tmp651_ = _tmp650_;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp651_);
						_vala_code_node_unref0 (_tmp651_);
					}
				} else {
					ValaExpression* _tmp652_;
					ValaExpression* _tmp653_;
					ValaDataType* _tmp654_;
					ValaDataType* _tmp655_;
					_tmp652_ = vala_binary_expression_get_right (self);
					_tmp653_ = _tmp652_;
					_tmp654_ = vala_expression_get_value_type (_tmp653_);
					_tmp655_ = _tmp654_;
					if (VALA_IS_POINTER_TYPE (_tmp655_)) {
						ValaSemanticAnalyzer* _tmp656_;
						ValaSemanticAnalyzer* _tmp657_;
						ValaDataType* _tmp658_;
						_tmp656_ = vala_code_context_get_analyzer (context);
						_tmp657_ = _tmp656_;
						_tmp658_ = _tmp657_->size_t_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp658_);
					}
				}
			} else {
				ValaExpression* _tmp659_;
				ValaExpression* _tmp660_;
				ValaDataType* _tmp661_;
				ValaDataType* _tmp662_;
				ValaExpression* _tmp663_;
				ValaExpression* _tmp664_;
				ValaDataType* _tmp665_;
				ValaDataType* _tmp666_;
				_tmp659_ = vala_binary_expression_get_left (self);
				_tmp660_ = _tmp659_;
				_tmp661_ = vala_expression_get_target_type (_tmp660_);
				_tmp662_ = _tmp661_;
				vala_data_type_set_nullable (_tmp662_, FALSE);
				_tmp663_ = vala_binary_expression_get_right (self);
				_tmp664_ = _tmp663_;
				_tmp665_ = vala_expression_get_target_type (_tmp664_);
				_tmp666_ = _tmp665_;
				vala_data_type_set_nullable (_tmp666_, FALSE);
			}
			_tmp667_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp668_ = _tmp667_;
			if (_tmp668_ == NULL) {
				ValaSemanticAnalyzer* _tmp669_;
				ValaSemanticAnalyzer* _tmp670_;
				ValaExpression* _tmp671_;
				ValaExpression* _tmp672_;
				ValaDataType* _tmp673_;
				ValaDataType* _tmp674_;
				ValaExpression* _tmp675_;
				ValaExpression* _tmp676_;
				ValaDataType* _tmp677_;
				ValaDataType* _tmp678_;
				ValaDataType* _tmp679_;
				_tmp669_ = vala_code_context_get_analyzer (context);
				_tmp670_ = _tmp669_;
				_tmp671_ = vala_binary_expression_get_left (self);
				_tmp672_ = _tmp671_;
				_tmp673_ = vala_expression_get_target_type (_tmp672_);
				_tmp674_ = _tmp673_;
				_tmp675_ = vala_binary_expression_get_right (self);
				_tmp676_ = _tmp675_;
				_tmp677_ = vala_expression_get_target_type (_tmp676_);
				_tmp678_ = _tmp677_;
				_tmp679_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp670_, _tmp674_, _tmp678_);
				vala_expression_set_value_type ((ValaExpression*) self, _tmp679_);
			}
			_tmp680_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp681_ = _tmp680_;
			if (_tmp681_ == NULL) {
				ValaSourceReference* _tmp682_;
				ValaSourceReference* _tmp683_;
				ValaExpression* _tmp684_;
				ValaExpression* _tmp685_;
				ValaDataType* _tmp686_;
				ValaDataType* _tmp687_;
				gchar* _tmp688_;
				gchar* _tmp689_;
				ValaExpression* _tmp690_;
				ValaExpression* _tmp691_;
				ValaDataType* _tmp692_;
				ValaDataType* _tmp693_;
				gchar* _tmp694_;
				gchar* _tmp695_;
				gchar* _tmp696_;
				gchar* _tmp697_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp682_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_binary_expression_get_left (self);
				_tmp685_ = _tmp684_;
				_tmp686_ = vala_expression_get_value_type (_tmp685_);
				_tmp687_ = _tmp686_;
				_tmp688_ = vala_code_node_to_string ((ValaCodeNode*) _tmp687_);
				_tmp689_ = _tmp688_;
				_tmp690_ = vala_binary_expression_get_right (self);
				_tmp691_ = _tmp690_;
				_tmp692_ = vala_expression_get_value_type (_tmp691_);
				_tmp693_ = _tmp692_;
				_tmp694_ = vala_code_node_to_string ((ValaCodeNode*) _tmp693_);
				_tmp695_ = _tmp694_;
				_tmp696_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp689_, _tmp695_);
				_tmp697_ = _tmp696_;
				vala_report_error (_tmp683_, _tmp697_);
				_g_free0 (_tmp697_);
				_g_free0 (_tmp695_);
				_g_free0 (_tmp689_);
				result = FALSE;
				return result;
			}
			break;
		}
		case VALA_BINARY_OPERATOR_MOD:
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			ValaExpression* _tmp698_;
			ValaExpression* _tmp699_;
			ValaDataType* _tmp700_;
			ValaDataType* _tmp701_;
			ValaExpression* _tmp702_;
			ValaExpression* _tmp703_;
			ValaDataType* _tmp704_;
			ValaDataType* _tmp705_;
			ValaSemanticAnalyzer* _tmp706_;
			ValaSemanticAnalyzer* _tmp707_;
			ValaExpression* _tmp708_;
			ValaExpression* _tmp709_;
			ValaDataType* _tmp710_;
			ValaDataType* _tmp711_;
			ValaExpression* _tmp712_;
			ValaExpression* _tmp713_;
			ValaDataType* _tmp714_;
			ValaDataType* _tmp715_;
			ValaDataType* _tmp716_;
			ValaDataType* _tmp717_;
			ValaDataType* _tmp718_;
			_tmp698_ = vala_binary_expression_get_left (self);
			_tmp699_ = _tmp698_;
			_tmp700_ = vala_expression_get_target_type (_tmp699_);
			_tmp701_ = _tmp700_;
			vala_data_type_set_nullable (_tmp701_, FALSE);
			_tmp702_ = vala_binary_expression_get_right (self);
			_tmp703_ = _tmp702_;
			_tmp704_ = vala_expression_get_target_type (_tmp703_);
			_tmp705_ = _tmp704_;
			vala_data_type_set_nullable (_tmp705_, FALSE);
			_tmp706_ = vala_code_context_get_analyzer (context);
			_tmp707_ = _tmp706_;
			_tmp708_ = vala_binary_expression_get_left (self);
			_tmp709_ = _tmp708_;
			_tmp710_ = vala_expression_get_target_type (_tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = vala_binary_expression_get_right (self);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_expression_get_target_type (_tmp713_);
			_tmp715_ = _tmp714_;
			_tmp716_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp707_, _tmp711_, _tmp715_);
			vala_expression_set_value_type ((ValaExpression*) self, _tmp716_);
			_tmp717_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp718_ = _tmp717_;
			if (_tmp718_ == NULL) {
				ValaSourceReference* _tmp719_;
				ValaSourceReference* _tmp720_;
				ValaExpression* _tmp721_;
				ValaExpression* _tmp722_;
				ValaDataType* _tmp723_;
				ValaDataType* _tmp724_;
				gchar* _tmp725_;
				gchar* _tmp726_;
				ValaExpression* _tmp727_;
				ValaExpression* _tmp728_;
				ValaDataType* _tmp729_;
				ValaDataType* _tmp730_;
				gchar* _tmp731_;
				gchar* _tmp732_;
				gchar* _tmp733_;
				gchar* _tmp734_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp719_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp720_ = _tmp719_;
				_tmp721_ = vala_binary_expression_get_left (self);
				_tmp722_ = _tmp721_;
				_tmp723_ = vala_expression_get_value_type (_tmp722_);
				_tmp724_ = _tmp723_;
				_tmp725_ = vala_code_node_to_string ((ValaCodeNode*) _tmp724_);
				_tmp726_ = _tmp725_;
				_tmp727_ = vala_binary_expression_get_right (self);
				_tmp728_ = _tmp727_;
				_tmp729_ = vala_expression_get_value_type (_tmp728_);
				_tmp730_ = _tmp729_;
				_tmp731_ = vala_code_node_to_string ((ValaCodeNode*) _tmp730_);
				_tmp732_ = _tmp731_;
				_tmp733_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp726_, _tmp732_);
				_tmp734_ = _tmp733_;
				vala_report_error (_tmp720_, _tmp734_);
				_g_free0 (_tmp734_);
				_g_free0 (_tmp732_);
				_g_free0 (_tmp726_);
				result = FALSE;
				return result;
			}
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			gboolean _tmp735_ = FALSE;
			ValaExpression* _tmp736_;
			ValaExpression* _tmp737_;
			ValaDataType* _tmp738_;
			ValaDataType* _tmp739_;
			ValaSemanticAnalyzer* _tmp740_;
			ValaSemanticAnalyzer* _tmp741_;
			ValaDataType* _tmp742_;
			ValaSemanticAnalyzer* _tmp824_;
			ValaSemanticAnalyzer* _tmp825_;
			ValaDataType* _tmp826_;
			_tmp736_ = vala_binary_expression_get_left (self);
			_tmp737_ = _tmp736_;
			_tmp738_ = vala_expression_get_value_type (_tmp737_);
			_tmp739_ = _tmp738_;
			_tmp740_ = vala_code_context_get_analyzer (context);
			_tmp741_ = _tmp740_;
			_tmp742_ = _tmp741_->string_type;
			if (vala_data_type_compatible (_tmp739_, _tmp742_)) {
				ValaExpression* _tmp743_;
				ValaExpression* _tmp744_;
				ValaDataType* _tmp745_;
				ValaDataType* _tmp746_;
				ValaSemanticAnalyzer* _tmp747_;
				ValaSemanticAnalyzer* _tmp748_;
				ValaDataType* _tmp749_;
				_tmp743_ = vala_binary_expression_get_right (self);
				_tmp744_ = _tmp743_;
				_tmp745_ = vala_expression_get_value_type (_tmp744_);
				_tmp746_ = _tmp745_;
				_tmp747_ = vala_code_context_get_analyzer (context);
				_tmp748_ = _tmp747_;
				_tmp749_ = _tmp748_->string_type;
				_tmp735_ = vala_data_type_compatible (_tmp746_, _tmp749_);
			} else {
				_tmp735_ = FALSE;
			}
			if (_tmp735_) {
			} else {
				gboolean _tmp750_ = FALSE;
				ValaExpression* _tmp751_;
				ValaExpression* _tmp752_;
				ValaDataType* _tmp753_;
				ValaDataType* _tmp754_;
				_tmp751_ = vala_binary_expression_get_left (self);
				_tmp752_ = _tmp751_;
				_tmp753_ = vala_expression_get_value_type (_tmp752_);
				_tmp754_ = _tmp753_;
				if (VALA_IS_POINTER_TYPE (_tmp754_)) {
					ValaExpression* _tmp755_;
					ValaExpression* _tmp756_;
					ValaDataType* _tmp757_;
					ValaDataType* _tmp758_;
					_tmp755_ = vala_binary_expression_get_right (self);
					_tmp756_ = _tmp755_;
					_tmp757_ = vala_expression_get_value_type (_tmp756_);
					_tmp758_ = _tmp757_;
					_tmp750_ = VALA_IS_POINTER_TYPE (_tmp758_);
				} else {
					_tmp750_ = FALSE;
				}
				if (_tmp750_) {
				} else {
					ValaDataType* resulting_type = NULL;
					gboolean _tmp759_;
					ValaDataType* _tmp788_;
					gboolean _tmp805_;
					ValaExpression* _tmp811_;
					ValaExpression* _tmp812_;
					ValaDataType* _tmp813_;
					ValaDataType* _tmp814_;
					ValaDataType* _tmp815_;
					ValaExpression* _tmp816_;
					ValaExpression* _tmp817_;
					ValaDataType* _tmp818_;
					ValaDataType* _tmp819_;
					ValaExpression* _tmp820_;
					ValaExpression* _tmp821_;
					ValaDataType* _tmp822_;
					ValaDataType* _tmp823_;
					_tmp759_ = self->priv->_is_chained;
					if (_tmp759_) {
						ValaBinaryExpression* lbe = NULL;
						ValaExpression* _tmp760_;
						ValaExpression* _tmp761_;
						ValaBinaryExpression* _tmp762_;
						ValaSemanticAnalyzer* _tmp763_;
						ValaSemanticAnalyzer* _tmp764_;
						ValaBinaryExpression* _tmp765_;
						ValaExpression* _tmp766_;
						ValaExpression* _tmp767_;
						ValaDataType* _tmp768_;
						ValaDataType* _tmp769_;
						ValaExpression* _tmp770_;
						ValaExpression* _tmp771_;
						ValaDataType* _tmp772_;
						ValaDataType* _tmp773_;
						ValaDataType* _tmp774_;
						ValaDataType* _tmp775_;
						_tmp760_ = vala_binary_expression_get_left (self);
						_tmp761_ = _tmp760_;
						_tmp762_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp761_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
						lbe = _tmp762_;
						_tmp763_ = vala_code_context_get_analyzer (context);
						_tmp764_ = _tmp763_;
						_tmp765_ = lbe;
						_tmp766_ = vala_binary_expression_get_right (_tmp765_);
						_tmp767_ = _tmp766_;
						_tmp768_ = vala_expression_get_target_type (_tmp767_);
						_tmp769_ = _tmp768_;
						_tmp770_ = vala_binary_expression_get_right (self);
						_tmp771_ = _tmp770_;
						_tmp772_ = vala_expression_get_target_type (_tmp771_);
						_tmp773_ = _tmp772_;
						_tmp774_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp764_, _tmp769_, _tmp773_);
						_tmp775_ = _vala_code_node_ref0 (_tmp774_);
						_vala_code_node_unref0 (resulting_type);
						resulting_type = _tmp775_;
						_vala_code_node_unref0 (lbe);
					} else {
						ValaSemanticAnalyzer* _tmp776_;
						ValaSemanticAnalyzer* _tmp777_;
						ValaExpression* _tmp778_;
						ValaExpression* _tmp779_;
						ValaDataType* _tmp780_;
						ValaDataType* _tmp781_;
						ValaExpression* _tmp782_;
						ValaExpression* _tmp783_;
						ValaDataType* _tmp784_;
						ValaDataType* _tmp785_;
						ValaDataType* _tmp786_;
						ValaDataType* _tmp787_;
						_tmp776_ = vala_code_context_get_analyzer (context);
						_tmp777_ = _tmp776_;
						_tmp778_ = vala_binary_expression_get_left (self);
						_tmp779_ = _tmp778_;
						_tmp780_ = vala_expression_get_target_type (_tmp779_);
						_tmp781_ = _tmp780_;
						_tmp782_ = vala_binary_expression_get_right (self);
						_tmp783_ = _tmp782_;
						_tmp784_ = vala_expression_get_target_type (_tmp783_);
						_tmp785_ = _tmp784_;
						_tmp786_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp777_, _tmp781_, _tmp785_);
						_tmp787_ = _vala_code_node_ref0 (_tmp786_);
						_vala_code_node_unref0 (resulting_type);
						resulting_type = _tmp787_;
					}
					_tmp788_ = resulting_type;
					if (_tmp788_ == NULL) {
						ValaSourceReference* _tmp789_;
						ValaSourceReference* _tmp790_;
						ValaExpression* _tmp791_;
						ValaExpression* _tmp792_;
						ValaDataType* _tmp793_;
						ValaDataType* _tmp794_;
						gchar* _tmp795_;
						gchar* _tmp796_;
						ValaExpression* _tmp797_;
						ValaExpression* _tmp798_;
						ValaDataType* _tmp799_;
						ValaDataType* _tmp800_;
						gchar* _tmp801_;
						gchar* _tmp802_;
						gchar* _tmp803_;
						gchar* _tmp804_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp789_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp790_ = _tmp789_;
						_tmp791_ = vala_binary_expression_get_left (self);
						_tmp792_ = _tmp791_;
						_tmp793_ = vala_expression_get_value_type (_tmp792_);
						_tmp794_ = _tmp793_;
						_tmp795_ = vala_code_node_to_string ((ValaCodeNode*) _tmp794_);
						_tmp796_ = _tmp795_;
						_tmp797_ = vala_binary_expression_get_right (self);
						_tmp798_ = _tmp797_;
						_tmp799_ = vala_expression_get_value_type (_tmp798_);
						_tmp800_ = _tmp799_;
						_tmp801_ = vala_code_node_to_string ((ValaCodeNode*) _tmp800_);
						_tmp802_ = _tmp801_;
						_tmp803_ = g_strdup_printf ("Relational operation not supported for types `%s' and `%s'", _tmp796_, _tmp802_);
						_tmp804_ = _tmp803_;
						vala_report_error (_tmp790_, _tmp804_);
						_g_free0 (_tmp804_);
						_g_free0 (_tmp802_);
						_g_free0 (_tmp796_);
						result = FALSE;
						_vala_code_node_unref0 (resulting_type);
						return result;
					}
					_tmp805_ = self->priv->_is_chained;
					if (!_tmp805_) {
						ValaExpression* _tmp806_;
						ValaExpression* _tmp807_;
						ValaDataType* _tmp808_;
						ValaDataType* _tmp809_;
						ValaDataType* _tmp810_;
						_tmp806_ = vala_binary_expression_get_left (self);
						_tmp807_ = _tmp806_;
						_tmp808_ = resulting_type;
						_tmp809_ = vala_data_type_copy (_tmp808_);
						_tmp810_ = _tmp809_;
						vala_expression_set_target_type (_tmp807_, _tmp810_);
						_vala_code_node_unref0 (_tmp810_);
					}
					_tmp811_ = vala_binary_expression_get_right (self);
					_tmp812_ = _tmp811_;
					_tmp813_ = resulting_type;
					_tmp814_ = vala_data_type_copy (_tmp813_);
					_tmp815_ = _tmp814_;
					vala_expression_set_target_type (_tmp812_, _tmp815_);
					_vala_code_node_unref0 (_tmp815_);
					_tmp816_ = vala_binary_expression_get_left (self);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_expression_get_target_type (_tmp817_);
					_tmp819_ = _tmp818_;
					vala_data_type_set_nullable (_tmp819_, FALSE);
					_tmp820_ = vala_binary_expression_get_right (self);
					_tmp821_ = _tmp820_;
					_tmp822_ = vala_expression_get_target_type (_tmp821_);
					_tmp823_ = _tmp822_;
					vala_data_type_set_nullable (_tmp823_, FALSE);
					_vala_code_node_unref0 (resulting_type);
				}
			}
			_tmp824_ = vala_code_context_get_analyzer (context);
			_tmp825_ = _tmp824_;
			_tmp826_ = _tmp825_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp826_);
			break;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			ValaProfile _tmp827_;
			ValaProfile _tmp828_;
			gboolean _tmp897_ = FALSE;
			ValaExpression* _tmp898_;
			ValaExpression* _tmp899_;
			ValaDataType* _tmp900_;
			ValaDataType* _tmp901_;
			ValaExpression* _tmp902_;
			ValaExpression* _tmp903_;
			ValaDataType* _tmp904_;
			ValaDataType* _tmp905_;
			ValaDataType* resulting_type = NULL;
			ValaSemanticAnalyzer* _tmp930_;
			ValaSemanticAnalyzer* _tmp931_;
			ValaExpression* _tmp932_;
			ValaExpression* _tmp933_;
			ValaDataType* _tmp934_;
			ValaDataType* _tmp935_;
			ValaExpression* _tmp936_;
			ValaExpression* _tmp937_;
			ValaDataType* _tmp938_;
			ValaDataType* _tmp939_;
			ValaDataType* _tmp940_;
			ValaDataType* _tmp941_;
			ValaDataType* _tmp942_;
			ValaExpression* _tmp953_;
			ValaExpression* _tmp954_;
			ValaDataType* _tmp955_;
			ValaDataType* _tmp956_;
			ValaExpression* _tmp957_;
			ValaExpression* _tmp958_;
			ValaDataType* _tmp959_;
			ValaDataType* _tmp960_;
			ValaExpression* _tmp961_;
			ValaExpression* _tmp962_;
			ValaDataType* _tmp963_;
			ValaDataType* _tmp964_;
			gboolean _tmp965_;
			gboolean _tmp966_;
			ValaExpression* _tmp967_;
			ValaExpression* _tmp968_;
			ValaDataType* _tmp969_;
			ValaDataType* _tmp970_;
			gboolean _tmp971_;
			gboolean _tmp972_;
			ValaSemanticAnalyzer* _tmp981_;
			ValaSemanticAnalyzer* _tmp982_;
			ValaDataType* _tmp983_;
			_tmp827_ = vala_code_context_get_profile (context);
			_tmp828_ = _tmp827_;
			if (_tmp828_ == VALA_PROFILE_GOBJECT) {
				ValaTypeSymbol* gvalue_type = NULL;
				ValaSemanticAnalyzer* _tmp829_;
				ValaSemanticAnalyzer* _tmp830_;
				ValaStructValueType* _tmp831_;
				ValaTypeSymbol* _tmp832_;
				ValaTypeSymbol* _tmp833_;
				ValaTypeSymbol* _tmp834_;
				gboolean _tmp835_ = FALSE;
				gboolean _tmp836_ = FALSE;
				ValaExpression* _tmp837_;
				ValaExpression* _tmp838_;
				ValaDataType* _tmp839_;
				ValaDataType* _tmp840_;
				ValaTypeSymbol* _tmp841_;
				ValaTypeSymbol* _tmp842_;
				ValaTypeSymbol* _tmp843_;
				_tmp829_ = vala_code_context_get_analyzer (context);
				_tmp830_ = _tmp829_;
				_tmp831_ = _tmp830_->gvalue_type;
				_tmp832_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp831_);
				_tmp833_ = _tmp832_;
				_tmp834_ = _vala_code_node_ref0 (_tmp833_);
				gvalue_type = _tmp834_;
				_tmp837_ = vala_binary_expression_get_left (self);
				_tmp838_ = _tmp837_;
				_tmp839_ = vala_expression_get_target_type (_tmp838_);
				_tmp840_ = _tmp839_;
				_tmp841_ = vala_data_type_get_type_symbol (_tmp840_);
				_tmp842_ = _tmp841_;
				_tmp843_ = gvalue_type;
				if (_tmp842_ == _tmp843_) {
					ValaExpression* _tmp844_;
					ValaExpression* _tmp845_;
					ValaDataType* _tmp846_;
					ValaDataType* _tmp847_;
					ValaTypeSymbol* _tmp848_;
					ValaTypeSymbol* _tmp849_;
					ValaTypeSymbol* _tmp850_;
					_tmp844_ = vala_binary_expression_get_right (self);
					_tmp845_ = _tmp844_;
					_tmp846_ = vala_expression_get_target_type (_tmp845_);
					_tmp847_ = _tmp846_;
					_tmp848_ = vala_data_type_get_type_symbol (_tmp847_);
					_tmp849_ = _tmp848_;
					_tmp850_ = gvalue_type;
					_tmp836_ = _tmp849_ != _tmp850_;
				} else {
					_tmp836_ = FALSE;
				}
				if (_tmp836_) {
					_tmp835_ = TRUE;
				} else {
					gboolean _tmp851_ = FALSE;
					ValaExpression* _tmp852_;
					ValaExpression* _tmp853_;
					ValaDataType* _tmp854_;
					ValaDataType* _tmp855_;
					ValaTypeSymbol* _tmp856_;
					ValaTypeSymbol* _tmp857_;
					ValaTypeSymbol* _tmp858_;
					_tmp852_ = vala_binary_expression_get_left (self);
					_tmp853_ = _tmp852_;
					_tmp854_ = vala_expression_get_target_type (_tmp853_);
					_tmp855_ = _tmp854_;
					_tmp856_ = vala_data_type_get_type_symbol (_tmp855_);
					_tmp857_ = _tmp856_;
					_tmp858_ = gvalue_type;
					if (_tmp857_ != _tmp858_) {
						ValaExpression* _tmp859_;
						ValaExpression* _tmp860_;
						ValaDataType* _tmp861_;
						ValaDataType* _tmp862_;
						ValaTypeSymbol* _tmp863_;
						ValaTypeSymbol* _tmp864_;
						ValaTypeSymbol* _tmp865_;
						_tmp859_ = vala_binary_expression_get_right (self);
						_tmp860_ = _tmp859_;
						_tmp861_ = vala_expression_get_target_type (_tmp860_);
						_tmp862_ = _tmp861_;
						_tmp863_ = vala_data_type_get_type_symbol (_tmp862_);
						_tmp864_ = _tmp863_;
						_tmp865_ = gvalue_type;
						_tmp851_ = _tmp864_ == _tmp865_;
					} else {
						_tmp851_ = FALSE;
					}
					_tmp835_ = _tmp851_;
				}
				if (_tmp835_) {
					ValaExpression* gvalue_expr = NULL;
					ValaDataType* target_type = NULL;
					ValaExpression* _tmp866_;
					ValaExpression* _tmp867_;
					ValaDataType* _tmp868_;
					ValaDataType* _tmp869_;
					ValaTypeSymbol* _tmp870_;
					ValaTypeSymbol* _tmp871_;
					ValaTypeSymbol* _tmp872_;
					ValaCastExpression* cast_expr = NULL;
					ValaExpression* _tmp889_;
					ValaDataType* _tmp890_;
					ValaExpression* _tmp891_;
					ValaSourceReference* _tmp892_;
					ValaSourceReference* _tmp893_;
					ValaCastExpression* _tmp894_;
					ValaExpression* _tmp895_;
					ValaCastExpression* _tmp896_;
					_tmp866_ = vala_binary_expression_get_left (self);
					_tmp867_ = _tmp866_;
					_tmp868_ = vala_expression_get_target_type (_tmp867_);
					_tmp869_ = _tmp868_;
					_tmp870_ = vala_data_type_get_type_symbol (_tmp869_);
					_tmp871_ = _tmp870_;
					_tmp872_ = gvalue_type;
					if (_tmp871_ == _tmp872_) {
						ValaExpression* _tmp873_;
						ValaExpression* _tmp874_;
						ValaExpression* _tmp875_;
						ValaExpression* _tmp876_;
						ValaExpression* _tmp877_;
						ValaDataType* _tmp878_;
						ValaDataType* _tmp879_;
						ValaDataType* _tmp880_;
						_tmp873_ = vala_binary_expression_get_left (self);
						_tmp874_ = _tmp873_;
						_tmp875_ = _vala_code_node_ref0 (_tmp874_);
						_vala_code_node_unref0 (gvalue_expr);
						gvalue_expr = _tmp875_;
						_tmp876_ = vala_binary_expression_get_right (self);
						_tmp877_ = _tmp876_;
						_tmp878_ = vala_expression_get_target_type (_tmp877_);
						_tmp879_ = _tmp878_;
						_tmp880_ = _vala_code_node_ref0 (_tmp879_);
						_vala_code_node_unref0 (target_type);
						target_type = _tmp880_;
					} else {
						ValaExpression* _tmp881_;
						ValaExpression* _tmp882_;
						ValaExpression* _tmp883_;
						ValaExpression* _tmp884_;
						ValaExpression* _tmp885_;
						ValaDataType* _tmp886_;
						ValaDataType* _tmp887_;
						ValaDataType* _tmp888_;
						_tmp881_ = vala_binary_expression_get_right (self);
						_tmp882_ = _tmp881_;
						_tmp883_ = _vala_code_node_ref0 (_tmp882_);
						_vala_code_node_unref0 (gvalue_expr);
						gvalue_expr = _tmp883_;
						_tmp884_ = vala_binary_expression_get_left (self);
						_tmp885_ = _tmp884_;
						_tmp886_ = vala_expression_get_target_type (_tmp885_);
						_tmp887_ = _tmp886_;
						_tmp888_ = _vala_code_node_ref0 (_tmp887_);
						_vala_code_node_unref0 (target_type);
						target_type = _tmp888_;
					}
					_tmp889_ = gvalue_expr;
					_tmp890_ = target_type;
					_tmp891_ = gvalue_expr;
					_tmp892_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp891_);
					_tmp893_ = _tmp892_;
					_tmp894_ = vala_cast_expression_new (_tmp889_, _tmp890_, _tmp893_);
					cast_expr = _tmp894_;
					_tmp895_ = gvalue_expr;
					_tmp896_ = cast_expr;
					vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp895_, (ValaExpression*) _tmp896_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					result = vala_code_node_check ((ValaCodeNode*) self, context);
					_vala_code_node_unref0 (cast_expr);
					_vala_code_node_unref0 (target_type);
					_vala_code_node_unref0 (gvalue_expr);
					_vala_code_node_unref0 (gvalue_type);
					return result;
				}
				_vala_code_node_unref0 (gvalue_type);
			}
			_tmp898_ = vala_binary_expression_get_right (self);
			_tmp899_ = _tmp898_;
			_tmp900_ = vala_expression_get_value_type (_tmp899_);
			_tmp901_ = _tmp900_;
			_tmp902_ = vala_binary_expression_get_left (self);
			_tmp903_ = _tmp902_;
			_tmp904_ = vala_expression_get_value_type (_tmp903_);
			_tmp905_ = _tmp904_;
			if (!vala_data_type_compatible (_tmp901_, _tmp905_)) {
				ValaExpression* _tmp906_;
				ValaExpression* _tmp907_;
				ValaDataType* _tmp908_;
				ValaDataType* _tmp909_;
				ValaExpression* _tmp910_;
				ValaExpression* _tmp911_;
				ValaDataType* _tmp912_;
				ValaDataType* _tmp913_;
				_tmp906_ = vala_binary_expression_get_left (self);
				_tmp907_ = _tmp906_;
				_tmp908_ = vala_expression_get_value_type (_tmp907_);
				_tmp909_ = _tmp908_;
				_tmp910_ = vala_binary_expression_get_right (self);
				_tmp911_ = _tmp910_;
				_tmp912_ = vala_expression_get_value_type (_tmp911_);
				_tmp913_ = _tmp912_;
				_tmp897_ = !vala_data_type_compatible (_tmp909_, _tmp913_);
			} else {
				_tmp897_ = FALSE;
			}
			if (_tmp897_) {
				ValaSourceReference* _tmp914_;
				ValaSourceReference* _tmp915_;
				ValaExpression* _tmp916_;
				ValaExpression* _tmp917_;
				ValaDataType* _tmp918_;
				ValaDataType* _tmp919_;
				gchar* _tmp920_;
				gchar* _tmp921_;
				ValaExpression* _tmp922_;
				ValaExpression* _tmp923_;
				ValaDataType* _tmp924_;
				ValaDataType* _tmp925_;
				gchar* _tmp926_;
				gchar* _tmp927_;
				gchar* _tmp928_;
				gchar* _tmp929_;
				_tmp914_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp915_ = _tmp914_;
				_tmp916_ = vala_binary_expression_get_right (self);
				_tmp917_ = _tmp916_;
				_tmp918_ = vala_expression_get_value_type (_tmp917_);
				_tmp919_ = _tmp918_;
				_tmp920_ = vala_code_node_to_string ((ValaCodeNode*) _tmp919_);
				_tmp921_ = _tmp920_;
				_tmp922_ = vala_binary_expression_get_left (self);
				_tmp923_ = _tmp922_;
				_tmp924_ = vala_expression_get_value_type (_tmp923_);
				_tmp925_ = _tmp924_;
				_tmp926_ = vala_code_node_to_string ((ValaCodeNode*) _tmp925_);
				_tmp927_ = _tmp926_;
				_tmp928_ = g_strdup_printf ("Equality operation: `%s' and `%s' are incompatible", _tmp921_, _tmp927_);
				_tmp929_ = _tmp928_;
				vala_report_error (_tmp915_, _tmp929_);
				_g_free0 (_tmp929_);
				_g_free0 (_tmp927_);
				_g_free0 (_tmp921_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp930_ = vala_code_context_get_analyzer (context);
			_tmp931_ = _tmp930_;
			_tmp932_ = vala_binary_expression_get_left (self);
			_tmp933_ = _tmp932_;
			_tmp934_ = vala_expression_get_target_type (_tmp933_);
			_tmp935_ = _tmp934_;
			_tmp936_ = vala_binary_expression_get_right (self);
			_tmp937_ = _tmp936_;
			_tmp938_ = vala_expression_get_target_type (_tmp937_);
			_tmp939_ = _tmp938_;
			_tmp940_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp931_, _tmp935_, _tmp939_);
			_tmp941_ = _vala_code_node_ref0 (_tmp940_);
			resulting_type = _tmp941_;
			_tmp942_ = resulting_type;
			if (_tmp942_ != NULL) {
				ValaExpression* _tmp943_;
				ValaExpression* _tmp944_;
				ValaDataType* _tmp945_;
				ValaDataType* _tmp946_;
				ValaDataType* _tmp947_;
				ValaExpression* _tmp948_;
				ValaExpression* _tmp949_;
				ValaDataType* _tmp950_;
				ValaDataType* _tmp951_;
				ValaDataType* _tmp952_;
				_tmp943_ = vala_binary_expression_get_left (self);
				_tmp944_ = _tmp943_;
				_tmp945_ = resulting_type;
				_tmp946_ = vala_data_type_copy (_tmp945_);
				_tmp947_ = _tmp946_;
				vala_expression_set_target_type (_tmp944_, _tmp947_);
				_vala_code_node_unref0 (_tmp947_);
				_tmp948_ = vala_binary_expression_get_right (self);
				_tmp949_ = _tmp948_;
				_tmp950_ = resulting_type;
				_tmp951_ = vala_data_type_copy (_tmp950_);
				_tmp952_ = _tmp951_;
				vala_expression_set_target_type (_tmp949_, _tmp952_);
				_vala_code_node_unref0 (_tmp952_);
			}
			_tmp953_ = vala_binary_expression_get_left (self);
			_tmp954_ = _tmp953_;
			_tmp955_ = vala_expression_get_target_type (_tmp954_);
			_tmp956_ = _tmp955_;
			vala_data_type_set_value_owned (_tmp956_, FALSE);
			_tmp957_ = vala_binary_expression_get_right (self);
			_tmp958_ = _tmp957_;
			_tmp959_ = vala_expression_get_target_type (_tmp958_);
			_tmp960_ = _tmp959_;
			vala_data_type_set_value_owned (_tmp960_, FALSE);
			_tmp961_ = vala_binary_expression_get_left (self);
			_tmp962_ = _tmp961_;
			_tmp963_ = vala_expression_get_value_type (_tmp962_);
			_tmp964_ = _tmp963_;
			_tmp965_ = vala_data_type_get_nullable (_tmp964_);
			_tmp966_ = _tmp965_;
			_tmp967_ = vala_binary_expression_get_right (self);
			_tmp968_ = _tmp967_;
			_tmp969_ = vala_expression_get_value_type (_tmp968_);
			_tmp970_ = _tmp969_;
			_tmp971_ = vala_data_type_get_nullable (_tmp970_);
			_tmp972_ = _tmp971_;
			if (_tmp966_ != _tmp972_) {
				ValaExpression* _tmp973_;
				ValaExpression* _tmp974_;
				ValaDataType* _tmp975_;
				ValaDataType* _tmp976_;
				ValaExpression* _tmp977_;
				ValaExpression* _tmp978_;
				ValaDataType* _tmp979_;
				ValaDataType* _tmp980_;
				_tmp973_ = vala_binary_expression_get_left (self);
				_tmp974_ = _tmp973_;
				_tmp975_ = vala_expression_get_target_type (_tmp974_);
				_tmp976_ = _tmp975_;
				vala_data_type_set_nullable (_tmp976_, TRUE);
				_tmp977_ = vala_binary_expression_get_right (self);
				_tmp978_ = _tmp977_;
				_tmp979_ = vala_expression_get_target_type (_tmp978_);
				_tmp980_ = _tmp979_;
				vala_data_type_set_nullable (_tmp980_, TRUE);
			}
			_tmp981_ = vala_code_context_get_analyzer (context);
			_tmp982_ = _tmp981_;
			_tmp983_ = _tmp982_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp983_);
			_vala_code_node_unref0 (resulting_type);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			ValaExpression* _tmp984_;
			ValaExpression* _tmp985_;
			ValaDataType* _tmp986_;
			ValaDataType* _tmp987_;
			ValaExpression* _tmp988_;
			ValaExpression* _tmp989_;
			ValaDataType* _tmp990_;
			ValaDataType* _tmp991_;
			gboolean _tmp992_ = FALSE;
			ValaExpression* _tmp993_;
			ValaExpression* _tmp994_;
			ValaDataType* _tmp995_;
			ValaDataType* _tmp996_;
			ValaSemanticAnalyzer* _tmp997_;
			ValaSemanticAnalyzer* _tmp998_;
			ValaDataType* _tmp999_;
			_tmp984_ = vala_binary_expression_get_left (self);
			_tmp985_ = _tmp984_;
			_tmp986_ = vala_expression_get_target_type (_tmp985_);
			_tmp987_ = _tmp986_;
			vala_data_type_set_nullable (_tmp987_, FALSE);
			_tmp988_ = vala_binary_expression_get_right (self);
			_tmp989_ = _tmp988_;
			_tmp990_ = vala_expression_get_target_type (_tmp989_);
			_tmp991_ = _tmp990_;
			vala_data_type_set_nullable (_tmp991_, FALSE);
			_tmp993_ = vala_binary_expression_get_left (self);
			_tmp994_ = _tmp993_;
			_tmp995_ = vala_expression_get_value_type (_tmp994_);
			_tmp996_ = _tmp995_;
			_tmp997_ = vala_code_context_get_analyzer (context);
			_tmp998_ = _tmp997_;
			_tmp999_ = _tmp998_->bool_type;
			if (vala_data_type_compatible (_tmp996_, _tmp999_)) {
				ValaExpression* _tmp1000_;
				ValaExpression* _tmp1001_;
				ValaDataType* _tmp1002_;
				ValaDataType* _tmp1003_;
				ValaSemanticAnalyzer* _tmp1004_;
				ValaSemanticAnalyzer* _tmp1005_;
				ValaDataType* _tmp1006_;
				_tmp1000_ = vala_binary_expression_get_right (self);
				_tmp1001_ = _tmp1000_;
				_tmp1002_ = vala_expression_get_value_type (_tmp1001_);
				_tmp1003_ = _tmp1002_;
				_tmp1004_ = vala_code_context_get_analyzer (context);
				_tmp1005_ = _tmp1004_;
				_tmp1006_ = _tmp1005_->bool_type;
				_tmp992_ = !vala_data_type_compatible (_tmp1003_, _tmp1006_);
			} else {
				_tmp992_ = FALSE;
			}
			if (_tmp992_) {
				ValaExpression* _tmp1007_;
				ValaExpression* _tmp1008_;
				ValaDataType* _tmp1009_;
				ValaDataType* _tmp1010_;
				ValaDataType* _tmp1011_;
				ValaDataType* _tmp1012_;
				_tmp1007_ = vala_binary_expression_get_right (self);
				_tmp1008_ = _tmp1007_;
				_tmp1009_ = vala_expression_get_target_type (_tmp1008_);
				_tmp1010_ = _tmp1009_;
				_tmp1011_ = vala_data_type_copy (_tmp1010_);
				_tmp1012_ = _tmp1011_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp1012_);
				_vala_code_node_unref0 (_tmp1012_);
			} else {
				ValaExpression* _tmp1013_;
				ValaExpression* _tmp1014_;
				ValaDataType* _tmp1015_;
				ValaDataType* _tmp1016_;
				ValaDataType* _tmp1017_;
				ValaDataType* _tmp1018_;
				_tmp1013_ = vala_binary_expression_get_left (self);
				_tmp1014_ = _tmp1013_;
				_tmp1015_ = vala_expression_get_target_type (_tmp1014_);
				_tmp1016_ = _tmp1015_;
				_tmp1017_ = vala_data_type_copy (_tmp1016_);
				_tmp1018_ = _tmp1017_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp1018_);
				_vala_code_node_unref0 (_tmp1018_);
			}
			break;
		}
		case VALA_BINARY_OPERATOR_AND:
		case VALA_BINARY_OPERATOR_OR:
		{
			gboolean _tmp1019_ = FALSE;
			ValaExpression* _tmp1020_;
			ValaExpression* _tmp1021_;
			ValaDataType* _tmp1022_;
			ValaDataType* _tmp1023_;
			ValaSemanticAnalyzer* _tmp1024_;
			ValaSemanticAnalyzer* _tmp1025_;
			ValaDataType* _tmp1026_;
			ValaExpression* _tmp1036_;
			ValaExpression* _tmp1037_;
			ValaDataType* _tmp1038_;
			ValaDataType* _tmp1039_;
			ValaExpression* _tmp1040_;
			ValaExpression* _tmp1041_;
			ValaDataType* _tmp1042_;
			ValaDataType* _tmp1043_;
			ValaSemanticAnalyzer* _tmp1044_;
			ValaSemanticAnalyzer* _tmp1045_;
			ValaDataType* _tmp1046_;
			_tmp1020_ = vala_binary_expression_get_left (self);
			_tmp1021_ = _tmp1020_;
			_tmp1022_ = vala_expression_get_value_type (_tmp1021_);
			_tmp1023_ = _tmp1022_;
			_tmp1024_ = vala_code_context_get_analyzer (context);
			_tmp1025_ = _tmp1024_;
			_tmp1026_ = _tmp1025_->bool_type;
			if (!vala_data_type_compatible (_tmp1023_, _tmp1026_)) {
				_tmp1019_ = TRUE;
			} else {
				ValaExpression* _tmp1027_;
				ValaExpression* _tmp1028_;
				ValaDataType* _tmp1029_;
				ValaDataType* _tmp1030_;
				ValaSemanticAnalyzer* _tmp1031_;
				ValaSemanticAnalyzer* _tmp1032_;
				ValaDataType* _tmp1033_;
				_tmp1027_ = vala_binary_expression_get_right (self);
				_tmp1028_ = _tmp1027_;
				_tmp1029_ = vala_expression_get_value_type (_tmp1028_);
				_tmp1030_ = _tmp1029_;
				_tmp1031_ = vala_code_context_get_analyzer (context);
				_tmp1032_ = _tmp1031_;
				_tmp1033_ = _tmp1032_->bool_type;
				_tmp1019_ = !vala_data_type_compatible (_tmp1030_, _tmp1033_);
			}
			if (_tmp1019_) {
				ValaSourceReference* _tmp1034_;
				ValaSourceReference* _tmp1035_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1034_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1035_ = _tmp1034_;
				vala_report_error (_tmp1035_, "Operands must be boolean");
			}
			_tmp1036_ = vala_binary_expression_get_left (self);
			_tmp1037_ = _tmp1036_;
			_tmp1038_ = vala_expression_get_target_type (_tmp1037_);
			_tmp1039_ = _tmp1038_;
			vala_data_type_set_nullable (_tmp1039_, FALSE);
			_tmp1040_ = vala_binary_expression_get_right (self);
			_tmp1041_ = _tmp1040_;
			_tmp1042_ = vala_expression_get_target_type (_tmp1041_);
			_tmp1043_ = _tmp1042_;
			vala_data_type_set_nullable (_tmp1043_, FALSE);
			_tmp1044_ = vala_code_context_get_analyzer (context);
			_tmp1045_ = _tmp1044_;
			_tmp1046_ = _tmp1045_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1046_);
			break;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			gboolean _tmp1047_ = FALSE;
			ValaExpression* _tmp1048_;
			ValaExpression* _tmp1049_;
			ValaDataType* _tmp1050_;
			ValaDataType* _tmp1051_;
			ValaSemanticAnalyzer* _tmp1052_;
			ValaSemanticAnalyzer* _tmp1053_;
			ValaDataType* _tmp1054_;
			ValaSemanticAnalyzer* _tmp1158_;
			ValaSemanticAnalyzer* _tmp1159_;
			ValaDataType* _tmp1160_;
			_tmp1048_ = vala_binary_expression_get_left (self);
			_tmp1049_ = _tmp1048_;
			_tmp1050_ = vala_expression_get_value_type (_tmp1049_);
			_tmp1051_ = _tmp1050_;
			_tmp1052_ = vala_code_context_get_analyzer (context);
			_tmp1053_ = _tmp1052_;
			_tmp1054_ = _tmp1053_->int_type;
			if (vala_data_type_compatible (_tmp1051_, _tmp1054_)) {
				ValaExpression* _tmp1055_;
				ValaExpression* _tmp1056_;
				ValaDataType* _tmp1057_;
				ValaDataType* _tmp1058_;
				ValaSemanticAnalyzer* _tmp1059_;
				ValaSemanticAnalyzer* _tmp1060_;
				ValaDataType* _tmp1061_;
				_tmp1055_ = vala_binary_expression_get_right (self);
				_tmp1056_ = _tmp1055_;
				_tmp1057_ = vala_expression_get_value_type (_tmp1056_);
				_tmp1058_ = _tmp1057_;
				_tmp1059_ = vala_code_context_get_analyzer (context);
				_tmp1060_ = _tmp1059_;
				_tmp1061_ = _tmp1060_->int_type;
				_tmp1047_ = vala_data_type_compatible (_tmp1058_, _tmp1061_);
			} else {
				_tmp1047_ = FALSE;
			}
			if (_tmp1047_) {
				ValaExpression* _tmp1062_;
				ValaExpression* _tmp1063_;
				ValaDataType* _tmp1064_;
				ValaDataType* _tmp1065_;
				ValaExpression* _tmp1066_;
				ValaExpression* _tmp1067_;
				ValaDataType* _tmp1068_;
				ValaDataType* _tmp1069_;
				_tmp1062_ = vala_binary_expression_get_left (self);
				_tmp1063_ = _tmp1062_;
				_tmp1064_ = vala_expression_get_target_type (_tmp1063_);
				_tmp1065_ = _tmp1064_;
				vala_data_type_set_nullable (_tmp1065_, FALSE);
				_tmp1066_ = vala_binary_expression_get_right (self);
				_tmp1067_ = _tmp1066_;
				_tmp1068_ = vala_expression_get_target_type (_tmp1067_);
				_tmp1069_ = _tmp1068_;
				vala_data_type_set_nullable (_tmp1069_, FALSE);
			} else {
				ValaExpression* _tmp1070_;
				ValaExpression* _tmp1071_;
				ValaDataType* _tmp1072_;
				ValaDataType* _tmp1073_;
				_tmp1070_ = vala_binary_expression_get_right (self);
				_tmp1071_ = _tmp1070_;
				_tmp1072_ = vala_expression_get_value_type (_tmp1071_);
				_tmp1073_ = _tmp1072_;
				if (VALA_IS_ARRAY_TYPE (_tmp1073_)) {
					ValaExpression* _tmp1074_;
					ValaExpression* _tmp1075_;
					ValaDataType* _tmp1076_;
					ValaDataType* _tmp1077_;
					ValaExpression* _tmp1078_;
					ValaExpression* _tmp1079_;
					ValaDataType* _tmp1080_;
					ValaDataType* _tmp1081_;
					ValaDataType* _tmp1082_;
					ValaDataType* _tmp1083_;
					_tmp1074_ = vala_binary_expression_get_left (self);
					_tmp1075_ = _tmp1074_;
					_tmp1076_ = vala_expression_get_value_type (_tmp1075_);
					_tmp1077_ = _tmp1076_;
					_tmp1078_ = vala_binary_expression_get_right (self);
					_tmp1079_ = _tmp1078_;
					_tmp1080_ = vala_expression_get_value_type (_tmp1079_);
					_tmp1081_ = _tmp1080_;
					_tmp1082_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1081_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp1083_ = _tmp1082_;
					if (!vala_data_type_compatible (_tmp1077_, _tmp1083_)) {
						ValaSourceReference* _tmp1084_;
						ValaSourceReference* _tmp1085_;
						ValaExpression* _tmp1086_;
						ValaExpression* _tmp1087_;
						ValaDataType* _tmp1088_;
						ValaDataType* _tmp1089_;
						gchar* _tmp1090_;
						gchar* _tmp1091_;
						ValaExpression* _tmp1092_;
						ValaExpression* _tmp1093_;
						ValaDataType* _tmp1094_;
						ValaDataType* _tmp1095_;
						gchar* _tmp1096_;
						gchar* _tmp1097_;
						gchar* _tmp1098_;
						gchar* _tmp1099_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1084_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1085_ = _tmp1084_;
						_tmp1086_ = vala_binary_expression_get_left (self);
						_tmp1087_ = _tmp1086_;
						_tmp1088_ = vala_expression_get_value_type (_tmp1087_);
						_tmp1089_ = _tmp1088_;
						_tmp1090_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1089_);
						_tmp1091_ = _tmp1090_;
						_tmp1092_ = vala_binary_expression_get_right (self);
						_tmp1093_ = _tmp1092_;
						_tmp1094_ = vala_expression_get_value_type (_tmp1093_);
						_tmp1095_ = _tmp1094_;
						_tmp1096_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1095_);
						_tmp1097_ = _tmp1096_;
						_tmp1098_ = g_strdup_printf ("Cannot look for `%s' in `%s'", _tmp1091_, _tmp1097_);
						_tmp1099_ = _tmp1098_;
						vala_report_error (_tmp1085_, _tmp1099_);
						_g_free0 (_tmp1099_);
						_g_free0 (_tmp1097_);
						_g_free0 (_tmp1091_);
					}
				} else {
					ValaMethod* contains_method = NULL;
					ValaExpression* _tmp1100_;
					ValaExpression* _tmp1101_;
					ValaDataType* _tmp1102_;
					ValaDataType* _tmp1103_;
					ValaSymbol* _tmp1104_;
					ValaMethod* _tmp1105_;
					ValaMethod* _tmp1106_;
					ValaMethod* _tmp1117_;
					ValaList* _tmp1118_;
					gint _tmp1119_;
					gint _tmp1120_;
					ValaMethod* _tmp1128_;
					ValaDataType* _tmp1129_;
					ValaDataType* _tmp1130_;
					ValaSemanticAnalyzer* _tmp1131_;
					ValaSemanticAnalyzer* _tmp1132_;
					ValaDataType* _tmp1133_;
					ValaMethodCall* contains_call = NULL;
					ValaExpression* _tmp1141_;
					ValaExpression* _tmp1142_;
					ValaSourceReference* _tmp1143_;
					ValaSourceReference* _tmp1144_;
					ValaMemberAccess* _tmp1145_;
					ValaMemberAccess* _tmp1146_;
					ValaSourceReference* _tmp1147_;
					ValaSourceReference* _tmp1148_;
					ValaMethodCall* _tmp1149_;
					ValaMethodCall* _tmp1150_;
					ValaMethodCall* _tmp1151_;
					ValaExpression* _tmp1152_;
					ValaExpression* _tmp1153_;
					ValaCodeNode* _tmp1154_;
					ValaCodeNode* _tmp1155_;
					ValaMethodCall* _tmp1156_;
					ValaMethodCall* _tmp1157_;
					_tmp1100_ = vala_binary_expression_get_right (self);
					_tmp1101_ = _tmp1100_;
					_tmp1102_ = vala_expression_get_value_type (_tmp1101_);
					_tmp1103_ = _tmp1102_;
					_tmp1104_ = vala_data_type_get_member (_tmp1103_, "contains");
					_tmp1105_ = VALA_IS_METHOD (_tmp1104_) ? ((ValaMethod*) _tmp1104_) : NULL;
					if (_tmp1105_ == NULL) {
						_vala_code_node_unref0 (_tmp1104_);
					}
					contains_method = _tmp1105_;
					_tmp1106_ = contains_method;
					if (_tmp1106_ == NULL) {
						ValaSourceReference* _tmp1107_;
						ValaSourceReference* _tmp1108_;
						ValaExpression* _tmp1109_;
						ValaExpression* _tmp1110_;
						ValaDataType* _tmp1111_;
						ValaDataType* _tmp1112_;
						gchar* _tmp1113_;
						gchar* _tmp1114_;
						gchar* _tmp1115_;
						gchar* _tmp1116_;
						_tmp1107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1108_ = _tmp1107_;
						_tmp1109_ = vala_binary_expression_get_right (self);
						_tmp1110_ = _tmp1109_;
						_tmp1111_ = vala_expression_get_value_type (_tmp1110_);
						_tmp1112_ = _tmp1111_;
						_tmp1113_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1112_);
						_tmp1114_ = _tmp1113_;
						_tmp1115_ = g_strdup_printf ("`%s' does not have a `contains' method", _tmp1114_);
						_tmp1116_ = _tmp1115_;
						vala_report_error (_tmp1108_, _tmp1116_);
						_g_free0 (_tmp1116_);
						_g_free0 (_tmp1114_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1117_ = contains_method;
					_tmp1118_ = vala_callable_get_parameters ((ValaCallable*) _tmp1117_);
					_tmp1119_ = vala_collection_get_size ((ValaCollection*) _tmp1118_);
					_tmp1120_ = _tmp1119_;
					if (_tmp1120_ != 1) {
						ValaSourceReference* _tmp1121_;
						ValaSourceReference* _tmp1122_;
						ValaMethod* _tmp1123_;
						gchar* _tmp1124_;
						gchar* _tmp1125_;
						gchar* _tmp1126_;
						gchar* _tmp1127_;
						_tmp1121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1122_ = _tmp1121_;
						_tmp1123_ = contains_method;
						_tmp1124_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1123_);
						_tmp1125_ = _tmp1124_;
						_tmp1126_ = g_strdup_printf ("`%s' must have one parameter", _tmp1125_);
						_tmp1127_ = _tmp1126_;
						vala_report_error (_tmp1122_, _tmp1127_);
						_g_free0 (_tmp1127_);
						_g_free0 (_tmp1125_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1128_ = contains_method;
					_tmp1129_ = vala_callable_get_return_type ((ValaCallable*) _tmp1128_);
					_tmp1130_ = _tmp1129_;
					_tmp1131_ = vala_code_context_get_analyzer (context);
					_tmp1132_ = _tmp1131_;
					_tmp1133_ = _tmp1132_->bool_type;
					if (!vala_data_type_compatible (_tmp1130_, _tmp1133_)) {
						ValaSourceReference* _tmp1134_;
						ValaSourceReference* _tmp1135_;
						ValaMethod* _tmp1136_;
						gchar* _tmp1137_;
						gchar* _tmp1138_;
						gchar* _tmp1139_;
						gchar* _tmp1140_;
						_tmp1134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1135_ = _tmp1134_;
						_tmp1136_ = contains_method;
						_tmp1137_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1136_);
						_tmp1138_ = _tmp1137_;
						_tmp1139_ = g_strdup_printf ("`%s' must return a boolean value", _tmp1138_);
						_tmp1140_ = _tmp1139_;
						vala_report_error (_tmp1135_, _tmp1140_);
						_g_free0 (_tmp1140_);
						_g_free0 (_tmp1138_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1141_ = vala_binary_expression_get_right (self);
					_tmp1142_ = _tmp1141_;
					_tmp1143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1144_ = _tmp1143_;
					_tmp1145_ = vala_member_access_new (_tmp1142_, "contains", _tmp1144_);
					_tmp1146_ = _tmp1145_;
					_tmp1147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1148_ = _tmp1147_;
					_tmp1149_ = vala_method_call_new ((ValaExpression*) _tmp1146_, _tmp1148_);
					_tmp1150_ = _tmp1149_;
					_vala_code_node_unref0 (_tmp1146_);
					contains_call = _tmp1150_;
					_tmp1151_ = contains_call;
					_tmp1152_ = vala_binary_expression_get_left (self);
					_tmp1153_ = _tmp1152_;
					vala_method_call_add_argument (_tmp1151_, _tmp1153_);
					_tmp1154_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp1155_ = _tmp1154_;
					_tmp1156_ = contains_call;
					vala_code_node_replace_expression (_tmp1155_, (ValaExpression*) self, (ValaExpression*) _tmp1156_);
					_tmp1157_ = contains_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp1157_, context);
					_vala_code_node_unref0 (contains_call);
					_vala_code_node_unref0 (contains_method);
					return result;
				}
			}
			_tmp1158_ = vala_code_context_get_analyzer (context);
			_tmp1159_ = _tmp1158_;
			_tmp1160_ = _tmp1159_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1160_);
			break;
		}
		default:
		{
			ValaSourceReference* _tmp1161_;
			ValaSourceReference* _tmp1162_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1162_ = _tmp1161_;
			vala_report_error (_tmp1162_, "internal error: unsupported binary operator");
			result = FALSE;
			return result;
		}
	}
	_tmp1163_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1164_ = _tmp1163_;
	vala_code_node_check ((ValaCodeNode*) _tmp1164_, context);
	_tmp1165_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1166_ = _tmp1165_;
	result = !_tmp1166_;
	return result;
}

static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass,
                                   gpointer klass_data)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBinaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_binary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}

static void
vala_binary_expression_instance_init (ValaBinaryExpression * self,
                                      gpointer klass)
{
	self->priv = vala_binary_expression_get_instance_private (self);
}

static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
static GType
vala_binary_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
	GType vala_binary_expression_type_id;
	vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
	ValaBinaryExpression_private_offset = g_type_add_instance_private (vala_binary_expression_type_id, sizeof (ValaBinaryExpressionPrivate));
	return vala_binary_expression_type_id;
}

GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = vala_binary_expression_get_type_once ();
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}

const gchar*
vala_binary_operator_to_string (ValaBinaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_binary_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
	GType vala_binary_operator_type_id;
	vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
	return vala_binary_operator_type_id;
}

GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = vala_binary_operator_get_type_once ();
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}

