// Generated by gmmproc 2.68.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/entry.h>
#include <gtkmm/private/entry_p.h>


/*
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>

using IconPosition = Gtk::Entry::IconPosition;

namespace Gtk
{

void Entry::set_icon_from_icon_name(const Glib::ustring& icon_name, IconPosition icon_pos)
{
  gtk_entry_set_icon_from_icon_name(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), icon_name.c_str());
}

void Entry::set_icon_from_gicon(const Glib::RefPtr<Gio::Icon>& icon, IconPosition icon_pos)
{
  gtk_entry_set_icon_from_gicon(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), const_cast<GIcon*>(Glib::unwrap<Gio::Icon>(icon)));
}

void Entry::unset_icon(IconPosition icon_pos)
{
  //We could use any one of these set_icon_from_* functions:
  gtk_entry_set_icon_from_paintable(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), nullptr);
}

void Entry::set_icon_activatable(bool activatable, IconPosition icon_pos)
{
  gtk_entry_set_icon_activatable(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), static_cast<int>(activatable));
}

void Entry::set_icon_tooltip_text(const Glib::ustring& tooltip, IconPosition icon_pos)
{
  gtk_entry_set_icon_tooltip_text(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), tooltip.c_str());
}

void Entry::set_icon_tooltip_markup(const Glib::ustring& tooltip, IconPosition icon_pos)
{
  gtk_entry_set_icon_tooltip_markup(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), tooltip.c_str());
}

Gdk::Rectangle Entry::get_icon_area(IconPosition icon_pos) const
{
  Gdk::Rectangle result;
  gtk_entry_get_icon_area(const_cast<GtkEntry*>(gobj()), (GtkEntryIconPosition)icon_pos, result.gobj());
  return result;
}

} //namespace Gtk

namespace
{


static void Entry_signal_icon_release_callback(GtkEntry* self, GtkEntryIconPosition p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(IconPosition)>;

  auto obj = dynamic_cast<Entry*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(static_cast<IconPosition>(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Entry_signal_icon_release_info =
{
  "icon-release",
  (GCallback) &Entry_signal_icon_release_callback,
  (GCallback) &Entry_signal_icon_release_callback
};


static void Entry_signal_icon_press_callback(GtkEntry* self, GtkEntryIconPosition p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(IconPosition)>;

  auto obj = dynamic_cast<Entry*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(static_cast<IconPosition>(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Entry_signal_icon_press_info =
{
  "icon-press",
  (GCallback) &Entry_signal_icon_press_callback,
  (GCallback) &Entry_signal_icon_press_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::Entry::IconPosition>::value_type()
{
  return gtk_entry_icon_position_get_type();
}


namespace Glib
{

Gtk::Entry* wrap(GtkEntry* object, bool take_copy)
{
  return dynamic_cast<Gtk::Entry *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Entry_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Entry_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_entry_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Editable::add_interface(get_type());
  CellEditable::add_interface(get_type());

  }

  return *this;
}


void Entry_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Entry_Class::wrap_new(GObject* o)
{
  return manage(new Entry((GtkEntry*)(o)));

}


/* The implementation: */

Entry::Entry(const Glib::ConstructParams& construct_params)
:
  Gtk::Widget(construct_params)
{
  }

Entry::Entry(GtkEntry* castitem)
:
  Gtk::Widget((GtkWidget*)(castitem))
{
  }


Entry::Entry(Entry&& src) noexcept
: Gtk::Widget(std::move(src))
  , Editable(std::move(src))
  , CellEditable(std::move(src))
{}

Entry& Entry::operator=(Entry&& src) noexcept
{
  Gtk::Widget::operator=(std::move(src));
  Editable::operator=(std::move(src));
  CellEditable::operator=(std::move(src));
  return *this;
}

Entry::~Entry() noexcept
{
  destroy_();
}

Entry::CppClassType Entry::entry_class_; // initialize static member

GType Entry::get_type()
{
  return entry_class_.init().get_type();
}


GType Entry::get_base_type()
{
  return gtk_entry_get_type();
}


Entry::Entry()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(entry_class_.init()))
{
  

}

Entry::Entry(const Glib::RefPtr<EntryBuffer>& buffer)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(entry_class_.init(), "buffer", Glib::unwrap(buffer), nullptr))
{
  

}

Glib::RefPtr<EntryBuffer> Entry::get_buffer()
{
  auto retvalue = Glib::wrap(gtk_entry_get_buffer(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const EntryBuffer> Entry::get_buffer() const
{
  return const_cast<Entry*>(this)->get_buffer();
}

void Entry::set_buffer(const Glib::RefPtr<EntryBuffer>& buffer)
{
  gtk_entry_set_buffer(gobj(), Glib::unwrap(buffer));
}

void Entry::set_visibility(bool visible)
{
  gtk_entry_set_visibility(gobj(), static_cast<int>(visible));
}

bool Entry::get_visibility() const
{
  return gtk_entry_get_visibility(const_cast<GtkEntry*>(gobj()));
}

void Entry::set_invisible_char(gunichar ch)
{
  gtk_entry_set_invisible_char(gobj(), ch);
}

void Entry::unset_invisible_char()
{
  gtk_entry_unset_invisible_char(gobj());
}

gunichar Entry::get_invisible_char() const
{
  return gtk_entry_get_invisible_char(const_cast<GtkEntry*>(gobj()));
}

void Entry::set_has_frame(bool setting)
{
  gtk_entry_set_has_frame(gobj(), static_cast<int>(setting));
}

bool Entry::get_has_frame() const
{
  return gtk_entry_get_has_frame(const_cast<GtkEntry*>(gobj()));
}

void Entry::set_overwrite_mode(bool overwrite)
{
  gtk_entry_set_overwrite_mode(gobj(), static_cast<int>(overwrite));
}

bool Entry::get_overwrite_mode() const
{
  return gtk_entry_get_overwrite_mode(const_cast<GtkEntry*>(gobj()));
}

void Entry::set_max_length(int max)
{
  gtk_entry_set_max_length(gobj(), max);
}

int Entry::get_max_length() const
{
  return gtk_entry_get_max_length(const_cast<GtkEntry*>(gobj()));
}

guint16 Entry::get_text_length() const
{
  return gtk_entry_get_text_length(const_cast<GtkEntry*>(gobj()));
}

void Entry::set_activates_default(bool setting)
{
  gtk_entry_set_activates_default(gobj(), static_cast<int>(setting));
}

gboolean Entry::get_activates_default() const
{
  return gtk_entry_get_activates_default(const_cast<GtkEntry*>(gobj()));
}

void Entry::set_alignment(float xalign)
{
  gtk_entry_set_alignment(gobj(), xalign);
}

void Entry::set_alignment(Align xalign)
{
  gtk_entry_set_alignment(gobj(), _gtkmm_align_float_from_enum(xalign));
}

float Entry::get_alignment() const
{
  return gtk_entry_get_alignment(const_cast<GtkEntry*>(gobj()));
}

void Entry::set_completion(const Glib::RefPtr<EntryCompletion>& completion)
{
  gtk_entry_set_completion(gobj(), Glib::unwrap(completion));
}

Glib::RefPtr<EntryCompletion> Entry::get_completion()
{
  auto retvalue = Glib::wrap(gtk_entry_get_completion(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const EntryCompletion> Entry::get_completion() const
{
  return const_cast<Entry*>(this)->get_completion();
}

void Entry::set_progress_fraction(double fraction)
{
  gtk_entry_set_progress_fraction(gobj(), fraction);
}

double Entry::get_progress_fraction() const
{
  return gtk_entry_get_progress_fraction(const_cast<GtkEntry*>(gobj()));
}

void Entry::set_progress_pulse_step(double fraction)
{
  gtk_entry_set_progress_pulse_step(gobj(), fraction);
}

double Entry::get_progress_pulse_step()
{
  return gtk_entry_get_progress_pulse_step(gobj());
}

void Entry::progress_pulse()
{
  gtk_entry_progress_pulse(gobj());
}

Glib::ustring Entry::get_placeholder_text() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_entry_get_placeholder_text(const_cast<GtkEntry*>(gobj())));
}

void Entry::set_placeholder_text(const Glib::ustring& text)
{
  gtk_entry_set_placeholder_text(gobj(), text.c_str());
}

void Entry::set_icon_from_paintable(const Glib::RefPtr<Gdk::Paintable>& paintable, IconPosition icon_pos)
{
  gtk_entry_set_icon_from_paintable(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), Glib::unwrap(paintable));
}

Image::Type Entry::get_icon_storage_type(IconPosition icon_pos) const
{
  return static_cast<Image::Type>(gtk_entry_get_icon_storage_type(const_cast<GtkEntry*>(gobj()), static_cast<GtkEntryIconPosition>(icon_pos)));
}

Glib::RefPtr<Gdk::Paintable> Entry::get_icon_paintable(IconPosition icon_pos)
{
  auto retvalue = Glib::wrap(gtk_entry_get_icon_paintable(gobj(), static_cast<GtkEntryIconPosition>(icon_pos)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Paintable> Entry::get_icon_paintable(IconPosition icon_pos) const
{
  return const_cast<Entry*>(this)->get_icon_paintable(icon_pos);
}

Glib::ustring Entry::get_icon_name(IconPosition icon_pos) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_entry_get_icon_name(const_cast<GtkEntry*>(gobj()), static_cast<GtkEntryIconPosition>(icon_pos)));
}

Glib::RefPtr<Gio::Icon> Entry::get_icon_gicon(IconPosition icon_pos)
{
  auto retvalue = Glib::wrap(gtk_entry_get_icon_gicon(gobj(), static_cast<GtkEntryIconPosition>(icon_pos)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::Icon> Entry::get_icon_gicon(IconPosition icon_pos) const
{
  return const_cast<Entry*>(this)->get_icon_gicon(icon_pos);
}

bool Entry::get_icon_activatable(IconPosition icon_pos) const
{
  return gtk_entry_get_icon_activatable(const_cast<GtkEntry*>(gobj()), static_cast<GtkEntryIconPosition>(icon_pos));
}

void Entry::set_icon_sensitive(IconPosition icon_pos, bool sensitive)
{
  gtk_entry_set_icon_sensitive(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), static_cast<int>(sensitive));
}

bool Entry::get_icon_sensitive(IconPosition icon_pos)
{
  return gtk_entry_get_icon_sensitive(gobj(), static_cast<GtkEntryIconPosition>(icon_pos));
}

int Entry::get_icon_at_pos(int x, int y) const
{
  return gtk_entry_get_icon_at_pos(const_cast<GtkEntry*>(gobj()), x, y);
}

Glib::ustring Entry::get_icon_tooltip_text(IconPosition icon_pos) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_entry_get_icon_tooltip_text(const_cast<GtkEntry*>(gobj()), static_cast<GtkEntryIconPosition>(icon_pos)));
}

Glib::ustring Entry::get_icon_tooltip_markup(IconPosition icon_pos) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_entry_get_icon_tooltip_markup(const_cast<GtkEntry*>(gobj()), static_cast<GtkEntryIconPosition>(icon_pos)));
}

void Entry::set_icon_drag_source(const Glib::RefPtr<Gdk::ContentProvider>& provider, Gdk::DragAction actions, IconPosition icon_pos)
{
  gtk_entry_set_icon_drag_source(gobj(), static_cast<GtkEntryIconPosition>(icon_pos), Glib::unwrap(provider), static_cast<GdkDragAction>(actions));
}

int Entry::get_current_icon_drag_source()
{
  return gtk_entry_get_current_icon_drag_source(gobj());
}

void Entry::reset_im_context()
{
  gtk_entry_reset_im_context(gobj());
}

void Entry::set_input_purpose(InputPurpose purpose)
{
  gtk_entry_set_input_purpose(gobj(), static_cast<GtkInputPurpose>(purpose));
}

InputPurpose Entry::get_input_purpose() const
{
  return static_cast<InputPurpose>(gtk_entry_get_input_purpose(const_cast<GtkEntry*>(gobj())));
}

void Entry::set_input_hints(InputHints hints)
{
  gtk_entry_set_input_hints(gobj(), static_cast<GtkInputHints>(hints));
}

InputHints Entry::get_input_hints() const
{
  return static_cast<InputHints>(gtk_entry_get_input_hints(const_cast<GtkEntry*>(gobj())));
}

void Entry::set_attributes(Pango::AttrList& attrs)
{
  gtk_entry_set_attributes(gobj(), (attrs).gobj());
}

Pango::AttrList Entry::get_attributes() const
{
  return Pango::AttrList((gtk_entry_get_attributes(const_cast<GtkEntry*>(gobj()))));
}

void Entry::set_tabs(const Pango::TabArray& tabs)
{
  gtk_entry_set_tabs(gobj(), const_cast<Pango::TabArray&>(tabs).gobj());
}

Pango::TabArray Entry::get_tabs() const
{
  return Pango::TabArray((gtk_entry_get_tabs(const_cast<GtkEntry*>(gobj()))));
}

void Entry::grab_focus_without_selecting()
{
  gtk_entry_grab_focus_without_selecting(gobj());
}

void Entry::set_extra_menu(const Glib::RefPtr<Gio::MenuModel>& model)
{
  gtk_entry_set_extra_menu(gobj(), Glib::unwrap(model));
}

Glib::RefPtr<Gio::MenuModel> Entry::get_extra_menu()
{
  auto retvalue = Glib::wrap(gtk_entry_get_extra_menu(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::MenuModel> Entry::get_extra_menu() const
{
  return const_cast<Entry*>(this)->get_extra_menu();
}


Glib::SignalProxy<void(IconPosition)> Entry::signal_icon_release()
{
  return Glib::SignalProxy<void(IconPosition) >(this, &Entry_signal_icon_release_info);
}


Glib::SignalProxy<void(IconPosition)> Entry::signal_icon_press()
{
  return Glib::SignalProxy<void(IconPosition) >(this, &Entry_signal_icon_press_info);
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<EntryBuffer>>::value,
  "Type Glib::RefPtr<EntryBuffer> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<EntryBuffer> > Entry::property_buffer() 
{
  return Glib::PropertyProxy< Glib::RefPtr<EntryBuffer> >(this, "buffer");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<EntryBuffer> > Entry::property_buffer() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<EntryBuffer> >(this, "buffer");
}

Glib::PropertyProxy< int > Entry::property_max_length() 
{
  return Glib::PropertyProxy< int >(this, "max-length");
}

Glib::PropertyProxy_ReadOnly< int > Entry::property_max_length() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "max-length");
}

Glib::PropertyProxy< bool > Entry::property_visibility() 
{
  return Glib::PropertyProxy< bool >(this, "visibility");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_visibility() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "visibility");
}

Glib::PropertyProxy< bool > Entry::property_has_frame() 
{
  return Glib::PropertyProxy< bool >(this, "has-frame");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_has_frame() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-frame");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<gunichar>::value,
  "Type gunichar cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< gunichar > Entry::property_invisible_char() 
{
  return Glib::PropertyProxy< gunichar >(this, "invisible-char");
}

Glib::PropertyProxy_ReadOnly< gunichar > Entry::property_invisible_char() const
{
  return Glib::PropertyProxy_ReadOnly< gunichar >(this, "invisible-char");
}

Glib::PropertyProxy< bool > Entry::property_invisible_char_set() 
{
  return Glib::PropertyProxy< bool >(this, "invisible-char-set");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_invisible_char_set() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "invisible-char-set");
}

Glib::PropertyProxy< bool > Entry::property_activates_default() 
{
  return Glib::PropertyProxy< bool >(this, "activates-default");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_activates_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "activates-default");
}

Glib::PropertyProxy_ReadOnly< int > Entry::property_scroll_offset() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "scroll-offset");
}

Glib::PropertyProxy< bool > Entry::property_truncate_multiline() 
{
  return Glib::PropertyProxy< bool >(this, "truncate-multiline");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_truncate_multiline() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "truncate-multiline");
}

Glib::PropertyProxy< bool > Entry::property_overwrite_mode() 
{
  return Glib::PropertyProxy< bool >(this, "overwrite-mode");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_overwrite_mode() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "overwrite-mode");
}

Glib::PropertyProxy_ReadOnly< guint > Entry::property_text_length() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "text-length");
}

Glib::PropertyProxy< double > Entry::property_progress_fraction() 
{
  return Glib::PropertyProxy< double >(this, "progress-fraction");
}

Glib::PropertyProxy_ReadOnly< double > Entry::property_progress_fraction() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "progress-fraction");
}

Glib::PropertyProxy< double > Entry::property_progress_pulse_step() 
{
  return Glib::PropertyProxy< double >(this, "progress-pulse-step");
}

Glib::PropertyProxy_ReadOnly< double > Entry::property_progress_pulse_step() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "progress-pulse-step");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gdk::Paintable>>::value,
  "Type Glib::RefPtr<Gdk::Paintable> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gdk::Paintable> > Entry::property_primary_icon_paintable() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Paintable> >(this, "primary-icon-paintable");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Paintable> > Entry::property_primary_icon_paintable() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Paintable> >(this, "primary-icon-paintable");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gdk::Paintable>>::value,
  "Type Glib::RefPtr<Gdk::Paintable> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gdk::Paintable> > Entry::property_secondary_icon_paintable() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Paintable> >(this, "secondary-icon-paintable");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Paintable> > Entry::property_secondary_icon_paintable() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Paintable> >(this, "secondary-icon-paintable");
}

Glib::PropertyProxy< Glib::ustring > Entry::property_primary_icon_name() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "primary-icon-name");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Entry::property_primary_icon_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "primary-icon-name");
}

Glib::PropertyProxy< Glib::ustring > Entry::property_secondary_icon_name() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "secondary-icon-name");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Entry::property_secondary_icon_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "secondary-icon-name");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gio::Icon>>::value,
  "Type Glib::RefPtr<Gio::Icon> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > Entry::property_primary_icon_gicon() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> >(this, "primary-icon-gicon");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > Entry::property_primary_icon_gicon() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> >(this, "primary-icon-gicon");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gio::Icon>>::value,
  "Type Glib::RefPtr<Gio::Icon> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > Entry::property_secondary_icon_gicon() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> >(this, "secondary-icon-gicon");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > Entry::property_secondary_icon_gicon() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> >(this, "secondary-icon-gicon");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Image::Type>::value,
  "Type Image::Type cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Image::Type > Entry::property_primary_icon_storage_type() const
{
  return Glib::PropertyProxy_ReadOnly< Image::Type >(this, "primary-icon-storage-type");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Image::Type>::value,
  "Type Image::Type cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Image::Type > Entry::property_secondary_icon_storage_type() const
{
  return Glib::PropertyProxy_ReadOnly< Image::Type >(this, "secondary-icon-storage-type");
}

Glib::PropertyProxy< bool > Entry::property_primary_icon_activatable() 
{
  return Glib::PropertyProxy< bool >(this, "primary-icon-activatable");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_primary_icon_activatable() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "primary-icon-activatable");
}

Glib::PropertyProxy< bool > Entry::property_secondary_icon_activatable() 
{
  return Glib::PropertyProxy< bool >(this, "secondary-icon-activatable");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_secondary_icon_activatable() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "secondary-icon-activatable");
}

Glib::PropertyProxy< bool > Entry::property_primary_icon_sensitive() 
{
  return Glib::PropertyProxy< bool >(this, "primary-icon-sensitive");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_primary_icon_sensitive() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "primary-icon-sensitive");
}

Glib::PropertyProxy< bool > Entry::property_secondary_icon_sensitive() 
{
  return Glib::PropertyProxy< bool >(this, "secondary-icon-sensitive");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_secondary_icon_sensitive() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "secondary-icon-sensitive");
}

Glib::PropertyProxy< bool > Entry::property_primary_icon_tooltip_text() 
{
  return Glib::PropertyProxy< bool >(this, "primary-icon-tooltip-text");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_primary_icon_tooltip_text() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "primary-icon-tooltip-text");
}

Glib::PropertyProxy< bool > Entry::property_secondary_icon_tooltip_text() 
{
  return Glib::PropertyProxy< bool >(this, "secondary-icon-tooltip-text");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_secondary_icon_tooltip_text() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "secondary-icon-tooltip-text");
}

Glib::PropertyProxy< bool > Entry::property_primary_icon_tooltip_markup() 
{
  return Glib::PropertyProxy< bool >(this, "primary-icon-tooltip-markup");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_primary_icon_tooltip_markup() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "primary-icon-tooltip-markup");
}

Glib::PropertyProxy< bool > Entry::property_secondary_icon_tooltip_markup() 
{
  return Glib::PropertyProxy< bool >(this, "secondary-icon-tooltip-markup");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_secondary_icon_tooltip_markup() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "secondary-icon-tooltip-markup");
}

Glib::PropertyProxy< Glib::ustring > Entry::property_im_module() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "im-module");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Entry::property_im_module() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "im-module");
}

Glib::PropertyProxy< Glib::ustring > Entry::property_placeholder_text() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "placeholder-text");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Entry::property_placeholder_text() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "placeholder-text");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<EntryCompletion>>::value,
  "Type Glib::RefPtr<EntryCompletion> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<EntryCompletion> > Entry::property_completion() 
{
  return Glib::PropertyProxy< Glib::RefPtr<EntryCompletion> >(this, "completion");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<EntryCompletion> > Entry::property_completion() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<EntryCompletion> >(this, "completion");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<InputPurpose>::value,
  "Type InputPurpose cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< InputPurpose > Entry::property_input_purpose() 
{
  return Glib::PropertyProxy< InputPurpose >(this, "input-purpose");
}

Glib::PropertyProxy_ReadOnly< InputPurpose > Entry::property_input_purpose() const
{
  return Glib::PropertyProxy_ReadOnly< InputPurpose >(this, "input-purpose");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<InputHints>::value,
  "Type InputHints cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< InputHints > Entry::property_input_hints() 
{
  return Glib::PropertyProxy< InputHints >(this, "input-hints");
}

Glib::PropertyProxy_ReadOnly< InputHints > Entry::property_input_hints() const
{
  return Glib::PropertyProxy_ReadOnly< InputHints >(this, "input-hints");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Pango::AttrList>::value,
  "Type Pango::AttrList cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Pango::AttrList > Entry::property_attributes() 
{
  return Glib::PropertyProxy< Pango::AttrList >(this, "attributes");
}

Glib::PropertyProxy_ReadOnly< Pango::AttrList > Entry::property_attributes() const
{
  return Glib::PropertyProxy_ReadOnly< Pango::AttrList >(this, "attributes");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Pango::TabArray>::value,
  "Type Pango::TabArray cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Pango::TabArray > Entry::property_tabs() 
{
  return Glib::PropertyProxy< Pango::TabArray >(this, "tabs");
}

Glib::PropertyProxy_ReadOnly< Pango::TabArray > Entry::property_tabs() const
{
  return Glib::PropertyProxy_ReadOnly< Pango::TabArray >(this, "tabs");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gio::MenuModel>>::value,
  "Type Glib::RefPtr<Gio::MenuModel> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > Entry::property_extra_menu() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> >(this, "extra-menu");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > Entry::property_extra_menu() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> >(this, "extra-menu");
}

Glib::PropertyProxy< bool > Entry::property_show_emoji_icon() 
{
  return Glib::PropertyProxy< bool >(this, "show-emoji-icon");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_show_emoji_icon() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "show-emoji-icon");
}

Glib::PropertyProxy< bool > Entry::property_enable_emoji_completion() 
{
  return Glib::PropertyProxy< bool >(this, "enable-emoji-completion");
}

Glib::PropertyProxy_ReadOnly< bool > Entry::property_enable_emoji_completion() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "enable-emoji-completion");
}


} // namespace Gtk


