// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/selectiondata.h>
#include <gtkmm/private/selectiondata_p.h>


/* Copyright 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/vectorutils.h>

#include <gtk/gtk.h>

namespace Gtk
{

void SelectionData::set(const std::string& type, int format, const guint8* data, int length)
{
  gtk_selection_data_set(gobj(), g_intern_string(type.c_str()), format, data, length);
}

void SelectionData::set(int format, const guint8* data, int length)
{
  //The C examples do this - that's why I added this method overload. murrayc.
  set(get_target(), format, data, length);
}

void SelectionData::set(const std::string& type, const std::string& data)
{
  gtk_selection_data_set(gobj(), g_intern_string(type.c_str()),
                         sizeof(char) * 8, // format is 8 bits per unit
                         reinterpret_cast<const guint8*>(data.data()), data.size());
}

bool SelectionData::set_text(const Glib::ustring& data)
{
  return gtk_selection_data_set_text(gobj(), data.data(), data.bytes());
}

Glib::ustring SelectionData::get_text() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(
      reinterpret_cast<char*>(gtk_selection_data_get_text(const_cast<GtkSelectionData*>(gobj()))));
}

std::string SelectionData::get_data_as_string() const
{
  const guchar* data = get_data();
  const int length = get_length();
  if(data && length > 0)
    return std::string(reinterpret_cast<const char*>(data), length);
  else
    return std::string();
}

std::string SelectionData::get_target() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(
      gtk_selection_data_get_target(const_cast<GtkSelectionData*>(gobj())) );
}

std::vector<std::string> SelectionData::get_targets() const
{
  GdkAtom* targets = nullptr;
  int n_targets = 0;

  if(!gtk_selection_data_get_targets(const_cast<GtkSelectionData*>(gobj()), &targets, &n_targets))
    n_targets = 0; // it's set to -1 otherwise

  //Note that we free the GdkAtom* array, but we don't need to free its items:
  return Glib::ArrayHandler<std::string, Gdk::AtomStringTraits>::array_to_vector(targets, n_targets, Glib::OWNERSHIP_SHALLOW);
}


std::string SelectionData::get_data_type() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(
    gtk_selection_data_get_data_type(const_cast<GtkSelectionData*>(gobj())) );
}

} // namespace Gtk

namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::SelectionData wrap(GtkSelectionData* object, bool take_copy)
{
  return Gtk::SelectionData(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


// static
GType SelectionData::get_type()
{
  return gtk_selection_data_get_type();
}

SelectionData::SelectionData()
:
  gobject_ (nullptr) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

SelectionData::SelectionData(const SelectionData& other)
:
  gobject_ ((other.gobject_) ? gtk_selection_data_copy(other.gobject_) : nullptr)
{}

SelectionData::SelectionData(SelectionData&& other) noexcept
:
  gobject_(other.gobject_)
{
  other.gobject_ = nullptr;
}

SelectionData& SelectionData::operator=(SelectionData&& other) noexcept
{
  SelectionData temp (other);
  swap(temp);
  return *this;
}

SelectionData::SelectionData(GtkSelectionData* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gtk_selection_data_copy(gobject) : gobject)
{}

SelectionData& SelectionData::operator=(const SelectionData& other)
{
  SelectionData temp (other);
  swap(temp);
  return *this;
}

SelectionData::~SelectionData() noexcept
{
  if(gobject_)
    gtk_selection_data_free(gobject_);
}

void SelectionData::swap(SelectionData& other) noexcept
{
  std::swap(gobject_, other.gobject_);
}

GtkSelectionData* SelectionData::gobj_copy() const
{
  return gtk_selection_data_copy(gobject_);
}


bool SelectionData::set_pixbuf(const Glib::RefPtr<const Gdk::Pixbuf>& pixbuf)
{
  return gtk_selection_data_set_pixbuf(gobj(), const_cast<GdkPixbuf*>(Glib::unwrap(pixbuf)));
}

Glib::RefPtr<Gdk::Pixbuf> SelectionData::get_pixbuf() const
{
  return Glib::wrap(gtk_selection_data_get_pixbuf(const_cast<GtkSelectionData*>(gobj())));
}

bool SelectionData::set_texture(const Glib::RefPtr<const Gdk::Texture>& texture)
{
  return gtk_selection_data_set_texture(gobj(), const_cast<GdkTexture*>(Glib::unwrap(texture)));
}

Glib::RefPtr<Gdk::Texture> SelectionData::get_texture() const
{
  return Glib::wrap(gtk_selection_data_get_texture(const_cast<GtkSelectionData*>(gobj())));
}

bool SelectionData::set_uris(const std::vector<Glib::ustring>& uris)
{
  return gtk_selection_data_set_uris(gobj(), const_cast<char**>(Glib::ArrayHandler<Glib::ustring>::vector_to_array(uris).data()));
}

std::vector<Glib::ustring> SelectionData::get_uris() const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(gtk_selection_data_get_uris(const_cast<GtkSelectionData*>(gobj())), Glib::OWNERSHIP_DEEP);
}

const guchar* SelectionData::get_data() const
{
  return gtk_selection_data_get_data(const_cast<GtkSelectionData*>(gobj()));
}

int SelectionData::get_length() const
{
  return gtk_selection_data_get_length(const_cast<GtkSelectionData*>(gobj()));
}

const guchar* SelectionData::get_data(int& length) const
{
  return gtk_selection_data_get_data_with_length(const_cast<GtkSelectionData*>(gobj()), &(length));
}

int SelectionData::get_format() const
{
  return gtk_selection_data_get_format(const_cast<GtkSelectionData*>(gobj()));
}

Glib::RefPtr<Gdk::Display> SelectionData::get_display()
{
  auto retvalue = Glib::wrap(gtk_selection_data_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Display> SelectionData::get_display() const
{
  return const_cast<SelectionData*>(this)->get_display();
}

bool SelectionData::targets_include_uri() const
{
  return gtk_selection_data_targets_include_uri(const_cast<GtkSelectionData*>(gobj()));
}

bool SelectionData::targets_include_text() const
{
  return gtk_selection_data_targets_include_text(const_cast<GtkSelectionData*>(gobj()));
}

bool SelectionData::targets_include_image(bool writable) const
{
  return gtk_selection_data_targets_include_image(const_cast<GtkSelectionData*>(gobj()), static_cast<int>(writable));
}


} // namespace Gtk


