/* rygel-simple-data-source.c generated by valac 0.48.5, the Vala compiler
 * generated from rygel-simple-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <rygel-server.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sys/types.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>

#define RYGEL_TYPE_SIMPLE_DATA_SOURCE (rygel_simple_data_source_get_type ())
#define RYGEL_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource))
#define RYGEL_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))
#define RYGEL_IS_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_IS_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_SIMPLE_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))

typedef struct _RygelSimpleDataSource RygelSimpleDataSource;
typedef struct _RygelSimpleDataSourceClass RygelSimpleDataSourceClass;
typedef struct _RygelSimpleDataSourcePrivate RygelSimpleDataSourcePrivate;
enum  {
	RYGEL_SIMPLE_DATA_SOURCE_0_PROPERTY,
	RYGEL_SIMPLE_DATA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* rygel_simple_data_source_properties[RYGEL_SIMPLE_DATA_SOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelSimpleDataSource {
	GObject parent_instance;
	RygelSimpleDataSourcePrivate * priv;
};

struct _RygelSimpleDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelSimpleDataSourcePrivate {
	gchar* uri;
	GThread* thread;
	GMutex mutex;
	GCond cond;
	off_t first_byte;
	off_t last_byte;
	gboolean frozen;
	gboolean stop_thread;
	GThreadPool* pool;
};

struct _Block1Data {
	int _ref_count_;
	RygelSimpleDataSource* self;
	guint8* slice;
	gint slice_length1;
	gint _slice_size_;
};

static gint RygelSimpleDataSource_private_offset;
static gpointer rygel_simple_data_source_parent_class = NULL;
static RygelDataSourceIface * rygel_simple_data_source_rygel_data_source_parent_iface = NULL;

GType rygel_simple_data_source_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSimpleDataSource, g_object_unref)
RygelSimpleDataSource* rygel_simple_data_source_new (GThreadPool* pool,
                                                     const gchar* uri);
RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type,
                                                           GThreadPool* pool,
                                                           const gchar* uri);
static GeeList* rygel_simple_data_source_real_preroll (RygelDataSource* base,
                                                RygelHTTPSeekRequest* seek_request,
                                                RygelPlaySpeedRequest* playspeed_request,
                                                GError** error);
static void rygel_simple_data_source_real_start (RygelDataSource* base,
                                          GError** error);
static void* rygel_simple_data_source_thread_func (RygelSimpleDataSource* self);
static gpointer _rygel_simple_data_source_thread_func_gthread_func (gpointer self);
static void rygel_simple_data_source_real_freeze (RygelDataSource* base);
static void rygel_simple_data_source_real_thaw (RygelDataSource* base);
static void rygel_simple_data_source_real_stop (RygelDataSource* base);
void rygel_simple_data_source_pool_func (RygelSimpleDataSource* data);
static void rygel_simple_data_source_run (RygelSimpleDataSource* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block1Data* _data1_);
static gboolean _____lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (RygelSimpleDataSource* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void rygel_simple_data_source_finalize (GObject * obj);
static GType rygel_simple_data_source_get_type_once (void);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
rygel_simple_data_source_get_instance_private (RygelSimpleDataSource* self)
{
	return G_STRUCT_MEMBER_P (self, RygelSimpleDataSource_private_offset);
}

RygelSimpleDataSource*
rygel_simple_data_source_construct (GType object_type,
                                    GThreadPool* pool,
                                    const gchar* uri)
{
	RygelSimpleDataSource * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelSimpleDataSource*) g_object_new (object_type, NULL);
	g_debug ("rygel-simple-data-source.vala:47: Creating new data source for %s", uri);
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp0_;
	self->priv->pool = pool;
	return self;
}

RygelSimpleDataSource*
rygel_simple_data_source_new (GThreadPool* pool,
                              const gchar* uri)
{
	return rygel_simple_data_source_construct (RYGEL_TYPE_SIMPLE_DATA_SOURCE, pool, uri);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeeList*
rygel_simple_data_source_real_preroll (RygelDataSource* base,
                                       RygelHTTPSeekRequest* seek_request,
                                       RygelPlaySpeedRequest* playspeed_request,
                                       GError** error)
{
	RygelSimpleDataSource * self;
	GeeArrayList* response_list = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeList* result = NULL;
	self = (RygelSimpleDataSource*) base;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	response_list = _tmp0_;
	if (seek_request != NULL) {
		RygelHTTPByteSeekRequest* byte_seek = NULL;
		RygelHTTPByteSeekRequest* _tmp2_;
		RygelHTTPByteSeekRequest* _tmp3_;
		gint64 _tmp4_;
		gint64 _tmp5_;
		RygelHTTPByteSeekRequest* _tmp6_;
		gint64 _tmp7_;
		gint64 _tmp8_;
		RygelHTTPByteSeekRequest* _tmp9_;
		gint64 _tmp10_;
		gint64 _tmp11_;
		RygelHTTPByteSeekRequest* _tmp12_;
		gint64 _tmp13_;
		gint64 _tmp14_;
		const gchar* _tmp15_;
		RygelHTTPByteSeekResponse* seek_response = NULL;
		RygelHTTPByteSeekRequest* _tmp16_;
		RygelHTTPByteSeekResponse* _tmp17_;
		GeeArrayList* _tmp18_;
		RygelHTTPByteSeekResponse* _tmp19_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
			GError* _tmp1_;
			_tmp1_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _ ("Only byte-based seek supported"));
			_inner_error0_ = _tmp1_;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (response_list);
			return NULL;
		}
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) seek_request) : NULL);
		byte_seek = _tmp2_;
		_tmp3_ = byte_seek;
		_tmp4_ = rygel_http_byte_seek_request_get_start_byte (_tmp3_);
		_tmp5_ = _tmp4_;
		self->priv->first_byte = (off_t) _tmp5_;
		_tmp6_ = byte_seek;
		_tmp7_ = rygel_http_byte_seek_request_get_end_byte (_tmp6_);
		_tmp8_ = _tmp7_;
		self->priv->last_byte = (off_t) (_tmp8_ + 1);
		_tmp9_ = byte_seek;
		_tmp10_ = rygel_http_byte_seek_request_get_start_byte (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = byte_seek;
		_tmp13_ = rygel_http_byte_seek_request_get_end_byte (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->priv->uri;
		g_debug ("rygel-simple-data-source.vala:70: Processing byte seek request for byt" \
"es %lld-%lld of %s", _tmp11_, _tmp14_, _tmp15_);
		_tmp16_ = byte_seek;
		_tmp17_ = rygel_http_byte_seek_response_new_from_request (_tmp16_);
		seek_response = _tmp17_;
		_tmp18_ = response_list;
		_tmp19_ = seek_response;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (RygelHTTPResponseElement*) _tmp19_);
		_g_object_unref0 (seek_response);
		_g_object_unref0 (byte_seek);
	} else {
		self->priv->first_byte = (off_t) 0;
		self->priv->last_byte = (off_t) 0;
	}
	if (playspeed_request != NULL) {
		GError* _tmp20_;
		_tmp20_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED, _ ("Playspeed not supported"));
		_inner_error0_ = _tmp20_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (response_list);
		return NULL;
	}
	result = (GeeList*) response_list;
	return result;
}

static gpointer
_rygel_simple_data_source_thread_func_gthread_func (gpointer self)
{
	gpointer result;
	result = rygel_simple_data_source_thread_func ((RygelSimpleDataSource*) self);
	g_object_unref (self);
	return result;
}

static void
rygel_simple_data_source_real_start (RygelDataSource* base,
                                     GError** error)
{
	RygelSimpleDataSource * self;
	const gchar* _tmp0_;
	GThreadPool* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (RygelSimpleDataSource*) base;
	_tmp0_ = self->priv->uri;
	g_debug ("rygel-simple-data-source.vala:91: Starting data source for uri %s", _tmp0_);
	_tmp1_ = self->priv->pool;
	if (_tmp1_ != NULL) {
		GThreadPool* _tmp2_;
		RygelSimpleDataSource* _tmp3_;
		_tmp2_ = self->priv->pool;
		_tmp3_ = _g_object_ref0 (self);
		g_thread_pool_push (_tmp2_, _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	} else {
		GThread* _tmp4_;
		_tmp4_ = g_thread_new ("Rygel Serving Thread", _rygel_simple_data_source_thread_func_gthread_func, g_object_ref (self));
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp4_;
	}
}

static void
rygel_simple_data_source_real_freeze (RygelDataSource* base)
{
	RygelSimpleDataSource * self;
	self = (RygelSimpleDataSource*) base;
	g_mutex_lock (&self->priv->mutex);
	if (!self->priv->frozen) {
		self->priv->frozen = TRUE;
	}
	g_mutex_unlock (&self->priv->mutex);
}

static void
rygel_simple_data_source_real_thaw (RygelDataSource* base)
{
	RygelSimpleDataSource * self;
	self = (RygelSimpleDataSource*) base;
	g_mutex_lock (&self->priv->mutex);
	if (self->priv->frozen) {
		self->priv->frozen = FALSE;
		g_cond_broadcast (&self->priv->cond);
	}
	g_mutex_unlock (&self->priv->mutex);
}

static void
rygel_simple_data_source_real_stop (RygelDataSource* base)
{
	RygelSimpleDataSource * self;
	self = (RygelSimpleDataSource*) base;
	g_mutex_lock (&self->priv->mutex);
	if (!self->priv->stop_thread) {
		self->priv->frozen = FALSE;
		self->priv->stop_thread = TRUE;
		g_cond_broadcast (&self->priv->cond);
	}
	g_mutex_unlock (&self->priv->mutex);
}

void
rygel_simple_data_source_pool_func (RygelSimpleDataSource* data)
{
	g_return_if_fail (data != NULL);
	rygel_simple_data_source_run (data);
	_g_object_unref0 (data);
}

static void*
rygel_simple_data_source_thread_func (RygelSimpleDataSource* self)
{
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rygel_simple_data_source_run (self);
	result = NULL;
	return result;
}

static GError*
vala_g_io_error_from_errno (gint err_no)
{
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError* result = NULL;
	_tmp0_ = g_strerror (err_no);
	_tmp1_ = g_error_new (g_io_error_quark (), g_io_error_from_errno (err_no), "%s", _tmp0_);
	result = (GError*) _tmp1_;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelSimpleDataSource* self;
		self = _data1_->self;
		_data1_->slice = (g_free (_data1_->slice), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
____lambda4_ (Block1Data* _data1_)
{
	RygelSimpleDataSource* self;
	gboolean result = FALSE;
	self = _data1_->self;
	if (!self->priv->stop_thread) {
		guint8* _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = _data1_->slice;
		_tmp0__length1 = _data1_->slice_length1;
		g_signal_emit_by_name ((RygelDataSource*) self, "data-available", _tmp0_, (gint) _tmp0__length1);
	}
	result = FALSE;
	return result;
}

static gboolean
_____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}

static gboolean
__lambda5_ (RygelSimpleDataSource* self)
{
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((RygelSimpleDataSource*) self);
	return result;
}

static void
rygel_simple_data_source_run (RygelSimpleDataSource* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	gint fd = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_file_new_for_commandline_arg (_tmp0_);
	file = _tmp1_;
	_tmp2_ = self->priv->uri;
	g_debug ("rygel-simple-data-source.vala:142: Spawning new thread for streaming f" \
"ile %s", _tmp2_);
	fd = -1;
	{
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		fd = open (_tmp5_, O_RDONLY, (mode_t) 0);
		_g_free0 (_tmp5_);
		if (fd < 0) {
			GError* _tmp6_;
			_tmp6_ = vala_g_io_error_from_errno (errno);
			_inner_error0_ = _tmp6_;
			goto __catch0_g_error;
		}
		if (self->priv->last_byte == ((off_t) 0)) {
			self->priv->last_byte = lseek (fd, (off_t) 0, SEEK_END);
			if (self->priv->last_byte < ((off_t) 0)) {
				GError* _tmp7_;
				_tmp7_ = vala_g_io_error_from_errno (errno);
				_inner_error0_ = _tmp7_;
				goto __catch0_g_error;
			}
			if (lseek (fd, (off_t) 0, SEEK_SET) < ((off_t) 0)) {
				GError* _tmp8_;
				_tmp8_ = vala_g_io_error_from_errno (errno);
				_inner_error0_ = _tmp8_;
				goto __catch0_g_error;
			}
		}
		if (self->priv->first_byte != ((off_t) 0)) {
			if (lseek (fd, self->priv->first_byte, SEEK_SET) < ((off_t) 0)) {
				GError* _tmp9_;
				_tmp9_ = vala_g_io_error_from_errno (errno);
				_inner_error0_ = _tmp9_;
				goto __catch0_g_error;
			}
		}
		while (TRUE) {
			Block1Data* _data1_;
			gboolean exit = FALSE;
			gboolean _tmp10_ = FALSE;
			off_t start = {0};
			off_t stop = {0};
			guint8* _tmp11_;
			gint len = 0;
			guint8* _tmp12_;
			gint _tmp12__length1;
			guint8* _tmp13_;
			gint _tmp13__length1;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			g_mutex_lock (&self->priv->mutex);
			while (TRUE) {
				if (!self->priv->frozen) {
					break;
				}
				g_cond_wait (&self->priv->cond, &self->priv->mutex);
			}
			exit = self->priv->stop_thread;
			g_mutex_unlock (&self->priv->mutex);
			if (exit) {
				_tmp10_ = TRUE;
			} else {
				_tmp10_ = self->priv->first_byte == self->priv->last_byte;
			}
			if (_tmp10_) {
				g_debug ("rygel-simple-data-source.vala:178: Done streaming!");
				block1_data_unref (_data1_);
				_data1_ = NULL;
				break;
			}
			start = self->priv->first_byte;
			stop = start + G_MAXUINT16;
			if (stop > self->priv->last_byte) {
				stop = self->priv->last_byte;
			}
			_tmp11_ = g_new0 (guint8, stop - start);
			_data1_->slice = _tmp11_;
			_data1_->slice_length1 = stop - start;
			_data1_->_slice_size_ = _data1_->slice_length1;
			_tmp12_ = _data1_->slice;
			_tmp12__length1 = _data1_->slice_length1;
			_tmp13_ = _data1_->slice;
			_tmp13__length1 = _data1_->slice_length1;
			len = (gint) read (fd, _tmp12_, (gsize) _tmp13__length1);
			if (len < 0) {
				GError* _tmp14_;
				_tmp14_ = vala_g_io_error_from_errno (errno);
				_inner_error0_ = _tmp14_;
				block1_data_unref (_data1_);
				_data1_ = NULL;
				goto __catch0_g_error;
			}
			_data1_->slice_length1 = len;
			self->priv->first_byte = stop;
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = file;
		_tmp16_ = g_file_get_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _error_;
		_tmp19_ = _tmp18_->message;
		g_warning ("rygel-simple-data-source.vala:208: Failed to stream file %s: %s", _tmp17_, _tmp19_);
		_g_free0 (_tmp17_);
		_g_error_free0 (_error_);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		close (fd);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (file);
}

static void
rygel_simple_data_source_class_init (RygelSimpleDataSourceClass * klass,
                                     gpointer klass_data)
{
	rygel_simple_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelSimpleDataSource_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_data_source_finalize;
}

static void
rygel_simple_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface,
                                                           gpointer iface_data)
{
	rygel_simple_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->preroll = (GeeList* (*) (RygelDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_simple_data_source_real_preroll;
	iface->start = (void (*) (RygelDataSource*, GError**)) rygel_simple_data_source_real_start;
	iface->freeze = (void (*) (RygelDataSource*)) rygel_simple_data_source_real_freeze;
	iface->thaw = (void (*) (RygelDataSource*)) rygel_simple_data_source_real_thaw;
	iface->stop = (void (*) (RygelDataSource*)) rygel_simple_data_source_real_stop;
}

static void
rygel_simple_data_source_instance_init (RygelSimpleDataSource * self,
                                        gpointer klass)
{
	self->priv = rygel_simple_data_source_get_instance_private (self);
	g_mutex_init (&self->priv->mutex);
	g_cond_init (&self->priv->cond);
	self->priv->first_byte = (off_t) 0;
	self->priv->last_byte = (off_t) 0;
	self->priv->frozen = FALSE;
	self->priv->stop_thread = FALSE;
}

static void
rygel_simple_data_source_finalize (GObject * obj)
{
	RygelSimpleDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource);
	rygel_data_source_stop ((RygelDataSource*) self);
	_g_free0 (self->priv->uri);
	_g_thread_unref0 (self->priv->thread);
	_vala_clear_GMutex (&self->priv->mutex);
	_vala_clear_GCond (&self->priv->cond);
	G_OBJECT_CLASS (rygel_simple_data_source_parent_class)->finalize (obj);
}

/**
 * A simple data source for use with the simple media engine (RygelSimpleMediaEngine).
 *
 * This does not support time-base seeking with
 * rygel_data_source_start() because it does not
 * use any multimedia framework. Therefore, calling start() with
 * RYGEL_HTTP_SEEK_TYPE_TIME will fail with a
 * RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED GError code,
 */
static GType
rygel_simple_data_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleDataSource), 0, (GInstanceInitFunc) rygel_simple_data_source_instance_init, NULL };
	static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_simple_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_simple_data_source_type_id;
	rygel_simple_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSimpleDataSource", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_simple_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
	RygelSimpleDataSource_private_offset = g_type_add_instance_private (rygel_simple_data_source_type_id, sizeof (RygelSimpleDataSourcePrivate));
	return rygel_simple_data_source_type_id;
}

GType
rygel_simple_data_source_get_type (void)
{
	static volatile gsize rygel_simple_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_data_source_type_id__volatile)) {
		GType rygel_simple_data_source_type_id;
		rygel_simple_data_source_type_id = rygel_simple_data_source_get_type_once ();
		g_once_init_leave (&rygel_simple_data_source_type_id__volatile, rygel_simple_data_source_type_id);
	}
	return rygel_simple_data_source_type_id__volatile;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

