// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/widget.h>
#include <gtkmm/private/widget_p.h>

#include <gtk/gtk.h>

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/vectorutils.h>
#include <giomm/listmodel.h>

#include <gdkmm/frameclock.h>
#include <gdkmm/paintable.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/window.h>
#include <gtkmm/root.h>
#include <gtkmm/native.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/settings.h>
#include <gtkmm/container.h>
#include <gtkmm/eventcontroller.h>
#include <gtkmm/tooltip.h>
#include <gtkmm/snapshot.h>
#include <gtkmm/layoutmanager.h>
#include <gtk/gtk.h>


namespace //anonymous
{

// This signal callback is custom implemented, so that we can refrain from calling
// the signal handler if the C++ wrapper is being deleted.
// https://bugzilla.gnome.org/show_bug.cgi?id=605728#c5
void Widget_signal_hide_callback(GObject* self, void* data)
{
  const auto obj = Glib::ObjectBase::_get_current_wrapper(self);

  // Do not try to call a signal on a disassociated wrapper.
  // This function might be invoked recursively if the signal_hide() handler
  // deletes the object.
  // Therefore we have to test for cpp_destruction_in_progress_ at this point.
  if(obj && !obj->_cpp_destruction_is_in_progress())
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<sigc::slot<void()>*>(slot))();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

gboolean SlotTick_gtk_callback(GtkWidget* self, GdkFrameClock* frame_clock, void* data)
{
  // Do not try to call a signal on a disassociated wrapper.
  if (Glib::ObjectBase::_get_current_wrapper((GObject*)self))
  {
    auto the_slot = static_cast<Gtk::Widget::SlotTick*>(data);
    try
    {
      return (*the_slot)(Glib::wrap(frame_clock, true));
    }
    catch (...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  return false;
}

} //anonymous

namespace Gtk
{

// This default handler callback is custom implemented, so that we can refrain
// from calling an on_hide() override, if the C++ wrapper is being deleted.
void Widget_Class::hide_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  // This function might be invoked recursively if an on_hide() override
  // deletes the object.
  // Therefore we test for cpp_destruction_in_progress_ at this point.
  // (Not sure if it's necessary, but it feels safer. Perhaps the following
  // dynamic_cast catches all dangerous cases. /Kjell Ahlstedt)
  if(obj_base && obj_base->is_derived_() && !obj_base->_cpp_destruction_is_in_progress())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_hide();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->hide)
    (*base->hide)(self);
}

// This vfunc callback is custom implemented because we want the output
// arguments of the C++ vfunc to be int& (not int*), and the vfunc_callback
// function may be called from gtk+ with NULL pointers.
void Widget_Class::measure_vfunc_callback(GtkWidget* self, GtkOrientation orientation, int for_size,
  int* minimum, int* natural, int* minimum_baseline, int* natural_baseline)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        int no_minimum = 0;
        int no_natural = 0;
        int no_minimum_baseline = 0;
        int no_natural_baseline = 0;
        obj->measure_vfunc((Orientation)orientation, for_size,
          (minimum ? *minimum : no_minimum),
          (natural ? *natural : no_natural),
          (minimum_baseline ? *minimum_baseline : no_minimum_baseline),
          (natural_baseline ? *natural_baseline : no_natural_baseline));
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->measure)
    (*base->measure)(self, orientation, for_size, minimum, natural, minimum_baseline, natural_baseline);
}

// This vfunc callback and the corresponding vfunc are custom implemented because we want
// the output arguments of the C++ vfunc to be bool& (not gboolean* or gboolean&).
void Widget_Class::compute_expand_vfunc_callback(GtkWidget* self, gboolean* hexpand_p, gboolean* vexpand_p)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        bool hexpand_pcxx = hexpand_p ? *hexpand_p : false;
        bool vexpand_pcxx = vexpand_p ? *vexpand_p : false;
        obj->compute_expand_vfunc(hexpand_pcxx, vexpand_pcxx);
        if (hexpand_p)
          *hexpand_p = hexpand_pcxx;
        if (vexpand_p)
          *vexpand_p = vexpand_pcxx;
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->compute_expand)
    (*base->compute_expand)(self, hexpand_p, vexpand_p);
}

void Gtk::Widget::compute_expand_vfunc(bool& hexpand_p, bool& vexpand_p)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->compute_expand)
  {
    gboolean hexpand_pc = hexpand_p;
    gboolean vexpand_pc = vexpand_p;
    (*base->compute_expand)(gobj(), &hexpand_pc, &vexpand_pc);
    hexpand_p = hexpand_pc;
    vexpand_p = vexpand_pc;
  }
}


Widget::~Widget() noexcept
{}

Glib::RefPtr<ConstraintTarget> Widget::make_refptr_constrainttarget()
{
  auto refcnt_constrainttarget =
    Glib::make_refptr_for_instance(static_cast<ConstraintTarget*>(this));
  refcnt_constrainttarget->reference();
  return refcnt_constrainttarget;
}

Glib::RefPtr<const ConstraintTarget> Widget::make_refptr_constrainttarget() const
{
  return const_cast<Widget*>(this)->make_refptr_constrainttarget();
}

void Widget::reparent(Container& new_parent)
{
  auto old_parent = get_parent();
  g_return_if_fail(old_parent != nullptr); // if the widget is not in a Container

  if (old_parent != &new_parent)
  {
    reference();
    old_parent->remove(*this);
    new_parent.add(*this);
    unreference();
  }
}

void Widget::set_layout_manager(const Glib::RefPtr<LayoutManager>& layout_manager)
{
  // gtk_widget_set_layout_manager() does not take a ref.
  if (layout_manager)
    layout_manager->reference();
  gtk_widget_set_layout_manager(gobj(), Glib::unwrap(layout_manager));
}

void Widget::unset_layout_manager()
{
  gtk_widget_set_layout_manager(gobj(), nullptr);
}

void Widget::unset_name()
{
  gtk_widget_set_name(gobj(), nullptr);
}

void Widget::realize_if_needed()
{
  if(!get_realized())
    realize();
}

void Widget::unset_focus_child()
{
  gtk_widget_set_focus_child(gobj(), nullptr);
}

void Widget::add_modal_grab()
{
  gtk_grab_add(gobj());
}

void Widget::remove_modal_grab()
{
  gtk_grab_remove(gobj());
}

Widget* Widget::get_current_modal_grab()
{
  return Glib::wrap(gtk_grab_get_current());
}

Allocation Widget::get_allocation() const
{
  Allocation allocation;
  gtk_widget_get_allocation(const_cast<GtkWidget*>(gobj()), allocation.gobj());
  return allocation;
}

void Widget_Class::dispose_vfunc_callback(GObject* self)
{
  //Avoid disposal. See also Window_Class::dispose_vfunc_callback().

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): gobject_: %p\n", (void*)self);
  //if(self)
   //g_warning("  gtypename: %s\n", G_OBJECT_TYPE_NAME(self));
  #endif

  const auto obj = dynamic_cast<Widget*>(
      Glib::ObjectBase::_get_current_wrapper(self));

  // This function might be invoked recursively because we're triggering
  // several signal emissions, particularly signal_hide().  Therefore we
  // have to test for cpp_destruction_in_progress_ at this point.

  if(obj && !obj->_cpp_destruction_is_in_progress()) //When it should really be destroyed, we zero gobj_.
  {
    const auto pWidget = obj->gobj();
    g_return_if_fail(pWidget == GTK_WIDGET(self));

    // Abort dispose if the widget isn't managed, in order to prevent
    // the nasty self-destroying behaviour of GTK+.  This applies to
    // any widget inside a GtkContainer on gtk_container_destroy()
    // See also Window_Class::dispose_vfunc_callback().

    if(obj->referenced_) //Not managed
    {
      // GTKMM_LIFECYCLE
      // Remove the widget from its parent container so that it
      // won't be destroyed later by gtk_container_destroy().
      GtkWidget* parent = gtk_widget_get_parent(pWidget);
      if(parent)
      {
        // Normally, we would have to ref the child widget because
        // gtk_container_remove() unrefs it.  But since we only remove
        // non-managed objects here, the container just releases the
        // reference it has acquired before in gtk_container_add().

        #ifdef GLIBMM_DEBUG_REFCOUNTING
        g_warning("Widget_Class::dispose_vfunc_callback(): removing gobject_: %p from parent: %p", (void*)self, (void*)parent);
        #endif

        gtk_container_remove(GTK_CONTAINER(parent), pWidget);

        #ifdef GLIBMM_DEBUG_REFCOUNTING
        g_warning("Widget_Class::dispose_vfunc_callback(): after removing from parent.");
        #endif
      }

      #ifdef GLIBMM_DEBUG_REFCOUNTING
      g_warning("Widget_Class::dispose_vfunc_callback(): before gtk_widget_hide().");
      #endif

      // Now hide the widget.  The C++ object must _not_ be accessed anymore
      // after this call, because a signal_hide() handler might delete it.
      gtk_widget_hide(pWidget);

      #ifdef GLIBMM_DEBUG_REFCOUNTING
      g_warning("Widget_Class::dispose_vfunc_callback(): after gtk_widget_hide().");
      #endif

      // GTKMM_LIFECYCLE
      return; // Prevent calling of normal C dispose vfunc (see below)
    }

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Widget_Class::dispose_vfunc_callback(): unreferenced: before gtk_widget_hide().");
    #endif

    // Always hide widgets on object destruction, regardless of whether
    // the widget is managed or not.  This is done for consistency so that
    // connecting to signal_hide() is guaranteed to work.
    gtk_widget_hide(pWidget);

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Widget_Class::dispose_vfunc_callback(): unreferenced:  after gtk_widget_hide().");
    #endif
  }

  const auto base = static_cast<GObjectClass*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)));

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): before calling base->dispose.");
  #endif

  if(base->dispose)
    (*base->dispose)(self);

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): after calling base->dispose.");
  #endif
}

void Widget::unset_font_options()
{
  gtk_widget_set_font_options(gobj(), nullptr);
}

void Widget::remove_action_group(const Glib::ustring& name)
{
  gtk_widget_insert_action_group(gobj(), name.c_str(), nullptr /* see C docs */);
}

void Widget::set_margin(int margin)
{
  property_margin() = margin;
}

void Widget::set_expand(bool expand)
{
  property_expand() = expand;
}

void Widget::add_controller(const Glib::RefPtr<EventController>& controller)
{
  // gtk_widget_add_controller() does not take a ref.
  if (controller)
    controller->reference();
  gtk_widget_add_controller(gobj(), Glib::unwrap(controller));
}

guint Widget::add_tick_callback(const SlotTick& slot)
{
  // Create a copy of the slot object. A pointer to this will be passed
  // through the callback's data parameter. It will be deleted
  // when Glib::destroy_notify_delete<SlotTick>() is called.
  auto slot_copy = new SlotTick(slot);

  return gtk_widget_add_tick_callback(gobj(), &SlotTick_gtk_callback, slot_copy,
    &Glib::destroy_notify_delete<SlotTick>);
}

void Widget::insert_at_start(Widget& parent)
{
  gtk_widget_insert_after(gobj(), parent.gobj(), nullptr);
}

void Widget::insert_at_end(Widget& parent)
{
  gtk_widget_insert_before(gobj(), parent.gobj(), nullptr);
}

} // namespace Gtk

namespace
{


static const Glib::SignalProxyInfo Widget_signal_show_info =
{
  "show",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_hide_info =
{
  "hide",
  (GCallback) &Widget_signal_hide_callback,
  (GCallback) &Widget_signal_hide_callback
};


static const Glib::SignalProxyInfo Widget_signal_map_info =
{
  "map",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_unmap_info =
{
  "unmap",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_realize_info =
{
  "realize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_unrealize_info =
{
  "unrealize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Widget_signal_size_allocate_callback(GtkWidget* self, gint p0,gint p1,gint p2,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(int, int, int)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
, p1
, p2
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_size_allocate_info =
{
  "size_allocate",
  (GCallback) &Widget_signal_size_allocate_callback,
  (GCallback) &Widget_signal_size_allocate_callback
};


static void Widget_signal_state_flags_changed_callback(GtkWidget* self, GtkStateFlags p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gtk::StateFlags)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(static_cast<Gtk::StateFlags>(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_state_flags_changed_info =
{
  "state-flags-changed",
  (GCallback) &Widget_signal_state_flags_changed_callback,
  (GCallback) &Widget_signal_state_flags_changed_callback
};


static void Widget_signal_direction_changed_callback(GtkWidget* self, GtkTextDirection p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(TextDirection)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(static_cast<TextDirection>(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_direction_changed_info =
{
  "direction_changed",
  (GCallback) &Widget_signal_direction_changed_callback,
  (GCallback) &Widget_signal_direction_changed_callback
};


static void Widget_signal_grab_notify_callback(GtkWidget* self, gboolean p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(bool)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_grab_notify_info =
{
  "grab_notify",
  (GCallback) &Widget_signal_grab_notify_callback,
  (GCallback) &Widget_signal_grab_notify_callback
};


static gboolean Widget_signal_mnemonic_activate_callback(GtkWidget* self, gboolean p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(bool)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_mnemonic_activate_notify_callback(GtkWidget* self, gboolean p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(bool)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_mnemonic_activate_info =
{
  "mnemonic_activate",
  (GCallback) &Widget_signal_mnemonic_activate_callback,
  (GCallback) &Widget_signal_mnemonic_activate_notify_callback
};


static const Glib::SignalProxyInfo Widget_signal_accel_closures_changed_info =
{
  "accel_closures_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static gboolean Widget_signal_popup_menu_callback(GtkWidget* self, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool()>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))());
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_popup_menu_notify_callback(GtkWidget* self,  void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void()>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_popup_menu_info =
{
  "popup_menu",
  (GCallback) &Widget_signal_popup_menu_callback,
  (GCallback) &Widget_signal_popup_menu_notify_callback
};


static gboolean Widget_signal_query_tooltip_callback(GtkWidget* self, gint p0,gint p1,gboolean p2,GtkTooltip* p3,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(int, int, bool, const Glib::RefPtr<Tooltip>&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
, p1
, p2
, Glib::wrap(p3, true)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_query_tooltip_notify_callback(GtkWidget* self, gint p0,gint p1,gboolean p2,GtkTooltip* p3, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(int, int, bool, const Glib::RefPtr<Tooltip>&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
, p1
, p2
, Glib::wrap(p3, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_query_tooltip_info =
{
  "query_tooltip",
  (GCallback) &Widget_signal_query_tooltip_callback,
  (GCallback) &Widget_signal_query_tooltip_notify_callback
};


} // anonymous namespace


namespace Glib
{

Gtk::Widget* wrap(GtkWidget* object, bool take_copy)
{
  return dynamic_cast<Gtk::Widget *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Widget_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Widget_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_widget_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Buildable::add_interface(get_type());
  ConstraintTarget::add_interface(get_type());
#ifdef GTKMM_ATKMM_ENABLED
  Atk::Implementor::add_interface(get_type());

#endif // GTKMM_ATKMM_ENABLED

  }

  return *this;
}


void Widget_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

    reinterpret_cast<GObjectClass*>(klass)->dispose = &dispose_vfunc_callback;
    klass->root = &root_vfunc_callback;
  klass->unroot = &unroot_vfunc_callback;
  klass->get_request_mode = &get_request_mode_vfunc_callback;
  klass->measure = &measure_vfunc_callback;
  klass->grab_focus = &grab_focus_vfunc_callback;
#ifdef GTKMM_ATKMM_ENABLED
  klass->get_accessible = &get_accessible_vfunc_callback;
#endif // GTKMM_ATKMM_ENABLED
  klass->compute_expand = &compute_expand_vfunc_callback;
  klass->contains = &contains_vfunc_callback;
  klass->snapshot = &snapshot_vfunc_callback;

  klass->show = &show_callback;
  klass->hide = &hide_callback;
  klass->map = &map_callback;
  klass->unmap = &unmap_callback;
  klass->realize = &realize_callback;
  klass->unrealize = &unrealize_callback;
  klass->size_allocate = &size_allocate_callback;
  klass->state_flags_changed = &state_flags_changed_callback;
  klass->direction_changed = &direction_changed_callback;
  klass->grab_notify = &grab_notify_callback;
  klass->mnemonic_activate = &mnemonic_activate_callback;
  klass->popup_menu = &popup_menu_callback;
  klass->query_tooltip = &query_tooltip_callback;
}

void Widget_Class::root_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->root_vfunc();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->root)
    (*base->root)(self);
}
void Widget_Class::unroot_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->unroot_vfunc();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->unroot)
    (*base->unroot)(self);
}
GtkSizeRequestMode Widget_Class::get_request_mode_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<GtkSizeRequestMode>(obj->get_request_mode_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_request_mode)
    return (*base->get_request_mode)(self);

  using RType = GtkSizeRequestMode;
  return RType();
}
gboolean Widget_Class::grab_focus_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->grab_focus_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->grab_focus)
    return (*base->grab_focus)(self);

  using RType = gboolean;
  return RType();
}
#ifdef GTKMM_ATKMM_ENABLED
AtkObject* Widget_Class::get_accessible_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->get_accessible_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_accessible)
    return (*base->get_accessible)(self);

  using RType = AtkObject*;
  return RType();
}
#endif // GTKMM_ATKMM_ENABLED
gboolean Widget_Class::contains_vfunc_callback(GtkWidget* self, gdouble x, gdouble y)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->contains_vfunc(x
, y
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->contains)
    return (*base->contains)(self, x, y);

  using RType = gboolean;
  return RType();
}
void Widget_Class::snapshot_vfunc_callback(GtkWidget* self, GtkSnapshot* snapshot)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->snapshot_vfunc(Glib::wrap_gtk_snapshot(snapshot, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->snapshot)
    (*base->snapshot)(self, snapshot);
}

void Widget_Class::show_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_show();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->show)
    (*base->show)(self);
}
void Widget_Class::map_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_map();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->map)
    (*base->map)(self);
}
void Widget_Class::unmap_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_unmap();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unmap)
    (*base->unmap)(self);
}
void Widget_Class::realize_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_realize();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->realize)
    (*base->realize)(self);
}
void Widget_Class::unrealize_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_unrealize();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unrealize)
    (*base->unrealize)(self);
}
void Widget_Class::size_allocate_callback(GtkWidget* self, gint p0, gint p1, gint p2)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_size_allocate(p0
, p1
, p2
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->size_allocate)
    (*base->size_allocate)(self, p0, p1, p2);
}
void Widget_Class::state_flags_changed_callback(GtkWidget* self, GtkStateFlags p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_state_flags_changed(static_cast<Gtk::StateFlags>(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->state_flags_changed)
    (*base->state_flags_changed)(self, p0);
}
void Widget_Class::direction_changed_callback(GtkWidget* self, GtkTextDirection p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_direction_changed(static_cast<TextDirection>(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->direction_changed)
    (*base->direction_changed)(self, p0);
}
void Widget_Class::grab_notify_callback(GtkWidget* self, gboolean p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_grab_notify(p0
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->grab_notify)
    (*base->grab_notify)(self, p0);
}
gboolean Widget_Class::mnemonic_activate_callback(GtkWidget* self, gboolean p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_mnemonic_activate(p0
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->mnemonic_activate)
    return (*base->mnemonic_activate)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::popup_menu_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_popup_menu());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->popup_menu)
    return (*base->popup_menu)(self);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::query_tooltip_callback(GtkWidget* self, gint p0, gint p1, gboolean p2, GtkTooltip* p3)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_query_tooltip(p0
, p1
, p2
, Glib::wrap(p3, true)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->query_tooltip)
    return (*base->query_tooltip)(self, p0, p1, p2, p3);

  using RType = gboolean;
  return RType();
}


Glib::ObjectBase* Widget_Class::wrap_new(GObject* o)
{
  return manage(new Widget((GtkWidget*)(o)));

}


/* The implementation: */

Widget::Widget(const Glib::ConstructParams& construct_params)
:
  Object(construct_params)
{
  }

Widget::Widget(GtkWidget* castitem)
:
  Object((GObject*)(castitem))
{
  }


Widget::Widget(Widget&& src) noexcept
: Object(std::move(src))
  , Buildable(std::move(src))
  , ConstraintTarget(std::move(src))
#ifdef GTKMM_ATKMM_ENABLED
  , Atk::Implementor(std::move(src))

#endif // GTKMM_ATKMM_ENABLED
{}

Widget& Widget::operator=(Widget&& src) noexcept
{
  Object::operator=(std::move(src));
  Buildable::operator=(std::move(src));
  ConstraintTarget::operator=(std::move(src));
#ifdef GTKMM_ATKMM_ENABLED
  Atk::Implementor::operator=(std::move(src));

#endif // GTKMM_ATKMM_ENABLED
  return *this;
}

Widget::CppClassType Widget::widget_class_; // initialize static member

GType Widget::get_type()
{
  return widget_class_.init().get_type();
}


GType Widget::get_base_type()
{
  return gtk_widget_get_type();
}


void Widget::show()
{
  gtk_widget_show(gobj());
}

void Widget::hide()
{
  gtk_widget_hide(gobj());
}

void Widget::queue_draw()
{
  gtk_widget_queue_draw(gobj());
}

void Widget::queue_resize()
{
  gtk_widget_queue_resize(gobj());
}

void Widget::queue_allocate()
{
  gtk_widget_queue_allocate(gobj());
}

void Widget::size_allocate(const Allocation& allocation, int baseline)
{
  gtk_widget_size_allocate(gobj(), (allocation.gobj()), baseline);
}

SizeRequestMode Widget::get_request_mode() const
{
  return static_cast<SizeRequestMode>(gtk_widget_get_request_mode(const_cast<GtkWidget*>(gobj())));
}

void Widget::measure(Orientation orientation, int for_size, int& minimum, int& natural, int& minimum_baseline, int& natural_baseline) const
{
  gtk_widget_measure(const_cast<GtkWidget*>(gobj()), static_cast<GtkOrientation>(orientation), for_size, &(minimum), &(natural), &(minimum_baseline), &(natural_baseline));
}

void Widget::get_preferred_size(Requisition& minimum_size, Requisition& natural_size) const
{
  gtk_widget_get_preferred_size(const_cast<GtkWidget*>(gobj()), (GtkRequisition*)(&minimum_size), (GtkRequisition*)(&natural_size));
}

Glib::RefPtr<LayoutManager> Widget::get_layout_manager()
{
  auto retvalue = Glib::wrap(gtk_widget_get_layout_manager(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const LayoutManager> Widget::get_layout_manager() const
{
  return const_cast<Widget*>(this)->get_layout_manager();
}

void Widget::add_accelerator(const Glib::ustring& accel_signal, const Glib::RefPtr<AccelGroup>& accel_group, guint accel_key, Gdk::ModifierType accel_mods, AccelFlags accel_flags)
{
  gtk_widget_add_accelerator(gobj(), accel_signal.c_str(), Glib::unwrap(accel_group), accel_key, static_cast<GdkModifierType>(accel_mods), static_cast<GtkAccelFlags>(accel_flags));
}

bool Widget::remove_accelerator(const Glib::RefPtr<AccelGroup>& accel_group, guint accel_key, Gdk::ModifierType accel_mods)
{
  return gtk_widget_remove_accelerator(gobj(), Glib::unwrap(accel_group), accel_key, static_cast<GdkModifierType>(accel_mods));
}

void Widget::set_accel_path(const Glib::ustring& accel_path, const Glib::RefPtr<AccelGroup>& accel_group)
{
  gtk_widget_set_accel_path(gobj(), accel_path.c_str(), Glib::unwrap(accel_group));
}

bool Widget::mnemonic_activate(bool group_cycling)
{
  return gtk_widget_mnemonic_activate(gobj(), static_cast<int>(group_cycling));
}

bool Widget::event(const Glib::RefPtr<Gdk::Event>& gdk_event)
{
  return gtk_widget_event(gobj(), Glib::unwrap(gdk_event));
}

bool Widget::activate()
{
  return gtk_widget_activate(gobj());
}

void Widget::set_can_focus(bool can_focus)
{
  gtk_widget_set_can_focus(gobj(), static_cast<int>(can_focus));
}

bool Widget::get_can_focus() const
{
  return gtk_widget_get_can_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_focus() const
{
  return gtk_widget_has_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_focus() const
{
  return gtk_widget_is_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_visible_focus() const
{
  return gtk_widget_has_visible_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::grab_focus()
{
  return gtk_widget_grab_focus(gobj());
}

void Widget::set_focus_on_click(bool focus_on_click)
{
  gtk_widget_set_focus_on_click(gobj(), static_cast<int>(focus_on_click));
}

bool Widget::get_focus_on_click() const
{
  return gtk_widget_get_focus_on_click(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_can_target(bool can_target)
{
  gtk_widget_set_can_target(gobj(), static_cast<int>(can_target));
}

bool Widget::get_can_target() const
{
  return gtk_widget_get_can_target(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_default() const
{
  return gtk_widget_has_default(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_receives_default(bool receives_default)
{
  gtk_widget_set_receives_default(gobj(), static_cast<int>(receives_default));
}

bool Widget::get_receives_default() const
{
  return gtk_widget_get_receives_default(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_grab() const
{
  return gtk_widget_has_grab(const_cast<GtkWidget*>(gobj()));
}

bool Widget::device_is_shadowed(const Glib::RefPtr<const Gdk::Device>& device)
{
  return gtk_widget_device_is_shadowed(gobj(), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)));
}

void Widget::set_name(const Glib::ustring& name)
{
  gtk_widget_set_name(gobj(), name.c_str());
}

Glib::ustring Widget::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_widget_get_name(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_state_flags(StateFlags flags, bool clear)
{
  gtk_widget_set_state_flags(gobj(), static_cast<GtkStateFlags>(flags), static_cast<int>(clear));
}

void Widget::unset_state_flags(StateFlags flags)
{
  gtk_widget_unset_state_flags(gobj(), static_cast<GtkStateFlags>(flags));
}

StateFlags Widget::get_state_flags() const
{
  return static_cast<StateFlags>(gtk_widget_get_state_flags(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_sensitive(bool sensitive)
{
  gtk_widget_set_sensitive(gobj(), static_cast<int>(sensitive));
}

bool Widget::get_sensitive() const
{
  return gtk_widget_get_sensitive(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_sensitive() const
{
  return gtk_widget_is_sensitive(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_visible(bool visible)
{
  gtk_widget_set_visible(gobj(), static_cast<int>(visible));
}

bool Widget::get_visible() const
{
  return gtk_widget_get_visible(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_visible() const
{
  return gtk_widget_is_visible(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_is_drawable() const
{
  return gtk_widget_is_drawable(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_realized() const
{
  return gtk_widget_get_realized(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_mapped() const
{
  return gtk_widget_get_mapped(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_child_visible(bool visible)
{
  gtk_widget_set_child_visible(gobj(), static_cast<int>(visible));
}

bool Widget::get_child_visible() const
{
  return gtk_widget_get_child_visible(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_allocated_width() const
{
  return gtk_widget_get_allocated_width(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_allocated_height() const
{
  return gtk_widget_get_allocated_height(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_allocated_baseline() const
{
  return gtk_widget_get_allocated_baseline(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_width() const
{
  return gtk_widget_get_width(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_height() const
{
  return gtk_widget_get_height(const_cast<GtkWidget*>(gobj()));
}

Container* Widget::get_parent()
{
  return Glib::wrap((GtkContainer*)(gtk_widget_get_parent(gobj())));
}

const Container* Widget::get_parent() const
{
  return const_cast<Widget*>(this)->get_parent();
}

Root* Widget::get_root()
{
  return dynamic_cast<Root*>(Glib::wrap_auto((GObject*)(gtk_widget_get_root(gobj())), false));
}

const Root* Widget::get_root() const
{
  return const_cast<Widget*>(this)->get_root();
}

Native* Widget::get_native()
{
  return dynamic_cast<Native*>(Glib::wrap_auto((GObject*)(gtk_widget_get_native(gobj())), false));
}

const Native* Widget::get_native() const
{
  return const_cast<Widget*>(this)->get_native();
}

bool Widget::child_focus(DirectionType direction)
{
  return gtk_widget_child_focus(gobj(), static_cast<GtkDirectionType>(direction));
}

bool Widget::keynav_failed(DirectionType direction)
{
  return gtk_widget_keynav_failed(gobj(), static_cast<GtkDirectionType>(direction));
}

void Widget::error_bell()
{
  gtk_widget_error_bell(gobj());
}

void Widget::set_size_request(int width, int height)
{
  gtk_widget_set_size_request(gobj(), width, height);
}

void Widget::get_size_request(int& width, int& height) const
{
  gtk_widget_get_size_request(const_cast<GtkWidget*>(gobj()), &(width), &(height));
}

void Widget::set_opacity(double opacity)
{
  gtk_widget_set_opacity(gobj(), opacity);
}

double Widget::get_opacity() const
{
  return gtk_widget_get_opacity(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_overflow(Overflow overflow)
{
  gtk_widget_set_overflow(gobj(), static_cast<GtkOverflow>(overflow));
}

Overflow Widget::get_overflow() const
{
  return static_cast<Overflow>(gtk_widget_get_overflow(const_cast<GtkWidget*>(gobj())));
}

Widget* Widget::get_ancestor(GType widget_type)
{
  return Glib::wrap(gtk_widget_get_ancestor(gobj(), widget_type));
}

const Widget* Widget::get_ancestor(GType widget_type) const
{
  return const_cast<Widget*>(this)->get_ancestor(widget_type);
}

int Widget::get_scale_factor() const
{
  return gtk_widget_get_scale_factor(const_cast<GtkWidget*>(gobj()));
}

Glib::RefPtr<Gdk::Display> Widget::get_display()
{
  auto retvalue = Glib::wrap(gtk_widget_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Display> Widget::get_display() const
{
  return const_cast<Widget*>(this)->get_display();
}

Glib::RefPtr<Settings> Widget::get_settings()
{
  auto retvalue = Glib::wrap(gtk_widget_get_settings(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Gdk::Clipboard> Widget::get_clipboard()
{
  auto retvalue = Glib::wrap(gtk_widget_get_clipboard(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Clipboard> Widget::get_clipboard() const
{
  return const_cast<Widget*>(this)->get_clipboard();
}

Glib::RefPtr<Gdk::Clipboard> Widget::get_primary_clipboard()
{
  auto retvalue = Glib::wrap(gtk_widget_get_primary_clipboard(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Clipboard> Widget::get_primary_clipboard() const
{
  return const_cast<Widget*>(this)->get_primary_clipboard();
}

bool Widget::get_hexpand() const
{
  return gtk_widget_get_hexpand(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_hexpand(bool expand)
{
  gtk_widget_set_hexpand(gobj(), static_cast<int>(expand));
}

bool Widget::get_hexpand_set() const
{
  return gtk_widget_get_hexpand_set(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_hexpand_set(bool set)
{
  gtk_widget_set_hexpand_set(gobj(), static_cast<int>(set));
}

bool Widget::get_vexpand() const
{
  return gtk_widget_get_vexpand(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_vexpand(bool expand)
{
  gtk_widget_set_vexpand(gobj(), static_cast<int>(expand));
}

bool Widget::get_vexpand_set() const
{
  return gtk_widget_get_vexpand_set(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_vexpand_set(bool set)
{
  gtk_widget_set_vexpand_set(gobj(), static_cast<int>(set));
}

bool Widget::compute_expand(Orientation orientation)
{
  return gtk_widget_compute_expand(gobj(), static_cast<GtkOrientation>(orientation));
}

bool Widget::get_support_multidevice() const
{
  return gtk_widget_get_support_multidevice(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_support_multidevice(bool support_multidevice)
{
  gtk_widget_set_support_multidevice(gobj(), static_cast<int>(support_multidevice));
}

#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<Atk::Object> Widget::get_accessible()
{
  auto retvalue = Glib::wrap(gtk_widget_get_accessible(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}
#endif // GTKMM_ATKMM_ENABLED

#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<const Atk::Object> Widget::get_accessible() const
{
  return const_cast<Widget*>(this)->get_accessible();
}
#endif // GTKMM_ATKMM_ENABLED

Align Widget::get_halign() const
{
  return static_cast<Align>(gtk_widget_get_halign(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_halign(Align align)
{
  gtk_widget_set_halign(gobj(), static_cast<GtkAlign>(align));
}

Align Widget::get_valign() const
{
  return static_cast<Align>(gtk_widget_get_valign(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_valign(Align align)
{
  gtk_widget_set_valign(gobj(), static_cast<GtkAlign>(align));
}

int Widget::get_margin_start() const
{
  return gtk_widget_get_margin_start(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_start(int margin)
{
  gtk_widget_set_margin_start(gobj(), margin);
}

int Widget::get_margin_end() const
{
  return gtk_widget_get_margin_end(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_end(int margin)
{
  gtk_widget_set_margin_end(gobj(), margin);
}

int Widget::get_margin_top() const
{
  return gtk_widget_get_margin_top(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_top(int margin)
{
  gtk_widget_set_margin_top(gobj(), margin);
}

int Widget::get_margin_bottom() const
{
  return gtk_widget_get_margin_bottom(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_bottom(int margin)
{
  gtk_widget_set_margin_bottom(gobj(), margin);
}

bool Widget::is_ancestor(Widget & ancestor) const
{
  return gtk_widget_is_ancestor(const_cast<GtkWidget*>(gobj()), (ancestor).gobj());
}

bool Widget::translate_coordinates(Widget& dest_widget, int src_x, int src_y, int& dest_x, int& dest_y)
{
  return gtk_widget_translate_coordinates(gobj(), (dest_widget).gobj(), src_x, src_y, &(dest_x), &(dest_y));
}

bool Widget::contains(double x, double y) const
{
  return gtk_widget_contains(const_cast<GtkWidget*>(gobj()), x, y);
}

Widget* Widget::pick(double x, double y, PickFlags flags)
{
  return Glib::wrap(gtk_widget_pick(gobj(), x, y, static_cast<GtkPickFlags>(flags)));
}

const Widget* Widget::pick(double x, double y, PickFlags flags) const
{
  return const_cast<Widget*>(this)->pick(x, y, flags);
}

void Widget::remove_controller(const Glib::RefPtr<EventController>& controller)
{
  gtk_widget_remove_controller(gobj(), Glib::unwrap(controller));
}

void Widget::reset_style()
{
  gtk_widget_reset_style(gobj());
}

Glib::RefPtr<Pango::Context> Widget::create_pango_context()
{
  return Glib::wrap(gtk_widget_create_pango_context(gobj()));
}

Glib::RefPtr<Pango::Context> Widget::get_pango_context()
{
  auto retvalue = Glib::wrap(gtk_widget_get_pango_context(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Widget::set_font_options(const Cairo::FontOptions& options)
{
  gtk_widget_set_font_options(gobj(), (options).cobj());
}

Cairo::FontOptions Widget::get_font_options() const
{
  return Cairo::FontOptions(const_cast<cairo_font_options_t*>(gtk_widget_get_font_options(const_cast<GtkWidget*>(gobj()))), false /* take_ownership */);
}

Glib::RefPtr<Pango::Layout> Widget::create_pango_layout(const Glib::ustring& text)
{
  return Glib::wrap(gtk_widget_create_pango_layout(gobj(), text.c_str()));
}

void Widget::set_direction(TextDirection dir)
{
  gtk_widget_set_direction(gobj(), static_cast<GtkTextDirection>(dir));
}

TextDirection Widget::get_direction() const
{
  return static_cast<TextDirection>(gtk_widget_get_direction(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_default_direction(TextDirection dir)
{
  gtk_widget_set_default_direction(static_cast<GtkTextDirection>(dir));
}

TextDirection Widget::get_default_direction()
{
  return static_cast<TextDirection>(gtk_widget_get_default_direction());
}

void Widget::input_shape_combine_region(const Cairo::RefPtr<const Cairo::Region>& region)
{
  gtk_widget_input_shape_combine_region(gobj(), const_cast<cairo_region_t*>((region) ? (region)->cobj() : nullptr));
}

void Widget::set_cursor(const Glib::RefPtr<Gdk::Cursor>& cursor)
{
  gtk_widget_set_cursor(gobj(), Glib::unwrap(cursor));
}

void Widget::set_cursor(const Glib::ustring& name)
{
  gtk_widget_set_cursor_from_name(gobj(), name.empty() ? nullptr : name.c_str());
}

Glib::RefPtr<Gdk::Cursor> Widget::get_cursor()
{
  auto retvalue = Glib::wrap(gtk_widget_get_cursor(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Cursor> Widget::get_cursor() const
{
  return const_cast<Widget*>(this)->get_cursor();
}

std::vector<Widget*> Widget::list_mnemonic_labels()
{
  return Glib::ListHandler<Widget*>::list_to_vector(gtk_widget_list_mnemonic_labels(gobj()), Glib::OWNERSHIP_SHALLOW);
}

std::vector<const Widget*> Widget::list_mnemonic_labels() const
{
  return Glib::ListHandler<const Widget*>::list_to_vector(gtk_widget_list_mnemonic_labels(const_cast<GtkWidget*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Widget::add_mnemonic_label(Widget& label)
{
  gtk_widget_add_mnemonic_label(gobj(), (label).gobj());
}

void Widget::remove_mnemonic_label(Widget& label)
{
  gtk_widget_remove_mnemonic_label(gobj(), (label).gobj());
}

bool Widget::drag_check_threshold(int start_x, int start_y, int current_x, int current_y)
{
  return gtk_drag_check_threshold(gobj(), start_x, start_y, current_x, current_y);
}

Glib::RefPtr<Gdk::FrameClock> Widget::get_frame_clock()
{
  auto retvalue = Glib::wrap(gtk_widget_get_frame_clock(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::FrameClock> Widget::get_frame_clock() const
{
  return const_cast<Widget*>(this)->get_frame_clock();
}

void Widget::set_parent(Widget& parent)
{
  gtk_widget_set_parent(gobj(), (parent).gobj());
}

void Widget::unparent()
{
  gtk_widget_unparent(gobj());
}

void Widget::map()
{
  gtk_widget_map(gobj());
}

void Widget::unmap()
{
  gtk_widget_unmap(gobj());
}

void Widget::trigger_tooltip_query()
{
  gtk_widget_trigger_tooltip_query(gobj());
}

void Widget::set_tooltip_text(const Glib::ustring& text)
{
  gtk_widget_set_tooltip_text(gobj(), text.c_str());
}

Glib::ustring Widget::get_tooltip_text() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_widget_get_tooltip_text(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_tooltip_markup(const Glib::ustring& markup)
{
  gtk_widget_set_tooltip_markup(gobj(), markup.c_str());
}

Glib::ustring Widget::get_tooltip_markup() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_widget_get_tooltip_markup(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_has_tooltip(bool has_tooltip)
{
  gtk_widget_set_has_tooltip(gobj(), static_cast<int>(has_tooltip));
}

bool Widget::get_has_tooltip() const
{
  return gtk_widget_get_has_tooltip(const_cast<GtkWidget*>(gobj()));
}

bool Widget::in_destruction() const
{
  return gtk_widget_in_destruction(const_cast<GtkWidget*>(gobj()));
}

Glib::RefPtr<StyleContext> Widget::get_style_context()
{
  auto retvalue = Glib::wrap(gtk_widget_get_style_context(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const StyleContext> Widget::get_style_context() const
{
  return const_cast<Widget*>(this)->get_style_context();
}

Gdk::ModifierType Widget::get_modifier_mask(Gdk::ModifierIntent intent)
{
  return static_cast<Gdk::ModifierType>(gtk_widget_get_modifier_mask(gobj(), static_cast<GdkModifierIntent>(intent)));
}

void Widget::remove_tick_callback(guint id)
{
  gtk_widget_remove_tick_callback(gobj(), id);
}

void Widget::insert_action_group(const Glib::ustring& name, const Glib::RefPtr<Gio::ActionGroup>& group)
{
  gtk_widget_insert_action_group(gobj(), name.c_str(), const_cast<GActionGroup*>(Glib::unwrap<Gio::ActionGroup>(group)));
}

bool Widget::activate_action(const Glib::ustring& name, const Glib::VariantBase& args)
{
  return gtk_widget_activate_action_variant(gobj(), name.c_str(), const_cast<GVariant*>((args).gobj()));
}

bool Widget::activate_action(const Glib::ustring& name)
{
  return gtk_widget_activate_action_variant(gobj(), name.c_str(), nullptr);
}

void Widget::activate_default()
{
  gtk_widget_activate_default(gobj());
}

void Widget::set_font_map(const Glib::RefPtr<Pango::FontMap>& font_map)
{
  gtk_widget_set_font_map(gobj(), Glib::unwrap(font_map));
}

Glib::RefPtr<Pango::FontMap> Widget::get_font_map()
{
  auto retvalue = Glib::wrap(gtk_widget_get_font_map(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Pango::FontMap> Widget::get_font_map() const
{
  return const_cast<Widget*>(this)->get_font_map();
}

Widget* Widget::get_first_child()
{
  return Glib::wrap(gtk_widget_get_first_child(gobj()));
}

const Widget* Widget::get_first_child() const
{
  return const_cast<Widget*>(this)->get_first_child();
}

Widget* Widget::get_last_child()
{
  return Glib::wrap(gtk_widget_get_last_child(gobj()));
}

const Widget* Widget::get_last_child() const
{
  return const_cast<Widget*>(this)->get_last_child();
}

Widget* Widget::get_next_sibling()
{
  return Glib::wrap(gtk_widget_get_next_sibling(gobj()));
}

const Widget* Widget::get_next_sibling() const
{
  return const_cast<Widget*>(this)->get_next_sibling();
}

Widget* Widget::get_prev_sibling()
{
  return Glib::wrap(gtk_widget_get_prev_sibling(gobj()));
}

const Widget* Widget::get_prev_sibling() const
{
  return const_cast<Widget*>(this)->get_prev_sibling();
}

Glib::RefPtr<Gio::ListModel> Widget::observe_children()
{
  return Glib::wrap(gtk_widget_observe_children(gobj()));
}

Glib::RefPtr<const Gio::ListModel> Widget::observe_children() const
{
  return const_cast<Widget*>(this)->observe_children();
}

Glib::RefPtr<Gio::ListModel> Widget::observe_controllers()
{
  return Glib::wrap(gtk_widget_observe_controllers(gobj()));
}

Glib::RefPtr<const Gio::ListModel> Widget::observe_controllers() const
{
  return const_cast<Widget*>(this)->observe_controllers();
}

void Widget::insert_after(Widget& parent, const Widget& previous_sibling)
{
  gtk_widget_insert_after(gobj(), (parent).gobj(), const_cast<GtkWidget*>((previous_sibling).gobj()));
}

void Widget::insert_before(Widget& parent, const Widget& next_sibling)
{
  gtk_widget_insert_before(gobj(), (parent).gobj(), const_cast<GtkWidget*>((next_sibling).gobj()));
}

void Widget::snapshot_child(Widget& child, const Glib::RefPtr<Gtk::Snapshot>& snapshot)
{
  gtk_widget_snapshot_child(gobj(), (child).gobj(), Glib::unwrap(snapshot));
}

bool Widget::should_layout() const
{
  return gtk_widget_should_layout(const_cast<GtkWidget*>(gobj()));
}

void Widget::add_css_class(const Glib::ustring& css_class)
{
  gtk_widget_add_css_class(gobj(), css_class.c_str());
}

void Widget::remove_css_class(const Glib::ustring& css_class)
{
  gtk_widget_remove_css_class(gobj(), css_class.c_str());
}

bool Widget::has_css_class(const Glib::ustring& css_class) const
{
  return gtk_widget_has_css_class(const_cast<GtkWidget*>(gobj()), css_class.c_str());
}

Widget::Widget()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Object(Glib::ConstructParams(widget_class_.init()))
{
  

}

void Widget::realize()
{
  gtk_widget_realize(gobj());
}

void Widget::unrealize()
{
  gtk_widget_unrealize(gobj());
}

void Widget::set_focus_child(Widget& child)
{
  gtk_widget_set_focus_child(gobj(), (child).gobj());
}

Widget* Widget::get_focus_child()
{
  return Glib::wrap(gtk_widget_get_focus_child(gobj()));
}

const Widget* Widget::get_focus_child() const
{
  return const_cast<Widget*>(this)->get_focus_child();
}


Glib::SignalProxy<void()> Widget::signal_show()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_show_info);
}


Glib::SignalProxy<void()> Widget::signal_hide()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_hide_info);
}


Glib::SignalProxy<void()> Widget::signal_map()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_map_info);
}


Glib::SignalProxy<void()> Widget::signal_unmap()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_unmap_info);
}


Glib::SignalProxy<void()> Widget::signal_realize()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_realize_info);
}


Glib::SignalProxy<void()> Widget::signal_unrealize()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_unrealize_info);
}


Glib::SignalProxy<void(int, int, int)> Widget::signal_size_allocate()
{
  return Glib::SignalProxy<void(int, int, int) >(this, &Widget_signal_size_allocate_info);
}


Glib::SignalProxy<void(Gtk::StateFlags)> Widget::signal_state_flags_changed()
{
  return Glib::SignalProxy<void(Gtk::StateFlags) >(this, &Widget_signal_state_flags_changed_info);
}


Glib::SignalProxy<void(TextDirection)> Widget::signal_direction_changed()
{
  return Glib::SignalProxy<void(TextDirection) >(this, &Widget_signal_direction_changed_info);
}


Glib::SignalProxy<void(bool)> Widget::signal_grab_notify()
{
  return Glib::SignalProxy<void(bool) >(this, &Widget_signal_grab_notify_info);
}


Glib::SignalProxy<bool(bool)> Widget::signal_mnemonic_activate()
{
  return Glib::SignalProxy<bool(bool) >(this, &Widget_signal_mnemonic_activate_info);
}


Glib::SignalProxy<void()> Widget::signal_accel_closures_changed()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_accel_closures_changed_info);
}


Glib::SignalProxy<bool()> Widget::signal_popup_menu()
{
  return Glib::SignalProxy<bool() >(this, &Widget_signal_popup_menu_info);
}


Glib::SignalProxy<bool(int, int, bool, const Glib::RefPtr<Tooltip>&)> Widget::signal_query_tooltip()
{
  return Glib::SignalProxy<bool(int, int, bool, const Glib::RefPtr<Tooltip>&) >(this, &Widget_signal_query_tooltip_info);
}


Glib::PropertyProxy< Glib::ustring > Widget::property_name() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "name");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "name");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Container*>::value,
  "Type Container* cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Container* > Widget::property_parent() const
{
  return Glib::PropertyProxy_ReadOnly< Container* >(this, "parent");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Root*>::value,
  "Type Root* cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Root* > Widget::property_root() const
{
  return Glib::PropertyProxy_ReadOnly< Root* >(this, "root");
}

Glib::PropertyProxy< int > Widget::property_width_request() 
{
  return Glib::PropertyProxy< int >(this, "width-request");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_width_request() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "width-request");
}

Glib::PropertyProxy< int > Widget::property_height_request() 
{
  return Glib::PropertyProxy< int >(this, "height-request");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_height_request() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "height-request");
}

Glib::PropertyProxy< bool > Widget::property_visible() 
{
  return Glib::PropertyProxy< bool >(this, "visible");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_visible() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "visible");
}

Glib::PropertyProxy< bool > Widget::property_sensitive() 
{
  return Glib::PropertyProxy< bool >(this, "sensitive");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_sensitive() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "sensitive");
}

Glib::PropertyProxy< bool > Widget::property_can_focus() 
{
  return Glib::PropertyProxy< bool >(this, "can-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_can_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-focus");
}

Glib::PropertyProxy< bool > Widget::property_has_focus() 
{
  return Glib::PropertyProxy< bool >(this, "has-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-focus");
}

Glib::PropertyProxy< bool > Widget::property_is_focus() 
{
  return Glib::PropertyProxy< bool >(this, "is-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_is_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "is-focus");
}

Glib::PropertyProxy< bool > Widget::property_can_target() 
{
  return Glib::PropertyProxy< bool >(this, "can-target");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_can_target() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-target");
}

Glib::PropertyProxy< bool > Widget::property_focus_on_click() 
{
  return Glib::PropertyProxy< bool >(this, "focus-on-click");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_focus_on_click() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "focus-on-click");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-default");
}

Glib::PropertyProxy< bool > Widget::property_receives_default() 
{
  return Glib::PropertyProxy< bool >(this, "receives-default");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_receives_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "receives-default");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gdk::Cursor>>::value,
  "Type Glib::RefPtr<Gdk::Cursor> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gdk::Cursor> > Widget::property_cursor() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Cursor> >(this, "cursor");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Cursor> > Widget::property_cursor() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Cursor> >(this, "cursor");
}

Glib::PropertyProxy< bool > Widget::property_has_tooltip() 
{
  return Glib::PropertyProxy< bool >(this, "has-tooltip");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_tooltip() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-tooltip");
}

Glib::PropertyProxy< Glib::ustring > Widget::property_tooltip_markup() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "tooltip-markup");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_tooltip_markup() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "tooltip-markup");
}

Glib::PropertyProxy< Glib::ustring > Widget::property_tooltip_text() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "tooltip-text");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_tooltip_text() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "tooltip-text");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Align>::value,
  "Type Align cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Align > Widget::property_halign() 
{
  return Glib::PropertyProxy< Align >(this, "halign");
}

Glib::PropertyProxy_ReadOnly< Align > Widget::property_halign() const
{
  return Glib::PropertyProxy_ReadOnly< Align >(this, "halign");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Align>::value,
  "Type Align cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Align > Widget::property_valign() 
{
  return Glib::PropertyProxy< Align >(this, "valign");
}

Glib::PropertyProxy_ReadOnly< Align > Widget::property_valign() const
{
  return Glib::PropertyProxy_ReadOnly< Align >(this, "valign");
}

Glib::PropertyProxy< int > Widget::property_margin_start() 
{
  return Glib::PropertyProxy< int >(this, "margin-start");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_start() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-start");
}

Glib::PropertyProxy< int > Widget::property_margin_end() 
{
  return Glib::PropertyProxy< int >(this, "margin-end");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_end() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-end");
}

Glib::PropertyProxy< int > Widget::property_margin_top() 
{
  return Glib::PropertyProxy< int >(this, "margin-top");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_top() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-top");
}

Glib::PropertyProxy< int > Widget::property_margin_bottom() 
{
  return Glib::PropertyProxy< int >(this, "margin-bottom");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_bottom() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-bottom");
}

Glib::PropertyProxy< int > Widget::property_margin() 
{
  return Glib::PropertyProxy< int >(this, "margin");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin");
}

Glib::PropertyProxy< bool > Widget::property_hexpand() 
{
  return Glib::PropertyProxy< bool >(this, "hexpand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_hexpand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hexpand");
}

Glib::PropertyProxy< bool > Widget::property_hexpand_set() 
{
  return Glib::PropertyProxy< bool >(this, "hexpand-set");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_hexpand_set() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hexpand-set");
}

Glib::PropertyProxy< bool > Widget::property_vexpand() 
{
  return Glib::PropertyProxy< bool >(this, "vexpand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_vexpand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "vexpand");
}

Glib::PropertyProxy< bool > Widget::property_vexpand_set() 
{
  return Glib::PropertyProxy< bool >(this, "vexpand-set");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_vexpand_set() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "vexpand-set");
}

Glib::PropertyProxy< bool > Widget::property_expand() 
{
  return Glib::PropertyProxy< bool >(this, "expand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_expand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "expand");
}

Glib::PropertyProxy< double > Widget::property_opacity() 
{
  return Glib::PropertyProxy< double >(this, "opacity");
}

Glib::PropertyProxy_ReadOnly< double > Widget::property_opacity() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "opacity");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Overflow>::value,
  "Type Overflow cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Overflow > Widget::property_overflow() 
{
  return Glib::PropertyProxy< Overflow >(this, "overflow");
}

Glib::PropertyProxy_ReadOnly< Overflow > Widget::property_overflow() const
{
  return Glib::PropertyProxy_ReadOnly< Overflow >(this, "overflow");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_scale_factor() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "scale-factor");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_css_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "css-name");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<LayoutManager>>::value,
  "Type Glib::RefPtr<LayoutManager> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<LayoutManager> > Widget::property_layout_manager() 
{
  return Glib::PropertyProxy< Glib::RefPtr<LayoutManager> >(this, "layout-manager");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<LayoutManager> > Widget::property_layout_manager() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<LayoutManager> >(this, "layout-manager");
}


void Gtk::Widget::on_show()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->show)
    (*base->show)(gobj());
}
void Gtk::Widget::on_hide()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->hide)
    (*base->hide)(gobj());
}
void Gtk::Widget::on_map()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->map)
    (*base->map)(gobj());
}
void Gtk::Widget::on_unmap()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unmap)
    (*base->unmap)(gobj());
}
void Gtk::Widget::on_realize()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->realize)
    (*base->realize)(gobj());
}
void Gtk::Widget::on_unrealize()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unrealize)
    (*base->unrealize)(gobj());
}
void Gtk::Widget::on_size_allocate(int width, int height, int baseline)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->size_allocate)
    (*base->size_allocate)(gobj(),width,height,baseline);
}
void Gtk::Widget::on_state_flags_changed(Gtk::StateFlags previous_state_flags)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->state_flags_changed)
    (*base->state_flags_changed)(gobj(),static_cast<GtkStateFlags>(previous_state_flags));
}
void Gtk::Widget::on_direction_changed(TextDirection direction)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->direction_changed)
    (*base->direction_changed)(gobj(),static_cast<GtkTextDirection>(direction));
}
void Gtk::Widget::on_grab_notify(bool was_grabbed)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->grab_notify)
    (*base->grab_notify)(gobj(),static_cast<int>(was_grabbed));
}
bool Gtk::Widget::on_mnemonic_activate(bool group_cycling)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->mnemonic_activate)
    return (*base->mnemonic_activate)(gobj(),static_cast<int>(group_cycling));

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_popup_menu()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->popup_menu)
    return (*base->popup_menu)(gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_query_tooltip(int x, int y, bool keyboard_tooltip, const Glib::RefPtr<Tooltip>& tooltip)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->query_tooltip)
    return (*base->query_tooltip)(gobj(),x,y,static_cast<int>(keyboard_tooltip),Glib::unwrap(tooltip));

  using RType = bool;
  return RType();
}

void Gtk::Widget::root_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->root)
  {
    (*base->root)(gobj());
  }
}
void Gtk::Widget::unroot_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unroot)
  {
    (*base->unroot)(gobj());
  }
}
SizeRequestMode Gtk::Widget::get_request_mode_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_request_mode)
  {
    SizeRequestMode retval(static_cast<SizeRequestMode>((*base->get_request_mode)(const_cast<GtkWidget*>(gobj()))));
    return retval;
  }

  using RType = SizeRequestMode;
  return RType();
}
void Gtk::Widget::measure_vfunc(Orientation orientation, int for_size, int& minimum, int& natural, int& minimum_baseline, int& natural_baseline) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->measure)
  {
    (*base->measure)(const_cast<GtkWidget*>(gobj()),static_cast<GtkOrientation>(orientation),for_size,&(minimum),&(natural),&(minimum_baseline),&(natural_baseline));
  }
}
bool Gtk::Widget::grab_focus_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->grab_focus)
  {
    bool retval((*base->grab_focus)(gobj()));
    return retval;
  }

  using RType = bool;
  return RType();
}
#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<Atk::Object> Gtk::Widget::get_accessible_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_accessible)
  {
    Glib::RefPtr<Atk::Object> retval(Glib::wrap((*base->get_accessible)(gobj()), true));
    return retval;
  }

  using RType = Glib::RefPtr<Atk::Object>;
  return RType();
}
#endif // GTKMM_ATKMM_ENABLED
bool Gtk::Widget::contains_vfunc(double x, double y) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->contains)
  {
    bool retval((*base->contains)(const_cast<GtkWidget*>(gobj()),x,y));
    return retval;
  }

  using RType = bool;
  return RType();
}
void Gtk::Widget::snapshot_vfunc(const Glib::RefPtr<Gtk::Snapshot>& snapshot) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->snapshot)
  {
    (*base->snapshot)(gobj(),Glib::unwrap(snapshot));
  }
}


} // namespace Gtk


