/* rygel-item-updater.c generated by valac 0.48.5, the Vala compiler
 * generated from rygel-item-updater.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Krzesimir Nowak <krnowak@openismus.com>
 *         Doug Galligan <doug@sentosatech.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_TYPE_ITEM_UPDATER (rygel_item_updater_get_type ())
#define RYGEL_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater))
#define RYGEL_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))
#define RYGEL_IS_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_IS_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_ITEM_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))

typedef struct _RygelItemUpdater RygelItemUpdater;
typedef struct _RygelItemUpdaterClass RygelItemUpdaterClass;
typedef struct _RygelItemUpdaterPrivate RygelItemUpdaterPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
enum  {
	RYGEL_ITEM_UPDATER_0_PROPERTY,
	RYGEL_ITEM_UPDATER_CANCELLABLE_PROPERTY,
	RYGEL_ITEM_UPDATER_NUM_PROPERTIES
};
static GParamSpec* rygel_item_updater_properties[RYGEL_ITEM_UPDATER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemUpdaterRunData RygelItemUpdaterRunData;
typedef struct _RygelItemUpdaterUpdateObjectData RygelItemUpdaterUpdateObjectData;
typedef struct _RygelItemUpdaterFetchObjectData RygelItemUpdaterFetchObjectData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelItemUpdater {
	GObject parent_instance;
	RygelItemUpdaterPrivate * priv;
};

struct _RygelItemUpdaterClass {
	GObjectClass parent_class;
};

struct _RygelItemUpdaterPrivate {
	gchar* object_id;
	gchar* current_tag_value;
	gchar* new_tag_value;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemUpdaterRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelItemUpdater* self;
	GUPnPServiceAction* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	const gchar* _tmp7_;
	GError* _error_;
	GError* _tmp8_;
	GUPnPServiceAction* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _RygelItemUpdaterUpdateObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelItemUpdater* self;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp0_;
	GeeLinkedList* current_list;
	const gchar* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* new_list;
	const gchar* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeLinkedList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeLinkedList* _tmp11_;
	gint _tmp12_;
	gpointer* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GeeLinkedList* _tmp15_;
	gint _tmp16_;
	gpointer* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelMediaObject* _tmp19_;
	GeeLinkedList* _tmp20_;
	GeeLinkedList* _tmp21_;
	RygelContentDirectory* _tmp22_;
	RygelHTTPServer* _tmp23_;
	GUPnPDIDLLiteFragmentResult _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	GError* _tmp27_;
	GError* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	GError* _inner_error0_;
};

struct _RygelItemUpdaterFetchObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelItemUpdater* self;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* _tmp6_;
	GError* _tmp7_;
	RygelMediaObject* _tmp8_;
	GUPnPOCMFlags _tmp9_;
	GUPnPOCMFlags _tmp10_;
	gchar* msg;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelMediaObject* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	RygelMediaObject* _tmp17_;
	RygelMediaContainer* _tmp18_;
	RygelMediaContainer* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gchar* _vala1_msg;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	RygelMediaObject* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	RygelMediaObject* _tmp27_;
	RygelMediaContainer* _tmp28_;
	RygelMediaContainer* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GError* _tmp32_;
	GError* _inner_error0_;
};

static gint RygelItemUpdater_private_offset;
static gpointer rygel_item_updater_parent_class = NULL;
static GRegex* rygel_item_updater_escape_regex;
static GRegex* rygel_item_updater_escape_regex = NULL;
static RygelStateMachineIface * rygel_item_updater_rygel_state_machine_parent_iface = NULL;

GType rygel_item_updater_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelItemUpdater, g_object_unref)
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelContentDirectory, g_object_unref)
#define RYGEL_ITEM_UPDATER_QN_UPNP_DATE "dc:date"
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir,
                                          GUPnPServiceAction* action);
RygelItemUpdater* rygel_item_updater_construct (GType object_type,
                                                RygelContentDirectory* content_dir,
                                                GUPnPServiceAction* action);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPServer, g_object_unref)
GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
GType rygel_media_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaContainer, g_object_unref)
static void rygel_item_updater_real_run_data_free (gpointer _data);
static void rygel_item_updater_real_run (RygelStateMachine* base,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static gboolean rygel_item_updater_real_run_co (RygelItemUpdaterRunData* _data_);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_updater_update_object (RygelItemUpdater* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void rygel_item_updater_update_object_finish (RygelItemUpdater* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static void rygel_item_updater_run_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static gchar* rygel_item_updater_unescape (const gchar* value);
static gchar* rygel_item_updater_format_tag_values (const gchar* tag_values);
static void rygel_item_updater_check_date_tag (gchar** current_tag,
                                        gint current_tag_length1,
                                        gchar** new_tag,
                                        gint new_tag_length1,
                                        GError** error);
static void rygel_item_updater_check_date (const gchar* date_value,
                                    GError** error);
static GeeLinkedList* rygel_item_updater_csv_split (const gchar* tag_values);
static void rygel_item_updater_update_object_data_free (gpointer _data);
static gboolean rygel_item_updater_update_object_co (RygelItemUpdaterUpdateObjectData* _data_);
static void rygel_item_updater_fetch_object (RygelItemUpdater* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static RygelMediaObject* rygel_item_updater_fetch_object_finish (RygelItemUpdater* self,
                                                          GAsyncResult* _res_,
                                                          GError** error);
static void rygel_item_updater_update_object_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
void rygel_media_object_apply_fragments (RygelMediaObject* self,
                                         GeeLinkedList* current_fragments,
                                         GeeLinkedList* new_fragments,
                                         RygelHTTPServer* http_server,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self,
                                                                       GAsyncResult* _res_);
static void rygel_item_updater_fetch_object_data_free (gpointer _data);
static gboolean rygel_item_updater_fetch_object_co (RygelItemUpdaterFetchObjectData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self,
                                        const gchar* id,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static void rygel_item_updater_fetch_object_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_item_updater_finalize (GObject * obj);
static GType rygel_item_updater_get_type_once (void);
static void _vala_rygel_item_updater_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_rygel_item_updater_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
rygel_item_updater_get_instance_private (RygelItemUpdater* self)
{
	return G_STRUCT_MEMBER_P (self, RygelItemUpdater_private_offset);
}

static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelItemUpdater*
rygel_item_updater_construct (GType object_type,
                              RygelContentDirectory* content_dir,
                              GUPnPServiceAction* action)
{
	RygelItemUpdater * self = NULL;
	RygelContentDirectory* _tmp0_;
	GCancellable* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelItemUpdater*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (content_dir);
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp0_;
	_tmp1_ = content_dir->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_tmp2_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = _tmp2_;
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}

RygelItemUpdater*
rygel_item_updater_new (RygelContentDirectory* content_dir,
                        GUPnPServiceAction* action)
{
	return rygel_item_updater_construct (RYGEL_TYPE_ITEM_UPDATER, content_dir, action);
}

static void
rygel_item_updater_real_run_data_free (gpointer _data)
{
	RygelItemUpdaterRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterRunData, _data_);
}

static void
rygel_item_updater_real_run (RygelStateMachine* base,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	RygelItemUpdater * self;
	RygelItemUpdaterRunData* _data_;
	RygelItemUpdater* _tmp0_;
	self = (RygelItemUpdater*) base;
	_data_ = g_slice_new0 (RygelItemUpdaterRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_item_updater_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_real_run_co (_data_);
}

static void
rygel_item_updater_run_finish (RygelStateMachine* base,
                               GAsyncResult* _res_)
{
	RygelItemUpdaterRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_item_updater_run_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	RygelItemUpdaterRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_real_run_co (_data_);
}

static gboolean
rygel_item_updater_real_run_co (RygelItemUpdaterRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->action;
		_data_->_tmp1_ = NULL;
		_data_->_tmp2_ = NULL;
		_data_->_tmp3_ = NULL;
		gupnp_service_action_get (_data_->_tmp0_, "ObjectID", G_TYPE_STRING, &_data_->_tmp1_, "CurrentTagValue", G_TYPE_STRING, &_data_->_tmp2_, "NewTagValue", G_TYPE_STRING, &_data_->_tmp3_, NULL);
		_g_free0 (_data_->self->priv->object_id);
		_data_->self->priv->object_id = _data_->_tmp1_;
		_g_free0 (_data_->self->priv->current_tag_value);
		_data_->self->priv->current_tag_value = _data_->_tmp2_;
		_g_free0 (_data_->self->priv->new_tag_value);
		_data_->self->priv->new_tag_value = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->self->priv->object_id;
		if (_data_->_tmp4_ == NULL) {
			_data_->_tmp5_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("Object ID missing"));
			_data_->_inner_error0_ = _data_->_tmp5_;
			goto __catch0_g_error;
		}
		_data_->_state_ = 1;
		rygel_item_updater_update_object (_data_->self, rygel_item_updater_run_ready, _data_);
		return FALSE;
		_state_1:
		rygel_item_updater_update_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->self->priv->action;
		gupnp_service_action_return (_data_->_tmp6_);
		_data_->_tmp7_ = _data_->self->priv->object_id;
		g_debug (_ ("Successfully updated object “%s”"), _data_->_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->_error_;
		if (_data_->_tmp8_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			_data_->_tmp9_ = _data_->self->priv->action;
			_data_->_tmp10_ = _data_->_error_;
			_data_->_tmp11_ = _data_->_error_;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			gupnp_service_action_return_error (_data_->_tmp9_, (guint) _data_->_tmp10_->code, _data_->_tmp12_);
		} else {
			_data_->_tmp13_ = _data_->self->priv->action;
			_data_->_tmp14_ = _data_->_error_;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			gupnp_service_action_return_error (_data_->_tmp13_, (guint) 701, _data_->_tmp15_);
		}
		_data_->_tmp16_ = _data_->self->priv->object_id;
		_data_->_tmp17_ = _data_->_error_;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		g_warning (_ ("Failed to update object “%s”: %s"), _data_->_tmp16_, _data_->_tmp18_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
rygel_item_updater_unescape (const gchar* value)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = rygel_item_updater_escape_regex;
		_tmp2_ = g_regex_replace (_tmp1_, value, (gssize) -1, 0, "\\1", 0, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		gchar* _tmp4_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = g_strdup (value);
		result = _tmp4_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
rygel_item_updater_format_tag_values (const gchar* tag_values)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp31_;
	gchar* result = NULL;
	g_return_val_if_fail (tag_values != NULL, NULL);
	_tmp1_ = strlen (tag_values);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		_tmp0_ = string_get_char (tag_values, (glong) 0) == ((gunichar) '<');
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** init_split = NULL;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint init_split_length1;
		gint _init_split_size_;
		gchar* tag_name = NULL;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* tag_value = NULL;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar** _tmp18_;
		gchar** _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp4_ = _tmp3_ = g_strsplit (tag_values, "</", 0);
		init_split = _tmp4_;
		init_split_length1 = _vala_array_length (_tmp3_);
		_init_split_size_ = init_split_length1;
		_tmp5_ = init_split;
		_tmp5__length1 = init_split_length1;
		_tmp6_ = _tmp5_[1];
		_tmp7_ = init_split;
		_tmp7__length1 = init_split_length1;
		_tmp8_ = _tmp7_[1];
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = string_substring (_tmp6_, (glong) 0, (glong) (_tmp10_ - 1));
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strstrip (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp12_);
		tag_name = _tmp15_;
		_tmp16_ = init_split;
		_tmp16__length1 = init_split_length1;
		_tmp17_ = _tmp16_[0];
		_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, ">", 0);
		_tmp20_ = _tmp19_;
		_tmp20__length1 = _vala_array_length (_tmp18_);
		_tmp21_ = _tmp20_[1];
		_tmp22_ = g_strstrip (_tmp21_);
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
		tag_value = _tmp24_;
		_tmp25_ = tag_name;
		g_debug ("rygel-item-updater.vala:113: Tag Name formatted :%s", _tmp25_);
		_tmp26_ = tag_value;
		g_debug ("rygel-item-updater.vala:114: Tag Value formatted :%s", _tmp26_);
		_tmp27_ = tag_name;
		_tmp28_ = tag_value;
		_tmp29_ = tag_name;
		_tmp30_ = g_strdup_printf ("<%s>%s</%s>", _tmp27_, _tmp28_, _tmp29_);
		result = _tmp30_;
		_g_free0 (tag_value);
		_g_free0 (tag_name);
		init_split = (_vala_array_free (init_split, init_split_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp31_ = g_strdup (tag_values);
	result = _tmp31_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
rygel_item_updater_check_date_tag (gchar** current_tag,
                                   gint current_tag_length1,
                                   gchar** new_tag,
                                   gint new_tag_length1,
                                   GError** error)
{
	gint date_index = 0;
	GError* _inner_error0_ = NULL;
	date_index = -1;
	{
		gchar** cur_str_collection = NULL;
		gint cur_str_collection_length1 = 0;
		gint _cur_str_collection_size_ = 0;
		gint cur_str_it = 0;
		cur_str_collection = current_tag;
		cur_str_collection_length1 = current_tag_length1;
		for (cur_str_it = 0; cur_str_it < cur_str_collection_length1; cur_str_it = cur_str_it + 1) {
			const gchar* cur_str = NULL;
			cur_str = cur_str_collection[cur_str_it];
			{
				gint _tmp0_;
				const gchar* _tmp1_;
				_tmp0_ = date_index;
				date_index = _tmp0_ + 1;
				_tmp1_ = cur_str;
				if (string_index_of (_tmp1_, RYGEL_ITEM_UPDATER_QN_UPNP_DATE, 0) != -1) {
					gchar* date_val = NULL;
					const gchar* _tmp2_;
					gchar** _tmp3_;
					gchar** _tmp4_;
					gchar** _tmp5_;
					gint _tmp5__length1;
					const gchar* _tmp6_;
					gchar** _tmp7_;
					gchar** _tmp8_;
					gchar** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp2_ = new_tag[date_index];
					_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "</", 0);
					_tmp5_ = _tmp4_;
					_tmp5__length1 = _vala_array_length (_tmp3_);
					_tmp6_ = _tmp5_[0];
					_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ">", 0);
					_tmp9_ = _tmp8_;
					_tmp9__length1 = _vala_array_length (_tmp7_);
					_tmp10_ = _tmp9_[1];
					_tmp11_ = g_strstrip (_tmp10_);
					_tmp12_ = g_strdup (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
					_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
					date_val = _tmp13_;
					_tmp14_ = date_val;
					rygel_item_updater_check_date (_tmp14_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (date_val);
						return;
					}
					_g_free0 (date_val);
					break;
				}
			}
		}
	}
	date_index = -1;
	{
		gchar** new_str_collection = NULL;
		gint new_str_collection_length1 = 0;
		gint _new_str_collection_size_ = 0;
		gint new_str_it = 0;
		new_str_collection = new_tag;
		new_str_collection_length1 = new_tag_length1;
		for (new_str_it = 0; new_str_it < new_str_collection_length1; new_str_it = new_str_it + 1) {
			const gchar* new_str = NULL;
			new_str = new_str_collection[new_str_it];
			{
				gint _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = date_index;
				date_index = _tmp15_ + 1;
				_tmp16_ = new_str;
				if (string_index_of (_tmp16_, RYGEL_ITEM_UPDATER_QN_UPNP_DATE, 0) != -1) {
					gchar* date_val = NULL;
					const gchar* _tmp17_;
					gchar** _tmp18_;
					gchar** _tmp19_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					gchar** _tmp22_;
					gchar** _tmp23_;
					gchar** _tmp24_;
					gint _tmp24__length1;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp17_ = new_tag[date_index];
					_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "</", 0);
					_tmp20_ = _tmp19_;
					_tmp20__length1 = _vala_array_length (_tmp18_);
					_tmp21_ = _tmp20_[0];
					_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, ">", 0);
					_tmp24_ = _tmp23_;
					_tmp24__length1 = _vala_array_length (_tmp22_);
					_tmp25_ = _tmp24_[1];
					_tmp26_ = g_strstrip (_tmp25_);
					_tmp27_ = g_strdup (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
					_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
					date_val = _tmp28_;
					_tmp29_ = date_val;
					rygel_item_updater_check_date (_tmp29_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (date_val);
						return;
					}
					_g_free0 (date_val);
					break;
				}
			}
		}
	}
}

static void
rygel_item_updater_check_date (const gchar* date_value,
                               GError** error)
{
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_;
	GDate date = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (date_value != NULL);
	year = 0;
	month = 0;
	day = 0;
	_tmp3_ = sscanf (date_value, "%4d-%02d-%02d", &_tmp0_, &_tmp1_, &_tmp2_);
	year = _tmp0_;
	month = _tmp1_;
	day = _tmp2_;
	if (_tmp3_ != 3) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE, _ ("Invalid date format: %s"), date_value);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	memset (&date, 0, sizeof (GDate));
	g_date_set_dmy (&date, (GDateDay) day, (gint) ((GDateMonth) month), (GDateYear) year);
	if (!g_date_valid (&date)) {
		GError* _tmp5_;
		_tmp5_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE, _ ("Invalid date: %s"), date_value);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static GeeLinkedList*
rygel_item_updater_csv_split (const gchar* tag_values)
{
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_;
	gboolean escape = FALSE;
	gint token_start = 0;
	gint token_length = 0;
	gint len = 0;
	gint _tmp1_;
	gint _tmp2_;
	gchar* stripped_values = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GeeLinkedList* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GeeLinkedList* result = NULL;
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	if (tag_values == NULL) {
		result = list;
		return result;
	}
	escape = FALSE;
	token_start = 0;
	token_length = 0;
	_tmp1_ = strlen (tag_values);
	_tmp2_ = _tmp1_;
	len = _tmp2_;
	{
		gint iter = 0;
		iter = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar c = '\0';
				gboolean increase = FALSE;
				if (!_tmp3_) {
					iter = iter + 1;
				}
				_tmp3_ = FALSE;
				if (!(iter < len)) {
					break;
				}
				c = string_get (tag_values, (glong) iter);
				increase = TRUE;
				if (escape) {
					escape = FALSE;
				} else {
					switch (c) {
						case '\\':
						{
							escape = TRUE;
							break;
						}
						case ',':
						{
							gchar* value = NULL;
							gchar* _tmp4_;
							gboolean _tmp5_ = FALSE;
							const gchar* _tmp6_;
							gint _tmp7_;
							gint _tmp8_;
							GeeLinkedList* _tmp14_;
							const gchar* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							_tmp4_ = string_substring (tag_values, (glong) token_start, (glong) token_length);
							value = _tmp4_;
							_tmp6_ = value;
							_tmp7_ = strlen (_tmp6_);
							_tmp8_ = _tmp7_;
							if (_tmp8_ > 0) {
								const gchar* _tmp9_;
								_tmp9_ = value;
								_tmp5_ = string_get (_tmp9_, (glong) 0) == '<';
							} else {
								_tmp5_ = FALSE;
							}
							if (_tmp5_) {
								const gchar* _tmp10_;
								const gchar* _tmp11_;
								gint _tmp12_;
								gint _tmp13_;
								_tmp10_ = value;
								_tmp11_ = value;
								_tmp12_ = strlen (_tmp11_);
								_tmp13_ = _tmp12_;
								if (!(string_get (_tmp10_, (glong) (_tmp13_ - 1)) == '>')) {
									_g_free0 (value);
									break;
								}
							}
							_tmp14_ = list;
							_tmp15_ = value;
							_tmp16_ = rygel_item_updater_unescape (_tmp15_);
							_tmp17_ = _tmp16_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
							_g_free0 (_tmp17_);
							token_start += token_length + 1;
							token_length = 0;
							increase = FALSE;
							_g_free0 (value);
							break;
						}
						default:
						break;
					}
				}
				if (increase) {
					token_length = token_length + 1;
				}
			}
		}
	}
	_tmp18_ = string_substring (tag_values, (glong) token_start, (glong) -1);
	_tmp19_ = _tmp18_;
	_tmp20_ = string_strip (_tmp19_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	stripped_values = _tmp21_;
	_tmp22_ = list;
	_tmp23_ = stripped_values;
	_tmp24_ = rygel_item_updater_unescape (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = rygel_item_updater_format_tag_values (_tmp25_);
	_tmp27_ = _tmp26_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp27_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	result = list;
	_g_free0 (stripped_values);
	return result;
}

static void
rygel_item_updater_update_object_data_free (gpointer _data)
{
	RygelItemUpdaterUpdateObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterUpdateObjectData, _data_);
}

static void
rygel_item_updater_update_object (RygelItemUpdater* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	RygelItemUpdaterUpdateObjectData* _data_;
	RygelItemUpdater* _tmp0_;
	_data_ = g_slice_new0 (RygelItemUpdaterUpdateObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_item_updater_update_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_update_object_co (_data_);
}

static void
rygel_item_updater_update_object_finish (RygelItemUpdater* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	RygelItemUpdaterUpdateObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_item_updater_update_object_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	RygelItemUpdaterUpdateObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_update_object_co (_data_);
}

static gboolean
rygel_item_updater_update_object_co (RygelItemUpdaterUpdateObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_item_updater_fetch_object (_data_->self, rygel_item_updater_update_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = rygel_item_updater_fetch_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->media_object = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->current_tag_value;
	_data_->_tmp2_ = rygel_item_updater_csv_split (_data_->_tmp1_);
	_data_->current_list = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->new_tag_value;
	_data_->_tmp4_ = rygel_item_updater_csv_split (_data_->_tmp3_);
	_data_->new_list = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->current_list;
	_data_->_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->new_list;
	_data_->_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	if (_data_->_tmp7_ == _data_->_tmp10_) {
		_data_->_tmp11_ = _data_->current_list;
		_data_->_tmp12_ = 0;
		_data_->_tmp13_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp11_, &_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp14__length1 = _data_->_tmp12_;
		_data_->_tmp15_ = _data_->new_list;
		_data_->_tmp16_ = 0;
		_data_->_tmp17_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp15_, &_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp18__length1 = _data_->_tmp16_;
		rygel_item_updater_check_date_tag (_data_->_tmp14_, (gint) _data_->_tmp12_, _data_->_tmp18_, (gint) _data_->_tmp16_, &_data_->_inner_error0_);
		_data_->_tmp18_ = (_vala_array_free (_data_->_tmp18_, _data_->_tmp18__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp14_ = (_vala_array_free (_data_->_tmp14_, _data_->_tmp14__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp19_ = _data_->media_object;
	_data_->_tmp20_ = _data_->current_list;
	_data_->_tmp21_ = _data_->new_list;
	_data_->_tmp22_ = _data_->self->priv->content_dir;
	_data_->_tmp23_ = _data_->_tmp22_->http_server;
	_data_->_state_ = 2;
	rygel_media_object_apply_fragments (_data_->_tmp19_, _data_->_tmp20_, _data_->_tmp21_, _data_->_tmp23_, rygel_item_updater_update_object_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_result_ = rygel_media_object_apply_fragments_finish (_data_->_tmp19_, _data_->_res_);
	_data_->_tmp24_ = _data_->_result_;
	switch (_data_->_tmp24_) {
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK:
		{
			break;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_CURRENT_BAD_XML:
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_CURRENT_INVALID:
		{
			_data_->_tmp25_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE, _ ("Bad current tag value."));
			_data_->_inner_error0_ = _data_->_tmp25_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_NEW_BAD_XML:
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_NEW_INVALID:
		{
			_data_->_tmp26_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE, _ ("Bad new tag value."));
			_data_->_inner_error0_ = _data_->_tmp26_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_REQUIRED_TAG:
		{
			_data_->_tmp27_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG, _ ("Tried to delete required tag."));
			_data_->_inner_error0_ = _data_->_tmp27_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_READONLY_TAG:
		{
			_data_->_tmp28_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG, _ ("Tried to change read-only property."));
			_data_->_inner_error0_ = _data_->_tmp28_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_MISMATCH:
		{
			_data_->_tmp29_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH, _ ("Parameter count mismatch."));
			_data_->_inner_error0_ = _data_->_tmp29_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		default:
		{
			_data_->_tmp30_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("Unknown error."));
			_data_->_inner_error0_ = _data_->_tmp30_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->new_list);
	_g_object_unref0 (_data_->current_list);
	_g_object_unref0 (_data_->media_object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_item_updater_fetch_object_data_free (gpointer _data)
{
	RygelItemUpdaterFetchObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterFetchObjectData, _data_);
}

static void
rygel_item_updater_fetch_object (RygelItemUpdater* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelItemUpdaterFetchObjectData* _data_;
	RygelItemUpdater* _tmp0_;
	_data_ = g_slice_new0 (RygelItemUpdaterFetchObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_item_updater_fetch_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_fetch_object_co (_data_);
}

static RygelMediaObject*
rygel_item_updater_fetch_object_finish (RygelItemUpdater* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	RygelMediaObject* result;
	RygelItemUpdaterFetchObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_item_updater_fetch_object_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	RygelItemUpdaterFetchObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_fetch_object_co (_data_);
}

static gboolean
rygel_item_updater_fetch_object_co (RygelItemUpdaterFetchObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->content_dir;
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
	_data_->_tmp2_ = _data_->self->priv->object_id;
	_data_->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	rygel_media_container_find_object (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp4_, rygel_item_updater_fetch_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = rygel_media_container_find_object_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	_data_->media_object = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->media_object;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("No such object"));
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp8_ = _data_->media_object;
		_data_->_tmp9_ = rygel_media_object_get_ocm_flags (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		if (!((_data_->_tmp10_ & GUPNP_OCM_FLAGS_CHANGE_METADATA) == GUPNP_OCM_FLAGS_CHANGE_METADATA)) {
			_data_->_tmp11_ = g_strdup (_ ("Metadata modification of object %s not allowed"));
			_data_->msg = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->msg;
			_data_->_tmp13_ = _data_->media_object;
			_data_->_tmp14_ = rygel_media_object_get_id (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT, _data_->_tmp12_, _data_->_tmp15_);
			_data_->_inner_error0_ = _data_->_tmp16_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->msg);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp17_ = _data_->media_object;
			_data_->_tmp18_ = rygel_media_object_get_parent (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_tmp20_ = rygel_media_object_get_restricted ((RygelMediaObject*) _data_->_tmp19_);
			_data_->_tmp21_ = _data_->_tmp20_;
			if (_data_->_tmp21_) {
				_data_->_tmp22_ = g_strdup (_ ("Metadata modification of object %s being a child of restricted object " \
"%s not allowed"));
				_data_->_vala1_msg = _data_->_tmp22_;
				_data_->_tmp23_ = _data_->_vala1_msg;
				_data_->_tmp24_ = _data_->media_object;
				_data_->_tmp25_ = rygel_media_object_get_id (_data_->_tmp24_);
				_data_->_tmp26_ = _data_->_tmp25_;
				_data_->_tmp27_ = _data_->media_object;
				_data_->_tmp28_ = rygel_media_object_get_parent (_data_->_tmp27_);
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_tmp30_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp29_);
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp23_, _data_->_tmp26_, _data_->_tmp31_);
				_data_->_inner_error0_ = _data_->_tmp32_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->_vala1_msg);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->result = _data_->media_object;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GCancellable*
rygel_item_updater_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelItemUpdater* self;
	GCancellable* _tmp0_;
	self = (RygelItemUpdater*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_item_updater_real_set_cancellable (RygelStateMachine* base,
                                         GCancellable* value)
{
	RygelItemUpdater* self;
	self = (RygelItemUpdater*) base;
	if (rygel_item_updater_real_get_cancellable (base) != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_item_updater_properties[RYGEL_ITEM_UPDATER_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_item_updater_class_init (RygelItemUpdaterClass * klass,
                               gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	rygel_item_updater_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelItemUpdater_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_updater_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_updater_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_updater_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_UPDATER_CANCELLABLE_PROPERTY, rygel_item_updater_properties[RYGEL_ITEM_UPDATER_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("\\\\(.)", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (rygel_item_updater_escape_regex);
		rygel_item_updater_escape_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
rygel_item_updater_rygel_state_machine_interface_init (RygelStateMachineIface * iface,
                                                       gpointer iface_data)
{
	rygel_item_updater_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_item_updater_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_item_updater_run_finish;
	iface->get_cancellable = rygel_item_updater_real_get_cancellable;
	iface->set_cancellable = rygel_item_updater_real_set_cancellable;
}

static void
rygel_item_updater_instance_init (RygelItemUpdater * self,
                                  gpointer klass)
{
	self->priv = rygel_item_updater_get_instance_private (self);
}

static void
rygel_item_updater_finalize (GObject * obj)
{
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	_g_free0 (self->priv->object_id);
	_g_free0 (self->priv->current_tag_value);
	_g_free0 (self->priv->new_tag_value);
	_g_object_unref0 (self->priv->content_dir);
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_updater_parent_class)->finalize (obj);
}

/**
 * UpdateObject action implementation.
 */
static GType
rygel_item_updater_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelItemUpdaterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_updater_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemUpdater), 0, (GInstanceInitFunc) rygel_item_updater_instance_init, NULL };
	static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_updater_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_item_updater_type_id;
	rygel_item_updater_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemUpdater", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_item_updater_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	RygelItemUpdater_private_offset = g_type_add_instance_private (rygel_item_updater_type_id, sizeof (RygelItemUpdaterPrivate));
	return rygel_item_updater_type_id;
}

GType
rygel_item_updater_get_type (void)
{
	static volatile gsize rygel_item_updater_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_updater_type_id__volatile)) {
		GType rygel_item_updater_type_id;
		rygel_item_updater_type_id = rygel_item_updater_get_type_once ();
		g_once_init_leave (&rygel_item_updater_type_id__volatile, rygel_item_updater_type_id);
	}
	return rygel_item_updater_type_id__volatile;
}

static void
_vala_rygel_item_updater_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	switch (property_id) {
		case RYGEL_ITEM_UPDATER_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_item_updater_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	switch (property_id) {
		case RYGEL_ITEM_UPDATER_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

