/* rygel-recursive-module-loader.c generated by valac 0.44.9, the Vala compiler
 * generated from rygel-recursive-module-loader.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>
#include <glib/gi18n-lib.h>

#define RYGEL_TYPE_RECURSIVE_MODULE_LOADER (rygel_recursive_module_loader_get_type ())
#define RYGEL_RECURSIVE_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader))
#define RYGEL_RECURSIVE_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoaderClass))
#define RYGEL_IS_RECURSIVE_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER))
#define RYGEL_IS_RECURSIVE_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RECURSIVE_MODULE_LOADER))
#define RYGEL_RECURSIVE_MODULE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoaderClass))

typedef struct _RygelRecursiveModuleLoader RygelRecursiveModuleLoader;
typedef struct _RygelRecursiveModuleLoaderClass RygelRecursiveModuleLoaderClass;
typedef struct _RygelRecursiveModuleLoaderPrivate RygelRecursiveModuleLoaderPrivate;

#define RYGEL_TYPE_PLUGIN_INFORMATION (rygel_plugin_information_get_type ())
#define RYGEL_PLUGIN_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation))
#define RYGEL_PLUGIN_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformationClass))
#define RYGEL_IS_PLUGIN_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_INFORMATION))
#define RYGEL_IS_PLUGIN_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_INFORMATION))
#define RYGEL_PLUGIN_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformationClass))

typedef struct _RygelPluginInformation RygelPluginInformation;
typedef struct _RygelPluginInformationClass RygelPluginInformationClass;
enum  {
	RYGEL_RECURSIVE_MODULE_LOADER_0_PROPERTY,
	RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH_PROPERTY,
	RYGEL_RECURSIVE_MODULE_LOADER_NUM_PROPERTIES
};
static GParamSpec* rygel_recursive_module_loader_properties[RYGEL_RECURSIVE_MODULE_LOADER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef void (*RygelRecursiveModuleLoaderFolderHandler) (GFile* folder, gpointer user_data);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelRecursiveModuleLoaderLoadModulesFromFolderData RygelRecursiveModuleLoaderLoadModulesFromFolderData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelRecursiveModuleLoader {
	GObject parent_instance;
	RygelRecursiveModuleLoaderPrivate * priv;
};

struct _RygelRecursiveModuleLoaderClass {
	GObjectClass parent_class;
	gboolean (*load_module_from_file) (RygelRecursiveModuleLoader* self, GFile* file);
	gboolean (*load_module_from_info) (RygelRecursiveModuleLoader* self, RygelPluginInformation* info);
};

struct _RygelRecursiveModuleLoaderPrivate {
	gboolean done;
	gchar* _base_path;
};

struct _Block2Data {
	int _ref_count_;
	RygelRecursiveModuleLoader* self;
	GQueue* queue;
};

struct _RygelRecursiveModuleLoaderLoadModulesFromFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelRecursiveModuleLoader* self;
	GFile* folder;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GList* infos;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp2_;
	GFileEnumerator* _tmp3_;
	GFileEnumerator* _tmp4_;
	GList* _tmp5_;
	GFileEnumerator* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	GError* _error_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GList* _tmp13_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp14_;
	GFileInfo* info;
	GFileInfo* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _inner_error0_;
};

static gint RygelRecursiveModuleLoader_private_offset;
static gpointer rygel_recursive_module_loader_parent_class = NULL;

GType rygel_recursive_module_loader_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelRecursiveModuleLoader, g_object_unref)
GType rygel_plugin_information_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPluginInformation, g_object_unref)
#define RYGEL_RECURSIVE_MODULE_LOADER_LOADER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE
RygelRecursiveModuleLoader* rygel_recursive_module_loader_construct (GType object_type,
                                                                     const gchar* path);
static void rygel_recursive_module_loader_real_constructed (GObject* base);
void rygel_recursive_module_loader_load_modules (RygelRecursiveModuleLoader* self);
const gchar* rygel_recursive_module_loader_get_base_path (RygelRecursiveModuleLoader* self);
static gboolean rygel_recursive_module_loader_is_folder (RygelRecursiveModuleLoader* self,
                                                  GFile* file);
static void rygel_recursive_module_loader_load_modules_from_folder (RygelRecursiveModuleLoader* self,
                                                             GFile* folder,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void rygel_recursive_module_loader_load_modules_from_folder_finish (RygelRecursiveModuleLoader* self,
                                                                    GAsyncResult* _res_);
void rygel_recursive_module_loader_load_modules_sync (RygelRecursiveModuleLoader* self,
                                                      GCancellable* cancellable);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
static void block2_data_unref (void * _userdata_);
static void rygel_recursive_module_loader_handle_file_info (RygelRecursiveModuleLoader* self,
                                                     GFile* folder,
                                                     GFileInfo* info,
                                                     RygelRecursiveModuleLoaderFolderHandler handler,
                                                     gpointer handler_target);
static void _____lambda7_ (Block2Data* _data2_,
                    GFile* subfolder);
static void ______lambda7__rygel_recursive_module_loader_folder_handler (GFile* folder,
                                                                  gpointer self);
gboolean rygel_recursive_module_loader_load_module_from_file (RygelRecursiveModuleLoader* self,
                                                              GFile* file);
static gboolean rygel_recursive_module_loader_real_load_module_from_file (RygelRecursiveModuleLoader* self,
                                                                   GFile* file);
gboolean rygel_recursive_module_loader_load_module_from_info (RygelRecursiveModuleLoader* self,
                                                              RygelPluginInformation* info);
static gboolean rygel_recursive_module_loader_real_load_module_from_info (RygelRecursiveModuleLoader* self,
                                                                   RygelPluginInformation* info);
static void rygel_recursive_module_loader_load_modules_from_folder_data_free (gpointer _data);
static gboolean rygel_recursive_module_loader_load_modules_from_folder_co (RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_);
static void rygel_recursive_module_loader_load_modules_from_folder_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda6_ (RygelRecursiveModuleLoader* self,
                   GFile* subfolder);
static void _____lambda6__rygel_recursive_module_loader_folder_handler (GFile* folder,
                                                                 gpointer self);
static gboolean rygel_recursive_module_loader_is_folder_eligible (RygelRecursiveModuleLoader* self,
                                                           GFileInfo* file_info);
RygelPluginInformation* rygel_plugin_information_new_from_file (GFile* file,
                                                                GError** error);
void rygel_recursive_module_loader_set_base_path (RygelRecursiveModuleLoader* self,
                                                  const gchar* value);
static void rygel_recursive_module_loader_finalize (GObject * obj);
static void _vala_rygel_recursive_module_loader_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_rygel_recursive_module_loader_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
rygel_recursive_module_loader_get_instance_private (RygelRecursiveModuleLoader* self)
{
	return G_STRUCT_MEMBER_P (self, RygelRecursiveModuleLoader_private_offset);
}

/**
     * Create a recursive module loader for a given path.
     *
     * Either call load_modules() or load_modules_sync() to start descending
     * into the folder hierarchy and load the modules.
     *
     * @param path base path of the loader.
     */
RygelRecursiveModuleLoader*
rygel_recursive_module_loader_construct (GType object_type,
                                         const gchar* path)
{
	RygelRecursiveModuleLoader * self = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (RygelRecursiveModuleLoader*) g_object_new (object_type, "base-path", path, NULL);
	return self;
}

static void
rygel_recursive_module_loader_real_constructed (GObject* base)
{
	RygelRecursiveModuleLoader * self;
	self = (RygelRecursiveModuleLoader*) base;
	G_OBJECT_CLASS (rygel_recursive_module_loader_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	self->priv->done = FALSE;
}

/**
     * Walk asynchronously through the tree and load modules.
     */
void
rygel_recursive_module_loader_load_modules (RygelRecursiveModuleLoader* self)
{
	GFile* folder = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_;
	GFile* _tmp6_;
	g_return_if_fail (self != NULL);
	_vala_assert (g_module_supported (), "Module.supported()");
	_tmp0_ = self->priv->_base_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	folder = _tmp1_;
	_tmp3_ = folder;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GFile* _tmp4_;
		_tmp4_ = folder;
		_tmp2_ = !rygel_recursive_module_loader_is_folder (self, _tmp4_);
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->_base_path;
		g_warning (_ ("Failed to open plugins folder: “%s”"), _tmp5_);
		_g_object_unref0 (folder);
		return;
	}
	_tmp6_ = folder;
	rygel_recursive_module_loader_load_modules_from_folder (self, _tmp6_, NULL, NULL);
	_g_object_unref0 (folder);
}

/**
     * Walk synchronously through the tree and load modules.
     */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelRecursiveModuleLoader* self;
		self = _data2_->self;
		(_data2_->queue == NULL) ? NULL : (_data2_->queue = (_g_queue_free__g_object_unref0_ (_data2_->queue), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_____lambda7_ (Block2Data* _data2_,
               GFile* subfolder)
{
	RygelRecursiveModuleLoader* self;
	GQueue* _tmp0_;
	GFile* _tmp1_;
	self = _data2_->self;
	g_return_if_fail (subfolder != NULL);
	_tmp0_ = _data2_->queue;
	_tmp1_ = _g_object_ref0 (subfolder);
	g_queue_push_head (_tmp0_, _tmp1_);
}

static void
______lambda7__rygel_recursive_module_loader_folder_handler (GFile* folder,
                                                             gpointer self)
{
	_____lambda7_ (self, folder);
}

void
rygel_recursive_module_loader_load_modules_sync (RygelRecursiveModuleLoader* self,
                                                 GCancellable* cancellable)
{
	Block2Data* _data2_;
	const gchar* _tmp0_;
	GQueue* _tmp1_;
	GQueue* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->_base_path;
	g_debug ("rygel-recursive-module-loader.vala:83: Searching for modules in folder" \
" '%s'", _tmp0_);
	_tmp1_ = g_queue_new ();
	_data2_->queue = _tmp1_;
	_tmp2_ = _data2_->queue;
	_tmp3_ = self->priv->_base_path;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	g_queue_push_head (_tmp2_, _tmp4_);
	while (TRUE) {
		GQueue* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GFile* folder = NULL;
		GQueue* _tmp7_;
		gpointer _tmp8_;
		_tmp5_ = _data2_->queue;
		if (!(!g_queue_is_empty (_tmp5_))) {
			break;
		}
		if (cancellable != NULL) {
			_tmp6_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			break;
		}
		_tmp7_ = _data2_->queue;
		_tmp8_ = g_queue_pop_head (_tmp7_);
		folder = (GFile*) _tmp8_;
		{
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp9_;
			GFileEnumerator* _tmp10_;
			GFileInfo* info = NULL;
			GFileEnumerator* _tmp11_;
			GFileInfo* _tmp12_;
			_tmp9_ = folder;
			_tmp10_ = g_file_enumerate_children (_tmp9_, RYGEL_RECURSIVE_MODULE_LOADER_LOADER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, cancellable, &_inner_error0_);
			enumerator = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch44_g_error;
			}
			_tmp11_ = enumerator;
			_tmp12_ = g_file_enumerator_next_file (_tmp11_, cancellable, &_inner_error0_);
			info = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch44_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp13_;
				GFile* _tmp14_;
				GFileInfo* _tmp15_;
				GFileInfo* _tmp16_ = NULL;
				GFileEnumerator* _tmp17_;
				GFileInfo* _tmp18_;
				GFileInfo* _tmp19_;
				_tmp13_ = info;
				if (!(_tmp13_ != NULL)) {
					break;
				}
				_tmp14_ = folder;
				_tmp15_ = info;
				rygel_recursive_module_loader_handle_file_info (self, _tmp14_, _tmp15_, ______lambda7__rygel_recursive_module_loader_folder_handler, _data2_);
				_tmp17_ = enumerator;
				_tmp18_ = g_file_enumerator_next_file (_tmp17_, cancellable, &_inner_error0_);
				_tmp16_ = _tmp18_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					goto __catch44_g_error;
				}
				_tmp19_ = _tmp16_;
				_tmp16_ = NULL;
				_g_object_unref0 (info);
				info = _tmp19_;
				_g_object_unref0 (_tmp16_);
			}
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
		}
		goto __finally44;
		__catch44_g_error:
		{
			GError* _error_ = NULL;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = folder;
			_tmp21_ = g_file_get_path (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _error_;
			_tmp24_ = _tmp23_->message;
			g_debug ("rygel-recursive-module-loader.vala:107: Failed to enumerate folder %s:" \
" %s", _tmp22_, _tmp24_);
			_g_free0 (_tmp22_);
			_g_error_free0 (_error_);
		}
		__finally44:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (folder);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (folder);
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

/**
     * Load module from file.
     * @param file File to load the module from
     * @return The implementation should return true if the class should
     * continue to search for modules, false otherwise.
     */
static gboolean
rygel_recursive_module_loader_real_load_module_from_file (RygelRecursiveModuleLoader* self,
                                                          GFile* file)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `rygel_recursive_module_loader_load_module_from_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
rygel_recursive_module_loader_load_module_from_file (RygelRecursiveModuleLoader* self,
                                                     GFile* file)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_RECURSIVE_MODULE_LOADER_GET_CLASS (self)->load_module_from_file (self, file);
}

static gboolean
rygel_recursive_module_loader_real_load_module_from_info (RygelRecursiveModuleLoader* self,
                                                          RygelPluginInformation* info)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `rygel_recursive_module_loader_load_module_from_info'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
rygel_recursive_module_loader_load_module_from_info (RygelRecursiveModuleLoader* self,
                                                     RygelPluginInformation* info)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_RECURSIVE_MODULE_LOADER_GET_CLASS (self)->load_module_from_info (self, info);
}

static void
rygel_recursive_module_loader_load_modules_from_folder_data_free (gpointer _data)
{
	RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelRecursiveModuleLoaderLoadModulesFromFolderData, _data_);
}

static void
rygel_recursive_module_loader_load_modules_from_folder (RygelRecursiveModuleLoader* self,
                                                        GFile* folder,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_;
	RygelRecursiveModuleLoader* _tmp0_;
	GFile* _tmp1_;
	_data_ = g_slice_new0 (RygelRecursiveModuleLoaderLoadModulesFromFolderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_recursive_module_loader_load_modules_from_folder_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp1_;
	rygel_recursive_module_loader_load_modules_from_folder_co (_data_);
}

static void
rygel_recursive_module_loader_load_modules_from_folder_finish (RygelRecursiveModuleLoader* self,
                                                               GAsyncResult* _res_)
{
	RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Process children of a folder.
     *
     * Recurse into folders or call load_module_from_file() if it looks
     * like a shared library.
     *
     * @param folder the folder
     */
static void
rygel_recursive_module_loader_load_modules_from_folder_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_recursive_module_loader_load_modules_from_folder_co (_data_);
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
____lambda6_ (RygelRecursiveModuleLoader* self,
              GFile* subfolder)
{
	g_return_if_fail (subfolder != NULL);
	rygel_recursive_module_loader_load_modules_from_folder (self, subfolder, NULL, NULL);
}

static void
_____lambda6__rygel_recursive_module_loader_folder_handler (GFile* folder,
                                                            gpointer self)
{
	____lambda6_ ((RygelRecursiveModuleLoader*) self, folder);
}

static gboolean
rygel_recursive_module_loader_load_modules_from_folder_co (RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_get_path (_data_->folder);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("rygel-recursive-module-loader.vala:133: Searching for modules in folde" \
"r '%s'.", _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	{
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->folder, RYGEL_RECURSIVE_MODULE_LOADER_LOADER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_recursive_module_loader_load_modules_from_folder_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_enumerate_children_finish (_data_->folder, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp2_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch45_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_g_object_unref0 (_data_->enumerator);
		_data_->enumerator = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->enumerator;
		_data_->_state_ = 2;
		g_file_enumerator_next_files_async (_data_->_tmp6_, G_MAXINT, G_PRIORITY_DEFAULT, NULL, rygel_recursive_module_loader_load_modules_from_folder_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp7_ = g_file_enumerator_next_files_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp2_);
			goto __catch45_g_error;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		_data_->infos = _data_->_tmp8_;
		(_data_->_tmp5_ == NULL) ? NULL : (_data_->_tmp5_ = (_g_list_free__g_object_unref0_ (_data_->_tmp5_), NULL));
		_g_object_unref0 (_data_->_tmp2_);
	}
	goto __finally45;
	__catch45_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = g_file_get_path (_data_->folder);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->_error_;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical (_ ("Error listing contents of folder “%s”: %s"), _data_->_tmp10_, _data_->_tmp12_);
		_g_free0 (_data_->_tmp10_);
		_g_error_free0 (_data_->_error_);
		_g_object_unref0 (_data_->enumerator);
		(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally45:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->enumerator);
		(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->infos;
	{
		_data_->info_collection = _data_->_tmp13_;
		for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
			_data_->_tmp14_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
			_data_->info = _data_->_tmp14_;
			{
				if (_data_->self->priv->done) {
					_g_object_unref0 (_data_->info);
					break;
				}
				_data_->_tmp15_ = _data_->info;
				rygel_recursive_module_loader_handle_file_info (_data_->self, _data_->folder, _data_->_tmp15_, _____lambda6__rygel_recursive_module_loader_folder_handler, _data_->self);
				_g_object_unref0 (_data_->info);
			}
		}
	}
	_data_->_tmp16_ = g_file_get_path (_data_->folder);
	_data_->_tmp17_ = _data_->_tmp16_;
	g_debug ("rygel-recursive-module-loader.vala:166: Finished searching for modules" \
" in folder '%s'", _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_g_object_unref0 (_data_->enumerator);
	(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Process a file info.
     *
     * Utility method used by sync and async tree walk.
     * @param folder parent folder
     * @param info the FileInfo of the file to process
     * @param handler a call-back if the FileInfo represents a folder.
     */
static void
rygel_recursive_module_loader_handle_file_info (RygelRecursiveModuleLoader* self,
                                                GFile* folder,
                                                GFileInfo* info,
                                                RygelRecursiveModuleLoaderFolderHandler handler,
                                                gpointer handler_target)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = g_file_info_get_name (info);
	_tmp1_ = g_file_get_child (folder, _tmp0_);
	file = _tmp1_;
	if (rygel_recursive_module_loader_is_folder_eligible (self, info)) {
		GFile* _tmp2_;
		_tmp2_ = file;
		handler (_tmp2_, handler_target);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = g_file_info_get_name (info);
		if (g_str_has_suffix (_tmp3_, ".plugin")) {
			{
				RygelPluginInformation* plugin_info = NULL;
				GFile* _tmp4_;
				RygelPluginInformation* _tmp5_;
				RygelPluginInformation* _tmp6_;
				_tmp4_ = file;
				_tmp5_ = rygel_plugin_information_new_from_file (_tmp4_, &_inner_error0_);
				plugin_info = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch46_g_error;
				}
				_tmp6_ = plugin_info;
				if (!rygel_recursive_module_loader_load_module_from_info (self, _tmp6_)) {
					self->priv->done = TRUE;
				}
				_g_object_unref0 (plugin_info);
			}
			goto __finally46;
			__catch46_g_error:
			{
				GError* _error_ = NULL;
				GError* _tmp7_;
				const gchar* _tmp8_;
				_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp7_ = _error_;
				_tmp8_ = _tmp7_->message;
				g_warning (_ ("Could not load plugin: %s"), _tmp8_);
				_g_error_free0 (_error_);
			}
			__finally46:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_g_object_unref0 (file);
}

static gboolean
rygel_recursive_module_loader_is_folder_eligible (RygelRecursiveModuleLoader* self,
                                                  GFileInfo* file_info)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file_info != NULL, FALSE);
	if (g_file_info_get_file_type (file_info) == G_FILE_TYPE_DIRECTORY) {
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		_tmp2_ = g_file_info_get_name (file_info);
		if (g_strcmp0 (_tmp2_, ".libs") == 0) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = !g_file_info_get_is_hidden (file_info);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
     * Check if a File is a folder.
     *
     * @param file the File to check
     * @return true, if file is folder, false otherwise.
     */
static gboolean
rygel_recursive_module_loader_is_folder (RygelRecursiveModuleLoader* self,
                                         GFile* file)
{
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GFileInfo* file_info = NULL;
		GFileInfo* _tmp0_;
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		file_info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch47_g_error;
		}
		result = rygel_recursive_module_loader_is_folder_eligible (self, file_info);
		_g_object_unref0 (file_info);
		return result;
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = g_file_get_path (file);
		_tmp2_ = _tmp1_;
		g_critical (_ ("Failed to query content type for “%s”"), _tmp2_);
		_g_free0 (_tmp2_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally47:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp3_;
}

const gchar*
rygel_recursive_module_loader_get_base_path (RygelRecursiveModuleLoader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_path;
	result = _tmp0_;
	return result;
}

void
rygel_recursive_module_loader_set_base_path (RygelRecursiveModuleLoader* self,
                                             const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_recursive_module_loader_get_base_path (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_base_path);
		self->priv->_base_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_recursive_module_loader_properties[RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH_PROPERTY]);
	}
}

static void
rygel_recursive_module_loader_class_init (RygelRecursiveModuleLoaderClass * klass,
                                          gpointer klass_data)
{
	rygel_recursive_module_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelRecursiveModuleLoader_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_recursive_module_loader_real_constructed;
	((RygelRecursiveModuleLoaderClass *) klass)->load_module_from_file = (gboolean (*) (RygelRecursiveModuleLoader*, GFile*)) rygel_recursive_module_loader_real_load_module_from_file;
	((RygelRecursiveModuleLoaderClass *) klass)->load_module_from_info = (gboolean (*) (RygelRecursiveModuleLoader*, RygelPluginInformation*)) rygel_recursive_module_loader_real_load_module_from_info;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_recursive_module_loader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_recursive_module_loader_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_recursive_module_loader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH_PROPERTY, rygel_recursive_module_loader_properties[RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH_PROPERTY] = g_param_spec_string ("base-path", "base-path", "base-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
rygel_recursive_module_loader_instance_init (RygelRecursiveModuleLoader * self,
                                             gpointer klass)
{
	self->priv = rygel_recursive_module_loader_get_instance_private (self);
}

static void
rygel_recursive_module_loader_finalize (GObject * obj)
{
	RygelRecursiveModuleLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader);
	_g_free0 (self->priv->_base_path);
	G_OBJECT_CLASS (rygel_recursive_module_loader_parent_class)->finalize (obj);
}

/**
 * Recursively walk a folder looking for shared libraries.
 *
 * The folder can either be walked synchronously or asynchronously.
 * Implementing classes need to implement the abstract method
 * load_module_from_file() which is called when the walker encounters a
 * dynamic module file.
 */
GType
rygel_recursive_module_loader_get_type (void)
{
	static volatile gsize rygel_recursive_module_loader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_recursive_module_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRecursiveModuleLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_recursive_module_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRecursiveModuleLoader), 0, (GInstanceInitFunc) rygel_recursive_module_loader_instance_init, NULL };
		GType rygel_recursive_module_loader_type_id;
		rygel_recursive_module_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRecursiveModuleLoader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		RygelRecursiveModuleLoader_private_offset = g_type_add_instance_private (rygel_recursive_module_loader_type_id, sizeof (RygelRecursiveModuleLoaderPrivate));
		g_once_init_leave (&rygel_recursive_module_loader_type_id__volatile, rygel_recursive_module_loader_type_id);
	}
	return rygel_recursive_module_loader_type_id__volatile;
}

static void
_vala_rygel_recursive_module_loader_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	RygelRecursiveModuleLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader);
	switch (property_id) {
		case RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH_PROPERTY:
		g_value_set_string (value, rygel_recursive_module_loader_get_base_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_recursive_module_loader_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	RygelRecursiveModuleLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader);
	switch (property_id) {
		case RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH_PROPERTY:
		rygel_recursive_module_loader_set_base_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

