/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib-object.h>
#include <vala.h>
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>

#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_vapi_gen_unref0(var) ((var == NULL) ? NULL : (var = (vala_vapi_gen_unref (var), NULL)))
typedef struct _ValaParamSpecVAPIGen ValaParamSpecVAPIGen;

struct _ValaVAPIGen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVAPIGen *self);
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};

struct _ValaParamSpecVAPIGen {
	GParamSpec parent_instance;
};

static gint ValaVAPIGen_private_offset;
static gpointer vala_vapi_gen_parent_class = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_metadata_directories;
static gboolean vala_vapi_gen_nostdpkg;
static gchar** vala_vapi_gen_packages;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_directory;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_quiet_mode;
static gchar** vala_vapi_gen_sources;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar** vala_vapi_gen_metadata_directories = NULL;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages = NULL;
static gboolean vala_vapi_gen_nostdpkg = FALSE;

G_GNUC_INTERNAL gpointer vala_vapi_gen_ref (gpointer instance);
G_GNUC_INTERNAL void vala_vapi_gen_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_gen (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_vapi_gen (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_vapi_gen (GValue* value,
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_vapi_gen (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_vapi_gen_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaVAPIGen, vala_vapi_gen_unref)
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaGIdlParser, vala_code_visitor_unref)
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
void vala_gidl_parser_parse (ValaGIdlParser* self,
                             ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gint stack_length,
                                      const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint vala_vapi_gen_main (gchar** args,
                         gint args_length1);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_new (void);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (ValaVAPIGen * obj);
static GType vala_vapi_gen_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[12] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_nostdpkg, "Do not include standard packages", NULL}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static inline gpointer
vala_vapi_gen_get_instance_private (ValaVAPIGen* self)
{
	return G_STRUCT_MEMBER_P (self, ValaVAPIGen_private_offset);
}

static gint
vala_vapi_gen_quit (ValaVAPIGen* self)
{
	ValaCodeContext* _tmp0_;
	ValaReport* _tmp1_;
	ValaReport* _tmp2_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_report (_tmp0_);
	_tmp2_ = _tmp1_;
	if (vala_report_get_errors (_tmp2_) == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			FILE* _tmp3_;
			ValaCodeContext* _tmp4_;
			ValaReport* _tmp5_;
			ValaReport* _tmp6_;
			_tmp3_ = stdout;
			_tmp4_ = self->priv->context;
			_tmp5_ = vala_code_context_get_report (_tmp4_);
			_tmp6_ = _tmp5_;
			fprintf (_tmp3_, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp6_));
		}
		result = 0;
		return result;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			FILE* _tmp7_;
			ValaCodeContext* _tmp8_;
			ValaReport* _tmp9_;
			ValaReport* _tmp10_;
			ValaCodeContext* _tmp11_;
			ValaReport* _tmp12_;
			ValaReport* _tmp13_;
			_tmp7_ = stdout;
			_tmp8_ = self->priv->context;
			_tmp9_ = vala_code_context_get_report (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->context;
			_tmp12_ = vala_code_context_get_report (_tmp11_);
			_tmp13_ = _tmp12_;
			fprintf (_tmp7_, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp10_), vala_report_get_warnings (_tmp13_));
		}
		result = 1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gint stack_length,
                             const gchar* needle)
{
	gint i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gint
vala_vapi_gen_run (ValaVAPIGen* self)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	ValaCodeContext* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	ValaCodeContext* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	ValaCodeContext* _tmp11_;
	ValaReport* _tmp12_;
	ValaReport* _tmp13_;
	ValaCodeContext* _tmp14_;
	ValaCodeContext* _tmp15_;
	ValaCodeContext* _tmp18_;
	ValaReport* _tmp19_;
	ValaReport* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	ValaCodeContext* _tmp36_;
	ValaReport* _tmp37_;
	ValaReport* _tmp38_;
	const gchar* _tmp39_;
	ValaCodeContext* _tmp44_;
	ValaReport* _tmp45_;
	ValaReport* _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	ValaCodeContext* _tmp52_;
	ValaReport* _tmp53_;
	ValaReport* _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	ValaCodeContext* _tmp67_;
	ValaReport* _tmp68_;
	ValaReport* _tmp69_;
	ValaParser* parser = NULL;
	ValaParser* _tmp70_;
	ValaParser* _tmp71_;
	ValaCodeContext* _tmp72_;
	ValaCodeContext* _tmp73_;
	ValaReport* _tmp74_;
	ValaReport* _tmp75_;
	ValaGirParser* girparser = NULL;
	ValaGirParser* _tmp76_;
	ValaGirParser* _tmp77_;
	ValaCodeContext* _tmp78_;
	ValaCodeContext* _tmp79_;
	ValaReport* _tmp80_;
	ValaReport* _tmp81_;
	ValaGIdlParser* gidlparser = NULL;
	ValaGIdlParser* _tmp82_;
	ValaGIdlParser* _tmp83_;
	ValaCodeContext* _tmp84_;
	ValaCodeContext* _tmp85_;
	ValaReport* _tmp86_;
	ValaReport* _tmp87_;
	ValaCodeContext* _tmp88_;
	ValaCodeContext* _tmp89_;
	ValaReport* _tmp90_;
	ValaReport* _tmp91_;
	gchar** package_names = NULL;
	gchar** _tmp92_;
	gint package_names_length1;
	gint _package_names_size_;
	gchar* library_name = NULL;
	const gchar* _tmp135_;
	gchar* _tmp136_;
	gboolean _tmp137_ = FALSE;
	gchar** _tmp138_;
	gint _tmp138__length1;
	ValaCodeWriter* interface_writer = NULL;
	ValaCodeWriter* _tmp147_;
	gchar* vapi_filename = NULL;
	const gchar* _tmp148_;
	gchar* _tmp149_;
	const gchar* _tmp150_;
	ValaCodeWriter* _tmp154_;
	ValaCodeContext* _tmp155_;
	const gchar* _tmp156_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_set_profile (_tmp1_, VALA_PROFILE_GOBJECT);
	_tmp2_ = self->priv->context;
	_tmp3_ = vala_vapi_gen_vapi_directories;
	_tmp3__length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp2_, _tmp3_, _tmp3__length1);
	_tmp4_ = self->priv->context;
	_tmp5_ = vala_vapi_gen_gir_directories;
	_tmp5__length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	vala_code_context_set_gir_directories (_tmp4_, _tmp5_, _tmp5__length1);
	_tmp6_ = self->priv->context;
	_tmp7_ = vala_vapi_gen_metadata_directories;
	_tmp7__length1 = _vala_array_length (vala_vapi_gen_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp6_, _tmp7_, _tmp7__length1);
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_report_set_enable_warnings (_tmp10_, !vala_vapi_gen_disable_warnings);
	_tmp11_ = self->priv->context;
	_tmp12_ = vala_code_context_get_report (_tmp11_);
	_tmp13_ = _tmp12_;
	vala_report_set_verbose_errors (_tmp13_, !vala_vapi_gen_quiet_mode);
	_tmp14_ = self->priv->context;
	vala_code_context_push (_tmp14_);
	_tmp15_ = self->priv->context;
	vala_code_context_set_nostdpkg (_tmp15_, vala_vapi_gen_nostdpkg);
	if (!vala_vapi_gen_nostdpkg) {
		ValaCodeContext* _tmp16_;
		ValaCodeContext* _tmp17_;
		_tmp16_ = self->priv->context;
		vala_code_context_add_external_package (_tmp16_, "glib-2.0");
		_tmp17_ = self->priv->context;
		vala_code_context_add_external_package (_tmp17_, "gobject-2.0");
	}
	_tmp18_ = self->priv->context;
	_tmp19_ = vala_code_context_get_report (_tmp18_);
	_tmp20_ = _tmp19_;
	if (vala_report_get_errors (_tmp20_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp21_ = vala_vapi_gen_sources;
	_tmp21__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp21_;
		source_collection_length1 = _tmp21__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp22_;
			gchar* source = NULL;
			_tmp22_ = g_strdup (source_collection[source_it]);
			source = _tmp22_;
			{
				const gchar* _tmp23_;
				gchar* depsfile = NULL;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				ValaCodeContext* _tmp34_;
				const gchar* _tmp35_;
				_tmp23_ = source;
				if (!g_str_has_suffix (_tmp23_, ".gi")) {
					_g_free0 (source);
					continue;
				}
				_tmp24_ = source;
				_tmp25_ = source;
				_tmp26_ = strlen (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = strlen ("gi");
				_tmp29_ = _tmp28_;
				_tmp30_ = string_substring (_tmp24_, (glong) 0, (glong) (_tmp27_ - _tmp29_));
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strconcat (_tmp31_, "deps", NULL);
				_tmp33_ = _tmp32_;
				_g_free0 (_tmp31_);
				depsfile = _tmp33_;
				_tmp34_ = self->priv->context;
				_tmp35_ = depsfile;
				vala_code_context_add_packages_from_file (_tmp34_, _tmp35_);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp36_ = self->priv->context;
	_tmp37_ = vala_code_context_get_report (_tmp36_);
	_tmp38_ = _tmp37_;
	if (vala_report_get_errors (_tmp38_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp39_ = vala_vapi_gen_library;
	if (_tmp39_ != NULL) {
		gchar* depsfile = NULL;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		ValaCodeContext* _tmp42_;
		const gchar* _tmp43_;
		_tmp40_ = vala_vapi_gen_library;
		_tmp41_ = g_strconcat (_tmp40_, ".deps", NULL);
		depsfile = _tmp41_;
		_tmp42_ = self->priv->context;
		_tmp43_ = depsfile;
		vala_code_context_add_packages_from_file (_tmp42_, _tmp43_);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp44_ = self->priv->context;
	_tmp45_ = vala_code_context_get_report (_tmp44_);
	_tmp46_ = _tmp45_;
	if (vala_report_get_errors (_tmp46_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp47_ = vala_vapi_gen_packages;
	_tmp47__length1 = _vala_array_length (vala_vapi_gen_packages);
	if (_tmp47_ != NULL) {
		gchar** _tmp48_;
		gint _tmp48__length1;
		_tmp48_ = vala_vapi_gen_packages;
		_tmp48__length1 = _vala_array_length (vala_vapi_gen_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp48_;
			package_collection_length1 = _tmp48__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp49_;
				gchar* package = NULL;
				_tmp49_ = g_strdup (package_collection[package_it]);
				package = _tmp49_;
				{
					ValaCodeContext* _tmp50_;
					const gchar* _tmp51_;
					_tmp50_ = self->priv->context;
					_tmp51_ = package;
					vala_code_context_add_external_package (_tmp50_, _tmp51_);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = NULL;
	}
	_tmp52_ = self->priv->context;
	_tmp53_ = vala_code_context_get_report (_tmp52_);
	_tmp54_ = _tmp53_;
	if (vala_report_get_errors (_tmp54_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp55_ = vala_vapi_gen_sources;
	_tmp55__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp55_;
		source_collection_length1 = _tmp55__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp56_;
			gchar* source = NULL;
			_tmp56_ = g_strdup (source_collection[source_it]);
			source = _tmp56_;
			{
				const gchar* _tmp57_;
				_tmp57_ = source;
				if (g_file_test (_tmp57_, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp58_;
					const gchar* _tmp59_;
					ValaSourceFile* _tmp60_;
					ValaSourceFile* _tmp61_;
					ValaCodeContext* _tmp62_;
					ValaSourceFile* _tmp63_;
					_tmp58_ = self->priv->context;
					_tmp59_ = source;
					_tmp60_ = vala_source_file_new (_tmp58_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp59_, NULL, FALSE);
					source_file = _tmp60_;
					_tmp61_ = source_file;
					vala_source_file_set_from_commandline (_tmp61_, TRUE);
					_tmp62_ = self->priv->context;
					_tmp63_ = source_file;
					vala_code_context_add_source_file (_tmp62_, _tmp63_);
					_vala_source_file_unref0 (source_file);
				} else {
					const gchar* _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					_tmp64_ = source;
					_tmp65_ = g_strdup_printf ("%s not found", _tmp64_);
					_tmp66_ = _tmp65_;
					vala_report_error (NULL, _tmp66_);
					_g_free0 (_tmp66_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp67_ = self->priv->context;
	_tmp68_ = vala_code_context_get_report (_tmp67_);
	_tmp69_ = _tmp68_;
	if (vala_report_get_errors (_tmp69_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp70_ = vala_parser_new ();
	parser = _tmp70_;
	_tmp71_ = parser;
	_tmp72_ = self->priv->context;
	vala_parser_parse (_tmp71_, _tmp72_);
	_tmp73_ = self->priv->context;
	_tmp74_ = vala_code_context_get_report (_tmp73_);
	_tmp75_ = _tmp74_;
	if (vala_report_get_errors (_tmp75_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp76_ = vala_gir_parser_new ();
	girparser = _tmp76_;
	_tmp77_ = girparser;
	_tmp78_ = self->priv->context;
	vala_gir_parser_parse (_tmp77_, _tmp78_);
	_tmp79_ = self->priv->context;
	_tmp80_ = vala_code_context_get_report (_tmp79_);
	_tmp81_ = _tmp80_;
	if (vala_report_get_errors (_tmp81_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp82_ = vala_gidl_parser_new ();
	gidlparser = _tmp82_;
	_tmp83_ = gidlparser;
	_tmp84_ = self->priv->context;
	vala_gidl_parser_parse (_tmp83_, _tmp84_);
	_tmp85_ = self->priv->context;
	_tmp86_ = vala_code_context_get_report (_tmp85_);
	_tmp87_ = _tmp86_;
	if (vala_report_get_errors (_tmp87_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp88_ = self->priv->context;
	vala_code_context_check (_tmp88_);
	_tmp89_ = self->priv->context;
	_tmp90_ = vala_code_context_get_report (_tmp89_);
	_tmp91_ = _tmp90_;
	if (vala_report_get_errors (_tmp91_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp92_ = g_new0 (gchar*, 0 + 1);
	package_names = _tmp92_;
	package_names_length1 = 0;
	_package_names_size_ = package_names_length1;
	{
		ValaList* _file_list = NULL;
		ValaCodeContext* _tmp93_;
		ValaList* _tmp94_;
		ValaList* _tmp95_;
		gint _file_size = 0;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _file_index = 0;
		_tmp93_ = self->priv->context;
		_tmp94_ = vala_code_context_get_source_files (_tmp93_);
		_tmp95_ = _vala_iterable_ref0 (_tmp94_);
		_file_list = _tmp95_;
		_tmp96_ = _file_list;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_file_size = _tmp98_;
		_file_index = -1;
		while (TRUE) {
			ValaSourceFile* file = NULL;
			ValaList* _tmp99_;
			gpointer _tmp100_;
			ValaSourceFile* _tmp101_;
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			ValaSourceFile* _tmp104_;
			const gchar* _tmp105_;
			const gchar* _tmp106_;
			gchar** _tmp107_;
			gint _tmp107__length1;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp99_ = _file_list;
			_tmp100_ = vala_list_get (_tmp99_, _file_index);
			file = (ValaSourceFile*) _tmp100_;
			_tmp101_ = file;
			_tmp102_ = vala_source_file_get_filename (_tmp101_);
			_tmp103_ = _tmp102_;
			if (g_str_has_suffix (_tmp103_, ".vapi")) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp104_ = file;
			_tmp105_ = vala_source_file_get_filename (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_vapi_gen_sources;
			_tmp107__length1 = _vala_array_length (vala_vapi_gen_sources);
			if (_vala_string_array_contains (_tmp107_, _tmp107__length1, _tmp106_)) {
				ValaSourceFile* _tmp108_;
				ValaSourceFile* _tmp109_;
				const gchar* _tmp110_;
				const gchar* _tmp111_;
				_tmp108_ = file;
				vala_source_file_set_file_type (_tmp108_, VALA_SOURCE_FILE_TYPE_SOURCE);
				_tmp109_ = file;
				_tmp110_ = vala_source_file_get_filename (_tmp109_);
				_tmp111_ = _tmp110_;
				if (g_str_has_suffix (_tmp111_, ".gir")) {
					gchar* metadata_filename = NULL;
					ValaCodeContext* _tmp112_;
					ValaSourceFile* _tmp113_;
					const gchar* _tmp114_;
					const gchar* _tmp115_;
					gchar* _tmp116_;
					const gchar* _tmp117_;
					gboolean _tmp123_ = FALSE;
					ValaSourceFile* _tmp124_;
					gboolean _tmp125_;
					gboolean _tmp126_;
					_tmp112_ = self->priv->context;
					_tmp113_ = file;
					_tmp114_ = vala_source_file_get_filename (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = vala_code_context_get_metadata_path (_tmp112_, _tmp115_);
					metadata_filename = _tmp116_;
					_tmp117_ = metadata_filename;
					if (_tmp117_ != NULL) {
						ValaSourceFile* metadata_file = NULL;
						ValaCodeContext* _tmp118_;
						const gchar* _tmp119_;
						ValaSourceFile* _tmp120_;
						ValaSourceFile* _tmp121_;
						_tmp118_ = self->priv->context;
						_tmp119_ = metadata_filename;
						_tmp120_ = vala_code_context_get_source_file (_tmp118_, _tmp119_);
						metadata_file = _tmp120_;
						_tmp121_ = metadata_file;
						if (_tmp121_ != NULL) {
							ValaSourceFile* _tmp122_;
							_tmp122_ = metadata_file;
							vala_source_file_set_file_type (_tmp122_, VALA_SOURCE_FILE_TYPE_SOURCE);
						}
					}
					_tmp124_ = file;
					_tmp125_ = vala_source_file_get_from_commandline (_tmp124_);
					_tmp126_ = _tmp125_;
					if (_tmp126_) {
						ValaSourceFile* _tmp127_;
						const gchar* _tmp128_;
						const gchar* _tmp129_;
						_tmp127_ = file;
						_tmp128_ = vala_source_file_get_package_name (_tmp127_);
						_tmp129_ = _tmp128_;
						_tmp123_ = _tmp129_ != NULL;
					} else {
						_tmp123_ = FALSE;
					}
					if (_tmp123_) {
						gchar** _tmp130_;
						gint _tmp130__length1;
						ValaSourceFile* _tmp131_;
						const gchar* _tmp132_;
						const gchar* _tmp133_;
						gchar* _tmp134_;
						_tmp130_ = package_names;
						_tmp130__length1 = package_names_length1;
						_tmp131_ = file;
						_tmp132_ = vala_source_file_get_package_name (_tmp131_);
						_tmp133_ = _tmp132_;
						_tmp134_ = g_strdup (_tmp133_);
						_vala_array_add1 (&package_names, &package_names_length1, &_package_names_size_, _tmp134_);
					}
					_g_free0 (metadata_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp135_ = vala_vapi_gen_library;
	_tmp136_ = g_path_get_basename (_tmp135_);
	library_name = _tmp136_;
	_tmp138_ = package_names;
	_tmp138__length1 = package_names_length1;
	if (_tmp138__length1 > 0) {
		const gchar* _tmp139_;
		gchar** _tmp140_;
		gint _tmp140__length1;
		_tmp139_ = library_name;
		_tmp140_ = package_names;
		_tmp140__length1 = package_names_length1;
		_tmp137_ = !_vala_string_array_contains (_tmp140_, _tmp140__length1, _tmp139_);
	} else {
		_tmp137_ = FALSE;
	}
	if (_tmp137_) {
		const gchar* _tmp141_;
		gchar** _tmp142_;
		gint _tmp142__length1;
		gchar* _tmp143_;
		gchar* _tmp144_;
		gchar* _tmp145_;
		gchar* _tmp146_;
		_tmp141_ = library_name;
		_tmp142_ = package_names;
		_tmp142__length1 = package_names_length1;
		_tmp143_ = g_strjoin ("', `", _tmp142_, NULL);
		_tmp144_ = _tmp143_;
		_tmp145_ = g_strdup_printf ("Given library name `%s' does not match pkg-config name `%s'", _tmp141_, _tmp144_);
		_tmp146_ = _tmp145_;
		vala_report_warning (NULL, _tmp146_);
		_g_free0 (_tmp146_);
		_g_free0 (_tmp144_);
	}
	_tmp147_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_VAPIGEN);
	interface_writer = _tmp147_;
	_tmp148_ = vala_vapi_gen_library;
	_tmp149_ = g_strdup_printf ("%s.vapi", _tmp148_);
	vapi_filename = _tmp149_;
	_tmp150_ = vala_vapi_gen_directory;
	if (_tmp150_ != NULL) {
		const gchar* _tmp151_;
		const gchar* _tmp152_;
		gchar* _tmp153_;
		_tmp151_ = vala_vapi_gen_directory;
		_tmp152_ = vapi_filename;
		_tmp153_ = g_build_path ("/", _tmp151_, _tmp152_, NULL);
		_g_free0 (vapi_filename);
		vapi_filename = _tmp153_;
	}
	_tmp154_ = interface_writer;
	_tmp155_ = self->priv->context;
	_tmp156_ = vapi_filename;
	vala_code_writer_write_file (_tmp154_, _tmp155_, _tmp156_);
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = NULL;
	result = vala_vapi_gen_quit (self);
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_g_free0 (library_name);
	package_names = (_vala_array_free (package_names, package_names_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}

static gint
vala_vapi_gen_main (gchar** args,
                    gint args_length1)
{
	gchar** _tmp12_;
	gint _tmp12__length1;
	ValaVAPIGen* vapigen = NULL;
	ValaVAPIGen* _tmp14_;
	ValaVAPIGen* _tmp15_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	setlocale (LC_ALL, "");
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala API Generator");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_VAPI_GEN_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (vala_vapi_gen_version) {
		FILE* _tmp11_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "Vala API Generator %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp12_ = vala_vapi_gen_sources;
	_tmp12__length1 = _vala_array_length (vala_vapi_gen_sources);
	if (_tmp12_ == NULL) {
		FILE* _tmp13_;
		_tmp13_ = stderr;
		fprintf (_tmp13_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp14_ = vala_vapi_gen_new ();
	vapigen = _tmp14_;
	_tmp15_ = vapigen;
	result = vala_vapi_gen_run (_tmp15_);
	_vala_vapi_gen_unref0 (vapigen);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_vapi_gen_main (argv, argc);
}

G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_construct (GType object_type)
{
	ValaVAPIGen* self = NULL;
	self = (ValaVAPIGen*) g_type_create_instance (object_type);
	return self;
}

G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_new (void)
{
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}

static void
vala_value_vapi_gen_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_vapi_gen_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_vapi_gen_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_vapi_gen_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_vapi_gen_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_vapi_gen_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_vapi_gen_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaVAPIGen * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_vapi_gen_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_vapi_gen_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaVAPIGen ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_vapi_gen_ref (value->data[0].v_pointer);
	}
	return NULL;
}

G_GNUC_INTERNAL GParamSpec*
vala_param_spec_vapi_gen (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecVAPIGen* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VAPI_GEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

G_GNUC_INTERNAL gpointer
vala_value_get_vapi_gen (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN), NULL);
	return value->data[0].v_pointer;
}

G_GNUC_INTERNAL void
vala_value_set_vapi_gen (GValue* value,
                         gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_vapi_gen_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}

G_GNUC_INTERNAL void
vala_value_take_vapi_gen (GValue* value,
                          gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}

static void
vala_vapi_gen_class_init (ValaVAPIGenClass * klass,
                          gpointer klass_data)
{
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	((ValaVAPIGenClass *) klass)->finalize = vala_vapi_gen_finalize;
	g_type_class_adjust_private_offset (klass, &ValaVAPIGen_private_offset);
}

static void
vala_vapi_gen_instance_init (ValaVAPIGen * self,
                             gpointer klass)
{
	self->priv = vala_vapi_gen_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_vapi_gen_finalize (ValaVAPIGen * obj)
{
	ValaVAPIGen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VAPI_GEN, ValaVAPIGen);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}

static GType
vala_vapi_gen_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_vapi_gen_init, vala_value_vapi_gen_free_value, vala_value_vapi_gen_copy_value, vala_value_vapi_gen_peek_pointer, "p", vala_value_vapi_gen_collect_value, "p", vala_value_vapi_gen_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_vapi_gen_type_id;
	vala_vapi_gen_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVAPIGen", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaVAPIGen_private_offset = g_type_add_instance_private (vala_vapi_gen_type_id, sizeof (ValaVAPIGenPrivate));
	return vala_vapi_gen_type_id;
}

G_GNUC_INTERNAL GType
vala_vapi_gen_get_type (void)
{
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = vala_vapi_gen_get_type_once ();
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}

G_GNUC_INTERNAL gpointer
vala_vapi_gen_ref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

G_GNUC_INTERNAL void
vala_vapi_gen_unref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VAPI_GEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

