// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_FILECHOOSERBUTTON_H
#define _GTKMM_FILECHOOSERBUTTON_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/widget.h>
#include <gtkmm/filechooserdialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkFileChooserButton = struct _GtkFileChooserButton;
using GtkFileChooserButtonClass = struct _GtkFileChooserButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class FileChooserButton_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A button to launch a file chooser dialog.
 *
 * This widget lets the user select a file. It implements the FileChooser interface. Visually, it is a file name with a
 * button to bring up a FileChooserDialog. The user can then use that dialog to change the file associated with that
 * button. This widget does not support setting the "select_multiple" property to true.
 *
 * The FileChooserButton supports the Actions Action::OPEN and Action::SELECT_FOLDER.
 *
 * The FileChooserButton will ellipsize the label, and will thus request little horizontal space. To give the button more
 * space, you should call size_request(), set_width_chars(), or pack the button in such a way that other interface
 * elements give space to the widget.
 *
 * The FileChooserButton widget looks like this:
 * @image html filechooserbutton1.png
 *
 * @ingroup Widgets
 */

class FileChooserButton
  : public Widget,
    public FileChooser
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileChooserButton CppObjectType;
  typedef FileChooserButton_Class CppClassType;
  typedef GtkFileChooserButton BaseObjectType;
  typedef GtkFileChooserButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  FileChooserButton(FileChooserButton&& src) noexcept;
  FileChooserButton& operator=(FileChooserButton&& src) noexcept;

  // noncopyable
  FileChooserButton(const FileChooserButton&) = delete;
  FileChooserButton& operator=(const FileChooserButton&) = delete;

  ~FileChooserButton() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FileChooserButton_Class;
  static CppClassType filechooserbutton_class_;

protected:
  explicit FileChooserButton(const Glib::ConstructParams& construct_params);
  explicit FileChooserButton(GtkFileChooserButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkFileChooserButton*       gobj()       { return reinterpret_cast<GtkFileChooserButton*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkFileChooserButton* gobj() const { return reinterpret_cast<GtkFileChooserButton*>(gobject_); }

private:

  
public:

  /** Creates a new file-selecting button widget with the default title.
   * @param action The open mode for the widget.
   */
  explicit FileChooserButton(Action action = Action::OPEN);

  /** Creates a new file-selecting button widget.
   *
   * @param title The title of the browse dialog.
   * @param action The open mode for the widget.
   */
    explicit FileChooserButton(const Glib::ustring& title, Action action =  Action::OPEN);


  /** Creates a new file-selecting button widget which uses dialog as its file-picking window.
   *
   * @param dialog The dialog to use.
   */
    explicit FileChooserButton(FileChooserDialog& dialog);


  /** Retrieves the title of the browse dialog used by @a button. The returned value
   * should not be modified or freed.
   * 
   * @return A pointer to the browse dialog’s title.
   */
  Glib::ustring get_title() const;
  
  /** Modifies the @a title of the browse dialog used by @a button.
   * 
   * @param title The new browse dialog title.
   */
  void set_title(const Glib::ustring& title);

  
  /** Retrieves the width in characters of the @a button widget’s entry and/or label.
   * 
   * @return An integer width (in characters) that the button will use to size itself.
   */
  int get_width_chars() const;
  
  /** Sets the width (in characters) that @a button will use to @a n_chars.
   * 
   * @param n_chars The new width, in characters.
   */
  void set_width_chars(int n_chars);

  // no_default_handler because GtkFileChooserButtonClass is private.
  //This is a G_SIGNAL_ACTION signal, but it seems to be public API for applications.
  //See http://bugzilla.gnome.org/show_bug.cgi?id=353196
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%file_set()</tt>
   *
   * Flags: Run First
   *
   * The signal_file_set() signal is emitted when the user selects a file.
   * 
   * Note that this signal is only emitted when the user
   * changes the file.
   */

  Glib::SignalProxy<void()> signal_file_set();


  //_WRAP_PROPERTY("dialog", FileChooserDialog*) //construct-only
  

  /** Title to put on the Gtk::FileChooserDialog associated with the button.
   *
   * Default value: "Select a File"
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** Title to put on the Gtk::FileChooserDialog associated with the button.
   *
   * Default value: "Select a File"
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** The width of the entry and label inside the button, in characters.
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_width_chars() ;

/** The width of the entry and label inside the button, in characters.
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width_chars() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FileChooserButton
   */
  Gtk::FileChooserButton* wrap(GtkFileChooserButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_FILECHOOSERBUTTON_H */

