// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_DROPTARGET_H
#define _GTKMM_DROPTARGET_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2020 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gdkmm/contentformats.h>
#include <gdkmm/drop.h>
#include <gdkmm/enums.h>
#include <gtkmm/eventcontroller.h>
#include <gtkmm/selectiondata.h>


// The underlying C code can be found in gtkdragdest.h,.c

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkDropTarget = struct _GtkDropTarget;
using GtkDropTargetClass = struct _GtkDropTargetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class DropTarget_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
/** Event controller to receive DND drops.
 *
 * %Gtk::DropTarget is an auxiliary object that is used to receive
 * Drag-and-Drop operations.
 *
 * To use a %Gtk::DropTarget to receive drops on a widget, you create
 * a %Gtk::DropTarget object, configure which data formats and actions
 * you support, connect to its signals, and then attach
 * it to the widget with Gtk::Widget::add_controller().
 *
 * During a drag operation, the first signal that a %Gtk::DropTarget
 * emits is signal_accept(), which is meant to determine
 * whether the target is a possible drop site for the ongoing drag.
 * The default handler for the accept signal accepts the drag
 * if it finds a compatible data format and an action that is supported
 * on both sides.
 *
 * If it is, and the widget becomes the current target, you will
 * receive a signal_drag_enter(), followed by
 * signal_drag_motion() signals as the pointer moves, and
 * finally either a signal_drag_leave() when the pointer
 * moves off the widget, or a signal_drag_drop() when a drop happens.
 *
 * The signal_drag_enter() and signal_drag_motion() handler can call Gdk::Drop::status()
 * to update the status of the ongoing operation. The signal_drag_drop() handler
 * should initiate the data transfer and finish the operation by calling
 * Gdk::Drop::finish().
 *
 * Between the drag-enter and drag-leave signals the widget is the
 * current drop target, and will receive the Gtk::StateFlags::DROP_ACTIVE
 * state, which can be used to style the widget as a drop target.
 *
 * @newin{3,96}
 *
 * @ingroup Gestures
 */

class DropTarget : public EventController
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = DropTarget;
  using CppClassType = DropTarget_Class;
  using BaseObjectType = GtkDropTarget;
  using BaseClassType = GtkDropTargetClass;

  // noncopyable
  DropTarget(const DropTarget&) = delete;
  DropTarget& operator=(const DropTarget&) = delete;

private:  friend class DropTarget_Class;
  static CppClassType droptarget_class_;

protected:
  explicit DropTarget(const Glib::ConstructParams& construct_params);
  explicit DropTarget(GtkDropTarget* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  DropTarget(DropTarget&& src) noexcept;
  DropTarget& operator=(DropTarget&& src) noexcept;

  ~DropTarget() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkDropTarget*       gobj()       { return reinterpret_cast<GtkDropTarget*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkDropTarget* gobj() const { return reinterpret_cast<GtkDropTarget*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkDropTarget* gobj_copy();

private:


protected:
  // Gdk::ContentFormats is an immutable object. It can be declared const
  // in input parameters. No one can change it.
    explicit DropTarget(const Glib::RefPtr<const Gdk::ContentFormats>& formats, Gdk::DragAction actions);


public:
  
  static Glib::RefPtr<DropTarget> create(const Glib::RefPtr<const Gdk::ContentFormats>& formats, Gdk::DragAction actions =  static_cast<Gdk::DragAction>(0));

  static Glib::RefPtr<DropTarget> create(Gdk::DragAction actions = static_cast<Gdk::DragAction>(0));

  
  /** Sets the data formats that this drop target will accept.
   * 
   * @param formats The supported data formats.
   */
  void set_formats(const Glib::RefPtr<const Gdk::ContentFormats>& formats);
  
  /** Gets the data formats that this drop target accepts.
   * 
   * @return The supported data formats.
   */
  Glib::RefPtr<Gdk::ContentFormats> get_formats();
  
  /** Gets the data formats that this drop target accepts.
   * 
   * @return The supported data formats.
   */
  Glib::RefPtr<const Gdk::ContentFormats> get_formats() const;

  
  /** Sets the actions that this drop target supports.
   * 
   * @param actions The supported actions.
   */
  void set_actions(Gdk::DragAction actions);
  
  /** Gets the actions that this drop target supports.
   * 
   * @return The actions that this drop target supports.
   */
  Gdk::DragAction get_actions() const;

  
  /** Returns the underlying Gtk::Drop object for an ongoing drag.
   * 
   * @return The Gtk::Drop of the current drag operation, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Gdk::Drop> get_drop();
  
  /** Returns the underlying Gtk::Drop object for an ongoing drag.
   * 
   * @return The Gtk::Drop of the current drag operation, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Gdk::Drop> get_drop() const;

  
  /** Returns a mimetype that is supported both by @a dest and the ongoing
   * drag. For more detailed control, you can use gdk_drop_get_formats()
   * to obtain the content formats that are supported by the source.
   * 
   * @return A matching mimetype for the ongoing drag, or <tt>nullptr</tt>.
   */
  Glib::ustring find_mimetype() const;

  
  /** Asynchronously reads the dropped data from an ongoing
   * drag on a Gtk::DropTarget, and returns the data in a 
   * Gtk::SelectionData object.
   * 
   * This function is meant for cases where a Gtk::SelectionData
   * object is needed, such as when using the Gtk::TreeModel DND
   * support. In most other cases, the Gdk::Drop async read
   * APIs that return in input stream or Value are more
   * convenient and should be preferred.
   * 
   * @param target The data format to read.
   * @param cancellable A cancellable.
   * @param slot Callback to call on completion.
   */
  void read_selection_async(const std::string& target, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable);

  /// A read_selection_async() convenience overload.
  void read_selection_async(const std::string& target, const Gio::SlotAsyncReady& slot);
 

  /** Finishes an async drop read operation, see read_selection().
   * 
   * @param result A Gio::AsyncResult.
   * @return The Gtk::SelectionData, or <tt>nullptr</tt>.
   * 
   * @throws Glib::Error
   */
  SelectionData read_selection_finish(const Glib::RefPtr<Gio::AsyncResult>& result);

  
  /** Sets the @a drop as not accepted on this drag site.
   * 
   * This function should be used when delaying the decision
   * on whether to accept a drag or not until after reading
   * the data.
   * 
   * @param drop The Gdk::Drop of an ongoing drag operation.
   */
  void deny_drop(const Glib::RefPtr<Gdk::Drop>& drop);

  /** The Gdk::ContentFormats that determines the supported data formats
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::ContentFormats> > property_formats() ;

/** The Gdk::ContentFormats that determines the supported data formats
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::ContentFormats> > property_formats() const;

  /** The Gdk::DragActions that this drop target supports
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::DragAction > property_actions() ;

/** The Gdk::DragActions that this drop target supports
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::DragAction > property_actions() const;

  /** Whether the drop target is currently the targed of an ongoing drag operation,
   * and highlighted.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_contains() const;


  // no_default_handler because GtkDropTargetClass is private.
  
  /** Only one signal handler is called. If you connect a handler, it must be
   * called before (instead of) the default handler, otherwise it won't be called.
   * Set the @a after parameter in connect() to <tt>false</tt>.
   *
   * @par Slot Prototype:
   * <tt>bool on_my_%accept(const Glib::RefPtr<Gdk::Drop>& drop)</tt>
   *
   * Flags: Run Last
   *
   * The signal_accept() signal is emitted on the drop site when the user
   * moves the cursor over the widget during a drag. The signal handler
   * must determine whether the cursor position is in a drop zone or not.
   * If it is not in a drop zone, it returns <tt>false</tt> and no further processing
   * is necessary. Otherwise, the handler returns <tt>true</tt>. In this case, the
   * handler is responsible for providing the necessary information for
   * displaying feedback to the user, by calling gdk_drag_status().
   * 
   * The default handler for this signal decides whether to accept the drop
   * based on the type of the data.
   * 
   * If the decision whether the drop will be accepted or rejected can't be
   * made based solely the data format, handler may inspect the dragged data
   * by calling one of the Gdk::Drop read functions and return <tt>true</tt> to
   * tentatively accept the drop. When the data arrives and is found to not be
   * acceptable, a call to Gtk::DropTarget::deny_drop() should be made to reject
   * the drop.
   * 
   * @param drop The Gdk::Drop.
   * @return Whether the cursor position is in a drop zone.
   */

  Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::Drop>&)> signal_accept();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%drag_enter(const Glib::RefPtr<Gdk::Drop>& drop)</tt>
   *
   * Flags: Run Last
   *
   * The signal_drag_enter() signal is emitted on the drop site when the cursor
   * enters the widget. It can be used to set up custom highlighting.
   * 
   * @param drop The Gdk::Drop.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Gdk::Drop>&)> signal_drag_enter();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%drag_motion(const Glib::RefPtr<Gdk::Drop>& drop, int x, int y)</tt>
   *
   * Flags: Run Last
   *
   * The signal_drag() motion signal is emitted while the pointer is moving
   * over the drop target.
   * 
   * @param drop The Gdk::Drop.
   * @param x The x coordinate of the current cursor position.
   * @param y The y coordinate of the current cursor position.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Gdk::Drop>&, int, int)> signal_drag_motion();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%drag_leave(const Glib::RefPtr<Gdk::Drop>& drop)</tt>
   *
   * Flags: Run Last
   *
   * The signal_drag_leave() signal is emitted on the drop site when the cursor
   * leaves the widget. Its main purpose it to undo things done in
   * Gtk::DropTarget::signal_drag_enter().
   * 
   * @param drop The Gdk::Drop.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Gdk::Drop>&)> signal_drag_leave();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%drag_drop(const Glib::RefPtr<Gdk::Drop>& drop, int x, int y)</tt>
   *
   * Flags: Run Last
   *
   * The signal_drag_drop() signal is emitted on the drop site when the user drops
   * the data onto the widget. The signal handler must determine whether
   * the cursor position is in a drop zone or not. If it is not in a drop
   * zone, it returns <tt>false</tt> and no further processing is necessary.
   * 
   * Otherwise, the handler returns <tt>true</tt>. In this case, the handler must
   * ensure that gdk_drop_finish() is called to let the source know that
   * the drop is done. The call to gtk_drag_finish() can be done either
   * directly or after receiving the data.
   * 
   * To receive the data, use one of the read functions provides by Gtk::Drop
   * and Gtk::DragDest: gdk_drop_read_async(), gdk_drop_read_value_async(),
   * gdk_drop_read_text_async(), Gtk::DropTarget::read_selection().
   * 
   * You can use Gtk::DropTarget::get_drop() to obtain the Gtk::Drop object
   * for the ongoing operation in your signal handler. If you call one of the
   * read functions in your handler, GTK will ensure that the Gtk::Drop object
   * stays alive until the read is completed. If you delay obtaining the data
   * (e.g. to handle Gdk::DragAction::ASK by showing a Gtk::Popover), you need to
   * hold a reference on the Gtk::Drop.
   * 
   * @param drop The Gdk::Drop.
   * @param x The x coordinate of the current cursor position.
   * @param y The y coordinate of the current cursor position.
   * @return Whether the cursor position is in a drop zone.
   */

  Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::Drop>&, int, int)> signal_drag_drop();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::DropTarget
   */
  Glib::RefPtr<Gtk::DropTarget> wrap(GtkDropTarget* object, bool take_copy = false);
}


#endif /* _GTKMM_DROPTARGET_H */

