// Generated by gmmproc 2.61.1 -- DO NOT MODIFY!
#ifndef _GDKMM_DISPLAY_H
#define _GDKMM_DISPLAY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <gdkmm/applaunchcontext.h>
#include <gdkmm/types.h> //For ModifierType
#include <gdkmm/event.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkDisplay = struct _GdkDisplay;
using GdkDisplayClass = struct _GdkDisplayClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Display_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{


class Clipboard;
class Device;
class Seat;
class Monitor;
class Surface;

 /** Gdk::Display object's purpose is two fold:
 *   To grab/ungrab keyboard focus and mouse pointer
 *   To manage and provide information about the Gdk::Monitor(s) available for this Gdk::Display
 *
 * Gdk::Display objects are the GDK representation of the X Display which can be described as a workstation consisting
 * of a keyboard a pointing device (such as a mouse) and one or more screens. It is used to open and keep track of
 * various Gdk::Monitor objects currently instantiated by the application. It is also used to grab and release the keyboard
 * and the mouse pointer.
 */

class Display : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Display;
  using CppClassType = Display_Class;
  using BaseObjectType = GdkDisplay;
  using BaseClassType = GdkDisplayClass;

  // noncopyable
  Display(const Display&) = delete;
  Display& operator=(const Display&) = delete;

private:  friend class Display_Class;
  static CppClassType display_class_;

protected:
  explicit Display(const Glib::ConstructParams& construct_params);
  explicit Display(GdkDisplay* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Display(Display&& src) noexcept;
  Display& operator=(Display&& src) noexcept;

  ~Display() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkDisplay*       gobj()       { return reinterpret_cast<GdkDisplay*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkDisplay* gobj() const { return reinterpret_cast<GdkDisplay*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkDisplay* gobj_copy();

private:

protected:
  Display();

public:
  
  /** Opens a display.
   * 
   * @param display_name The name of the display to open.
   * @return A Gdk::Display, or <tt>nullptr</tt> if the
   * display could not be opened.
   */
  static Glib::RefPtr<Display> open(const Glib::ustring& display_name);

  
  /** Gets the name of the display.
   * 
   * @return A string representing the display name. This string is owned
   * by GDK and should not be modified or freed.
   */
  Glib::ustring get_name() const;

  
  /** Returns <tt>true</tt> if there is an ongoing grab on @a device for @a display.
   * 
   * @param device A Gdk::Device.
   * @return <tt>true</tt> if there is a grab in effect for @a device.
   */
  bool device_is_grabbed(const Glib::RefPtr<const Gdk::Device>& device) const;
  
  /** Emits a short beep on @a display
   */
  void beep();
  
  /** Flushes any requests queued for the windowing system and waits until all
   * requests have been handled. This is often used for making sure that the
   * display is synchronized with the current state of the program. Calling
   * sync() before gdk_error_trap_pop() makes sure that any errors
   * generated from earlier requests are handled before the error trap is
   * removed.
   * 
   * This is most useful for X11. On windowing systems where requests are
   * handled synchronously, this function will do nothing.
   */
  void sync();
  
  /** Closes the connection to the windowing system for the given display,
   * and cleans up associated resources.
   */
  void close();
  
  /** Finds out if the display has been closed.
   * 
   * @return <tt>true</tt> if the display is closed.
   */
  bool is_closed() const;
  
  /** Returns whether surfaces can reasonably be expected to have
   * their alpha channel drawn correctly on the screen. Check
   * is_rgba() for wether the display supports an
   * alpha channel.
   * 
   * On X11 this function returns whether a compositing manager is
   * compositing on @a display.
   * 
   * On modern displays, this value is always <tt>true</tt>.
   * 
   * @return Whether surfaces with RGBA visuals can reasonably be
   * expected to have their alpha channels drawn correctly on the screen.
   */
  bool is_composited() const;
  
  /** Returns wether surfaces on this @a display are created with an
   * alpha channel.
   * 
   * Even if a <tt>true</tt> is returned, it is possible that the
   * surface’s alpha channel won’t be honored when displaying the
   * surface on the screen: in particular, for X an appropriate
   * windowing manager and compositing manager must be running to
   * provide appropriate display. Use is_composited()
   * to check if that is the case.
   * 
   * For setting an overall opacity for a top-level surface, see
   * Gdk::Surface::set_opacity().
   * 
   * On modern displays, this value is always <tt>true</tt>.
   * 
   * @return <tt>true</tt> if surfaces are created with an alpha channel or
   * <tt>false</tt> if the display does not support this functionality.
   */
  bool is_rgba() const;

  // get_event() removes the next event, if there is one - therefore there is no const version:
  
  /** Gets the next Gdk::Event to be processed for @a display, fetching events from the
   * windowing system if necessary.
   * 
   * @return The next Gdk::Event to be processed,
   * or <tt>nullptr</tt> if no events are pending.
   */
  Glib::RefPtr<Event> get_event();

  
  /** Gets a copy of the first Gdk::Event in the @a display’s event queue, without
   * removing the event from the queue.  (Note that this function will
   * not get more events from the windowing system.  It only checks the events
   * that have already been moved to the GDK event queue.)
   * 
   * @return The first Gdk::Event on the
   * event queue.
   */
  Glib::RefPtr<Event> peek_event();
  
  /** Gets a copy of the first Gdk::Event in the @a display’s event queue, without
   * removing the event from the queue.  (Note that this function will
   * not get more events from the windowing system.  It only checks the events
   * that have already been moved to the GDK event queue.)
   * 
   * @return The first Gdk::Event on the
   * event queue.
   */
  Glib::RefPtr<const Event> peek_event() const;
  
  /** Appends a copy of the given event onto the front of the event
   * queue for @a display.
   * 
   * @param event A Gdk::Event.
   */
  void put_event(const Glib::RefPtr<const Event>& event);
  
  /** Returns whether the display has events that are waiting
   * to be processed.
   * 
   * @return <tt>true</tt> if there are events ready to be processed.
   */
  bool has_pending() const;

  
  /** Gets the default Gdk::Display. This is a convenience
   * function for:
   * `gdk_display_manager_get_default_display (Gdk::DisplayManager::get())`.
   * 
   * @return A Gdk::Display, or <tt>nullptr</tt> if
   * there is no default display.
   */
  static Glib::RefPtr<Display> get_default();

  
  /** Returns the Gdk::Keymap attached to @a display.
   * 
   * @return The Gdk::Keymap attached to @a display.
   */
  GdkKeymap* get_keymap();
  
  /** Returns the Gdk::Keymap attached to @a display.
   * 
   * @return The Gdk::Keymap attached to @a display.
   */
  const GdkKeymap* get_keymap() const;

  
  /** Flushes any requests queued for the windowing system; this happens automatically
   * when the main loop blocks waiting for new events, but if your application
   * is drawing without returning control to the main loop, you may need
   * to call this function explicitly. A common case where this function
   * needs to be called is when an application is executing drawing commands
   * from a thread other than the thread where the main loop is running.
   * 
   * This is most useful for X11. On windowing systems where requests are
   * handled synchronously, this function will do nothing.
   */
  void flush();

  
  /** Returns the default group leader surface for all toplevel surfaces
   * on @a display. This surface is implicitly created by GDK.
   * See gdk_surface_set_group().
   * 
   * @return The default group leader surface
   * for @a display.
   */
  Glib::RefPtr<Surface> get_default_group();
  
  /** Returns the default group leader surface for all toplevel surfaces
   * on @a display. This surface is implicitly created by GDK.
   * See gdk_surface_set_group().
   * 
   * @return The default group leader surface
   * for @a display.
   */
  Glib::RefPtr<const Surface> get_default_group() const;

  
  /** Gets the clipboard used for copy/paste operations.
   * 
   * @return The display's clipboard.
   */
  Glib::RefPtr<Clipboard> get_clipboard();
  
  /** Gets the clipboard used for copy/paste operations.
   * 
   * @return The display's clipboard.
   */
  Glib::RefPtr<const Clipboard> get_clipboard() const;
  
  /** Gets the clipboard used for the primary selection. On backends where the
   * primary clipboard is not supported natively, GDK emulates this clipboard
   * locally.
   * 
   * @return The primary clipboard.
   */
  Glib::RefPtr<Clipboard> get_primary_clipboard();
  
  /** Gets the clipboard used for the primary selection. On backends where the
   * primary clipboard is not supported natively, GDK emulates this clipboard
   * locally.
   * 
   * @return The primary clipboard.
   */
  Glib::RefPtr<const Clipboard> get_primary_clipboard() const;

  
  /** Returns <tt>true</tt> if gdk_surface_shape_combine_mask() can
   * be used to create shaped windows on @a display.
   * 
   * @return <tt>true</tt> if shaped windows are supported.
   */
  bool supports_shapes() const;
  
  /** Returns <tt>true</tt> if gdk_surface_input_shape_combine_mask() can
   * be used to modify the input shape of surfaces on @a display.
   * 
   * @return <tt>true</tt> if surfaces with modified input shape are supported.
   */
  bool supports_input_shapes() const;
  
  /** Indicates to the GUI environment that the application has
   * finished loading, using a given identifier.
   * 
   * GTK+ will call this function automatically for Gtk::Window
   * with custom startup-notification identifier unless
   * gtk_window_set_auto_startup_notification() is called to
   * disable that feature.
   * 
   * @param startup_id A startup-notification identifier, for which
   * notification process should be completed.
   */
  void notify_startup_complete(const Glib::ustring& startup_id);

 
  /** Returns a Gdk::AppLaunchContext suitable for launching
   * applications on the given display.
   * 
   * @return A new Gdk::AppLaunchContext for @a display.
   * Free with Glib::object_unref() when done.
   */
  Glib::RefPtr<AppLaunchContext> get_app_launch_context();
  
  /** Returns a Gdk::AppLaunchContext suitable for launching
   * applications on the given display.
   * 
   * @return A new Gdk::AppLaunchContext for @a display.
   * Free with Glib::object_unref() when done.
   */
  Glib::RefPtr<const AppLaunchContext> get_app_launch_context() const;

  
  /** Returns the default Gdk::Seat for this display.
   * 
   * @return The default seat.
   */
  Glib::RefPtr<Seat> get_default_seat();
  
  /** Returns the default Gdk::Seat for this display.
   * 
   * @return The default seat.
   */
  Glib::RefPtr<const Seat> get_default_seat() const;

 
  /** Returns the list of seats known to @a display.
   * 
   * @return The
   * list of seats known to the Gdk::Display.
   */
  std::vector<Glib::RefPtr<Seat>> list_seats();
 

  /** Returns the list of seats known to @a display.
   * 
   * @return The
   * list of seats known to the Gdk::Display.
   */
  std::vector<Glib::RefPtr<const Seat>> list_seats() const;

  
  /** Gets the number of monitors that belong to @a display.
   * 
   * The returned number is valid until the next emission of the
   * Gdk::Display::signal_monitor_added() or Gdk::Display::signal_monitor_removed() signal.
   * 
   * @return The number of monitors.
   */
  int get_n_monitors() const;
  
  /** Gets a monitor associated with this display.
   * 
   * @param monitor_num Number of the monitor.
   * @return The Gdk::Monitor, or <tt>nullptr</tt> if
   *  @a monitor_num is not a valid monitor number.
   */
  Glib::RefPtr<Monitor> get_monitor(int monitor_num);
  
  /** Gets a monitor associated with this display.
   * 
   * @param monitor_num Number of the monitor.
   * @return The Gdk::Monitor, or <tt>nullptr</tt> if
   *  @a monitor_num is not a valid monitor number.
   */
  Glib::RefPtr<const Monitor> get_monitor(int monitor_num) const;
  
  /** Gets the primary monitor for the display.
   * 
   * The primary monitor is considered the monitor where the “main desktop”
   * lives. While normal application surfaces typically allow the window
   * manager to place the surfaces, specialized desktop applications
   * such as panels should place themselves on the primary monitor.
   * 
   * If no monitor is the designated primary monitor, any monitor
   * (usually the first) may be returned. To make sure there is a dedicated
   * primary monitor, use Gdk::Monitor::is_primary() on the returned monitor.
   * 
   * @return The primary monitor, or any monitor if no
   * primary monitor is configured by the user.
   */
  Glib::RefPtr<Monitor> get_primary_monitor();
  
  /** Gets the primary monitor for the display.
   * 
   * The primary monitor is considered the monitor where the “main desktop”
   * lives. While normal application surfaces typically allow the window
   * manager to place the surfaces, specialized desktop applications
   * such as panels should place themselves on the primary monitor.
   * 
   * If no monitor is the designated primary monitor, any monitor
   * (usually the first) may be returned. To make sure there is a dedicated
   * primary monitor, use Gdk::Monitor::is_primary() on the returned monitor.
   * 
   * @return The primary monitor, or any monitor if no
   * primary monitor is configured by the user.
   */
  Glib::RefPtr<const Monitor> get_primary_monitor() const;
  
  /** Gets the monitor in which the point ( @a x, @a y) is located,
   * or a nearby monitor if the point is not in any monitor.
   * 
   * @param x The x coordinate of the point.
   * @param y The y coordinate of the point.
   * @return The monitor containing the point.
   */
  Glib::RefPtr<Monitor> get_monitor_at_point(int x, int y);
  
  /** Gets the monitor in which the point ( @a x, @a y) is located,
   * or a nearby monitor if the point is not in any monitor.
   * 
   * @param x The x coordinate of the point.
   * @param y The y coordinate of the point.
   * @return The monitor containing the point.
   */
  Glib::RefPtr<const Monitor> get_monitor_at_point(int x, int y) const;
  
  /** Gets the monitor in which the largest area of @a surface
   * resides, or a monitor close to @a surface if it is outside
   * of all monitors.
   * 
   * @param surface A Gdk::Surface.
   * @return The monitor with the largest overlap with @a surface.
   */
  Glib::RefPtr<Monitor> get_monitor_at_surface(const Glib::RefPtr<Surface>& surface);
  
  /** Gets the monitor in which the largest area of @a surface
   * resides, or a monitor close to @a surface if it is outside
   * of all monitors.
   * 
   * @param surface A Gdk::Surface.
   * @return The monitor with the largest overlap with @a surface.
   */
  Glib::RefPtr<const Monitor> get_monitor_at_surface(const Glib::RefPtr<Surface>& surface) const;

  template <class ValueType>
  bool get_setting(const Glib::ustring& name, ValueType& value) const;
  

  //We use no_default_handler because GdkDisplayClass is private.

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%closed(bool is_error)</tt>
   *
   * Flags: Run Last
   *
   * The signal_closed() signal is emitted when the connection to the windowing
   * system for @a display is closed.
   * 
   * @param is_error <tt>true</tt> if the display was closed due to an error.
   */

  Glib::SignalProxy<void(bool)> signal_closed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%opened()</tt>
   *
   * Flags: Run Last
   *
   * The signal_opened() signal is emitted when the connection to the windowing
   * system for @a display is opened.
   */

  Glib::SignalProxy<void()> signal_opened();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%seat_added(const Glib::RefPtr<Seat>& seat)</tt>
   *
   * Flags: Run Last
   *
   * The signal_seat_added() signal is emitted whenever a new seat is made
   * known to the windowing system.
   * 
   * @param seat The seat that was just added.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Seat>&)> signal_seat_added();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%seat_removed(const Glib::RefPtr<Seat>& seat)</tt>
   *
   * Flags: Run Last
   *
   * The signal_seat_removed() signal is emitted whenever a seat is removed
   * by the windowing system.
   * 
   * @param seat The seat that was just removed.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Seat>&)> signal_seat_removed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%monitor_added(const Glib::RefPtr<Monitor>& monitor)</tt>
   *
   * Flags: Run Last
   *
   * The signal_monitor_added() signal is emitted whenever a monitor is
   * added.
   * 
   * @param monitor The monitor that was just added.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Monitor>&)> signal_monitor_added();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%monitor_removed(const Glib::RefPtr<Monitor>& monitor)</tt>
   *
   * Flags: Run Last
   *
   * The signal_monitor_removed() signal is emitted whenever a monitor is
   * removed.
   * 
   * @param monitor The monitor that was just removed.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Monitor>&)> signal_monitor_removed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%setting_changed(const Glib::ustring& setting)</tt>
   *
   * Flags: Run Last
   *
   * The signal_setting_changed() signal is emitted whenever a setting
   * changes its value.
   * 
   * @param setting The name of the setting that changed.
   */

  Glib::SignalProxy<void(const Glib::ustring&)> signal_setting_changed();


  /** <tt>true</tt> if the display properly composits the alpha channel.
   * See Gdk::Display::is_composited() for details.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_composited() const;


  /** <tt>true</tt> if the display supports an alpha channel. See Gdk::Display::is_rgba()
   * for details.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_rgba() const;


  // We don't wrap the vfuncs because GdkDisplayClass is private.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

template <class ValueType>
bool Display::get_setting(const Glib::ustring& name, ValueType& value) const
{
  Glib::Value<ValueType> glibmmvalue;
  glibmmvalue.init(Glib::Value<ValueType>::value_type());

  gboolean result = gdk_display_get_setting(const_cast<GdkDisplay*>(gobj()), name.c_str(), glibmmvalue.gobj());

  value = glibmmvalue.get();
  return result;
}


} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Display
   */
  Glib::RefPtr<Gdk::Display> wrap(GdkDisplay* object, bool take_copy = false);
}


#endif /* _GDKMM_DISPLAY_H */

