/* valavapicheck.c generated by valac, the Vala compiler
 * generated from valavapicheck.vala, do not modify */

/* valavapicheck.vala
 *
 * Copyright (C) 2007  Mathias Hasselmann
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mathias Hasselmann <mathias.hasselmann@gmx.de>
 */

#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gidlmodule.h>
#include <gidlparser.h>
#include <gidlnode.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define VALA_TYPE_VAPI_CHECK (vala_vapi_check_get_type ())
#define VALA_VAPI_CHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_CHECK, ValaVAPICheck))
#define VALA_VAPI_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_CHECK, ValaVAPICheckClass))
#define VALA_IS_VAPI_CHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_CHECK))
#define VALA_IS_VAPI_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_CHECK))
#define VALA_VAPI_CHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_CHECK, ValaVAPICheckClass))

typedef struct _ValaVAPICheck ValaVAPICheck;
typedef struct _ValaVAPICheckClass ValaVAPICheckClass;
typedef struct _ValaVAPICheckPrivate ValaVAPICheckPrivate;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_vapi_check_unref0(var) ((var == NULL) ? NULL : (var = (vala_vapi_check_unref (var), NULL)))
typedef struct _ValaParamSpecVAPICheck ValaParamSpecVAPICheck;

struct _ValaVAPICheck {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVAPICheckPrivate * priv;
};

struct _ValaVAPICheckClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVAPICheck *self);
};

struct _ValaVAPICheckPrivate {
	ValaCodeContext* _context;
	ValaSourceFile* _gidl;
	ValaSourceFile* _metadata;
	ValaList* _scope;
	ValaSet* _symbols;
};

struct _ValaParamSpecVAPICheck {
	GParamSpec parent_instance;
};

static gint ValaVAPICheck_private_offset;
static gpointer vala_vapi_check_parent_class = NULL;

G_GNUC_INTERNAL gpointer vala_vapi_check_ref (gpointer instance);
G_GNUC_INTERNAL void vala_vapi_check_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_check (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_vapi_check (GValue* value,
                                gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_vapi_check (GValue* value,
                                 gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_vapi_check (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_vapi_check_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaVAPICheck, vala_vapi_check_unref)
G_GNUC_INTERNAL ValaVAPICheck* vala_vapi_check_new (const gchar* gidlname,
                                    ValaCodeContext* context);
G_GNUC_INTERNAL ValaVAPICheck* vala_vapi_check_construct (GType object_type,
                                          const gchar* gidlname,
                                          ValaCodeContext* context);
static void vala_vapi_check_set_gidl (ValaVAPICheck* self,
                               ValaSourceFile* value);
static void vala_vapi_check_set_metadata (ValaVAPICheck* self,
                                   ValaSourceFile* value);
static void vala_vapi_check_set_context (ValaVAPICheck* self,
                                  ValaCodeContext* value);
G_GNUC_INTERNAL ValaCodeContext* vala_vapi_check_get_context (ValaVAPICheck* self);
G_GNUC_INTERNAL ValaSourceFile* vala_vapi_check_get_gidl (ValaVAPICheck* self);
G_GNUC_INTERNAL ValaSourceFile* vala_vapi_check_get_metadata (ValaVAPICheck* self);
static void vala_vapi_check_parse_gidl (ValaVAPICheck* self);
static void vala_vapi_check_parse_members (ValaVAPICheck* self,
                                    const gchar* name,
                                    GList* members);
static void _g_idl_module_free0_ (gpointer var);
static inline void _g_list_free__g_idl_module_free0_ (GList* self);
static void vala_vapi_check_add_symbol (ValaVAPICheck* self,
                                 const gchar* name,
                                 const gchar* separator);
static gchar* vala_vapi_check_get_scope (ValaVAPICheck* self);
static void vala_vapi_check_enter_scope (ValaVAPICheck* self,
                                  const gchar* name);
static void vala_vapi_check_leave_scope (ValaVAPICheck* self);
static gint vala_vapi_check_check_metadata (ValaVAPICheck* self);
G_GNUC_INTERNAL gint vala_vapi_check_run (ValaVAPICheck* self);
static gint vala_vapi_check_main (gchar** args,
                           gint args_length1);
static void vala_vapi_check_finalize (ValaVAPICheck * obj);
static GType vala_vapi_check_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_vapi_check_get_instance_private (ValaVAPICheck* self)
{
	return G_STRUCT_MEMBER_P (self, ValaVAPICheck_private_offset);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

G_GNUC_INTERNAL ValaVAPICheck*
vala_vapi_check_construct (GType object_type,
                           const gchar* gidlname,
                           ValaCodeContext* context)
{
	ValaVAPICheck* self = NULL;
	ValaSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	g_return_val_if_fail (gidlname != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	self = (ValaVAPICheck*) g_type_create_instance (object_type);
	_tmp0_ = vala_source_file_new (context, VALA_SOURCE_FILE_TYPE_SOURCE, gidlname, NULL, FALSE);
	_tmp1_ = _tmp0_;
	vala_vapi_check_set_gidl (self, _tmp1_);
	_vala_source_file_unref0 (_tmp1_);
	_tmp2_ = strlen (gidlname);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (gidlname, (glong) 0, (glong) (_tmp3_ - 5));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, ".metadata", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_source_file_new (context, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp7_, NULL, FALSE);
	_tmp9_ = _tmp8_;
	vala_vapi_check_set_metadata (self, _tmp9_);
	_vala_source_file_unref0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	vala_vapi_check_set_context (self, context);
	return self;
}

G_GNUC_INTERNAL ValaVAPICheck*
vala_vapi_check_new (const gchar* gidlname,
                     ValaCodeContext* context)
{
	return vala_vapi_check_construct (VALA_TYPE_VAPI_CHECK, gidlname, context);
}

G_GNUC_INTERNAL ValaCodeContext*
vala_vapi_check_get_context (ValaVAPICheck* self)
{
	ValaCodeContext* result;
	ValaCodeContext* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static void
vala_vapi_check_set_context (ValaVAPICheck* self,
                             ValaCodeContext* value)
{
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_context_ref0 (value);
	_vala_code_context_unref0 (self->priv->_context);
	self->priv->_context = _tmp0_;
}

G_GNUC_INTERNAL ValaSourceFile*
vala_vapi_check_get_gidl (ValaVAPICheck* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gidl;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static void
vala_vapi_check_set_gidl (ValaVAPICheck* self,
                          ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_gidl);
	self->priv->_gidl = _tmp0_;
}

G_GNUC_INTERNAL ValaSourceFile*
vala_vapi_check_get_metadata (ValaVAPICheck* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_metadata;
	result = _tmp0_;
	return result;
}

static void
vala_vapi_check_set_metadata (ValaVAPICheck* self,
                              ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_metadata);
	self->priv->_metadata = _tmp0_;
}

static void
_g_idl_module_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_idl_module_free (var), NULL));
}

static inline void
_g_list_free__g_idl_module_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_idl_module_free0_);
}

static void
vala_vapi_check_parse_gidl (ValaVAPICheck* self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_);
	_vala_iterable_unref0 (self->priv->_scope);
	self->priv->_scope = (ValaList*) _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_, _tmp3_);
	_vala_iterable_unref0 (self->priv->_symbols);
	self->priv->_symbols = (ValaSet*) _tmp4_;
	{
		GList* _tmp5_ = NULL;
		ValaSourceFile* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GList* _tmp9_;
		_tmp6_ = self->priv->_gidl;
		_tmp7_ = vala_source_file_get_filename (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_idl_parse_file (_tmp8_, &_inner_error0_);
		_tmp5_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			GList* module_collection = NULL;
			GList* module_it = NULL;
			module_collection = _tmp5_;
			for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
				GIdlModule* module = NULL;
				module = (GIdlModule*) module_it->data;
				{
					GIdlModule* _tmp10_;
					const gchar* _tmp11_;
					GIdlModule* _tmp12_;
					GList* _tmp13_;
					_tmp10_ = module;
					_tmp11_ = _tmp10_->name;
					_tmp12_ = module;
					_tmp13_ = _tmp12_->entries;
					vala_vapi_check_parse_members (self, _tmp11_, _tmp13_);
				}
			}
		}
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (_g_list_free__g_idl_module_free0_ (_tmp5_), NULL));
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		FILE* _tmp14_;
		ValaSourceFile* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = stderr;
		_tmp15_ = self->priv->_gidl;
		_tmp16_ = vala_source_file_get_filename (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp14_, "%s: %s\n", _tmp17_, _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
vala_vapi_check_add_symbol (ValaVAPICheck* self,
                            const gchar* name,
                            const gchar* separator)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (NULL != separator) {
		gchar* fullname = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaSet* _tmp6_;
		const gchar* _tmp7_;
		_tmp0_ = vala_vapi_check_get_scope (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat (_tmp1_, separator, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, name, NULL);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		fullname = _tmp5_;
		_tmp6_ = self->priv->_symbols;
		_tmp7_ = fullname;
		vala_collection_add ((ValaCollection*) _tmp6_, _tmp7_);
		_g_free0 (fullname);
	} else {
		ValaSet* _tmp8_;
		_tmp8_ = self->priv->_symbols;
		vala_collection_add ((ValaCollection*) _tmp8_, name);
	}
}

static gchar*
vala_vapi_check_get_scope (ValaVAPICheck* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scope;
	_tmp1_ = self->priv->_scope;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_list_get (_tmp0_, _tmp3_ - 1);
	result = (gchar*) _tmp4_;
	return result;
}

static void
vala_vapi_check_enter_scope (ValaVAPICheck* self,
                             const gchar* name)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_scope;
	vala_collection_add ((ValaCollection*) _tmp0_, name);
	vala_vapi_check_add_symbol (self, name, NULL);
}

static void
vala_vapi_check_leave_scope (ValaVAPICheck* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_scope;
	_tmp1_ = self->priv->_scope;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_list_remove_at (_tmp0_, _tmp3_ - 1);
	_tmp5_ = (gchar*) _tmp4_;
	_g_free0 (_tmp5_);
}

static void
vala_vapi_check_parse_members (ValaVAPICheck* self,
                               const gchar* name,
                               GList* members)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_vapi_check_enter_scope (self, name);
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = members;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node = NULL;
			node = (GIdlNode*) node_it->data;
			{
				GIdlNode* _tmp0_;
				GIdlNodeTypeId _tmp1_;
				_tmp0_ = node;
				_tmp1_ = _tmp0_->type;
				switch (_tmp1_) {
					case G_IDL_NODE_ENUM:
					{
						GIdlNode* _tmp2_;
						const gchar* _tmp3_;
						GIdlNode* _tmp4_;
						GList* _tmp5_;
						_tmp2_ = node;
						_tmp3_ = ((GIdlNodeEnum*) _tmp2_)->gtype_name;
						_tmp4_ = node;
						_tmp5_ = ((GIdlNodeEnum*) _tmp4_)->values;
						vala_vapi_check_parse_members (self, _tmp3_, _tmp5_);
						break;
					}
					case G_IDL_NODE_FUNCTION:
					{
						GIdlNode* _tmp6_;
						const gchar* _tmp7_;
						GIdlNode* _tmp8_;
						GList* _tmp9_;
						_tmp6_ = node;
						_tmp7_ = ((GIdlNodeFunction*) _tmp6_)->symbol;
						_tmp8_ = node;
						_tmp9_ = ((GIdlNodeFunction*) _tmp8_)->parameters;
						vala_vapi_check_parse_members (self, _tmp7_, (GList*) _tmp9_);
						break;
					}
					case G_IDL_NODE_BOXED:
					{
						GIdlNode* _tmp10_;
						const gchar* _tmp11_;
						GIdlNode* _tmp12_;
						GList* _tmp13_;
						_tmp10_ = node;
						_tmp11_ = ((GIdlNodeBoxed*) _tmp10_)->gtype_name;
						_tmp12_ = node;
						_tmp13_ = ((GIdlNodeBoxed*) _tmp12_)->members;
						vala_vapi_check_parse_members (self, _tmp11_, _tmp13_);
						break;
					}
					case G_IDL_NODE_INTERFACE:
					case G_IDL_NODE_OBJECT:
					{
						GIdlNode* _tmp14_;
						const gchar* _tmp15_;
						GIdlNode* _tmp16_;
						GList* _tmp17_;
						_tmp14_ = node;
						_tmp15_ = ((GIdlNodeInterface*) _tmp14_)->gtype_name;
						_tmp16_ = node;
						_tmp17_ = ((GIdlNodeInterface*) _tmp16_)->members;
						vala_vapi_check_parse_members (self, _tmp15_, _tmp17_);
						break;
					}
					case G_IDL_NODE_FIELD:
					case G_IDL_NODE_PARAM:
					{
						GIdlNode* _tmp18_;
						const gchar* _tmp19_;
						_tmp18_ = node;
						_tmp19_ = _tmp18_->name;
						vala_vapi_check_add_symbol (self, _tmp19_, ".");
						break;
					}
					case G_IDL_NODE_PROPERTY:
					case G_IDL_NODE_SIGNAL:
					{
						GIdlNode* _tmp20_;
						const gchar* _tmp21_;
						_tmp20_ = node;
						_tmp21_ = _tmp20_->name;
						vala_vapi_check_add_symbol (self, _tmp21_, "::");
						break;
					}
					case G_IDL_NODE_STRUCT:
					{
						GIdlNode* _tmp22_;
						const gchar* _tmp23_;
						GIdlNode* _tmp24_;
						GList* _tmp25_;
						_tmp22_ = node;
						_tmp23_ = _tmp22_->name;
						_tmp24_ = node;
						_tmp25_ = ((GIdlNodeStruct*) _tmp24_)->members;
						vala_vapi_check_parse_members (self, _tmp23_, _tmp25_);
						break;
					}
					case G_IDL_NODE_VALUE:
					case G_IDL_NODE_VFUNC:
					{
						break;
					}
					default:
					{
						GIdlNode* _tmp26_;
						const gchar* _tmp27_;
						GIdlNode* _tmp28_;
						GIdlNodeTypeId _tmp29_;
						_tmp26_ = node;
						_tmp27_ = _tmp26_->name;
						_tmp28_ = node;
						_tmp29_ = _tmp28_->type;
						g_warning ("valavapicheck.vala:121: TODO: %s: Implement support for type %d nodes", _tmp27_, (gint) _tmp29_);
						break;
					}
				}
			}
		}
	}
	vala_vapi_check_leave_scope (self);
}

static gint
vala_vapi_check_check_metadata (ValaVAPICheck* self)
{
	gint _tmp38_ = -1;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		GIOChannel* metafile = NULL;
		ValaSourceFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GIOChannel* _tmp3_;
		gchar* line = NULL;
		gint lineno = 0;
		_tmp0_ = self->priv->_metadata;
		_tmp1_ = vala_source_file_get_filename (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_io_channel_new_file (_tmp2_, "r", &_inner_error0_);
		metafile = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		lineno = 1;
		while (TRUE) {
			GIOStatus _tmp4_ = 0;
			GIOChannel* _tmp5_;
			gchar* _tmp6_ = NULL;
			GIOStatus _tmp7_;
			gchar** tokens = NULL;
			const gchar* _tmp8_;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint tokens_length1;
			gint _tokens_size_;
			gchar* symbol = NULL;
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp5_ = metafile;
			_tmp7_ = g_io_channel_read_line (_tmp5_, &_tmp6_, NULL, NULL, &_inner_error0_);
			_g_free0 (line);
			line = _tmp6_;
			_tmp4_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_io_channel_unref0 (metafile);
				goto __catch1_g_error;
			}
			if (!(G_IO_STATUS_NORMAL == _tmp4_)) {
				break;
			}
			_tmp8_ = line;
			_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 2);
			tokens = _tmp10_;
			tokens_length1 = _vala_array_length (_tmp9_);
			_tokens_size_ = tokens_length1;
			_tmp11_ = tokens;
			_tmp11__length1 = tokens_length1;
			_tmp12_ = _tmp11_[0];
			_tmp13_ = g_strdup (_tmp12_);
			symbol = _tmp13_;
			_tmp15_ = symbol;
			_tmp16_ = strlen (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ > 0) {
				ValaSet* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = self->priv->_symbols;
				_tmp19_ = symbol;
				_tmp14_ = !vala_collection_contains ((ValaCollection*) _tmp18_, _tmp19_);
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				ValaSourceReference* src = NULL;
				ValaSourceFile* _tmp20_;
				ValaSourceLocation _tmp21_ = {0};
				const gchar* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				ValaSourceLocation _tmp25_ = {0};
				ValaSourceReference* _tmp26_;
				ValaSourceReference* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp20_ = self->priv->_metadata;
				vala_source_location_init (&_tmp21_, NULL, lineno, 1);
				_tmp22_ = symbol;
				_tmp23_ = strlen (_tmp22_);
				_tmp24_ = _tmp23_;
				vala_source_location_init (&_tmp25_, NULL, lineno, (gint) _tmp24_);
				_tmp26_ = vala_source_reference_new (_tmp20_, &_tmp21_, &_tmp25_);
				src = _tmp26_;
				_tmp27_ = src;
				_tmp28_ = symbol;
				_tmp29_ = g_strdup_printf ("Symbol `%s' not found", _tmp28_);
				_tmp30_ = _tmp29_;
				vala_report_error (_tmp27_, _tmp30_);
				_g_free0 (_tmp30_);
				_vala_source_reference_unref0 (src);
			}
			lineno += 1;
			_g_free0 (symbol);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		}
		result = 0;
		_g_free0 (line);
		_g_io_channel_unref0 (metafile);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		ValaSourceFile* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		GError* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = self->priv->_metadata;
		_tmp32_ = vala_source_file_get_filename (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = _error_;
		_tmp35_ = _tmp34_->message;
		_tmp36_ = g_strdup_printf ("%s: %s", _tmp33_, _tmp35_);
		_tmp37_ = _tmp36_;
		vala_report_error (NULL, _tmp37_);
		_g_free0 (_tmp37_);
		result = 1;
		_g_error_free0 (_error_);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp38_;
}

G_GNUC_INTERNAL gint
vala_vapi_check_run (ValaVAPICheck* self)
{
	ValaSourceFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaSourceFile* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_gidl;
	_tmp1_ = vala_source_file_get_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!g_file_test (_tmp2_, G_FILE_TEST_IS_REGULAR)) {
		ValaSourceFile* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = self->priv->_gidl;
		_tmp4_ = vala_source_file_get_filename (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s not found", _tmp5_);
		_tmp7_ = _tmp6_;
		vala_report_error (NULL, _tmp7_);
		_g_free0 (_tmp7_);
		result = 2;
		return result;
	}
	_tmp8_ = self->priv->_metadata;
	_tmp9_ = vala_source_file_get_filename (_tmp8_);
	_tmp10_ = _tmp9_;
	if (!g_file_test (_tmp10_, G_FILE_TEST_IS_REGULAR)) {
		ValaSourceFile* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = self->priv->_metadata;
		_tmp12_ = vala_source_file_get_filename (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("%s not found", _tmp13_);
		_tmp15_ = _tmp14_;
		vala_report_error (NULL, _tmp15_);
		_g_free0 (_tmp15_);
		result = 2;
		return result;
	}
	vala_vapi_check_parse_gidl (self);
	result = vala_vapi_check_check_metadata (self);
	return result;
}

static gint
vala_vapi_check_main (gchar** args,
                      gint args_length1)
{
	gboolean _tmp0_ = FALSE;
	ValaVAPICheck* vapicheck = NULL;
	const gchar* _tmp6_;
	ValaCodeContext* _tmp7_;
	ValaCodeContext* _tmp8_;
	ValaVAPICheck* _tmp9_;
	ValaVAPICheck* _tmp10_;
	ValaVAPICheck* _tmp11_;
	gint result = 0;
	if (2 != args_length1) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = args[1];
		_tmp0_ = !g_str_has_suffix (_tmp1_, ".gidl");
	}
	if (_tmp0_) {
		FILE* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = stdout;
		_tmp3_ = args[0];
		_tmp4_ = g_path_get_basename (_tmp3_);
		_tmp5_ = _tmp4_;
		fprintf (_tmp2_, "Usage: %s library.gidl\n", _tmp5_);
		_g_free0 (_tmp5_);
		result = 2;
		return result;
	}
	_tmp6_ = args[1];
	_tmp7_ = vala_code_context_new ();
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_vapi_check_new (_tmp6_, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp8_);
	vapicheck = _tmp10_;
	_tmp11_ = vapicheck;
	result = vala_vapi_check_run (_tmp11_);
	_vala_vapi_check_unref0 (vapicheck);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_vapi_check_main (argv, argc);
}

static void
vala_value_vapi_check_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_vapi_check_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_vapi_check_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_vapi_check_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_vapi_check_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_vapi_check_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_vapi_check_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaVAPICheck * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_vapi_check_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_vapi_check_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	ValaVAPICheck ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_vapi_check_ref (value->data[0].v_pointer);
	}
	return NULL;
}

G_GNUC_INTERNAL GParamSpec*
vala_param_spec_vapi_check (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ValaParamSpecVAPICheck* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VAPI_CHECK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

G_GNUC_INTERNAL gpointer
vala_value_get_vapi_check (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_CHECK), NULL);
	return value->data[0].v_pointer;
}

G_GNUC_INTERNAL void
vala_value_set_vapi_check (GValue* value,
                           gpointer v_object)
{
	ValaVAPICheck * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_CHECK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_CHECK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_vapi_check_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_check_unref (old);
	}
}

G_GNUC_INTERNAL void
vala_value_take_vapi_check (GValue* value,
                            gpointer v_object)
{
	ValaVAPICheck * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_CHECK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_CHECK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_check_unref (old);
	}
}

static void
vala_vapi_check_class_init (ValaVAPICheckClass * klass,
                            gpointer klass_data)
{
	vala_vapi_check_parent_class = g_type_class_peek_parent (klass);
	((ValaVAPICheckClass *) klass)->finalize = vala_vapi_check_finalize;
	g_type_class_adjust_private_offset (klass, &ValaVAPICheck_private_offset);
}

static void
vala_vapi_check_instance_init (ValaVAPICheck * self,
                               gpointer klass)
{
	self->priv = vala_vapi_check_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_vapi_check_finalize (ValaVAPICheck * obj)
{
	ValaVAPICheck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VAPI_CHECK, ValaVAPICheck);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->_context);
	_vala_source_file_unref0 (self->priv->_gidl);
	_vala_source_file_unref0 (self->priv->_metadata);
	_vala_iterable_unref0 (self->priv->_scope);
	_vala_iterable_unref0 (self->priv->_symbols);
}

static GType
vala_vapi_check_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_vapi_check_init, vala_value_vapi_check_free_value, vala_value_vapi_check_copy_value, vala_value_vapi_check_peek_pointer, "p", vala_value_vapi_check_collect_value, "p", vala_value_vapi_check_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaVAPICheckClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_check_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPICheck), 0, (GInstanceInitFunc) vala_vapi_check_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_vapi_check_type_id;
	vala_vapi_check_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVAPICheck", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaVAPICheck_private_offset = g_type_add_instance_private (vala_vapi_check_type_id, sizeof (ValaVAPICheckPrivate));
	return vala_vapi_check_type_id;
}

G_GNUC_INTERNAL GType
vala_vapi_check_get_type (void)
{
	static volatile gsize vala_vapi_check_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_check_type_id__volatile)) {
		GType vala_vapi_check_type_id;
		vala_vapi_check_type_id = vala_vapi_check_get_type_once ();
		g_once_init_leave (&vala_vapi_check_type_id__volatile, vala_vapi_check_type_id);
	}
	return vala_vapi_check_type_id__volatile;
}

G_GNUC_INTERNAL gpointer
vala_vapi_check_ref (gpointer instance)
{
	ValaVAPICheck * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

G_GNUC_INTERNAL void
vala_vapi_check_unref (gpointer instance)
{
	ValaVAPICheck * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VAPI_CHECK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

