/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;

static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp7_ = _expr_list;
			_tmp8_ = vala_list_get (_tmp7_, _expr_index);
			expr = (ValaExpression*) _tmp8_;
			_tmp9_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp8_ = vala_method_call_get_call (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_accessible (_tmp9_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			_tmp15_ = self->priv->_is_yield_expression;
			_tmp11_ = !_tmp15_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = vala_method_call_get_call (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp19_ = _tmp18_;
			_tmp10_ = g_strcmp0 (_tmp19_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp20_;
			_tmp20_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp20_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp21_;
		_tmp21_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp21_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp22_;
			ValaTypeSymbol* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaMethod* m = NULL;
			ValaClass* _tmp25_;
			ValaCreationMethod* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaMethod* _tmp28_;
			_tmp22_ = mtype;
			_tmp23_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp24_ = _tmp23_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_CLASS, ValaClass);
			_tmp25_ = cl;
			_tmp26_ = vala_class_get_default_construction_method (_tmp25_);
			_tmp27_ = _tmp26_;
			m = (ValaMethod*) _tmp27_;
			_tmp28_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp28_, collection, source_reference);
		} else {
			ValaDataType* _tmp29_;
			_tmp29_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp29_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp30_;
				ValaDelegate* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				_tmp30_ = mtype;
				_tmp31_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp32_ = _tmp31_;
				d = _tmp32_;
				_tmp33_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp34_;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp34_ = self->priv->argument_list;
		_tmp35_ = _vala_iterable_ref0 (_tmp34_);
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp39_;
			gpointer _tmp40_;
			ValaExpression* _tmp41_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp39_ = _expr_list;
			_tmp40_ = vala_list_get (_tmp39_, _expr_index);
			expr = (ValaExpression*) _tmp40_;
			_tmp41_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp41_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp104_;
	ValaExpression* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	gboolean _tmp109_ = FALSE;
	ValaProfile _tmp110_;
	ValaProfile _tmp111_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp137_;
	gboolean _tmp223_ = FALSE;
	ValaExpression* _tmp224_;
	ValaExpression* _tmp225_;
	gboolean _tmp295_ = FALSE;
	gboolean _tmp296_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp311_;
	ValaDataType* _tmp312_;
	ValaDataType* _tmp313_;
	ValaList* params = NULL;
	ValaDataType* _tmp314_;
	ValaList* _tmp315_;
	ValaList* _tmp316_;
	ValaDataType* _tmp317_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp372_;
	ValaIterator* _tmp373_;
	gboolean _tmp422_ = FALSE;
	ValaDataType* _tmp423_;
	gboolean _tmp443_ = FALSE;
	ValaDataType* _tmp444_;
	gboolean force_lambda_method_closure = FALSE;
	ValaDataType* _tmp536_;
	ValaDataType* _tmp547_;
	ValaDataType* _tmp548_;
	ValaDataType* _tmp549_;
	ValaDataType* _tmp550_;
	ValaDataType* _tmp551_;
	ValaDataType* _tmp552_;
	ValaList* _tmp553_;
	ValaDataType* _tmp554_;
	ValaDataType* _tmp555_;
	ValaDataType* _tmp556_;
	ValaSemanticAnalyzer* _tmp787_;
	ValaSemanticAnalyzer* _tmp788_;
	ValaDataType* _tmp789_;
	ValaList* _tmp790_;
	ValaList* _tmp791_;
	gboolean _tmp817_ = FALSE;
	gboolean _tmp818_ = FALSE;
	ValaCreationMethod* _tmp819_;
	ValaDataType* _tmp847_;
	ValaDataType* _tmp848_;
	gboolean _tmp849_;
	gboolean _tmp850_;
	gboolean _tmp906_;
	gboolean _tmp907_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaMemberAccess* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp88_ = FALSE;
			ValaMemberAccess* _tmp89_;
			ValaSymbol* _tmp90_;
			ValaSymbol* _tmp91_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp19_ = ma;
			_tmp20_ = vala_member_access_get_prototype_access (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_method_call_get_call (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_full_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp29_);
				_tmp31_ = _tmp30_;
				vala_report_error (_tmp23_, _tmp31_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp29_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_type_arguments (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp59_;
				ValaSymbol* _tmp60_;
				ValaSymbol* _tmp61_;
				gboolean _tmp62_ = FALSE;
				ValaMethod* _tmp63_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (VALA_IS_SIGNAL (_tmp48_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
					_tmp52_ = sig;
					if (_tmp52_ != NULL) {
						ValaMemberAccess* _tmp53_;
						ValaExpression* _tmp54_;
						ValaExpression* _tmp55_;
						ValaDataType* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						_tmp53_ = sig;
						_tmp54_ = vala_member_access_get_inner (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_expression_get_value_type (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp58_;
					}
				}
				_tmp59_ = ma;
				_tmp60_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp59_);
				_tmp61_ = _tmp60_;
				m = VALA_IS_METHOD (_tmp61_) ? ((ValaMethod*) _tmp61_) : NULL;
				_tmp63_ = m;
				if (_tmp63_ != NULL) {
					ValaMethod* _tmp64_;
					gboolean _tmp65_;
					gboolean _tmp66_;
					_tmp64_ = m;
					_tmp65_ = vala_method_get_coroutine (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp62_ = _tmp66_;
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					gboolean _tmp67_ = FALSE;
					ValaMemberAccess* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					_tmp68_ = ma;
					_tmp69_ = vala_member_access_get_member_name (_tmp68_);
					_tmp70_ = _tmp69_;
					if (g_strcmp0 (_tmp70_, "begin") == 0) {
						_tmp67_ = TRUE;
					} else {
						ValaMemberAccess* _tmp71_;
						const gchar* _tmp72_;
						const gchar* _tmp73_;
						_tmp71_ = ma;
						_tmp72_ = vala_member_access_get_member_name (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp67_ = g_strcmp0 (_tmp73_, "end") == 0;
					}
					if (_tmp67_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp74_;
						ValaExpression* _tmp75_;
						ValaExpression* _tmp76_;
						gboolean _tmp77_ = FALSE;
						ValaMemberAccess* _tmp78_;
						_tmp74_ = ma;
						_tmp75_ = vala_member_access_get_inner (_tmp74_);
						_tmp76_ = _tmp75_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp76_) ? ((ValaMemberAccess*) _tmp76_) : NULL;
						_tmp78_ = method_access;
						if (_tmp78_ != NULL) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = method_access;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp77_ = _tmp81_ != NULL;
						} else {
							_tmp77_ = FALSE;
						}
						if (_tmp77_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaDataType* _tmp85_;
							ValaDataType* _tmp86_;
							ValaDataType* _tmp87_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_value_type (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp87_ = _vala_code_node_ref0 (_tmp86_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp87_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp89_ = ma;
			_tmp90_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp89_);
			_tmp91_ = _tmp90_;
			if (_tmp91_ != NULL) {
				ValaMemberAccess* _tmp92_;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaAttribute* _tmp95_;
				_tmp92_ = ma;
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp94_, "Assert");
				_tmp88_ = _tmp95_ != NULL;
			} else {
				_tmp88_ = FALSE;
			}
			if (_tmp88_) {
				ValaList* _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp96_ = self->priv->argument_list;
				_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
				_tmp98_ = _tmp97_;
				if (_tmp98_ == 1) {
					ValaList* _tmp99_;
					gpointer _tmp100_;
					ValaExpression* _tmp101_;
					ValaSourceReference* _tmp102_;
					ValaSourceReference* _tmp103_;
					_tmp99_ = self->priv->argument_list;
					_tmp100_ = vala_list_get (_tmp99_, 0);
					_tmp101_ = (ValaExpression*) _tmp100_;
					_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp101_);
					_tmp103_ = _tmp102_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp103_);
					_vala_code_node_unref0 (_tmp101_);
				}
			}
		}
	}
	_tmp104_ = vala_method_call_get_call (self);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_expression_get_value_type (_tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = _vala_code_node_ref0 (_tmp107_);
	mtype = _tmp108_;
	_tmp110_ = vala_code_context_get_profile (context);
	_tmp111_ = _tmp110_;
	if (_tmp111_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp112_;
		ValaExpression* _tmp113_;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaSemanticAnalyzer* _tmp116_;
		ValaSemanticAnalyzer* _tmp117_;
		ValaClass* _tmp118_;
		_tmp112_ = vala_method_call_get_call (self);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_expression_get_symbol_reference (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_code_context_get_analyzer (context);
		_tmp117_ = _tmp116_;
		_tmp118_ = _tmp117_->object_type;
		_tmp109_ = _tmp115_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp109_ = FALSE;
	}
	gobject_chainup = _tmp109_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp121_;
		gboolean _tmp122_ = FALSE;
		ValaMemberAccess* _tmp123_;
		gboolean _tmp131_ = FALSE;
		ValaMemberAccess* _tmp132_;
		_tmp119_ = vala_method_call_get_call (self);
		_tmp120_ = _tmp119_;
		expr = _tmp120_;
		_tmp121_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp121_) ? ((ValaMemberAccess*) _tmp121_) : NULL;
		_tmp123_ = ma;
		if (_tmp123_ != NULL) {
			ValaMemberAccess* _tmp124_;
			ValaSymbol* _tmp125_;
			ValaSymbol* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = VALA_IS_CREATION_METHOD (_tmp126_);
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaMemberAccess* _tmp127_;
			ValaExpression* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp127_ = ma;
			_tmp128_ = vala_member_access_get_inner (_tmp127_);
			_tmp129_ = _tmp128_;
			expr = _tmp129_;
			_tmp130_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp130_) ? ((ValaMemberAccess*) _tmp130_) : NULL;
		}
		_tmp132_ = ma;
		if (_tmp132_ != NULL) {
			ValaMemberAccess* _tmp133_;
			const gchar* _tmp134_;
			const gchar* _tmp135_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_member_name (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp131_ = g_strcmp0 (_tmp135_, "this") == 0;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp136_;
			_tmp136_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp136_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp137_ = self->priv->_is_chainup;
	if (_tmp137_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp138_;
		ValaSemanticAnalyzer* _tmp139_;
		ValaMethod* _tmp140_;
		ValaCreationMethod* _tmp141_;
		ValaCreationMethod* _tmp149_;
		ValaDataType* _tmp150_;
		_tmp138_ = vala_code_context_get_analyzer (context);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_semantic_analyzer_find_current_method (_tmp139_);
		cm = VALA_IS_CREATION_METHOD (_tmp140_) ? ((ValaCreationMethod*) _tmp140_) : NULL;
		_tmp141_ = cm;
		if (_tmp141_ == NULL) {
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp143_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp144_;
			gboolean _tmp145_;
			gboolean _tmp146_;
			_tmp144_ = cm;
			_tmp145_ = vala_creation_method_get_chain_up (_tmp144_);
			_tmp146_ = _tmp145_;
			if (_tmp146_) {
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				vala_report_error (_tmp148_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp149_ = cm;
		vala_creation_method_set_chain_up (_tmp149_, TRUE);
		_tmp150_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp150_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp151_;
			ValaTypeSymbol* _tmp152_;
			ValaTypeSymbol* _tmp153_;
			ValaClass* _tmp154_;
			ValaCreationMethod* _tmp155_;
			ValaCreationMethod* _tmp156_;
			ValaCreationMethod* _tmp157_;
			_tmp151_ = mtype;
			_tmp152_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp153_ = _tmp152_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_CLASS, ValaClass);
			_tmp154_ = cl;
			_tmp155_ = vala_class_get_default_construction_method (_tmp154_);
			_tmp156_ = _tmp155_;
			base_cm = _tmp156_;
			_tmp157_ = base_cm;
			if (_tmp157_ == NULL) {
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				ValaClass* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				_tmp160_ = cl;
				_tmp161_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = g_strdup_printf ("chain up to `%s' not supported", _tmp162_);
				_tmp164_ = _tmp163_;
				vala_report_error (_tmp159_, _tmp164_);
				_g_free0 (_tmp164_);
				_g_free0 (_tmp162_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp165_;
				gboolean _tmp166_;
				gboolean _tmp167_;
				_tmp165_ = base_cm;
				_tmp166_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp165_);
				_tmp167_ = _tmp166_;
				if (!_tmp167_) {
					ValaSourceReference* _tmp168_;
					ValaSourceReference* _tmp169_;
					ValaCreationMethod* _tmp170_;
					gchar* _tmp171_;
					gchar* _tmp172_;
					gchar* _tmp173_;
					gchar* _tmp174_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp169_ = _tmp168_;
					_tmp170_ = base_cm;
					_tmp171_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp170_);
					_tmp172_ = _tmp171_;
					_tmp173_ = g_strdup_printf ("chain up to `%s' not supported", _tmp172_);
					_tmp174_ = _tmp173_;
					vala_report_error (_tmp169_, _tmp174_);
					_g_free0 (_tmp174_);
					_g_free0 (_tmp172_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp175_ = FALSE;
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaSymbol* _tmp178_;
			ValaSymbol* _tmp179_;
			_tmp176_ = vala_method_call_get_call (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_expression_get_symbol_reference (_tmp177_);
			_tmp179_ = _tmp178_;
			if (VALA_IS_CREATION_METHOD (_tmp179_)) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaSymbol* _tmp184_;
				ValaSymbol* _tmp185_;
				_tmp180_ = vala_method_call_get_call (self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_symbol_get_parent_symbol (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp175_ = VALA_IS_CLASS (_tmp185_);
			} else {
				_tmp175_ = FALSE;
			}
			if (_tmp175_) {
				ValaExpression* _tmp186_;
				ValaExpression* _tmp187_;
				ValaSymbol* _tmp188_;
				ValaSymbol* _tmp189_;
				ValaCreationMethod* _tmp190_;
				gboolean _tmp191_;
				gboolean _tmp192_;
				_tmp186_ = vala_method_call_get_call (self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_expression_get_symbol_reference (_tmp187_);
				_tmp189_ = _tmp188_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp190_ = base_cm;
				_tmp191_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp190_);
				_tmp192_ = _tmp191_;
				if (!_tmp192_) {
					ValaSourceReference* _tmp193_;
					ValaSourceReference* _tmp194_;
					ValaCreationMethod* _tmp195_;
					gchar* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					gchar* _tmp199_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp194_ = _tmp193_;
					_tmp195_ = base_cm;
					_tmp196_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = g_strdup_printf ("chain up to `%s' not supported", _tmp197_);
					_tmp199_ = _tmp198_;
					vala_report_error (_tmp194_, _tmp199_);
					_g_free0 (_tmp199_);
					_g_free0 (_tmp197_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp200_;
					ValaSymbol* _tmp201_;
					ValaSymbol* _tmp202_;
					gboolean _tmp203_ = FALSE;
					ValaClass* _tmp204_;
					ValaExpression* _tmp211_;
					ValaExpression* _tmp212_;
					ValaSemanticAnalyzer* _tmp213_;
					ValaSemanticAnalyzer* _tmp214_;
					ValaClass* _tmp215_;
					ValaObjectType* _tmp216_;
					ValaObjectType* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					_tmp200_ = cm;
					_tmp201_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp200_);
					_tmp202_ = _tmp201_;
					cl = VALA_IS_CLASS (_tmp202_) ? ((ValaClass*) _tmp202_) : NULL;
					_tmp204_ = cl;
					if (_tmp204_ == NULL) {
						_tmp203_ = TRUE;
					} else {
						ValaClass* _tmp205_;
						ValaSemanticAnalyzer* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaClass* _tmp208_;
						_tmp205_ = cl;
						_tmp206_ = vala_code_context_get_analyzer (context);
						_tmp207_ = _tmp206_;
						_tmp208_ = _tmp207_->object_type;
						_tmp203_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp205_, (ValaTypeSymbol*) _tmp208_);
					}
					if (_tmp203_) {
						ValaSourceReference* _tmp209_;
						ValaSourceReference* _tmp210_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp210_ = _tmp209_;
						vala_report_error (_tmp210_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp211_ = vala_method_call_get_call (self);
					_tmp212_ = _tmp211_;
					_tmp213_ = vala_code_context_get_analyzer (context);
					_tmp214_ = _tmp213_;
					_tmp215_ = _tmp214_->object_type;
					_tmp216_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp215_);
					_tmp217_ = _tmp216_;
					vala_expression_set_value_type (_tmp212_, (ValaDataType*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_method_call_get_call (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_expression_get_value_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = _vala_code_node_ref0 (_tmp221_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp222_;
				}
			}
		}
	}
	_tmp224_ = vala_method_call_get_call (self);
	_tmp225_ = _tmp224_;
	if (VALA_IS_MEMBER_ACCESS (_tmp225_)) {
		gboolean _tmp226_ = FALSE;
		gboolean _tmp227_ = FALSE;
		ValaExpression* _tmp228_;
		ValaExpression* _tmp229_;
		ValaSymbol* _tmp230_;
		ValaSymbol* _tmp231_;
		_tmp228_ = vala_method_call_get_call (self);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_expression_get_symbol_reference (_tmp229_);
		_tmp231_ = _tmp230_;
		if (VALA_IS_CREATION_METHOD (_tmp231_)) {
			ValaExpression* _tmp232_;
			ValaExpression* _tmp233_;
			ValaSymbol* _tmp234_;
			ValaSymbol* _tmp235_;
			ValaSymbol* _tmp236_;
			ValaSymbol* _tmp237_;
			_tmp232_ = vala_method_call_get_call (self);
			_tmp233_ = _tmp232_;
			_tmp234_ = vala_expression_get_symbol_reference (_tmp233_);
			_tmp235_ = _tmp234_;
			_tmp236_ = vala_symbol_get_parent_symbol (_tmp235_);
			_tmp237_ = _tmp236_;
			_tmp227_ = VALA_IS_STRUCT (_tmp237_);
		} else {
			_tmp227_ = FALSE;
		}
		if (_tmp227_) {
			_tmp226_ = TRUE;
		} else {
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			_tmp238_ = vala_method_call_get_call (self);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp226_ = VALA_IS_STRUCT (_tmp241_);
		}
		_tmp223_ = _tmp226_;
	} else {
		_tmp223_ = FALSE;
	}
	if (_tmp223_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp242_;
		ValaExpression* _tmp243_;
		ValaSymbol* _tmp244_;
		ValaSymbol* _tmp245_;
		gboolean _tmp246_ = FALSE;
		gboolean _tmp247_ = FALSE;
		ValaStruct* _tmp248_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp259_;
		ValaExpression* _tmp260_;
		ValaSourceReference* _tmp261_;
		ValaSourceReference* _tmp262_;
		ValaObjectCreationExpression* _tmp263_;
		ValaObjectCreationExpression* _tmp264_;
		ValaObjectCreationExpression* _tmp274_;
		ValaDataType* _tmp275_;
		ValaDataType* _tmp276_;
		ValaSemanticAnalyzer* _tmp277_;
		ValaSemanticAnalyzer* _tmp278_;
		ValaList* _tmp279_;
		ValaCodeNode* _tmp280_;
		ValaCodeNode* _tmp281_;
		ValaObjectCreationExpression* _tmp282_;
		ValaObjectCreationExpression* _tmp283_;
		_tmp242_ = vala_method_call_get_call (self);
		_tmp243_ = _tmp242_;
		_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
		_tmp245_ = _tmp244_;
		st = VALA_IS_STRUCT (_tmp245_) ? ((ValaStruct*) _tmp245_) : NULL;
		_tmp248_ = st;
		if (_tmp248_ != NULL) {
			ValaStruct* _tmp249_;
			ValaCreationMethod* _tmp250_;
			ValaCreationMethod* _tmp251_;
			_tmp249_ = st;
			_tmp250_ = vala_struct_get_default_construction_method (_tmp249_);
			_tmp251_ = _tmp250_;
			_tmp247_ = _tmp251_ == NULL;
		} else {
			_tmp247_ = FALSE;
		}
		if (_tmp247_) {
			gboolean _tmp252_ = FALSE;
			gboolean _tmp253_ = FALSE;
			ValaStruct* _tmp254_;
			_tmp254_ = st;
			if (vala_struct_is_boolean_type (_tmp254_)) {
				_tmp253_ = TRUE;
			} else {
				ValaStruct* _tmp255_;
				_tmp255_ = st;
				_tmp253_ = vala_struct_is_integer_type (_tmp255_);
			}
			if (_tmp253_) {
				_tmp252_ = TRUE;
			} else {
				ValaStruct* _tmp256_;
				_tmp256_ = st;
				_tmp252_ = vala_struct_is_floating_type (_tmp256_);
			}
			_tmp246_ = _tmp252_;
		} else {
			_tmp246_ = FALSE;
		}
		if (_tmp246_) {
			ValaSourceReference* _tmp257_;
			ValaSourceReference* _tmp258_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp257_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp258_ = _tmp257_;
			vala_report_error (_tmp258_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp259_ = vala_method_call_get_call (self);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp262_ = _tmp261_;
		_tmp263_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp260_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp262_);
		struct_creation_expression = _tmp263_;
		_tmp264_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp264_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp265_;
			ValaList* _tmp266_;
			gint _arg_size = 0;
			ValaList* _tmp267_;
			gint _tmp268_;
			gint _tmp269_;
			gint _arg_index = 0;
			_tmp265_ = self->priv->argument_list;
			_tmp266_ = _vala_iterable_ref0 (_tmp265_);
			_arg_list = _tmp266_;
			_tmp267_ = _arg_list;
			_tmp268_ = vala_collection_get_size ((ValaCollection*) _tmp267_);
			_tmp269_ = _tmp268_;
			_arg_size = _tmp269_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp270_;
				gpointer _tmp271_;
				ValaObjectCreationExpression* _tmp272_;
				ValaExpression* _tmp273_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp270_ = _arg_list;
				_tmp271_ = vala_list_get (_tmp270_, _arg_index);
				arg = (ValaExpression*) _tmp271_;
				_tmp272_ = struct_creation_expression;
				_tmp273_ = arg;
				vala_object_creation_expression_add_argument (_tmp272_, _tmp273_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp274_ = struct_creation_expression;
		_tmp275_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp276_ = _tmp275_;
		vala_expression_set_target_type ((ValaExpression*) _tmp274_, _tmp276_);
		_tmp277_ = vala_code_context_get_analyzer (context);
		_tmp278_ = _tmp277_;
		_tmp279_ = _tmp278_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp279_, (ValaCodeNode*) self);
		_tmp280_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp281_ = _tmp280_;
		_tmp282_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp281_, (ValaExpression*) self, (ValaExpression*) _tmp282_);
		_tmp283_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp283_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp284_ = FALSE;
		gboolean _tmp285_ = FALSE;
		gboolean _tmp286_;
		_tmp286_ = self->priv->_is_chainup;
		if (!_tmp286_) {
			ValaExpression* _tmp287_;
			ValaExpression* _tmp288_;
			_tmp287_ = vala_method_call_get_call (self);
			_tmp288_ = _tmp287_;
			_tmp285_ = VALA_IS_MEMBER_ACCESS (_tmp288_);
		} else {
			_tmp285_ = FALSE;
		}
		if (_tmp285_) {
			ValaExpression* _tmp289_;
			ValaExpression* _tmp290_;
			ValaSymbol* _tmp291_;
			ValaSymbol* _tmp292_;
			_tmp289_ = vala_method_call_get_call (self);
			_tmp290_ = _tmp289_;
			_tmp291_ = vala_expression_get_symbol_reference (_tmp290_);
			_tmp292_ = _tmp291_;
			_tmp284_ = VALA_IS_CREATION_METHOD (_tmp292_);
		} else {
			_tmp284_ = FALSE;
		}
		if (_tmp284_) {
			ValaSourceReference* _tmp293_;
			ValaSourceReference* _tmp294_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp293_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp294_ = _tmp293_;
			vala_report_error (_tmp294_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp296_ = self->priv->_is_chainup;
	if (!_tmp296_) {
		ValaDataType* _tmp297_;
		_tmp297_ = mtype;
		_tmp295_ = VALA_IS_OBJECT_TYPE (_tmp297_);
	} else {
		_tmp295_ = FALSE;
	}
	if (_tmp295_) {
		ValaSourceReference* _tmp298_;
		ValaSourceReference* _tmp299_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp298_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp299_ = _tmp298_;
		vala_report_error (_tmp299_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp300_ = FALSE;
		ValaDataType* _tmp301_;
		_tmp301_ = mtype;
		if (_tmp301_ != NULL) {
			ValaDataType* _tmp302_;
			_tmp302_ = mtype;
			_tmp300_ = vala_data_type_is_invokable (_tmp302_);
		} else {
			_tmp300_ = FALSE;
		}
		if (_tmp300_) {
		} else {
			ValaExpression* _tmp303_;
			ValaExpression* _tmp304_;
			ValaSymbol* _tmp305_;
			ValaSymbol* _tmp306_;
			_tmp303_ = vala_method_call_get_call (self);
			_tmp304_ = _tmp303_;
			_tmp305_ = vala_expression_get_symbol_reference (_tmp304_);
			_tmp306_ = _tmp305_;
			if (VALA_IS_CLASS (_tmp306_)) {
				ValaSourceReference* _tmp307_;
				ValaSourceReference* _tmp308_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp308_ = _tmp307_;
				vala_report_error (_tmp308_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp309_;
				ValaSourceReference* _tmp310_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp309_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp310_ = _tmp309_;
				vala_report_error (_tmp310_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp311_ = mtype;
	_tmp312_ = vala_data_type_get_return_type (_tmp311_);
	_tmp313_ = _vala_code_node_ref0 (_tmp312_);
	ret_type = _tmp313_;
	_tmp314_ = mtype;
	_tmp315_ = vala_data_type_get_parameters (_tmp314_);
	_tmp316_ = _vala_iterable_ref0 (_tmp315_);
	params = _tmp316_;
	_tmp317_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp317_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp318_;
		ValaExpression* _tmp319_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp320_;
		ValaMethod* _tmp321_;
		ValaMethod* _tmp322_;
		ValaMethod* _tmp323_;
		gboolean _tmp324_;
		gboolean _tmp325_;
		gint n_type_params = 0;
		ValaMethod* _tmp356_;
		ValaList* _tmp357_;
		gint _tmp358_;
		gint _tmp359_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp360_;
		ValaList* _tmp361_;
		gint _tmp362_;
		gint _tmp363_;
		gboolean _tmp364_ = FALSE;
		_tmp318_ = vala_method_call_get_call (self);
		_tmp319_ = _tmp318_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp319_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp320_ = mtype;
		_tmp321_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp322_ = _tmp321_;
		m = _tmp322_;
		_tmp323_ = m;
		_tmp324_ = vala_method_get_coroutine (_tmp323_);
		_tmp325_ = _tmp324_;
		if (_tmp325_) {
			gboolean _tmp326_;
			_tmp326_ = self->priv->_is_yield_expression;
			if (!_tmp326_) {
				ValaMemberAccess* _tmp327_;
				const gchar* _tmp328_;
				const gchar* _tmp329_;
				_tmp327_ = ma;
				_tmp328_ = vala_member_access_get_member_name (_tmp327_);
				_tmp329_ = _tmp328_;
				if (g_strcmp0 (_tmp329_, "end") != 0) {
					ValaMemberAccess* _tmp330_;
					const gchar* _tmp331_;
					const gchar* _tmp332_;
					ValaMethod* _tmp336_;
					ValaList* _tmp337_;
					ValaVoidType* _tmp338_;
					_tmp330_ = ma;
					_tmp331_ = vala_member_access_get_member_name (_tmp330_);
					_tmp332_ = _tmp331_;
					if (g_strcmp0 (_tmp332_, "begin") != 0) {
						ValaMemberAccess* _tmp333_;
						ValaSourceReference* _tmp334_;
						ValaSourceReference* _tmp335_;
						_tmp333_ = ma;
						_tmp334_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp333_);
						_tmp335_ = _tmp334_;
						vala_report_deprecated (_tmp335_, "implicit .begin is deprecated");
					}
					_tmp336_ = m;
					_tmp337_ = vala_method_get_async_begin_parameters (_tmp336_);
					_vala_iterable_unref0 (params);
					params = _tmp337_;
					_tmp338_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp338_;
				} else {
					ValaMethod* _tmp339_;
					ValaList* _tmp340_;
					_tmp339_ = m;
					_tmp340_ = vala_method_get_async_end_parameters (_tmp339_);
					_vala_iterable_unref0 (params);
					params = _tmp340_;
				}
			} else {
				gboolean _tmp341_ = FALSE;
				ValaMemberAccess* _tmp342_;
				const gchar* _tmp343_;
				const gchar* _tmp344_;
				_tmp342_ = ma;
				_tmp343_ = vala_member_access_get_member_name (_tmp342_);
				_tmp344_ = _tmp343_;
				if (g_strcmp0 (_tmp344_, "begin") == 0) {
					_tmp341_ = TRUE;
				} else {
					ValaMemberAccess* _tmp345_;
					const gchar* _tmp346_;
					const gchar* _tmp347_;
					_tmp345_ = ma;
					_tmp346_ = vala_member_access_get_member_name (_tmp345_);
					_tmp347_ = _tmp346_;
					_tmp341_ = g_strcmp0 (_tmp347_, "end") == 0;
				}
				if (_tmp341_) {
					ValaMemberAccess* _tmp348_;
					ValaSourceReference* _tmp349_;
					ValaSourceReference* _tmp350_;
					ValaMemberAccess* _tmp351_;
					const gchar* _tmp352_;
					const gchar* _tmp353_;
					gchar* _tmp354_;
					gchar* _tmp355_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp348_ = ma;
					_tmp349_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp348_);
					_tmp350_ = _tmp349_;
					_tmp351_ = ma;
					_tmp352_ = vala_member_access_get_member_name (_tmp351_);
					_tmp353_ = _tmp352_;
					_tmp354_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp353_);
					_tmp355_ = _tmp354_;
					vala_report_error (_tmp350_, _tmp355_);
					_g_free0 (_tmp355_);
				}
			}
		}
		_tmp356_ = m;
		_tmp357_ = vala_method_get_type_parameters (_tmp356_);
		_tmp358_ = vala_collection_get_size ((ValaCollection*) _tmp357_);
		_tmp359_ = _tmp358_;
		n_type_params = _tmp359_;
		_tmp360_ = ma;
		_tmp361_ = vala_member_access_get_type_arguments (_tmp360_);
		_tmp362_ = vala_collection_get_size ((ValaCollection*) _tmp361_);
		_tmp363_ = _tmp362_;
		n_type_args = _tmp363_;
		if (n_type_args > 0) {
			_tmp364_ = n_type_args < n_type_params;
		} else {
			_tmp364_ = FALSE;
		}
		if (_tmp364_) {
			ValaMemberAccess* _tmp365_;
			ValaSourceReference* _tmp366_;
			ValaSourceReference* _tmp367_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp365_ = ma;
			_tmp366_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp365_);
			_tmp367_ = _tmp366_;
			vala_report_error (_tmp367_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp368_ = FALSE;
			if (n_type_args > 0) {
				_tmp368_ = n_type_args > n_type_params;
			} else {
				_tmp368_ = FALSE;
			}
			if (_tmp368_) {
				ValaMemberAccess* _tmp369_;
				ValaSourceReference* _tmp370_;
				ValaSourceReference* _tmp371_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp369_ = ma;
				_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp369_);
				_tmp371_ = _tmp370_;
				vala_report_error (_tmp371_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp372_ = self->priv->argument_list;
	_tmp373_ = vala_iterable_iterator ((ValaIterable*) _tmp372_);
	arg_it = _tmp373_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp374_;
		ValaList* _tmp375_;
		gint _param_size = 0;
		ValaList* _tmp376_;
		gint _tmp377_;
		gint _tmp378_;
		gint _param_index = 0;
		_tmp374_ = params;
		_tmp375_ = _vala_iterable_ref0 (_tmp374_);
		_param_list = _tmp375_;
		_tmp376_ = _param_list;
		_tmp377_ = vala_collection_get_size ((ValaCollection*) _tmp376_);
		_tmp378_ = _tmp377_;
		_param_size = _tmp378_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp379_;
			gpointer _tmp380_;
			ValaParameter* _tmp381_;
			ValaParameter* _tmp382_;
			gboolean _tmp383_;
			gboolean _tmp384_;
			ValaParameter* _tmp385_;
			gboolean _tmp386_;
			gboolean _tmp387_;
			ValaIterator* _tmp405_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp379_ = _param_list;
			_tmp380_ = vala_list_get (_tmp379_, _param_index);
			param = (ValaParameter*) _tmp380_;
			_tmp381_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp381_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp382_ = param;
			_tmp383_ = vala_parameter_get_ellipsis (_tmp382_);
			_tmp384_ = _tmp383_;
			if (_tmp384_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp385_ = param;
			_tmp386_ = vala_parameter_get_params_array (_tmp385_);
			_tmp387_ = _tmp386_;
			if (_tmp387_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp388_;
				ValaDataType* _tmp389_;
				ValaDataType* _tmp390_;
				ValaArrayType* _tmp391_;
				_tmp388_ = param;
				_tmp389_ = vala_variable_get_variable_type ((ValaVariable*) _tmp388_);
				_tmp390_ = _tmp389_;
				_tmp391_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp390_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp391_;
				while (TRUE) {
					ValaIterator* _tmp392_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp393_;
					gpointer _tmp394_;
					ValaExpression* _tmp395_;
					ValaArrayType* _tmp396_;
					ValaDataType* _tmp397_;
					ValaDataType* _tmp398_;
					ValaExpression* _tmp399_;
					ValaDataType* _tmp400_;
					ValaDataType* _tmp401_;
					ValaArrayType* _tmp402_;
					gboolean _tmp403_;
					gboolean _tmp404_;
					_tmp392_ = arg_it;
					if (!vala_iterator_next (_tmp392_)) {
						break;
					}
					_tmp393_ = arg_it;
					_tmp394_ = vala_iterator_get (_tmp393_);
					arg = (ValaExpression*) _tmp394_;
					_tmp395_ = arg;
					_tmp396_ = array_type;
					_tmp397_ = vala_array_type_get_element_type (_tmp396_);
					_tmp398_ = _tmp397_;
					vala_expression_set_target_type (_tmp395_, _tmp398_);
					_tmp399_ = arg;
					_tmp400_ = vala_expression_get_target_type (_tmp399_);
					_tmp401_ = _tmp400_;
					_tmp402_ = array_type;
					_tmp403_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp402_);
					_tmp404_ = _tmp403_;
					vala_data_type_set_value_owned (_tmp401_, _tmp404_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp405_ = arg_it;
			if (vala_iterator_next (_tmp405_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp406_;
				gpointer _tmp407_;
				ValaExpression* _tmp408_;
				ValaParameter* _tmp409_;
				ValaDataType* _tmp410_;
				ValaDataType* _tmp411_;
				ValaExpression* _tmp412_;
				ValaExpression* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaDataType* _tmp416_;
				ValaList* _tmp417_;
				ValaDataType* _tmp418_;
				ValaDataType* _tmp419_;
				ValaExpression* _tmp420_;
				ValaExpression* _tmp421_;
				_tmp406_ = arg_it;
				_tmp407_ = vala_iterator_get (_tmp406_);
				arg = (ValaExpression*) _tmp407_;
				_tmp408_ = arg;
				_tmp409_ = param;
				_tmp410_ = vala_variable_get_variable_type ((ValaVariable*) _tmp409_);
				_tmp411_ = _tmp410_;
				vala_expression_set_formal_target_type (_tmp408_, _tmp411_);
				_tmp412_ = arg;
				_tmp413_ = arg;
				_tmp414_ = vala_expression_get_formal_target_type (_tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = target_object_type;
				_tmp417_ = method_type_args;
				_tmp418_ = vala_data_type_get_actual_type (_tmp415_, _tmp416_, _tmp417_, (ValaCodeNode*) self);
				_tmp419_ = _tmp418_;
				vala_expression_set_target_type (_tmp412_, _tmp419_);
				_vala_code_node_unref0 (_tmp419_);
				_tmp420_ = arg;
				_tmp421_ = _vala_code_node_ref0 (_tmp420_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp421_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp423_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp423_)) {
		ValaDataType* _tmp424_;
		ValaMethod* _tmp425_;
		ValaMethod* _tmp426_;
		ValaAttribute* _tmp427_;
		_tmp424_ = mtype;
		_tmp425_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp424_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp426_, "Print");
		_tmp422_ = _tmp427_ != NULL;
	} else {
		_tmp422_ = FALSE;
	}
	if (_tmp422_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp428_;
		ValaSourceReference* _tmp429_;
		ValaTemplate* _tmp430_;
		ValaList* _tmp441_;
		ValaTemplate* _tmp442_;
		_tmp428_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp429_ = _tmp428_;
		_tmp430_ = vala_template_new (_tmp429_);
		template = _tmp430_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp431_;
			ValaList* _tmp432_;
			gint _arg_size = 0;
			ValaList* _tmp433_;
			gint _tmp434_;
			gint _tmp435_;
			gint _arg_index = 0;
			_tmp431_ = self->priv->argument_list;
			_tmp432_ = _vala_iterable_ref0 (_tmp431_);
			_arg_list = _tmp432_;
			_tmp433_ = _arg_list;
			_tmp434_ = vala_collection_get_size ((ValaCollection*) _tmp433_);
			_tmp435_ = _tmp434_;
			_arg_size = _tmp435_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp436_;
				gpointer _tmp437_;
				ValaExpression* _tmp438_;
				ValaTemplate* _tmp439_;
				ValaExpression* _tmp440_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp436_ = _arg_list;
				_tmp437_ = vala_list_get (_tmp436_, _arg_index);
				arg = (ValaExpression*) _tmp437_;
				_tmp438_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp438_, NULL);
				_tmp439_ = template;
				_tmp440_ = arg;
				vala_template_add_expression (_tmp439_, _tmp440_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp441_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp441_);
		_tmp442_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp442_);
		_vala_code_node_unref0 (template);
	}
	_tmp444_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp444_)) {
		ValaDataType* _tmp445_;
		ValaMethod* _tmp446_;
		ValaMethod* _tmp447_;
		gboolean _tmp448_;
		gboolean _tmp449_;
		_tmp445_ = mtype;
		_tmp446_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp445_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp447_ = _tmp446_;
		_tmp448_ = vala_method_get_printf_format (_tmp447_);
		_tmp449_ = _tmp448_;
		_tmp443_ = _tmp449_;
	} else {
		_tmp443_ = FALSE;
	}
	if (_tmp443_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp450_;
		ValaStringLiteral* _tmp494_;
		format_literal = NULL;
		_tmp450_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp450_)) {
		} else {
			ValaExpression* _tmp451_;
			_tmp451_ = last_arg;
			if (_tmp451_ != NULL) {
				ValaExpression* _tmp452_;
				ValaStringLiteral* _tmp453_;
				gboolean _tmp454_ = FALSE;
				ValaStringLiteral* _tmp455_;
				_tmp452_ = last_arg;
				_tmp453_ = vala_string_literal_get_format_literal (_tmp452_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp453_;
				_tmp455_ = format_literal;
				if (_tmp455_ == NULL) {
					ValaList* _tmp456_;
					gint _tmp457_;
					gint _tmp458_;
					ValaList* _tmp459_;
					gint _tmp460_;
					gint _tmp461_;
					_tmp456_ = self->priv->argument_list;
					_tmp457_ = vala_collection_get_size ((ValaCollection*) _tmp456_);
					_tmp458_ = _tmp457_;
					_tmp459_ = params;
					_tmp460_ = vala_collection_get_size ((ValaCollection*) _tmp459_);
					_tmp461_ = _tmp460_;
					_tmp454_ = _tmp458_ == (_tmp461_ - 1);
				} else {
					_tmp454_ = FALSE;
				}
				if (_tmp454_) {
					ValaStringLiteral* _tmp462_;
					ValaStringLiteral* _tmp463_;
					ValaSemanticAnalyzer* _tmp464_;
					ValaSemanticAnalyzer* _tmp465_;
					ValaDataType* _tmp466_;
					ValaDataType* _tmp467_;
					ValaDataType* _tmp468_;
					ValaList* _tmp469_;
					ValaList* _tmp470_;
					gint _tmp471_;
					gint _tmp472_;
					ValaStringLiteral* _tmp473_;
					ValaList* _tmp474_;
					ValaIterator* _tmp475_;
					_tmp462_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp462_;
					_tmp463_ = format_literal;
					_tmp464_ = vala_code_context_get_analyzer (context);
					_tmp465_ = _tmp464_;
					_tmp466_ = _tmp465_->string_type;
					_tmp467_ = vala_data_type_copy (_tmp466_);
					_tmp468_ = _tmp467_;
					vala_expression_set_target_type ((ValaExpression*) _tmp463_, _tmp468_);
					_vala_code_node_unref0 (_tmp468_);
					_tmp469_ = self->priv->argument_list;
					_tmp470_ = self->priv->argument_list;
					_tmp471_ = vala_collection_get_size ((ValaCollection*) _tmp470_);
					_tmp472_ = _tmp471_;
					_tmp473_ = format_literal;
					vala_list_insert (_tmp469_, _tmp472_ - 1, (ValaExpression*) _tmp473_);
					_tmp474_ = self->priv->argument_list;
					_tmp475_ = vala_iterable_iterator ((ValaIterable*) _tmp474_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp475_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp476_;
						ValaList* _tmp477_;
						gint _param_size = 0;
						ValaList* _tmp478_;
						gint _tmp479_;
						gint _tmp480_;
						gint _param_index = 0;
						_tmp476_ = params;
						_tmp477_ = _vala_iterable_ref0 (_tmp476_);
						_param_list = _tmp477_;
						_tmp478_ = _param_list;
						_tmp479_ = vala_collection_get_size ((ValaCollection*) _tmp478_);
						_tmp480_ = _tmp479_;
						_param_size = _tmp480_;
						_param_index = -1;
						while (TRUE) {
							ValaParameter* param = NULL;
							ValaList* _tmp481_;
							gpointer _tmp482_;
							ValaParameter* _tmp483_;
							gboolean _tmp484_;
							gboolean _tmp485_;
							ValaIterator* _tmp486_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp481_ = _param_list;
							_tmp482_ = vala_list_get (_tmp481_, _param_index);
							param = (ValaParameter*) _tmp482_;
							_tmp483_ = param;
							_tmp484_ = vala_parameter_get_ellipsis (_tmp483_);
							_tmp485_ = _tmp484_;
							if (_tmp485_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp486_ = arg_it;
							vala_iterator_next (_tmp486_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp487_;
				ValaExpression* _tmp488_;
				ValaMemberAccess* _tmp489_;
				_tmp487_ = vala_method_call_get_call (self);
				_tmp488_ = _tmp487_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp488_) ? ((ValaMemberAccess*) _tmp488_) : NULL;
				_tmp489_ = ma;
				if (_tmp489_ != NULL) {
					ValaMemberAccess* _tmp490_;
					ValaExpression* _tmp491_;
					ValaExpression* _tmp492_;
					ValaStringLiteral* _tmp493_;
					_tmp490_ = ma;
					_tmp491_ = vala_member_access_get_inner (_tmp490_);
					_tmp492_ = _tmp491_;
					_tmp493_ = vala_string_literal_get_format_literal (_tmp492_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp493_;
				}
			}
		}
		_tmp494_ = format_literal;
		if (_tmp494_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp495_;
			gchar* _tmp496_;
			ValaSemanticAnalyzer* _tmp497_;
			ValaSemanticAnalyzer* _tmp498_;
			const gchar* _tmp499_;
			ValaIterator* _tmp500_;
			ValaSourceReference* _tmp501_;
			ValaSourceReference* _tmp502_;
			_tmp495_ = format_literal;
			_tmp496_ = vala_string_literal_eval (_tmp495_);
			format = _tmp496_;
			_tmp497_ = vala_code_context_get_analyzer (context);
			_tmp498_ = _tmp497_;
			_tmp499_ = format;
			_tmp500_ = arg_it;
			_tmp501_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp502_ = _tmp501_;
			if (!vala_semantic_analyzer_check_print_format (_tmp498_, _tmp499_, _tmp500_, _tmp502_)) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp503_;
		ValaList* _tmp504_;
		gint _arg_size = 0;
		ValaList* _tmp505_;
		gint _tmp506_;
		gint _tmp507_;
		gint _arg_index = 0;
		_tmp503_ = self->priv->argument_list;
		_tmp504_ = _vala_iterable_ref0 (_tmp503_);
		_arg_list = _tmp504_;
		_tmp505_ = _arg_list;
		_tmp506_ = vala_collection_get_size ((ValaCollection*) _tmp505_);
		_tmp507_ = _tmp506_;
		_arg_size = _tmp507_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp508_;
			gpointer _tmp509_;
			ValaExpression* _tmp510_;
			gboolean _tmp511_ = FALSE;
			ValaExpression* _tmp512_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp508_ = _arg_list;
			_tmp509_ = vala_list_get (_tmp508_, _arg_index);
			arg = (ValaExpression*) _tmp509_;
			_tmp510_ = arg;
			vala_code_node_check ((ValaCodeNode*) _tmp510_, context);
			_tmp512_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp512_)) {
				ValaExpression* _tmp513_;
				ValaMethod* _tmp514_;
				ValaMethod* _tmp515_;
				gboolean _tmp516_;
				gboolean _tmp517_;
				_tmp513_ = arg;
				_tmp514_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp513_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp515_ = _tmp514_;
				_tmp516_ = vala_method_get_closure (_tmp515_);
				_tmp517_ = _tmp516_;
				_tmp511_ = _tmp517_;
			} else {
				_tmp511_ = FALSE;
			}
			if (_tmp511_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	if (force_lambda_method_closure) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp518_;
			ValaList* _tmp519_;
			gint _arg_size = 0;
			ValaList* _tmp520_;
			gint _tmp521_;
			gint _tmp522_;
			gint _arg_index = 0;
			_tmp518_ = self->priv->argument_list;
			_tmp519_ = _vala_iterable_ref0 (_tmp518_);
			_arg_list = _tmp519_;
			_tmp520_ = _arg_list;
			_tmp521_ = vala_collection_get_size ((ValaCollection*) _tmp520_);
			_tmp522_ = _tmp521_;
			_arg_size = _tmp522_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp523_;
				gpointer _tmp524_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp525_;
				gboolean _tmp526_ = FALSE;
				ValaLambdaExpression* _tmp527_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp523_ = _arg_list;
				_tmp524_ = vala_list_get (_tmp523_, _arg_index);
				arg = (ValaExpression*) _tmp524_;
				_tmp525_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp525_) ? ((ValaLambdaExpression*) _tmp525_) : NULL;
				_tmp527_ = lambda;
				if (_tmp527_ != NULL) {
					ValaLambdaExpression* _tmp528_;
					ValaMethod* _tmp529_;
					ValaMethod* _tmp530_;
					ValaMemberBinding _tmp531_;
					ValaMemberBinding _tmp532_;
					_tmp528_ = lambda;
					_tmp529_ = vala_lambda_expression_get_method (_tmp528_);
					_tmp530_ = _tmp529_;
					_tmp531_ = vala_method_get_binding (_tmp530_);
					_tmp532_ = _tmp531_;
					_tmp526_ = _tmp532_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp526_ = FALSE;
				}
				if (_tmp526_) {
					ValaLambdaExpression* _tmp533_;
					ValaMethod* _tmp534_;
					ValaMethod* _tmp535_;
					_tmp533_ = lambda;
					_tmp534_ = vala_lambda_expression_get_method (_tmp533_);
					_tmp535_ = _tmp534_;
					vala_method_set_closure (_tmp535_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
	}
	_tmp536_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp536_)) {
		gboolean _tmp537_ = FALSE;
		gboolean _tmp538_ = FALSE;
		ValaCodeNode* _tmp539_;
		ValaCodeNode* _tmp540_;
		_tmp539_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp540_ = _tmp539_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp540_)) {
			ValaCodeNode* _tmp541_;
			ValaCodeNode* _tmp542_;
			_tmp541_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp542_ = _tmp541_;
			_tmp538_ = !VALA_IS_FOR_STATEMENT (_tmp542_);
		} else {
			_tmp538_ = FALSE;
		}
		if (_tmp538_) {
			ValaCodeNode* _tmp543_;
			ValaCodeNode* _tmp544_;
			_tmp543_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp544_ = _tmp543_;
			_tmp537_ = !VALA_IS_YIELD_STATEMENT (_tmp544_);
		} else {
			_tmp537_ = FALSE;
		}
		if (_tmp537_) {
			ValaSourceReference* _tmp545_;
			ValaSourceReference* _tmp546_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp545_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp546_ = _tmp545_;
			vala_report_error (_tmp546_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp547_ = ret_type;
	_tmp548_ = vala_data_type_copy (_tmp547_);
	_tmp549_ = _tmp548_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp549_);
	_vala_code_node_unref0 (_tmp549_);
	_tmp550_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp551_ = _tmp550_;
	_tmp552_ = target_object_type;
	_tmp553_ = method_type_args;
	_tmp554_ = vala_data_type_get_actual_type (_tmp551_, _tmp552_, _tmp553_, (ValaCodeNode*) self);
	_tmp555_ = _tmp554_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp555_);
	_vala_code_node_unref0 (_tmp555_);
	_tmp556_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp556_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp557_;
		ValaMethod* _tmp558_;
		ValaMethod* _tmp559_;
		gboolean _tmp560_;
		ValaMethod* _tmp579_;
		gboolean _tmp580_;
		gboolean _tmp581_;
		ValaMethod* _tmp584_;
		gboolean _tmp585_;
		gboolean _tmp586_;
		gboolean _tmp591_ = FALSE;
		gboolean _tmp592_ = FALSE;
		gboolean _tmp593_ = FALSE;
		gboolean _tmp594_;
		gboolean _tmp595_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp607_;
		ValaSymbol* _tmp608_;
		ValaSymbol* _tmp609_;
		gboolean _tmp610_ = FALSE;
		ValaSignal* _tmp611_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp620_;
		ValaSymbol* _tmp621_;
		ValaSymbol* _tmp622_;
		gboolean _tmp623_ = FALSE;
		ValaDynamicSignal* _tmp624_;
		gboolean _tmp666_ = FALSE;
		ValaMethod* _tmp667_;
		gboolean _tmp774_ = FALSE;
		ValaMethod* _tmp775_;
		_tmp557_ = mtype;
		_tmp558_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp557_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp559_ = _tmp558_;
		m = _tmp559_;
		_tmp560_ = self->priv->_is_yield_expression;
		if (_tmp560_) {
			ValaMethod* _tmp561_;
			gboolean _tmp562_;
			gboolean _tmp563_;
			gboolean _tmp566_ = FALSE;
			ValaSemanticAnalyzer* _tmp567_;
			ValaSemanticAnalyzer* _tmp568_;
			ValaMethod* _tmp569_;
			ValaMethod* _tmp570_;
			_tmp561_ = m;
			_tmp562_ = vala_method_get_coroutine (_tmp561_);
			_tmp563_ = _tmp562_;
			if (!_tmp563_) {
				ValaSourceReference* _tmp564_;
				ValaSourceReference* _tmp565_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp565_ = _tmp564_;
				vala_report_error (_tmp565_, "yield expression requires async method");
			}
			_tmp567_ = vala_code_context_get_analyzer (context);
			_tmp568_ = _tmp567_;
			_tmp569_ = vala_semantic_analyzer_get_current_method (_tmp568_);
			_tmp570_ = _tmp569_;
			if (_tmp570_ == NULL) {
				_tmp566_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp571_;
				ValaSemanticAnalyzer* _tmp572_;
				ValaMethod* _tmp573_;
				ValaMethod* _tmp574_;
				gboolean _tmp575_;
				gboolean _tmp576_;
				_tmp571_ = vala_code_context_get_analyzer (context);
				_tmp572_ = _tmp571_;
				_tmp573_ = vala_semantic_analyzer_get_current_method (_tmp572_);
				_tmp574_ = _tmp573_;
				_tmp575_ = vala_method_get_coroutine (_tmp574_);
				_tmp576_ = _tmp575_;
				_tmp566_ = !_tmp576_;
			}
			if (_tmp566_) {
				ValaSourceReference* _tmp577_;
				ValaSourceReference* _tmp578_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp577_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp578_ = _tmp577_;
				vala_report_error (_tmp578_, "yield expression not available outside async method");
			}
		}
		_tmp579_ = m;
		_tmp580_ = vala_method_get_returns_floating_reference (_tmp579_);
		_tmp581_ = _tmp580_;
		if (_tmp581_) {
			ValaDataType* _tmp582_;
			ValaDataType* _tmp583_;
			_tmp582_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp583_ = _tmp582_;
			vala_data_type_set_floating_reference (_tmp583_, TRUE);
		}
		_tmp584_ = m;
		_tmp585_ = vala_method_get_returns_modified_pointer (_tmp584_);
		_tmp586_ = _tmp585_;
		if (_tmp586_) {
			ValaExpression* _tmp587_;
			ValaExpression* _tmp588_;
			ValaExpression* _tmp589_;
			ValaExpression* _tmp590_;
			_tmp587_ = vala_method_call_get_call (self);
			_tmp588_ = _tmp587_;
			_tmp589_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp588_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp590_ = _tmp589_;
			vala_expression_set_lvalue (_tmp590_, TRUE);
		}
		_tmp594_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp595_ = _tmp594_;
		if (_tmp595_) {
			ValaDataType* _tmp596_;
			ValaDataType* _tmp597_;
			gboolean _tmp598_;
			gboolean _tmp599_;
			_tmp596_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp597_ = _tmp596_;
			_tmp598_ = vala_data_type_get_nullable (_tmp597_);
			_tmp599_ = _tmp598_;
			_tmp593_ = !_tmp599_;
		} else {
			_tmp593_ = FALSE;
		}
		if (_tmp593_) {
			ValaDataType* _tmp600_;
			ValaDataType* _tmp601_;
			gboolean _tmp602_;
			gboolean _tmp603_;
			_tmp600_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp601_ = _tmp600_;
			_tmp602_ = vala_data_type_get_floating_reference (_tmp601_);
			_tmp603_ = _tmp602_;
			_tmp592_ = _tmp603_;
		} else {
			_tmp592_ = FALSE;
		}
		if (_tmp592_) {
			ValaDataType* _tmp604_;
			_tmp604_ = ret_type;
			_tmp591_ = VALA_IS_OBJECT_TYPE (_tmp604_);
		} else {
			_tmp591_ = FALSE;
		}
		if (_tmp591_) {
			ValaDataType* _tmp605_;
			ValaDataType* _tmp606_;
			_tmp605_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp606_ = _tmp605_;
			vala_data_type_set_nullable (_tmp606_, TRUE);
		}
		_tmp607_ = m;
		_tmp608_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp607_);
		_tmp609_ = _tmp608_;
		sig = VALA_IS_SIGNAL (_tmp609_) ? ((ValaSignal*) _tmp609_) : NULL;
		_tmp611_ = sig;
		if (_tmp611_ != NULL) {
			ValaMethod* _tmp612_;
			const gchar* _tmp613_;
			const gchar* _tmp614_;
			_tmp612_ = m;
			_tmp613_ = vala_symbol_get_name ((ValaSymbol*) _tmp612_);
			_tmp614_ = _tmp613_;
			_tmp610_ = g_strcmp0 (_tmp614_, "disconnect") == 0;
		} else {
			_tmp610_ = FALSE;
		}
		if (_tmp610_) {
			ValaExpression* param = NULL;
			ValaList* _tmp615_;
			gpointer _tmp616_;
			ValaExpression* _tmp617_;
			_tmp615_ = self->priv->argument_list;
			_tmp616_ = vala_list_get (_tmp615_, 0);
			param = (ValaExpression*) _tmp616_;
			_tmp617_ = param;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp617_)) {
				ValaSourceReference* _tmp618_;
				ValaSourceReference* _tmp619_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp618_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp619_ = _tmp618_;
				vala_report_error (_tmp619_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_tmp620_ = m;
		_tmp621_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp620_);
		_tmp622_ = _tmp621_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp622_) ? ((ValaDynamicSignal*) _tmp622_) : NULL;
		_tmp624_ = dynamic_sig;
		if (_tmp624_ != NULL) {
			ValaDynamicSignal* _tmp625_;
			ValaExpression* _tmp626_;
			ValaExpression* _tmp627_;
			_tmp625_ = dynamic_sig;
			_tmp626_ = vala_dynamic_signal_get_handler (_tmp625_);
			_tmp627_ = _tmp626_;
			_tmp623_ = _tmp627_ != NULL;
		} else {
			_tmp623_ = FALSE;
		}
		if (_tmp623_) {
			ValaDynamicSignal* _tmp628_;
			ValaDynamicSignal* _tmp629_;
			ValaExpression* _tmp630_;
			ValaExpression* _tmp631_;
			ValaDataType* _tmp632_;
			ValaDataType* _tmp633_;
			ValaDataType* _tmp634_;
			ValaDataType* _tmp635_;
			ValaDataType* _tmp636_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp653_;
			ValaExpression* _tmp654_;
			ValaExpression* _tmp655_;
			ValaDynamicSignal* _tmp656_;
			ValaDynamicSignal* _tmp657_;
			ValaSymbol* _tmp658_;
			ValaSymbol* _tmp659_;
			ValaObjectType* _tmp660_;
			ValaObjectType* _tmp661_;
			ValaDelegate* _tmp662_;
			ValaDelegate* _tmp663_;
			ValaDelegateType* _tmp664_;
			ValaDelegateType* _tmp665_;
			_tmp628_ = dynamic_sig;
			_tmp629_ = dynamic_sig;
			_tmp630_ = vala_dynamic_signal_get_handler (_tmp629_);
			_tmp631_ = _tmp630_;
			_tmp632_ = vala_expression_get_value_type (_tmp631_);
			_tmp633_ = _tmp632_;
			_tmp634_ = vala_data_type_get_return_type (_tmp633_);
			_tmp635_ = vala_data_type_copy (_tmp634_);
			_tmp636_ = _tmp635_;
			vala_callable_set_return_type ((ValaCallable*) _tmp628_, _tmp636_);
			_vala_code_node_unref0 (_tmp636_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp637_;
				ValaExpression* _tmp638_;
				ValaExpression* _tmp639_;
				ValaDataType* _tmp640_;
				ValaDataType* _tmp641_;
				ValaList* _tmp642_;
				ValaList* _tmp643_;
				gint _param_size = 0;
				ValaList* _tmp644_;
				gint _tmp645_;
				gint _tmp646_;
				gint _param_index = 0;
				_tmp637_ = dynamic_sig;
				_tmp638_ = vala_dynamic_signal_get_handler (_tmp637_);
				_tmp639_ = _tmp638_;
				_tmp640_ = vala_expression_get_value_type (_tmp639_);
				_tmp641_ = _tmp640_;
				_tmp642_ = vala_data_type_get_parameters (_tmp641_);
				_tmp643_ = _vala_iterable_ref0 (_tmp642_);
				_param_list = _tmp643_;
				_tmp644_ = _param_list;
				_tmp645_ = vala_collection_get_size ((ValaCollection*) _tmp644_);
				_tmp646_ = _tmp645_;
				_param_size = _tmp646_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp647_;
					gpointer _tmp648_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp647_ = _param_list;
					_tmp648_ = vala_list_get (_tmp647_, _param_index);
					param = (ValaParameter*) _tmp648_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp649_;
						ValaParameter* _tmp650_;
						ValaParameter* _tmp651_;
						ValaParameter* _tmp652_;
						_tmp649_ = dynamic_sig;
						_tmp650_ = param;
						_tmp651_ = vala_parameter_copy (_tmp650_);
						_tmp652_ = _tmp651_;
						vala_callable_add_parameter ((ValaCallable*) _tmp649_, _tmp652_);
						_vala_code_node_unref0 (_tmp652_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp653_ = dynamic_sig;
			_tmp654_ = vala_dynamic_signal_get_handler (_tmp653_);
			_tmp655_ = _tmp654_;
			_tmp656_ = dynamic_sig;
			_tmp657_ = dynamic_sig;
			_tmp658_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp657_);
			_tmp659_ = _tmp658_;
			_tmp660_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp659_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp661_ = _tmp660_;
			_tmp662_ = vala_signal_get_delegate ((ValaSignal*) _tmp656_, (ValaDataType*) _tmp661_, (ValaCodeNode*) self);
			_tmp663_ = _tmp662_;
			_tmp664_ = vala_delegate_type_new (_tmp663_);
			_tmp665_ = _tmp664_;
			vala_expression_set_target_type (_tmp655_, (ValaDataType*) _tmp665_);
			_vala_code_node_unref0 (_tmp665_);
			_vala_code_node_unref0 (_tmp663_);
			_vala_code_node_unref0 (_tmp661_);
		}
		_tmp667_ = m;
		if (_tmp667_ != NULL) {
			ValaMethod* _tmp668_;
			_tmp668_ = m;
			_tmp666_ = vala_method_has_type_parameters (_tmp668_);
		} else {
			_tmp666_ = FALSE;
		}
		if (_tmp666_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp669_;
			ValaExpression* _tmp670_;
			ValaMemberAccess* _tmp671_;
			ValaList* _tmp672_;
			gint _tmp673_;
			gint _tmp674_;
			_tmp669_ = vala_method_call_get_call (self);
			_tmp670_ = _tmp669_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp670_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp671_ = ma;
			_tmp672_ = vala_member_access_get_type_arguments (_tmp671_);
			_tmp673_ = vala_collection_get_size ((ValaCollection*) _tmp672_);
			_tmp674_ = _tmp673_;
			if (_tmp674_ == 0) {
				ValaList* _tmp741_;
				ValaIterator* _tmp742_;
				ValaDataType* _tmp768_;
				ValaDataType* _tmp769_;
				ValaDataType* _tmp770_;
				ValaList* _tmp771_;
				ValaDataType* _tmp772_;
				ValaDataType* _tmp773_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp675_;
					ValaList* _tmp676_;
					ValaList* _tmp677_;
					gint _type_param_size = 0;
					ValaList* _tmp678_;
					gint _tmp679_;
					gint _tmp680_;
					gint _type_param_index = 0;
					_tmp675_ = m;
					_tmp676_ = vala_method_get_type_parameters (_tmp675_);
					_tmp677_ = _vala_iterable_ref0 (_tmp676_);
					_type_param_list = _tmp677_;
					_tmp678_ = _type_param_list;
					_tmp679_ = vala_collection_get_size ((ValaCollection*) _tmp678_);
					_tmp680_ = _tmp679_;
					_type_param_size = _tmp680_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp681_;
						gpointer _tmp682_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp683_;
						ValaIterator* _tmp684_;
						gboolean _tmp719_ = FALSE;
						ValaDataType* _tmp720_;
						ValaDataType* _tmp730_;
						ValaMemberAccess* _tmp739_;
						ValaDataType* _tmp740_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp681_ = _type_param_list;
						_tmp682_ = vala_list_get (_tmp681_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp682_;
						type_arg = NULL;
						_tmp683_ = self->priv->argument_list;
						_tmp684_ = vala_iterable_iterator ((ValaIterable*) _tmp683_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp684_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp685_;
							ValaList* _tmp686_;
							gint _param_size = 0;
							ValaList* _tmp687_;
							gint _tmp688_;
							gint _tmp689_;
							gint _param_index = 0;
							_tmp685_ = params;
							_tmp686_ = _vala_iterable_ref0 (_tmp685_);
							_param_list = _tmp686_;
							_tmp687_ = _param_list;
							_tmp688_ = vala_collection_get_size ((ValaCollection*) _tmp687_);
							_tmp689_ = _tmp688_;
							_param_size = _tmp689_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp690_;
								gpointer _tmp691_;
								gboolean _tmp692_ = FALSE;
								ValaParameter* _tmp693_;
								gboolean _tmp694_;
								gboolean _tmp695_;
								ValaIterator* _tmp699_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp690_ = _param_list;
								_tmp691_ = vala_list_get (_tmp690_, _param_index);
								param = (ValaParameter*) _tmp691_;
								_tmp693_ = param;
								_tmp694_ = vala_parameter_get_ellipsis (_tmp693_);
								_tmp695_ = _tmp694_;
								if (_tmp695_) {
									_tmp692_ = TRUE;
								} else {
									ValaParameter* _tmp696_;
									gboolean _tmp697_;
									gboolean _tmp698_;
									_tmp696_ = param;
									_tmp697_ = vala_parameter_get_params_array (_tmp696_);
									_tmp698_ = _tmp697_;
									_tmp692_ = _tmp698_;
								}
								if (_tmp692_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp699_ = arg_it;
								if (vala_iterator_next (_tmp699_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp700_;
									gpointer _tmp701_;
									ValaParameter* _tmp702_;
									ValaDataType* _tmp703_;
									ValaDataType* _tmp704_;
									ValaTypeParameter* _tmp705_;
									ValaExpression* _tmp706_;
									ValaDataType* _tmp707_;
									ValaDataType* _tmp708_;
									ValaDataType* _tmp709_;
									ValaDataType* _tmp710_;
									ValaExpression* _tmp711_;
									ValaExpression* _tmp712_;
									ValaDataType* _tmp713_;
									ValaDataType* _tmp714_;
									ValaDataType* _tmp715_;
									ValaList* _tmp716_;
									ValaDataType* _tmp717_;
									ValaDataType* _tmp718_;
									_tmp700_ = arg_it;
									_tmp701_ = vala_iterator_get (_tmp700_);
									arg = (ValaExpression*) _tmp701_;
									_tmp702_ = param;
									_tmp703_ = vala_variable_get_variable_type ((ValaVariable*) _tmp702_);
									_tmp704_ = _tmp703_;
									_tmp705_ = type_param;
									_tmp706_ = arg;
									_tmp707_ = vala_expression_get_value_type (_tmp706_);
									_tmp708_ = _tmp707_;
									_tmp709_ = vala_data_type_infer_type_argument (_tmp704_, _tmp705_, _tmp708_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp709_;
									_tmp710_ = type_arg;
									if (_tmp710_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp711_ = arg;
									_tmp712_ = arg;
									_tmp713_ = vala_expression_get_formal_target_type (_tmp712_);
									_tmp714_ = _tmp713_;
									_tmp715_ = target_object_type;
									_tmp716_ = method_type_args;
									_tmp717_ = vala_data_type_get_actual_type (_tmp714_, _tmp715_, _tmp716_, (ValaCodeNode*) self);
									_tmp718_ = _tmp717_;
									vala_expression_set_target_type (_tmp711_, _tmp718_);
									_vala_code_node_unref0 (_tmp718_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp720_ = type_arg;
						if (_tmp720_ == NULL) {
							ValaDataType* _tmp721_;
							ValaDataType* _tmp722_;
							_tmp721_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp722_ = _tmp721_;
							_tmp719_ = _tmp722_ != NULL;
						} else {
							_tmp719_ = FALSE;
						}
						if (_tmp719_) {
							ValaMethod* _tmp723_;
							ValaDataType* _tmp724_;
							ValaDataType* _tmp725_;
							ValaTypeParameter* _tmp726_;
							ValaDataType* _tmp727_;
							ValaDataType* _tmp728_;
							ValaDataType* _tmp729_;
							_tmp723_ = m;
							_tmp724_ = vala_callable_get_return_type ((ValaCallable*) _tmp723_);
							_tmp725_ = _tmp724_;
							_tmp726_ = type_param;
							_tmp727_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp728_ = _tmp727_;
							_tmp729_ = vala_data_type_infer_type_argument (_tmp725_, _tmp726_, _tmp728_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp729_;
						}
						_tmp730_ = type_arg;
						if (_tmp730_ == NULL) {
							ValaMemberAccess* _tmp731_;
							ValaSourceReference* _tmp732_;
							ValaSourceReference* _tmp733_;
							ValaTypeParameter* _tmp734_;
							gchar* _tmp735_;
							gchar* _tmp736_;
							gchar* _tmp737_;
							gchar* _tmp738_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp731_ = ma;
							_tmp732_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp731_);
							_tmp733_ = _tmp732_;
							_tmp734_ = type_param;
							_tmp735_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp734_);
							_tmp736_ = _tmp735_;
							_tmp737_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp736_);
							_tmp738_ = _tmp737_;
							vala_report_error (_tmp733_, _tmp738_);
							_g_free0 (_tmp738_);
							_g_free0 (_tmp736_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp739_ = ma;
						_tmp740_ = type_arg;
						vala_member_access_add_type_argument (_tmp739_, _tmp740_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp741_ = self->priv->argument_list;
				_tmp742_ = vala_iterable_iterator ((ValaIterable*) _tmp741_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp742_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp743_;
					ValaList* _tmp744_;
					gint _param_size = 0;
					ValaList* _tmp745_;
					gint _tmp746_;
					gint _tmp747_;
					gint _param_index = 0;
					_tmp743_ = params;
					_tmp744_ = _vala_iterable_ref0 (_tmp743_);
					_param_list = _tmp744_;
					_tmp745_ = _param_list;
					_tmp746_ = vala_collection_get_size ((ValaCollection*) _tmp745_);
					_tmp747_ = _tmp746_;
					_param_size = _tmp747_;
					_param_index = -1;
					while (TRUE) {
						ValaParameter* param = NULL;
						ValaList* _tmp748_;
						gpointer _tmp749_;
						gboolean _tmp750_ = FALSE;
						ValaParameter* _tmp751_;
						gboolean _tmp752_;
						gboolean _tmp753_;
						ValaIterator* _tmp757_;
						_param_index = _param_index + 1;
						if (!(_param_index < _param_size)) {
							break;
						}
						_tmp748_ = _param_list;
						_tmp749_ = vala_list_get (_tmp748_, _param_index);
						param = (ValaParameter*) _tmp749_;
						_tmp751_ = param;
						_tmp752_ = vala_parameter_get_ellipsis (_tmp751_);
						_tmp753_ = _tmp752_;
						if (_tmp753_) {
							_tmp750_ = TRUE;
						} else {
							ValaParameter* _tmp754_;
							gboolean _tmp755_;
							gboolean _tmp756_;
							_tmp754_ = param;
							_tmp755_ = vala_parameter_get_params_array (_tmp754_);
							_tmp756_ = _tmp755_;
							_tmp750_ = _tmp756_;
						}
						if (_tmp750_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp757_ = arg_it;
						if (vala_iterator_next (_tmp757_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp758_;
							gpointer _tmp759_;
							ValaExpression* _tmp760_;
							ValaExpression* _tmp761_;
							ValaDataType* _tmp762_;
							ValaDataType* _tmp763_;
							ValaDataType* _tmp764_;
							ValaList* _tmp765_;
							ValaDataType* _tmp766_;
							ValaDataType* _tmp767_;
							_tmp758_ = arg_it;
							_tmp759_ = vala_iterator_get (_tmp758_);
							arg = (ValaExpression*) _tmp759_;
							_tmp760_ = arg;
							_tmp761_ = arg;
							_tmp762_ = vala_expression_get_formal_target_type (_tmp761_);
							_tmp763_ = _tmp762_;
							_tmp764_ = target_object_type;
							_tmp765_ = method_type_args;
							_tmp766_ = vala_data_type_get_actual_type (_tmp763_, _tmp764_, _tmp765_, (ValaCodeNode*) self);
							_tmp767_ = _tmp766_;
							vala_expression_set_target_type (_tmp760_, _tmp767_);
							_vala_code_node_unref0 (_tmp767_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp768_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp769_ = _tmp768_;
				_tmp770_ = target_object_type;
				_tmp771_ = method_type_args;
				_tmp772_ = vala_data_type_get_actual_type (_tmp769_, _tmp770_, _tmp771_, (ValaCodeNode*) self);
				_tmp773_ = _tmp772_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp773_);
				_vala_code_node_unref0 (_tmp773_);
			}
		}
		_tmp775_ = m;
		if (_tmp775_ != NULL) {
			ValaMethod* _tmp776_;
			gboolean _tmp777_;
			gboolean _tmp778_;
			_tmp776_ = m;
			_tmp777_ = vala_method_get_coroutine (_tmp776_);
			_tmp778_ = _tmp777_;
			_tmp774_ = _tmp778_;
		} else {
			_tmp774_ = FALSE;
		}
		if (_tmp774_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp779_;
			ValaExpression* _tmp780_;
			ValaMemberAccess* _tmp781_;
			const gchar* _tmp782_;
			const gchar* _tmp783_;
			_tmp779_ = vala_method_call_get_call (self);
			_tmp780_ = _tmp779_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp780_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp781_ = ma;
			_tmp782_ = vala_member_access_get_member_name (_tmp781_);
			_tmp783_ = _tmp782_;
			if (g_strcmp0 (_tmp783_, "end") == 0) {
				ValaMethod* _tmp784_;
				ValaMethod* _tmp785_;
				ValaMethodType* _tmp786_;
				_tmp784_ = m;
				_tmp785_ = vala_method_get_end_method (_tmp784_);
				_tmp786_ = vala_method_type_new (_tmp785_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp786_;
			}
		}
	}
	_tmp787_ = vala_code_context_get_analyzer (context);
	_tmp788_ = _tmp787_;
	_tmp789_ = mtype;
	_tmp790_ = params;
	_tmp791_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp788_, (ValaExpression*) self, _tmp789_, _tmp790_, _tmp791_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp792_;
		ValaList* _tmp793_;
		gint _arg_size = 0;
		ValaList* _tmp794_;
		gint _tmp795_;
		gint _tmp796_;
		gint _arg_index = 0;
		_tmp792_ = self->priv->argument_list;
		_tmp793_ = _vala_iterable_ref0 (_tmp792_);
		_arg_list = _tmp793_;
		_tmp794_ = _arg_list;
		_tmp795_ = vala_collection_get_size ((ValaCollection*) _tmp794_);
		_tmp796_ = _tmp795_;
		_arg_size = _tmp796_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp797_;
			gpointer _tmp798_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp799_;
			gboolean _tmp800_ = FALSE;
			ValaSizeofExpression* _tmp801_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp797_ = _arg_list;
			_tmp798_ = vala_list_get (_tmp797_, _arg_index);
			arg = (ValaExpression*) _tmp798_;
			_tmp799_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp799_) ? ((ValaSizeofExpression*) _tmp799_) : NULL;
			_tmp801_ = sizeof_expr;
			if (_tmp801_ != NULL) {
				ValaSizeofExpression* _tmp802_;
				ValaDataType* _tmp803_;
				ValaDataType* _tmp804_;
				_tmp802_ = sizeof_expr;
				_tmp803_ = vala_sizeof_expression_get_type_reference (_tmp802_);
				_tmp804_ = _tmp803_;
				_tmp800_ = VALA_IS_GENERIC_TYPE (_tmp804_);
			} else {
				_tmp800_ = FALSE;
			}
			if (_tmp800_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp805_;
				ValaDataType* _tmp806_;
				ValaDataType* _tmp807_;
				ValaDataType* _tmp808_;
				ValaList* _tmp809_;
				ValaDataType* _tmp810_;
				ValaExpression* _tmp811_;
				ValaDataType* _tmp812_;
				ValaSourceReference* _tmp813_;
				ValaSourceReference* _tmp814_;
				ValaSizeofExpression* _tmp815_;
				ValaSizeofExpression* _tmp816_;
				_tmp805_ = sizeof_expr;
				_tmp806_ = vala_sizeof_expression_get_type_reference (_tmp805_);
				_tmp807_ = _tmp806_;
				_tmp808_ = target_object_type;
				_tmp809_ = method_type_args;
				_tmp810_ = vala_data_type_get_actual_type (_tmp807_, _tmp808_, _tmp809_, (ValaCodeNode*) self);
				sizeof_type = _tmp810_;
				_tmp811_ = arg;
				_tmp812_ = sizeof_type;
				_tmp813_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp814_ = _tmp813_;
				_tmp815_ = vala_sizeof_expression_new (_tmp812_, _tmp814_);
				_tmp816_ = _tmp815_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp811_, (ValaExpression*) _tmp816_);
				_vala_code_node_unref0 (_tmp816_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp819_ = base_cm;
	if (_tmp819_ != NULL) {
		ValaCreationMethod* _tmp820_;
		_tmp820_ = base_cm;
		_tmp818_ = vala_method_is_variadic ((ValaMethod*) _tmp820_);
	} else {
		_tmp818_ = FALSE;
	}
	if (_tmp818_) {
		ValaList* _tmp821_;
		gint _tmp822_;
		gint _tmp823_;
		ValaCreationMethod* _tmp824_;
		ValaList* _tmp825_;
		gint _tmp826_;
		gint _tmp827_;
		_tmp821_ = self->priv->argument_list;
		_tmp822_ = vala_collection_get_size ((ValaCollection*) _tmp821_);
		_tmp823_ = _tmp822_;
		_tmp824_ = base_cm;
		_tmp825_ = vala_callable_get_parameters ((ValaCallable*) _tmp824_);
		_tmp826_ = vala_collection_get_size ((ValaCollection*) _tmp825_);
		_tmp827_ = _tmp826_;
		_tmp817_ = _tmp823_ == _tmp827_;
	} else {
		_tmp817_ = FALSE;
	}
	if (_tmp817_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp828_;
		ValaList* _tmp829_;
		gint _tmp830_;
		gint _tmp831_;
		gpointer _tmp832_;
		gboolean _tmp833_ = FALSE;
		ValaExpression* _tmp834_;
		ValaDataType* _tmp835_;
		ValaDataType* _tmp836_;
		_tmp828_ = self->priv->argument_list;
		_tmp829_ = self->priv->argument_list;
		_tmp830_ = vala_collection_get_size ((ValaCollection*) _tmp829_);
		_tmp831_ = _tmp830_;
		_tmp832_ = vala_list_get (_tmp828_, _tmp831_ - 1);
		this_last_arg = (ValaExpression*) _tmp832_;
		_tmp834_ = this_last_arg;
		_tmp835_ = vala_expression_get_value_type (_tmp834_);
		_tmp836_ = _tmp835_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp836_)) {
			ValaExpression* _tmp837_;
			ValaDataType* _tmp838_;
			ValaDataType* _tmp839_;
			ValaTypeSymbol* _tmp840_;
			ValaTypeSymbol* _tmp841_;
			ValaSemanticAnalyzer* _tmp842_;
			ValaSemanticAnalyzer* _tmp843_;
			ValaDataType* _tmp844_;
			ValaTypeSymbol* _tmp845_;
			ValaTypeSymbol* _tmp846_;
			_tmp837_ = this_last_arg;
			_tmp838_ = vala_expression_get_value_type (_tmp837_);
			_tmp839_ = _tmp838_;
			_tmp840_ = vala_data_type_get_type_symbol (_tmp839_);
			_tmp841_ = _tmp840_;
			_tmp842_ = vala_code_context_get_analyzer (context);
			_tmp843_ = _tmp842_;
			_tmp844_ = _tmp843_->va_list_type;
			_tmp845_ = vala_data_type_get_type_symbol (_tmp844_);
			_tmp846_ = _tmp845_;
			_tmp833_ = _tmp841_ == _tmp846_;
		} else {
			_tmp833_ = FALSE;
		}
		if (_tmp833_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp847_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp848_ = _tmp847_;
	vala_code_node_check ((ValaCodeNode*) _tmp848_, context);
	_tmp849_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp850_ = _tmp849_;
	if (_tmp850_) {
		gboolean _tmp851_ = FALSE;
		ValaCodeNode* _tmp852_;
		ValaCodeNode* _tmp853_;
		_tmp852_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp853_ = _tmp852_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp853_)) {
			_tmp851_ = TRUE;
		} else {
			ValaCodeNode* _tmp854_;
			ValaCodeNode* _tmp855_;
			_tmp854_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp855_ = _tmp854_;
			_tmp851_ = VALA_IS_EXPRESSION_STATEMENT (_tmp855_);
		}
		if (_tmp851_) {
		} else {
			ValaSemanticAnalyzer* _tmp856_;
			ValaSemanticAnalyzer* _tmp857_;
			ValaSymbol* _tmp858_;
			ValaSymbol* _tmp859_;
			_tmp856_ = vala_code_context_get_analyzer (context);
			_tmp857_ = _tmp856_;
			_tmp858_ = vala_semantic_analyzer_get_current_symbol (_tmp857_);
			_tmp859_ = _tmp858_;
			if (!VALA_IS_BLOCK (_tmp859_)) {
				ValaSourceReference* _tmp860_;
				ValaSourceReference* _tmp861_;
				_tmp860_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp861_ = _tmp860_;
				vala_report_error (_tmp861_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp862_;
				ValaCodeNode* _tmp863_;
				ValaCodeNode* _tmp864_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp865_;
				ValaDataType* _tmp866_;
				ValaDataType* _tmp867_;
				ValaDataType* _tmp868_;
				gchar* _tmp869_;
				gchar* _tmp870_;
				ValaSourceReference* _tmp871_;
				ValaSourceReference* _tmp872_;
				ValaLocalVariable* _tmp873_;
				ValaLocalVariable* _tmp874_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp875_;
				ValaSourceReference* _tmp876_;
				ValaSourceReference* _tmp877_;
				ValaDeclarationStatement* _tmp878_;
				ValaSemanticAnalyzer* _tmp879_;
				ValaSemanticAnalyzer* _tmp880_;
				ValaBlock* _tmp881_;
				ValaDeclarationStatement* _tmp882_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp883_;
				ValaDataType* _tmp884_;
				ValaDataType* _tmp885_;
				ValaExpression* _tmp886_;
				ValaExpression* _tmp887_;
				ValaDataType* _tmp888_;
				ValaDataType* _tmp889_;
				ValaLocalVariable* _tmp890_;
				ValaDeclarationStatement* _tmp891_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp892_;
				ValaSemanticAnalyzer* _tmp893_;
				ValaSymbol* _tmp894_;
				ValaSymbol* _tmp895_;
				ValaBlock* _tmp896_;
				ValaBlock* _tmp897_;
				ValaLocalVariable* _tmp898_;
				ValaSemanticAnalyzer* _tmp899_;
				ValaSemanticAnalyzer* _tmp900_;
				ValaBlock* _tmp901_;
				ValaLocalVariable* _tmp902_;
				ValaCodeNode* _tmp903_;
				ValaExpression* _tmp904_;
				ValaExpression* _tmp905_;
				_tmp862_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp863_ = _tmp862_;
				_tmp864_ = _vala_code_node_ref0 (_tmp863_);
				old_parent_node = _tmp864_;
				_tmp865_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp866_ = _tmp865_;
				_tmp867_ = vala_data_type_copy (_tmp866_);
				_tmp868_ = _tmp867_;
				_tmp869_ = vala_code_node_get_temp_name ();
				_tmp870_ = _tmp869_;
				_tmp871_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp872_ = _tmp871_;
				_tmp873_ = vala_local_variable_new (_tmp868_, _tmp870_, NULL, _tmp872_);
				_tmp874_ = _tmp873_;
				_g_free0 (_tmp870_);
				_vala_code_node_unref0 (_tmp868_);
				local = _tmp874_;
				_tmp875_ = local;
				_tmp876_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp877_ = _tmp876_;
				_tmp878_ = vala_declaration_statement_new ((ValaSymbol*) _tmp875_, _tmp877_);
				decl = _tmp878_;
				_tmp879_ = vala_code_context_get_analyzer (context);
				_tmp880_ = _tmp879_;
				_tmp881_ = _tmp880_->insert_block;
				_tmp882_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp881_, (ValaStatement*) _tmp882_);
				_tmp883_ = local;
				_tmp884_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp885_ = _tmp884_;
				_tmp886_ = vala_semantic_analyzer_create_temp_access (_tmp883_, _tmp885_);
				temp_access = _tmp886_;
				_tmp887_ = temp_access;
				_tmp888_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp889_ = _tmp888_;
				vala_expression_set_formal_target_type (_tmp887_, _tmp889_);
				_tmp890_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp890_, (ValaExpression*) self);
				_tmp891_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp891_, context);
				_tmp892_ = vala_code_context_get_analyzer (context);
				_tmp893_ = _tmp892_;
				_tmp894_ = vala_semantic_analyzer_get_current_symbol (_tmp893_);
				_tmp895_ = _tmp894_;
				_tmp896_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp895_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp896_;
				_tmp897_ = block;
				_tmp898_ = local;
				vala_block_remove_local_variable (_tmp897_, _tmp898_);
				_tmp899_ = vala_code_context_get_analyzer (context);
				_tmp900_ = _tmp899_;
				_tmp901_ = _tmp900_->insert_block;
				_tmp902_ = local;
				vala_block_add_local_variable (_tmp901_, _tmp902_);
				_tmp903_ = old_parent_node;
				_tmp904_ = temp_access;
				vala_code_node_replace_expression (_tmp903_, (ValaExpression*) self, _tmp904_);
				_tmp905_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp905_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp906_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp907_ = _tmp906_;
	result = !_tmp907_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _expr_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_expr_list = _tmp18_;
		_tmp19_ = _expr_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_expr_size = _tmp21_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaExpression* _tmp24_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp22_ = _expr_list;
			_tmp23_ = vala_list_get (_tmp22_, _expr_index);
			expr = (ValaExpression*) _tmp23_;
			_tmp24_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp24_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			GString* _tmp18_;
			ValaExpression* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp15_ = _expr_list;
			_tmp16_ = vala_list_get (_tmp15_, _expr_index);
			expr = (ValaExpression*) _tmp16_;
			if (!first) {
				GString* _tmp17_;
				_tmp17_ = b;
				g_string_append (_tmp17_, ", ");
			}
			_tmp18_ = b;
			_tmp19_ = expr;
			_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			g_string_append (_tmp18_, _tmp21_);
			_g_free0 (_tmp21_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp22_ = b;
	g_string_append (_tmp22_, "))");
	_tmp23_ = b;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

