// Generated by gmmproc 2.61.1 -- DO NOT MODIFY!
#ifndef _GDKMM_CONTENTPROVIDER_H
#define _GDKMM_CONTENTPROVIDER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/bytes.h>
#include <glibmm/object.h>
#include <glibmm/refptr.h>
#include <gdkmm/contentformats.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkContentProvider = struct _GdkContentProvider;
using GdkContentProviderClass = struct _GdkContentProviderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class ContentProvider_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{

/** Provides content for data transfer between applications.
 *
 * A %Gdk::ContentProvider is used to provide content for the clipboard in
 * a number of formats.
 *
 * To create a %ContentProvider, use one of the overloaded create() methods.
 *
 * GDK knows how to handle common text and image formats out-of-the-box. See
 * Gdk::ContentSerializer and Gdk::ContentDeserializer if you want to add support
 * for application-specific data formats.
 *
 * @see Gdk::ContentSerializer, Gdk::ContentDeserializer
 *
 * @newin{3,94}
 */

class ContentProvider : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = ContentProvider;
  using CppClassType = ContentProvider_Class;
  using BaseObjectType = GdkContentProvider;
  using BaseClassType = GdkContentProviderClass;

  // noncopyable
  ContentProvider(const ContentProvider&) = delete;
  ContentProvider& operator=(const ContentProvider&) = delete;

private:  friend class ContentProvider_Class;
  static CppClassType contentprovider_class_;

protected:
  explicit ContentProvider(const Glib::ConstructParams& construct_params);
  explicit ContentProvider(GdkContentProvider* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  ContentProvider(ContentProvider&& src) noexcept;
  ContentProvider& operator=(ContentProvider&& src) noexcept;

  ~ContentProvider() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkContentProvider*       gobj()       { return reinterpret_cast<GdkContentProvider*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkContentProvider* gobj() const { return reinterpret_cast<GdkContentProvider*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkContentProvider* gobj_copy();

private:


public:
  // _WRAP_METHOD is used for the create() methods because the gdk_content_provider_new_for_*()
  // functions do more than call g_object_new().
  
  /** Create a content provider that provides the given @a bytes as data for
   * the given @a mime_type.
   * 
   * @param mime_type The mime type.
   * @param bytes A Bytes with the data for @a mime_type.
   * @return A new Gdk::ContentProvider.
   */
  static Glib::RefPtr<ContentProvider> create(const Glib::ustring& mime_type, const Glib::RefPtr<const Glib::Bytes>& bytes);
  
  /** Create a content provider that provides the given @a value.
   * 
   * @param value A Value.
   * @return A new Gdk::ContentProvider.
   */
  static Glib::RefPtr<ContentProvider> create(const Glib::ValueBase& value);

  // ref_formats() and ref_storable_formats() are const because they return
  // newly created ContentFormats instances.
  
  /** Gets the formats that the provider can provide its current contents in.
   * 
   * @return The formats of the provider.
   */
  Glib::RefPtr<ContentFormats> ref_formats() const;
  
  /** Gets the formats that the provider suggests other applications to store
   * the data in.  
   * An example of such an application would be a clipboard manager.
   * 
   * This can be assumed to be a subset of ref_formats().
   * 
   * @return The storable formats of the provider.
   */
  Glib::RefPtr<ContentFormats> ref_storable_formats() const;

  
  /** Emits the Gdk::ContentProvider::signal_contents_changed() signal.
   */
  void content_changed();

  /** The possible formats that the provider can provide its data in.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ContentFormats> > property_formats() const;


  /** The subset of formats that clipboard managers should store this provider's data in.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ContentFormats> > property_storable_formats() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%content_changed()</tt>
   *
   * Flags: Run Last
   *
   */

  Glib::SignalProxy<void()> signal_content_changed();


  // GdkContentProvider contains vfuncs, but it's no use wrapping them as long as
  // there is no constructor that calls g_object_new() to create a gtkmm__GdkContentProvider
  // instance. A GdkContentProvider instance never calls an overriding vfunc in
  // Gdk::ContentProvider.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_content_changed().
  virtual void on_content_changed();


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::ContentProvider
   */
  Glib::RefPtr<Gdk::ContentProvider> wrap(GdkContentProvider* object, bool take_copy = false);
}


#endif /* _GDKMM_CONTENTPROVIDER_H */

