/* rygel-dlna-available-seek-response.c generated by valac 0.44.9, the Vala compiler
 * generated from rygel-dlna-available-seek-response.vala, do not modify */

/*
 * Copyright (C) 2014  Cable Television Laboratories, Inc.
 * Contact: http://www.cablelabs.com/
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelHTTPResponseElementPrivate RygelHTTPResponseElementPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE (rygel_dlna_available_seek_range_response_get_type ())
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponse))
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponseClass))
#define RYGEL_IS_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE))
#define RYGEL_IS_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE))
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponseClass))

typedef struct _RygelDLNAAvailableSeekRangeResponse RygelDLNAAvailableSeekRangeResponse;
typedef struct _RygelDLNAAvailableSeekRangeResponseClass RygelDLNAAvailableSeekRangeResponseClass;
typedef struct _RygelDLNAAvailableSeekRangeResponsePrivate RygelDLNAAvailableSeekRangeResponsePrivate;
enum  {
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_0_PROPERTY,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE_PROPERTY,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME_PROPERTY,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME_PROPERTY,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE_PROPERTY,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE_PROPERTY,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH_PROPERTY,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_NUM_PROPERTIES];
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelHTTPResponseElement {
	GObject parent_instance;
	RygelHTTPResponseElementPrivate * priv;
};

struct _RygelHTTPResponseElementClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
	gchar* (*to_string) (RygelHTTPResponseElement* self);
};

struct _RygelDLNAAvailableSeekRangeResponse {
	RygelHTTPResponseElement parent_instance;
	RygelDLNAAvailableSeekRangeResponsePrivate * priv;
};

struct _RygelDLNAAvailableSeekRangeResponseClass {
	RygelHTTPResponseElementClass parent_class;
};

struct _RygelDLNAAvailableSeekRangeResponsePrivate {
	gint _mode;
	gint64 _start_time;
	gint64 _end_time;
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

static gint RygelDLNAAvailableSeekRangeResponse_private_offset;
static gpointer rygel_dlna_available_seek_range_response_parent_class = NULL;

GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPResponseElement, g_object_unref)
GType rygel_http_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPRequest, g_object_unref)
GType rygel_dlna_available_seek_range_response_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelDLNAAvailableSeekRangeResponse, g_object_unref)
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_AVAILABLE_SEEK_RANGE_HEADER "availableSeekRange.dlna.org"
RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_new (gint mode,
                                                                                   gint64 start_time,
                                                                                   gint64 end_time,
                                                                                   gint64 start_byte,
                                                                                   gint64 end_byte);
RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_construct (GType object_type,
                                                                                         gint mode,
                                                                                         gint64 start_time,
                                                                                         gint64 end_time,
                                                                                         gint64 start_byte,
                                                                                         gint64 end_byte);
RygelHTTPResponseElement* rygel_http_response_element_construct (GType object_type);
static void rygel_dlna_available_seek_range_response_set_mode (RygelDLNAAvailableSeekRangeResponse* self,
                                                        gint value);
static void rygel_dlna_available_seek_range_response_set_start_time (RygelDLNAAvailableSeekRangeResponse* self,
                                                              gint64 value);
static void rygel_dlna_available_seek_range_response_set_end_time (RygelDLNAAvailableSeekRangeResponse* self,
                                                            gint64 value);
static void rygel_dlna_available_seek_range_response_set_start_byte (RygelDLNAAvailableSeekRangeResponse* self,
                                                              gint64 value);
static void rygel_dlna_available_seek_range_response_set_end_byte (RygelDLNAAvailableSeekRangeResponse* self,
                                                            gint64 value);
static void rygel_dlna_available_seek_range_response_set_range_length (RygelDLNAAvailableSeekRangeResponse* self,
                                                                gint64 value);
RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_new_time_only (gint mode,
                                                                                             gint64 start_time,
                                                                                             gint64 end_time);
RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_construct_time_only (GType object_type,
                                                                                                   gint mode,
                                                                                                   gint64 start_time,
                                                                                                   gint64 end_time);
#define RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED ((gint64) -1)
static void rygel_dlna_available_seek_range_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                                         RygelHTTPRequest* request);
static gchar* rygel_dlna_available_seek_range_response_get_response_string (RygelDLNAAvailableSeekRangeResponse* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPServer, g_object_unref)
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPItemURI, g_object_unref)
GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelClientHacks, g_object_unref)
gint64 rygel_dlna_available_seek_range_response_get_start_time (RygelDLNAAvailableSeekRangeResponse* self);
gint rygel_dlna_available_seek_range_response_get_mode (RygelDLNAAvailableSeekRangeResponse* self);
gint64 rygel_dlna_available_seek_range_response_get_end_time (RygelDLNAAvailableSeekRangeResponse* self);
gint64 rygel_dlna_available_seek_range_response_get_start_byte (RygelDLNAAvailableSeekRangeResponse* self);
gint64 rygel_dlna_available_seek_range_response_get_end_byte (RygelDLNAAvailableSeekRangeResponse* self);
static gchar* rygel_dlna_available_seek_range_response_real_to_string (RygelHTTPResponseElement* base);
gint64 rygel_dlna_available_seek_range_response_get_range_length (RygelDLNAAvailableSeekRangeResponse* self);
static void rygel_dlna_available_seek_range_response_finalize (GObject * obj);
static void _vala_rygel_dlna_available_seek_range_response_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_rygel_dlna_available_seek_range_response_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);

static inline gpointer
rygel_dlna_available_seek_range_response_get_instance_private (RygelDLNAAvailableSeekRangeResponse* self)
{
	return G_STRUCT_MEMBER_P (self, RygelDLNAAvailableSeekRangeResponse_private_offset);
}

RygelDLNAAvailableSeekRangeResponse*
rygel_dlna_available_seek_range_response_construct (GType object_type,
                                                    gint mode,
                                                    gint64 start_time,
                                                    gint64 end_time,
                                                    gint64 start_byte,
                                                    gint64 end_byte)
{
	RygelDLNAAvailableSeekRangeResponse * self = NULL;
	self = (RygelDLNAAvailableSeekRangeResponse*) rygel_http_response_element_construct (object_type);
	rygel_dlna_available_seek_range_response_set_mode (self, mode);
	rygel_dlna_available_seek_range_response_set_start_time (self, start_time);
	rygel_dlna_available_seek_range_response_set_end_time (self, end_time);
	rygel_dlna_available_seek_range_response_set_start_byte (self, start_byte);
	rygel_dlna_available_seek_range_response_set_end_byte (self, end_byte);
	rygel_dlna_available_seek_range_response_set_range_length (self, (end_byte - start_byte) + 1);
	return self;
}

RygelDLNAAvailableSeekRangeResponse*
rygel_dlna_available_seek_range_response_new (gint mode,
                                              gint64 start_time,
                                              gint64 end_time,
                                              gint64 start_byte,
                                              gint64 end_byte)
{
	return rygel_dlna_available_seek_range_response_construct (RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, mode, start_time, end_time, start_byte, end_byte);
}

RygelDLNAAvailableSeekRangeResponse*
rygel_dlna_available_seek_range_response_construct_time_only (GType object_type,
                                                              gint mode,
                                                              gint64 start_time,
                                                              gint64 end_time)
{
	RygelDLNAAvailableSeekRangeResponse * self = NULL;
	self = (RygelDLNAAvailableSeekRangeResponse*) rygel_http_response_element_construct (object_type);
	rygel_dlna_available_seek_range_response_set_mode (self, mode);
	rygel_dlna_available_seek_range_response_set_start_time (self, start_time);
	rygel_dlna_available_seek_range_response_set_end_time (self, end_time);
	rygel_dlna_available_seek_range_response_set_range_length (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	rygel_dlna_available_seek_range_response_set_end_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	rygel_dlna_available_seek_range_response_set_start_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	return self;
}

RygelDLNAAvailableSeekRangeResponse*
rygel_dlna_available_seek_range_response_new_time_only (gint mode,
                                                        gint64 start_time,
                                                        gint64 end_time)
{
	return rygel_dlna_available_seek_range_response_construct_time_only (RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, mode, start_time, end_time);
}

static void
rygel_dlna_available_seek_range_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                                    RygelHTTPRequest* request)
{
	RygelDLNAAvailableSeekRangeResponse * self;
	gchar* response = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (RygelDLNAAvailableSeekRangeResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = rygel_dlna_available_seek_range_response_get_response_string (self);
	response = _tmp0_;
	_tmp1_ = response;
	if (_tmp1_ != NULL) {
		SoupMessage* _tmp2_;
		SoupMessageHeaders* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = request->msg;
		_tmp3_ = _tmp2_->response_headers;
		_tmp4_ = response;
		soup_message_headers_append (_tmp3_, RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_AVAILABLE_SEEK_RANGE_HEADER, _tmp4_);
	}
	_g_free0 (response);
}

static gchar*
rygel_dlna_available_seek_range_response_get_response_string (RygelDLNAAvailableSeekRangeResponse* self)
{
	gint64 _tmp0_;
	GString* response = NULL;
	GString* _tmp1_;
	GString* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	gint64 _tmp8_;
	GString* _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	GString* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_start_time;
	if (_tmp0_ == RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_string_new ("");
	response = _tmp1_;
	_tmp2_ = response;
	_tmp3_ = self->priv->_mode;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = response;
	g_string_append (_tmp6_, " npt=");
	_tmp7_ = response;
	_tmp8_ = self->priv->_start_time;
	g_string_append_printf (_tmp7_, "%.3f-", ((gdouble) _tmp8_) / G_TIME_SPAN_SECOND);
	_tmp9_ = response;
	_tmp10_ = self->priv->_end_time;
	g_string_append_printf (_tmp9_, "%.3f", ((gdouble) _tmp10_) / G_TIME_SPAN_SECOND);
	_tmp11_ = self->priv->_start_byte;
	if (_tmp11_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		GString* _tmp12_;
		GString* _tmp13_;
		gint64 _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GString* _tmp17_;
		GString* _tmp18_;
		gint64 _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp12_ = response;
		g_string_append (_tmp12_, " bytes=");
		_tmp13_ = response;
		_tmp14_ = self->priv->_start_byte;
		_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp14_);
		_tmp16_ = _tmp15_;
		g_string_append (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = response;
		g_string_append (_tmp17_, "-");
		_tmp18_ = response;
		_tmp19_ = self->priv->_end_byte;
		_tmp20_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp19_);
		_tmp21_ = _tmp20_;
		g_string_append (_tmp18_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = response;
	_tmp23_ = _tmp22_->str;
	_tmp24_ = g_strdup (_tmp23_);
	result = _tmp24_;
	_g_string_free0 (response);
	return result;
}

static gchar*
rygel_dlna_available_seek_range_response_real_to_string (RygelHTTPResponseElement* base)
{
	RygelDLNAAvailableSeekRangeResponse * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	self = (RygelDLNAAvailableSeekRangeResponse*) base;
	_tmp0_ = rygel_dlna_available_seek_range_response_get_response_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("HTTPTimeSeekResponse (%s)", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gint
rygel_dlna_available_seek_range_response_get_mode (RygelDLNAAvailableSeekRangeResponse* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

static void
rygel_dlna_available_seek_range_response_set_mode (RygelDLNAAvailableSeekRangeResponse* self,
                                                   gint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dlna_available_seek_range_response_get_mode (self) != value) {
		self->priv->_mode = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE_PROPERTY]);
	}
}

gint64
rygel_dlna_available_seek_range_response_get_start_time (RygelDLNAAvailableSeekRangeResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_time;
	return result;
}

static void
rygel_dlna_available_seek_range_response_set_start_time (RygelDLNAAvailableSeekRangeResponse* self,
                                                         gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dlna_available_seek_range_response_get_start_time (self) != value) {
		self->priv->_start_time = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME_PROPERTY]);
	}
}

gint64
rygel_dlna_available_seek_range_response_get_end_time (RygelDLNAAvailableSeekRangeResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_time;
	return result;
}

static void
rygel_dlna_available_seek_range_response_set_end_time (RygelDLNAAvailableSeekRangeResponse* self,
                                                       gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dlna_available_seek_range_response_get_end_time (self) != value) {
		self->priv->_end_time = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME_PROPERTY]);
	}
}

gint64
rygel_dlna_available_seek_range_response_get_start_byte (RygelDLNAAvailableSeekRangeResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_byte;
	return result;
}

static void
rygel_dlna_available_seek_range_response_set_start_byte (RygelDLNAAvailableSeekRangeResponse* self,
                                                         gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dlna_available_seek_range_response_get_start_byte (self) != value) {
		self->priv->_start_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE_PROPERTY]);
	}
}

gint64
rygel_dlna_available_seek_range_response_get_end_byte (RygelDLNAAvailableSeekRangeResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_byte;
	return result;
}

static void
rygel_dlna_available_seek_range_response_set_end_byte (RygelDLNAAvailableSeekRangeResponse* self,
                                                       gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dlna_available_seek_range_response_get_end_byte (self) != value) {
		self->priv->_end_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE_PROPERTY]);
	}
}

gint64
rygel_dlna_available_seek_range_response_get_range_length (RygelDLNAAvailableSeekRangeResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_range_length;
	return result;
}

static void
rygel_dlna_available_seek_range_response_set_range_length (RygelDLNAAvailableSeekRangeResponse* self,
                                                           gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dlna_available_seek_range_response_get_range_length (self) != value) {
		self->priv->_range_length = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH_PROPERTY]);
	}
}

static void
rygel_dlna_available_seek_range_response_class_init (RygelDLNAAvailableSeekRangeResponseClass * klass,
                                                     gpointer klass_data)
{
	rygel_dlna_available_seek_range_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelDLNAAvailableSeekRangeResponse_private_offset);
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = (void (*) (RygelHTTPResponseElement*, RygelHTTPRequest*)) rygel_dlna_available_seek_range_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = (gchar* (*) (RygelHTTPResponseElement*)) rygel_dlna_available_seek_range_response_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dlna_available_seek_range_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dlna_available_seek_range_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_dlna_available_seek_range_response_finalize;
	/**
	     * The Limited Operation mode (0 or 1)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE_PROPERTY, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE_PROPERTY] = g_param_spec_int ("mode", "mode", "mode", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Available range start time, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME_PROPERTY, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME_PROPERTY] = g_param_spec_int64 ("start-time", "start-time", "start-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Available range end time, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME_PROPERTY, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME_PROPERTY] = g_param_spec_int64 ("end-time", "end-time", "end-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The start of the available range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE_PROPERTY, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE_PROPERTY] = g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The end of the available range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE_PROPERTY, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE_PROPERTY] = g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the available range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH_PROPERTY, rygel_dlna_available_seek_range_response_properties[RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH_PROPERTY] = g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_dlna_available_seek_range_response_instance_init (RygelDLNAAvailableSeekRangeResponse * self,
                                                        gpointer klass)
{
	self->priv = rygel_dlna_available_seek_range_response_get_instance_private (self);
}

static void
rygel_dlna_available_seek_range_response_finalize (GObject * obj)
{
	RygelDLNAAvailableSeekRangeResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponse);
	G_OBJECT_CLASS (rygel_dlna_available_seek_range_response_parent_class)->finalize (obj);
}

GType
rygel_dlna_available_seek_range_response_get_type (void)
{
	static volatile gsize rygel_dlna_available_seek_range_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dlna_available_seek_range_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDLNAAvailableSeekRangeResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dlna_available_seek_range_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDLNAAvailableSeekRangeResponse), 0, (GInstanceInitFunc) rygel_dlna_available_seek_range_response_instance_init, NULL };
		GType rygel_dlna_available_seek_range_response_type_id;
		rygel_dlna_available_seek_range_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelDLNAAvailableSeekRangeResponse", &g_define_type_info, 0);
		RygelDLNAAvailableSeekRangeResponse_private_offset = g_type_add_instance_private (rygel_dlna_available_seek_range_response_type_id, sizeof (RygelDLNAAvailableSeekRangeResponsePrivate));
		g_once_init_leave (&rygel_dlna_available_seek_range_response_type_id__volatile, rygel_dlna_available_seek_range_response_type_id);
	}
	return rygel_dlna_available_seek_range_response_type_id__volatile;
}

static void
_vala_rygel_dlna_available_seek_range_response_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	RygelDLNAAvailableSeekRangeResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponse);
	switch (property_id) {
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE_PROPERTY:
		g_value_set_int (value, rygel_dlna_available_seek_range_response_get_mode (self));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME_PROPERTY:
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_start_time (self));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME_PROPERTY:
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_end_time (self));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_start_byte (self));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_end_byte (self));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH_PROPERTY:
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_range_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_dlna_available_seek_range_response_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	RygelDLNAAvailableSeekRangeResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponse);
	switch (property_id) {
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE_PROPERTY:
		rygel_dlna_available_seek_range_response_set_mode (self, g_value_get_int (value));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME_PROPERTY:
		rygel_dlna_available_seek_range_response_set_start_time (self, g_value_get_int64 (value));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME_PROPERTY:
		rygel_dlna_available_seek_range_response_set_end_time (self, g_value_get_int64 (value));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE_PROPERTY:
		rygel_dlna_available_seek_range_response_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE_PROPERTY:
		rygel_dlna_available_seek_range_response_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH_PROPERTY:
		rygel_dlna_available_seek_range_response_set_range_length (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

