/* testcollection.c generated by valac 0.44.7, the Vala compiler
 * generated from testcollection.vala, do not modify */

/* testcollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 * Copyright (C) 2011-2013  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 *      Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;
enum  {
	COLLECTION_TESTS_0_PROPERTY,
	COLLECTION_TESTS_NUM_PROPERTIES
};
static GParamSpec* collection_tests_properties[COLLECTION_TESTS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*GeeTestCaseTestMethod) (gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	CollectionTests* self;
	gint count;
	GeeIterator* test_iterator;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint i;
};

struct _Block3Data {
	int _ref_count_;
	CollectionTests* self;
	GeeIterator* test_iterator;
};

struct _Block4Data {
	int _ref_count_;
	CollectionTests* self;
	GeeIterator* iter;
	gint i;
	gint j;
	GeeIterator* test_iterator;
};

struct _Block5Data {
	int _ref_count_;
	CollectionTests* self;
	gboolean one;
	gboolean two;
	gboolean three;
};

struct _Block6Data {
	int _ref_count_;
	CollectionTests* self;
	gboolean one;
	gboolean two;
	gboolean three;
};

static gpointer collection_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
CollectionTests* collection_tests_construct (GType object_type,
                                             const gchar* name);
GeeTestCase* gee_test_case_construct (GType object_type,
                                      const gchar* name);
void gee_test_case_add_test (GeeTestCase* self,
                             const gchar* name,
                             GeeTestCaseTestMethod test,
                             gpointer test_target,
                             GDestroyNotify test_target_destroy_notify);
void collection_tests_test_type_correctness (CollectionTests* self);
static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self);
static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self);
void collection_tests_test_mutable_iterator (CollectionTests* self);
static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_size_and_is_empty (CollectionTests* self);
static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_remove (CollectionTests* self);
static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self);
void collection_tests_test_clear (CollectionTests* self);
static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_all (CollectionTests* self);
static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_all (CollectionTests* self);
static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_remove_all (CollectionTests* self);
static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_retain_all (CollectionTests* self);
static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_to_array (CollectionTests* self);
static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self);
void collection_tests_test_gobject_properties (CollectionTests* self);
static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
void collection_tests_test_foreach (CollectionTests* self);
static void _collection_tests_test_foreach_gee_test_case_test_method (gpointer self);
void collection_tests_test_fold (CollectionTests* self);
static void _collection_tests_test_fold_gee_test_case_test_method (gpointer self);
void collection_tests_test_map (CollectionTests* self);
static void _collection_tests_test_map_gee_test_case_test_method (gpointer self);
void collection_tests_test_scan (CollectionTests* self);
static void _collection_tests_test_scan_gee_test_case_test_method (gpointer self);
void collection_tests_test_filter (CollectionTests* self);
static void _collection_tests_test_filter_gee_test_case_test_method (gpointer self);
void collection_tests_test_chop (CollectionTests* self);
static void _collection_tests_test_chop_gee_test_case_test_method (gpointer self);
void collection_tests_test_first_match (CollectionTests* self);
static void _collection_tests_test_first_match_gee_test_case_test_method (gpointer self);
void collection_tests_test_any_match (CollectionTests* self);
static void _collection_tests_test_any_match_gee_test_case_test_method (gpointer self);
void collection_tests_test_all_match (CollectionTests* self);
static void _collection_tests_test_all_match_gee_test_case_test_method (gpointer self);
void collection_tests_test_max_min (CollectionTests* self);
static void _collection_tests_test_max_min_gee_test_case_test_method (gpointer self);
void collection_tests_test_order_by (CollectionTests* self);
static void _collection_tests_test_order_by_gee_test_case_test_method (gpointer self);
gchar** test_data_get_data (gint* result_length1);
guint* test_data_get_drawn_numbers (gint* result_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda5_ (CollectionTests* self,
                     gchar* x);
static gboolean ___lambda5__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean __lambda6_ (CollectionTests* self,
                     gchar* x);
static gboolean ___lambda6__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean __lambda7_ (Block1Data* _data1_,
                     gchar* x);
static gboolean ___lambda7__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean __lambda8_ (Block1Data* _data1_,
                     gchar* x);
static gboolean ___lambda8__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean __lambda9_ (Block1Data* _data1_,
                     gchar* x);
static gboolean ___lambda9__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean __lambda10_ (Block1Data* _data1_,
                      gchar* x);
static gboolean ___lambda10__gee_forall_func (gpointer g,
                                       gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _____lambda11_ (Block2Data* _data2_,
                         gchar* x);
static gboolean ______lambda11__gee_forall_func (gpointer g,
                                          gpointer self);
static gboolean _____lambda12_ (Block2Data* _data2_,
                         gchar* x);
static gboolean ______lambda12__gee_forall_func (gpointer g,
                                          gpointer self);
static gboolean _____lambda13_ (Block2Data* _data2_,
                         gchar* x);
static gboolean ______lambda13__gee_forall_func (gpointer g,
                                          gpointer self);
static gboolean _____lambda14_ (Block2Data* _data2_,
                         gchar* x);
static gboolean ______lambda14__gee_forall_func (gpointer g,
                                          gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gint __lambda15_ (CollectionTests* self,
                  gchar* x,
                  gint y);
static gpointer ___lambda15__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gint __lambda16_ (CollectionTests* self,
                  gchar* x,
                  gint y);
static gpointer ___lambda16__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gint __lambda17_ (Block3Data* _data3_,
                  gchar* x,
                  gint y);
static gpointer ___lambda17__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gint __lambda18_ (Block3Data* _data3_,
                  gchar* x,
                  gint y);
static gpointer ___lambda18__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gint __lambda19_ (Block3Data* _data3_,
                  gchar* x,
                  gint y);
static gpointer ___lambda19__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gint __lambda20_ (Block3Data* _data3_,
                  gchar* x,
                  gint y);
static gpointer ___lambda20__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gint __lambda21_ (CollectionTests* self,
                  gchar* str);
static gpointer ___lambda21__gee_map_func (gpointer g,
                                    gpointer self);
static gint __lambda22_ (CollectionTests* self,
                  gchar* str);
static gpointer ___lambda22__gee_map_func (gpointer g,
                                    gpointer self);
static gint __lambda23_ (Block4Data* _data4_,
                  gchar* str);
static gpointer ___lambda23__gee_map_func (gpointer g,
                                    gpointer self);
static gboolean __lambda24_ (Block4Data* _data4_,
                      gchar* str);
static gboolean ___lambda24__gee_forall_func (gpointer g,
                                       gpointer self);
static gint __lambda25_ (Block4Data* _data4_,
                  gchar* str);
static gpointer ___lambda25__gee_map_func (gpointer g,
                                    gpointer self);
static gboolean __lambda26_ (Block4Data* _data4_,
                      gchar* str);
static gboolean ___lambda26__gee_forall_func (gpointer g,
                                       gpointer self);
static gint __lambda27_ (Block4Data* _data4_,
                  gchar* str);
static gpointer ___lambda27__gee_map_func (gpointer g,
                                    gpointer self);
static gboolean __lambda28_ (Block4Data* _data4_,
                      gchar* str);
static gboolean ___lambda28__gee_forall_func (gpointer g,
                                       gpointer self);
static gint __lambda29_ (Block4Data* _data4_,
                  gchar* str);
static gpointer ___lambda29__gee_map_func (gpointer g,
                                    gpointer self);
static gboolean __lambda30_ (Block4Data* _data4_,
                      gchar* str);
static gboolean ___lambda30__gee_forall_func (gpointer g,
                                       gpointer self);
static gint __lambda31_ (Block4Data* _data4_,
                  gchar* str);
static gpointer ___lambda31__gee_map_func (gpointer g,
                                    gpointer self);
static gint __lambda32_ (Block4Data* _data4_,
                  gchar* str);
static gpointer ___lambda32__gee_map_func (gpointer g,
                                    gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gint __lambda33_ (Block5Data* _data5_,
                  gchar* str,
                  gint cur);
static gpointer ___lambda33__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gint __lambda34_ (Block5Data* _data5_,
                  gchar* str,
                  gint cur);
static gpointer ___lambda34__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean __lambda35_ (Block6Data* _data6_,
                      const gchar* str);
static gboolean ___lambda35__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda36_ (Block6Data* _data6_,
                      const gchar* str);
static gboolean ___lambda36__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda37_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda37__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda38_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda38__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda39_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda39__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda40_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda40__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda41_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda41__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda42_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda42__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda43_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda43__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda44_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda44__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda45_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda45__gee_predicate (gconstpointer g,
                                     gpointer self);
static gboolean __lambda46_ (CollectionTests* self,
                      const gchar* x);
static gboolean ___lambda46__gee_predicate (gconstpointer g,
                                     gpointer self);
static gint __lambda47_ (CollectionTests* self,
                  const gchar* a,
                  const gchar* b);
static gint ___lambda47__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gint __lambda48_ (CollectionTests* self,
                  const gchar* a,
                  const gchar* b);
static gint ___lambda48__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gint __lambda49_ (CollectionTests* self,
                  const gchar* a,
                  const gchar* b);
static gint ___lambda49__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void collection_tests_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static void
_collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_type_correctness ((CollectionTests*) self);
}

static void
_collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_iterator_returns_all_elements_once ((CollectionTests*) self);
}

static void
_collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_mutable_iterator ((CollectionTests*) self);
}

static void
_collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_contains_size_and_is_empty ((CollectionTests*) self);
}

static void
_collection_tests_test_add_remove_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_add_remove ((CollectionTests*) self);
}

static void
_collection_tests_test_clear_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_clear ((CollectionTests*) self);
}

static void
_collection_tests_test_add_all_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_add_all ((CollectionTests*) self);
}

static void
_collection_tests_test_contains_all_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_contains_all ((CollectionTests*) self);
}

static void
_collection_tests_test_remove_all_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_remove_all ((CollectionTests*) self);
}

static void
_collection_tests_test_retain_all_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_retain_all ((CollectionTests*) self);
}

static void
_collection_tests_test_to_array_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_to_array ((CollectionTests*) self);
}

static void
_collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_gobject_properties ((CollectionTests*) self);
}

static void
_collection_tests_test_foreach_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_foreach ((CollectionTests*) self);
}

static void
_collection_tests_test_fold_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_fold ((CollectionTests*) self);
}

static void
_collection_tests_test_map_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_map ((CollectionTests*) self);
}

static void
_collection_tests_test_scan_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_scan ((CollectionTests*) self);
}

static void
_collection_tests_test_filter_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_filter ((CollectionTests*) self);
}

static void
_collection_tests_test_chop_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_chop ((CollectionTests*) self);
}

static void
_collection_tests_test_first_match_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_first_match ((CollectionTests*) self);
}

static void
_collection_tests_test_any_match_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_any_match ((CollectionTests*) self);
}

static void
_collection_tests_test_all_match_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_all_match ((CollectionTests*) self);
}

static void
_collection_tests_test_max_min_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_max_min ((CollectionTests*) self);
}

static void
_collection_tests_test_order_by_gee_test_case_test_method (gpointer self)
{
	collection_tests_test_order_by ((CollectionTests*) self);
}

CollectionTests*
collection_tests_construct (GType object_type,
                            const gchar* name)
{
	CollectionTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (CollectionTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] type correctness", _collection_tests_test_type_correctness_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator returns all elements once", _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] mutable iterator", _collection_tests_test_mutable_iterator_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains, size and is_empty", _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add and remove", _collection_tests_test_add_remove_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _collection_tests_test_clear_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add_all", _collection_tests_test_add_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains_all", _collection_tests_test_contains_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove_all", _collection_tests_test_remove_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] retain_all", _collection_tests_test_retain_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] to_array", _collection_tests_test_to_array_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] GObject properties", _collection_tests_test_gobject_properties_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] foreach", _collection_tests_test_foreach_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] fold", _collection_tests_test_fold_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] map", _collection_tests_test_map_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] scan", _collection_tests_test_scan_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] filter", _collection_tests_test_filter_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] chop", _collection_tests_test_chop_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] first_match", _collection_tests_test_first_match_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] any_match", _collection_tests_test_any_match_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] all_match", _collection_tests_test_all_match_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] max_min", _collection_tests_test_max_min_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] order_by", _collection_tests_test_order_by_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	return self;
}

void
collection_tests_test_type_correctness (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GType _tmp2_;
	GType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ == G_TYPE_STRING, "test_collection.element_type == typeof (string)");
}

void
collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	gboolean has_next = FALSE;
	GeeIterator* iterator = NULL;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	gchar** data = NULL;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint data_length1;
	gint _data_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	guint* found_times = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	guint* _tmp11_;
	gint found_times_length1;
	gint _found_times_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_vala_assert (!gee_iterator_has_next (_tmp3_), "! iterator.has_next ()");
	_tmp4_ = iterator;
	_vala_assert (!gee_iterator_next (_tmp4_), "! iterator.next ()");
	_tmp6_ = test_data_get_data (&_tmp5_);
	data = _tmp6_;
	data_length1 = _tmp5_;
	_data_size_ = data_length1;
	_tmp7_ = data;
	_tmp7__length1 = data_length1;
	{
		gchar** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = _tmp7_;
		el_collection_length1 = _tmp7__length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			const gchar* el = NULL;
			el = el_collection[el_it];
			{
				GeeCollection* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = self->test_collection;
				_tmp9_ = el;
				_vala_assert (gee_collection_add (_tmp8_, _tmp9_), "test_collection.add (el)");
			}
		}
	}
	_tmp10_ = data;
	_tmp10__length1 = data_length1;
	_tmp11_ = g_new0 (guint, _tmp10__length1);
	found_times = _tmp11_;
	found_times_length1 = _tmp10__length1;
	_found_times_size_ = found_times_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GeeCollection* _tmp18_;
				GeeIterator* _tmp19_;
				gboolean valid = FALSE;
				GeeIterator* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
				GeeIterator* _tmp44_;
				GeeIterator* _tmp45_;
				gboolean _tmp46_;
				gboolean _tmp47_;
				GeeIterator* _tmp48_;
				GeeIterator* _tmp49_;
				gboolean _tmp50_;
				gboolean _tmp51_;
				guint* _tmp52_;
				gint _tmp52__length1;
				if (!_tmp12_) {
					guint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < ((guint) 2))) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							guint* _tmp16_;
							gint _tmp16__length1;
							guint* _tmp17_;
							gint _tmp17__length1;
							if (!_tmp14_) {
								guint _tmp15_;
								_tmp15_ = j;
								j = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp16_ = found_times;
							_tmp16__length1 = found_times_length1;
							if (!(j < ((guint) _tmp16__length1))) {
								break;
							}
							_tmp17_ = found_times;
							_tmp17__length1 = found_times_length1;
							_tmp17_[j] = (guint) 0;
						}
					}
				}
				_tmp18_ = self->test_collection;
				_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
				_g_object_unref0 (iterator);
				iterator = _tmp19_;
				_tmp20_ = iterator;
				_tmp21_ = gee_iterator_get_valid (_tmp20_);
				_tmp22_ = _tmp21_;
				valid = _tmp22_;
				_vala_assert (!valid, "! valid");
				while (TRUE) {
					GeeIterator* _tmp23_;
					GeeIterator* _tmp24_;
					gboolean _tmp25_;
					gboolean _tmp26_;
					GeeIterator* _tmp27_;
					GeeIterator* _tmp28_;
					gboolean _tmp29_;
					gboolean _tmp30_;
					gchar* element = NULL;
					GeeIterator* _tmp31_;
					gpointer _tmp32_;
					GeeIterator* _tmp33_;
					gboolean _tmp34_;
					gboolean _tmp35_;
					_tmp23_ = iterator;
					has_next = gee_iterator_has_next (_tmp23_);
					_tmp24_ = iterator;
					_tmp25_ = gee_iterator_get_valid (_tmp24_);
					_tmp26_ = _tmp25_;
					_vala_assert (valid == _tmp26_, "valid == iterator.valid");
					_tmp27_ = iterator;
					_vala_assert (has_next == gee_iterator_next (_tmp27_), "has_next == iterator.next ()");
					_tmp28_ = iterator;
					_tmp29_ = gee_iterator_get_valid (_tmp28_);
					_tmp30_ = _tmp29_;
					valid = _tmp30_;
					_vala_assert (valid, "valid = iterator.valid");
					if (!has_next) {
						break;
					}
					_tmp31_ = iterator;
					_tmp32_ = gee_iterator_get (_tmp31_);
					element = (gchar*) _tmp32_;
					_tmp33_ = iterator;
					_tmp34_ = gee_iterator_get_valid (_tmp33_);
					_tmp35_ = _tmp34_;
					_vala_assert (_tmp35_, "iterator.valid");
					{
						guint element_idx = 0U;
						element_idx = (guint) 0;
						{
							gboolean _tmp36_ = FALSE;
							_tmp36_ = TRUE;
							while (TRUE) {
								gchar** _tmp38_;
								gint _tmp38__length1;
								gchar** _tmp39_;
								gint _tmp39__length1;
								const gchar* _tmp40_;
								const gchar* _tmp41_;
								if (!_tmp36_) {
									guint _tmp37_;
									_tmp37_ = element_idx;
									element_idx = _tmp37_ + 1;
								}
								_tmp36_ = FALSE;
								_tmp38_ = data;
								_tmp38__length1 = data_length1;
								_vala_assert (element_idx < ((guint) _tmp38__length1), "element_idx < data.length");
								_tmp39_ = data;
								_tmp39__length1 = data_length1;
								_tmp40_ = _tmp39_[element_idx];
								_tmp41_ = element;
								if (g_strcmp0 (_tmp40_, _tmp41_) == 0) {
									guint* _tmp42_;
									gint _tmp42__length1;
									guint _tmp43_;
									_tmp42_ = found_times;
									_tmp42__length1 = found_times_length1;
									_tmp43_ = _tmp42_[element_idx];
									_tmp42_[element_idx] = _tmp43_ + 1;
									break;
								}
							}
						}
					}
					_g_free0 (element);
				}
				_tmp44_ = iterator;
				has_next = gee_iterator_has_next (_tmp44_);
				_vala_assert (!has_next, "! has_next");
				_tmp45_ = iterator;
				_tmp46_ = gee_iterator_get_valid (_tmp45_);
				_tmp47_ = _tmp46_;
				_vala_assert (_tmp47_, "iterator.valid");
				_tmp48_ = iterator;
				_vala_assert (has_next == gee_iterator_next (_tmp48_), "has_next == iterator.next ()");
				_tmp49_ = iterator;
				_tmp50_ = gee_iterator_get_valid (_tmp49_);
				_tmp51_ = _tmp50_;
				_vala_assert (_tmp51_, "iterator.valid");
				_tmp52_ = found_times;
				_tmp52__length1 = found_times_length1;
				{
					guint* ft_collection = NULL;
					gint ft_collection_length1 = 0;
					gint _ft_collection_size_ = 0;
					gint ft_it = 0;
					ft_collection = _tmp52_;
					ft_collection_length1 = _tmp52__length1;
					for (ft_it = 0; ft_it < ft_collection_length1; ft_it = ft_it + 1) {
						guint ft = 0U;
						ft = ft_collection[ft_it];
						{
							_vala_assert (ft == ((guint) 1), "ft == 1");
						}
					}
				}
			}
		}
	}
	found_times = (g_free (found_times), NULL);
	_g_object_unref0 (iterator);
}

void
collection_tests_test_mutable_iterator (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	gboolean has_next = FALSE;
	GeeIterator* iterator = NULL;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_;
	gchar** data = NULL;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp5_ = 0;
	guint* _tmp6_;
	gint idx_length1;
	gint _idx_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GeeCollection* _tmp10_;
	GeeIterator* _tmp11_;
	guint* found_times = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	guint* _tmp13_;
	gint found_times_length1;
	gint _found_times_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	iterator = _tmp2_;
	_tmp4_ = test_data_get_data (&_tmp3_);
	data = _tmp4_;
	data_length1 = _tmp3_;
	_data_size_ = data_length1;
	_tmp6_ = test_data_get_drawn_numbers (&_tmp5_);
	idx = _tmp6_;
	idx_length1 = _tmp5_;
	_idx_size_ = idx_length1;
	_tmp7_ = data;
	_tmp7__length1 = data_length1;
	{
		gchar** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = _tmp7_;
		el_collection_length1 = _tmp7__length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			const gchar* el = NULL;
			el = el_collection[el_it];
			{
				GeeCollection* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = self->test_collection;
				_tmp9_ = el;
				_vala_assert (gee_collection_add (_tmp8_, _tmp9_), "test_collection.add (el)");
			}
		}
	}
	_tmp10_ = self->test_collection;
	_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
	_g_object_unref0 (iterator);
	iterator = _tmp11_;
	_tmp12_ = data;
	_tmp12__length1 = data_length1;
	_tmp13_ = g_new0 (guint, _tmp12__length1);
	found_times = _tmp13_;
	found_times_length1 = _tmp12__length1;
	_found_times_size_ = found_times_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				guint* _tmp16_;
				gint _tmp16__length1;
				GeeCollection* _tmp21_;
				GeeIterator* _tmp22_;
				GeeIterator* _tmp23_;
				gboolean _tmp24_;
				gboolean _tmp25_;
				gboolean last_removed = FALSE;
				GeeIterator* _tmp53_;
				GeeIterator* _tmp54_;
				gboolean _tmp55_;
				gboolean _tmp56_;
				GeeIterator* _tmp57_;
				GeeIterator* _tmp58_;
				gboolean _tmp59_;
				gboolean _tmp60_;
				if (!_tmp14_) {
					guint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = idx;
				_tmp16__length1 = idx_length1;
				if (!(i <= ((guint) _tmp16__length1))) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							guint* _tmp19_;
							gint _tmp19__length1;
							guint* _tmp20_;
							gint _tmp20__length1;
							if (!_tmp17_) {
								guint _tmp18_;
								_tmp18_ = j;
								j = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp19_ = found_times;
							_tmp19__length1 = found_times_length1;
							if (!(j < ((guint) _tmp19__length1))) {
								break;
							}
							_tmp20_ = found_times;
							_tmp20__length1 = found_times_length1;
							_tmp20_[j] = (guint) 0;
						}
					}
				}
				_tmp21_ = self->test_collection;
				_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
				_g_object_unref0 (iterator);
				iterator = _tmp22_;
				_tmp23_ = iterator;
				_tmp24_ = gee_iterator_get_valid (_tmp23_);
				_tmp25_ = _tmp24_;
				_vala_assert (!_tmp25_, "! iterator.valid");
				last_removed = FALSE;
				while (TRUE) {
					GeeIterator* _tmp26_;
					GeeIterator* _tmp27_;
					gchar* element = NULL;
					GeeIterator* _tmp28_;
					gpointer _tmp29_;
					GeeIterator* _tmp30_;
					gboolean _tmp31_;
					gboolean _tmp32_;
					_tmp26_ = iterator;
					has_next = gee_iterator_has_next (_tmp26_);
					_tmp27_ = iterator;
					_vala_assert (has_next == gee_iterator_next (_tmp27_), "has_next == iterator.next ()");
					if (!has_next) {
						break;
					}
					_tmp28_ = iterator;
					_tmp29_ = gee_iterator_get (_tmp28_);
					element = (gchar*) _tmp29_;
					_tmp30_ = iterator;
					_tmp31_ = gee_iterator_get_valid (_tmp30_);
					_tmp32_ = _tmp31_;
					_vala_assert (_tmp32_, "iterator.valid");
					{
						guint element_idx = 0U;
						element_idx = (guint) 0;
						{
							gboolean _tmp33_ = FALSE;
							_tmp33_ = TRUE;
							while (TRUE) {
								gchar** _tmp35_;
								gint _tmp35__length1;
								gchar** _tmp36_;
								gint _tmp36__length1;
								const gchar* _tmp37_;
								const gchar* _tmp38_;
								if (!_tmp33_) {
									guint _tmp34_;
									_tmp34_ = element_idx;
									element_idx = _tmp34_ + 1;
								}
								_tmp33_ = FALSE;
								_tmp35_ = data;
								_tmp35__length1 = data_length1;
								_vala_assert (element_idx < ((guint) _tmp35__length1), "element_idx < data.length");
								_tmp36_ = data;
								_tmp36__length1 = data_length1;
								_tmp37_ = _tmp36_[element_idx];
								_tmp38_ = element;
								if (g_strcmp0 (_tmp37_, _tmp38_) == 0) {
									gboolean _tmp39_ = FALSE;
									guint* _tmp40_;
									gint _tmp40__length1;
									guint* _tmp51_;
									gint _tmp51__length1;
									guint _tmp52_;
									_tmp40_ = idx;
									_tmp40__length1 = idx_length1;
									if (i != ((guint) _tmp40__length1)) {
										gchar** _tmp41_;
										gint _tmp41__length1;
										const gchar* _tmp42_;
										gchar** _tmp43_;
										gint _tmp43__length1;
										guint* _tmp44_;
										gint _tmp44__length1;
										guint _tmp45_;
										const gchar* _tmp46_;
										_tmp41_ = data;
										_tmp41__length1 = data_length1;
										_tmp42_ = _tmp41_[element_idx];
										_tmp43_ = data;
										_tmp43__length1 = data_length1;
										_tmp44_ = idx;
										_tmp44__length1 = idx_length1;
										_tmp45_ = _tmp44_[i];
										_tmp46_ = _tmp43_[_tmp45_];
										_tmp39_ = g_strcmp0 (_tmp42_, _tmp46_) == 0;
									} else {
										_tmp39_ = FALSE;
									}
									if (_tmp39_) {
										GeeIterator* _tmp47_;
										GeeIterator* _tmp48_;
										gboolean _tmp49_;
										gboolean _tmp50_;
										_tmp47_ = iterator;
										gee_iterator_remove (_tmp47_);
										_tmp48_ = iterator;
										_tmp49_ = gee_iterator_get_valid (_tmp48_);
										_tmp50_ = _tmp49_;
										_vala_assert (!_tmp50_, "! iterator.valid");
										last_removed = TRUE;
									} else {
										last_removed = FALSE;
									}
									_tmp51_ = found_times;
									_tmp51__length1 = found_times_length1;
									_tmp52_ = _tmp51_[element_idx];
									_tmp51_[element_idx] = _tmp52_ + 1;
									break;
								}
							}
						}
					}
					_g_free0 (element);
				}
				_tmp53_ = iterator;
				has_next = gee_iterator_has_next (_tmp53_);
				_vala_assert (!has_next, "! has_next");
				_tmp54_ = iterator;
				_tmp55_ = gee_iterator_get_valid (_tmp54_);
				_tmp56_ = _tmp55_;
				_vala_assert (_tmp56_ == (!last_removed), "iterator.valid == !last_removed");
				_tmp57_ = iterator;
				_vala_assert (has_next == gee_iterator_next (_tmp57_), "has_next == iterator.next ()");
				_tmp58_ = iterator;
				_tmp59_ = gee_iterator_get_valid (_tmp58_);
				_tmp60_ = _tmp59_;
				_vala_assert (_tmp60_ == (!last_removed), "iterator.valid == !last_removed");
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp61_ = FALSE;
						_tmp61_ = TRUE;
						while (TRUE) {
							guint* _tmp63_;
							gint _tmp63__length1;
							gboolean removed = FALSE;
							gint _tmp68_ = 0;
							guint* _tmp69_;
							gint _tmp69__length1;
							guint _tmp70_;
							if (!_tmp61_) {
								guint _tmp62_;
								_tmp62_ = j;
								j = _tmp62_ + 1;
							}
							_tmp61_ = FALSE;
							_tmp63_ = found_times;
							_tmp63__length1 = found_times_length1;
							if (!(j < ((guint) _tmp63__length1))) {
								break;
							}
							removed = FALSE;
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp64_ = FALSE;
									_tmp64_ = TRUE;
									while (TRUE) {
										guint* _tmp66_;
										gint _tmp66__length1;
										guint _tmp67_;
										if (!_tmp64_) {
											gint _tmp65_;
											_tmp65_ = k;
											k = _tmp65_ + 1;
										}
										_tmp64_ = FALSE;
										if (!(((guint) k) < i)) {
											break;
										}
										_tmp66_ = idx;
										_tmp66__length1 = idx_length1;
										_tmp67_ = _tmp66_[k];
										if (_tmp67_ == j) {
											removed = TRUE;
											break;
										}
									}
								}
							}
							if (removed) {
								_tmp68_ = 0;
							} else {
								_tmp68_ = 1;
							}
							_tmp69_ = found_times;
							_tmp69__length1 = found_times_length1;
							_tmp70_ = _tmp69_[j];
							_vala_assert (_tmp70_ == ((guint) _tmp68_), "found_times[j] == (removed ? 0 : 1)");
						}
					}
				}
			}
		}
	}
	found_times = (g_free (found_times), NULL);
	_g_object_unref0 (iterator);
}

void
collection_tests_test_contains_size_and_is_empty (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	gchar** data = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp3_ = 0;
	guint* _tmp4_;
	gint idx_length1;
	gint _idx_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GeeCollection* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeCollection* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GeeCollection* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	GeeCollection* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	GeeCollection* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GeeCollection* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GeeCollection* _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	GeeCollection* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GeeCollection* _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	GeeCollection* _tmp106_;
	gchar** _tmp107_;
	gint _tmp107__length1;
	GeeCollection* _tmp110_;
	gint _tmp111_;
	gint _tmp112_;
	GeeCollection* _tmp113_;
	gboolean _tmp114_;
	gboolean _tmp115_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp2_ = test_data_get_data (&_tmp1_);
	data = _tmp2_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	_tmp4_ = test_data_get_drawn_numbers (&_tmp3_);
	idx = _tmp4_;
	idx_length1 = _tmp3_;
	_idx_size_ = idx_length1;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp5_;
		s_collection_length1 = _tmp5__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GeeCollection* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = self->test_collection;
				_tmp7_ = s;
				_vala_assert (!gee_collection_contains (_tmp6_, _tmp7_), "! test_collection.contains (s)");
			}
		}
	}
	_tmp8_ = self->test_collection;
	_tmp9_ = gee_collection_get_size (_tmp8_);
	_tmp10_ = _tmp9_;
	_vala_assert (_tmp10_ == 0, "test_collection.size == 0");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_get_is_empty (_tmp11_);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_, "test_collection.is_empty");
	_tmp14_ = self->test_collection;
	_tmp15_ = data;
	_tmp15__length1 = data_length1;
	_tmp16_ = _tmp15_[0];
	_vala_assert (gee_collection_add (_tmp14_, _tmp16_), "test_collection.add (data[0])");
	_tmp17_ = self->test_collection;
	_tmp18_ = data;
	_tmp18__length1 = data_length1;
	_tmp19_ = _tmp18_[0];
	_vala_assert (gee_collection_contains (_tmp17_, _tmp19_), "test_collection.contains (data[0])");
	{
		guint i = 0U;
		i = (guint) 1;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gchar** _tmp22_;
				gint _tmp22__length1;
				GeeCollection* _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				const gchar* _tmp25_;
				if (!_tmp20_) {
					guint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = data;
				_tmp22__length1 = data_length1;
				if (!(i < ((guint) _tmp22__length1))) {
					break;
				}
				_tmp23_ = self->test_collection;
				_tmp24_ = data;
				_tmp24__length1 = data_length1;
				_tmp25_ = _tmp24_[i];
				_vala_assert (!gee_collection_contains (_tmp23_, _tmp25_), "! test_collection.contains (data[i])");
			}
		}
	}
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_collection_get_size (_tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_ == 1, "test_collection.size == 1");
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_collection_get_is_empty (_tmp29_);
	_tmp31_ = _tmp30_;
	_vala_assert (!_tmp31_, "! test_collection.is_empty");
	_tmp32_ = self->test_collection;
	_vala_assert (gee_collection_remove (_tmp32_, "one"), "test_collection.remove (\"one\")");
	_tmp33_ = data;
	_tmp33__length1 = data_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp33_;
		s_collection_length1 = _tmp33__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GeeCollection* _tmp34_;
				const gchar* _tmp35_;
				_tmp34_ = self->test_collection;
				_tmp35_ = s;
				_vala_assert (!gee_collection_contains (_tmp34_, _tmp35_), "! test_collection.contains (s)");
			}
		}
	}
	_tmp36_ = self->test_collection;
	_tmp37_ = gee_collection_get_size (_tmp36_);
	_tmp38_ = _tmp37_;
	_vala_assert (_tmp38_ == 0, "test_collection.size == 0");
	_tmp39_ = self->test_collection;
	_tmp40_ = gee_collection_get_is_empty (_tmp39_);
	_tmp41_ = _tmp40_;
	_vala_assert (_tmp41_, "test_collection.is_empty");
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp42_ = FALSE;
			_tmp42_ = TRUE;
			while (TRUE) {
				gchar** _tmp44_;
				gint _tmp44__length1;
				GeeCollection* _tmp45_;
				gchar** _tmp46_;
				gint _tmp46__length1;
				const gchar* _tmp47_;
				GeeCollection* _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				GeeCollection* _tmp62_;
				gboolean _tmp63_;
				gboolean _tmp64_;
				if (!_tmp42_) {
					guint _tmp43_;
					_tmp43_ = i;
					i = _tmp43_ + 1;
				}
				_tmp42_ = FALSE;
				_tmp44_ = data;
				_tmp44__length1 = data_length1;
				if (!(i < ((guint) _tmp44__length1))) {
					break;
				}
				_tmp45_ = self->test_collection;
				_tmp46_ = data;
				_tmp46__length1 = data_length1;
				_tmp47_ = _tmp46_[i];
				_vala_assert (gee_collection_add (_tmp45_, _tmp47_), "test_collection.add (data[i])");
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp48_ = FALSE;
						_tmp48_ = TRUE;
						while (TRUE) {
							GeeCollection* _tmp50_;
							gchar** _tmp51_;
							gint _tmp51__length1;
							const gchar* _tmp52_;
							if (!_tmp48_) {
								guint _tmp49_;
								_tmp49_ = j;
								j = _tmp49_ + 1;
							}
							_tmp48_ = FALSE;
							if (!(j <= i)) {
								break;
							}
							_tmp50_ = self->test_collection;
							_tmp51_ = data;
							_tmp51__length1 = data_length1;
							_tmp52_ = _tmp51_[j];
							_vala_assert (gee_collection_contains (_tmp50_, _tmp52_), "test_collection.contains (data[j])");
						}
					}
				}
				{
					guint j = 0U;
					j = i + 1;
					{
						gboolean _tmp53_ = FALSE;
						_tmp53_ = TRUE;
						while (TRUE) {
							gchar** _tmp55_;
							gint _tmp55__length1;
							GeeCollection* _tmp56_;
							gchar** _tmp57_;
							gint _tmp57__length1;
							const gchar* _tmp58_;
							if (!_tmp53_) {
								guint _tmp54_;
								_tmp54_ = j;
								j = _tmp54_ + 1;
							}
							_tmp53_ = FALSE;
							_tmp55_ = data;
							_tmp55__length1 = data_length1;
							if (!(j < ((guint) _tmp55__length1))) {
								break;
							}
							_tmp56_ = self->test_collection;
							_tmp57_ = data;
							_tmp57__length1 = data_length1;
							_tmp58_ = _tmp57_[j];
							_vala_assert (!gee_collection_contains (_tmp56_, _tmp58_), "! test_collection.contains (data[j])");
						}
					}
				}
				_tmp59_ = self->test_collection;
				_tmp60_ = gee_collection_get_size (_tmp59_);
				_tmp61_ = _tmp60_;
				_vala_assert (((guint) _tmp61_) == (i + 1), "test_collection.size == i + 1");
				_tmp62_ = self->test_collection;
				_tmp63_ = gee_collection_get_is_empty (_tmp62_);
				_tmp64_ = _tmp63_;
				_vala_assert (!_tmp64_, "! test_collection.is_empty");
			}
		}
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				guint* _tmp67_;
				gint _tmp67__length1;
				GeeCollection* _tmp68_;
				gchar** _tmp69_;
				gint _tmp69__length1;
				guint* _tmp70_;
				gint _tmp70__length1;
				guint _tmp71_;
				const gchar* _tmp72_;
				GeeCollection* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gchar** _tmp86_;
				gint _tmp86__length1;
				GeeCollection* _tmp87_;
				gchar** _tmp88_;
				gint _tmp88__length1;
				guint* _tmp89_;
				gint _tmp89__length1;
				guint _tmp90_;
				const gchar* _tmp91_;
				GeeCollection* _tmp102_;
				gint _tmp103_;
				gint _tmp104_;
				gchar** _tmp105_;
				gint _tmp105__length1;
				if (!_tmp65_) {
					guint _tmp66_;
					_tmp66_ = i;
					i = _tmp66_ + 1;
				}
				_tmp65_ = FALSE;
				_tmp67_ = idx;
				_tmp67__length1 = idx_length1;
				if (!(i < ((guint) _tmp67__length1))) {
					break;
				}
				_tmp68_ = self->test_collection;
				_tmp69_ = data;
				_tmp69__length1 = data_length1;
				_tmp70_ = idx;
				_tmp70__length1 = idx_length1;
				_tmp71_ = _tmp70_[i];
				_tmp72_ = _tmp69_[_tmp71_];
				_vala_assert (gee_collection_remove (_tmp68_, _tmp72_), "test_collection.remove (data[idx[i]])");
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp73_ = FALSE;
						_tmp73_ = TRUE;
						while (TRUE) {
							gchar** _tmp75_;
							gint _tmp75__length1;
							gboolean removed = FALSE;
							GeeCollection* _tmp80_;
							gchar** _tmp81_;
							gint _tmp81__length1;
							const gchar* _tmp82_;
							if (!_tmp73_) {
								guint _tmp74_;
								_tmp74_ = j;
								j = _tmp74_ + 1;
							}
							_tmp73_ = FALSE;
							_tmp75_ = data;
							_tmp75__length1 = data_length1;
							if (!(j < ((guint) _tmp75__length1))) {
								break;
							}
							removed = FALSE;
							{
								guint k = 0U;
								k = (guint) 0;
								{
									gboolean _tmp76_ = FALSE;
									_tmp76_ = TRUE;
									while (TRUE) {
										guint* _tmp78_;
										gint _tmp78__length1;
										guint _tmp79_;
										if (!_tmp76_) {
											guint _tmp77_;
											_tmp77_ = k;
											k = _tmp77_ + 1;
										}
										_tmp76_ = FALSE;
										if (!(k <= i)) {
											break;
										}
										_tmp78_ = idx;
										_tmp78__length1 = idx_length1;
										_tmp79_ = _tmp78_[k];
										if (_tmp79_ == j) {
											removed = TRUE;
											break;
										}
									}
								}
							}
							_tmp80_ = self->test_collection;
							_tmp81_ = data;
							_tmp81__length1 = data_length1;
							_tmp82_ = _tmp81_[j];
							_vala_assert (gee_collection_contains (_tmp80_, _tmp82_) == (!removed), "test_collection.contains (data[j]) == !removed");
						}
					}
				}
				_tmp83_ = self->test_collection;
				_tmp84_ = gee_collection_get_size (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = data;
				_tmp86__length1 = data_length1;
				_vala_assert (((guint) _tmp85_) == (_tmp86__length1 - (i + 1)), "test_collection.size == data.length - (i + 1)");
				_tmp87_ = self->test_collection;
				_tmp88_ = data;
				_tmp88__length1 = data_length1;
				_tmp89_ = idx;
				_tmp89__length1 = idx_length1;
				_tmp90_ = _tmp89_[i];
				_tmp91_ = _tmp88_[_tmp90_];
				_vala_assert (!gee_collection_remove (_tmp87_, _tmp91_), "! test_collection.remove (data[idx[i]])");
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp92_ = FALSE;
						_tmp92_ = TRUE;
						while (TRUE) {
							gchar** _tmp94_;
							gint _tmp94__length1;
							gboolean removed = FALSE;
							GeeCollection* _tmp99_;
							gchar** _tmp100_;
							gint _tmp100__length1;
							const gchar* _tmp101_;
							if (!_tmp92_) {
								guint _tmp93_;
								_tmp93_ = j;
								j = _tmp93_ + 1;
							}
							_tmp92_ = FALSE;
							_tmp94_ = data;
							_tmp94__length1 = data_length1;
							if (!(j < ((guint) _tmp94__length1))) {
								break;
							}
							removed = FALSE;
							{
								guint k = 0U;
								k = (guint) 0;
								{
									gboolean _tmp95_ = FALSE;
									_tmp95_ = TRUE;
									while (TRUE) {
										guint* _tmp97_;
										gint _tmp97__length1;
										guint _tmp98_;
										if (!_tmp95_) {
											guint _tmp96_;
											_tmp96_ = k;
											k = _tmp96_ + 1;
										}
										_tmp95_ = FALSE;
										if (!(k <= i)) {
											break;
										}
										_tmp97_ = idx;
										_tmp97__length1 = idx_length1;
										_tmp98_ = _tmp97_[k];
										if (_tmp98_ == j) {
											removed = TRUE;
											break;
										}
									}
								}
							}
							_tmp99_ = self->test_collection;
							_tmp100_ = data;
							_tmp100__length1 = data_length1;
							_tmp101_ = _tmp100_[j];
							_vala_assert (gee_collection_contains (_tmp99_, _tmp101_) == (!removed), "test_collection.contains (data[j]) == !removed");
						}
					}
				}
				_tmp102_ = self->test_collection;
				_tmp103_ = gee_collection_get_size (_tmp102_);
				_tmp104_ = _tmp103_;
				_tmp105_ = data;
				_tmp105__length1 = data_length1;
				_vala_assert (((guint) _tmp104_) == (_tmp105__length1 - (i + 1)), "test_collection.size == data.length - (i + 1)");
			}
		}
	}
	_tmp106_ = self->test_collection;
	gee_collection_clear (_tmp106_);
	_tmp107_ = data;
	_tmp107__length1 = data_length1;
	{
		gchar** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = _tmp107_;
		el_collection_length1 = _tmp107__length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			const gchar* el = NULL;
			el = el_collection[el_it];
			{
				GeeCollection* _tmp108_;
				const gchar* _tmp109_;
				_tmp108_ = self->test_collection;
				_tmp109_ = el;
				_vala_assert (!gee_collection_contains (_tmp108_, _tmp109_), "! test_collection.contains (el)");
			}
		}
	}
	_tmp110_ = self->test_collection;
	_tmp111_ = gee_collection_get_size (_tmp110_);
	_tmp112_ = _tmp111_;
	_vala_assert (_tmp112_ == 0, "test_collection.size == 0");
	_tmp113_ = self->test_collection;
	_tmp114_ = gee_collection_get_is_empty (_tmp113_);
	_tmp115_ = _tmp114_;
	_vala_assert (_tmp115_, "test_collection.is_empty");
}

void
collection_tests_test_add_remove (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	gchar** to_add = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint to_add_length1;
	gint _to_add_size_;
	gint expected_size = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GeeCollection* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	GeeCollection* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp2_ = test_data_get_data (&_tmp1_);
	to_add = _tmp2_;
	to_add_length1 = _tmp1_;
	_to_add_size_ = to_add_length1;
	expected_size = 0;
	_tmp3_ = to_add;
	_tmp3__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp3_;
		a_collection_length1 = _tmp3__length1;
		for (a_it = 0; a_it < a_collection_length1; a_it = a_it + 1) {
			gchar* _tmp4_;
			gchar* a = NULL;
			_tmp4_ = g_strdup (a_collection[a_it]);
			a = _tmp4_;
			{
				GeeCollection* _tmp5_;
				const gchar* _tmp6_;
				GeeCollection* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GeeCollection* _tmp11_;
				const gchar* _tmp12_;
				GeeCollection* _tmp13_;
				const gchar* _tmp14_;
				_tmp5_ = self->test_collection;
				_tmp6_ = a;
				_vala_assert (!gee_collection_contains (_tmp5_, _tmp6_), "!test_collection.contains (a)");
				_tmp7_ = self->test_collection;
				_tmp8_ = gee_collection_get_size (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = expected_size;
				expected_size = _tmp10_ + 1;
				_vala_assert (_tmp9_ == _tmp10_, "test_collection.size == expected_size++");
				_tmp11_ = self->test_collection;
				_tmp12_ = a;
				_vala_assert (gee_collection_add (_tmp11_, _tmp12_), "test_collection.add (a)");
				_tmp13_ = self->test_collection;
				_tmp14_ = a;
				_vala_assert (gee_collection_contains (_tmp13_, _tmp14_), "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_get_size (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = to_add;
	_tmp18__length1 = to_add_length1;
	_vala_assert (_tmp17_ == _tmp18__length1, "test_collection.size == to_add.length");
	_tmp19_ = to_add;
	_tmp19__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp19_;
		a_collection_length1 = _tmp19__length1;
		for (a_it = 0; a_it < a_collection_length1; a_it = a_it + 1) {
			gchar* _tmp20_;
			gchar* a = NULL;
			_tmp20_ = g_strdup (a_collection[a_it]);
			a = _tmp20_;
			{
				GeeCollection* _tmp21_;
				const gchar* _tmp22_;
				_tmp21_ = self->test_collection;
				_tmp22_ = a;
				_vala_assert (gee_collection_contains (_tmp21_, _tmp22_), "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp23_ = to_add;
	_tmp23__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp23_;
		a_collection_length1 = _tmp23__length1;
		for (a_it = 0; a_it < a_collection_length1; a_it = a_it + 1) {
			gchar* _tmp24_;
			gchar* a = NULL;
			_tmp24_ = g_strdup (a_collection[a_it]);
			a = _tmp24_;
			{
				GeeCollection* _tmp25_;
				const gchar* _tmp26_;
				GeeCollection* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				GeeCollection* _tmp31_;
				const gchar* _tmp32_;
				GeeCollection* _tmp33_;
				const gchar* _tmp34_;
				_tmp25_ = self->test_collection;
				_tmp26_ = a;
				_vala_assert (gee_collection_contains (_tmp25_, _tmp26_), "test_collection.contains (a)");
				_tmp27_ = self->test_collection;
				_tmp28_ = gee_collection_get_size (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = expected_size;
				expected_size = _tmp30_ - 1;
				_vala_assert (_tmp29_ == _tmp30_, "test_collection.size == expected_size--");
				_tmp31_ = self->test_collection;
				_tmp32_ = a;
				_vala_assert (gee_collection_remove (_tmp31_, _tmp32_), "test_collection.remove (a)");
				_tmp33_ = self->test_collection;
				_tmp34_ = a;
				_vala_assert (!gee_collection_contains (_tmp33_, _tmp34_), "!test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp35_ = self->test_collection;
	_tmp36_ = gee_collection_get_size (_tmp35_);
	_tmp37_ = _tmp36_;
	_vala_assert (_tmp37_ == 0, "test_collection.size == 0");
}

void
collection_tests_test_clear (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	gchar** to_add = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint to_add_length1;
	gint _to_add_size_;
	gint expected_size = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GeeCollection* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp23_;
	GeeIterator* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp2_ = test_data_get_data (&_tmp1_);
	to_add = _tmp2_;
	to_add_length1 = _tmp1_;
	_to_add_size_ = to_add_length1;
	expected_size = 0;
	_tmp3_ = to_add;
	_tmp3__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp3_;
		a_collection_length1 = _tmp3__length1;
		for (a_it = 0; a_it < a_collection_length1; a_it = a_it + 1) {
			gchar* _tmp4_;
			gchar* a = NULL;
			_tmp4_ = g_strdup (a_collection[a_it]);
			a = _tmp4_;
			{
				GeeCollection* _tmp5_;
				const gchar* _tmp6_;
				GeeCollection* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GeeCollection* _tmp11_;
				const gchar* _tmp12_;
				GeeCollection* _tmp13_;
				const gchar* _tmp14_;
				_tmp5_ = self->test_collection;
				_tmp6_ = a;
				_vala_assert (!gee_collection_contains (_tmp5_, _tmp6_), "!test_collection.contains (a)");
				_tmp7_ = self->test_collection;
				_tmp8_ = gee_collection_get_size (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = expected_size;
				expected_size = _tmp10_ + 1;
				_vala_assert (_tmp9_ == _tmp10_, "test_collection.size == expected_size++");
				_tmp11_ = self->test_collection;
				_tmp12_ = a;
				_vala_assert (gee_collection_add (_tmp11_, _tmp12_), "test_collection.add (a)");
				_tmp13_ = self->test_collection;
				_tmp14_ = a;
				_vala_assert (gee_collection_contains (_tmp13_, _tmp14_), "test_collection.contains (a)");
				_g_free0 (a);
			}
		}
	}
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_get_size (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = to_add;
	_tmp18__length1 = to_add_length1;
	_vala_assert (_tmp17_ == _tmp18__length1, "test_collection.size == to_add.length");
	_tmp19_ = self->test_collection;
	gee_collection_clear (_tmp19_);
	_tmp20_ = self->test_collection;
	_tmp21_ = gee_collection_get_size (_tmp20_);
	_tmp22_ = _tmp21_;
	_vala_assert (_tmp22_ == 0, "test_collection.size == 0");
	_tmp23_ = self->test_collection;
	_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
	iter = _tmp24_;
	_vala_assert (iter != NULL, "iter != null");
	_vala_assert (!gee_iterator_has_next (iter), "!iter.has_next ()");
	_g_object_unref0 (iter);
}

void
collection_tests_test_add_all (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeCollection* _tmp13_;
	GeeCollection* _tmp14_;
	GeeCollection* _tmp15_;
	GeeCollection* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GeeCollection* _tmp30_;
	GeeCollection* _tmp31_;
	GeeCollection* _tmp32_;
	GeeCollection* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GeeCollection* _tmp36_;
	GeeCollection* _tmp37_;
	GeeCollection* _tmp38_;
	GeeCollection* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GeeCollection* _tmp42_;
	GeeCollection* _tmp43_;
	GeeCollection* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_vala_assert (!gee_collection_add_all (_tmp2_, (GeeCollection*) dummy), "! test_collection.add_all (dummy)");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_get_is_empty (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_, "test_collection.is_empty");
	_tmp6_ = gee_collection_get_is_empty ((GeeCollection*) dummy);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_, "dummy.is_empty");
	_tmp8_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp8_, "hello"), "test_collection.add (\"hello\")");
	_tmp9_ = self->test_collection;
	_vala_assert (!gee_collection_add_all (_tmp9_, (GeeCollection*) dummy), "! test_collection.add_all (dummy)");
	_tmp10_ = self->test_collection;
	_tmp11_ = gee_collection_get_size (_tmp10_);
	_tmp12_ = _tmp11_;
	_vala_assert (_tmp12_ == 1, "test_collection.size == 1");
	_tmp13_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp13_, "hello"), "test_collection.contains (\"hello\")");
	_tmp14_ = self->test_collection;
	gee_collection_clear (_tmp14_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp15_ = self->test_collection;
	_vala_assert (gee_collection_add_all (_tmp15_, (GeeCollection*) dummy), "test_collection.add_all (dummy)");
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_collection_get_size (_tmp16_);
	_tmp18_ = _tmp17_;
	_vala_assert (_tmp18_ == 3, "test_collection.size == 3");
	_tmp19_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp19_, "hello1"), "test_collection.contains (\"hello1\")");
	_tmp20_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp20_, "hello2"), "test_collection.contains (\"hello2\")");
	_tmp21_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp21_, "hello3"), "test_collection.contains (\"hello3\")");
	_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp23_ = _tmp22_;
	_vala_assert (_tmp23_ == 3, "dummy.size == 3");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"), "dummy.contains (\"hello1\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"), "dummy.contains (\"hello2\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"), "dummy.contains (\"hello3\")");
	_tmp24_ = self->test_collection;
	gee_collection_clear (_tmp24_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp25_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp25_, "hello"), "test_collection.add (\"hello\")");
	_tmp26_ = self->test_collection;
	_vala_assert (gee_collection_add_all (_tmp26_, (GeeCollection*) dummy), "test_collection.add_all (dummy)");
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_vala_assert (_tmp29_ == 4, "test_collection.size == 4");
	_tmp30_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp30_, "hello"), "test_collection.contains (\"hello\")");
	_tmp31_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp31_, "hello1"), "test_collection.contains (\"hello1\")");
	_tmp32_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp32_, "hello2"), "test_collection.contains (\"hello2\")");
	_tmp33_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp33_, "hello3"), "test_collection.contains (\"hello3\")");
	_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp35_ = _tmp34_;
	_vala_assert (_tmp35_ == 3, "dummy.size == 3");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"), "dummy.contains (\"hello1\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"), "dummy.contains (\"hello2\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"), "dummy.contains (\"hello3\")");
	_tmp36_ = self->test_collection;
	gee_collection_clear (_tmp36_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp37_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp37_, "hello1"), "test_collection.add (\"hello1\")");
	_tmp38_ = self->test_collection;
	_vala_assert (gee_collection_add_all (_tmp38_, (GeeCollection*) dummy), "test_collection.add_all (dummy)");
	_tmp39_ = self->test_collection;
	_tmp40_ = gee_collection_get_size (_tmp39_);
	_tmp41_ = _tmp40_;
	_vala_assert (_tmp41_ >= 3, "test_collection.size >= 3");
	_tmp42_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp42_, "hello1"), "test_collection.contains (\"hello1\")");
	_tmp43_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp43_, "hello2"), "test_collection.contains (\"hello2\")");
	_tmp44_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp44_, "hello3"), "test_collection.contains (\"hello3\")");
	_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp46_ = _tmp45_;
	_vala_assert (_tmp46_ == 3, "dummy.size == 3");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"), "dummy.contains (\"hello1\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"), "dummy.contains (\"hello2\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"), "dummy.contains (\"hello3\")");
	_g_object_unref0 (dummy);
}

void
collection_tests_test_contains_all (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp1_;
	GeeCollection* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	GeeCollection* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_get_is_empty (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp4_, "test_collection.is_empty");
	_tmp5_ = self->test_collection;
	_vala_assert (!gee_collection_contains_all (_tmp5_, (GeeCollection*) dummy), "! test_collection.contains_all (dummy)");
	_tmp6_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp6_, "hello4"), "test_collection.add (\"hello4\")");
	_tmp7_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp7_, "hello5"), "test_collection.add (\"hello5\")");
	_tmp8_ = self->test_collection;
	_vala_assert (!gee_collection_contains_all (_tmp8_, (GeeCollection*) dummy), "! test_collection.contains_all (dummy)");
	_tmp9_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp9_, "hello1"), "test_collection.add (\"hello1\")");
	_tmp10_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp10_, "hello2"), "test_collection.add (\"hello2\")");
	_tmp11_ = self->test_collection;
	_vala_assert (!gee_collection_contains_all (_tmp11_, (GeeCollection*) dummy), "! test_collection.contains_all (dummy)");
	_tmp12_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp12_, "hello3"), "test_collection.add (\"hello3\")");
	_tmp13_ = self->test_collection;
	_vala_assert (gee_collection_contains_all (_tmp13_, (GeeCollection*) dummy), "test_collection.contains_all (dummy)");
	_tmp14_ = self->test_collection;
	_vala_assert (!gee_collection_contains_all ((GeeCollection*) dummy, _tmp14_), "! dummy.contains_all (test_collection)");
	_g_object_unref0 (dummy);
}

void
collection_tests_test_remove_all (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	GeeCollection* _tmp14_;
	GeeCollection* _tmp15_;
	GeeCollection* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GeeCollection* _tmp21_;
	GeeCollection* _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GeeCollection* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GeeCollection* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_vala_assert (!gee_collection_remove_all (_tmp2_, (GeeCollection*) dummy), "! test_collection.remove_all (dummy)");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_get_is_empty (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_, "test_collection.is_empty");
	_tmp6_ = gee_collection_get_is_empty ((GeeCollection*) dummy);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_, "dummy.is_empty");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp8_ = self->test_collection;
	_vala_assert (!gee_collection_remove_all (_tmp8_, (GeeCollection*) dummy), "! test_collection.remove_all (dummy)");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_get_is_empty (_tmp9_);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp11_, "test_collection.is_empty");
	_tmp12_ = self->test_collection;
	gee_collection_clear (_tmp12_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp13_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp13_, "hello4"), "test_collection.add (\"hello4\")");
	_tmp14_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp14_, "hello5"), "test_collection.add (\"hello5\")");
	_tmp15_ = self->test_collection;
	_vala_assert (!gee_collection_remove_all (_tmp15_, (GeeCollection*) dummy), "! test_collection.remove_all (dummy)");
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_collection_get_size (_tmp16_);
	_tmp18_ = _tmp17_;
	_vala_assert (_tmp18_ == 2, "test_collection.size == 2");
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_ == 3, "dummy.size == 3");
	_tmp21_ = self->test_collection;
	gee_collection_clear (_tmp21_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp22_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp22_, "hello1"), "test_collection.add (\"hello1\")");
	_tmp23_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp23_, "hello2"), "test_collection.add (\"hello2\")");
	_tmp24_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp24_, "hello3"), "test_collection.add (\"hello3\")");
	_tmp25_ = self->test_collection;
	_vala_assert (gee_collection_remove_all (_tmp25_, (GeeCollection*) dummy), "test_collection.remove_all (dummy)");
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_collection_get_is_empty (_tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_, "test_collection.is_empty");
	_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp30_ = _tmp29_;
	_vala_assert (_tmp30_ == 3, "dummy.size == 3");
	_tmp31_ = self->test_collection;
	gee_collection_clear (_tmp31_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}

void
collection_tests_test_retain_all (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GeeCollection* _tmp16_;
	GeeCollection* _tmp17_;
	GeeCollection* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GeeCollection* _tmp32_;
	GeeCollection* _tmp33_;
	GeeCollection* _tmp34_;
	GeeCollection* _tmp35_;
	GeeCollection* _tmp36_;
	GeeCollection* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	GeeCollection* _tmp40_;
	GeeCollection* _tmp41_;
	GeeCollection* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	GeeCollection* _tmp45_;
	GeeCollection* _tmp46_;
	GeeCollection* _tmp47_;
	GeeCollection* _tmp48_;
	GeeCollection* _tmp49_;
	GeeCollection* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GeeCollection* _tmp53_;
	GeeCollection* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	GeeCollection* _tmp57_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_vala_assert (!gee_collection_retain_all (_tmp2_, (GeeCollection*) dummy), "! test_collection.retain_all (dummy)");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_get_is_empty (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_, "test_collection.is_empty");
	_tmp6_ = gee_collection_get_is_empty ((GeeCollection*) dummy);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_, "dummy.is_empty");
	_tmp8_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp8_, "hello1"), "test_collection.add (\"hello1\")");
	_tmp9_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp9_, "hello2"), "test_collection.add (\"hello2\")");
	_tmp10_ = self->test_collection;
	_vala_assert (gee_collection_retain_all (_tmp10_, (GeeCollection*) dummy), "test_collection.retain_all (dummy)");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_get_is_empty (_tmp11_);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_, "test_collection.is_empty");
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) dummy);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_, "dummy.is_empty");
	_tmp16_ = self->test_collection;
	gee_collection_clear (_tmp16_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp17_ = self->test_collection;
	_vala_assert (!gee_collection_retain_all (_tmp17_, (GeeCollection*) dummy), "! test_collection.retain_all (dummy)");
	_tmp18_ = self->test_collection;
	_tmp19_ = gee_collection_get_is_empty (_tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_, "test_collection.is_empty");
	_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp22_ = _tmp21_;
	_vala_assert (_tmp22_ == 3, "dummy.size == 3");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"), "dummy.contains (\"hello1\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"), "dummy.contains (\"hello2\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"), "dummy.contains (\"hello3\")");
	_tmp23_ = self->test_collection;
	gee_collection_clear (_tmp23_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp24_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp24_, "hello4"), "test_collection.add (\"hello4\")");
	_tmp25_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp25_, "hello5"), "test_collection.add (\"hello5\")");
	_tmp26_ = self->test_collection;
	_vala_assert (gee_collection_retain_all (_tmp26_, (GeeCollection*) dummy), "test_collection.retain_all (dummy)");
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_get_is_empty (_tmp27_);
	_tmp29_ = _tmp28_;
	_vala_assert (_tmp29_, "test_collection.is_empty");
	_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp31_ = _tmp30_;
	_vala_assert (_tmp31_ == 3, "dummy.size == 3");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"), "dummy.contains (\"hello1\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"), "dummy.contains (\"hello2\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"), "dummy.contains (\"hello3\")");
	_tmp32_ = self->test_collection;
	gee_collection_clear (_tmp32_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp33_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp33_, "hello1"), "test_collection.add (\"hello1\")");
	_tmp34_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp34_, "hello2"), "test_collection.add (\"hello2\")");
	_tmp35_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp35_, "hello3"), "test_collection.add (\"hello3\")");
	_tmp36_ = self->test_collection;
	_vala_assert (!gee_collection_retain_all (_tmp36_, (GeeCollection*) dummy), "! test_collection.retain_all (dummy)");
	_tmp37_ = self->test_collection;
	_tmp38_ = gee_collection_get_size (_tmp37_);
	_tmp39_ = _tmp38_;
	_vala_assert (_tmp39_ == 3, "test_collection.size == 3");
	_tmp40_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp40_, "hello1"), "test_collection.contains (\"hello1\")");
	_tmp41_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp41_, "hello2"), "test_collection.contains (\"hello2\")");
	_tmp42_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp42_, "hello3"), "test_collection.contains (\"hello3\")");
	_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp44_ = _tmp43_;
	_vala_assert (_tmp44_ == 3, "dummy.size == 3");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"), "dummy.contains (\"hello1\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"), "dummy.contains (\"hello2\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"), "dummy.contains (\"hello3\")");
	_tmp45_ = self->test_collection;
	gee_collection_clear (_tmp45_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"), "dummy.add (\"hello1\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"), "dummy.add (\"hello2\")");
	_vala_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"), "dummy.add (\"hello3\")");
	_tmp46_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp46_, "hello2"), "test_collection.add (\"hello2\")");
	_tmp47_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp47_, "hello3"), "test_collection.add (\"hello3\")");
	_tmp48_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp48_, "hello4"), "test_collection.add (\"hello4\")");
	_tmp49_ = self->test_collection;
	_vala_assert (gee_collection_retain_all (_tmp49_, (GeeCollection*) dummy), "test_collection.retain_all (dummy)");
	_tmp50_ = self->test_collection;
	_tmp51_ = gee_collection_get_size (_tmp50_);
	_tmp52_ = _tmp51_;
	_vala_assert (_tmp52_ == 2, "test_collection.size == 2");
	_tmp53_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp53_, "hello2"), "test_collection.contains (\"hello2\")");
	_tmp54_ = self->test_collection;
	_vala_assert (gee_collection_contains (_tmp54_, "hello3"), "test_collection.contains (\"hello3\")");
	_tmp55_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) dummy);
	_tmp56_ = _tmp55_;
	_vala_assert (_tmp56_ == 3, "dummy.size == 3");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"), "dummy.contains (\"hello1\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"), "dummy.contains (\"hello2\")");
	_vala_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"), "dummy.contains (\"hello3\")");
	_tmp57_ = self->test_collection;
	gee_collection_clear (_tmp57_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}

void
collection_tests_test_to_array (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	gchar** array = NULL;
	GeeCollection* _tmp7_;
	gint _tmp8_ = 0;
	gpointer* _tmp9_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_collection_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_, "test_collection.is_empty");
	_tmp4_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp4_, "hello1"), "test_collection.add (\"hello1\")");
	_tmp5_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp5_, "hello2"), "test_collection.add (\"hello2\")");
	_tmp6_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp6_, "hello3"), "test_collection.add (\"hello3\")");
	_tmp7_ = self->test_collection;
	_tmp9_ = gee_collection_to_array (_tmp7_, &_tmp8_);
	array = (gchar**) _tmp9_;
	array_length1 = (_tmp8_ * sizeof (gchar*)) / sizeof (gchar*);
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp10_ = self->test_collection;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_element_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* element = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			const gchar* _tmp18_;
			_tmp12_ = _element_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _element_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			element = (gchar*) _tmp14_;
			_tmp15_ = element;
			_tmp16_ = array;
			_tmp16__length1 = array_length1;
			_tmp17_ = index;
			index = _tmp17_ + 1;
			_tmp18_ = _tmp16_[_tmp17_];
			_vala_assert (g_strcmp0 (_tmp15_, _tmp18_) == 0, "element == array[index++]");
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}

void
collection_tests_test_gobject_properties (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GValue value = {0};
	GValue _tmp1_ = {0};
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (_tmp0_ != NULL, "test_collection != null");
	g_value_init (&_tmp1_, G_TYPE_INT);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	_tmp2_ = self->test_collection;
	g_object_get_property ((GObject*) _tmp2_, "size", &value);
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (g_value_get_int (&value) == _tmp5_, "value.get_int () == test_collection.size");
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CollectionTests* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->test_iterator);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda5_ (CollectionTests* self,
            gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	g_assert_not_reached ();
	_g_free0 (x);
	return result;
}

static gboolean
___lambda5__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda5_ ((CollectionTests*) self, (gchar*) g);
	return result;
}

static gboolean
__lambda6_ (CollectionTests* self,
            gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	g_assert_not_reached ();
	_g_free0 (x);
	return result;
}

static gboolean
___lambda6__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda6_ ((CollectionTests*) self, (gchar*) g);
	return result;
}

static gboolean
__lambda7_ (Block1Data* _data1_,
            gchar* x)
{
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data1_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data1_->count;
	_data1_->count = _tmp4_ + 1;
	result = TRUE;
	_g_free0 (x);
	return result;
}

static gboolean
___lambda7__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda7_ (self, (gchar*) g);
	return result;
}

static gboolean
__lambda8_ (Block1Data* _data1_,
            gchar* x)
{
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data1_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data1_->count;
	_data1_->count = _tmp4_ + 1;
	result = TRUE;
	_g_free0 (x);
	return result;
}

static gboolean
___lambda8__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda8_ (self, (gchar*) g);
	return result;
}

static gboolean
__lambda9_ (Block1Data* _data1_,
            gchar* x)
{
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data1_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data1_->count;
	_data1_->count = _tmp4_ + 1;
	result = TRUE;
	_g_free0 (x);
	return result;
}

static gboolean
___lambda9__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda9_ (self, (gchar*) g);
	return result;
}

static gboolean
__lambda10_ (Block1Data* _data1_,
             gchar* x)
{
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data1_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data1_->count;
	_data1_->count = _tmp4_ + 1;
	result = TRUE;
	_g_free0 (x);
	return result;
}

static gboolean
___lambda10__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda10_ (self, (gchar*) g);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CollectionTests* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
_____lambda11_ (Block2Data* _data2_,
                gchar* x)
{
	Block1Data* _data1_;
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data1_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data1_->count;
	_data1_->count = _tmp4_ + 1;
	result = _tmp4_ != _data2_->i;
	_g_free0 (x);
	return result;
}

static gboolean
______lambda11__gee_forall_func (gpointer g,
                                 gpointer self)
{
	gboolean result;
	result = _____lambda11_ (self, (gchar*) g);
	return result;
}

static gboolean
_____lambda12_ (Block2Data* _data2_,
                gchar* x)
{
	Block1Data* _data1_;
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data1_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data1_->count;
	_data1_->count = _tmp4_ + 1;
	result = _tmp4_ != _data2_->i;
	_g_free0 (x);
	return result;
}

static gboolean
______lambda12__gee_forall_func (gpointer g,
                                 gpointer self)
{
	gboolean result;
	result = _____lambda12_ (self, (gchar*) g);
	return result;
}

static gboolean
_____lambda13_ (Block2Data* _data2_,
                gchar* x)
{
	Block1Data* _data1_;
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data1_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data1_->count;
	_data1_->count = _tmp4_ + 1;
	result = _tmp4_ != (_data2_->i + 1);
	_g_free0 (x);
	return result;
}

static gboolean
______lambda13__gee_forall_func (gpointer g,
                                 gpointer self)
{
	gboolean result;
	result = _____lambda13_ (self, (gchar*) g);
	return result;
}

static gboolean
_____lambda14_ (Block2Data* _data2_,
                gchar* x)
{
	Block1Data* _data1_;
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data1_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data1_->count;
	_data1_->count = _tmp4_ + 1;
	result = _tmp4_ != (_data2_->i + 1);
	_g_free0 (x);
	return result;
}

static gboolean
______lambda14__gee_forall_func (gpointer g,
                                 gpointer self)
{
	gboolean result;
	result = _____lambda14_ (self, (gchar*) g);
	return result;
}

void
collection_tests_test_foreach (CollectionTests* self)
{
	Block1Data* _data1_;
	gboolean res = FALSE;
	gchar** data = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint data_length1;
	gint _data_size_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GeeCollection* _tmp9_;
	GeeIterator* _tmp10_;
	GeeCollection* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GeeCollection* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp15_;
	GeeIterator* _tmp16_;
	GeeIterator* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GeeIterator* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	GeeIterator* _tmp22_;
	gpointer _tmp23_;
	gchar* _tmp24_;
	GeeIterator* _tmp25_;
	gpointer _tmp26_;
	gchar* _tmp27_;
	GeeIterator* _tmp28_;
	GeeCollection* _tmp29_;
	GeeIterator* _tmp30_;
	GeeCollection* _tmp31_;
	GeeIterator* _tmp32_;
	GeeIterator* _tmp33_;
	GeeIterator* _tmp34_;
	GeeIterator* _tmp35_;
	GeeIterator* _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	GeeIterator* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GeeIterator* _tmp41_;
	gpointer _tmp42_;
	gchar* _tmp43_;
	GeeIterator* _tmp44_;
	gpointer _tmp45_;
	gchar* _tmp46_;
	GeeIterator* _tmp47_;
	GeeCollection* _tmp48_;
	GeeIterator* _tmp49_;
	GeeCollection* _tmp50_;
	GeeIterator* _tmp51_;
	GeeIterator* _tmp52_;
	GeeIterator* _tmp53_;
	GeeIterator* _tmp54_;
	GeeIterator* _tmp55_;
	GeeIterator* _tmp56_;
	gchar** _tmp57_;
	gint _tmp57__length1;
	GeeIterator* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	GeeIterator* _tmp61_;
	gpointer _tmp62_;
	gchar* _tmp63_;
	GeeIterator* _tmp64_;
	gpointer _tmp65_;
	gchar* _tmp66_;
	GeeIterator* _tmp67_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp1_ = test_data_get_data (&_tmp0_);
	data = _tmp1_;
	data_length1 = _tmp0_;
	_data_size_ = data_length1;
	_tmp2_ = self->test_collection;
	res = gee_traversable_foreach ((GeeTraversable*) _tmp2_, ___lambda5__gee_forall_func, self);
	_vala_assert (res == TRUE, "res == true");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	_tmp5_ = _tmp4_;
	res = gee_traversable_foreach ((GeeTraversable*) _tmp5_, ___lambda6__gee_forall_func, self);
	_g_object_unref0 (_tmp5_);
	_vala_assert (res == TRUE, "res == true");
	_tmp6_ = data;
	_tmp6__length1 = data_length1;
	{
		gchar** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = _tmp6_;
		el_collection_length1 = _tmp6__length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			const gchar* el = NULL;
			el = el_collection[el_it];
			{
				GeeCollection* _tmp7_;
				const gchar* _tmp8_;
				_tmp7_ = self->test_collection;
				_tmp8_ = el;
				_vala_assert (gee_collection_add (_tmp7_, _tmp8_), "test_collection.add (el)");
			}
		}
	}
	_data1_->count = 0;
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	_data1_->test_iterator = _tmp10_;
	_tmp11_ = self->test_collection;
	res = gee_traversable_foreach ((GeeTraversable*) _tmp11_, ___lambda7__gee_forall_func, _data1_);
	_tmp12_ = data;
	_tmp12__length1 = data_length1;
	_vala_assert (_data1_->count == _tmp12__length1, "count == data.length");
	_vala_assert (res == TRUE, "res == true");
	_data1_->count = 0;
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
	_g_object_unref0 (_data1_->test_iterator);
	_data1_->test_iterator = _tmp14_;
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
	iter = _tmp16_;
	_tmp17_ = iter;
	res = gee_traversable_foreach ((GeeTraversable*) _tmp17_, ___lambda8__gee_forall_func, _data1_);
	_tmp18_ = data;
	_tmp18__length1 = data_length1;
	_vala_assert (_data1_->count == _tmp18__length1, "count == data.length");
	_vala_assert (res == TRUE, "res == true");
	_tmp19_ = iter;
	_tmp20_ = gee_iterator_get_valid (_tmp19_);
	_tmp21_ = _tmp20_;
	_vala_assert (_tmp21_, "iter.valid");
	_tmp22_ = iter;
	_tmp23_ = gee_iterator_get (_tmp22_);
	_tmp24_ = (gchar*) _tmp23_;
	_tmp25_ = _data1_->test_iterator;
	_tmp26_ = gee_iterator_get (_tmp25_);
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp24_, _tmp27_) == 0, "iter.get () == test_iterator.get ()");
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	_tmp28_ = iter;
	_vala_assert (!gee_iterator_has_next (_tmp28_), "!iter.has_next ()");
	_data1_->count = 1;
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_iterable_iterator ((GeeIterable*) _tmp29_);
	_g_object_unref0 (_data1_->test_iterator);
	_data1_->test_iterator = _tmp30_;
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
	_g_object_unref0 (iter);
	iter = _tmp32_;
	_tmp33_ = iter;
	_vala_assert (gee_iterator_next (_tmp33_), "iter.next ()");
	_tmp34_ = iter;
	_vala_assert (gee_iterator_next (_tmp34_), "iter.next ()");
	_tmp35_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp35_), "test_iterator.next ()");
	_tmp36_ = iter;
	res = gee_traversable_foreach ((GeeTraversable*) _tmp36_, ___lambda9__gee_forall_func, _data1_);
	_tmp37_ = data;
	_tmp37__length1 = data_length1;
	_vala_assert (_data1_->count == _tmp37__length1, "count == data.length");
	_vala_assert (res == TRUE, "res == true");
	_tmp38_ = iter;
	_tmp39_ = gee_iterator_get_valid (_tmp38_);
	_tmp40_ = _tmp39_;
	_vala_assert (_tmp40_, "iter.valid");
	_tmp41_ = iter;
	_tmp42_ = gee_iterator_get (_tmp41_);
	_tmp43_ = (gchar*) _tmp42_;
	_tmp44_ = _data1_->test_iterator;
	_tmp45_ = gee_iterator_get (_tmp44_);
	_tmp46_ = (gchar*) _tmp45_;
	_vala_assert (g_strcmp0 (_tmp43_, _tmp46_) == 0, "iter.get () == test_iterator.get ()");
	_g_free0 (_tmp46_);
	_g_free0 (_tmp43_);
	_tmp47_ = iter;
	_vala_assert (!gee_iterator_has_next (_tmp47_), "!iter.has_next ()");
	_data1_->count = 1;
	_tmp48_ = self->test_collection;
	_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
	_g_object_unref0 (_data1_->test_iterator);
	_data1_->test_iterator = _tmp49_;
	_tmp50_ = self->test_collection;
	_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
	_g_object_unref0 (iter);
	iter = _tmp51_;
	_tmp52_ = iter;
	_vala_assert (gee_iterator_next (_tmp52_), "iter.next ()");
	_tmp53_ = iter;
	_vala_assert (gee_iterator_next (_tmp53_), "iter.next ()");
	_tmp54_ = iter;
	_vala_assert (gee_iterator_has_next (_tmp54_), "iter.has_next ()");
	_tmp55_ = _data1_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp55_), "test_iterator.next ()");
	_tmp56_ = iter;
	res = gee_traversable_foreach ((GeeTraversable*) _tmp56_, ___lambda10__gee_forall_func, _data1_);
	_tmp57_ = data;
	_tmp57__length1 = data_length1;
	_vala_assert (_data1_->count == _tmp57__length1, "count == data.length");
	_vala_assert (res == TRUE, "res == true");
	_tmp58_ = iter;
	_tmp59_ = gee_iterator_get_valid (_tmp58_);
	_tmp60_ = _tmp59_;
	_vala_assert (_tmp60_, "iter.valid");
	_tmp61_ = iter;
	_tmp62_ = gee_iterator_get (_tmp61_);
	_tmp63_ = (gchar*) _tmp62_;
	_tmp64_ = _data1_->test_iterator;
	_tmp65_ = gee_iterator_get (_tmp64_);
	_tmp66_ = (gchar*) _tmp65_;
	_vala_assert (g_strcmp0 (_tmp63_, _tmp66_) == 0, "iter.get () == test_iterator.get ()");
	_g_free0 (_tmp66_);
	_g_free0 (_tmp63_);
	_tmp67_ = iter;
	_vala_assert (!gee_iterator_has_next (_tmp67_), "!iter.has_next ()");
	{
		Block2Data* _data2_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_data2_->i = 0;
		{
			gboolean _tmp68_ = FALSE;
			_tmp68_ = TRUE;
			while (TRUE) {
				GeeCollection* _tmp70_;
				GeeIterator* _tmp71_;
				GeeCollection* _tmp72_;
				GeeCollection* _tmp73_;
				GeeIterator* _tmp74_;
				GeeCollection* _tmp75_;
				GeeIterator* _tmp76_;
				GeeIterator* _tmp77_;
				GeeIterator* _tmp78_;
				gboolean _tmp79_;
				gboolean _tmp80_;
				GeeIterator* _tmp81_;
				gpointer _tmp82_;
				gchar* _tmp83_;
				GeeIterator* _tmp84_;
				gpointer _tmp85_;
				gchar* _tmp86_;
				GeeIterator* _tmp87_;
				GeeIterator* _tmp96_;
				GeeCollection* _tmp97_;
				GeeIterator* _tmp98_;
				GeeCollection* _tmp99_;
				GeeIterator* _tmp100_;
				GeeIterator* _tmp101_;
				GeeIterator* _tmp102_;
				GeeIterator* _tmp103_;
				GeeIterator* _tmp104_;
				GeeIterator* _tmp105_;
				gboolean _tmp106_;
				gboolean _tmp107_;
				GeeIterator* _tmp108_;
				gpointer _tmp109_;
				gchar* _tmp110_;
				GeeIterator* _tmp111_;
				gpointer _tmp112_;
				gchar* _tmp113_;
				GeeIterator* _tmp114_;
				GeeIterator* _tmp123_;
				GeeCollection* _tmp124_;
				GeeIterator* _tmp125_;
				GeeCollection* _tmp126_;
				GeeIterator* _tmp127_;
				GeeIterator* _tmp128_;
				GeeIterator* _tmp129_;
				GeeIterator* _tmp130_;
				GeeIterator* _tmp131_;
				GeeIterator* _tmp132_;
				GeeIterator* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				GeeIterator* _tmp136_;
				gpointer _tmp137_;
				gchar* _tmp138_;
				GeeIterator* _tmp139_;
				gpointer _tmp140_;
				gchar* _tmp141_;
				GeeIterator* _tmp142_;
				GeeIterator* _tmp151_;
				if (!_tmp68_) {
					gint _tmp69_;
					_tmp69_ = _data2_->i;
					_data2_->i = _tmp69_ + 1;
				}
				_tmp68_ = FALSE;
				if (!(_data2_->i < 3)) {
					break;
				}
				_data1_->count = 0;
				_tmp70_ = self->test_collection;
				_tmp71_ = gee_iterable_iterator ((GeeIterable*) _tmp70_);
				_g_object_unref0 (_data1_->test_iterator);
				_data1_->test_iterator = _tmp71_;
				_tmp72_ = self->test_collection;
				res = gee_traversable_foreach ((GeeTraversable*) _tmp72_, ______lambda11__gee_forall_func, _data2_);
				_vala_assert (_data1_->count == (_data2_->i + 1), "count == i + 1");
				_vala_assert (res == FALSE, "res == false");
				_data1_->count = 0;
				_tmp73_ = self->test_collection;
				_tmp74_ = gee_iterable_iterator ((GeeIterable*) _tmp73_);
				_g_object_unref0 (_data1_->test_iterator);
				_data1_->test_iterator = _tmp74_;
				_tmp75_ = self->test_collection;
				_tmp76_ = gee_iterable_iterator ((GeeIterable*) _tmp75_);
				_g_object_unref0 (iter);
				iter = _tmp76_;
				_tmp77_ = iter;
				res = gee_traversable_foreach ((GeeTraversable*) _tmp77_, ______lambda12__gee_forall_func, _data2_);
				_vala_assert (_data1_->count == (_data2_->i + 1), "count == i + 1");
				_vala_assert (res == FALSE, "res == false");
				_tmp78_ = iter;
				_tmp79_ = gee_iterator_get_valid (_tmp78_);
				_tmp80_ = _tmp79_;
				_vala_assert (_tmp80_, "iter.valid");
				_tmp81_ = iter;
				_tmp82_ = gee_iterator_get (_tmp81_);
				_tmp83_ = (gchar*) _tmp82_;
				_tmp84_ = _data1_->test_iterator;
				_tmp85_ = gee_iterator_get (_tmp84_);
				_tmp86_ = (gchar*) _tmp85_;
				_vala_assert (g_strcmp0 (_tmp83_, _tmp86_) == 0, "iter.get () == test_iterator.get ()");
				_g_free0 (_tmp86_);
				_g_free0 (_tmp83_);
				_tmp87_ = iter;
				_vala_assert (gee_iterator_has_next (_tmp87_), "iter.has_next ()");
				while (TRUE) {
					GeeIterator* _tmp88_;
					GeeIterator* _tmp89_;
					GeeIterator* _tmp90_;
					gpointer _tmp91_;
					gchar* _tmp92_;
					GeeIterator* _tmp93_;
					gpointer _tmp94_;
					gchar* _tmp95_;
					_tmp88_ = _data1_->test_iterator;
					if (!gee_iterator_next (_tmp88_)) {
						break;
					}
					_tmp89_ = iter;
					_vala_assert (gee_iterator_next (_tmp89_), "iter.next ()");
					_tmp90_ = iter;
					_tmp91_ = gee_iterator_get (_tmp90_);
					_tmp92_ = (gchar*) _tmp91_;
					_tmp93_ = _data1_->test_iterator;
					_tmp94_ = gee_iterator_get (_tmp93_);
					_tmp95_ = (gchar*) _tmp94_;
					_vala_assert (g_strcmp0 (_tmp92_, _tmp95_) == 0, "iter.get () == test_iterator.get ()");
					_g_free0 (_tmp95_);
					_g_free0 (_tmp92_);
				}
				_tmp96_ = iter;
				_vala_assert (!gee_iterator_has_next (_tmp96_), "!iter.has_next ()");
				_data1_->count = 1;
				_tmp97_ = self->test_collection;
				_tmp98_ = gee_iterable_iterator ((GeeIterable*) _tmp97_);
				_g_object_unref0 (_data1_->test_iterator);
				_data1_->test_iterator = _tmp98_;
				_tmp99_ = self->test_collection;
				_tmp100_ = gee_iterable_iterator ((GeeIterable*) _tmp99_);
				_g_object_unref0 (iter);
				iter = _tmp100_;
				_tmp101_ = iter;
				_vala_assert (gee_iterator_next (_tmp101_), "iter.next ()");
				_tmp102_ = iter;
				_vala_assert (gee_iterator_next (_tmp102_), "iter.next ()");
				_tmp103_ = _data1_->test_iterator;
				_vala_assert (gee_iterator_next (_tmp103_), "test_iterator.next ()");
				_tmp104_ = iter;
				res = gee_traversable_foreach ((GeeTraversable*) _tmp104_, ______lambda13__gee_forall_func, _data2_);
				_vala_assert (_data1_->count == (_data2_->i + 2), "count == i + 2");
				_vala_assert (res == FALSE, "res == false");
				_tmp105_ = iter;
				_tmp106_ = gee_iterator_get_valid (_tmp105_);
				_tmp107_ = _tmp106_;
				_vala_assert (_tmp107_, "iter.valid");
				_tmp108_ = iter;
				_tmp109_ = gee_iterator_get (_tmp108_);
				_tmp110_ = (gchar*) _tmp109_;
				_tmp111_ = _data1_->test_iterator;
				_tmp112_ = gee_iterator_get (_tmp111_);
				_tmp113_ = (gchar*) _tmp112_;
				_vala_assert (g_strcmp0 (_tmp110_, _tmp113_) == 0, "iter.get () == test_iterator.get ()");
				_g_free0 (_tmp113_);
				_g_free0 (_tmp110_);
				_tmp114_ = iter;
				_vala_assert (gee_iterator_has_next (_tmp114_), "iter.has_next ()");
				while (TRUE) {
					GeeIterator* _tmp115_;
					GeeIterator* _tmp116_;
					GeeIterator* _tmp117_;
					gpointer _tmp118_;
					gchar* _tmp119_;
					GeeIterator* _tmp120_;
					gpointer _tmp121_;
					gchar* _tmp122_;
					_tmp115_ = _data1_->test_iterator;
					if (!gee_iterator_next (_tmp115_)) {
						break;
					}
					_tmp116_ = iter;
					_vala_assert (gee_iterator_next (_tmp116_), "iter.next ()");
					_tmp117_ = iter;
					_tmp118_ = gee_iterator_get (_tmp117_);
					_tmp119_ = (gchar*) _tmp118_;
					_tmp120_ = _data1_->test_iterator;
					_tmp121_ = gee_iterator_get (_tmp120_);
					_tmp122_ = (gchar*) _tmp121_;
					_vala_assert (g_strcmp0 (_tmp119_, _tmp122_) == 0, "iter.get () == test_iterator.get ()");
					_g_free0 (_tmp122_);
					_g_free0 (_tmp119_);
				}
				_tmp123_ = iter;
				_vala_assert (!gee_iterator_has_next (_tmp123_), "!iter.has_next ()");
				_data1_->count = 1;
				_tmp124_ = self->test_collection;
				_tmp125_ = gee_iterable_iterator ((GeeIterable*) _tmp124_);
				_g_object_unref0 (_data1_->test_iterator);
				_data1_->test_iterator = _tmp125_;
				_tmp126_ = self->test_collection;
				_tmp127_ = gee_iterable_iterator ((GeeIterable*) _tmp126_);
				_g_object_unref0 (iter);
				iter = _tmp127_;
				_tmp128_ = iter;
				_vala_assert (gee_iterator_next (_tmp128_), "iter.next ()");
				_tmp129_ = iter;
				_vala_assert (gee_iterator_next (_tmp129_), "iter.next ()");
				_tmp130_ = iter;
				_vala_assert (gee_iterator_has_next (_tmp130_), "iter.has_next ()");
				_tmp131_ = _data1_->test_iterator;
				_vala_assert (gee_iterator_next (_tmp131_), "test_iterator.next ()");
				_tmp132_ = iter;
				res = gee_traversable_foreach ((GeeTraversable*) _tmp132_, ______lambda14__gee_forall_func, _data2_);
				_vala_assert (_data1_->count == (_data2_->i + 2), "count == i + 2");
				_vala_assert (res == FALSE, "res == false");
				_tmp133_ = iter;
				_tmp134_ = gee_iterator_get_valid (_tmp133_);
				_tmp135_ = _tmp134_;
				_vala_assert (_tmp135_, "iter.valid");
				_tmp136_ = iter;
				_tmp137_ = gee_iterator_get (_tmp136_);
				_tmp138_ = (gchar*) _tmp137_;
				_tmp139_ = _data1_->test_iterator;
				_tmp140_ = gee_iterator_get (_tmp139_);
				_tmp141_ = (gchar*) _tmp140_;
				_vala_assert (g_strcmp0 (_tmp138_, _tmp141_) == 0, "iter.get () == test_iterator.get ()");
				_g_free0 (_tmp141_);
				_g_free0 (_tmp138_);
				_tmp142_ = iter;
				_vala_assert (gee_iterator_has_next (_tmp142_), "iter.has_next ()");
				while (TRUE) {
					GeeIterator* _tmp143_;
					GeeIterator* _tmp144_;
					GeeIterator* _tmp145_;
					gpointer _tmp146_;
					gchar* _tmp147_;
					GeeIterator* _tmp148_;
					gpointer _tmp149_;
					gchar* _tmp150_;
					_tmp143_ = _data1_->test_iterator;
					if (!gee_iterator_next (_tmp143_)) {
						break;
					}
					_tmp144_ = iter;
					_vala_assert (gee_iterator_next (_tmp144_), "iter.next ()");
					_tmp145_ = iter;
					_tmp146_ = gee_iterator_get (_tmp145_);
					_tmp147_ = (gchar*) _tmp146_;
					_tmp148_ = _data1_->test_iterator;
					_tmp149_ = gee_iterator_get (_tmp148_);
					_tmp150_ = (gchar*) _tmp149_;
					_vala_assert (g_strcmp0 (_tmp147_, _tmp150_) == 0, "iter.get () == test_iterator.get ()");
					_g_free0 (_tmp150_);
					_g_free0 (_tmp147_);
				}
				_tmp151_ = iter;
				_vala_assert (!gee_iterator_has_next (_tmp151_), "!iter.has_next ()");
			}
		}
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_g_object_unref0 (iter);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		CollectionTests* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->test_iterator);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gint
__lambda15_ (CollectionTests* self,
             gchar* x,
             gint y)
{
	gint result = 0;
	g_return_val_if_fail (x != NULL, 0);
	g_assert_not_reached ();
	_g_free0 (x);
	return result;
}

static gpointer
___lambda15__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda15_ ((CollectionTests*) self, (gchar*) g, (gint) ((gintptr) a)));
	return result;
}

static gint
__lambda16_ (CollectionTests* self,
             gchar* x,
             gint y)
{
	gint result = 0;
	g_return_val_if_fail (x != NULL, 0);
	g_assert_not_reached ();
	_g_free0 (x);
	return result;
}

static gpointer
___lambda16__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda16_ ((CollectionTests*) self, (gchar*) g, (gint) ((gintptr) a)));
	return result;
}

static gint
__lambda17_ (Block3Data* _data3_,
             gchar* x,
             gint y)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	self = _data3_->self;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = _data3_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data3_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	result = y + 1;
	_g_free0 (x);
	return result;
}

static gpointer
___lambda17__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda17_ (self, (gchar*) g, (gint) ((gintptr) a)));
	return result;
}

static gint
__lambda18_ (Block3Data* _data3_,
             gchar* x,
             gint y)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	self = _data3_->self;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = _data3_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data3_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	result = y + 1;
	_g_free0 (x);
	return result;
}

static gpointer
___lambda18__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda18_ (self, (gchar*) g, (gint) ((gintptr) a)));
	return result;
}

static gint
__lambda19_ (Block3Data* _data3_,
             gchar* x,
             gint y)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	self = _data3_->self;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = _data3_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data3_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	result = y + 1;
	_g_free0 (x);
	return result;
}

static gpointer
___lambda19__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda19_ (self, (gchar*) g, (gint) ((gintptr) a)));
	return result;
}

static gint
__lambda20_ (Block3Data* _data3_,
             gchar* x,
             gint y)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	self = _data3_->self;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = _data3_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data3_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (x, _tmp3_) == 0, "x == test_iterator.get ()");
	_g_free0 (_tmp3_);
	result = y + 1;
	_g_free0 (x);
	return result;
}

static gpointer
___lambda20__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda20_ (self, (gchar*) g, (gint) ((gintptr) a)));
	return result;
}

void
collection_tests_test_fold (CollectionTests* self)
{
	Block3Data* _data3_;
	gint count = 0;
	gchar** data = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint data_length1;
	gint _data_size_;
	GeeCollection* _tmp2_;
	gpointer _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	gpointer _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeCollection* _tmp11_;
	GeeIterator* _tmp12_;
	GeeCollection* _tmp13_;
	gpointer _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GeeCollection* _tmp16_;
	GeeIterator* _tmp17_;
	GeeCollection* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	gpointer _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GeeCollection* _tmp23_;
	GeeIterator* _tmp24_;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp25_;
	GeeIterator* _tmp26_;
	GeeIterator* _tmp27_;
	GeeIterator* _tmp28_;
	GeeIterator* _tmp29_;
	GeeIterator* _tmp30_;
	gpointer _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	GeeCollection* _tmp33_;
	GeeIterator* _tmp34_;
	GeeCollection* _tmp35_;
	GeeIterator* _tmp36_;
	GeeIterator* _tmp37_;
	GeeIterator* _tmp38_;
	GeeIterator* _tmp39_;
	GeeIterator* _tmp40_;
	GeeIterator* _tmp41_;
	gpointer _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp1_ = test_data_get_data (&_tmp0_);
	data = _tmp1_;
	data_length1 = _tmp0_;
	_data_size_ = data_length1;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_traversable_fold ((GeeTraversable*) _tmp2_, G_TYPE_INT, NULL, NULL, ___lambda15__gee_fold_func, self, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_traversable_fold ((GeeTraversable*) _tmp6_, G_TYPE_INT, NULL, NULL, ___lambda16__gee_fold_func, self, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp7_);
	_g_object_unref0 (_tmp6_);
	_tmp8_ = data;
	_tmp8__length1 = data_length1;
	{
		gchar** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = _tmp8_;
		el_collection_length1 = _tmp8__length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			const gchar* el = NULL;
			el = el_collection[el_it];
			{
				GeeCollection* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = self->test_collection;
				_tmp10_ = el;
				_vala_assert (gee_collection_add (_tmp9_, _tmp10_), "test_collection.add (el)");
			}
		}
	}
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
	_data3_->test_iterator = _tmp12_;
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_traversable_fold ((GeeTraversable*) _tmp13_, G_TYPE_INT, NULL, NULL, ___lambda17__gee_fold_func, _data3_, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp14_);
	_tmp15_ = data;
	_tmp15__length1 = data_length1;
	_vala_assert (count == _tmp15__length1, "count == data.length");
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
	_g_object_unref0 (_data3_->test_iterator);
	_data3_->test_iterator = _tmp17_;
	_tmp18_ = self->test_collection;
	_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_traversable_fold ((GeeTraversable*) _tmp20_, G_TYPE_INT, NULL, NULL, ___lambda18__gee_fold_func, _data3_, (gpointer) ((gintptr) 0));
	count = (gint) ((gintptr) _tmp21_);
	_g_object_unref0 (_tmp20_);
	_tmp22_ = data;
	_tmp22__length1 = data_length1;
	_vala_assert (count == _tmp22__length1, "count == data.length");
	_tmp23_ = self->test_collection;
	_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
	_g_object_unref0 (_data3_->test_iterator);
	_data3_->test_iterator = _tmp24_;
	_tmp25_ = self->test_collection;
	_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
	iter = _tmp26_;
	_tmp27_ = iter;
	_vala_assert (gee_iterator_next (_tmp27_), "iter.next ()");
	_tmp28_ = iter;
	_vala_assert (gee_iterator_next (_tmp28_), "iter.next ()");
	_tmp29_ = _data3_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp29_), "test_iterator.next ()");
	_tmp30_ = iter;
	_tmp31_ = gee_traversable_fold ((GeeTraversable*) _tmp30_, G_TYPE_INT, NULL, NULL, ___lambda19__gee_fold_func, _data3_, (gpointer) ((gintptr) 1));
	count = (gint) ((gintptr) _tmp31_);
	_tmp32_ = data;
	_tmp32__length1 = data_length1;
	_vala_assert (count == _tmp32__length1, "count == data.length");
	_tmp33_ = self->test_collection;
	_tmp34_ = gee_iterable_iterator ((GeeIterable*) _tmp33_);
	_g_object_unref0 (_data3_->test_iterator);
	_data3_->test_iterator = _tmp34_;
	_tmp35_ = self->test_collection;
	_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
	_g_object_unref0 (iter);
	iter = _tmp36_;
	_tmp37_ = iter;
	_vala_assert (gee_iterator_next (_tmp37_), "iter.next ()");
	_tmp38_ = iter;
	_vala_assert (gee_iterator_next (_tmp38_), "iter.next ()");
	_tmp39_ = iter;
	_vala_assert (gee_iterator_has_next (_tmp39_), "iter.has_next ()");
	_tmp40_ = _data3_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp40_), "test_iterator.next ()");
	_tmp41_ = iter;
	_tmp42_ = gee_traversable_fold ((GeeTraversable*) _tmp41_, G_TYPE_INT, NULL, NULL, ___lambda20__gee_fold_func, _data3_, (gpointer) ((gintptr) 1));
	count = (gint) ((gintptr) _tmp42_);
	_tmp43_ = data;
	_tmp43__length1 = data_length1;
	_vala_assert (count == _tmp43__length1, "count == data.length");
	_g_object_unref0 (iter);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		CollectionTests* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->test_iterator);
		_g_object_unref0 (_data4_->iter);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gint
__lambda21_ (CollectionTests* self,
             gchar* str)
{
	gint result = 0;
	g_return_val_if_fail (str != NULL, 0);
	g_assert_not_reached ();
	_g_free0 (str);
	return result;
}

static gpointer
___lambda21__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda21_ ((CollectionTests*) self, (gchar*) g));
	return result;
}

static gint
__lambda22_ (CollectionTests* self,
             gchar* str)
{
	gint result = 0;
	g_return_val_if_fail (str != NULL, 0);
	g_assert_not_reached ();
	_g_free0 (str);
	return result;
}

static gpointer
___lambda22__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda22_ ((CollectionTests*) self, (gchar*) g));
	return result;
}

static gint
__lambda23_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = _data4_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data4_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (str, _tmp3_) == 0, "str == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data4_->i;
	_data4_->i = _tmp4_ + 1;
	result = _tmp4_;
	_g_free0 (str);
	return result;
}

static gpointer
___lambda23__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda23_ (self, (gchar*) g));
	return result;
}

static gboolean
__lambda24_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeIterator* _tmp5_;
	gpointer _tmp6_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	_tmp0_ = _data4_->iter;
	_vala_assert (gee_iterator_has_next (_tmp0_), "iter.has_next ()");
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	_tmp1_ = _data4_->iter;
	_vala_assert (gee_iterator_next (_tmp1_), "iter.next ()");
	_tmp2_ = _data4_->iter;
	_tmp3_ = gee_iterator_get_valid (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp4_, "iter.valid");
	_tmp5_ = _data4_->iter;
	_tmp6_ = gee_iterator_get (_tmp5_);
	_vala_assert (_data4_->j == ((gint) ((gintptr) _tmp6_)), "j == iter.get ()");
	_data4_->j = _data4_->j + 1;
	_vala_assert (_data4_->j == _data4_->i, "++j == i");
	result = TRUE;
	_g_free0 (str);
	return result;
}

static gboolean
___lambda24__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda24_ (self, (gchar*) g);
	return result;
}

static gint
__lambda25_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = _data4_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data4_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (str, _tmp3_) == 0, "str == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data4_->i;
	_data4_->i = _tmp4_ + 1;
	result = _tmp4_;
	_g_free0 (str);
	return result;
}

static gpointer
___lambda25__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda25_ (self, (gchar*) g));
	return result;
}

static gboolean
__lambda26_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	_tmp0_ = _data4_->iter;
	_vala_assert (gee_iterator_has_next (_tmp0_), "iter.has_next ()");
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	_tmp1_ = _data4_->iter;
	_tmp2_ = gee_iterator_get_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gint _tmp4_;
		_tmp4_ = _data4_->j;
		_data4_->j = _tmp4_ + 1;
	}
	_tmp5_ = _data4_->iter;
	_vala_assert (gee_iterator_next (_tmp5_), "iter.next ()");
	_tmp6_ = _data4_->iter;
	_tmp7_ = gee_iterator_get_valid (_tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_, "iter.valid");
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	result = TRUE;
	_g_free0 (str);
	return result;
}

static gboolean
___lambda26__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda26_ (self, (gchar*) g);
	return result;
}

static gint
__lambda27_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = _data4_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data4_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (str, _tmp3_) == 0, "str == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data4_->i;
	_data4_->i = _tmp4_ + 1;
	result = _tmp4_;
	_g_free0 (str);
	return result;
}

static gpointer
___lambda27__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda27_ (self, (gchar*) g));
	return result;
}

static gboolean
__lambda28_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeIterator* _tmp5_;
	gpointer _tmp6_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	_tmp0_ = _data4_->iter;
	_vala_assert (gee_iterator_has_next (_tmp0_), "iter.has_next ()");
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	_tmp1_ = _data4_->iter;
	_vala_assert (gee_iterator_next (_tmp1_), "iter.next ()");
	_tmp2_ = _data4_->iter;
	_tmp3_ = gee_iterator_get_valid (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp4_, "iter.valid");
	_tmp5_ = _data4_->iter;
	_tmp6_ = gee_iterator_get (_tmp5_);
	_vala_assert (_data4_->j == ((gint) ((gintptr) _tmp6_)), "j == iter.get ()");
	_data4_->j = _data4_->j + 1;
	_vala_assert (_data4_->j == _data4_->i, "++j == i");
	result = TRUE;
	_g_free0 (str);
	return result;
}

static gboolean
___lambda28__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda28_ (self, (gchar*) g);
	return result;
}

static gint
__lambda29_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = _data4_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data4_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (str, _tmp3_) == 0, "str == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data4_->i;
	_data4_->i = _tmp4_ + 1;
	result = _tmp4_;
	_g_free0 (str);
	return result;
}

static gpointer
___lambda29__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda29_ (self, (gchar*) g));
	return result;
}

static gboolean
__lambda30_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gboolean result = FALSE;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	_tmp0_ = _data4_->iter;
	_vala_assert (gee_iterator_has_next (_tmp0_), "iter.has_next ()");
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	_tmp1_ = _data4_->iter;
	_tmp2_ = gee_iterator_get_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gint _tmp4_;
		_tmp4_ = _data4_->j;
		_data4_->j = _tmp4_ + 1;
	}
	_tmp5_ = _data4_->iter;
	_vala_assert (gee_iterator_next (_tmp5_), "iter.next ()");
	_tmp6_ = _data4_->iter;
	_tmp7_ = gee_iterator_get_valid (_tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_, "iter.valid");
	_vala_assert (_data4_->j == _data4_->i, "j == i");
	result = TRUE;
	_g_free0 (str);
	return result;
}

static gboolean
___lambda30__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda30_ (self, (gchar*) g);
	return result;
}

static gint
__lambda31_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = _data4_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data4_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (str, _tmp3_) == 0, "str == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data4_->i;
	_data4_->i = _tmp4_ + 1;
	result = _tmp4_;
	_g_free0 (str);
	return result;
}

static gpointer
___lambda31__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda31_ (self, (gchar*) g));
	return result;
}

static gint
__lambda32_ (Block4Data* _data4_,
             gchar* str)
{
	CollectionTests* self;
	gint result = 0;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = _data4_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp0_), "test_iterator.next ()");
	_tmp1_ = _data4_->test_iterator;
	_tmp2_ = gee_iterator_get (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (g_strcmp0 (str, _tmp3_) == 0, "str == test_iterator.get ()");
	_g_free0 (_tmp3_);
	_tmp4_ = _data4_->i;
	_data4_->i = _tmp4_ + 1;
	result = _tmp4_;
	_g_free0 (str);
	return result;
}

static gpointer
___lambda32__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda32_ (self, (gchar*) g));
	return result;
}

void
collection_tests_test_map (CollectionTests* self)
{
	Block4Data* _data4_;
	gchar** data = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint data_length1;
	gint _data_size_;
	GeeCollection* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	GeeCollection* _tmp9_;
	GeeIterator* _tmp10_;
	GeeIterator* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GeeIterator* _tmp16_;
	GeeIterator* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GeeCollection* _tmp21_;
	GeeIterator* _tmp22_;
	GeeCollection* _tmp23_;
	GeeIterator* _tmp24_;
	GeeIterator* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	GeeCollection* _tmp28_;
	GeeIterator* _tmp29_;
	GeeIterator* _tmp30_;
	GeeCollection* _tmp31_;
	GeeIterator* _tmp32_;
	GeeCollection* _tmp33_;
	GeeIterator* _tmp34_;
	GeeIterator* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	GeeCollection* _tmp38_;
	GeeIterator* _tmp39_;
	GeeIterator* _tmp40_;
	GeeCollection* _tmp41_;
	GeeIterator* _tmp42_;
	GeeIterator* outer_iter = NULL;
	GeeCollection* _tmp43_;
	GeeIterator* _tmp44_;
	GeeIterator* _tmp45_;
	GeeIterator* _tmp46_;
	GeeIterator* _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	GeeCollection* _tmp50_;
	GeeIterator* _tmp51_;
	GeeIterator* _tmp52_;
	GeeCollection* _tmp53_;
	GeeIterator* _tmp54_;
	GeeCollection* _tmp55_;
	GeeIterator* _tmp56_;
	GeeIterator* _tmp57_;
	GeeIterator* _tmp58_;
	GeeIterator* _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp61_;
	GeeCollection* _tmp62_;
	GeeIterator* _tmp63_;
	GeeIterator* _tmp64_;
	GeeCollection* _tmp65_;
	GeeIterator* _tmp66_;
	GeeCollection* _tmp67_;
	GeeIterator* _tmp68_;
	GeeIterator* outer_iter2 = NULL;
	GeeCollection* _tmp69_;
	GeeIterator* _tmp70_;
	GeeIterator* _tmp71_;
	GeeIterator* _tmp72_;
	GeeIterator* _tmp73_;
	GeeIterator* _tmp74_;
	GeeIterator* _tmp75_;
	GeeIterator* _tmp76_;
	GeeIterator* _tmp77_;
	GeeIterator* _tmp78_;
	gboolean _tmp79_;
	gboolean _tmp80_;
	GeeIterator* _tmp92_;
	GeeIterator* _tmp93_;
	GeeCollection* _tmp94_;
	GeeIterator* _tmp95_;
	GeeCollection* _tmp96_;
	GeeIterator* _tmp97_;
	GeeCollection* _tmp98_;
	GeeIterator* _tmp99_;
	GeeIterator* _tmp100_;
	GeeIterator* _tmp101_;
	GeeIterator* _tmp102_;
	GeeIterator* _tmp103_;
	GeeIterator* _tmp104_;
	GeeIterator* _tmp105_;
	GeeIterator* _tmp106_;
	GeeIterator* _tmp107_;
	gboolean _tmp108_;
	gboolean _tmp109_;
	GeeIterator* _tmp120_;
	GeeIterator* _tmp121_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp1_ = test_data_get_data (&_tmp0_);
	data = _tmp1_;
	data_length1 = _tmp0_;
	_data_size_ = data_length1;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_traversable_map ((GeeTraversable*) _tmp2_, G_TYPE_INT, NULL, NULL, ___lambda21__gee_map_func, self);
	_data4_->iter = _tmp3_;
	_tmp4_ = _data4_->iter;
	_tmp5_ = gee_iterator_get_valid (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (!_tmp6_, "!iter.valid");
	_tmp7_ = _data4_->iter;
	_vala_assert (!gee_iterator_has_next (_tmp7_), "!iter.has_next ()");
	_tmp8_ = _data4_->iter;
	_vala_assert (!gee_iterator_next (_tmp8_), "!iter.next ()");
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_traversable_map ((GeeTraversable*) _tmp11_, G_TYPE_INT, NULL, NULL, ___lambda22__gee_map_func, self);
	_g_object_unref0 (_data4_->iter);
	_data4_->iter = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_tmp13_ = _data4_->iter;
	_tmp14_ = gee_iterator_get_valid (_tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (!_tmp15_, "!iter.valid");
	_tmp16_ = _data4_->iter;
	_vala_assert (!gee_iterator_has_next (_tmp16_), "!iter.has_next ()");
	_tmp17_ = _data4_->iter;
	_vala_assert (!gee_iterator_next (_tmp17_), "!iter.next ()");
	_tmp18_ = data;
	_tmp18__length1 = data_length1;
	{
		gchar** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = _tmp18_;
		el_collection_length1 = _tmp18__length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			const gchar* el = NULL;
			el = el_collection[el_it];
			{
				GeeCollection* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = self->test_collection;
				_tmp20_ = el;
				_vala_assert (gee_collection_add (_tmp19_, _tmp20_), "test_collection.add (el)");
			}
		}
	}
	_data4_->i = 0;
	_data4_->j = 0;
	_tmp21_ = self->test_collection;
	_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
	_data4_->test_iterator = _tmp22_;
	_tmp23_ = self->test_collection;
	_tmp24_ = gee_traversable_map ((GeeTraversable*) _tmp23_, G_TYPE_INT, NULL, NULL, ___lambda23__gee_map_func, _data4_);
	_g_object_unref0 (_data4_->iter);
	_data4_->iter = _tmp24_;
	_tmp25_ = _data4_->iter;
	_tmp26_ = gee_iterator_get_valid (_tmp25_);
	_tmp27_ = _tmp26_;
	_vala_assert (!_tmp27_, "!iter.valid");
	_tmp28_ = self->test_collection;
	gee_traversable_foreach ((GeeTraversable*) _tmp28_, ___lambda24__gee_forall_func, _data4_);
	_tmp29_ = _data4_->iter;
	_vala_assert (!gee_iterator_has_next (_tmp29_), "!iter.has_next ()");
	_tmp30_ = _data4_->iter;
	_vala_assert (!gee_iterator_next (_tmp30_), "!iter.next ()");
	_data4_->i = 0;
	_data4_->j = 0;
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
	_g_object_unref0 (_data4_->test_iterator);
	_data4_->test_iterator = _tmp32_;
	_tmp33_ = self->test_collection;
	_tmp34_ = gee_traversable_map ((GeeTraversable*) _tmp33_, G_TYPE_INT, NULL, NULL, ___lambda25__gee_map_func, _data4_);
	_g_object_unref0 (_data4_->iter);
	_data4_->iter = _tmp34_;
	_tmp35_ = _data4_->iter;
	_tmp36_ = gee_iterator_get_valid (_tmp35_);
	_tmp37_ = _tmp36_;
	_vala_assert (!_tmp37_, "!iter.valid");
	_tmp38_ = self->test_collection;
	gee_traversable_foreach ((GeeTraversable*) _tmp38_, ___lambda26__gee_forall_func, _data4_);
	_tmp39_ = _data4_->iter;
	_vala_assert (!gee_iterator_has_next (_tmp39_), "!iter.has_next ()");
	_tmp40_ = _data4_->iter;
	_vala_assert (!gee_iterator_next (_tmp40_), "!iter.next ()");
	_data4_->i = 0;
	_data4_->j = 0;
	_tmp41_ = self->test_collection;
	_tmp42_ = gee_iterable_iterator ((GeeIterable*) _tmp41_);
	_g_object_unref0 (_data4_->test_iterator);
	_data4_->test_iterator = _tmp42_;
	_tmp43_ = self->test_collection;
	_tmp44_ = gee_iterable_iterator ((GeeIterable*) _tmp43_);
	outer_iter = _tmp44_;
	_tmp45_ = outer_iter;
	_tmp46_ = gee_traversable_map ((GeeTraversable*) _tmp45_, G_TYPE_INT, NULL, NULL, ___lambda27__gee_map_func, _data4_);
	_g_object_unref0 (_data4_->iter);
	_data4_->iter = _tmp46_;
	_tmp47_ = _data4_->iter;
	_tmp48_ = gee_iterator_get_valid (_tmp47_);
	_tmp49_ = _tmp48_;
	_vala_assert (!_tmp49_, "!iter.valid");
	_tmp50_ = self->test_collection;
	gee_traversable_foreach ((GeeTraversable*) _tmp50_, ___lambda28__gee_forall_func, _data4_);
	_tmp51_ = _data4_->iter;
	_vala_assert (!gee_iterator_has_next (_tmp51_), "!iter.has_next ()");
	_tmp52_ = _data4_->iter;
	_vala_assert (!gee_iterator_next (_tmp52_), "!iter.next ()");
	_data4_->i = 0;
	_data4_->j = 0;
	_tmp53_ = self->test_collection;
	_tmp54_ = gee_iterable_iterator ((GeeIterable*) _tmp53_);
	_g_object_unref0 (_data4_->test_iterator);
	_data4_->test_iterator = _tmp54_;
	_tmp55_ = self->test_collection;
	_tmp56_ = gee_iterable_iterator ((GeeIterable*) _tmp55_);
	_g_object_unref0 (outer_iter);
	outer_iter = _tmp56_;
	_tmp57_ = outer_iter;
	_tmp58_ = gee_traversable_map ((GeeTraversable*) _tmp57_, G_TYPE_INT, NULL, NULL, ___lambda29__gee_map_func, _data4_);
	_g_object_unref0 (_data4_->iter);
	_data4_->iter = _tmp58_;
	_tmp59_ = _data4_->iter;
	_tmp60_ = gee_iterator_get_valid (_tmp59_);
	_tmp61_ = _tmp60_;
	_vala_assert (!_tmp61_, "!iter.valid");
	_tmp62_ = self->test_collection;
	gee_traversable_foreach ((GeeTraversable*) _tmp62_, ___lambda30__gee_forall_func, _data4_);
	_tmp63_ = _data4_->iter;
	_vala_assert (!gee_iterator_has_next (_tmp63_), "!iter.has_next ()");
	_tmp64_ = _data4_->iter;
	_vala_assert (!gee_iterator_next (_tmp64_), "!iter.next ()");
	_data4_->i = 1;
	_data4_->j = 1;
	_tmp65_ = self->test_collection;
	_tmp66_ = gee_iterable_iterator ((GeeIterable*) _tmp65_);
	_g_object_unref0 (_data4_->test_iterator);
	_data4_->test_iterator = _tmp66_;
	_tmp67_ = self->test_collection;
	_tmp68_ = gee_iterable_iterator ((GeeIterable*) _tmp67_);
	_g_object_unref0 (outer_iter);
	outer_iter = _tmp68_;
	_tmp69_ = self->test_collection;
	_tmp70_ = gee_iterable_iterator ((GeeIterable*) _tmp69_);
	outer_iter2 = _tmp70_;
	_tmp71_ = outer_iter;
	_vala_assert (gee_iterator_next (_tmp71_), "outer_iter.next ()");
	_tmp72_ = outer_iter2;
	_vala_assert (gee_iterator_next (_tmp72_), "outer_iter2.next ()");
	_tmp73_ = outer_iter;
	_vala_assert (gee_iterator_next (_tmp73_), "outer_iter.next ()");
	_tmp74_ = outer_iter2;
	_vala_assert (gee_iterator_next (_tmp74_), "outer_iter2.next ()");
	_tmp75_ = _data4_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp75_), "test_iterator.next ()");
	_tmp76_ = outer_iter;
	_tmp77_ = gee_traversable_map ((GeeTraversable*) _tmp76_, G_TYPE_INT, NULL, NULL, ___lambda31__gee_map_func, _data4_);
	_g_object_unref0 (_data4_->iter);
	_data4_->iter = _tmp77_;
	_tmp78_ = _data4_->iter;
	_tmp79_ = gee_iterator_get_valid (_tmp78_);
	_tmp80_ = _tmp79_;
	_vala_assert (_tmp80_, "iter.valid");
	{
		gboolean _tmp81_ = FALSE;
		_tmp81_ = TRUE;
		while (TRUE) {
			GeeIterator* _tmp83_;
			GeeIterator* _tmp84_;
			GeeIterator* _tmp85_;
			gpointer _tmp86_;
			GeeIterator* _tmp87_;
			GeeIterator* _tmp88_;
			GeeIterator* _tmp89_;
			gboolean _tmp90_;
			gboolean _tmp91_;
			if (!_tmp81_) {
				GeeIterator* _tmp82_;
				_tmp82_ = outer_iter2;
				if (!gee_iterator_next (_tmp82_)) {
					break;
				}
			}
			_tmp81_ = FALSE;
			_vala_assert (_data4_->i == _data4_->j, "i == j");
			_tmp83_ = outer_iter2;
			_tmp84_ = _data4_->iter;
			_vala_assert (gee_iterator_has_next (_tmp83_) == gee_iterator_has_next (_tmp84_), "outer_iter2.has_next () == iter.has_next ()");
			_vala_assert (_data4_->i == _data4_->j, "i == j");
			_tmp85_ = _data4_->iter;
			_tmp86_ = gee_iterator_get (_tmp85_);
			_vala_assert (_data4_->j == ((gint) ((gintptr) _tmp86_)), "j == iter.get ()");
			_data4_->j = _data4_->j + 1;
			_vala_assert (_data4_->j == _data4_->i, "++j == i");
			_tmp87_ = outer_iter2;
			_tmp88_ = _data4_->iter;
			_vala_assert (gee_iterator_has_next (_tmp87_) == gee_iterator_next (_tmp88_), "outer_iter2.has_next () == iter.next ()");
			_tmp89_ = _data4_->iter;
			_tmp90_ = gee_iterator_get_valid (_tmp89_);
			_tmp91_ = _tmp90_;
			_vala_assert (_tmp91_, "iter.valid");
		}
	}
	_tmp92_ = _data4_->iter;
	_vala_assert (!gee_iterator_has_next (_tmp92_), "!iter.has_next ()");
	_tmp93_ = _data4_->iter;
	_vala_assert (!gee_iterator_next (_tmp93_), "!iter.next ()");
	_data4_->i = 1;
	_data4_->j = 1;
	_tmp94_ = self->test_collection;
	_tmp95_ = gee_iterable_iterator ((GeeIterable*) _tmp94_);
	_g_object_unref0 (_data4_->test_iterator);
	_data4_->test_iterator = _tmp95_;
	_tmp96_ = self->test_collection;
	_tmp97_ = gee_iterable_iterator ((GeeIterable*) _tmp96_);
	_g_object_unref0 (outer_iter);
	outer_iter = _tmp97_;
	_tmp98_ = self->test_collection;
	_tmp99_ = gee_iterable_iterator ((GeeIterable*) _tmp98_);
	_g_object_unref0 (outer_iter2);
	outer_iter2 = _tmp99_;
	_tmp100_ = outer_iter;
	_vala_assert (gee_iterator_next (_tmp100_), "outer_iter.next ()");
	_tmp101_ = outer_iter2;
	_vala_assert (gee_iterator_next (_tmp101_), "outer_iter2.next ()");
	_tmp102_ = outer_iter;
	_vala_assert (gee_iterator_next (_tmp102_), "outer_iter.next ()");
	_tmp103_ = outer_iter2;
	_vala_assert (gee_iterator_next (_tmp103_), "outer_iter2.next ()");
	_tmp104_ = _data4_->test_iterator;
	_vala_assert (gee_iterator_next (_tmp104_), "test_iterator.next ()");
	_tmp105_ = outer_iter;
	_tmp106_ = gee_traversable_map ((GeeTraversable*) _tmp105_, G_TYPE_INT, NULL, NULL, ___lambda32__gee_map_func, _data4_);
	_g_object_unref0 (_data4_->iter);
	_data4_->iter = _tmp106_;
	_tmp107_ = _data4_->iter;
	_tmp108_ = gee_iterator_get_valid (_tmp107_);
	_tmp109_ = _tmp108_;
	_vala_assert (_tmp109_, "iter.valid");
	{
		gboolean _tmp110_ = FALSE;
		_tmp110_ = TRUE;
		while (TRUE) {
			GeeIterator* _tmp112_;
			GeeIterator* _tmp113_;
			GeeIterator* _tmp114_;
			GeeIterator* _tmp115_;
			gint _tmp116_;
			GeeIterator* _tmp117_;
			gboolean _tmp118_;
			gboolean _tmp119_;
			if (!_tmp110_) {
				GeeIterator* _tmp111_;
				_tmp111_ = outer_iter2;
				if (!gee_iterator_next (_tmp111_)) {
					break;
				}
			}
			_tmp110_ = FALSE;
			_vala_assert (_data4_->i == _data4_->j, "i == j");
			_tmp112_ = outer_iter2;
			_tmp113_ = _data4_->iter;
			_vala_assert (gee_iterator_has_next (_tmp112_) == gee_iterator_has_next (_tmp113_), "outer_iter2.has_next () == iter.has_next ()");
			_vala_assert (_data4_->i == _data4_->j, "i == j");
			_tmp114_ = outer_iter2;
			_tmp115_ = _data4_->iter;
			_vala_assert (gee_iterator_has_next (_tmp114_) == gee_iterator_next (_tmp115_), "outer_iter2.has_next () == iter.next ()");
			_tmp116_ = _data4_->j;
			_data4_->j = _tmp116_ + 1;
			_tmp117_ = _data4_->iter;
			_tmp118_ = gee_iterator_get_valid (_tmp117_);
			_tmp119_ = _tmp118_;
			_vala_assert (_tmp119_, "iter.valid");
		}
	}
	_tmp120_ = _data4_->iter;
	_vala_assert (!gee_iterator_has_next (_tmp120_), "!iter.has_next ()");
	_tmp121_ = _data4_->iter;
	_vala_assert (!gee_iterator_next (_tmp121_), "!iter.next ()");
	_g_object_unref0 (outer_iter2);
	_g_object_unref0 (outer_iter);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		CollectionTests* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gint
__lambda33_ (Block5Data* _data5_,
             gchar* str,
             gint cur)
{
	CollectionTests* self;
	gint result = 0;
	self = _data5_->self;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "one") == 0) {
		_vala_assert (!_data5_->one, "!one");
		_data5_->one = TRUE;
	} else {
		if (g_strcmp0 (str, "two") == 0) {
			_vala_assert (!_data5_->two, "!two");
			_data5_->two = TRUE;
		} else {
			if (g_strcmp0 (str, "three") == 0) {
				_vala_assert (!_data5_->three, "!three");
				_data5_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	result = cur + 1;
	_g_free0 (str);
	return result;
}

static gpointer
___lambda33__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda33_ (self, (gchar*) g, (gint) ((gintptr) a)));
	return result;
}

static gint
__lambda34_ (Block5Data* _data5_,
             gchar* str,
             gint cur)
{
	CollectionTests* self;
	gint result = 0;
	self = _data5_->self;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "one") == 0) {
		_vala_assert (!_data5_->one, "!one");
		_data5_->one = TRUE;
	} else {
		if (g_strcmp0 (str, "two") == 0) {
			_vala_assert (!_data5_->two, "!two");
			_data5_->two = TRUE;
		} else {
			if (g_strcmp0 (str, "three") == 0) {
				_vala_assert (!_data5_->three, "!three");
				_data5_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	result = cur + 1;
	_g_free0 (str);
	return result;
}

static gpointer
___lambda34__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda34_ (self, (gchar*) g, (gint) ((gintptr) a)));
	return result;
}

void
collection_tests_test_scan (CollectionTests* self)
{
	Block5Data* _data5_;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	gint j = 0;
	GeeCollection* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GeeCollection* _tmp18_;
	GeeIterator* _tmp19_;
	GeeCollection* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp0_, "one"), "test_collection.add (\"one\")");
	_tmp1_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp1_, "two"), "test_collection.add (\"two\")");
	_tmp2_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp2_, "three"), "test_collection.add (\"three\")");
	_data5_->one = FALSE;
	_data5_->two = FALSE;
	_data5_->three = FALSE;
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_traversable_scan ((GeeTraversable*) _tmp5_, G_TYPE_INT, NULL, NULL, ___lambda33__gee_fold_func, _data5_, (gpointer) ((gintptr) 0));
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	iter = _tmp7_;
	j = 0;
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			gint _tmp14_;
			if (!_tmp8_) {
				GeeIterator* _tmp9_;
				_tmp9_ = iter;
				if (!gee_iterator_next (_tmp9_)) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp10_ = iter;
			_tmp11_ = gee_iterator_get (_tmp10_);
			_vala_assert (j == ((gint) ((gintptr) _tmp11_)), "j == iter.get ()");
			_tmp12_ = iter;
			_tmp13_ = gee_iterator_get (_tmp12_);
			_vala_assert (j == ((gint) ((gintptr) _tmp13_)), "j == iter.get ()");
			_tmp14_ = j;
			j = _tmp14_ + 1;
		}
	}
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_get_size (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_assert (j == (_tmp17_ + 1), "j == test_collection.size + 1");
	_vala_assert (_data5_->one, "one");
	_vala_assert (_data5_->two, "two");
	_vala_assert (_data5_->three, "three");
	_data5_->three = FALSE;
	_data5_->two = _data5_->three;
	_data5_->one = _data5_->two;
	j = 0;
	_tmp18_ = self->test_collection;
	_tmp19_ = gee_traversable_scan ((GeeTraversable*) _tmp18_, G_TYPE_INT, NULL, NULL, ___lambda34__gee_fold_func, _data5_, (gpointer) ((gintptr) 0));
	_g_object_unref0 (iter);
	iter = _tmp19_;
	{
		gboolean _tmp20_ = FALSE;
		_tmp20_ = TRUE;
		while (TRUE) {
			GeeIterator* _tmp22_;
			gpointer _tmp23_;
			GeeIterator* _tmp24_;
			gpointer _tmp25_;
			gint _tmp26_;
			if (!_tmp20_) {
				GeeIterator* _tmp21_;
				_tmp21_ = iter;
				if (!gee_iterator_next (_tmp21_)) {
					break;
				}
			}
			_tmp20_ = FALSE;
			_tmp22_ = iter;
			_tmp23_ = gee_iterator_get (_tmp22_);
			_vala_assert (j == ((gint) ((gintptr) _tmp23_)), "j == iter.get ()");
			_tmp24_ = iter;
			_tmp25_ = gee_iterator_get (_tmp24_);
			_vala_assert (j == ((gint) ((gintptr) _tmp25_)), "j == iter.get ()");
			_tmp26_ = j;
			j = _tmp26_ + 1;
		}
	}
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_vala_assert (j == (_tmp29_ + 1), "j == test_collection.size + 1");
	_vala_assert (_data5_->one, "one");
	_vala_assert (_data5_->two, "two");
	_vala_assert (_data5_->three, "three");
	_g_object_unref0 (iter);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		CollectionTests* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
__lambda35_ (Block6Data* _data6_,
             const gchar* str)
{
	CollectionTests* self;
	gboolean result = FALSE;
	self = _data6_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "one") == 0) {
		_vala_assert (!_data6_->one, "!one");
		_data6_->one = TRUE;
	} else {
		if (g_strcmp0 (str, "two") == 0) {
			_vala_assert (!_data6_->two, "!two");
			_data6_->two = TRUE;
		} else {
			if (g_strcmp0 (str, "three") == 0) {
				_vala_assert (!_data6_->three, "!three");
				_data6_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	result = g_strcmp0 (str, "two") != 0;
	return result;
}

static gboolean
___lambda35__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda35_ (self, (const gchar*) g);
	return result;
}

static gboolean
__lambda36_ (Block6Data* _data6_,
             const gchar* str)
{
	CollectionTests* self;
	gboolean result = FALSE;
	self = _data6_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "one") == 0) {
		_vala_assert (!_data6_->one, "!one");
		_data6_->one = TRUE;
	} else {
		if (g_strcmp0 (str, "two") == 0) {
			_vala_assert (!_data6_->two, "!two");
			_data6_->two = TRUE;
		} else {
			if (g_strcmp0 (str, "three") == 0) {
				_vala_assert (!_data6_->three, "!three");
				_data6_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	result = g_strcmp0 (str, "two") != 0;
	return result;
}

static gboolean
___lambda36__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda36_ (self, (const gchar*) g);
	return result;
}

void
collection_tests_test_filter (CollectionTests* self)
{
	Block6Data* _data6_;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gint j = 0;
	GeeCollection* _tmp16_;
	GeeIterator* _tmp17_;
	GeeIterator* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp0_, "one"), "test_collection.add (\"one\")");
	_tmp1_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp1_, "two"), "test_collection.add (\"two\")");
	_tmp2_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp2_, "three"), "test_collection.add (\"three\")");
	_data6_->one = FALSE;
	_data6_->two = FALSE;
	_data6_->three = FALSE;
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_traversable_filter ((GeeTraversable*) _tmp5_, ___lambda35__gee_predicate, block6_data_ref (_data6_), block6_data_unref);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	iter = _tmp7_;
	_tmp8_ = iter;
	_tmp9_ = gee_iterator_get_valid (_tmp8_);
	_tmp10_ = _tmp9_;
	_vala_assert (!_tmp10_, "!iter.valid");
	j = 0;
	while (TRUE) {
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		gpointer _tmp13_;
		gchar* _tmp14_;
		gint _tmp15_;
		_tmp11_ = iter;
		if (!gee_iterator_next (_tmp11_)) {
			break;
		}
		_tmp12_ = iter;
		_tmp13_ = gee_iterator_get (_tmp12_);
		_tmp14_ = (gchar*) _tmp13_;
		_vala_assert (g_strcmp0 (_tmp14_, "two") != 0, "iter.get () != \"two\"");
		_g_free0 (_tmp14_);
		_tmp15_ = j;
		j = _tmp15_ + 1;
	}
	_vala_assert (j == 2, "j == 2");
	_vala_assert (_data6_->one, "one");
	_vala_assert (_data6_->two, "two");
	_vala_assert (_data6_->three, "three");
	_data6_->three = FALSE;
	_data6_->two = _data6_->three;
	_data6_->one = _data6_->two;
	j = 0;
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_traversable_filter ((GeeTraversable*) _tmp16_, ___lambda36__gee_predicate, block6_data_ref (_data6_), block6_data_unref);
	_g_object_unref0 (iter);
	iter = _tmp17_;
	_tmp18_ = iter;
	_tmp19_ = gee_iterator_get_valid (_tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (!_tmp20_, "!iter.valid");
	while (TRUE) {
		GeeIterator* _tmp21_;
		GeeIterator* _tmp22_;
		gpointer _tmp23_;
		gchar* _tmp24_;
		gint _tmp25_;
		_tmp21_ = iter;
		if (!gee_iterator_next (_tmp21_)) {
			break;
		}
		_tmp22_ = iter;
		_tmp23_ = gee_iterator_get (_tmp22_);
		_tmp24_ = (gchar*) _tmp23_;
		_vala_assert (g_strcmp0 (_tmp24_, "two") != 0, "iter.get () != \"two\"");
		_g_free0 (_tmp24_);
		_tmp25_ = j;
		j = _tmp25_ + 1;
	}
	_vala_assert (j == 2, "j == 2");
	_vala_assert (_data6_->one, "one");
	_vala_assert (_data6_->two, "two");
	_vala_assert (_data6_->three, "three");
	_g_object_unref0 (iter);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

void
collection_tests_test_chop (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GeeIterator* iter2 = NULL;
	GeeCollection* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	gchar* _tmp18_;
	GeeIterator* _tmp19_;
	gpointer _tmp20_;
	gchar* _tmp21_;
	GeeIterator* _tmp22_;
	GeeIterator* _tmp23_;
	GeeCollection* _tmp24_;
	GeeIterator* _tmp25_;
	GeeIterator* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GeeCollection* _tmp29_;
	GeeIterator* _tmp30_;
	GeeIterator* _tmp31_;
	GeeIterator* _tmp32_;
	GeeIterator* _tmp33_;
	GeeIterator* _tmp34_;
	gpointer _tmp35_;
	gchar* _tmp36_;
	GeeIterator* _tmp37_;
	gpointer _tmp38_;
	gchar* _tmp39_;
	GeeIterator* _tmp40_;
	GeeIterator* _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp0_, "one"), "test_collection.add (\"one\")");
	_tmp1_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp1_, "two"), "test_collection.add (\"two\")");
	_tmp2_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp2_, "three"), "test_collection.add (\"three\")");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_traversable_chop ((GeeTraversable*) _tmp5_, 1, 1);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	iter = _tmp7_;
	_tmp8_ = iter;
	_tmp9_ = gee_iterator_get_valid (_tmp8_);
	_tmp10_ = _tmp9_;
	_vala_assert (!_tmp10_, "!iter.valid");
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
	iter2 = _tmp12_;
	_tmp13_ = iter2;
	_vala_assert (gee_iterator_next (_tmp13_), "iter2.next ()");
	_tmp14_ = iter2;
	_vala_assert (gee_iterator_next (_tmp14_), "iter2.next ()");
	_tmp15_ = iter;
	_vala_assert (gee_iterator_next (_tmp15_), "iter.next ()");
	_tmp16_ = iter2;
	_tmp17_ = gee_iterator_get (_tmp16_);
	_tmp18_ = (gchar*) _tmp17_;
	_tmp19_ = iter;
	_tmp20_ = gee_iterator_get (_tmp19_);
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp18_, _tmp21_) == 0, "iter2.get () == iter.get ()");
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	_tmp22_ = iter;
	_vala_assert (!gee_iterator_next (_tmp22_), "!iter.next ()");
	_tmp23_ = iter2;
	_vala_assert (gee_iterator_next (_tmp23_), "iter2.next ()");
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_traversable_chop ((GeeTraversable*) _tmp24_, 1, 1);
	_g_object_unref0 (iter);
	iter = _tmp25_;
	_tmp26_ = iter;
	_tmp27_ = gee_iterator_get_valid (_tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (!_tmp28_, "!iter.valid");
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_iterable_iterator ((GeeIterable*) _tmp29_);
	_g_object_unref0 (iter2);
	iter2 = _tmp30_;
	_tmp31_ = iter2;
	_vala_assert (gee_iterator_next (_tmp31_), "iter2.next ()");
	_tmp32_ = iter2;
	_vala_assert (gee_iterator_next (_tmp32_), "iter2.next ()");
	_tmp33_ = iter;
	_vala_assert (gee_iterator_next (_tmp33_), "iter.next ()");
	_tmp34_ = iter2;
	_tmp35_ = gee_iterator_get (_tmp34_);
	_tmp36_ = (gchar*) _tmp35_;
	_tmp37_ = iter;
	_tmp38_ = gee_iterator_get (_tmp37_);
	_tmp39_ = (gchar*) _tmp38_;
	_vala_assert (g_strcmp0 (_tmp36_, _tmp39_) == 0, "iter2.get () == iter.get ()");
	_g_free0 (_tmp39_);
	_g_free0 (_tmp36_);
	_tmp40_ = iter;
	_vala_assert (!gee_iterator_next (_tmp40_), "!iter.next ()");
	_tmp41_ = iter2;
	_vala_assert (gee_iterator_next (_tmp41_), "iter2.next ()");
	_g_object_unref0 (iter2);
	_g_object_unref0 (iter);
}

static gboolean
__lambda37_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "one") == 0;
	return result;
}

static gboolean
___lambda37__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda37_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

static gboolean
__lambda38_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "two") == 0;
	return result;
}

static gboolean
___lambda38__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda38_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

static gboolean
__lambda39_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "three") == 0;
	return result;
}

static gboolean
___lambda39__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda39_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

static gboolean
__lambda40_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "four") == 0;
	return result;
}

static gboolean
___lambda40__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda40_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

void
collection_tests_test_first_match (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	GeeCollection* _tmp6_;
	gpointer _tmp7_;
	gchar* _tmp8_;
	GeeCollection* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	GeeCollection* _tmp12_;
	gpointer _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp0_, "one"), "test_collection.add (\"one\")");
	_tmp1_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp1_, "two"), "test_collection.add (\"two\")");
	_tmp2_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp2_, "three"), "test_collection.add (\"three\")");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_traversable_first_match ((GeeTraversable*) _tmp3_, ___lambda37__gee_predicate, g_object_ref (self), g_object_unref);
	_tmp5_ = (gchar*) _tmp4_;
	_vala_assert (g_strcmp0 (_tmp5_, "one") == 0, "test_collection.first_match ((x) => x == \"one\") == \"one\"");
	_g_free0 (_tmp5_);
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_traversable_first_match ((GeeTraversable*) _tmp6_, ___lambda38__gee_predicate, g_object_ref (self), g_object_unref);
	_tmp8_ = (gchar*) _tmp7_;
	_vala_assert (g_strcmp0 (_tmp8_, "two") == 0, "test_collection.first_match ((x) => x == \"two\") == \"two\"");
	_g_free0 (_tmp8_);
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_traversable_first_match ((GeeTraversable*) _tmp9_, ___lambda39__gee_predicate, g_object_ref (self), g_object_unref);
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "three") == 0, "test_collection.first_match ((x) => x == \"three\") == \"three\"");
	_g_free0 (_tmp11_);
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_traversable_first_match ((GeeTraversable*) _tmp12_, ___lambda40__gee_predicate, g_object_ref (self), g_object_unref);
	_tmp14_ = (gchar*) _tmp13_;
	_vala_assert (_tmp14_ == NULL, "test_collection.first_match ((x) => x == \"four\") == null");
	_g_free0 (_tmp14_);
}

static gboolean
__lambda41_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "one") == 0;
	return result;
}

static gboolean
___lambda41__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda41_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

static gboolean
__lambda42_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "two") == 0;
	return result;
}

static gboolean
___lambda42__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda42_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

static gboolean
__lambda43_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "three") == 0;
	return result;
}

static gboolean
___lambda43__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda43_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

static gboolean
__lambda44_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "four") == 0;
	return result;
}

static gboolean
___lambda44__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda44_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

void
collection_tests_test_any_match (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp0_, "one"), "test_collection.add (\"one\")");
	_tmp1_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp1_, "two"), "test_collection.add (\"two\")");
	_tmp2_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp2_, "three"), "test_collection.add (\"three\")");
	_tmp3_ = self->test_collection;
	_vala_assert (gee_traversable_any_match ((GeeTraversable*) _tmp3_, ___lambda41__gee_predicate, g_object_ref (self), g_object_unref), "test_collection.any_match ((x) => x == \"one\")");
	_tmp4_ = self->test_collection;
	_vala_assert (gee_traversable_any_match ((GeeTraversable*) _tmp4_, ___lambda42__gee_predicate, g_object_ref (self), g_object_unref), "test_collection.any_match ((x) => x == \"two\")");
	_tmp5_ = self->test_collection;
	_vala_assert (gee_traversable_any_match ((GeeTraversable*) _tmp5_, ___lambda43__gee_predicate, g_object_ref (self), g_object_unref), "test_collection.any_match ((x) => x == \"three\")");
	_tmp6_ = self->test_collection;
	_vala_assert (!gee_traversable_any_match ((GeeTraversable*) _tmp6_, ___lambda44__gee_predicate, g_object_ref (self), g_object_unref), "!test_collection.any_match ((x) => x == \"four\")");
}

static gboolean
__lambda45_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "one") == 0;
	return result;
}

static gboolean
___lambda45__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda45_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

static gboolean
__lambda46_ (CollectionTests* self,
             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (x != NULL, FALSE);
	result = g_strcmp0 (x, "one") == 0;
	return result;
}

static gboolean
___lambda46__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda46_ ((CollectionTests*) self, (const gchar*) g);
	return result;
}

void
collection_tests_test_all_match (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp0_, "one"), "test_collection.add (\"one\")");
	_tmp1_ = self->test_collection;
	_vala_assert (gee_traversable_all_match ((GeeTraversable*) _tmp1_, ___lambda45__gee_predicate, g_object_ref (self), g_object_unref), "test_collection.all_match ((x) => x == \"one\")");
	_tmp2_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp2_, "two"), "test_collection.add (\"two\")");
	_tmp3_ = self->test_collection;
	_vala_assert (!gee_traversable_all_match ((GeeTraversable*) _tmp3_, ___lambda46__gee_predicate, g_object_ref (self), g_object_unref), "!test_collection.all_match ((x) => x == \"one\")");
}

static gint
__lambda47_ (CollectionTests* self,
             const gchar* a,
             const gchar* b)
{
	gint result = 0;
	GCompareFunc _tmp0_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	result = _tmp0_ (a, b);
	return result;
}

static gint
___lambda47__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda47_ ((CollectionTests*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

static gint
__lambda48_ (CollectionTests* self,
             const gchar* a,
             const gchar* b)
{
	gint result = 0;
	GCompareFunc _tmp0_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	result = _tmp0_ (a, b);
	return result;
}

static gint
___lambda48__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda48_ ((CollectionTests*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

void
collection_tests_test_max_min (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	GeeCollection* _tmp6_;
	gpointer _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp0_, "one"), "test_collection.add (\"one\")");
	_tmp1_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp1_, "two"), "test_collection.add (\"two\")");
	_tmp2_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp2_, "three"), "test_collection.add (\"three\")");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_traversable_max ((GeeTraversable*) _tmp3_, ___lambda47__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp5_ = (gchar*) _tmp4_;
	_vala_assert (g_strcmp0 (_tmp5_, "one") == 0, "test_collection.max ((a, b) => strcmp (a, b)) == \"one\"");
	_g_free0 (_tmp5_);
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_traversable_min ((GeeTraversable*) _tmp6_, ___lambda48__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp8_ = (gchar*) _tmp7_;
	_vala_assert (g_strcmp0 (_tmp8_, "two") == 0, "test_collection.min ((a, b) => strcmp (a, b)) == \"two\"");
	_g_free0 (_tmp8_);
}

static gint
__lambda49_ (CollectionTests* self,
             const gchar* a,
             const gchar* b)
{
	gint result = 0;
	GCompareFunc _tmp0_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	result = _tmp0_ (a, b);
	return result;
}

static gint
___lambda49__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda49_ ((CollectionTests*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

void
collection_tests_test_order_by (CollectionTests* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterator* sorted_collection = NULL;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	gchar* previous_item = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp0_, "one"), "test_collection.add (\"one\")");
	_tmp1_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp1_, "two"), "test_collection.add (\"two\")");
	_tmp2_ = self->test_collection;
	_vala_assert (gee_collection_add (_tmp2_, "three"), "test_collection.add (\"three\")");
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_traversable_order_by ((GeeTraversable*) _tmp3_, ___lambda49__gcompare_data_func, g_object_ref (self), g_object_unref);
	sorted_collection = _tmp4_;
	previous_item = NULL;
	while (TRUE) {
		GeeIterator* _tmp5_;
		gchar* item = NULL;
		GeeIterator* _tmp6_;
		gpointer _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = sorted_collection;
		if (!gee_iterator_next (_tmp5_)) {
			break;
		}
		_tmp6_ = sorted_collection;
		_tmp7_ = gee_iterator_get (_tmp6_);
		item = (gchar*) _tmp7_;
		_tmp8_ = previous_item;
		if (_tmp8_ != NULL) {
			GCompareFunc _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = ((GCompareFunc) g_strcmp0);
			_tmp10_ = previous_item;
			_tmp11_ = item;
			_vala_assert (_tmp9_ (_tmp10_, _tmp11_) <= 0, "strcmp (previous_item, item) <= 0");
		}
		_tmp12_ = item;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (previous_item);
		previous_item = _tmp13_;
		_g_free0 (item);
	}
	_g_free0 (previous_item);
	_g_object_unref0 (sorted_collection);
}

static void
collection_tests_class_init (CollectionTestsClass * klass,
                             gpointer klass_data)
{
	collection_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = collection_tests_finalize;
}

static void
collection_tests_instance_init (CollectionTests * self,
                                gpointer klass)
{
}

static void
collection_tests_finalize (GObject * obj)
{
	CollectionTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLLECTION_TESTS, CollectionTests);
	_g_object_unref0 (self->test_collection);
	G_OBJECT_CLASS (collection_tests_parent_class)->finalize (obj);
}

GType
collection_tests_get_type (void)
{
	static volatile gsize collection_tests_type_id__volatile = 0;
	if (g_once_init_enter (&collection_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CollectionTests), 0, (GInstanceInitFunc) collection_tests_instance_init, NULL };
		GType collection_tests_type_id;
		collection_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "CollectionTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&collection_tests_type_id__volatile, collection_tests_type_id);
	}
	return collection_tests_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

