// Generated by gmmproc 2.61.1 -- DO NOT MODIFY!
#ifndef _GTKMM_ICONINFO_H
#define _GTKMM_ICONINFO_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <gtkmm/stylecontext.h>
#include <gdkmm/rectangle.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/rgba.h>
#include <gdkmm/types.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkIconInfo = struct _GtkIconInfo;
using GtkIconInfoClass = struct _GtkIconInfoClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class IconInfo_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{
class Texture;
}

namespace Gtk
{

class IconTheme;


class IconInfo : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = IconInfo;
  using CppClassType = IconInfo_Class;
  using BaseObjectType = GtkIconInfo;
  using BaseClassType = GtkIconInfoClass;

  // noncopyable
  IconInfo(const IconInfo&) = delete;
  IconInfo& operator=(const IconInfo&) = delete;

private:  friend class IconInfo_Class;
  static CppClassType iconinfo_class_;

protected:
  explicit IconInfo(const Glib::ConstructParams& construct_params);
  explicit IconInfo(GtkIconInfo* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  IconInfo(IconInfo&& src) noexcept;
  IconInfo& operator=(IconInfo&& src) noexcept;

  ~IconInfo() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkIconInfo*       gobj()       { return reinterpret_cast<GtkIconInfo*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkIconInfo* gobj() const { return reinterpret_cast<GtkIconInfo*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkIconInfo* gobj_copy();

private:


protected:
  // Can't use _WRAP_CTOR(), because there are no properties that correspond
  // to the constructor's parameters.
  IconInfo(const Glib::RefPtr<IconTheme>& icon_theme, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  

public:
  /** Creates an %IconInfo for a Gdk::Pixbuf.
   *
   * @newin{3,92}
   *
   * @param icon_theme A Gtk::IconTheme.
   * @param pixbuf The pixbuf to wrap in an %IconInfo.
   * @return A RefPtr to a new %IconInfo.
   */
  
  static Glib::RefPtr<IconInfo> create(const Glib::RefPtr<IconTheme>& icon_theme, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);


  /** Gets the base size for the icon. The base size
   * is a size for the icon that was specified by
   * the icon theme creator. This may be different
   * than the actual size of image;
   * These icons will be given
   * the same base size as the larger icons to which
   * they are attached.
   * 
   * Note that for scaled icons the base size does
   * not include the base scale.
   * 
   * @return The base size, or 0, if no base
   * size is known for the icon.
   */
  int get_base_size() const;
  
  /** Gets the base scale for the icon. The base scale is a scale
   * for the icon that was specified by the icon theme creator.
   * For instance an icon drawn for a high-dpi monitor with window
   * scale 2 for a base size of 32 will be 64 pixels tall and have
   * a base scale of 2.
   * 
   * @return The base scale.
   */
  int get_base_scale() const;

  
  /** Gets the filename for the icon. If the Gtk::IconLookupFlags::USE_BUILTIN
   * flag was passed to Gtk::IconTheme::lookup_icon(), there may be no
   * filename if a builtin icon is returned; in this case, you should
   * use gtk_icon_info_get_builtin_pixbuf().
   * 
   * @return The filename for the icon, or <tt>nullptr</tt>
   * if gtk_icon_info_get_builtin_pixbuf() should
   * be used instead.
   */
  Glib::ustring get_filename() const;
  
  /** Checks if the icon is symbolic or not. This currently uses only
   * the file name and not the file contents for determining this.
   * This behaviour may change in the future.
   * 
   * @return <tt>true</tt> if the icon is symbolic, <tt>false</tt> otherwise.
   */
  bool is_symbolic() const;

  
  /** Renders an icon previously looked up in an icon theme using
   * Gtk::IconTheme::lookup_icon(); the size will be based on the size
   * passed to Gtk::IconTheme::lookup_icon(). Note that the resulting
   * pixbuf may not be exactly this size; an icon theme may have icons
   * that differ slightly from their nominal sizes, and in addition GTK+
   * will avoid scaling icons that it considers sufficiently close to the
   * requested size or for which the source image would have to be scaled
   * up too far. (This maintains sharpness.). This behaviour can be changed
   * by passing the Gtk::IconLookupFlags::FORCE_SIZE flag when obtaining
   * the Gtk::IconInfo. If this flag has been specified, the pixbuf
   * returned by this function will be scaled to the exact size.
   * 
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use Glib::object_unref() to release your reference
   * to the icon.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<const Gdk::Pixbuf> load_icon() const;
  
  /** Returns a texture object that can be used to render the icon
   * with GSK.
   * 
   * @return The icon texture; this may be a newly
   * created texture or a new reference to an exiting texture. Use
   * Glib::object_unref() to release your reference.
   */
  Glib::RefPtr<const Gdk::Texture> load_texture() const;

  
  /** Asynchronously load, render and scale an icon previously looked up
   * from the icon theme using Gtk::IconTheme::lookup_icon().
   * 
   * For more details, see load_icon() which is the synchronous
   * version of this call.
   * 
   * @param cancellable Optional Cancellable object, <tt>nullptr</tt> to ignore.
   * @param slot A SlotAsyncReady to call when the
   * request is satisfied.
   */
  void load_icon_async(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable) const;

  /// A load_icon_async() convenience overload.
  void load_icon_async(const Gio::SlotAsyncReady& slot) const;
  
  /** Finishes an async icon load, see load_icon_async().
   * 
   * @param result A Gio::AsyncResult.
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use Glib::object_unref() to release your reference
   * to the icon.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<const Gdk::Pixbuf> load_icon_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;


  /** Loads an icon, modifying it to match the system colours for the foreground,
   * success, warning and error colors provided. If the icon is not a symbolic
   * one, the function will return the result from load_icon().
   * 
   * This allows loading symbolic icons that will match the system theme.
   * 
   * Unless you are implementing a widget, you will want to use
   * Glib::themed_icon_new_with_default_fallbacks() to load the icon.
   * 
   * As implementation details, the icon loaded needs to be of SVG type,
   * contain the “symbolic” term as the last component of the icon name,
   * and use the “fg”, “success”, “warning” and “error” CSS styles in the
   * SVG file itself.
   * 
   * See the [Symbolic Icons Specification](http://www.freedesktop.org/wiki/SymbolicIcons)
   * for more information about symbolic icons.
   * 
   * @param fg A Gdk::RGBA representing the foreground color of the icon.
   * @param success_color A Gdk::RGBA representing the warning color
   * of the icon or <tt>nullptr</tt> to use the default color.
   * @param warning_color A Gdk::RGBA representing the warning color
   * of the icon or <tt>nullptr</tt> to use the default color.
   * @param error_color A Gdk::RGBA representing the error color
   * of the icon or <tt>nullptr</tt> to use the default color (allow-none).
   * @param was_symbolic A <tt>bool</tt>, returns whether the
   * loaded icon was a symbolic one and whether the @a fg color was
   * applied to it.
   * @return A Gdk::Pixbuf representing the loaded icon.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<const Gdk::Pixbuf> load_symbolic(const Gdk::RGBA& fg, const Gdk::RGBA& success_color, const Gdk::RGBA& warning_color, const Gdk::RGBA& error_color, bool& was_symbolic) const;

  // In gtk_icon_info_load_symbolic_async(), each GdkRGBA* can be NULL, but we do not want that many method overloads.
  
  /** Asynchronously load, render and scale a symbolic icon previously looked up
   * from the icon theme using Gtk::IconTheme::lookup_icon().
   * 
   * For more details, see load_symbolic() which is the synchronous
   * version of this call.
   * 
   * @param fg A Gdk::RGBA representing the foreground color of the icon.
   * @param success_color A Gdk::RGBA representing the warning color
   * of the icon or <tt>nullptr</tt> to use the default color.
   * @param warning_color A Gdk::RGBA representing the warning color
   * of the icon or <tt>nullptr</tt> to use the default color.
   * @param error_color A Gdk::RGBA representing the error color
   * of the icon or <tt>nullptr</tt> to use the default color (allow-none).
   * @param cancellable Optional Cancellable object,
   * <tt>nullptr</tt> to ignore.
   * @param slot A SlotAsyncReady to call when the
   * request is satisfied.
   */
  void load_symbolic_async(const Gdk::RGBA& fg, const Gdk::RGBA& success_color, const Gdk::RGBA& warning_color, const Gdk::RGBA& error_color, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable) const;

  /// A load_symbolic_async() convenience overload.
  void load_symbolic_async(const Gdk::RGBA& fg, const Gdk::RGBA& success_color, const Gdk::RGBA& warning_color, const Gdk::RGBA& error_color, const Gio::SlotAsyncReady& slot) const;
  
  /** Finishes an async icon load, see load_symbolic_async().
   * 
   * @param result A Gio::AsyncResult.
   * @param was_symbolic A <tt>bool</tt>, returns whether the
   * loaded icon was a symbolic one and whether the @a fg color was
   * applied to it.
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use Glib::object_unref() to release your reference
   * to the icon.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<const Gdk::Pixbuf> load_symbolic_finish(const Glib::RefPtr<Gio::AsyncResult>& result, bool& was_symbolic) const;


  /** Loads an icon, modifying it to match the system colors for the foreground,
   * success, warning and error colors provided. If the icon is not a symbolic
   * one, the function will return the result from load_icon().
   * This function uses the regular foreground color and the symbolic colors
   * with the names “success_color”, “warning_color” and “error_color” from
   * the context.
   * 
   * This allows loading symbolic icons that will match the system theme.
   * 
   * See load_symbolic() for more details.
   * 
   * @param context A Gtk::StyleContext.
   * @param was_symbolic A <tt>bool</tt>, returns whether the
   * loaded icon was a symbolic one and whether the foreground color was
   * applied to it.
   * @return A Gdk::Pixbuf representing the loaded icon.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<const Gdk::Pixbuf> load_symbolic_for_context(const Glib::RefPtr<StyleContext>& context, bool& was_symbolic) const;

  
  /** Asynchronously load, render and scale a symbolic icon previously
   * looked up from the icon theme using Gtk::IconTheme::lookup_icon().
   * 
   * For more details, see load_symbolic_for_context()
   * which is the synchronous version of this call.
   * 
   * @param context A Gtk::StyleContext.
   * @param cancellable Optional Cancellable object,
   * <tt>nullptr</tt> to ignore.
   * @param slot A SlotAsyncReady to call when the
   * request is satisfied.
   */
  void load_symbolic_for_context_async(const Glib::RefPtr<StyleContext>& context, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable) const;

  /// A load_symbolic_for_context_async() convenience overload.
  void load_symbolic_for_context_async(const Glib::RefPtr<StyleContext>& context, const Gio::SlotAsyncReady& slot) const;
 
  /** Finishes an async icon load, see load_symbolic_for_context_async().
   * 
   * @param result A Gio::AsyncResult.
   * @param was_symbolic A <tt>bool</tt>, returns whether the
   * loaded icon was a symbolic one and whether the @a fg color was
   * applied to it.
   * @return The rendered icon; this may be a newly
   * created icon or a new reference to an internal icon, so you must
   * not modify the icon. Use Glib::object_unref() to release your reference
   * to the icon.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<const Gdk::Pixbuf> load_symbolic_for_context_finish(const Glib::RefPtr<Gio::AsyncResult>& result, bool& was_symbolic) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::IconInfo
   */
  Glib::RefPtr<Gtk::IconInfo> wrap(GtkIconInfo* object, bool take_copy = false);
}


#endif /* _GTKMM_ICONINFO_H */

