// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use Error;
use SocketConnectable;
use TlsCertificate;
use TlsCertificateFlags;
use TlsDatabaseLookupFlags;
use TlsDatabaseVerifyFlags;
use TlsInteraction;
use ffi;
#[cfg(feature = "futures")]
use futures_core;
use glib::GString;
use glib::object::IsA;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
#[cfg(feature = "futures")]
use std::boxed::Box as Box_;
use std::fmt;
use std::ptr;

glib_wrapper! {
    pub struct TlsDatabase(Object<ffi::GTlsDatabase, ffi::GTlsDatabaseClass, TlsDatabaseClass>);

    match fn {
        get_type => || ffi::g_tls_database_get_type(),
    }
}

pub const NONE_TLS_DATABASE: Option<&TlsDatabase> = None;

pub trait TlsDatabaseExt: 'static {
    fn create_certificate_handle<P: IsA<TlsCertificate>>(&self, certificate: &P) -> Option<GString>;

    fn lookup_certificate_for_handle<'a, 'b, P: IsA<TlsInteraction> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>>(&self, handle: &str, interaction: Q, flags: TlsDatabaseLookupFlags, cancellable: S) -> Result<Option<TlsCertificate>, Error>;

    fn lookup_certificate_for_handle_async<'a, 'b, P: IsA<TlsInteraction> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>, T: FnOnce(Result<TlsCertificate, Error>) + Send + 'static>(&self, handle: &str, interaction: Q, flags: TlsDatabaseLookupFlags, cancellable: S, callback: T);

    #[cfg(feature = "futures")]
    fn lookup_certificate_for_handle_async_future<'a, P: IsA<TlsInteraction> + Clone + 'static, Q: Into<Option<&'a P>>>(&self, handle: &str, interaction: Q, flags: TlsDatabaseLookupFlags) -> Box_<futures_core::Future<Item = (Self, TlsCertificate), Error = (Self, Error)>> where Self: Sized + Clone;

    fn lookup_certificate_issuer<'a, 'b, P: IsA<TlsCertificate>, Q: IsA<TlsInteraction> + 'a, R: Into<Option<&'a Q>>, S: IsA<Cancellable> + 'b, T: Into<Option<&'b S>>>(&self, certificate: &P, interaction: R, flags: TlsDatabaseLookupFlags, cancellable: T) -> Result<TlsCertificate, Error>;

    fn lookup_certificate_issuer_async<'a, 'b, P: IsA<TlsCertificate>, Q: IsA<TlsInteraction> + 'a, R: Into<Option<&'a Q>>, S: IsA<Cancellable> + 'b, T: Into<Option<&'b S>>, U: FnOnce(Result<TlsCertificate, Error>) + Send + 'static>(&self, certificate: &P, interaction: R, flags: TlsDatabaseLookupFlags, cancellable: T, callback: U);

    #[cfg(feature = "futures")]
    fn lookup_certificate_issuer_async_future<'a, P: IsA<TlsCertificate> + Clone + 'static, Q: IsA<TlsInteraction> + Clone + 'static, R: Into<Option<&'a Q>>>(&self, certificate: &P, interaction: R, flags: TlsDatabaseLookupFlags) -> Box_<futures_core::Future<Item = (Self, TlsCertificate), Error = (Self, Error)>> where Self: Sized + Clone;

    //fn lookup_certificates_issued_by<'a, 'b, P: IsA<TlsInteraction> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>>(&self, issuer_raw_dn: /*Ignored*/&glib::ByteArray, interaction: Q, flags: TlsDatabaseLookupFlags, cancellable: S) -> Result<Vec<TlsCertificate>, Error>;

    //fn lookup_certificates_issued_by_async<'a, 'b, P: IsA<TlsInteraction> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>, T: FnOnce(Result<Vec<TlsCertificate>, Error>) + Send + 'static>(&self, issuer_raw_dn: /*Ignored*/&glib::ByteArray, interaction: Q, flags: TlsDatabaseLookupFlags, cancellable: S, callback: T);

    //#[cfg(feature = "futures")]
    //fn lookup_certificates_issued_by_async_future<'a, P: IsA<TlsInteraction> + Clone + 'static, Q: Into<Option<&'a P>>>(&self, issuer_raw_dn: /*Ignored*/&glib::ByteArray, interaction: Q, flags: TlsDatabaseLookupFlags) -> Box_<futures_core::Future<Item = (Self, Vec<TlsCertificate>), Error = (Self, Error)>> where Self: Sized + Clone;

    fn verify_chain<'a, 'b, 'c, P: IsA<TlsCertificate>, Q: IsA<SocketConnectable> + 'a, R: Into<Option<&'a Q>>, S: IsA<TlsInteraction> + 'b, T: Into<Option<&'b S>>, U: IsA<Cancellable> + 'c, V: Into<Option<&'c U>>>(&self, chain: &P, purpose: &str, identity: R, interaction: T, flags: TlsDatabaseVerifyFlags, cancellable: V) -> Result<TlsCertificateFlags, Error>;

    fn verify_chain_async<'a, 'b, 'c, P: IsA<TlsCertificate>, Q: IsA<SocketConnectable> + 'a, R: Into<Option<&'a Q>>, S: IsA<TlsInteraction> + 'b, T: Into<Option<&'b S>>, U: IsA<Cancellable> + 'c, V: Into<Option<&'c U>>, W: FnOnce(Result<TlsCertificateFlags, Error>) + Send + 'static>(&self, chain: &P, purpose: &str, identity: R, interaction: T, flags: TlsDatabaseVerifyFlags, cancellable: V, callback: W);

    #[cfg(feature = "futures")]
    fn verify_chain_async_future<'a, 'b, P: IsA<TlsCertificate> + Clone + 'static, Q: IsA<SocketConnectable> + Clone + 'static, R: Into<Option<&'a Q>>, S: IsA<TlsInteraction> + Clone + 'static, T: Into<Option<&'b S>>>(&self, chain: &P, purpose: &str, identity: R, interaction: T, flags: TlsDatabaseVerifyFlags) -> Box_<futures_core::Future<Item = (Self, TlsCertificateFlags), Error = (Self, Error)>> where Self: Sized + Clone;
}

impl<O: IsA<TlsDatabase>> TlsDatabaseExt for O {
    fn create_certificate_handle<P: IsA<TlsCertificate>>(&self, certificate: &P) -> Option<GString> {
        unsafe {
            from_glib_full(ffi::g_tls_database_create_certificate_handle(self.as_ref().to_glib_none().0, certificate.as_ref().to_glib_none().0))
        }
    }

    fn lookup_certificate_for_handle<'a, 'b, P: IsA<TlsInteraction> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>>(&self, handle: &str, interaction: Q, flags: TlsDatabaseLookupFlags, cancellable: S) -> Result<Option<TlsCertificate>, Error> {
        let interaction = interaction.into();
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_database_lookup_certificate_for_handle(self.as_ref().to_glib_none().0, handle.to_glib_none().0, interaction.map(|p| p.as_ref()).to_glib_none().0, flags.to_glib(), cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn lookup_certificate_for_handle_async<'a, 'b, P: IsA<TlsInteraction> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>, T: FnOnce(Result<TlsCertificate, Error>) + Send + 'static>(&self, handle: &str, interaction: Q, flags: TlsDatabaseLookupFlags, cancellable: S, callback: T) {
        let interaction = interaction.into();
        let cancellable = cancellable.into();
        let user_data: Box<T> = Box::new(callback);
        unsafe extern "C" fn lookup_certificate_for_handle_async_trampoline<T: FnOnce(Result<TlsCertificate, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_database_lookup_certificate_for_handle_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<T> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = lookup_certificate_for_handle_async_trampoline::<T>;
        unsafe {
            ffi::g_tls_database_lookup_certificate_for_handle_async(self.as_ref().to_glib_none().0, handle.to_glib_none().0, interaction.map(|p| p.as_ref()).to_glib_none().0, flags.to_glib(), cancellable.map(|p| p.as_ref()).to_glib_none().0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    fn lookup_certificate_for_handle_async_future<'a, P: IsA<TlsInteraction> + Clone + 'static, Q: Into<Option<&'a P>>>(&self, handle: &str, interaction: Q, flags: TlsDatabaseLookupFlags) -> Box_<futures_core::Future<Item = (Self, TlsCertificate), Error = (Self, Error)>> where Self: Sized + Clone {
        use GioFuture;
        use fragile::Fragile;

        let handle = String::from(handle);
        let interaction = interaction.into();
        let interaction = interaction.map(ToOwned::to_owned);
        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            let obj_clone = Fragile::new(obj.clone());
            obj.lookup_certificate_for_handle_async(
                 &handle,
                 interaction.as_ref().map(::std::borrow::Borrow::borrow),
                 flags,
                 Some(&cancellable),
                 move |res| {
                     let obj = obj_clone.into_inner();
                     let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }

    fn lookup_certificate_issuer<'a, 'b, P: IsA<TlsCertificate>, Q: IsA<TlsInteraction> + 'a, R: Into<Option<&'a Q>>, S: IsA<Cancellable> + 'b, T: Into<Option<&'b S>>>(&self, certificate: &P, interaction: R, flags: TlsDatabaseLookupFlags, cancellable: T) -> Result<TlsCertificate, Error> {
        let interaction = interaction.into();
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_database_lookup_certificate_issuer(self.as_ref().to_glib_none().0, certificate.as_ref().to_glib_none().0, interaction.map(|p| p.as_ref()).to_glib_none().0, flags.to_glib(), cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn lookup_certificate_issuer_async<'a, 'b, P: IsA<TlsCertificate>, Q: IsA<TlsInteraction> + 'a, R: Into<Option<&'a Q>>, S: IsA<Cancellable> + 'b, T: Into<Option<&'b S>>, U: FnOnce(Result<TlsCertificate, Error>) + Send + 'static>(&self, certificate: &P, interaction: R, flags: TlsDatabaseLookupFlags, cancellable: T, callback: U) {
        let interaction = interaction.into();
        let cancellable = cancellable.into();
        let user_data: Box<U> = Box::new(callback);
        unsafe extern "C" fn lookup_certificate_issuer_async_trampoline<U: FnOnce(Result<TlsCertificate, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_database_lookup_certificate_issuer_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<U> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = lookup_certificate_issuer_async_trampoline::<U>;
        unsafe {
            ffi::g_tls_database_lookup_certificate_issuer_async(self.as_ref().to_glib_none().0, certificate.as_ref().to_glib_none().0, interaction.map(|p| p.as_ref()).to_glib_none().0, flags.to_glib(), cancellable.map(|p| p.as_ref()).to_glib_none().0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    fn lookup_certificate_issuer_async_future<'a, P: IsA<TlsCertificate> + Clone + 'static, Q: IsA<TlsInteraction> + Clone + 'static, R: Into<Option<&'a Q>>>(&self, certificate: &P, interaction: R, flags: TlsDatabaseLookupFlags) -> Box_<futures_core::Future<Item = (Self, TlsCertificate), Error = (Self, Error)>> where Self: Sized + Clone {
        use GioFuture;
        use fragile::Fragile;

        let certificate = certificate.clone();
        let interaction = interaction.into();
        let interaction = interaction.map(ToOwned::to_owned);
        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            let obj_clone = Fragile::new(obj.clone());
            obj.lookup_certificate_issuer_async(
                 &certificate,
                 interaction.as_ref().map(::std::borrow::Borrow::borrow),
                 flags,
                 Some(&cancellable),
                 move |res| {
                     let obj = obj_clone.into_inner();
                     let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }

    //fn lookup_certificates_issued_by<'a, 'b, P: IsA<TlsInteraction> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>>(&self, issuer_raw_dn: /*Ignored*/&glib::ByteArray, interaction: Q, flags: TlsDatabaseLookupFlags, cancellable: S) -> Result<Vec<TlsCertificate>, Error> {
    //    unsafe { TODO: call ffi::g_tls_database_lookup_certificates_issued_by() }
    //}

    //fn lookup_certificates_issued_by_async<'a, 'b, P: IsA<TlsInteraction> + 'a, Q: Into<Option<&'a P>>, R: IsA<Cancellable> + 'b, S: Into<Option<&'b R>>, T: FnOnce(Result<Vec<TlsCertificate>, Error>) + Send + 'static>(&self, issuer_raw_dn: /*Ignored*/&glib::ByteArray, interaction: Q, flags: TlsDatabaseLookupFlags, cancellable: S, callback: T) {
    //    unsafe { TODO: call ffi::g_tls_database_lookup_certificates_issued_by_async() }
    //}

    //#[cfg(feature = "futures")]
    //fn lookup_certificates_issued_by_async_future<'a, P: IsA<TlsInteraction> + Clone + 'static, Q: Into<Option<&'a P>>>(&self, issuer_raw_dn: /*Ignored*/&glib::ByteArray, interaction: Q, flags: TlsDatabaseLookupFlags) -> Box_<futures_core::Future<Item = (Self, Vec<TlsCertificate>), Error = (Self, Error)>> where Self: Sized + Clone {
        //use GioFuture;
        //use fragile::Fragile;

        //let issuer_raw_dn = issuer_raw_dn.clone();
        //let interaction = interaction.into();
        //let interaction = interaction.map(ToOwned::to_owned);
        //GioFuture::new(self, move |obj, send| {
        //    let cancellable = Cancellable::new();
        //    let send = Fragile::new(send);
        //    let obj_clone = Fragile::new(obj.clone());
        //    obj.lookup_certificates_issued_by_async(
        //         &issuer_raw_dn,
        //         interaction.as_ref().map(::std::borrow::Borrow::borrow),
        //         flags,
        //         Some(&cancellable),
        //         move |res| {
        //             let obj = obj_clone.into_inner();
        //             let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
        //             let _ = send.into_inner().send(res);
        //         },
        //    );

        //    cancellable
        //})
    //}

    fn verify_chain<'a, 'b, 'c, P: IsA<TlsCertificate>, Q: IsA<SocketConnectable> + 'a, R: Into<Option<&'a Q>>, S: IsA<TlsInteraction> + 'b, T: Into<Option<&'b S>>, U: IsA<Cancellable> + 'c, V: Into<Option<&'c U>>>(&self, chain: &P, purpose: &str, identity: R, interaction: T, flags: TlsDatabaseVerifyFlags, cancellable: V) -> Result<TlsCertificateFlags, Error> {
        let identity = identity.into();
        let interaction = interaction.into();
        let cancellable = cancellable.into();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_database_verify_chain(self.as_ref().to_glib_none().0, chain.as_ref().to_glib_none().0, purpose.to_glib_none().0, identity.map(|p| p.as_ref()).to_glib_none().0, interaction.map(|p| p.as_ref()).to_glib_none().0, flags.to_glib(), cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn verify_chain_async<'a, 'b, 'c, P: IsA<TlsCertificate>, Q: IsA<SocketConnectable> + 'a, R: Into<Option<&'a Q>>, S: IsA<TlsInteraction> + 'b, T: Into<Option<&'b S>>, U: IsA<Cancellable> + 'c, V: Into<Option<&'c U>>, W: FnOnce(Result<TlsCertificateFlags, Error>) + Send + 'static>(&self, chain: &P, purpose: &str, identity: R, interaction: T, flags: TlsDatabaseVerifyFlags, cancellable: V, callback: W) {
        let identity = identity.into();
        let interaction = interaction.into();
        let cancellable = cancellable.into();
        let user_data: Box<W> = Box::new(callback);
        unsafe extern "C" fn verify_chain_async_trampoline<W: FnOnce(Result<TlsCertificateFlags, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_database_verify_chain_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<W> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = verify_chain_async_trampoline::<W>;
        unsafe {
            ffi::g_tls_database_verify_chain_async(self.as_ref().to_glib_none().0, chain.as_ref().to_glib_none().0, purpose.to_glib_none().0, identity.map(|p| p.as_ref()).to_glib_none().0, interaction.map(|p| p.as_ref()).to_glib_none().0, flags.to_glib(), cancellable.map(|p| p.as_ref()).to_glib_none().0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    #[cfg(feature = "futures")]
    fn verify_chain_async_future<'a, 'b, P: IsA<TlsCertificate> + Clone + 'static, Q: IsA<SocketConnectable> + Clone + 'static, R: Into<Option<&'a Q>>, S: IsA<TlsInteraction> + Clone + 'static, T: Into<Option<&'b S>>>(&self, chain: &P, purpose: &str, identity: R, interaction: T, flags: TlsDatabaseVerifyFlags) -> Box_<futures_core::Future<Item = (Self, TlsCertificateFlags), Error = (Self, Error)>> where Self: Sized + Clone {
        use GioFuture;
        use fragile::Fragile;

        let chain = chain.clone();
        let purpose = String::from(purpose);
        let identity = identity.into();
        let identity = identity.map(ToOwned::to_owned);
        let interaction = interaction.into();
        let interaction = interaction.map(ToOwned::to_owned);
        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            let obj_clone = Fragile::new(obj.clone());
            obj.verify_chain_async(
                 &chain,
                 &purpose,
                 identity.as_ref().map(::std::borrow::Borrow::borrow),
                 interaction.as_ref().map(::std::borrow::Borrow::borrow),
                 flags,
                 Some(&cancellable),
                 move |res| {
                     let obj = obj_clone.into_inner();
                     let res = res.map(|v| (obj.clone(), v)).map_err(|v| (obj.clone(), v));
                     let _ = send.into_inner().send(res);
                 },
            );

            cancellable
        })
    }
}

impl fmt::Display for TlsDatabase {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TlsDatabase")
    }
}
