/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar* * invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp15_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				ValaScope* _tmp10_;
				ValaScope* _tmp11_;
				ValaParameter* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = param;
				_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_scope_remove (_tmp11_, _tmp14_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp15_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp15_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp23_;
	ValaLocalVariable* _tmp32_;
	ValaLocalVariable* _tmp33_;
	ValaList* _tmp36_;
	ValaList* _tmp45_;
	ValaBlock* _tmp54_;
	ValaBlock* _tmp55_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaTypeParameter* _tmp6_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp4_ = _p_list;
			_tmp5_ = vala_list_get (_tmp4_, _p_index);
			p = (ValaTypeParameter*) _tmp5_;
			_tmp6_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp7_ = vala_method_get_base_interface_type (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		_tmp9_ = vala_method_get_base_interface_type (self);
		_tmp10_ = _tmp9_;
		vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
	}
	_tmp11_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp13_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _param_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _param_index = 0;
		_tmp15_ = self->priv->parameters;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_param_list = _tmp16_;
		_tmp17_ = _param_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_param_size = _tmp19_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaParameter* _tmp22_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp20_ = _param_list;
			_tmp21_ = vala_list_get (_tmp20_, _param_index);
			param = (ValaParameter*) _tmp21_;
			_tmp22_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp23_ = self->error_types;
	if (_tmp23_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			gint _error_type_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _error_type_index = 0;
			_tmp24_ = self->error_types;
			_tmp25_ = _vala_iterable_ref0 (_tmp24_);
			_error_type_list = _tmp25_;
			_tmp26_ = _error_type_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_error_type_size = _tmp28_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp29_;
				gpointer _tmp30_;
				ValaDataType* _tmp31_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp29_ = _error_type_list;
				_tmp30_ = vala_list_get (_tmp29_, _error_type_index);
				error_type = (ValaDataType*) _tmp30_;
				_tmp31_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp32_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaLocalVariable* _tmp34_;
		ValaLocalVariable* _tmp35_;
		_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp35_ = _tmp34_;
		vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
	}
	_tmp36_ = self->priv->preconditions;
	if (_tmp36_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			gint _precondition_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _precondition_index = 0;
			_tmp37_ = self->priv->preconditions;
			_tmp38_ = _vala_iterable_ref0 (_tmp37_);
			_precondition_list = _tmp38_;
			_tmp39_ = _precondition_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_precondition_size = _tmp41_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp42_;
				gpointer _tmp43_;
				ValaExpression* _tmp44_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp42_ = _precondition_list;
				_tmp43_ = vala_list_get (_tmp42_, _precondition_index);
				precondition = (ValaExpression*) _tmp43_;
				_tmp44_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp45_ = self->priv->postconditions;
	if (_tmp45_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp46_;
			ValaList* _tmp47_;
			gint _postcondition_size = 0;
			ValaList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _postcondition_index = 0;
			_tmp46_ = self->priv->postconditions;
			_tmp47_ = _vala_iterable_ref0 (_tmp46_);
			_postcondition_list = _tmp47_;
			_tmp48_ = _postcondition_list;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_postcondition_size = _tmp50_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				ValaExpression* _tmp53_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp51_ = _postcondition_list;
				_tmp52_ = vala_list_get (_tmp51_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp52_;
				_tmp53_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp53_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp54_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		ValaBlock* _tmp56_;
		ValaBlock* _tmp57_;
		_tmp56_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp57_ = _tmp56_;
		vala_code_node_accept ((ValaCodeNode*) _tmp57_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar* * invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	ValaList* method_type_args = NULL;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaObjectType* _tmp57_;
	ValaList* _tmp58_;
	ValaDataType* _tmp59_;
	ValaDataType* _tmp60_;
	ValaDataType* _tmp61_;
	ValaDataType* _tmp62_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp71_;
	ValaIterator* _tmp72_;
	gint param_index = 0;
	ValaIterator* _tmp113_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp115_;
	ValaArrayList* _tmp116_;
	ValaArrayList* _tmp117_;
	ValaList* _tmp118_;
	gboolean _tmp139_;
	gboolean _tmp140_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp15_;
				gpointer _tmp16_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp17_;
				ValaGenericType* _tmp18_;
				ValaGenericType* _tmp19_;
				ValaObjectType* _tmp20_;
				ValaGenericType* _tmp21_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp15_ = _type_parameter_list;
				_tmp16_ = vala_list_get (_tmp15_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp16_;
				_tmp17_ = type_parameter;
				_tmp18_ = vala_generic_type_new (_tmp17_);
				type_arg = _tmp18_;
				_tmp19_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp19_, TRUE);
				_tmp20_ = object_type;
				_tmp21_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp20_, (ValaDataType*) _tmp21_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp22_ = vala_method_get_type_parameters (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_method_get_type_parameters (base_method);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp25_ < _tmp29_;
	_vala_iterable_unref0 (_tmp27_);
	_vala_iterable_unref0 (_tmp23_);
	if (_tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp31_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp32_;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gboolean _tmp40_;
		_tmp32_ = vala_method_get_type_parameters (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_method_get_type_parameters (base_method);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp35_ > _tmp39_;
		_vala_iterable_unref0 (_tmp37_);
		_vala_iterable_unref0 (_tmp33_);
		if (_tmp40_) {
			gchar* _tmp41_;
			_tmp41_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp41_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp42_;
		ValaArrayList* _tmp43_;
		_tmp42_ = g_direct_equal;
		_tmp43_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp42_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp43_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp44_;
			gint _type_parameter_size = 0;
			ValaList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _type_parameter_index = 0;
			_tmp44_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp44_;
			_tmp45_ = _type_parameter_list;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_type_parameter_size = _tmp47_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp48_;
				gpointer _tmp49_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp50_;
				ValaGenericType* _tmp51_;
				ValaGenericType* _tmp52_;
				ValaList* _tmp53_;
				ValaGenericType* _tmp54_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp48_ = _type_parameter_list;
				_tmp49_ = vala_list_get (_tmp48_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp49_;
				_tmp50_ = type_parameter;
				_tmp51_ = vala_generic_type_new (_tmp50_);
				type_arg = _tmp51_;
				_tmp52_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp52_, TRUE);
				_tmp53_ = method_type_args;
				_tmp54_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp53_, (ValaDataType*) _tmp54_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp55_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp56_ = _tmp55_;
	_tmp57_ = object_type;
	_tmp58_ = method_type_args;
	_tmp59_ = vala_data_type_get_actual_type (_tmp56_, (ValaDataType*) _tmp57_, _tmp58_, node_reference);
	actual_base_type = _tmp59_;
	_tmp60_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = actual_base_type;
	if (!vala_data_type_equals (_tmp61_, _tmp62_)) {
		ValaDataType* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp63_ = actual_base_type;
		_tmp64_ = vala_data_type_to_prototype_string (_tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_data_type_to_prototype_string (_tmp67_, NULL);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp65_, _tmp69_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp70_;
		_g_free0 (_tmp69_);
		_g_free0 (_tmp65_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp71_ = self->priv->parameters;
	_tmp72_ = vala_iterable_iterator ((ValaIterable*) _tmp71_);
	method_params_it = _tmp72_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp73_;
		ValaList* _tmp74_;
		gint _base_param_size = 0;
		ValaList* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _base_param_index = 0;
		_tmp73_ = base_method->priv->parameters;
		_tmp74_ = _vala_iterable_ref0 (_tmp73_);
		_base_param_list = _tmp74_;
		_tmp75_ = _base_param_list;
		_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
		_tmp77_ = _tmp76_;
		_base_param_size = _tmp77_;
		_base_param_index = -1;
		while (TRUE) {
			ValaParameter* base_param = NULL;
			ValaList* _tmp78_;
			gpointer _tmp79_;
			ValaIterator* _tmp80_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp82_;
			gpointer _tmp83_;
			ValaParameter* _tmp84_;
			gboolean _tmp85_;
			gboolean _tmp86_;
			ValaParameter* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			ValaParameter* _tmp91_;
			gboolean _tmp92_;
			gboolean _tmp93_;
			gint _tmp112_;
			_base_param_index = _base_param_index + 1;
			if (!(_base_param_index < _base_param_size)) {
				break;
			}
			_tmp78_ = _base_param_list;
			_tmp79_ = vala_list_get (_tmp78_, _base_param_index);
			base_param = (ValaParameter*) _tmp79_;
			_tmp80_ = method_params_it;
			if (!vala_iterator_next (_tmp80_)) {
				gchar* _tmp81_;
				_tmp81_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp81_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp82_ = method_params_it;
			_tmp83_ = vala_iterator_get (_tmp82_);
			param = (ValaParameter*) _tmp83_;
			_tmp84_ = base_param;
			_tmp85_ = vala_parameter_get_ellipsis (_tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = param;
			_tmp88_ = vala_parameter_get_ellipsis (_tmp87_);
			_tmp89_ = _tmp88_;
			if (_tmp86_ != _tmp89_) {
				gchar* _tmp90_;
				_tmp90_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp90_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp91_ = base_param;
			_tmp92_ = vala_parameter_get_ellipsis (_tmp91_);
			_tmp93_ = _tmp92_;
			if (!_tmp93_) {
				ValaParameter* _tmp94_;
				ValaParameterDirection _tmp95_;
				ValaParameterDirection _tmp96_;
				ValaParameter* _tmp97_;
				ValaParameterDirection _tmp98_;
				ValaParameterDirection _tmp99_;
				ValaParameter* _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				ValaObjectType* _tmp104_;
				ValaList* _tmp105_;
				ValaDataType* _tmp106_;
				ValaDataType* _tmp107_;
				ValaParameter* _tmp108_;
				ValaDataType* _tmp109_;
				ValaDataType* _tmp110_;
				_tmp94_ = base_param;
				_tmp95_ = vala_parameter_get_direction (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = param;
				_tmp98_ = vala_parameter_get_direction (_tmp97_);
				_tmp99_ = _tmp98_;
				if (_tmp96_ != _tmp99_) {
					gchar* _tmp100_;
					_tmp100_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp100_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp101_ = base_param;
				_tmp102_ = vala_variable_get_variable_type ((ValaVariable*) _tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = object_type;
				_tmp105_ = method_type_args;
				_tmp106_ = vala_data_type_get_actual_type (_tmp103_, (ValaDataType*) _tmp104_, _tmp105_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp106_;
				_tmp107_ = actual_base_type;
				_tmp108_ = param;
				_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) _tmp108_);
				_tmp110_ = _tmp109_;
				if (!vala_data_type_equals (_tmp107_, _tmp110_)) {
					gchar* _tmp111_;
					_tmp111_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp111_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp112_ = param_index;
			param_index = _tmp112_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp113_ = method_params_it;
	if (vala_iterator_next (_tmp113_)) {
		gchar* _tmp114_;
		_tmp114_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp114_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp115_ = g_direct_equal;
	_tmp116_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp115_);
	base_method_errors = _tmp116_;
	_tmp117_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp117_, NULL);
	_tmp118_ = self->error_types;
	if (_tmp118_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp119_;
			ValaList* _tmp120_;
			gint _method_error_type_size = 0;
			ValaList* _tmp121_;
			gint _tmp122_;
			gint _tmp123_;
			gint _method_error_type_index = 0;
			_tmp119_ = self->error_types;
			_tmp120_ = _vala_iterable_ref0 (_tmp119_);
			_method_error_type_list = _tmp120_;
			_tmp121_ = _method_error_type_list;
			_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
			_tmp123_ = _tmp122_;
			_method_error_type_size = _tmp123_;
			_method_error_type_index = -1;
			while (TRUE) {
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp124_;
				gpointer _tmp125_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				if (!(_method_error_type_index < _method_error_type_size)) {
					break;
				}
				_tmp124_ = _method_error_type_list;
				_tmp125_ = vala_list_get (_tmp124_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp125_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp126_;
					ValaArrayList* _tmp127_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp128_;
					gint _tmp129_;
					gint _tmp130_;
					gint _base_method_error_type_index = 0;
					_tmp126_ = base_method_errors;
					_tmp127_ = _vala_iterable_ref0 (_tmp126_);
					_base_method_error_type_list = _tmp127_;
					_tmp128_ = _base_method_error_type_list;
					_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
					_tmp130_ = _tmp129_;
					_base_method_error_type_size = _tmp130_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp131_;
						gpointer _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						if (!(_base_method_error_type_index < _base_method_error_type_size)) {
							break;
						}
						_tmp131_ = _base_method_error_type_list;
						_tmp132_ = vala_list_get ((ValaList*) _tmp131_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp132_;
						_tmp133_ = method_error_type;
						_tmp134_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp133_, _tmp134_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp135_;
					gchar* _tmp136_;
					gchar* _tmp137_;
					gchar* _tmp138_;
					_tmp135_ = method_error_type;
					_tmp136_ = vala_code_node_to_string ((ValaCodeNode*) _tmp135_);
					_tmp137_ = _tmp136_;
					_tmp138_ = g_strdup_printf ("incompatible error type `%s'", _tmp137_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp138_;
					_g_free0 (_tmp137_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp139_ = base_method->priv->_coroutine;
	_tmp140_ = self->priv->_coroutine;
	if (_tmp139_ != _tmp140_) {
		gchar* _tmp141_;
		_tmp141_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp141_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_type_parameter_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_type_parameter_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	gint result = 0;
	ValaList* _tmp0_;
	gint i = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->preconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->postconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp6_ = _error_type_list;
				_tmp7_ = vala_list_get (_tmp6_, _error_type_index);
				error_type = (ValaDataType*) _tmp7_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp8_;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					_tmp8_ = error_type;
					_tmp9_ = vala_data_type_copy (_tmp8_);
					type = _tmp9_;
					_tmp10_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp10_, source_reference);
					_tmp11_ = type;
					vala_collection_add (collection, _tmp11_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp12_;
					_tmp12_ = error_type;
					vala_collection_add (collection, _tmp12_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp12_;
	ValaClass* _tmp37_;
	ValaClass* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaSignal* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp7_;
		_tmp8_ = sig;
		_tmp9_ = vala_signal_get_default_handler (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (sym);
		sym = _tmp11_;
		_vala_code_node_unref0 (sig);
	}
	_tmp12_ = sym;
	if (VALA_IS_METHOD (_tmp12_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp13_;
		ValaMethod* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaMethod* _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = sym;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
		base_method = _tmp14_;
		_tmp16_ = base_method;
		_tmp17_ = _tmp16_->priv->_is_abstract;
		if (_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			_tmp18_ = base_method;
			_tmp19_ = _tmp18_->priv->_is_virtual;
			_tmp15_ = _tmp19_;
		}
		if (_tmp15_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp20_;
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			ValaMethod* _tmp35_;
			ValaMethod* _tmp36_;
			_tmp20_ = base_method;
			_tmp22_ = vala_method_compatible (self, _tmp20_, &_tmp21_);
			_g_free0 (invalid_match);
			invalid_match = _tmp21_;
			if (!_tmp22_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp23_;
				ValaMethodType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				ValaMethodType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = base_method;
				_tmp24_ = vala_method_type_new (_tmp23_);
				base_method_type = _tmp24_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = base_method_type;
				_tmp30_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = invalid_match;
				_tmp33_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp28_, _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_method);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp35_ = base_method;
			self->priv->_base_method = _tmp35_;
			_tmp36_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp36_, "CCode", "instance_pos");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_method);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp37_ = vala_class_get_base_class (cl);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaClass* _tmp39_;
		ValaClass* _tmp40_;
		_tmp39_ = vala_class_get_base_class (cl);
		_tmp40_ = _tmp39_;
		vala_method_find_base_class_method (self, _tmp40_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp67_;
	ValaDataType* _tmp83_;
	ValaDataType* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp4_ = _type_list;
			_tmp5_ = vala_list_get (_tmp4_, _type_index);
			type = (ValaDataType*) _tmp5_;
			_tmp6_ = type;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			if (VALA_IS_INTERFACE (_tmp8_)) {
				gboolean _tmp9_ = FALSE;
				ValaDataType* _tmp10_;
				ValaDataType* _tmp11_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp19_;
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaScope* _tmp22_;
				ValaScope* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp34_;
				_tmp10_ = vala_method_get_base_interface_type (self);
				_tmp11_ = _tmp10_;
				if (_tmp11_ != NULL) {
					ValaDataType* _tmp12_;
					ValaDataType* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaDataType* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					_tmp12_ = vala_method_get_base_interface_type (self);
					_tmp13_ = _tmp12_;
					_tmp14_ = vala_data_type_get_data_type (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = type;
					_tmp17_ = vala_data_type_get_data_type (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp9_ = _tmp15_ != _tmp18_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp19_ = type;
				_tmp20_ = vala_data_type_get_data_type (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_scope_lookup (_tmp23_, _tmp25_);
				sym = _tmp26_;
				_tmp27_ = sym;
				if (VALA_IS_SIGNAL (_tmp27_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp28_;
					ValaSignal* _tmp29_;
					ValaSignal* _tmp30_;
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaSymbol* _tmp33_;
					_tmp28_ = sym;
					_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp29_;
					_tmp30_ = sig;
					_tmp31_ = vala_signal_get_default_handler (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp32_);
					_vala_code_node_unref0 (sym);
					sym = _tmp33_;
					_vala_code_node_unref0 (sig);
				}
				_tmp34_ = sym;
				if (VALA_IS_METHOD (_tmp34_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp35_;
					ValaMethod* _tmp36_;
					gboolean _tmp37_ = FALSE;
					ValaMethod* _tmp38_;
					gboolean _tmp39_;
					_tmp35_ = sym;
					_tmp36_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod));
					base_method = _tmp36_;
					_tmp38_ = base_method;
					_tmp39_ = _tmp38_->priv->_is_abstract;
					if (_tmp39_) {
						_tmp37_ = TRUE;
					} else {
						ValaMethod* _tmp40_;
						gboolean _tmp41_;
						_tmp40_ = base_method;
						_tmp41_ = _tmp40_->priv->_is_virtual;
						_tmp37_ = _tmp41_;
					}
					if (_tmp37_) {
						ValaDataType* _tmp42_;
						ValaDataType* _tmp43_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp58_;
						gchar* _tmp59_ = NULL;
						gboolean _tmp60_;
						_tmp42_ = vala_method_get_base_interface_type (self);
						_tmp43_ = _tmp42_;
						if (_tmp43_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp44_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									ValaMethod* m = NULL;
									ValaList* _tmp48_;
									gpointer _tmp49_;
									gboolean _tmp50_ = FALSE;
									ValaMethod* _tmp51_;
									ValaDataType* _tmp52_;
									ValaDataType* _tmp53_;
									_m_index = _m_index + 1;
									if (!(_m_index < _m_size)) {
										break;
									}
									_tmp48_ = _m_list;
									_tmp49_ = vala_list_get (_tmp48_, _m_index);
									m = (ValaMethod*) _tmp49_;
									_tmp51_ = m;
									_tmp52_ = vala_method_get_base_interface_type (_tmp51_);
									_tmp53_ = _tmp52_;
									if (_tmp53_ != NULL) {
										ValaMethod* _tmp54_;
										ValaMethod* _tmp55_;
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										_tmp54_ = base_method;
										_tmp55_ = m;
										_tmp56_ = vala_method_get_base_interface_method (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp50_ = _tmp54_ == _tmp57_;
									} else {
										_tmp50_ = FALSE;
									}
									if (_tmp50_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (base_method);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp58_ = base_method;
						_tmp60_ = vala_method_compatible (self, _tmp58_, &_tmp59_);
						_g_free0 (invalid_match);
						invalid_match = _tmp59_;
						if (!_tmp60_) {
							const gchar* _tmp61_;
							gchar* _tmp62_;
							ValaMethod* _tmp63_;
							ValaMethod* _tmp64_;
							_tmp61_ = invalid_match;
							_tmp62_ = g_strdup (_tmp61_);
							_g_free0 (invalid_error);
							invalid_error = _tmp62_;
							_tmp63_ = base_method;
							_tmp64_ = _vala_code_node_ref0 (_tmp63_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp64_;
						} else {
							ValaMethod* _tmp65_;
							ValaMethod* _tmp66_;
							_tmp65_ = base_method;
							_tmp66_ = _vala_code_node_ref0 (_tmp65_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp66_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_method);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
					_vala_code_node_unref0 (base_method);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp67_ = base_match;
	if (_tmp67_ != NULL) {
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		_tmp68_ = base_match;
		self->priv->_base_interface_method = _tmp68_;
		_tmp69_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp69_, "CCode", "instance_pos");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		ValaMethod* _tmp70_;
		_tmp70_ = invalid_base_match;
		if (_tmp70_ != NULL) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp71_;
			ValaMethodType* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			ValaMethodType* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp71_ = invalid_base_match;
			_tmp72_ = vala_method_type_new (_tmp71_);
			base_method_type = _tmp72_;
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp76_ = _tmp75_;
			_tmp77_ = base_method_type;
			_tmp78_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp77_, NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = invalid_error;
			_tmp81_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp76_, _tmp79_, _tmp80_);
			_tmp82_ = _tmp81_;
			vala_report_error (_tmp74_, _tmp82_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp76_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp83_ = vala_method_get_base_interface_type (self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ != NULL) {
		ValaSourceReference* _tmp85_;
		ValaSourceReference* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp88_);
		_tmp90_ = _tmp89_;
		vala_report_error (_tmp86_, _tmp90_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSemanticAnalyzer* _tmp119_;
	ValaSourceFile* _tmp120_;
	ValaSourceFile* _tmp121_;
	ValaSourceFile* _tmp122_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp123_;
	ValaSemanticAnalyzer* _tmp124_;
	ValaSymbol* _tmp125_;
	ValaSymbol* _tmp126_;
	ValaSymbol* _tmp127_;
	ValaSourceReference* _tmp128_;
	ValaSourceReference* _tmp129_;
	ValaSemanticAnalyzer* _tmp136_;
	ValaSemanticAnalyzer* _tmp137_;
	ValaDataType* _tmp138_;
	ValaDataType* _tmp139_;
	gboolean _tmp140_;
	gboolean _tmp141_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp144_;
	ValaAttribute* _tmp145_;
	ValaAttribute* _tmp146_;
	ValaDataType* _tmp153_;
	ValaDataType* _tmp154_;
	gboolean _tmp157_ = FALSE;
	gboolean _tmp158_ = FALSE;
	gboolean _tmp159_ = FALSE;
	ValaList* _tmp160_;
	gint _tmp161_;
	gint _tmp162_;
	gboolean optional_param = FALSE;
	gboolean _tmp229_;
	ValaList* _tmp243_;
	ValaLocalVariable* _tmp264_;
	ValaLocalVariable* _tmp265_;
	ValaList* _tmp268_;
	ValaList* _tmp277_;
	ValaBlock* _tmp286_;
	ValaBlock* _tmp287_;
	ValaSemanticAnalyzer* _tmp290_;
	ValaSemanticAnalyzer* _tmp291_;
	ValaStruct* _tmp292_;
	ValaStruct* _tmp293_;
	gboolean _tmp329_ = FALSE;
	gboolean _tmp330_ = FALSE;
	ValaDataType* _tmp331_;
	ValaDataType* _tmp332_;
	ValaSemanticAnalyzer* _tmp376_;
	ValaSemanticAnalyzer* _tmp377_;
	ValaSourceFile* _tmp378_;
	ValaSemanticAnalyzer* _tmp379_;
	ValaSemanticAnalyzer* _tmp380_;
	ValaSymbol* _tmp381_;
	gboolean _tmp382_ = FALSE;
	gboolean _tmp383_ = FALSE;
	gboolean _tmp384_ = FALSE;
	gboolean _tmp385_;
	gboolean _tmp386_;
	ValaSemanticAnalyzer* _tmp402_;
	ValaSemanticAnalyzer* _tmp403_;
	ValaDataType* _tmp404_;
	ValaDataType* _tmp405_;
	ValaBlock* _tmp452_;
	ValaBlock* _tmp453_;
	gboolean _tmp490_ = FALSE;
	gboolean _tmp491_ = FALSE;
	gboolean _tmp492_ = FALSE;
	gboolean _tmp493_ = FALSE;
	gboolean _tmp494_ = FALSE;
	ValaAttribute* _tmp552_;
	gboolean _tmp553_;
	gboolean _tmp554_;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp5_ = self->priv->_this_parameter;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) _tmp5_);
		_tmp7_ = _tmp6_;
		vala_data_type_set_value_owned (_tmp7_, TRUE);
	}
	_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp8_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp11_ = _tmp10_;
	if (VALA_IS_CLASS (_tmp11_)) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp13_ = self->priv->_is_abstract;
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			_tmp12_ = _tmp14_;
		}
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaClass* _tmp17_;
		gboolean _tmp18_ = FALSE;
		ValaClass* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp17_;
		_tmp19_ = cl;
		_tmp20_ = vala_class_get_is_compact (_tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			ValaClass* _tmp22_;
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			_tmp22_ = cl;
			_tmp23_ = vala_class_get_base_class (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ != NULL;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		_tmp29_ = self->priv->_is_abstract;
		if (_tmp29_) {
			_tmp28_ = TRUE;
		} else {
			gboolean _tmp30_;
			_tmp30_ = self->priv->_is_virtual;
			_tmp28_ = _tmp30_;
		}
		_tmp27_ = _tmp28_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = _tmp31_;
		vala_report_error (_tmp32_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...'.");
		result = FALSE;
		return result;
	}
	_tmp33_ = self->priv->_is_abstract;
	if (_tmp33_) {
		ValaSymbol* _tmp34_;
		ValaSymbol* _tmp35_;
		_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		if (VALA_IS_CLASS (_tmp35_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaClass* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp38_;
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!VALA_IS_INTERFACE (_tmp45_)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!VALA_IS_CLASS (_tmp51_)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !VALA_IS_INTERFACE (_tmp53_);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!VALA_IS_CLASS (_tmp58_)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!VALA_IS_CLASS (_tmp65_)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !VALA_IS_INTERFACE (_tmp67_);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		gboolean _tmp80_;
		_tmp80_ = self->priv->_is_abstract;
		if (_tmp80_) {
			_tmp79_ = TRUE;
		} else {
			gboolean _tmp81_;
			_tmp81_ = self->priv->_is_virtual;
			_tmp79_ = _tmp81_;
		}
		if (_tmp79_) {
			gboolean _tmp82_;
			gboolean _tmp83_;
			_tmp82_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp83_ = _tmp82_;
			_tmp78_ = _tmp83_;
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			gboolean _tmp84_;
			gboolean _tmp85_;
			_tmp84_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp85_ = _tmp84_;
			_tmp77_ = !_tmp85_;
		} else {
			_tmp77_ = FALSE;
		}
		if (_tmp77_) {
			ValaSymbol* _tmp86_;
			ValaSymbol* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			_tmp86_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_symbol_get_external (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp76_ = !_tmp89_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp90_;
			ValaSourceReference* _tmp91_;
			_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp91_ = _tmp90_;
			vala_report_error (_tmp91_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_;
			gboolean _tmp94_;
			_tmp93_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp94_ = _tmp93_;
			if (_tmp94_) {
				ValaBlock* _tmp95_;
				ValaBlock* _tmp96_;
				_tmp95_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp96_ = _tmp95_;
				_tmp92_ = _tmp96_ != NULL;
			} else {
				_tmp92_ = FALSE;
			}
			if (_tmp92_) {
				ValaSourceReference* _tmp97_;
				ValaSourceReference* _tmp98_;
				_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp98_ = _tmp97_;
				vala_report_error (_tmp98_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_;
				_tmp102_ = self->priv->_is_abstract;
				if (!_tmp102_) {
					gboolean _tmp103_;
					gboolean _tmp104_;
					_tmp103_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp104_ = _tmp103_;
					_tmp101_ = !_tmp104_;
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					ValaSourceFileType _tmp105_;
					ValaSourceFileType _tmp106_;
					_tmp105_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp106_ = _tmp105_;
					_tmp100_ = _tmp106_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					ValaBlock* _tmp107_;
					ValaBlock* _tmp108_;
					_tmp107_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp108_ = _tmp107_;
					_tmp99_ = _tmp108_ == NULL;
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp110_ = _tmp109_;
					vala_report_error (_tmp110_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp113_ = self->priv->_coroutine;
	if (_tmp113_) {
		gboolean _tmp114_;
		gboolean _tmp115_;
		_tmp114_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp115_ = _tmp114_;
		_tmp112_ = !_tmp115_;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		_tmp111_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		ValaSourceReference* _tmp116_;
		ValaSourceReference* _tmp117_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp117_ = _tmp116_;
		vala_report_error (_tmp117_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp118_ = vala_code_context_get_analyzer (context);
	_tmp119_ = _tmp118_;
	_tmp120_ = vala_semantic_analyzer_get_current_source_file (_tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = _vala_source_file_ref0 (_tmp121_);
	old_source_file = _tmp122_;
	_tmp123_ = vala_code_context_get_analyzer (context);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_semantic_analyzer_get_current_symbol (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = _vala_code_node_ref0 (_tmp126_);
	old_symbol = _tmp127_;
	_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp129_ = _tmp128_;
	if (_tmp129_ != NULL) {
		ValaSemanticAnalyzer* _tmp130_;
		ValaSemanticAnalyzer* _tmp131_;
		ValaSourceReference* _tmp132_;
		ValaSourceReference* _tmp133_;
		ValaSourceFile* _tmp134_;
		ValaSourceFile* _tmp135_;
		_tmp130_ = vala_code_context_get_analyzer (context);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_source_reference_get_file (_tmp133_);
		_tmp135_ = _tmp134_;
		vala_semantic_analyzer_set_current_source_file (_tmp131_, _tmp135_);
	}
	_tmp136_ = vala_code_context_get_analyzer (context);
	_tmp137_ = _tmp136_;
	vala_semantic_analyzer_set_current_symbol (_tmp137_, (ValaSymbol*) self);
	_tmp138_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp139_ = _tmp138_;
	_tmp140_ = vala_method_get_returns_floating_reference (self);
	_tmp141_ = _tmp140_;
	vala_data_type_set_floating_reference (_tmp139_, _tmp141_);
	_tmp142_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp143_ = _tmp142_;
	vala_code_node_check ((ValaCodeNode*) _tmp143_, context);
	_tmp144_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp145_ = _vala_code_node_ref0 (_tmp144_);
	init_attr = _tmp145_;
	_tmp146_ = init_attr;
	if (_tmp146_ != NULL) {
		ValaSourceReference* _tmp147_;
		ValaSourceReference* _tmp148_;
		ValaSourceFile* _tmp149_;
		ValaSourceFile* _tmp150_;
		ValaCodeContext* _tmp151_;
		ValaCodeContext* _tmp152_;
		_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_source_reference_get_file (_tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_source_file_get_context (_tmp150_);
		_tmp152_ = _tmp151_;
		vala_code_context_set_module_init_method (_tmp152_, self);
	}
	_tmp153_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp154_ = _tmp153_;
	if (_tmp154_ != NULL) {
		ValaDataType* _tmp155_;
		ValaDataType* _tmp156_;
		_tmp155_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp156_ = _tmp155_;
		vala_code_node_check ((ValaCodeNode*) _tmp156_, context);
	}
	_tmp160_ = self->priv->parameters;
	_tmp161_ = vala_collection_get_size ((ValaCollection*) _tmp160_);
	_tmp162_ = _tmp161_;
	if (_tmp162_ == 1) {
		ValaList* _tmp163_;
		gpointer _tmp164_;
		ValaParameter* _tmp165_;
		gboolean _tmp166_;
		gboolean _tmp167_;
		_tmp163_ = self->priv->parameters;
		_tmp164_ = vala_list_get (_tmp163_, 0);
		_tmp165_ = (ValaParameter*) _tmp164_;
		_tmp166_ = vala_parameter_get_ellipsis (_tmp165_);
		_tmp167_ = _tmp166_;
		_tmp159_ = _tmp167_;
		_vala_code_node_unref0 (_tmp165_);
	} else {
		_tmp159_ = FALSE;
	}
	if (_tmp159_) {
		ValaBlock* _tmp168_;
		ValaBlock* _tmp169_;
		_tmp168_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp169_ = _tmp168_;
		_tmp158_ = _tmp169_ != NULL;
	} else {
		_tmp158_ = FALSE;
	}
	if (_tmp158_) {
		ValaMemberBinding _tmp170_;
		_tmp170_ = self->priv->_binding;
		_tmp157_ = _tmp170_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp157_ = FALSE;
	}
	if (_tmp157_) {
		ValaList* _tmp171_;
		gpointer _tmp172_;
		ValaParameter* _tmp173_;
		ValaSourceReference* _tmp174_;
		ValaSourceReference* _tmp175_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp171_ = self->priv->parameters;
		_tmp172_ = vala_list_get (_tmp171_, 0);
		_tmp173_ = (ValaParameter*) _tmp172_;
		_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp173_);
		_tmp175_ = _tmp174_;
		vala_report_error (_tmp175_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp173_);
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp176_;
		ValaList* _tmp177_;
		gint _param_size = 0;
		ValaList* _tmp178_;
		gint _tmp179_;
		gint _tmp180_;
		gint _param_index = 0;
		_tmp176_ = self->priv->parameters;
		_tmp177_ = _vala_iterable_ref0 (_tmp176_);
		_param_list = _tmp177_;
		_tmp178_ = _param_list;
		_tmp179_ = vala_collection_get_size ((ValaCollection*) _tmp178_);
		_tmp180_ = _tmp179_;
		_param_size = _tmp180_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp181_;
			gpointer _tmp182_;
			ValaParameter* _tmp183_;
			gboolean _tmp184_ = FALSE;
			gboolean _tmp185_;
			gboolean _tmp192_ = FALSE;
			gboolean _tmp193_ = FALSE;
			gboolean _tmp194_;
			gboolean _tmp195_;
			gboolean _tmp214_;
			gboolean _tmp215_ = FALSE;
			gboolean _tmp216_ = FALSE;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp181_ = _param_list;
			_tmp182_ = vala_list_get (_tmp181_, _param_index);
			param = (ValaParameter*) _tmp182_;
			_tmp183_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp183_, context);
			_tmp185_ = self->priv->_coroutine;
			if (_tmp185_) {
				ValaParameter* _tmp186_;
				ValaParameterDirection _tmp187_;
				ValaParameterDirection _tmp188_;
				_tmp186_ = param;
				_tmp187_ = vala_parameter_get_direction (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp184_ = _tmp188_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp184_ = FALSE;
			}
			if (_tmp184_) {
				ValaParameter* _tmp189_;
				ValaSourceReference* _tmp190_;
				ValaSourceReference* _tmp191_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp189_ = param;
				_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp189_);
				_tmp191_ = _tmp190_;
				vala_report_error (_tmp191_, "Reference parameters are not supported for async methods");
			}
			_tmp194_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp195_ = _tmp194_;
			if (!_tmp195_) {
				gboolean _tmp196_;
				_tmp196_ = self->priv->_coroutine;
				_tmp193_ = _tmp196_;
			} else {
				_tmp193_ = FALSE;
			}
			if (_tmp193_) {
				gboolean _tmp197_ = FALSE;
				ValaParameter* _tmp198_;
				gboolean _tmp199_;
				gboolean _tmp200_;
				_tmp198_ = param;
				_tmp199_ = vala_parameter_get_ellipsis (_tmp198_);
				_tmp200_ = _tmp199_;
				if (_tmp200_) {
					_tmp197_ = TRUE;
				} else {
					ValaParameter* _tmp201_;
					ValaDataType* _tmp202_;
					ValaDataType* _tmp203_;
					ValaTypeSymbol* _tmp204_;
					ValaTypeSymbol* _tmp205_;
					ValaSemanticAnalyzer* _tmp206_;
					ValaSemanticAnalyzer* _tmp207_;
					ValaDataType* _tmp208_;
					ValaTypeSymbol* _tmp209_;
					ValaTypeSymbol* _tmp210_;
					_tmp201_ = param;
					_tmp202_ = vala_variable_get_variable_type ((ValaVariable*) _tmp201_);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_data_type_get_data_type (_tmp203_);
					_tmp205_ = _tmp204_;
					_tmp206_ = vala_code_context_get_analyzer (context);
					_tmp207_ = _tmp206_;
					_tmp208_ = _tmp207_->va_list_type;
					_tmp209_ = vala_data_type_get_data_type (_tmp208_);
					_tmp210_ = _tmp209_;
					_tmp197_ = _tmp205_ == _tmp210_;
				}
				_tmp192_ = _tmp197_;
			} else {
				_tmp192_ = FALSE;
			}
			if (_tmp192_) {
				ValaParameter* _tmp211_;
				ValaSourceReference* _tmp212_;
				ValaSourceReference* _tmp213_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp211_ = param;
				_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp211_);
				_tmp213_ = _tmp212_;
				vala_report_error (_tmp213_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp214_ = self->priv->_coroutine;
			if (_tmp214_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp217_;
				ValaExpression* _tmp218_;
				ValaExpression* _tmp219_;
				_tmp217_ = param;
				_tmp218_ = vala_variable_get_initializer ((ValaVariable*) _tmp217_);
				_tmp219_ = _tmp218_;
				_tmp216_ = _tmp219_ == NULL;
			} else {
				_tmp216_ = FALSE;
			}
			if (_tmp216_) {
				ValaParameter* _tmp220_;
				gboolean _tmp221_;
				gboolean _tmp222_;
				_tmp220_ = param;
				_tmp221_ = vala_parameter_get_ellipsis (_tmp220_);
				_tmp222_ = _tmp221_;
				_tmp215_ = !_tmp222_;
			} else {
				_tmp215_ = FALSE;
			}
			if (_tmp215_) {
				ValaParameter* _tmp223_;
				ValaSourceReference* _tmp224_;
				ValaSourceReference* _tmp225_;
				_tmp223_ = param;
				_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp223_);
				_tmp225_ = _tmp224_;
				vala_report_warning (_tmp225_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp226_;
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				_tmp226_ = param;
				_tmp227_ = vala_variable_get_initializer ((ValaVariable*) _tmp226_);
				_tmp228_ = _tmp227_;
				if (_tmp228_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp229_ = self->priv->_coroutine;
	if (_tmp229_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp230_;
			gint _tmp231_;
			gint _tmp232_;
			_tmp230_ = self->priv->parameters;
			_tmp231_ = vala_collection_get_size ((ValaCollection*) _tmp230_);
			_tmp232_ = _tmp231_;
			i = _tmp232_ - 1;
			{
				gboolean _tmp233_ = FALSE;
				_tmp233_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp235_;
					gpointer _tmp236_;
					ValaParameter* _tmp237_;
					ValaParameterDirection _tmp238_;
					ValaParameterDirection _tmp239_;
					if (!_tmp233_) {
						gint _tmp234_;
						_tmp234_ = i;
						i = _tmp234_ - 1;
					}
					_tmp233_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp235_ = self->priv->parameters;
					_tmp236_ = vala_list_get (_tmp235_, i);
					param = (ValaParameter*) _tmp236_;
					_tmp237_ = param;
					_tmp238_ = vala_parameter_get_direction (_tmp237_);
					_tmp239_ = _tmp238_;
					if (_tmp239_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp240_;
							ValaSourceReference* _tmp241_;
							ValaSourceReference* _tmp242_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp240_ = param;
							_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp240_);
							_tmp242_ = _tmp241_;
							vala_report_error (_tmp242_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp243_ = self->error_types;
	if (_tmp243_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp244_;
			ValaList* _tmp245_;
			gint _error_type_size = 0;
			ValaList* _tmp246_;
			gint _tmp247_;
			gint _tmp248_;
			gint _error_type_index = 0;
			_tmp244_ = self->error_types;
			_tmp245_ = _vala_iterable_ref0 (_tmp244_);
			_error_type_list = _tmp245_;
			_tmp246_ = _error_type_list;
			_tmp247_ = vala_collection_get_size ((ValaCollection*) _tmp246_);
			_tmp248_ = _tmp247_;
			_error_type_size = _tmp248_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp249_;
				gpointer _tmp250_;
				ValaDataType* _tmp251_;
				ValaSemanticAnalyzer* _tmp252_;
				ValaSemanticAnalyzer* _tmp253_;
				ValaDataType* _tmp254_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp249_ = _error_type_list;
				_tmp250_ = vala_list_get (_tmp249_, _error_type_index);
				error_type = (ValaDataType*) _tmp250_;
				_tmp251_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp251_, context);
				_tmp252_ = vala_code_context_get_analyzer (context);
				_tmp253_ = _tmp252_;
				_tmp254_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp253_, (ValaSymbol*) self, _tmp254_)) {
					ValaSourceReference* _tmp255_;
					ValaSourceReference* _tmp256_;
					ValaDataType* _tmp257_;
					gchar* _tmp258_;
					gchar* _tmp259_;
					gchar* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					gchar* _tmp263_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp256_ = _tmp255_;
					_tmp257_ = error_type;
					_tmp258_ = vala_code_node_to_string ((ValaCodeNode*) _tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp261_ = _tmp260_;
					_tmp262_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp259_, _tmp261_);
					_tmp263_ = _tmp262_;
					vala_report_error (_tmp256_, _tmp263_);
					_g_free0 (_tmp263_);
					_g_free0 (_tmp261_);
					_g_free0 (_tmp259_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp264_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp265_ = _tmp264_;
	if (_tmp265_ != NULL) {
		ValaLocalVariable* _tmp266_;
		ValaLocalVariable* _tmp267_;
		_tmp266_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp267_ = _tmp266_;
		vala_code_node_check ((ValaCodeNode*) _tmp267_, context);
	}
	_tmp268_ = self->priv->preconditions;
	if (_tmp268_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp269_;
			ValaList* _tmp270_;
			gint _precondition_size = 0;
			ValaList* _tmp271_;
			gint _tmp272_;
			gint _tmp273_;
			gint _precondition_index = 0;
			_tmp269_ = self->priv->preconditions;
			_tmp270_ = _vala_iterable_ref0 (_tmp269_);
			_precondition_list = _tmp270_;
			_tmp271_ = _precondition_list;
			_tmp272_ = vala_collection_get_size ((ValaCollection*) _tmp271_);
			_tmp273_ = _tmp272_;
			_precondition_size = _tmp273_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp274_;
				gpointer _tmp275_;
				ValaExpression* _tmp276_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp274_ = _precondition_list;
				_tmp275_ = vala_list_get (_tmp274_, _precondition_index);
				precondition = (ValaExpression*) _tmp275_;
				_tmp276_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp276_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp277_ = self->priv->postconditions;
	if (_tmp277_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp278_;
			ValaList* _tmp279_;
			gint _postcondition_size = 0;
			ValaList* _tmp280_;
			gint _tmp281_;
			gint _tmp282_;
			gint _postcondition_index = 0;
			_tmp278_ = self->priv->postconditions;
			_tmp279_ = _vala_iterable_ref0 (_tmp278_);
			_postcondition_list = _tmp279_;
			_tmp280_ = _postcondition_list;
			_tmp281_ = vala_collection_get_size ((ValaCollection*) _tmp280_);
			_tmp282_ = _tmp281_;
			_postcondition_size = _tmp282_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp283_;
				gpointer _tmp284_;
				ValaExpression* _tmp285_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp283_ = _postcondition_list;
				_tmp284_ = vala_list_get (_tmp283_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp284_;
				_tmp285_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp286_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp287_ = _tmp286_;
	if (_tmp287_ != NULL) {
		ValaBlock* _tmp288_;
		ValaBlock* _tmp289_;
		_tmp288_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp289_ = _tmp288_;
		vala_code_node_check ((ValaCodeNode*) _tmp289_, context);
	}
	_tmp290_ = vala_code_context_get_analyzer (context);
	_tmp291_ = _tmp290_;
	_tmp292_ = vala_semantic_analyzer_get_current_struct (_tmp291_);
	_tmp293_ = _tmp292_;
	if (_tmp293_ != NULL) {
		gboolean _tmp294_ = FALSE;
		gboolean _tmp295_ = FALSE;
		gboolean _tmp296_;
		_tmp296_ = self->priv->_is_abstract;
		if (_tmp296_) {
			_tmp295_ = TRUE;
		} else {
			gboolean _tmp297_;
			_tmp297_ = self->priv->_is_virtual;
			_tmp295_ = _tmp297_;
		}
		if (_tmp295_) {
			_tmp294_ = TRUE;
		} else {
			gboolean _tmp298_;
			_tmp298_ = self->priv->_overrides;
			_tmp294_ = _tmp298_;
		}
		if (_tmp294_) {
			ValaSourceReference* _tmp299_;
			ValaSourceReference* _tmp300_;
			gchar* _tmp301_;
			gchar* _tmp302_;
			gchar* _tmp303_;
			gchar* _tmp304_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp299_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp302_ = _tmp301_;
			_tmp303_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp302_);
			_tmp304_ = _tmp303_;
			vala_report_error (_tmp300_, _tmp304_);
			_g_free0 (_tmp304_);
			_g_free0 (_tmp302_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp305_ = FALSE;
		gboolean _tmp306_;
		_tmp306_ = self->priv->_overrides;
		if (_tmp306_) {
			ValaMethod* _tmp307_;
			ValaMethod* _tmp308_;
			_tmp307_ = vala_method_get_base_method (self);
			_tmp308_ = _tmp307_;
			_tmp305_ = _tmp308_ == NULL;
		} else {
			_tmp305_ = FALSE;
		}
		if (_tmp305_) {
			ValaSourceReference* _tmp309_;
			ValaSourceReference* _tmp310_;
			gchar* _tmp311_;
			gchar* _tmp312_;
			gchar* _tmp313_;
			gchar* _tmp314_;
			_tmp309_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp312_ = _tmp311_;
			_tmp313_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp312_);
			_tmp314_ = _tmp313_;
			vala_report_error (_tmp310_, _tmp314_);
			_g_free0 (_tmp314_);
			_g_free0 (_tmp312_);
		} else {
			gboolean _tmp315_ = FALSE;
			gboolean _tmp316_ = FALSE;
			gboolean _tmp317_ = FALSE;
			gboolean _tmp318_;
			_tmp318_ = self->priv->_is_abstract;
			if (_tmp318_) {
				_tmp317_ = TRUE;
			} else {
				gboolean _tmp319_;
				_tmp319_ = self->priv->_is_virtual;
				_tmp317_ = _tmp319_;
			}
			if (_tmp317_) {
				_tmp316_ = TRUE;
			} else {
				gboolean _tmp320_;
				_tmp320_ = self->priv->_overrides;
				_tmp316_ = _tmp320_;
			}
			if (_tmp316_) {
				ValaSymbolAccessibility _tmp321_;
				ValaSymbolAccessibility _tmp322_;
				_tmp321_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp322_ = _tmp321_;
				_tmp315_ = _tmp322_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp315_ = FALSE;
			}
			if (_tmp315_) {
				ValaSourceReference* _tmp323_;
				ValaSourceReference* _tmp324_;
				gchar* _tmp325_;
				gchar* _tmp326_;
				gchar* _tmp327_;
				gchar* _tmp328_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp323_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp326_ = _tmp325_;
				_tmp327_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp326_);
				_tmp328_ = _tmp327_;
				vala_report_error (_tmp324_, _tmp328_);
				_g_free0 (_tmp328_);
				_g_free0 (_tmp326_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp331_ = vala_method_get_base_interface_type (self);
	_tmp332_ = _tmp331_;
	if (_tmp332_ != NULL) {
		ValaMethod* _tmp333_;
		ValaMethod* _tmp334_;
		_tmp333_ = vala_method_get_base_interface_method (self);
		_tmp334_ = _tmp333_;
		_tmp330_ = _tmp334_ != NULL;
	} else {
		_tmp330_ = FALSE;
	}
	if (_tmp330_) {
		ValaSymbol* _tmp335_;
		ValaSymbol* _tmp336_;
		_tmp335_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp336_ = _tmp335_;
		_tmp329_ = VALA_IS_CLASS (_tmp336_);
	} else {
		_tmp329_ = FALSE;
	}
	if (_tmp329_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp337_;
		ValaSymbol* _tmp338_;
		ValaClass* _tmp339_;
		_tmp337_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp338_ = _tmp337_;
		_tmp339_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp338_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp339_;
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp340_;
			ValaList* _tmp341_;
			gint _m_size = 0;
			ValaList* _tmp342_;
			gint _tmp343_;
			gint _tmp344_;
			gint _m_index = 0;
			_tmp340_ = cl;
			_tmp341_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp340_);
			_m_list = _tmp341_;
			_tmp342_ = _m_list;
			_tmp343_ = vala_collection_get_size ((ValaCollection*) _tmp342_);
			_tmp344_ = _tmp343_;
			_m_size = _tmp344_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp345_;
				gpointer _tmp346_;
				gboolean _tmp347_ = FALSE;
				ValaMethod* _tmp348_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp345_ = _m_list;
				_tmp346_ = vala_list_get (_tmp345_, _m_index);
				m = (ValaMethod*) _tmp346_;
				_tmp348_ = m;
				if (_tmp348_ != self) {
					ValaMethod* _tmp349_;
					ValaMethod* _tmp350_;
					ValaMethod* _tmp351_;
					ValaMethod* _tmp352_;
					ValaMethod* _tmp353_;
					_tmp349_ = m;
					_tmp350_ = vala_method_get_base_interface_method (_tmp349_);
					_tmp351_ = _tmp350_;
					_tmp352_ = vala_method_get_base_interface_method (self);
					_tmp353_ = _tmp352_;
					_tmp347_ = _tmp351_ == _tmp353_;
				} else {
					_tmp347_ = FALSE;
				}
				if (_tmp347_) {
					ValaMethod* _tmp354_;
					ValaMethod* _tmp355_;
					ValaSourceReference* _tmp356_;
					ValaSourceReference* _tmp357_;
					ValaClass* _tmp358_;
					gchar* _tmp359_;
					gchar* _tmp360_;
					ValaMethod* _tmp361_;
					ValaMethod* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					gchar* _tmp365_;
					gchar* _tmp366_;
					ValaMethod* _tmp367_;
					ValaSourceReference* _tmp368_;
					ValaSourceReference* _tmp369_;
					ValaMethod* _tmp370_;
					ValaMethod* _tmp371_;
					gchar* _tmp372_;
					gchar* _tmp373_;
					gchar* _tmp374_;
					gchar* _tmp375_;
					_tmp354_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp354_, TRUE);
					_tmp355_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp355_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp356_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp357_ = _tmp356_;
					_tmp358_ = cl;
					_tmp359_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = vala_method_get_base_interface_method (self);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp360_, _tmp364_);
					_tmp366_ = _tmp365_;
					vala_report_error (_tmp357_, _tmp366_);
					_g_free0 (_tmp366_);
					_g_free0 (_tmp364_);
					_g_free0 (_tmp360_);
					_tmp367_ = m;
					_tmp368_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp367_);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_method_get_base_interface_method (self);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp371_);
					_tmp373_ = _tmp372_;
					_tmp374_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp373_);
					_tmp375_ = _tmp374_;
					vala_report_notice (_tmp369_, _tmp375_);
					_g_free0 (_tmp375_);
					_g_free0 (_tmp373_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp376_ = vala_code_context_get_analyzer (context);
	_tmp377_ = _tmp376_;
	_tmp378_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp377_, _tmp378_);
	_tmp379_ = vala_code_context_get_analyzer (context);
	_tmp380_ = _tmp379_;
	_tmp381_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp380_, _tmp381_);
	_tmp385_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp386_ = _tmp385_;
	if (!_tmp386_) {
		gboolean _tmp387_;
		_tmp387_ = self->priv->_overrides;
		_tmp384_ = !_tmp387_;
	} else {
		_tmp384_ = FALSE;
	}
	if (_tmp384_) {
		gboolean _tmp388_;
		gboolean _tmp389_;
		_tmp388_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp389_ = _tmp388_;
		_tmp383_ = !_tmp389_;
	} else {
		_tmp383_ = FALSE;
	}
	if (_tmp383_) {
		ValaSymbol* _tmp390_;
		ValaSymbol* _tmp391_;
		_tmp390_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp391_ = _tmp390_;
		_tmp382_ = _tmp391_ != NULL;
		_vala_code_node_unref0 (_tmp391_);
	} else {
		_tmp382_ = FALSE;
	}
	if (_tmp382_) {
		ValaSourceReference* _tmp392_;
		ValaSourceReference* _tmp393_;
		gchar* _tmp394_;
		gchar* _tmp395_;
		ValaSymbol* _tmp396_;
		ValaSymbol* _tmp397_;
		gchar* _tmp398_;
		gchar* _tmp399_;
		gchar* _tmp400_;
		gchar* _tmp401_;
		_tmp392_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp393_ = _tmp392_;
		_tmp394_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp395_ = _tmp394_;
		_tmp396_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp397_ = _tmp396_;
		_tmp398_ = vala_symbol_get_full_name (_tmp397_);
		_tmp399_ = _tmp398_;
		_tmp400_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp395_, _tmp399_);
		_tmp401_ = _tmp400_;
		vala_report_warning (_tmp393_, _tmp401_);
		_g_free0 (_tmp401_);
		_g_free0 (_tmp399_);
		_vala_code_node_unref0 (_tmp397_);
		_g_free0 (_tmp395_);
	}
	_tmp402_ = vala_code_context_get_analyzer (context);
	_tmp403_ = _tmp402_;
	_tmp404_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp405_ = _tmp404_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp403_, (ValaSymbol*) self, _tmp405_)) {
		ValaSourceReference* _tmp406_;
		ValaSourceReference* _tmp407_;
		ValaDataType* _tmp408_;
		ValaDataType* _tmp409_;
		gchar* _tmp410_;
		gchar* _tmp411_;
		gchar* _tmp412_;
		gchar* _tmp413_;
		gchar* _tmp414_;
		gchar* _tmp415_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp406_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp407_ = _tmp406_;
		_tmp408_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp409_ = _tmp408_;
		_tmp410_ = vala_code_node_to_string ((ValaCodeNode*) _tmp409_);
		_tmp411_ = _tmp410_;
		_tmp412_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp413_ = _tmp412_;
		_tmp414_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp411_, _tmp413_);
		_tmp415_ = _tmp414_;
		vala_report_error (_tmp407_, _tmp415_);
		_g_free0 (_tmp415_);
		_g_free0 (_tmp413_);
		_g_free0 (_tmp411_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp416_;
		gint _precondition_size = 0;
		ValaList* _tmp417_;
		gint _tmp418_;
		gint _tmp419_;
		gint _precondition_index = 0;
		_tmp416_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp416_;
		_tmp417_ = _precondition_list;
		_tmp418_ = vala_collection_get_size ((ValaCollection*) _tmp417_);
		_tmp419_ = _tmp418_;
		_precondition_size = _tmp419_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp420_;
			gpointer _tmp421_;
			ValaExpression* _tmp422_;
			gboolean _tmp423_;
			gboolean _tmp424_;
			ValaExpression* _tmp425_;
			ValaDataType* _tmp426_;
			ValaDataType* _tmp427_;
			ValaSemanticAnalyzer* _tmp428_;
			ValaSemanticAnalyzer* _tmp429_;
			ValaDataType* _tmp430_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp420_ = _precondition_list;
			_tmp421_ = vala_list_get (_tmp420_, _precondition_index);
			precondition = (ValaExpression*) _tmp421_;
			_tmp422_ = precondition;
			_tmp423_ = vala_code_node_get_error ((ValaCodeNode*) _tmp422_);
			_tmp424_ = _tmp423_;
			if (_tmp424_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp425_ = precondition;
			_tmp426_ = vala_expression_get_value_type (_tmp425_);
			_tmp427_ = _tmp426_;
			_tmp428_ = vala_code_context_get_analyzer (context);
			_tmp429_ = _tmp428_;
			_tmp430_ = _tmp429_->bool_type;
			if (!vala_data_type_compatible (_tmp427_, _tmp430_)) {
				ValaExpression* _tmp431_;
				ValaSourceReference* _tmp432_;
				ValaSourceReference* _tmp433_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp431_ = precondition;
				_tmp432_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp431_);
				_tmp433_ = _tmp432_;
				vala_report_error (_tmp433_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp434_;
		gint _postcondition_size = 0;
		ValaList* _tmp435_;
		gint _tmp436_;
		gint _tmp437_;
		gint _postcondition_index = 0;
		_tmp434_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp434_;
		_tmp435_ = _postcondition_list;
		_tmp436_ = vala_collection_get_size ((ValaCollection*) _tmp435_);
		_tmp437_ = _tmp436_;
		_postcondition_size = _tmp437_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp438_;
			gpointer _tmp439_;
			ValaExpression* _tmp440_;
			gboolean _tmp441_;
			gboolean _tmp442_;
			ValaExpression* _tmp443_;
			ValaDataType* _tmp444_;
			ValaDataType* _tmp445_;
			ValaSemanticAnalyzer* _tmp446_;
			ValaSemanticAnalyzer* _tmp447_;
			ValaDataType* _tmp448_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp438_ = _postcondition_list;
			_tmp439_ = vala_list_get (_tmp438_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp439_;
			_tmp440_ = postcondition;
			_tmp441_ = vala_code_node_get_error ((ValaCodeNode*) _tmp440_);
			_tmp442_ = _tmp441_;
			if (_tmp442_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp443_ = postcondition;
			_tmp444_ = vala_expression_get_value_type (_tmp443_);
			_tmp445_ = _tmp444_;
			_tmp446_ = vala_code_context_get_analyzer (context);
			_tmp447_ = _tmp446_;
			_tmp448_ = _tmp447_->bool_type;
			if (!vala_data_type_compatible (_tmp445_, _tmp448_)) {
				ValaExpression* _tmp449_;
				ValaSourceReference* _tmp450_;
				ValaSourceReference* _tmp451_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp449_ = postcondition;
				_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp449_);
				_tmp451_ = _tmp450_;
				vala_report_error (_tmp451_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp452_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp453_ = _tmp452_;
	if (_tmp453_ != NULL) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp454_;
		ValaArrayList* _tmp455_;
		ValaBlock* _tmp456_;
		ValaBlock* _tmp457_;
		ValaArrayList* _tmp458_;
		_tmp454_ = g_direct_equal;
		_tmp455_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp454_);
		body_errors = _tmp455_;
		_tmp456_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp457_ = _tmp456_;
		_tmp458_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp457_, (ValaCollection*) _tmp458_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp459_;
			ValaArrayList* _tmp460_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp461_;
			gint _tmp462_;
			gint _tmp463_;
			gint _body_error_type_index = 0;
			_tmp459_ = body_errors;
			_tmp460_ = _vala_iterable_ref0 (_tmp459_);
			_body_error_type_list = _tmp460_;
			_tmp461_ = _body_error_type_list;
			_tmp462_ = vala_collection_get_size ((ValaCollection*) _tmp461_);
			_tmp463_ = _tmp462_;
			_body_error_type_size = _tmp463_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp464_;
				gpointer _tmp465_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp466_;
				gboolean _tmp476_ = FALSE;
				ValaDataType* _tmp477_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp481_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp464_ = _body_error_type_list;
				_tmp465_ = vala_list_get ((ValaList*) _tmp464_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp465_;
				can_propagate_error = FALSE;
				_tmp466_ = self->error_types;
				if (_tmp466_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp467_;
						ValaList* _tmp468_;
						gint _method_error_type_size = 0;
						ValaList* _tmp469_;
						gint _tmp470_;
						gint _tmp471_;
						gint _method_error_type_index = 0;
						_tmp467_ = self->error_types;
						_tmp468_ = _vala_iterable_ref0 (_tmp467_);
						_method_error_type_list = _tmp468_;
						_tmp469_ = _method_error_type_list;
						_tmp470_ = vala_collection_get_size ((ValaCollection*) _tmp469_);
						_tmp471_ = _tmp470_;
						_method_error_type_size = _tmp471_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp472_;
							gpointer _tmp473_;
							ValaDataType* _tmp474_;
							ValaDataType* _tmp475_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp472_ = _method_error_type_list;
							_tmp473_ = vala_list_get (_tmp472_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp473_;
							_tmp474_ = body_error_type;
							_tmp475_ = method_error_type;
							if (vala_data_type_compatible (_tmp474_, _tmp475_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp477_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp477_)) {
					ValaDataType* _tmp478_;
					gboolean _tmp479_;
					gboolean _tmp480_;
					_tmp478_ = body_error_type;
					_tmp479_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp478_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp480_ = _tmp479_;
					_tmp476_ = _tmp480_;
				} else {
					_tmp476_ = FALSE;
				}
				is_dynamic_error = _tmp476_;
				if (!can_propagate_error) {
					_tmp481_ = !is_dynamic_error;
				} else {
					_tmp481_ = FALSE;
				}
				if (_tmp481_) {
					ValaDataType* _tmp482_;
					ValaSourceReference* _tmp483_;
					ValaSourceReference* _tmp484_;
					ValaDataType* _tmp485_;
					gchar* _tmp486_;
					gchar* _tmp487_;
					gchar* _tmp488_;
					gchar* _tmp489_;
					_tmp482_ = body_error_type;
					_tmp483_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp482_);
					_tmp484_ = _tmp483_;
					_tmp485_ = body_error_type;
					_tmp486_ = vala_code_node_to_string ((ValaCodeNode*) _tmp485_);
					_tmp487_ = _tmp486_;
					_tmp488_ = g_strdup_printf ("unhandled error `%s'", _tmp487_);
					_tmp489_ = _tmp488_;
					vala_report_warning (_tmp484_, _tmp489_);
					_g_free0 (_tmp489_);
					_g_free0 (_tmp487_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp495_;
		_tmp495_ = self->priv->_binding;
		_tmp494_ = _tmp495_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp494_ = FALSE;
	}
	if (_tmp494_) {
		gboolean _tmp496_;
		_tmp496_ = self->priv->_overrides;
		_tmp493_ = !_tmp496_;
	} else {
		_tmp493_ = FALSE;
	}
	if (_tmp493_) {
		ValaSymbolAccessibility _tmp497_;
		ValaSymbolAccessibility _tmp498_;
		_tmp497_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp498_ = _tmp497_;
		_tmp492_ = _tmp498_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp492_ = FALSE;
	}
	if (_tmp492_) {
		ValaSymbol* _tmp499_;
		ValaSymbol* _tmp500_;
		_tmp499_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp500_ = _tmp499_;
		_tmp491_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp500_);
	} else {
		_tmp491_ = FALSE;
	}
	if (_tmp491_) {
		ValaSymbol* _tmp501_;
		ValaSymbol* _tmp502_;
		ValaAttribute* _tmp503_;
		_tmp501_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp502_ = _tmp501_;
		_tmp503_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp502_, "DBus");
		_tmp490_ = _tmp503_ != NULL;
	} else {
		_tmp490_ = FALSE;
	}
	if (_tmp490_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp504_;
		ValaAttribute* _tmp505_;
		gboolean _tmp506_ = FALSE;
		ValaAttribute* _tmp507_;
		_tmp504_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp505_ = _vala_code_node_ref0 (_tmp504_);
		dbus_attr = _tmp505_;
		_tmp507_ = dbus_attr;
		if (_tmp507_ == NULL) {
			_tmp506_ = TRUE;
		} else {
			ValaAttribute* _tmp508_;
			_tmp508_ = dbus_attr;
			_tmp506_ = vala_attribute_get_bool (_tmp508_, "visible", TRUE);
		}
		if (_tmp506_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp509_;
			ValaArrayList* _tmp510_;
			ValaArrayList* _tmp511_;
			gboolean _tmp528_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp509_ = g_direct_equal;
			_tmp510_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp509_);
			error_types = _tmp510_;
			_tmp511_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp511_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp512_;
				ValaArrayList* _tmp513_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp514_;
				gint _tmp515_;
				gint _tmp516_;
				gint _error_type_index = 0;
				_tmp512_ = error_types;
				_tmp513_ = _vala_iterable_ref0 (_tmp512_);
				_error_type_list = _tmp513_;
				_tmp514_ = _error_type_list;
				_tmp515_ = vala_collection_get_size ((ValaCollection*) _tmp514_);
				_tmp516_ = _tmp515_;
				_error_type_size = _tmp516_;
				_error_type_index = -1;
				while (TRUE) {
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp517_;
					gpointer _tmp518_;
					ValaDataType* _tmp519_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp520_;
					ValaErrorDomain* _tmp521_;
					ValaErrorDomain* _tmp522_;
					ValaErrorDomain* _tmp523_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp524_;
					gchar* _tmp525_;
					const gchar* _tmp526_;
					_error_type_index = _error_type_index + 1;
					if (!(_error_type_index < _error_type_size)) {
						break;
					}
					_tmp517_ = _error_type_list;
					_tmp518_ = vala_list_get ((ValaList*) _tmp517_, _error_type_index);
					error_type = (ValaDataType*) _tmp518_;
					_tmp519_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp519_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp520_ = error_type;
					_tmp521_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp520_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp522_ = _tmp521_;
					error_domain = _tmp522_;
					_tmp523_ = error_domain;
					if (_tmp523_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp524_ = error_domain;
					_tmp525_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp524_);
					full_error_domain = _tmp525_;
					_tmp526_ = full_error_domain;
					if (g_strcmp0 (_tmp526_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp527_;
						_tmp527_ = full_error_domain;
						if (g_strcmp0 (_tmp527_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp529_ = FALSE;
				if (throws_gioerror) {
					_tmp529_ = throws_gdbuserror;
				} else {
					_tmp529_ = FALSE;
				}
				_tmp528_ = !_tmp529_;
			} else {
				_tmp528_ = FALSE;
			}
			if (_tmp528_) {
				ValaSourceReference* _tmp530_;
				ValaSourceReference* _tmp531_;
				_tmp530_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp531_ = _tmp530_;
				vala_report_warning (_tmp531_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp532_;
		ValaMethod* _tmp533_;
		gboolean _tmp542_;
		gboolean _tmp543_;
		gboolean _tmp546_;
		gboolean _tmp549_;
		_tmp532_ = vala_code_context_get_entry_point (context);
		_tmp533_ = _tmp532_;
		if (_tmp533_ != NULL) {
			ValaSourceReference* _tmp534_;
			ValaSourceReference* _tmp535_;
			ValaMethod* _tmp536_;
			ValaMethod* _tmp537_;
			gchar* _tmp538_;
			gchar* _tmp539_;
			gchar* _tmp540_;
			gchar* _tmp541_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp534_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp535_ = _tmp534_;
			_tmp536_ = vala_code_context_get_entry_point (context);
			_tmp537_ = _tmp536_;
			_tmp538_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp537_);
			_tmp539_ = _tmp538_;
			_tmp540_ = g_strdup_printf ("program already has an entry point `%s'", _tmp539_);
			_tmp541_ = _tmp540_;
			vala_report_error (_tmp535_, _tmp541_);
			_g_free0 (_tmp541_);
			_g_free0 (_tmp539_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp542_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp543_ = _tmp542_;
		if (_tmp543_) {
			ValaSourceReference* _tmp544_;
			ValaSourceReference* _tmp545_;
			_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp545_ = _tmp544_;
			vala_report_error (_tmp545_, "\"main\" method cannot throw errors");
		}
		_tmp546_ = self->priv->_is_inline;
		if (_tmp546_) {
			ValaSourceReference* _tmp547_;
			ValaSourceReference* _tmp548_;
			_tmp547_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp548_ = _tmp547_;
			vala_report_error (_tmp548_, "\"main\" method cannot be inline");
		}
		_tmp549_ = self->priv->_coroutine;
		if (_tmp549_) {
			ValaSourceReference* _tmp550_;
			ValaSourceReference* _tmp551_;
			_tmp550_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp551_ = _tmp550_;
			vala_report_error (_tmp551_, "\"main\" method cannot be async");
		}
	}
	_tmp552_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp552_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp553_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp554_ = _tmp553_;
	result = !_tmp554_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp33_;
	ValaIterator* _tmp34_;
	ValaIterator* _tmp35_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp36_;
	gpointer _tmp37_;
	ValaParameter* _tmp38_;
	ValaParameterDirection _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameter* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaArrayType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_data_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	params = _tmp26_;
	_tmp27_ = params;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp30_ = params;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp33_ = params;
	_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
	params_it = _tmp34_;
	_tmp35_ = params_it;
	vala_iterator_next (_tmp35_);
	_tmp36_ = params_it;
	_tmp37_ = vala_iterator_get (_tmp36_);
	param = (ValaParameter*) _tmp37_;
	_tmp38_ = param;
	_tmp39_ = vala_parameter_get_direction (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp41_ = param;
	_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (!VALA_IS_ARRAY_TYPE (_tmp43_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp44_ = param;
	_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp47_;
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_data_type (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint result = 0;
	gint n = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaParameter* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gint _tmp14_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp8_ = param;
			_tmp9_ = vala_variable_get_initializer ((ValaVariable*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaParameter* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp14_ = n;
			n = _tmp14_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp31_;
	ValaMethod* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp30_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaMethod* _tmp18_;
				ValaParameter* _tmp19_;
				ValaParameter* _tmp20_;
				ValaParameter* _tmp21_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp16_ = _param_list;
				_tmp17_ = vala_list_get (_tmp16_, _param_index);
				param = (ValaParameter*) _tmp17_;
				_tmp18_ = self->priv->end_method;
				_tmp19_ = param;
				_tmp20_ = vala_parameter_copy (_tmp19_);
				_tmp21_ = _tmp20_;
				vala_callable_add_parameter ((ValaCallable*) _tmp18_, _tmp21_);
				_vala_code_node_unref0 (_tmp21_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp22_;
			gint _param_size = 0;
			ValaList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _param_index = 0;
			_tmp22_ = vala_method_get_type_parameters (self);
			_param_list = _tmp22_;
			_tmp23_ = _param_list;
			_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_param_size = _tmp25_;
			_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* param = NULL;
				ValaList* _tmp26_;
				gpointer _tmp27_;
				ValaMethod* _tmp28_;
				ValaTypeParameter* _tmp29_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp26_ = _param_list;
				_tmp27_ = vala_list_get (_tmp26_, _param_index);
				param = (ValaTypeParameter*) _tmp27_;
				_tmp28_ = self->priv->end_method;
				_tmp29_ = param;
				vala_method_add_type_parameter (_tmp28_, _tmp29_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp30_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp30_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp31_ = self->priv->end_method;
	_tmp32_ = _vala_code_node_ref0 (_tmp31_);
	result = _tmp32_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaDelegate* _tmp32_;
	ValaDelegateType* _tmp33_;
	ValaDelegateType* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameter* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaNullLiteral* _tmp43_;
	ValaNullLiteral* _tmp44_;
	ValaParameter* _tmp45_;
	ValaExpression* _tmp46_;
	ValaExpression* _tmp47_;
	ValaDelegateType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaParameter* _tmp51_;
	ValaParameter* _tmp52_;
	ValaArrayList* _tmp53_;
	ValaParameter* _tmp54_;
	ValaParameter* _tmp55_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaParameter* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp16_ = _param_list;
			_tmp17_ = vala_list_get (_tmp16_, _param_index);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_ellipsis (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				_tmp21_ = param;
				_tmp22_ = _vala_code_node_ref0 (_tmp21_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp22_;
			} else {
				ValaParameter* _tmp23_;
				ValaParameterDirection _tmp24_;
				ValaParameterDirection _tmp25_;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_get_direction (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp26_;
					ValaParameter* _tmp27_;
					_tmp26_ = params;
					_tmp27_ = param;
					vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "AsyncReadyCallback");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp33_ = vala_delegate_type_new (_tmp32_);
	_tmp34_ = _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	callback_type = _tmp34_;
	_tmp35_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp35_, TRUE);
	_tmp36_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp36_, TRUE);
	_tmp37_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp37_, TRUE);
	_tmp38_ = callback_type;
	_tmp39_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp38_, NULL);
	callback_param = _tmp39_;
	_tmp40_ = callback_param;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_null_literal_new (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_variable_set_initializer ((ValaVariable*) _tmp40_, (ValaExpression*) _tmp44_);
	_vala_code_node_unref0 (_tmp44_);
	_tmp45_ = callback_param;
	_tmp46_ = vala_variable_get_initializer ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = callback_type;
	_tmp49_ = vala_data_type_copy ((ValaDataType*) _tmp48_);
	_tmp50_ = _tmp49_;
	vala_expression_set_target_type (_tmp47_, _tmp50_);
	_vala_code_node_unref0 (_tmp50_);
	_tmp51_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp51_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp52_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp52_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp53_ = params;
	_tmp54_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
	_tmp55_ = ellipsis;
	if (_tmp55_ != NULL) {
		ValaArrayList* _tmp56_;
		ValaParameter* _tmp57_;
		_tmp56_ = params;
		_tmp57_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameterDirection _tmp31_;
			ValaParameterDirection _tmp32_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp28_ = _param_list;
			_tmp29_ = vala_list_get (_tmp28_, _param_index);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			_tmp31_ = vala_parameter_get_direction (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp33_;
				ValaParameter* _tmp34_;
				_tmp33_ = params;
				_tmp34_ = param;
				vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				ValaLocalVariable* local = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaLocalVariable* _tmp8_;
				_local_index = _local_index + 1;
				if (!(_local_index < _local_size)) {
					break;
				}
				_tmp6_ = _local_list;
				_tmp7_ = vala_list_get (_tmp6_, _local_index);
				local = (ValaLocalVariable*) _tmp7_;
				_tmp8_ = local;
				vala_collection_add (variables, _tmp8_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	gboolean _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_closure;
	if (_tmp4_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

